// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateReplicationSetInput`](crate::input::CreateReplicationSetInput)
pub mod create_replication_set_input {
    /// A builder for [`CreateReplicationSetInput`](crate::input::CreateReplicationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::RegionMapInputValue>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The Regions that Incident Manager replicates your data to. You can have up to three Regions
        /// in your replication set.</p>
        pub fn regions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::RegionMapInputValue>,
        ) -> Self {
            let mut hash_map = self.regions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.regions = Some(hash_map);
            self
        }
        /// <p>The Regions that Incident Manager replicates your data to. You can have up to three Regions
        /// in your replication set.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::RegionMapInputValue>,
            >,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationSetInput`](crate::input::CreateReplicationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplicationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplicationSetInput {
                regions: self.regions,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplicationSetInputOperationOutputAlias = crate::operation::CreateReplicationSet;
#[doc(hidden)]
pub type CreateReplicationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReplicationSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplicationSet`](crate::operation::CreateReplicationSet)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplicationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReplicationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createReplicationSet").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReplicationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReplicationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_replication_set(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplicationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplicationSet",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReplicationSetInput`](crate::input::CreateReplicationSetInput)
    pub fn builder() -> crate::input::create_replication_set_input::Builder {
        crate::input::create_replication_set_input::Builder::default()
    }
}

/// See [`CreateResponsePlanInput`](crate::input::CreateResponsePlanInput)
pub mod create_response_plan_input {
    /// A builder for [`CreateResponsePlanInput`](crate::input::CreateResponsePlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) incident_template: std::option::Option<crate::model::IncidentTemplate>,
        pub(crate) chat_channel: std::option::Option<crate::model::ChatChannel>,
        pub(crate) engagements: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The short format name of the response plan. Can't include spaces.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The short format name of the response plan. Can't include spaces.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The long format of the response plan name. This field can contain spaces.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The long format of the response plan name. This field can contain spaces.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>Details used to create an incident when using this response plan.</p>
        pub fn incident_template(mut self, input: crate::model::IncidentTemplate) -> Self {
            self.incident_template = Some(input);
            self
        }
        /// <p>Details used to create an incident when using this response plan.</p>
        pub fn set_incident_template(
            mut self,
            input: std::option::Option<crate::model::IncidentTemplate>,
        ) -> Self {
            self.incident_template = input;
            self
        }
        /// <p>The
        /// AWS Chatbot
        /// chat channel used for collaboration during an incident.</p>
        pub fn chat_channel(mut self, input: crate::model::ChatChannel) -> Self {
            self.chat_channel = Some(input);
            self
        }
        /// <p>The
        /// AWS Chatbot
        /// chat channel used for collaboration during an incident.</p>
        pub fn set_chat_channel(
            mut self,
            input: std::option::Option<crate::model::ChatChannel>,
        ) -> Self {
            self.chat_channel = input;
            self
        }
        /// <p>The contacts and escalation plans that the response plan engages during an
        /// incident.</p>
        pub fn engagements(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.engagements = Some(input);
            self
        }
        /// <p>The contacts and escalation plans that the response plan engages during an
        /// incident.</p>
        pub fn set_engagements(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.engagements = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions that the response plan starts at the beginning of an incident.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions that the response plan starts at the beginning of an incident.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResponsePlanInput`](crate::input::CreateResponsePlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResponsePlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResponsePlanInput {
                client_token: self.client_token,
                name: self.name,
                display_name: self.display_name,
                incident_template: self.incident_template,
                chat_channel: self.chat_channel,
                engagements: self.engagements,
                actions: self.actions,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResponsePlanInputOperationOutputAlias = crate::operation::CreateResponsePlan;
#[doc(hidden)]
pub type CreateResponsePlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResponsePlanInput {
    /// Consumes the builder and constructs an Operation<[`CreateResponsePlan`](crate::operation::CreateResponsePlan)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResponsePlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResponsePlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createResponsePlan").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResponsePlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResponsePlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_response_plan(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResponsePlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResponsePlan",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResponsePlanInput`](crate::input::CreateResponsePlanInput)
    pub fn builder() -> crate::input::create_response_plan_input::Builder {
        crate::input::create_response_plan_input::Builder::default()
    }
}

/// See [`CreateTimelineEventInput`](crate::input::CreateTimelineEventInput)
pub mod create_timeline_event_input {
    /// A builder for [`CreateTimelineEventInput`](crate::input::CreateTimelineEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_type: std::option::Option<std::string::String>,
        pub(crate) event_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are adding the event
        /// to.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are adding the event
        /// to.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>The type of the event. You can create timeline events of type <code>Custom
        /// Event</code>.</p>
        pub fn event_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type = Some(input.into());
            self
        }
        /// <p>The type of the event. You can create timeline events of type <code>Custom
        /// Event</code>.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_type = input;
            self
        }
        /// <p>A valid JSON string. There is no other schema imposed. A short description of the event.</p>
        pub fn event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data = Some(input.into());
            self
        }
        /// <p>A valid JSON string. There is no other schema imposed. A short description of the event.</p>
        pub fn set_event_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_data = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTimelineEventInput`](crate::input::CreateTimelineEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTimelineEventInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTimelineEventInput {
                client_token: self.client_token,
                incident_record_arn: self.incident_record_arn,
                event_time: self.event_time,
                event_type: self.event_type,
                event_data: self.event_data,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTimelineEventInputOperationOutputAlias = crate::operation::CreateTimelineEvent;
#[doc(hidden)]
pub type CreateTimelineEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTimelineEventInput {
    /// Consumes the builder and constructs an Operation<[`CreateTimelineEvent`](crate::operation::CreateTimelineEvent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTimelineEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTimelineEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createTimelineEvent").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTimelineEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTimelineEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_timeline_event(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTimelineEvent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTimelineEvent",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTimelineEventInput`](crate::input::CreateTimelineEventInput)
    pub fn builder() -> crate::input::create_timeline_event_input::Builder {
        crate::input::create_timeline_event_input::Builder::default()
    }
}

/// See [`DeleteIncidentRecordInput`](crate::input::DeleteIncidentRecordInput)
pub mod delete_incident_record_input {
    /// A builder for [`DeleteIncidentRecordInput`](crate::input::DeleteIncidentRecordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident record you are deleting.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are deleting.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIncidentRecordInput`](crate::input::DeleteIncidentRecordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIncidentRecordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIncidentRecordInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteIncidentRecordInputOperationOutputAlias = crate::operation::DeleteIncidentRecord;
#[doc(hidden)]
pub type DeleteIncidentRecordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIncidentRecordInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIncidentRecord`](crate::operation::DeleteIncidentRecord)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIncidentRecord,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIncidentRecordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteIncidentRecord").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIncidentRecordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIncidentRecordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_incident_record(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIncidentRecord::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIncidentRecord",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIncidentRecordInput`](crate::input::DeleteIncidentRecordInput)
    pub fn builder() -> crate::input::delete_incident_record_input::Builder {
        crate::input::delete_incident_record_input::Builder::default()
    }
}

/// See [`DeleteReplicationSetInput`](crate::input::DeleteReplicationSetInput)
pub mod delete_replication_set_input {
    /// A builder for [`DeleteReplicationSetInput`](crate::input::DeleteReplicationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication set you're deleting.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're deleting.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationSetInput`](crate::input::DeleteReplicationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationSetInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationSetInputOperationOutputAlias = crate::operation::DeleteReplicationSet;
#[doc(hidden)]
pub type DeleteReplicationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReplicationSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationSet`](crate::operation::DeleteReplicationSet)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteReplicationSet").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeleteReplicationSetInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_1) = &_input.arn {
                query.push_kv("arn", &aws_smithy_http::query::fmt_string(&inner_1));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationSet",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationSetInput`](crate::input::DeleteReplicationSetInput)
    pub fn builder() -> crate::input::delete_replication_set_input::Builder {
        crate::input::delete_replication_set_input::Builder::default()
    }
}

/// See [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
pub mod delete_resource_policy_input {
    /// A builder for [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource you're deleting the policy from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource you're deleting the policy from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The ID of the resource policy you're deleting.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource policy you're deleting.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourcePolicyInput {
                resource_arn: self.resource_arn,
                policy_id: self.policy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationOutputAlias = crate::operation::DeleteResourcePolicy;
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourcePolicy`](crate::operation::DeleteResourcePolicy)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourcePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteResourcePolicy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_resource_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourcePolicy",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
}

/// See [`DeleteResponsePlanInput`](crate::input::DeleteResponsePlanInput)
pub mod delete_response_plan_input {
    /// A builder for [`DeleteResponsePlanInput`](crate::input::DeleteResponsePlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResponsePlanInput`](crate::input::DeleteResponsePlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResponsePlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResponsePlanInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteResponsePlanInputOperationOutputAlias = crate::operation::DeleteResponsePlan;
#[doc(hidden)]
pub type DeleteResponsePlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResponsePlanInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResponsePlan`](crate::operation::DeleteResponsePlan)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResponsePlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResponsePlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteResponsePlan").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResponsePlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResponsePlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_response_plan(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResponsePlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResponsePlan",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResponsePlanInput`](crate::input::DeleteResponsePlanInput)
    pub fn builder() -> crate::input::delete_response_plan_input::Builder {
        crate::input::delete_response_plan_input::Builder::default()
    }
}

/// See [`DeleteTimelineEventInput`](crate::input::DeleteTimelineEventInput)
pub mod delete_timeline_event_input {
    /// A builder for [`DeleteTimelineEventInput`](crate::input::DeleteTimelineEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident that the event is part of.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that the event is part of.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTimelineEventInput`](crate::input::DeleteTimelineEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTimelineEventInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTimelineEventInput {
                incident_record_arn: self.incident_record_arn,
                event_id: self.event_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTimelineEventInputOperationOutputAlias = crate::operation::DeleteTimelineEvent;
#[doc(hidden)]
pub type DeleteTimelineEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTimelineEventInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTimelineEvent`](crate::operation::DeleteTimelineEvent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTimelineEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTimelineEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/deleteTimelineEvent").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTimelineEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTimelineEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_timeline_event(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTimelineEvent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTimelineEvent",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTimelineEventInput`](crate::input::DeleteTimelineEventInput)
    pub fn builder() -> crate::input::delete_timeline_event_input::Builder {
        crate::input::delete_timeline_event_input::Builder::default()
    }
}

/// See [`GetIncidentRecordInput`](crate::input::GetIncidentRecordInput)
pub mod get_incident_record_input {
    /// A builder for [`GetIncidentRecordInput`](crate::input::GetIncidentRecordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIncidentRecordInput`](crate::input::GetIncidentRecordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIncidentRecordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIncidentRecordInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetIncidentRecordInputOperationOutputAlias = crate::operation::GetIncidentRecord;
#[doc(hidden)]
pub type GetIncidentRecordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIncidentRecordInput {
    /// Consumes the builder and constructs an Operation<[`GetIncidentRecord`](crate::operation::GetIncidentRecord)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIncidentRecord,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIncidentRecordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getIncidentRecord").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetIncidentRecordInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_2) = &_input.arn {
                query.push_kv("arn", &aws_smithy_http::query::fmt_string(&inner_2));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIncidentRecordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIncidentRecordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIncidentRecord::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIncidentRecord",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIncidentRecordInput`](crate::input::GetIncidentRecordInput)
    pub fn builder() -> crate::input::get_incident_record_input::Builder {
        crate::input::get_incident_record_input::Builder::default()
    }
}

/// See [`GetReplicationSetInput`](crate::input::GetReplicationSetInput)
pub mod get_replication_set_input {
    /// A builder for [`GetReplicationSetInput`](crate::input::GetReplicationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication set you want to retrieve.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you want to retrieve.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReplicationSetInput`](crate::input::GetReplicationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReplicationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReplicationSetInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetReplicationSetInputOperationOutputAlias = crate::operation::GetReplicationSet;
#[doc(hidden)]
pub type GetReplicationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetReplicationSetInput {
    /// Consumes the builder and constructs an Operation<[`GetReplicationSet`](crate::operation::GetReplicationSet)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReplicationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReplicationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getReplicationSet").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetReplicationSetInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.arn {
                query.push_kv("arn", &aws_smithy_http::query::fmt_string(&inner_3));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReplicationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReplicationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReplicationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReplicationSet",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReplicationSetInput`](crate::input::GetReplicationSetInput)
    pub fn builder() -> crate::input::get_replication_set_input::Builder {
        crate::input::get_replication_set_input::Builder::default()
    }
}

/// See [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
pub mod get_resource_policies_input {
    /// A builder for [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan with the attached resource policy. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan with the attached resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The maximum number of resource policies to display per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of resource policies to display per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourcePoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourcePoliciesInput {
                resource_arn: self.resource_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourcePoliciesInputOperationOutputAlias = crate::operation::GetResourcePolicies;
#[doc(hidden)]
pub type GetResourcePoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourcePoliciesInput {
    /// Consumes the builder and constructs an Operation<[`GetResourcePolicies`](crate::operation::GetResourcePolicies)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourcePolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourcePoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getResourcePolicies").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetResourcePoliciesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.resource_arn {
                query.push_kv("resourceArn", &aws_smithy_http::query::fmt_string(&inner_4));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourcePoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourcePoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resource_policies(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourcePolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourcePolicies",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
    pub fn builder() -> crate::input::get_resource_policies_input::Builder {
        crate::input::get_resource_policies_input::Builder::default()
    }
}

/// See [`GetResponsePlanInput`](crate::input::GetResponsePlanInput)
pub mod get_response_plan_input {
    /// A builder for [`GetResponsePlanInput`](crate::input::GetResponsePlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResponsePlanInput`](crate::input::GetResponsePlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResponsePlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResponsePlanInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetResponsePlanInputOperationOutputAlias = crate::operation::GetResponsePlan;
#[doc(hidden)]
pub type GetResponsePlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResponsePlanInput {
    /// Consumes the builder and constructs an Operation<[`GetResponsePlan`](crate::operation::GetResponsePlan)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResponsePlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResponsePlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getResponsePlan").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetResponsePlanInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.arn {
                query.push_kv("arn", &aws_smithy_http::query::fmt_string(&inner_5));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResponsePlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResponsePlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResponsePlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResponsePlan",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResponsePlanInput`](crate::input::GetResponsePlanInput)
    pub fn builder() -> crate::input::get_response_plan_input::Builder {
        crate::input::get_response_plan_input::Builder::default()
    }
}

/// See [`GetTimelineEventInput`](crate::input::GetTimelineEventInput)
pub mod get_timeline_event_input {
    /// A builder for [`GetTimelineEventInput`](crate::input::GetTimelineEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident that the timeline event is part of.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that the timeline event is part of.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>The ID of the event. You can get an event's ID when you create it or by using <code>ListTimelineEvents</code>.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event. You can get an event's ID when you create it or by using <code>ListTimelineEvents</code>.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTimelineEventInput`](crate::input::GetTimelineEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTimelineEventInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTimelineEventInput {
                incident_record_arn: self.incident_record_arn,
                event_id: self.event_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTimelineEventInputOperationOutputAlias = crate::operation::GetTimelineEvent;
#[doc(hidden)]
pub type GetTimelineEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTimelineEventInput {
    /// Consumes the builder and constructs an Operation<[`GetTimelineEvent`](crate::operation::GetTimelineEvent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTimelineEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTimelineEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/getTimelineEvent").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetTimelineEventInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.incident_record_arn {
                query.push_kv(
                    "incidentRecordArn",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
            if let Some(inner_7) = &_input.event_id {
                query.push_kv("eventId", &aws_smithy_http::query::fmt_string(&inner_7));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTimelineEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTimelineEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTimelineEvent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTimelineEvent",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTimelineEventInput`](crate::input::GetTimelineEventInput)
    pub fn builder() -> crate::input::get_timeline_event_input::Builder {
        crate::input::get_timeline_event_input::Builder::default()
    }
}

/// See [`ListIncidentRecordsInput`](crate::input::ListIncidentRecordsInput)
pub mod list_incident_records_input {
    /// A builder for [`ListIncidentRecordsInput`](crate::input::ListIncidentRecordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filter the list of incident records you are searching through. You can filter on the
        /// following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>creationTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>impact</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>createdBy</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filter the list of incident records you are searching through. You can filter on the
        /// following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>creationTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>impact</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>createdBy</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIncidentRecordsInput`](crate::input::ListIncidentRecordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIncidentRecordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIncidentRecordsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIncidentRecordsInputOperationOutputAlias = crate::operation::ListIncidentRecords;
#[doc(hidden)]
pub type ListIncidentRecordsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListIncidentRecordsInput {
    /// Consumes the builder and constructs an Operation<[`ListIncidentRecords`](crate::operation::ListIncidentRecords)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIncidentRecords,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIncidentRecordsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listIncidentRecords").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIncidentRecordsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIncidentRecordsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_incident_records(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIncidentRecords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIncidentRecords",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIncidentRecordsInput`](crate::input::ListIncidentRecordsInput)
    pub fn builder() -> crate::input::list_incident_records_input::Builder {
        crate::input::list_incident_records_input::Builder::default()
    }
}

/// See [`ListRelatedItemsInput`](crate::input::ListRelatedItemsInput)
pub mod list_related_items_input {
    /// A builder for [`ListRelatedItemsInput`](crate::input::ListRelatedItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident record that you are listing related items for.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record that you are listing related items for.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>The maximum number of related items per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of related items per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRelatedItemsInput`](crate::input::ListRelatedItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRelatedItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRelatedItemsInput {
                incident_record_arn: self.incident_record_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRelatedItemsInputOperationOutputAlias = crate::operation::ListRelatedItems;
#[doc(hidden)]
pub type ListRelatedItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRelatedItemsInput {
    /// Consumes the builder and constructs an Operation<[`ListRelatedItems`](crate::operation::ListRelatedItems)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRelatedItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRelatedItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listRelatedItems").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRelatedItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRelatedItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_related_items(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRelatedItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRelatedItems",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRelatedItemsInput`](crate::input::ListRelatedItemsInput)
    pub fn builder() -> crate::input::list_related_items_input::Builder {
        crate::input::list_related_items_input::Builder::default()
    }
}

/// See [`ListReplicationSetsInput`](crate::input::ListReplicationSetsInput)
pub mod list_replication_sets_input {
    /// A builder for [`ListReplicationSetsInput`](crate::input::ListReplicationSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results per page. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReplicationSetsInput`](crate::input::ListReplicationSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReplicationSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReplicationSetsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReplicationSetsInputOperationOutputAlias = crate::operation::ListReplicationSets;
#[doc(hidden)]
pub type ListReplicationSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReplicationSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListReplicationSets`](crate::operation::ListReplicationSets)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReplicationSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReplicationSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listReplicationSets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReplicationSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReplicationSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_replication_sets(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReplicationSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReplicationSets",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReplicationSetsInput`](crate::input::ListReplicationSetsInput)
    pub fn builder() -> crate::input::list_replication_sets_input::Builder {
        crate::input::list_replication_sets_input::Builder::default()
    }
}

/// See [`ListResponsePlansInput`](crate::input::ListResponsePlansInput)
pub mod list_response_plans_input {
    /// A builder for [`ListResponsePlansInput`](crate::input::ListResponsePlansInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of response plans per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of response plans per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResponsePlansInput`](crate::input::ListResponsePlansInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResponsePlansInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResponsePlansInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResponsePlansInputOperationOutputAlias = crate::operation::ListResponsePlans;
#[doc(hidden)]
pub type ListResponsePlansInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResponsePlansInput {
    /// Consumes the builder and constructs an Operation<[`ListResponsePlans`](crate::operation::ListResponsePlans)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResponsePlans,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResponsePlansInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listResponsePlans").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResponsePlansInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResponsePlansInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_response_plans(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResponsePlans::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResponsePlans",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResponsePlansInput`](crate::input::ListResponsePlansInput)
    pub fn builder() -> crate::input::list_response_plans_input::Builder {
        crate::input::list_response_plans_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.resource_arn;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_8, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTimelineEventsInput`](crate::input::ListTimelineEventsInput)
pub mod list_timeline_events_input {
    /// A builder for [`ListTimelineEventsInput`](crate::input::ListTimelineEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_by: std::option::Option<crate::model::TimelineEventSort>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the incident that the event is part of.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that the event is part of.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters the timeline events based on the provided conditional values. You can filter
        /// timeline events using the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>eventTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>eventType</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters the timeline events based on the provided conditional values. You can filter
        /// timeline events using the following keys:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>eventTime</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>eventType</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Sort by the specified key value pair.</p>
        pub fn sort_by(mut self, input: crate::model::TimelineEventSort) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Sort by the specified key value pair.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::TimelineEventSort>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>Sorts the order of timeline events by the value specified in the <code>sortBy</code>
        /// field.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>Sorts the order of timeline events by the value specified in the <code>sortBy</code>
        /// field.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTimelineEventsInput`](crate::input::ListTimelineEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTimelineEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTimelineEventsInput {
                incident_record_arn: self.incident_record_arn,
                filters: self.filters,
                sort_by: self.sort_by,
                sort_order: self.sort_order,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTimelineEventsInputOperationOutputAlias = crate::operation::ListTimelineEvents;
#[doc(hidden)]
pub type ListTimelineEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTimelineEventsInput {
    /// Consumes the builder and constructs an Operation<[`ListTimelineEvents`](crate::operation::ListTimelineEvents)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTimelineEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTimelineEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/listTimelineEvents").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTimelineEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTimelineEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_timeline_events(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTimelineEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTimelineEvents",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTimelineEventsInput`](crate::input::ListTimelineEventsInput)
    pub fn builder() -> crate::input::list_timeline_events_input::Builder {
        crate::input::list_timeline_events_input::Builder::default()
    }
}

/// See [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
pub mod put_resource_policy_input {
    /// A builder for [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the resource policy
        /// to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the resource policy
        /// to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResourcePolicyInput {
                resource_arn: self.resource_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutResourcePolicyInputOperationOutputAlias = crate::operation::PutResourcePolicy;
#[doc(hidden)]
pub type PutResourcePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutResourcePolicy`](crate::operation::PutResourcePolicy)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResourcePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/putResourcePolicy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_resource_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResourcePolicy",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
}

/// See [`StartIncidentInput`](crate::input::StartIncidentInput)
pub mod start_incident_input {
    /// A builder for [`StartIncidentInput`](crate::input::StartIncidentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) response_plan_arn: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) impact: std::option::Option<i32>,
        pub(crate) trigger_details: std::option::Option<crate::model::TriggerDetails>,
        pub(crate) related_items: std::option::Option<std::vec::Vec<crate::model::RelatedItem>>,
    }
    impl Builder {
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat
        /// channels, SNS topics, runbooks, title, and impact of the incident. </p>
        pub fn response_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_plan_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat
        /// channels, SNS topics, runbooks, title, and impact of the incident. </p>
        pub fn set_response_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_plan_arn = input;
            self
        }
        /// <p>Provide a title for the incident. Providing a title overwrites the title provided by
        /// the response plan. </p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>Provide a title for the incident. Providing a title overwrites the title provided by
        /// the response plan. </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, this typically relates to full application
        /// failure that impacts many to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> -  Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn impact(mut self, input: i32) -> Self {
            self.impact = Some(input);
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, this typically relates to full application
        /// failure that impacts many to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> -  Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn set_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.impact = input;
            self
        }
        /// <p>Details of what created the incident record in Incident Manager.</p>
        pub fn trigger_details(mut self, input: crate::model::TriggerDetails) -> Self {
            self.trigger_details = Some(input);
            self
        }
        /// <p>Details of what created the incident record in Incident Manager.</p>
        pub fn set_trigger_details(
            mut self,
            input: std::option::Option<crate::model::TriggerDetails>,
        ) -> Self {
            self.trigger_details = input;
            self
        }
        /// Appends an item to `related_items`.
        ///
        /// To override the contents of this collection use [`set_related_items`](Self::set_related_items).
        ///
        /// <p>Add related items to the incident for other responders to use. Related items are AWS
        /// resources, external links, or files uploaded to an S3 bucket. </p>
        pub fn related_items(mut self, input: impl Into<crate::model::RelatedItem>) -> Self {
            let mut v = self.related_items.unwrap_or_default();
            v.push(input.into());
            self.related_items = Some(v);
            self
        }
        /// <p>Add related items to the incident for other responders to use. Related items are AWS
        /// resources, external links, or files uploaded to an S3 bucket. </p>
        pub fn set_related_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedItem>>,
        ) -> Self {
            self.related_items = input;
            self
        }
        /// Consumes the builder and constructs a [`StartIncidentInput`](crate::input::StartIncidentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartIncidentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartIncidentInput {
                client_token: self.client_token,
                response_plan_arn: self.response_plan_arn,
                title: self.title,
                impact: self.impact,
                trigger_details: self.trigger_details,
                related_items: self.related_items,
            })
        }
    }
}
#[doc(hidden)]
pub type StartIncidentInputOperationOutputAlias = crate::operation::StartIncident;
#[doc(hidden)]
pub type StartIncidentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartIncidentInput {
    /// Consumes the builder and constructs an Operation<[`StartIncident`](crate::operation::StartIncident)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartIncident,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartIncidentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/startIncident").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartIncidentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartIncidentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_incident(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartIncident::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartIncident",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartIncidentInput`](crate::input::StartIncidentInput)
    pub fn builder() -> crate::input::start_incident_input::Builder {
        crate::input::start_incident_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags that you are adding to the response plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.resource_arn;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_9, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the response plan you're removing a tag from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan you're removing a tag from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The name of the tag you're removing from the response plan.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The name of the tag you're removing from the response plan.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.resource_arn;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_10, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.tag_keys {
                for inner_12 in inner_11 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_12));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDeletionProtectionInput`](crate::input::UpdateDeletionProtectionInput)
pub mod update_deletion_protection_input {
    /// A builder for [`UpdateDeletionProtectionInput`](crate::input::UpdateDeletionProtectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) deletion_protected: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Details if deletion protection is enabled or disabled in your account.</p>
        pub fn deletion_protected(mut self, input: bool) -> Self {
            self.deletion_protected = Some(input);
            self
        }
        /// <p>Details if deletion protection is enabled or disabled in your account.</p>
        pub fn set_deletion_protected(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protected = input;
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeletionProtectionInput`](crate::input::UpdateDeletionProtectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeletionProtectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeletionProtectionInput {
                arn: self.arn,
                deletion_protected: self.deletion_protected,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeletionProtectionInputOperationOutputAlias =
    crate::operation::UpdateDeletionProtection;
#[doc(hidden)]
pub type UpdateDeletionProtectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDeletionProtectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeletionProtection`](crate::operation::UpdateDeletionProtection)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeletionProtection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeletionProtectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateDeletionProtection").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeletionProtectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeletionProtectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_deletion_protection(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeletionProtection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeletionProtection",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeletionProtectionInput`](crate::input::UpdateDeletionProtectionInput)
    pub fn builder() -> crate::input::update_deletion_protection_input::Builder {
        crate::input::update_deletion_protection_input::Builder::default()
    }
}

/// See [`UpdateIncidentRecordInput`](crate::input::UpdateIncidentRecordInput)
pub mod update_incident_record_input {
    /// A builder for [`UpdateIncidentRecordInput`](crate::input::UpdateIncidentRecordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) impact: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::IncidentRecordStatus>,
        pub(crate) chat_channel: std::option::Option<crate::model::ChatChannel>,
        pub(crate) notification_targets:
            std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
    }
    impl Builder {
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are updating.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are updating.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The title of the incident is a brief and easily recognizable.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the incident is a brief and easily recognizable.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The summary describes what has happened during the incident.</p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>The summary describes what has happened during the incident.</p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>Defines the impact to customers and applications. Providing an impact overwrites the
        /// impact provided by the response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, this typically relates to full application
        /// failure that impacts many to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> -  Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn impact(mut self, input: i32) -> Self {
            self.impact = Some(input);
            self
        }
        /// <p>Defines the impact to customers and applications. Providing an impact overwrites the
        /// impact provided by the response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>1</code> - Critical impact, this typically relates to full application
        /// failure that impacts many to all customers. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - High impact, partial application failure with impact to many
        /// customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> -  Medium impact, the application is providing reduced service
        /// to customers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
        /// yet.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>5</code> - No impact, customers aren't currently impacted but urgent
        /// action is needed to avoid impact.</p>
        /// </li>
        /// </ul>
        pub fn set_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.impact = input;
            self
        }
        /// <p>The status of the incident. An incident can be <code>Open</code> or <code>Resolved</code>.</p>
        pub fn status(mut self, input: crate::model::IncidentRecordStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the incident. An incident can be <code>Open</code> or <code>Resolved</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IncidentRecordStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The AWS Chatbot chat channel for responders to collaborate in.</p>
        pub fn chat_channel(mut self, input: crate::model::ChatChannel) -> Self {
            self.chat_channel = Some(input);
            self
        }
        /// <p>The AWS Chatbot chat channel for responders to collaborate in.</p>
        pub fn set_chat_channel(
            mut self,
            input: std::option::Option<crate::model::ChatChannel>,
        ) -> Self {
            self.chat_channel = input;
            self
        }
        /// Appends an item to `notification_targets`.
        ///
        /// To override the contents of this collection use [`set_notification_targets`](Self::set_notification_targets).
        ///
        /// <p>The SNS targets that are notified when updates are made to an incident.</p>
        /// <p>Using multiple SNS topics creates redundancy in the case that a Region is down during
        /// the incident.</p>
        pub fn notification_targets(
            mut self,
            input: impl Into<crate::model::NotificationTargetItem>,
        ) -> Self {
            let mut v = self.notification_targets.unwrap_or_default();
            v.push(input.into());
            self.notification_targets = Some(v);
            self
        }
        /// <p>The SNS targets that are notified when updates are made to an incident.</p>
        /// <p>Using multiple SNS topics creates redundancy in the case that a Region is down during
        /// the incident.</p>
        pub fn set_notification_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
        ) -> Self {
            self.notification_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIncidentRecordInput`](crate::input::UpdateIncidentRecordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIncidentRecordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIncidentRecordInput {
                client_token: self.client_token,
                arn: self.arn,
                title: self.title,
                summary: self.summary,
                impact: self.impact,
                status: self.status,
                chat_channel: self.chat_channel,
                notification_targets: self.notification_targets,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIncidentRecordInputOperationOutputAlias = crate::operation::UpdateIncidentRecord;
#[doc(hidden)]
pub type UpdateIncidentRecordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateIncidentRecordInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIncidentRecord`](crate::operation::UpdateIncidentRecord)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIncidentRecord,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateIncidentRecordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateIncidentRecord").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateIncidentRecordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateIncidentRecordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_incident_record(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIncidentRecord::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIncidentRecord",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateIncidentRecordInput`](crate::input::UpdateIncidentRecordInput)
    pub fn builder() -> crate::input::update_incident_record_input::Builder {
        crate::input::update_incident_record_input::Builder::default()
    }
}

/// See [`UpdateRelatedItemsInput`](crate::input::UpdateRelatedItemsInput)
pub mod update_related_items_input {
    /// A builder for [`UpdateRelatedItemsInput`](crate::input::UpdateRelatedItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) related_items_update: std::option::Option<crate::model::RelatedItemsUpdate>,
    }
    impl Builder {
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are updating related items
        /// in.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident record you are updating related items
        /// in.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>Details about the item you are adding or deleting.</p>
        pub fn related_items_update(mut self, input: crate::model::RelatedItemsUpdate) -> Self {
            self.related_items_update = Some(input);
            self
        }
        /// <p>Details about the item you are adding or deleting.</p>
        pub fn set_related_items_update(
            mut self,
            input: std::option::Option<crate::model::RelatedItemsUpdate>,
        ) -> Self {
            self.related_items_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRelatedItemsInput`](crate::input::UpdateRelatedItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRelatedItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRelatedItemsInput {
                client_token: self.client_token,
                incident_record_arn: self.incident_record_arn,
                related_items_update: self.related_items_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRelatedItemsInputOperationOutputAlias = crate::operation::UpdateRelatedItems;
#[doc(hidden)]
pub type UpdateRelatedItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRelatedItemsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRelatedItems`](crate::operation::UpdateRelatedItems)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRelatedItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRelatedItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateRelatedItems").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRelatedItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRelatedItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_related_items(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRelatedItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRelatedItems",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRelatedItemsInput`](crate::input::UpdateRelatedItemsInput)
    pub fn builder() -> crate::input::update_related_items_input::Builder {
        crate::input::update_related_items_input::Builder::default()
    }
}

/// See [`UpdateReplicationSetInput`](crate::input::UpdateReplicationSetInput)
pub mod update_replication_set_input {
    /// A builder for [`UpdateReplicationSetInput`](crate::input::UpdateReplicationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) actions:
            std::option::Option<std::vec::Vec<crate::model::UpdateReplicationSetAction>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>An action to add or delete a Region.</p>
        pub fn actions(
            mut self,
            input: impl Into<crate::model::UpdateReplicationSetAction>,
        ) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>An action to add or delete a Region.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateReplicationSetAction>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationSetInput`](crate::input::UpdateReplicationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReplicationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReplicationSetInput {
                arn: self.arn,
                actions: self.actions,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReplicationSetInputOperationOutputAlias = crate::operation::UpdateReplicationSet;
#[doc(hidden)]
pub type UpdateReplicationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateReplicationSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReplicationSet`](crate::operation::UpdateReplicationSet)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReplicationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReplicationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateReplicationSet").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReplicationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReplicationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_replication_set(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReplicationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReplicationSet",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReplicationSetInput`](crate::input::UpdateReplicationSetInput)
    pub fn builder() -> crate::input::update_replication_set_input::Builder {
        crate::input::update_replication_set_input::Builder::default()
    }
}

/// See [`UpdateResponsePlanInput`](crate::input::UpdateResponsePlanInput)
pub mod update_response_plan_input {
    /// A builder for [`UpdateResponsePlanInput`](crate::input::UpdateResponsePlanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) incident_template_title: std::option::Option<std::string::String>,
        pub(crate) incident_template_impact: std::option::Option<i32>,
        pub(crate) incident_template_summary: std::option::Option<std::string::String>,
        pub(crate) incident_template_dedupe_string: std::option::Option<std::string::String>,
        pub(crate) incident_template_notification_targets:
            std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
        pub(crate) chat_channel: std::option::Option<crate::model::ChatChannel>,
        pub(crate) engagements: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    }
    impl Builder {
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The long format name of the response plan. Can't contain spaces.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The long format name of the response plan. Can't contain spaces.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The short format name of the incident. Can't contain spaces.</p>
        pub fn incident_template_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_template_title = Some(input.into());
            self
        }
        /// <p>The short format name of the incident. Can't contain spaces.</p>
        pub fn set_incident_template_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_template_title = input;
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>5</code> - Severe impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> - High impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> - Medium impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - Low impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>1</code> - No impact</p>
        /// </li>
        /// </ul>
        pub fn incident_template_impact(mut self, input: i32) -> Self {
            self.incident_template_impact = Some(input);
            self
        }
        /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
        /// provided by a response plan.</p>
        /// <p class="title">
        /// <b>Possible impacts:</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>5</code> - Severe impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>4</code> - High impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>3</code> - Medium impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>2</code> - Low impact</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>1</code> - No impact</p>
        /// </li>
        /// </ul>
        pub fn set_incident_template_impact(mut self, input: std::option::Option<i32>) -> Self {
            self.incident_template_impact = input;
            self
        }
        /// <p>A brief summary of the incident. This typically contains what has happened, what's
        /// currently happening, and next steps.</p>
        pub fn incident_template_summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_template_summary = Some(input.into());
            self
        }
        /// <p>A brief summary of the incident. This typically contains what has happened, what's
        /// currently happening, and next steps.</p>
        pub fn set_incident_template_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_template_summary = input;
            self
        }
        /// <p>Used to create only one incident record for an incident.</p>
        pub fn incident_template_dedupe_string(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.incident_template_dedupe_string = Some(input.into());
            self
        }
        /// <p>Used to create only one incident record for an incident.</p>
        pub fn set_incident_template_dedupe_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_template_dedupe_string = input;
            self
        }
        /// Appends an item to `incident_template_notification_targets`.
        ///
        /// To override the contents of this collection use [`set_incident_template_notification_targets`](Self::set_incident_template_notification_targets).
        ///
        /// <p>The SNS targets that are notified when updates are made to an incident.</p>
        pub fn incident_template_notification_targets(
            mut self,
            input: impl Into<crate::model::NotificationTargetItem>,
        ) -> Self {
            let mut v = self
                .incident_template_notification_targets
                .unwrap_or_default();
            v.push(input.into());
            self.incident_template_notification_targets = Some(v);
            self
        }
        /// <p>The SNS targets that are notified when updates are made to an incident.</p>
        pub fn set_incident_template_notification_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
        ) -> Self {
            self.incident_template_notification_targets = input;
            self
        }
        /// <p>The
        /// AWS
        /// Chatbot chat channel used for collaboration during an
        /// incident.</p>
        /// <p>Use the empty structure to remove the chat channel from the response plan.</p>
        pub fn chat_channel(mut self, input: crate::model::ChatChannel) -> Self {
            self.chat_channel = Some(input);
            self
        }
        /// <p>The
        /// AWS
        /// Chatbot chat channel used for collaboration during an
        /// incident.</p>
        /// <p>Use the empty structure to remove the chat channel from the response plan.</p>
        pub fn set_chat_channel(
            mut self,
            input: std::option::Option<crate::model::ChatChannel>,
        ) -> Self {
            self.chat_channel = input;
            self
        }
        /// <p>The contacts and escalation plans that Incident Manager engages at the start of the incident.</p>
        pub fn engagements(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.engagements = Some(input);
            self
        }
        /// <p>The contacts and escalation plans that Incident Manager engages at the start of the incident.</p>
        pub fn set_engagements(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.engagements = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions that this response plan takes at the beginning of an incident.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions that this response plan takes at the beginning of an incident.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResponsePlanInput`](crate::input::UpdateResponsePlanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResponsePlanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResponsePlanInput {
                client_token: self.client_token,
                arn: self.arn,
                display_name: self.display_name,
                incident_template_title: self.incident_template_title,
                incident_template_impact: self.incident_template_impact,
                incident_template_summary: self.incident_template_summary,
                incident_template_dedupe_string: self.incident_template_dedupe_string,
                incident_template_notification_targets: self.incident_template_notification_targets,
                chat_channel: self.chat_channel,
                engagements: self.engagements,
                actions: self.actions,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResponsePlanInputOperationOutputAlias = crate::operation::UpdateResponsePlan;
#[doc(hidden)]
pub type UpdateResponsePlanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResponsePlanInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResponsePlan`](crate::operation::UpdateResponsePlan)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResponsePlan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResponsePlanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateResponsePlan").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResponsePlanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResponsePlanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_response_plan(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResponsePlan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResponsePlan",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResponsePlanInput`](crate::input::UpdateResponsePlanInput)
    pub fn builder() -> crate::input::update_response_plan_input::Builder {
        crate::input::update_response_plan_input::Builder::default()
    }
}

/// See [`UpdateTimelineEventInput`](crate::input::UpdateTimelineEventInput)
pub mod update_timeline_event_input {
    /// A builder for [`UpdateTimelineEventInput`](crate::input::UpdateTimelineEventInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) incident_record_arn: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_type: std::option::Option<std::string::String>,
        pub(crate) event_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that the timeline event is part
        /// of.</p>
        pub fn incident_record_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_record_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident that the timeline event is part
        /// of.</p>
        pub fn set_incident_record_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.incident_record_arn = input;
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p>The time that the event occurred.</p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p>The type of the event. You can update events of type <code>Custom Event</code>.</p>
        pub fn event_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type = Some(input.into());
            self
        }
        /// <p>The type of the event. You can update events of type <code>Custom Event</code>.</p>
        pub fn set_event_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_type = input;
            self
        }
        /// <p>A short description of the event.</p>
        pub fn event_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_data = Some(input.into());
            self
        }
        /// <p>A short description of the event.</p>
        pub fn set_event_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_data = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTimelineEventInput`](crate::input::UpdateTimelineEventInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTimelineEventInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTimelineEventInput {
                client_token: self.client_token,
                incident_record_arn: self.incident_record_arn,
                event_id: self.event_id,
                event_time: self.event_time,
                event_type: self.event_type,
                event_data: self.event_data,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTimelineEventInputOperationOutputAlias = crate::operation::UpdateTimelineEvent;
#[doc(hidden)]
pub type UpdateTimelineEventInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTimelineEventInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTimelineEvent`](crate::operation::UpdateTimelineEvent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTimelineEvent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTimelineEventInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/updateTimelineEvent").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTimelineEventInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTimelineEventInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_timeline_event(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTimelineEvent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTimelineEvent",
            "ssmincidents",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTimelineEventInput`](crate::input::UpdateTimelineEventInput)
    pub fn builder() -> crate::input::update_timeline_event_input::Builder {
        crate::input::update_timeline_event_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTimelineEventInput {
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the incident that the timeline event is part
    /// of.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The time that the event occurred.</p>
    pub event_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of the event. You can update events of type <code>Custom Event</code>.</p>
    pub event_type: std::option::Option<std::string::String>,
    /// <p>A short description of the event.</p>
    pub event_data: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateTimelineEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTimelineEventInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("event_id", &self.event_id);
        formatter.field("event_time", &self.event_time);
        formatter.field("event_type", &self.event_type);
        formatter.field("event_data", &self.event_data);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResponsePlanInput {
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The long format name of the response plan. Can't contain spaces.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The short format name of the incident. Can't contain spaces.</p>
    pub incident_template_title: std::option::Option<std::string::String>,
    /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
    /// provided by a response plan.</p>
    /// <p class="title">
    /// <b>Possible impacts:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>5</code> - Severe impact</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>4</code> - High impact</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>3</code> - Medium impact</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>2</code> - Low impact</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>1</code> - No impact</p>
    /// </li>
    /// </ul>
    pub incident_template_impact: std::option::Option<i32>,
    /// <p>A brief summary of the incident. This typically contains what has happened, what's
    /// currently happening, and next steps.</p>
    pub incident_template_summary: std::option::Option<std::string::String>,
    /// <p>Used to create only one incident record for an incident.</p>
    pub incident_template_dedupe_string: std::option::Option<std::string::String>,
    /// <p>The SNS targets that are notified when updates are made to an incident.</p>
    pub incident_template_notification_targets:
        std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
    /// <p>The
    /// AWS
    /// Chatbot chat channel used for collaboration during an
    /// incident.</p>
    /// <p>Use the empty structure to remove the chat channel from the response plan.</p>
    pub chat_channel: std::option::Option<crate::model::ChatChannel>,
    /// <p>The contacts and escalation plans that Incident Manager engages at the start of the incident.</p>
    pub engagements: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The actions that this response plan takes at the beginning of an incident.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
}
impl std::fmt::Debug for UpdateResponsePlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResponsePlanInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("arn", &self.arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("incident_template_title", &self.incident_template_title);
        formatter.field("incident_template_impact", &self.incident_template_impact);
        formatter.field("incident_template_summary", &self.incident_template_summary);
        formatter.field(
            "incident_template_dedupe_string",
            &self.incident_template_dedupe_string,
        );
        formatter.field(
            "incident_template_notification_targets",
            &self.incident_template_notification_targets,
        );
        formatter.field("chat_channel", &self.chat_channel);
        formatter.field("engagements", &self.engagements);
        formatter.field("actions", &self.actions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationSetInput {
    /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An action to add or delete a Region.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::UpdateReplicationSetAction>>,
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateReplicationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationSetInput");
        formatter.field("arn", &self.arn);
        formatter.field("actions", &self.actions);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRelatedItemsInput {
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the incident record you are updating related items
    /// in.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>Details about the item you are adding or deleting.</p>
    pub related_items_update: std::option::Option<crate::model::RelatedItemsUpdate>,
}
impl std::fmt::Debug for UpdateRelatedItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRelatedItemsInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("related_items_update", &self.related_items_update);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIncidentRecordInput {
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the incident record you are updating.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The title of the incident is a brief and easily recognizable.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The summary describes what has happened during the incident.</p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>Defines the impact to customers and applications. Providing an impact overwrites the
    /// impact provided by the response plan.</p>
    /// <p class="title">
    /// <b>Possible impacts:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>1</code> - Critical impact, this typically relates to full application
    /// failure that impacts many to all customers. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>2</code> - High impact, partial application failure with impact to many
    /// customers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>3</code> -  Medium impact, the application is providing reduced service
    /// to customers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
    /// yet.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>5</code> - No impact, customers aren't currently impacted but urgent
    /// action is needed to avoid impact.</p>
    /// </li>
    /// </ul>
    pub impact: std::option::Option<i32>,
    /// <p>The status of the incident. An incident can be <code>Open</code> or <code>Resolved</code>.</p>
    pub status: std::option::Option<crate::model::IncidentRecordStatus>,
    /// <p>The AWS Chatbot chat channel for responders to collaborate in.</p>
    pub chat_channel: std::option::Option<crate::model::ChatChannel>,
    /// <p>The SNS targets that are notified when updates are made to an incident.</p>
    /// <p>Using multiple SNS topics creates redundancy in the case that a Region is down during
    /// the incident.</p>
    pub notification_targets:
        std::option::Option<std::vec::Vec<crate::model::NotificationTargetItem>>,
}
impl std::fmt::Debug for UpdateIncidentRecordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIncidentRecordInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("arn", &self.arn);
        formatter.field("title", &self.title);
        formatter.field("summary", &self.summary);
        formatter.field("impact", &self.impact);
        formatter.field("status", &self.status);
        formatter.field("chat_channel", &self.chat_channel);
        formatter.field("notification_targets", &self.notification_targets);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeletionProtectionInput {
    /// <p>The Amazon Resource Name (ARN) of the replication set you're updating.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Details if deletion protection is enabled or disabled in your account.</p>
    pub deletion_protected: std::option::Option<bool>,
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateDeletionProtectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeletionProtectionInput");
        formatter.field("arn", &self.arn);
        formatter.field("deletion_protected", &self.deletion_protected);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the response plan you're removing a tag from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name of the tag you're removing from the response plan.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags that you are adding to the response plan.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartIncidentInput {
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat
    /// channels, SNS topics, runbooks, title, and impact of the incident. </p>
    pub response_plan_arn: std::option::Option<std::string::String>,
    /// <p>Provide a title for the incident. Providing a title overwrites the title provided by
    /// the response plan. </p>
    pub title: std::option::Option<std::string::String>,
    /// <p>Defines the impact to the customers. Providing an impact overwrites the impact
    /// provided by a response plan.</p>
    /// <p class="title">
    /// <b>Possible impacts:</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>1</code> - Critical impact, this typically relates to full application
    /// failure that impacts many to all customers. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>2</code> - High impact, partial application failure with impact to many
    /// customers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>3</code> -  Medium impact, the application is providing reduced service
    /// to customers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>4</code> -  Low impact, customer might aren't impacted by the problem
    /// yet.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>5</code> - No impact, customers aren't currently impacted but urgent
    /// action is needed to avoid impact.</p>
    /// </li>
    /// </ul>
    pub impact: std::option::Option<i32>,
    /// <p>Details of what created the incident record in Incident Manager.</p>
    pub trigger_details: std::option::Option<crate::model::TriggerDetails>,
    /// <p>Add related items to the incident for other responders to use. Related items are AWS
    /// resources, external links, or files uploaded to an S3 bucket. </p>
    pub related_items: std::option::Option<std::vec::Vec<crate::model::RelatedItem>>,
}
impl std::fmt::Debug for StartIncidentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartIncidentInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("response_plan_arn", &self.response_plan_arn);
        formatter.field("title", &self.title);
        formatter.field("impact", &self.impact);
        formatter.field("trigger_details", &self.trigger_details);
        formatter.field("related_items", &self.related_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the response plan you're adding the resource policy
    /// to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Details of the resource policy.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTimelineEventsInput {
    /// <p>The Amazon Resource Name (ARN) of the incident that the event is part of.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>Filters the timeline events based on the provided conditional values. You can filter
    /// timeline events using the following keys:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>eventTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>eventType</code>
    /// </p>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Sort by the specified key value pair.</p>
    pub sort_by: std::option::Option<crate::model::TimelineEventSort>,
    /// <p>Sorts the order of timeline events by the value specified in the <code>sortBy</code>
    /// field.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The maximum number of results per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTimelineEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTimelineEventsInput");
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("filters", &self.filters);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResponsePlansInput {
    /// <p>The maximum number of response plans per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListResponsePlansInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResponsePlansInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReplicationSetsInput {
    /// <p>The maximum number of results per page. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListReplicationSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReplicationSetsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRelatedItemsInput {
    /// <p>The Amazon Resource Name (ARN) of the incident record that you are listing related items for.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of related items per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListRelatedItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRelatedItemsInput");
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIncidentRecordsInput {
    /// <p>Filter the list of incident records you are searching through. You can filter on the
    /// following keys:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>creationTime</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>impact</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>status</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>createdBy</code>
    /// </p>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of results per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListIncidentRecordsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIncidentRecordsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTimelineEventInput {
    /// <p>The Amazon Resource Name (ARN) of the incident that the timeline event is part of.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the event. You can get an event's ID when you create it or by using <code>ListTimelineEvents</code>.</p>
    pub event_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTimelineEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTimelineEventInput");
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("event_id", &self.event_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResponsePlanInput {
    /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResponsePlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResponsePlanInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePoliciesInput {
    /// <p>The Amazon Resource Name (ARN) of the response plan with the attached resource policy. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of resource policies to display per page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourcePoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePoliciesInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReplicationSetInput {
    /// <p>The Amazon Resource Name (ARN) of the replication set you want to retrieve.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetReplicationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReplicationSetInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIncidentRecordInput {
    /// <p>The Amazon Resource Name (ARN) of the incident record.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetIncidentRecordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIncidentRecordInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTimelineEventInput {
    /// <p>The Amazon Resource Name (ARN) of the incident that the event is part of.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the event you are updating. You can find this by using <code>ListTimelineEvents</code>.</p>
    pub event_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteTimelineEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTimelineEventInput");
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("event_id", &self.event_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResponsePlanInput {
    /// <p>The Amazon Resource Name (ARN) of the response plan.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteResponsePlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResponsePlanInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resource you're deleting the policy from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the resource policy you're deleting.</p>
    pub policy_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("policy_id", &self.policy_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationSetInput {
    /// <p>The Amazon Resource Name (ARN) of the replication set you're deleting.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteReplicationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationSetInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIncidentRecordInput {
    /// <p>The Amazon Resource Name (ARN) of the incident record you are deleting.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteIncidentRecordInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIncidentRecordInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTimelineEventInput {
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the incident record you are adding the event
    /// to.</p>
    pub incident_record_arn: std::option::Option<std::string::String>,
    /// <p>The time that the event occurred.</p>
    pub event_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of the event. You can create timeline events of type <code>Custom
    /// Event</code>.</p>
    pub event_type: std::option::Option<std::string::String>,
    /// <p>A valid JSON string. There is no other schema imposed. A short description of the event.</p>
    pub event_data: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateTimelineEventInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTimelineEventInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("incident_record_arn", &self.incident_record_arn);
        formatter.field("event_time", &self.event_time);
        formatter.field("event_type", &self.event_type);
        formatter.field("event_data", &self.event_data);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResponsePlanInput {
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The short format name of the response plan. Can't include spaces.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The long format of the response plan name. This field can contain spaces.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>Details used to create an incident when using this response plan.</p>
    pub incident_template: std::option::Option<crate::model::IncidentTemplate>,
    /// <p>The
    /// AWS Chatbot
    /// chat channel used for collaboration during an incident.</p>
    pub chat_channel: std::option::Option<crate::model::ChatChannel>,
    /// <p>The contacts and escalation plans that the response plan engages during an
    /// incident.</p>
    pub engagements: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The actions that the response plan starts at the beginning of an incident.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>A list of tags that you are adding to the response plan.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateResponsePlanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResponsePlanInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("incident_template", &self.incident_template);
        formatter.field("chat_channel", &self.chat_channel);
        formatter.field("engagements", &self.engagements);
        formatter.field("actions", &self.actions);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationSetInput {
    /// <p>The Regions that Incident Manager replicates your data to. You can have up to three Regions
    /// in your replication set.</p>
    pub regions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::RegionMapInputValue>,
    >,
    /// <p>A token ensuring that the action is called only once with the specified details.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateReplicationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationSetInput");
        formatter.field("regions", &self.regions);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
