// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptPageInput`](crate::input::AcceptPageInput)
pub mod accept_page_input {
    /// A builder for [`AcceptPageInput`](crate::input::AcceptPageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_id: std::option::Option<std::string::String>,
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
        pub(crate) accept_type: std::option::Option<crate::model::AcceptType>,
        pub(crate) note: std::option::Option<std::string::String>,
        pub(crate) accept_code: std::option::Option<std::string::String>,
        pub(crate) accept_code_validation: std::option::Option<crate::model::AcceptCodeValidation>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn page_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_id = input;
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
        pub fn accept_type(mut self, input: crate::model::AcceptType) -> Self {
            self.accept_type = Some(input);
            self
        }
        /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
        pub fn set_accept_type(
            mut self,
            input: std::option::Option<crate::model::AcceptType>,
        ) -> Self {
            self.accept_type = input;
            self
        }
        /// <p>Information provided by the user when the user acknowledges the page.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.note = Some(input.into());
            self
        }
        /// <p>Information provided by the user when the user acknowledges the page.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.note = input;
            self
        }
        /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
        pub fn accept_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_code = Some(input.into());
            self
        }
        /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
        pub fn set_accept_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accept_code = input;
            self
        }
        /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
        /// <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
        pub fn accept_code_validation(mut self, input: crate::model::AcceptCodeValidation) -> Self {
            self.accept_code_validation = Some(input);
            self
        }
        /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
        /// <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
        pub fn set_accept_code_validation(
            mut self,
            input: std::option::Option<crate::model::AcceptCodeValidation>,
        ) -> Self {
            self.accept_code_validation = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptPageInput`](crate::input::AcceptPageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptPageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptPageInput {
                page_id: self.page_id,
                contact_channel_id: self.contact_channel_id,
                accept_type: self.accept_type,
                note: self.note,
                accept_code: self.accept_code,
                accept_code_validation: self.accept_code_validation,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptPageInputOperationOutputAlias = crate::operation::AcceptPage;
#[doc(hidden)]
pub type AcceptPageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptPageInput {
    /// Consumes the builder and constructs an Operation<[`AcceptPage`](crate::operation::AcceptPage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptPage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptPageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptPageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptPageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.AcceptPage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_page(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptPage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptPage",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptPageInput`](crate::input::AcceptPageInput)
    pub fn builder() -> crate::input::accept_page_input::Builder {
        crate::input::accept_page_input::Builder::default()
    }
}

/// See [`ActivateContactChannelInput`](crate::input::ActivateContactChannelInput)
pub mod activate_contact_channel_input {
    /// A builder for [`ActivateContactChannelInput`](crate::input::ActivateContactChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
        pub(crate) activation_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// <p>The code sent to the contact channel when it was created in the contact. </p>
        pub fn activation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.activation_code = Some(input.into());
            self
        }
        /// <p>The code sent to the contact channel when it was created in the contact. </p>
        pub fn set_activation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activation_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateContactChannelInput`](crate::input::ActivateContactChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateContactChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateContactChannelInput {
                contact_channel_id: self.contact_channel_id,
                activation_code: self.activation_code,
            })
        }
    }
}
#[doc(hidden)]
pub type ActivateContactChannelInputOperationOutputAlias = crate::operation::ActivateContactChannel;
#[doc(hidden)]
pub type ActivateContactChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ActivateContactChannelInput {
    /// Consumes the builder and constructs an Operation<[`ActivateContactChannel`](crate::operation::ActivateContactChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateContactChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ActivateContactChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ActivateContactChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ActivateContactChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ActivateContactChannel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_activate_contact_channel(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateContactChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateContactChannel",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ActivateContactChannelInput`](crate::input::ActivateContactChannelInput)
    pub fn builder() -> crate::input::activate_contact_channel_input::Builder {
        crate::input::activate_contact_channel_input::Builder::default()
    }
}

/// See [`CreateContactInput`](crate::input::CreateContactInput)
pub mod create_contact_input {
    /// A builder for [`CreateContactInput`](crate::input::CreateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ContactType>,
        pub(crate) plan: std::option::Option<crate::model::Plan>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. </p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. </p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The full name of the contact or escalation plan. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The full name of the contact or escalation plan. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>
        pub fn r#type(mut self, input: crate::model::ContactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. </p>
        pub fn plan(mut self, input: crate::model::Plan) -> Self {
            self.plan = Some(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. </p>
        pub fn set_plan(mut self, input: std::option::Option<crate::model::Plan>) -> Self {
            self.plan = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactInput`](crate::input::CreateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactInput {
                alias: self.alias,
                display_name: self.display_name,
                r#type: self.r#type,
                plan: self.plan,
                tags: self.tags,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactInputOperationOutputAlias = crate::operation::CreateContact;
#[doc(hidden)]
pub type CreateContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContactInput {
    /// Consumes the builder and constructs an Operation<[`CreateContact`](crate::operation::CreateContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.CreateContact",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_contact(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContact",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateContactInput`](crate::input::CreateContactInput)
    pub fn builder() -> crate::input::create_contact_input::Builder {
        crate::input::create_contact_input::Builder::default()
    }
}

/// See [`CreateContactChannelInput`](crate::input::CreateContactChannelInput)
pub mod create_contact_channel_input {
    /// A builder for [`CreateContactChannelInput`](crate::input::CreateContactChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelType>,
        pub(crate) delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
        pub(crate) defer_activation: std::option::Option<bool>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Incident Manager supports three types of contact channels:</p>
        /// <ul>
        /// <li> <p> <code>SMS</code> </p> </li>
        /// <li> <p> <code>VOICE</code> </p> </li>
        /// <li> <p> <code>EMAIL</code> </p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Incident Manager supports three types of contact channels:</p>
        /// <ul>
        /// <li> <p> <code>SMS</code> </p> </li>
        /// <li> <p> <code>VOICE</code> </p> </li>
        /// <li> <p> <code>EMAIL</code> </p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p>
        /// <ul>
        /// <li> <p>SMS - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>VOICE - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>EMAIL - any standard email format</p> </li>
        /// </ul>
        pub fn delivery_address(mut self, input: crate::model::ContactChannelAddress) -> Self {
            self.delivery_address = Some(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p>
        /// <ul>
        /// <li> <p>SMS - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>VOICE - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>EMAIL - any standard email format</p> </li>
        /// </ul>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.delivery_address = input;
            self
        }
        /// <p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.</p>
        pub fn defer_activation(mut self, input: bool) -> Self {
            self.defer_activation = Some(input);
            self
        }
        /// <p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.</p>
        pub fn set_defer_activation(mut self, input: std::option::Option<bool>) -> Self {
            self.defer_activation = input;
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactChannelInput`](crate::input::CreateContactChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactChannelInput {
                contact_id: self.contact_id,
                name: self.name,
                r#type: self.r#type,
                delivery_address: self.delivery_address,
                defer_activation: self.defer_activation,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactChannelInputOperationOutputAlias = crate::operation::CreateContactChannel;
#[doc(hidden)]
pub type CreateContactChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContactChannelInput {
    /// Consumes the builder and constructs an Operation<[`CreateContactChannel`](crate::operation::CreateContactChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContactChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateContactChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateContactChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateContactChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.CreateContactChannel",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_contact_channel(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContactChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContactChannel",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateContactChannelInput`](crate::input::CreateContactChannelInput)
    pub fn builder() -> crate::input::create_contact_channel_input::Builder {
        crate::input::create_contact_channel_input::Builder::default()
    }
}

/// See [`DeactivateContactChannelInput`](crate::input::DeactivateContactChannelInput)
pub mod deactivate_contact_channel_input {
    /// A builder for [`DeactivateContactChannelInput`](crate::input::DeactivateContactChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateContactChannelInput`](crate::input::DeactivateContactChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateContactChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateContactChannelInput {
                contact_channel_id: self.contact_channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeactivateContactChannelInputOperationOutputAlias =
    crate::operation::DeactivateContactChannel;
#[doc(hidden)]
pub type DeactivateContactChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeactivateContactChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateContactChannel`](crate::operation::DeactivateContactChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateContactChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeactivateContactChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeactivateContactChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeactivateContactChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.DeactivateContactChannel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deactivate_contact_channel(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateContactChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateContactChannel",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeactivateContactChannelInput`](crate::input::DeactivateContactChannelInput)
    pub fn builder() -> crate::input::deactivate_contact_channel_input::Builder {
        crate::input::deactivate_contact_channel_input::Builder::default()
    }
}

/// See [`DeleteContactInput`](crate::input::DeleteContactInput)
pub mod delete_contact_input {
    /// A builder for [`DeleteContactInput`](crate::input::DeleteContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactInput`](crate::input::DeleteContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactInput {
                contact_id: self.contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactInputOperationOutputAlias = crate::operation::DeleteContact;
#[doc(hidden)]
pub type DeleteContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContactInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContact`](crate::operation::DeleteContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.DeleteContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_contact(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContact",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactInput`](crate::input::DeleteContactInput)
    pub fn builder() -> crate::input::delete_contact_input::Builder {
        crate::input::delete_contact_input::Builder::default()
    }
}

/// See [`DeleteContactChannelInput`](crate::input::DeleteContactChannelInput)
pub mod delete_contact_channel_input {
    /// A builder for [`DeleteContactChannelInput`](crate::input::DeleteContactChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactChannelInput`](crate::input::DeleteContactChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactChannelInput {
                contact_channel_id: self.contact_channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactChannelInputOperationOutputAlias = crate::operation::DeleteContactChannel;
#[doc(hidden)]
pub type DeleteContactChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContactChannelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContactChannel`](crate::operation::DeleteContactChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContactChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteContactChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteContactChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteContactChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.DeleteContactChannel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_contact_channel(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContactChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContactChannel",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactChannelInput`](crate::input::DeleteContactChannelInput)
    pub fn builder() -> crate::input::delete_contact_channel_input::Builder {
        crate::input::delete_contact_channel_input::Builder::default()
    }
}

/// See [`DescribeEngagementInput`](crate::input::DescribeEngagementInput)
pub mod describe_engagement_input {
    /// A builder for [`DescribeEngagementInput`](crate::input::DescribeEngagementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engagement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
        pub fn engagement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngagementInput`](crate::input::DescribeEngagementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngagementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngagementInput {
                engagement_id: self.engagement_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngagementInputOperationOutputAlias = crate::operation::DescribeEngagement;
#[doc(hidden)]
pub type DescribeEngagementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEngagementInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngagement`](crate::operation::DescribeEngagement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngagement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEngagementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEngagementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEngagementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.DescribeEngagement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_engagement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngagement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngagement",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngagementInput`](crate::input::DescribeEngagementInput)
    pub fn builder() -> crate::input::describe_engagement_input::Builder {
        crate::input::describe_engagement_input::Builder::default()
    }
}

/// See [`DescribePageInput`](crate::input::DescribePageInput)
pub mod describe_page_input {
    /// A builder for [`DescribePageInput`](crate::input::DescribePageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the engagement to a contact channel.</p>
        pub fn page_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_id = Some(input.into());
            self
        }
        /// <p>The ID of the engagement to a contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePageInput`](crate::input::DescribePageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePageInput {
                page_id: self.page_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePageInputOperationOutputAlias = crate::operation::DescribePage;
#[doc(hidden)]
pub type DescribePageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePageInput {
    /// Consumes the builder and constructs an Operation<[`DescribePage`](crate::operation::DescribePage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.DescribePage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_page(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePage",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePageInput`](crate::input::DescribePageInput)
    pub fn builder() -> crate::input::describe_page_input::Builder {
        crate::input::describe_page_input::Builder::default()
    }
}

/// See [`GetContactInput`](crate::input::GetContactInput)
pub mod get_contact_input {
    /// A builder for [`GetContactInput`](crate::input::GetContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactInput`](crate::input::GetContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactInput {
                contact_id: self.contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactInputOperationOutputAlias = crate::operation::GetContact;
#[doc(hidden)]
pub type GetContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContactInput {
    /// Consumes the builder and constructs an Operation<[`GetContact`](crate::operation::GetContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.GetContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_contact(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContact",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContactInput`](crate::input::GetContactInput)
    pub fn builder() -> crate::input::get_contact_input::Builder {
        crate::input::get_contact_input::Builder::default()
    }
}

/// See [`GetContactChannelInput`](crate::input::GetContactChannelInput)
pub mod get_contact_channel_input {
    /// A builder for [`GetContactChannelInput`](crate::input::GetContactChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactChannelInput`](crate::input::GetContactChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactChannelInput {
                contact_channel_id: self.contact_channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactChannelInputOperationOutputAlias = crate::operation::GetContactChannel;
#[doc(hidden)]
pub type GetContactChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContactChannelInput {
    /// Consumes the builder and constructs an Operation<[`GetContactChannel`](crate::operation::GetContactChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContactChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContactChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContactChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContactChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.GetContactChannel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_contact_channel(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContactChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContactChannel",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContactChannelInput`](crate::input::GetContactChannelInput)
    pub fn builder() -> crate::input::get_contact_channel_input::Builder {
        crate::input::get_contact_channel_input::Builder::default()
    }
}

/// See [`GetContactPolicyInput`](crate::input::GetContactPolicyInput)
pub mod get_contact_policy_input {
    /// A builder for [`GetContactPolicyInput`](crate::input::GetContactPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactPolicyInput`](crate::input::GetContactPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactPolicyInput {
                contact_arn: self.contact_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactPolicyInputOperationOutputAlias = crate::operation::GetContactPolicy;
#[doc(hidden)]
pub type GetContactPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContactPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetContactPolicy`](crate::operation::GetContactPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContactPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContactPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContactPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContactPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.GetContactPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_contact_policy(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContactPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContactPolicy",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContactPolicyInput`](crate::input::GetContactPolicyInput)
    pub fn builder() -> crate::input::get_contact_policy_input::Builder {
        crate::input::get_contact_policy_input::Builder::default()
    }
}

/// See [`ListContactChannelsInput`](crate::input::ListContactChannelsInput)
pub mod list_contact_channels_input {
    /// A builder for [`ListContactChannelsInput`](crate::input::ListContactChannelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact. </p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact. </p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of contact channels per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of contact channels per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactChannelsInput`](crate::input::ListContactChannelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactChannelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactChannelsInput {
                contact_id: self.contact_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactChannelsInputOperationOutputAlias = crate::operation::ListContactChannels;
#[doc(hidden)]
pub type ListContactChannelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContactChannelsInput {
    /// Consumes the builder and constructs an Operation<[`ListContactChannels`](crate::operation::ListContactChannels)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContactChannels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContactChannelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContactChannelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContactChannelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ListContactChannels",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_contact_channels(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContactChannels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContactChannels",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContactChannelsInput`](crate::input::ListContactChannelsInput)
    pub fn builder() -> crate::input::list_contact_channels_input::Builder {
        crate::input::list_contact_channels_input::Builder::default()
    }
}

/// See [`ListContactsInput`](crate::input::ListContactsInput)
pub mod list_contacts_input {
    /// A builder for [`ListContactsInput`](crate::input::ListContactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) alias_prefix: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ContactType>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of contacts and escalation plans per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of contacts and escalation plans per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
        pub fn alias_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_prefix = Some(input.into());
            self
        }
        /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
        pub fn set_alias_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_prefix = input;
            self
        }
        /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>
        pub fn r#type(mut self, input: crate::model::ContactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactsInput`](crate::input::ListContactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                alias_prefix: self.alias_prefix,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactsInputOperationOutputAlias = crate::operation::ListContacts;
#[doc(hidden)]
pub type ListContactsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContactsInput {
    /// Consumes the builder and constructs an Operation<[`ListContacts`](crate::operation::ListContacts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContacts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContactsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContactsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContactsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ListContacts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_contacts(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContacts",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContactsInput`](crate::input::ListContactsInput)
    pub fn builder() -> crate::input::list_contacts_input::Builder {
        crate::input::list_contacts_input::Builder::default()
    }
}

/// See [`ListEngagementsInput`](crate::input::ListEngagementsInput)
pub mod list_engagements_input {
    /// A builder for [`ListEngagementsInput`](crate::input::ListEngagementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) incident_id: std::option::Option<std::string::String>,
        pub(crate) time_range_value: std::option::Option<crate::model::TimeRange>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of engagements per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of engagements per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.incident_id = input;
            self
        }
        /// <p>The time range to lists engagements for an incident.</p>
        pub fn time_range_value(mut self, input: crate::model::TimeRange) -> Self {
            self.time_range_value = Some(input);
            self
        }
        /// <p>The time range to lists engagements for an incident.</p>
        pub fn set_time_range_value(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.time_range_value = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEngagementsInput`](crate::input::ListEngagementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEngagementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEngagementsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                incident_id: self.incident_id,
                time_range_value: self.time_range_value,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEngagementsInputOperationOutputAlias = crate::operation::ListEngagements;
#[doc(hidden)]
pub type ListEngagementsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEngagementsInput {
    /// Consumes the builder and constructs an Operation<[`ListEngagements`](crate::operation::ListEngagements)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEngagements,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEngagementsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEngagementsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEngagementsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ListEngagements",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_engagements(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEngagements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEngagements",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEngagementsInput`](crate::input::ListEngagementsInput)
    pub fn builder() -> crate::input::list_engagements_input::Builder {
        crate::input::list_engagements_input::Builder::default()
    }
}

/// See [`ListPageReceiptsInput`](crate::input::ListPageReceiptsInput)
pub mod list_page_receipts_input {
    /// A builder for [`ListPageReceiptsInput`](crate::input::ListPageReceiptsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
        pub fn page_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_id = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of acknowledgements per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of acknowledgements per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPageReceiptsInput`](crate::input::ListPageReceiptsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPageReceiptsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPageReceiptsInput {
                page_id: self.page_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPageReceiptsInputOperationOutputAlias = crate::operation::ListPageReceipts;
#[doc(hidden)]
pub type ListPageReceiptsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPageReceiptsInput {
    /// Consumes the builder and constructs an Operation<[`ListPageReceipts`](crate::operation::ListPageReceipts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPageReceipts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPageReceiptsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPageReceiptsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPageReceiptsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ListPageReceipts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_page_receipts(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPageReceipts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPageReceipts",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPageReceiptsInput`](crate::input::ListPageReceiptsInput)
    pub fn builder() -> crate::input::list_page_receipts_input::Builder {
        crate::input::list_page_receipts_input::Builder::default()
    }
}

/// See [`ListPagesByContactInput`](crate::input::ListPagesByContactInput)
pub mod list_pages_by_contact_input {
    /// A builder for [`ListPagesByContactInput`](crate::input::ListPagesByContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPagesByContactInput`](crate::input::ListPagesByContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPagesByContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPagesByContactInput {
                contact_id: self.contact_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPagesByContactInputOperationOutputAlias = crate::operation::ListPagesByContact;
#[doc(hidden)]
pub type ListPagesByContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPagesByContactInput {
    /// Consumes the builder and constructs an Operation<[`ListPagesByContact`](crate::operation::ListPagesByContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPagesByContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPagesByContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPagesByContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPagesByContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ListPagesByContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pages_by_contact(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPagesByContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPagesByContact",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPagesByContactInput`](crate::input::ListPagesByContactInput)
    pub fn builder() -> crate::input::list_pages_by_contact_input::Builder {
        crate::input::list_pages_by_contact_input::Builder::default()
    }
}

/// See [`ListPagesByEngagementInput`](crate::input::ListPagesByEngagementInput)
pub mod list_pages_by_engagement_input {
    /// A builder for [`ListPagesByEngagementInput`](crate::input::ListPagesByEngagementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engagement_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn engagement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_id = input;
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPagesByEngagementInput`](crate::input::ListPagesByEngagementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPagesByEngagementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPagesByEngagementInput {
                engagement_id: self.engagement_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPagesByEngagementInputOperationOutputAlias = crate::operation::ListPagesByEngagement;
#[doc(hidden)]
pub type ListPagesByEngagementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPagesByEngagementInput {
    /// Consumes the builder and constructs an Operation<[`ListPagesByEngagement`](crate::operation::ListPagesByEngagement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPagesByEngagement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPagesByEngagementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPagesByEngagementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPagesByEngagementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ListPagesByEngagement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pages_by_engagement(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPagesByEngagement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPagesByEngagement",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPagesByEngagementInput`](crate::input::ListPagesByEngagementInput)
    pub fn builder() -> crate::input::list_pages_by_engagement_input::Builder {
        crate::input::list_pages_by_engagement_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutContactPolicyInput`](crate::input::PutContactPolicyInput)
pub mod put_contact_policy_input {
    /// A builder for [`PutContactPolicyInput`](crate::input::PutContactPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutContactPolicyInput`](crate::input::PutContactPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutContactPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutContactPolicyInput {
                contact_arn: self.contact_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutContactPolicyInputOperationOutputAlias = crate::operation::PutContactPolicy;
#[doc(hidden)]
pub type PutContactPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutContactPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutContactPolicy`](crate::operation::PutContactPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutContactPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutContactPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutContactPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutContactPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.PutContactPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_contact_policy(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutContactPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutContactPolicy",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutContactPolicyInput`](crate::input::PutContactPolicyInput)
    pub fn builder() -> crate::input::put_contact_policy_input::Builder {
        crate::input::put_contact_policy_input::Builder::default()
    }
}

/// See [`SendActivationCodeInput`](crate::input::SendActivationCodeInput)
pub mod send_activation_code_input {
    /// A builder for [`SendActivationCodeInput`](crate::input::SendActivationCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendActivationCodeInput`](crate::input::SendActivationCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendActivationCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendActivationCodeInput {
                contact_channel_id: self.contact_channel_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SendActivationCodeInputOperationOutputAlias = crate::operation::SendActivationCode;
#[doc(hidden)]
pub type SendActivationCodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SendActivationCodeInput {
    /// Consumes the builder and constructs an Operation<[`SendActivationCode`](crate::operation::SendActivationCode)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendActivationCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendActivationCodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendActivationCodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendActivationCodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.SendActivationCode",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_send_activation_code(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendActivationCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendActivationCode",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendActivationCodeInput`](crate::input::SendActivationCodeInput)
    pub fn builder() -> crate::input::send_activation_code_input::Builder {
        crate::input::send_activation_code_input::Builder::default()
    }
}

/// See [`StartEngagementInput`](crate::input::StartEngagementInput)
pub mod start_engagement_input {
    /// A builder for [`StartEngagementInput`](crate::input::StartEngagementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) sender: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) public_subject: std::option::Option<std::string::String>,
        pub(crate) public_content: std::option::Option<std::string::String>,
        pub(crate) incident_id: std::option::Option<std::string::String>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender = Some(input.into());
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender = input;
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn public_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_subject = Some(input.into());
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn set_public_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_subject = input;
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn public_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_content = Some(input.into());
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn set_public_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_content = input;
            self
        }
        /// <p>The ARN of the incident that the engagement is part of.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_id = Some(input.into());
            self
        }
        /// <p>The ARN of the incident that the engagement is part of.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.incident_id = input;
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartEngagementInput`](crate::input::StartEngagementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartEngagementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartEngagementInput {
                contact_id: self.contact_id,
                sender: self.sender,
                subject: self.subject,
                content: self.content,
                public_subject: self.public_subject,
                public_content: self.public_content,
                incident_id: self.incident_id,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartEngagementInputOperationOutputAlias = crate::operation::StartEngagement;
#[doc(hidden)]
pub type StartEngagementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartEngagementInput {
    /// Consumes the builder and constructs an Operation<[`StartEngagement`](crate::operation::StartEngagement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartEngagement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartEngagementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartEngagementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartEngagementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.StartEngagement",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_engagement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartEngagement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartEngagement",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartEngagementInput`](crate::input::StartEngagementInput)
    pub fn builder() -> crate::input::start_engagement_input::Builder {
        crate::input::start_engagement_input::Builder::default()
    }
}

/// See [`StopEngagementInput`](crate::input::StopEngagementInput)
pub mod stop_engagement_input {
    /// A builder for [`StopEngagementInput`](crate::input::StopEngagementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engagement_id: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn engagement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_id = input;
            self
        }
        /// <p>The reason that you're stopping the engagement. </p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason that you're stopping the engagement. </p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`StopEngagementInput`](crate::input::StopEngagementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopEngagementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopEngagementInput {
                engagement_id: self.engagement_id,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type StopEngagementInputOperationOutputAlias = crate::operation::StopEngagement;
#[doc(hidden)]
pub type StopEngagementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopEngagementInput {
    /// Consumes the builder and constructs an Operation<[`StopEngagement`](crate::operation::StopEngagement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopEngagement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopEngagementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopEngagementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopEngagementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.StopEngagement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_engagement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopEngagement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopEngagement",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopEngagementInput`](crate::input::StopEngagementInput)
    pub fn builder() -> crate::input::stop_engagement_input::Builder {
        crate::input::stop_engagement_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag that you want to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The key of the tag that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateContactInput`](crate::input::UpdateContactInput)
pub mod update_contact_input {
    /// A builder for [`UpdateContactInput`](crate::input::UpdateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) plan: std::option::Option<crate::model::Plan>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. </p>
        pub fn plan(mut self, input: crate::model::Plan) -> Self {
            self.plan = Some(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. </p>
        pub fn set_plan(mut self, input: std::option::Option<crate::model::Plan>) -> Self {
            self.plan = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContactInput`](crate::input::UpdateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContactInput {
                contact_id: self.contact_id,
                display_name: self.display_name,
                plan: self.plan,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContactInputOperationOutputAlias = crate::operation::UpdateContact;
#[doc(hidden)]
pub type UpdateContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateContactInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContact`](crate::operation::UpdateContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.UpdateContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_contact(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContact",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContactInput`](crate::input::UpdateContactInput)
    pub fn builder() -> crate::input::update_contact_input::Builder {
        crate::input::update_contact_input::Builder::default()
    }
}

/// See [`UpdateContactChannelInput`](crate::input::UpdateContactChannelInput)
pub mod update_contact_channel_input {
    /// A builder for [`UpdateContactChannelInput`](crate::input::UpdateContactChannelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn delivery_address(mut self, input: crate::model::ContactChannelAddress) -> Self {
            self.delivery_address = Some(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.delivery_address = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContactChannelInput`](crate::input::UpdateContactChannelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContactChannelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContactChannelInput {
                contact_channel_id: self.contact_channel_id,
                name: self.name,
                delivery_address: self.delivery_address,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContactChannelInputOperationOutputAlias = crate::operation::UpdateContactChannel;
#[doc(hidden)]
pub type UpdateContactChannelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateContactChannelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContactChannel`](crate::operation::UpdateContactChannel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContactChannel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContactChannelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContactChannelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContactChannelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SSMContacts.UpdateContactChannel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_contact_channel(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContactChannel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContactChannel",
            "ssmcontacts",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContactChannelInput`](crate::input::UpdateContactChannelInput)
    pub fn builder() -> crate::input::update_contact_channel_input::Builder {
        crate::input::update_contact_channel_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
    /// <p>The name of the contact channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
    pub delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
}
impl UpdateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
    /// <p>The name of the contact channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
    pub fn delivery_address(&self) -> std::option::Option<&crate::model::ContactChannelAddress> {
        self.delivery_address.as_ref()
    }
}
impl std::fmt::Debug for UpdateContactChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContactChannelInput");
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.field("name", &self.name);
        formatter.field("delivery_address", &self.delivery_address);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>The full name of the contact or escalation plan.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. </p>
    pub plan: std::option::Option<crate::model::Plan>,
}
impl UpdateContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
    /// <p>The full name of the contact or escalation plan.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. </p>
    pub fn plan(&self) -> std::option::Option<&crate::model::Plan> {
        self.plan.as_ref()
    }
}
impl std::fmt::Debug for UpdateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContactInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("display_name", &self.display_name);
        formatter.field("plan", &self.plan);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key of the tag that you want to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key of the tag that you want to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
    pub engagement_id: std::option::Option<std::string::String>,
    /// <p>The reason that you're stopping the engagement. </p>
    pub reason: std::option::Option<std::string::String>,
}
impl StopEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
    pub fn engagement_id(&self) -> std::option::Option<&str> {
        self.engagement_id.as_deref()
    }
    /// <p>The reason that you're stopping the engagement. </p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for StopEngagementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopEngagementInput");
        formatter.field("engagement_id", &self.engagement_id);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>The user that started the engagement.</p>
    pub sender: std::option::Option<std::string::String>,
    /// <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    pub public_subject: std::option::Option<std::string::String>,
    /// <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    pub public_content: std::option::Option<std::string::String>,
    /// <p>The ARN of the incident that the engagement is part of.</p>
    pub incident_id: std::option::Option<std::string::String>,
    /// <p>A token ensuring that the operation is called only once with the specified details.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl StartEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
    /// <p>The user that started the engagement.</p>
    pub fn sender(&self) -> std::option::Option<&str> {
        self.sender.as_deref()
    }
    /// <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    pub fn public_subject(&self) -> std::option::Option<&str> {
        self.public_subject.as_deref()
    }
    /// <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    pub fn public_content(&self) -> std::option::Option<&str> {
        self.public_content.as_deref()
    }
    /// <p>The ARN of the incident that the engagement is part of.</p>
    pub fn incident_id(&self) -> std::option::Option<&str> {
        self.incident_id.as_deref()
    }
    /// <p>A token ensuring that the operation is called only once with the specified details.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for StartEngagementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartEngagementInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("sender", &self.sender);
        formatter.field("subject", &self.subject);
        formatter.field("content", &self.content);
        formatter.field("public_subject", &self.public_subject);
        formatter.field("public_content", &self.public_content);
        formatter.field("incident_id", &self.incident_id);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendActivationCodeInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
}
impl SendActivationCodeInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
}
impl std::fmt::Debug for SendActivationCodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendActivationCodeInput");
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutContactPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>Details of the resource policy.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutContactPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>Details of the resource policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutContactPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutContactPolicyInput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPagesByEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
    pub engagement_id: std::option::Option<std::string::String>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of engagements to contact channels to list per page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPagesByEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
    pub fn engagement_id(&self) -> std::option::Option<&str> {
        self.engagement_id.as_deref()
    }
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of engagements to contact channels to list per page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPagesByEngagementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPagesByEngagementInput");
        formatter.field("engagement_id", &self.engagement_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPagesByContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListPagesByContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPagesByContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPagesByContactInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPageReceiptsInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
    pub page_id: std::option::Option<std::string::String>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of acknowledgements per page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPageReceiptsInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
    pub fn page_id(&self) -> std::option::Option<&str> {
        self.page_id.as_deref()
    }
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of acknowledgements per page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPageReceiptsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPageReceiptsInput");
        formatter.field("page_id", &self.page_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEngagementsInput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of engagements per page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
    pub incident_id: std::option::Option<std::string::String>,
    /// <p>The time range to lists engagements for an incident.</p>
    pub time_range_value: std::option::Option<crate::model::TimeRange>,
}
impl ListEngagementsInput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of engagements per page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
    pub fn incident_id(&self) -> std::option::Option<&str> {
        self.incident_id.as_deref()
    }
    /// <p>The time range to lists engagements for an incident.</p>
    pub fn time_range_value(&self) -> std::option::Option<&crate::model::TimeRange> {
        self.time_range_value.as_ref()
    }
}
impl std::fmt::Debug for ListEngagementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEngagementsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("incident_id", &self.incident_id);
        formatter.field("time_range_value", &self.time_range_value);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactsInput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of contacts and escalation plans per page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
    pub alias_prefix: std::option::Option<std::string::String>,
    /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>
    pub r#type: std::option::Option<crate::model::ContactType>,
}
impl ListContactsInput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of contacts and escalation plans per page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
    pub fn alias_prefix(&self) -> std::option::Option<&str> {
        self.alias_prefix.as_deref()
    }
    /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ContactType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for ListContactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("alias_prefix", &self.alias_prefix);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactChannelsInput {
    /// <p>The Amazon Resource Name (ARN) of the contact. </p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of contact channels per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListContactChannelsInput {
    /// <p>The Amazon Resource Name (ARN) of the contact. </p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of contact channels per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListContactChannelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactChannelsInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub contact_arn: std::option::Option<std::string::String>,
}
impl GetContactPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
}
impl std::fmt::Debug for GetContactPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactPolicyInput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
}
impl GetContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
}
impl std::fmt::Debug for GetContactChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactChannelInput");
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub contact_id: std::option::Option<std::string::String>,
}
impl GetContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
}
impl std::fmt::Debug for GetContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePageInput {
    /// <p>The ID of the engagement to a contact channel.</p>
    pub page_id: std::option::Option<std::string::String>,
}
impl DescribePageInput {
    /// <p>The ID of the engagement to a contact channel.</p>
    pub fn page_id(&self) -> std::option::Option<&str> {
        self.page_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePageInput");
        formatter.field("page_id", &self.page_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
    pub engagement_id: std::option::Option<std::string::String>,
}
impl DescribeEngagementInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
    pub fn engagement_id(&self) -> std::option::Option<&str> {
        self.engagement_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeEngagementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngagementInput");
        formatter.field("engagement_id", &self.engagement_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
}
impl DeleteContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteContactChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContactChannelInput");
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
    pub contact_id: std::option::Option<std::string::String>,
}
impl DeleteContactInput {
    /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContactInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
}
impl DeactivateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
}
impl std::fmt::Debug for DeactivateContactChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateContactChannelInput");
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>The name of the contact channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Incident Manager supports three types of contact channels:</p>
    /// <ul>
    /// <li> <p> <code>SMS</code> </p> </li>
    /// <li> <p> <code>VOICE</code> </p> </li>
    /// <li> <p> <code>EMAIL</code> </p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ChannelType>,
    /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p>
    /// <ul>
    /// <li> <p>SMS - '+' followed by the country code and phone number</p> </li>
    /// <li> <p>VOICE - '+' followed by the country code and phone number</p> </li>
    /// <li> <p>EMAIL - any standard email format</p> </li>
    /// </ul>
    pub delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
    /// <p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.</p>
    pub defer_activation: std::option::Option<bool>,
    /// <p>A token ensuring that the operation is called only once with the specified details.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl CreateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
    /// <p>The name of the contact channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Incident Manager supports three types of contact channels:</p>
    /// <ul>
    /// <li> <p> <code>SMS</code> </p> </li>
    /// <li> <p> <code>VOICE</code> </p> </li>
    /// <li> <p> <code>EMAIL</code> </p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.r#type.as_ref()
    }
    /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p>
    /// <ul>
    /// <li> <p>SMS - '+' followed by the country code and phone number</p> </li>
    /// <li> <p>VOICE - '+' followed by the country code and phone number</p> </li>
    /// <li> <p>EMAIL - any standard email format</p> </li>
    /// </ul>
    pub fn delivery_address(&self) -> std::option::Option<&crate::model::ContactChannelAddress> {
        self.delivery_address.as_ref()
    }
    /// <p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.</p>
    pub fn defer_activation(&self) -> std::option::Option<bool> {
        self.defer_activation
    }
    /// <p>A token ensuring that the operation is called only once with the specified details.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for CreateContactChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContactChannelInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("delivery_address", &self.delivery_address);
        formatter.field("defer_activation", &self.defer_activation);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContactInput {
    /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. </p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The full name of the contact or escalation plan. </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>
    pub r#type: std::option::Option<crate::model::ContactType>,
    /// <p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. </p>
    pub plan: std::option::Option<crate::model::Plan>,
    /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A token ensuring that the operation is called only once with the specified details.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl CreateContactInput {
    /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. </p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The full name of the contact or escalation plan. </p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ContactType> {
        self.r#type.as_ref()
    }
    /// <p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. </p>
    pub fn plan(&self) -> std::option::Option<&crate::model::Plan> {
        self.plan.as_ref()
    }
    /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A token ensuring that the operation is called only once with the specified details.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for CreateContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContactInput");
        formatter.field("alias", &self.alias);
        formatter.field("display_name", &self.display_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("plan", &self.plan);
        formatter.field("tags", &self.tags);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
    /// <p>The code sent to the contact channel when it was created in the contact. </p>
    pub activation_code: std::option::Option<std::string::String>,
}
impl ActivateContactChannelInput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
    /// <p>The code sent to the contact channel when it was created in the contact. </p>
    pub fn activation_code(&self) -> std::option::Option<&str> {
        self.activation_code.as_deref()
    }
}
impl std::fmt::Debug for ActivateContactChannelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateContactChannelInput");
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.field("activation_code", &self.activation_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptPageInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
    pub page_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the contact channel.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
    /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
    pub accept_type: std::option::Option<crate::model::AcceptType>,
    /// <p>Information provided by the user when the user acknowledges the page.</p>
    pub note: std::option::Option<std::string::String>,
    /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
    pub accept_code: std::option::Option<std::string::String>,
    /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
    /// <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
    pub accept_code_validation: std::option::Option<crate::model::AcceptCodeValidation>,
}
impl AcceptPageInput {
    /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
    pub fn page_id(&self) -> std::option::Option<&str> {
        self.page_id.as_deref()
    }
    /// <p>The ARN of the contact channel.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
    /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
    pub fn accept_type(&self) -> std::option::Option<&crate::model::AcceptType> {
        self.accept_type.as_ref()
    }
    /// <p>Information provided by the user when the user acknowledges the page.</p>
    pub fn note(&self) -> std::option::Option<&str> {
        self.note.as_deref()
    }
    /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
    pub fn accept_code(&self) -> std::option::Option<&str> {
        self.accept_code.as_deref()
    }
    /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
    /// <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
    pub fn accept_code_validation(
        &self,
    ) -> std::option::Option<&crate::model::AcceptCodeValidation> {
        self.accept_code_validation.as_ref()
    }
}
impl std::fmt::Debug for AcceptPageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptPageInput");
        formatter.field("page_id", &self.page_id);
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.field("accept_type", &self.accept_type);
        formatter.field("note", &self.note);
        formatter.field("accept_code", &self.accept_code);
        formatter.field("accept_code_validation", &self.accept_code_validation);
        formatter.finish()
    }
}
