// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Systems Manager Incident Manager Contacts
///
/// Client for invoking operations on AWS Systems Manager Incident Manager Contacts. Each operation on AWS Systems Manager Incident Manager Contacts is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ssmcontacts::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ssmcontacts::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ssmcontacts::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AcceptPage`](crate::client::fluent_builders::AcceptPage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_id(impl Into<String>)`](crate::client::fluent_builders::AcceptPage::page_id) / [`set_page_id(Option<String>)`](crate::client::fluent_builders::AcceptPage::set_page_id): <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
    ///   - [`contact_channel_id(impl Into<String>)`](crate::client::fluent_builders::AcceptPage::contact_channel_id) / [`set_contact_channel_id(Option<String>)`](crate::client::fluent_builders::AcceptPage::set_contact_channel_id): <p>The ARN of the contact channel.</p>
    ///   - [`accept_type(AcceptType)`](crate::client::fluent_builders::AcceptPage::accept_type) / [`set_accept_type(Option<AcceptType>)`](crate::client::fluent_builders::AcceptPage::set_accept_type): <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
    ///   - [`note(impl Into<String>)`](crate::client::fluent_builders::AcceptPage::note) / [`set_note(Option<String>)`](crate::client::fluent_builders::AcceptPage::set_note): <p>Information provided by the user when the user acknowledges the page.</p>
    ///   - [`accept_code(impl Into<String>)`](crate::client::fluent_builders::AcceptPage::accept_code) / [`set_accept_code(Option<String>)`](crate::client::fluent_builders::AcceptPage::set_accept_code): <p>The accept code is a 6-digit code used to acknowledge the page.</p>
    ///   - [`accept_code_validation(AcceptCodeValidation)`](crate::client::fluent_builders::AcceptPage::accept_code_validation) / [`set_accept_code_validation(Option<AcceptCodeValidation>)`](crate::client::fluent_builders::AcceptPage::set_accept_code_validation): <p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>  <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
    /// - On success, responds with [`AcceptPageOutput`](crate::output::AcceptPageOutput)

    /// - On failure, responds with [`SdkError<AcceptPageError>`](crate::error::AcceptPageError)
    pub fn accept_page(&self) -> fluent_builders::AcceptPage<C, M, R> {
        fluent_builders::AcceptPage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ActivateContactChannel`](crate::client::fluent_builders::ActivateContactChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_channel_id(impl Into<String>)`](crate::client::fluent_builders::ActivateContactChannel::contact_channel_id) / [`set_contact_channel_id(Option<String>)`](crate::client::fluent_builders::ActivateContactChannel::set_contact_channel_id): <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    ///   - [`activation_code(impl Into<String>)`](crate::client::fluent_builders::ActivateContactChannel::activation_code) / [`set_activation_code(Option<String>)`](crate::client::fluent_builders::ActivateContactChannel::set_activation_code): <p>The code sent to the contact channel when it was created in the contact. </p>
    /// - On success, responds with [`ActivateContactChannelOutput`](crate::output::ActivateContactChannelOutput)

    /// - On failure, responds with [`SdkError<ActivateContactChannelError>`](crate::error::ActivateContactChannelError)
    pub fn activate_contact_channel(&self) -> fluent_builders::ActivateContactChannel<C, M, R> {
        fluent_builders::ActivateContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContact`](crate::client::fluent_builders::CreateContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`alias(impl Into<String>)`](crate::client::fluent_builders::CreateContact::alias) / [`set_alias(Option<String>)`](crate::client::fluent_builders::CreateContact::set_alias): <p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. </p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateContact::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateContact::set_display_name): <p>The full name of the contact or escalation plan. </p>
    ///   - [`r#type(ContactType)`](crate::client::fluent_builders::CreateContact::r#type) / [`set_type(Option<ContactType>)`](crate::client::fluent_builders::CreateContact::set_type): <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>
    ///   - [`plan(Plan)`](crate::client::fluent_builders::CreateContact::plan) / [`set_plan(Option<Plan>)`](crate::client::fluent_builders::CreateContact::set_plan): <p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateContact::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateContact::set_tags): <p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set. </p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateContact::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateContact::set_idempotency_token): <p>A token ensuring that the operation is called only once with the specified details.</p>
    /// - On success, responds with [`CreateContactOutput`](crate::output::CreateContactOutput) with field(s):
    ///   - [`contact_arn(Option<String>)`](crate::output::CreateContactOutput::contact_arn): <p>The Amazon Resource Name (ARN) of the created contact or escalation plan.</p>
    /// - On failure, responds with [`SdkError<CreateContactError>`](crate::error::CreateContactError)
    pub fn create_contact(&self) -> fluent_builders::CreateContact<C, M, R> {
        fluent_builders::CreateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContactChannel`](crate::client::fluent_builders::CreateContactChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::CreateContactChannel::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::CreateContactChannel::set_contact_id): <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateContactChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateContactChannel::set_name): <p>The name of the contact channel.</p>
    ///   - [`r#type(ChannelType)`](crate::client::fluent_builders::CreateContactChannel::r#type) / [`set_type(Option<ChannelType>)`](crate::client::fluent_builders::CreateContactChannel::set_type): <p>Incident Manager supports three types of contact channels:</p>  <ul>   <li> <p> <code>SMS</code> </p> </li>   <li> <p> <code>VOICE</code> </p> </li>   <li> <p> <code>EMAIL</code> </p> </li>  </ul>
    ///   - [`delivery_address(ContactChannelAddress)`](crate::client::fluent_builders::CreateContactChannel::delivery_address) / [`set_delivery_address(Option<ContactChannelAddress>)`](crate::client::fluent_builders::CreateContactChannel::set_delivery_address): <p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p>  <ul>   <li> <p>SMS - '+' followed by the country code and phone number</p> </li>   <li> <p>VOICE - '+' followed by the country code and phone number</p> </li>   <li> <p>EMAIL - any standard email format</p> </li>  </ul>
    ///   - [`defer_activation(bool)`](crate::client::fluent_builders::CreateContactChannel::defer_activation) / [`set_defer_activation(Option<bool>)`](crate::client::fluent_builders::CreateContactChannel::set_defer_activation): <p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateContactChannel::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateContactChannel::set_idempotency_token): <p>A token ensuring that the operation is called only once with the specified details.</p>
    /// - On success, responds with [`CreateContactChannelOutput`](crate::output::CreateContactChannelOutput) with field(s):
    ///   - [`contact_channel_arn(Option<String>)`](crate::output::CreateContactChannelOutput::contact_channel_arn): <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    /// - On failure, responds with [`SdkError<CreateContactChannelError>`](crate::error::CreateContactChannelError)
    pub fn create_contact_channel(&self) -> fluent_builders::CreateContactChannel<C, M, R> {
        fluent_builders::CreateContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeactivateContactChannel`](crate::client::fluent_builders::DeactivateContactChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_channel_id(impl Into<String>)`](crate::client::fluent_builders::DeactivateContactChannel::contact_channel_id) / [`set_contact_channel_id(Option<String>)`](crate::client::fluent_builders::DeactivateContactChannel::set_contact_channel_id): <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
    /// - On success, responds with [`DeactivateContactChannelOutput`](crate::output::DeactivateContactChannelOutput)

    /// - On failure, responds with [`SdkError<DeactivateContactChannelError>`](crate::error::DeactivateContactChannelError)
    pub fn deactivate_contact_channel(&self) -> fluent_builders::DeactivateContactChannel<C, M, R> {
        fluent_builders::DeactivateContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContact`](crate::client::fluent_builders::DeleteContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::DeleteContact::set_contact_id): <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
    /// - On success, responds with [`DeleteContactOutput`](crate::output::DeleteContactOutput)

    /// - On failure, responds with [`SdkError<DeleteContactError>`](crate::error::DeleteContactError)
    pub fn delete_contact(&self) -> fluent_builders::DeleteContact<C, M, R> {
        fluent_builders::DeleteContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContactChannel`](crate::client::fluent_builders::DeleteContactChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_channel_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContactChannel::contact_channel_id) / [`set_contact_channel_id(Option<String>)`](crate::client::fluent_builders::DeleteContactChannel::set_contact_channel_id): <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    /// - On success, responds with [`DeleteContactChannelOutput`](crate::output::DeleteContactChannelOutput)

    /// - On failure, responds with [`SdkError<DeleteContactChannelError>`](crate::error::DeleteContactChannelError)
    pub fn delete_contact_channel(&self) -> fluent_builders::DeleteContactChannel<C, M, R> {
        fluent_builders::DeleteContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEngagement`](crate::client::fluent_builders::DescribeEngagement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engagement_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEngagement::engagement_id) / [`set_engagement_id(Option<String>)`](crate::client::fluent_builders::DescribeEngagement::set_engagement_id): <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
    /// - On success, responds with [`DescribeEngagementOutput`](crate::output::DescribeEngagementOutput) with field(s):
    ///   - [`contact_arn(Option<String>)`](crate::output::DescribeEngagementOutput::contact_arn): <p>The ARN of the escalation plan or contacts involved in the engagement.</p>
    ///   - [`engagement_arn(Option<String>)`](crate::output::DescribeEngagementOutput::engagement_arn): <p>The ARN of the engagement.</p>
    ///   - [`sender(Option<String>)`](crate::output::DescribeEngagementOutput::sender): <p>The user that started the engagement.</p>
    ///   - [`subject(Option<String>)`](crate::output::DescribeEngagementOutput::subject): <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    ///   - [`content(Option<String>)`](crate::output::DescribeEngagementOutput::content): <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    ///   - [`public_subject(Option<String>)`](crate::output::DescribeEngagementOutput::public_subject): <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    ///   - [`public_content(Option<String>)`](crate::output::DescribeEngagementOutput::public_content): <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    ///   - [`incident_id(Option<String>)`](crate::output::DescribeEngagementOutput::incident_id): <p>The ARN of the incident in which the engagement occurred.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeEngagementOutput::start_time): <p>The time that the engagement started.</p>
    ///   - [`stop_time(Option<DateTime>)`](crate::output::DescribeEngagementOutput::stop_time): <p>The time that the engagement ended.</p>
    /// - On failure, responds with [`SdkError<DescribeEngagementError>`](crate::error::DescribeEngagementError)
    pub fn describe_engagement(&self) -> fluent_builders::DescribeEngagement<C, M, R> {
        fluent_builders::DescribeEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePage`](crate::client::fluent_builders::DescribePage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_id(impl Into<String>)`](crate::client::fluent_builders::DescribePage::page_id) / [`set_page_id(Option<String>)`](crate::client::fluent_builders::DescribePage::set_page_id): <p>The ID of the engagement to a contact channel.</p>
    /// - On success, responds with [`DescribePageOutput`](crate::output::DescribePageOutput) with field(s):
    ///   - [`page_arn(Option<String>)`](crate::output::DescribePageOutput::page_arn): <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
    ///   - [`engagement_arn(Option<String>)`](crate::output::DescribePageOutput::engagement_arn): <p>The ARN of the engagement that engaged the contact channel.</p>
    ///   - [`contact_arn(Option<String>)`](crate::output::DescribePageOutput::contact_arn): <p>The ARN of the contact that was engaged.</p>
    ///   - [`sender(Option<String>)`](crate::output::DescribePageOutput::sender): <p>The user that started the engagement.</p>
    ///   - [`subject(Option<String>)`](crate::output::DescribePageOutput::subject): <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    ///   - [`content(Option<String>)`](crate::output::DescribePageOutput::content): <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    ///   - [`public_subject(Option<String>)`](crate::output::DescribePageOutput::public_subject): <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    ///   - [`public_content(Option<String>)`](crate::output::DescribePageOutput::public_content): <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    ///   - [`incident_id(Option<String>)`](crate::output::DescribePageOutput::incident_id): <p>The ARN of the incident that engaged the contact channel.</p>
    ///   - [`sent_time(Option<DateTime>)`](crate::output::DescribePageOutput::sent_time): <p>The time the engagement was sent to the contact channel.</p>
    ///   - [`read_time(Option<DateTime>)`](crate::output::DescribePageOutput::read_time): <p>The time that the contact channel acknowledged the engagement.</p>
    ///   - [`delivery_time(Option<DateTime>)`](crate::output::DescribePageOutput::delivery_time): <p>The time that the contact channel received the engagement.</p>
    /// - On failure, responds with [`SdkError<DescribePageError>`](crate::error::DescribePageError)
    pub fn describe_page(&self) -> fluent_builders::DescribePage<C, M, R> {
        fluent_builders::DescribePage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContact`](crate::client::fluent_builders::GetContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::GetContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::GetContact::set_contact_id): <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    /// - On success, responds with [`GetContactOutput`](crate::output::GetContactOutput) with field(s):
    ///   - [`contact_arn(Option<String>)`](crate::output::GetContactOutput::contact_arn): <p>The ARN of the contact or escalation plan.</p>
    ///   - [`alias(Option<String>)`](crate::output::GetContactOutput::alias): <p>The alias of the contact or escalation plan. The alias is unique and identifiable.</p>
    ///   - [`display_name(Option<String>)`](crate::output::GetContactOutput::display_name): <p>The full name of the contact or escalation plan.</p>
    ///   - [`r#type(Option<ContactType>)`](crate::output::GetContactOutput::type): <p>The type of contact, either <code>PERSONAL</code> or <code>ESCALATION</code>. </p>
    ///   - [`plan(Option<Plan>)`](crate::output::GetContactOutput::plan): <p>Details about the specific timing or stages and targets of the escalation plan or engagement plan.</p>
    /// - On failure, responds with [`SdkError<GetContactError>`](crate::error::GetContactError)
    pub fn get_contact(&self) -> fluent_builders::GetContact<C, M, R> {
        fluent_builders::GetContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContactChannel`](crate::client::fluent_builders::GetContactChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_channel_id(impl Into<String>)`](crate::client::fluent_builders::GetContactChannel::contact_channel_id) / [`set_contact_channel_id(Option<String>)`](crate::client::fluent_builders::GetContactChannel::set_contact_channel_id): <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
    /// - On success, responds with [`GetContactChannelOutput`](crate::output::GetContactChannelOutput) with field(s):
    ///   - [`contact_arn(Option<String>)`](crate::output::GetContactChannelOutput::contact_arn): <p>The ARN of the contact that the channel belongs to.</p>
    ///   - [`contact_channel_arn(Option<String>)`](crate::output::GetContactChannelOutput::contact_channel_arn): <p>The ARN of the contact channel.</p>
    ///   - [`name(Option<String>)`](crate::output::GetContactChannelOutput::name): <p>The name of the contact channel</p>
    ///   - [`r#type(Option<ChannelType>)`](crate::output::GetContactChannelOutput::type): <p>The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.</p>
    ///   - [`delivery_address(Option<ContactChannelAddress>)`](crate::output::GetContactChannelOutput::delivery_address): <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
    ///   - [`activation_status(Option<ActivationStatus>)`](crate::output::GetContactChannelOutput::activation_status): <p>A Boolean value indicating if the contact channel has been activated or not.</p>
    /// - On failure, responds with [`SdkError<GetContactChannelError>`](crate::error::GetContactChannelError)
    pub fn get_contact_channel(&self) -> fluent_builders::GetContactChannel<C, M, R> {
        fluent_builders::GetContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContactPolicy`](crate::client::fluent_builders::GetContactPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_arn(impl Into<String>)`](crate::client::fluent_builders::GetContactPolicy::contact_arn) / [`set_contact_arn(Option<String>)`](crate::client::fluent_builders::GetContactPolicy::set_contact_arn): <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    /// - On success, responds with [`GetContactPolicyOutput`](crate::output::GetContactPolicyOutput) with field(s):
    ///   - [`contact_arn(Option<String>)`](crate::output::GetContactPolicyOutput::contact_arn): <p>The ARN of the contact or escalation plan.</p>
    ///   - [`policy(Option<String>)`](crate::output::GetContactPolicyOutput::policy): <p>Details about the resource policy attached to the contact or escalation plan.</p>
    /// - On failure, responds with [`SdkError<GetContactPolicyError>`](crate::error::GetContactPolicyError)
    pub fn get_contact_policy(&self) -> fluent_builders::GetContactPolicy<C, M, R> {
        fluent_builders::GetContactPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContactChannels`](crate::client::fluent_builders::ListContactChannels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContactChannels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::ListContactChannels::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::ListContactChannels::set_contact_id): <p>The Amazon Resource Name (ARN) of the contact. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContactChannels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContactChannels::set_next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContactChannels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContactChannels::set_max_results): <p>The maximum number of contact channels per page.</p>
    /// - On success, responds with [`ListContactChannelsOutput`](crate::output::ListContactChannelsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListContactChannelsOutput::next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`contact_channels(Option<Vec<ContactChannel>>)`](crate::output::ListContactChannelsOutput::contact_channels): <p>A list of contact channels related to the specified contact.</p>
    /// - On failure, responds with [`SdkError<ListContactChannelsError>`](crate::error::ListContactChannelsError)
    pub fn list_contact_channels(&self) -> fluent_builders::ListContactChannels<C, M, R> {
        fluent_builders::ListContactChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContacts`](crate::client::fluent_builders::ListContacts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContacts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContacts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContacts::set_next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContacts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContacts::set_max_results): <p>The maximum number of contacts and escalation plans per page of results.</p>
    ///   - [`alias_prefix(impl Into<String>)`](crate::client::fluent_builders::ListContacts::alias_prefix) / [`set_alias_prefix(Option<String>)`](crate::client::fluent_builders::ListContacts::set_alias_prefix): <p>Used to list only contacts who's aliases start with the specified prefix.</p>
    ///   - [`r#type(ContactType)`](crate::client::fluent_builders::ListContacts::r#type) / [`set_type(Option<ContactType>)`](crate::client::fluent_builders::ListContacts::set_type): <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>
    /// - On success, responds with [`ListContactsOutput`](crate::output::ListContactsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListContactsOutput::next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`contacts(Option<Vec<Contact>>)`](crate::output::ListContactsOutput::contacts): <p>A list of the contacts and escalation plans in your Incident Manager account.</p>
    /// - On failure, responds with [`SdkError<ListContactsError>`](crate::error::ListContactsError)
    pub fn list_contacts(&self) -> fluent_builders::ListContacts<C, M, R> {
        fluent_builders::ListContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEngagements`](crate::client::fluent_builders::ListEngagements) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEngagements::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEngagements::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEngagements::set_next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEngagements::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEngagements::set_max_results): <p>The maximum number of engagements per page of results.</p>
    ///   - [`incident_id(impl Into<String>)`](crate::client::fluent_builders::ListEngagements::incident_id) / [`set_incident_id(Option<String>)`](crate::client::fluent_builders::ListEngagements::set_incident_id): <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
    ///   - [`time_range_value(TimeRange)`](crate::client::fluent_builders::ListEngagements::time_range_value) / [`set_time_range_value(Option<TimeRange>)`](crate::client::fluent_builders::ListEngagements::set_time_range_value): <p>The time range to lists engagements for an incident.</p>
    /// - On success, responds with [`ListEngagementsOutput`](crate::output::ListEngagementsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListEngagementsOutput::next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`engagements(Option<Vec<Engagement>>)`](crate::output::ListEngagementsOutput::engagements): <p>A list of each engagement that occurred during the specified time range of an incident.</p>
    /// - On failure, responds with [`SdkError<ListEngagementsError>`](crate::error::ListEngagementsError)
    pub fn list_engagements(&self) -> fluent_builders::ListEngagements<C, M, R> {
        fluent_builders::ListEngagements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPageReceipts`](crate::client::fluent_builders::ListPageReceipts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPageReceipts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`page_id(impl Into<String>)`](crate::client::fluent_builders::ListPageReceipts::page_id) / [`set_page_id(Option<String>)`](crate::client::fluent_builders::ListPageReceipts::set_page_id): <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPageReceipts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPageReceipts::set_next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPageReceipts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPageReceipts::set_max_results): <p>The maximum number of acknowledgements per page of results.</p>
    /// - On success, responds with [`ListPageReceiptsOutput`](crate::output::ListPageReceiptsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPageReceiptsOutput::next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`receipts(Option<Vec<Receipt>>)`](crate::output::ListPageReceiptsOutput::receipts): <p>A list of each acknowledgement.</p>
    /// - On failure, responds with [`SdkError<ListPageReceiptsError>`](crate::error::ListPageReceiptsError)
    pub fn list_page_receipts(&self) -> fluent_builders::ListPageReceipts<C, M, R> {
        fluent_builders::ListPageReceipts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPagesByContact`](crate::client::fluent_builders::ListPagesByContact) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPagesByContact::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::ListPagesByContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::ListPagesByContact::set_contact_id): <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPagesByContact::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPagesByContact::set_next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPagesByContact::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPagesByContact::set_max_results): <p>The maximum number of engagements to contact channels to list per page of results. </p>
    /// - On success, responds with [`ListPagesByContactOutput`](crate::output::ListPagesByContactOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPagesByContactOutput::next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`pages(Option<Vec<Page>>)`](crate::output::ListPagesByContactOutput::pages): <p>The list of engagements to a contact's contact channel.</p>
    /// - On failure, responds with [`SdkError<ListPagesByContactError>`](crate::error::ListPagesByContactError)
    pub fn list_pages_by_contact(&self) -> fluent_builders::ListPagesByContact<C, M, R> {
        fluent_builders::ListPagesByContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPagesByEngagement`](crate::client::fluent_builders::ListPagesByEngagement) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPagesByEngagement::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engagement_id(impl Into<String>)`](crate::client::fluent_builders::ListPagesByEngagement::engagement_id) / [`set_engagement_id(Option<String>)`](crate::client::fluent_builders::ListPagesByEngagement::set_engagement_id): <p>The Amazon Resource Name (ARN) of the engagement.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPagesByEngagement::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPagesByEngagement::set_next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPagesByEngagement::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPagesByEngagement::set_max_results): <p>The maximum number of engagements to contact channels to list per page of results.</p>
    /// - On success, responds with [`ListPagesByEngagementOutput`](crate::output::ListPagesByEngagementOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPagesByEngagementOutput::next_token): <p>The pagination token to continue to the next page of results.</p>
    ///   - [`pages(Option<Vec<Page>>)`](crate::output::ListPagesByEngagementOutput::pages): <p>The list of engagements to contact channels.</p>
    /// - On failure, responds with [`SdkError<ListPagesByEngagementError>`](crate::error::ListPagesByEngagementError)
    pub fn list_pages_by_engagement(&self) -> fluent_builders::ListPagesByEngagement<C, M, R> {
        fluent_builders::ListPagesByEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags related to the contact or escalation plan.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutContactPolicy`](crate::client::fluent_builders::PutContactPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_arn(impl Into<String>)`](crate::client::fluent_builders::PutContactPolicy::contact_arn) / [`set_contact_arn(Option<String>)`](crate::client::fluent_builders::PutContactPolicy::set_contact_arn): <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutContactPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutContactPolicy::set_policy): <p>Details of the resource policy.</p>
    /// - On success, responds with [`PutContactPolicyOutput`](crate::output::PutContactPolicyOutput)

    /// - On failure, responds with [`SdkError<PutContactPolicyError>`](crate::error::PutContactPolicyError)
    pub fn put_contact_policy(&self) -> fluent_builders::PutContactPolicy<C, M, R> {
        fluent_builders::PutContactPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendActivationCode`](crate::client::fluent_builders::SendActivationCode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_channel_id(impl Into<String>)`](crate::client::fluent_builders::SendActivationCode::contact_channel_id) / [`set_contact_channel_id(Option<String>)`](crate::client::fluent_builders::SendActivationCode::set_contact_channel_id): <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    /// - On success, responds with [`SendActivationCodeOutput`](crate::output::SendActivationCodeOutput)

    /// - On failure, responds with [`SdkError<SendActivationCodeError>`](crate::error::SendActivationCodeError)
    pub fn send_activation_code(&self) -> fluent_builders::SendActivationCode<C, M, R> {
        fluent_builders::SendActivationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartEngagement`](crate::client::fluent_builders::StartEngagement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_contact_id): <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
    ///   - [`sender(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::sender) / [`set_sender(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_sender): <p>The user that started the engagement.</p>
    ///   - [`subject(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::subject) / [`set_subject(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_subject): <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_content): <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
    ///   - [`public_subject(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::public_subject) / [`set_public_subject(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_public_subject): <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    ///   - [`public_content(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::public_content) / [`set_public_content(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_public_content): <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
    ///   - [`incident_id(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::incident_id) / [`set_incident_id(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_incident_id): <p>The ARN of the incident that the engagement is part of.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::StartEngagement::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::StartEngagement::set_idempotency_token): <p>A token ensuring that the operation is called only once with the specified details.</p>
    /// - On success, responds with [`StartEngagementOutput`](crate::output::StartEngagementOutput) with field(s):
    ///   - [`engagement_arn(Option<String>)`](crate::output::StartEngagementOutput::engagement_arn): <p>The ARN of the engagement.</p>
    /// - On failure, responds with [`SdkError<StartEngagementError>`](crate::error::StartEngagementError)
    pub fn start_engagement(&self) -> fluent_builders::StartEngagement<C, M, R> {
        fluent_builders::StartEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopEngagement`](crate::client::fluent_builders::StopEngagement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engagement_id(impl Into<String>)`](crate::client::fluent_builders::StopEngagement::engagement_id) / [`set_engagement_id(Option<String>)`](crate::client::fluent_builders::StopEngagement::set_engagement_id): <p>The Amazon Resource Name (ARN) of the engagement.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::StopEngagement::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::StopEngagement::set_reason): <p>The reason that you're stopping the engagement. </p>
    /// - On success, responds with [`StopEngagementOutput`](crate::output::StopEngagementOutput)

    /// - On failure, responds with [`SdkError<StopEngagementError>`](crate::error::StopEngagementError)
    pub fn stop_engagement(&self) -> fluent_builders::StopEngagement<C, M, R> {
        fluent_builders::StopEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags that you are adding to the contact or escalation plan.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The key of the tag that you want to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContact`](crate::client::fluent_builders::UpdateContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_contact_id): <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_display_name): <p>The full name of the contact or escalation plan.</p>
    ///   - [`plan(Plan)`](crate::client::fluent_builders::UpdateContact::plan) / [`set_plan(Option<Plan>)`](crate::client::fluent_builders::UpdateContact::set_plan): <p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. </p>
    /// - On success, responds with [`UpdateContactOutput`](crate::output::UpdateContactOutput)

    /// - On failure, responds with [`SdkError<UpdateContactError>`](crate::error::UpdateContactError)
    pub fn update_contact(&self) -> fluent_builders::UpdateContact<C, M, R> {
        fluent_builders::UpdateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactChannel`](crate::client::fluent_builders::UpdateContactChannel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_channel_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactChannel::contact_channel_id) / [`set_contact_channel_id(Option<String>)`](crate::client::fluent_builders::UpdateContactChannel::set_contact_channel_id): <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateContactChannel::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateContactChannel::set_name): <p>The name of the contact channel.</p>
    ///   - [`delivery_address(ContactChannelAddress)`](crate::client::fluent_builders::UpdateContactChannel::delivery_address) / [`set_delivery_address(Option<ContactChannelAddress>)`](crate::client::fluent_builders::UpdateContactChannel::set_delivery_address): <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
    /// - On success, responds with [`UpdateContactChannelOutput`](crate::output::UpdateContactChannelOutput)

    /// - On failure, responds with [`SdkError<UpdateContactChannelError>`](crate::error::UpdateContactChannelError)
    pub fn update_contact_channel(&self) -> fluent_builders::UpdateContactChannel<C, M, R> {
        fluent_builders::UpdateContactChannel::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptPage`.
    ///
    /// <p>Used to acknowledge an engagement to a contact channel during an incident.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptPage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_page_input::Builder,
    }
    impl<C, M, R> AcceptPage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptPage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptPageOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptPageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptPageInputOperationOutputAlias,
                crate::output::AcceptPageOutput,
                crate::error::AcceptPageError,
                crate::input::AcceptPageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn page_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_id(input);
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(input.into());
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
        /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
        pub fn accept_type(mut self, input: crate::model::AcceptType) -> Self {
            self.inner = self.inner.accept_type(input);
            self
        }
        /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
        pub fn set_accept_type(
            mut self,
            input: std::option::Option<crate::model::AcceptType>,
        ) -> Self {
            self.inner = self.inner.set_accept_type(input);
            self
        }
        /// <p>Information provided by the user when the user acknowledges the page.</p>
        pub fn note(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.note(input.into());
            self
        }
        /// <p>Information provided by the user when the user acknowledges the page.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_note(input);
            self
        }
        /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
        pub fn accept_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_code(input.into());
            self
        }
        /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
        pub fn set_accept_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_accept_code(input);
            self
        }
        /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
        /// <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
        pub fn accept_code_validation(mut self, input: crate::model::AcceptCodeValidation) -> Self {
            self.inner = self.inner.accept_code_validation(input);
            self
        }
        /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
        /// <p>Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
        pub fn set_accept_code_validation(
            mut self,
            input: std::option::Option<crate::model::AcceptCodeValidation>,
        ) -> Self {
            self.inner = self.inner.set_accept_code_validation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ActivateContactChannel`.
    ///
    /// <p>Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been activated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_contact_channel_input::Builder,
    }
    impl<C, M, R> ActivateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateContactChannelInputOperationOutputAlias,
                crate::output::ActivateContactChannelOutput,
                crate::error::ActivateContactChannelError,
                crate::input::ActivateContactChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
        /// <p>The code sent to the contact channel when it was created in the contact. </p>
        pub fn activation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_code(input.into());
            self
        }
        /// <p>The code sent to the contact channel when it was created in the contact. </p>
        pub fn set_activation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContact`.
    ///
    /// <p>Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_input::Builder,
    }
    impl<C, M, R> CreateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactInputOperationOutputAlias,
                crate::output::CreateContactOutput,
                crate::error::CreateContactError,
                crate::input::CreateContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. </p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(input.into());
            self
        }
        /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must be unique and identifiable. </p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The full name of the contact or escalation plan. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The full name of the contact or escalation plan. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>
        pub fn r#type(mut self, input: crate::model::ContactType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. </p>
        pub fn plan(mut self, input: crate::model::Plan) -> Self {
            self.inner = self.inner.plan(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts. </p>
        pub fn set_plan(mut self, input: std::option::Option<crate::model::Plan>) -> Self {
            self.inner = self.inner.set_plan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your replication set. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactChannel`.
    ///
    /// <p>A contact channel is the method that Incident Manager uses to engage your contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_channel_input::Builder,
    }
    impl<C, M, R> CreateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactChannelInputOperationOutputAlias,
                crate::output::CreateContactChannelOutput,
                crate::error::CreateContactChannelError,
                crate::input::CreateContactChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Incident Manager supports three types of contact channels:</p>
        /// <ul>
        /// <li> <p> <code>SMS</code> </p> </li>
        /// <li> <p> <code>VOICE</code> </p> </li>
        /// <li> <p> <code>EMAIL</code> </p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Incident Manager supports three types of contact channels:</p>
        /// <ul>
        /// <li> <p> <code>SMS</code> </p> </li>
        /// <li> <p> <code>VOICE</code> </p> </li>
        /// <li> <p> <code>EMAIL</code> </p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p>
        /// <ul>
        /// <li> <p>SMS - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>VOICE - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>EMAIL - any standard email format</p> </li>
        /// </ul>
        pub fn delivery_address(mut self, input: crate::model::ContactChannelAddress) -> Self {
            self.inner = self.inner.delivery_address(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:</p>
        /// <ul>
        /// <li> <p>SMS - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>VOICE - '+' followed by the country code and phone number</p> </li>
        /// <li> <p>EMAIL - any standard email format</p> </li>
        /// </ul>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.inner = self.inner.set_delivery_address(input);
            self
        }
        /// <p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.</p>
        pub fn defer_activation(mut self, input: bool) -> Self {
            self.inner = self.inner.defer_activation(input);
            self
        }
        /// <p>If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.</p>
        pub fn set_defer_activation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_defer_activation(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateContactChannel`.
    ///
    /// <p>To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeactivateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_contact_channel_input::Builder,
    }
    impl<C, M, R> DeactivateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivateContactChannelInputOperationOutputAlias,
                crate::output::DeactivateContactChannelOutput,
                crate::error::DeactivateContactChannelError,
                crate::input::DeactivateContactChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContact`.
    ///
    /// <p>To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_input::Builder,
    }
    impl<C, M, R> DeleteContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactInputOperationOutputAlias,
                crate::output::DeleteContactOutput,
                crate::error::DeleteContactError,
                crate::input::DeleteContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactChannel`.
    ///
    /// <p>To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a contact, you won't be able to engage that contact during an incident.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_channel_input::Builder,
    }
    impl<C, M, R> DeleteContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactChannelInputOperationOutputAlias,
                crate::output::DeleteContactChannelOutput,
                crate::error::DeleteContactChannelError,
                crate::input::DeleteContactChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngagement`.
    ///
    /// <p>Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engagement_input::Builder,
    }
    impl<C, M, R> DescribeEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngagementInputOperationOutputAlias,
                crate::output::DescribeEngagementOutput,
                crate::error::DescribeEngagementError,
                crate::input::DescribeEngagementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
        pub fn engagement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engagement_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engagement_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePage`.
    ///
    /// <p>Lists details of the engagement to a contact channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_page_input::Builder,
    }
    impl<C, M, R> DescribePage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePageInputOperationOutputAlias,
                crate::output::DescribePageOutput,
                crate::error::DescribePageError,
                crate::input::DescribePageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the engagement to a contact channel.</p>
        pub fn page_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_id(input.into());
            self
        }
        /// <p>The ID of the engagement to a contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContact`.
    ///
    /// <p>Retrieves information about the specified contact or escalation plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_input::Builder,
    }
    impl<C, M, R> GetContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactInputOperationOutputAlias,
                crate::output::GetContactOutput,
                crate::error::GetContactError,
                crate::input::GetContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactChannel`.
    ///
    /// <p>List details about a specific contact channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_channel_input::Builder,
    }
    impl<C, M, R> GetContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactChannelInputOperationOutputAlias,
                crate::output::GetContactChannelOutput,
                crate::error::GetContactChannelError,
                crate::input::GetContactChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactPolicy`.
    ///
    /// <p>Retrieves the resource policies attached to the specified contact or escalation plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContactPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_policy_input::Builder,
    }
    impl<C, M, R> GetContactPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactPolicyInputOperationOutputAlias,
                crate::output::GetContactPolicyOutput,
                crate::error::GetContactPolicyError,
                crate::input::GetContactPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactChannels`.
    ///
    /// <p>Lists all contact channels for the specified contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContactChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_channels_input::Builder,
    }
    impl<C, M, R> ListContactChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactChannelsInputOperationOutputAlias,
                crate::output::ListContactChannelsOutput,
                crate::error::ListContactChannelsError,
                crate::input::ListContactChannelsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactChannelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactChannelsPaginator<C, M, R> {
            crate::paginator::ListContactChannelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the contact. </p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact. </p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of contact channels per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of contact channels per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContacts`.
    ///
    /// <p>Lists all contacts and escalation plans in Incident Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContacts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contacts_input::Builder,
    }
    impl<C, M, R> ListContacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactsInputOperationOutputAlias,
                crate::output::ListContactsOutput,
                crate::error::ListContactsError,
                crate::input::ListContactsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactsPaginator<C, M, R> {
            crate::paginator::ListContactsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of contacts and escalation plans per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of contacts and escalation plans per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
        pub fn alias_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_prefix(input.into());
            self
        }
        /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
        pub fn set_alias_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_prefix(input);
            self
        }
        /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>
        pub fn r#type(mut self, input: crate::model::ContactType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEngagements`.
    ///
    /// <p>Lists all engagements that have happened in an incident.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEngagements<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_engagements_input::Builder,
    }
    impl<C, M, R> ListEngagements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEngagements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEngagementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEngagementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEngagementsInputOperationOutputAlias,
                crate::output::ListEngagementsOutput,
                crate::error::ListEngagementsError,
                crate::input::ListEngagementsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEngagementsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEngagementsPaginator<C, M, R> {
            crate::paginator::ListEngagementsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of engagements per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of engagements per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_incident_id(input);
            self
        }
        /// <p>The time range to lists engagements for an incident.</p>
        pub fn time_range_value(mut self, input: crate::model::TimeRange) -> Self {
            self.inner = self.inner.time_range_value(input);
            self
        }
        /// <p>The time range to lists engagements for an incident.</p>
        pub fn set_time_range_value(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_time_range_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPageReceipts`.
    ///
    /// <p>Lists all of the engagements to contact channels that have been acknowledged. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPageReceipts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_page_receipts_input::Builder,
    }
    impl<C, M, R> ListPageReceipts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPageReceipts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPageReceiptsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPageReceiptsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPageReceiptsInputOperationOutputAlias,
                crate::output::ListPageReceiptsOutput,
                crate::error::ListPageReceiptsError,
                crate::input::ListPageReceiptsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPageReceiptsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPageReceiptsPaginator<C, M, R> {
            crate::paginator::ListPageReceiptsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
        pub fn page_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of acknowledgements per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of acknowledgements per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPagesByContact`.
    ///
    /// <p>Lists the engagements to a contact's contact channels.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPagesByContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pages_by_contact_input::Builder,
    }
    impl<C, M, R> ListPagesByContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPagesByContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPagesByContactOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPagesByContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPagesByContactInputOperationOutputAlias,
                crate::output::ListPagesByContactOutput,
                crate::error::ListPagesByContactError,
                crate::input::ListPagesByContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPagesByContactPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPagesByContactPaginator<C, M, R> {
            crate::paginator::ListPagesByContactPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPagesByEngagement`.
    ///
    /// <p>Lists the engagements to contact channels that occurred by engaging a contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPagesByEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pages_by_engagement_input::Builder,
    }
    impl<C, M, R> ListPagesByEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPagesByEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPagesByEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPagesByEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPagesByEngagementInputOperationOutputAlias,
                crate::output::ListPagesByEngagementOutput,
                crate::error::ListPagesByEngagementError,
                crate::input::ListPagesByEngagementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPagesByEngagementPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPagesByEngagementPaginator<C, M, R> {
            crate::paginator::ListPagesByEngagementPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn engagement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engagement_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engagement_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags of an escalation plan or contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutContactPolicy`.
    ///
    /// <p>Adds a resource to the specified contact or escalation plan.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutContactPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_contact_policy_input::Builder,
    }
    impl<C, M, R> PutContactPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutContactPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutContactPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutContactPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutContactPolicyInputOperationOutputAlias,
                crate::output::PutContactPolicyOutput,
                crate::error::PutContactPolicyError,
                crate::input::PutContactPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendActivationCode`.
    ///
    /// <p>Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the <code>ActivateChannel</code> operation. Incident Manager can't engage a contact channel until it has been activated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendActivationCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_activation_code_input::Builder,
    }
    impl<C, M, R> SendActivationCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendActivationCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendActivationCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::SendActivationCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendActivationCodeInputOperationOutputAlias,
                crate::output::SendActivationCodeOutput,
                crate::error::SendActivationCodeError,
                crate::input::SendActivationCodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartEngagement`.
    ///
    /// <p>Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_engagement_input::Builder,
    }
    impl<C, M, R> StartEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::StartEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartEngagementInputOperationOutputAlias,
                crate::output::StartEngagementOutput,
                crate::error::StartEngagementError,
                crate::input::StartEngagementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sender(input.into());
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sender(input);
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subject(input.into());
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subject(input);
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn public_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_subject(input.into());
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn set_public_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_subject(input);
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn public_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_content(input.into());
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for engagements to <code>SMS</code>.</p>
        pub fn set_public_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_content(input);
            self
        }
        /// <p>The ARN of the incident that the engagement is part of.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_id(input.into());
            self
        }
        /// <p>The ARN of the incident that the engagement is part of.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_incident_id(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopEngagement`.
    ///
    /// <p>Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren't engaged.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_engagement_input::Builder,
    }
    impl<C, M, R> StopEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::StopEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopEngagementInputOperationOutputAlias,
                crate::output::StopEngagementOutput,
                crate::error::StopEngagementError,
                crate::input::StopEngagementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn engagement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engagement_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engagement_id(input);
            self
        }
        /// <p>The reason that you're stopping the engagement. </p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>The reason that you're stopping the engagement. </p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your replication set. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the specified resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag that you want to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The key of the tag that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContact`.
    ///
    /// <p>Updates the contact or escalation plan specified. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_input::Builder,
    }
    impl<C, M, R> UpdateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactInputOperationOutputAlias,
                crate::output::UpdateContactOutput,
                crate::error::UpdateContactError,
                crate::input::UpdateContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. </p>
        pub fn plan(mut self, input: crate::model::Plan) -> Self {
            self.inner = self.inner.plan(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages for specified contact channels. An escalation plan uses these stages to contact specified contacts. </p>
        pub fn set_plan(mut self, input: std::option::Option<crate::model::Plan>) -> Self {
            self.inner = self.inner.set_plan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactChannel`.
    ///
    /// <p>Updates a contact's contact channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_channel_input::Builder,
    }
    impl<C, M, R> UpdateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactChannelInputOperationOutputAlias,
                crate::output::UpdateContactChannelOutput,
                crate::error::UpdateContactChannelError,
                crate::input::UpdateContactChannelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn delivery_address(mut self, input: crate::model::ContactChannelAddress) -> Self {
            self.inner = self.inner.delivery_address(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.inner = self.inner.set_delivery_address(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
