// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptPage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptPageError {
    /// Kind of error that occurred.
    pub kind: AcceptPageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptPage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptPageErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptPageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptPageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AcceptPageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AcceptPageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AcceptPageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AcceptPageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AcceptPageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptPageError {
    fn code(&self) -> Option<&str> {
        AcceptPageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptPageError {
    /// Creates a new `AcceptPageError`.
    pub fn new(kind: AcceptPageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptPageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptPageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptPageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptPageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptPageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AcceptPageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AcceptPageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, AcceptPageErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `AcceptPageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptPageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptPageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AcceptPageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `AcceptPageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AcceptPageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AcceptPageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptPageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AcceptPageErrorKind::InternalServerException(_inner) => Some(_inner),
            AcceptPageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AcceptPageErrorKind::ThrottlingException(_inner) => Some(_inner),
            AcceptPageErrorKind::ValidationException(_inner) => Some(_inner),
            AcceptPageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ActivateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ActivateContactChannelError {
    /// Kind of error that occurred.
    pub kind: ActivateContactChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ActivateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ActivateContactChannelErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ActivateContactChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ActivateContactChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ActivateContactChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ActivateContactChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ActivateContactChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ActivateContactChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ActivateContactChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ActivateContactChannelError {
    fn code(&self) -> Option<&str> {
        ActivateContactChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ActivateContactChannelError {
    /// Creates a new `ActivateContactChannelError`.
    pub fn new(kind: ActivateContactChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ActivateContactChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ActivateContactChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ActivateContactChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ActivateContactChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ActivateContactChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateContactChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateContactChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateContactChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateContactChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateContactChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateContactChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateContactChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateContactChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateContactChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ActivateContactChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ActivateContactChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ActivateContactChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            ActivateContactChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ActivateContactChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            ActivateContactChannelErrorKind::ValidationException(_inner) => Some(_inner),
            ActivateContactChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContactError {
    /// Kind of error that occurred.
    pub kind: CreateContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContactErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContactError {
    fn code(&self) -> Option<&str> {
        CreateContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContactError {
    /// Creates a new `CreateContactError`.
    pub fn new(kind: CreateContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateContactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateContactErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateContactErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateContactErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateContactErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateContactErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateContactErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateContactErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateContactErrorKind::ConflictException(_inner) => Some(_inner),
            CreateContactErrorKind::DataEncryptionException(_inner) => Some(_inner),
            CreateContactErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateContactErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateContactErrorKind::ValidationException(_inner) => Some(_inner),
            CreateContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContactChannelError {
    /// Kind of error that occurred.
    pub kind: CreateContactChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContactChannelErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContactChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContactChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateContactChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateContactChannelErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            CreateContactChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateContactChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateContactChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateContactChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContactChannelError {
    fn code(&self) -> Option<&str> {
        CreateContactChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContactChannelError {
    /// Creates a new `CreateContactChannelError`.
    pub fn new(kind: CreateContactChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContactChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContactChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContactChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContactChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateContactChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactChannelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactChannelErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactChannelErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateContactChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContactChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateContactChannelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateContactChannelErrorKind::DataEncryptionException(_inner) => Some(_inner),
            CreateContactChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateContactChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateContactChannelErrorKind::ValidationException(_inner) => Some(_inner),
            CreateContactChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeactivateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeactivateContactChannelError {
    /// Kind of error that occurred.
    pub kind: DeactivateContactChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeactivateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeactivateContactChannelErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeactivateContactChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeactivateContactChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeactivateContactChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeactivateContactChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeactivateContactChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeactivateContactChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeactivateContactChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeactivateContactChannelError {
    fn code(&self) -> Option<&str> {
        DeactivateContactChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeactivateContactChannelError {
    /// Creates a new `DeactivateContactChannelError`.
    pub fn new(kind: DeactivateContactChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeactivateContactChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeactivateContactChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeactivateContactChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeactivateContactChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeactivateContactChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateContactChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateContactChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateContactChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateContactChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateContactChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateContactChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateContactChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateContactChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateContactChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeactivateContactChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeactivateContactChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeactivateContactChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeactivateContactChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeactivateContactChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeactivateContactChannelErrorKind::ValidationException(_inner) => Some(_inner),
            DeactivateContactChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContactError {
    /// Kind of error that occurred.
    pub kind: DeleteContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContactErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteContactErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteContactErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContactError {
    fn code(&self) -> Option<&str> {
        DeleteContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContactError {
    /// Creates a new `DeleteContactError`.
    pub fn new(kind: DeleteContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteContactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteContactErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteContactErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteContactErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteContactErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteContactErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteContactErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteContactErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContactChannelError {
    /// Kind of error that occurred.
    pub kind: DeleteContactChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContactChannelErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContactChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContactChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteContactChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteContactChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteContactChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteContactChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteContactChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContactChannelError {
    fn code(&self) -> Option<&str> {
        DeleteContactChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContactChannelError {
    /// Creates a new `DeleteContactChannelError`.
    pub fn new(kind: DeleteContactChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContactChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContactChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContactChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContactChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteContactChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteContactChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContactChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteContactChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteContactChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteContactChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteContactChannelErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteContactChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEngagementError {
    /// Kind of error that occurred.
    pub kind: DescribeEngagementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEngagementErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEngagementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEngagementErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeEngagementErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            DescribeEngagementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeEngagementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeEngagementErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeEngagementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeEngagementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEngagementError {
    fn code(&self) -> Option<&str> {
        DescribeEngagementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEngagementError {
    /// Creates a new `DescribeEngagementError`.
    pub fn new(kind: DescribeEngagementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEngagementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEngagementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEngagementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEngagementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEngagementErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngagementErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEngagementErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngagementErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEngagementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngagementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEngagementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngagementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEngagementErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngagementErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEngagementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEngagementErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeEngagementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEngagementErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeEngagementErrorKind::DataEncryptionException(_inner) => Some(_inner),
            DescribeEngagementErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeEngagementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeEngagementErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeEngagementErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeEngagementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePageError {
    /// Kind of error that occurred.
    pub kind: DescribePageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePageErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePageErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            DescribePageErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePageErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePageError {
    fn code(&self) -> Option<&str> {
        DescribePageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePageError {
    /// Creates a new `DescribePageError`.
    pub fn new(kind: DescribePageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribePageErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribePageErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePageErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePageErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePageErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePageErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePageErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribePageErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribePageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribePageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribePageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePageErrorKind::DataEncryptionException(_inner) => Some(_inner),
            DescribePageErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePageErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePageErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContactError {
    /// Kind of error that occurred.
    pub kind: GetContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContactErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContactErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            GetContactErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetContactErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContactError {
    fn code(&self) -> Option<&str> {
        GetContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContactError {
    /// Creates a new `GetContactError`.
    pub fn new(kind: GetContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetContactErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetContactErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(&self.kind, GetContactErrorKind::DataEncryptionException(_))
    }
    /// Returns `true` if the error kind is `GetContactErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetContactErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetContactErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetContactErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetContactErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContactErrorKind::DataEncryptionException(_inner) => Some(_inner),
            GetContactErrorKind::InternalServerException(_inner) => Some(_inner),
            GetContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetContactErrorKind::ValidationException(_inner) => Some(_inner),
            GetContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContactChannelError {
    /// Kind of error that occurred.
    pub kind: GetContactChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContactChannelErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContactChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContactChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContactChannelErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            GetContactChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetContactChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetContactChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetContactChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetContactChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContactChannelError {
    fn code(&self) -> Option<&str> {
        GetContactChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContactChannelError {
    /// Creates a new `GetContactChannelError`.
    pub fn new(kind: GetContactChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContactChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContactChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContactChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContactChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContactChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactChannelErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactChannelErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetContactChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContactChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContactChannelErrorKind::DataEncryptionException(_inner) => Some(_inner),
            GetContactChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            GetContactChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetContactChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetContactChannelErrorKind::ValidationException(_inner) => Some(_inner),
            GetContactChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContactPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContactPolicyError {
    /// Kind of error that occurred.
    pub kind: GetContactPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContactPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContactPolicyErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContactPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContactPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContactPolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetContactPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetContactPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetContactPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetContactPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContactPolicyError {
    fn code(&self) -> Option<&str> {
        GetContactPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContactPolicyError {
    /// Creates a new `GetContactPolicyError`.
    pub fn new(kind: GetContactPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContactPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContactPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContactPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContactPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContactPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetContactPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContactPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContactPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetContactPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetContactPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetContactPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            GetContactPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContactChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContactChannelsError {
    /// Kind of error that occurred.
    pub kind: ListContactChannelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContactChannels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContactChannelsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContactChannelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContactChannelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListContactChannelsErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            ListContactChannelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListContactChannelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListContactChannelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListContactChannelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListContactChannelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContactChannelsError {
    fn code(&self) -> Option<&str> {
        ListContactChannelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContactChannelsError {
    /// Creates a new `ListContactChannelsError`.
    pub fn new(kind: ListContactChannelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContactChannelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContactChannelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContactChannelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContactChannelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListContactChannelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactChannelsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactChannelsErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactChannelsErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactChannelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactChannelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactChannelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactChannelsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactChannelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactChannelsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactChannelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactChannelsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListContactChannelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContactChannelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListContactChannelsErrorKind::DataEncryptionException(_inner) => Some(_inner),
            ListContactChannelsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListContactChannelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListContactChannelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListContactChannelsErrorKind::ValidationException(_inner) => Some(_inner),
            ListContactChannelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContactsError {
    /// Kind of error that occurred.
    pub kind: ListContactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContactsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContactsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListContactsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListContactsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListContactsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListContactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContactsError {
    fn code(&self) -> Option<&str> {
        ListContactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContactsError {
    /// Creates a new `ListContactsError`.
    pub fn new(kind: ListContactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListContactsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListContactsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListContactsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListContactsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListContactsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListContactsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListContactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContactsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListContactsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListContactsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListContactsErrorKind::ValidationException(_inner) => Some(_inner),
            ListContactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEngagements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEngagementsError {
    /// Kind of error that occurred.
    pub kind: ListEngagementsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEngagements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEngagementsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEngagementsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEngagementsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEngagementsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEngagementsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEngagementsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEngagementsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEngagementsError {
    fn code(&self) -> Option<&str> {
        ListEngagementsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEngagementsError {
    /// Creates a new `ListEngagementsError`.
    pub fn new(kind: ListEngagementsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEngagementsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEngagementsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEngagementsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEngagementsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEngagementsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEngagementsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEngagementsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEngagementsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEngagementsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListEngagementsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListEngagementsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListEngagementsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListEngagementsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEngagementsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEngagementsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEngagementsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEngagementsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEngagementsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPageReceipts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPageReceiptsError {
    /// Kind of error that occurred.
    pub kind: ListPageReceiptsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPageReceipts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPageReceiptsErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPageReceiptsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPageReceiptsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPageReceiptsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPageReceiptsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPageReceiptsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPageReceiptsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPageReceiptsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPageReceiptsError {
    fn code(&self) -> Option<&str> {
        ListPageReceiptsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPageReceiptsError {
    /// Creates a new `ListPageReceiptsError`.
    pub fn new(kind: ListPageReceiptsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPageReceiptsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPageReceiptsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPageReceiptsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPageReceiptsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPageReceiptsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPageReceiptsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPageReceiptsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPageReceiptsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPageReceiptsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPageReceiptsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPageReceiptsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPageReceiptsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPageReceiptsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPageReceiptsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPageReceiptsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPageReceiptsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPageReceiptsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPageReceiptsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPageReceiptsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPageReceiptsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPageReceiptsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPagesByContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPagesByContactError {
    /// Kind of error that occurred.
    pub kind: ListPagesByContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPagesByContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPagesByContactErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPagesByContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPagesByContactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPagesByContactErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPagesByContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPagesByContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPagesByContactErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPagesByContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPagesByContactError {
    fn code(&self) -> Option<&str> {
        ListPagesByContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPagesByContactError {
    /// Creates a new `ListPagesByContactError`.
    pub fn new(kind: ListPagesByContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPagesByContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPagesByContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPagesByContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPagesByContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPagesByContactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByContactErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByContactErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByContactErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByContactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByContactErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByContactErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByContactErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPagesByContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPagesByContactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPagesByContactErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPagesByContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPagesByContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPagesByContactErrorKind::ValidationException(_inner) => Some(_inner),
            ListPagesByContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPagesByEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPagesByEngagementError {
    /// Kind of error that occurred.
    pub kind: ListPagesByEngagementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPagesByEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPagesByEngagementErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPagesByEngagementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPagesByEngagementErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPagesByEngagementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPagesByEngagementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPagesByEngagementErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPagesByEngagementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPagesByEngagementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPagesByEngagementError {
    fn code(&self) -> Option<&str> {
        ListPagesByEngagementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPagesByEngagementError {
    /// Creates a new `ListPagesByEngagementError`.
    pub fn new(kind: ListPagesByEngagementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPagesByEngagementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPagesByEngagementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPagesByEngagementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPagesByEngagementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPagesByEngagementErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByEngagementErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByEngagementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByEngagementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByEngagementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByEngagementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByEngagementErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByEngagementErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPagesByEngagementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPagesByEngagementErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPagesByEngagementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPagesByEngagementErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPagesByEngagementErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPagesByEngagementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPagesByEngagementErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPagesByEngagementErrorKind::ValidationException(_inner) => Some(_inner),
            ListPagesByEngagementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutContactPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutContactPolicyError {
    /// Kind of error that occurred.
    pub kind: PutContactPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutContactPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutContactPolicyErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutContactPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutContactPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutContactPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutContactPolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutContactPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutContactPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutContactPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutContactPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutContactPolicyError {
    fn code(&self) -> Option<&str> {
        PutContactPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutContactPolicyError {
    /// Creates a new `PutContactPolicyError`.
    pub fn new(kind: PutContactPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutContactPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutContactPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutContactPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutContactPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutContactPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutContactPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutContactPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutContactPolicyErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutContactPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutContactPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutContactPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutContactPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutContactPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutContactPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutContactPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutContactPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutContactPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutContactPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutContactPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            PutContactPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutContactPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutContactPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutContactPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutContactPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendActivationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendActivationCodeError {
    /// Kind of error that occurred.
    pub kind: SendActivationCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendActivationCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendActivationCodeErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendActivationCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendActivationCodeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SendActivationCodeErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            SendActivationCodeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SendActivationCodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SendActivationCodeErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            SendActivationCodeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendActivationCodeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SendActivationCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendActivationCodeError {
    fn code(&self) -> Option<&str> {
        SendActivationCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendActivationCodeError {
    /// Creates a new `SendActivationCodeError`.
    pub fn new(kind: SendActivationCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendActivationCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendActivationCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendActivationCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendActivationCodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendActivationCodeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendActivationCodeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendActivationCodeErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendActivationCodeErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `SendActivationCodeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendActivationCodeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SendActivationCodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendActivationCodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendActivationCodeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendActivationCodeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `SendActivationCodeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendActivationCodeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `SendActivationCodeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendActivationCodeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for SendActivationCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendActivationCodeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SendActivationCodeErrorKind::DataEncryptionException(_inner) => Some(_inner),
            SendActivationCodeErrorKind::InternalServerException(_inner) => Some(_inner),
            SendActivationCodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SendActivationCodeErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            SendActivationCodeErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendActivationCodeErrorKind::ValidationException(_inner) => Some(_inner),
            SendActivationCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartEngagementError {
    /// Kind of error that occurred.
    pub kind: StartEngagementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartEngagementErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartEngagementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartEngagementErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartEngagementErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            StartEngagementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartEngagementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartEngagementErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartEngagementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartEngagementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartEngagementError {
    fn code(&self) -> Option<&str> {
        StartEngagementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartEngagementError {
    /// Creates a new `StartEngagementError`.
    pub fn new(kind: StartEngagementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartEngagementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartEngagementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartEngagementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartEngagementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartEngagementErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEngagementErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEngagementErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEngagementErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEngagementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEngagementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEngagementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartEngagementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartEngagementErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartEngagementErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartEngagementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartEngagementErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartEngagementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartEngagementErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartEngagementErrorKind::DataEncryptionException(_inner) => Some(_inner),
            StartEngagementErrorKind::InternalServerException(_inner) => Some(_inner),
            StartEngagementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartEngagementErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartEngagementErrorKind::ValidationException(_inner) => Some(_inner),
            StartEngagementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopEngagementError {
    /// Kind of error that occurred.
    pub kind: StopEngagementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopEngagement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopEngagementErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopEngagementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopEngagementErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopEngagementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopEngagementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopEngagementErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopEngagementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopEngagementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopEngagementError {
    fn code(&self) -> Option<&str> {
        StopEngagementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopEngagementError {
    /// Creates a new `StopEngagementError`.
    pub fn new(kind: StopEngagementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopEngagementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopEngagementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopEngagementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopEngagementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopEngagementErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEngagementErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopEngagementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEngagementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopEngagementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopEngagementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopEngagementErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StopEngagementErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StopEngagementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StopEngagementErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StopEngagementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopEngagementErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopEngagementErrorKind::InternalServerException(_inner) => Some(_inner),
            StopEngagementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopEngagementErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopEngagementErrorKind::ValidationException(_inner) => Some(_inner),
            StopEngagementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactError {
    /// Kind of error that occurred.
    pub kind: UpdateContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactError {
    fn code(&self) -> Option<&str> {
        UpdateContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactError {
    /// Creates a new `UpdateContactError`.
    pub fn new(kind: UpdateContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateContactErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateContactErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateContactErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateContactErrorKind::DataEncryptionException(_inner) => Some(_inner),
            UpdateContactErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContactErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateContactErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactChannelError {
    /// Kind of error that occurred.
    pub kind: UpdateContactChannelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContactChannel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactChannelErrorKind {
    /// <p>You don't have sufficient access to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Updating or deleting a resource causes an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The operation failed to due an encryption key error.</p>
    DataEncryptionException(crate::error::DataEncryptionException),
    /// <p>Unexpected error occurred while
    /// processing the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request references a resource that doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
    /// service.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactChannelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactChannelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateContactChannelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateContactChannelErrorKind::DataEncryptionException(_inner) => _inner.fmt(f),
            UpdateContactChannelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateContactChannelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContactChannelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateContactChannelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateContactChannelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactChannelError {
    fn code(&self) -> Option<&str> {
        UpdateContactChannelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactChannelError {
    /// Creates a new `UpdateContactChannelError`.
    pub fn new(kind: UpdateContactChannelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactChannelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactChannelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactChannelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactChannelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContactChannelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactChannelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactChannelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactChannelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactChannelErrorKind::DataEncryptionException`.
    pub fn is_data_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactChannelErrorKind::DataEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactChannelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactChannelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactChannelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactChannelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactChannelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactChannelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactChannelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactChannelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateContactChannelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactChannelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateContactChannelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateContactChannelErrorKind::DataEncryptionException(_inner) => Some(_inner),
            UpdateContactChannelErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateContactChannelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContactChannelErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateContactChannelErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateContactChannelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input fails to satisfy the constraints specified by an Amazon Web Services
/// service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Reason the request failed validation
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// The fields that caused the error
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// Reason the request failed validation
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// The fields that caused the error
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Reason the request failed validation
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// Reason the request failed validation
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// The fields that caused the error
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// The fields that caused the error
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating service
    pub quota_code: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating quota
    pub service_code: std::option::Option<std::string::String>,
    /// Advice to clients on when the call can be safely retried
    pub retry_after_seconds: i32,
}
impl ThrottlingException {
    /// Service Quotas requirement to identify originating service
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// Service Quotas requirement to identify originating quota
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// Advice to clients on when the call can be safely retried
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Service Quotas requirement to identify originating service
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating service
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Service Quotas requirement to identify originating quota
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating quota
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                quota_code: self.quota_code,
                service_code: self.service_code,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Request references a resource that doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Hypothetical resource identifier that was not found
    pub resource_id: std::option::Option<std::string::String>,
    /// Hypothetical resource type that was not found
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// Hypothetical resource identifier that was not found
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// Hypothetical resource type that was not found
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Hypothetical resource identifier that was not found
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Hypothetical resource identifier that was not found
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Hypothetical resource type that was not found
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Hypothetical resource type that was not found
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Unexpected error occurred while
/// processing the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Advice to clients on when the call can be safely retried
    pub retry_after_seconds: i32,
}
impl InternalServerException {
    /// Advice to clients on when the call can be safely retried
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The operation failed to due an encryption key error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataEncryptionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataEncryptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataEncryptionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DataEncryptionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DataEncryptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DataEncryptionException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DataEncryptionException {}
/// See [`DataEncryptionException`](crate::error::DataEncryptionException)
pub mod data_encryption_exception {
    /// A builder for [`DataEncryptionException`](crate::error::DataEncryptionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataEncryptionException`](crate::error::DataEncryptionException)
        pub fn build(self) -> crate::error::DataEncryptionException {
            crate::error::DataEncryptionException {
                message: self.message,
            }
        }
    }
}
impl DataEncryptionException {
    /// Creates a new builder-style object to manufacture [`DataEncryptionException`](crate::error::DataEncryptionException)
    pub fn builder() -> crate::error::data_encryption_exception::Builder {
        crate::error::data_encryption_exception::Builder::default()
    }
}

/// <p>Updating or deleting a resource causes an inconsistent state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Identifier of the resource in use
    pub resource_id: std::option::Option<std::string::String>,
    /// ype of the resource in use
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// Identifier of the resource in use
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// ype of the resource in use
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Identifier of the resource in use
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Identifier of the resource in use
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// ype of the resource in use
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// ype of the resource in use
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You don't have sufficient access to perform this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>Request would cause a service quota to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Identifier of the resource affected
    pub resource_id: std::option::Option<std::string::String>,
    /// Type of the resource affected
    pub resource_type: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating service
    pub quota_code: std::option::Option<std::string::String>,
    /// Service Quotas requirement to identify originating quota
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// Identifier of the resource affected
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// Type of the resource affected
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// Service Quotas requirement to identify originating service
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// Service Quotas requirement to identify originating quota
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Identifier of the resource affected
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Identifier of the resource affected
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Type of the resource affected
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Type of the resource affected
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Service Quotas requirement to identify originating service
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating service
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Service Quotas requirement to identify originating quota
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// Service Quotas requirement to identify originating quota
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
