// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `SSMContacts`.
///
/// This client allows ergonomic access to a `SSMContacts`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptPage` operation.
    ///
    /// See [`AcceptPage`](crate::client::fluent_builders::AcceptPage) for more information about the
    /// operation and its arguments.
    pub fn accept_page(&self) -> fluent_builders::AcceptPage<C, M, R> {
        fluent_builders::AcceptPage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ActivateContactChannel` operation.
    ///
    /// See [`ActivateContactChannel`](crate::client::fluent_builders::ActivateContactChannel) for more information about the
    /// operation and its arguments.
    pub fn activate_contact_channel(&self) -> fluent_builders::ActivateContactChannel<C, M, R> {
        fluent_builders::ActivateContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContact` operation.
    ///
    /// See [`CreateContact`](crate::client::fluent_builders::CreateContact) for more information about the
    /// operation and its arguments.
    pub fn create_contact(&self) -> fluent_builders::CreateContact<C, M, R> {
        fluent_builders::CreateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContactChannel` operation.
    ///
    /// See [`CreateContactChannel`](crate::client::fluent_builders::CreateContactChannel) for more information about the
    /// operation and its arguments.
    pub fn create_contact_channel(&self) -> fluent_builders::CreateContactChannel<C, M, R> {
        fluent_builders::CreateContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeactivateContactChannel` operation.
    ///
    /// See [`DeactivateContactChannel`](crate::client::fluent_builders::DeactivateContactChannel) for more information about the
    /// operation and its arguments.
    pub fn deactivate_contact_channel(&self) -> fluent_builders::DeactivateContactChannel<C, M, R> {
        fluent_builders::DeactivateContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContact` operation.
    ///
    /// See [`DeleteContact`](crate::client::fluent_builders::DeleteContact) for more information about the
    /// operation and its arguments.
    pub fn delete_contact(&self) -> fluent_builders::DeleteContact<C, M, R> {
        fluent_builders::DeleteContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContactChannel` operation.
    ///
    /// See [`DeleteContactChannel`](crate::client::fluent_builders::DeleteContactChannel) for more information about the
    /// operation and its arguments.
    pub fn delete_contact_channel(&self) -> fluent_builders::DeleteContactChannel<C, M, R> {
        fluent_builders::DeleteContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEngagement` operation.
    ///
    /// See [`DescribeEngagement`](crate::client::fluent_builders::DescribeEngagement) for more information about the
    /// operation and its arguments.
    pub fn describe_engagement(&self) -> fluent_builders::DescribeEngagement<C, M, R> {
        fluent_builders::DescribeEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePage` operation.
    ///
    /// See [`DescribePage`](crate::client::fluent_builders::DescribePage) for more information about the
    /// operation and its arguments.
    pub fn describe_page(&self) -> fluent_builders::DescribePage<C, M, R> {
        fluent_builders::DescribePage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContact` operation.
    ///
    /// See [`GetContact`](crate::client::fluent_builders::GetContact) for more information about the
    /// operation and its arguments.
    pub fn get_contact(&self) -> fluent_builders::GetContact<C, M, R> {
        fluent_builders::GetContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContactChannel` operation.
    ///
    /// See [`GetContactChannel`](crate::client::fluent_builders::GetContactChannel) for more information about the
    /// operation and its arguments.
    pub fn get_contact_channel(&self) -> fluent_builders::GetContactChannel<C, M, R> {
        fluent_builders::GetContactChannel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContactPolicy` operation.
    ///
    /// See [`GetContactPolicy`](crate::client::fluent_builders::GetContactPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_contact_policy(&self) -> fluent_builders::GetContactPolicy<C, M, R> {
        fluent_builders::GetContactPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContactChannels` operation.
    ///
    /// See [`ListContactChannels`](crate::client::fluent_builders::ListContactChannels) for more information about the
    /// operation and its arguments.
    pub fn list_contact_channels(&self) -> fluent_builders::ListContactChannels<C, M, R> {
        fluent_builders::ListContactChannels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContacts` operation.
    ///
    /// See [`ListContacts`](crate::client::fluent_builders::ListContacts) for more information about the
    /// operation and its arguments.
    pub fn list_contacts(&self) -> fluent_builders::ListContacts<C, M, R> {
        fluent_builders::ListContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEngagements` operation.
    ///
    /// See [`ListEngagements`](crate::client::fluent_builders::ListEngagements) for more information about the
    /// operation and its arguments.
    pub fn list_engagements(&self) -> fluent_builders::ListEngagements<C, M, R> {
        fluent_builders::ListEngagements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPageReceipts` operation.
    ///
    /// See [`ListPageReceipts`](crate::client::fluent_builders::ListPageReceipts) for more information about the
    /// operation and its arguments.
    pub fn list_page_receipts(&self) -> fluent_builders::ListPageReceipts<C, M, R> {
        fluent_builders::ListPageReceipts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPagesByContact` operation.
    ///
    /// See [`ListPagesByContact`](crate::client::fluent_builders::ListPagesByContact) for more information about the
    /// operation and its arguments.
    pub fn list_pages_by_contact(&self) -> fluent_builders::ListPagesByContact<C, M, R> {
        fluent_builders::ListPagesByContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPagesByEngagement` operation.
    ///
    /// See [`ListPagesByEngagement`](crate::client::fluent_builders::ListPagesByEngagement) for more information about the
    /// operation and its arguments.
    pub fn list_pages_by_engagement(&self) -> fluent_builders::ListPagesByEngagement<C, M, R> {
        fluent_builders::ListPagesByEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutContactPolicy` operation.
    ///
    /// See [`PutContactPolicy`](crate::client::fluent_builders::PutContactPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_contact_policy(&self) -> fluent_builders::PutContactPolicy<C, M, R> {
        fluent_builders::PutContactPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendActivationCode` operation.
    ///
    /// See [`SendActivationCode`](crate::client::fluent_builders::SendActivationCode) for more information about the
    /// operation and its arguments.
    pub fn send_activation_code(&self) -> fluent_builders::SendActivationCode<C, M, R> {
        fluent_builders::SendActivationCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartEngagement` operation.
    ///
    /// See [`StartEngagement`](crate::client::fluent_builders::StartEngagement) for more information about the
    /// operation and its arguments.
    pub fn start_engagement(&self) -> fluent_builders::StartEngagement<C, M, R> {
        fluent_builders::StartEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopEngagement` operation.
    ///
    /// See [`StopEngagement`](crate::client::fluent_builders::StopEngagement) for more information about the
    /// operation and its arguments.
    pub fn stop_engagement(&self) -> fluent_builders::StopEngagement<C, M, R> {
        fluent_builders::StopEngagement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContact` operation.
    ///
    /// See [`UpdateContact`](crate::client::fluent_builders::UpdateContact) for more information about the
    /// operation and its arguments.
    pub fn update_contact(&self) -> fluent_builders::UpdateContact<C, M, R> {
        fluent_builders::UpdateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactChannel` operation.
    ///
    /// See [`UpdateContactChannel`](crate::client::fluent_builders::UpdateContactChannel) for more information about the
    /// operation and its arguments.
    pub fn update_contact_channel(&self) -> fluent_builders::UpdateContactChannel<C, M, R> {
        fluent_builders::UpdateContactChannel::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptPage`.
    ///
    /// <p>Used to acknowledge an engagement to a contact channel during an incident.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptPage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_page_input::Builder,
    }
    impl<C, M, R> AcceptPage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptPage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptPageOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptPageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptPageInputOperationOutputAlias,
                crate::output::AcceptPageOutput,
                crate::error::AcceptPageError,
                crate::input::AcceptPageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn page_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_id(input);
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn contact_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(inp);
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
        /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
        pub fn accept_type(mut self, inp: crate::model::AcceptType) -> Self {
            self.inner = self.inner.accept_type(inp);
            self
        }
        /// <p>The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.</p>
        pub fn set_accept_type(
            mut self,
            input: std::option::Option<crate::model::AcceptType>,
        ) -> Self {
            self.inner = self.inner.set_accept_type(input);
            self
        }
        /// <p>Information provided by the user when the user acknowledges the page.</p>
        pub fn note(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.note(inp);
            self
        }
        /// <p>Information provided by the user when the user acknowledges the page.</p>
        pub fn set_note(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_note(input);
            self
        }
        /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
        pub fn accept_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept_code(inp);
            self
        }
        /// <p>The accept code is a 6-digit code used to acknowledge the page.</p>
        pub fn set_accept_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_accept_code(input);
            self
        }
        /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code>
        /// <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by
        /// replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode
        /// validation causes Incident Manager to verify that the code entered by the user matches the
        /// code sent by Incident Manager with the page.</p>
        /// <p>Incident Manager can also <code>IGNORE</code>
        /// <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes
        /// Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
        pub fn accept_code_validation(mut self, inp: crate::model::AcceptCodeValidation) -> Self {
            self.inner = self.inner.accept_code_validation(inp);
            self
        }
        /// <p>An optional field that Incident Manager uses to <code>ENFORCE</code>
        /// <code>AcceptCode</code> validation when acknowledging an page. Acknowledgement can occur by
        /// replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode
        /// validation causes Incident Manager to verify that the code entered by the user matches the
        /// code sent by Incident Manager with the page.</p>
        /// <p>Incident Manager can also <code>IGNORE</code>
        /// <code>AcceptCode</code> validation. Ignoring <code>AcceptCode</code> validation causes
        /// Incident Manager to accept any value entered for the <code>AcceptCode</code>.</p>
        pub fn set_accept_code_validation(
            mut self,
            input: std::option::Option<crate::model::AcceptCodeValidation>,
        ) -> Self {
            self.inner = self.inner.set_accept_code_validation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ActivateContactChannel`.
    ///
    /// <p>Activates a contact's contact channel. Incident Manager can't engage a contact until the
    /// contact channel has been activated.</p>
    #[derive(std::fmt::Debug)]
    pub struct ActivateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_contact_channel_input::Builder,
    }
    impl<C, M, R> ActivateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateContactChannelInputOperationOutputAlias,
                crate::output::ActivateContactChannelOutput,
                crate::error::ActivateContactChannelError,
                crate::input::ActivateContactChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
        /// <p>The code sent to the contact channel when it was created in the contact. </p>
        pub fn activation_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_code(inp);
            self
        }
        /// <p>The code sent to the contact channel when it was created in the contact. </p>
        pub fn set_activation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContact`.
    ///
    /// <p>Contacts are either the contacts that Incident Manager engages during an incident or the
    /// escalation plans that Incident Manager uses to engage contacts in phases during an
    /// incident. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_input::Builder,
    }
    impl<C, M, R> CreateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactInputOperationOutputAlias,
                crate::output::CreateContactOutput,
                crate::error::CreateContactError,
                crate::input::CreateContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must
        /// be unique and identifiable. </p>
        pub fn alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias(inp);
            self
        }
        /// <p>The short name to quickly identify a contact or escalation plan. The contact alias must
        /// be unique and identifiable. </p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias(input);
            self
        }
        /// <p>The full name of the contact or escalation plan.  </p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The full name of the contact or escalation plan.  </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use
        /// <code>PERSONAL</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ContactType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>To create an escalation plan use <code>ESCALATION</code>. To create a contact use
        /// <code>PERSONAL</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages that contact specified
        /// contact channels. An escalation plan uses stages that contact specified contacts. </p>
        pub fn plan(mut self, inp: crate::model::Plan) -> Self {
            self.inner = self.inner.plan(inp);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages that contact specified
        /// contact channels. An escalation plan uses stages that contact specified contacts. </p>
        pub fn set_plan(mut self, input: std::option::Option<crate::model::Plan>) -> Self {
            self.inner = self.inner.set_plan(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your
        /// replication set. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Adds a tag to the target. You can only tag resources created in the first Region of your
        /// replication set. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactChannel`.
    ///
    /// <p>A contact channel is the method that Incident Manager uses to engage your contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_channel_input::Builder,
    }
    impl<C, M, R> CreateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactChannelInputOperationOutputAlias,
                crate::output::CreateContactChannelOutput,
                crate::error::CreateContactChannelError,
                crate::input::CreateContactChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Incident Manager supports three types of contact channels:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VOICE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EMAIL</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ChannelType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Incident Manager supports three types of contact channels:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VOICE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EMAIL</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format
        /// is dependent on the type of the contact channel. The following are the expected
        /// formats:</p>
        /// <ul>
        /// <li>
        /// <p>SMS - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>VOICE - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>EMAIL - any standard email format</p>
        /// </li>
        /// </ul>
        pub fn delivery_address(mut self, inp: crate::model::ContactChannelAddress) -> Self {
            self.inner = self.inner.delivery_address(inp);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. The format
        /// is dependent on the type of the contact channel. The following are the expected
        /// formats:</p>
        /// <ul>
        /// <li>
        /// <p>SMS - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>VOICE - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>EMAIL - any standard email format</p>
        /// </li>
        /// </ul>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.inner = self.inner.set_delivery_address(input);
            self
        }
        /// <p>If you want to activate the channel at a later time, you can choose to defer activation.
        /// Incident Manager can't engage your contact channel until it has been activated.</p>
        pub fn defer_activation(mut self, inp: bool) -> Self {
            self.inner = self.inner.defer_activation(inp);
            self
        }
        /// <p>If you want to activate the channel at a later time, you can choose to defer activation.
        /// Incident Manager can't engage your contact channel until it has been activated.</p>
        pub fn set_defer_activation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_defer_activation(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateContactChannel`.
    ///
    /// <p>To no longer receive Incident Manager engagements to a contact channel, you can deactivate
    /// the channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeactivateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_contact_channel_input::Builder,
    }
    impl<C, M, R> DeactivateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivateContactChannelInputOperationOutputAlias,
                crate::output::DeactivateContactChannelOutput,
                crate::error::DeactivateContactChannelError,
                crate::input::DeactivateContactChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
        pub fn contact_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you're deactivating.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContact`.
    ///
    /// <p>To remove a contact from Incident Manager, you can delete the contact. Deleting a contact
    /// removes them from all escalation plans and related response plans. Deleting an escalation
    /// plan removes it from all related response plans. You will have to recreate the contact and
    /// its contact channels before you can use it again.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_input::Builder,
    }
    impl<C, M, R> DeleteContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactInputOperationOutputAlias,
                crate::output::DeleteContactOutput,
                crate::error::DeleteContactError,
                crate::input::DeleteContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact that you're deleting.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactChannel`.
    ///
    /// <p>To no longer receive engagements on a contact channel, you can delete the channel from a
    /// contact. Deleting the contact channel removes it from the contact's engagement plan. If you
    /// delete the only contact channel for a contact, you won't be able to engage that contact
    /// during an incident.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_channel_input::Builder,
    }
    impl<C, M, R> DeleteContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactChannelInputOperationOutputAlias,
                crate::output::DeleteContactChannelOutput,
                crate::error::DeleteContactChannelError,
                crate::input::DeleteContactChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngagement`.
    ///
    /// <p>Incident Manager uses engagements to engage contacts and escalation plans during an incident.
    /// Use this command to describe the engagement that occurred during an incident.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_engagement_input::Builder,
    }
    impl<C, M, R> DescribeEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEngagementInputOperationOutputAlias,
                crate::output::DescribeEngagementOutput,
                crate::error::DescribeEngagementError,
                crate::input::DescribeEngagementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
        pub fn engagement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engagement_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement you want the details of.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engagement_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePage`.
    ///
    /// <p>Lists details of the engagement to a contact channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_page_input::Builder,
    }
    impl<C, M, R> DescribePage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePageInputOperationOutputAlias,
                crate::output::DescribePageOutput,
                crate::error::DescribePageError,
                crate::input::DescribePageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the engagement to a contact channel.</p>
        pub fn page_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_id(inp);
            self
        }
        /// <p>The ID of the engagement to a contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContact`.
    ///
    /// <p>Retrieves information about the specified contact or escalation plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_input::Builder,
    }
    impl<C, M, R> GetContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactInputOperationOutputAlias,
                crate::output::GetContactOutput,
                crate::error::GetContactError,
                crate::input::GetContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactChannel`.
    ///
    /// <p>List details about a specific contact channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_channel_input::Builder,
    }
    impl<C, M, R> GetContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactChannelInputOperationOutputAlias,
                crate::output::GetContactChannelOutput,
                crate::error::GetContactChannelError,
                crate::input::GetContactChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
        pub fn contact_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want information about.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactPolicy`.
    ///
    /// <p>Retrieves the resource policies attached to the specified contact or escalation
    /// plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContactPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_policy_input::Builder,
    }
    impl<C, M, R> GetContactPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactPolicyInputOperationOutputAlias,
                crate::output::GetContactPolicyOutput,
                crate::error::GetContactPolicyError,
                crate::input::GetContactPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactChannels`.
    ///
    /// <p>Lists all contact channels for the specified contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContactChannels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_channels_input::Builder,
    }
    impl<C, M, R> ListContactChannels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactChannels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactChannelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactChannelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactChannelsInputOperationOutputAlias,
                crate::output::ListContactChannelsOutput,
                crate::error::ListContactChannelsError,
                crate::input::ListContactChannelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact. </p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact. </p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of contact channels per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of contact channels per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContacts`.
    ///
    /// <p>Lists all contacts and escalation plans in Incident Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContacts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contacts_input::Builder,
    }
    impl<C, M, R> ListContacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactsInputOperationOutputAlias,
                crate::output::ListContactsOutput,
                crate::error::ListContactsError,
                crate::input::ListContactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of contacts and escalation plans per page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of contacts and escalation plans per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
        pub fn alias_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alias_prefix(inp);
            self
        }
        /// <p>Used to list only contacts who's aliases start with the specified prefix.</p>
        pub fn set_alias_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alias_prefix(input);
            self
        }
        /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is
        /// type <code>ESCALATION</code>.</p>
        pub fn r#type(mut self, inp: crate::model::ContactType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is
        /// type <code>ESCALATION</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEngagements`.
    ///
    /// <p>Lists all engagements that have happened in an incident.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEngagements<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_engagements_input::Builder,
    }
    impl<C, M, R> ListEngagements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEngagements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEngagementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEngagementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEngagementsInputOperationOutputAlias,
                crate::output::ListEngagementsOutput,
                crate::error::ListEngagementsError,
                crate::input::ListEngagementsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of engagements per page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of engagements per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
        pub fn incident_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the incident you're listing engagements for.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_incident_id(input);
            self
        }
        /// <p>The time range to lists engagements for an incident.</p>
        pub fn time_range_value(mut self, inp: crate::model::TimeRange) -> Self {
            self.inner = self.inner.time_range_value(inp);
            self
        }
        /// <p>The time range to lists engagements for an incident.</p>
        pub fn set_time_range_value(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_time_range_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPageReceipts`.
    ///
    /// <p>Lists all of the engagements to contact channels that have been acknowledged. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListPageReceipts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_page_receipts_input::Builder,
    }
    impl<C, M, R> ListPageReceipts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPageReceipts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPageReceiptsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPageReceiptsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPageReceiptsInputOperationOutputAlias,
                crate::output::ListPageReceiptsOutput,
                crate::error::ListPageReceiptsError,
                crate::input::ListPageReceiptsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
        pub fn page_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a specific contact channel.</p>
        pub fn set_page_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of acknowledgements per page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of acknowledgements per page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPagesByContact`.
    ///
    /// <p>Lists the engagements to a contact's contact channels.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPagesByContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pages_by_contact_input::Builder,
    }
    impl<C, M, R> ListPagesByContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPagesByContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPagesByContactOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPagesByContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPagesByContactInputOperationOutputAlias,
                crate::output::ListPagesByContactOutput,
                crate::error::ListPagesByContactError,
                crate::input::ListPagesByContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact you are retrieving engagements for.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPagesByEngagement`.
    ///
    /// <p>Lists the engagements to contact channels that occurred by engaging a contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPagesByEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pages_by_engagement_input::Builder,
    }
    impl<C, M, R> ListPagesByEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPagesByEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPagesByEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPagesByEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPagesByEngagementInputOperationOutputAlias,
                crate::output::ListPagesByEngagementOutput,
                crate::error::ListPagesByEngagementError,
                crate::input::ListPagesByEngagementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn engagement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engagement_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engagement_id(input);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of
        /// results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of engagements to contact channels to list per page of
        /// results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags of an escalation plan or contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutContactPolicy`.
    ///
    /// <p>Adds a resource to the specified contact or escalation plan.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutContactPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_contact_policy_input::Builder,
    }
    impl<C, M, R> PutContactPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutContactPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutContactPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutContactPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutContactPolicyInputOperationOutputAlias,
                crate::output::PutContactPolicyOutput,
                crate::error::PutContactPolicyError,
                crate::input::PutContactPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_arn(input);
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>Details of the resource policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendActivationCode`.
    ///
    /// <p>Sends an activation code to a contact channel. The contact can use this code to activate
    /// the contact channel in the console or with the <code>ActivateChannel</code> operation.
    /// Incident Manager can't engage a contact channel until it has been activated.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendActivationCode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_activation_code_input::Builder,
    }
    impl<C, M, R> SendActivationCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendActivationCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendActivationCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::SendActivationCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendActivationCodeInputOperationOutputAlias,
                crate::output::SendActivationCodeOutput,
                crate::error::SendActivationCodeError,
                crate::input::SendActivationCodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartEngagement`.
    ///
    /// <p>Starts an engagement to a contact or escalation plan. The engagement engages each
    /// contact specified in the incident.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_engagement_input::Builder,
    }
    impl<C, M, R> StartEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::StartEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartEngagementInputOperationOutputAlias,
                crate::output::StartEngagementOutput,
                crate::error::StartEngagementError,
                crate::input::StartEngagementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact being engaged.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn sender(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sender(inp);
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sender(input);
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subject(inp);
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subject(input);
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> or <code>EMAIL</code>.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn public_subject(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_subject(inp);
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn set_public_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_subject(input);
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn public_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_content(inp);
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn set_public_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_content(input);
            self
        }
        /// <p>The ARN of the incident that the engagement is part of.</p>
        pub fn incident_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.incident_id(inp);
            self
        }
        /// <p>The ARN of the incident that the engagement is part of.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_incident_id(input);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A token ensuring that the operation is called only once with the specified
        /// details.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopEngagement`.
    ///
    /// <p>Stops an engagement before it finishes the final stage of the escalation plan or
    /// engagement plan. Further contacts aren't engaged.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopEngagement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_engagement_input::Builder,
    }
    impl<C, M, R> StopEngagement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopEngagement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopEngagementOutput,
            aws_smithy_http::result::SdkError<crate::error::StopEngagementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopEngagementInputOperationOutputAlias,
                crate::output::StopEngagementOutput,
                crate::error::StopEngagementError,
                crate::input::StopEngagementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn engagement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engagement_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn set_engagement_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engagement_id(input);
            self
        }
        /// <p>The reason that you're stopping the engagement. </p>
        pub fn reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>The reason that you're stopping the engagement. </p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags a contact or escalation plan. You can tag only contacts and escalation plans in the
    /// first region of your replication set. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you are adding to the contact or escalation plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from the specified resource. </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag that you want to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The key of the tag that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContact`.
    ///
    /// <p>Updates the contact or escalation plan specified. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_input::Builder,
    }
    impl<C, M, R> UpdateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactInputOperationOutputAlias,
                crate::output::UpdateContactOutput,
                crate::error::UpdateContactError,
                crate::input::UpdateContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan you're updating.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages for specified contact
        /// channels. An escalation plan uses these stages to contact specified contacts. </p>
        pub fn plan(mut self, inp: crate::model::Plan) -> Self {
            self.inner = self.inner.plan(inp);
            self
        }
        /// <p>A list of stages. A contact has an engagement plan with stages for specified contact
        /// channels. An escalation plan uses these stages to contact specified contacts. </p>
        pub fn set_plan(mut self, input: std::option::Option<crate::model::Plan>) -> Self {
            self.inner = self.inner.set_plan(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactChannel`.
    ///
    /// <p>Updates a contact's contact channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactChannel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_channel_input::Builder,
    }
    impl<C, M, R> UpdateContactChannel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactChannel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactChannelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactChannelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactChannelInputOperationOutputAlias,
                crate::output::UpdateContactChannelOutput,
                crate::error::UpdateContactChannelError,
                crate::input::UpdateContactChannelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
        pub fn contact_channel_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_channel_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel you want to update.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_channel_id(input);
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn delivery_address(mut self, inp: crate::model::ContactChannelAddress) -> Self {
            self.inner = self.inner.delivery_address(inp);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.inner = self.inner.set_delivery_address(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
