// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContactChannelOutput {}
impl std::fmt::Debug for UpdateContactChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContactChannelOutput");
        formatter.finish()
    }
}
/// See [`UpdateContactChannelOutput`](crate::output::UpdateContactChannelOutput)
pub mod update_contact_channel_output {
    /// A builder for [`UpdateContactChannelOutput`](crate::output::UpdateContactChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateContactChannelOutput`](crate::output::UpdateContactChannelOutput)
        pub fn build(self) -> crate::output::UpdateContactChannelOutput {
            crate::output::UpdateContactChannelOutput {}
        }
    }
}
impl UpdateContactChannelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContactChannelOutput`](crate::output::UpdateContactChannelOutput)
    pub fn builder() -> crate::output::update_contact_channel_output::Builder {
        crate::output::update_contact_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContactOutput {}
impl std::fmt::Debug for UpdateContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContactOutput");
        formatter.finish()
    }
}
/// See [`UpdateContactOutput`](crate::output::UpdateContactOutput)
pub mod update_contact_output {
    /// A builder for [`UpdateContactOutput`](crate::output::UpdateContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateContactOutput`](crate::output::UpdateContactOutput)
        pub fn build(self) -> crate::output::UpdateContactOutput {
            crate::output::UpdateContactOutput {}
        }
    }
}
impl UpdateContactOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContactOutput`](crate::output::UpdateContactOutput)
    pub fn builder() -> crate::output::update_contact_output::Builder {
        crate::output::update_contact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopEngagementOutput {}
impl std::fmt::Debug for StopEngagementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopEngagementOutput");
        formatter.finish()
    }
}
/// See [`StopEngagementOutput`](crate::output::StopEngagementOutput)
pub mod stop_engagement_output {
    /// A builder for [`StopEngagementOutput`](crate::output::StopEngagementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopEngagementOutput`](crate::output::StopEngagementOutput)
        pub fn build(self) -> crate::output::StopEngagementOutput {
            crate::output::StopEngagementOutput {}
        }
    }
}
impl StopEngagementOutput {
    /// Creates a new builder-style object to manufacture [`StopEngagementOutput`](crate::output::StopEngagementOutput)
    pub fn builder() -> crate::output::stop_engagement_output::Builder {
        crate::output::stop_engagement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartEngagementOutput {
    /// <p>The ARN of the engagement.</p>
    pub engagement_arn: std::option::Option<std::string::String>,
}
impl StartEngagementOutput {
    /// <p>The ARN of the engagement.</p>
    pub fn engagement_arn(&self) -> std::option::Option<&str> {
        self.engagement_arn.as_deref()
    }
}
impl std::fmt::Debug for StartEngagementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartEngagementOutput");
        formatter.field("engagement_arn", &self.engagement_arn);
        formatter.finish()
    }
}
/// See [`StartEngagementOutput`](crate::output::StartEngagementOutput)
pub mod start_engagement_output {
    /// A builder for [`StartEngagementOutput`](crate::output::StartEngagementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engagement_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the engagement.</p>
        pub fn engagement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the engagement.</p>
        pub fn set_engagement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartEngagementOutput`](crate::output::StartEngagementOutput)
        pub fn build(self) -> crate::output::StartEngagementOutput {
            crate::output::StartEngagementOutput {
                engagement_arn: self.engagement_arn,
            }
        }
    }
}
impl StartEngagementOutput {
    /// Creates a new builder-style object to manufacture [`StartEngagementOutput`](crate::output::StartEngagementOutput)
    pub fn builder() -> crate::output::start_engagement_output::Builder {
        crate::output::start_engagement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendActivationCodeOutput {}
impl std::fmt::Debug for SendActivationCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendActivationCodeOutput");
        formatter.finish()
    }
}
/// See [`SendActivationCodeOutput`](crate::output::SendActivationCodeOutput)
pub mod send_activation_code_output {
    /// A builder for [`SendActivationCodeOutput`](crate::output::SendActivationCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SendActivationCodeOutput`](crate::output::SendActivationCodeOutput)
        pub fn build(self) -> crate::output::SendActivationCodeOutput {
            crate::output::SendActivationCodeOutput {}
        }
    }
}
impl SendActivationCodeOutput {
    /// Creates a new builder-style object to manufacture [`SendActivationCodeOutput`](crate::output::SendActivationCodeOutput)
    pub fn builder() -> crate::output::send_activation_code_output::Builder {
        crate::output::send_activation_code_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutContactPolicyOutput {}
impl std::fmt::Debug for PutContactPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutContactPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutContactPolicyOutput`](crate::output::PutContactPolicyOutput)
pub mod put_contact_policy_output {
    /// A builder for [`PutContactPolicyOutput`](crate::output::PutContactPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutContactPolicyOutput`](crate::output::PutContactPolicyOutput)
        pub fn build(self) -> crate::output::PutContactPolicyOutput {
            crate::output::PutContactPolicyOutput {}
        }
    }
}
impl PutContactPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutContactPolicyOutput`](crate::output::PutContactPolicyOutput)
    pub fn builder() -> crate::output::put_contact_policy_output::Builder {
        crate::output::put_contact_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags related to the contact or escalation plan.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags related to the contact or escalation plan.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags related to the contact or escalation plan.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags related to the contact or escalation plan.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPagesByEngagementOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of engagements to contact channels.</p>
    pub pages: std::option::Option<std::vec::Vec<crate::model::Page>>,
}
impl ListPagesByEngagementOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The list of engagements to contact channels.</p>
    pub fn pages(&self) -> std::option::Option<&[crate::model::Page]> {
        self.pages.as_deref()
    }
}
impl std::fmt::Debug for ListPagesByEngagementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPagesByEngagementOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("pages", &self.pages);
        formatter.finish()
    }
}
/// See [`ListPagesByEngagementOutput`](crate::output::ListPagesByEngagementOutput)
pub mod list_pages_by_engagement_output {
    /// A builder for [`ListPagesByEngagementOutput`](crate::output::ListPagesByEngagementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) pages: std::option::Option<std::vec::Vec<crate::model::Page>>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `pages`.
        ///
        /// To override the contents of this collection use [`set_pages`](Self::set_pages).
        ///
        /// <p>The list of engagements to contact channels.</p>
        pub fn pages(mut self, input: impl Into<crate::model::Page>) -> Self {
            let mut v = self.pages.unwrap_or_default();
            v.push(input.into());
            self.pages = Some(v);
            self
        }
        /// <p>The list of engagements to contact channels.</p>
        pub fn set_pages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Page>>,
        ) -> Self {
            self.pages = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPagesByEngagementOutput`](crate::output::ListPagesByEngagementOutput)
        pub fn build(self) -> crate::output::ListPagesByEngagementOutput {
            crate::output::ListPagesByEngagementOutput {
                next_token: self.next_token,
                pages: self.pages,
            }
        }
    }
}
impl ListPagesByEngagementOutput {
    /// Creates a new builder-style object to manufacture [`ListPagesByEngagementOutput`](crate::output::ListPagesByEngagementOutput)
    pub fn builder() -> crate::output::list_pages_by_engagement_output::Builder {
        crate::output::list_pages_by_engagement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPagesByContactOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of engagements to a contact's contact channel.</p>
    pub pages: std::option::Option<std::vec::Vec<crate::model::Page>>,
}
impl ListPagesByContactOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The list of engagements to a contact's contact channel.</p>
    pub fn pages(&self) -> std::option::Option<&[crate::model::Page]> {
        self.pages.as_deref()
    }
}
impl std::fmt::Debug for ListPagesByContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPagesByContactOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("pages", &self.pages);
        formatter.finish()
    }
}
/// See [`ListPagesByContactOutput`](crate::output::ListPagesByContactOutput)
pub mod list_pages_by_contact_output {
    /// A builder for [`ListPagesByContactOutput`](crate::output::ListPagesByContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) pages: std::option::Option<std::vec::Vec<crate::model::Page>>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `pages`.
        ///
        /// To override the contents of this collection use [`set_pages`](Self::set_pages).
        ///
        /// <p>The list of engagements to a contact's contact channel.</p>
        pub fn pages(mut self, input: impl Into<crate::model::Page>) -> Self {
            let mut v = self.pages.unwrap_or_default();
            v.push(input.into());
            self.pages = Some(v);
            self
        }
        /// <p>The list of engagements to a contact's contact channel.</p>
        pub fn set_pages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Page>>,
        ) -> Self {
            self.pages = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPagesByContactOutput`](crate::output::ListPagesByContactOutput)
        pub fn build(self) -> crate::output::ListPagesByContactOutput {
            crate::output::ListPagesByContactOutput {
                next_token: self.next_token,
                pages: self.pages,
            }
        }
    }
}
impl ListPagesByContactOutput {
    /// Creates a new builder-style object to manufacture [`ListPagesByContactOutput`](crate::output::ListPagesByContactOutput)
    pub fn builder() -> crate::output::list_pages_by_contact_output::Builder {
        crate::output::list_pages_by_contact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPageReceiptsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of each acknowledgement.</p>
    pub receipts: std::option::Option<std::vec::Vec<crate::model::Receipt>>,
}
impl ListPageReceiptsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of each acknowledgement.</p>
    pub fn receipts(&self) -> std::option::Option<&[crate::model::Receipt]> {
        self.receipts.as_deref()
    }
}
impl std::fmt::Debug for ListPageReceiptsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPageReceiptsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("receipts", &self.receipts);
        formatter.finish()
    }
}
/// See [`ListPageReceiptsOutput`](crate::output::ListPageReceiptsOutput)
pub mod list_page_receipts_output {
    /// A builder for [`ListPageReceiptsOutput`](crate::output::ListPageReceiptsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) receipts: std::option::Option<std::vec::Vec<crate::model::Receipt>>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `receipts`.
        ///
        /// To override the contents of this collection use [`set_receipts`](Self::set_receipts).
        ///
        /// <p>A list of each acknowledgement.</p>
        pub fn receipts(mut self, input: impl Into<crate::model::Receipt>) -> Self {
            let mut v = self.receipts.unwrap_or_default();
            v.push(input.into());
            self.receipts = Some(v);
            self
        }
        /// <p>A list of each acknowledgement.</p>
        pub fn set_receipts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Receipt>>,
        ) -> Self {
            self.receipts = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPageReceiptsOutput`](crate::output::ListPageReceiptsOutput)
        pub fn build(self) -> crate::output::ListPageReceiptsOutput {
            crate::output::ListPageReceiptsOutput {
                next_token: self.next_token,
                receipts: self.receipts,
            }
        }
    }
}
impl ListPageReceiptsOutput {
    /// Creates a new builder-style object to manufacture [`ListPageReceiptsOutput`](crate::output::ListPageReceiptsOutput)
    pub fn builder() -> crate::output::list_page_receipts_output::Builder {
        crate::output::list_page_receipts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEngagementsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of each engagement that occurred during the specified time range of an
    /// incident.</p>
    pub engagements: std::option::Option<std::vec::Vec<crate::model::Engagement>>,
}
impl ListEngagementsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of each engagement that occurred during the specified time range of an
    /// incident.</p>
    pub fn engagements(&self) -> std::option::Option<&[crate::model::Engagement]> {
        self.engagements.as_deref()
    }
}
impl std::fmt::Debug for ListEngagementsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEngagementsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("engagements", &self.engagements);
        formatter.finish()
    }
}
/// See [`ListEngagementsOutput`](crate::output::ListEngagementsOutput)
pub mod list_engagements_output {
    /// A builder for [`ListEngagementsOutput`](crate::output::ListEngagementsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) engagements: std::option::Option<std::vec::Vec<crate::model::Engagement>>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `engagements`.
        ///
        /// To override the contents of this collection use [`set_engagements`](Self::set_engagements).
        ///
        /// <p>A list of each engagement that occurred during the specified time range of an
        /// incident.</p>
        pub fn engagements(mut self, input: impl Into<crate::model::Engagement>) -> Self {
            let mut v = self.engagements.unwrap_or_default();
            v.push(input.into());
            self.engagements = Some(v);
            self
        }
        /// <p>A list of each engagement that occurred during the specified time range of an
        /// incident.</p>
        pub fn set_engagements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Engagement>>,
        ) -> Self {
            self.engagements = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEngagementsOutput`](crate::output::ListEngagementsOutput)
        pub fn build(self) -> crate::output::ListEngagementsOutput {
            crate::output::ListEngagementsOutput {
                next_token: self.next_token,
                engagements: self.engagements,
            }
        }
    }
}
impl ListEngagementsOutput {
    /// Creates a new builder-style object to manufacture [`ListEngagementsOutput`](crate::output::ListEngagementsOutput)
    pub fn builder() -> crate::output::list_engagements_output::Builder {
        crate::output::list_engagements_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of the contacts and escalation plans in your Incident Manager account.</p>
    pub contacts: std::option::Option<std::vec::Vec<crate::model::Contact>>,
}
impl ListContactsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of the contacts and escalation plans in your Incident Manager account.</p>
    pub fn contacts(&self) -> std::option::Option<&[crate::model::Contact]> {
        self.contacts.as_deref()
    }
}
impl std::fmt::Debug for ListContactsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("contacts", &self.contacts);
        formatter.finish()
    }
}
/// See [`ListContactsOutput`](crate::output::ListContactsOutput)
pub mod list_contacts_output {
    /// A builder for [`ListContactsOutput`](crate::output::ListContactsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) contacts: std::option::Option<std::vec::Vec<crate::model::Contact>>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `contacts`.
        ///
        /// To override the contents of this collection use [`set_contacts`](Self::set_contacts).
        ///
        /// <p>A list of the contacts and escalation plans in your Incident Manager account.</p>
        pub fn contacts(mut self, input: impl Into<crate::model::Contact>) -> Self {
            let mut v = self.contacts.unwrap_or_default();
            v.push(input.into());
            self.contacts = Some(v);
            self
        }
        /// <p>A list of the contacts and escalation plans in your Incident Manager account.</p>
        pub fn set_contacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Contact>>,
        ) -> Self {
            self.contacts = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactsOutput`](crate::output::ListContactsOutput)
        pub fn build(self) -> crate::output::ListContactsOutput {
            crate::output::ListContactsOutput {
                next_token: self.next_token,
                contacts: self.contacts,
            }
        }
    }
}
impl ListContactsOutput {
    /// Creates a new builder-style object to manufacture [`ListContactsOutput`](crate::output::ListContactsOutput)
    pub fn builder() -> crate::output::list_contacts_output::Builder {
        crate::output::list_contacts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactChannelsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of contact channels related to the specified contact.</p>
    pub contact_channels: std::option::Option<std::vec::Vec<crate::model::ContactChannel>>,
}
impl ListContactChannelsOutput {
    /// <p>The pagination token to continue to the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of contact channels related to the specified contact.</p>
    pub fn contact_channels(&self) -> std::option::Option<&[crate::model::ContactChannel]> {
        self.contact_channels.as_deref()
    }
}
impl std::fmt::Debug for ListContactChannelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactChannelsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("contact_channels", &self.contact_channels);
        formatter.finish()
    }
}
/// See [`ListContactChannelsOutput`](crate::output::ListContactChannelsOutput)
pub mod list_contact_channels_output {
    /// A builder for [`ListContactChannelsOutput`](crate::output::ListContactChannelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) contact_channels:
            std::option::Option<std::vec::Vec<crate::model::ContactChannel>>,
    }
    impl Builder {
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `contact_channels`.
        ///
        /// To override the contents of this collection use [`set_contact_channels`](Self::set_contact_channels).
        ///
        /// <p>A list of contact channels related to the specified contact.</p>
        pub fn contact_channels(mut self, input: impl Into<crate::model::ContactChannel>) -> Self {
            let mut v = self.contact_channels.unwrap_or_default();
            v.push(input.into());
            self.contact_channels = Some(v);
            self
        }
        /// <p>A list of contact channels related to the specified contact.</p>
        pub fn set_contact_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactChannel>>,
        ) -> Self {
            self.contact_channels = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactChannelsOutput`](crate::output::ListContactChannelsOutput)
        pub fn build(self) -> crate::output::ListContactChannelsOutput {
            crate::output::ListContactChannelsOutput {
                next_token: self.next_token,
                contact_channels: self.contact_channels,
            }
        }
    }
}
impl ListContactChannelsOutput {
    /// Creates a new builder-style object to manufacture [`ListContactChannelsOutput`](crate::output::ListContactChannelsOutput)
    pub fn builder() -> crate::output::list_contact_channels_output::Builder {
        crate::output::list_contact_channels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactPolicyOutput {
    /// <p>The ARN of the contact or escalation plan.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>Details about the resource policy attached to the contact or escalation plan.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetContactPolicyOutput {
    /// <p>The ARN of the contact or escalation plan.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>Details about the resource policy attached to the contact or escalation plan.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetContactPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactPolicyOutput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetContactPolicyOutput`](crate::output::GetContactPolicyOutput)
pub mod get_contact_policy_output {
    /// A builder for [`GetContactPolicyOutput`](crate::output::GetContactPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>Details about the resource policy attached to the contact or escalation plan.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>Details about the resource policy attached to the contact or escalation plan.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactPolicyOutput`](crate::output::GetContactPolicyOutput)
        pub fn build(self) -> crate::output::GetContactPolicyOutput {
            crate::output::GetContactPolicyOutput {
                contact_arn: self.contact_arn,
                policy: self.policy,
            }
        }
    }
}
impl GetContactPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetContactPolicyOutput`](crate::output::GetContactPolicyOutput)
    pub fn builder() -> crate::output::get_contact_policy_output::Builder {
        crate::output::get_contact_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactChannelOutput {
    /// <p>The ARN of the contact that the channel belongs to.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the contact channel.</p>
    pub contact_channel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the contact channel</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or
    /// <code>EMAIL</code>.</p>
    pub r#type: std::option::Option<crate::model::ChannelType>,
    /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
    pub delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
    /// <p>A Boolean value indicating if the contact channel has been activated or not.</p>
    pub activation_status: std::option::Option<crate::model::ActivationStatus>,
}
impl GetContactChannelOutput {
    /// <p>The ARN of the contact that the channel belongs to.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The ARN of the contact channel.</p>
    pub fn contact_channel_arn(&self) -> std::option::Option<&str> {
        self.contact_channel_arn.as_deref()
    }
    /// <p>The name of the contact channel</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or
    /// <code>EMAIL</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.r#type.as_ref()
    }
    /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
    pub fn delivery_address(&self) -> std::option::Option<&crate::model::ContactChannelAddress> {
        self.delivery_address.as_ref()
    }
    /// <p>A Boolean value indicating if the contact channel has been activated or not.</p>
    pub fn activation_status(&self) -> std::option::Option<&crate::model::ActivationStatus> {
        self.activation_status.as_ref()
    }
}
impl std::fmt::Debug for GetContactChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactChannelOutput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("contact_channel_arn", &self.contact_channel_arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("delivery_address", &self.delivery_address);
        formatter.field("activation_status", &self.activation_status);
        formatter.finish()
    }
}
/// See [`GetContactChannelOutput`](crate::output::GetContactChannelOutput)
pub mod get_contact_channel_output {
    /// A builder for [`GetContactChannelOutput`](crate::output::GetContactChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) contact_channel_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelType>,
        pub(crate) delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
        pub(crate) activation_status: std::option::Option<crate::model::ActivationStatus>,
    }
    impl Builder {
        /// <p>The ARN of the contact that the channel belongs to.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact that the channel belongs to.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn contact_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact channel.</p>
        pub fn set_contact_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_arn = input;
            self
        }
        /// <p>The name of the contact channel</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact channel</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or
        /// <code>EMAIL</code>.</p>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or
        /// <code>EMAIL</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn delivery_address(mut self, input: crate::model::ContactChannelAddress) -> Self {
            self.delivery_address = Some(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.delivery_address = input;
            self
        }
        /// <p>A Boolean value indicating if the contact channel has been activated or not.</p>
        pub fn activation_status(mut self, input: crate::model::ActivationStatus) -> Self {
            self.activation_status = Some(input);
            self
        }
        /// <p>A Boolean value indicating if the contact channel has been activated or not.</p>
        pub fn set_activation_status(
            mut self,
            input: std::option::Option<crate::model::ActivationStatus>,
        ) -> Self {
            self.activation_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactChannelOutput`](crate::output::GetContactChannelOutput)
        pub fn build(self) -> crate::output::GetContactChannelOutput {
            crate::output::GetContactChannelOutput {
                contact_arn: self.contact_arn,
                contact_channel_arn: self.contact_channel_arn,
                name: self.name,
                r#type: self.r#type,
                delivery_address: self.delivery_address,
                activation_status: self.activation_status,
            }
        }
    }
}
impl GetContactChannelOutput {
    /// Creates a new builder-style object to manufacture [`GetContactChannelOutput`](crate::output::GetContactChannelOutput)
    pub fn builder() -> crate::output::get_contact_channel_output::Builder {
        crate::output::get_contact_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactOutput {
    /// <p>The ARN of the contact or escalation plan.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The alias of the contact or escalation plan. The alias is unique and
    /// identifiable.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The full name of the contact or escalation plan.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The type of contact, either <code>PERSONAL</code> or <code>ESCALATION</code>. </p>
    pub r#type: std::option::Option<crate::model::ContactType>,
    /// <p>Details about the specific timing or stages and targets of the escalation plan or
    /// engagement plan.</p>
    pub plan: std::option::Option<crate::model::Plan>,
}
impl GetContactOutput {
    /// <p>The ARN of the contact or escalation plan.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The alias of the contact or escalation plan. The alias is unique and
    /// identifiable.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The full name of the contact or escalation plan.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The type of contact, either <code>PERSONAL</code> or <code>ESCALATION</code>. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ContactType> {
        self.r#type.as_ref()
    }
    /// <p>Details about the specific timing or stages and targets of the escalation plan or
    /// engagement plan.</p>
    pub fn plan(&self) -> std::option::Option<&crate::model::Plan> {
        self.plan.as_ref()
    }
}
impl std::fmt::Debug for GetContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactOutput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("alias", &self.alias);
        formatter.field("display_name", &self.display_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("plan", &self.plan);
        formatter.finish()
    }
}
/// See [`GetContactOutput`](crate::output::GetContactOutput)
pub mod get_contact_output {
    /// A builder for [`GetContactOutput`](crate::output::GetContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ContactType>,
        pub(crate) plan: std::option::Option<crate::model::Plan>,
    }
    impl Builder {
        /// <p>The ARN of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The alias of the contact or escalation plan. The alias is unique and
        /// identifiable.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias of the contact or escalation plan. The alias is unique and
        /// identifiable.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The type of contact, either <code>PERSONAL</code> or <code>ESCALATION</code>. </p>
        pub fn r#type(mut self, input: crate::model::ContactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of contact, either <code>PERSONAL</code> or <code>ESCALATION</code>. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Details about the specific timing or stages and targets of the escalation plan or
        /// engagement plan.</p>
        pub fn plan(mut self, input: crate::model::Plan) -> Self {
            self.plan = Some(input);
            self
        }
        /// <p>Details about the specific timing or stages and targets of the escalation plan or
        /// engagement plan.</p>
        pub fn set_plan(mut self, input: std::option::Option<crate::model::Plan>) -> Self {
            self.plan = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactOutput`](crate::output::GetContactOutput)
        pub fn build(self) -> crate::output::GetContactOutput {
            crate::output::GetContactOutput {
                contact_arn: self.contact_arn,
                alias: self.alias,
                display_name: self.display_name,
                r#type: self.r#type,
                plan: self.plan,
            }
        }
    }
}
impl GetContactOutput {
    /// Creates a new builder-style object to manufacture [`GetContactOutput`](crate::output::GetContactOutput)
    pub fn builder() -> crate::output::get_contact_output::Builder {
        crate::output::get_contact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePageOutput {
    /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
    pub page_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the engagement that engaged the contact channel.</p>
    pub engagement_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the contact that was engaged.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The user that started the engagement.</p>
    pub sender: std::option::Option<std::string::String>,
    /// <p>The secure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The secure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The insecure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub public_subject: std::option::Option<std::string::String>,
    /// <p>The insecure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub public_content: std::option::Option<std::string::String>,
    /// <p>The ARN of the incident that engaged the contact channel.</p>
    pub incident_id: std::option::Option<std::string::String>,
    /// <p>The time the engagement was sent to the contact channel.</p>
    pub sent_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the contact channel acknowledged the engagement.</p>
    pub read_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the contact channel received the engagement.</p>
    pub delivery_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribePageOutput {
    /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
    pub fn page_arn(&self) -> std::option::Option<&str> {
        self.page_arn.as_deref()
    }
    /// <p>The ARN of the engagement that engaged the contact channel.</p>
    pub fn engagement_arn(&self) -> std::option::Option<&str> {
        self.engagement_arn.as_deref()
    }
    /// <p>The ARN of the contact that was engaged.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The user that started the engagement.</p>
    pub fn sender(&self) -> std::option::Option<&str> {
        self.sender.as_deref()
    }
    /// <p>The secure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The secure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The insecure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub fn public_subject(&self) -> std::option::Option<&str> {
        self.public_subject.as_deref()
    }
    /// <p>The insecure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub fn public_content(&self) -> std::option::Option<&str> {
        self.public_content.as_deref()
    }
    /// <p>The ARN of the incident that engaged the contact channel.</p>
    pub fn incident_id(&self) -> std::option::Option<&str> {
        self.incident_id.as_deref()
    }
    /// <p>The time the engagement was sent to the contact channel.</p>
    pub fn sent_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.sent_time.as_ref()
    }
    /// <p>The time that the contact channel acknowledged the engagement.</p>
    pub fn read_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.read_time.as_ref()
    }
    /// <p>The time that the contact channel received the engagement.</p>
    pub fn delivery_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.delivery_time.as_ref()
    }
}
impl std::fmt::Debug for DescribePageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePageOutput");
        formatter.field("page_arn", &self.page_arn);
        formatter.field("engagement_arn", &self.engagement_arn);
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("sender", &self.sender);
        formatter.field("subject", &self.subject);
        formatter.field("content", &self.content);
        formatter.field("public_subject", &self.public_subject);
        formatter.field("public_content", &self.public_content);
        formatter.field("incident_id", &self.incident_id);
        formatter.field("sent_time", &self.sent_time);
        formatter.field("read_time", &self.read_time);
        formatter.field("delivery_time", &self.delivery_time);
        formatter.finish()
    }
}
/// See [`DescribePageOutput`](crate::output::DescribePageOutput)
pub mod describe_page_output {
    /// A builder for [`DescribePageOutput`](crate::output::DescribePageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_arn: std::option::Option<std::string::String>,
        pub(crate) engagement_arn: std::option::Option<std::string::String>,
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) sender: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) public_subject: std::option::Option<std::string::String>,
        pub(crate) public_content: std::option::Option<std::string::String>,
        pub(crate) incident_id: std::option::Option<std::string::String>,
        pub(crate) sent_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) read_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) delivery_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn page_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement to a contact channel.</p>
        pub fn set_page_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_arn = input;
            self
        }
        /// <p>The ARN of the engagement that engaged the contact channel.</p>
        pub fn engagement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the engagement that engaged the contact channel.</p>
        pub fn set_engagement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_arn = input;
            self
        }
        /// <p>The ARN of the contact that was engaged.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact that was engaged.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender = Some(input.into());
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender = input;
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn public_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_subject = Some(input.into());
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn set_public_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_subject = input;
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn public_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_content = Some(input.into());
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn set_public_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_content = input;
            self
        }
        /// <p>The ARN of the incident that engaged the contact channel.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_id = Some(input.into());
            self
        }
        /// <p>The ARN of the incident that engaged the contact channel.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.incident_id = input;
            self
        }
        /// <p>The time the engagement was sent to the contact channel.</p>
        pub fn sent_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.sent_time = Some(input);
            self
        }
        /// <p>The time the engagement was sent to the contact channel.</p>
        pub fn set_sent_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.sent_time = input;
            self
        }
        /// <p>The time that the contact channel acknowledged the engagement.</p>
        pub fn read_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.read_time = Some(input);
            self
        }
        /// <p>The time that the contact channel acknowledged the engagement.</p>
        pub fn set_read_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.read_time = input;
            self
        }
        /// <p>The time that the contact channel received the engagement.</p>
        pub fn delivery_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.delivery_time = Some(input);
            self
        }
        /// <p>The time that the contact channel received the engagement.</p>
        pub fn set_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.delivery_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePageOutput`](crate::output::DescribePageOutput)
        pub fn build(self) -> crate::output::DescribePageOutput {
            crate::output::DescribePageOutput {
                page_arn: self.page_arn,
                engagement_arn: self.engagement_arn,
                contact_arn: self.contact_arn,
                sender: self.sender,
                subject: self.subject,
                content: self.content,
                public_subject: self.public_subject,
                public_content: self.public_content,
                incident_id: self.incident_id,
                sent_time: self.sent_time,
                read_time: self.read_time,
                delivery_time: self.delivery_time,
            }
        }
    }
}
impl DescribePageOutput {
    /// Creates a new builder-style object to manufacture [`DescribePageOutput`](crate::output::DescribePageOutput)
    pub fn builder() -> crate::output::describe_page_output::Builder {
        crate::output::describe_page_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngagementOutput {
    /// <p>The ARN of the escalation plan or contacts involved in the engagement.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the engagement.</p>
    pub engagement_arn: std::option::Option<std::string::String>,
    /// <p>The user that started the engagement.</p>
    pub sender: std::option::Option<std::string::String>,
    /// <p>The secure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>The secure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The insecure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub public_subject: std::option::Option<std::string::String>,
    /// <p>The insecure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub public_content: std::option::Option<std::string::String>,
    /// <p>The ARN of the incident in which the engagement occurred.</p>
    pub incident_id: std::option::Option<std::string::String>,
    /// <p>The time that the engagement started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the engagement ended.</p>
    pub stop_time: std::option::Option<aws_smithy_types::Instant>,
}
impl DescribeEngagementOutput {
    /// <p>The ARN of the escalation plan or contacts involved in the engagement.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The ARN of the engagement.</p>
    pub fn engagement_arn(&self) -> std::option::Option<&str> {
        self.engagement_arn.as_deref()
    }
    /// <p>The user that started the engagement.</p>
    pub fn sender(&self) -> std::option::Option<&str> {
        self.sender.as_deref()
    }
    /// <p>The secure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>The secure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The insecure subject of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub fn public_subject(&self) -> std::option::Option<&str> {
        self.public_subject.as_deref()
    }
    /// <p>The insecure content of the message that was sent to the contact. Use this field for
    /// engagements to <code>SMS</code>.</p>
    pub fn public_content(&self) -> std::option::Option<&str> {
        self.public_content.as_deref()
    }
    /// <p>The ARN of the incident in which the engagement occurred.</p>
    pub fn incident_id(&self) -> std::option::Option<&str> {
        self.incident_id.as_deref()
    }
    /// <p>The time that the engagement started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The time that the engagement ended.</p>
    pub fn stop_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeEngagementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngagementOutput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("engagement_arn", &self.engagement_arn);
        formatter.field("sender", &self.sender);
        formatter.field("subject", &self.subject);
        formatter.field("content", &self.content);
        formatter.field("public_subject", &self.public_subject);
        formatter.field("public_content", &self.public_content);
        formatter.field("incident_id", &self.incident_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("stop_time", &self.stop_time);
        formatter.finish()
    }
}
/// See [`DescribeEngagementOutput`](crate::output::DescribeEngagementOutput)
pub mod describe_engagement_output {
    /// A builder for [`DescribeEngagementOutput`](crate::output::DescribeEngagementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) engagement_arn: std::option::Option<std::string::String>,
        pub(crate) sender: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) public_subject: std::option::Option<std::string::String>,
        pub(crate) public_content: std::option::Option<std::string::String>,
        pub(crate) incident_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the escalation plan or contacts involved in the engagement.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the escalation plan or contacts involved in the engagement.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The ARN of the engagement.</p>
        pub fn engagement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the engagement.</p>
        pub fn set_engagement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_arn = input;
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender = Some(input.into());
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender = input;
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The secure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The secure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>VOICE</code> and <code>EMAIL</code>.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn public_subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_subject = Some(input.into());
            self
        }
        /// <p>The insecure subject of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn set_public_subject(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_subject = input;
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn public_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_content = Some(input.into());
            self
        }
        /// <p>The insecure content of the message that was sent to the contact. Use this field for
        /// engagements to <code>SMS</code>.</p>
        pub fn set_public_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_content = input;
            self
        }
        /// <p>The ARN of the incident in which the engagement occurred.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_id = Some(input.into());
            self
        }
        /// <p>The ARN of the incident in which the engagement occurred.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.incident_id = input;
            self
        }
        /// <p>The time that the engagement started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time that the engagement started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time that the engagement ended.</p>
        pub fn stop_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_time = Some(input);
            self
        }
        /// <p>The time that the engagement ended.</p>
        pub fn set_stop_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngagementOutput`](crate::output::DescribeEngagementOutput)
        pub fn build(self) -> crate::output::DescribeEngagementOutput {
            crate::output::DescribeEngagementOutput {
                contact_arn: self.contact_arn,
                engagement_arn: self.engagement_arn,
                sender: self.sender,
                subject: self.subject,
                content: self.content,
                public_subject: self.public_subject,
                public_content: self.public_content,
                incident_id: self.incident_id,
                start_time: self.start_time,
                stop_time: self.stop_time,
            }
        }
    }
}
impl DescribeEngagementOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEngagementOutput`](crate::output::DescribeEngagementOutput)
    pub fn builder() -> crate::output::describe_engagement_output::Builder {
        crate::output::describe_engagement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContactChannelOutput {}
impl std::fmt::Debug for DeleteContactChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContactChannelOutput");
        formatter.finish()
    }
}
/// See [`DeleteContactChannelOutput`](crate::output::DeleteContactChannelOutput)
pub mod delete_contact_channel_output {
    /// A builder for [`DeleteContactChannelOutput`](crate::output::DeleteContactChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteContactChannelOutput`](crate::output::DeleteContactChannelOutput)
        pub fn build(self) -> crate::output::DeleteContactChannelOutput {
            crate::output::DeleteContactChannelOutput {}
        }
    }
}
impl DeleteContactChannelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteContactChannelOutput`](crate::output::DeleteContactChannelOutput)
    pub fn builder() -> crate::output::delete_contact_channel_output::Builder {
        crate::output::delete_contact_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContactOutput {}
impl std::fmt::Debug for DeleteContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContactOutput");
        formatter.finish()
    }
}
/// See [`DeleteContactOutput`](crate::output::DeleteContactOutput)
pub mod delete_contact_output {
    /// A builder for [`DeleteContactOutput`](crate::output::DeleteContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteContactOutput`](crate::output::DeleteContactOutput)
        pub fn build(self) -> crate::output::DeleteContactOutput {
            crate::output::DeleteContactOutput {}
        }
    }
}
impl DeleteContactOutput {
    /// Creates a new builder-style object to manufacture [`DeleteContactOutput`](crate::output::DeleteContactOutput)
    pub fn builder() -> crate::output::delete_contact_output::Builder {
        crate::output::delete_contact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateContactChannelOutput {}
impl std::fmt::Debug for DeactivateContactChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateContactChannelOutput");
        formatter.finish()
    }
}
/// See [`DeactivateContactChannelOutput`](crate::output::DeactivateContactChannelOutput)
pub mod deactivate_contact_channel_output {
    /// A builder for [`DeactivateContactChannelOutput`](crate::output::DeactivateContactChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeactivateContactChannelOutput`](crate::output::DeactivateContactChannelOutput)
        pub fn build(self) -> crate::output::DeactivateContactChannelOutput {
            crate::output::DeactivateContactChannelOutput {}
        }
    }
}
impl DeactivateContactChannelOutput {
    /// Creates a new builder-style object to manufacture [`DeactivateContactChannelOutput`](crate::output::DeactivateContactChannelOutput)
    pub fn builder() -> crate::output::deactivate_contact_channel_output::Builder {
        crate::output::deactivate_contact_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContactChannelOutput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub contact_channel_arn: std::option::Option<std::string::String>,
}
impl CreateContactChannelOutput {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub fn contact_channel_arn(&self) -> std::option::Option<&str> {
        self.contact_channel_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateContactChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContactChannelOutput");
        formatter.field("contact_channel_arn", &self.contact_channel_arn);
        formatter.finish()
    }
}
/// See [`CreateContactChannelOutput`](crate::output::CreateContactChannelOutput)
pub mod create_contact_channel_output {
    /// A builder for [`CreateContactChannelOutput`](crate::output::CreateContactChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactChannelOutput`](crate::output::CreateContactChannelOutput)
        pub fn build(self) -> crate::output::CreateContactChannelOutput {
            crate::output::CreateContactChannelOutput {
                contact_channel_arn: self.contact_channel_arn,
            }
        }
    }
}
impl CreateContactChannelOutput {
    /// Creates a new builder-style object to manufacture [`CreateContactChannelOutput`](crate::output::CreateContactChannelOutput)
    pub fn builder() -> crate::output::create_contact_channel_output::Builder {
        crate::output::create_contact_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContactOutput {
    /// <p>The Amazon Resource Name (ARN) of the created contact or escalation plan.</p>
    pub contact_arn: std::option::Option<std::string::String>,
}
impl CreateContactOutput {
    /// <p>The Amazon Resource Name (ARN) of the created contact or escalation plan.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContactOutput");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.finish()
    }
}
/// See [`CreateContactOutput`](crate::output::CreateContactOutput)
pub mod create_contact_output {
    /// A builder for [`CreateContactOutput`](crate::output::CreateContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the created contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the created contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactOutput`](crate::output::CreateContactOutput)
        pub fn build(self) -> crate::output::CreateContactOutput {
            crate::output::CreateContactOutput {
                contact_arn: self.contact_arn,
            }
        }
    }
}
impl CreateContactOutput {
    /// Creates a new builder-style object to manufacture [`CreateContactOutput`](crate::output::CreateContactOutput)
    pub fn builder() -> crate::output::create_contact_output::Builder {
        crate::output::create_contact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateContactChannelOutput {}
impl std::fmt::Debug for ActivateContactChannelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateContactChannelOutput");
        formatter.finish()
    }
}
/// See [`ActivateContactChannelOutput`](crate::output::ActivateContactChannelOutput)
pub mod activate_contact_channel_output {
    /// A builder for [`ActivateContactChannelOutput`](crate::output::ActivateContactChannelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ActivateContactChannelOutput`](crate::output::ActivateContactChannelOutput)
        pub fn build(self) -> crate::output::ActivateContactChannelOutput {
            crate::output::ActivateContactChannelOutput {}
        }
    }
}
impl ActivateContactChannelOutput {
    /// Creates a new builder-style object to manufacture [`ActivateContactChannelOutput`](crate::output::ActivateContactChannelOutput)
    pub fn builder() -> crate::output::activate_contact_channel_output::Builder {
        crate::output::activate_contact_channel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptPageOutput {}
impl std::fmt::Debug for AcceptPageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptPageOutput");
        formatter.finish()
    }
}
/// See [`AcceptPageOutput`](crate::output::AcceptPageOutput)
pub mod accept_page_output {
    /// A builder for [`AcceptPageOutput`](crate::output::AcceptPageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AcceptPageOutput`](crate::output::AcceptPageOutput)
        pub fn build(self) -> crate::output::AcceptPageOutput {
            crate::output::AcceptPageOutput {}
        }
    }
}
impl AcceptPageOutput {
    /// Creates a new builder-style object to manufacture [`AcceptPageOutput`](crate::output::AcceptPageOutput)
    pub fn builder() -> crate::output::accept_page_output::Builder {
        crate::output::accept_page_output::Builder::default()
    }
}
