// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides information about which field caused the exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the field that caused the exception.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Information about what caused the field to cause an exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the field that caused the exception.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Information about what caused the field to cause an exception.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field that caused the exception.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field that caused the exception.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Information about what caused the field to cause an exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about what caused the field to cause an exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details that Incident Manager uses when trying to engage the contact channel. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactChannelAddress {
    /// <p>The format is dependent on the type of the contact channel. The following are the
    /// expected formats:</p>
    /// <ul>
    /// <li>
    /// <p>SMS - '+' followed by the country code and phone number</p>
    /// </li>
    /// <li>
    /// <p>VOICE - '+' followed by the country code and phone number</p>
    /// </li>
    /// <li>
    /// <p>EMAIL - any standard email format</p>
    /// </li>
    /// </ul>
    pub simple_address: std::option::Option<std::string::String>,
}
impl ContactChannelAddress {
    /// <p>The format is dependent on the type of the contact channel. The following are the
    /// expected formats:</p>
    /// <ul>
    /// <li>
    /// <p>SMS - '+' followed by the country code and phone number</p>
    /// </li>
    /// <li>
    /// <p>VOICE - '+' followed by the country code and phone number</p>
    /// </li>
    /// <li>
    /// <p>EMAIL - any standard email format</p>
    /// </li>
    /// </ul>
    pub fn simple_address(&self) -> std::option::Option<&str> {
        self.simple_address.as_deref()
    }
}
impl std::fmt::Debug for ContactChannelAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactChannelAddress");
        formatter.field("simple_address", &self.simple_address);
        formatter.finish()
    }
}
/// See [`ContactChannelAddress`](crate::model::ContactChannelAddress)
pub mod contact_channel_address {
    /// A builder for [`ContactChannelAddress`](crate::model::ContactChannelAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simple_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The format is dependent on the type of the contact channel. The following are the
        /// expected formats:</p>
        /// <ul>
        /// <li>
        /// <p>SMS - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>VOICE - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>EMAIL - any standard email format</p>
        /// </li>
        /// </ul>
        pub fn simple_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.simple_address = Some(input.into());
            self
        }
        /// <p>The format is dependent on the type of the contact channel. The following are the
        /// expected formats:</p>
        /// <ul>
        /// <li>
        /// <p>SMS - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>VOICE - '+' followed by the country code and phone number</p>
        /// </li>
        /// <li>
        /// <p>EMAIL - any standard email format</p>
        /// </li>
        /// </ul>
        pub fn set_simple_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.simple_address = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactChannelAddress`](crate::model::ContactChannelAddress)
        pub fn build(self) -> crate::model::ContactChannelAddress {
            crate::model::ContactChannelAddress {
                simple_address: self.simple_address,
            }
        }
    }
}
impl ContactChannelAddress {
    /// Creates a new builder-style object to manufacture [`ContactChannelAddress`](crate::model::ContactChannelAddress)
    pub fn builder() -> crate::model::contact_channel_address::Builder {
        crate::model::contact_channel_address::Builder::default()
    }
}

/// <p>The stages that an escalation plan or engagement plan engages contacts and contact
/// methods in.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Plan {
    /// <p>A list of stages that the escalation plan or engagement plan uses to engage contacts and
    /// contact methods.</p>
    pub stages: std::option::Option<std::vec::Vec<crate::model::Stage>>,
}
impl Plan {
    /// <p>A list of stages that the escalation plan or engagement plan uses to engage contacts and
    /// contact methods.</p>
    pub fn stages(&self) -> std::option::Option<&[crate::model::Stage]> {
        self.stages.as_deref()
    }
}
impl std::fmt::Debug for Plan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Plan");
        formatter.field("stages", &self.stages);
        formatter.finish()
    }
}
/// See [`Plan`](crate::model::Plan)
pub mod plan {
    /// A builder for [`Plan`](crate::model::Plan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stages: std::option::Option<std::vec::Vec<crate::model::Stage>>,
    }
    impl Builder {
        /// Appends an item to `stages`.
        ///
        /// To override the contents of this collection use [`set_stages`](Self::set_stages).
        ///
        /// <p>A list of stages that the escalation plan or engagement plan uses to engage contacts and
        /// contact methods.</p>
        pub fn stages(mut self, input: impl Into<crate::model::Stage>) -> Self {
            let mut v = self.stages.unwrap_or_default();
            v.push(input.into());
            self.stages = Some(v);
            self
        }
        /// <p>A list of stages that the escalation plan or engagement plan uses to engage contacts and
        /// contact methods.</p>
        pub fn set_stages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Stage>>,
        ) -> Self {
            self.stages = input;
            self
        }
        /// Consumes the builder and constructs a [`Plan`](crate::model::Plan)
        pub fn build(self) -> crate::model::Plan {
            crate::model::Plan {
                stages: self.stages,
            }
        }
    }
}
impl Plan {
    /// Creates a new builder-style object to manufacture [`Plan`](crate::model::Plan)
    pub fn builder() -> crate::model::plan::Builder {
        crate::model::plan::Builder::default()
    }
}

/// <p>A set amount of time that an escalation plan or engagement plan engages the specified
/// contacts or contact methods.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stage {
    /// <p>The time to wait until beginning the next stage. The duration can only be set to 0 if a
    /// target is specified.</p>
    pub duration_in_minutes: std::option::Option<i32>,
    /// <p>The contacts or contact methods that the escalation plan or engagement plan is
    /// engaging.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
}
impl Stage {
    /// <p>The time to wait until beginning the next stage. The duration can only be set to 0 if a
    /// target is specified.</p>
    pub fn duration_in_minutes(&self) -> std::option::Option<i32> {
        self.duration_in_minutes
    }
    /// <p>The contacts or contact methods that the escalation plan or engagement plan is
    /// engaging.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
}
impl std::fmt::Debug for Stage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stage");
        formatter.field("duration_in_minutes", &self.duration_in_minutes);
        formatter.field("targets", &self.targets);
        formatter.finish()
    }
}
/// See [`Stage`](crate::model::Stage)
pub mod stage {
    /// A builder for [`Stage`](crate::model::Stage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration_in_minutes: std::option::Option<i32>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    }
    impl Builder {
        /// <p>The time to wait until beginning the next stage. The duration can only be set to 0 if a
        /// target is specified.</p>
        pub fn duration_in_minutes(mut self, input: i32) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>The time to wait until beginning the next stage. The duration can only be set to 0 if a
        /// target is specified.</p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The contacts or contact methods that the escalation plan or engagement plan is
        /// engaging.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The contacts or contact methods that the escalation plan or engagement plan is
        /// engaging.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Consumes the builder and constructs a [`Stage`](crate::model::Stage)
        pub fn build(self) -> crate::model::Stage {
            crate::model::Stage {
                duration_in_minutes: self.duration_in_minutes,
                targets: self.targets,
            }
        }
    }
}
impl Stage {
    /// Creates a new builder-style object to manufacture [`Stage`](crate::model::Stage)
    pub fn builder() -> crate::model::stage::Builder {
        crate::model::stage::Builder::default()
    }
}

/// <p>The contact or contact channel that's being engaged.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Target {
    /// <p>Information about the contact channel Incident Manager is engaging.</p>
    pub channel_target_info: std::option::Option<crate::model::ChannelTargetInfo>,
    /// <p>Information about the contact that Incident Manager is engaging.</p>
    pub contact_target_info: std::option::Option<crate::model::ContactTargetInfo>,
}
impl Target {
    /// <p>Information about the contact channel Incident Manager is engaging.</p>
    pub fn channel_target_info(&self) -> std::option::Option<&crate::model::ChannelTargetInfo> {
        self.channel_target_info.as_ref()
    }
    /// <p>Information about the contact that Incident Manager is engaging.</p>
    pub fn contact_target_info(&self) -> std::option::Option<&crate::model::ContactTargetInfo> {
        self.contact_target_info.as_ref()
    }
}
impl std::fmt::Debug for Target {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Target");
        formatter.field("channel_target_info", &self.channel_target_info);
        formatter.field("contact_target_info", &self.contact_target_info);
        formatter.finish()
    }
}
/// See [`Target`](crate::model::Target)
pub mod target {
    /// A builder for [`Target`](crate::model::Target)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_target_info: std::option::Option<crate::model::ChannelTargetInfo>,
        pub(crate) contact_target_info: std::option::Option<crate::model::ContactTargetInfo>,
    }
    impl Builder {
        /// <p>Information about the contact channel Incident Manager is engaging.</p>
        pub fn channel_target_info(mut self, input: crate::model::ChannelTargetInfo) -> Self {
            self.channel_target_info = Some(input);
            self
        }
        /// <p>Information about the contact channel Incident Manager is engaging.</p>
        pub fn set_channel_target_info(
            mut self,
            input: std::option::Option<crate::model::ChannelTargetInfo>,
        ) -> Self {
            self.channel_target_info = input;
            self
        }
        /// <p>Information about the contact that Incident Manager is engaging.</p>
        pub fn contact_target_info(mut self, input: crate::model::ContactTargetInfo) -> Self {
            self.contact_target_info = Some(input);
            self
        }
        /// <p>Information about the contact that Incident Manager is engaging.</p>
        pub fn set_contact_target_info(
            mut self,
            input: std::option::Option<crate::model::ContactTargetInfo>,
        ) -> Self {
            self.contact_target_info = input;
            self
        }
        /// Consumes the builder and constructs a [`Target`](crate::model::Target)
        pub fn build(self) -> crate::model::Target {
            crate::model::Target {
                channel_target_info: self.channel_target_info,
                contact_target_info: self.contact_target_info,
            }
        }
    }
}
impl Target {
    /// Creates a new builder-style object to manufacture [`Target`](crate::model::Target)
    pub fn builder() -> crate::model::target::Builder {
        crate::model::target::Builder::default()
    }
}

/// <p>The contact that Incident Manager is engaging during an incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactTargetInfo {
    /// <p>The Amazon Resource Name (ARN) of the contact.</p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value determining if the contact's acknowledgement stops the progress of
    /// stages in the plan.</p>
    pub is_essential: std::option::Option<bool>,
}
impl ContactTargetInfo {
    /// <p>The Amazon Resource Name (ARN) of the contact.</p>
    pub fn contact_id(&self) -> std::option::Option<&str> {
        self.contact_id.as_deref()
    }
    /// <p>A Boolean value determining if the contact's acknowledgement stops the progress of
    /// stages in the plan.</p>
    pub fn is_essential(&self) -> std::option::Option<bool> {
        self.is_essential
    }
}
impl std::fmt::Debug for ContactTargetInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactTargetInfo");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("is_essential", &self.is_essential);
        formatter.finish()
    }
}
/// See [`ContactTargetInfo`](crate::model::ContactTargetInfo)
pub mod contact_target_info {
    /// A builder for [`ContactTargetInfo`](crate::model::ContactTargetInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) is_essential: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>A Boolean value determining if the contact's acknowledgement stops the progress of
        /// stages in the plan.</p>
        pub fn is_essential(mut self, input: bool) -> Self {
            self.is_essential = Some(input);
            self
        }
        /// <p>A Boolean value determining if the contact's acknowledgement stops the progress of
        /// stages in the plan.</p>
        pub fn set_is_essential(mut self, input: std::option::Option<bool>) -> Self {
            self.is_essential = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactTargetInfo`](crate::model::ContactTargetInfo)
        pub fn build(self) -> crate::model::ContactTargetInfo {
            crate::model::ContactTargetInfo {
                contact_id: self.contact_id,
                is_essential: self.is_essential,
            }
        }
    }
}
impl ContactTargetInfo {
    /// Creates a new builder-style object to manufacture [`ContactTargetInfo`](crate::model::ContactTargetInfo)
    pub fn builder() -> crate::model::contact_target_info::Builder {
        crate::model::contact_target_info::Builder::default()
    }
}

/// <p>Information about the contact channel that Incident Manager uses to engage the
/// contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChannelTargetInfo {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub contact_channel_id: std::option::Option<std::string::String>,
    /// <p>The number of minutes to wait to retry sending engagement in the case the engagement
    /// initially fails.</p>
    pub retry_interval_in_minutes: std::option::Option<i32>,
}
impl ChannelTargetInfo {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub fn contact_channel_id(&self) -> std::option::Option<&str> {
        self.contact_channel_id.as_deref()
    }
    /// <p>The number of minutes to wait to retry sending engagement in the case the engagement
    /// initially fails.</p>
    pub fn retry_interval_in_minutes(&self) -> std::option::Option<i32> {
        self.retry_interval_in_minutes
    }
}
impl std::fmt::Debug for ChannelTargetInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChannelTargetInfo");
        formatter.field("contact_channel_id", &self.contact_channel_id);
        formatter.field("retry_interval_in_minutes", &self.retry_interval_in_minutes);
        formatter.finish()
    }
}
/// See [`ChannelTargetInfo`](crate::model::ChannelTargetInfo)
pub mod channel_target_info {
    /// A builder for [`ChannelTargetInfo`](crate::model::ChannelTargetInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_id: std::option::Option<std::string::String>,
        pub(crate) retry_interval_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_id = input;
            self
        }
        /// <p>The number of minutes to wait to retry sending engagement in the case the engagement
        /// initially fails.</p>
        pub fn retry_interval_in_minutes(mut self, input: i32) -> Self {
            self.retry_interval_in_minutes = Some(input);
            self
        }
        /// <p>The number of minutes to wait to retry sending engagement in the case the engagement
        /// initially fails.</p>
        pub fn set_retry_interval_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_interval_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`ChannelTargetInfo`](crate::model::ChannelTargetInfo)
        pub fn build(self) -> crate::model::ChannelTargetInfo {
            crate::model::ChannelTargetInfo {
                contact_channel_id: self.contact_channel_id,
                retry_interval_in_minutes: self.retry_interval_in_minutes,
            }
        }
    }
}
impl ChannelTargetInfo {
    /// Creates a new builder-style object to manufacture [`ChannelTargetInfo`](crate::model::ChannelTargetInfo)
    pub fn builder() -> crate::model::channel_target_info::Builder {
        crate::model::channel_target_info::Builder::default()
    }
}

/// <p>A container of a key-value name pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Name of the
    /// object
    /// key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Name of the
    /// object
    /// key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the
        /// object
        /// key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Name of the
        /// object
        /// key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Incident Manager engaging a contact's contact channel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Page {
    /// <p>The Amazon Resource Name (ARN) of the page to the contact channel.</p>
    pub page_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the engagement that this page is part of.</p>
    pub engagement_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the contact that Incident Manager is engaging.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The user that started the engagement.</p>
    pub sender: std::option::Option<std::string::String>,
    /// <p>The ARN of the incident that's engaging the contact channel.</p>
    pub incident_id: std::option::Option<std::string::String>,
    /// <p>The time that Incident Manager engaged the contact channel.</p>
    pub sent_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the message was delivered to the contact channel.</p>
    pub delivery_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the contact channel acknowledged engagement.</p>
    pub read_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Page {
    /// <p>The Amazon Resource Name (ARN) of the page to the contact channel.</p>
    pub fn page_arn(&self) -> std::option::Option<&str> {
        self.page_arn.as_deref()
    }
    /// <p>The ARN of the engagement that this page is part of.</p>
    pub fn engagement_arn(&self) -> std::option::Option<&str> {
        self.engagement_arn.as_deref()
    }
    /// <p>The ARN of the contact that Incident Manager is engaging.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The user that started the engagement.</p>
    pub fn sender(&self) -> std::option::Option<&str> {
        self.sender.as_deref()
    }
    /// <p>The ARN of the incident that's engaging the contact channel.</p>
    pub fn incident_id(&self) -> std::option::Option<&str> {
        self.incident_id.as_deref()
    }
    /// <p>The time that Incident Manager engaged the contact channel.</p>
    pub fn sent_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.sent_time.as_ref()
    }
    /// <p>The time the message was delivered to the contact channel.</p>
    pub fn delivery_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.delivery_time.as_ref()
    }
    /// <p>The time that the contact channel acknowledged engagement.</p>
    pub fn read_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.read_time.as_ref()
    }
}
impl std::fmt::Debug for Page {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Page");
        formatter.field("page_arn", &self.page_arn);
        formatter.field("engagement_arn", &self.engagement_arn);
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("sender", &self.sender);
        formatter.field("incident_id", &self.incident_id);
        formatter.field("sent_time", &self.sent_time);
        formatter.field("delivery_time", &self.delivery_time);
        formatter.field("read_time", &self.read_time);
        formatter.finish()
    }
}
/// See [`Page`](crate::model::Page)
pub mod page {
    /// A builder for [`Page`](crate::model::Page)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_arn: std::option::Option<std::string::String>,
        pub(crate) engagement_arn: std::option::Option<std::string::String>,
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) sender: std::option::Option<std::string::String>,
        pub(crate) incident_id: std::option::Option<std::string::String>,
        pub(crate) sent_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) delivery_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) read_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the page to the contact channel.</p>
        pub fn page_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the page to the contact channel.</p>
        pub fn set_page_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_arn = input;
            self
        }
        /// <p>The ARN of the engagement that this page is part of.</p>
        pub fn engagement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the engagement that this page is part of.</p>
        pub fn set_engagement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_arn = input;
            self
        }
        /// <p>The ARN of the contact that Incident Manager is engaging.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact that Incident Manager is engaging.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender = Some(input.into());
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender = input;
            self
        }
        /// <p>The ARN of the incident that's engaging the contact channel.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_id = Some(input.into());
            self
        }
        /// <p>The ARN of the incident that's engaging the contact channel.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.incident_id = input;
            self
        }
        /// <p>The time that Incident Manager engaged the contact channel.</p>
        pub fn sent_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.sent_time = Some(input);
            self
        }
        /// <p>The time that Incident Manager engaged the contact channel.</p>
        pub fn set_sent_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.sent_time = input;
            self
        }
        /// <p>The time the message was delivered to the contact channel.</p>
        pub fn delivery_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.delivery_time = Some(input);
            self
        }
        /// <p>The time the message was delivered to the contact channel.</p>
        pub fn set_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.delivery_time = input;
            self
        }
        /// <p>The time that the contact channel acknowledged engagement.</p>
        pub fn read_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.read_time = Some(input);
            self
        }
        /// <p>The time that the contact channel acknowledged engagement.</p>
        pub fn set_read_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.read_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Page`](crate::model::Page)
        pub fn build(self) -> crate::model::Page {
            crate::model::Page {
                page_arn: self.page_arn,
                engagement_arn: self.engagement_arn,
                contact_arn: self.contact_arn,
                sender: self.sender,
                incident_id: self.incident_id,
                sent_time: self.sent_time,
                delivery_time: self.delivery_time,
                read_time: self.read_time,
            }
        }
    }
}
impl Page {
    /// Creates a new builder-style object to manufacture [`Page`](crate::model::Page)
    pub fn builder() -> crate::model::page::Builder {
        crate::model::page::Builder::default()
    }
}

/// <p>Records events during an engagement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Receipt {
    /// <p>The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.</p>
    pub contact_channel_arn: std::option::Option<std::string::String>,
    /// <p>The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and
    /// <code>READ</code>.</p>
    pub receipt_type: std::option::Option<crate::model::ReceiptType>,
    /// <p>Information provided during the page acknowledgement.</p>
    pub receipt_info: std::option::Option<std::string::String>,
    /// <p>The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or
    /// <code>READ</code>.</p>
    pub receipt_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Receipt {
    /// <p>The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.</p>
    pub fn contact_channel_arn(&self) -> std::option::Option<&str> {
        self.contact_channel_arn.as_deref()
    }
    /// <p>The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and
    /// <code>READ</code>.</p>
    pub fn receipt_type(&self) -> std::option::Option<&crate::model::ReceiptType> {
        self.receipt_type.as_ref()
    }
    /// <p>Information provided during the page acknowledgement.</p>
    pub fn receipt_info(&self) -> std::option::Option<&str> {
        self.receipt_info.as_deref()
    }
    /// <p>The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or
    /// <code>READ</code>.</p>
    pub fn receipt_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.receipt_time.as_ref()
    }
}
impl std::fmt::Debug for Receipt {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Receipt");
        formatter.field("contact_channel_arn", &self.contact_channel_arn);
        formatter.field("receipt_type", &self.receipt_type);
        formatter.field("receipt_info", &self.receipt_info);
        formatter.field("receipt_time", &self.receipt_time);
        formatter.finish()
    }
}
/// See [`Receipt`](crate::model::Receipt)
pub mod receipt {
    /// A builder for [`Receipt`](crate::model::Receipt)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_arn: std::option::Option<std::string::String>,
        pub(crate) receipt_type: std::option::Option<crate::model::ReceiptType>,
        pub(crate) receipt_info: std::option::Option<std::string::String>,
        pub(crate) receipt_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.</p>
        pub fn contact_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.</p>
        pub fn set_contact_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_arn = input;
            self
        }
        /// <p>The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and
        /// <code>READ</code>.</p>
        pub fn receipt_type(mut self, input: crate::model::ReceiptType) -> Self {
            self.receipt_type = Some(input);
            self
        }
        /// <p>The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and
        /// <code>READ</code>.</p>
        pub fn set_receipt_type(
            mut self,
            input: std::option::Option<crate::model::ReceiptType>,
        ) -> Self {
            self.receipt_type = input;
            self
        }
        /// <p>Information provided during the page acknowledgement.</p>
        pub fn receipt_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.receipt_info = Some(input.into());
            self
        }
        /// <p>Information provided during the page acknowledgement.</p>
        pub fn set_receipt_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.receipt_info = input;
            self
        }
        /// <p>The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or
        /// <code>READ</code>.</p>
        pub fn receipt_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.receipt_time = Some(input);
            self
        }
        /// <p>The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or
        /// <code>READ</code>.</p>
        pub fn set_receipt_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.receipt_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Receipt`](crate::model::Receipt)
        pub fn build(self) -> crate::model::Receipt {
            crate::model::Receipt {
                contact_channel_arn: self.contact_channel_arn,
                receipt_type: self.receipt_type,
                receipt_info: self.receipt_info,
                receipt_time: self.receipt_time,
            }
        }
    }
}
impl Receipt {
    /// Creates a new builder-style object to manufacture [`Receipt`](crate::model::Receipt)
    pub fn builder() -> crate::model::receipt::Builder {
        crate::model::receipt::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReceiptType {
    #[allow(missing_docs)] // documentation missing in model
    Delivered,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    #[allow(missing_docs)] // documentation missing in model
    Sent,
    #[allow(missing_docs)] // documentation missing in model
    Stop,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReceiptType {
    fn from(s: &str) -> Self {
        match s {
            "DELIVERED" => ReceiptType::Delivered,
            "ERROR" => ReceiptType::Error,
            "READ" => ReceiptType::Read,
            "SENT" => ReceiptType::Sent,
            "STOP" => ReceiptType::Stop,
            other => ReceiptType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReceiptType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReceiptType::from(s))
    }
}
impl ReceiptType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReceiptType::Delivered => "DELIVERED",
            ReceiptType::Error => "ERROR",
            ReceiptType::Read => "READ",
            ReceiptType::Sent => "SENT",
            ReceiptType::Stop => "STOP",
            ReceiptType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELIVERED", "ERROR", "READ", "SENT", "STOP"]
    }
}
impl AsRef<str> for ReceiptType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Incident Manager reaching out to a contact or escalation plan to engage contact during an
/// incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Engagement {
    /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
    pub engagement_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the escalation plan or contact that Incident Manager is engaging.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The user that started the engagement.</p>
    pub sender: std::option::Option<std::string::String>,
    /// <p>The ARN of the incident that's engaging the contact.</p>
    pub incident_id: std::option::Option<std::string::String>,
    /// <p>The time that the engagement began.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the engagement ended.</p>
    pub stop_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Engagement {
    /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
    pub fn engagement_arn(&self) -> std::option::Option<&str> {
        self.engagement_arn.as_deref()
    }
    /// <p>The ARN of the escalation plan or contact that Incident Manager is engaging.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The user that started the engagement.</p>
    pub fn sender(&self) -> std::option::Option<&str> {
        self.sender.as_deref()
    }
    /// <p>The ARN of the incident that's engaging the contact.</p>
    pub fn incident_id(&self) -> std::option::Option<&str> {
        self.incident_id.as_deref()
    }
    /// <p>The time that the engagement began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The time that the engagement ended.</p>
    pub fn stop_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.stop_time.as_ref()
    }
}
impl std::fmt::Debug for Engagement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Engagement");
        formatter.field("engagement_arn", &self.engagement_arn);
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("sender", &self.sender);
        formatter.field("incident_id", &self.incident_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("stop_time", &self.stop_time);
        formatter.finish()
    }
}
/// See [`Engagement`](crate::model::Engagement)
pub mod engagement {
    /// A builder for [`Engagement`](crate::model::Engagement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engagement_arn: std::option::Option<std::string::String>,
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) sender: std::option::Option<std::string::String>,
        pub(crate) incident_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stop_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn engagement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.engagement_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the engagement.</p>
        pub fn set_engagement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engagement_arn = input;
            self
        }
        /// <p>The ARN of the escalation plan or contact that Incident Manager is engaging.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the escalation plan or contact that Incident Manager is engaging.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn sender(mut self, input: impl Into<std::string::String>) -> Self {
            self.sender = Some(input.into());
            self
        }
        /// <p>The user that started the engagement.</p>
        pub fn set_sender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sender = input;
            self
        }
        /// <p>The ARN of the incident that's engaging the contact.</p>
        pub fn incident_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.incident_id = Some(input.into());
            self
        }
        /// <p>The ARN of the incident that's engaging the contact.</p>
        pub fn set_incident_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.incident_id = input;
            self
        }
        /// <p>The time that the engagement began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time that the engagement began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time that the engagement ended.</p>
        pub fn stop_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stop_time = Some(input);
            self
        }
        /// <p>The time that the engagement ended.</p>
        pub fn set_stop_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stop_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Engagement`](crate::model::Engagement)
        pub fn build(self) -> crate::model::Engagement {
            crate::model::Engagement {
                engagement_arn: self.engagement_arn,
                contact_arn: self.contact_arn,
                sender: self.sender,
                incident_id: self.incident_id,
                start_time: self.start_time,
                stop_time: self.stop_time,
            }
        }
    }
}
impl Engagement {
    /// Creates a new builder-style object to manufacture [`Engagement`](crate::model::Engagement)
    pub fn builder() -> crate::model::engagement::Builder {
        crate::model::engagement::Builder::default()
    }
}

/// <p>A range of between two set times</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeRange {
    /// <p>The start of the time range.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end of the time range.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl TimeRange {
    /// <p>The start of the time range.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end of the time range.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for TimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeRange");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`TimeRange`](crate::model::TimeRange)
pub mod time_range {
    /// A builder for [`TimeRange`](crate::model::TimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The start of the time range.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time range.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time range.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time range.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeRange`](crate::model::TimeRange)
        pub fn build(self) -> crate::model::TimeRange {
            crate::model::TimeRange {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl TimeRange {
    /// Creates a new builder-style object to manufacture [`TimeRange`](crate::model::TimeRange)
    pub fn builder() -> crate::model::time_range::Builder {
        crate::model::time_range::Builder::default()
    }
}

/// <p>A personal contact or escalation plan that Incident Manager engages during an
/// incident.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Contact {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The unique and identifiable alias of the contact or escalation plan.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The full name of the contact or escalation plan.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an
    /// escalation plan is type <code>ESCALATION</code>.</p>
    pub r#type: std::option::Option<crate::model::ContactType>,
}
impl Contact {
    /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The unique and identifiable alias of the contact or escalation plan.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The full name of the contact or escalation plan.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an
    /// escalation plan is type <code>ESCALATION</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ContactType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Contact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Contact");
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("alias", &self.alias);
        formatter.field("display_name", &self.display_name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Contact`](crate::model::Contact)
pub mod contact {
    /// A builder for [`Contact`](crate::model::Contact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ContactType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact or escalation plan.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The unique and identifiable alias of the contact or escalation plan.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The unique and identifiable alias of the contact or escalation plan.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The full name of the contact or escalation plan.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an
        /// escalation plan is type <code>ESCALATION</code>.</p>
        pub fn r#type(mut self, input: crate::model::ContactType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an
        /// escalation plan is type <code>ESCALATION</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ContactType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Contact`](crate::model::Contact)
        pub fn build(self) -> crate::model::Contact {
            crate::model::Contact {
                contact_arn: self.contact_arn,
                alias: self.alias,
                display_name: self.display_name,
                r#type: self.r#type,
            }
        }
    }
}
impl Contact {
    /// Creates a new builder-style object to manufacture [`Contact`](crate::model::Contact)
    pub fn builder() -> crate::model::contact::Builder {
        crate::model::contact::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactType {
    #[allow(missing_docs)] // documentation missing in model
    Escalation,
    #[allow(missing_docs)] // documentation missing in model
    Personal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactType {
    fn from(s: &str) -> Self {
        match s {
            "ESCALATION" => ContactType::Escalation,
            "PERSONAL" => ContactType::Personal,
            other => ContactType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactType::from(s))
    }
}
impl ContactType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactType::Escalation => "ESCALATION",
            ContactType::Personal => "PERSONAL",
            ContactType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ESCALATION", "PERSONAL"]
    }
}
impl AsRef<str> for ContactType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The method that Incident Manager uses to engage a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactChannel {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub contact_channel_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the contact that contains the contact channel.</p>
    pub contact_arn: std::option::Option<std::string::String>,
    /// <p>The name of the contact channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the contact channel. Incident Manager supports three contact methods:</p>
    /// <ul>
    /// <li>
    /// <p>SMS</p>
    /// </li>
    /// <li>
    /// <p>VOICE</p>
    /// </li>
    /// <li>
    /// <p>EMAIL</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ChannelType>,
    /// <p>The details that Incident Manager uses when trying to engage the contact channel.</p>
    pub delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
    /// <p>A Boolean value describing if the contact channel has been activated or not. If the
    /// contact channel isn't activated, Incident Manager can't engage the contact through it. </p>
    pub activation_status: std::option::Option<crate::model::ActivationStatus>,
}
impl ContactChannel {
    /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
    pub fn contact_channel_arn(&self) -> std::option::Option<&str> {
        self.contact_channel_arn.as_deref()
    }
    /// <p>The ARN of the contact that contains the contact channel.</p>
    pub fn contact_arn(&self) -> std::option::Option<&str> {
        self.contact_arn.as_deref()
    }
    /// <p>The name of the contact channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the contact channel. Incident Manager supports three contact methods:</p>
    /// <ul>
    /// <li>
    /// <p>SMS</p>
    /// </li>
    /// <li>
    /// <p>VOICE</p>
    /// </li>
    /// <li>
    /// <p>EMAIL</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.r#type.as_ref()
    }
    /// <p>The details that Incident Manager uses when trying to engage the contact channel.</p>
    pub fn delivery_address(&self) -> std::option::Option<&crate::model::ContactChannelAddress> {
        self.delivery_address.as_ref()
    }
    /// <p>A Boolean value describing if the contact channel has been activated or not. If the
    /// contact channel isn't activated, Incident Manager can't engage the contact through it. </p>
    pub fn activation_status(&self) -> std::option::Option<&crate::model::ActivationStatus> {
        self.activation_status.as_ref()
    }
}
impl std::fmt::Debug for ContactChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactChannel");
        formatter.field("contact_channel_arn", &self.contact_channel_arn);
        formatter.field("contact_arn", &self.contact_arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("delivery_address", &self.delivery_address);
        formatter.field("activation_status", &self.activation_status);
        formatter.finish()
    }
}
/// See [`ContactChannel`](crate::model::ContactChannel)
pub mod contact_channel {
    /// A builder for [`ContactChannel`](crate::model::ContactChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_channel_arn: std::option::Option<std::string::String>,
        pub(crate) contact_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelType>,
        pub(crate) delivery_address: std::option::Option<crate::model::ContactChannelAddress>,
        pub(crate) activation_status: std::option::Option<crate::model::ActivationStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn contact_channel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_channel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact channel.</p>
        pub fn set_contact_channel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_channel_arn = input;
            self
        }
        /// <p>The ARN of the contact that contains the contact channel.</p>
        pub fn contact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the contact that contains the contact channel.</p>
        pub fn set_contact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_arn = input;
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the contact channel. Incident Manager supports three contact methods:</p>
        /// <ul>
        /// <li>
        /// <p>SMS</p>
        /// </li>
        /// <li>
        /// <p>VOICE</p>
        /// </li>
        /// <li>
        /// <p>EMAIL</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the contact channel. Incident Manager supports three contact methods:</p>
        /// <ul>
        /// <li>
        /// <p>SMS</p>
        /// </li>
        /// <li>
        /// <p>VOICE</p>
        /// </li>
        /// <li>
        /// <p>EMAIL</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel.</p>
        pub fn delivery_address(mut self, input: crate::model::ContactChannelAddress) -> Self {
            self.delivery_address = Some(input);
            self
        }
        /// <p>The details that Incident Manager uses when trying to engage the contact channel.</p>
        pub fn set_delivery_address(
            mut self,
            input: std::option::Option<crate::model::ContactChannelAddress>,
        ) -> Self {
            self.delivery_address = input;
            self
        }
        /// <p>A Boolean value describing if the contact channel has been activated or not. If the
        /// contact channel isn't activated, Incident Manager can't engage the contact through it. </p>
        pub fn activation_status(mut self, input: crate::model::ActivationStatus) -> Self {
            self.activation_status = Some(input);
            self
        }
        /// <p>A Boolean value describing if the contact channel has been activated or not. If the
        /// contact channel isn't activated, Incident Manager can't engage the contact through it. </p>
        pub fn set_activation_status(
            mut self,
            input: std::option::Option<crate::model::ActivationStatus>,
        ) -> Self {
            self.activation_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactChannel`](crate::model::ContactChannel)
        pub fn build(self) -> crate::model::ContactChannel {
            crate::model::ContactChannel {
                contact_channel_arn: self.contact_channel_arn,
                contact_arn: self.contact_arn,
                name: self.name,
                r#type: self.r#type,
                delivery_address: self.delivery_address,
                activation_status: self.activation_status,
            }
        }
    }
}
impl ContactChannel {
    /// Creates a new builder-style object to manufacture [`ContactChannel`](crate::model::ContactChannel)
    pub fn builder() -> crate::model::contact_channel::Builder {
        crate::model::contact_channel::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActivationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activated,
    #[allow(missing_docs)] // documentation missing in model
    NotActivated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActivationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATED" => ActivationStatus::Activated,
            "NOT_ACTIVATED" => ActivationStatus::NotActivated,
            other => ActivationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActivationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActivationStatus::from(s))
    }
}
impl ActivationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActivationStatus::Activated => "ACTIVATED",
            ActivationStatus::NotActivated => "NOT_ACTIVATED",
            ActivationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVATED", "NOT_ACTIVATED"]
    }
}
impl AsRef<str> for ActivationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelType {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelType {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL" => ChannelType::Email,
            "SMS" => ChannelType::Sms,
            "VOICE" => ChannelType::Voice,
            other => ChannelType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelType::from(s))
    }
}
impl ChannelType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelType::Email => "EMAIL",
            ChannelType::Sms => "SMS",
            ChannelType::Voice => "VOICE",
            ChannelType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMAIL", "SMS", "VOICE"]
    }
}
impl AsRef<str> for ChannelType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AcceptCodeValidation {
    #[allow(missing_docs)] // documentation missing in model
    Enforce,
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AcceptCodeValidation {
    fn from(s: &str) -> Self {
        match s {
            "ENFORCE" => AcceptCodeValidation::Enforce,
            "IGNORE" => AcceptCodeValidation::Ignore,
            other => AcceptCodeValidation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AcceptCodeValidation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AcceptCodeValidation::from(s))
    }
}
impl AcceptCodeValidation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AcceptCodeValidation::Enforce => "ENFORCE",
            AcceptCodeValidation::Ignore => "IGNORE",
            AcceptCodeValidation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENFORCE", "IGNORE"]
    }
}
impl AsRef<str> for AcceptCodeValidation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AcceptType {
    #[allow(missing_docs)] // documentation missing in model
    Delivered,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AcceptType {
    fn from(s: &str) -> Self {
        match s {
            "DELIVERED" => AcceptType::Delivered,
            "READ" => AcceptType::Read,
            other => AcceptType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AcceptType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AcceptType::from(s))
    }
}
impl AcceptType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AcceptType::Delivered => "DELIVERED",
            AcceptType::Read => "READ",
            AcceptType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELIVERED", "READ"]
    }
}
impl AsRef<str> for AcceptType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
