// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The result body of the UpdateServiceSetting API operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceSettingOutput {}
impl std::fmt::Debug for UpdateServiceSettingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceSettingOutput");
        formatter.finish()
    }
}
/// See [`UpdateServiceSettingOutput`](crate::output::UpdateServiceSettingOutput)
pub mod update_service_setting_output {
    /// A builder for [`UpdateServiceSettingOutput`](crate::output::UpdateServiceSettingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateServiceSettingOutput`](crate::output::UpdateServiceSettingOutput)
        pub fn build(self) -> crate::output::UpdateServiceSettingOutput {
            crate::output::UpdateServiceSettingOutput {}
        }
    }
}
impl UpdateServiceSettingOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceSettingOutput`](crate::output::UpdateServiceSettingOutput)
    pub fn builder() -> crate::output::update_service_setting_output::Builder {
        crate::output::update_service_setting_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceDataSyncOutput {}
impl std::fmt::Debug for UpdateResourceDataSyncOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceDataSyncOutput");
        formatter.finish()
    }
}
/// See [`UpdateResourceDataSyncOutput`](crate::output::UpdateResourceDataSyncOutput)
pub mod update_resource_data_sync_output {
    /// A builder for [`UpdateResourceDataSyncOutput`](crate::output::UpdateResourceDataSyncOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateResourceDataSyncOutput`](crate::output::UpdateResourceDataSyncOutput)
        pub fn build(self) -> crate::output::UpdateResourceDataSyncOutput {
            crate::output::UpdateResourceDataSyncOutput {}
        }
    }
}
impl UpdateResourceDataSyncOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResourceDataSyncOutput`](crate::output::UpdateResourceDataSyncOutput)
    pub fn builder() -> crate::output::update_resource_data_sync_output::Builder {
        crate::output::update_resource_data_sync_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePatchBaselineOutput {
    /// <p>The ID of the deleted patch baseline.</p>
    pub baseline_id: std::option::Option<std::string::String>,
    /// <p>The name of the patch baseline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The operating system rule used by the updated patch baseline.</p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>A set of global filters used to exclude patches from the baseline.</p>
    pub global_filters: std::option::Option<crate::model::PatchFilterGroup>,
    /// <p>A set of rules used to include patches in the baseline.</p>
    pub approval_rules: std::option::Option<crate::model::PatchRuleGroup>,
    /// <p>A list of explicitly approved patches for the baseline.</p>
    pub approved_patches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The compliance severity level assigned to the patch baseline after the update completed.</p>
    pub approved_patches_compliance_level: std::option::Option<crate::model::PatchComplianceLevel>,
    /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    pub approved_patches_enable_non_security: std::option::Option<bool>,
    /// <p>A list of explicitly rejected patches for the baseline.</p>
    pub rejected_patches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
    pub rejected_patches_action: std::option::Option<crate::model::PatchAction>,
    /// <p>The date when the patch baseline was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the patch baseline was last modified.</p>
    pub modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A description of the patch baseline.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
}
impl UpdatePatchBaselineOutput {
    /// <p>The ID of the deleted patch baseline.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
    /// <p>The name of the patch baseline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The operating system rule used by the updated patch baseline.</p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
    /// <p>A set of global filters used to exclude patches from the baseline.</p>
    pub fn global_filters(&self) -> std::option::Option<&crate::model::PatchFilterGroup> {
        self.global_filters.as_ref()
    }
    /// <p>A set of rules used to include patches in the baseline.</p>
    pub fn approval_rules(&self) -> std::option::Option<&crate::model::PatchRuleGroup> {
        self.approval_rules.as_ref()
    }
    /// <p>A list of explicitly approved patches for the baseline.</p>
    pub fn approved_patches(&self) -> std::option::Option<&[std::string::String]> {
        self.approved_patches.as_deref()
    }
    /// <p>The compliance severity level assigned to the patch baseline after the update completed.</p>
    pub fn approved_patches_compliance_level(
        &self,
    ) -> std::option::Option<&crate::model::PatchComplianceLevel> {
        self.approved_patches_compliance_level.as_ref()
    }
    /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    pub fn approved_patches_enable_non_security(&self) -> std::option::Option<bool> {
        self.approved_patches_enable_non_security
    }
    /// <p>A list of explicitly rejected patches for the baseline.</p>
    pub fn rejected_patches(&self) -> std::option::Option<&[std::string::String]> {
        self.rejected_patches.as_deref()
    }
    /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
    pub fn rejected_patches_action(&self) -> std::option::Option<&crate::model::PatchAction> {
        self.rejected_patches_action.as_ref()
    }
    /// <p>The date when the patch baseline was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The date when the patch baseline was last modified.</p>
    pub fn modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_date.as_ref()
    }
    /// <p>A description of the patch baseline.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::PatchSource]> {
        self.sources.as_deref()
    }
}
impl std::fmt::Debug for UpdatePatchBaselineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePatchBaselineOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.field("name", &self.name);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("global_filters", &self.global_filters);
        formatter.field("approval_rules", &self.approval_rules);
        formatter.field("approved_patches", &self.approved_patches);
        formatter.field(
            "approved_patches_compliance_level",
            &self.approved_patches_compliance_level,
        );
        formatter.field(
            "approved_patches_enable_non_security",
            &self.approved_patches_enable_non_security,
        );
        formatter.field("rejected_patches", &self.rejected_patches);
        formatter.field("rejected_patches_action", &self.rejected_patches_action);
        formatter.field("created_date", &self.created_date);
        formatter.field("modified_date", &self.modified_date);
        formatter.field("description", &self.description);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}
/// See [`UpdatePatchBaselineOutput`](crate::output::UpdatePatchBaselineOutput)
pub mod update_patch_baseline_output {
    /// A builder for [`UpdatePatchBaselineOutput`](crate::output::UpdatePatchBaselineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) global_filters: std::option::Option<crate::model::PatchFilterGroup>,
        pub(crate) approval_rules: std::option::Option<crate::model::PatchRuleGroup>,
        pub(crate) approved_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) approved_patches_compliance_level:
            std::option::Option<crate::model::PatchComplianceLevel>,
        pub(crate) approved_patches_enable_non_security: std::option::Option<bool>,
        pub(crate) rejected_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rejected_patches_action: std::option::Option<crate::model::PatchAction>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
    }
    impl Builder {
        /// <p>The ID of the deleted patch baseline.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the deleted patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The operating system rule used by the updated patch baseline.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system rule used by the updated patch baseline.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>A set of global filters used to exclude patches from the baseline.</p>
        pub fn global_filters(mut self, input: crate::model::PatchFilterGroup) -> Self {
            self.global_filters = Some(input);
            self
        }
        /// <p>A set of global filters used to exclude patches from the baseline.</p>
        pub fn set_global_filters(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.global_filters = input;
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn approval_rules(mut self, input: crate::model::PatchRuleGroup) -> Self {
            self.approval_rules = Some(input);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<crate::model::PatchRuleGroup>,
        ) -> Self {
            self.approval_rules = input;
            self
        }
        /// Appends an item to `approved_patches`.
        ///
        /// To override the contents of this collection use [`set_approved_patches`](Self::set_approved_patches).
        ///
        /// <p>A list of explicitly approved patches for the baseline.</p>
        pub fn approved_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.approved_patches.unwrap_or_default();
            v.push(input.into());
            self.approved_patches = Some(v);
            self
        }
        /// <p>A list of explicitly approved patches for the baseline.</p>
        pub fn set_approved_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approved_patches = input;
            self
        }
        /// <p>The compliance severity level assigned to the patch baseline after the update completed.</p>
        pub fn approved_patches_compliance_level(
            mut self,
            input: crate::model::PatchComplianceLevel,
        ) -> Self {
            self.approved_patches_compliance_level = Some(input);
            self
        }
        /// <p>The compliance severity level assigned to the patch baseline after the update completed.</p>
        pub fn set_approved_patches_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.approved_patches_compliance_level = input;
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
        pub fn approved_patches_enable_non_security(mut self, input: bool) -> Self {
            self.approved_patches_enable_non_security = Some(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
        pub fn set_approved_patches_enable_non_security(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.approved_patches_enable_non_security = input;
            self
        }
        /// Appends an item to `rejected_patches`.
        ///
        /// To override the contents of this collection use [`set_rejected_patches`](Self::set_rejected_patches).
        ///
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        pub fn rejected_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rejected_patches.unwrap_or_default();
            v.push(input.into());
            self.rejected_patches = Some(v);
            self
        }
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        pub fn set_rejected_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rejected_patches = input;
            self
        }
        /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
        pub fn rejected_patches_action(mut self, input: crate::model::PatchAction) -> Self {
            self.rejected_patches_action = Some(input);
            self
        }
        /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
        pub fn set_rejected_patches_action(
            mut self,
            input: std::option::Option<crate::model::PatchAction>,
        ) -> Self {
            self.rejected_patches_action = input;
            self
        }
        /// <p>The date when the patch baseline was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date when the patch baseline was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The date when the patch baseline was last modified.</p>
        pub fn modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_date = Some(input);
            self
        }
        /// <p>The date when the patch baseline was last modified.</p>
        pub fn set_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_date = input;
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn sources(mut self, input: crate::model::PatchSource) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePatchBaselineOutput`](crate::output::UpdatePatchBaselineOutput)
        pub fn build(self) -> crate::output::UpdatePatchBaselineOutput {
            crate::output::UpdatePatchBaselineOutput {
                baseline_id: self.baseline_id,
                name: self.name,
                operating_system: self.operating_system,
                global_filters: self.global_filters,
                approval_rules: self.approval_rules,
                approved_patches: self.approved_patches,
                approved_patches_compliance_level: self.approved_patches_compliance_level,
                approved_patches_enable_non_security: self.approved_patches_enable_non_security,
                rejected_patches: self.rejected_patches,
                rejected_patches_action: self.rejected_patches_action,
                created_date: self.created_date,
                modified_date: self.modified_date,
                description: self.description,
                sources: self.sources,
            }
        }
    }
}
impl UpdatePatchBaselineOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePatchBaselineOutput`](crate::output::UpdatePatchBaselineOutput)
    pub fn builder() -> crate::output::update_patch_baseline_output::Builder {
        crate::output::update_patch_baseline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOpsMetadataOutput {
    /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object that was updated.</p>
    pub ops_metadata_arn: std::option::Option<std::string::String>,
}
impl UpdateOpsMetadataOutput {
    /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object that was updated.</p>
    pub fn ops_metadata_arn(&self) -> std::option::Option<&str> {
        self.ops_metadata_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateOpsMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOpsMetadataOutput");
        formatter.field("ops_metadata_arn", &self.ops_metadata_arn);
        formatter.finish()
    }
}
/// See [`UpdateOpsMetadataOutput`](crate::output::UpdateOpsMetadataOutput)
pub mod update_ops_metadata_output {
    /// A builder for [`UpdateOpsMetadataOutput`](crate::output::UpdateOpsMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_metadata_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object that was updated.</p>
        pub fn ops_metadata_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_metadata_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object that was updated.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_metadata_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOpsMetadataOutput`](crate::output::UpdateOpsMetadataOutput)
        pub fn build(self) -> crate::output::UpdateOpsMetadataOutput {
            crate::output::UpdateOpsMetadataOutput {
                ops_metadata_arn: self.ops_metadata_arn,
            }
        }
    }
}
impl UpdateOpsMetadataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateOpsMetadataOutput`](crate::output::UpdateOpsMetadataOutput)
    pub fn builder() -> crate::output::update_ops_metadata_output::Builder {
        crate::output::update_ops_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOpsItemOutput {}
impl std::fmt::Debug for UpdateOpsItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOpsItemOutput");
        formatter.finish()
    }
}
/// See [`UpdateOpsItemOutput`](crate::output::UpdateOpsItemOutput)
pub mod update_ops_item_output {
    /// A builder for [`UpdateOpsItemOutput`](crate::output::UpdateOpsItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateOpsItemOutput`](crate::output::UpdateOpsItemOutput)
        pub fn build(self) -> crate::output::UpdateOpsItemOutput {
            crate::output::UpdateOpsItemOutput {}
        }
    }
}
impl UpdateOpsItemOutput {
    /// Creates a new builder-style object to manufacture [`UpdateOpsItemOutput`](crate::output::UpdateOpsItemOutput)
    pub fn builder() -> crate::output::update_ops_item_output::Builder {
        crate::output::update_ops_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateManagedInstanceRoleOutput {}
impl std::fmt::Debug for UpdateManagedInstanceRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateManagedInstanceRoleOutput");
        formatter.finish()
    }
}
/// See [`UpdateManagedInstanceRoleOutput`](crate::output::UpdateManagedInstanceRoleOutput)
pub mod update_managed_instance_role_output {
    /// A builder for [`UpdateManagedInstanceRoleOutput`](crate::output::UpdateManagedInstanceRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateManagedInstanceRoleOutput`](crate::output::UpdateManagedInstanceRoleOutput)
        pub fn build(self) -> crate::output::UpdateManagedInstanceRoleOutput {
            crate::output::UpdateManagedInstanceRoleOutput {}
        }
    }
}
impl UpdateManagedInstanceRoleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateManagedInstanceRoleOutput`](crate::output::UpdateManagedInstanceRoleOutput)
    pub fn builder() -> crate::output::update_managed_instance_role_output::Builder {
        crate::output::update_managed_instance_role_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMaintenanceWindowTaskOutput {
    /// <p>The ID of the maintenance window that was updated.</p>
    pub window_id: std::option::Option<std::string::String>,
    /// <p>The task ID of the maintenance window that was updated.</p>
    pub window_task_id: std::option::Option<std::string::String>,
    /// <p>The updated target values.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The updated task ARN value.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The updated parameter values.</p> <note>
    /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub task_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::MaintenanceWindowTaskParameterValueExpression,
        >,
    >,
    /// <p>The updated parameter values.</p>
    pub task_invocation_parameters:
        std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
    /// <p>The updated priority value.</p>
    pub priority: i32,
    /// <p>The updated <code>MaxConcurrency</code> value.</p>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The updated <code>MaxErrors</code> value.</p>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>The updated logging information in Amazon S3.</p> <note>
    /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub logging_info: std::option::Option<crate::model::LoggingInfo>,
    /// <p>The updated task name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated task description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>
    pub cutoff_behavior: std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
}
impl UpdateMaintenanceWindowTaskOutput {
    /// <p>The ID of the maintenance window that was updated.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
    /// <p>The task ID of the maintenance window that was updated.</p>
    pub fn window_task_id(&self) -> std::option::Option<&str> {
        self.window_task_id.as_deref()
    }
    /// <p>The updated target values.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
    /// <p>The updated task ARN value.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The updated parameter values.</p> <note>
    /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub fn task_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::MaintenanceWindowTaskParameterValueExpression,
        >,
    > {
        self.task_parameters.as_ref()
    }
    /// <p>The updated parameter values.</p>
    pub fn task_invocation_parameters(
        &self,
    ) -> std::option::Option<&crate::model::MaintenanceWindowTaskInvocationParameters> {
        self.task_invocation_parameters.as_ref()
    }
    /// <p>The updated priority value.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>The updated <code>MaxConcurrency</code> value.</p>
    pub fn max_concurrency(&self) -> std::option::Option<&str> {
        self.max_concurrency.as_deref()
    }
    /// <p>The updated <code>MaxErrors</code> value.</p>
    pub fn max_errors(&self) -> std::option::Option<&str> {
        self.max_errors.as_deref()
    }
    /// <p>The updated logging information in Amazon S3.</p> <note>
    /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub fn logging_info(&self) -> std::option::Option<&crate::model::LoggingInfo> {
        self.logging_info.as_ref()
    }
    /// <p>The updated task name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated task description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>
    pub fn cutoff_behavior(
        &self,
    ) -> std::option::Option<&crate::model::MaintenanceWindowTaskCutoffBehavior> {
        self.cutoff_behavior.as_ref()
    }
}
impl std::fmt::Debug for UpdateMaintenanceWindowTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMaintenanceWindowTaskOutput");
        formatter.field("window_id", &self.window_id);
        formatter.field("window_task_id", &self.window_task_id);
        formatter.field("targets", &self.targets);
        formatter.field("task_arn", &self.task_arn);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("task_parameters", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "task_invocation_parameters",
            &self.task_invocation_parameters,
        );
        formatter.field("priority", &self.priority);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("logging_info", &self.logging_info);
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("cutoff_behavior", &self.cutoff_behavior);
        formatter.finish()
    }
}
/// See [`UpdateMaintenanceWindowTaskOutput`](crate::output::UpdateMaintenanceWindowTaskOutput)
pub mod update_maintenance_window_task_output {
    /// A builder for [`UpdateMaintenanceWindowTaskOutput`](crate::output::UpdateMaintenanceWindowTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_task_id: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) task_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::MaintenanceWindowTaskParameterValueExpression,
            >,
        >,
        pub(crate) task_invocation_parameters:
            std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) logging_info: std::option::Option<crate::model::LoggingInfo>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cutoff_behavior:
            std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window that was updated.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window that was updated.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The task ID of the maintenance window that was updated.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_task_id = Some(input.into());
            self
        }
        /// <p>The task ID of the maintenance window that was updated.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_task_id = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The updated target values.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// <p>The updated target values.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The updated task ARN value.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The updated task ARN value.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// Adds a key-value pair to `task_parameters`.
        ///
        /// To override the contents of this collection use [`set_task_parameters`](Self::set_task_parameters).
        ///
        /// <p>The updated parameter values.</p> <note>
        /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn task_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MaintenanceWindowTaskParameterValueExpression,
        ) -> Self {
            let mut hash_map = self.task_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.task_parameters = Some(hash_map);
            self
        }
        /// <p>The updated parameter values.</p> <note>
        /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn set_task_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::MaintenanceWindowTaskParameterValueExpression,
                >,
            >,
        ) -> Self {
            self.task_parameters = input;
            self
        }
        /// <p>The updated parameter values.</p>
        pub fn task_invocation_parameters(
            mut self,
            input: crate::model::MaintenanceWindowTaskInvocationParameters,
        ) -> Self {
            self.task_invocation_parameters = Some(input);
            self
        }
        /// <p>The updated parameter values.</p>
        pub fn set_task_invocation_parameters(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
        ) -> Self {
            self.task_invocation_parameters = input;
            self
        }
        /// <p>The updated priority value.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The updated priority value.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The updated <code>MaxConcurrency</code> value.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The updated <code>MaxConcurrency</code> value.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The updated <code>MaxErrors</code> value.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The updated <code>MaxErrors</code> value.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The updated logging information in Amazon S3.</p> <note>
        /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn logging_info(mut self, input: crate::model::LoggingInfo) -> Self {
            self.logging_info = Some(input);
            self
        }
        /// <p>The updated logging information in Amazon S3.</p> <note>
        /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn set_logging_info(
            mut self,
            input: std::option::Option<crate::model::LoggingInfo>,
        ) -> Self {
            self.logging_info = input;
            self
        }
        /// <p>The updated task name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated task name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated task description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated task description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>
        pub fn cutoff_behavior(
            mut self,
            input: crate::model::MaintenanceWindowTaskCutoffBehavior,
        ) -> Self {
            self.cutoff_behavior = Some(input);
            self
        }
        /// <p>The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>
        pub fn set_cutoff_behavior(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
        ) -> Self {
            self.cutoff_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMaintenanceWindowTaskOutput`](crate::output::UpdateMaintenanceWindowTaskOutput)
        pub fn build(self) -> crate::output::UpdateMaintenanceWindowTaskOutput {
            crate::output::UpdateMaintenanceWindowTaskOutput {
                window_id: self.window_id,
                window_task_id: self.window_task_id,
                targets: self.targets,
                task_arn: self.task_arn,
                service_role_arn: self.service_role_arn,
                task_parameters: self.task_parameters,
                task_invocation_parameters: self.task_invocation_parameters,
                priority: self.priority.unwrap_or_default(),
                max_concurrency: self.max_concurrency,
                max_errors: self.max_errors,
                logging_info: self.logging_info,
                name: self.name,
                description: self.description,
                cutoff_behavior: self.cutoff_behavior,
            }
        }
    }
}
impl UpdateMaintenanceWindowTaskOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceWindowTaskOutput`](crate::output::UpdateMaintenanceWindowTaskOutput)
    pub fn builder() -> crate::output::update_maintenance_window_task_output::Builder {
        crate::output::update_maintenance_window_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMaintenanceWindowTargetOutput {
    /// <p>The maintenance window ID specified in the update request.</p>
    pub window_id: std::option::Option<std::string::String>,
    /// <p>The target ID specified in the update request.</p>
    pub window_target_id: std::option::Option<std::string::String>,
    /// <p>The updated targets.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The updated owner.</p>
    pub owner_information: std::option::Option<std::string::String>,
    /// <p>The updated name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateMaintenanceWindowTargetOutput {
    /// <p>The maintenance window ID specified in the update request.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
    /// <p>The target ID specified in the update request.</p>
    pub fn window_target_id(&self) -> std::option::Option<&str> {
        self.window_target_id.as_deref()
    }
    /// <p>The updated targets.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
    /// <p>The updated owner.</p>
    pub fn owner_information(&self) -> std::option::Option<&str> {
        self.owner_information.as_deref()
    }
    /// <p>The updated name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateMaintenanceWindowTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMaintenanceWindowTargetOutput");
        formatter.field("window_id", &self.window_id);
        formatter.field("window_target_id", &self.window_target_id);
        formatter.field("targets", &self.targets);
        formatter.field("owner_information", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`UpdateMaintenanceWindowTargetOutput`](crate::output::UpdateMaintenanceWindowTargetOutput)
pub mod update_maintenance_window_target_output {
    /// A builder for [`UpdateMaintenanceWindowTargetOutput`](crate::output::UpdateMaintenanceWindowTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_target_id: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) owner_information: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maintenance window ID specified in the update request.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The maintenance window ID specified in the update request.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The target ID specified in the update request.</p>
        pub fn window_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_target_id = Some(input.into());
            self
        }
        /// <p>The target ID specified in the update request.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_target_id = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The updated targets.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// <p>The updated targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The updated owner.</p>
        pub fn owner_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_information = Some(input.into());
            self
        }
        /// <p>The updated owner.</p>
        pub fn set_owner_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_information = input;
            self
        }
        /// <p>The updated name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The updated name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMaintenanceWindowTargetOutput`](crate::output::UpdateMaintenanceWindowTargetOutput)
        pub fn build(self) -> crate::output::UpdateMaintenanceWindowTargetOutput {
            crate::output::UpdateMaintenanceWindowTargetOutput {
                window_id: self.window_id,
                window_target_id: self.window_target_id,
                targets: self.targets,
                owner_information: self.owner_information,
                name: self.name,
                description: self.description,
            }
        }
    }
}
impl UpdateMaintenanceWindowTargetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceWindowTargetOutput`](crate::output::UpdateMaintenanceWindowTargetOutput)
    pub fn builder() -> crate::output::update_maintenance_window_target_output::Builder {
        crate::output::update_maintenance_window_target_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMaintenanceWindowOutput {
    /// <p>The ID of the created maintenance window.</p>
    pub window_id: std::option::Option<std::string::String>,
    /// <p>The name of the maintenance window.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
    pub end_date: std::option::Option<std::string::String>,
    /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    pub schedule_timezone: std::option::Option<std::string::String>,
    /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
    pub schedule_offset: std::option::Option<i32>,
    /// <p>The duration of the maintenance window in hours.</p>
    pub duration: i32,
    /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    pub cutoff: i32,
    /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
    pub allow_unassociated_targets: bool,
    /// <p>Whether the maintenance window is enabled.</p>
    pub enabled: bool,
}
impl UpdateMaintenanceWindowOutput {
    /// <p>The ID of the created maintenance window.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
    /// <p>The name of the maintenance window.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An optional description of the update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
    pub fn end_date(&self) -> std::option::Option<&str> {
        self.end_date.as_deref()
    }
    /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    pub fn schedule_timezone(&self) -> std::option::Option<&str> {
        self.schedule_timezone.as_deref()
    }
    /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
    pub fn schedule_offset(&self) -> std::option::Option<i32> {
        self.schedule_offset
    }
    /// <p>The duration of the maintenance window in hours.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    pub fn cutoff(&self) -> i32 {
        self.cutoff
    }
    /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
    pub fn allow_unassociated_targets(&self) -> bool {
        self.allow_unassociated_targets
    }
    /// <p>Whether the maintenance window is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for UpdateMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMaintenanceWindowOutput");
        formatter.field("window_id", &self.window_id);
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("schedule", &self.schedule);
        formatter.field("schedule_timezone", &self.schedule_timezone);
        formatter.field("schedule_offset", &self.schedule_offset);
        formatter.field("duration", &self.duration);
        formatter.field("cutoff", &self.cutoff);
        formatter.field(
            "allow_unassociated_targets",
            &self.allow_unassociated_targets,
        );
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`UpdateMaintenanceWindowOutput`](crate::output::UpdateMaintenanceWindowOutput)
pub mod update_maintenance_window_output {
    /// A builder for [`UpdateMaintenanceWindowOutput`](crate::output::UpdateMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) schedule_timezone: std::option::Option<std::string::String>,
        pub(crate) schedule_offset: std::option::Option<i32>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) cutoff: std::option::Option<i32>,
        pub(crate) allow_unassociated_targets: std::option::Option<bool>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the created maintenance window.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the created maintenance window.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
        pub fn schedule_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_timezone = Some(input.into());
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
        pub fn set_schedule_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_timezone = input;
            self
        }
        /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
        pub fn schedule_offset(mut self, input: i32) -> Self {
            self.schedule_offset = Some(input);
            self
        }
        /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.schedule_offset = input;
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
        pub fn cutoff(mut self, input: i32) -> Self {
            self.cutoff = Some(input);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
        pub fn set_cutoff(mut self, input: std::option::Option<i32>) -> Self {
            self.cutoff = input;
            self
        }
        /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
        pub fn allow_unassociated_targets(mut self, input: bool) -> Self {
            self.allow_unassociated_targets = Some(input);
            self
        }
        /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
        pub fn set_allow_unassociated_targets(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_unassociated_targets = input;
            self
        }
        /// <p>Whether the maintenance window is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether the maintenance window is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMaintenanceWindowOutput`](crate::output::UpdateMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::UpdateMaintenanceWindowOutput {
            crate::output::UpdateMaintenanceWindowOutput {
                window_id: self.window_id,
                name: self.name,
                description: self.description,
                start_date: self.start_date,
                end_date: self.end_date,
                schedule: self.schedule,
                schedule_timezone: self.schedule_timezone,
                schedule_offset: self.schedule_offset,
                duration: self.duration.unwrap_or_default(),
                cutoff: self.cutoff.unwrap_or_default(),
                allow_unassociated_targets: self.allow_unassociated_targets.unwrap_or_default(),
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl UpdateMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceWindowOutput`](crate::output::UpdateMaintenanceWindowOutput)
    pub fn builder() -> crate::output::update_maintenance_window_output::Builder {
        crate::output::update_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentMetadataOutput {}
impl std::fmt::Debug for UpdateDocumentMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentMetadataOutput");
        formatter.finish()
    }
}
/// See [`UpdateDocumentMetadataOutput`](crate::output::UpdateDocumentMetadataOutput)
pub mod update_document_metadata_output {
    /// A builder for [`UpdateDocumentMetadataOutput`](crate::output::UpdateDocumentMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDocumentMetadataOutput`](crate::output::UpdateDocumentMetadataOutput)
        pub fn build(self) -> crate::output::UpdateDocumentMetadataOutput {
            crate::output::UpdateDocumentMetadataOutput {}
        }
    }
}
impl UpdateDocumentMetadataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentMetadataOutput`](crate::output::UpdateDocumentMetadataOutput)
    pub fn builder() -> crate::output::update_document_metadata_output::Builder {
        crate::output::update_document_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentDefaultVersionOutput {
    /// <p>The description of a custom document that you want to set as the default version.</p>
    pub description: std::option::Option<crate::model::DocumentDefaultVersionDescription>,
}
impl UpdateDocumentDefaultVersionOutput {
    /// <p>The description of a custom document that you want to set as the default version.</p>
    pub fn description(
        &self,
    ) -> std::option::Option<&crate::model::DocumentDefaultVersionDescription> {
        self.description.as_ref()
    }
}
impl std::fmt::Debug for UpdateDocumentDefaultVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentDefaultVersionOutput");
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`UpdateDocumentDefaultVersionOutput`](crate::output::UpdateDocumentDefaultVersionOutput)
pub mod update_document_default_version_output {
    /// A builder for [`UpdateDocumentDefaultVersionOutput`](crate::output::UpdateDocumentDefaultVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description:
            std::option::Option<crate::model::DocumentDefaultVersionDescription>,
    }
    impl Builder {
        /// <p>The description of a custom document that you want to set as the default version.</p>
        pub fn description(
            mut self,
            input: crate::model::DocumentDefaultVersionDescription,
        ) -> Self {
            self.description = Some(input);
            self
        }
        /// <p>The description of a custom document that you want to set as the default version.</p>
        pub fn set_description(
            mut self,
            input: std::option::Option<crate::model::DocumentDefaultVersionDescription>,
        ) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentDefaultVersionOutput`](crate::output::UpdateDocumentDefaultVersionOutput)
        pub fn build(self) -> crate::output::UpdateDocumentDefaultVersionOutput {
            crate::output::UpdateDocumentDefaultVersionOutput {
                description: self.description,
            }
        }
    }
}
impl UpdateDocumentDefaultVersionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentDefaultVersionOutput`](crate::output::UpdateDocumentDefaultVersionOutput)
    pub fn builder() -> crate::output::update_document_default_version_output::Builder {
        crate::output::update_document_default_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDocumentOutput {
    /// <p>A description of the document that was updated.</p>
    pub document_description: std::option::Option<crate::model::DocumentDescription>,
}
impl UpdateDocumentOutput {
    /// <p>A description of the document that was updated.</p>
    pub fn document_description(&self) -> std::option::Option<&crate::model::DocumentDescription> {
        self.document_description.as_ref()
    }
}
impl std::fmt::Debug for UpdateDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDocumentOutput");
        formatter.field("document_description", &self.document_description);
        formatter.finish()
    }
}
/// See [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
pub mod update_document_output {
    /// A builder for [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_description: std::option::Option<crate::model::DocumentDescription>,
    }
    impl Builder {
        /// <p>A description of the document that was updated.</p>
        pub fn document_description(mut self, input: crate::model::DocumentDescription) -> Self {
            self.document_description = Some(input);
            self
        }
        /// <p>A description of the document that was updated.</p>
        pub fn set_document_description(
            mut self,
            input: std::option::Option<crate::model::DocumentDescription>,
        ) -> Self {
            self.document_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
        pub fn build(self) -> crate::output::UpdateDocumentOutput {
            crate::output::UpdateDocumentOutput {
                document_description: self.document_description,
            }
        }
    }
}
impl UpdateDocumentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput)
    pub fn builder() -> crate::output::update_document_output::Builder {
        crate::output::update_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssociationStatusOutput {
    /// <p>Information about the association.</p>
    pub association_description: std::option::Option<crate::model::AssociationDescription>,
}
impl UpdateAssociationStatusOutput {
    /// <p>Information about the association.</p>
    pub fn association_description(
        &self,
    ) -> std::option::Option<&crate::model::AssociationDescription> {
        self.association_description.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssociationStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssociationStatusOutput");
        formatter.field("association_description", &self.association_description);
        formatter.finish()
    }
}
/// See [`UpdateAssociationStatusOutput`](crate::output::UpdateAssociationStatusOutput)
pub mod update_association_status_output {
    /// A builder for [`UpdateAssociationStatusOutput`](crate::output::UpdateAssociationStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_description:
            std::option::Option<crate::model::AssociationDescription>,
    }
    impl Builder {
        /// <p>Information about the association.</p>
        pub fn association_description(
            mut self,
            input: crate::model::AssociationDescription,
        ) -> Self {
            self.association_description = Some(input);
            self
        }
        /// <p>Information about the association.</p>
        pub fn set_association_description(
            mut self,
            input: std::option::Option<crate::model::AssociationDescription>,
        ) -> Self {
            self.association_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssociationStatusOutput`](crate::output::UpdateAssociationStatusOutput)
        pub fn build(self) -> crate::output::UpdateAssociationStatusOutput {
            crate::output::UpdateAssociationStatusOutput {
                association_description: self.association_description,
            }
        }
    }
}
impl UpdateAssociationStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssociationStatusOutput`](crate::output::UpdateAssociationStatusOutput)
    pub fn builder() -> crate::output::update_association_status_output::Builder {
        crate::output::update_association_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssociationOutput {
    /// <p>The description of the association that was updated.</p>
    pub association_description: std::option::Option<crate::model::AssociationDescription>,
}
impl UpdateAssociationOutput {
    /// <p>The description of the association that was updated.</p>
    pub fn association_description(
        &self,
    ) -> std::option::Option<&crate::model::AssociationDescription> {
        self.association_description.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssociationOutput");
        formatter.field("association_description", &self.association_description);
        formatter.finish()
    }
}
/// See [`UpdateAssociationOutput`](crate::output::UpdateAssociationOutput)
pub mod update_association_output {
    /// A builder for [`UpdateAssociationOutput`](crate::output::UpdateAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_description:
            std::option::Option<crate::model::AssociationDescription>,
    }
    impl Builder {
        /// <p>The description of the association that was updated.</p>
        pub fn association_description(
            mut self,
            input: crate::model::AssociationDescription,
        ) -> Self {
            self.association_description = Some(input);
            self
        }
        /// <p>The description of the association that was updated.</p>
        pub fn set_association_description(
            mut self,
            input: std::option::Option<crate::model::AssociationDescription>,
        ) -> Self {
            self.association_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssociationOutput`](crate::output::UpdateAssociationOutput)
        pub fn build(self) -> crate::output::UpdateAssociationOutput {
            crate::output::UpdateAssociationOutput {
                association_description: self.association_description,
            }
        }
    }
}
impl UpdateAssociationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssociationOutput`](crate::output::UpdateAssociationOutput)
    pub fn builder() -> crate::output::update_association_output::Builder {
        crate::output::update_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnlabelParameterVersionOutput {
    /// <p>A list of all labels deleted from the parameter.</p>
    pub removed_labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The labels that aren't attached to the given parameter version.</p>
    pub invalid_labels: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UnlabelParameterVersionOutput {
    /// <p>A list of all labels deleted from the parameter.</p>
    pub fn removed_labels(&self) -> std::option::Option<&[std::string::String]> {
        self.removed_labels.as_deref()
    }
    /// <p>The labels that aren't attached to the given parameter version.</p>
    pub fn invalid_labels(&self) -> std::option::Option<&[std::string::String]> {
        self.invalid_labels.as_deref()
    }
}
impl std::fmt::Debug for UnlabelParameterVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnlabelParameterVersionOutput");
        formatter.field("removed_labels", &self.removed_labels);
        formatter.field("invalid_labels", &self.invalid_labels);
        formatter.finish()
    }
}
/// See [`UnlabelParameterVersionOutput`](crate::output::UnlabelParameterVersionOutput)
pub mod unlabel_parameter_version_output {
    /// A builder for [`UnlabelParameterVersionOutput`](crate::output::UnlabelParameterVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) removed_labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) invalid_labels: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `removed_labels`.
        ///
        /// To override the contents of this collection use [`set_removed_labels`](Self::set_removed_labels).
        ///
        /// <p>A list of all labels deleted from the parameter.</p>
        pub fn removed_labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.removed_labels.unwrap_or_default();
            v.push(input.into());
            self.removed_labels = Some(v);
            self
        }
        /// <p>A list of all labels deleted from the parameter.</p>
        pub fn set_removed_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.removed_labels = input;
            self
        }
        /// Appends an item to `invalid_labels`.
        ///
        /// To override the contents of this collection use [`set_invalid_labels`](Self::set_invalid_labels).
        ///
        /// <p>The labels that aren't attached to the given parameter version.</p>
        pub fn invalid_labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.invalid_labels.unwrap_or_default();
            v.push(input.into());
            self.invalid_labels = Some(v);
            self
        }
        /// <p>The labels that aren't attached to the given parameter version.</p>
        pub fn set_invalid_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.invalid_labels = input;
            self
        }
        /// Consumes the builder and constructs a [`UnlabelParameterVersionOutput`](crate::output::UnlabelParameterVersionOutput)
        pub fn build(self) -> crate::output::UnlabelParameterVersionOutput {
            crate::output::UnlabelParameterVersionOutput {
                removed_labels: self.removed_labels,
                invalid_labels: self.invalid_labels,
            }
        }
    }
}
impl UnlabelParameterVersionOutput {
    /// Creates a new builder-style object to manufacture [`UnlabelParameterVersionOutput`](crate::output::UnlabelParameterVersionOutput)
    pub fn builder() -> crate::output::unlabel_parameter_version_output::Builder {
        crate::output::unlabel_parameter_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateSessionOutput {
    /// <p>The ID of the session that has been terminated.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl TerminateSessionOutput {
    /// <p>The ID of the session that has been terminated.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for TerminateSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateSessionOutput");
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}
/// See [`TerminateSessionOutput`](crate::output::TerminateSessionOutput)
pub mod terminate_session_output {
    /// A builder for [`TerminateSessionOutput`](crate::output::TerminateSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the session that has been terminated.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The ID of the session that has been terminated.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateSessionOutput`](crate::output::TerminateSessionOutput)
        pub fn build(self) -> crate::output::TerminateSessionOutput {
            crate::output::TerminateSessionOutput {
                session_id: self.session_id,
            }
        }
    }
}
impl TerminateSessionOutput {
    /// Creates a new builder-style object to manufacture [`TerminateSessionOutput`](crate::output::TerminateSessionOutput)
    pub fn builder() -> crate::output::terminate_session_output::Builder {
        crate::output::terminate_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopAutomationExecutionOutput {}
impl std::fmt::Debug for StopAutomationExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopAutomationExecutionOutput");
        formatter.finish()
    }
}
/// See [`StopAutomationExecutionOutput`](crate::output::StopAutomationExecutionOutput)
pub mod stop_automation_execution_output {
    /// A builder for [`StopAutomationExecutionOutput`](crate::output::StopAutomationExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopAutomationExecutionOutput`](crate::output::StopAutomationExecutionOutput)
        pub fn build(self) -> crate::output::StopAutomationExecutionOutput {
            crate::output::StopAutomationExecutionOutput {}
        }
    }
}
impl StopAutomationExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StopAutomationExecutionOutput`](crate::output::StopAutomationExecutionOutput)
    pub fn builder() -> crate::output::stop_automation_execution_output::Builder {
        crate::output::stop_automation_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSessionOutput {
    /// <p>The ID of the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
    pub token_value: std::option::Option<std::string::String>,
    /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code> </p>
    /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
    pub stream_url: std::option::Option<std::string::String>,
}
impl StartSessionOutput {
    /// <p>The ID of the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
    pub fn token_value(&self) -> std::option::Option<&str> {
        self.token_value.as_deref()
    }
    /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code> </p>
    /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
    pub fn stream_url(&self) -> std::option::Option<&str> {
        self.stream_url.as_deref()
    }
}
impl std::fmt::Debug for StartSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSessionOutput");
        formatter.field("session_id", &self.session_id);
        formatter.field("token_value", &self.token_value);
        formatter.field("stream_url", &self.stream_url);
        formatter.finish()
    }
}
/// See [`StartSessionOutput`](crate::output::StartSessionOutput)
pub mod start_session_output {
    /// A builder for [`StartSessionOutput`](crate::output::StartSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) token_value: std::option::Option<std::string::String>,
        pub(crate) stream_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The ID of the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
        pub fn token_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_value = Some(input.into());
            self
        }
        /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
        pub fn set_token_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_value = input;
            self
        }
        /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code> </p>
        /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
        pub fn stream_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_url = Some(input.into());
            self
        }
        /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code> </p>
        /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
        pub fn set_stream_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_url = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSessionOutput`](crate::output::StartSessionOutput)
        pub fn build(self) -> crate::output::StartSessionOutput {
            crate::output::StartSessionOutput {
                session_id: self.session_id,
                token_value: self.token_value,
                stream_url: self.stream_url,
            }
        }
    }
}
impl StartSessionOutput {
    /// Creates a new builder-style object to manufacture [`StartSessionOutput`](crate::output::StartSessionOutput)
    pub fn builder() -> crate::output::start_session_output::Builder {
        crate::output::start_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartChangeRequestExecutionOutput {
    /// <p>The unique ID of a runbook workflow operation. (A runbook workflow is a type of Automation operation.) </p>
    pub automation_execution_id: std::option::Option<std::string::String>,
}
impl StartChangeRequestExecutionOutput {
    /// <p>The unique ID of a runbook workflow operation. (A runbook workflow is a type of Automation operation.) </p>
    pub fn automation_execution_id(&self) -> std::option::Option<&str> {
        self.automation_execution_id.as_deref()
    }
}
impl std::fmt::Debug for StartChangeRequestExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartChangeRequestExecutionOutput");
        formatter.field("automation_execution_id", &self.automation_execution_id);
        formatter.finish()
    }
}
/// See [`StartChangeRequestExecutionOutput`](crate::output::StartChangeRequestExecutionOutput)
pub mod start_change_request_execution_output {
    /// A builder for [`StartChangeRequestExecutionOutput`](crate::output::StartChangeRequestExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automation_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of a runbook workflow operation. (A runbook workflow is a type of Automation operation.) </p>
        pub fn automation_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.automation_execution_id = Some(input.into());
            self
        }
        /// <p>The unique ID of a runbook workflow operation. (A runbook workflow is a type of Automation operation.) </p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automation_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChangeRequestExecutionOutput`](crate::output::StartChangeRequestExecutionOutput)
        pub fn build(self) -> crate::output::StartChangeRequestExecutionOutput {
            crate::output::StartChangeRequestExecutionOutput {
                automation_execution_id: self.automation_execution_id,
            }
        }
    }
}
impl StartChangeRequestExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartChangeRequestExecutionOutput`](crate::output::StartChangeRequestExecutionOutput)
    pub fn builder() -> crate::output::start_change_request_execution_output::Builder {
        crate::output::start_change_request_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAutomationExecutionOutput {
    /// <p>The unique ID of a newly scheduled automation execution.</p>
    pub automation_execution_id: std::option::Option<std::string::String>,
}
impl StartAutomationExecutionOutput {
    /// <p>The unique ID of a newly scheduled automation execution.</p>
    pub fn automation_execution_id(&self) -> std::option::Option<&str> {
        self.automation_execution_id.as_deref()
    }
}
impl std::fmt::Debug for StartAutomationExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAutomationExecutionOutput");
        formatter.field("automation_execution_id", &self.automation_execution_id);
        formatter.finish()
    }
}
/// See [`StartAutomationExecutionOutput`](crate::output::StartAutomationExecutionOutput)
pub mod start_automation_execution_output {
    /// A builder for [`StartAutomationExecutionOutput`](crate::output::StartAutomationExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automation_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of a newly scheduled automation execution.</p>
        pub fn automation_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.automation_execution_id = Some(input.into());
            self
        }
        /// <p>The unique ID of a newly scheduled automation execution.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automation_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAutomationExecutionOutput`](crate::output::StartAutomationExecutionOutput)
        pub fn build(self) -> crate::output::StartAutomationExecutionOutput {
            crate::output::StartAutomationExecutionOutput {
                automation_execution_id: self.automation_execution_id,
            }
        }
    }
}
impl StartAutomationExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartAutomationExecutionOutput`](crate::output::StartAutomationExecutionOutput)
    pub fn builder() -> crate::output::start_automation_execution_output::Builder {
        crate::output::start_automation_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAssociationsOnceOutput {}
impl std::fmt::Debug for StartAssociationsOnceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAssociationsOnceOutput");
        formatter.finish()
    }
}
/// See [`StartAssociationsOnceOutput`](crate::output::StartAssociationsOnceOutput)
pub mod start_associations_once_output {
    /// A builder for [`StartAssociationsOnceOutput`](crate::output::StartAssociationsOnceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartAssociationsOnceOutput`](crate::output::StartAssociationsOnceOutput)
        pub fn build(self) -> crate::output::StartAssociationsOnceOutput {
            crate::output::StartAssociationsOnceOutput {}
        }
    }
}
impl StartAssociationsOnceOutput {
    /// Creates a new builder-style object to manufacture [`StartAssociationsOnceOutput`](crate::output::StartAssociationsOnceOutput)
    pub fn builder() -> crate::output::start_associations_once_output::Builder {
        crate::output::start_associations_once_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendCommandOutput {
    /// <p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>
    pub command: std::option::Option<crate::model::Command>,
}
impl SendCommandOutput {
    /// <p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>
    pub fn command(&self) -> std::option::Option<&crate::model::Command> {
        self.command.as_ref()
    }
}
impl std::fmt::Debug for SendCommandOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendCommandOutput");
        formatter.field("command", &self.command);
        formatter.finish()
    }
}
/// See [`SendCommandOutput`](crate::output::SendCommandOutput)
pub mod send_command_output {
    /// A builder for [`SendCommandOutput`](crate::output::SendCommandOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command: std::option::Option<crate::model::Command>,
    }
    impl Builder {
        /// <p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>
        pub fn command(mut self, input: crate::model::Command) -> Self {
            self.command = Some(input);
            self
        }
        /// <p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>
        pub fn set_command(mut self, input: std::option::Option<crate::model::Command>) -> Self {
            self.command = input;
            self
        }
        /// Consumes the builder and constructs a [`SendCommandOutput`](crate::output::SendCommandOutput)
        pub fn build(self) -> crate::output::SendCommandOutput {
            crate::output::SendCommandOutput {
                command: self.command,
            }
        }
    }
}
impl SendCommandOutput {
    /// Creates a new builder-style object to manufacture [`SendCommandOutput`](crate::output::SendCommandOutput)
    pub fn builder() -> crate::output::send_command_output::Builder {
        crate::output::send_command_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendAutomationSignalOutput {}
impl std::fmt::Debug for SendAutomationSignalOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendAutomationSignalOutput");
        formatter.finish()
    }
}
/// See [`SendAutomationSignalOutput`](crate::output::SendAutomationSignalOutput)
pub mod send_automation_signal_output {
    /// A builder for [`SendAutomationSignalOutput`](crate::output::SendAutomationSignalOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SendAutomationSignalOutput`](crate::output::SendAutomationSignalOutput)
        pub fn build(self) -> crate::output::SendAutomationSignalOutput {
            crate::output::SendAutomationSignalOutput {}
        }
    }
}
impl SendAutomationSignalOutput {
    /// Creates a new builder-style object to manufacture [`SendAutomationSignalOutput`](crate::output::SendAutomationSignalOutput)
    pub fn builder() -> crate::output::send_automation_signal_output::Builder {
        crate::output::send_automation_signal_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResumeSessionOutput {
    /// <p>The ID of the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
    pub token_value: std::option::Option<std::string::String>,
    /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the managed node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>.</p>
    /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
    pub stream_url: std::option::Option<std::string::String>,
}
impl ResumeSessionOutput {
    /// <p>The ID of the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
    pub fn token_value(&self) -> std::option::Option<&str> {
        self.token_value.as_deref()
    }
    /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the managed node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>.</p>
    /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
    pub fn stream_url(&self) -> std::option::Option<&str> {
        self.stream_url.as_deref()
    }
}
impl std::fmt::Debug for ResumeSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResumeSessionOutput");
        formatter.field("session_id", &self.session_id);
        formatter.field("token_value", &self.token_value);
        formatter.field("stream_url", &self.stream_url);
        formatter.finish()
    }
}
/// See [`ResumeSessionOutput`](crate::output::ResumeSessionOutput)
pub mod resume_session_output {
    /// A builder for [`ResumeSessionOutput`](crate::output::ResumeSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) token_value: std::option::Option<std::string::String>,
        pub(crate) stream_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The ID of the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
        pub fn token_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_value = Some(input.into());
            self
        }
        /// <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
        pub fn set_token_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_value = input;
            self
        }
        /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the managed node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>.</p>
        /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
        pub fn stream_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_url = Some(input.into());
            self
        }
        /// <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the managed node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>.</p>
        /// <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>
        /// <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
        pub fn set_stream_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeSessionOutput`](crate::output::ResumeSessionOutput)
        pub fn build(self) -> crate::output::ResumeSessionOutput {
            crate::output::ResumeSessionOutput {
                session_id: self.session_id,
                token_value: self.token_value,
                stream_url: self.stream_url,
            }
        }
    }
}
impl ResumeSessionOutput {
    /// Creates a new builder-style object to manufacture [`ResumeSessionOutput`](crate::output::ResumeSessionOutput)
    pub fn builder() -> crate::output::resume_session_output::Builder {
        crate::output::resume_session_output::Builder::default()
    }
}

/// <p>The result body of the ResetServiceSetting API operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetServiceSettingOutput {
    /// <p>The current, effective service setting after calling the ResetServiceSetting API operation.</p>
    pub service_setting: std::option::Option<crate::model::ServiceSetting>,
}
impl ResetServiceSettingOutput {
    /// <p>The current, effective service setting after calling the ResetServiceSetting API operation.</p>
    pub fn service_setting(&self) -> std::option::Option<&crate::model::ServiceSetting> {
        self.service_setting.as_ref()
    }
}
impl std::fmt::Debug for ResetServiceSettingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetServiceSettingOutput");
        formatter.field("service_setting", &self.service_setting);
        formatter.finish()
    }
}
/// See [`ResetServiceSettingOutput`](crate::output::ResetServiceSettingOutput)
pub mod reset_service_setting_output {
    /// A builder for [`ResetServiceSettingOutput`](crate::output::ResetServiceSettingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_setting: std::option::Option<crate::model::ServiceSetting>,
    }
    impl Builder {
        /// <p>The current, effective service setting after calling the ResetServiceSetting API operation.</p>
        pub fn service_setting(mut self, input: crate::model::ServiceSetting) -> Self {
            self.service_setting = Some(input);
            self
        }
        /// <p>The current, effective service setting after calling the ResetServiceSetting API operation.</p>
        pub fn set_service_setting(
            mut self,
            input: std::option::Option<crate::model::ServiceSetting>,
        ) -> Self {
            self.service_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetServiceSettingOutput`](crate::output::ResetServiceSettingOutput)
        pub fn build(self) -> crate::output::ResetServiceSettingOutput {
            crate::output::ResetServiceSettingOutput {
                service_setting: self.service_setting,
            }
        }
    }
}
impl ResetServiceSettingOutput {
    /// Creates a new builder-style object to manufacture [`ResetServiceSettingOutput`](crate::output::ResetServiceSettingOutput)
    pub fn builder() -> crate::output::reset_service_setting_output::Builder {
        crate::output::reset_service_setting_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceOutput {}
impl std::fmt::Debug for RemoveTagsFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
pub mod remove_tags_from_resource_output {
    /// A builder for [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromResourceOutput {
            crate::output::RemoveTagsFromResourceOutput {}
        }
    }
}
impl RemoveTagsFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    pub fn builder() -> crate::output::remove_tags_from_resource_output::Builder {
        crate::output::remove_tags_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTaskWithMaintenanceWindowOutput {
    /// <p>The ID of the task in the maintenance window.</p>
    pub window_task_id: std::option::Option<std::string::String>,
}
impl RegisterTaskWithMaintenanceWindowOutput {
    /// <p>The ID of the task in the maintenance window.</p>
    pub fn window_task_id(&self) -> std::option::Option<&str> {
        self.window_task_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterTaskWithMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTaskWithMaintenanceWindowOutput");
        formatter.field("window_task_id", &self.window_task_id);
        formatter.finish()
    }
}
/// See [`RegisterTaskWithMaintenanceWindowOutput`](crate::output::RegisterTaskWithMaintenanceWindowOutput)
pub mod register_task_with_maintenance_window_output {
    /// A builder for [`RegisterTaskWithMaintenanceWindowOutput`](crate::output::RegisterTaskWithMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the task in the maintenance window.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task in the maintenance window.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTaskWithMaintenanceWindowOutput`](crate::output::RegisterTaskWithMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::RegisterTaskWithMaintenanceWindowOutput {
            crate::output::RegisterTaskWithMaintenanceWindowOutput {
                window_task_id: self.window_task_id,
            }
        }
    }
}
impl RegisterTaskWithMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`RegisterTaskWithMaintenanceWindowOutput`](crate::output::RegisterTaskWithMaintenanceWindowOutput)
    pub fn builder() -> crate::output::register_task_with_maintenance_window_output::Builder {
        crate::output::register_task_with_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTargetWithMaintenanceWindowOutput {
    /// <p>The ID of the target definition in this maintenance window.</p>
    pub window_target_id: std::option::Option<std::string::String>,
}
impl RegisterTargetWithMaintenanceWindowOutput {
    /// <p>The ID of the target definition in this maintenance window.</p>
    pub fn window_target_id(&self) -> std::option::Option<&str> {
        self.window_target_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterTargetWithMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTargetWithMaintenanceWindowOutput");
        formatter.field("window_target_id", &self.window_target_id);
        formatter.finish()
    }
}
/// See [`RegisterTargetWithMaintenanceWindowOutput`](crate::output::RegisterTargetWithMaintenanceWindowOutput)
pub mod register_target_with_maintenance_window_output {
    /// A builder for [`RegisterTargetWithMaintenanceWindowOutput`](crate::output::RegisterTargetWithMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the target definition in this maintenance window.</p>
        pub fn window_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_target_id = Some(input.into());
            self
        }
        /// <p>The ID of the target definition in this maintenance window.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTargetWithMaintenanceWindowOutput`](crate::output::RegisterTargetWithMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::RegisterTargetWithMaintenanceWindowOutput {
            crate::output::RegisterTargetWithMaintenanceWindowOutput {
                window_target_id: self.window_target_id,
            }
        }
    }
}
impl RegisterTargetWithMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`RegisterTargetWithMaintenanceWindowOutput`](crate::output::RegisterTargetWithMaintenanceWindowOutput)
    pub fn builder() -> crate::output::register_target_with_maintenance_window_output::Builder {
        crate::output::register_target_with_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterPatchBaselineForPatchGroupOutput {
    /// <p>The ID of the patch baseline the patch group was registered with.</p>
    pub baseline_id: std::option::Option<std::string::String>,
    /// <p>The name of the patch group registered with the patch baseline.</p>
    pub patch_group: std::option::Option<std::string::String>,
}
impl RegisterPatchBaselineForPatchGroupOutput {
    /// <p>The ID of the patch baseline the patch group was registered with.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
    /// <p>The name of the patch group registered with the patch baseline.</p>
    pub fn patch_group(&self) -> std::option::Option<&str> {
        self.patch_group.as_deref()
    }
}
impl std::fmt::Debug for RegisterPatchBaselineForPatchGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterPatchBaselineForPatchGroupOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.field("patch_group", &self.patch_group);
        formatter.finish()
    }
}
/// See [`RegisterPatchBaselineForPatchGroupOutput`](crate::output::RegisterPatchBaselineForPatchGroupOutput)
pub mod register_patch_baseline_for_patch_group_output {
    /// A builder for [`RegisterPatchBaselineForPatchGroupOutput`](crate::output::RegisterPatchBaselineForPatchGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) patch_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline the patch group was registered with.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline the patch group was registered with.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The name of the patch group registered with the patch baseline.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group registered with the patch baseline.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterPatchBaselineForPatchGroupOutput`](crate::output::RegisterPatchBaselineForPatchGroupOutput)
        pub fn build(self) -> crate::output::RegisterPatchBaselineForPatchGroupOutput {
            crate::output::RegisterPatchBaselineForPatchGroupOutput {
                baseline_id: self.baseline_id,
                patch_group: self.patch_group,
            }
        }
    }
}
impl RegisterPatchBaselineForPatchGroupOutput {
    /// Creates a new builder-style object to manufacture [`RegisterPatchBaselineForPatchGroupOutput`](crate::output::RegisterPatchBaselineForPatchGroupOutput)
    pub fn builder() -> crate::output::register_patch_baseline_for_patch_group_output::Builder {
        crate::output::register_patch_baseline_for_patch_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDefaultPatchBaselineOutput {
    /// <p>The ID of the default patch baseline.</p>
    pub baseline_id: std::option::Option<std::string::String>,
}
impl RegisterDefaultPatchBaselineOutput {
    /// <p>The ID of the default patch baseline.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterDefaultPatchBaselineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDefaultPatchBaselineOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.finish()
    }
}
/// See [`RegisterDefaultPatchBaselineOutput`](crate::output::RegisterDefaultPatchBaselineOutput)
pub mod register_default_patch_baseline_output {
    /// A builder for [`RegisterDefaultPatchBaselineOutput`](crate::output::RegisterDefaultPatchBaselineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the default patch baseline.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the default patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDefaultPatchBaselineOutput`](crate::output::RegisterDefaultPatchBaselineOutput)
        pub fn build(self) -> crate::output::RegisterDefaultPatchBaselineOutput {
            crate::output::RegisterDefaultPatchBaselineOutput {
                baseline_id: self.baseline_id,
            }
        }
    }
}
impl RegisterDefaultPatchBaselineOutput {
    /// Creates a new builder-style object to manufacture [`RegisterDefaultPatchBaselineOutput`](crate::output::RegisterDefaultPatchBaselineOutput)
    pub fn builder() -> crate::output::register_default_patch_baseline_output::Builder {
        crate::output::register_default_patch_baseline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutParameterOutput {
    /// <p>The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new version and assigns this new version a unique ID. You can reference a parameter version ID in API operations or in Systems Manager documents (SSM documents). By default, if you don't specify a specific version, the system returns the latest parameter value when a parameter is called.</p>
    pub version: i64,
    /// <p>The tier assigned to the parameter.</p>
    pub tier: std::option::Option<crate::model::ParameterTier>,
}
impl PutParameterOutput {
    /// <p>The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new version and assigns this new version a unique ID. You can reference a parameter version ID in API operations or in Systems Manager documents (SSM documents). By default, if you don't specify a specific version, the system returns the latest parameter value when a parameter is called.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The tier assigned to the parameter.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::ParameterTier> {
        self.tier.as_ref()
    }
}
impl std::fmt::Debug for PutParameterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutParameterOutput");
        formatter.field("version", &self.version);
        formatter.field("tier", &self.tier);
        formatter.finish()
    }
}
/// See [`PutParameterOutput`](crate::output::PutParameterOutput)
pub mod put_parameter_output {
    /// A builder for [`PutParameterOutput`](crate::output::PutParameterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<i64>,
        pub(crate) tier: std::option::Option<crate::model::ParameterTier>,
    }
    impl Builder {
        /// <p>The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new version and assigns this new version a unique ID. You can reference a parameter version ID in API operations or in Systems Manager documents (SSM documents). By default, if you don't specify a specific version, the system returns the latest parameter value when a parameter is called.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new version and assigns this new version a unique ID. You can reference a parameter version ID in API operations or in Systems Manager documents (SSM documents). By default, if you don't specify a specific version, the system returns the latest parameter value when a parameter is called.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The tier assigned to the parameter.</p>
        pub fn tier(mut self, input: crate::model::ParameterTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The tier assigned to the parameter.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::ParameterTier>) -> Self {
            self.tier = input;
            self
        }
        /// Consumes the builder and constructs a [`PutParameterOutput`](crate::output::PutParameterOutput)
        pub fn build(self) -> crate::output::PutParameterOutput {
            crate::output::PutParameterOutput {
                version: self.version.unwrap_or_default(),
                tier: self.tier,
            }
        }
    }
}
impl PutParameterOutput {
    /// Creates a new builder-style object to manufacture [`PutParameterOutput`](crate::output::PutParameterOutput)
    pub fn builder() -> crate::output::put_parameter_output::Builder {
        crate::output::put_parameter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutInventoryOutput {
    /// <p>Information about the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl PutInventoryOutput {
    /// <p>Information about the request.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for PutInventoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutInventoryOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`PutInventoryOutput`](crate::output::PutInventoryOutput)
pub mod put_inventory_output {
    /// A builder for [`PutInventoryOutput`](crate::output::PutInventoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInventoryOutput`](crate::output::PutInventoryOutput)
        pub fn build(self) -> crate::output::PutInventoryOutput {
            crate::output::PutInventoryOutput {
                message: self.message,
            }
        }
    }
}
impl PutInventoryOutput {
    /// Creates a new builder-style object to manufacture [`PutInventoryOutput`](crate::output::PutInventoryOutput)
    pub fn builder() -> crate::output::put_inventory_output::Builder {
        crate::output::put_inventory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutComplianceItemsOutput {}
impl std::fmt::Debug for PutComplianceItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutComplianceItemsOutput");
        formatter.finish()
    }
}
/// See [`PutComplianceItemsOutput`](crate::output::PutComplianceItemsOutput)
pub mod put_compliance_items_output {
    /// A builder for [`PutComplianceItemsOutput`](crate::output::PutComplianceItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutComplianceItemsOutput`](crate::output::PutComplianceItemsOutput)
        pub fn build(self) -> crate::output::PutComplianceItemsOutput {
            crate::output::PutComplianceItemsOutput {}
        }
    }
}
impl PutComplianceItemsOutput {
    /// Creates a new builder-style object to manufacture [`PutComplianceItemsOutput`](crate::output::PutComplianceItemsOutput)
    pub fn builder() -> crate::output::put_compliance_items_output::Builder {
        crate::output::put_compliance_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDocumentPermissionOutput {}
impl std::fmt::Debug for ModifyDocumentPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDocumentPermissionOutput");
        formatter.finish()
    }
}
/// See [`ModifyDocumentPermissionOutput`](crate::output::ModifyDocumentPermissionOutput)
pub mod modify_document_permission_output {
    /// A builder for [`ModifyDocumentPermissionOutput`](crate::output::ModifyDocumentPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ModifyDocumentPermissionOutput`](crate::output::ModifyDocumentPermissionOutput)
        pub fn build(self) -> crate::output::ModifyDocumentPermissionOutput {
            crate::output::ModifyDocumentPermissionOutput {}
        }
    }
}
impl ModifyDocumentPermissionOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDocumentPermissionOutput`](crate::output::ModifyDocumentPermissionOutput)
    pub fn builder() -> crate::output::modify_document_permission_output::Builder {
        crate::output::modify_document_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tags.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tags.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags.</p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceDataSyncOutput {
    /// <p>A list of your current resource data sync configurations and their statuses.</p>
    pub resource_data_sync_items:
        std::option::Option<std::vec::Vec<crate::model::ResourceDataSyncItem>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourceDataSyncOutput {
    /// <p>A list of your current resource data sync configurations and their statuses.</p>
    pub fn resource_data_sync_items(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceDataSyncItem]> {
        self.resource_data_sync_items.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourceDataSyncOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceDataSyncOutput");
        formatter.field("resource_data_sync_items", &self.resource_data_sync_items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourceDataSyncOutput`](crate::output::ListResourceDataSyncOutput)
pub mod list_resource_data_sync_output {
    /// A builder for [`ListResourceDataSyncOutput`](crate::output::ListResourceDataSyncOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_data_sync_items:
            std::option::Option<std::vec::Vec<crate::model::ResourceDataSyncItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_data_sync_items`.
        ///
        /// To override the contents of this collection use [`set_resource_data_sync_items`](Self::set_resource_data_sync_items).
        ///
        /// <p>A list of your current resource data sync configurations and their statuses.</p>
        pub fn resource_data_sync_items(
            mut self,
            input: crate::model::ResourceDataSyncItem,
        ) -> Self {
            let mut v = self.resource_data_sync_items.unwrap_or_default();
            v.push(input);
            self.resource_data_sync_items = Some(v);
            self
        }
        /// <p>A list of your current resource data sync configurations and their statuses.</p>
        pub fn set_resource_data_sync_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceDataSyncItem>>,
        ) -> Self {
            self.resource_data_sync_items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceDataSyncOutput`](crate::output::ListResourceDataSyncOutput)
        pub fn build(self) -> crate::output::ListResourceDataSyncOutput {
            crate::output::ListResourceDataSyncOutput {
                resource_data_sync_items: self.resource_data_sync_items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourceDataSyncOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceDataSyncOutput`](crate::output::ListResourceDataSyncOutput)
    pub fn builder() -> crate::output::list_resource_data_sync_output::Builder {
        crate::output::list_resource_data_sync_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceComplianceSummariesOutput {
    /// <p>A summary count for specified or targeted managed nodes. Summary count includes information about compliant and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you specify. </p>
    pub resource_compliance_summary_items:
        std::option::Option<std::vec::Vec<crate::model::ResourceComplianceSummaryItem>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResourceComplianceSummariesOutput {
    /// <p>A summary count for specified or targeted managed nodes. Summary count includes information about compliant and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you specify. </p>
    pub fn resource_compliance_summary_items(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceComplianceSummaryItem]> {
        self.resource_compliance_summary_items.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResourceComplianceSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceComplianceSummariesOutput");
        formatter.field(
            "resource_compliance_summary_items",
            &self.resource_compliance_summary_items,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResourceComplianceSummariesOutput`](crate::output::ListResourceComplianceSummariesOutput)
pub mod list_resource_compliance_summaries_output {
    /// A builder for [`ListResourceComplianceSummariesOutput`](crate::output::ListResourceComplianceSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_compliance_summary_items:
            std::option::Option<std::vec::Vec<crate::model::ResourceComplianceSummaryItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_compliance_summary_items`.
        ///
        /// To override the contents of this collection use [`set_resource_compliance_summary_items`](Self::set_resource_compliance_summary_items).
        ///
        /// <p>A summary count for specified or targeted managed nodes. Summary count includes information about compliant and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you specify. </p>
        pub fn resource_compliance_summary_items(
            mut self,
            input: crate::model::ResourceComplianceSummaryItem,
        ) -> Self {
            let mut v = self.resource_compliance_summary_items.unwrap_or_default();
            v.push(input);
            self.resource_compliance_summary_items = Some(v);
            self
        }
        /// <p>A summary count for specified or targeted managed nodes. Summary count includes information about compliant and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you specify. </p>
        pub fn set_resource_compliance_summary_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceComplianceSummaryItem>>,
        ) -> Self {
            self.resource_compliance_summary_items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceComplianceSummariesOutput`](crate::output::ListResourceComplianceSummariesOutput)
        pub fn build(self) -> crate::output::ListResourceComplianceSummariesOutput {
            crate::output::ListResourceComplianceSummariesOutput {
                resource_compliance_summary_items: self.resource_compliance_summary_items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResourceComplianceSummariesOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceComplianceSummariesOutput`](crate::output::ListResourceComplianceSummariesOutput)
    pub fn builder() -> crate::output::list_resource_compliance_summaries_output::Builder {
        crate::output::list_resource_compliance_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOpsMetadataOutput {
    /// <p>Returns a list of OpsMetadata objects.</p>
    pub ops_metadata_list: std::option::Option<std::vec::Vec<crate::model::OpsMetadata>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOpsMetadataOutput {
    /// <p>Returns a list of OpsMetadata objects.</p>
    pub fn ops_metadata_list(&self) -> std::option::Option<&[crate::model::OpsMetadata]> {
        self.ops_metadata_list.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOpsMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOpsMetadataOutput");
        formatter.field("ops_metadata_list", &self.ops_metadata_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOpsMetadataOutput`](crate::output::ListOpsMetadataOutput)
pub mod list_ops_metadata_output {
    /// A builder for [`ListOpsMetadataOutput`](crate::output::ListOpsMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_metadata_list: std::option::Option<std::vec::Vec<crate::model::OpsMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ops_metadata_list`.
        ///
        /// To override the contents of this collection use [`set_ops_metadata_list`](Self::set_ops_metadata_list).
        ///
        /// <p>Returns a list of OpsMetadata objects.</p>
        pub fn ops_metadata_list(mut self, input: crate::model::OpsMetadata) -> Self {
            let mut v = self.ops_metadata_list.unwrap_or_default();
            v.push(input);
            self.ops_metadata_list = Some(v);
            self
        }
        /// <p>Returns a list of OpsMetadata objects.</p>
        pub fn set_ops_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsMetadata>>,
        ) -> Self {
            self.ops_metadata_list = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpsMetadataOutput`](crate::output::ListOpsMetadataOutput)
        pub fn build(self) -> crate::output::ListOpsMetadataOutput {
            crate::output::ListOpsMetadataOutput {
                ops_metadata_list: self.ops_metadata_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOpsMetadataOutput {
    /// Creates a new builder-style object to manufacture [`ListOpsMetadataOutput`](crate::output::ListOpsMetadataOutput)
    pub fn builder() -> crate::output::list_ops_metadata_output::Builder {
        crate::output::list_ops_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOpsItemRelatedItemsOutput {
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of related-item resources for the specified OpsItem.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::OpsItemRelatedItemSummary>>,
}
impl ListOpsItemRelatedItemsOutput {
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of related-item resources for the specified OpsItem.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::OpsItemRelatedItemSummary]> {
        self.summaries.as_deref()
    }
}
impl std::fmt::Debug for ListOpsItemRelatedItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOpsItemRelatedItemsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("summaries", &self.summaries);
        formatter.finish()
    }
}
/// See [`ListOpsItemRelatedItemsOutput`](crate::output::ListOpsItemRelatedItemsOutput)
pub mod list_ops_item_related_items_output {
    /// A builder for [`ListOpsItemRelatedItemsOutput`](crate::output::ListOpsItemRelatedItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) summaries:
            std::option::Option<std::vec::Vec<crate::model::OpsItemRelatedItemSummary>>,
    }
    impl Builder {
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>A list of related-item resources for the specified OpsItem.</p>
        pub fn summaries(mut self, input: crate::model::OpsItemRelatedItemSummary) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input);
            self.summaries = Some(v);
            self
        }
        /// <p>A list of related-item resources for the specified OpsItem.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemRelatedItemSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpsItemRelatedItemsOutput`](crate::output::ListOpsItemRelatedItemsOutput)
        pub fn build(self) -> crate::output::ListOpsItemRelatedItemsOutput {
            crate::output::ListOpsItemRelatedItemsOutput {
                next_token: self.next_token,
                summaries: self.summaries,
            }
        }
    }
}
impl ListOpsItemRelatedItemsOutput {
    /// Creates a new builder-style object to manufacture [`ListOpsItemRelatedItemsOutput`](crate::output::ListOpsItemRelatedItemsOutput)
    pub fn builder() -> crate::output::list_ops_item_related_items_output::Builder {
        crate::output::list_ops_item_related_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOpsItemEventsOutput {
    /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of event information for the specified OpsItems.</p>
    pub summaries: std::option::Option<std::vec::Vec<crate::model::OpsItemEventSummary>>,
}
impl ListOpsItemEventsOutput {
    /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of event information for the specified OpsItems.</p>
    pub fn summaries(&self) -> std::option::Option<&[crate::model::OpsItemEventSummary]> {
        self.summaries.as_deref()
    }
}
impl std::fmt::Debug for ListOpsItemEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOpsItemEventsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("summaries", &self.summaries);
        formatter.finish()
    }
}
/// See [`ListOpsItemEventsOutput`](crate::output::ListOpsItemEventsOutput)
pub mod list_ops_item_events_output {
    /// A builder for [`ListOpsItemEventsOutput`](crate::output::ListOpsItemEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) summaries: std::option::Option<std::vec::Vec<crate::model::OpsItemEventSummary>>,
    }
    impl Builder {
        /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `summaries`.
        ///
        /// To override the contents of this collection use [`set_summaries`](Self::set_summaries).
        ///
        /// <p>A list of event information for the specified OpsItems.</p>
        pub fn summaries(mut self, input: crate::model::OpsItemEventSummary) -> Self {
            let mut v = self.summaries.unwrap_or_default();
            v.push(input);
            self.summaries = Some(v);
            self
        }
        /// <p>A list of event information for the specified OpsItems.</p>
        pub fn set_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemEventSummary>>,
        ) -> Self {
            self.summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpsItemEventsOutput`](crate::output::ListOpsItemEventsOutput)
        pub fn build(self) -> crate::output::ListOpsItemEventsOutput {
            crate::output::ListOpsItemEventsOutput {
                next_token: self.next_token,
                summaries: self.summaries,
            }
        }
    }
}
impl ListOpsItemEventsOutput {
    /// Creates a new builder-style object to manufacture [`ListOpsItemEventsOutput`](crate::output::ListOpsItemEventsOutput)
    pub fn builder() -> crate::output::list_ops_item_events_output::Builder {
        crate::output::list_ops_item_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInventoryEntriesOutput {
    /// <p>The type of inventory item returned by the request.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The managed node ID targeted by the request to query inventory information.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The inventory schema version used by the managed node(s).</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The time that inventory information was collected for the managed node(s).</p>
    pub capture_time: std::option::Option<std::string::String>,
    /// <p>A list of inventory items on the managed node(s).</p>
    pub entries: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInventoryEntriesOutput {
    /// <p>The type of inventory item returned by the request.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The managed node ID targeted by the request to query inventory information.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The inventory schema version used by the managed node(s).</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    /// <p>The time that inventory information was collected for the managed node(s).</p>
    pub fn capture_time(&self) -> std::option::Option<&str> {
        self.capture_time.as_deref()
    }
    /// <p>A list of inventory items on the managed node(s).</p>
    pub fn entries(
        &self,
    ) -> std::option::Option<&[std::collections::HashMap<std::string::String, std::string::String>]>
    {
        self.entries.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInventoryEntriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInventoryEntriesOutput");
        formatter.field("type_name", &self.type_name);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("capture_time", &self.capture_time);
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInventoryEntriesOutput`](crate::output::ListInventoryEntriesOutput)
pub mod list_inventory_entries_output {
    /// A builder for [`ListInventoryEntriesOutput`](crate::output::ListInventoryEntriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) capture_time: std::option::Option<std::string::String>,
        pub(crate) entries: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of inventory item returned by the request.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The type of inventory item returned by the request.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The managed node ID targeted by the request to query inventory information.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node ID targeted by the request to query inventory information.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The inventory schema version used by the managed node(s).</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The inventory schema version used by the managed node(s).</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The time that inventory information was collected for the managed node(s).</p>
        pub fn capture_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.capture_time = Some(input.into());
            self
        }
        /// <p>The time that inventory information was collected for the managed node(s).</p>
        pub fn set_capture_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capture_time = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of inventory items on the managed node(s).</p>
        pub fn entries(
            mut self,
            input: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>A list of inventory items on the managed node(s).</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInventoryEntriesOutput`](crate::output::ListInventoryEntriesOutput)
        pub fn build(self) -> crate::output::ListInventoryEntriesOutput {
            crate::output::ListInventoryEntriesOutput {
                type_name: self.type_name,
                instance_id: self.instance_id,
                schema_version: self.schema_version,
                capture_time: self.capture_time,
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInventoryEntriesOutput {
    /// Creates a new builder-style object to manufacture [`ListInventoryEntriesOutput`](crate::output::ListInventoryEntriesOutput)
    pub fn builder() -> crate::output::list_inventory_entries_output::Builder {
        crate::output::list_inventory_entries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDocumentVersionsOutput {
    /// <p>The document versions.</p>
    pub document_versions: std::option::Option<std::vec::Vec<crate::model::DocumentVersionInfo>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDocumentVersionsOutput {
    /// <p>The document versions.</p>
    pub fn document_versions(&self) -> std::option::Option<&[crate::model::DocumentVersionInfo]> {
        self.document_versions.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDocumentVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDocumentVersionsOutput");
        formatter.field("document_versions", &self.document_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDocumentVersionsOutput`](crate::output::ListDocumentVersionsOutput)
pub mod list_document_versions_output {
    /// A builder for [`ListDocumentVersionsOutput`](crate::output::ListDocumentVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_versions:
            std::option::Option<std::vec::Vec<crate::model::DocumentVersionInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `document_versions`.
        ///
        /// To override the contents of this collection use [`set_document_versions`](Self::set_document_versions).
        ///
        /// <p>The document versions.</p>
        pub fn document_versions(mut self, input: crate::model::DocumentVersionInfo) -> Self {
            let mut v = self.document_versions.unwrap_or_default();
            v.push(input);
            self.document_versions = Some(v);
            self
        }
        /// <p>The document versions.</p>
        pub fn set_document_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentVersionInfo>>,
        ) -> Self {
            self.document_versions = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentVersionsOutput`](crate::output::ListDocumentVersionsOutput)
        pub fn build(self) -> crate::output::ListDocumentVersionsOutput {
            crate::output::ListDocumentVersionsOutput {
                document_versions: self.document_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDocumentVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDocumentVersionsOutput`](crate::output::ListDocumentVersionsOutput)
    pub fn builder() -> crate::output::list_document_versions_output::Builder {
        crate::output::list_document_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDocumentsOutput {
    /// <p>The names of the SSM documents.</p>
    pub document_identifiers: std::option::Option<std::vec::Vec<crate::model::DocumentIdentifier>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDocumentsOutput {
    /// <p>The names of the SSM documents.</p>
    pub fn document_identifiers(&self) -> std::option::Option<&[crate::model::DocumentIdentifier]> {
        self.document_identifiers.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDocumentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDocumentsOutput");
        formatter.field("document_identifiers", &self.document_identifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDocumentsOutput`](crate::output::ListDocumentsOutput)
pub mod list_documents_output {
    /// A builder for [`ListDocumentsOutput`](crate::output::ListDocumentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_identifiers:
            std::option::Option<std::vec::Vec<crate::model::DocumentIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `document_identifiers`.
        ///
        /// To override the contents of this collection use [`set_document_identifiers`](Self::set_document_identifiers).
        ///
        /// <p>The names of the SSM documents.</p>
        pub fn document_identifiers(mut self, input: crate::model::DocumentIdentifier) -> Self {
            let mut v = self.document_identifiers.unwrap_or_default();
            v.push(input);
            self.document_identifiers = Some(v);
            self
        }
        /// <p>The names of the SSM documents.</p>
        pub fn set_document_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentIdentifier>>,
        ) -> Self {
            self.document_identifiers = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentsOutput`](crate::output::ListDocumentsOutput)
        pub fn build(self) -> crate::output::ListDocumentsOutput {
            crate::output::ListDocumentsOutput {
                document_identifiers: self.document_identifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDocumentsOutput {
    /// Creates a new builder-style object to manufacture [`ListDocumentsOutput`](crate::output::ListDocumentsOutput)
    pub fn builder() -> crate::output::list_documents_output::Builder {
        crate::output::list_documents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDocumentMetadataHistoryOutput {
    /// <p>The name of the change template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the change template.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The user ID of the person in the organization who requested the review of the change template.</p>
    pub author: std::option::Option<std::string::String>,
    /// <p>Information about the response to the change template approval request.</p>
    pub metadata: std::option::Option<crate::model::DocumentMetadataResponseInfo>,
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDocumentMetadataHistoryOutput {
    /// <p>The name of the change template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the change template.</p>
    pub fn document_version(&self) -> std::option::Option<&str> {
        self.document_version.as_deref()
    }
    /// <p>The user ID of the person in the organization who requested the review of the change template.</p>
    pub fn author(&self) -> std::option::Option<&str> {
        self.author.as_deref()
    }
    /// <p>Information about the response to the change template approval request.</p>
    pub fn metadata(&self) -> std::option::Option<&crate::model::DocumentMetadataResponseInfo> {
        self.metadata.as_ref()
    }
    /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDocumentMetadataHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDocumentMetadataHistoryOutput");
        formatter.field("name", &self.name);
        formatter.field("document_version", &self.document_version);
        formatter.field("author", &self.author);
        formatter.field("metadata", &self.metadata);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDocumentMetadataHistoryOutput`](crate::output::ListDocumentMetadataHistoryOutput)
pub mod list_document_metadata_history_output {
    /// A builder for [`ListDocumentMetadataHistoryOutput`](crate::output::ListDocumentMetadataHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<crate::model::DocumentMetadataResponseInfo>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the change template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the change template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the change template.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of the change template.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The user ID of the person in the organization who requested the review of the change template.</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The user ID of the person in the organization who requested the review of the change template.</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p>Information about the response to the change template approval request.</p>
        pub fn metadata(mut self, input: crate::model::DocumentMetadataResponseInfo) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>Information about the response to the change template approval request.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadataResponseInfo>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentMetadataHistoryOutput`](crate::output::ListDocumentMetadataHistoryOutput)
        pub fn build(self) -> crate::output::ListDocumentMetadataHistoryOutput {
            crate::output::ListDocumentMetadataHistoryOutput {
                name: self.name,
                document_version: self.document_version,
                author: self.author,
                metadata: self.metadata,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDocumentMetadataHistoryOutput {
    /// Creates a new builder-style object to manufacture [`ListDocumentMetadataHistoryOutput`](crate::output::ListDocumentMetadataHistoryOutput)
    pub fn builder() -> crate::output::list_document_metadata_history_output::Builder {
        crate::output::list_document_metadata_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComplianceSummariesOutput {
    /// <p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria that you specified.</p>
    pub compliance_summary_items:
        std::option::Option<std::vec::Vec<crate::model::ComplianceSummaryItem>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComplianceSummariesOutput {
    /// <p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria that you specified.</p>
    pub fn compliance_summary_items(
        &self,
    ) -> std::option::Option<&[crate::model::ComplianceSummaryItem]> {
        self.compliance_summary_items.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComplianceSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComplianceSummariesOutput");
        formatter.field("compliance_summary_items", &self.compliance_summary_items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComplianceSummariesOutput`](crate::output::ListComplianceSummariesOutput)
pub mod list_compliance_summaries_output {
    /// A builder for [`ListComplianceSummariesOutput`](crate::output::ListComplianceSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_summary_items:
            std::option::Option<std::vec::Vec<crate::model::ComplianceSummaryItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `compliance_summary_items`.
        ///
        /// To override the contents of this collection use [`set_compliance_summary_items`](Self::set_compliance_summary_items).
        ///
        /// <p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria that you specified.</p>
        pub fn compliance_summary_items(
            mut self,
            input: crate::model::ComplianceSummaryItem,
        ) -> Self {
            let mut v = self.compliance_summary_items.unwrap_or_default();
            v.push(input);
            self.compliance_summary_items = Some(v);
            self
        }
        /// <p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria that you specified.</p>
        pub fn set_compliance_summary_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceSummaryItem>>,
        ) -> Self {
            self.compliance_summary_items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComplianceSummariesOutput`](crate::output::ListComplianceSummariesOutput)
        pub fn build(self) -> crate::output::ListComplianceSummariesOutput {
            crate::output::ListComplianceSummariesOutput {
                compliance_summary_items: self.compliance_summary_items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComplianceSummariesOutput {
    /// Creates a new builder-style object to manufacture [`ListComplianceSummariesOutput`](crate::output::ListComplianceSummariesOutput)
    pub fn builder() -> crate::output::list_compliance_summaries_output::Builder {
        crate::output::list_compliance_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComplianceItemsOutput {
    /// <p>A list of compliance information for the specified resource ID. </p>
    pub compliance_items: std::option::Option<std::vec::Vec<crate::model::ComplianceItem>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComplianceItemsOutput {
    /// <p>A list of compliance information for the specified resource ID. </p>
    pub fn compliance_items(&self) -> std::option::Option<&[crate::model::ComplianceItem]> {
        self.compliance_items.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComplianceItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComplianceItemsOutput");
        formatter.field("compliance_items", &self.compliance_items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComplianceItemsOutput`](crate::output::ListComplianceItemsOutput)
pub mod list_compliance_items_output {
    /// A builder for [`ListComplianceItemsOutput`](crate::output::ListComplianceItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_items:
            std::option::Option<std::vec::Vec<crate::model::ComplianceItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `compliance_items`.
        ///
        /// To override the contents of this collection use [`set_compliance_items`](Self::set_compliance_items).
        ///
        /// <p>A list of compliance information for the specified resource ID. </p>
        pub fn compliance_items(mut self, input: crate::model::ComplianceItem) -> Self {
            let mut v = self.compliance_items.unwrap_or_default();
            v.push(input);
            self.compliance_items = Some(v);
            self
        }
        /// <p>A list of compliance information for the specified resource ID. </p>
        pub fn set_compliance_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceItem>>,
        ) -> Self {
            self.compliance_items = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComplianceItemsOutput`](crate::output::ListComplianceItemsOutput)
        pub fn build(self) -> crate::output::ListComplianceItemsOutput {
            crate::output::ListComplianceItemsOutput {
                compliance_items: self.compliance_items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComplianceItemsOutput {
    /// Creates a new builder-style object to manufacture [`ListComplianceItemsOutput`](crate::output::ListComplianceItemsOutput)
    pub fn builder() -> crate::output::list_compliance_items_output::Builder {
        crate::output::list_compliance_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCommandsOutput {
    /// <p>(Optional) The list of commands requested by the user. </p>
    pub commands: std::option::Option<std::vec::Vec<crate::model::Command>>,
    /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCommandsOutput {
    /// <p>(Optional) The list of commands requested by the user. </p>
    pub fn commands(&self) -> std::option::Option<&[crate::model::Command]> {
        self.commands.as_deref()
    }
    /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCommandsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCommandsOutput");
        formatter.field("commands", &self.commands);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCommandsOutput`](crate::output::ListCommandsOutput)
pub mod list_commands_output {
    /// A builder for [`ListCommandsOutput`](crate::output::ListCommandsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commands: std::option::Option<std::vec::Vec<crate::model::Command>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `commands`.
        ///
        /// To override the contents of this collection use [`set_commands`](Self::set_commands).
        ///
        /// <p>(Optional) The list of commands requested by the user. </p>
        pub fn commands(mut self, input: crate::model::Command) -> Self {
            let mut v = self.commands.unwrap_or_default();
            v.push(input);
            self.commands = Some(v);
            self
        }
        /// <p>(Optional) The list of commands requested by the user. </p>
        pub fn set_commands(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Command>>,
        ) -> Self {
            self.commands = input;
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCommandsOutput`](crate::output::ListCommandsOutput)
        pub fn build(self) -> crate::output::ListCommandsOutput {
            crate::output::ListCommandsOutput {
                commands: self.commands,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCommandsOutput {
    /// Creates a new builder-style object to manufacture [`ListCommandsOutput`](crate::output::ListCommandsOutput)
    pub fn builder() -> crate::output::list_commands_output::Builder {
        crate::output::list_commands_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCommandInvocationsOutput {
    /// <p>(Optional) A list of all invocations. </p>
    pub command_invocations: std::option::Option<std::vec::Vec<crate::model::CommandInvocation>>,
    /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCommandInvocationsOutput {
    /// <p>(Optional) A list of all invocations. </p>
    pub fn command_invocations(&self) -> std::option::Option<&[crate::model::CommandInvocation]> {
        self.command_invocations.as_deref()
    }
    /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCommandInvocationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCommandInvocationsOutput");
        formatter.field("command_invocations", &self.command_invocations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCommandInvocationsOutput`](crate::output::ListCommandInvocationsOutput)
pub mod list_command_invocations_output {
    /// A builder for [`ListCommandInvocationsOutput`](crate::output::ListCommandInvocationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_invocations:
            std::option::Option<std::vec::Vec<crate::model::CommandInvocation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `command_invocations`.
        ///
        /// To override the contents of this collection use [`set_command_invocations`](Self::set_command_invocations).
        ///
        /// <p>(Optional) A list of all invocations. </p>
        pub fn command_invocations(mut self, input: crate::model::CommandInvocation) -> Self {
            let mut v = self.command_invocations.unwrap_or_default();
            v.push(input);
            self.command_invocations = Some(v);
            self
        }
        /// <p>(Optional) A list of all invocations. </p>
        pub fn set_command_invocations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandInvocation>>,
        ) -> Self {
            self.command_invocations = input;
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCommandInvocationsOutput`](crate::output::ListCommandInvocationsOutput)
        pub fn build(self) -> crate::output::ListCommandInvocationsOutput {
            crate::output::ListCommandInvocationsOutput {
                command_invocations: self.command_invocations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCommandInvocationsOutput {
    /// Creates a new builder-style object to manufacture [`ListCommandInvocationsOutput`](crate::output::ListCommandInvocationsOutput)
    pub fn builder() -> crate::output::list_command_invocations_output::Builder {
        crate::output::list_command_invocations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociationVersionsOutput {
    /// <p>Information about all versions of the association for the specified association ID.</p>
    pub association_versions:
        std::option::Option<std::vec::Vec<crate::model::AssociationVersionInfo>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociationVersionsOutput {
    /// <p>Information about all versions of the association for the specified association ID.</p>
    pub fn association_versions(
        &self,
    ) -> std::option::Option<&[crate::model::AssociationVersionInfo]> {
        self.association_versions.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociationVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociationVersionsOutput");
        formatter.field("association_versions", &self.association_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociationVersionsOutput`](crate::output::ListAssociationVersionsOutput)
pub mod list_association_versions_output {
    /// A builder for [`ListAssociationVersionsOutput`](crate::output::ListAssociationVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_versions:
            std::option::Option<std::vec::Vec<crate::model::AssociationVersionInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `association_versions`.
        ///
        /// To override the contents of this collection use [`set_association_versions`](Self::set_association_versions).
        ///
        /// <p>Information about all versions of the association for the specified association ID.</p>
        pub fn association_versions(mut self, input: crate::model::AssociationVersionInfo) -> Self {
            let mut v = self.association_versions.unwrap_or_default();
            v.push(input);
            self.association_versions = Some(v);
            self
        }
        /// <p>Information about all versions of the association for the specified association ID.</p>
        pub fn set_association_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationVersionInfo>>,
        ) -> Self {
            self.association_versions = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociationVersionsOutput`](crate::output::ListAssociationVersionsOutput)
        pub fn build(self) -> crate::output::ListAssociationVersionsOutput {
            crate::output::ListAssociationVersionsOutput {
                association_versions: self.association_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociationVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociationVersionsOutput`](crate::output::ListAssociationVersionsOutput)
    pub fn builder() -> crate::output::list_association_versions_output::Builder {
        crate::output::list_association_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociationsOutput {
    /// <p>The associations.</p>
    pub associations: std::option::Option<std::vec::Vec<crate::model::Association>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociationsOutput {
    /// <p>The associations.</p>
    pub fn associations(&self) -> std::option::Option<&[crate::model::Association]> {
        self.associations.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociationsOutput");
        formatter.field("associations", &self.associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
pub mod list_associations_output {
    /// A builder for [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associations: std::option::Option<std::vec::Vec<crate::model::Association>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `associations`.
        ///
        /// To override the contents of this collection use [`set_associations`](Self::set_associations).
        ///
        /// <p>The associations.</p>
        pub fn associations(mut self, input: crate::model::Association) -> Self {
            let mut v = self.associations.unwrap_or_default();
            v.push(input);
            self.associations = Some(v);
            self
        }
        /// <p>The associations.</p>
        pub fn set_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Association>>,
        ) -> Self {
            self.associations = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
        pub fn build(self) -> crate::output::ListAssociationsOutput {
            crate::output::ListAssociationsOutput {
                associations: self.associations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
    pub fn builder() -> crate::output::list_associations_output::Builder {
        crate::output::list_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LabelParameterVersionOutput {
    /// <p>The label doesn't meet the requirements. For information about parameter label requirements, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub invalid_labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The version of the parameter that has been labeled.</p>
    pub parameter_version: i64,
}
impl LabelParameterVersionOutput {
    /// <p>The label doesn't meet the requirements. For information about parameter label requirements, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub fn invalid_labels(&self) -> std::option::Option<&[std::string::String]> {
        self.invalid_labels.as_deref()
    }
    /// <p>The version of the parameter that has been labeled.</p>
    pub fn parameter_version(&self) -> i64 {
        self.parameter_version
    }
}
impl std::fmt::Debug for LabelParameterVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LabelParameterVersionOutput");
        formatter.field("invalid_labels", &self.invalid_labels);
        formatter.field("parameter_version", &self.parameter_version);
        formatter.finish()
    }
}
/// See [`LabelParameterVersionOutput`](crate::output::LabelParameterVersionOutput)
pub mod label_parameter_version_output {
    /// A builder for [`LabelParameterVersionOutput`](crate::output::LabelParameterVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invalid_labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parameter_version: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `invalid_labels`.
        ///
        /// To override the contents of this collection use [`set_invalid_labels`](Self::set_invalid_labels).
        ///
        /// <p>The label doesn't meet the requirements. For information about parameter label requirements, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn invalid_labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.invalid_labels.unwrap_or_default();
            v.push(input.into());
            self.invalid_labels = Some(v);
            self
        }
        /// <p>The label doesn't meet the requirements. For information about parameter label requirements, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_invalid_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.invalid_labels = input;
            self
        }
        /// <p>The version of the parameter that has been labeled.</p>
        pub fn parameter_version(mut self, input: i64) -> Self {
            self.parameter_version = Some(input);
            self
        }
        /// <p>The version of the parameter that has been labeled.</p>
        pub fn set_parameter_version(mut self, input: std::option::Option<i64>) -> Self {
            self.parameter_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LabelParameterVersionOutput`](crate::output::LabelParameterVersionOutput)
        pub fn build(self) -> crate::output::LabelParameterVersionOutput {
            crate::output::LabelParameterVersionOutput {
                invalid_labels: self.invalid_labels,
                parameter_version: self.parameter_version.unwrap_or_default(),
            }
        }
    }
}
impl LabelParameterVersionOutput {
    /// Creates a new builder-style object to manufacture [`LabelParameterVersionOutput`](crate::output::LabelParameterVersionOutput)
    pub fn builder() -> crate::output::label_parameter_version_output::Builder {
        crate::output::label_parameter_version_output::Builder::default()
    }
}

/// <p>The query result body of the GetServiceSetting API operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceSettingOutput {
    /// <p>The query result of the current service setting.</p>
    pub service_setting: std::option::Option<crate::model::ServiceSetting>,
}
impl GetServiceSettingOutput {
    /// <p>The query result of the current service setting.</p>
    pub fn service_setting(&self) -> std::option::Option<&crate::model::ServiceSetting> {
        self.service_setting.as_ref()
    }
}
impl std::fmt::Debug for GetServiceSettingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceSettingOutput");
        formatter.field("service_setting", &self.service_setting);
        formatter.finish()
    }
}
/// See [`GetServiceSettingOutput`](crate::output::GetServiceSettingOutput)
pub mod get_service_setting_output {
    /// A builder for [`GetServiceSettingOutput`](crate::output::GetServiceSettingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_setting: std::option::Option<crate::model::ServiceSetting>,
    }
    impl Builder {
        /// <p>The query result of the current service setting.</p>
        pub fn service_setting(mut self, input: crate::model::ServiceSetting) -> Self {
            self.service_setting = Some(input);
            self
        }
        /// <p>The query result of the current service setting.</p>
        pub fn set_service_setting(
            mut self,
            input: std::option::Option<crate::model::ServiceSetting>,
        ) -> Self {
            self.service_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceSettingOutput`](crate::output::GetServiceSettingOutput)
        pub fn build(self) -> crate::output::GetServiceSettingOutput {
            crate::output::GetServiceSettingOutput {
                service_setting: self.service_setting,
            }
        }
    }
}
impl GetServiceSettingOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceSettingOutput`](crate::output::GetServiceSettingOutput)
    pub fn builder() -> crate::output::get_service_setting_output::Builder {
        crate::output::get_service_setting_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPatchBaselineForPatchGroupOutput {
    /// <p>The ID of the patch baseline that should be used for the patch group.</p>
    pub baseline_id: std::option::Option<std::string::String>,
    /// <p>The name of the patch group.</p>
    pub patch_group: std::option::Option<std::string::String>,
    /// <p>The operating system rule specified for patch groups using the patch baseline.</p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
}
impl GetPatchBaselineForPatchGroupOutput {
    /// <p>The ID of the patch baseline that should be used for the patch group.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
    /// <p>The name of the patch group.</p>
    pub fn patch_group(&self) -> std::option::Option<&str> {
        self.patch_group.as_deref()
    }
    /// <p>The operating system rule specified for patch groups using the patch baseline.</p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
}
impl std::fmt::Debug for GetPatchBaselineForPatchGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPatchBaselineForPatchGroupOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.field("patch_group", &self.patch_group);
        formatter.field("operating_system", &self.operating_system);
        formatter.finish()
    }
}
/// See [`GetPatchBaselineForPatchGroupOutput`](crate::output::GetPatchBaselineForPatchGroupOutput)
pub mod get_patch_baseline_for_patch_group_output {
    /// A builder for [`GetPatchBaselineForPatchGroupOutput`](crate::output::GetPatchBaselineForPatchGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) patch_group: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline that should be used for the patch group.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline that should be used for the patch group.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The name of the patch group.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// <p>The operating system rule specified for patch groups using the patch baseline.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system rule specified for patch groups using the patch baseline.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPatchBaselineForPatchGroupOutput`](crate::output::GetPatchBaselineForPatchGroupOutput)
        pub fn build(self) -> crate::output::GetPatchBaselineForPatchGroupOutput {
            crate::output::GetPatchBaselineForPatchGroupOutput {
                baseline_id: self.baseline_id,
                patch_group: self.patch_group,
                operating_system: self.operating_system,
            }
        }
    }
}
impl GetPatchBaselineForPatchGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetPatchBaselineForPatchGroupOutput`](crate::output::GetPatchBaselineForPatchGroupOutput)
    pub fn builder() -> crate::output::get_patch_baseline_for_patch_group_output::Builder {
        crate::output::get_patch_baseline_for_patch_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPatchBaselineOutput {
    /// <p>The ID of the retrieved patch baseline.</p>
    pub baseline_id: std::option::Option<std::string::String>,
    /// <p>The name of the patch baseline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Returns the operating system specified for the patch baseline.</p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>A set of global filters used to exclude patches from the baseline.</p>
    pub global_filters: std::option::Option<crate::model::PatchFilterGroup>,
    /// <p>A set of rules used to include patches in the baseline.</p>
    pub approval_rules: std::option::Option<crate::model::PatchRuleGroup>,
    /// <p>A list of explicitly approved patches for the baseline.</p>
    pub approved_patches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>
    pub approved_patches_compliance_level: std::option::Option<crate::model::PatchComplianceLevel>,
    /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    pub approved_patches_enable_non_security: std::option::Option<bool>,
    /// <p>A list of explicitly rejected patches for the baseline.</p>
    pub rejected_patches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
    pub rejected_patches_action: std::option::Option<crate::model::PatchAction>,
    /// <p>Patch groups included in the patch baseline.</p>
    pub patch_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date the patch baseline was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the patch baseline was last modified.</p>
    pub modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A description of the patch baseline.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
}
impl GetPatchBaselineOutput {
    /// <p>The ID of the retrieved patch baseline.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
    /// <p>The name of the patch baseline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Returns the operating system specified for the patch baseline.</p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
    /// <p>A set of global filters used to exclude patches from the baseline.</p>
    pub fn global_filters(&self) -> std::option::Option<&crate::model::PatchFilterGroup> {
        self.global_filters.as_ref()
    }
    /// <p>A set of rules used to include patches in the baseline.</p>
    pub fn approval_rules(&self) -> std::option::Option<&crate::model::PatchRuleGroup> {
        self.approval_rules.as_ref()
    }
    /// <p>A list of explicitly approved patches for the baseline.</p>
    pub fn approved_patches(&self) -> std::option::Option<&[std::string::String]> {
        self.approved_patches.as_deref()
    }
    /// <p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>
    pub fn approved_patches_compliance_level(
        &self,
    ) -> std::option::Option<&crate::model::PatchComplianceLevel> {
        self.approved_patches_compliance_level.as_ref()
    }
    /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    pub fn approved_patches_enable_non_security(&self) -> std::option::Option<bool> {
        self.approved_patches_enable_non_security
    }
    /// <p>A list of explicitly rejected patches for the baseline.</p>
    pub fn rejected_patches(&self) -> std::option::Option<&[std::string::String]> {
        self.rejected_patches.as_deref()
    }
    /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
    pub fn rejected_patches_action(&self) -> std::option::Option<&crate::model::PatchAction> {
        self.rejected_patches_action.as_ref()
    }
    /// <p>Patch groups included in the patch baseline.</p>
    pub fn patch_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.patch_groups.as_deref()
    }
    /// <p>The date the patch baseline was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The date the patch baseline was last modified.</p>
    pub fn modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_date.as_ref()
    }
    /// <p>A description of the patch baseline.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::PatchSource]> {
        self.sources.as_deref()
    }
}
impl std::fmt::Debug for GetPatchBaselineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPatchBaselineOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.field("name", &self.name);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("global_filters", &self.global_filters);
        formatter.field("approval_rules", &self.approval_rules);
        formatter.field("approved_patches", &self.approved_patches);
        formatter.field(
            "approved_patches_compliance_level",
            &self.approved_patches_compliance_level,
        );
        formatter.field(
            "approved_patches_enable_non_security",
            &self.approved_patches_enable_non_security,
        );
        formatter.field("rejected_patches", &self.rejected_patches);
        formatter.field("rejected_patches_action", &self.rejected_patches_action);
        formatter.field("patch_groups", &self.patch_groups);
        formatter.field("created_date", &self.created_date);
        formatter.field("modified_date", &self.modified_date);
        formatter.field("description", &self.description);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}
/// See [`GetPatchBaselineOutput`](crate::output::GetPatchBaselineOutput)
pub mod get_patch_baseline_output {
    /// A builder for [`GetPatchBaselineOutput`](crate::output::GetPatchBaselineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) global_filters: std::option::Option<crate::model::PatchFilterGroup>,
        pub(crate) approval_rules: std::option::Option<crate::model::PatchRuleGroup>,
        pub(crate) approved_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) approved_patches_compliance_level:
            std::option::Option<crate::model::PatchComplianceLevel>,
        pub(crate) approved_patches_enable_non_security: std::option::Option<bool>,
        pub(crate) rejected_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rejected_patches_action: std::option::Option<crate::model::PatchAction>,
        pub(crate) patch_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
    }
    impl Builder {
        /// <p>The ID of the retrieved patch baseline.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the retrieved patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Returns the operating system specified for the patch baseline.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Returns the operating system specified for the patch baseline.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>A set of global filters used to exclude patches from the baseline.</p>
        pub fn global_filters(mut self, input: crate::model::PatchFilterGroup) -> Self {
            self.global_filters = Some(input);
            self
        }
        /// <p>A set of global filters used to exclude patches from the baseline.</p>
        pub fn set_global_filters(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.global_filters = input;
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn approval_rules(mut self, input: crate::model::PatchRuleGroup) -> Self {
            self.approval_rules = Some(input);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<crate::model::PatchRuleGroup>,
        ) -> Self {
            self.approval_rules = input;
            self
        }
        /// Appends an item to `approved_patches`.
        ///
        /// To override the contents of this collection use [`set_approved_patches`](Self::set_approved_patches).
        ///
        /// <p>A list of explicitly approved patches for the baseline.</p>
        pub fn approved_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.approved_patches.unwrap_or_default();
            v.push(input.into());
            self.approved_patches = Some(v);
            self
        }
        /// <p>A list of explicitly approved patches for the baseline.</p>
        pub fn set_approved_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approved_patches = input;
            self
        }
        /// <p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>
        pub fn approved_patches_compliance_level(
            mut self,
            input: crate::model::PatchComplianceLevel,
        ) -> Self {
            self.approved_patches_compliance_level = Some(input);
            self
        }
        /// <p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>
        pub fn set_approved_patches_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.approved_patches_compliance_level = input;
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
        pub fn approved_patches_enable_non_security(mut self, input: bool) -> Self {
            self.approved_patches_enable_non_security = Some(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
        pub fn set_approved_patches_enable_non_security(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.approved_patches_enable_non_security = input;
            self
        }
        /// Appends an item to `rejected_patches`.
        ///
        /// To override the contents of this collection use [`set_rejected_patches`](Self::set_rejected_patches).
        ///
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        pub fn rejected_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rejected_patches.unwrap_or_default();
            v.push(input.into());
            self.rejected_patches = Some(v);
            self
        }
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        pub fn set_rejected_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rejected_patches = input;
            self
        }
        /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
        pub fn rejected_patches_action(mut self, input: crate::model::PatchAction) -> Self {
            self.rejected_patches_action = Some(input);
            self
        }
        /// <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
        pub fn set_rejected_patches_action(
            mut self,
            input: std::option::Option<crate::model::PatchAction>,
        ) -> Self {
            self.rejected_patches_action = input;
            self
        }
        /// Appends an item to `patch_groups`.
        ///
        /// To override the contents of this collection use [`set_patch_groups`](Self::set_patch_groups).
        ///
        /// <p>Patch groups included in the patch baseline.</p>
        pub fn patch_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.patch_groups.unwrap_or_default();
            v.push(input.into());
            self.patch_groups = Some(v);
            self
        }
        /// <p>Patch groups included in the patch baseline.</p>
        pub fn set_patch_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.patch_groups = input;
            self
        }
        /// <p>The date the patch baseline was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the patch baseline was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The date the patch baseline was last modified.</p>
        pub fn modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_date = Some(input);
            self
        }
        /// <p>The date the patch baseline was last modified.</p>
        pub fn set_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_date = input;
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn sources(mut self, input: crate::model::PatchSource) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPatchBaselineOutput`](crate::output::GetPatchBaselineOutput)
        pub fn build(self) -> crate::output::GetPatchBaselineOutput {
            crate::output::GetPatchBaselineOutput {
                baseline_id: self.baseline_id,
                name: self.name,
                operating_system: self.operating_system,
                global_filters: self.global_filters,
                approval_rules: self.approval_rules,
                approved_patches: self.approved_patches,
                approved_patches_compliance_level: self.approved_patches_compliance_level,
                approved_patches_enable_non_security: self.approved_patches_enable_non_security,
                rejected_patches: self.rejected_patches,
                rejected_patches_action: self.rejected_patches_action,
                patch_groups: self.patch_groups,
                created_date: self.created_date,
                modified_date: self.modified_date,
                description: self.description,
                sources: self.sources,
            }
        }
    }
}
impl GetPatchBaselineOutput {
    /// Creates a new builder-style object to manufacture [`GetPatchBaselineOutput`](crate::output::GetPatchBaselineOutput)
    pub fn builder() -> crate::output::get_patch_baseline_output::Builder {
        crate::output::get_patch_baseline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetParametersByPathOutput {
    /// <p>A list of parameters found in the specified hierarchy.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetParametersByPathOutput {
    /// <p>A list of parameters found in the specified hierarchy.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetParametersByPathOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetParametersByPathOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetParametersByPathOutput`](crate::output::GetParametersByPathOutput)
pub mod get_parameters_by_path_output {
    /// A builder for [`GetParametersByPathOutput`](crate::output::GetParametersByPathOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters found in the specified hierarchy.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameters found in the specified hierarchy.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParametersByPathOutput`](crate::output::GetParametersByPathOutput)
        pub fn build(self) -> crate::output::GetParametersByPathOutput {
            crate::output::GetParametersByPathOutput {
                parameters: self.parameters,
                next_token: self.next_token,
            }
        }
    }
}
impl GetParametersByPathOutput {
    /// Creates a new builder-style object to manufacture [`GetParametersByPathOutput`](crate::output::GetParametersByPathOutput)
    pub fn builder() -> crate::output::get_parameters_by_path_output::Builder {
        crate::output::get_parameters_by_path_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetParametersOutput {
    /// <p>A list of details for a parameter.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>A list of parameters that aren't formatted correctly or don't run during an execution.</p>
    pub invalid_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetParametersOutput {
    /// <p>A list of details for a parameter.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>A list of parameters that aren't formatted correctly or don't run during an execution.</p>
    pub fn invalid_parameters(&self) -> std::option::Option<&[std::string::String]> {
        self.invalid_parameters.as_deref()
    }
}
impl std::fmt::Debug for GetParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetParametersOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("invalid_parameters", &self.invalid_parameters);
        formatter.finish()
    }
}
/// See [`GetParametersOutput`](crate::output::GetParametersOutput)
pub mod get_parameters_output {
    /// A builder for [`GetParametersOutput`](crate::output::GetParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) invalid_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of details for a parameter.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>A list of details for a parameter.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `invalid_parameters`.
        ///
        /// To override the contents of this collection use [`set_invalid_parameters`](Self::set_invalid_parameters).
        ///
        /// <p>A list of parameters that aren't formatted correctly or don't run during an execution.</p>
        pub fn invalid_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.invalid_parameters.unwrap_or_default();
            v.push(input.into());
            self.invalid_parameters = Some(v);
            self
        }
        /// <p>A list of parameters that aren't formatted correctly or don't run during an execution.</p>
        pub fn set_invalid_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.invalid_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParametersOutput`](crate::output::GetParametersOutput)
        pub fn build(self) -> crate::output::GetParametersOutput {
            crate::output::GetParametersOutput {
                parameters: self.parameters,
                invalid_parameters: self.invalid_parameters,
            }
        }
    }
}
impl GetParametersOutput {
    /// Creates a new builder-style object to manufacture [`GetParametersOutput`](crate::output::GetParametersOutput)
    pub fn builder() -> crate::output::get_parameters_output::Builder {
        crate::output::get_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetParameterHistoryOutput {
    /// <p>A list of parameters returned by the request.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::ParameterHistory>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetParameterHistoryOutput {
    /// <p>A list of parameters returned by the request.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::ParameterHistory]> {
        self.parameters.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetParameterHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetParameterHistoryOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetParameterHistoryOutput`](crate::output::GetParameterHistoryOutput)
pub mod get_parameter_history_output {
    /// A builder for [`GetParameterHistoryOutput`](crate::output::GetParameterHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::ParameterHistory>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of parameters returned by the request.</p>
        pub fn parameters(mut self, input: crate::model::ParameterHistory) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>A list of parameters returned by the request.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterHistory>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParameterHistoryOutput`](crate::output::GetParameterHistoryOutput)
        pub fn build(self) -> crate::output::GetParameterHistoryOutput {
            crate::output::GetParameterHistoryOutput {
                parameters: self.parameters,
                next_token: self.next_token,
            }
        }
    }
}
impl GetParameterHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetParameterHistoryOutput`](crate::output::GetParameterHistoryOutput)
    pub fn builder() -> crate::output::get_parameter_history_output::Builder {
        crate::output::get_parameter_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetParameterOutput {
    /// <p>Information about a parameter.</p>
    pub parameter: std::option::Option<crate::model::Parameter>,
}
impl GetParameterOutput {
    /// <p>Information about a parameter.</p>
    pub fn parameter(&self) -> std::option::Option<&crate::model::Parameter> {
        self.parameter.as_ref()
    }
}
impl std::fmt::Debug for GetParameterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetParameterOutput");
        formatter.field("parameter", &self.parameter);
        formatter.finish()
    }
}
/// See [`GetParameterOutput`](crate::output::GetParameterOutput)
pub mod get_parameter_output {
    /// A builder for [`GetParameterOutput`](crate::output::GetParameterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter: std::option::Option<crate::model::Parameter>,
    }
    impl Builder {
        /// <p>Information about a parameter.</p>
        pub fn parameter(mut self, input: crate::model::Parameter) -> Self {
            self.parameter = Some(input);
            self
        }
        /// <p>Information about a parameter.</p>
        pub fn set_parameter(
            mut self,
            input: std::option::Option<crate::model::Parameter>,
        ) -> Self {
            self.parameter = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParameterOutput`](crate::output::GetParameterOutput)
        pub fn build(self) -> crate::output::GetParameterOutput {
            crate::output::GetParameterOutput {
                parameter: self.parameter,
            }
        }
    }
}
impl GetParameterOutput {
    /// Creates a new builder-style object to manufacture [`GetParameterOutput`](crate::output::GetParameterOutput)
    pub fn builder() -> crate::output::get_parameter_output::Builder {
        crate::output::get_parameter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpsSummaryOutput {
    /// <p>The list of aggregated details and filtered OpsData.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::OpsEntity>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetOpsSummaryOutput {
    /// <p>The list of aggregated details and filtered OpsData.</p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::OpsEntity]> {
        self.entities.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetOpsSummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpsSummaryOutput");
        formatter.field("entities", &self.entities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetOpsSummaryOutput`](crate::output::GetOpsSummaryOutput)
pub mod get_ops_summary_output {
    /// A builder for [`GetOpsSummaryOutput`](crate::output::GetOpsSummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::OpsEntity>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>The list of aggregated details and filtered OpsData.</p>
        pub fn entities(mut self, input: crate::model::OpsEntity) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input);
            self.entities = Some(v);
            self
        }
        /// <p>The list of aggregated details and filtered OpsData.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsEntity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpsSummaryOutput`](crate::output::GetOpsSummaryOutput)
        pub fn build(self) -> crate::output::GetOpsSummaryOutput {
            crate::output::GetOpsSummaryOutput {
                entities: self.entities,
                next_token: self.next_token,
            }
        }
    }
}
impl GetOpsSummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetOpsSummaryOutput`](crate::output::GetOpsSummaryOutput)
    pub fn builder() -> crate::output::get_ops_summary_output::Builder {
        crate::output::get_ops_summary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpsMetadataOutput {
    /// <p>The resource ID of the Application Manager application.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>OpsMetadata for an Application Manager application.</p>
    pub metadata: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
    >,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetOpsMetadataOutput {
    /// <p>The resource ID of the Application Manager application.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>OpsMetadata for an Application Manager application.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
    > {
        self.metadata.as_ref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetOpsMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpsMetadataOutput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("metadata", &self.metadata);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetOpsMetadataOutput`](crate::output::GetOpsMetadataOutput)
pub mod get_ops_metadata_output {
    /// A builder for [`GetOpsMetadataOutput`](crate::output::GetOpsMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ID of the Application Manager application.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the Application Manager application.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>OpsMetadata for an Application Manager application.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MetadataValue,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.metadata = Some(hash_map);
            self
        }
        /// <p>OpsMetadata for an Application Manager application.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpsMetadataOutput`](crate::output::GetOpsMetadataOutput)
        pub fn build(self) -> crate::output::GetOpsMetadataOutput {
            crate::output::GetOpsMetadataOutput {
                resource_id: self.resource_id,
                metadata: self.metadata,
                next_token: self.next_token,
            }
        }
    }
}
impl GetOpsMetadataOutput {
    /// Creates a new builder-style object to manufacture [`GetOpsMetadataOutput`](crate::output::GetOpsMetadataOutput)
    pub fn builder() -> crate::output::get_ops_metadata_output::Builder {
        crate::output::get_ops_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpsItemOutput {
    /// <p>The OpsItem.</p>
    pub ops_item: std::option::Option<crate::model::OpsItem>,
}
impl GetOpsItemOutput {
    /// <p>The OpsItem.</p>
    pub fn ops_item(&self) -> std::option::Option<&crate::model::OpsItem> {
        self.ops_item.as_ref()
    }
}
impl std::fmt::Debug for GetOpsItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpsItemOutput");
        formatter.field("ops_item", &self.ops_item);
        formatter.finish()
    }
}
/// See [`GetOpsItemOutput`](crate::output::GetOpsItemOutput)
pub mod get_ops_item_output {
    /// A builder for [`GetOpsItemOutput`](crate::output::GetOpsItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item: std::option::Option<crate::model::OpsItem>,
    }
    impl Builder {
        /// <p>The OpsItem.</p>
        pub fn ops_item(mut self, input: crate::model::OpsItem) -> Self {
            self.ops_item = Some(input);
            self
        }
        /// <p>The OpsItem.</p>
        pub fn set_ops_item(mut self, input: std::option::Option<crate::model::OpsItem>) -> Self {
            self.ops_item = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpsItemOutput`](crate::output::GetOpsItemOutput)
        pub fn build(self) -> crate::output::GetOpsItemOutput {
            crate::output::GetOpsItemOutput {
                ops_item: self.ops_item,
            }
        }
    }
}
impl GetOpsItemOutput {
    /// Creates a new builder-style object to manufacture [`GetOpsItemOutput`](crate::output::GetOpsItemOutput)
    pub fn builder() -> crate::output::get_ops_item_output::Builder {
        crate::output::get_ops_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMaintenanceWindowTaskOutput {
    /// <p>The retrieved maintenance window ID.</p>
    pub window_id: std::option::Option<std::string::String>,
    /// <p>The retrieved maintenance window task ID.</p>
    pub window_task_id: std::option::Option<std::string::String>,
    /// <p>The targets where the task should run.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The resource that the task used during execution. For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, the value of <code>TaskArn</code> is the SSM document name/ARN. For <code>LAMBDA</code> tasks, the value is the function name/ARN. For <code>STEP_FUNCTIONS</code> tasks, the value is the state machine ARN.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The type of task to run.</p>
    pub task_type: std::option::Option<crate::model::MaintenanceWindowTaskType>,
    /// <p>The parameters to pass to the task when it runs.</p> <note>
    /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub task_parameters: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::MaintenanceWindowTaskParameterValueExpression,
        >,
    >,
    /// <p>The parameters to pass to the task when it runs.</p>
    pub task_invocation_parameters:
        std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
    /// <p>The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>
    pub priority: i32,
    /// <p>The maximum number of targets allowed to run this task in parallel.</p> <note>
    /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
    /// </note>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The maximum number of errors allowed before the task stops being scheduled.</p> <note>
    /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
    /// </note>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>The location in Amazon Simple Storage Service (Amazon S3) where the task results are logged.</p> <note>
    /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub logging_info: std::option::Option<crate::model::LoggingInfo>,
    /// <p>The retrieved task name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The retrieved task description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The action to take on tasks when the maintenance window cutoff time is reached. <code>CONTINUE_TASK</code> means that tasks continue to run. For Automation, Lambda, Step Functions tasks, <code>CANCEL_TASK</code> means that currently running task invocations continue, but no new task invocations are started. For Run Command tasks, <code>CANCEL_TASK</code> means the system attempts to stop the task by sending a <code>CancelCommand</code> operation.</p>
    pub cutoff_behavior: std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
}
impl GetMaintenanceWindowTaskOutput {
    /// <p>The retrieved maintenance window ID.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
    /// <p>The retrieved maintenance window task ID.</p>
    pub fn window_task_id(&self) -> std::option::Option<&str> {
        self.window_task_id.as_deref()
    }
    /// <p>The targets where the task should run.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
    /// <p>The resource that the task used during execution. For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, the value of <code>TaskArn</code> is the SSM document name/ARN. For <code>LAMBDA</code> tasks, the value is the function name/ARN. For <code>STEP_FUNCTIONS</code> tasks, the value is the state machine ARN.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The type of task to run.</p>
    pub fn task_type(&self) -> std::option::Option<&crate::model::MaintenanceWindowTaskType> {
        self.task_type.as_ref()
    }
    /// <p>The parameters to pass to the task when it runs.</p> <note>
    /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub fn task_parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::MaintenanceWindowTaskParameterValueExpression,
        >,
    > {
        self.task_parameters.as_ref()
    }
    /// <p>The parameters to pass to the task when it runs.</p>
    pub fn task_invocation_parameters(
        &self,
    ) -> std::option::Option<&crate::model::MaintenanceWindowTaskInvocationParameters> {
        self.task_invocation_parameters.as_ref()
    }
    /// <p>The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>The maximum number of targets allowed to run this task in parallel.</p> <note>
    /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
    /// </note>
    pub fn max_concurrency(&self) -> std::option::Option<&str> {
        self.max_concurrency.as_deref()
    }
    /// <p>The maximum number of errors allowed before the task stops being scheduled.</p> <note>
    /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
    /// </note>
    pub fn max_errors(&self) -> std::option::Option<&str> {
        self.max_errors.as_deref()
    }
    /// <p>The location in Amazon Simple Storage Service (Amazon S3) where the task results are logged.</p> <note>
    /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    pub fn logging_info(&self) -> std::option::Option<&crate::model::LoggingInfo> {
        self.logging_info.as_ref()
    }
    /// <p>The retrieved task name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The retrieved task description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The action to take on tasks when the maintenance window cutoff time is reached. <code>CONTINUE_TASK</code> means that tasks continue to run. For Automation, Lambda, Step Functions tasks, <code>CANCEL_TASK</code> means that currently running task invocations continue, but no new task invocations are started. For Run Command tasks, <code>CANCEL_TASK</code> means the system attempts to stop the task by sending a <code>CancelCommand</code> operation.</p>
    pub fn cutoff_behavior(
        &self,
    ) -> std::option::Option<&crate::model::MaintenanceWindowTaskCutoffBehavior> {
        self.cutoff_behavior.as_ref()
    }
}
impl std::fmt::Debug for GetMaintenanceWindowTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMaintenanceWindowTaskOutput");
        formatter.field("window_id", &self.window_id);
        formatter.field("window_task_id", &self.window_task_id);
        formatter.field("targets", &self.targets);
        formatter.field("task_arn", &self.task_arn);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("task_type", &self.task_type);
        formatter.field("task_parameters", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "task_invocation_parameters",
            &self.task_invocation_parameters,
        );
        formatter.field("priority", &self.priority);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("logging_info", &self.logging_info);
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("cutoff_behavior", &self.cutoff_behavior);
        formatter.finish()
    }
}
/// See [`GetMaintenanceWindowTaskOutput`](crate::output::GetMaintenanceWindowTaskOutput)
pub mod get_maintenance_window_task_output {
    /// A builder for [`GetMaintenanceWindowTaskOutput`](crate::output::GetMaintenanceWindowTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_task_id: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) task_type: std::option::Option<crate::model::MaintenanceWindowTaskType>,
        pub(crate) task_parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::MaintenanceWindowTaskParameterValueExpression,
            >,
        >,
        pub(crate) task_invocation_parameters:
            std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) logging_info: std::option::Option<crate::model::LoggingInfo>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cutoff_behavior:
            std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
    }
    impl Builder {
        /// <p>The retrieved maintenance window ID.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The retrieved maintenance window ID.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The retrieved maintenance window task ID.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_task_id = Some(input.into());
            self
        }
        /// <p>The retrieved maintenance window task ID.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_task_id = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets where the task should run.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// <p>The targets where the task should run.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The resource that the task used during execution. For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, the value of <code>TaskArn</code> is the SSM document name/ARN. For <code>LAMBDA</code> tasks, the value is the function name/ARN. For <code>STEP_FUNCTIONS</code> tasks, the value is the state machine ARN.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The resource that the task used during execution. For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, the value of <code>TaskArn</code> is the SSM document name/ARN. For <code>LAMBDA</code> tasks, the value is the function name/ARN. For <code>STEP_FUNCTIONS</code> tasks, the value is the state machine ARN.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The type of task to run.</p>
        pub fn task_type(mut self, input: crate::model::MaintenanceWindowTaskType) -> Self {
            self.task_type = Some(input);
            self
        }
        /// <p>The type of task to run.</p>
        pub fn set_task_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskType>,
        ) -> Self {
            self.task_type = input;
            self
        }
        /// Adds a key-value pair to `task_parameters`.
        ///
        /// To override the contents of this collection use [`set_task_parameters`](Self::set_task_parameters).
        ///
        /// <p>The parameters to pass to the task when it runs.</p> <note>
        /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn task_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MaintenanceWindowTaskParameterValueExpression,
        ) -> Self {
            let mut hash_map = self.task_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.task_parameters = Some(hash_map);
            self
        }
        /// <p>The parameters to pass to the task when it runs.</p> <note>
        /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn set_task_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::MaintenanceWindowTaskParameterValueExpression,
                >,
            >,
        ) -> Self {
            self.task_parameters = input;
            self
        }
        /// <p>The parameters to pass to the task when it runs.</p>
        pub fn task_invocation_parameters(
            mut self,
            input: crate::model::MaintenanceWindowTaskInvocationParameters,
        ) -> Self {
            self.task_invocation_parameters = Some(input);
            self
        }
        /// <p>The parameters to pass to the task when it runs.</p>
        pub fn set_task_invocation_parameters(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
        ) -> Self {
            self.task_invocation_parameters = input;
            self
        }
        /// <p>The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The maximum number of targets allowed to run this task in parallel.</p> <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
        /// </note>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The maximum number of targets allowed to run this task in parallel.</p> <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
        /// </note>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The maximum number of errors allowed before the task stops being scheduled.</p> <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
        /// </note>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The maximum number of errors allowed before the task stops being scheduled.</p> <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>
        /// </note>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The location in Amazon Simple Storage Service (Amazon S3) where the task results are logged.</p> <note>
        /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn logging_info(mut self, input: crate::model::LoggingInfo) -> Self {
            self.logging_info = Some(input);
            self
        }
        /// <p>The location in Amazon Simple Storage Service (Amazon S3) where the task results are logged.</p> <note>
        /// <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        pub fn set_logging_info(
            mut self,
            input: std::option::Option<crate::model::LoggingInfo>,
        ) -> Self {
            self.logging_info = input;
            self
        }
        /// <p>The retrieved task name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The retrieved task name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The retrieved task description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The retrieved task description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The action to take on tasks when the maintenance window cutoff time is reached. <code>CONTINUE_TASK</code> means that tasks continue to run. For Automation, Lambda, Step Functions tasks, <code>CANCEL_TASK</code> means that currently running task invocations continue, but no new task invocations are started. For Run Command tasks, <code>CANCEL_TASK</code> means the system attempts to stop the task by sending a <code>CancelCommand</code> operation.</p>
        pub fn cutoff_behavior(
            mut self,
            input: crate::model::MaintenanceWindowTaskCutoffBehavior,
        ) -> Self {
            self.cutoff_behavior = Some(input);
            self
        }
        /// <p>The action to take on tasks when the maintenance window cutoff time is reached. <code>CONTINUE_TASK</code> means that tasks continue to run. For Automation, Lambda, Step Functions tasks, <code>CANCEL_TASK</code> means that currently running task invocations continue, but no new task invocations are started. For Run Command tasks, <code>CANCEL_TASK</code> means the system attempts to stop the task by sending a <code>CancelCommand</code> operation.</p>
        pub fn set_cutoff_behavior(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
        ) -> Self {
            self.cutoff_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowTaskOutput`](crate::output::GetMaintenanceWindowTaskOutput)
        pub fn build(self) -> crate::output::GetMaintenanceWindowTaskOutput {
            crate::output::GetMaintenanceWindowTaskOutput {
                window_id: self.window_id,
                window_task_id: self.window_task_id,
                targets: self.targets,
                task_arn: self.task_arn,
                service_role_arn: self.service_role_arn,
                task_type: self.task_type,
                task_parameters: self.task_parameters,
                task_invocation_parameters: self.task_invocation_parameters,
                priority: self.priority.unwrap_or_default(),
                max_concurrency: self.max_concurrency,
                max_errors: self.max_errors,
                logging_info: self.logging_info,
                name: self.name,
                description: self.description,
                cutoff_behavior: self.cutoff_behavior,
            }
        }
    }
}
impl GetMaintenanceWindowTaskOutput {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowTaskOutput`](crate::output::GetMaintenanceWindowTaskOutput)
    pub fn builder() -> crate::output::get_maintenance_window_task_output::Builder {
        crate::output::get_maintenance_window_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMaintenanceWindowExecutionTaskInvocationOutput {
    /// <p>The maintenance window execution ID.</p>
    pub window_execution_id: std::option::Option<std::string::String>,
    /// <p>The task execution ID.</p>
    pub task_execution_id: std::option::Option<std::string::String>,
    /// <p>The invocation ID.</p>
    pub invocation_id: std::option::Option<std::string::String>,
    /// <p>The execution ID.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>Retrieves the task type for a maintenance window.</p>
    pub task_type: std::option::Option<crate::model::MaintenanceWindowTaskType>,
    /// <p>The parameters used at the time that the task ran.</p>
    pub parameters: std::option::Option<std::string::String>,
    /// <p>The task status for an invocation.</p>
    pub status: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
    /// <p>The details explaining the status. Details are only available for certain status values.</p>
    pub status_details: std::option::Option<std::string::String>,
    /// <p>The time that the task started running on the target.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the task finished running on the target.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>User-provided value to be included in any Amazon CloudWatch Events or Amazon EventBridge events raised while running tasks for these targets in this maintenance window.</p>
    pub owner_information: std::option::Option<std::string::String>,
    /// <p>The maintenance window target ID.</p>
    pub window_target_id: std::option::Option<std::string::String>,
}
impl GetMaintenanceWindowExecutionTaskInvocationOutput {
    /// <p>The maintenance window execution ID.</p>
    pub fn window_execution_id(&self) -> std::option::Option<&str> {
        self.window_execution_id.as_deref()
    }
    /// <p>The task execution ID.</p>
    pub fn task_execution_id(&self) -> std::option::Option<&str> {
        self.task_execution_id.as_deref()
    }
    /// <p>The invocation ID.</p>
    pub fn invocation_id(&self) -> std::option::Option<&str> {
        self.invocation_id.as_deref()
    }
    /// <p>The execution ID.</p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p>Retrieves the task type for a maintenance window.</p>
    pub fn task_type(&self) -> std::option::Option<&crate::model::MaintenanceWindowTaskType> {
        self.task_type.as_ref()
    }
    /// <p>The parameters used at the time that the task ran.</p>
    pub fn parameters(&self) -> std::option::Option<&str> {
        self.parameters.as_deref()
    }
    /// <p>The task status for an invocation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MaintenanceWindowExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The details explaining the status. Details are only available for certain status values.</p>
    pub fn status_details(&self) -> std::option::Option<&str> {
        self.status_details.as_deref()
    }
    /// <p>The time that the task started running on the target.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time that the task finished running on the target.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>User-provided value to be included in any Amazon CloudWatch Events or Amazon EventBridge events raised while running tasks for these targets in this maintenance window.</p>
    pub fn owner_information(&self) -> std::option::Option<&str> {
        self.owner_information.as_deref()
    }
    /// <p>The maintenance window target ID.</p>
    pub fn window_target_id(&self) -> std::option::Option<&str> {
        self.window_target_id.as_deref()
    }
}
impl std::fmt::Debug for GetMaintenanceWindowExecutionTaskInvocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMaintenanceWindowExecutionTaskInvocationOutput");
        formatter.field("window_execution_id", &self.window_execution_id);
        formatter.field("task_execution_id", &self.task_execution_id);
        formatter.field("invocation_id", &self.invocation_id);
        formatter.field("execution_id", &self.execution_id);
        formatter.field("task_type", &self.task_type);
        formatter.field("parameters", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("owner_information", &"*** Sensitive Data Redacted ***");
        formatter.field("window_target_id", &self.window_target_id);
        formatter.finish()
    }
}
/// See [`GetMaintenanceWindowExecutionTaskInvocationOutput`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput)
pub mod get_maintenance_window_execution_task_invocation_output {
    /// A builder for [`GetMaintenanceWindowExecutionTaskInvocationOutput`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
        pub(crate) task_execution_id: std::option::Option<std::string::String>,
        pub(crate) invocation_id: std::option::Option<std::string::String>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) task_type: std::option::Option<crate::model::MaintenanceWindowTaskType>,
        pub(crate) parameters: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) owner_information: std::option::Option<std::string::String>,
        pub(crate) window_target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maintenance window execution ID.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The maintenance window execution ID.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// <p>The task execution ID.</p>
        pub fn task_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_execution_id = Some(input.into());
            self
        }
        /// <p>The task execution ID.</p>
        pub fn set_task_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_execution_id = input;
            self
        }
        /// <p>The invocation ID.</p>
        pub fn invocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_id = Some(input.into());
            self
        }
        /// <p>The invocation ID.</p>
        pub fn set_invocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_id = input;
            self
        }
        /// <p>The execution ID.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>The execution ID.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>Retrieves the task type for a maintenance window.</p>
        pub fn task_type(mut self, input: crate::model::MaintenanceWindowTaskType) -> Self {
            self.task_type = Some(input);
            self
        }
        /// <p>Retrieves the task type for a maintenance window.</p>
        pub fn set_task_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskType>,
        ) -> Self {
            self.task_type = input;
            self
        }
        /// <p>The parameters used at the time that the task ran.</p>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameters = Some(input.into());
            self
        }
        /// <p>The parameters used at the time that the task ran.</p>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The task status for an invocation.</p>
        pub fn status(mut self, input: crate::model::MaintenanceWindowExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The task status for an invocation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The details explaining the status. Details are only available for certain status values.</p>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>The details explaining the status. Details are only available for certain status values.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>The time that the task started running on the target.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time that the task started running on the target.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time that the task finished running on the target.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the task finished running on the target.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>User-provided value to be included in any Amazon CloudWatch Events or Amazon EventBridge events raised while running tasks for these targets in this maintenance window.</p>
        pub fn owner_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_information = Some(input.into());
            self
        }
        /// <p>User-provided value to be included in any Amazon CloudWatch Events or Amazon EventBridge events raised while running tasks for these targets in this maintenance window.</p>
        pub fn set_owner_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_information = input;
            self
        }
        /// <p>The maintenance window target ID.</p>
        pub fn window_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_target_id = Some(input.into());
            self
        }
        /// <p>The maintenance window target ID.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowExecutionTaskInvocationOutput`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput)
        pub fn build(self) -> crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput {
            crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput {
                window_execution_id: self.window_execution_id,
                task_execution_id: self.task_execution_id,
                invocation_id: self.invocation_id,
                execution_id: self.execution_id,
                task_type: self.task_type,
                parameters: self.parameters,
                status: self.status,
                status_details: self.status_details,
                start_time: self.start_time,
                end_time: self.end_time,
                owner_information: self.owner_information,
                window_target_id: self.window_target_id,
            }
        }
    }
}
impl GetMaintenanceWindowExecutionTaskInvocationOutput {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionTaskInvocationOutput`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput)
    pub fn builder(
    ) -> crate::output::get_maintenance_window_execution_task_invocation_output::Builder {
        crate::output::get_maintenance_window_execution_task_invocation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMaintenanceWindowExecutionTaskOutput {
    /// <p>The ID of the maintenance window execution that includes the task.</p>
    pub window_execution_id: std::option::Option<std::string::String>,
    /// <p>The ID of the specific task execution in the maintenance window task that was retrieved.</p>
    pub task_execution_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task that ran.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The role that was assumed when running the task.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>The type of task that was run.</p>
    pub r#type: std::option::Option<crate::model::MaintenanceWindowTaskType>,
    /// <p>The parameters passed to the task when it was run.</p> <note>
    /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    /// <p>The map has the following format:</p>
    /// <ul>
    /// <li> <p> <code>Key</code>: string, between 1 and 255 characters</p> </li>
    /// <li> <p> <code>Value</code>: an array of strings, each between 1 and 255 characters</p> </li>
    /// </ul>
    pub task_parameters: std::option::Option<
        std::vec::Vec<
            std::collections::HashMap<
                std::string::String,
                crate::model::MaintenanceWindowTaskParameterValueExpression,
            >,
        >,
    >,
    /// <p>The priority of the task.</p>
    pub priority: i32,
    /// <p>The defined maximum number of task executions that could be run in parallel.</p>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>The status of the task.</p>
    pub status: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
    /// <p>The details explaining the status. Not available for all status values.</p>
    pub status_details: std::option::Option<std::string::String>,
    /// <p>The time the task execution started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the task execution completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetMaintenanceWindowExecutionTaskOutput {
    /// <p>The ID of the maintenance window execution that includes the task.</p>
    pub fn window_execution_id(&self) -> std::option::Option<&str> {
        self.window_execution_id.as_deref()
    }
    /// <p>The ID of the specific task execution in the maintenance window task that was retrieved.</p>
    pub fn task_execution_id(&self) -> std::option::Option<&str> {
        self.task_execution_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the task that ran.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
    /// <p>The role that was assumed when running the task.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p>The type of task that was run.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MaintenanceWindowTaskType> {
        self.r#type.as_ref()
    }
    /// <p>The parameters passed to the task when it was run.</p> <note>
    /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
    /// </note>
    /// <p>The map has the following format:</p>
    /// <ul>
    /// <li> <p> <code>Key</code>: string, between 1 and 255 characters</p> </li>
    /// <li> <p> <code>Value</code>: an array of strings, each between 1 and 255 characters</p> </li>
    /// </ul>
    pub fn task_parameters(
        &self,
    ) -> std::option::Option<
        &[std::collections::HashMap<
            std::string::String,
            crate::model::MaintenanceWindowTaskParameterValueExpression,
        >],
    > {
        self.task_parameters.as_deref()
    }
    /// <p>The priority of the task.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>The defined maximum number of task executions that could be run in parallel.</p>
    pub fn max_concurrency(&self) -> std::option::Option<&str> {
        self.max_concurrency.as_deref()
    }
    /// <p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>
    pub fn max_errors(&self) -> std::option::Option<&str> {
        self.max_errors.as_deref()
    }
    /// <p>The status of the task.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MaintenanceWindowExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The details explaining the status. Not available for all status values.</p>
    pub fn status_details(&self) -> std::option::Option<&str> {
        self.status_details.as_deref()
    }
    /// <p>The time the task execution started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time the task execution completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for GetMaintenanceWindowExecutionTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMaintenanceWindowExecutionTaskOutput");
        formatter.field("window_execution_id", &self.window_execution_id);
        formatter.field("task_execution_id", &self.task_execution_id);
        formatter.field("task_arn", &self.task_arn);
        formatter.field("service_role", &self.service_role);
        formatter.field("r#type", &self.r#type);
        formatter.field("task_parameters", &"*** Sensitive Data Redacted ***");
        formatter.field("priority", &self.priority);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`GetMaintenanceWindowExecutionTaskOutput`](crate::output::GetMaintenanceWindowExecutionTaskOutput)
pub mod get_maintenance_window_execution_task_output {
    /// A builder for [`GetMaintenanceWindowExecutionTaskOutput`](crate::output::GetMaintenanceWindowExecutionTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
        pub(crate) task_execution_id: std::option::Option<std::string::String>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::MaintenanceWindowTaskType>,
        pub(crate) task_parameters: std::option::Option<
            std::vec::Vec<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::MaintenanceWindowTaskParameterValueExpression,
                >,
            >,
        >,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that was retrieved.</p>
        pub fn task_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that was retrieved.</p>
        pub fn set_task_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_execution_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that ran.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that ran.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The role that was assumed when running the task.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The role that was assumed when running the task.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>The type of task that was run.</p>
        pub fn r#type(mut self, input: crate::model::MaintenanceWindowTaskType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of task that was run.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `task_parameters`.
        ///
        /// To override the contents of this collection use [`set_task_parameters`](Self::set_task_parameters).
        ///
        /// <p>The parameters passed to the task when it was run.</p> <note>
        /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        /// <p>The map has the following format:</p>
        /// <ul>
        /// <li> <p> <code>Key</code>: string, between 1 and 255 characters</p> </li>
        /// <li> <p> <code>Value</code>: an array of strings, each between 1 and 255 characters</p> </li>
        /// </ul>
        pub fn task_parameters(
            mut self,
            input: std::collections::HashMap<
                std::string::String,
                crate::model::MaintenanceWindowTaskParameterValueExpression,
            >,
        ) -> Self {
            let mut v = self.task_parameters.unwrap_or_default();
            v.push(input);
            self.task_parameters = Some(v);
            self
        }
        /// <p>The parameters passed to the task when it was run.</p> <note>
        /// <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>
        /// </note>
        /// <p>The map has the following format:</p>
        /// <ul>
        /// <li> <p> <code>Key</code>: string, between 1 and 255 characters</p> </li>
        /// <li> <p> <code>Value</code>: an array of strings, each between 1 and 255 characters</p> </li>
        /// </ul>
        pub fn set_task_parameters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<
                        std::string::String,
                        crate::model::MaintenanceWindowTaskParameterValueExpression,
                    >,
                >,
            >,
        ) -> Self {
            self.task_parameters = input;
            self
        }
        /// <p>The priority of the task.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority of the task.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The defined maximum number of task executions that could be run in parallel.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The defined maximum number of task executions that could be run in parallel.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The status of the task.</p>
        pub fn status(mut self, input: crate::model::MaintenanceWindowExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the task.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The details explaining the status. Not available for all status values.</p>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>The details explaining the status. Not available for all status values.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>The time the task execution started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the task execution started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time the task execution completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time the task execution completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowExecutionTaskOutput`](crate::output::GetMaintenanceWindowExecutionTaskOutput)
        pub fn build(self) -> crate::output::GetMaintenanceWindowExecutionTaskOutput {
            crate::output::GetMaintenanceWindowExecutionTaskOutput {
                window_execution_id: self.window_execution_id,
                task_execution_id: self.task_execution_id,
                task_arn: self.task_arn,
                service_role: self.service_role,
                r#type: self.r#type,
                task_parameters: self.task_parameters,
                priority: self.priority.unwrap_or_default(),
                max_concurrency: self.max_concurrency,
                max_errors: self.max_errors,
                status: self.status,
                status_details: self.status_details,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl GetMaintenanceWindowExecutionTaskOutput {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionTaskOutput`](crate::output::GetMaintenanceWindowExecutionTaskOutput)
    pub fn builder() -> crate::output::get_maintenance_window_execution_task_output::Builder {
        crate::output::get_maintenance_window_execution_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMaintenanceWindowExecutionOutput {
    /// <p>The ID of the maintenance window execution.</p>
    pub window_execution_id: std::option::Option<std::string::String>,
    /// <p>The ID of the task executions from the maintenance window execution.</p>
    pub task_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the maintenance window execution.</p>
    pub status: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
    /// <p>The details explaining the status. Not available for all status values.</p>
    pub status_details: std::option::Option<std::string::String>,
    /// <p>The time the maintenance window started running.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the maintenance window finished running.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetMaintenanceWindowExecutionOutput {
    /// <p>The ID of the maintenance window execution.</p>
    pub fn window_execution_id(&self) -> std::option::Option<&str> {
        self.window_execution_id.as_deref()
    }
    /// <p>The ID of the task executions from the maintenance window execution.</p>
    pub fn task_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.task_ids.as_deref()
    }
    /// <p>The status of the maintenance window execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MaintenanceWindowExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>The details explaining the status. Not available for all status values.</p>
    pub fn status_details(&self) -> std::option::Option<&str> {
        self.status_details.as_deref()
    }
    /// <p>The time the maintenance window started running.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time the maintenance window finished running.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for GetMaintenanceWindowExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMaintenanceWindowExecutionOutput");
        formatter.field("window_execution_id", &self.window_execution_id);
        formatter.field("task_ids", &self.task_ids);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`GetMaintenanceWindowExecutionOutput`](crate::output::GetMaintenanceWindowExecutionOutput)
pub mod get_maintenance_window_execution_output {
    /// A builder for [`GetMaintenanceWindowExecutionOutput`](crate::output::GetMaintenanceWindowExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
        pub(crate) task_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// Appends an item to `task_ids`.
        ///
        /// To override the contents of this collection use [`set_task_ids`](Self::set_task_ids).
        ///
        /// <p>The ID of the task executions from the maintenance window execution.</p>
        pub fn task_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.task_ids.unwrap_or_default();
            v.push(input.into());
            self.task_ids = Some(v);
            self
        }
        /// <p>The ID of the task executions from the maintenance window execution.</p>
        pub fn set_task_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.task_ids = input;
            self
        }
        /// <p>The status of the maintenance window execution.</p>
        pub fn status(mut self, input: crate::model::MaintenanceWindowExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the maintenance window execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The details explaining the status. Not available for all status values.</p>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>The details explaining the status. Not available for all status values.</p>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>The time the maintenance window started running.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the maintenance window started running.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time the maintenance window finished running.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time the maintenance window finished running.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowExecutionOutput`](crate::output::GetMaintenanceWindowExecutionOutput)
        pub fn build(self) -> crate::output::GetMaintenanceWindowExecutionOutput {
            crate::output::GetMaintenanceWindowExecutionOutput {
                window_execution_id: self.window_execution_id,
                task_ids: self.task_ids,
                status: self.status,
                status_details: self.status_details,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl GetMaintenanceWindowExecutionOutput {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionOutput`](crate::output::GetMaintenanceWindowExecutionOutput)
    pub fn builder() -> crate::output::get_maintenance_window_execution_output::Builder {
        crate::output::get_maintenance_window_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMaintenanceWindowOutput {
    /// <p>The ID of the created maintenance window.</p>
    pub window_id: std::option::Option<std::string::String>,
    /// <p>The name of the maintenance window.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the maintenance window.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
    pub end_date: std::option::Option<std::string::String>,
    /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    pub schedule_timezone: std::option::Option<std::string::String>,
    /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
    pub schedule_offset: std::option::Option<i32>,
    /// <p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>
    pub next_execution_time: std::option::Option<std::string::String>,
    /// <p>The duration of the maintenance window in hours.</p>
    pub duration: i32,
    /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    pub cutoff: i32,
    /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
    pub allow_unassociated_targets: bool,
    /// <p>Indicates whether the maintenance window is enabled.</p>
    pub enabled: bool,
    /// <p>The date the maintenance window was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the maintenance window was last modified.</p>
    pub modified_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetMaintenanceWindowOutput {
    /// <p>The ID of the created maintenance window.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
    /// <p>The name of the maintenance window.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the maintenance window.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
    pub fn end_date(&self) -> std::option::Option<&str> {
        self.end_date.as_deref()
    }
    /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    pub fn schedule_timezone(&self) -> std::option::Option<&str> {
        self.schedule_timezone.as_deref()
    }
    /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
    pub fn schedule_offset(&self) -> std::option::Option<i32> {
        self.schedule_offset
    }
    /// <p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>
    pub fn next_execution_time(&self) -> std::option::Option<&str> {
        self.next_execution_time.as_deref()
    }
    /// <p>The duration of the maintenance window in hours.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    pub fn cutoff(&self) -> i32 {
        self.cutoff
    }
    /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
    pub fn allow_unassociated_targets(&self) -> bool {
        self.allow_unassociated_targets
    }
    /// <p>Indicates whether the maintenance window is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The date the maintenance window was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The date the maintenance window was last modified.</p>
    pub fn modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_date.as_ref()
    }
}
impl std::fmt::Debug for GetMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMaintenanceWindowOutput");
        formatter.field("window_id", &self.window_id);
        formatter.field("name", &self.name);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("schedule", &self.schedule);
        formatter.field("schedule_timezone", &self.schedule_timezone);
        formatter.field("schedule_offset", &self.schedule_offset);
        formatter.field("next_execution_time", &self.next_execution_time);
        formatter.field("duration", &self.duration);
        formatter.field("cutoff", &self.cutoff);
        formatter.field(
            "allow_unassociated_targets",
            &self.allow_unassociated_targets,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field("created_date", &self.created_date);
        formatter.field("modified_date", &self.modified_date);
        formatter.finish()
    }
}
/// See [`GetMaintenanceWindowOutput`](crate::output::GetMaintenanceWindowOutput)
pub mod get_maintenance_window_output {
    /// A builder for [`GetMaintenanceWindowOutput`](crate::output::GetMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) schedule_timezone: std::option::Option<std::string::String>,
        pub(crate) schedule_offset: std::option::Option<i32>,
        pub(crate) next_execution_time: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) cutoff: std::option::Option<i32>,
        pub(crate) allow_unassociated_targets: std::option::Option<bool>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) modified_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the created maintenance window.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the created maintenance window.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the maintenance window.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the maintenance window.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
        pub fn schedule_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_timezone = Some(input.into());
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
        pub fn set_schedule_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_timezone = input;
            self
        }
        /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
        pub fn schedule_offset(mut self, input: i32) -> Self {
            self.schedule_offset = Some(input);
            self
        }
        /// <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.schedule_offset = input;
            self
        }
        /// <p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>
        pub fn next_execution_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_execution_time = Some(input.into());
            self
        }
        /// <p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>
        pub fn set_next_execution_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_execution_time = input;
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
        pub fn cutoff(mut self, input: i32) -> Self {
            self.cutoff = Some(input);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
        pub fn set_cutoff(mut self, input: std::option::Option<i32>) -> Self {
            self.cutoff = input;
            self
        }
        /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
        pub fn allow_unassociated_targets(mut self, input: bool) -> Self {
            self.allow_unassociated_targets = Some(input);
            self
        }
        /// <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
        pub fn set_allow_unassociated_targets(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_unassociated_targets = input;
            self
        }
        /// <p>Indicates whether the maintenance window is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether the maintenance window is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The date the maintenance window was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the maintenance window was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The date the maintenance window was last modified.</p>
        pub fn modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_date = Some(input);
            self
        }
        /// <p>The date the maintenance window was last modified.</p>
        pub fn set_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowOutput`](crate::output::GetMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::GetMaintenanceWindowOutput {
            crate::output::GetMaintenanceWindowOutput {
                window_id: self.window_id,
                name: self.name,
                description: self.description,
                start_date: self.start_date,
                end_date: self.end_date,
                schedule: self.schedule,
                schedule_timezone: self.schedule_timezone,
                schedule_offset: self.schedule_offset,
                next_execution_time: self.next_execution_time,
                duration: self.duration.unwrap_or_default(),
                cutoff: self.cutoff.unwrap_or_default(),
                allow_unassociated_targets: self.allow_unassociated_targets.unwrap_or_default(),
                enabled: self.enabled.unwrap_or_default(),
                created_date: self.created_date,
                modified_date: self.modified_date,
            }
        }
    }
}
impl GetMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowOutput`](crate::output::GetMaintenanceWindowOutput)
    pub fn builder() -> crate::output::get_maintenance_window_output::Builder {
        crate::output::get_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInventorySchemaOutput {
    /// <p>Inventory schemas returned by the request.</p>
    pub schemas: std::option::Option<std::vec::Vec<crate::model::InventoryItemSchema>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetInventorySchemaOutput {
    /// <p>Inventory schemas returned by the request.</p>
    pub fn schemas(&self) -> std::option::Option<&[crate::model::InventoryItemSchema]> {
        self.schemas.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetInventorySchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInventorySchemaOutput");
        formatter.field("schemas", &self.schemas);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetInventorySchemaOutput`](crate::output::GetInventorySchemaOutput)
pub mod get_inventory_schema_output {
    /// A builder for [`GetInventorySchemaOutput`](crate::output::GetInventorySchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schemas: std::option::Option<std::vec::Vec<crate::model::InventoryItemSchema>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schemas`.
        ///
        /// To override the contents of this collection use [`set_schemas`](Self::set_schemas).
        ///
        /// <p>Inventory schemas returned by the request.</p>
        pub fn schemas(mut self, input: crate::model::InventoryItemSchema) -> Self {
            let mut v = self.schemas.unwrap_or_default();
            v.push(input);
            self.schemas = Some(v);
            self
        }
        /// <p>Inventory schemas returned by the request.</p>
        pub fn set_schemas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryItemSchema>>,
        ) -> Self {
            self.schemas = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInventorySchemaOutput`](crate::output::GetInventorySchemaOutput)
        pub fn build(self) -> crate::output::GetInventorySchemaOutput {
            crate::output::GetInventorySchemaOutput {
                schemas: self.schemas,
                next_token: self.next_token,
            }
        }
    }
}
impl GetInventorySchemaOutput {
    /// Creates a new builder-style object to manufacture [`GetInventorySchemaOutput`](crate::output::GetInventorySchemaOutput)
    pub fn builder() -> crate::output::get_inventory_schema_output::Builder {
        crate::output::get_inventory_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInventoryOutput {
    /// <p>Collection of inventory entities such as a collection of managed node inventory. </p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::InventoryResultEntity>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetInventoryOutput {
    /// <p>Collection of inventory entities such as a collection of managed node inventory. </p>
    pub fn entities(&self) -> std::option::Option<&[crate::model::InventoryResultEntity]> {
        self.entities.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetInventoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInventoryOutput");
        formatter.field("entities", &self.entities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetInventoryOutput`](crate::output::GetInventoryOutput)
pub mod get_inventory_output {
    /// A builder for [`GetInventoryOutput`](crate::output::GetInventoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entities:
            std::option::Option<std::vec::Vec<crate::model::InventoryResultEntity>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>Collection of inventory entities such as a collection of managed node inventory. </p>
        pub fn entities(mut self, input: crate::model::InventoryResultEntity) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input);
            self.entities = Some(v);
            self
        }
        /// <p>Collection of inventory entities such as a collection of managed node inventory. </p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryResultEntity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInventoryOutput`](crate::output::GetInventoryOutput)
        pub fn build(self) -> crate::output::GetInventoryOutput {
            crate::output::GetInventoryOutput {
                entities: self.entities,
                next_token: self.next_token,
            }
        }
    }
}
impl GetInventoryOutput {
    /// Creates a new builder-style object to manufacture [`GetInventoryOutput`](crate::output::GetInventoryOutput)
    pub fn builder() -> crate::output::get_inventory_output::Builder {
        crate::output::get_inventory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDocumentOutput {
    /// <p>The name of the SSM document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date the SSM document was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <code>UpdateDocument</code>.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
    pub version_name: std::option::Option<std::string::String>,
    /// <p>The document version.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>, <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.</p>
    pub status: std::option::Option<crate::model::DocumentStatus>,
    /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
    pub status_information: std::option::Option<std::string::String>,
    /// <p>The contents of the SSM document.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The document type.</p>
    pub document_type: std::option::Option<crate::model::DocumentType>,
    /// <p>The document format, either JSON or YAML.</p>
    pub document_format: std::option::Option<crate::model::DocumentFormat>,
    /// <p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>
    pub requires: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
    /// <p>A description of the document attachments, including names, locations, sizes, and so on.</p>
    pub attachments_content: std::option::Option<std::vec::Vec<crate::model::AttachmentContent>>,
    /// <p>The current review status of a new custom Systems Manager document (SSM document) created by a member of your organization, or of the latest version of an existing SSM document.</p>
    /// <p>Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.</p>
    /// <p>Only one version of an SSM document can be in review, or PENDING, at a time.</p>
    pub review_status: std::option::Option<crate::model::ReviewStatus>,
}
impl GetDocumentOutput {
    /// <p>The name of the SSM document.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The date the SSM document was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <code>UpdateDocument</code>.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
    pub fn version_name(&self) -> std::option::Option<&str> {
        self.version_name.as_deref()
    }
    /// <p>The document version.</p>
    pub fn document_version(&self) -> std::option::Option<&str> {
        self.document_version.as_deref()
    }
    /// <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>, <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DocumentStatus> {
        self.status.as_ref()
    }
    /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
    pub fn status_information(&self) -> std::option::Option<&str> {
        self.status_information.as_deref()
    }
    /// <p>The contents of the SSM document.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The document type.</p>
    pub fn document_type(&self) -> std::option::Option<&crate::model::DocumentType> {
        self.document_type.as_ref()
    }
    /// <p>The document format, either JSON or YAML.</p>
    pub fn document_format(&self) -> std::option::Option<&crate::model::DocumentFormat> {
        self.document_format.as_ref()
    }
    /// <p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>
    pub fn requires(&self) -> std::option::Option<&[crate::model::DocumentRequires]> {
        self.requires.as_deref()
    }
    /// <p>A description of the document attachments, including names, locations, sizes, and so on.</p>
    pub fn attachments_content(&self) -> std::option::Option<&[crate::model::AttachmentContent]> {
        self.attachments_content.as_deref()
    }
    /// <p>The current review status of a new custom Systems Manager document (SSM document) created by a member of your organization, or of the latest version of an existing SSM document.</p>
    /// <p>Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.</p>
    /// <p>Only one version of an SSM document can be in review, or PENDING, at a time.</p>
    pub fn review_status(&self) -> std::option::Option<&crate::model::ReviewStatus> {
        self.review_status.as_ref()
    }
}
impl std::fmt::Debug for GetDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDocumentOutput");
        formatter.field("name", &self.name);
        formatter.field("created_date", &self.created_date);
        formatter.field("display_name", &self.display_name);
        formatter.field("version_name", &self.version_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("status", &self.status);
        formatter.field("status_information", &self.status_information);
        formatter.field("content", &self.content);
        formatter.field("document_type", &self.document_type);
        formatter.field("document_format", &self.document_format);
        formatter.field("requires", &self.requires);
        formatter.field("attachments_content", &self.attachments_content);
        formatter.field("review_status", &self.review_status);
        formatter.finish()
    }
}
/// See [`GetDocumentOutput`](crate::output::GetDocumentOutput)
pub mod get_document_output {
    /// A builder for [`GetDocumentOutput`](crate::output::GetDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DocumentStatus>,
        pub(crate) status_information: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) document_type: std::option::Option<crate::model::DocumentType>,
        pub(crate) document_format: std::option::Option<crate::model::DocumentFormat>,
        pub(crate) requires: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        pub(crate) attachments_content:
            std::option::Option<std::vec::Vec<crate::model::AttachmentContent>>,
        pub(crate) review_status: std::option::Option<crate::model::ReviewStatus>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date the SSM document was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the SSM document was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <code>UpdateDocument</code>.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <code>UpdateDocument</code>.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>The document version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>, <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.</p>
        pub fn status(mut self, input: crate::model::DocumentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>, <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DocumentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
        pub fn status_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_information = Some(input.into());
            self
        }
        /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
        pub fn set_status_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_information = input;
            self
        }
        /// <p>The contents of the SSM document.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The contents of the SSM document.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The document type.</p>
        pub fn document_type(mut self, input: crate::model::DocumentType) -> Self {
            self.document_type = Some(input);
            self
        }
        /// <p>The document type.</p>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<crate::model::DocumentType>,
        ) -> Self {
            self.document_type = input;
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.document_format = Some(input);
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.document_format = input;
            self
        }
        /// Appends an item to `requires`.
        ///
        /// To override the contents of this collection use [`set_requires`](Self::set_requires).
        ///
        /// <p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>
        pub fn requires(mut self, input: crate::model::DocumentRequires) -> Self {
            let mut v = self.requires.unwrap_or_default();
            v.push(input);
            self.requires = Some(v);
            self
        }
        /// <p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>
        pub fn set_requires(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        ) -> Self {
            self.requires = input;
            self
        }
        /// Appends an item to `attachments_content`.
        ///
        /// To override the contents of this collection use [`set_attachments_content`](Self::set_attachments_content).
        ///
        /// <p>A description of the document attachments, including names, locations, sizes, and so on.</p>
        pub fn attachments_content(mut self, input: crate::model::AttachmentContent) -> Self {
            let mut v = self.attachments_content.unwrap_or_default();
            v.push(input);
            self.attachments_content = Some(v);
            self
        }
        /// <p>A description of the document attachments, including names, locations, sizes, and so on.</p>
        pub fn set_attachments_content(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentContent>>,
        ) -> Self {
            self.attachments_content = input;
            self
        }
        /// <p>The current review status of a new custom Systems Manager document (SSM document) created by a member of your organization, or of the latest version of an existing SSM document.</p>
        /// <p>Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.</p>
        /// <p>Only one version of an SSM document can be in review, or PENDING, at a time.</p>
        pub fn review_status(mut self, input: crate::model::ReviewStatus) -> Self {
            self.review_status = Some(input);
            self
        }
        /// <p>The current review status of a new custom Systems Manager document (SSM document) created by a member of your organization, or of the latest version of an existing SSM document.</p>
        /// <p>Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.</p>
        /// <p>Only one version of an SSM document can be in review, or PENDING, at a time.</p>
        pub fn set_review_status(
            mut self,
            input: std::option::Option<crate::model::ReviewStatus>,
        ) -> Self {
            self.review_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentOutput`](crate::output::GetDocumentOutput)
        pub fn build(self) -> crate::output::GetDocumentOutput {
            crate::output::GetDocumentOutput {
                name: self.name,
                created_date: self.created_date,
                display_name: self.display_name,
                version_name: self.version_name,
                document_version: self.document_version,
                status: self.status,
                status_information: self.status_information,
                content: self.content,
                document_type: self.document_type,
                document_format: self.document_format,
                requires: self.requires,
                attachments_content: self.attachments_content,
                review_status: self.review_status,
            }
        }
    }
}
impl GetDocumentOutput {
    /// Creates a new builder-style object to manufacture [`GetDocumentOutput`](crate::output::GetDocumentOutput)
    pub fn builder() -> crate::output::get_document_output::Builder {
        crate::output::get_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeployablePatchSnapshotForInstanceOutput {
    /// <p>The managed node ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The user-defined snapshot ID.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.</p>
    pub snapshot_download_url: std::option::Option<std::string::String>,
    /// <p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the managed node for the specified patch snapshot.</p>
    pub product: std::option::Option<std::string::String>,
}
impl GetDeployablePatchSnapshotForInstanceOutput {
    /// <p>The managed node ID.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The user-defined snapshot ID.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.</p>
    pub fn snapshot_download_url(&self) -> std::option::Option<&str> {
        self.snapshot_download_url.as_deref()
    }
    /// <p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the managed node for the specified patch snapshot.</p>
    pub fn product(&self) -> std::option::Option<&str> {
        self.product.as_deref()
    }
}
impl std::fmt::Debug for GetDeployablePatchSnapshotForInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeployablePatchSnapshotForInstanceOutput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("snapshot_download_url", &self.snapshot_download_url);
        formatter.field("product", &self.product);
        formatter.finish()
    }
}
/// See [`GetDeployablePatchSnapshotForInstanceOutput`](crate::output::GetDeployablePatchSnapshotForInstanceOutput)
pub mod get_deployable_patch_snapshot_for_instance_output {
    /// A builder for [`GetDeployablePatchSnapshotForInstanceOutput`](crate::output::GetDeployablePatchSnapshotForInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_download_url: std::option::Option<std::string::String>,
        pub(crate) product: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The managed node ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The user-defined snapshot ID.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The user-defined snapshot ID.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.</p>
        pub fn snapshot_download_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_download_url = Some(input.into());
            self
        }
        /// <p>A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.</p>
        pub fn set_snapshot_download_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_download_url = input;
            self
        }
        /// <p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the managed node for the specified patch snapshot.</p>
        pub fn product(mut self, input: impl Into<std::string::String>) -> Self {
            self.product = Some(input.into());
            self
        }
        /// <p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the managed node for the specified patch snapshot.</p>
        pub fn set_product(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeployablePatchSnapshotForInstanceOutput`](crate::output::GetDeployablePatchSnapshotForInstanceOutput)
        pub fn build(self) -> crate::output::GetDeployablePatchSnapshotForInstanceOutput {
            crate::output::GetDeployablePatchSnapshotForInstanceOutput {
                instance_id: self.instance_id,
                snapshot_id: self.snapshot_id,
                snapshot_download_url: self.snapshot_download_url,
                product: self.product,
            }
        }
    }
}
impl GetDeployablePatchSnapshotForInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetDeployablePatchSnapshotForInstanceOutput`](crate::output::GetDeployablePatchSnapshotForInstanceOutput)
    pub fn builder() -> crate::output::get_deployable_patch_snapshot_for_instance_output::Builder {
        crate::output::get_deployable_patch_snapshot_for_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDefaultPatchBaselineOutput {
    /// <p>The ID of the default patch baseline.</p>
    pub baseline_id: std::option::Option<std::string::String>,
    /// <p>The operating system for the returned patch baseline. </p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
}
impl GetDefaultPatchBaselineOutput {
    /// <p>The ID of the default patch baseline.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
    /// <p>The operating system for the returned patch baseline. </p>
    pub fn operating_system(&self) -> std::option::Option<&crate::model::OperatingSystem> {
        self.operating_system.as_ref()
    }
}
impl std::fmt::Debug for GetDefaultPatchBaselineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDefaultPatchBaselineOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.field("operating_system", &self.operating_system);
        formatter.finish()
    }
}
/// See [`GetDefaultPatchBaselineOutput`](crate::output::GetDefaultPatchBaselineOutput)
pub mod get_default_patch_baseline_output {
    /// A builder for [`GetDefaultPatchBaselineOutput`](crate::output::GetDefaultPatchBaselineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
    }
    impl Builder {
        /// <p>The ID of the default patch baseline.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the default patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The operating system for the returned patch baseline. </p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system for the returned patch baseline. </p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDefaultPatchBaselineOutput`](crate::output::GetDefaultPatchBaselineOutput)
        pub fn build(self) -> crate::output::GetDefaultPatchBaselineOutput {
            crate::output::GetDefaultPatchBaselineOutput {
                baseline_id: self.baseline_id,
                operating_system: self.operating_system,
            }
        }
    }
}
impl GetDefaultPatchBaselineOutput {
    /// Creates a new builder-style object to manufacture [`GetDefaultPatchBaselineOutput`](crate::output::GetDefaultPatchBaselineOutput)
    pub fn builder() -> crate::output::get_default_patch_baseline_output::Builder {
        crate::output::get_default_patch_baseline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectionStatusOutput {
    /// <p>The ID of the managed node to check connection status. </p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The status of the connection to the managed node. For example, 'Connected' or 'Not Connected'.</p>
    pub status: std::option::Option<crate::model::ConnectionStatus>,
}
impl GetConnectionStatusOutput {
    /// <p>The ID of the managed node to check connection status. </p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>The status of the connection to the managed node. For example, 'Connected' or 'Not Connected'.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ConnectionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetConnectionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectionStatusOutput");
        formatter.field("target", &self.target);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetConnectionStatusOutput`](crate::output::GetConnectionStatusOutput)
pub mod get_connection_status_output {
    /// A builder for [`GetConnectionStatusOutput`](crate::output::GetConnectionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ConnectionStatus>,
    }
    impl Builder {
        /// <p>The ID of the managed node to check connection status. </p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The ID of the managed node to check connection status. </p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The status of the connection to the managed node. For example, 'Connected' or 'Not Connected'.</p>
        pub fn status(mut self, input: crate::model::ConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the connection to the managed node. For example, 'Connected' or 'Not Connected'.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionStatusOutput`](crate::output::GetConnectionStatusOutput)
        pub fn build(self) -> crate::output::GetConnectionStatusOutput {
            crate::output::GetConnectionStatusOutput {
                target: self.target,
                status: self.status,
            }
        }
    }
}
impl GetConnectionStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectionStatusOutput`](crate::output::GetConnectionStatusOutput)
    pub fn builder() -> crate::output::get_connection_status_output::Builder {
        crate::output::get_connection_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommandInvocationOutput {
    /// <p>The parent command ID of the invocation plugin.</p>
    pub command_id: std::option::Option<std::string::String>,
    /// <p>The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The comment text for the command.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The name of the document that was run. For example, <code>AWS-RunShellScript</code>.</p>
    pub document_name: std::option::Option<std::string::String>,
    /// <p>The Systems Manager document (SSM document) version used in the request.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The name of the plugin, or <i>step name</i>, for which details are reported. For example, <code>aws:RunShellScript</code> is a plugin.</p>
    pub plugin_name: std::option::Option<std::string::String>,
    /// <p>The error level response code for the plugin script. If the response code is <code>-1</code>, then the command hasn't started running on the managed node, or it wasn't received by the node.</p>
    pub response_code: i32,
    /// <p>The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedBefore</code> filter.</p>
    /// <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p>
    /// <p>If the plugin hasn't started to run, the string is empty.</p>
    pub execution_start_date_time: std::option::Option<std::string::String>,
    /// <p>Duration since <code>ExecutionStartDateTime</code>.</p>
    pub execution_elapsed_time: std::option::Option<std::string::String>,
    /// <p>The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedAfter</code> filter.</p>
    /// <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p>
    /// <p>If the plugin hasn't started to run, the string is empty.</p>
    pub execution_end_date_time: std::option::Option<std::string::String>,
    /// <p>The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.</p>
    pub status: std::option::Option<crate::model::CommandInvocationStatus>,
    /// <p>A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more information than <code>Status</code> because it includes states resulting from error and concurrency control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code> can be one of the following values:</p>
    /// <ul>
    /// <li> <p>Pending: The command hasn't been sent to the managed node.</p> </li>
    /// <li> <p>In Progress: The command has been sent to the managed node but hasn't reached a terminal state.</p> </li>
    /// <li> <p>Delayed: The system attempted to send the command to the target, but the target wasn't available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.</p> </li>
    /// <li> <p>Success: The command or plugin ran successfully. This is a terminal state.</p> </li>
    /// <li> <p>Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
    /// <li> <p>Execution Timed Out: The command started to run on the managed node, but the execution wasn't complete before the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
    /// <li> <p>Failed: The command wasn't run successfully on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
    /// <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li>
    /// <li> <p>Undeliverable: The command can't be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code> limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
    /// <li> <p>Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li>
    /// </ul>
    pub status_details: std::option::Option<std::string::String>,
    /// <p>The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.</p>
    pub standard_output_content: std::option::Option<std::string::String>,
    /// <p>The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.</p>
    pub standard_output_url: std::option::Option<std::string::String>,
    /// <p>The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
    pub standard_error_content: std::option::Option<std::string::String>,
    /// <p>The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
    pub standard_error_url: std::option::Option<std::string::String>,
    /// <p>Amazon CloudWatch Logs information where Systems Manager sent the command output.</p>
    pub cloud_watch_output_config: std::option::Option<crate::model::CloudWatchOutputConfig>,
}
impl GetCommandInvocationOutput {
    /// <p>The parent command ID of the invocation plugin.</p>
    pub fn command_id(&self) -> std::option::Option<&str> {
        self.command_id.as_deref()
    }
    /// <p>The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The comment text for the command.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
    /// <p>The name of the document that was run. For example, <code>AWS-RunShellScript</code>.</p>
    pub fn document_name(&self) -> std::option::Option<&str> {
        self.document_name.as_deref()
    }
    /// <p>The Systems Manager document (SSM document) version used in the request.</p>
    pub fn document_version(&self) -> std::option::Option<&str> {
        self.document_version.as_deref()
    }
    /// <p>The name of the plugin, or <i>step name</i>, for which details are reported. For example, <code>aws:RunShellScript</code> is a plugin.</p>
    pub fn plugin_name(&self) -> std::option::Option<&str> {
        self.plugin_name.as_deref()
    }
    /// <p>The error level response code for the plugin script. If the response code is <code>-1</code>, then the command hasn't started running on the managed node, or it wasn't received by the node.</p>
    pub fn response_code(&self) -> i32 {
        self.response_code
    }
    /// <p>The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedBefore</code> filter.</p>
    /// <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p>
    /// <p>If the plugin hasn't started to run, the string is empty.</p>
    pub fn execution_start_date_time(&self) -> std::option::Option<&str> {
        self.execution_start_date_time.as_deref()
    }
    /// <p>Duration since <code>ExecutionStartDateTime</code>.</p>
    pub fn execution_elapsed_time(&self) -> std::option::Option<&str> {
        self.execution_elapsed_time.as_deref()
    }
    /// <p>The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedAfter</code> filter.</p>
    /// <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p>
    /// <p>If the plugin hasn't started to run, the string is empty.</p>
    pub fn execution_end_date_time(&self) -> std::option::Option<&str> {
        self.execution_end_date_time.as_deref()
    }
    /// <p>The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CommandInvocationStatus> {
        self.status.as_ref()
    }
    /// <p>A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more information than <code>Status</code> because it includes states resulting from error and concurrency control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code> can be one of the following values:</p>
    /// <ul>
    /// <li> <p>Pending: The command hasn't been sent to the managed node.</p> </li>
    /// <li> <p>In Progress: The command has been sent to the managed node but hasn't reached a terminal state.</p> </li>
    /// <li> <p>Delayed: The system attempted to send the command to the target, but the target wasn't available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.</p> </li>
    /// <li> <p>Success: The command or plugin ran successfully. This is a terminal state.</p> </li>
    /// <li> <p>Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
    /// <li> <p>Execution Timed Out: The command started to run on the managed node, but the execution wasn't complete before the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
    /// <li> <p>Failed: The command wasn't run successfully on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
    /// <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li>
    /// <li> <p>Undeliverable: The command can't be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code> limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
    /// <li> <p>Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li>
    /// </ul>
    pub fn status_details(&self) -> std::option::Option<&str> {
        self.status_details.as_deref()
    }
    /// <p>The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.</p>
    pub fn standard_output_content(&self) -> std::option::Option<&str> {
        self.standard_output_content.as_deref()
    }
    /// <p>The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.</p>
    pub fn standard_output_url(&self) -> std::option::Option<&str> {
        self.standard_output_url.as_deref()
    }
    /// <p>The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
    pub fn standard_error_content(&self) -> std::option::Option<&str> {
        self.standard_error_content.as_deref()
    }
    /// <p>The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
    pub fn standard_error_url(&self) -> std::option::Option<&str> {
        self.standard_error_url.as_deref()
    }
    /// <p>Amazon CloudWatch Logs information where Systems Manager sent the command output.</p>
    pub fn cloud_watch_output_config(
        &self,
    ) -> std::option::Option<&crate::model::CloudWatchOutputConfig> {
        self.cloud_watch_output_config.as_ref()
    }
}
impl std::fmt::Debug for GetCommandInvocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommandInvocationOutput");
        formatter.field("command_id", &self.command_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("comment", &self.comment);
        formatter.field("document_name", &self.document_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("plugin_name", &self.plugin_name);
        formatter.field("response_code", &self.response_code);
        formatter.field("execution_start_date_time", &self.execution_start_date_time);
        formatter.field("execution_elapsed_time", &self.execution_elapsed_time);
        formatter.field("execution_end_date_time", &self.execution_end_date_time);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("standard_output_content", &self.standard_output_content);
        formatter.field("standard_output_url", &self.standard_output_url);
        formatter.field("standard_error_content", &self.standard_error_content);
        formatter.field("standard_error_url", &self.standard_error_url);
        formatter.field("cloud_watch_output_config", &self.cloud_watch_output_config);
        formatter.finish()
    }
}
/// See [`GetCommandInvocationOutput`](crate::output::GetCommandInvocationOutput)
pub mod get_command_invocation_output {
    /// A builder for [`GetCommandInvocationOutput`](crate::output::GetCommandInvocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) document_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) plugin_name: std::option::Option<std::string::String>,
        pub(crate) response_code: std::option::Option<i32>,
        pub(crate) execution_start_date_time: std::option::Option<std::string::String>,
        pub(crate) execution_elapsed_time: std::option::Option<std::string::String>,
        pub(crate) execution_end_date_time: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CommandInvocationStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) standard_output_content: std::option::Option<std::string::String>,
        pub(crate) standard_output_url: std::option::Option<std::string::String>,
        pub(crate) standard_error_content: std::option::Option<std::string::String>,
        pub(crate) standard_error_url: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_output_config:
            std::option::Option<crate::model::CloudWatchOutputConfig>,
    }
    impl Builder {
        /// <p>The parent command ID of the invocation plugin.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>The parent command ID of the invocation plugin.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// <p>The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The comment text for the command.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>The comment text for the command.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The name of the document that was run. For example, <code>AWS-RunShellScript</code>.</p>
        pub fn document_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_name = Some(input.into());
            self
        }
        /// <p>The name of the document that was run. For example, <code>AWS-RunShellScript</code>.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_name = input;
            self
        }
        /// <p>The Systems Manager document (SSM document) version used in the request.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The Systems Manager document (SSM document) version used in the request.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The name of the plugin, or <i>step name</i>, for which details are reported. For example, <code>aws:RunShellScript</code> is a plugin.</p>
        pub fn plugin_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.plugin_name = Some(input.into());
            self
        }
        /// <p>The name of the plugin, or <i>step name</i>, for which details are reported. For example, <code>aws:RunShellScript</code> is a plugin.</p>
        pub fn set_plugin_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plugin_name = input;
            self
        }
        /// <p>The error level response code for the plugin script. If the response code is <code>-1</code>, then the command hasn't started running on the managed node, or it wasn't received by the node.</p>
        pub fn response_code(mut self, input: i32) -> Self {
            self.response_code = Some(input);
            self
        }
        /// <p>The error level response code for the plugin script. If the response code is <code>-1</code>, then the command hasn't started running on the managed node, or it wasn't received by the node.</p>
        pub fn set_response_code(mut self, input: std::option::Option<i32>) -> Self {
            self.response_code = input;
            self
        }
        /// <p>The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedBefore</code> filter.</p>
        /// <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p>
        /// <p>If the plugin hasn't started to run, the string is empty.</p>
        pub fn execution_start_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_start_date_time = Some(input.into());
            self
        }
        /// <p>The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedBefore</code> filter.</p>
        /// <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p>
        /// <p>If the plugin hasn't started to run, the string is empty.</p>
        pub fn set_execution_start_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_start_date_time = input;
            self
        }
        /// <p>Duration since <code>ExecutionStartDateTime</code>.</p>
        pub fn execution_elapsed_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_elapsed_time = Some(input.into());
            self
        }
        /// <p>Duration since <code>ExecutionStartDateTime</code>.</p>
        pub fn set_execution_elapsed_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_elapsed_time = input;
            self
        }
        /// <p>The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedAfter</code> filter.</p>
        /// <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p>
        /// <p>If the plugin hasn't started to run, the string is empty.</p>
        pub fn execution_end_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_end_date_time = Some(input.into());
            self
        }
        /// <p>The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedAfter</code> filter.</p>
        /// <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p>
        /// <p>If the plugin hasn't started to run, the string is empty.</p>
        pub fn set_execution_end_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_end_date_time = input;
            self
        }
        /// <p>The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.</p>
        pub fn status(mut self, input: crate::model::CommandInvocationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CommandInvocationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more information than <code>Status</code> because it includes states resulting from error and concurrency control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p>Pending: The command hasn't been sent to the managed node.</p> </li>
        /// <li> <p>In Progress: The command has been sent to the managed node but hasn't reached a terminal state.</p> </li>
        /// <li> <p>Delayed: The system attempted to send the command to the target, but the target wasn't available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.</p> </li>
        /// <li> <p>Success: The command or plugin ran successfully. This is a terminal state.</p> </li>
        /// <li> <p>Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
        /// <li> <p>Execution Timed Out: The command started to run on the managed node, but the execution wasn't complete before the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
        /// <li> <p>Failed: The command wasn't run successfully on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
        /// <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li>
        /// <li> <p>Undeliverable: The command can't be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code> limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
        /// <li> <p>Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li>
        /// </ul>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more information than <code>Status</code> because it includes states resulting from error and concurrency control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code> can be one of the following values:</p>
        /// <ul>
        /// <li> <p>Pending: The command hasn't been sent to the managed node.</p> </li>
        /// <li> <p>In Progress: The command has been sent to the managed node but hasn't reached a terminal state.</p> </li>
        /// <li> <p>Delayed: The system attempted to send the command to the target, but the target wasn't available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.</p> </li>
        /// <li> <p>Success: The command or plugin ran successfully. This is a terminal state.</p> </li>
        /// <li> <p>Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
        /// <li> <p>Execution Timed Out: The command started to run on the managed node, but the execution wasn't complete before the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
        /// <li> <p>Failed: The command wasn't run successfully on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>
        /// <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li>
        /// <li> <p>Undeliverable: The command can't be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code> limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>
        /// <li> <p>Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li>
        /// </ul>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.</p>
        pub fn standard_output_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_output_content = Some(input.into());
            self
        }
        /// <p>The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.</p>
        pub fn set_standard_output_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_output_content = input;
            self
        }
        /// <p>The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.</p>
        pub fn standard_output_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_output_url = Some(input.into());
            self
        }
        /// <p>The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.</p>
        pub fn set_standard_output_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_output_url = input;
            self
        }
        /// <p>The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
        pub fn standard_error_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_error_content = Some(input.into());
            self
        }
        /// <p>The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
        pub fn set_standard_error_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_error_content = input;
            self
        }
        /// <p>The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
        pub fn standard_error_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_error_url = Some(input.into());
            self
        }
        /// <p>The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
        pub fn set_standard_error_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_error_url = input;
            self
        }
        /// <p>Amazon CloudWatch Logs information where Systems Manager sent the command output.</p>
        pub fn cloud_watch_output_config(
            mut self,
            input: crate::model::CloudWatchOutputConfig,
        ) -> Self {
            self.cloud_watch_output_config = Some(input);
            self
        }
        /// <p>Amazon CloudWatch Logs information where Systems Manager sent the command output.</p>
        pub fn set_cloud_watch_output_config(
            mut self,
            input: std::option::Option<crate::model::CloudWatchOutputConfig>,
        ) -> Self {
            self.cloud_watch_output_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommandInvocationOutput`](crate::output::GetCommandInvocationOutput)
        pub fn build(self) -> crate::output::GetCommandInvocationOutput {
            crate::output::GetCommandInvocationOutput {
                command_id: self.command_id,
                instance_id: self.instance_id,
                comment: self.comment,
                document_name: self.document_name,
                document_version: self.document_version,
                plugin_name: self.plugin_name,
                response_code: self.response_code.unwrap_or_default(),
                execution_start_date_time: self.execution_start_date_time,
                execution_elapsed_time: self.execution_elapsed_time,
                execution_end_date_time: self.execution_end_date_time,
                status: self.status,
                status_details: self.status_details,
                standard_output_content: self.standard_output_content,
                standard_output_url: self.standard_output_url,
                standard_error_content: self.standard_error_content,
                standard_error_url: self.standard_error_url,
                cloud_watch_output_config: self.cloud_watch_output_config,
            }
        }
    }
}
impl GetCommandInvocationOutput {
    /// Creates a new builder-style object to manufacture [`GetCommandInvocationOutput`](crate::output::GetCommandInvocationOutput)
    pub fn builder() -> crate::output::get_command_invocation_output::Builder {
        crate::output::get_command_invocation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCalendarStateOutput {
    /// <p>The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates that actions aren't allowed to proceed.</p>
    pub state: std::option::Option<crate::model::CalendarState>,
    /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your command. If you don't specify a time, <code>GetCalendarState</code> uses the current time.</p>
    pub at_time: std::option::Option<std::string::String>,
    /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.</p>
    pub next_transition_time: std::option::Option<std::string::String>,
}
impl GetCalendarStateOutput {
    /// <p>The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates that actions aren't allowed to proceed.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::CalendarState> {
        self.state.as_ref()
    }
    /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your command. If you don't specify a time, <code>GetCalendarState</code> uses the current time.</p>
    pub fn at_time(&self) -> std::option::Option<&str> {
        self.at_time.as_deref()
    }
    /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.</p>
    pub fn next_transition_time(&self) -> std::option::Option<&str> {
        self.next_transition_time.as_deref()
    }
}
impl std::fmt::Debug for GetCalendarStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCalendarStateOutput");
        formatter.field("state", &self.state);
        formatter.field("at_time", &self.at_time);
        formatter.field("next_transition_time", &self.next_transition_time);
        formatter.finish()
    }
}
/// See [`GetCalendarStateOutput`](crate::output::GetCalendarStateOutput)
pub mod get_calendar_state_output {
    /// A builder for [`GetCalendarStateOutput`](crate::output::GetCalendarStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::CalendarState>,
        pub(crate) at_time: std::option::Option<std::string::String>,
        pub(crate) next_transition_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates that actions aren't allowed to proceed.</p>
        pub fn state(mut self, input: crate::model::CalendarState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates that actions aren't allowed to proceed.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::CalendarState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your command. If you don't specify a time, <code>GetCalendarState</code> uses the current time.</p>
        pub fn at_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.at_time = Some(input.into());
            self
        }
        /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your command. If you don't specify a time, <code>GetCalendarState</code> uses the current time.</p>
        pub fn set_at_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.at_time = input;
            self
        }
        /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.</p>
        pub fn next_transition_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_transition_time = Some(input.into());
            self
        }
        /// <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.</p>
        pub fn set_next_transition_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_transition_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCalendarStateOutput`](crate::output::GetCalendarStateOutput)
        pub fn build(self) -> crate::output::GetCalendarStateOutput {
            crate::output::GetCalendarStateOutput {
                state: self.state,
                at_time: self.at_time,
                next_transition_time: self.next_transition_time,
            }
        }
    }
}
impl GetCalendarStateOutput {
    /// Creates a new builder-style object to manufacture [`GetCalendarStateOutput`](crate::output::GetCalendarStateOutput)
    pub fn builder() -> crate::output::get_calendar_state_output::Builder {
        crate::output::get_calendar_state_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAutomationExecutionOutput {
    /// <p>Detailed information about the current state of an automation execution.</p>
    pub automation_execution: std::option::Option<crate::model::AutomationExecution>,
}
impl GetAutomationExecutionOutput {
    /// <p>Detailed information about the current state of an automation execution.</p>
    pub fn automation_execution(&self) -> std::option::Option<&crate::model::AutomationExecution> {
        self.automation_execution.as_ref()
    }
}
impl std::fmt::Debug for GetAutomationExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAutomationExecutionOutput");
        formatter.field("automation_execution", &self.automation_execution);
        formatter.finish()
    }
}
/// See [`GetAutomationExecutionOutput`](crate::output::GetAutomationExecutionOutput)
pub mod get_automation_execution_output {
    /// A builder for [`GetAutomationExecutionOutput`](crate::output::GetAutomationExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automation_execution: std::option::Option<crate::model::AutomationExecution>,
    }
    impl Builder {
        /// <p>Detailed information about the current state of an automation execution.</p>
        pub fn automation_execution(mut self, input: crate::model::AutomationExecution) -> Self {
            self.automation_execution = Some(input);
            self
        }
        /// <p>Detailed information about the current state of an automation execution.</p>
        pub fn set_automation_execution(
            mut self,
            input: std::option::Option<crate::model::AutomationExecution>,
        ) -> Self {
            self.automation_execution = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAutomationExecutionOutput`](crate::output::GetAutomationExecutionOutput)
        pub fn build(self) -> crate::output::GetAutomationExecutionOutput {
            crate::output::GetAutomationExecutionOutput {
                automation_execution: self.automation_execution,
            }
        }
    }
}
impl GetAutomationExecutionOutput {
    /// Creates a new builder-style object to manufacture [`GetAutomationExecutionOutput`](crate::output::GetAutomationExecutionOutput)
    pub fn builder() -> crate::output::get_automation_execution_output::Builder {
        crate::output::get_automation_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateOpsItemRelatedItemOutput {}
impl std::fmt::Debug for DisassociateOpsItemRelatedItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateOpsItemRelatedItemOutput");
        formatter.finish()
    }
}
/// See [`DisassociateOpsItemRelatedItemOutput`](crate::output::DisassociateOpsItemRelatedItemOutput)
pub mod disassociate_ops_item_related_item_output {
    /// A builder for [`DisassociateOpsItemRelatedItemOutput`](crate::output::DisassociateOpsItemRelatedItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateOpsItemRelatedItemOutput`](crate::output::DisassociateOpsItemRelatedItemOutput)
        pub fn build(self) -> crate::output::DisassociateOpsItemRelatedItemOutput {
            crate::output::DisassociateOpsItemRelatedItemOutput {}
        }
    }
}
impl DisassociateOpsItemRelatedItemOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateOpsItemRelatedItemOutput`](crate::output::DisassociateOpsItemRelatedItemOutput)
    pub fn builder() -> crate::output::disassociate_ops_item_related_item_output::Builder {
        crate::output::disassociate_ops_item_related_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSessionsOutput {
    /// <p>A list of sessions meeting the request parameters.</p>
    pub sessions: std::option::Option<std::vec::Vec<crate::model::Session>>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSessionsOutput {
    /// <p>A list of sessions meeting the request parameters.</p>
    pub fn sessions(&self) -> std::option::Option<&[crate::model::Session]> {
        self.sessions.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSessionsOutput");
        formatter.field("sessions", &self.sessions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
pub mod describe_sessions_output {
    /// A builder for [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sessions: std::option::Option<std::vec::Vec<crate::model::Session>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sessions`.
        ///
        /// To override the contents of this collection use [`set_sessions`](Self::set_sessions).
        ///
        /// <p>A list of sessions meeting the request parameters.</p>
        pub fn sessions(mut self, input: crate::model::Session) -> Self {
            let mut v = self.sessions.unwrap_or_default();
            v.push(input);
            self.sessions = Some(v);
            self
        }
        /// <p>A list of sessions meeting the request parameters.</p>
        pub fn set_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Session>>,
        ) -> Self {
            self.sessions = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
        pub fn build(self) -> crate::output::DescribeSessionsOutput {
            crate::output::DescribeSessionsOutput {
                sessions: self.sessions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSessionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
    pub fn builder() -> crate::output::describe_sessions_output::Builder {
        crate::output::describe_sessions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePatchPropertiesOutput {
    /// <p>A list of the properties for patches matching the filter request parameters.</p>
    pub properties: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
    /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePatchPropertiesOutput {
    /// <p>A list of the properties for patches matching the filter request parameters.</p>
    pub fn properties(
        &self,
    ) -> std::option::Option<&[std::collections::HashMap<std::string::String, std::string::String>]>
    {
        self.properties.as_deref()
    }
    /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePatchPropertiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePatchPropertiesOutput");
        formatter.field("properties", &self.properties);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePatchPropertiesOutput`](crate::output::DescribePatchPropertiesOutput)
pub mod describe_patch_properties_output {
    /// A builder for [`DescribePatchPropertiesOutput`](crate::output::DescribePatchPropertiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) properties: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of the properties for patches matching the filter request parameters.</p>
        pub fn properties(
            mut self,
            input: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input);
            self.properties = Some(v);
            self
        }
        /// <p>A list of the properties for patches matching the filter request parameters.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchPropertiesOutput`](crate::output::DescribePatchPropertiesOutput)
        pub fn build(self) -> crate::output::DescribePatchPropertiesOutput {
            crate::output::DescribePatchPropertiesOutput {
                properties: self.properties,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePatchPropertiesOutput {
    /// Creates a new builder-style object to manufacture [`DescribePatchPropertiesOutput`](crate::output::DescribePatchPropertiesOutput)
    pub fn builder() -> crate::output::describe_patch_properties_output::Builder {
        crate::output::describe_patch_properties_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePatchGroupStateOutput {
    /// <p>The number of managed nodes in the patch group.</p>
    pub instances: i32,
    /// <p>The number of managed nodes with installed patches.</p>
    pub instances_with_installed_patches: i32,
    /// <p>The number of managed nodes with patches installed that aren't defined in the patch baseline.</p>
    pub instances_with_installed_other_patches: i32,
    /// <p>The number of managed nodes with patches installed by Patch Manager that haven't been rebooted after the patch installation. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub instances_with_installed_pending_reboot_patches: std::option::Option<i32>,
    /// <p>The number of managed nodes with patches installed that are specified in a <code>RejectedPatches</code> list. Patches with a status of <code>INSTALLED_REJECTED</code> were typically installed before they were added to a <code>RejectedPatches</code> list.</p> <note>
    /// <p>If <code>ALLOW_AS_DEPENDENCY</code> is the specified option for <code>RejectedPatchesAction</code>, the value of <code>InstancesWithInstalledRejectedPatches</code> will always be <code>0</code> (zero).</p>
    /// </note>
    pub instances_with_installed_rejected_patches: std::option::Option<i32>,
    /// <p>The number of managed nodes with missing patches from the patch baseline.</p>
    pub instances_with_missing_patches: i32,
    /// <p>The number of managed nodes with patches from the patch baseline that failed to install.</p>
    pub instances_with_failed_patches: i32,
    /// <p>The number of managed nodes with patches that aren't applicable.</p>
    pub instances_with_not_applicable_patches: i32,
    /// <p>The number of managed nodes with <code>NotApplicable</code> patches beyond the supported limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.</p>
    pub instances_with_unreported_not_applicable_patches: std::option::Option<i32>,
    /// <p>The number of managed nodes where patches that are specified as <code>Critical</code> for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub instances_with_critical_non_compliant_patches: std::option::Option<i32>,
    /// <p>The number of managed nodes where patches that are specified as <code>Security</code> in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub instances_with_security_non_compliant_patches: std::option::Option<i32>,
    /// <p>The number of managed nodes with patches installed that are specified as other than <code>Critical</code> or <code>Security</code> but aren't compliant with the patch baseline. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub instances_with_other_non_compliant_patches: std::option::Option<i32>,
}
impl DescribePatchGroupStateOutput {
    /// <p>The number of managed nodes in the patch group.</p>
    pub fn instances(&self) -> i32 {
        self.instances
    }
    /// <p>The number of managed nodes with installed patches.</p>
    pub fn instances_with_installed_patches(&self) -> i32 {
        self.instances_with_installed_patches
    }
    /// <p>The number of managed nodes with patches installed that aren't defined in the patch baseline.</p>
    pub fn instances_with_installed_other_patches(&self) -> i32 {
        self.instances_with_installed_other_patches
    }
    /// <p>The number of managed nodes with patches installed by Patch Manager that haven't been rebooted after the patch installation. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub fn instances_with_installed_pending_reboot_patches(&self) -> std::option::Option<i32> {
        self.instances_with_installed_pending_reboot_patches
    }
    /// <p>The number of managed nodes with patches installed that are specified in a <code>RejectedPatches</code> list. Patches with a status of <code>INSTALLED_REJECTED</code> were typically installed before they were added to a <code>RejectedPatches</code> list.</p> <note>
    /// <p>If <code>ALLOW_AS_DEPENDENCY</code> is the specified option for <code>RejectedPatchesAction</code>, the value of <code>InstancesWithInstalledRejectedPatches</code> will always be <code>0</code> (zero).</p>
    /// </note>
    pub fn instances_with_installed_rejected_patches(&self) -> std::option::Option<i32> {
        self.instances_with_installed_rejected_patches
    }
    /// <p>The number of managed nodes with missing patches from the patch baseline.</p>
    pub fn instances_with_missing_patches(&self) -> i32 {
        self.instances_with_missing_patches
    }
    /// <p>The number of managed nodes with patches from the patch baseline that failed to install.</p>
    pub fn instances_with_failed_patches(&self) -> i32 {
        self.instances_with_failed_patches
    }
    /// <p>The number of managed nodes with patches that aren't applicable.</p>
    pub fn instances_with_not_applicable_patches(&self) -> i32 {
        self.instances_with_not_applicable_patches
    }
    /// <p>The number of managed nodes with <code>NotApplicable</code> patches beyond the supported limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.</p>
    pub fn instances_with_unreported_not_applicable_patches(&self) -> std::option::Option<i32> {
        self.instances_with_unreported_not_applicable_patches
    }
    /// <p>The number of managed nodes where patches that are specified as <code>Critical</code> for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub fn instances_with_critical_non_compliant_patches(&self) -> std::option::Option<i32> {
        self.instances_with_critical_non_compliant_patches
    }
    /// <p>The number of managed nodes where patches that are specified as <code>Security</code> in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub fn instances_with_security_non_compliant_patches(&self) -> std::option::Option<i32> {
        self.instances_with_security_non_compliant_patches
    }
    /// <p>The number of managed nodes with patches installed that are specified as other than <code>Critical</code> or <code>Security</code> but aren't compliant with the patch baseline. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    pub fn instances_with_other_non_compliant_patches(&self) -> std::option::Option<i32> {
        self.instances_with_other_non_compliant_patches
    }
}
impl std::fmt::Debug for DescribePatchGroupStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePatchGroupStateOutput");
        formatter.field("instances", &self.instances);
        formatter.field(
            "instances_with_installed_patches",
            &self.instances_with_installed_patches,
        );
        formatter.field(
            "instances_with_installed_other_patches",
            &self.instances_with_installed_other_patches,
        );
        formatter.field(
            "instances_with_installed_pending_reboot_patches",
            &self.instances_with_installed_pending_reboot_patches,
        );
        formatter.field(
            "instances_with_installed_rejected_patches",
            &self.instances_with_installed_rejected_patches,
        );
        formatter.field(
            "instances_with_missing_patches",
            &self.instances_with_missing_patches,
        );
        formatter.field(
            "instances_with_failed_patches",
            &self.instances_with_failed_patches,
        );
        formatter.field(
            "instances_with_not_applicable_patches",
            &self.instances_with_not_applicable_patches,
        );
        formatter.field(
            "instances_with_unreported_not_applicable_patches",
            &self.instances_with_unreported_not_applicable_patches,
        );
        formatter.field(
            "instances_with_critical_non_compliant_patches",
            &self.instances_with_critical_non_compliant_patches,
        );
        formatter.field(
            "instances_with_security_non_compliant_patches",
            &self.instances_with_security_non_compliant_patches,
        );
        formatter.field(
            "instances_with_other_non_compliant_patches",
            &self.instances_with_other_non_compliant_patches,
        );
        formatter.finish()
    }
}
/// See [`DescribePatchGroupStateOutput`](crate::output::DescribePatchGroupStateOutput)
pub mod describe_patch_group_state_output {
    /// A builder for [`DescribePatchGroupStateOutput`](crate::output::DescribePatchGroupStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances: std::option::Option<i32>,
        pub(crate) instances_with_installed_patches: std::option::Option<i32>,
        pub(crate) instances_with_installed_other_patches: std::option::Option<i32>,
        pub(crate) instances_with_installed_pending_reboot_patches: std::option::Option<i32>,
        pub(crate) instances_with_installed_rejected_patches: std::option::Option<i32>,
        pub(crate) instances_with_missing_patches: std::option::Option<i32>,
        pub(crate) instances_with_failed_patches: std::option::Option<i32>,
        pub(crate) instances_with_not_applicable_patches: std::option::Option<i32>,
        pub(crate) instances_with_unreported_not_applicable_patches: std::option::Option<i32>,
        pub(crate) instances_with_critical_non_compliant_patches: std::option::Option<i32>,
        pub(crate) instances_with_security_non_compliant_patches: std::option::Option<i32>,
        pub(crate) instances_with_other_non_compliant_patches: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of managed nodes in the patch group.</p>
        pub fn instances(mut self, input: i32) -> Self {
            self.instances = Some(input);
            self
        }
        /// <p>The number of managed nodes in the patch group.</p>
        pub fn set_instances(mut self, input: std::option::Option<i32>) -> Self {
            self.instances = input;
            self
        }
        /// <p>The number of managed nodes with installed patches.</p>
        pub fn instances_with_installed_patches(mut self, input: i32) -> Self {
            self.instances_with_installed_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with installed patches.</p>
        pub fn set_instances_with_installed_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_installed_patches = input;
            self
        }
        /// <p>The number of managed nodes with patches installed that aren't defined in the patch baseline.</p>
        pub fn instances_with_installed_other_patches(mut self, input: i32) -> Self {
            self.instances_with_installed_other_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with patches installed that aren't defined in the patch baseline.</p>
        pub fn set_instances_with_installed_other_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_installed_other_patches = input;
            self
        }
        /// <p>The number of managed nodes with patches installed by Patch Manager that haven't been rebooted after the patch installation. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn instances_with_installed_pending_reboot_patches(mut self, input: i32) -> Self {
            self.instances_with_installed_pending_reboot_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with patches installed by Patch Manager that haven't been rebooted after the patch installation. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn set_instances_with_installed_pending_reboot_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_installed_pending_reboot_patches = input;
            self
        }
        /// <p>The number of managed nodes with patches installed that are specified in a <code>RejectedPatches</code> list. Patches with a status of <code>INSTALLED_REJECTED</code> were typically installed before they were added to a <code>RejectedPatches</code> list.</p> <note>
        /// <p>If <code>ALLOW_AS_DEPENDENCY</code> is the specified option for <code>RejectedPatchesAction</code>, the value of <code>InstancesWithInstalledRejectedPatches</code> will always be <code>0</code> (zero).</p>
        /// </note>
        pub fn instances_with_installed_rejected_patches(mut self, input: i32) -> Self {
            self.instances_with_installed_rejected_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with patches installed that are specified in a <code>RejectedPatches</code> list. Patches with a status of <code>INSTALLED_REJECTED</code> were typically installed before they were added to a <code>RejectedPatches</code> list.</p> <note>
        /// <p>If <code>ALLOW_AS_DEPENDENCY</code> is the specified option for <code>RejectedPatchesAction</code>, the value of <code>InstancesWithInstalledRejectedPatches</code> will always be <code>0</code> (zero).</p>
        /// </note>
        pub fn set_instances_with_installed_rejected_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_installed_rejected_patches = input;
            self
        }
        /// <p>The number of managed nodes with missing patches from the patch baseline.</p>
        pub fn instances_with_missing_patches(mut self, input: i32) -> Self {
            self.instances_with_missing_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with missing patches from the patch baseline.</p>
        pub fn set_instances_with_missing_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_missing_patches = input;
            self
        }
        /// <p>The number of managed nodes with patches from the patch baseline that failed to install.</p>
        pub fn instances_with_failed_patches(mut self, input: i32) -> Self {
            self.instances_with_failed_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with patches from the patch baseline that failed to install.</p>
        pub fn set_instances_with_failed_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_failed_patches = input;
            self
        }
        /// <p>The number of managed nodes with patches that aren't applicable.</p>
        pub fn instances_with_not_applicable_patches(mut self, input: i32) -> Self {
            self.instances_with_not_applicable_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with patches that aren't applicable.</p>
        pub fn set_instances_with_not_applicable_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_not_applicable_patches = input;
            self
        }
        /// <p>The number of managed nodes with <code>NotApplicable</code> patches beyond the supported limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.</p>
        pub fn instances_with_unreported_not_applicable_patches(mut self, input: i32) -> Self {
            self.instances_with_unreported_not_applicable_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with <code>NotApplicable</code> patches beyond the supported limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.</p>
        pub fn set_instances_with_unreported_not_applicable_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_unreported_not_applicable_patches = input;
            self
        }
        /// <p>The number of managed nodes where patches that are specified as <code>Critical</code> for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn instances_with_critical_non_compliant_patches(mut self, input: i32) -> Self {
            self.instances_with_critical_non_compliant_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes where patches that are specified as <code>Critical</code> for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn set_instances_with_critical_non_compliant_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_critical_non_compliant_patches = input;
            self
        }
        /// <p>The number of managed nodes where patches that are specified as <code>Security</code> in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn instances_with_security_non_compliant_patches(mut self, input: i32) -> Self {
            self.instances_with_security_non_compliant_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes where patches that are specified as <code>Security</code> in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn set_instances_with_security_non_compliant_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_security_non_compliant_patches = input;
            self
        }
        /// <p>The number of managed nodes with patches installed that are specified as other than <code>Critical</code> or <code>Security</code> but aren't compliant with the patch baseline. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn instances_with_other_non_compliant_patches(mut self, input: i32) -> Self {
            self.instances_with_other_non_compliant_patches = Some(input);
            self
        }
        /// <p>The number of managed nodes with patches installed that are specified as other than <code>Critical</code> or <code>Security</code> but aren't compliant with the patch baseline. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
        pub fn set_instances_with_other_non_compliant_patches(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.instances_with_other_non_compliant_patches = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchGroupStateOutput`](crate::output::DescribePatchGroupStateOutput)
        pub fn build(self) -> crate::output::DescribePatchGroupStateOutput {
            crate::output::DescribePatchGroupStateOutput {
                instances: self.instances.unwrap_or_default(),
                instances_with_installed_patches: self
                    .instances_with_installed_patches
                    .unwrap_or_default(),
                instances_with_installed_other_patches: self
                    .instances_with_installed_other_patches
                    .unwrap_or_default(),
                instances_with_installed_pending_reboot_patches: self
                    .instances_with_installed_pending_reboot_patches,
                instances_with_installed_rejected_patches: self
                    .instances_with_installed_rejected_patches,
                instances_with_missing_patches: self
                    .instances_with_missing_patches
                    .unwrap_or_default(),
                instances_with_failed_patches: self
                    .instances_with_failed_patches
                    .unwrap_or_default(),
                instances_with_not_applicable_patches: self
                    .instances_with_not_applicable_patches
                    .unwrap_or_default(),
                instances_with_unreported_not_applicable_patches: self
                    .instances_with_unreported_not_applicable_patches,
                instances_with_critical_non_compliant_patches: self
                    .instances_with_critical_non_compliant_patches,
                instances_with_security_non_compliant_patches: self
                    .instances_with_security_non_compliant_patches,
                instances_with_other_non_compliant_patches: self
                    .instances_with_other_non_compliant_patches,
            }
        }
    }
}
impl DescribePatchGroupStateOutput {
    /// Creates a new builder-style object to manufacture [`DescribePatchGroupStateOutput`](crate::output::DescribePatchGroupStateOutput)
    pub fn builder() -> crate::output::describe_patch_group_state_output::Builder {
        crate::output::describe_patch_group_state_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePatchGroupsOutput {
    /// <p>Each entry in the array contains:</p>
    /// <ul>
    /// <li> <p> <code>PatchGroup</code>: string (between 1 and 256 characters. Regex: <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code> </p> </li>
    /// <li> <p> <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.</p> </li>
    /// </ul>
    pub mappings: std::option::Option<std::vec::Vec<crate::model::PatchGroupPatchBaselineMapping>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePatchGroupsOutput {
    /// <p>Each entry in the array contains:</p>
    /// <ul>
    /// <li> <p> <code>PatchGroup</code>: string (between 1 and 256 characters. Regex: <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code> </p> </li>
    /// <li> <p> <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.</p> </li>
    /// </ul>
    pub fn mappings(&self) -> std::option::Option<&[crate::model::PatchGroupPatchBaselineMapping]> {
        self.mappings.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePatchGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePatchGroupsOutput");
        formatter.field("mappings", &self.mappings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePatchGroupsOutput`](crate::output::DescribePatchGroupsOutput)
pub mod describe_patch_groups_output {
    /// A builder for [`DescribePatchGroupsOutput`](crate::output::DescribePatchGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mappings:
            std::option::Option<std::vec::Vec<crate::model::PatchGroupPatchBaselineMapping>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `mappings`.
        ///
        /// To override the contents of this collection use [`set_mappings`](Self::set_mappings).
        ///
        /// <p>Each entry in the array contains:</p>
        /// <ul>
        /// <li> <p> <code>PatchGroup</code>: string (between 1 and 256 characters. Regex: <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code> </p> </li>
        /// <li> <p> <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.</p> </li>
        /// </ul>
        pub fn mappings(mut self, input: crate::model::PatchGroupPatchBaselineMapping) -> Self {
            let mut v = self.mappings.unwrap_or_default();
            v.push(input);
            self.mappings = Some(v);
            self
        }
        /// <p>Each entry in the array contains:</p>
        /// <ul>
        /// <li> <p> <code>PatchGroup</code>: string (between 1 and 256 characters. Regex: <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code> </p> </li>
        /// <li> <p> <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.</p> </li>
        /// </ul>
        pub fn set_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchGroupPatchBaselineMapping>>,
        ) -> Self {
            self.mappings = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchGroupsOutput`](crate::output::DescribePatchGroupsOutput)
        pub fn build(self) -> crate::output::DescribePatchGroupsOutput {
            crate::output::DescribePatchGroupsOutput {
                mappings: self.mappings,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePatchGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribePatchGroupsOutput`](crate::output::DescribePatchGroupsOutput)
    pub fn builder() -> crate::output::describe_patch_groups_output::Builder {
        crate::output::describe_patch_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePatchBaselinesOutput {
    /// <p>An array of <code>PatchBaselineIdentity</code> elements.</p>
    pub baseline_identities:
        std::option::Option<std::vec::Vec<crate::model::PatchBaselineIdentity>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePatchBaselinesOutput {
    /// <p>An array of <code>PatchBaselineIdentity</code> elements.</p>
    pub fn baseline_identities(
        &self,
    ) -> std::option::Option<&[crate::model::PatchBaselineIdentity]> {
        self.baseline_identities.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePatchBaselinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePatchBaselinesOutput");
        formatter.field("baseline_identities", &self.baseline_identities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePatchBaselinesOutput`](crate::output::DescribePatchBaselinesOutput)
pub mod describe_patch_baselines_output {
    /// A builder for [`DescribePatchBaselinesOutput`](crate::output::DescribePatchBaselinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_identities:
            std::option::Option<std::vec::Vec<crate::model::PatchBaselineIdentity>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `baseline_identities`.
        ///
        /// To override the contents of this collection use [`set_baseline_identities`](Self::set_baseline_identities).
        ///
        /// <p>An array of <code>PatchBaselineIdentity</code> elements.</p>
        pub fn baseline_identities(mut self, input: crate::model::PatchBaselineIdentity) -> Self {
            let mut v = self.baseline_identities.unwrap_or_default();
            v.push(input);
            self.baseline_identities = Some(v);
            self
        }
        /// <p>An array of <code>PatchBaselineIdentity</code> elements.</p>
        pub fn set_baseline_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchBaselineIdentity>>,
        ) -> Self {
            self.baseline_identities = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchBaselinesOutput`](crate::output::DescribePatchBaselinesOutput)
        pub fn build(self) -> crate::output::DescribePatchBaselinesOutput {
            crate::output::DescribePatchBaselinesOutput {
                baseline_identities: self.baseline_identities,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePatchBaselinesOutput {
    /// Creates a new builder-style object to manufacture [`DescribePatchBaselinesOutput`](crate::output::DescribePatchBaselinesOutput)
    pub fn builder() -> crate::output::describe_patch_baselines_output::Builder {
        crate::output::describe_patch_baselines_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeParametersOutput {
    /// <p>Parameters returned by the request.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::ParameterMetadata>>,
    /// <p>The token to use when requesting the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeParametersOutput {
    /// <p>Parameters returned by the request.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::ParameterMetadata]> {
        self.parameters.as_deref()
    }
    /// <p>The token to use when requesting the next set of items.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeParametersOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
pub mod describe_parameters_output {
    /// A builder for [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::ParameterMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Parameters returned by the request.</p>
        pub fn parameters(mut self, input: crate::model::ParameterMetadata) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>Parameters returned by the request.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterMetadata>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The token to use when requesting the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
        pub fn build(self) -> crate::output::DescribeParametersOutput {
            crate::output::DescribeParametersOutput {
                parameters: self.parameters,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeParametersOutput`](crate::output::DescribeParametersOutput)
    pub fn builder() -> crate::output::describe_parameters_output::Builder {
        crate::output::describe_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOpsItemsOutput {
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of OpsItems.</p>
    pub ops_item_summaries: std::option::Option<std::vec::Vec<crate::model::OpsItemSummary>>,
}
impl DescribeOpsItemsOutput {
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of OpsItems.</p>
    pub fn ops_item_summaries(&self) -> std::option::Option<&[crate::model::OpsItemSummary]> {
        self.ops_item_summaries.as_deref()
    }
}
impl std::fmt::Debug for DescribeOpsItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOpsItemsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("ops_item_summaries", &self.ops_item_summaries);
        formatter.finish()
    }
}
/// See [`DescribeOpsItemsOutput`](crate::output::DescribeOpsItemsOutput)
pub mod describe_ops_items_output {
    /// A builder for [`DescribeOpsItemsOutput`](crate::output::DescribeOpsItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) ops_item_summaries:
            std::option::Option<std::vec::Vec<crate::model::OpsItemSummary>>,
    }
    impl Builder {
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `ops_item_summaries`.
        ///
        /// To override the contents of this collection use [`set_ops_item_summaries`](Self::set_ops_item_summaries).
        ///
        /// <p>A list of OpsItems.</p>
        pub fn ops_item_summaries(mut self, input: crate::model::OpsItemSummary) -> Self {
            let mut v = self.ops_item_summaries.unwrap_or_default();
            v.push(input);
            self.ops_item_summaries = Some(v);
            self
        }
        /// <p>A list of OpsItems.</p>
        pub fn set_ops_item_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemSummary>>,
        ) -> Self {
            self.ops_item_summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOpsItemsOutput`](crate::output::DescribeOpsItemsOutput)
        pub fn build(self) -> crate::output::DescribeOpsItemsOutput {
            crate::output::DescribeOpsItemsOutput {
                next_token: self.next_token,
                ops_item_summaries: self.ops_item_summaries,
            }
        }
    }
}
impl DescribeOpsItemsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOpsItemsOutput`](crate::output::DescribeOpsItemsOutput)
    pub fn builder() -> crate::output::describe_ops_items_output::Builder {
        crate::output::describe_ops_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowTasksOutput {
    /// <p>Information about the tasks in the maintenance window.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowTask>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowTasksOutput {
    /// <p>Information about the tasks in the maintenance window.</p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::MaintenanceWindowTask]> {
        self.tasks.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceWindowTasksOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowTasksOutput`](crate::output::DescribeMaintenanceWindowTasksOutput)
pub mod describe_maintenance_window_tasks_output {
    /// A builder for [`DescribeMaintenanceWindowTasksOutput`](crate::output::DescribeMaintenanceWindowTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowTask>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>Information about the tasks in the maintenance window.</p>
        pub fn tasks(mut self, input: crate::model::MaintenanceWindowTask) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p>Information about the tasks in the maintenance window.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowTask>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowTasksOutput`](crate::output::DescribeMaintenanceWindowTasksOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceWindowTasksOutput {
            crate::output::DescribeMaintenanceWindowTasksOutput {
                tasks: self.tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowTasksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowTasksOutput`](crate::output::DescribeMaintenanceWindowTasksOutput)
    pub fn builder() -> crate::output::describe_maintenance_window_tasks_output::Builder {
        crate::output::describe_maintenance_window_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowTargetsOutput {
    /// <p>Information about the targets in the maintenance window.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowTarget>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowTargetsOutput {
    /// <p>Information about the targets in the maintenance window.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::MaintenanceWindowTarget]> {
        self.targets.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceWindowTargetsOutput");
        formatter.field("targets", &self.targets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowTargetsOutput`](crate::output::DescribeMaintenanceWindowTargetsOutput)
pub mod describe_maintenance_window_targets_output {
    /// A builder for [`DescribeMaintenanceWindowTargetsOutput`](crate::output::DescribeMaintenanceWindowTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowTarget>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>Information about the targets in the maintenance window.</p>
        pub fn targets(mut self, input: crate::model::MaintenanceWindowTarget) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// <p>Information about the targets in the maintenance window.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowTarget>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowTargetsOutput`](crate::output::DescribeMaintenanceWindowTargetsOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceWindowTargetsOutput {
            crate::output::DescribeMaintenanceWindowTargetsOutput {
                targets: self.targets,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowTargetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowTargetsOutput`](crate::output::DescribeMaintenanceWindowTargetsOutput)
    pub fn builder() -> crate::output::describe_maintenance_window_targets_output::Builder {
        crate::output::describe_maintenance_window_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowsForTargetOutput {
    /// <p>Information about the maintenance window targets and tasks a managed node is associated with.</p>
    pub window_identities:
        std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowIdentityForTarget>>,
    /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowsForTargetOutput {
    /// <p>Information about the maintenance window targets and tasks a managed node is associated with.</p>
    pub fn window_identities(
        &self,
    ) -> std::option::Option<&[crate::model::MaintenanceWindowIdentityForTarget]> {
        self.window_identities.as_deref()
    }
    /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowsForTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceWindowsForTargetOutput");
        formatter.field("window_identities", &self.window_identities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowsForTargetOutput`](crate::output::DescribeMaintenanceWindowsForTargetOutput)
pub mod describe_maintenance_windows_for_target_output {
    /// A builder for [`DescribeMaintenanceWindowsForTargetOutput`](crate::output::DescribeMaintenanceWindowsForTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_identities:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowIdentityForTarget>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `window_identities`.
        ///
        /// To override the contents of this collection use [`set_window_identities`](Self::set_window_identities).
        ///
        /// <p>Information about the maintenance window targets and tasks a managed node is associated with.</p>
        pub fn window_identities(
            mut self,
            input: crate::model::MaintenanceWindowIdentityForTarget,
        ) -> Self {
            let mut v = self.window_identities.unwrap_or_default();
            v.push(input);
            self.window_identities = Some(v);
            self
        }
        /// <p>Information about the maintenance window targets and tasks a managed node is associated with.</p>
        pub fn set_window_identities(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MaintenanceWindowIdentityForTarget>,
            >,
        ) -> Self {
            self.window_identities = input;
            self
        }
        /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowsForTargetOutput`](crate::output::DescribeMaintenanceWindowsForTargetOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceWindowsForTargetOutput {
            crate::output::DescribeMaintenanceWindowsForTargetOutput {
                window_identities: self.window_identities,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowsForTargetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowsForTargetOutput`](crate::output::DescribeMaintenanceWindowsForTargetOutput)
    pub fn builder() -> crate::output::describe_maintenance_windows_for_target_output::Builder {
        crate::output::describe_maintenance_windows_for_target_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowScheduleOutput {
    /// <p>Information about maintenance window executions scheduled for the specified time range.</p>
    pub scheduled_window_executions:
        std::option::Option<std::vec::Vec<crate::model::ScheduledWindowExecution>>,
    /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowScheduleOutput {
    /// <p>Information about maintenance window executions scheduled for the specified time range.</p>
    pub fn scheduled_window_executions(
        &self,
    ) -> std::option::Option<&[crate::model::ScheduledWindowExecution]> {
        self.scheduled_window_executions.as_deref()
    }
    /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceWindowScheduleOutput");
        formatter.field(
            "scheduled_window_executions",
            &self.scheduled_window_executions,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowScheduleOutput`](crate::output::DescribeMaintenanceWindowScheduleOutput)
pub mod describe_maintenance_window_schedule_output {
    /// A builder for [`DescribeMaintenanceWindowScheduleOutput`](crate::output::DescribeMaintenanceWindowScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_window_executions:
            std::option::Option<std::vec::Vec<crate::model::ScheduledWindowExecution>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `scheduled_window_executions`.
        ///
        /// To override the contents of this collection use [`set_scheduled_window_executions`](Self::set_scheduled_window_executions).
        ///
        /// <p>Information about maintenance window executions scheduled for the specified time range.</p>
        pub fn scheduled_window_executions(
            mut self,
            input: crate::model::ScheduledWindowExecution,
        ) -> Self {
            let mut v = self.scheduled_window_executions.unwrap_or_default();
            v.push(input);
            self.scheduled_window_executions = Some(v);
            self
        }
        /// <p>Information about maintenance window executions scheduled for the specified time range.</p>
        pub fn set_scheduled_window_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledWindowExecution>>,
        ) -> Self {
            self.scheduled_window_executions = input;
            self
        }
        /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You use this token in the next call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowScheduleOutput`](crate::output::DescribeMaintenanceWindowScheduleOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceWindowScheduleOutput {
            crate::output::DescribeMaintenanceWindowScheduleOutput {
                scheduled_window_executions: self.scheduled_window_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowScheduleOutput`](crate::output::DescribeMaintenanceWindowScheduleOutput)
    pub fn builder() -> crate::output::describe_maintenance_window_schedule_output::Builder {
        crate::output::describe_maintenance_window_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowsOutput {
    /// <p>Information about the maintenance windows.</p>
    pub window_identities:
        std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowIdentity>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowsOutput {
    /// <p>Information about the maintenance windows.</p>
    pub fn window_identities(
        &self,
    ) -> std::option::Option<&[crate::model::MaintenanceWindowIdentity]> {
        self.window_identities.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceWindowsOutput");
        formatter.field("window_identities", &self.window_identities);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowsOutput`](crate::output::DescribeMaintenanceWindowsOutput)
pub mod describe_maintenance_windows_output {
    /// A builder for [`DescribeMaintenanceWindowsOutput`](crate::output::DescribeMaintenanceWindowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_identities:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowIdentity>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `window_identities`.
        ///
        /// To override the contents of this collection use [`set_window_identities`](Self::set_window_identities).
        ///
        /// <p>Information about the maintenance windows.</p>
        pub fn window_identities(mut self, input: crate::model::MaintenanceWindowIdentity) -> Self {
            let mut v = self.window_identities.unwrap_or_default();
            v.push(input);
            self.window_identities = Some(v);
            self
        }
        /// <p>Information about the maintenance windows.</p>
        pub fn set_window_identities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowIdentity>>,
        ) -> Self {
            self.window_identities = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowsOutput`](crate::output::DescribeMaintenanceWindowsOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceWindowsOutput {
            crate::output::DescribeMaintenanceWindowsOutput {
                window_identities: self.window_identities,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowsOutput`](crate::output::DescribeMaintenanceWindowsOutput)
    pub fn builder() -> crate::output::describe_maintenance_windows_output::Builder {
        crate::output::describe_maintenance_windows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowExecutionTasksOutput {
    /// <p>Information about the task executions.</p>
    pub window_execution_task_identities:
        std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowExecutionTaskIdentity>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowExecutionTasksOutput {
    /// <p>Information about the task executions.</p>
    pub fn window_execution_task_identities(
        &self,
    ) -> std::option::Option<&[crate::model::MaintenanceWindowExecutionTaskIdentity]> {
        self.window_execution_task_identities.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowExecutionTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceWindowExecutionTasksOutput");
        formatter.field(
            "window_execution_task_identities",
            &self.window_execution_task_identities,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowExecutionTasksOutput`](crate::output::DescribeMaintenanceWindowExecutionTasksOutput)
pub mod describe_maintenance_window_execution_tasks_output {
    /// A builder for [`DescribeMaintenanceWindowExecutionTasksOutput`](crate::output::DescribeMaintenanceWindowExecutionTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_task_identities: std::option::Option<
            std::vec::Vec<crate::model::MaintenanceWindowExecutionTaskIdentity>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `window_execution_task_identities`.
        ///
        /// To override the contents of this collection use [`set_window_execution_task_identities`](Self::set_window_execution_task_identities).
        ///
        /// <p>Information about the task executions.</p>
        pub fn window_execution_task_identities(
            mut self,
            input: crate::model::MaintenanceWindowExecutionTaskIdentity,
        ) -> Self {
            let mut v = self.window_execution_task_identities.unwrap_or_default();
            v.push(input);
            self.window_execution_task_identities = Some(v);
            self
        }
        /// <p>Information about the task executions.</p>
        pub fn set_window_execution_task_identities(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MaintenanceWindowExecutionTaskIdentity>,
            >,
        ) -> Self {
            self.window_execution_task_identities = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowExecutionTasksOutput`](crate::output::DescribeMaintenanceWindowExecutionTasksOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceWindowExecutionTasksOutput {
            crate::output::DescribeMaintenanceWindowExecutionTasksOutput {
                window_execution_task_identities: self.window_execution_task_identities,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowExecutionTasksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionTasksOutput`](crate::output::DescribeMaintenanceWindowExecutionTasksOutput)
    pub fn builder() -> crate::output::describe_maintenance_window_execution_tasks_output::Builder {
        crate::output::describe_maintenance_window_execution_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
    /// <p>Information about the task invocation results per invocation.</p>
    pub window_execution_task_invocation_identities: std::option::Option<
        std::vec::Vec<crate::model::MaintenanceWindowExecutionTaskInvocationIdentity>,
    >,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
    /// <p>Information about the task invocation results per invocation.</p>
    pub fn window_execution_task_invocation_identities(
        &self,
    ) -> std::option::Option<&[crate::model::MaintenanceWindowExecutionTaskInvocationIdentity]>
    {
        self.window_execution_task_invocation_identities.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("DescribeMaintenanceWindowExecutionTaskInvocationsOutput");
        formatter.field(
            "window_execution_task_invocation_identities",
            &self.window_execution_task_invocation_identities,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowExecutionTaskInvocationsOutput`](crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput)
pub mod describe_maintenance_window_execution_task_invocations_output {
    /// A builder for [`DescribeMaintenanceWindowExecutionTaskInvocationsOutput`](crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_task_invocation_identities: std::option::Option<
            std::vec::Vec<crate::model::MaintenanceWindowExecutionTaskInvocationIdentity>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `window_execution_task_invocation_identities`.
        ///
        /// To override the contents of this collection use [`set_window_execution_task_invocation_identities`](Self::set_window_execution_task_invocation_identities).
        ///
        /// <p>Information about the task invocation results per invocation.</p>
        pub fn window_execution_task_invocation_identities(
            mut self,
            input: crate::model::MaintenanceWindowExecutionTaskInvocationIdentity,
        ) -> Self {
            let mut v = self
                .window_execution_task_invocation_identities
                .unwrap_or_default();
            v.push(input);
            self.window_execution_task_invocation_identities = Some(v);
            self
        }
        /// <p>Information about the task invocation results per invocation.</p>
        pub fn set_window_execution_task_invocation_identities(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MaintenanceWindowExecutionTaskInvocationIdentity>,
            >,
        ) -> Self {
            self.window_execution_task_invocation_identities = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowExecutionTaskInvocationsOutput`](crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput)
        pub fn build(
            self,
        ) -> crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
            crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
                window_execution_task_invocation_identities: self
                    .window_execution_task_invocation_identities,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionTaskInvocationsOutput`](crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput)
    pub fn builder(
    ) -> crate::output::describe_maintenance_window_execution_task_invocations_output::Builder {
        crate::output::describe_maintenance_window_execution_task_invocations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMaintenanceWindowExecutionsOutput {
    /// <p>Information about the maintenance window executions.</p>
    pub window_executions:
        std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowExecution>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMaintenanceWindowExecutionsOutput {
    /// <p>Information about the maintenance window executions.</p>
    pub fn window_executions(
        &self,
    ) -> std::option::Option<&[crate::model::MaintenanceWindowExecution]> {
        self.window_executions.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMaintenanceWindowExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMaintenanceWindowExecutionsOutput");
        formatter.field("window_executions", &self.window_executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMaintenanceWindowExecutionsOutput`](crate::output::DescribeMaintenanceWindowExecutionsOutput)
pub mod describe_maintenance_window_executions_output {
    /// A builder for [`DescribeMaintenanceWindowExecutionsOutput`](crate::output::DescribeMaintenanceWindowExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_executions:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowExecution>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `window_executions`.
        ///
        /// To override the contents of this collection use [`set_window_executions`](Self::set_window_executions).
        ///
        /// <p>Information about the maintenance window executions.</p>
        pub fn window_executions(
            mut self,
            input: crate::model::MaintenanceWindowExecution,
        ) -> Self {
            let mut v = self.window_executions.unwrap_or_default();
            v.push(input);
            self.window_executions = Some(v);
            self
        }
        /// <p>Information about the maintenance window executions.</p>
        pub fn set_window_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowExecution>>,
        ) -> Self {
            self.window_executions = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowExecutionsOutput`](crate::output::DescribeMaintenanceWindowExecutionsOutput)
        pub fn build(self) -> crate::output::DescribeMaintenanceWindowExecutionsOutput {
            crate::output::DescribeMaintenanceWindowExecutionsOutput {
                window_executions: self.window_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMaintenanceWindowExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionsOutput`](crate::output::DescribeMaintenanceWindowExecutionsOutput)
    pub fn builder() -> crate::output::describe_maintenance_window_executions_output::Builder {
        crate::output::describe_maintenance_window_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInventoryDeletionsOutput {
    /// <p>A list of status items for deleted inventory.</p>
    pub inventory_deletions:
        std::option::Option<std::vec::Vec<crate::model::InventoryDeletionStatusItem>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInventoryDeletionsOutput {
    /// <p>A list of status items for deleted inventory.</p>
    pub fn inventory_deletions(
        &self,
    ) -> std::option::Option<&[crate::model::InventoryDeletionStatusItem]> {
        self.inventory_deletions.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInventoryDeletionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInventoryDeletionsOutput");
        formatter.field("inventory_deletions", &self.inventory_deletions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInventoryDeletionsOutput`](crate::output::DescribeInventoryDeletionsOutput)
pub mod describe_inventory_deletions_output {
    /// A builder for [`DescribeInventoryDeletionsOutput`](crate::output::DescribeInventoryDeletionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inventory_deletions:
            std::option::Option<std::vec::Vec<crate::model::InventoryDeletionStatusItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `inventory_deletions`.
        ///
        /// To override the contents of this collection use [`set_inventory_deletions`](Self::set_inventory_deletions).
        ///
        /// <p>A list of status items for deleted inventory.</p>
        pub fn inventory_deletions(
            mut self,
            input: crate::model::InventoryDeletionStatusItem,
        ) -> Self {
            let mut v = self.inventory_deletions.unwrap_or_default();
            v.push(input);
            self.inventory_deletions = Some(v);
            self
        }
        /// <p>A list of status items for deleted inventory.</p>
        pub fn set_inventory_deletions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryDeletionStatusItem>>,
        ) -> Self {
            self.inventory_deletions = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInventoryDeletionsOutput`](crate::output::DescribeInventoryDeletionsOutput)
        pub fn build(self) -> crate::output::DescribeInventoryDeletionsOutput {
            crate::output::DescribeInventoryDeletionsOutput {
                inventory_deletions: self.inventory_deletions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInventoryDeletionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInventoryDeletionsOutput`](crate::output::DescribeInventoryDeletionsOutput)
    pub fn builder() -> crate::output::describe_inventory_deletions_output::Builder {
        crate::output::describe_inventory_deletions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstancePatchStatesForPatchGroupOutput {
    /// <p>The high-level patch state for the requested managed nodes. </p>
    pub instance_patch_states: std::option::Option<std::vec::Vec<crate::model::InstancePatchState>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstancePatchStatesForPatchGroupOutput {
    /// <p>The high-level patch state for the requested managed nodes. </p>
    pub fn instance_patch_states(
        &self,
    ) -> std::option::Option<&[crate::model::InstancePatchState]> {
        self.instance_patch_states.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstancePatchStatesForPatchGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstancePatchStatesForPatchGroupOutput");
        formatter.field("instance_patch_states", &self.instance_patch_states);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInstancePatchStatesForPatchGroupOutput`](crate::output::DescribeInstancePatchStatesForPatchGroupOutput)
pub mod describe_instance_patch_states_for_patch_group_output {
    /// A builder for [`DescribeInstancePatchStatesForPatchGroupOutput`](crate::output::DescribeInstancePatchStatesForPatchGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_patch_states:
            std::option::Option<std::vec::Vec<crate::model::InstancePatchState>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_patch_states`.
        ///
        /// To override the contents of this collection use [`set_instance_patch_states`](Self::set_instance_patch_states).
        ///
        /// <p>The high-level patch state for the requested managed nodes. </p>
        pub fn instance_patch_states(mut self, input: crate::model::InstancePatchState) -> Self {
            let mut v = self.instance_patch_states.unwrap_or_default();
            v.push(input);
            self.instance_patch_states = Some(v);
            self
        }
        /// <p>The high-level patch state for the requested managed nodes. </p>
        pub fn set_instance_patch_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePatchState>>,
        ) -> Self {
            self.instance_patch_states = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancePatchStatesForPatchGroupOutput`](crate::output::DescribeInstancePatchStatesForPatchGroupOutput)
        pub fn build(self) -> crate::output::DescribeInstancePatchStatesForPatchGroupOutput {
            crate::output::DescribeInstancePatchStatesForPatchGroupOutput {
                instance_patch_states: self.instance_patch_states,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInstancePatchStatesForPatchGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchStatesForPatchGroupOutput`](crate::output::DescribeInstancePatchStatesForPatchGroupOutput)
    pub fn builder() -> crate::output::describe_instance_patch_states_for_patch_group_output::Builder
    {
        crate::output::describe_instance_patch_states_for_patch_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstancePatchStatesOutput {
    /// <p>The high-level patch state for the requested managed nodes.</p>
    pub instance_patch_states: std::option::Option<std::vec::Vec<crate::model::InstancePatchState>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstancePatchStatesOutput {
    /// <p>The high-level patch state for the requested managed nodes.</p>
    pub fn instance_patch_states(
        &self,
    ) -> std::option::Option<&[crate::model::InstancePatchState]> {
        self.instance_patch_states.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstancePatchStatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstancePatchStatesOutput");
        formatter.field("instance_patch_states", &self.instance_patch_states);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInstancePatchStatesOutput`](crate::output::DescribeInstancePatchStatesOutput)
pub mod describe_instance_patch_states_output {
    /// A builder for [`DescribeInstancePatchStatesOutput`](crate::output::DescribeInstancePatchStatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_patch_states:
            std::option::Option<std::vec::Vec<crate::model::InstancePatchState>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_patch_states`.
        ///
        /// To override the contents of this collection use [`set_instance_patch_states`](Self::set_instance_patch_states).
        ///
        /// <p>The high-level patch state for the requested managed nodes.</p>
        pub fn instance_patch_states(mut self, input: crate::model::InstancePatchState) -> Self {
            let mut v = self.instance_patch_states.unwrap_or_default();
            v.push(input);
            self.instance_patch_states = Some(v);
            self
        }
        /// <p>The high-level patch state for the requested managed nodes.</p>
        pub fn set_instance_patch_states(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePatchState>>,
        ) -> Self {
            self.instance_patch_states = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancePatchStatesOutput`](crate::output::DescribeInstancePatchStatesOutput)
        pub fn build(self) -> crate::output::DescribeInstancePatchStatesOutput {
            crate::output::DescribeInstancePatchStatesOutput {
                instance_patch_states: self.instance_patch_states,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInstancePatchStatesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchStatesOutput`](crate::output::DescribeInstancePatchStatesOutput)
    pub fn builder() -> crate::output::describe_instance_patch_states_output::Builder {
        crate::output::describe_instance_patch_states_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstancePatchesOutput {
    /// <p>Each entry in the array is a structure containing:</p>
    /// <ul>
    /// <li> <p>Title (string)</p> </li>
    /// <li> <p>KBId (string)</p> </li>
    /// <li> <p>Classification (string)</p> </li>
    /// <li> <p>Severity (string)</p> </li>
    /// <li> <p>State (string, such as "INSTALLED" or "FAILED")</p> </li>
    /// <li> <p>InstalledTime (DateTime)</p> </li>
    /// <li> <p>InstalledBy (string)</p> </li>
    /// </ul>
    pub patches: std::option::Option<std::vec::Vec<crate::model::PatchComplianceData>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstancePatchesOutput {
    /// <p>Each entry in the array is a structure containing:</p>
    /// <ul>
    /// <li> <p>Title (string)</p> </li>
    /// <li> <p>KBId (string)</p> </li>
    /// <li> <p>Classification (string)</p> </li>
    /// <li> <p>Severity (string)</p> </li>
    /// <li> <p>State (string, such as "INSTALLED" or "FAILED")</p> </li>
    /// <li> <p>InstalledTime (DateTime)</p> </li>
    /// <li> <p>InstalledBy (string)</p> </li>
    /// </ul>
    pub fn patches(&self) -> std::option::Option<&[crate::model::PatchComplianceData]> {
        self.patches.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstancePatchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstancePatchesOutput");
        formatter.field("patches", &self.patches);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInstancePatchesOutput`](crate::output::DescribeInstancePatchesOutput)
pub mod describe_instance_patches_output {
    /// A builder for [`DescribeInstancePatchesOutput`](crate::output::DescribeInstancePatchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patches: std::option::Option<std::vec::Vec<crate::model::PatchComplianceData>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `patches`.
        ///
        /// To override the contents of this collection use [`set_patches`](Self::set_patches).
        ///
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li> <p>Title (string)</p> </li>
        /// <li> <p>KBId (string)</p> </li>
        /// <li> <p>Classification (string)</p> </li>
        /// <li> <p>Severity (string)</p> </li>
        /// <li> <p>State (string, such as "INSTALLED" or "FAILED")</p> </li>
        /// <li> <p>InstalledTime (DateTime)</p> </li>
        /// <li> <p>InstalledBy (string)</p> </li>
        /// </ul>
        pub fn patches(mut self, input: crate::model::PatchComplianceData) -> Self {
            let mut v = self.patches.unwrap_or_default();
            v.push(input);
            self.patches = Some(v);
            self
        }
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li> <p>Title (string)</p> </li>
        /// <li> <p>KBId (string)</p> </li>
        /// <li> <p>Classification (string)</p> </li>
        /// <li> <p>Severity (string)</p> </li>
        /// <li> <p>State (string, such as "INSTALLED" or "FAILED")</p> </li>
        /// <li> <p>InstalledTime (DateTime)</p> </li>
        /// <li> <p>InstalledBy (string)</p> </li>
        /// </ul>
        pub fn set_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchComplianceData>>,
        ) -> Self {
            self.patches = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancePatchesOutput`](crate::output::DescribeInstancePatchesOutput)
        pub fn build(self) -> crate::output::DescribeInstancePatchesOutput {
            crate::output::DescribeInstancePatchesOutput {
                patches: self.patches,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInstancePatchesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchesOutput`](crate::output::DescribeInstancePatchesOutput)
    pub fn builder() -> crate::output::describe_instance_patches_output::Builder {
        crate::output::describe_instance_patches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstanceInformationOutput {
    /// <p>The managed node information list.</p>
    pub instance_information_list:
        std::option::Option<std::vec::Vec<crate::model::InstanceInformation>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstanceInformationOutput {
    /// <p>The managed node information list.</p>
    pub fn instance_information_list(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceInformation]> {
        self.instance_information_list.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstanceInformationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstanceInformationOutput");
        formatter.field("instance_information_list", &self.instance_information_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInstanceInformationOutput`](crate::output::DescribeInstanceInformationOutput)
pub mod describe_instance_information_output {
    /// A builder for [`DescribeInstanceInformationOutput`](crate::output::DescribeInstanceInformationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_information_list:
            std::option::Option<std::vec::Vec<crate::model::InstanceInformation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_information_list`.
        ///
        /// To override the contents of this collection use [`set_instance_information_list`](Self::set_instance_information_list).
        ///
        /// <p>The managed node information list.</p>
        pub fn instance_information_list(
            mut self,
            input: crate::model::InstanceInformation,
        ) -> Self {
            let mut v = self.instance_information_list.unwrap_or_default();
            v.push(input);
            self.instance_information_list = Some(v);
            self
        }
        /// <p>The managed node information list.</p>
        pub fn set_instance_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceInformation>>,
        ) -> Self {
            self.instance_information_list = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceInformationOutput`](crate::output::DescribeInstanceInformationOutput)
        pub fn build(self) -> crate::output::DescribeInstanceInformationOutput {
            crate::output::DescribeInstanceInformationOutput {
                instance_information_list: self.instance_information_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInstanceInformationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceInformationOutput`](crate::output::DescribeInstanceInformationOutput)
    pub fn builder() -> crate::output::describe_instance_information_output::Builder {
        crate::output::describe_instance_information_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstanceAssociationsStatusOutput {
    /// <p>Status information about the association.</p>
    pub instance_association_status_infos:
        std::option::Option<std::vec::Vec<crate::model::InstanceAssociationStatusInfo>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeInstanceAssociationsStatusOutput {
    /// <p>Status information about the association.</p>
    pub fn instance_association_status_infos(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceAssociationStatusInfo]> {
        self.instance_association_status_infos.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstanceAssociationsStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstanceAssociationsStatusOutput");
        formatter.field(
            "instance_association_status_infos",
            &self.instance_association_status_infos,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeInstanceAssociationsStatusOutput`](crate::output::DescribeInstanceAssociationsStatusOutput)
pub mod describe_instance_associations_status_output {
    /// A builder for [`DescribeInstanceAssociationsStatusOutput`](crate::output::DescribeInstanceAssociationsStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_association_status_infos:
            std::option::Option<std::vec::Vec<crate::model::InstanceAssociationStatusInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_association_status_infos`.
        ///
        /// To override the contents of this collection use [`set_instance_association_status_infos`](Self::set_instance_association_status_infos).
        ///
        /// <p>Status information about the association.</p>
        pub fn instance_association_status_infos(
            mut self,
            input: crate::model::InstanceAssociationStatusInfo,
        ) -> Self {
            let mut v = self.instance_association_status_infos.unwrap_or_default();
            v.push(input);
            self.instance_association_status_infos = Some(v);
            self
        }
        /// <p>Status information about the association.</p>
        pub fn set_instance_association_status_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceAssociationStatusInfo>>,
        ) -> Self {
            self.instance_association_status_infos = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceAssociationsStatusOutput`](crate::output::DescribeInstanceAssociationsStatusOutput)
        pub fn build(self) -> crate::output::DescribeInstanceAssociationsStatusOutput {
            crate::output::DescribeInstanceAssociationsStatusOutput {
                instance_association_status_infos: self.instance_association_status_infos,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeInstanceAssociationsStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAssociationsStatusOutput`](crate::output::DescribeInstanceAssociationsStatusOutput)
    pub fn builder() -> crate::output::describe_instance_associations_status_output::Builder {
        crate::output::describe_instance_associations_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEffectivePatchesForPatchBaselineOutput {
    /// <p>An array of patches and patch status.</p>
    pub effective_patches: std::option::Option<std::vec::Vec<crate::model::EffectivePatch>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEffectivePatchesForPatchBaselineOutput {
    /// <p>An array of patches and patch status.</p>
    pub fn effective_patches(&self) -> std::option::Option<&[crate::model::EffectivePatch]> {
        self.effective_patches.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEffectivePatchesForPatchBaselineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEffectivePatchesForPatchBaselineOutput");
        formatter.field("effective_patches", &self.effective_patches);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEffectivePatchesForPatchBaselineOutput`](crate::output::DescribeEffectivePatchesForPatchBaselineOutput)
pub mod describe_effective_patches_for_patch_baseline_output {
    /// A builder for [`DescribeEffectivePatchesForPatchBaselineOutput`](crate::output::DescribeEffectivePatchesForPatchBaselineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) effective_patches:
            std::option::Option<std::vec::Vec<crate::model::EffectivePatch>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `effective_patches`.
        ///
        /// To override the contents of this collection use [`set_effective_patches`](Self::set_effective_patches).
        ///
        /// <p>An array of patches and patch status.</p>
        pub fn effective_patches(mut self, input: crate::model::EffectivePatch) -> Self {
            let mut v = self.effective_patches.unwrap_or_default();
            v.push(input);
            self.effective_patches = Some(v);
            self
        }
        /// <p>An array of patches and patch status.</p>
        pub fn set_effective_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EffectivePatch>>,
        ) -> Self {
            self.effective_patches = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEffectivePatchesForPatchBaselineOutput`](crate::output::DescribeEffectivePatchesForPatchBaselineOutput)
        pub fn build(self) -> crate::output::DescribeEffectivePatchesForPatchBaselineOutput {
            crate::output::DescribeEffectivePatchesForPatchBaselineOutput {
                effective_patches: self.effective_patches,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEffectivePatchesForPatchBaselineOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEffectivePatchesForPatchBaselineOutput`](crate::output::DescribeEffectivePatchesForPatchBaselineOutput)
    pub fn builder() -> crate::output::describe_effective_patches_for_patch_baseline_output::Builder
    {
        crate::output::describe_effective_patches_for_patch_baseline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEffectiveInstanceAssociationsOutput {
    /// <p>The associations for the requested managed node.</p>
    pub associations: std::option::Option<std::vec::Vec<crate::model::InstanceAssociation>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEffectiveInstanceAssociationsOutput {
    /// <p>The associations for the requested managed node.</p>
    pub fn associations(&self) -> std::option::Option<&[crate::model::InstanceAssociation]> {
        self.associations.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEffectiveInstanceAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEffectiveInstanceAssociationsOutput");
        formatter.field("associations", &self.associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEffectiveInstanceAssociationsOutput`](crate::output::DescribeEffectiveInstanceAssociationsOutput)
pub mod describe_effective_instance_associations_output {
    /// A builder for [`DescribeEffectiveInstanceAssociationsOutput`](crate::output::DescribeEffectiveInstanceAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associations:
            std::option::Option<std::vec::Vec<crate::model::InstanceAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `associations`.
        ///
        /// To override the contents of this collection use [`set_associations`](Self::set_associations).
        ///
        /// <p>The associations for the requested managed node.</p>
        pub fn associations(mut self, input: crate::model::InstanceAssociation) -> Self {
            let mut v = self.associations.unwrap_or_default();
            v.push(input);
            self.associations = Some(v);
            self
        }
        /// <p>The associations for the requested managed node.</p>
        pub fn set_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceAssociation>>,
        ) -> Self {
            self.associations = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEffectiveInstanceAssociationsOutput`](crate::output::DescribeEffectiveInstanceAssociationsOutput)
        pub fn build(self) -> crate::output::DescribeEffectiveInstanceAssociationsOutput {
            crate::output::DescribeEffectiveInstanceAssociationsOutput {
                associations: self.associations,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEffectiveInstanceAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEffectiveInstanceAssociationsOutput`](crate::output::DescribeEffectiveInstanceAssociationsOutput)
    pub fn builder() -> crate::output::describe_effective_instance_associations_output::Builder {
        crate::output::describe_effective_instance_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDocumentPermissionOutput {
    /// <p>The account IDs that have permission to use this document. The ID can be either an Amazon Web Services account or <i>All</i>.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of Amazon Web Services accounts where the current document is shared and the version shared with each account.</p>
    pub account_sharing_info_list:
        std::option::Option<std::vec::Vec<crate::model::AccountSharingInfo>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDocumentPermissionOutput {
    /// <p>The account IDs that have permission to use this document. The ID can be either an Amazon Web Services account or <i>All</i>.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>A list of Amazon Web Services accounts where the current document is shared and the version shared with each account.</p>
    pub fn account_sharing_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::AccountSharingInfo]> {
        self.account_sharing_info_list.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDocumentPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDocumentPermissionOutput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("account_sharing_info_list", &self.account_sharing_info_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDocumentPermissionOutput`](crate::output::DescribeDocumentPermissionOutput)
pub mod describe_document_permission_output {
    /// A builder for [`DescribeDocumentPermissionOutput`](crate::output::DescribeDocumentPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) account_sharing_info_list:
            std::option::Option<std::vec::Vec<crate::model::AccountSharingInfo>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account IDs that have permission to use this document. The ID can be either an Amazon Web Services account or <i>All</i>.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The account IDs that have permission to use this document. The ID can be either an Amazon Web Services account or <i>All</i>.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `account_sharing_info_list`.
        ///
        /// To override the contents of this collection use [`set_account_sharing_info_list`](Self::set_account_sharing_info_list).
        ///
        /// <p>A list of Amazon Web Services accounts where the current document is shared and the version shared with each account.</p>
        pub fn account_sharing_info_list(
            mut self,
            input: crate::model::AccountSharingInfo,
        ) -> Self {
            let mut v = self.account_sharing_info_list.unwrap_or_default();
            v.push(input);
            self.account_sharing_info_list = Some(v);
            self
        }
        /// <p>A list of Amazon Web Services accounts where the current document is shared and the version shared with each account.</p>
        pub fn set_account_sharing_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountSharingInfo>>,
        ) -> Self {
            self.account_sharing_info_list = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentPermissionOutput`](crate::output::DescribeDocumentPermissionOutput)
        pub fn build(self) -> crate::output::DescribeDocumentPermissionOutput {
            crate::output::DescribeDocumentPermissionOutput {
                account_ids: self.account_ids,
                account_sharing_info_list: self.account_sharing_info_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDocumentPermissionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentPermissionOutput`](crate::output::DescribeDocumentPermissionOutput)
    pub fn builder() -> crate::output::describe_document_permission_output::Builder {
        crate::output::describe_document_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDocumentOutput {
    /// <p>Information about the SSM document.</p>
    pub document: std::option::Option<crate::model::DocumentDescription>,
}
impl DescribeDocumentOutput {
    /// <p>Information about the SSM document.</p>
    pub fn document(&self) -> std::option::Option<&crate::model::DocumentDescription> {
        self.document.as_ref()
    }
}
impl std::fmt::Debug for DescribeDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDocumentOutput");
        formatter.field("document", &self.document);
        formatter.finish()
    }
}
/// See [`DescribeDocumentOutput`](crate::output::DescribeDocumentOutput)
pub mod describe_document_output {
    /// A builder for [`DescribeDocumentOutput`](crate::output::DescribeDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<crate::model::DocumentDescription>,
    }
    impl Builder {
        /// <p>Information about the SSM document.</p>
        pub fn document(mut self, input: crate::model::DocumentDescription) -> Self {
            self.document = Some(input);
            self
        }
        /// <p>Information about the SSM document.</p>
        pub fn set_document(
            mut self,
            input: std::option::Option<crate::model::DocumentDescription>,
        ) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentOutput`](crate::output::DescribeDocumentOutput)
        pub fn build(self) -> crate::output::DescribeDocumentOutput {
            crate::output::DescribeDocumentOutput {
                document: self.document,
            }
        }
    }
}
impl DescribeDocumentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentOutput`](crate::output::DescribeDocumentOutput)
    pub fn builder() -> crate::output::describe_document_output::Builder {
        crate::output::describe_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAvailablePatchesOutput {
    /// <p>An array of patches. Each entry in the array is a patch structure.</p>
    pub patches: std::option::Option<std::vec::Vec<crate::model::Patch>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAvailablePatchesOutput {
    /// <p>An array of patches. Each entry in the array is a patch structure.</p>
    pub fn patches(&self) -> std::option::Option<&[crate::model::Patch]> {
        self.patches.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAvailablePatchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAvailablePatchesOutput");
        formatter.field("patches", &self.patches);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAvailablePatchesOutput`](crate::output::DescribeAvailablePatchesOutput)
pub mod describe_available_patches_output {
    /// A builder for [`DescribeAvailablePatchesOutput`](crate::output::DescribeAvailablePatchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patches: std::option::Option<std::vec::Vec<crate::model::Patch>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `patches`.
        ///
        /// To override the contents of this collection use [`set_patches`](Self::set_patches).
        ///
        /// <p>An array of patches. Each entry in the array is a patch structure.</p>
        pub fn patches(mut self, input: crate::model::Patch) -> Self {
            let mut v = self.patches.unwrap_or_default();
            v.push(input);
            self.patches = Some(v);
            self
        }
        /// <p>An array of patches. Each entry in the array is a patch structure.</p>
        pub fn set_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Patch>>,
        ) -> Self {
            self.patches = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAvailablePatchesOutput`](crate::output::DescribeAvailablePatchesOutput)
        pub fn build(self) -> crate::output::DescribeAvailablePatchesOutput {
            crate::output::DescribeAvailablePatchesOutput {
                patches: self.patches,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAvailablePatchesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAvailablePatchesOutput`](crate::output::DescribeAvailablePatchesOutput)
    pub fn builder() -> crate::output::describe_available_patches_output::Builder {
        crate::output::describe_available_patches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAutomationStepExecutionsOutput {
    /// <p>A list of details about the current state of all steps that make up an execution.</p>
    pub step_executions: std::option::Option<std::vec::Vec<crate::model::StepExecution>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAutomationStepExecutionsOutput {
    /// <p>A list of details about the current state of all steps that make up an execution.</p>
    pub fn step_executions(&self) -> std::option::Option<&[crate::model::StepExecution]> {
        self.step_executions.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAutomationStepExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAutomationStepExecutionsOutput");
        formatter.field("step_executions", &self.step_executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAutomationStepExecutionsOutput`](crate::output::DescribeAutomationStepExecutionsOutput)
pub mod describe_automation_step_executions_output {
    /// A builder for [`DescribeAutomationStepExecutionsOutput`](crate::output::DescribeAutomationStepExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) step_executions: std::option::Option<std::vec::Vec<crate::model::StepExecution>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `step_executions`.
        ///
        /// To override the contents of this collection use [`set_step_executions`](Self::set_step_executions).
        ///
        /// <p>A list of details about the current state of all steps that make up an execution.</p>
        pub fn step_executions(mut self, input: crate::model::StepExecution) -> Self {
            let mut v = self.step_executions.unwrap_or_default();
            v.push(input);
            self.step_executions = Some(v);
            self
        }
        /// <p>A list of details about the current state of all steps that make up an execution.</p>
        pub fn set_step_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepExecution>>,
        ) -> Self {
            self.step_executions = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutomationStepExecutionsOutput`](crate::output::DescribeAutomationStepExecutionsOutput)
        pub fn build(self) -> crate::output::DescribeAutomationStepExecutionsOutput {
            crate::output::DescribeAutomationStepExecutionsOutput {
                step_executions: self.step_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAutomationStepExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAutomationStepExecutionsOutput`](crate::output::DescribeAutomationStepExecutionsOutput)
    pub fn builder() -> crate::output::describe_automation_step_executions_output::Builder {
        crate::output::describe_automation_step_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAutomationExecutionsOutput {
    /// <p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>
    pub automation_execution_metadata_list:
        std::option::Option<std::vec::Vec<crate::model::AutomationExecutionMetadata>>,
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAutomationExecutionsOutput {
    /// <p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>
    pub fn automation_execution_metadata_list(
        &self,
    ) -> std::option::Option<&[crate::model::AutomationExecutionMetadata]> {
        self.automation_execution_metadata_list.as_deref()
    }
    /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAutomationExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAutomationExecutionsOutput");
        formatter.field(
            "automation_execution_metadata_list",
            &self.automation_execution_metadata_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAutomationExecutionsOutput`](crate::output::DescribeAutomationExecutionsOutput)
pub mod describe_automation_executions_output {
    /// A builder for [`DescribeAutomationExecutionsOutput`](crate::output::DescribeAutomationExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automation_execution_metadata_list:
            std::option::Option<std::vec::Vec<crate::model::AutomationExecutionMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `automation_execution_metadata_list`.
        ///
        /// To override the contents of this collection use [`set_automation_execution_metadata_list`](Self::set_automation_execution_metadata_list).
        ///
        /// <p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>
        pub fn automation_execution_metadata_list(
            mut self,
            input: crate::model::AutomationExecutionMetadata,
        ) -> Self {
            let mut v = self.automation_execution_metadata_list.unwrap_or_default();
            v.push(input);
            self.automation_execution_metadata_list = Some(v);
            self
        }
        /// <p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>
        pub fn set_automation_execution_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomationExecutionMetadata>>,
        ) -> Self {
            self.automation_execution_metadata_list = input;
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutomationExecutionsOutput`](crate::output::DescribeAutomationExecutionsOutput)
        pub fn build(self) -> crate::output::DescribeAutomationExecutionsOutput {
            crate::output::DescribeAutomationExecutionsOutput {
                automation_execution_metadata_list: self.automation_execution_metadata_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAutomationExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAutomationExecutionsOutput`](crate::output::DescribeAutomationExecutionsOutput)
    pub fn builder() -> crate::output::describe_automation_executions_output::Builder {
        crate::output::describe_automation_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssociationExecutionTargetsOutput {
    /// <p>Information about the execution.</p>
    pub association_execution_targets:
        std::option::Option<std::vec::Vec<crate::model::AssociationExecutionTarget>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAssociationExecutionTargetsOutput {
    /// <p>Information about the execution.</p>
    pub fn association_execution_targets(
        &self,
    ) -> std::option::Option<&[crate::model::AssociationExecutionTarget]> {
        self.association_execution_targets.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssociationExecutionTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssociationExecutionTargetsOutput");
        formatter.field(
            "association_execution_targets",
            &self.association_execution_targets,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAssociationExecutionTargetsOutput`](crate::output::DescribeAssociationExecutionTargetsOutput)
pub mod describe_association_execution_targets_output {
    /// A builder for [`DescribeAssociationExecutionTargetsOutput`](crate::output::DescribeAssociationExecutionTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_execution_targets:
            std::option::Option<std::vec::Vec<crate::model::AssociationExecutionTarget>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `association_execution_targets`.
        ///
        /// To override the contents of this collection use [`set_association_execution_targets`](Self::set_association_execution_targets).
        ///
        /// <p>Information about the execution.</p>
        pub fn association_execution_targets(
            mut self,
            input: crate::model::AssociationExecutionTarget,
        ) -> Self {
            let mut v = self.association_execution_targets.unwrap_or_default();
            v.push(input);
            self.association_execution_targets = Some(v);
            self
        }
        /// <p>Information about the execution.</p>
        pub fn set_association_execution_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationExecutionTarget>>,
        ) -> Self {
            self.association_execution_targets = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssociationExecutionTargetsOutput`](crate::output::DescribeAssociationExecutionTargetsOutput)
        pub fn build(self) -> crate::output::DescribeAssociationExecutionTargetsOutput {
            crate::output::DescribeAssociationExecutionTargetsOutput {
                association_execution_targets: self.association_execution_targets,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAssociationExecutionTargetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAssociationExecutionTargetsOutput`](crate::output::DescribeAssociationExecutionTargetsOutput)
    pub fn builder() -> crate::output::describe_association_execution_targets_output::Builder {
        crate::output::describe_association_execution_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssociationExecutionsOutput {
    /// <p>A list of the executions for the specified association ID.</p>
    pub association_executions:
        std::option::Option<std::vec::Vec<crate::model::AssociationExecution>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAssociationExecutionsOutput {
    /// <p>A list of the executions for the specified association ID.</p>
    pub fn association_executions(
        &self,
    ) -> std::option::Option<&[crate::model::AssociationExecution]> {
        self.association_executions.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAssociationExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssociationExecutionsOutput");
        formatter.field("association_executions", &self.association_executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAssociationExecutionsOutput`](crate::output::DescribeAssociationExecutionsOutput)
pub mod describe_association_executions_output {
    /// A builder for [`DescribeAssociationExecutionsOutput`](crate::output::DescribeAssociationExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_executions:
            std::option::Option<std::vec::Vec<crate::model::AssociationExecution>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `association_executions`.
        ///
        /// To override the contents of this collection use [`set_association_executions`](Self::set_association_executions).
        ///
        /// <p>A list of the executions for the specified association ID.</p>
        pub fn association_executions(mut self, input: crate::model::AssociationExecution) -> Self {
            let mut v = self.association_executions.unwrap_or_default();
            v.push(input);
            self.association_executions = Some(v);
            self
        }
        /// <p>A list of the executions for the specified association ID.</p>
        pub fn set_association_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationExecution>>,
        ) -> Self {
            self.association_executions = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssociationExecutionsOutput`](crate::output::DescribeAssociationExecutionsOutput)
        pub fn build(self) -> crate::output::DescribeAssociationExecutionsOutput {
            crate::output::DescribeAssociationExecutionsOutput {
                association_executions: self.association_executions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAssociationExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAssociationExecutionsOutput`](crate::output::DescribeAssociationExecutionsOutput)
    pub fn builder() -> crate::output::describe_association_executions_output::Builder {
        crate::output::describe_association_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAssociationOutput {
    /// <p>Information about the association.</p>
    pub association_description: std::option::Option<crate::model::AssociationDescription>,
}
impl DescribeAssociationOutput {
    /// <p>Information about the association.</p>
    pub fn association_description(
        &self,
    ) -> std::option::Option<&crate::model::AssociationDescription> {
        self.association_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAssociationOutput");
        formatter.field("association_description", &self.association_description);
        formatter.finish()
    }
}
/// See [`DescribeAssociationOutput`](crate::output::DescribeAssociationOutput)
pub mod describe_association_output {
    /// A builder for [`DescribeAssociationOutput`](crate::output::DescribeAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_description:
            std::option::Option<crate::model::AssociationDescription>,
    }
    impl Builder {
        /// <p>Information about the association.</p>
        pub fn association_description(
            mut self,
            input: crate::model::AssociationDescription,
        ) -> Self {
            self.association_description = Some(input);
            self
        }
        /// <p>Information about the association.</p>
        pub fn set_association_description(
            mut self,
            input: std::option::Option<crate::model::AssociationDescription>,
        ) -> Self {
            self.association_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssociationOutput`](crate::output::DescribeAssociationOutput)
        pub fn build(self) -> crate::output::DescribeAssociationOutput {
            crate::output::DescribeAssociationOutput {
                association_description: self.association_description,
            }
        }
    }
}
impl DescribeAssociationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAssociationOutput`](crate::output::DescribeAssociationOutput)
    pub fn builder() -> crate::output::describe_association_output::Builder {
        crate::output::describe_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeActivationsOutput {
    /// <p>A list of activations for your Amazon Web Services account.</p>
    pub activation_list: std::option::Option<std::vec::Vec<crate::model::Activation>>,
    /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeActivationsOutput {
    /// <p>A list of activations for your Amazon Web Services account.</p>
    pub fn activation_list(&self) -> std::option::Option<&[crate::model::Activation]> {
        self.activation_list.as_deref()
    }
    /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeActivationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeActivationsOutput");
        formatter.field("activation_list", &self.activation_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeActivationsOutput`](crate::output::DescribeActivationsOutput)
pub mod describe_activations_output {
    /// A builder for [`DescribeActivationsOutput`](crate::output::DescribeActivationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activation_list: std::option::Option<std::vec::Vec<crate::model::Activation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `activation_list`.
        ///
        /// To override the contents of this collection use [`set_activation_list`](Self::set_activation_list).
        ///
        /// <p>A list of activations for your Amazon Web Services account.</p>
        pub fn activation_list(mut self, input: crate::model::Activation) -> Self {
            let mut v = self.activation_list.unwrap_or_default();
            v.push(input);
            self.activation_list = Some(v);
            self
        }
        /// <p>A list of activations for your Amazon Web Services account.</p>
        pub fn set_activation_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Activation>>,
        ) -> Self {
            self.activation_list = input;
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivationsOutput`](crate::output::DescribeActivationsOutput)
        pub fn build(self) -> crate::output::DescribeActivationsOutput {
            crate::output::DescribeActivationsOutput {
                activation_list: self.activation_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeActivationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeActivationsOutput`](crate::output::DescribeActivationsOutput)
    pub fn builder() -> crate::output::describe_activations_output::Builder {
        crate::output::describe_activations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTaskFromMaintenanceWindowOutput {
    /// <p>The ID of the maintenance window the task was removed from.</p>
    pub window_id: std::option::Option<std::string::String>,
    /// <p>The ID of the task removed from the maintenance window.</p>
    pub window_task_id: std::option::Option<std::string::String>,
}
impl DeregisterTaskFromMaintenanceWindowOutput {
    /// <p>The ID of the maintenance window the task was removed from.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
    /// <p>The ID of the task removed from the maintenance window.</p>
    pub fn window_task_id(&self) -> std::option::Option<&str> {
        self.window_task_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterTaskFromMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTaskFromMaintenanceWindowOutput");
        formatter.field("window_id", &self.window_id);
        formatter.field("window_task_id", &self.window_task_id);
        formatter.finish()
    }
}
/// See [`DeregisterTaskFromMaintenanceWindowOutput`](crate::output::DeregisterTaskFromMaintenanceWindowOutput)
pub mod deregister_task_from_maintenance_window_output {
    /// A builder for [`DeregisterTaskFromMaintenanceWindowOutput`](crate::output::DeregisterTaskFromMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window the task was removed from.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window the task was removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The ID of the task removed from the maintenance window.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task removed from the maintenance window.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTaskFromMaintenanceWindowOutput`](crate::output::DeregisterTaskFromMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::DeregisterTaskFromMaintenanceWindowOutput {
            crate::output::DeregisterTaskFromMaintenanceWindowOutput {
                window_id: self.window_id,
                window_task_id: self.window_task_id,
            }
        }
    }
}
impl DeregisterTaskFromMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterTaskFromMaintenanceWindowOutput`](crate::output::DeregisterTaskFromMaintenanceWindowOutput)
    pub fn builder() -> crate::output::deregister_task_from_maintenance_window_output::Builder {
        crate::output::deregister_task_from_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTargetFromMaintenanceWindowOutput {
    /// <p>The ID of the maintenance window the target was removed from.</p>
    pub window_id: std::option::Option<std::string::String>,
    /// <p>The ID of the removed target definition.</p>
    pub window_target_id: std::option::Option<std::string::String>,
}
impl DeregisterTargetFromMaintenanceWindowOutput {
    /// <p>The ID of the maintenance window the target was removed from.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
    /// <p>The ID of the removed target definition.</p>
    pub fn window_target_id(&self) -> std::option::Option<&str> {
        self.window_target_id.as_deref()
    }
}
impl std::fmt::Debug for DeregisterTargetFromMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTargetFromMaintenanceWindowOutput");
        formatter.field("window_id", &self.window_id);
        formatter.field("window_target_id", &self.window_target_id);
        formatter.finish()
    }
}
/// See [`DeregisterTargetFromMaintenanceWindowOutput`](crate::output::DeregisterTargetFromMaintenanceWindowOutput)
pub mod deregister_target_from_maintenance_window_output {
    /// A builder for [`DeregisterTargetFromMaintenanceWindowOutput`](crate::output::DeregisterTargetFromMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window the target was removed from.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window the target was removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The ID of the removed target definition.</p>
        pub fn window_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_target_id = Some(input.into());
            self
        }
        /// <p>The ID of the removed target definition.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTargetFromMaintenanceWindowOutput`](crate::output::DeregisterTargetFromMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::DeregisterTargetFromMaintenanceWindowOutput {
            crate::output::DeregisterTargetFromMaintenanceWindowOutput {
                window_id: self.window_id,
                window_target_id: self.window_target_id,
            }
        }
    }
}
impl DeregisterTargetFromMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterTargetFromMaintenanceWindowOutput`](crate::output::DeregisterTargetFromMaintenanceWindowOutput)
    pub fn builder() -> crate::output::deregister_target_from_maintenance_window_output::Builder {
        crate::output::deregister_target_from_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterPatchBaselineForPatchGroupOutput {
    /// <p>The ID of the patch baseline the patch group was deregistered from.</p>
    pub baseline_id: std::option::Option<std::string::String>,
    /// <p>The name of the patch group deregistered from the patch baseline.</p>
    pub patch_group: std::option::Option<std::string::String>,
}
impl DeregisterPatchBaselineForPatchGroupOutput {
    /// <p>The ID of the patch baseline the patch group was deregistered from.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
    /// <p>The name of the patch group deregistered from the patch baseline.</p>
    pub fn patch_group(&self) -> std::option::Option<&str> {
        self.patch_group.as_deref()
    }
}
impl std::fmt::Debug for DeregisterPatchBaselineForPatchGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterPatchBaselineForPatchGroupOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.field("patch_group", &self.patch_group);
        formatter.finish()
    }
}
/// See [`DeregisterPatchBaselineForPatchGroupOutput`](crate::output::DeregisterPatchBaselineForPatchGroupOutput)
pub mod deregister_patch_baseline_for_patch_group_output {
    /// A builder for [`DeregisterPatchBaselineForPatchGroupOutput`](crate::output::DeregisterPatchBaselineForPatchGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) patch_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline the patch group was deregistered from.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline the patch group was deregistered from.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The name of the patch group deregistered from the patch baseline.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group deregistered from the patch baseline.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterPatchBaselineForPatchGroupOutput`](crate::output::DeregisterPatchBaselineForPatchGroupOutput)
        pub fn build(self) -> crate::output::DeregisterPatchBaselineForPatchGroupOutput {
            crate::output::DeregisterPatchBaselineForPatchGroupOutput {
                baseline_id: self.baseline_id,
                patch_group: self.patch_group,
            }
        }
    }
}
impl DeregisterPatchBaselineForPatchGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterPatchBaselineForPatchGroupOutput`](crate::output::DeregisterPatchBaselineForPatchGroupOutput)
    pub fn builder() -> crate::output::deregister_patch_baseline_for_patch_group_output::Builder {
        crate::output::deregister_patch_baseline_for_patch_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterManagedInstanceOutput {}
impl std::fmt::Debug for DeregisterManagedInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterManagedInstanceOutput");
        formatter.finish()
    }
}
/// See [`DeregisterManagedInstanceOutput`](crate::output::DeregisterManagedInstanceOutput)
pub mod deregister_managed_instance_output {
    /// A builder for [`DeregisterManagedInstanceOutput`](crate::output::DeregisterManagedInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterManagedInstanceOutput`](crate::output::DeregisterManagedInstanceOutput)
        pub fn build(self) -> crate::output::DeregisterManagedInstanceOutput {
            crate::output::DeregisterManagedInstanceOutput {}
        }
    }
}
impl DeregisterManagedInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterManagedInstanceOutput`](crate::output::DeregisterManagedInstanceOutput)
    pub fn builder() -> crate::output::deregister_managed_instance_output::Builder {
        crate::output::deregister_managed_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceDataSyncOutput {}
impl std::fmt::Debug for DeleteResourceDataSyncOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceDataSyncOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourceDataSyncOutput`](crate::output::DeleteResourceDataSyncOutput)
pub mod delete_resource_data_sync_output {
    /// A builder for [`DeleteResourceDataSyncOutput`](crate::output::DeleteResourceDataSyncOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourceDataSyncOutput`](crate::output::DeleteResourceDataSyncOutput)
        pub fn build(self) -> crate::output::DeleteResourceDataSyncOutput {
            crate::output::DeleteResourceDataSyncOutput {}
        }
    }
}
impl DeleteResourceDataSyncOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourceDataSyncOutput`](crate::output::DeleteResourceDataSyncOutput)
    pub fn builder() -> crate::output::delete_resource_data_sync_output::Builder {
        crate::output::delete_resource_data_sync_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePatchBaselineOutput {
    /// <p>The ID of the deleted patch baseline.</p>
    pub baseline_id: std::option::Option<std::string::String>,
}
impl DeletePatchBaselineOutput {
    /// <p>The ID of the deleted patch baseline.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePatchBaselineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePatchBaselineOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.finish()
    }
}
/// See [`DeletePatchBaselineOutput`](crate::output::DeletePatchBaselineOutput)
pub mod delete_patch_baseline_output {
    /// A builder for [`DeletePatchBaselineOutput`](crate::output::DeletePatchBaselineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deleted patch baseline.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the deleted patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePatchBaselineOutput`](crate::output::DeletePatchBaselineOutput)
        pub fn build(self) -> crate::output::DeletePatchBaselineOutput {
            crate::output::DeletePatchBaselineOutput {
                baseline_id: self.baseline_id,
            }
        }
    }
}
impl DeletePatchBaselineOutput {
    /// Creates a new builder-style object to manufacture [`DeletePatchBaselineOutput`](crate::output::DeletePatchBaselineOutput)
    pub fn builder() -> crate::output::delete_patch_baseline_output::Builder {
        crate::output::delete_patch_baseline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteParametersOutput {
    /// <p>The names of the deleted parameters.</p>
    pub deleted_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of parameters that weren't deleted because the parameters aren't valid.</p>
    pub invalid_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteParametersOutput {
    /// <p>The names of the deleted parameters.</p>
    pub fn deleted_parameters(&self) -> std::option::Option<&[std::string::String]> {
        self.deleted_parameters.as_deref()
    }
    /// <p>The names of parameters that weren't deleted because the parameters aren't valid.</p>
    pub fn invalid_parameters(&self) -> std::option::Option<&[std::string::String]> {
        self.invalid_parameters.as_deref()
    }
}
impl std::fmt::Debug for DeleteParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteParametersOutput");
        formatter.field("deleted_parameters", &self.deleted_parameters);
        formatter.field("invalid_parameters", &self.invalid_parameters);
        formatter.finish()
    }
}
/// See [`DeleteParametersOutput`](crate::output::DeleteParametersOutput)
pub mod delete_parameters_output {
    /// A builder for [`DeleteParametersOutput`](crate::output::DeleteParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deleted_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) invalid_parameters: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `deleted_parameters`.
        ///
        /// To override the contents of this collection use [`set_deleted_parameters`](Self::set_deleted_parameters).
        ///
        /// <p>The names of the deleted parameters.</p>
        pub fn deleted_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.deleted_parameters.unwrap_or_default();
            v.push(input.into());
            self.deleted_parameters = Some(v);
            self
        }
        /// <p>The names of the deleted parameters.</p>
        pub fn set_deleted_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.deleted_parameters = input;
            self
        }
        /// Appends an item to `invalid_parameters`.
        ///
        /// To override the contents of this collection use [`set_invalid_parameters`](Self::set_invalid_parameters).
        ///
        /// <p>The names of parameters that weren't deleted because the parameters aren't valid.</p>
        pub fn invalid_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.invalid_parameters.unwrap_or_default();
            v.push(input.into());
            self.invalid_parameters = Some(v);
            self
        }
        /// <p>The names of parameters that weren't deleted because the parameters aren't valid.</p>
        pub fn set_invalid_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.invalid_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParametersOutput`](crate::output::DeleteParametersOutput)
        pub fn build(self) -> crate::output::DeleteParametersOutput {
            crate::output::DeleteParametersOutput {
                deleted_parameters: self.deleted_parameters,
                invalid_parameters: self.invalid_parameters,
            }
        }
    }
}
impl DeleteParametersOutput {
    /// Creates a new builder-style object to manufacture [`DeleteParametersOutput`](crate::output::DeleteParametersOutput)
    pub fn builder() -> crate::output::delete_parameters_output::Builder {
        crate::output::delete_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteParameterOutput {}
impl std::fmt::Debug for DeleteParameterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteParameterOutput");
        formatter.finish()
    }
}
/// See [`DeleteParameterOutput`](crate::output::DeleteParameterOutput)
pub mod delete_parameter_output {
    /// A builder for [`DeleteParameterOutput`](crate::output::DeleteParameterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteParameterOutput`](crate::output::DeleteParameterOutput)
        pub fn build(self) -> crate::output::DeleteParameterOutput {
            crate::output::DeleteParameterOutput {}
        }
    }
}
impl DeleteParameterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteParameterOutput`](crate::output::DeleteParameterOutput)
    pub fn builder() -> crate::output::delete_parameter_output::Builder {
        crate::output::delete_parameter_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOpsMetadataOutput {}
impl std::fmt::Debug for DeleteOpsMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOpsMetadataOutput");
        formatter.finish()
    }
}
/// See [`DeleteOpsMetadataOutput`](crate::output::DeleteOpsMetadataOutput)
pub mod delete_ops_metadata_output {
    /// A builder for [`DeleteOpsMetadataOutput`](crate::output::DeleteOpsMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOpsMetadataOutput`](crate::output::DeleteOpsMetadataOutput)
        pub fn build(self) -> crate::output::DeleteOpsMetadataOutput {
            crate::output::DeleteOpsMetadataOutput {}
        }
    }
}
impl DeleteOpsMetadataOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOpsMetadataOutput`](crate::output::DeleteOpsMetadataOutput)
    pub fn builder() -> crate::output::delete_ops_metadata_output::Builder {
        crate::output::delete_ops_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMaintenanceWindowOutput {
    /// <p>The ID of the deleted maintenance window.</p>
    pub window_id: std::option::Option<std::string::String>,
}
impl DeleteMaintenanceWindowOutput {
    /// <p>The ID of the deleted maintenance window.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMaintenanceWindowOutput");
        formatter.field("window_id", &self.window_id);
        formatter.finish()
    }
}
/// See [`DeleteMaintenanceWindowOutput`](crate::output::DeleteMaintenanceWindowOutput)
pub mod delete_maintenance_window_output {
    /// A builder for [`DeleteMaintenanceWindowOutput`](crate::output::DeleteMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deleted maintenance window.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the deleted maintenance window.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMaintenanceWindowOutput`](crate::output::DeleteMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::DeleteMaintenanceWindowOutput {
            crate::output::DeleteMaintenanceWindowOutput {
                window_id: self.window_id,
            }
        }
    }
}
impl DeleteMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMaintenanceWindowOutput`](crate::output::DeleteMaintenanceWindowOutput)
    pub fn builder() -> crate::output::delete_maintenance_window_output::Builder {
        crate::output::delete_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInventoryOutput {
    /// <p>Every <code>DeleteInventory</code> operation is assigned a unique ID. This option returns a unique ID. You can use this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has completed before you begin other operations. </p>
    pub deletion_id: std::option::Option<std::string::String>,
    /// <p>The name of the inventory data type specified in the request.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>A summary of the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary">Deleting custom inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub deletion_summary: std::option::Option<crate::model::InventoryDeletionSummary>,
}
impl DeleteInventoryOutput {
    /// <p>Every <code>DeleteInventory</code> operation is assigned a unique ID. This option returns a unique ID. You can use this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has completed before you begin other operations. </p>
    pub fn deletion_id(&self) -> std::option::Option<&str> {
        self.deletion_id.as_deref()
    }
    /// <p>The name of the inventory data type specified in the request.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>A summary of the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary">Deleting custom inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub fn deletion_summary(&self) -> std::option::Option<&crate::model::InventoryDeletionSummary> {
        self.deletion_summary.as_ref()
    }
}
impl std::fmt::Debug for DeleteInventoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInventoryOutput");
        formatter.field("deletion_id", &self.deletion_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("deletion_summary", &self.deletion_summary);
        formatter.finish()
    }
}
/// See [`DeleteInventoryOutput`](crate::output::DeleteInventoryOutput)
pub mod delete_inventory_output {
    /// A builder for [`DeleteInventoryOutput`](crate::output::DeleteInventoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deletion_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) deletion_summary: std::option::Option<crate::model::InventoryDeletionSummary>,
    }
    impl Builder {
        /// <p>Every <code>DeleteInventory</code> operation is assigned a unique ID. This option returns a unique ID. You can use this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has completed before you begin other operations. </p>
        pub fn deletion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deletion_id = Some(input.into());
            self
        }
        /// <p>Every <code>DeleteInventory</code> operation is assigned a unique ID. This option returns a unique ID. You can use this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has completed before you begin other operations. </p>
        pub fn set_deletion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.deletion_id = input;
            self
        }
        /// <p>The name of the inventory data type specified in the request.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the inventory data type specified in the request.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>A summary of the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary">Deleting custom inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn deletion_summary(mut self, input: crate::model::InventoryDeletionSummary) -> Self {
            self.deletion_summary = Some(input);
            self
        }
        /// <p>A summary of the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary">Deleting custom inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_deletion_summary(
            mut self,
            input: std::option::Option<crate::model::InventoryDeletionSummary>,
        ) -> Self {
            self.deletion_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInventoryOutput`](crate::output::DeleteInventoryOutput)
        pub fn build(self) -> crate::output::DeleteInventoryOutput {
            crate::output::DeleteInventoryOutput {
                deletion_id: self.deletion_id,
                type_name: self.type_name,
                deletion_summary: self.deletion_summary,
            }
        }
    }
}
impl DeleteInventoryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInventoryOutput`](crate::output::DeleteInventoryOutput)
    pub fn builder() -> crate::output::delete_inventory_output::Builder {
        crate::output::delete_inventory_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDocumentOutput {}
impl std::fmt::Debug for DeleteDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDocumentOutput");
        formatter.finish()
    }
}
/// See [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
pub mod delete_document_output {
    /// A builder for [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
        pub fn build(self) -> crate::output::DeleteDocumentOutput {
            crate::output::DeleteDocumentOutput {}
        }
    }
}
impl DeleteDocumentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)
    pub fn builder() -> crate::output::delete_document_output::Builder {
        crate::output::delete_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssociationOutput {}
impl std::fmt::Debug for DeleteAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssociationOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssociationOutput`](crate::output::DeleteAssociationOutput)
pub mod delete_association_output {
    /// A builder for [`DeleteAssociationOutput`](crate::output::DeleteAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssociationOutput`](crate::output::DeleteAssociationOutput)
        pub fn build(self) -> crate::output::DeleteAssociationOutput {
            crate::output::DeleteAssociationOutput {}
        }
    }
}
impl DeleteAssociationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssociationOutput`](crate::output::DeleteAssociationOutput)
    pub fn builder() -> crate::output::delete_association_output::Builder {
        crate::output::delete_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteActivationOutput {}
impl std::fmt::Debug for DeleteActivationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteActivationOutput");
        formatter.finish()
    }
}
/// See [`DeleteActivationOutput`](crate::output::DeleteActivationOutput)
pub mod delete_activation_output {
    /// A builder for [`DeleteActivationOutput`](crate::output::DeleteActivationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteActivationOutput`](crate::output::DeleteActivationOutput)
        pub fn build(self) -> crate::output::DeleteActivationOutput {
            crate::output::DeleteActivationOutput {}
        }
    }
}
impl DeleteActivationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteActivationOutput`](crate::output::DeleteActivationOutput)
    pub fn builder() -> crate::output::delete_activation_output::Builder {
        crate::output::delete_activation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceDataSyncOutput {}
impl std::fmt::Debug for CreateResourceDataSyncOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceDataSyncOutput");
        formatter.finish()
    }
}
/// See [`CreateResourceDataSyncOutput`](crate::output::CreateResourceDataSyncOutput)
pub mod create_resource_data_sync_output {
    /// A builder for [`CreateResourceDataSyncOutput`](crate::output::CreateResourceDataSyncOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateResourceDataSyncOutput`](crate::output::CreateResourceDataSyncOutput)
        pub fn build(self) -> crate::output::CreateResourceDataSyncOutput {
            crate::output::CreateResourceDataSyncOutput {}
        }
    }
}
impl CreateResourceDataSyncOutput {
    /// Creates a new builder-style object to manufacture [`CreateResourceDataSyncOutput`](crate::output::CreateResourceDataSyncOutput)
    pub fn builder() -> crate::output::create_resource_data_sync_output::Builder {
        crate::output::create_resource_data_sync_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePatchBaselineOutput {
    /// <p>The ID of the created patch baseline.</p>
    pub baseline_id: std::option::Option<std::string::String>,
}
impl CreatePatchBaselineOutput {
    /// <p>The ID of the created patch baseline.</p>
    pub fn baseline_id(&self) -> std::option::Option<&str> {
        self.baseline_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePatchBaselineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePatchBaselineOutput");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.finish()
    }
}
/// See [`CreatePatchBaselineOutput`](crate::output::CreatePatchBaselineOutput)
pub mod create_patch_baseline_output {
    /// A builder for [`CreatePatchBaselineOutput`](crate::output::CreatePatchBaselineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the created patch baseline.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the created patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePatchBaselineOutput`](crate::output::CreatePatchBaselineOutput)
        pub fn build(self) -> crate::output::CreatePatchBaselineOutput {
            crate::output::CreatePatchBaselineOutput {
                baseline_id: self.baseline_id,
            }
        }
    }
}
impl CreatePatchBaselineOutput {
    /// Creates a new builder-style object to manufacture [`CreatePatchBaselineOutput`](crate::output::CreatePatchBaselineOutput)
    pub fn builder() -> crate::output::create_patch_baseline_output::Builder {
        crate::output::create_patch_baseline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOpsMetadataOutput {
    /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.</p>
    pub ops_metadata_arn: std::option::Option<std::string::String>,
}
impl CreateOpsMetadataOutput {
    /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.</p>
    pub fn ops_metadata_arn(&self) -> std::option::Option<&str> {
        self.ops_metadata_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateOpsMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOpsMetadataOutput");
        formatter.field("ops_metadata_arn", &self.ops_metadata_arn);
        formatter.finish()
    }
}
/// See [`CreateOpsMetadataOutput`](crate::output::CreateOpsMetadataOutput)
pub mod create_ops_metadata_output {
    /// A builder for [`CreateOpsMetadataOutput`](crate::output::CreateOpsMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_metadata_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.</p>
        pub fn ops_metadata_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_metadata_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_metadata_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOpsMetadataOutput`](crate::output::CreateOpsMetadataOutput)
        pub fn build(self) -> crate::output::CreateOpsMetadataOutput {
            crate::output::CreateOpsMetadataOutput {
                ops_metadata_arn: self.ops_metadata_arn,
            }
        }
    }
}
impl CreateOpsMetadataOutput {
    /// Creates a new builder-style object to manufacture [`CreateOpsMetadataOutput`](crate::output::CreateOpsMetadataOutput)
    pub fn builder() -> crate::output::create_ops_metadata_output::Builder {
        crate::output::create_ops_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOpsItemOutput {
    /// <p>The ID of the OpsItem.</p>
    pub ops_item_id: std::option::Option<std::string::String>,
}
impl CreateOpsItemOutput {
    /// <p>The ID of the OpsItem.</p>
    pub fn ops_item_id(&self) -> std::option::Option<&str> {
        self.ops_item_id.as_deref()
    }
}
impl std::fmt::Debug for CreateOpsItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOpsItemOutput");
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.finish()
    }
}
/// See [`CreateOpsItemOutput`](crate::output::CreateOpsItemOutput)
pub mod create_ops_item_output {
    /// A builder for [`CreateOpsItemOutput`](crate::output::CreateOpsItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the OpsItem.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOpsItemOutput`](crate::output::CreateOpsItemOutput)
        pub fn build(self) -> crate::output::CreateOpsItemOutput {
            crate::output::CreateOpsItemOutput {
                ops_item_id: self.ops_item_id,
            }
        }
    }
}
impl CreateOpsItemOutput {
    /// Creates a new builder-style object to manufacture [`CreateOpsItemOutput`](crate::output::CreateOpsItemOutput)
    pub fn builder() -> crate::output::create_ops_item_output::Builder {
        crate::output::create_ops_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMaintenanceWindowOutput {
    /// <p>The ID of the created maintenance window.</p>
    pub window_id: std::option::Option<std::string::String>,
}
impl CreateMaintenanceWindowOutput {
    /// <p>The ID of the created maintenance window.</p>
    pub fn window_id(&self) -> std::option::Option<&str> {
        self.window_id.as_deref()
    }
}
impl std::fmt::Debug for CreateMaintenanceWindowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMaintenanceWindowOutput");
        formatter.field("window_id", &self.window_id);
        formatter.finish()
    }
}
/// See [`CreateMaintenanceWindowOutput`](crate::output::CreateMaintenanceWindowOutput)
pub mod create_maintenance_window_output {
    /// A builder for [`CreateMaintenanceWindowOutput`](crate::output::CreateMaintenanceWindowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the created maintenance window.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the created maintenance window.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMaintenanceWindowOutput`](crate::output::CreateMaintenanceWindowOutput)
        pub fn build(self) -> crate::output::CreateMaintenanceWindowOutput {
            crate::output::CreateMaintenanceWindowOutput {
                window_id: self.window_id,
            }
        }
    }
}
impl CreateMaintenanceWindowOutput {
    /// Creates a new builder-style object to manufacture [`CreateMaintenanceWindowOutput`](crate::output::CreateMaintenanceWindowOutput)
    pub fn builder() -> crate::output::create_maintenance_window_output::Builder {
        crate::output::create_maintenance_window_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDocumentOutput {
    /// <p>Information about the SSM document.</p>
    pub document_description: std::option::Option<crate::model::DocumentDescription>,
}
impl CreateDocumentOutput {
    /// <p>Information about the SSM document.</p>
    pub fn document_description(&self) -> std::option::Option<&crate::model::DocumentDescription> {
        self.document_description.as_ref()
    }
}
impl std::fmt::Debug for CreateDocumentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDocumentOutput");
        formatter.field("document_description", &self.document_description);
        formatter.finish()
    }
}
/// See [`CreateDocumentOutput`](crate::output::CreateDocumentOutput)
pub mod create_document_output {
    /// A builder for [`CreateDocumentOutput`](crate::output::CreateDocumentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_description: std::option::Option<crate::model::DocumentDescription>,
    }
    impl Builder {
        /// <p>Information about the SSM document.</p>
        pub fn document_description(mut self, input: crate::model::DocumentDescription) -> Self {
            self.document_description = Some(input);
            self
        }
        /// <p>Information about the SSM document.</p>
        pub fn set_document_description(
            mut self,
            input: std::option::Option<crate::model::DocumentDescription>,
        ) -> Self {
            self.document_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDocumentOutput`](crate::output::CreateDocumentOutput)
        pub fn build(self) -> crate::output::CreateDocumentOutput {
            crate::output::CreateDocumentOutput {
                document_description: self.document_description,
            }
        }
    }
}
impl CreateDocumentOutput {
    /// Creates a new builder-style object to manufacture [`CreateDocumentOutput`](crate::output::CreateDocumentOutput)
    pub fn builder() -> crate::output::create_document_output::Builder {
        crate::output::create_document_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssociationBatchOutput {
    /// <p>Information about the associations that succeeded.</p>
    pub successful: std::option::Option<std::vec::Vec<crate::model::AssociationDescription>>,
    /// <p>Information about the associations that failed.</p>
    pub failed: std::option::Option<std::vec::Vec<crate::model::FailedCreateAssociation>>,
}
impl CreateAssociationBatchOutput {
    /// <p>Information about the associations that succeeded.</p>
    pub fn successful(&self) -> std::option::Option<&[crate::model::AssociationDescription]> {
        self.successful.as_deref()
    }
    /// <p>Information about the associations that failed.</p>
    pub fn failed(&self) -> std::option::Option<&[crate::model::FailedCreateAssociation]> {
        self.failed.as_deref()
    }
}
impl std::fmt::Debug for CreateAssociationBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssociationBatchOutput");
        formatter.field("successful", &self.successful);
        formatter.field("failed", &self.failed);
        formatter.finish()
    }
}
/// See [`CreateAssociationBatchOutput`](crate::output::CreateAssociationBatchOutput)
pub mod create_association_batch_output {
    /// A builder for [`CreateAssociationBatchOutput`](crate::output::CreateAssociationBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful:
            std::option::Option<std::vec::Vec<crate::model::AssociationDescription>>,
        pub(crate) failed:
            std::option::Option<std::vec::Vec<crate::model::FailedCreateAssociation>>,
    }
    impl Builder {
        /// Appends an item to `successful`.
        ///
        /// To override the contents of this collection use [`set_successful`](Self::set_successful).
        ///
        /// <p>Information about the associations that succeeded.</p>
        pub fn successful(mut self, input: crate::model::AssociationDescription) -> Self {
            let mut v = self.successful.unwrap_or_default();
            v.push(input);
            self.successful = Some(v);
            self
        }
        /// <p>Information about the associations that succeeded.</p>
        pub fn set_successful(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationDescription>>,
        ) -> Self {
            self.successful = input;
            self
        }
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// <p>Information about the associations that failed.</p>
        pub fn failed(mut self, input: crate::model::FailedCreateAssociation) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input);
            self.failed = Some(v);
            self
        }
        /// <p>Information about the associations that failed.</p>
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedCreateAssociation>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssociationBatchOutput`](crate::output::CreateAssociationBatchOutput)
        pub fn build(self) -> crate::output::CreateAssociationBatchOutput {
            crate::output::CreateAssociationBatchOutput {
                successful: self.successful,
                failed: self.failed,
            }
        }
    }
}
impl CreateAssociationBatchOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssociationBatchOutput`](crate::output::CreateAssociationBatchOutput)
    pub fn builder() -> crate::output::create_association_batch_output::Builder {
        crate::output::create_association_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssociationOutput {
    /// <p>Information about the association.</p>
    pub association_description: std::option::Option<crate::model::AssociationDescription>,
}
impl CreateAssociationOutput {
    /// <p>Information about the association.</p>
    pub fn association_description(
        &self,
    ) -> std::option::Option<&crate::model::AssociationDescription> {
        self.association_description.as_ref()
    }
}
impl std::fmt::Debug for CreateAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssociationOutput");
        formatter.field("association_description", &self.association_description);
        formatter.finish()
    }
}
/// See [`CreateAssociationOutput`](crate::output::CreateAssociationOutput)
pub mod create_association_output {
    /// A builder for [`CreateAssociationOutput`](crate::output::CreateAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_description:
            std::option::Option<crate::model::AssociationDescription>,
    }
    impl Builder {
        /// <p>Information about the association.</p>
        pub fn association_description(
            mut self,
            input: crate::model::AssociationDescription,
        ) -> Self {
            self.association_description = Some(input);
            self
        }
        /// <p>Information about the association.</p>
        pub fn set_association_description(
            mut self,
            input: std::option::Option<crate::model::AssociationDescription>,
        ) -> Self {
            self.association_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssociationOutput`](crate::output::CreateAssociationOutput)
        pub fn build(self) -> crate::output::CreateAssociationOutput {
            crate::output::CreateAssociationOutput {
                association_description: self.association_description,
            }
        }
    }
}
impl CreateAssociationOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssociationOutput`](crate::output::CreateAssociationOutput)
    pub fn builder() -> crate::output::create_association_output::Builder {
        crate::output::create_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateActivationOutput {
    /// <p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>
    pub activation_id: std::option::Option<std::string::String>,
    /// <p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>
    pub activation_code: std::option::Option<std::string::String>,
}
impl CreateActivationOutput {
    /// <p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>
    pub fn activation_id(&self) -> std::option::Option<&str> {
        self.activation_id.as_deref()
    }
    /// <p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>
    pub fn activation_code(&self) -> std::option::Option<&str> {
        self.activation_code.as_deref()
    }
}
impl std::fmt::Debug for CreateActivationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateActivationOutput");
        formatter.field("activation_id", &self.activation_id);
        formatter.field("activation_code", &self.activation_code);
        formatter.finish()
    }
}
/// See [`CreateActivationOutput`](crate::output::CreateActivationOutput)
pub mod create_activation_output {
    /// A builder for [`CreateActivationOutput`](crate::output::CreateActivationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activation_id: std::option::Option<std::string::String>,
        pub(crate) activation_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>
        pub fn activation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activation_id = Some(input.into());
            self
        }
        /// <p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>
        pub fn set_activation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activation_id = input;
            self
        }
        /// <p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>
        pub fn activation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.activation_code = Some(input.into());
            self
        }
        /// <p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>
        pub fn set_activation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activation_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateActivationOutput`](crate::output::CreateActivationOutput)
        pub fn build(self) -> crate::output::CreateActivationOutput {
            crate::output::CreateActivationOutput {
                activation_id: self.activation_id,
                activation_code: self.activation_code,
            }
        }
    }
}
impl CreateActivationOutput {
    /// Creates a new builder-style object to manufacture [`CreateActivationOutput`](crate::output::CreateActivationOutput)
    pub fn builder() -> crate::output::create_activation_output::Builder {
        crate::output::create_activation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelMaintenanceWindowExecutionOutput {
    /// <p>The ID of the maintenance window execution that has been stopped.</p>
    pub window_execution_id: std::option::Option<std::string::String>,
}
impl CancelMaintenanceWindowExecutionOutput {
    /// <p>The ID of the maintenance window execution that has been stopped.</p>
    pub fn window_execution_id(&self) -> std::option::Option<&str> {
        self.window_execution_id.as_deref()
    }
}
impl std::fmt::Debug for CancelMaintenanceWindowExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelMaintenanceWindowExecutionOutput");
        formatter.field("window_execution_id", &self.window_execution_id);
        formatter.finish()
    }
}
/// See [`CancelMaintenanceWindowExecutionOutput`](crate::output::CancelMaintenanceWindowExecutionOutput)
pub mod cancel_maintenance_window_execution_output {
    /// A builder for [`CancelMaintenanceWindowExecutionOutput`](crate::output::CancelMaintenanceWindowExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution that has been stopped.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution that has been stopped.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelMaintenanceWindowExecutionOutput`](crate::output::CancelMaintenanceWindowExecutionOutput)
        pub fn build(self) -> crate::output::CancelMaintenanceWindowExecutionOutput {
            crate::output::CancelMaintenanceWindowExecutionOutput {
                window_execution_id: self.window_execution_id,
            }
        }
    }
}
impl CancelMaintenanceWindowExecutionOutput {
    /// Creates a new builder-style object to manufacture [`CancelMaintenanceWindowExecutionOutput`](crate::output::CancelMaintenanceWindowExecutionOutput)
    pub fn builder() -> crate::output::cancel_maintenance_window_execution_output::Builder {
        crate::output::cancel_maintenance_window_execution_output::Builder::default()
    }
}

/// <p>Whether or not the command was successfully canceled. There is no guarantee that a request can be canceled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelCommandOutput {}
impl std::fmt::Debug for CancelCommandOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelCommandOutput");
        formatter.finish()
    }
}
/// See [`CancelCommandOutput`](crate::output::CancelCommandOutput)
pub mod cancel_command_output {
    /// A builder for [`CancelCommandOutput`](crate::output::CancelCommandOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelCommandOutput`](crate::output::CancelCommandOutput)
        pub fn build(self) -> crate::output::CancelCommandOutput {
            crate::output::CancelCommandOutput {}
        }
    }
}
impl CancelCommandOutput {
    /// Creates a new builder-style object to manufacture [`CancelCommandOutput`](crate::output::CancelCommandOutput)
    pub fn builder() -> crate::output::cancel_command_output::Builder {
        crate::output::cancel_command_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateOpsItemRelatedItemOutput {
    /// <p>The association ID.</p>
    pub association_id: std::option::Option<std::string::String>,
}
impl AssociateOpsItemRelatedItemOutput {
    /// <p>The association ID.</p>
    pub fn association_id(&self) -> std::option::Option<&str> {
        self.association_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateOpsItemRelatedItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateOpsItemRelatedItemOutput");
        formatter.field("association_id", &self.association_id);
        formatter.finish()
    }
}
/// See [`AssociateOpsItemRelatedItemOutput`](crate::output::AssociateOpsItemRelatedItemOutput)
pub mod associate_ops_item_related_item_output {
    /// A builder for [`AssociateOpsItemRelatedItemOutput`](crate::output::AssociateOpsItemRelatedItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The association ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateOpsItemRelatedItemOutput`](crate::output::AssociateOpsItemRelatedItemOutput)
        pub fn build(self) -> crate::output::AssociateOpsItemRelatedItemOutput {
            crate::output::AssociateOpsItemRelatedItemOutput {
                association_id: self.association_id,
            }
        }
    }
}
impl AssociateOpsItemRelatedItemOutput {
    /// Creates a new builder-style object to manufacture [`AssociateOpsItemRelatedItemOutput`](crate::output::AssociateOpsItemRelatedItemOutput)
    pub fn builder() -> crate::output::associate_ops_item_related_item_output::Builder {
        crate::output::associate_ops_item_related_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceOutput {}
impl std::fmt::Debug for AddTagsToResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceOutput");
        formatter.finish()
    }
}
/// See [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
pub mod add_tags_to_resource_output {
    /// A builder for [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
        pub fn build(self) -> crate::output::AddTagsToResourceOutput {
            crate::output::AddTagsToResourceOutput {}
        }
    }
}
impl AddTagsToResourceOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    pub fn builder() -> crate::output::add_tags_to_resource_output::Builder {
        crate::output::add_tags_to_resource_output::Builder::default()
    }
}
