// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Simple Systems Manager (SSM)
///
/// Client for invoking operations on Amazon Simple Systems Manager (SSM). Each operation on Amazon Simple Systems Manager (SSM) is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ssm::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ssm::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ssm::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(ResourceTypeForTagging)`](crate::client::fluent_builders::AddTagsToResource::resource_type) / [`set_resource_type(Option<ResourceTypeForTagging>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_type): <p>Specifies the type of resource you are tagging.</p> <note>   <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p>  </note>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_id): <p>The resource ID you want to tag.</p>  <p>Use the ID of the resource. Here are some examples:</p>  <p> <code>MaintenanceWindow</code>: <code>mw-012345abcde</code> </p>  <p> <code>PatchBaseline</code>: <code>pb-012345abcde</code> </p>  <p> <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or <code>/aws/ssm/MyGroup/appmanager</code>.</p>  <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the resource.</p>  <p> <code>ManagedInstance</code>: <code>mi-012345abcde</code> </p> <note>   <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tags): <p>One or more tags. The value parameter is required.</p> <important>   <p>Don't enter personally identifiable information in this field.</p>  </important>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)

    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateOpsItemRelatedItem`](crate::client::fluent_builders::AssociateOpsItemRelatedItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_item_id(impl Into<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::ops_item_id) / [`set_ops_item_id(Option<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::set_ops_item_id): <p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>
    ///   - [`association_type(impl Into<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::association_type) / [`set_association_type(Option<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::set_association_type): <p>The type of association that you want to create between an OpsItem and a resource. OpsCenter supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::set_resource_type): <p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the following types:</p>  <p> <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p>  <p> <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>
    ///   - [`resource_uri(impl Into<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::resource_uri) / [`set_resource_uri(Option<String>)`](crate::client::fluent_builders::AssociateOpsItemRelatedItem::set_resource_uri): <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the OpsItem.</p>
    /// - On success, responds with [`AssociateOpsItemRelatedItemOutput`](crate::output::AssociateOpsItemRelatedItemOutput) with field(s):
    ///   - [`association_id(Option<String>)`](crate::output::AssociateOpsItemRelatedItemOutput::association_id): <p>The association ID.</p>
    /// - On failure, responds with [`SdkError<AssociateOpsItemRelatedItemError>`](crate::error::AssociateOpsItemRelatedItemError)
    pub fn associate_ops_item_related_item(&self) -> fluent_builders::AssociateOpsItemRelatedItem {
        fluent_builders::AssociateOpsItemRelatedItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelCommand`](crate::client::fluent_builders::CancelCommand) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`command_id(impl Into<String>)`](crate::client::fluent_builders::CancelCommand::command_id) / [`set_command_id(Option<String>)`](crate::client::fluent_builders::CancelCommand::set_command_id): <p>The ID of the command you want to cancel.</p>
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::CancelCommand::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CancelCommand::set_instance_ids): <p>(Optional) A list of managed node IDs on which you want to cancel the command. If not provided, the command is canceled on every node on which it was requested.</p>
    /// - On success, responds with [`CancelCommandOutput`](crate::output::CancelCommandOutput)

    /// - On failure, responds with [`SdkError<CancelCommandError>`](crate::error::CancelCommandError)
    pub fn cancel_command(&self) -> fluent_builders::CancelCommand {
        fluent_builders::CancelCommand::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelMaintenanceWindowExecution`](crate::client::fluent_builders::CancelMaintenanceWindowExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_execution_id(impl Into<String>)`](crate::client::fluent_builders::CancelMaintenanceWindowExecution::window_execution_id) / [`set_window_execution_id(Option<String>)`](crate::client::fluent_builders::CancelMaintenanceWindowExecution::set_window_execution_id): <p>The ID of the maintenance window execution to stop.</p>
    /// - On success, responds with [`CancelMaintenanceWindowExecutionOutput`](crate::output::CancelMaintenanceWindowExecutionOutput) with field(s):
    ///   - [`window_execution_id(Option<String>)`](crate::output::CancelMaintenanceWindowExecutionOutput::window_execution_id): <p>The ID of the maintenance window execution that has been stopped.</p>
    /// - On failure, responds with [`SdkError<CancelMaintenanceWindowExecutionError>`](crate::error::CancelMaintenanceWindowExecutionError)
    pub fn cancel_maintenance_window_execution(
        &self,
    ) -> fluent_builders::CancelMaintenanceWindowExecution {
        fluent_builders::CancelMaintenanceWindowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateActivation`](crate::client::fluent_builders::CreateActivation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateActivation::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateActivation::set_description): <p>A user-defined description of the resource that you want to register with Systems Manager. </p> <important>   <p>Don't enter personally identifiable information in this field.</p>  </important>
    ///   - [`default_instance_name(impl Into<String>)`](crate::client::fluent_builders::CreateActivation::default_instance_name) / [`set_default_instance_name(Option<String>)`](crate::client::fluent_builders::CreateActivation::set_default_instance_name): <p>The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p> <important>   <p>Don't enter personally identifiable information in this field.</p>  </important>
    ///   - [`iam_role(impl Into<String>)`](crate::client::fluent_builders::CreateActivation::iam_role) / [`set_iam_role(Option<String>)`](crate::client::fluent_builders::CreateActivation::set_iam_role): <p>The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`registration_limit(i32)`](crate::client::fluent_builders::CreateActivation::registration_limit) / [`set_registration_limit(Option<i32>)`](crate::client::fluent_builders::CreateActivation::set_registration_limit): <p>Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.</p>
    ///   - [`expiration_date(DateTime)`](crate::client::fluent_builders::CreateActivation::expiration_date) / [`set_expiration_date(Option<DateTime>)`](crate::client::fluent_builders::CreateActivation::set_expiration_date): <p>The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires in 24 hours.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateActivation::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateActivation::set_tags): <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>   <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>  </ul> <important>   <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.</p>  </important>  <p>You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed nodes, see <code>AddTagsToResource</code>. For information about how to remove tags from your managed nodes, see <code>RemoveTagsFromResource</code>.</p>
    ///   - [`registration_metadata(Vec<RegistrationMetadataItem>)`](crate::client::fluent_builders::CreateActivation::registration_metadata) / [`set_registration_metadata(Option<Vec<RegistrationMetadataItem>>)`](crate::client::fluent_builders::CreateActivation::set_registration_metadata): <p>Reserved for internal use.</p>
    /// - On success, responds with [`CreateActivationOutput`](crate::output::CreateActivationOutput) with field(s):
    ///   - [`activation_id(Option<String>)`](crate::output::CreateActivationOutput::activation_id): <p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>
    ///   - [`activation_code(Option<String>)`](crate::output::CreateActivationOutput::activation_code): <p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>
    /// - On failure, responds with [`SdkError<CreateActivationError>`](crate::error::CreateActivationError)
    pub fn create_activation(&self) -> fluent_builders::CreateActivation {
        fluent_builders::CreateActivation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssociation`](crate::client::fluent_builders::CreateAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_name): <p>The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.</p>  <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account.</p>  <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:</p>  <p> <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p>  <p>For example:</p>  <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p>  <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_document_version): <p>The document version you want to associate with the target(s). Can be a specific version or the default version.</p> <important>   <p>State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code>.</p>  </important>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_instance_id): <p>The managed node ID.</p> <note>   <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p>  </note>
    ///   - [`parameters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::CreateAssociation::parameters) / [`set_parameters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::CreateAssociation::set_parameters): <p>The parameters for the runtime configuration of the document.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::CreateAssociation::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::CreateAssociation::set_targets): <p>The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all managed nodes in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`schedule_expression(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::schedule_expression) / [`set_schedule_expression(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_schedule_expression): <p>A cron expression when the association will be applied to the target(s).</p>
    ///   - [`output_location(InstanceAssociationOutputLocation)`](crate::client::fluent_builders::CreateAssociation::output_location) / [`set_output_location(Option<InstanceAssociationOutputLocation>)`](crate::client::fluent_builders::CreateAssociation::set_output_location): <p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.</p>
    ///   - [`association_name(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::association_name) / [`set_association_name(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_association_name): <p>Specify a descriptive name for the association.</p>
    ///   - [`automation_target_parameter_name(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::automation_target_parameter_name) / [`set_automation_target_parameter_name(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_automation_target_parameter_name): <p>Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>
    ///   - [`max_errors(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::max_errors) / [`set_max_errors(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_max_errors): <p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p>  <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>
    ///   - [`max_concurrency(impl Into<String>)`](crate::client::fluent_builders::CreateAssociation::max_concurrency) / [`set_max_concurrency(Option<String>)`](crate::client::fluent_builders::CreateAssociation::set_max_concurrency): <p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p>  <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>
    ///   - [`compliance_severity(AssociationComplianceSeverity)`](crate::client::fluent_builders::CreateAssociation::compliance_severity) / [`set_compliance_severity(Option<AssociationComplianceSeverity>)`](crate::client::fluent_builders::CreateAssociation::set_compliance_severity): <p>The severity level to assign to the association.</p>
    ///   - [`sync_compliance(AssociationSyncCompliance)`](crate::client::fluent_builders::CreateAssociation::sync_compliance) / [`set_sync_compliance(Option<AssociationSyncCompliance>)`](crate::client::fluent_builders::CreateAssociation::set_sync_compliance): <p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.</p>  <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <code>PutComplianceItems</code> API operation. In this case, compliance data isn't managed by State Manager. It is managed by your direct call to the <code>PutComplianceItems</code> API operation.</p>  <p>By default, all associations use <code>AUTO</code> mode.</p>
    ///   - [`apply_only_at_cron_interval(bool)`](crate::client::fluent_builders::CreateAssociation::apply_only_at_cron_interval) / [`set_apply_only_at_cron_interval(bool)`](crate::client::fluent_builders::CreateAssociation::set_apply_only_at_cron_interval): <p>By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter isn't supported for rate expressions.</p>
    ///   - [`calendar_names(Vec<String>)`](crate::client::fluent_builders::CreateAssociation::calendar_names) / [`set_calendar_names(Option<Vec<String>>)`](crate::client::fluent_builders::CreateAssociation::set_calendar_names): <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>
    ///   - [`target_locations(Vec<TargetLocation>)`](crate::client::fluent_builders::CreateAssociation::target_locations) / [`set_target_locations(Option<Vec<TargetLocation>>)`](crate::client::fluent_builders::CreateAssociation::set_target_locations): <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to create an association in multiple Regions and multiple accounts.</p>
    /// - On success, responds with [`CreateAssociationOutput`](crate::output::CreateAssociationOutput) with field(s):
    ///   - [`association_description(Option<AssociationDescription>)`](crate::output::CreateAssociationOutput::association_description): <p>Information about the association.</p>
    /// - On failure, responds with [`SdkError<CreateAssociationError>`](crate::error::CreateAssociationError)
    pub fn create_association(&self) -> fluent_builders::CreateAssociation {
        fluent_builders::CreateAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssociationBatch`](crate::client::fluent_builders::CreateAssociationBatch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entries(Vec<CreateAssociationBatchRequestEntry>)`](crate::client::fluent_builders::CreateAssociationBatch::entries) / [`set_entries(Option<Vec<CreateAssociationBatchRequestEntry>>)`](crate::client::fluent_builders::CreateAssociationBatch::set_entries): <p>One or more associations.</p>
    /// - On success, responds with [`CreateAssociationBatchOutput`](crate::output::CreateAssociationBatchOutput) with field(s):
    ///   - [`successful(Option<Vec<AssociationDescription>>)`](crate::output::CreateAssociationBatchOutput::successful): <p>Information about the associations that succeeded.</p>
    ///   - [`failed(Option<Vec<FailedCreateAssociation>>)`](crate::output::CreateAssociationBatchOutput::failed): <p>Information about the associations that failed.</p>
    /// - On failure, responds with [`SdkError<CreateAssociationBatchError>`](crate::error::CreateAssociationBatchError)
    pub fn create_association_batch(&self) -> fluent_builders::CreateAssociationBatch {
        fluent_builders::CreateAssociationBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDocument`](crate::client::fluent_builders::CreateDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::CreateDocument::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::CreateDocument::set_content): <p>The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.</p>  <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a> </p> </li>  </ul>
    ///   - [`requires(Vec<DocumentRequires>)`](crate::client::fluent_builders::CreateDocument::requires) / [`set_requires(Option<Vec<DocumentRequires>>)`](crate::client::fluent_builders::CreateDocument::set_requires): <p>A list of SSM documents required by a document. This parameter is used exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the <i>AppConfig User Guide</i>.</p>
    ///   - [`attachments(Vec<AttachmentsSource>)`](crate::client::fluent_builders::CreateDocument::attachments) / [`set_attachments(Option<Vec<AttachmentsSource>>)`](crate::client::fluent_builders::CreateDocument::set_attachments): <p>A list of key-value pairs that describe attachments to a version of a document.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDocument::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDocument::set_name): <p>A name for the SSM document.</p> <important>   <p>You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:</p>   <ul>    <li> <p> <code>aws-</code> </p> </li>    <li> <p> <code>amazon</code> </p> </li>    <li> <p> <code>amzn</code> </p> </li>   </ul>  </important>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateDocument::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateDocument::set_display_name): <p>An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. You can update this value at a later time using the <code>UpdateDocument</code> operation.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::CreateDocument::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::CreateDocument::set_version_name): <p>An optional field specifying the version of the artifact you are creating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
    ///   - [`document_type(DocumentType)`](crate::client::fluent_builders::CreateDocument::document_type) / [`set_document_type(Option<DocumentType>)`](crate::client::fluent_builders::CreateDocument::set_document_type): <p>The type of document to create.</p> <note>   <p>The <code>DeploymentStrategy</code> document type is an internal-use-only document type reserved for AppConfig.</p>  </note>
    ///   - [`document_format(DocumentFormat)`](crate::client::fluent_builders::CreateDocument::document_format) / [`set_document_format(Option<DocumentFormat>)`](crate::client::fluent_builders::CreateDocument::set_document_format): <p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format.</p>
    ///   - [`target_type(impl Into<String>)`](crate::client::fluent_builders::CreateDocument::target_type) / [`set_target_type(Option<String>)`](crate::client::fluent_builders::CreateDocument::set_target_type): <p>Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: <code>/AWS::EC2::Instance</code>. If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDocument::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDocument::set_tags): <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>   <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>  </ul> <note>   <p>To add tags to an existing SSM document, use the <code>AddTagsToResource</code> operation.</p>  </note>
    /// - On success, responds with [`CreateDocumentOutput`](crate::output::CreateDocumentOutput) with field(s):
    ///   - [`document_description(Option<DocumentDescription>)`](crate::output::CreateDocumentOutput::document_description): <p>Information about the SSM document.</p>
    /// - On failure, responds with [`SdkError<CreateDocumentError>`](crate::error::CreateDocumentError)
    pub fn create_document(&self) -> fluent_builders::CreateDocument {
        fluent_builders::CreateDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMaintenanceWindow`](crate::client::fluent_builders::CreateMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_name): <p>The name of the maintenance window.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_description): <p>An optional description for the maintenance window. We recommend specifying a description to help you organize your maintenance windows. </p>
    ///   - [`start_date(impl Into<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::start_date) / [`set_start_date(Option<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_start_date): <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future date.</p>
    ///   - [`end_date(impl Into<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::end_date) / [`set_end_date(Option<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_end_date): <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer run.</p>
    ///   - [`schedule(impl Into<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::schedule) / [`set_schedule(Option<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_schedule): <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    ///   - [`schedule_timezone(impl Into<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::schedule_timezone) / [`set_schedule_timezone(Option<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_schedule_timezone): <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    ///   - [`schedule_offset(i32)`](crate::client::fluent_builders::CreateMaintenanceWindow::schedule_offset) / [`set_schedule_offset(Option<i32>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_schedule_offset): <p>The number of days to wait after the date and time specified by a cron expression before running the maintenance window.</p>  <p>For example, the following cron expression schedules a maintenance window to run on the third Tuesday of every month at 11:30 PM.</p>  <p> <code>cron(30 23 ? * TUE#3 *)</code> </p>  <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.</p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::CreateMaintenanceWindow::duration) / [`set_duration(i32)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_duration): <p>The duration of the maintenance window in hours.</p>
    ///   - [`cutoff(i32)`](crate::client::fluent_builders::CreateMaintenanceWindow::cutoff) / [`set_cutoff(i32)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_cutoff): <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    ///   - [`allow_unassociated_targets(bool)`](crate::client::fluent_builders::CreateMaintenanceWindow::allow_unassociated_targets) / [`set_allow_unassociated_targets(bool)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_allow_unassociated_targets): <p>Enables a maintenance window task to run on managed nodes, even if you haven't registered those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by node ID) when you register a task with the maintenance window.</p>  <p>If you don't enable this option, then you must specify previously-registered targets when you register a task with the maintenance window.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_client_token): <p>User-provided idempotency token.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateMaintenanceWindow::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateMaintenanceWindow::set_tags): <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to identify the type of tasks it will run, the types of targets, and the environment it will run in. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=TaskType,Value=AgentUpdate</code> </p> </li>   <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>   <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>  </ul> <note>   <p>To add tags to an existing maintenance window, use the <code>AddTagsToResource</code> operation.</p>  </note>
    /// - On success, responds with [`CreateMaintenanceWindowOutput`](crate::output::CreateMaintenanceWindowOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::CreateMaintenanceWindowOutput::window_id): <p>The ID of the created maintenance window.</p>
    /// - On failure, responds with [`SdkError<CreateMaintenanceWindowError>`](crate::error::CreateMaintenanceWindowError)
    pub fn create_maintenance_window(&self) -> fluent_builders::CreateMaintenanceWindow {
        fluent_builders::CreateMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOpsItem`](crate::client::fluent_builders::CreateOpsItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateOpsItem::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateOpsItem::set_description): <p>Information about the OpsItem. </p>
    ///   - [`ops_item_type(impl Into<String>)`](crate::client::fluent_builders::CreateOpsItem::ops_item_type) / [`set_ops_item_type(Option<String>)`](crate::client::fluent_builders::CreateOpsItem::set_ops_item_type): <p>The type of OpsItem to create. Currently, the only valid values are <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>
    ///   - [`operational_data(HashMap<String, OpsItemDataValue>)`](crate::client::fluent_builders::CreateOpsItem::operational_data) / [`set_operational_data(Option<HashMap<String, OpsItemDataValue>>)`](crate::client::fluent_builders::CreateOpsItem::set_operational_data): <p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important>   <p>Operational data keys <i>can't</i> begin with the following: <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>, <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>  </important>  <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <code>DescribeOpsItems</code> API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the <code>GetOpsItem</code> API operation).</p>  <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`notifications(Vec<OpsItemNotification>)`](crate::client::fluent_builders::CreateOpsItem::notifications) / [`set_notifications(Option<Vec<OpsItemNotification>>)`](crate::client::fluent_builders::CreateOpsItem::set_notifications): <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::CreateOpsItem::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::CreateOpsItem::set_priority): <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
    ///   - [`related_ops_items(Vec<RelatedOpsItem>)`](crate::client::fluent_builders::CreateOpsItem::related_ops_items) / [`set_related_ops_items(Option<Vec<RelatedOpsItem>>)`](crate::client::fluent_builders::CreateOpsItem::set_related_ops_items): <p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::CreateOpsItem::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::CreateOpsItem::set_source): <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p> <note>   <p>The source name can't contain the following strings: <code>aws</code>, <code>amazon</code>, and <code>amzn</code>. </p>  </note>
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::CreateOpsItem::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::CreateOpsItem::set_title): <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateOpsItem::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateOpsItem::set_tags): <p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>  <p>Tags use a key-value pair. For example:</p>  <p> <code>Key=Department,Value=Finance</code> </p> <important>   <p>To add tags to a new OpsItem, a user must have IAM permissions for both the <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation. To add tags to an existing OpsItem, use the <code>AddTagsToResource</code> operation.</p>  </important>
    ///   - [`category(impl Into<String>)`](crate::client::fluent_builders::CreateOpsItem::category) / [`set_category(Option<String>)`](crate::client::fluent_builders::CreateOpsItem::set_category): <p>Specify a category to assign to an OpsItem. </p>
    ///   - [`severity(impl Into<String>)`](crate::client::fluent_builders::CreateOpsItem::severity) / [`set_severity(Option<String>)`](crate::client::fluent_builders::CreateOpsItem::set_severity): <p>Specify a severity to assign to an OpsItem.</p>
    ///   - [`actual_start_time(DateTime)`](crate::client::fluent_builders::CreateOpsItem::actual_start_time) / [`set_actual_start_time(Option<DateTime>)`](crate::client::fluent_builders::CreateOpsItem::set_actual_start_time): <p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    ///   - [`actual_end_time(DateTime)`](crate::client::fluent_builders::CreateOpsItem::actual_end_time) / [`set_actual_end_time(Option<DateTime>)`](crate::client::fluent_builders::CreateOpsItem::set_actual_end_time): <p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    ///   - [`planned_start_time(DateTime)`](crate::client::fluent_builders::CreateOpsItem::planned_start_time) / [`set_planned_start_time(Option<DateTime>)`](crate::client::fluent_builders::CreateOpsItem::set_planned_start_time): <p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    ///   - [`planned_end_time(DateTime)`](crate::client::fluent_builders::CreateOpsItem::planned_end_time) / [`set_planned_end_time(Option<DateTime>)`](crate::client::fluent_builders::CreateOpsItem::set_planned_end_time): <p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    /// - On success, responds with [`CreateOpsItemOutput`](crate::output::CreateOpsItemOutput) with field(s):
    ///   - [`ops_item_id(Option<String>)`](crate::output::CreateOpsItemOutput::ops_item_id): <p>The ID of the OpsItem.</p>
    /// - On failure, responds with [`SdkError<CreateOpsItemError>`](crate::error::CreateOpsItemError)
    pub fn create_ops_item(&self) -> fluent_builders::CreateOpsItem {
        fluent_builders::CreateOpsItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOpsMetadata`](crate::client::fluent_builders::CreateOpsMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::CreateOpsMetadata::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::CreateOpsMetadata::set_resource_id): <p>A resource ID for a new Application Manager application.</p>
    ///   - [`metadata(HashMap<String, MetadataValue>)`](crate::client::fluent_builders::CreateOpsMetadata::metadata) / [`set_metadata(Option<HashMap<String, MetadataValue>>)`](crate::client::fluent_builders::CreateOpsMetadata::set_metadata): <p>Metadata for a new Application Manager application. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateOpsMetadata::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateOpsMetadata::set_tags): <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>   <li> <p> <code>Key=Region,Value=us-east-2</code> </p> </li>  </ul>
    /// - On success, responds with [`CreateOpsMetadataOutput`](crate::output::CreateOpsMetadataOutput) with field(s):
    ///   - [`ops_metadata_arn(Option<String>)`](crate::output::CreateOpsMetadataOutput::ops_metadata_arn): <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob created by the call.</p>
    /// - On failure, responds with [`SdkError<CreateOpsMetadataError>`](crate::error::CreateOpsMetadataError)
    pub fn create_ops_metadata(&self) -> fluent_builders::CreateOpsMetadata {
        fluent_builders::CreateOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePatchBaseline`](crate::client::fluent_builders::CreatePatchBaseline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`operating_system(OperatingSystem)`](crate::client::fluent_builders::CreatePatchBaseline::operating_system) / [`set_operating_system(Option<OperatingSystem>)`](crate::client::fluent_builders::CreatePatchBaseline::set_operating_system): <p>Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreatePatchBaseline::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreatePatchBaseline::set_name): <p>The name of the patch baseline.</p>
    ///   - [`global_filters(PatchFilterGroup)`](crate::client::fluent_builders::CreatePatchBaseline::global_filters) / [`set_global_filters(Option<PatchFilterGroup>)`](crate::client::fluent_builders::CreatePatchBaseline::set_global_filters): <p>A set of global filters used to include patches in the baseline.</p>
    ///   - [`approval_rules(PatchRuleGroup)`](crate::client::fluent_builders::CreatePatchBaseline::approval_rules) / [`set_approval_rules(Option<PatchRuleGroup>)`](crate::client::fluent_builders::CreatePatchBaseline::set_approval_rules): <p>A set of rules used to include patches in the baseline.</p>
    ///   - [`approved_patches(Vec<String>)`](crate::client::fluent_builders::CreatePatchBaseline::approved_patches) / [`set_approved_patches(Option<Vec<String>>)`](crate::client::fluent_builders::CreatePatchBaseline::set_approved_patches): <p>A list of explicitly approved patches for the baseline.</p>  <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`approved_patches_compliance_level(PatchComplianceLevel)`](crate::client::fluent_builders::CreatePatchBaseline::approved_patches_compliance_level) / [`set_approved_patches_compliance_level(Option<PatchComplianceLevel>)`](crate::client::fluent_builders::CreatePatchBaseline::set_approved_patches_compliance_level): <p>Defines the compliance level for approved patches. When an approved patch is reported as missing, this value describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.</p>
    ///   - [`approved_patches_enable_non_security(bool)`](crate::client::fluent_builders::CreatePatchBaseline::approved_patches_enable_non_security) / [`set_approved_patches_enable_non_security(Option<bool>)`](crate::client::fluent_builders::CreatePatchBaseline::set_approved_patches_enable_non_security): <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    ///   - [`rejected_patches(Vec<String>)`](crate::client::fluent_builders::CreatePatchBaseline::rejected_patches) / [`set_rejected_patches(Option<Vec<String>>)`](crate::client::fluent_builders::CreatePatchBaseline::set_rejected_patches): <p>A list of explicitly rejected patches for the baseline.</p>  <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`rejected_patches_action(PatchAction)`](crate::client::fluent_builders::CreatePatchBaseline::rejected_patches_action) / [`set_rejected_patches_action(Option<PatchAction>)`](crate::client::fluent_builders::CreatePatchBaseline::set_rejected_patches_action): <p>The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p>  <ul>   <li> <p> <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.</p> </li>   <li> <p> <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as <code>InstalledRejected</code>.</p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePatchBaseline::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePatchBaseline::set_description): <p>A description of the patch baseline.</p>
    ///   - [`sources(Vec<PatchSource>)`](crate::client::fluent_builders::CreatePatchBaseline::sources) / [`set_sources(Option<Vec<PatchSource>>)`](crate::client::fluent_builders::CreatePatchBaseline::set_sources): <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreatePatchBaseline::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreatePatchBaseline::set_client_token): <p>User-provided idempotency token.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreatePatchBaseline::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreatePatchBaseline::set_tags): <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the severity level of patches it specifies and the operating system family it applies to. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=PatchSeverity,Value=Critical</code> </p> </li>   <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>  </ul> <note>   <p>To add tags to an existing patch baseline, use the <code>AddTagsToResource</code> operation.</p>  </note>
    /// - On success, responds with [`CreatePatchBaselineOutput`](crate::output::CreatePatchBaselineOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::CreatePatchBaselineOutput::baseline_id): <p>The ID of the created patch baseline.</p>
    /// - On failure, responds with [`SdkError<CreatePatchBaselineError>`](crate::error::CreatePatchBaselineError)
    pub fn create_patch_baseline(&self) -> fluent_builders::CreatePatchBaseline {
        fluent_builders::CreatePatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourceDataSync`](crate::client::fluent_builders::CreateResourceDataSync) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sync_name(impl Into<String>)`](crate::client::fluent_builders::CreateResourceDataSync::sync_name) / [`set_sync_name(Option<String>)`](crate::client::fluent_builders::CreateResourceDataSync::set_sync_name): <p>A name for the configuration.</p>
    ///   - [`s3_destination(ResourceDataSyncS3Destination)`](crate::client::fluent_builders::CreateResourceDataSync::s3_destination) / [`set_s3_destination(Option<ResourceDataSyncS3Destination>)`](crate::client::fluent_builders::CreateResourceDataSync::set_s3_destination): <p>Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value is SyncToDestination.</p>
    ///   - [`sync_type(impl Into<String>)`](crate::client::fluent_builders::CreateResourceDataSync::sync_type) / [`set_sync_type(Option<String>)`](crate::client::fluent_builders::CreateResourceDataSync::set_sync_type): <p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>
    ///   - [`sync_source(ResourceDataSyncSource)`](crate::client::fluent_builders::CreateResourceDataSync::sync_source) / [`set_sync_source(Option<ResourceDataSyncSource>)`](crate::client::fluent_builders::CreateResourceDataSync::set_sync_source): <p>Specify information about the data sources to synchronize. This parameter is required if the <code>SyncType</code> value is SyncFromSource.</p>
    /// - On success, responds with [`CreateResourceDataSyncOutput`](crate::output::CreateResourceDataSyncOutput)

    /// - On failure, responds with [`SdkError<CreateResourceDataSyncError>`](crate::error::CreateResourceDataSyncError)
    pub fn create_resource_data_sync(&self) -> fluent_builders::CreateResourceDataSync {
        fluent_builders::CreateResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteActivation`](crate::client::fluent_builders::DeleteActivation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`activation_id(impl Into<String>)`](crate::client::fluent_builders::DeleteActivation::activation_id) / [`set_activation_id(Option<String>)`](crate::client::fluent_builders::DeleteActivation::set_activation_id): <p>The ID of the activation that you want to delete.</p>
    /// - On success, responds with [`DeleteActivationOutput`](crate::output::DeleteActivationOutput)

    /// - On failure, responds with [`SdkError<DeleteActivationError>`](crate::error::DeleteActivationError)
    pub fn delete_activation(&self) -> fluent_builders::DeleteActivation {
        fluent_builders::DeleteActivation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssociation`](crate::client::fluent_builders::DeleteAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAssociation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAssociation::set_name): <p>The name of the SSM document.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssociation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteAssociation::set_instance_id): <p>The managed node ID.</p> <note>   <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p>  </note>
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssociation::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DeleteAssociation::set_association_id): <p>The association ID that you want to delete.</p>
    /// - On success, responds with [`DeleteAssociationOutput`](crate::output::DeleteAssociationOutput)

    /// - On failure, responds with [`SdkError<DeleteAssociationError>`](crate::error::DeleteAssociationError)
    pub fn delete_association(&self) -> fluent_builders::DeleteAssociation {
        fluent_builders::DeleteAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDocument`](crate::client::fluent_builders::DeleteDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteDocument::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteDocument::set_name): <p>The name of the document.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::DeleteDocument::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::DeleteDocument::set_document_version): <p>The version of the document that you want to delete. If not provided, all versions of the document are deleted.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDocument::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::DeleteDocument::set_version_name): <p>The version name of the document that you want to delete. If not provided, all versions of the document are deleted.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteDocument::force) / [`set_force(bool)`](crate::client::fluent_builders::DeleteDocument::set_force): <p>Some SSM document types require that you specify a <code>Force</code> flag before you can delete the document. For example, you must specify a <code>Force</code> flag to delete a document of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>
    /// - On success, responds with [`DeleteDocumentOutput`](crate::output::DeleteDocumentOutput)

    /// - On failure, responds with [`SdkError<DeleteDocumentError>`](crate::error::DeleteDocumentError)
    pub fn delete_document(&self) -> fluent_builders::DeleteDocument {
        fluent_builders::DeleteDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInventory`](crate::client::fluent_builders::DeleteInventory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteInventory::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::DeleteInventory::set_type_name): <p>The name of the custom inventory type for which you want to delete either all previously collected data or the inventory type itself. </p>
    ///   - [`schema_delete_option(InventorySchemaDeleteOption)`](crate::client::fluent_builders::DeleteInventory::schema_delete_option) / [`set_schema_delete_option(Option<InventorySchemaDeleteOption>)`](crate::client::fluent_builders::DeleteInventory::set_schema_delete_option): <p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose this option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of the following options:</p>  <p>DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> operation for a version greater than the disabled version.</p>  <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the schema later, if you want.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteInventory::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::DeleteInventory::set_dry_run): <p>Use this option to view a summary of the deletion request without deleting any data or the data type. This option is useful when you only want to understand what will be deleted. Once you validate that the data to be deleted is what you intend to delete, you can run the same command without specifying the <code>DryRun</code> option.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteInventory::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteInventory::set_client_token): <p>User-provided idempotency token.</p>
    /// - On success, responds with [`DeleteInventoryOutput`](crate::output::DeleteInventoryOutput) with field(s):
    ///   - [`deletion_id(Option<String>)`](crate::output::DeleteInventoryOutput::deletion_id): <p>Every <code>DeleteInventory</code> operation is assigned a unique ID. This option returns a unique ID. You can use this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has completed before you begin other operations. </p>
    ///   - [`type_name(Option<String>)`](crate::output::DeleteInventoryOutput::type_name): <p>The name of the inventory data type specified in the request.</p>
    ///   - [`deletion_summary(Option<InventoryDeletionSummary>)`](crate::output::DeleteInventoryOutput::deletion_summary): <p>A summary of the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary">Deleting custom inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// - On failure, responds with [`SdkError<DeleteInventoryError>`](crate::error::DeleteInventoryError)
    pub fn delete_inventory(&self) -> fluent_builders::DeleteInventory {
        fluent_builders::DeleteInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMaintenanceWindow`](crate::client::fluent_builders::DeleteMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMaintenanceWindow::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::DeleteMaintenanceWindow::set_window_id): <p>The ID of the maintenance window to delete.</p>
    /// - On success, responds with [`DeleteMaintenanceWindowOutput`](crate::output::DeleteMaintenanceWindowOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::DeleteMaintenanceWindowOutput::window_id): <p>The ID of the deleted maintenance window.</p>
    /// - On failure, responds with [`SdkError<DeleteMaintenanceWindowError>`](crate::error::DeleteMaintenanceWindowError)
    pub fn delete_maintenance_window(&self) -> fluent_builders::DeleteMaintenanceWindow {
        fluent_builders::DeleteMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOpsMetadata`](crate::client::fluent_builders::DeleteOpsMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_metadata_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteOpsMetadata::ops_metadata_arn) / [`set_ops_metadata_arn(Option<String>)`](crate::client::fluent_builders::DeleteOpsMetadata::set_ops_metadata_arn): <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>
    /// - On success, responds with [`DeleteOpsMetadataOutput`](crate::output::DeleteOpsMetadataOutput)

    /// - On failure, responds with [`SdkError<DeleteOpsMetadataError>`](crate::error::DeleteOpsMetadataError)
    pub fn delete_ops_metadata(&self) -> fluent_builders::DeleteOpsMetadata {
        fluent_builders::DeleteOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteParameter`](crate::client::fluent_builders::DeleteParameter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteParameter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteParameter::set_name): <p>The name of the parameter to delete.</p>
    /// - On success, responds with [`DeleteParameterOutput`](crate::output::DeleteParameterOutput)

    /// - On failure, responds with [`SdkError<DeleteParameterError>`](crate::error::DeleteParameterError)
    pub fn delete_parameter(&self) -> fluent_builders::DeleteParameter {
        fluent_builders::DeleteParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteParameters`](crate::client::fluent_builders::DeleteParameters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DeleteParameters::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteParameters::set_names): <p>The names of the parameters to delete. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>
    /// - On success, responds with [`DeleteParametersOutput`](crate::output::DeleteParametersOutput) with field(s):
    ///   - [`deleted_parameters(Option<Vec<String>>)`](crate::output::DeleteParametersOutput::deleted_parameters): <p>The names of the deleted parameters.</p>
    ///   - [`invalid_parameters(Option<Vec<String>>)`](crate::output::DeleteParametersOutput::invalid_parameters): <p>The names of parameters that weren't deleted because the parameters aren't valid.</p>
    /// - On failure, responds with [`SdkError<DeleteParametersError>`](crate::error::DeleteParametersError)
    pub fn delete_parameters(&self) -> fluent_builders::DeleteParameters {
        fluent_builders::DeleteParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePatchBaseline`](crate::client::fluent_builders::DeletePatchBaseline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`baseline_id(impl Into<String>)`](crate::client::fluent_builders::DeletePatchBaseline::baseline_id) / [`set_baseline_id(Option<String>)`](crate::client::fluent_builders::DeletePatchBaseline::set_baseline_id): <p>The ID of the patch baseline to delete.</p>
    /// - On success, responds with [`DeletePatchBaselineOutput`](crate::output::DeletePatchBaselineOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::DeletePatchBaselineOutput::baseline_id): <p>The ID of the deleted patch baseline.</p>
    /// - On failure, responds with [`SdkError<DeletePatchBaselineError>`](crate::error::DeletePatchBaselineError)
    pub fn delete_patch_baseline(&self) -> fluent_builders::DeletePatchBaseline {
        fluent_builders::DeletePatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourceDataSync`](crate::client::fluent_builders::DeleteResourceDataSync) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sync_name(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceDataSync::sync_name) / [`set_sync_name(Option<String>)`](crate::client::fluent_builders::DeleteResourceDataSync::set_sync_name): <p>The name of the configuration to delete.</p>
    ///   - [`sync_type(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceDataSync::sync_type) / [`set_sync_type(Option<String>)`](crate::client::fluent_builders::DeleteResourceDataSync::set_sync_type): <p>Specify the type of resource data sync to delete.</p>
    /// - On success, responds with [`DeleteResourceDataSyncOutput`](crate::output::DeleteResourceDataSyncOutput)

    /// - On failure, responds with [`SdkError<DeleteResourceDataSyncError>`](crate::error::DeleteResourceDataSyncError)
    pub fn delete_resource_data_sync(&self) -> fluent_builders::DeleteResourceDataSync {
        fluent_builders::DeleteResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterManagedInstance`](crate::client::fluent_builders::DeregisterManagedInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterManagedInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeregisterManagedInstance::set_instance_id): <p>The ID assigned to the managed node when you registered it using the activation process. </p>
    /// - On success, responds with [`DeregisterManagedInstanceOutput`](crate::output::DeregisterManagedInstanceOutput)

    /// - On failure, responds with [`SdkError<DeregisterManagedInstanceError>`](crate::error::DeregisterManagedInstanceError)
    pub fn deregister_managed_instance(&self) -> fluent_builders::DeregisterManagedInstance {
        fluent_builders::DeregisterManagedInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterPatchBaselineForPatchGroup`](crate::client::fluent_builders::DeregisterPatchBaselineForPatchGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`baseline_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterPatchBaselineForPatchGroup::baseline_id) / [`set_baseline_id(Option<String>)`](crate::client::fluent_builders::DeregisterPatchBaselineForPatchGroup::set_baseline_id): <p>The ID of the patch baseline to deregister the patch group from.</p>
    ///   - [`patch_group(impl Into<String>)`](crate::client::fluent_builders::DeregisterPatchBaselineForPatchGroup::patch_group) / [`set_patch_group(Option<String>)`](crate::client::fluent_builders::DeregisterPatchBaselineForPatchGroup::set_patch_group): <p>The name of the patch group that should be deregistered from the patch baseline.</p>
    /// - On success, responds with [`DeregisterPatchBaselineForPatchGroupOutput`](crate::output::DeregisterPatchBaselineForPatchGroupOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::DeregisterPatchBaselineForPatchGroupOutput::baseline_id): <p>The ID of the patch baseline the patch group was deregistered from.</p>
    ///   - [`patch_group(Option<String>)`](crate::output::DeregisterPatchBaselineForPatchGroupOutput::patch_group): <p>The name of the patch group deregistered from the patch baseline.</p>
    /// - On failure, responds with [`SdkError<DeregisterPatchBaselineForPatchGroupError>`](crate::error::DeregisterPatchBaselineForPatchGroupError)
    pub fn deregister_patch_baseline_for_patch_group(
        &self,
    ) -> fluent_builders::DeregisterPatchBaselineForPatchGroup {
        fluent_builders::DeregisterPatchBaselineForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterTargetFromMaintenanceWindow`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow::set_window_id): <p>The ID of the maintenance window the target should be removed from.</p>
    ///   - [`window_target_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow::window_target_id) / [`set_window_target_id(Option<String>)`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow::set_window_target_id): <p>The ID of the target definition to remove.</p>
    ///   - [`safe(bool)`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow::safe) / [`set_safe(Option<bool>)`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow::set_safe): <p>The system checks if the target is being referenced by a task. If the target is being referenced, the system returns an error and doesn't deregister the target from the maintenance window.</p>
    /// - On success, responds with [`DeregisterTargetFromMaintenanceWindowOutput`](crate::output::DeregisterTargetFromMaintenanceWindowOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::DeregisterTargetFromMaintenanceWindowOutput::window_id): <p>The ID of the maintenance window the target was removed from.</p>
    ///   - [`window_target_id(Option<String>)`](crate::output::DeregisterTargetFromMaintenanceWindowOutput::window_target_id): <p>The ID of the removed target definition.</p>
    /// - On failure, responds with [`SdkError<DeregisterTargetFromMaintenanceWindowError>`](crate::error::DeregisterTargetFromMaintenanceWindowError)
    pub fn deregister_target_from_maintenance_window(
        &self,
    ) -> fluent_builders::DeregisterTargetFromMaintenanceWindow {
        fluent_builders::DeregisterTargetFromMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterTaskFromMaintenanceWindow`](crate::client::fluent_builders::DeregisterTaskFromMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterTaskFromMaintenanceWindow::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::DeregisterTaskFromMaintenanceWindow::set_window_id): <p>The ID of the maintenance window the task should be removed from.</p>
    ///   - [`window_task_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterTaskFromMaintenanceWindow::window_task_id) / [`set_window_task_id(Option<String>)`](crate::client::fluent_builders::DeregisterTaskFromMaintenanceWindow::set_window_task_id): <p>The ID of the task to remove from the maintenance window.</p>
    /// - On success, responds with [`DeregisterTaskFromMaintenanceWindowOutput`](crate::output::DeregisterTaskFromMaintenanceWindowOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::DeregisterTaskFromMaintenanceWindowOutput::window_id): <p>The ID of the maintenance window the task was removed from.</p>
    ///   - [`window_task_id(Option<String>)`](crate::output::DeregisterTaskFromMaintenanceWindowOutput::window_task_id): <p>The ID of the task removed from the maintenance window.</p>
    /// - On failure, responds with [`SdkError<DeregisterTaskFromMaintenanceWindowError>`](crate::error::DeregisterTaskFromMaintenanceWindowError)
    pub fn deregister_task_from_maintenance_window(
        &self,
    ) -> fluent_builders::DeregisterTaskFromMaintenanceWindow {
        fluent_builders::DeregisterTaskFromMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeActivations`](crate::client::fluent_builders::DescribeActivations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeActivations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<DescribeActivationsFilter>)`](crate::client::fluent_builders::DescribeActivations::filters) / [`set_filters(Option<Vec<DescribeActivationsFilter>>)`](crate::client::fluent_builders::DescribeActivations::set_filters): <p>A filter to view information about your activations.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeActivations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeActivations::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeActivations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeActivations::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    /// - On success, responds with [`DescribeActivationsOutput`](crate::output::DescribeActivationsOutput) with field(s):
    ///   - [`activation_list(Option<Vec<Activation>>)`](crate::output::DescribeActivationsOutput::activation_list): <p>A list of activations for your Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeActivationsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
    /// - On failure, responds with [`SdkError<DescribeActivationsError>`](crate::error::DescribeActivationsError)
    pub fn describe_activations(&self) -> fluent_builders::DescribeActivations {
        fluent_builders::DescribeActivations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssociation`](crate::client::fluent_builders::DescribeAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeAssociation::set_name): <p>The name of the SSM document.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeAssociation::set_instance_id): <p>The managed node ID.</p>
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociation::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DescribeAssociation::set_association_id): <p>The association ID for which you want information.</p>
    ///   - [`association_version(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociation::association_version) / [`set_association_version(Option<String>)`](crate::client::fluent_builders::DescribeAssociation::set_association_version): <p>Specify the association version to retrieve. To view the latest version, either specify <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all associations for a managed node, use <code>ListAssociations</code>. To get a list of versions for a specific association, use <code>ListAssociationVersions</code>. </p>
    /// - On success, responds with [`DescribeAssociationOutput`](crate::output::DescribeAssociationOutput) with field(s):
    ///   - [`association_description(Option<AssociationDescription>)`](crate::output::DescribeAssociationOutput::association_description): <p>Information about the association.</p>
    /// - On failure, responds with [`SdkError<DescribeAssociationError>`](crate::error::DescribeAssociationError)
    pub fn describe_association(&self) -> fluent_builders::DescribeAssociation {
        fluent_builders::DescribeAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssociationExecutions`](crate::client::fluent_builders::DescribeAssociationExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAssociationExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociationExecutions::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DescribeAssociationExecutions::set_association_id): <p>The association ID for which you want to view execution history details.</p>
    ///   - [`filters(Vec<AssociationExecutionFilter>)`](crate::client::fluent_builders::DescribeAssociationExecutions::filters) / [`set_filters(Option<Vec<AssociationExecutionFilter>>)`](crate::client::fluent_builders::DescribeAssociationExecutions::set_filters): <p>Filters for the request. You can specify the following filters and values.</p>  <p>ExecutionId (EQUAL)</p>  <p>Status (EQUAL)</p>  <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAssociationExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAssociationExecutions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociationExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAssociationExecutions::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    /// - On success, responds with [`DescribeAssociationExecutionsOutput`](crate::output::DescribeAssociationExecutionsOutput) with field(s):
    ///   - [`association_executions(Option<Vec<AssociationExecution>>)`](crate::output::DescribeAssociationExecutionsOutput::association_executions): <p>A list of the executions for the specified association ID.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAssociationExecutionsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<DescribeAssociationExecutionsError>`](crate::error::DescribeAssociationExecutionsError)
    pub fn describe_association_executions(
        &self,
    ) -> fluent_builders::DescribeAssociationExecutions {
        fluent_builders::DescribeAssociationExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssociationExecutionTargets`](crate::client::fluent_builders::DescribeAssociationExecutionTargets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::set_association_id): <p>The association ID that includes the execution for which you want to view details.</p>
    ///   - [`execution_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::execution_id) / [`set_execution_id(Option<String>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::set_execution_id): <p>The execution ID for which you want to view details.</p>
    ///   - [`filters(Vec<AssociationExecutionTargetsFilter>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::filters) / [`set_filters(Option<Vec<AssociationExecutionTargetsFilter>>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::set_filters): <p>Filters for the request. You can specify the following filters and values.</p>  <p>Status (EQUAL)</p>  <p>ResourceId (EQUAL)</p>  <p>ResourceType (EQUAL)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAssociationExecutionTargets::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    /// - On success, responds with [`DescribeAssociationExecutionTargetsOutput`](crate::output::DescribeAssociationExecutionTargetsOutput) with field(s):
    ///   - [`association_execution_targets(Option<Vec<AssociationExecutionTarget>>)`](crate::output::DescribeAssociationExecutionTargetsOutput::association_execution_targets): <p>Information about the execution.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAssociationExecutionTargetsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<DescribeAssociationExecutionTargetsError>`](crate::error::DescribeAssociationExecutionTargetsError)
    pub fn describe_association_execution_targets(
        &self,
    ) -> fluent_builders::DescribeAssociationExecutionTargets {
        fluent_builders::DescribeAssociationExecutionTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAutomationExecutions`](crate::client::fluent_builders::DescribeAutomationExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAutomationExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<AutomationExecutionFilter>)`](crate::client::fluent_builders::DescribeAutomationExecutions::filters) / [`set_filters(Option<Vec<AutomationExecutionFilter>>)`](crate::client::fluent_builders::DescribeAutomationExecutions::set_filters): <p>Filters used to limit the scope of executions that are requested.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAutomationExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAutomationExecutions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAutomationExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAutomationExecutions::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeAutomationExecutionsOutput`](crate::output::DescribeAutomationExecutionsOutput) with field(s):
    ///   - [`automation_execution_metadata_list(Option<Vec<AutomationExecutionMetadata>>)`](crate::output::DescribeAutomationExecutionsOutput::automation_execution_metadata_list): <p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAutomationExecutionsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeAutomationExecutionsError>`](crate::error::DescribeAutomationExecutionsError)
    pub fn describe_automation_executions(&self) -> fluent_builders::DescribeAutomationExecutions {
        fluent_builders::DescribeAutomationExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAutomationStepExecutions`](crate::client::fluent_builders::DescribeAutomationStepExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAutomationStepExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`automation_execution_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::automation_execution_id) / [`set_automation_execution_id(Option<String>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::set_automation_execution_id): <p>The Automation execution ID for which you want step execution descriptions.</p>
    ///   - [`filters(Vec<StepExecutionFilter>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::filters) / [`set_filters(Option<Vec<StepExecutionFilter>>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::set_filters): <p>One or more filters to limit the number of step executions returned by the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::reverse_order) / [`set_reverse_order(Option<bool>)`](crate::client::fluent_builders::DescribeAutomationStepExecutions::set_reverse_order): <p>Indicates whether to list step executions in reverse order by start time. The default value is 'false'.</p>
    /// - On success, responds with [`DescribeAutomationStepExecutionsOutput`](crate::output::DescribeAutomationStepExecutionsOutput) with field(s):
    ///   - [`step_executions(Option<Vec<StepExecution>>)`](crate::output::DescribeAutomationStepExecutionsOutput::step_executions): <p>A list of details about the current state of all steps that make up an execution.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAutomationStepExecutionsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeAutomationStepExecutionsError>`](crate::error::DescribeAutomationStepExecutionsError)
    pub fn describe_automation_step_executions(
        &self,
    ) -> fluent_builders::DescribeAutomationStepExecutions {
        fluent_builders::DescribeAutomationStepExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAvailablePatches`](crate::client::fluent_builders::DescribeAvailablePatches) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAvailablePatches::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<PatchOrchestratorFilter>)`](crate::client::fluent_builders::DescribeAvailablePatches::filters) / [`set_filters(Option<Vec<PatchOrchestratorFilter>>)`](crate::client::fluent_builders::DescribeAvailablePatches::set_filters): <p>Each element in the array is a structure containing a key-value pair.</p>  <p> <b>Windows Server</b> </p>  <p>Supported keys for Windows Server managed node patches include the following:</p>  <ul>   <li> <p> <b> <code>PATCH_SET</code> </b> </p> <p>Sample values: <code>OS</code> | <code>APPLICATION</code> </p> </li>   <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> | <code>MicrosoftDefenderAntivirus</code> </p> </li>   <li> <p> <b> <code>PRODUCT_FAMILY</code> </b> </p> <p>Sample values: <code>Windows</code> | <code>Office</code> </p> </li>   <li> <p> <b> <code>MSRC_SEVERITY</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code> </p> </li>   <li> <p> <b> <code>CLASSIFICATION</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> | <code>DefinitionUpdates</code> </p> </li>   <li> <p> <b> <code>PATCH_ID</code> </b> </p> <p>Sample values: <code>KB123456</code> | <code>KB4516046</code> </p> </li>  </ul>  <p> <b>Linux</b> </p> <important>   <p>When specifying filters for Linux patches, you must specify a key-pair for <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the following command fails:</p>   <p> <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code> </p>   <p>However, the following command succeeds:</p>   <p> <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03 Key=CVE_ID,Values=CVE-2018-3615</code> </p>  </important>  <p>Supported keys for Linux managed node patches include the following:</p>  <ul>   <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code> </p> </li>   <li> <p> <b> <code>NAME</code> </b> </p> <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code> </p> </li>   <li> <p> <b> <code>SEVERITY</code> </b> </p> <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li>   <li> <p> <b> <code>EPOCH</code> </b> </p> <p>Sample values: <code>0</code> | <code>1</code> </p> </li>   <li> <p> <b> <code>VERSION</code> </b> </p> <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code> </p> </li>   <li> <p> <b> <code>RELEASE</code> </b> </p> <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code> </p> </li>   <li> <p> <b> <code>ARCH</code> </b> </p> <p>Sample values: <code>i686</code> | <code>x86_64</code> </p> </li>   <li> <p> <b> <code>REPOSITORY</code> </b> </p> <p>Sample values: <code>Core</code> | <code>Updates</code> </p> </li>   <li> <p> <b> <code>ADVISORY_ID</code> </b> </p> <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code> </p> </li>   <li> <p> <b> <code>CVE_ID</code> </b> </p> <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code> </p> </li>   <li> <p> <b> <code>BUGZILLA_ID</code> </b> </p> <p>Sample values: <code>1463241</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAvailablePatches::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAvailablePatches::set_max_results): <p>The maximum number of patches to return (per page).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAvailablePatches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAvailablePatches::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeAvailablePatchesOutput`](crate::output::DescribeAvailablePatchesOutput) with field(s):
    ///   - [`patches(Option<Vec<Patch>>)`](crate::output::DescribeAvailablePatchesOutput::patches): <p>An array of patches. Each entry in the array is a patch structure.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAvailablePatchesOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeAvailablePatchesError>`](crate::error::DescribeAvailablePatchesError)
    pub fn describe_available_patches(&self) -> fluent_builders::DescribeAvailablePatches {
        fluent_builders::DescribeAvailablePatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDocument`](crate::client::fluent_builders::DescribeDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeDocument::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeDocument::set_name): <p>The name of the SSM document.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::DescribeDocument::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::DescribeDocument::set_document_version): <p>The document version for which you want information. Can be a specific version or the default version.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDocument::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::DescribeDocument::set_version_name): <p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
    /// - On success, responds with [`DescribeDocumentOutput`](crate::output::DescribeDocumentOutput) with field(s):
    ///   - [`document(Option<DocumentDescription>)`](crate::output::DescribeDocumentOutput::document): <p>Information about the SSM document.</p>
    /// - On failure, responds with [`SdkError<DescribeDocumentError>`](crate::error::DescribeDocumentError)
    pub fn describe_document(&self) -> fluent_builders::DescribeDocument {
        fluent_builders::DescribeDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDocumentPermission`](crate::client::fluent_builders::DescribeDocumentPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentPermission::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeDocumentPermission::set_name): <p>The name of the document for which you are the owner.</p>
    ///   - [`permission_type(DocumentPermissionType)`](crate::client::fluent_builders::DescribeDocumentPermission::permission_type) / [`set_permission_type(Option<DocumentPermissionType>)`](crate::client::fluent_builders::DescribeDocumentPermission::set_permission_type): <p>The permission type for the document. The permission type can be <i>Share</i>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDocumentPermission::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDocumentPermission::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDocumentPermission::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDocumentPermission::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeDocumentPermissionOutput`](crate::output::DescribeDocumentPermissionOutput) with field(s):
    ///   - [`account_ids(Option<Vec<String>>)`](crate::output::DescribeDocumentPermissionOutput::account_ids): <p>The account IDs that have permission to use this document. The ID can be either an Amazon Web Services account or <i>All</i>.</p>
    ///   - [`account_sharing_info_list(Option<Vec<AccountSharingInfo>>)`](crate::output::DescribeDocumentPermissionOutput::account_sharing_info_list): <p>A list of Amazon Web Services accounts where the current document is shared and the version shared with each account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDocumentPermissionOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<DescribeDocumentPermissionError>`](crate::error::DescribeDocumentPermissionError)
    pub fn describe_document_permission(&self) -> fluent_builders::DescribeDocumentPermission {
        fluent_builders::DescribeDocumentPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEffectiveInstanceAssociations`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations::set_instance_id): <p>The managed node ID for which you want to view all associations.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeEffectiveInstanceAssociationsOutput`](crate::output::DescribeEffectiveInstanceAssociationsOutput) with field(s):
    ///   - [`associations(Option<Vec<InstanceAssociation>>)`](crate::output::DescribeEffectiveInstanceAssociationsOutput::associations): <p>The associations for the requested managed node.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEffectiveInstanceAssociationsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeEffectiveInstanceAssociationsError>`](crate::error::DescribeEffectiveInstanceAssociationsError)
    pub fn describe_effective_instance_associations(
        &self,
    ) -> fluent_builders::DescribeEffectiveInstanceAssociations {
        fluent_builders::DescribeEffectiveInstanceAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEffectivePatchesForPatchBaseline`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`baseline_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline::baseline_id) / [`set_baseline_id(Option<String>)`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline::set_baseline_id): <p>The ID of the patch baseline to retrieve the effective patches for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline::set_max_results): <p>The maximum number of patches to return (per page).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeEffectivePatchesForPatchBaselineOutput`](crate::output::DescribeEffectivePatchesForPatchBaselineOutput) with field(s):
    ///   - [`effective_patches(Option<Vec<EffectivePatch>>)`](crate::output::DescribeEffectivePatchesForPatchBaselineOutput::effective_patches): <p>An array of patches and patch status.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEffectivePatchesForPatchBaselineOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeEffectivePatchesForPatchBaselineError>`](crate::error::DescribeEffectivePatchesForPatchBaselineError)
    pub fn describe_effective_patches_for_patch_baseline(
        &self,
    ) -> fluent_builders::DescribeEffectivePatchesForPatchBaseline {
        fluent_builders::DescribeEffectivePatchesForPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceAssociationsStatus`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus::set_instance_id): <p>The managed node IDs for which you want association status information.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeInstanceAssociationsStatusOutput`](crate::output::DescribeInstanceAssociationsStatusOutput) with field(s):
    ///   - [`instance_association_status_infos(Option<Vec<InstanceAssociationStatusInfo>>)`](crate::output::DescribeInstanceAssociationsStatusOutput::instance_association_status_infos): <p>Status information about the association.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstanceAssociationsStatusOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceAssociationsStatusError>`](crate::error::DescribeInstanceAssociationsStatusError)
    pub fn describe_instance_associations_status(
        &self,
    ) -> fluent_builders::DescribeInstanceAssociationsStatus {
        fluent_builders::DescribeInstanceAssociationsStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceInformation`](crate::client::fluent_builders::DescribeInstanceInformation) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceInformation::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_information_filter_list(Vec<InstanceInformationFilter>)`](crate::client::fluent_builders::DescribeInstanceInformation::instance_information_filter_list) / [`set_instance_information_filter_list(Option<Vec<InstanceInformationFilter>>)`](crate::client::fluent_builders::DescribeInstanceInformation::set_instance_information_filter_list): <p>This is a legacy method. We recommend that you don't use this method. Instead, use the <code>Filters</code> data type. <code>Filters</code> enables you to return node information by filtering based on tags applied to managed nodes.</p> <note>   <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception error. </p>  </note>
    ///   - [`filters(Vec<InstanceInformationStringFilter>)`](crate::client::fluent_builders::DescribeInstanceInformation::filters) / [`set_filters(Option<Vec<InstanceInformationStringFilter>>)`](crate::client::fluent_builders::DescribeInstanceInformation::set_filters): <p>One or more filters. Use a filter to return a more specific list of managed nodes. You can filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of <code>InstanceInformationFilterList</code>, which is deprecated.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstanceInformation::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstanceInformation::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceInformation::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstanceInformation::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeInstanceInformationOutput`](crate::output::DescribeInstanceInformationOutput) with field(s):
    ///   - [`instance_information_list(Option<Vec<InstanceInformation>>)`](crate::output::DescribeInstanceInformationOutput::instance_information_list): <p>The managed node information list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstanceInformationOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>
    /// - On failure, responds with [`SdkError<DescribeInstanceInformationError>`](crate::error::DescribeInstanceInformationError)
    pub fn describe_instance_information(&self) -> fluent_builders::DescribeInstanceInformation {
        fluent_builders::DescribeInstanceInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstancePatches`](crate::client::fluent_builders::DescribeInstancePatches) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstancePatches::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancePatches::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeInstancePatches::set_instance_id): <p>The ID of the managed node whose patch state information should be retrieved.</p>
    ///   - [`filters(Vec<PatchOrchestratorFilter>)`](crate::client::fluent_builders::DescribeInstancePatches::filters) / [`set_filters(Option<Vec<PatchOrchestratorFilter>>)`](crate::client::fluent_builders::DescribeInstancePatches::set_filters): <p>Each element in the array is a structure containing a key-value pair.</p>  <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p>  <ul>   <li> <p> <b> <code>Classification</code> </b> </p> <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code> </p> </li>   <li> <p> <b> <code>KBId</code> </b> </p> <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code> </p> </li>   <li> <p> <b> <code>Severity</code> </b> </p> <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li>   <li> <p> <b> <code>State</code> </b> </p> <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancePatches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstancePatches::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstancePatches::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstancePatches::set_max_results): <p>The maximum number of patches to return (per page).</p>
    /// - On success, responds with [`DescribeInstancePatchesOutput`](crate::output::DescribeInstancePatchesOutput) with field(s):
    ///   - [`patches(Option<Vec<PatchComplianceData>>)`](crate::output::DescribeInstancePatchesOutput::patches): <p>Each entry in the array is a structure containing:</p>  <ul>   <li> <p>Title (string)</p> </li>   <li> <p>KBId (string)</p> </li>   <li> <p>Classification (string)</p> </li>   <li> <p>Severity (string)</p> </li>   <li> <p>State (string, such as "INSTALLED" or "FAILED")</p> </li>   <li> <p>InstalledTime (DateTime)</p> </li>   <li> <p>InstalledBy (string)</p> </li>  </ul>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstancePatchesOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeInstancePatchesError>`](crate::error::DescribeInstancePatchesError)
    pub fn describe_instance_patches(&self) -> fluent_builders::DescribeInstancePatches {
        fluent_builders::DescribeInstancePatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstancePatchStates`](crate::client::fluent_builders::DescribeInstancePatchStates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstancePatchStates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::DescribeInstancePatchStates::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeInstancePatchStates::set_instance_ids): <p>The ID of the managed node for which patch state information should be retrieved.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancePatchStates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstancePatchStates::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstancePatchStates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstancePatchStates::set_max_results): <p>The maximum number of managed nodes to return (per page).</p>
    /// - On success, responds with [`DescribeInstancePatchStatesOutput`](crate::output::DescribeInstancePatchStatesOutput) with field(s):
    ///   - [`instance_patch_states(Option<Vec<InstancePatchState>>)`](crate::output::DescribeInstancePatchStatesOutput::instance_patch_states): <p>The high-level patch state for the requested managed nodes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstancePatchStatesOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeInstancePatchStatesError>`](crate::error::DescribeInstancePatchStatesError)
    pub fn describe_instance_patch_states(&self) -> fluent_builders::DescribeInstancePatchStates {
        fluent_builders::DescribeInstancePatchStates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstancePatchStatesForPatchGroup`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`patch_group(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::patch_group) / [`set_patch_group(Option<String>)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::set_patch_group): <p>The name of the patch group for which the patch state information should be retrieved.</p>
    ///   - [`filters(Vec<InstancePatchStateFilter>)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::filters) / [`set_filters(Option<Vec<InstancePatchStateFilter>>)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::set_filters): <p>Each entry in the array is a structure containing:</p>  <ul>   <li> <p>Key (string between 1 and 200 characters)</p> </li>   <li> <p>Values (array containing a single string)</p> </li>   <li> <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup::set_max_results): <p>The maximum number of patches to return (per page).</p>
    /// - On success, responds with [`DescribeInstancePatchStatesForPatchGroupOutput`](crate::output::DescribeInstancePatchStatesForPatchGroupOutput) with field(s):
    ///   - [`instance_patch_states(Option<Vec<InstancePatchState>>)`](crate::output::DescribeInstancePatchStatesForPatchGroupOutput::instance_patch_states): <p>The high-level patch state for the requested managed nodes. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstancePatchStatesForPatchGroupOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeInstancePatchStatesForPatchGroupError>`](crate::error::DescribeInstancePatchStatesForPatchGroupError)
    pub fn describe_instance_patch_states_for_patch_group(
        &self,
    ) -> fluent_builders::DescribeInstancePatchStatesForPatchGroup {
        fluent_builders::DescribeInstancePatchStatesForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInventoryDeletions`](crate::client::fluent_builders::DescribeInventoryDeletions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInventoryDeletions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`deletion_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInventoryDeletions::deletion_id) / [`set_deletion_id(Option<String>)`](crate::client::fluent_builders::DescribeInventoryDeletions::set_deletion_id): <p>Specify the delete inventory ID for which you want information. This ID was returned by the <code>DeleteInventory</code> operation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInventoryDeletions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInventoryDeletions::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInventoryDeletions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInventoryDeletions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`DescribeInventoryDeletionsOutput`](crate::output::DescribeInventoryDeletionsOutput) with field(s):
    ///   - [`inventory_deletions(Option<Vec<InventoryDeletionStatusItem>>)`](crate::output::DescribeInventoryDeletionsOutput::inventory_deletions): <p>A list of status items for deleted inventory.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInventoryDeletionsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<DescribeInventoryDeletionsError>`](crate::error::DescribeInventoryDeletionsError)
    pub fn describe_inventory_deletions(&self) -> fluent_builders::DescribeInventoryDeletions {
        fluent_builders::DescribeInventoryDeletions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindowExecutions`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::set_window_id): <p>The ID of the maintenance window whose executions should be retrieved.</p>
    ///   - [`filters(Vec<MaintenanceWindowFilter>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::filters) / [`set_filters(Option<Vec<MaintenanceWindowFilter>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::set_filters): <p>Each entry in the array is a structure containing:</p>  <ul>   <li> <p>Key. A string between 1 and 128 characters. Supported keys include <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p> </li>   <li> <p>Values. An array of strings, each between 1 and 256 characters. Supported values are date/time strings in a valid ISO 8601 date/time format, such as <code>2021-11-04T05:00:00Z</code>.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowExecutionsOutput`](crate::output::DescribeMaintenanceWindowExecutionsOutput) with field(s):
    ///   - [`window_executions(Option<Vec<MaintenanceWindowExecution>>)`](crate::output::DescribeMaintenanceWindowExecutionsOutput::window_executions): <p>Information about the maintenance window executions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowExecutionsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowExecutionsError>`](crate::error::DescribeMaintenanceWindowExecutionsError)
    pub fn describe_maintenance_window_executions(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowExecutions {
        fluent_builders::DescribeMaintenanceWindowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindowExecutionTaskInvocations`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_execution_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::window_execution_id) / [`set_window_execution_id(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::set_window_execution_id): <p>The ID of the maintenance window execution the task is part of.</p>
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::set_task_id): <p>The ID of the specific task in the maintenance window task that should be retrieved.</p>
    ///   - [`filters(Vec<MaintenanceWindowFilter>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::filters) / [`set_filters(Option<Vec<MaintenanceWindowFilter>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::set_filters): <p>Optional filters used to scope down the returned task invocations. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowExecutionTaskInvocationsOutput`](crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput) with field(s):
    ///   - [`window_execution_task_invocation_identities(Option<Vec<MaintenanceWindowExecutionTaskInvocationIdentity>>)`](crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput::window_execution_task_invocation_identities): <p>Information about the task invocation results per invocation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowExecutionTaskInvocationsError>`](crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsError)
    pub fn describe_maintenance_window_execution_task_invocations(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations {
        fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindowExecutionTasks`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_execution_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::window_execution_id) / [`set_window_execution_id(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::set_window_execution_id): <p>The ID of the maintenance window execution whose task executions should be retrieved.</p>
    ///   - [`filters(Vec<MaintenanceWindowFilter>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::filters) / [`set_filters(Option<Vec<MaintenanceWindowFilter>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::set_filters): <p>Optional filters used to scope down the returned tasks. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowExecutionTasksOutput`](crate::output::DescribeMaintenanceWindowExecutionTasksOutput) with field(s):
    ///   - [`window_execution_task_identities(Option<Vec<MaintenanceWindowExecutionTaskIdentity>>)`](crate::output::DescribeMaintenanceWindowExecutionTasksOutput::window_execution_task_identities): <p>Information about the task executions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowExecutionTasksOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowExecutionTasksError>`](crate::error::DescribeMaintenanceWindowExecutionTasksError)
    pub fn describe_maintenance_window_execution_tasks(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowExecutionTasks {
        fluent_builders::DescribeMaintenanceWindowExecutionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindows`](crate::client::fluent_builders::DescribeMaintenanceWindows) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindows::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<MaintenanceWindowFilter>)`](crate::client::fluent_builders::DescribeMaintenanceWindows::filters) / [`set_filters(Option<Vec<MaintenanceWindowFilter>>)`](crate::client::fluent_builders::DescribeMaintenanceWindows::set_filters): <p>Optional filters used to narrow down the scope of the returned maintenance windows. Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example, <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindows::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindows::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindows::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowsOutput`](crate::output::DescribeMaintenanceWindowsOutput) with field(s):
    ///   - [`window_identities(Option<Vec<MaintenanceWindowIdentity>>)`](crate::output::DescribeMaintenanceWindowsOutput::window_identities): <p>Information about the maintenance windows.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowsError>`](crate::error::DescribeMaintenanceWindowsError)
    pub fn describe_maintenance_windows(&self) -> fluent_builders::DescribeMaintenanceWindows {
        fluent_builders::DescribeMaintenanceWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindowSchedule`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::set_window_id): <p>The ID of the maintenance window to retrieve information about.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::set_targets): <p>The managed node ID or key-value pair to retrieve information about.</p>
    ///   - [`resource_type(MaintenanceWindowResourceType)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::resource_type) / [`set_resource_type(Option<MaintenanceWindowResourceType>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::set_resource_type): <p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>
    ///   - [`filters(Vec<PatchOrchestratorFilter>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::filters) / [`set_filters(Option<Vec<PatchOrchestratorFilter>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::set_filters): <p>Filters used to limit the range of results. For example, you can limit maintenance window executions to only those scheduled before or after a certain date and time.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowScheduleOutput`](crate::output::DescribeMaintenanceWindowScheduleOutput) with field(s):
    ///   - [`scheduled_window_executions(Option<Vec<ScheduledWindowExecution>>)`](crate::output::DescribeMaintenanceWindowScheduleOutput::scheduled_window_executions): <p>Information about maintenance window executions scheduled for the specified time range.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowScheduleOutput::next_token): <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowScheduleError>`](crate::error::DescribeMaintenanceWindowScheduleError)
    pub fn describe_maintenance_window_schedule(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowSchedule {
        fluent_builders::DescribeMaintenanceWindowSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindowsForTarget`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::set_targets): <p>The managed node ID or key-value pair to retrieve information about.</p>
    ///   - [`resource_type(MaintenanceWindowResourceType)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::resource_type) / [`set_resource_type(Option<MaintenanceWindowResourceType>)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::set_resource_type): <p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowsForTargetOutput`](crate::output::DescribeMaintenanceWindowsForTargetOutput) with field(s):
    ///   - [`window_identities(Option<Vec<MaintenanceWindowIdentityForTarget>>)`](crate::output::DescribeMaintenanceWindowsForTargetOutput::window_identities): <p>Information about the maintenance window targets and tasks a managed node is associated with.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowsForTargetOutput::next_token): <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowsForTargetError>`](crate::error::DescribeMaintenanceWindowsForTargetError)
    pub fn describe_maintenance_windows_for_target(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowsForTarget {
        fluent_builders::DescribeMaintenanceWindowsForTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindowTargets`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::set_window_id): <p>The ID of the maintenance window whose targets should be retrieved.</p>
    ///   - [`filters(Vec<MaintenanceWindowFilter>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::filters) / [`set_filters(Option<Vec<MaintenanceWindowFilter>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::set_filters): <p>Optional filters that can be used to narrow down the scope of the returned window targets. The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and <code>OwnerInformation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowTargetsOutput`](crate::output::DescribeMaintenanceWindowTargetsOutput) with field(s):
    ///   - [`targets(Option<Vec<MaintenanceWindowTarget>>)`](crate::output::DescribeMaintenanceWindowTargetsOutput::targets): <p>Information about the targets in the maintenance window.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowTargetsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowTargetsError>`](crate::error::DescribeMaintenanceWindowTargetsError)
    pub fn describe_maintenance_window_targets(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowTargets {
        fluent_builders::DescribeMaintenanceWindowTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMaintenanceWindowTasks`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::set_window_id): <p>The ID of the maintenance window whose tasks should be retrieved.</p>
    ///   - [`filters(Vec<MaintenanceWindowFilter>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::filters) / [`set_filters(Option<Vec<MaintenanceWindowFilter>>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::set_filters): <p>Optional filters used to narrow down the scope of the returned tasks. The supported filter keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and <code>TaskType</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeMaintenanceWindowTasksOutput`](crate::output::DescribeMaintenanceWindowTasksOutput) with field(s):
    ///   - [`tasks(Option<Vec<MaintenanceWindowTask>>)`](crate::output::DescribeMaintenanceWindowTasksOutput::tasks): <p>Information about the tasks in the maintenance window.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMaintenanceWindowTasksOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribeMaintenanceWindowTasksError>`](crate::error::DescribeMaintenanceWindowTasksError)
    pub fn describe_maintenance_window_tasks(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowTasks {
        fluent_builders::DescribeMaintenanceWindowTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOpsItems`](crate::client::fluent_builders::DescribeOpsItems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOpsItems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_item_filters(Vec<OpsItemFilter>)`](crate::client::fluent_builders::DescribeOpsItems::ops_item_filters) / [`set_ops_item_filters(Option<Vec<OpsItemFilter>>)`](crate::client::fluent_builders::DescribeOpsItems::set_ops_item_filters): <p>One or more filters to limit the response.</p>  <ul>   <li> <p>Key: CreatedTime</p> <p>Operations: GreaterThan, LessThan</p> </li>   <li> <p>Key: LastModifiedBy</p> <p>Operations: Contains, Equals</p> </li>   <li> <p>Key: LastModifiedTime</p> <p>Operations: GreaterThan, LessThan</p> </li>   <li> <p>Key: Priority</p> <p>Operations: Equals</p> </li>   <li> <p>Key: Source</p> <p>Operations: Contains, Equals</p> </li>   <li> <p>Key: Status</p> <p>Operations: Equals</p> </li>   <li> <p>Key: Title*</p> <p>Operations: Equals,Contains</p> </li>   <li> <p>Key: OperationalData**</p> <p>Operations: Equals</p> </li>   <li> <p>Key: OperationalDataKey</p> <p>Operations: Equals</p> </li>   <li> <p>Key: OperationalDataValue</p> <p>Operations: Equals, Contains</p> </li>   <li> <p>Key: OpsItemId</p> <p>Operations: Equals</p> </li>   <li> <p>Key: ResourceId</p> <p>Operations: Contains</p> </li>   <li> <p>Key: AutomationId</p> <p>Operations: Equals</p> </li>  </ul>  <p>*The Equals operator for Title matches the first 100 characters. If you specify more than 100 characters, they system returns an error that the filter value exceeds the length limit.</p>  <p>**If you filter the response by using the OperationalData operator, specify a key-value pair by using the following JSON format: {"key":"key_name","value":"a_value"}</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeOpsItems::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeOpsItems::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeOpsItems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeOpsItems::set_next_token): <p>A token to start the list. Use this token to get the next set of results.</p>
    /// - On success, responds with [`DescribeOpsItemsOutput`](crate::output::DescribeOpsItemsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeOpsItemsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    ///   - [`ops_item_summaries(Option<Vec<OpsItemSummary>>)`](crate::output::DescribeOpsItemsOutput::ops_item_summaries): <p>A list of OpsItems.</p>
    /// - On failure, responds with [`SdkError<DescribeOpsItemsError>`](crate::error::DescribeOpsItemsError)
    pub fn describe_ops_items(&self) -> fluent_builders::DescribeOpsItems {
        fluent_builders::DescribeOpsItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeParameters`](crate::client::fluent_builders::DescribeParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ParametersFilter>)`](crate::client::fluent_builders::DescribeParameters::filters) / [`set_filters(Option<Vec<ParametersFilter>>)`](crate::client::fluent_builders::DescribeParameters::set_filters): <p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>
    ///   - [`parameter_filters(Vec<ParameterStringFilter>)`](crate::client::fluent_builders::DescribeParameters::parameter_filters) / [`set_parameter_filters(Option<Vec<ParameterStringFilter>>)`](crate::client::fluent_builders::DescribeParameters::set_parameter_filters): <p>Filters to limit the request results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeParameters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeParameters::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeParameters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeParameters::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribeParametersOutput`](crate::output::DescribeParametersOutput) with field(s):
    ///   - [`parameters(Option<Vec<ParameterMetadata>>)`](crate::output::DescribeParametersOutput::parameters): <p>Parameters returned by the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeParametersOutput::next_token): <p>The token to use when requesting the next set of items.</p>
    /// - On failure, responds with [`SdkError<DescribeParametersError>`](crate::error::DescribeParametersError)
    pub fn describe_parameters(&self) -> fluent_builders::DescribeParameters {
        fluent_builders::DescribeParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePatchBaselines`](crate::client::fluent_builders::DescribePatchBaselines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePatchBaselines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<PatchOrchestratorFilter>)`](crate::client::fluent_builders::DescribePatchBaselines::filters) / [`set_filters(Option<Vec<PatchOrchestratorFilter>>)`](crate::client::fluent_builders::DescribePatchBaselines::set_filters): <p>Each element in the array is a structure containing a key-value pair.</p>  <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p>  <ul>   <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code> </p> </li>   <li> <p> <b> <code>OWNER</code> </b> </p> <p>Sample values: <code>AWS</code> | <code>Self</code> </p> </li>   <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePatchBaselines::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePatchBaselines::set_max_results): <p>The maximum number of patch baselines to return (per page).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePatchBaselines::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePatchBaselines::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribePatchBaselinesOutput`](crate::output::DescribePatchBaselinesOutput) with field(s):
    ///   - [`baseline_identities(Option<Vec<PatchBaselineIdentity>>)`](crate::output::DescribePatchBaselinesOutput::baseline_identities): <p>An array of <code>PatchBaselineIdentity</code> elements.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePatchBaselinesOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribePatchBaselinesError>`](crate::error::DescribePatchBaselinesError)
    pub fn describe_patch_baselines(&self) -> fluent_builders::DescribePatchBaselines {
        fluent_builders::DescribePatchBaselines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePatchGroups`](crate::client::fluent_builders::DescribePatchGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePatchGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePatchGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePatchGroups::set_max_results): <p>The maximum number of patch groups to return (per page).</p>
    ///   - [`filters(Vec<PatchOrchestratorFilter>)`](crate::client::fluent_builders::DescribePatchGroups::filters) / [`set_filters(Option<Vec<PatchOrchestratorFilter>>)`](crate::client::fluent_builders::DescribePatchGroups::set_filters): <p>Each element in the array is a structure containing a key-value pair.</p>  <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p>  <ul>   <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p> </li>   <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePatchGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePatchGroups::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribePatchGroupsOutput`](crate::output::DescribePatchGroupsOutput) with field(s):
    ///   - [`mappings(Option<Vec<PatchGroupPatchBaselineMapping>>)`](crate::output::DescribePatchGroupsOutput::mappings): <p>Each entry in the array contains:</p>  <ul>   <li> <p> <code>PatchGroup</code>: string (between 1 and 256 characters. Regex: <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code> </p> </li>   <li> <p> <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.</p> </li>  </ul>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePatchGroupsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<DescribePatchGroupsError>`](crate::error::DescribePatchGroupsError)
    pub fn describe_patch_groups(&self) -> fluent_builders::DescribePatchGroups {
        fluent_builders::DescribePatchGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePatchGroupState`](crate::client::fluent_builders::DescribePatchGroupState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`patch_group(impl Into<String>)`](crate::client::fluent_builders::DescribePatchGroupState::patch_group) / [`set_patch_group(Option<String>)`](crate::client::fluent_builders::DescribePatchGroupState::set_patch_group): <p>The name of the patch group whose patch snapshot should be retrieved.</p>
    /// - On success, responds with [`DescribePatchGroupStateOutput`](crate::output::DescribePatchGroupStateOutput) with field(s):
    ///   - [`instances(i32)`](crate::output::DescribePatchGroupStateOutput::instances): <p>The number of managed nodes in the patch group.</p>
    ///   - [`instances_with_installed_patches(i32)`](crate::output::DescribePatchGroupStateOutput::instances_with_installed_patches): <p>The number of managed nodes with installed patches.</p>
    ///   - [`instances_with_installed_other_patches(i32)`](crate::output::DescribePatchGroupStateOutput::instances_with_installed_other_patches): <p>The number of managed nodes with patches installed that aren't defined in the patch baseline.</p>
    ///   - [`instances_with_installed_pending_reboot_patches(Option<i32>)`](crate::output::DescribePatchGroupStateOutput::instances_with_installed_pending_reboot_patches): <p>The number of managed nodes with patches installed by Patch Manager that haven't been rebooted after the patch installation. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    ///   - [`instances_with_installed_rejected_patches(Option<i32>)`](crate::output::DescribePatchGroupStateOutput::instances_with_installed_rejected_patches): <p>The number of managed nodes with patches installed that are specified in a <code>RejectedPatches</code> list. Patches with a status of <code>INSTALLED_REJECTED</code> were typically installed before they were added to a <code>RejectedPatches</code> list.</p> <note>   <p>If <code>ALLOW_AS_DEPENDENCY</code> is the specified option for <code>RejectedPatchesAction</code>, the value of <code>InstancesWithInstalledRejectedPatches</code> will always be <code>0</code> (zero).</p>  </note>
    ///   - [`instances_with_missing_patches(i32)`](crate::output::DescribePatchGroupStateOutput::instances_with_missing_patches): <p>The number of managed nodes with missing patches from the patch baseline.</p>
    ///   - [`instances_with_failed_patches(i32)`](crate::output::DescribePatchGroupStateOutput::instances_with_failed_patches): <p>The number of managed nodes with patches from the patch baseline that failed to install.</p>
    ///   - [`instances_with_not_applicable_patches(i32)`](crate::output::DescribePatchGroupStateOutput::instances_with_not_applicable_patches): <p>The number of managed nodes with patches that aren't applicable.</p>
    ///   - [`instances_with_unreported_not_applicable_patches(Option<i32>)`](crate::output::DescribePatchGroupStateOutput::instances_with_unreported_not_applicable_patches): <p>The number of managed nodes with <code>NotApplicable</code> patches beyond the supported limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.</p>
    ///   - [`instances_with_critical_non_compliant_patches(Option<i32>)`](crate::output::DescribePatchGroupStateOutput::instances_with_critical_non_compliant_patches): <p>The number of managed nodes where patches that are specified as <code>Critical</code> for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    ///   - [`instances_with_security_non_compliant_patches(Option<i32>)`](crate::output::DescribePatchGroupStateOutput::instances_with_security_non_compliant_patches): <p>The number of managed nodes where patches that are specified as <code>Security</code> in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    ///   - [`instances_with_other_non_compliant_patches(Option<i32>)`](crate::output::DescribePatchGroupStateOutput::instances_with_other_non_compliant_patches): <p>The number of managed nodes with patches installed that are specified as other than <code>Critical</code> or <code>Security</code> but aren't compliant with the patch baseline. The status of these managed nodes is <code>NON_COMPLIANT</code>.</p>
    /// - On failure, responds with [`SdkError<DescribePatchGroupStateError>`](crate::error::DescribePatchGroupStateError)
    pub fn describe_patch_group_state(&self) -> fluent_builders::DescribePatchGroupState {
        fluent_builders::DescribePatchGroupState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePatchProperties`](crate::client::fluent_builders::DescribePatchProperties) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePatchProperties::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`operating_system(OperatingSystem)`](crate::client::fluent_builders::DescribePatchProperties::operating_system) / [`set_operating_system(Option<OperatingSystem>)`](crate::client::fluent_builders::DescribePatchProperties::set_operating_system): <p>The operating system type for which to list patches.</p>
    ///   - [`property(PatchProperty)`](crate::client::fluent_builders::DescribePatchProperties::property) / [`set_property(Option<PatchProperty>)`](crate::client::fluent_builders::DescribePatchProperties::set_property): <p>The patch property for which you want to view patch details. </p>
    ///   - [`patch_set(PatchSet)`](crate::client::fluent_builders::DescribePatchProperties::patch_set) / [`set_patch_set(Option<PatchSet>)`](crate::client::fluent_builders::DescribePatchProperties::set_patch_set): <p>Indicates whether to list patches for the Windows operating system or for applications released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePatchProperties::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePatchProperties::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePatchProperties::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePatchProperties::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`DescribePatchPropertiesOutput`](crate::output::DescribePatchPropertiesOutput) with field(s):
    ///   - [`properties(Option<Vec<HashMap<String, String>>>)`](crate::output::DescribePatchPropertiesOutput::properties): <p>A list of the properties for patches matching the filter request parameters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePatchPropertiesOutput::next_token): <p>The token for the next set of items to return. (You use this token in the next call.)</p>
    /// - On failure, responds with [`SdkError<DescribePatchPropertiesError>`](crate::error::DescribePatchPropertiesError)
    pub fn describe_patch_properties(&self) -> fluent_builders::DescribePatchProperties {
        fluent_builders::DescribePatchProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSessions`](crate::client::fluent_builders::DescribeSessions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSessions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`state(SessionState)`](crate::client::fluent_builders::DescribeSessions::state) / [`set_state(Option<SessionState>)`](crate::client::fluent_builders::DescribeSessions::set_state): <p>The session status to retrieve a list of sessions for. For example, "Active".</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSessions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSessions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSessions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSessions::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`filters(Vec<SessionFilter>)`](crate::client::fluent_builders::DescribeSessions::filters) / [`set_filters(Option<Vec<SessionFilter>>)`](crate::client::fluent_builders::DescribeSessions::set_filters): <p>One or more filters to limit the type of sessions returned by the request.</p>
    /// - On success, responds with [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput) with field(s):
    ///   - [`sessions(Option<Vec<Session>>)`](crate::output::DescribeSessionsOutput::sessions): <p>A list of sessions meeting the request parameters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSessionsOutput::next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On failure, responds with [`SdkError<DescribeSessionsError>`](crate::error::DescribeSessionsError)
    pub fn describe_sessions(&self) -> fluent_builders::DescribeSessions {
        fluent_builders::DescribeSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateOpsItemRelatedItem`](crate::client::fluent_builders::DisassociateOpsItemRelatedItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_item_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateOpsItemRelatedItem::ops_item_id) / [`set_ops_item_id(Option<String>)`](crate::client::fluent_builders::DisassociateOpsItemRelatedItem::set_ops_item_id): <p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a related item.</p>
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateOpsItemRelatedItem::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DisassociateOpsItemRelatedItem::set_association_id): <p>The ID of the association for which you want to delete an association between the OpsItem and a related item.</p>
    /// - On success, responds with [`DisassociateOpsItemRelatedItemOutput`](crate::output::DisassociateOpsItemRelatedItemOutput)

    /// - On failure, responds with [`SdkError<DisassociateOpsItemRelatedItemError>`](crate::error::DisassociateOpsItemRelatedItemError)
    pub fn disassociate_ops_item_related_item(
        &self,
    ) -> fluent_builders::DisassociateOpsItemRelatedItem {
        fluent_builders::DisassociateOpsItemRelatedItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAutomationExecution`](crate::client::fluent_builders::GetAutomationExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`automation_execution_id(impl Into<String>)`](crate::client::fluent_builders::GetAutomationExecution::automation_execution_id) / [`set_automation_execution_id(Option<String>)`](crate::client::fluent_builders::GetAutomationExecution::set_automation_execution_id): <p>The unique identifier for an existing automation execution to examine. The execution ID is returned by StartAutomationExecution when the execution of an Automation runbook is initiated.</p>
    /// - On success, responds with [`GetAutomationExecutionOutput`](crate::output::GetAutomationExecutionOutput) with field(s):
    ///   - [`automation_execution(Option<AutomationExecution>)`](crate::output::GetAutomationExecutionOutput::automation_execution): <p>Detailed information about the current state of an automation execution.</p>
    /// - On failure, responds with [`SdkError<GetAutomationExecutionError>`](crate::error::GetAutomationExecutionError)
    pub fn get_automation_execution(&self) -> fluent_builders::GetAutomationExecution {
        fluent_builders::GetAutomationExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCalendarState`](crate::client::fluent_builders::GetCalendarState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calendar_names(Vec<String>)`](crate::client::fluent_builders::GetCalendarState::calendar_names) / [`set_calendar_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetCalendarState::set_calendar_names): <p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that represent the calendar entries for which you want to get the state.</p>
    ///   - [`at_time(impl Into<String>)`](crate::client::fluent_builders::GetCalendarState::at_time) / [`set_at_time(Option<String>)`](crate::client::fluent_builders::GetCalendarState::set_at_time): <p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don't specify a value or <code>AtTime</code>, the current time is used.</p>
    /// - On success, responds with [`GetCalendarStateOutput`](crate::output::GetCalendarStateOutput) with field(s):
    ///   - [`state(Option<CalendarState>)`](crate::output::GetCalendarStateOutput::state): <p>The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates that actions aren't allowed to proceed.</p>
    ///   - [`at_time(Option<String>)`](crate::output::GetCalendarStateOutput::at_time): <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your command. If you don't specify a time, <code>GetCalendarState</code> uses the current time.</p>
    ///   - [`next_transition_time(Option<String>)`](crate::output::GetCalendarStateOutput::next_transition_time): <p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.</p>
    /// - On failure, responds with [`SdkError<GetCalendarStateError>`](crate::error::GetCalendarStateError)
    pub fn get_calendar_state(&self) -> fluent_builders::GetCalendarState {
        fluent_builders::GetCalendarState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCommandInvocation`](crate::client::fluent_builders::GetCommandInvocation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`command_id(impl Into<String>)`](crate::client::fluent_builders::GetCommandInvocation::command_id) / [`set_command_id(Option<String>)`](crate::client::fluent_builders::GetCommandInvocation::set_command_id): <p>(Required) The parent command ID of the invocation plugin.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetCommandInvocation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetCommandInvocation::set_instance_id): <p>(Required) The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, and on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
    ///   - [`plugin_name(impl Into<String>)`](crate::client::fluent_builders::GetCommandInvocation::plugin_name) / [`set_plugin_name(Option<String>)`](crate::client::fluent_builders::GetCommandInvocation::set_plugin_name): <p>The name of the plugin for which you want detailed results. If the document contains only one plugin, you can omit the name and details for that plugin. If the document contains more than one plugin, you must specify the name of the plugin for which you want to view details.</p>  <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM documents). For example, <code>aws:RunShellScript</code> is a plugin.</p>  <p>To find the <code>PluginName</code>, check the document content and find the name of the plugin. Alternatively, use <code>ListCommandInvocations</code> with the <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the <code>Name</code> attribute of the <code>CommandPlugin</code> object in the <code>CommandPlugins</code> list.</p>
    /// - On success, responds with [`GetCommandInvocationOutput`](crate::output::GetCommandInvocationOutput) with field(s):
    ///   - [`command_id(Option<String>)`](crate::output::GetCommandInvocationOutput::command_id): <p>The parent command ID of the invocation plugin.</p>
    ///   - [`instance_id(Option<String>)`](crate::output::GetCommandInvocationOutput::instance_id): <p>The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
    ///   - [`comment(Option<String>)`](crate::output::GetCommandInvocationOutput::comment): <p>The comment text for the command.</p>
    ///   - [`document_name(Option<String>)`](crate::output::GetCommandInvocationOutput::document_name): <p>The name of the document that was run. For example, <code>AWS-RunShellScript</code>.</p>
    ///   - [`document_version(Option<String>)`](crate::output::GetCommandInvocationOutput::document_version): <p>The Systems Manager document (SSM document) version used in the request.</p>
    ///   - [`plugin_name(Option<String>)`](crate::output::GetCommandInvocationOutput::plugin_name): <p>The name of the plugin, or <i>step name</i>, for which details are reported. For example, <code>aws:RunShellScript</code> is a plugin.</p>
    ///   - [`response_code(i32)`](crate::output::GetCommandInvocationOutput::response_code): <p>The error level response code for the plugin script. If the response code is <code>-1</code>, then the command hasn't started running on the managed node, or it wasn't received by the node.</p>
    ///   - [`execution_start_date_time(Option<String>)`](crate::output::GetCommandInvocationOutput::execution_start_date_time): <p>The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedBefore</code> filter.</p>  <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p>  <p>If the plugin hasn't started to run, the string is empty.</p>
    ///   - [`execution_elapsed_time(Option<String>)`](crate::output::GetCommandInvocationOutput::execution_elapsed_time): <p>Duration since <code>ExecutionStartDateTime</code>.</p>
    ///   - [`execution_end_date_time(Option<String>)`](crate::output::GetCommandInvocationOutput::execution_end_date_time): <p>The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the <code>InvokedAfter</code> filter.</p>  <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p>  <p>If the plugin hasn't started to run, the string is empty.</p>
    ///   - [`status(Option<CommandInvocationStatus>)`](crate::output::GetCommandInvocationOutput::status): <p>The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.</p>
    ///   - [`status_details(Option<String>)`](crate::output::GetCommandInvocationOutput::status_details): <p>A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more information than <code>Status</code> because it includes states resulting from error and concurrency control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code> can be one of the following values:</p>  <ul>   <li> <p>Pending: The command hasn't been sent to the managed node.</p> </li>   <li> <p>In Progress: The command has been sent to the managed node but hasn't reached a terminal state.</p> </li>   <li> <p>Delayed: The system attempted to send the command to the target, but the target wasn't available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.</p> </li>   <li> <p>Success: The command or plugin ran successfully. This is a terminal state.</p> </li>   <li> <p>Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>   <li> <p>Execution Timed Out: The command started to run on the managed node, but the execution wasn't complete before the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>   <li> <p>Failed: The command wasn't run successfully on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p> </li>   <li> <p>Cancelled: The command was terminated before it was completed. This is a terminal state.</p> </li>   <li> <p>Undeliverable: The command can't be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code> limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li>   <li> <p>Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li>  </ul>
    ///   - [`standard_output_content(Option<String>)`](crate::output::GetCommandInvocationOutput::standard_output_content): <p>The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.</p>
    ///   - [`standard_output_url(Option<String>)`](crate::output::GetCommandInvocationOutput::standard_output_url): <p>The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.</p>
    ///   - [`standard_error_content(Option<String>)`](crate::output::GetCommandInvocationOutput::standard_error_content): <p>The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
    ///   - [`standard_error_url(Option<String>)`](crate::output::GetCommandInvocationOutput::standard_error_url): <p>The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't finished running, then this string is empty.</p>
    ///   - [`cloud_watch_output_config(Option<CloudWatchOutputConfig>)`](crate::output::GetCommandInvocationOutput::cloud_watch_output_config): <p>Amazon CloudWatch Logs information where Systems Manager sent the command output.</p>
    /// - On failure, responds with [`SdkError<GetCommandInvocationError>`](crate::error::GetCommandInvocationError)
    pub fn get_command_invocation(&self) -> fluent_builders::GetCommandInvocation {
        fluent_builders::GetCommandInvocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConnectionStatus`](crate::client::fluent_builders::GetConnectionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::GetConnectionStatus::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::GetConnectionStatus::set_target): <p>The managed node ID.</p>
    /// - On success, responds with [`GetConnectionStatusOutput`](crate::output::GetConnectionStatusOutput) with field(s):
    ///   - [`target(Option<String>)`](crate::output::GetConnectionStatusOutput::target): <p>The ID of the managed node to check connection status. </p>
    ///   - [`status(Option<ConnectionStatus>)`](crate::output::GetConnectionStatusOutput::status): <p>The status of the connection to the managed node. For example, 'Connected' or 'Not Connected'.</p>
    /// - On failure, responds with [`SdkError<GetConnectionStatusError>`](crate::error::GetConnectionStatusError)
    pub fn get_connection_status(&self) -> fluent_builders::GetConnectionStatus {
        fluent_builders::GetConnectionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDefaultPatchBaseline`](crate::client::fluent_builders::GetDefaultPatchBaseline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`operating_system(OperatingSystem)`](crate::client::fluent_builders::GetDefaultPatchBaseline::operating_system) / [`set_operating_system(Option<OperatingSystem>)`](crate::client::fluent_builders::GetDefaultPatchBaseline::set_operating_system): <p>Returns the default patch baseline for the specified operating system.</p>
    /// - On success, responds with [`GetDefaultPatchBaselineOutput`](crate::output::GetDefaultPatchBaselineOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::GetDefaultPatchBaselineOutput::baseline_id): <p>The ID of the default patch baseline.</p>
    ///   - [`operating_system(Option<OperatingSystem>)`](crate::output::GetDefaultPatchBaselineOutput::operating_system): <p>The operating system for the returned patch baseline. </p>
    /// - On failure, responds with [`SdkError<GetDefaultPatchBaselineError>`](crate::error::GetDefaultPatchBaselineError)
    pub fn get_default_patch_baseline(&self) -> fluent_builders::GetDefaultPatchBaseline {
        fluent_builders::GetDefaultPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployablePatchSnapshotForInstance`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance::set_instance_id): <p>The ID of the managed node for which the appropriate patch snapshot should be retrieved.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance::set_snapshot_id): <p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>
    ///   - [`baseline_override(BaselineOverride)`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance::baseline_override) / [`set_baseline_override(Option<BaselineOverride>)`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance::set_baseline_override): <p>Defines the basic information about a patch baseline override.</p>
    /// - On success, responds with [`GetDeployablePatchSnapshotForInstanceOutput`](crate::output::GetDeployablePatchSnapshotForInstanceOutput) with field(s):
    ///   - [`instance_id(Option<String>)`](crate::output::GetDeployablePatchSnapshotForInstanceOutput::instance_id): <p>The managed node ID.</p>
    ///   - [`snapshot_id(Option<String>)`](crate::output::GetDeployablePatchSnapshotForInstanceOutput::snapshot_id): <p>The user-defined snapshot ID.</p>
    ///   - [`snapshot_download_url(Option<String>)`](crate::output::GetDeployablePatchSnapshotForInstanceOutput::snapshot_download_url): <p>A pre-signed Amazon Simple Storage Service (Amazon S3) URL that can be used to download the patch snapshot.</p>
    ///   - [`product(Option<String>)`](crate::output::GetDeployablePatchSnapshotForInstanceOutput::product): <p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the managed node for the specified patch snapshot.</p>
    /// - On failure, responds with [`SdkError<GetDeployablePatchSnapshotForInstanceError>`](crate::error::GetDeployablePatchSnapshotForInstanceError)
    pub fn get_deployable_patch_snapshot_for_instance(
        &self,
    ) -> fluent_builders::GetDeployablePatchSnapshotForInstance {
        fluent_builders::GetDeployablePatchSnapshotForInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocument`](crate::client::fluent_builders::GetDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetDocument::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetDocument::set_name): <p>The name of the SSM document.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::GetDocument::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::GetDocument::set_version_name): <p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document and can't be changed.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::GetDocument::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::GetDocument::set_document_version): <p>The document version for which you want information.</p>
    ///   - [`document_format(DocumentFormat)`](crate::client::fluent_builders::GetDocument::document_format) / [`set_document_format(Option<DocumentFormat>)`](crate::client::fluent_builders::GetDocument::set_document_format): <p>Returns the document in the specified format. The document format can be either JSON or YAML. JSON is the default format.</p>
    /// - On success, responds with [`GetDocumentOutput`](crate::output::GetDocumentOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetDocumentOutput::name): <p>The name of the SSM document.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetDocumentOutput::created_date): <p>The date the SSM document was created.</p>
    ///   - [`display_name(Option<String>)`](crate::output::GetDocumentOutput::display_name): <p>The friendly name of the SSM document. This value can differ for each version of the document. If you want to update this value, see <code>UpdateDocument</code>.</p>
    ///   - [`version_name(Option<String>)`](crate::output::GetDocumentOutput::version_name): <p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
    ///   - [`document_version(Option<String>)`](crate::output::GetDocumentOutput::document_version): <p>The document version.</p>
    ///   - [`status(Option<DocumentStatus>)`](crate::output::GetDocumentOutput::status): <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>, <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.</p>
    ///   - [`status_information(Option<String>)`](crate::output::GetDocumentOutput::status_information): <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
    ///   - [`content(Option<String>)`](crate::output::GetDocumentOutput::content): <p>The contents of the SSM document.</p>
    ///   - [`document_type(Option<DocumentType>)`](crate::output::GetDocumentOutput::document_type): <p>The document type.</p>
    ///   - [`document_format(Option<DocumentFormat>)`](crate::output::GetDocumentOutput::document_format): <p>The document format, either JSON or YAML.</p>
    ///   - [`requires(Option<Vec<DocumentRequires>>)`](crate::output::GetDocumentOutput::requires): <p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>
    ///   - [`attachments_content(Option<Vec<AttachmentContent>>)`](crate::output::GetDocumentOutput::attachments_content): <p>A description of the document attachments, including names, locations, sizes, and so on.</p>
    ///   - [`review_status(Option<ReviewStatus>)`](crate::output::GetDocumentOutput::review_status): <p>The current review status of a new custom Systems Manager document (SSM document) created by a member of your organization, or of the latest version of an existing SSM document.</p>  <p>Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.</p>  <p>Only one version of an SSM document can be in review, or PENDING, at a time.</p>
    /// - On failure, responds with [`SdkError<GetDocumentError>`](crate::error::GetDocumentError)
    pub fn get_document(&self) -> fluent_builders::GetDocument {
        fluent_builders::GetDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInventory`](crate::client::fluent_builders::GetInventory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetInventory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<InventoryFilter>)`](crate::client::fluent_builders::GetInventory::filters) / [`set_filters(Option<Vec<InventoryFilter>>)`](crate::client::fluent_builders::GetInventory::set_filters): <p>One or more filters. Use a filter to return a more specific list of results.</p>
    ///   - [`aggregators(Vec<InventoryAggregator>)`](crate::client::fluent_builders::GetInventory::aggregators) / [`set_aggregators(Option<Vec<InventoryAggregator>>)`](crate::client::fluent_builders::GetInventory::set_aggregators): <p>Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried fleet.</p>
    ///   - [`result_attributes(Vec<ResultAttribute>)`](crate::client::fluent_builders::GetInventory::result_attributes) / [`set_result_attributes(Option<Vec<ResultAttribute>>)`](crate::client::fluent_builders::GetInventory::set_result_attributes): <p>The list of inventory item types to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInventory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInventory::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetInventory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetInventory::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`GetInventoryOutput`](crate::output::GetInventoryOutput) with field(s):
    ///   - [`entities(Option<Vec<InventoryResultEntity>>)`](crate::output::GetInventoryOutput::entities): <p>Collection of inventory entities such as a collection of managed node inventory. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInventoryOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<GetInventoryError>`](crate::error::GetInventoryError)
    pub fn get_inventory(&self) -> fluent_builders::GetInventory {
        fluent_builders::GetInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInventorySchema`](crate::client::fluent_builders::GetInventorySchema) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetInventorySchema::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::GetInventorySchema::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::GetInventorySchema::set_type_name): <p>The type of inventory item to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetInventorySchema::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetInventorySchema::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetInventorySchema::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetInventorySchema::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`aggregator(bool)`](crate::client::fluent_builders::GetInventorySchema::aggregator) / [`set_aggregator(bool)`](crate::client::fluent_builders::GetInventorySchema::set_aggregator): <p>Returns inventory schemas that support aggregation. For example, this call returns the <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.</p>
    ///   - [`sub_type(bool)`](crate::client::fluent_builders::GetInventorySchema::sub_type) / [`set_sub_type(Option<bool>)`](crate::client::fluent_builders::GetInventorySchema::set_sub_type): <p>Returns the sub-type schema for a specified inventory type.</p>
    /// - On success, responds with [`GetInventorySchemaOutput`](crate::output::GetInventorySchemaOutput) with field(s):
    ///   - [`schemas(Option<Vec<InventoryItemSchema>>)`](crate::output::GetInventorySchemaOutput::schemas): <p>Inventory schemas returned by the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetInventorySchemaOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<GetInventorySchemaError>`](crate::error::GetInventorySchemaError)
    pub fn get_inventory_schema(&self) -> fluent_builders::GetInventorySchema {
        fluent_builders::GetInventorySchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMaintenanceWindow`](crate::client::fluent_builders::GetMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindow::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindow::set_window_id): <p>The ID of the maintenance window for which you want to retrieve information.</p>
    /// - On success, responds with [`GetMaintenanceWindowOutput`](crate::output::GetMaintenanceWindowOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::GetMaintenanceWindowOutput::window_id): <p>The ID of the created maintenance window.</p>
    ///   - [`name(Option<String>)`](crate::output::GetMaintenanceWindowOutput::name): <p>The name of the maintenance window.</p>
    ///   - [`description(Option<String>)`](crate::output::GetMaintenanceWindowOutput::description): <p>The description of the maintenance window.</p>
    ///   - [`start_date(Option<String>)`](crate::output::GetMaintenanceWindowOutput::start_date): <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
    ///   - [`end_date(Option<String>)`](crate::output::GetMaintenanceWindowOutput::end_date): <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
    ///   - [`schedule(Option<String>)`](crate::output::GetMaintenanceWindowOutput::schedule): <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    ///   - [`schedule_timezone(Option<String>)`](crate::output::GetMaintenanceWindowOutput::schedule_timezone): <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    ///   - [`schedule_offset(Option<i32>)`](crate::output::GetMaintenanceWindowOutput::schedule_offset): <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
    ///   - [`next_execution_time(Option<String>)`](crate::output::GetMaintenanceWindowOutput::next_execution_time): <p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>
    ///   - [`duration(i32)`](crate::output::GetMaintenanceWindowOutput::duration): <p>The duration of the maintenance window in hours.</p>
    ///   - [`cutoff(i32)`](crate::output::GetMaintenanceWindowOutput::cutoff): <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    ///   - [`allow_unassociated_targets(bool)`](crate::output::GetMaintenanceWindowOutput::allow_unassociated_targets): <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
    ///   - [`enabled(bool)`](crate::output::GetMaintenanceWindowOutput::enabled): <p>Indicates whether the maintenance window is enabled.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetMaintenanceWindowOutput::created_date): <p>The date the maintenance window was created.</p>
    ///   - [`modified_date(Option<DateTime>)`](crate::output::GetMaintenanceWindowOutput::modified_date): <p>The date the maintenance window was last modified.</p>
    /// - On failure, responds with [`SdkError<GetMaintenanceWindowError>`](crate::error::GetMaintenanceWindowError)
    pub fn get_maintenance_window(&self) -> fluent_builders::GetMaintenanceWindow {
        fluent_builders::GetMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMaintenanceWindowExecution`](crate::client::fluent_builders::GetMaintenanceWindowExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_execution_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecution::window_execution_id) / [`set_window_execution_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecution::set_window_execution_id): <p>The ID of the maintenance window execution that includes the task.</p>
    /// - On success, responds with [`GetMaintenanceWindowExecutionOutput`](crate::output::GetMaintenanceWindowExecutionOutput) with field(s):
    ///   - [`window_execution_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionOutput::window_execution_id): <p>The ID of the maintenance window execution.</p>
    ///   - [`task_ids(Option<Vec<String>>)`](crate::output::GetMaintenanceWindowExecutionOutput::task_ids): <p>The ID of the task executions from the maintenance window execution.</p>
    ///   - [`status(Option<MaintenanceWindowExecutionStatus>)`](crate::output::GetMaintenanceWindowExecutionOutput::status): <p>The status of the maintenance window execution.</p>
    ///   - [`status_details(Option<String>)`](crate::output::GetMaintenanceWindowExecutionOutput::status_details): <p>The details explaining the status. Not available for all status values.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetMaintenanceWindowExecutionOutput::start_time): <p>The time the maintenance window started running.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::GetMaintenanceWindowExecutionOutput::end_time): <p>The time the maintenance window finished running.</p>
    /// - On failure, responds with [`SdkError<GetMaintenanceWindowExecutionError>`](crate::error::GetMaintenanceWindowExecutionError)
    pub fn get_maintenance_window_execution(
        &self,
    ) -> fluent_builders::GetMaintenanceWindowExecution {
        fluent_builders::GetMaintenanceWindowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMaintenanceWindowExecutionTask`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_execution_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTask::window_execution_id) / [`set_window_execution_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTask::set_window_execution_id): <p>The ID of the maintenance window execution that includes the task.</p>
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTask::set_task_id): <p>The ID of the specific task execution in the maintenance window task that should be retrieved.</p>
    /// - On success, responds with [`GetMaintenanceWindowExecutionTaskOutput`](crate::output::GetMaintenanceWindowExecutionTaskOutput) with field(s):
    ///   - [`window_execution_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::window_execution_id): <p>The ID of the maintenance window execution that includes the task.</p>
    ///   - [`task_execution_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::task_execution_id): <p>The ID of the specific task execution in the maintenance window task that was retrieved.</p>
    ///   - [`task_arn(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::task_arn): <p>The Amazon Resource Name (ARN) of the task that ran.</p>
    ///   - [`service_role(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::service_role): <p>The role that was assumed when running the task.</p>
    ///   - [`r#type(Option<MaintenanceWindowTaskType>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::type): <p>The type of task that was run.</p>
    ///   - [`task_parameters(Option<Vec<HashMap<String, MaintenanceWindowTaskParameterValueExpression>>>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::task_parameters): <p>The parameters passed to the task when it was run.</p> <note>   <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>  <p>The map has the following format:</p>  <ul>   <li> <p> <code>Key</code>: string, between 1 and 255 characters</p> </li>   <li> <p> <code>Value</code>: an array of strings, each between 1 and 255 characters</p> </li>  </ul>
    ///   - [`priority(i32)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::priority): <p>The priority of the task.</p>
    ///   - [`max_concurrency(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::max_concurrency): <p>The defined maximum number of task executions that could be run in parallel.</p>
    ///   - [`max_errors(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::max_errors): <p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>
    ///   - [`status(Option<MaintenanceWindowExecutionStatus>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::status): <p>The status of the task.</p>
    ///   - [`status_details(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::status_details): <p>The details explaining the status. Not available for all status values.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::start_time): <p>The time the task execution started.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::GetMaintenanceWindowExecutionTaskOutput::end_time): <p>The time the task execution completed.</p>
    /// - On failure, responds with [`SdkError<GetMaintenanceWindowExecutionTaskError>`](crate::error::GetMaintenanceWindowExecutionTaskError)
    pub fn get_maintenance_window_execution_task(
        &self,
    ) -> fluent_builders::GetMaintenanceWindowExecutionTask {
        fluent_builders::GetMaintenanceWindowExecutionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMaintenanceWindowExecutionTaskInvocation`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_execution_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::window_execution_id) / [`set_window_execution_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::set_window_execution_id): <p>The ID of the maintenance window execution for which the task is a part.</p>
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::set_task_id): <p>The ID of the specific task in the maintenance window task that should be retrieved. </p>
    ///   - [`invocation_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::invocation_id) / [`set_invocation_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::set_invocation_id): <p>The invocation ID to retrieve.</p>
    /// - On success, responds with [`GetMaintenanceWindowExecutionTaskInvocationOutput`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput) with field(s):
    ///   - [`window_execution_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::window_execution_id): <p>The maintenance window execution ID.</p>
    ///   - [`task_execution_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::task_execution_id): <p>The task execution ID.</p>
    ///   - [`invocation_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::invocation_id): <p>The invocation ID.</p>
    ///   - [`execution_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::execution_id): <p>The execution ID.</p>
    ///   - [`task_type(Option<MaintenanceWindowTaskType>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::task_type): <p>Retrieves the task type for a maintenance window.</p>
    ///   - [`parameters(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::parameters): <p>The parameters used at the time that the task ran.</p>
    ///   - [`status(Option<MaintenanceWindowExecutionStatus>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::status): <p>The task status for an invocation.</p>
    ///   - [`status_details(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::status_details): <p>The details explaining the status. Details are only available for certain status values.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::start_time): <p>The time that the task started running on the target.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::end_time): <p>The time that the task finished running on the target.</p>
    ///   - [`owner_information(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::owner_information): <p>User-provided value to be included in any Amazon CloudWatch Events or Amazon EventBridge events raised while running tasks for these targets in this maintenance window.</p>
    ///   - [`window_target_id(Option<String>)`](crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput::window_target_id): <p>The maintenance window target ID.</p>
    /// - On failure, responds with [`SdkError<GetMaintenanceWindowExecutionTaskInvocationError>`](crate::error::GetMaintenanceWindowExecutionTaskInvocationError)
    pub fn get_maintenance_window_execution_task_invocation(
        &self,
    ) -> fluent_builders::GetMaintenanceWindowExecutionTaskInvocation {
        fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMaintenanceWindowTask`](crate::client::fluent_builders::GetMaintenanceWindowTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowTask::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowTask::set_window_id): <p>The maintenance window ID that includes the task to retrieve.</p>
    ///   - [`window_task_id(impl Into<String>)`](crate::client::fluent_builders::GetMaintenanceWindowTask::window_task_id) / [`set_window_task_id(Option<String>)`](crate::client::fluent_builders::GetMaintenanceWindowTask::set_window_task_id): <p>The maintenance window task ID to retrieve.</p>
    /// - On success, responds with [`GetMaintenanceWindowTaskOutput`](crate::output::GetMaintenanceWindowTaskOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::window_id): <p>The retrieved maintenance window ID.</p>
    ///   - [`window_task_id(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::window_task_id): <p>The retrieved maintenance window task ID.</p>
    ///   - [`targets(Option<Vec<Target>>)`](crate::output::GetMaintenanceWindowTaskOutput::targets): <p>The targets where the task should run.</p>
    ///   - [`task_arn(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::task_arn): <p>The resource that the task used during execution. For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, the value of <code>TaskArn</code> is the SSM document name/ARN. For <code>LAMBDA</code> tasks, the value is the function name/ARN. For <code>STEP_FUNCTIONS</code> tasks, the value is the state machine ARN.</p>
    ///   - [`service_role_arn(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::service_role_arn): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
    ///   - [`task_type(Option<MaintenanceWindowTaskType>)`](crate::output::GetMaintenanceWindowTaskOutput::task_type): <p>The type of task to run.</p>
    ///   - [`task_parameters(Option<HashMap<String, MaintenanceWindowTaskParameterValueExpression>>)`](crate::output::GetMaintenanceWindowTaskOutput::task_parameters): <p>The parameters to pass to the task when it runs.</p> <note>   <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>
    ///   - [`task_invocation_parameters(Option<MaintenanceWindowTaskInvocationParameters>)`](crate::output::GetMaintenanceWindowTaskOutput::task_invocation_parameters): <p>The parameters to pass to the task when it runs.</p>
    ///   - [`priority(i32)`](crate::output::GetMaintenanceWindowTaskOutput::priority): <p>The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>
    ///   - [`max_concurrency(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::max_concurrency): <p>The maximum number of targets allowed to run this task in parallel.</p> <note>   <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>  </note>
    ///   - [`max_errors(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::max_errors): <p>The maximum number of errors allowed before the task stops being scheduled.</p> <note>   <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. This value doesn't affect the running of your task and can be ignored.</p>  </note>
    ///   - [`logging_info(Option<LoggingInfo>)`](crate::output::GetMaintenanceWindowTaskOutput::logging_info): <p>The location in Amazon Simple Storage Service (Amazon S3) where the task results are logged.</p> <note>   <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>
    ///   - [`name(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::name): <p>The retrieved task name.</p>
    ///   - [`description(Option<String>)`](crate::output::GetMaintenanceWindowTaskOutput::description): <p>The retrieved task description.</p>
    ///   - [`cutoff_behavior(Option<MaintenanceWindowTaskCutoffBehavior>)`](crate::output::GetMaintenanceWindowTaskOutput::cutoff_behavior): <p>The action to take on tasks when the maintenance window cutoff time is reached. <code>CONTINUE_TASK</code> means that tasks continue to run. For Automation, Lambda, Step Functions tasks, <code>CANCEL_TASK</code> means that currently running task invocations continue, but no new task invocations are started. For Run Command tasks, <code>CANCEL_TASK</code> means the system attempts to stop the task by sending a <code>CancelCommand</code> operation.</p>
    /// - On failure, responds with [`SdkError<GetMaintenanceWindowTaskError>`](crate::error::GetMaintenanceWindowTaskError)
    pub fn get_maintenance_window_task(&self) -> fluent_builders::GetMaintenanceWindowTask {
        fluent_builders::GetMaintenanceWindowTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOpsItem`](crate::client::fluent_builders::GetOpsItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_item_id(impl Into<String>)`](crate::client::fluent_builders::GetOpsItem::ops_item_id) / [`set_ops_item_id(Option<String>)`](crate::client::fluent_builders::GetOpsItem::set_ops_item_id): <p>The ID of the OpsItem that you want to get.</p>
    /// - On success, responds with [`GetOpsItemOutput`](crate::output::GetOpsItemOutput) with field(s):
    ///   - [`ops_item(Option<OpsItem>)`](crate::output::GetOpsItemOutput::ops_item): <p>The OpsItem.</p>
    /// - On failure, responds with [`SdkError<GetOpsItemError>`](crate::error::GetOpsItemError)
    pub fn get_ops_item(&self) -> fluent_builders::GetOpsItem {
        fluent_builders::GetOpsItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOpsMetadata`](crate::client::fluent_builders::GetOpsMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_metadata_arn(impl Into<String>)`](crate::client::fluent_builders::GetOpsMetadata::ops_metadata_arn) / [`set_ops_metadata_arn(Option<String>)`](crate::client::fluent_builders::GetOpsMetadata::set_ops_metadata_arn): <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetOpsMetadata::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetOpsMetadata::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetOpsMetadata::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetOpsMetadata::set_next_token): <p>A token to start the list. Use this token to get the next set of results.</p>
    /// - On success, responds with [`GetOpsMetadataOutput`](crate::output::GetOpsMetadataOutput) with field(s):
    ///   - [`resource_id(Option<String>)`](crate::output::GetOpsMetadataOutput::resource_id): <p>The resource ID of the Application Manager application.</p>
    ///   - [`metadata(Option<HashMap<String, MetadataValue>>)`](crate::output::GetOpsMetadataOutput::metadata): <p>OpsMetadata for an Application Manager application.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetOpsMetadataOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<GetOpsMetadataError>`](crate::error::GetOpsMetadataError)
    pub fn get_ops_metadata(&self) -> fluent_builders::GetOpsMetadata {
        fluent_builders::GetOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOpsSummary`](crate::client::fluent_builders::GetOpsSummary) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetOpsSummary::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sync_name(impl Into<String>)`](crate::client::fluent_builders::GetOpsSummary::sync_name) / [`set_sync_name(Option<String>)`](crate::client::fluent_builders::GetOpsSummary::set_sync_name): <p>Specify the name of a resource data sync to get.</p>
    ///   - [`filters(Vec<OpsFilter>)`](crate::client::fluent_builders::GetOpsSummary::filters) / [`set_filters(Option<Vec<OpsFilter>>)`](crate::client::fluent_builders::GetOpsSummary::set_filters): <p>Optional filters used to scope down the returned OpsData. </p>
    ///   - [`aggregators(Vec<OpsAggregator>)`](crate::client::fluent_builders::GetOpsSummary::aggregators) / [`set_aggregators(Option<Vec<OpsAggregator>>)`](crate::client::fluent_builders::GetOpsSummary::set_aggregators): <p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>
    ///   - [`result_attributes(Vec<OpsResultAttribute>)`](crate::client::fluent_builders::GetOpsSummary::result_attributes) / [`set_result_attributes(Option<Vec<OpsResultAttribute>>)`](crate::client::fluent_builders::GetOpsSummary::set_result_attributes): <p>The OpsData data type to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetOpsSummary::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetOpsSummary::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetOpsSummary::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetOpsSummary::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`GetOpsSummaryOutput`](crate::output::GetOpsSummaryOutput) with field(s):
    ///   - [`entities(Option<Vec<OpsEntity>>)`](crate::output::GetOpsSummaryOutput::entities): <p>The list of aggregated details and filtered OpsData.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetOpsSummaryOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<GetOpsSummaryError>`](crate::error::GetOpsSummaryError)
    pub fn get_ops_summary(&self) -> fluent_builders::GetOpsSummary {
        fluent_builders::GetOpsSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetParameter`](crate::client::fluent_builders::GetParameter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetParameter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetParameter::set_name): <p>The name of the parameter you want to query.</p>  <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>
    ///   - [`with_decryption(bool)`](crate::client::fluent_builders::GetParameter::with_decryption) / [`set_with_decryption(Option<bool>)`](crate::client::fluent_builders::GetParameter::set_with_decryption): <p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
    /// - On success, responds with [`GetParameterOutput`](crate::output::GetParameterOutput) with field(s):
    ///   - [`parameter(Option<Parameter>)`](crate::output::GetParameterOutput::parameter): <p>Information about a parameter.</p>
    /// - On failure, responds with [`SdkError<GetParameterError>`](crate::error::GetParameterError)
    pub fn get_parameter(&self) -> fluent_builders::GetParameter {
        fluent_builders::GetParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetParameterHistory`](crate::client::fluent_builders::GetParameterHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetParameterHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetParameterHistory::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetParameterHistory::set_name): <p>The name of the parameter for which you want to review history.</p>
    ///   - [`with_decryption(bool)`](crate::client::fluent_builders::GetParameterHistory::with_decryption) / [`set_with_decryption(Option<bool>)`](crate::client::fluent_builders::GetParameterHistory::set_with_decryption): <p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetParameterHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetParameterHistory::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetParameterHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetParameterHistory::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`GetParameterHistoryOutput`](crate::output::GetParameterHistoryOutput) with field(s):
    ///   - [`parameters(Option<Vec<ParameterHistory>>)`](crate::output::GetParameterHistoryOutput::parameters): <p>A list of parameters returned by the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetParameterHistoryOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<GetParameterHistoryError>`](crate::error::GetParameterHistoryError)
    pub fn get_parameter_history(&self) -> fluent_builders::GetParameterHistory {
        fluent_builders::GetParameterHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetParameters`](crate::client::fluent_builders::GetParameters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::GetParameters::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::GetParameters::set_names): <p>Names of the parameters for which you want to query information.</p>  <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>
    ///   - [`with_decryption(bool)`](crate::client::fluent_builders::GetParameters::with_decryption) / [`set_with_decryption(Option<bool>)`](crate::client::fluent_builders::GetParameters::set_with_decryption): <p>Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
    /// - On success, responds with [`GetParametersOutput`](crate::output::GetParametersOutput) with field(s):
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::GetParametersOutput::parameters): <p>A list of details for a parameter.</p>
    ///   - [`invalid_parameters(Option<Vec<String>>)`](crate::output::GetParametersOutput::invalid_parameters): <p>A list of parameters that aren't formatted correctly or don't run during an execution.</p>
    /// - On failure, responds with [`SdkError<GetParametersError>`](crate::error::GetParametersError)
    pub fn get_parameters(&self) -> fluent_builders::GetParameters {
        fluent_builders::GetParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetParametersByPath`](crate::client::fluent_builders::GetParametersByPath) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetParametersByPath::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`path(impl Into<String>)`](crate::client::fluent_builders::GetParametersByPath::path) / [`set_path(Option<String>)`](crate::client::fluent_builders::GetParametersByPath::set_path): <p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. For the API call to succeed, the last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33 </code> </p>
    ///   - [`recursive(bool)`](crate::client::fluent_builders::GetParametersByPath::recursive) / [`set_recursive(Option<bool>)`](crate::client::fluent_builders::GetParametersByPath::set_recursive): <p>Retrieve all parameters within a hierarchy.</p> <important>   <p>If a user has access to a path, then the user can access all levels of that path. For example, if a user has permission to access path <code>/a</code>, then the user can also access <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation recursively for <code>/a</code> and view <code>/a/b</code>.</p>  </important>
    ///   - [`parameter_filters(Vec<ParameterStringFilter>)`](crate::client::fluent_builders::GetParametersByPath::parameter_filters) / [`set_parameter_filters(Option<Vec<ParameterStringFilter>>)`](crate::client::fluent_builders::GetParametersByPath::set_parameter_filters): <p>Filters to limit the request results.</p> <note>   <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>: <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p>   <p>The following <code>Key</code> values aren't supported for <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and <code>Tier</code>.</p>  </note>
    ///   - [`with_decryption(bool)`](crate::client::fluent_builders::GetParametersByPath::with_decryption) / [`set_with_decryption(Option<bool>)`](crate::client::fluent_builders::GetParametersByPath::set_with_decryption): <p>Retrieve all parameters in a hierarchy with their value decrypted.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetParametersByPath::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetParametersByPath::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetParametersByPath::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetParametersByPath::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    /// - On success, responds with [`GetParametersByPathOutput`](crate::output::GetParametersByPathOutput) with field(s):
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::GetParametersByPathOutput::parameters): <p>A list of parameters found in the specified hierarchy.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetParametersByPathOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<GetParametersByPathError>`](crate::error::GetParametersByPathError)
    pub fn get_parameters_by_path(&self) -> fluent_builders::GetParametersByPath {
        fluent_builders::GetParametersByPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPatchBaseline`](crate::client::fluent_builders::GetPatchBaseline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`baseline_id(impl Into<String>)`](crate::client::fluent_builders::GetPatchBaseline::baseline_id) / [`set_baseline_id(Option<String>)`](crate::client::fluent_builders::GetPatchBaseline::set_baseline_id): <p>The ID of the patch baseline to retrieve.</p> <note>   <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon Resource Name (ARN) of the baseline. For example, for the baseline <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of <code>pb-0e392de35e7c563b7</code>.</p>  </note>
    /// - On success, responds with [`GetPatchBaselineOutput`](crate::output::GetPatchBaselineOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::GetPatchBaselineOutput::baseline_id): <p>The ID of the retrieved patch baseline.</p>
    ///   - [`name(Option<String>)`](crate::output::GetPatchBaselineOutput::name): <p>The name of the patch baseline.</p>
    ///   - [`operating_system(Option<OperatingSystem>)`](crate::output::GetPatchBaselineOutput::operating_system): <p>Returns the operating system specified for the patch baseline.</p>
    ///   - [`global_filters(Option<PatchFilterGroup>)`](crate::output::GetPatchBaselineOutput::global_filters): <p>A set of global filters used to exclude patches from the baseline.</p>
    ///   - [`approval_rules(Option<PatchRuleGroup>)`](crate::output::GetPatchBaselineOutput::approval_rules): <p>A set of rules used to include patches in the baseline.</p>
    ///   - [`approved_patches(Option<Vec<String>>)`](crate::output::GetPatchBaselineOutput::approved_patches): <p>A list of explicitly approved patches for the baseline.</p>
    ///   - [`approved_patches_compliance_level(Option<PatchComplianceLevel>)`](crate::output::GetPatchBaselineOutput::approved_patches_compliance_level): <p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>
    ///   - [`approved_patches_enable_non_security(Option<bool>)`](crate::output::GetPatchBaselineOutput::approved_patches_enable_non_security): <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    ///   - [`rejected_patches(Option<Vec<String>>)`](crate::output::GetPatchBaselineOutput::rejected_patches): <p>A list of explicitly rejected patches for the baseline.</p>
    ///   - [`rejected_patches_action(Option<PatchAction>)`](crate::output::GetPatchBaselineOutput::rejected_patches_action): <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
    ///   - [`patch_groups(Option<Vec<String>>)`](crate::output::GetPatchBaselineOutput::patch_groups): <p>Patch groups included in the patch baseline.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetPatchBaselineOutput::created_date): <p>The date the patch baseline was created.</p>
    ///   - [`modified_date(Option<DateTime>)`](crate::output::GetPatchBaselineOutput::modified_date): <p>The date the patch baseline was last modified.</p>
    ///   - [`description(Option<String>)`](crate::output::GetPatchBaselineOutput::description): <p>A description of the patch baseline.</p>
    ///   - [`sources(Option<Vec<PatchSource>>)`](crate::output::GetPatchBaselineOutput::sources): <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    /// - On failure, responds with [`SdkError<GetPatchBaselineError>`](crate::error::GetPatchBaselineError)
    pub fn get_patch_baseline(&self) -> fluent_builders::GetPatchBaseline {
        fluent_builders::GetPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPatchBaselineForPatchGroup`](crate::client::fluent_builders::GetPatchBaselineForPatchGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`patch_group(impl Into<String>)`](crate::client::fluent_builders::GetPatchBaselineForPatchGroup::patch_group) / [`set_patch_group(Option<String>)`](crate::client::fluent_builders::GetPatchBaselineForPatchGroup::set_patch_group): <p>The name of the patch group whose patch baseline should be retrieved.</p>
    ///   - [`operating_system(OperatingSystem)`](crate::client::fluent_builders::GetPatchBaselineForPatchGroup::operating_system) / [`set_operating_system(Option<OperatingSystem>)`](crate::client::fluent_builders::GetPatchBaselineForPatchGroup::set_operating_system): <p>Returns he operating system rule specified for patch groups using the patch baseline.</p>
    /// - On success, responds with [`GetPatchBaselineForPatchGroupOutput`](crate::output::GetPatchBaselineForPatchGroupOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::GetPatchBaselineForPatchGroupOutput::baseline_id): <p>The ID of the patch baseline that should be used for the patch group.</p>
    ///   - [`patch_group(Option<String>)`](crate::output::GetPatchBaselineForPatchGroupOutput::patch_group): <p>The name of the patch group.</p>
    ///   - [`operating_system(Option<OperatingSystem>)`](crate::output::GetPatchBaselineForPatchGroupOutput::operating_system): <p>The operating system rule specified for patch groups using the patch baseline.</p>
    /// - On failure, responds with [`SdkError<GetPatchBaselineForPatchGroupError>`](crate::error::GetPatchBaselineForPatchGroupError)
    pub fn get_patch_baseline_for_patch_group(
        &self,
    ) -> fluent_builders::GetPatchBaselineForPatchGroup {
        fluent_builders::GetPatchBaselineForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceSetting`](crate::client::fluent_builders::GetServiceSetting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`setting_id(impl Into<String>)`](crate::client::fluent_builders::GetServiceSetting::setting_id) / [`set_setting_id(Option<String>)`](crate::client::fluent_builders::GetServiceSetting::set_setting_id): <p>The ID of the service setting to get. The setting ID can be one of the following.</p>  <ul>   <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li>   <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li>   <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li>   <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li>   <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li>   <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li>  </ul>
    /// - On success, responds with [`GetServiceSettingOutput`](crate::output::GetServiceSettingOutput) with field(s):
    ///   - [`service_setting(Option<ServiceSetting>)`](crate::output::GetServiceSettingOutput::service_setting): <p>The query result of the current service setting.</p>
    /// - On failure, responds with [`SdkError<GetServiceSettingError>`](crate::error::GetServiceSettingError)
    pub fn get_service_setting(&self) -> fluent_builders::GetServiceSetting {
        fluent_builders::GetServiceSetting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`LabelParameterVersion`](crate::client::fluent_builders::LabelParameterVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::LabelParameterVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::LabelParameterVersion::set_name): <p>The parameter name on which you want to attach one or more labels.</p>
    ///   - [`parameter_version(i64)`](crate::client::fluent_builders::LabelParameterVersion::parameter_version) / [`set_parameter_version(Option<i64>)`](crate::client::fluent_builders::LabelParameterVersion::set_parameter_version): <p>The specific version of the parameter on which you want to attach one or more labels. If no version is specified, the system attaches the label to the latest version.</p>
    ///   - [`labels(Vec<String>)`](crate::client::fluent_builders::LabelParameterVersion::labels) / [`set_labels(Option<Vec<String>>)`](crate::client::fluent_builders::LabelParameterVersion::set_labels): <p>One or more labels to attach to the specified parameter version.</p>
    /// - On success, responds with [`LabelParameterVersionOutput`](crate::output::LabelParameterVersionOutput) with field(s):
    ///   - [`invalid_labels(Option<Vec<String>>)`](crate::output::LabelParameterVersionOutput::invalid_labels): <p>The label doesn't meet the requirements. For information about parameter label requirements, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`parameter_version(i64)`](crate::output::LabelParameterVersionOutput::parameter_version): <p>The version of the parameter that has been labeled.</p>
    /// - On failure, responds with [`SdkError<LabelParameterVersionError>`](crate::error::LabelParameterVersionError)
    pub fn label_parameter_version(&self) -> fluent_builders::LabelParameterVersion {
        fluent_builders::LabelParameterVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociations`](crate::client::fluent_builders::ListAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_filter_list(Vec<AssociationFilter>)`](crate::client::fluent_builders::ListAssociations::association_filter_list) / [`set_association_filter_list(Option<Vec<AssociationFilter>>)`](crate::client::fluent_builders::ListAssociations::set_association_filter_list): <p>One or more filters. Use a filter to return a more specific list of results.</p> <note>   <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy associations created using the <code>InstanceID</code> attribute. Associations targeting the managed node that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code> aren't returned.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssociations::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociations::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`ListAssociationsOutput`](crate::output::ListAssociationsOutput) with field(s):
    ///   - [`associations(Option<Vec<Association>>)`](crate::output::ListAssociationsOutput::associations): <p>The associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociationsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<ListAssociationsError>`](crate::error::ListAssociationsError)
    pub fn list_associations(&self) -> fluent_builders::ListAssociations {
        fluent_builders::ListAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociationVersions`](crate::client::fluent_builders::ListAssociationVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssociationVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::ListAssociationVersions::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::ListAssociationVersions::set_association_id): <p>The association ID for which you want to view all versions.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssociationVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssociationVersions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociationVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociationVersions::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    /// - On success, responds with [`ListAssociationVersionsOutput`](crate::output::ListAssociationVersionsOutput) with field(s):
    ///   - [`association_versions(Option<Vec<AssociationVersionInfo>>)`](crate::output::ListAssociationVersionsOutput::association_versions): <p>Information about all versions of the association for the specified association ID.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociationVersionsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAssociationVersionsError>`](crate::error::ListAssociationVersionsError)
    pub fn list_association_versions(&self) -> fluent_builders::ListAssociationVersions {
        fluent_builders::ListAssociationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCommandInvocations`](crate::client::fluent_builders::ListCommandInvocations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCommandInvocations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`command_id(impl Into<String>)`](crate::client::fluent_builders::ListCommandInvocations::command_id) / [`set_command_id(Option<String>)`](crate::client::fluent_builders::ListCommandInvocations::set_command_id): <p>(Optional) The invocations for a specific command ID.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListCommandInvocations::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListCommandInvocations::set_instance_id): <p>(Optional) The command execution details for a specific managed node ID.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCommandInvocations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCommandInvocations::set_max_results): <p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCommandInvocations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCommandInvocations::set_next_token): <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`filters(Vec<CommandFilter>)`](crate::client::fluent_builders::ListCommandInvocations::filters) / [`set_filters(Option<Vec<CommandFilter>>)`](crate::client::fluent_builders::ListCommandInvocations::set_filters): <p>(Optional) One or more filters. Use a filter to return a more specific list of results.</p>
    ///   - [`details(bool)`](crate::client::fluent_builders::ListCommandInvocations::details) / [`set_details(bool)`](crate::client::fluent_builders::ListCommandInvocations::set_details): <p>(Optional) If set this returns the response of the command executions and any command output. The default value is <code>false</code>. </p>
    /// - On success, responds with [`ListCommandInvocationsOutput`](crate::output::ListCommandInvocationsOutput) with field(s):
    ///   - [`command_invocations(Option<Vec<CommandInvocation>>)`](crate::output::ListCommandInvocationsOutput::command_invocations): <p>(Optional) A list of all invocations. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCommandInvocationsOutput::next_token): <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On failure, responds with [`SdkError<ListCommandInvocationsError>`](crate::error::ListCommandInvocationsError)
    pub fn list_command_invocations(&self) -> fluent_builders::ListCommandInvocations {
        fluent_builders::ListCommandInvocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCommands`](crate::client::fluent_builders::ListCommands) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCommands::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`command_id(impl Into<String>)`](crate::client::fluent_builders::ListCommands::command_id) / [`set_command_id(Option<String>)`](crate::client::fluent_builders::ListCommands::set_command_id): <p>(Optional) If provided, lists only the specified command.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListCommands::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListCommands::set_instance_id): <p>(Optional) Lists commands issued against this managed node ID.</p> <note>   <p>You can't specify a managed node ID in the same command that you specify <code>Status</code> = <code>Pending</code>. This is because the command hasn't reached the managed node yet.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCommands::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCommands::set_max_results): <p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCommands::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCommands::set_next_token): <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`filters(Vec<CommandFilter>)`](crate::client::fluent_builders::ListCommands::filters) / [`set_filters(Option<Vec<CommandFilter>>)`](crate::client::fluent_builders::ListCommands::set_filters): <p>(Optional) One or more filters. Use a filter to return a more specific list of results. </p>
    /// - On success, responds with [`ListCommandsOutput`](crate::output::ListCommandsOutput) with field(s):
    ///   - [`commands(Option<Vec<Command>>)`](crate::output::ListCommandsOutput::commands): <p>(Optional) The list of commands requested by the user. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCommandsOutput::next_token): <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On failure, responds with [`SdkError<ListCommandsError>`](crate::error::ListCommandsError)
    pub fn list_commands(&self) -> fluent_builders::ListCommands {
        fluent_builders::ListCommands::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComplianceItems`](crate::client::fluent_builders::ListComplianceItems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComplianceItems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ComplianceStringFilter>)`](crate::client::fluent_builders::ListComplianceItems::filters) / [`set_filters(Option<Vec<ComplianceStringFilter>>)`](crate::client::fluent_builders::ListComplianceItems::set_filters): <p>One or more compliance filters. Use a filter to return a more specific list of results.</p>
    ///   - [`resource_ids(Vec<String>)`](crate::client::fluent_builders::ListComplianceItems::resource_ids) / [`set_resource_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListComplianceItems::set_resource_ids): <p>The ID for the resources from which to get compliance information. Currently, you can only specify one resource ID.</p>
    ///   - [`resource_types(Vec<String>)`](crate::client::fluent_builders::ListComplianceItems::resource_types) / [`set_resource_types(Option<Vec<String>>)`](crate::client::fluent_builders::ListComplianceItems::set_resource_types): <p>The type of resource from which to get compliance information. Currently, the only supported resource type is <code>ManagedInstance</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComplianceItems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComplianceItems::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComplianceItems::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComplianceItems::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`ListComplianceItemsOutput`](crate::output::ListComplianceItemsOutput) with field(s):
    ///   - [`compliance_items(Option<Vec<ComplianceItem>>)`](crate::output::ListComplianceItemsOutput::compliance_items): <p>A list of compliance information for the specified resource ID. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComplianceItemsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListComplianceItemsError>`](crate::error::ListComplianceItemsError)
    pub fn list_compliance_items(&self) -> fluent_builders::ListComplianceItems {
        fluent_builders::ListComplianceItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComplianceSummaries`](crate::client::fluent_builders::ListComplianceSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComplianceSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ComplianceStringFilter>)`](crate::client::fluent_builders::ListComplianceSummaries::filters) / [`set_filters(Option<Vec<ComplianceStringFilter>>)`](crate::client::fluent_builders::ListComplianceSummaries::set_filters): <p>One or more compliance or inventory filters. Use a filter to return a more specific list of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComplianceSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComplianceSummaries::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComplianceSummaries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComplianceSummaries::set_max_results): <p>The maximum number of items to return for this call. Currently, you can specify null or 50. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`ListComplianceSummariesOutput`](crate::output::ListComplianceSummariesOutput) with field(s):
    ///   - [`compliance_summary_items(Option<Vec<ComplianceSummaryItem>>)`](crate::output::ListComplianceSummariesOutput::compliance_summary_items): <p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria that you specified.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComplianceSummariesOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListComplianceSummariesError>`](crate::error::ListComplianceSummariesError)
    pub fn list_compliance_summaries(&self) -> fluent_builders::ListComplianceSummaries {
        fluent_builders::ListComplianceSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDocumentMetadataHistory`](crate::client::fluent_builders::ListDocumentMetadataHistory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::set_name): <p>The name of the change template.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::set_document_version): <p>The version of the change template.</p>
    ///   - [`metadata(DocumentMetadataEnum)`](crate::client::fluent_builders::ListDocumentMetadataHistory::metadata) / [`set_metadata(Option<DocumentMetadataEnum>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::set_metadata): <p>The type of data for which details are being requested. Currently, the only supported value is <code>DocumentReviews</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDocumentMetadataHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDocumentMetadataHistory::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`ListDocumentMetadataHistoryOutput`](crate::output::ListDocumentMetadataHistoryOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::ListDocumentMetadataHistoryOutput::name): <p>The name of the change template.</p>
    ///   - [`document_version(Option<String>)`](crate::output::ListDocumentMetadataHistoryOutput::document_version): <p>The version of the change template.</p>
    ///   - [`author(Option<String>)`](crate::output::ListDocumentMetadataHistoryOutput::author): <p>The user ID of the person in the organization who requested the review of the change template.</p>
    ///   - [`metadata(Option<DocumentMetadataResponseInfo>)`](crate::output::ListDocumentMetadataHistoryOutput::metadata): <p>Information about the response to the change template approval request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDocumentMetadataHistoryOutput::next_token): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDocumentMetadataHistoryError>`](crate::error::ListDocumentMetadataHistoryError)
    pub fn list_document_metadata_history(&self) -> fluent_builders::ListDocumentMetadataHistory {
        fluent_builders::ListDocumentMetadataHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDocuments`](crate::client::fluent_builders::ListDocuments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDocuments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_filter_list(Vec<DocumentFilter>)`](crate::client::fluent_builders::ListDocuments::document_filter_list) / [`set_document_filter_list(Option<Vec<DocumentFilter>>)`](crate::client::fluent_builders::ListDocuments::set_document_filter_list): <p>This data type is deprecated. Instead, use <code>Filters</code>.</p>
    ///   - [`filters(Vec<DocumentKeyValuesFilter>)`](crate::client::fluent_builders::ListDocuments::filters) / [`set_filters(Option<Vec<DocumentKeyValuesFilter>>)`](crate::client::fluent_builders::ListDocuments::set_filters): <p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more specific list of results. For keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p> <note>   <p>This API operation only supports filtering documents by using a single tag key and one or more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code> </p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDocuments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDocuments::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDocuments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDocuments::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`ListDocumentsOutput`](crate::output::ListDocumentsOutput) with field(s):
    ///   - [`document_identifiers(Option<Vec<DocumentIdentifier>>)`](crate::output::ListDocumentsOutput::document_identifiers): <p>The names of the SSM documents.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDocumentsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<ListDocumentsError>`](crate::error::ListDocumentsError)
    pub fn list_documents(&self) -> fluent_builders::ListDocuments {
        fluent_builders::ListDocuments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDocumentVersions`](crate::client::fluent_builders::ListDocumentVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDocumentVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListDocumentVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListDocumentVersions::set_name): <p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDocumentVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDocumentVersions::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDocumentVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDocumentVersions::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`ListDocumentVersionsOutput`](crate::output::ListDocumentVersionsOutput) with field(s):
    ///   - [`document_versions(Option<Vec<DocumentVersionInfo>>)`](crate::output::ListDocumentVersionsOutput::document_versions): <p>The document versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDocumentVersionsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<ListDocumentVersionsError>`](crate::error::ListDocumentVersionsError)
    pub fn list_document_versions(&self) -> fluent_builders::ListDocumentVersions {
        fluent_builders::ListDocumentVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInventoryEntries`](crate::client::fluent_builders::ListInventoryEntries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListInventoryEntries::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListInventoryEntries::set_instance_id): <p>The managed node ID for which you want inventory information.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::ListInventoryEntries::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::ListInventoryEntries::set_type_name): <p>The type of inventory item for which you want information.</p>
    ///   - [`filters(Vec<InventoryFilter>)`](crate::client::fluent_builders::ListInventoryEntries::filters) / [`set_filters(Option<Vec<InventoryFilter>>)`](crate::client::fluent_builders::ListInventoryEntries::set_filters): <p>One or more filters. Use a filter to return a more specific list of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInventoryEntries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInventoryEntries::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInventoryEntries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInventoryEntries::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`ListInventoryEntriesOutput`](crate::output::ListInventoryEntriesOutput) with field(s):
    ///   - [`type_name(Option<String>)`](crate::output::ListInventoryEntriesOutput::type_name): <p>The type of inventory item returned by the request.</p>
    ///   - [`instance_id(Option<String>)`](crate::output::ListInventoryEntriesOutput::instance_id): <p>The managed node ID targeted by the request to query inventory information.</p>
    ///   - [`schema_version(Option<String>)`](crate::output::ListInventoryEntriesOutput::schema_version): <p>The inventory schema version used by the managed node(s).</p>
    ///   - [`capture_time(Option<String>)`](crate::output::ListInventoryEntriesOutput::capture_time): <p>The time that inventory information was collected for the managed node(s).</p>
    ///   - [`entries(Option<Vec<HashMap<String, String>>>)`](crate::output::ListInventoryEntriesOutput::entries): <p>A list of inventory items on the managed node(s).</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInventoryEntriesOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    /// - On failure, responds with [`SdkError<ListInventoryEntriesError>`](crate::error::ListInventoryEntriesError)
    pub fn list_inventory_entries(&self) -> fluent_builders::ListInventoryEntries {
        fluent_builders::ListInventoryEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOpsItemEvents`](crate::client::fluent_builders::ListOpsItemEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOpsItemEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<OpsItemEventFilter>)`](crate::client::fluent_builders::ListOpsItemEvents::filters) / [`set_filters(Option<Vec<OpsItemEventFilter>>)`](crate::client::fluent_builders::ListOpsItemEvents::set_filters): <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOpsItemEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOpsItemEvents::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOpsItemEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOpsItemEvents::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    /// - On success, responds with [`ListOpsItemEventsOutput`](crate::output::ListOpsItemEventsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListOpsItemEventsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results. </p>
    ///   - [`summaries(Option<Vec<OpsItemEventSummary>>)`](crate::output::ListOpsItemEventsOutput::summaries): <p>A list of event information for the specified OpsItems.</p>
    /// - On failure, responds with [`SdkError<ListOpsItemEventsError>`](crate::error::ListOpsItemEventsError)
    pub fn list_ops_item_events(&self) -> fluent_builders::ListOpsItemEvents {
        fluent_builders::ListOpsItemEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOpsItemRelatedItems`](crate::client::fluent_builders::ListOpsItemRelatedItems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOpsItemRelatedItems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_item_id(impl Into<String>)`](crate::client::fluent_builders::ListOpsItemRelatedItems::ops_item_id) / [`set_ops_item_id(Option<String>)`](crate::client::fluent_builders::ListOpsItemRelatedItems::set_ops_item_id): <p>The ID of the OpsItem for which you want to list all related-item resources.</p>
    ///   - [`filters(Vec<OpsItemRelatedItemsFilter>)`](crate::client::fluent_builders::ListOpsItemRelatedItems::filters) / [`set_filters(Option<Vec<OpsItemRelatedItemsFilter>>)`](crate::client::fluent_builders::ListOpsItemRelatedItems::set_filters): <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOpsItemRelatedItems::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOpsItemRelatedItems::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOpsItemRelatedItems::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOpsItemRelatedItems::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    /// - On success, responds with [`ListOpsItemRelatedItemsOutput`](crate::output::ListOpsItemRelatedItemsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListOpsItemRelatedItemsOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    ///   - [`summaries(Option<Vec<OpsItemRelatedItemSummary>>)`](crate::output::ListOpsItemRelatedItemsOutput::summaries): <p>A list of related-item resources for the specified OpsItem.</p>
    /// - On failure, responds with [`SdkError<ListOpsItemRelatedItemsError>`](crate::error::ListOpsItemRelatedItemsError)
    pub fn list_ops_item_related_items(&self) -> fluent_builders::ListOpsItemRelatedItems {
        fluent_builders::ListOpsItemRelatedItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOpsMetadata`](crate::client::fluent_builders::ListOpsMetadata) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOpsMetadata::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<OpsMetadataFilter>)`](crate::client::fluent_builders::ListOpsMetadata::filters) / [`set_filters(Option<Vec<OpsMetadataFilter>>)`](crate::client::fluent_builders::ListOpsMetadata::set_filters): <p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOpsMetadata::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListOpsMetadata::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOpsMetadata::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOpsMetadata::set_next_token): <p>A token to start the list. Use this token to get the next set of results.</p>
    /// - On success, responds with [`ListOpsMetadataOutput`](crate::output::ListOpsMetadataOutput) with field(s):
    ///   - [`ops_metadata_list(Option<Vec<OpsMetadata>>)`](crate::output::ListOpsMetadataOutput::ops_metadata_list): <p>Returns a list of OpsMetadata objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOpsMetadataOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListOpsMetadataError>`](crate::error::ListOpsMetadataError)
    pub fn list_ops_metadata(&self) -> fluent_builders::ListOpsMetadata {
        fluent_builders::ListOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceComplianceSummaries`](crate::client::fluent_builders::ListResourceComplianceSummaries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceComplianceSummaries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<ComplianceStringFilter>)`](crate::client::fluent_builders::ListResourceComplianceSummaries::filters) / [`set_filters(Option<Vec<ComplianceStringFilter>>)`](crate::client::fluent_builders::ListResourceComplianceSummaries::set_filters): <p>One or more filters. Use a filter to return a more specific list of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceComplianceSummaries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceComplianceSummaries::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceComplianceSummaries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourceComplianceSummaries::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`ListResourceComplianceSummariesOutput`](crate::output::ListResourceComplianceSummariesOutput) with field(s):
    ///   - [`resource_compliance_summary_items(Option<Vec<ResourceComplianceSummaryItem>>)`](crate::output::ListResourceComplianceSummariesOutput::resource_compliance_summary_items): <p>A summary count for specified or targeted managed nodes. Summary count includes information about compliant and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you specify. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceComplianceSummariesOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListResourceComplianceSummariesError>`](crate::error::ListResourceComplianceSummariesError)
    pub fn list_resource_compliance_summaries(
        &self,
    ) -> fluent_builders::ListResourceComplianceSummaries {
        fluent_builders::ListResourceComplianceSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceDataSync`](crate::client::fluent_builders::ListResourceDataSync) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceDataSync::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sync_type(impl Into<String>)`](crate::client::fluent_builders::ListResourceDataSync::sync_type) / [`set_sync_type(Option<String>)`](crate::client::fluent_builders::ListResourceDataSync::set_sync_type): <p>View a list of resource data syncs according to the sync type. Specify <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations or from multiple Amazon Web Services Regions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceDataSync::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceDataSync::set_next_token): <p>A token to start the list. Use this token to get the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceDataSync::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourceDataSync::set_max_results): <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
    /// - On success, responds with [`ListResourceDataSyncOutput`](crate::output::ListResourceDataSyncOutput) with field(s):
    ///   - [`resource_data_sync_items(Option<Vec<ResourceDataSyncItem>>)`](crate::output::ListResourceDataSyncOutput::resource_data_sync_items): <p>A list of your current resource data sync configurations and their statuses.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceDataSyncOutput::next_token): <p>The token for the next set of items to return. Use this token to get the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListResourceDataSyncError>`](crate::error::ListResourceDataSyncError)
    pub fn list_resource_data_sync(&self) -> fluent_builders::ListResourceDataSync {
        fluent_builders::ListResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(ResourceTypeForTagging)`](crate::client::fluent_builders::ListTagsForResource::resource_type) / [`set_resource_type(Option<ResourceTypeForTagging>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_type): <p>Returns a list of tags for a specific resource type.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_id): <p>The resource ID for which you want to see a list of tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>A list of tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDocumentPermission`](crate::client::fluent_builders::ModifyDocumentPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ModifyDocumentPermission::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ModifyDocumentPermission::set_name): <p>The name of the document that you want to share.</p>
    ///   - [`permission_type(DocumentPermissionType)`](crate::client::fluent_builders::ModifyDocumentPermission::permission_type) / [`set_permission_type(Option<DocumentPermissionType>)`](crate::client::fluent_builders::ModifyDocumentPermission::set_permission_type): <p>The permission type for the document. The permission type can be <i>Share</i>.</p>
    ///   - [`account_ids_to_add(Vec<String>)`](crate::client::fluent_builders::ModifyDocumentPermission::account_ids_to_add) / [`set_account_ids_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDocumentPermission::set_account_ids_to_add): <p>The Amazon Web Services user accounts that should have access to the document. The account IDs can either be a group of account IDs or <i>All</i>.</p>
    ///   - [`account_ids_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyDocumentPermission::account_ids_to_remove) / [`set_account_ids_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDocumentPermission::set_account_ids_to_remove): <p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services user account can either be a group of account IDs or <i>All</i>. This action has a higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system removes access to the document.</p>
    ///   - [`shared_document_version(impl Into<String>)`](crate::client::fluent_builders::ModifyDocumentPermission::shared_document_version) / [`set_shared_document_version(Option<String>)`](crate::client::fluent_builders::ModifyDocumentPermission::set_shared_document_version): <p>(Optional) The version of the document to share. If it isn't specified, the system choose the <code>Default</code> version to share.</p>
    /// - On success, responds with [`ModifyDocumentPermissionOutput`](crate::output::ModifyDocumentPermissionOutput)

    /// - On failure, responds with [`SdkError<ModifyDocumentPermissionError>`](crate::error::ModifyDocumentPermissionError)
    pub fn modify_document_permission(&self) -> fluent_builders::ModifyDocumentPermission {
        fluent_builders::ModifyDocumentPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutComplianceItems`](crate::client::fluent_builders::PutComplianceItems) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::PutComplianceItems::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::PutComplianceItems::set_resource_id): <p>Specify an ID for this resource. For a managed node, this is the node ID.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::PutComplianceItems::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::PutComplianceItems::set_resource_type): <p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>
    ///   - [`compliance_type(impl Into<String>)`](crate::client::fluent_builders::PutComplianceItems::compliance_type) / [`set_compliance_type(Option<String>)`](crate::client::fluent_builders::PutComplianceItems::set_compliance_type): <p>Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or Custom:<code>string</code>.</p>
    ///   - [`execution_summary(ComplianceExecutionSummary)`](crate::client::fluent_builders::PutComplianceItems::execution_summary) / [`set_execution_summary(Option<ComplianceExecutionSummary>)`](crate::client::fluent_builders::PutComplianceItems::set_execution_summary): <p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
    ///   - [`items(Vec<ComplianceItemEntry>)`](crate::client::fluent_builders::PutComplianceItems::items) / [`set_items(Option<Vec<ComplianceItemEntry>>)`](crate::client::fluent_builders::PutComplianceItems::set_items): <p>Information about the compliance as defined by the resource type. For example, for a patch compliance type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.</p>
    ///   - [`item_content_hash(impl Into<String>)`](crate::client::fluent_builders::PutComplianceItems::item_content_hash) / [`set_item_content_hash(Option<String>)`](crate::client::fluent_builders::PutComplianceItems::set_item_content_hash): <p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten or ignored. If the content hashes match, the request to put compliance information is ignored.</p>
    ///   - [`upload_type(ComplianceUploadType)`](crate::client::fluent_builders::PutComplianceItems::upload_type) / [`set_upload_type(Option<ComplianceUploadType>)`](crate::client::fluent_builders::PutComplianceItems::set_upload_type): <p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You must provide a full list of compliance items each time you send the request.</p>  <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p> <note>   <p>This attribute is only valid for association compliance.</p>  </note>
    /// - On success, responds with [`PutComplianceItemsOutput`](crate::output::PutComplianceItemsOutput)

    /// - On failure, responds with [`SdkError<PutComplianceItemsError>`](crate::error::PutComplianceItemsError)
    pub fn put_compliance_items(&self) -> fluent_builders::PutComplianceItems {
        fluent_builders::PutComplianceItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutInventory`](crate::client::fluent_builders::PutInventory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::PutInventory::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::PutInventory::set_instance_id): <p>An managed node ID where you want to add or update inventory items.</p>
    ///   - [`items(Vec<InventoryItem>)`](crate::client::fluent_builders::PutInventory::items) / [`set_items(Option<Vec<InventoryItem>>)`](crate::client::fluent_builders::PutInventory::set_items): <p>The inventory items that you want to add or update on managed nodes.</p>
    /// - On success, responds with [`PutInventoryOutput`](crate::output::PutInventoryOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::PutInventoryOutput::message): <p>Information about the request.</p>
    /// - On failure, responds with [`SdkError<PutInventoryError>`](crate::error::PutInventoryError)
    pub fn put_inventory(&self) -> fluent_builders::PutInventory {
        fluent_builders::PutInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutParameter`](crate::client::fluent_builders::PutParameter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutParameter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutParameter::set_name): <p>The fully qualified name of the parameter that you want to add to the system. The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: <code>/Dev/DBServer/MySQL/db-string13</code> </p>  <p>Naming Constraints:</p>  <ul>   <li> <p>Parameter names are case sensitive.</p> </li>   <li> <p>A parameter name must be unique within an Amazon Web Services Region</p> </li>   <li> <p>A parameter name can't be prefixed with "<code>aws</code>" or "<code>ssm</code>" (case-insensitive).</p> </li>   <li> <p>Parameter names can include only the following symbols and letters: <code>a-zA-Z0-9_.-</code> </p> <p>In addition, the slash character ( / ) is used to delineate hierarchies in parameter names. For example: <code>/Dev/Production/East/Project-ABC/MyParameter</code> </p> </li>   <li> <p>A parameter name can't include spaces.</p> </li>   <li> <p>Parameter hierarchies are limited to a maximum depth of fifteen levels.</p> </li>  </ul>  <p>For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note>   <p>The maximum length constraint listed below includes capacity for additional system attributes that aren't part of the name. The maximum length for a parameter name, including the full length of the parameter ARN, is 1011 characters. For example, the length of the following parameter name is 65 characters, not 20 characters:</p>   <p> <code>arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName</code> </p>  </note>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutParameter::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutParameter::set_description): <p>Information about the parameter that you want to add to the system. Optional but recommended.</p> <important>   <p>Don't enter personally identifiable information in this field.</p>  </important>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::PutParameter::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::PutParameter::set_value): <p>The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.</p> <note>   <p>Parameters can't be referenced or nested in the values of other parameters. You can't include <code>{{}}</code> or <code>{{ssm:<i>parameter-name</i>}}</code> in a parameter value.</p>  </note>
    ///   - [`r#type(ParameterType)`](crate::client::fluent_builders::PutParameter::type) / [`set_type(Option<ParameterType>)`](crate::client::fluent_builders::PutParameter::set_type): <p>The type of parameter that you want to add to the system.</p> <note>   <p> <code>SecureString</code> isn't currently supported for CloudFormation templates.</p>  </note>  <p>Items in a <code>StringList</code> must be separated by a comma (,). You can't use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the <code>String</code> data type.</p> <important>   <p>Specifying a parameter type isn't required when updating a parameter. You must specify a parameter type when creating a parameter.</p>  </important>
    ///   - [`key_id(impl Into<String>)`](crate::client::fluent_builders::PutParameter::key_id) / [`set_key_id(Option<String>)`](crate::client::fluent_builders::PutParameter::set_key_id): <p>The Key Management Service (KMS) ID that you want to use to encrypt a parameter. Either the default KMS key automatically assigned to your Amazon Web Services account or a custom key. Required for parameters that use the <code>SecureString</code> data type.</p>  <p>If you don't specify a key ID, the system uses the default key associated with your Amazon Web Services account.</p>  <ul>   <li> <p>To use your default KMS key, choose the <code>SecureString</code> data type, and do <i>not</i> specify the <code>Key ID</code> when you create the parameter. The system automatically populates <code>Key ID</code> with your default KMS key.</p> </li>   <li> <p>To use a custom KMS key, choose the <code>SecureString</code> data type with the <code>Key ID</code> parameter.</p> </li>  </ul>
    ///   - [`overwrite(bool)`](crate::client::fluent_builders::PutParameter::overwrite) / [`set_overwrite(Option<bool>)`](crate::client::fluent_builders::PutParameter::set_overwrite): <p>Overwrite an existing parameter. The default value is <code>false</code>.</p>
    ///   - [`allowed_pattern(impl Into<String>)`](crate::client::fluent_builders::PutParameter::allowed_pattern) / [`set_allowed_pattern(Option<String>)`](crate::client::fluent_builders::PutParameter::set_allowed_pattern): <p>A regular expression used to validate the parameter value. For example, for String types with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$ </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutParameter::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutParameter::set_tags): <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a Systems Manager parameter to identify the type of resource to which it applies, the environment, or the type of configuration data referenced by the parameter. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=Resource,Value=S3bucket</code> </p> </li>   <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>   <li> <p> <code>Key=ParameterType,Value=LicenseKey</code> </p> </li>  </ul> <note>   <p>To add tags to an existing Systems Manager parameter, use the <code>AddTagsToResource</code> operation.</p>  </note>
    ///   - [`tier(ParameterTier)`](crate::client::fluent_builders::PutParameter::tier) / [`set_tier(Option<ParameterTier>)`](crate::client::fluent_builders::PutParameter::set_tier): <p>The parameter tier to assign to a parameter.</p>  <p>Parameter Store offers a standard tier and an advanced tier for parameters. Standard parameters have a content size limit of 4 KB and can't be configured to use parameter policies. You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account. Standard parameters are offered at no additional cost. </p>  <p>Advanced parameters have a content size limit of 8 KB and can be configured to use parameter policies. You can create a maximum of 100,000 advanced parameters for each Region in an Amazon Web Services account. Advanced parameters incur a charge. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html">Standard and advanced parameter tiers</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>  <p>You can change a standard parameter to an advanced parameter any time. But you can't revert an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard parameter would result in data loss because the system would truncate the size of the parameter from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly, advanced parameters use a different form of encryption than standard parameters. </p>  <p>If you no longer need an advanced parameter, or if you no longer want to incur charges for an advanced parameter, you must delete it and recreate it as a new standard parameter. </p>  <p> <b>Using the Default Tier Configuration</b> </p>  <p>In <code>PutParameter</code> requests, you can specify the tier to create the parameter in. Whenever you specify a tier in the request, Parameter Store creates or updates the parameter according to that request. However, if you don't specify a tier in a request, Parameter Store assigns the tier based on the current Parameter Store default tier configuration.</p>  <p>The default tier when you begin using Parameter Store is the standard-parameter tier. If you use the advanced-parameter tier, you can specify one of the following as the default:</p>  <ul>   <li> <p> <b>Advanced</b>: With this option, Parameter Store evaluates all requests as advanced parameters. </p> </li>   <li> <p> <b>Intelligent-Tiering</b>: With this option, Parameter Store evaluates each request to determine if the parameter is standard or advanced. </p> <p>If the request doesn't include any options that require an advanced parameter, the parameter is created in the standard-parameter tier. If one or more options requiring an advanced parameter are included in the request, Parameter Store create a parameter in the advanced-parameter tier.</p> <p>This approach helps control your parameter-related costs by always creating standard parameters unless an advanced parameter is necessary. </p> </li>  </ul>  <p>Options that require an advanced parameter include the following:</p>  <ul>   <li> <p>The content size of the parameter is more than 4 KB.</p> </li>   <li> <p>The parameter uses a parameter policy.</p> </li>   <li> <p>More than 10,000 parameters already exist in your Amazon Web Services account in the current Amazon Web Services Region.</p> </li>  </ul>  <p>For more information about configuring the default tier option, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html">Specifying a default parameter tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`policies(impl Into<String>)`](crate::client::fluent_builders::PutParameter::policies) / [`set_policies(Option<String>)`](crate::client::fluent_builders::PutParameter::set_policies): <p>One or more policies to apply to a parameter. This operation takes a JSON array. Parameter Store, a capability of Amazon Web Services Systems Manager supports the following policy types:</p>  <p>Expiration: This policy deletes the parameter after it expires. When you create the policy, you specify the expiration date. You can update the expiration date and time by updating the policy. Updating the <i>parameter</i> doesn't affect the expiration date and time. When the expiration time is reached, Parameter Store deletes the parameter.</p>  <p>ExpirationNotification: This policy initiates an event in Amazon CloudWatch Events that notifies you about the expiration. By using this policy, you can receive notification before or after the expiration time is reached, in units of days or hours.</p>  <p>NoChangeNotification: This policy initiates a CloudWatch Events event if a parameter hasn't been modified for a specified period of time. This policy type is useful when, for example, a secret needs to be changed within a period of time, but it hasn't been changed.</p>  <p>All existing policies are preserved until you send new policies or an empty policy. For more information about parameter policies, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter policies</a>. </p>
    ///   - [`data_type(impl Into<String>)`](crate::client::fluent_builders::PutParameter::data_type) / [`set_data_type(Option<String>)`](crate::client::fluent_builders::PutParameter::set_data_type): <p>The data type for a <code>String</code> parameter. Supported data types include plain text and Amazon Machine Image (AMI) IDs.</p>  <p> <b>The following data type values are supported.</b> </p>  <ul>   <li> <p> <code>text</code> </p> </li>   <li> <p> <code>aws:ec2:image</code> </p> </li>   <li> <p> <code>aws:ssm:integration</code> </p> </li>  </ul>  <p>When you create a <code>String</code> parameter and specify <code>aws:ec2:image</code>, Amazon Web Services Systems Manager validates the parameter value is in the required format, such as <code>ami-12345abcdeEXAMPLE</code>, and that the specified AMI is available in your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html">Native parameter support for Amazon Machine Image (AMI) IDs</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// - On success, responds with [`PutParameterOutput`](crate::output::PutParameterOutput) with field(s):
    ///   - [`version(i64)`](crate::output::PutParameterOutput::version): <p>The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new version and assigns this new version a unique ID. You can reference a parameter version ID in API operations or in Systems Manager documents (SSM documents). By default, if you don't specify a specific version, the system returns the latest parameter value when a parameter is called.</p>
    ///   - [`tier(Option<ParameterTier>)`](crate::output::PutParameterOutput::tier): <p>The tier assigned to the parameter.</p>
    /// - On failure, responds with [`SdkError<PutParameterError>`](crate::error::PutParameterError)
    pub fn put_parameter(&self) -> fluent_builders::PutParameter {
        fluent_builders::PutParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterDefaultPatchBaseline`](crate::client::fluent_builders::RegisterDefaultPatchBaseline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`baseline_id(impl Into<String>)`](crate::client::fluent_builders::RegisterDefaultPatchBaseline::baseline_id) / [`set_baseline_id(Option<String>)`](crate::client::fluent_builders::RegisterDefaultPatchBaseline::set_baseline_id): <p>The ID of the patch baseline that should be the default patch baseline.</p>
    /// - On success, responds with [`RegisterDefaultPatchBaselineOutput`](crate::output::RegisterDefaultPatchBaselineOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::RegisterDefaultPatchBaselineOutput::baseline_id): <p>The ID of the default patch baseline.</p>
    /// - On failure, responds with [`SdkError<RegisterDefaultPatchBaselineError>`](crate::error::RegisterDefaultPatchBaselineError)
    pub fn register_default_patch_baseline(&self) -> fluent_builders::RegisterDefaultPatchBaseline {
        fluent_builders::RegisterDefaultPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterPatchBaselineForPatchGroup`](crate::client::fluent_builders::RegisterPatchBaselineForPatchGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`baseline_id(impl Into<String>)`](crate::client::fluent_builders::RegisterPatchBaselineForPatchGroup::baseline_id) / [`set_baseline_id(Option<String>)`](crate::client::fluent_builders::RegisterPatchBaselineForPatchGroup::set_baseline_id): <p>The ID of the patch baseline to register with the patch group.</p>
    ///   - [`patch_group(impl Into<String>)`](crate::client::fluent_builders::RegisterPatchBaselineForPatchGroup::patch_group) / [`set_patch_group(Option<String>)`](crate::client::fluent_builders::RegisterPatchBaselineForPatchGroup::set_patch_group): <p>The name of the patch group to be registered with the patch baseline.</p>
    /// - On success, responds with [`RegisterPatchBaselineForPatchGroupOutput`](crate::output::RegisterPatchBaselineForPatchGroupOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::RegisterPatchBaselineForPatchGroupOutput::baseline_id): <p>The ID of the patch baseline the patch group was registered with.</p>
    ///   - [`patch_group(Option<String>)`](crate::output::RegisterPatchBaselineForPatchGroupOutput::patch_group): <p>The name of the patch group registered with the patch baseline.</p>
    /// - On failure, responds with [`SdkError<RegisterPatchBaselineForPatchGroupError>`](crate::error::RegisterPatchBaselineForPatchGroupError)
    pub fn register_patch_baseline_for_patch_group(
        &self,
    ) -> fluent_builders::RegisterPatchBaselineForPatchGroup {
        fluent_builders::RegisterPatchBaselineForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterTargetWithMaintenanceWindow`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::set_window_id): <p>The ID of the maintenance window the target should be registered with.</p>
    ///   - [`resource_type(MaintenanceWindowResourceType)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::resource_type) / [`set_resource_type(Option<MaintenanceWindowResourceType>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::set_resource_type): <p>The type of target being registered with the maintenance window.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::set_targets): <p>The targets to register with the maintenance window. In other words, the managed nodes to run commands on when the maintenance window runs.</p> <note>   <p>If a single maintenance window task is registered with multiple targets, its task invocations occur sequentially and not in parallel. If your task must run on multiple targets at the same time, register a task for each target individually and assign each task the same priority level.</p>  </note>  <p>You can specify targets using managed node IDs, resource group names, or tags that have been applied to managed nodes.</p>  <p> <b>Example 1</b>: Specify managed node IDs</p>  <p> <code>Key=InstanceIds,Values=   <instance-id-1>    ,    <instance-id-2>     ,     <instance-id-3></instance-id-3>    </instance-id-2>   </instance-id-1></code> </p>  <p> <b>Example 2</b>: Use tag key-pairs applied to managed nodes</p>  <p> <code>Key=tag:   <my-tag-key>    ,Values=    <my-tag-value-1>     ,     <my-tag-value-2></my-tag-value-2>    </my-tag-value-1>   </my-tag-key></code> </p>  <p> <b>Example 3</b>: Use tag-keys applied to managed nodes</p>  <p> <code>Key=tag-key,Values=   <my-tag-key-1>    ,    <my-tag-key-2></my-tag-key-2>   </my-tag-key-1></code> </p>  <p> <b>Example 4</b>: Use resource group names</p>  <p> <code>Key=resource-groups:Name,Values=   <resource-group-name></resource-group-name></code> </p>  <p> <b>Example 5</b>: Use filters for resource group types</p>  <p> <code>Key=resource-groups:ResourceTypeFilters,Values=   <resource-type-1>    ,    <resource-type-2></resource-type-2>   </resource-type-1></code> </p> <note>   <p>For <code>Key=resource-groups:ResourceTypeFilters</code>, specify resource types in the following format</p>   <p> <code>Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC</code> </p>  </note>  <p>For more information about these examples formats, including the best use case for each one, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html">Examples: Register targets with a maintenance window</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`owner_information(impl Into<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::owner_information) / [`set_owner_information(Option<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::set_owner_information): <p>User-provided value that will be included in any Amazon CloudWatch Events events raised while running tasks for these targets in this maintenance window.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::set_name): <p>An optional name for the target.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::set_description): <p>An optional description for the target.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow::set_client_token): <p>User-provided idempotency token.</p>
    /// - On success, responds with [`RegisterTargetWithMaintenanceWindowOutput`](crate::output::RegisterTargetWithMaintenanceWindowOutput) with field(s):
    ///   - [`window_target_id(Option<String>)`](crate::output::RegisterTargetWithMaintenanceWindowOutput::window_target_id): <p>The ID of the target definition in this maintenance window.</p>
    /// - On failure, responds with [`SdkError<RegisterTargetWithMaintenanceWindowError>`](crate::error::RegisterTargetWithMaintenanceWindowError)
    pub fn register_target_with_maintenance_window(
        &self,
    ) -> fluent_builders::RegisterTargetWithMaintenanceWindow {
        fluent_builders::RegisterTargetWithMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterTaskWithMaintenanceWindow`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_window_id): <p>The ID of the maintenance window the task should be added to.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_targets): <p>The targets (either managed nodes or maintenance window targets).</p> <note>   <p>One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>  </note>  <p>Specify managed nodes using the following format: </p>  <p> <code>Key=InstanceIds,Values=   <instance-id-1>    ,    <instance-id-2></instance-id-2>   </instance-id-1></code> </p>  <p>Specify maintenance window targets using the following format:</p>  <p> <code>Key=WindowTargetIds,Values=   <window-target-id-1>    ,    <window-target-id-2></window-target-id-2>   </window-target-id-1></code> </p>
    ///   - [`task_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::task_arn) / [`set_task_arn(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_task_arn): <p>The ARN of the task to run.</p>
    ///   - [`service_role_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::service_role_arn) / [`set_service_role_arn(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_service_role_arn): <p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p>  <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using service-linked roles for Systems Manager</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks? </a> </p> </li>  </ul>
    ///   - [`task_type(MaintenanceWindowTaskType)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::task_type) / [`set_task_type(Option<MaintenanceWindowTaskType>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_task_type): <p>The type of task being registered.</p>
    ///   - [`task_parameters(HashMap<String, MaintenanceWindowTaskParameterValueExpression>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::task_parameters) / [`set_task_parameters(Option<HashMap<String, MaintenanceWindowTaskParameterValueExpression>>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_task_parameters): <p>The parameters that should be passed to the task when it is run.</p> <note>   <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>
    ///   - [`task_invocation_parameters(MaintenanceWindowTaskInvocationParameters)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::task_invocation_parameters) / [`set_task_invocation_parameters(Option<MaintenanceWindowTaskInvocationParameters>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_task_invocation_parameters): <p>The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty. </p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_priority): <p>The priority of the task in the maintenance window, the lower the number the higher the priority. Tasks in a maintenance window are scheduled in priority order with tasks that have the same priority scheduled in parallel.</p>
    ///   - [`max_concurrency(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::max_concurrency) / [`set_max_concurrency(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_max_concurrency): <p>The maximum number of targets this task can be run for, in parallel.</p> <note>   <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p>   <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.</p>  </note>
    ///   - [`max_errors(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::max_errors) / [`set_max_errors(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_max_errors): <p>The maximum number of errors allowed before this task stops being scheduled.</p> <note>   <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p>   <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.</p>  </note>
    ///   - [`logging_info(LoggingInfo)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::logging_info) / [`set_logging_info(Option<LoggingInfo>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_logging_info): <p>A structure containing information about an Amazon Simple Storage Service (Amazon S3) bucket to write managed node-level logs to. </p> <note>   <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_name): <p>An optional name for the task.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_description): <p>An optional description for the task.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_client_token): <p>User-provided idempotency token.</p>
    ///   - [`cutoff_behavior(MaintenanceWindowTaskCutoffBehavior)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::cutoff_behavior) / [`set_cutoff_behavior(Option<MaintenanceWindowTaskCutoffBehavior>)`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow::set_cutoff_behavior): <p>Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>  <ul>   <li> <p> <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default value.</p> </li>   <li> <p> <code>CANCEL_TASK</code>:</p>    <ul>     <li> <p>For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are already running continue, but no new task invocations are started.</p> </li>     <li> <p>For Run Command tasks: When the cutoff time is reached, the system sends a <code>CancelCommand</code> operation that attempts to cancel the command associated with the task. However, there is no guarantee that the command will be terminated and the underlying process stopped.</p> </li>    </ul> <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p> </li>  </ul>
    /// - On success, responds with [`RegisterTaskWithMaintenanceWindowOutput`](crate::output::RegisterTaskWithMaintenanceWindowOutput) with field(s):
    ///   - [`window_task_id(Option<String>)`](crate::output::RegisterTaskWithMaintenanceWindowOutput::window_task_id): <p>The ID of the task in the maintenance window.</p>
    /// - On failure, responds with [`SdkError<RegisterTaskWithMaintenanceWindowError>`](crate::error::RegisterTaskWithMaintenanceWindowError)
    pub fn register_task_with_maintenance_window(
        &self,
    ) -> fluent_builders::RegisterTaskWithMaintenanceWindow {
        fluent_builders::RegisterTaskWithMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(ResourceTypeForTagging)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_type) / [`set_resource_type(Option<ResourceTypeForTagging>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_type): <p>The type of resource from which you want to remove a tag.</p> <note>   <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p>  </note>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_id): <p>The ID of the resource from which you want to remove tags. For example:</p>  <p>ManagedInstance: mi-012345abcde</p>  <p>MaintenanceWindow: mw-012345abcde</p>  <p>PatchBaseline: pb-012345abcde</p>  <p>OpsMetadata object: <code>ResourceID</code> for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or <code>/aws/ssm/MyGroup/appmanager</code>.</p>  <p>For the Document and Parameter values, use the name of the resource.</p> <note>   <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.</p>  </note>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_keys): <p>Tag keys that you want to remove from the specified resource.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetServiceSetting`](crate::client::fluent_builders::ResetServiceSetting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`setting_id(impl Into<String>)`](crate::client::fluent_builders::ResetServiceSetting::setting_id) / [`set_setting_id(Option<String>)`](crate::client::fluent_builders::ResetServiceSetting::set_setting_id): <p>The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be one of the following.</p>  <ul>   <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li>   <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li>   <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li>   <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li>   <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li>   <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li>  </ul>
    /// - On success, responds with [`ResetServiceSettingOutput`](crate::output::ResetServiceSettingOutput) with field(s):
    ///   - [`service_setting(Option<ServiceSetting>)`](crate::output::ResetServiceSettingOutput::service_setting): <p>The current, effective service setting after calling the ResetServiceSetting API operation.</p>
    /// - On failure, responds with [`SdkError<ResetServiceSettingError>`](crate::error::ResetServiceSettingError)
    pub fn reset_service_setting(&self) -> fluent_builders::ResetServiceSetting {
        fluent_builders::ResetServiceSetting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResumeSession`](crate::client::fluent_builders::ResumeSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::ResumeSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::ResumeSession::set_session_id): <p>The ID of the disconnected session to resume.</p>
    /// - On success, responds with [`ResumeSessionOutput`](crate::output::ResumeSessionOutput) with field(s):
    ///   - [`session_id(Option<String>)`](crate::output::ResumeSessionOutput::session_id): <p>The ID of the session.</p>
    ///   - [`token_value(Option<String>)`](crate::output::ResumeSessionOutput::token_value): <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
    ///   - [`stream_url(Option<String>)`](crate::output::ResumeSessionOutput::stream_url): <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the managed node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>.</p>  <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>  <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
    /// - On failure, responds with [`SdkError<ResumeSessionError>`](crate::error::ResumeSessionError)
    pub fn resume_session(&self) -> fluent_builders::ResumeSession {
        fluent_builders::ResumeSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendAutomationSignal`](crate::client::fluent_builders::SendAutomationSignal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`automation_execution_id(impl Into<String>)`](crate::client::fluent_builders::SendAutomationSignal::automation_execution_id) / [`set_automation_execution_id(Option<String>)`](crate::client::fluent_builders::SendAutomationSignal::set_automation_execution_id): <p>The unique identifier for an existing Automation execution that you want to send the signal to.</p>
    ///   - [`signal_type(SignalType)`](crate::client::fluent_builders::SendAutomationSignal::signal_type) / [`set_signal_type(Option<SignalType>)`](crate::client::fluent_builders::SendAutomationSignal::set_signal_type): <p>The type of signal to send to an Automation execution. </p>
    ///   - [`payload(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::SendAutomationSignal::payload) / [`set_payload(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::SendAutomationSignal::set_payload): <p>The data sent with the signal. The data schema depends on the type of signal used in the request.</p>  <p>For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional comment that you can send with the signal type. For example:</p>  <p> <code>Comment="Looks good"</code> </p>  <p>For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of the Automation step to start or resume as the payload. For example:</p>  <p> <code>StepName="step1"</code> </p>  <p>For the <code>StopStep</code> signal type, you must send the step execution ID as the payload. For example:</p>  <p> <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code> </p>
    /// - On success, responds with [`SendAutomationSignalOutput`](crate::output::SendAutomationSignalOutput)

    /// - On failure, responds with [`SdkError<SendAutomationSignalError>`](crate::error::SendAutomationSignalError)
    pub fn send_automation_signal(&self) -> fluent_builders::SendAutomationSignal {
        fluent_builders::SendAutomationSignal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendCommand`](crate::client::fluent_builders::SendCommand) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::SendCommand::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::SendCommand::set_instance_ids): <p>The IDs of the managed nodes where the command should run. Specifying managed node IDs is most useful when you are targeting a limited number of managed nodes, though you can specify up to 50 IDs.</p>  <p>To target a larger number of managed nodes, or if you prefer not to list individual node IDs, we recommend using the <code>Targets</code> option instead. Using <code>Targets</code>, which accepts tag key-value pairs to identify the managed nodes to send commands to, you can a send command to tens, hundreds, or thousands of nodes at once.</p>  <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Using targets and rate controls to send commands to a fleet</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::SendCommand::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::SendCommand::set_targets): <p>An array of search criteria that targets managed nodes using a <code>Key,Value</code> combination that you specify. Specifying targets is most useful when you want to send a command to a large number of managed nodes at once. Using <code>Targets</code>, which accepts tag key-value pairs to identify managed nodes, you can send a command to tens, hundreds, or thousands of nodes at once.</p>  <p>To send a command to a smaller number of managed nodes, you can use the <code>InstanceIds</code> option instead.</p>  <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending commands to a fleet</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`document_name(impl Into<String>)`](crate::client::fluent_builders::SendCommand::document_name) / [`set_document_name(Option<String>)`](crate::client::fluent_builders::SendCommand::set_document_name): <p>The name of the Amazon Web Services Systems Manager document (SSM document) to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document Amazon Resource Name (ARN). For more information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note>   <p>If you specify a document name or ARN that hasn't been shared with your account, you receive an <code>InvalidDocument</code> error. </p>  </note>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::SendCommand::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::SendCommand::set_document_version): <p>The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a specific version number. If you run commands by using the Command Line Interface (Amazon Web Services CLI), then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example:</p>  <p>--document-version "\$DEFAULT"</p>  <p>--document-version "\$LATEST"</p>  <p>--document-version "3"</p>
    ///   - [`document_hash(impl Into<String>)`](crate::client::fluent_builders::SendCommand::document_hash) / [`set_document_hash(Option<String>)`](crate::client::fluent_builders::SendCommand::set_document_hash): <p>The Sha256 or Sha1 hash created by the system when the document was created. </p> <note>   <p>Sha1 hashes have been deprecated.</p>  </note>
    ///   - [`document_hash_type(DocumentHashType)`](crate::client::fluent_builders::SendCommand::document_hash_type) / [`set_document_hash_type(Option<DocumentHashType>)`](crate::client::fluent_builders::SendCommand::set_document_hash_type): <p>Sha256 or Sha1.</p> <note>   <p>Sha1 hashes have been deprecated.</p>  </note>
    ///   - [`timeout_seconds(i32)`](crate::client::fluent_builders::SendCommand::timeout_seconds) / [`set_timeout_seconds(Option<i32>)`](crate::client::fluent_builders::SendCommand::set_timeout_seconds): <p>If this time is reached and the command hasn't already started running, it won't run.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::SendCommand::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::SendCommand::set_comment): <p>User-specified information about the command, such as a brief description of what the command should do.</p>
    ///   - [`parameters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::SendCommand::parameters) / [`set_parameters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::SendCommand::set_parameters): <p>The required and optional parameters specified in the document being run.</p>
    ///   - [`output_s3_region(impl Into<String>)`](crate::client::fluent_builders::SendCommand::output_s3_region) / [`set_output_s3_region(Option<String>)`](crate::client::fluent_builders::SendCommand::set_output_s3_region): <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Amazon Web Services Region of the S3 bucket.</p>
    ///   - [`output_s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::SendCommand::output_s3_bucket_name) / [`set_output_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::SendCommand::set_output_s3_bucket_name): <p>The name of the S3 bucket where command execution responses should be stored.</p>
    ///   - [`output_s3_key_prefix(impl Into<String>)`](crate::client::fluent_builders::SendCommand::output_s3_key_prefix) / [`set_output_s3_key_prefix(Option<String>)`](crate::client::fluent_builders::SendCommand::set_output_s3_key_prefix): <p>The directory structure within the S3 bucket where the responses should be stored.</p>
    ///   - [`max_concurrency(impl Into<String>)`](crate::client::fluent_builders::SendCommand::max_concurrency) / [`set_max_concurrency(Option<String>)`](crate::client::fluent_builders::SendCommand::set_max_concurrency): <p>(Optional) The maximum number of managed nodes that are allowed to run the command at the same time. You can specify a number such as 10 or a percentage such as 10%. The default value is <code>50</code>. For more information about how to use <code>MaxConcurrency</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity">Using concurrency controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`max_errors(impl Into<String>)`](crate::client::fluent_builders::SendCommand::max_errors) / [`set_max_errors(Option<String>)`](crate::client::fluent_builders::SendCommand::set_max_errors): <p>The maximum number of errors allowed without the command failing. When the command fails one more time beyond the value of <code>MaxErrors</code>, the systems stops sending the command to additional targets. You can specify a number like 10 or a percentage like 10%. The default value is <code>0</code>. For more information about how to use <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors">Using error controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`service_role_arn(impl Into<String>)`](crate::client::fluent_builders::SendCommand::service_role_arn) / [`set_service_role_arn(Option<String>)`](crate::client::fluent_builders::SendCommand::set_service_role_arn): <p>The ARN of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands.</p>
    ///   - [`notification_config(NotificationConfig)`](crate::client::fluent_builders::SendCommand::notification_config) / [`set_notification_config(Option<NotificationConfig>)`](crate::client::fluent_builders::SendCommand::set_notification_config): <p>Configurations for sending notifications.</p>
    ///   - [`cloud_watch_output_config(CloudWatchOutputConfig)`](crate::client::fluent_builders::SendCommand::cloud_watch_output_config) / [`set_cloud_watch_output_config(Option<CloudWatchOutputConfig>)`](crate::client::fluent_builders::SendCommand::set_cloud_watch_output_config): <p>Enables Amazon Web Services Systems Manager to send Run Command output to Amazon CloudWatch Logs. Run Command is a capability of Amazon Web Services Systems Manager.</p>
    /// - On success, responds with [`SendCommandOutput`](crate::output::SendCommandOutput) with field(s):
    ///   - [`command(Option<Command>)`](crate::output::SendCommandOutput::command): <p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>
    /// - On failure, responds with [`SdkError<SendCommandError>`](crate::error::SendCommandError)
    pub fn send_command(&self) -> fluent_builders::SendCommand {
        fluent_builders::SendCommand::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAssociationsOnce`](crate::client::fluent_builders::StartAssociationsOnce) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_ids(Vec<String>)`](crate::client::fluent_builders::StartAssociationsOnce::association_ids) / [`set_association_ids(Option<Vec<String>>)`](crate::client::fluent_builders::StartAssociationsOnce::set_association_ids): <p>The association IDs that you want to run immediately and only one time.</p>
    /// - On success, responds with [`StartAssociationsOnceOutput`](crate::output::StartAssociationsOnceOutput)

    /// - On failure, responds with [`SdkError<StartAssociationsOnceError>`](crate::error::StartAssociationsOnceError)
    pub fn start_associations_once(&self) -> fluent_builders::StartAssociationsOnce {
        fluent_builders::StartAssociationsOnce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAutomationExecution`](crate::client::fluent_builders::StartAutomationExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_name(impl Into<String>)`](crate::client::fluent_builders::StartAutomationExecution::document_name) / [`set_document_name(Option<String>)`](crate::client::fluent_builders::StartAutomationExecution::set_document_name): <p>The name of the SSM document to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document ARN. For more information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::StartAutomationExecution::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::StartAutomationExecution::set_document_version): <p>The version of the Automation runbook to use for this execution.</p>
    ///   - [`parameters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::StartAutomationExecution::parameters) / [`set_parameters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::StartAutomationExecution::set_parameters): <p>A key-value map of execution parameters, which match the declared parameters in the Automation runbook.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartAutomationExecution::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartAutomationExecution::set_client_token): <p>User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can't be reused.</p>
    ///   - [`mode(ExecutionMode)`](crate::client::fluent_builders::StartAutomationExecution::mode) / [`set_mode(Option<ExecutionMode>)`](crate::client::fluent_builders::StartAutomationExecution::set_mode): <p>The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default mode is Auto.</p>
    ///   - [`target_parameter_name(impl Into<String>)`](crate::client::fluent_builders::StartAutomationExecution::target_parameter_name) / [`set_target_parameter_name(Option<String>)`](crate::client::fluent_builders::StartAutomationExecution::set_target_parameter_name): <p>The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify targets.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::StartAutomationExecution::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::StartAutomationExecution::set_targets): <p>A key-value mapping to target resources. Required if you specify TargetParameterName.</p>
    ///   - [`target_maps(Vec<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::StartAutomationExecution::target_maps) / [`set_target_maps(Option<Vec<HashMap<String, Vec<String>>>>)`](crate::client::fluent_builders::StartAutomationExecution::set_target_maps): <p>A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together.</p>
    ///   - [`max_concurrency(impl Into<String>)`](crate::client::fluent_builders::StartAutomationExecution::max_concurrency) / [`set_max_concurrency(Option<String>)`](crate::client::fluent_builders::StartAutomationExecution::set_max_concurrency): <p>The maximum number of targets allowed to run this task in parallel. You can specify a number, such as 10, or a percentage, such as 10%. The default value is <code>10</code>.</p>
    ///   - [`max_errors(impl Into<String>)`](crate::client::fluent_builders::StartAutomationExecution::max_errors) / [`set_max_errors(Option<String>)`](crate::client::fluent_builders::StartAutomationExecution::set_max_errors): <p>The number of errors that are allowed before the system stops running the automation on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops running the automation when the fourth error is received. If you specify 0, then the system stops running the automation on additional targets after the first error result is returned. If you run an automation on 50 resources and set max-errors to 10%, then the system stops running the automation on additional targets when the sixth error is received.</p>  <p>Executions that are already running an automation when max-errors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one at a time.</p>
    ///   - [`target_locations(Vec<TargetLocation>)`](crate::client::fluent_builders::StartAutomationExecution::target_locations) / [`set_target_locations(Option<Vec<TargetLocation>>)`](crate::client::fluent_builders::StartAutomationExecution::set_target_locations): <p>A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the automation. Use this operation to start an automation in multiple Amazon Web Services Regions and multiple Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartAutomationExecution::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartAutomationExecution::set_tags): <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an automation to identify an environment or operating system. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=environment,Value=test</code> </p> </li>   <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>  </ul> <note>   <p>To add tags to an existing patch baseline, use the <code>AddTagsToResource</code> operation.</p>  </note>
    /// - On success, responds with [`StartAutomationExecutionOutput`](crate::output::StartAutomationExecutionOutput) with field(s):
    ///   - [`automation_execution_id(Option<String>)`](crate::output::StartAutomationExecutionOutput::automation_execution_id): <p>The unique ID of a newly scheduled automation execution.</p>
    /// - On failure, responds with [`SdkError<StartAutomationExecutionError>`](crate::error::StartAutomationExecutionError)
    pub fn start_automation_execution(&self) -> fluent_builders::StartAutomationExecution {
        fluent_builders::StartAutomationExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartChangeRequestExecution`](crate::client::fluent_builders::StartChangeRequestExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scheduled_time(DateTime)`](crate::client::fluent_builders::StartChangeRequestExecution::scheduled_time) / [`set_scheduled_time(Option<DateTime>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_scheduled_time): <p>The date and time specified in the change request to run the Automation runbooks.</p> <note>   <p>The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.</p>  </note>
    ///   - [`document_name(impl Into<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::document_name) / [`set_document_name(Option<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_document_name): <p>The name of the change template document to run during the runbook workflow.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_document_version): <p>The version of the change template document to run during the runbook workflow.</p>
    ///   - [`parameters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::StartChangeRequestExecution::parameters) / [`set_parameters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_parameters): <p>A key-value map of parameters that match the declared parameters in the change template document.</p>
    ///   - [`change_request_name(impl Into<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::change_request_name) / [`set_change_request_name(Option<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_change_request_name): <p>The name of the change request associated with the runbook workflow to be run.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_client_token): <p>The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can't be reused.</p>
    ///   - [`auto_approve(bool)`](crate::client::fluent_builders::StartChangeRequestExecution::auto_approve) / [`set_auto_approve(bool)`](crate::client::fluent_builders::StartChangeRequestExecution::set_auto_approve): <p>Indicates whether the change request can be approved automatically without the need for manual approvals.</p>  <p>If <code>AutoApprovable</code> is enabled in a change template, then setting <code>AutoApprove</code> to <code>true</code> in <code>StartChangeRequestExecution</code> creates a change request that bypasses approver review.</p> <note>   <p>Change Calendar restrictions are not bypassed in this scenario. If the state of an associated calendar is <code>CLOSED</code>, change freeze approvers must still grant permission for this change request to run. If they don't, the change won't be processed until the calendar state is again <code>OPEN</code>. </p>  </note>
    ///   - [`runbooks(Vec<Runbook>)`](crate::client::fluent_builders::StartChangeRequestExecution::runbooks) / [`set_runbooks(Option<Vec<Runbook>>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_runbooks): <p>Information about the Automation runbooks that are run during the runbook workflow.</p> <note>   <p>The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartChangeRequestExecution::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_tags): <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a change request to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:</p>  <ul>   <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>   <li> <p> <code>Key=Region,Value=us-east-2</code> </p> </li>  </ul>
    ///   - [`scheduled_end_time(DateTime)`](crate::client::fluent_builders::StartChangeRequestExecution::scheduled_end_time) / [`set_scheduled_end_time(Option<DateTime>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_scheduled_end_time): <p>The time that the requester expects the runbook workflow related to the change request to complete. The time is an estimate only that the requester provides for reviewers.</p>
    ///   - [`change_details(impl Into<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::change_details) / [`set_change_details(Option<String>)`](crate::client::fluent_builders::StartChangeRequestExecution::set_change_details): <p>User-provided details about the change. If no details are provided, content specified in the <b>Template information</b> section of the associated change template is added.</p>
    /// - On success, responds with [`StartChangeRequestExecutionOutput`](crate::output::StartChangeRequestExecutionOutput) with field(s):
    ///   - [`automation_execution_id(Option<String>)`](crate::output::StartChangeRequestExecutionOutput::automation_execution_id): <p>The unique ID of a runbook workflow operation. (A runbook workflow is a type of Automation operation.) </p>
    /// - On failure, responds with [`SdkError<StartChangeRequestExecutionError>`](crate::error::StartChangeRequestExecutionError)
    pub fn start_change_request_execution(&self) -> fluent_builders::StartChangeRequestExecution {
        fluent_builders::StartChangeRequestExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSession`](crate::client::fluent_builders::StartSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target(impl Into<String>)`](crate::client::fluent_builders::StartSession::target) / [`set_target(Option<String>)`](crate::client::fluent_builders::StartSession::set_target): <p>The managed node to connect to for the session.</p>
    ///   - [`document_name(impl Into<String>)`](crate::client::fluent_builders::StartSession::document_name) / [`set_document_name(Option<String>)`](crate::client::fluent_builders::StartSession::set_document_name): <p>The name of the SSM document to define the parameters and plugin settings for the session. For example, <code>SSM-SessionManagerRunShell</code>. You can call the <code>GetDocument</code> API to verify the document exists before attempting to start a session. If no document name is provided, a shell to the managed node is launched by default.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::StartSession::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::StartSession::set_reason): <p>The reason for connecting to the instance. This value is included in the details for the Amazon CloudWatch Events event created when you start the session.</p>
    ///   - [`parameters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::StartSession::parameters) / [`set_parameters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::StartSession::set_parameters): <p>Reserved for future use.</p>
    /// - On success, responds with [`StartSessionOutput`](crate::output::StartSessionOutput) with field(s):
    ///   - [`session_id(Option<String>)`](crate::output::StartSessionOutput::session_id): <p>The ID of the session.</p>
    ///   - [`token_value(Option<String>)`](crate::output::StartSessionOutput::token_value): <p>An encrypted token value containing session and caller information. Used to authenticate the connection to the managed node.</p>
    ///   - [`stream_url(Option<String>)`](crate::output::StartSessionOutput::stream_url): <p>A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code> </p>  <p> <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>Amazon Web Services General Reference</i>.</p>  <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>
    /// - On failure, responds with [`SdkError<StartSessionError>`](crate::error::StartSessionError)
    pub fn start_session(&self) -> fluent_builders::StartSession {
        fluent_builders::StartSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopAutomationExecution`](crate::client::fluent_builders::StopAutomationExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`automation_execution_id(impl Into<String>)`](crate::client::fluent_builders::StopAutomationExecution::automation_execution_id) / [`set_automation_execution_id(Option<String>)`](crate::client::fluent_builders::StopAutomationExecution::set_automation_execution_id): <p>The execution ID of the Automation to stop.</p>
    ///   - [`r#type(StopType)`](crate::client::fluent_builders::StopAutomationExecution::type) / [`set_type(Option<StopType>)`](crate::client::fluent_builders::StopAutomationExecution::set_type): <p>The stop request type. Valid types include the following: Cancel and Complete. The default type is Cancel.</p>
    /// - On success, responds with [`StopAutomationExecutionOutput`](crate::output::StopAutomationExecutionOutput)

    /// - On failure, responds with [`SdkError<StopAutomationExecutionError>`](crate::error::StopAutomationExecutionError)
    pub fn stop_automation_execution(&self) -> fluent_builders::StopAutomationExecution {
        fluent_builders::StopAutomationExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TerminateSession`](crate::client::fluent_builders::TerminateSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::TerminateSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::TerminateSession::set_session_id): <p>The ID of the session to terminate.</p>
    /// - On success, responds with [`TerminateSessionOutput`](crate::output::TerminateSessionOutput) with field(s):
    ///   - [`session_id(Option<String>)`](crate::output::TerminateSessionOutput::session_id): <p>The ID of the session that has been terminated.</p>
    /// - On failure, responds with [`SdkError<TerminateSessionError>`](crate::error::TerminateSessionError)
    pub fn terminate_session(&self) -> fluent_builders::TerminateSession {
        fluent_builders::TerminateSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnlabelParameterVersion`](crate::client::fluent_builders::UnlabelParameterVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UnlabelParameterVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UnlabelParameterVersion::set_name): <p>The name of the parameter from which you want to delete one or more labels.</p>
    ///   - [`parameter_version(i64)`](crate::client::fluent_builders::UnlabelParameterVersion::parameter_version) / [`set_parameter_version(Option<i64>)`](crate::client::fluent_builders::UnlabelParameterVersion::set_parameter_version): <p>The specific version of the parameter which you want to delete one or more labels from. If it isn't present, the call will fail.</p>
    ///   - [`labels(Vec<String>)`](crate::client::fluent_builders::UnlabelParameterVersion::labels) / [`set_labels(Option<Vec<String>>)`](crate::client::fluent_builders::UnlabelParameterVersion::set_labels): <p>One or more labels to delete from the specified parameter version.</p>
    /// - On success, responds with [`UnlabelParameterVersionOutput`](crate::output::UnlabelParameterVersionOutput) with field(s):
    ///   - [`removed_labels(Option<Vec<String>>)`](crate::output::UnlabelParameterVersionOutput::removed_labels): <p>A list of all labels deleted from the parameter.</p>
    ///   - [`invalid_labels(Option<Vec<String>>)`](crate::output::UnlabelParameterVersionOutput::invalid_labels): <p>The labels that aren't attached to the given parameter version.</p>
    /// - On failure, responds with [`SdkError<UnlabelParameterVersionError>`](crate::error::UnlabelParameterVersionError)
    pub fn unlabel_parameter_version(&self) -> fluent_builders::UnlabelParameterVersion {
        fluent_builders::UnlabelParameterVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssociation`](crate::client::fluent_builders::UpdateAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_association_id): <p>The ID of the association you want to update. </p>
    ///   - [`parameters(HashMap<String, Vec<String>>)`](crate::client::fluent_builders::UpdateAssociation::parameters) / [`set_parameters(Option<HashMap<String, Vec<String>>>)`](crate::client::fluent_builders::UpdateAssociation::set_parameters): <p>The parameters you want to update for the association. If you create a parameter using Parameter Store, a capability of Amazon Web Services Systems Manager, you can reference the parameter using <code>{{ssm:parameter-name}}</code>.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_document_version): <p>The document version you want update for the association. </p> <important>   <p>State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code>.</p>  </important>
    ///   - [`schedule_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::schedule_expression) / [`set_schedule_expression(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_schedule_expression): <p>The cron expression used to schedule the association that you want to update.</p>
    ///   - [`output_location(InstanceAssociationOutputLocation)`](crate::client::fluent_builders::UpdateAssociation::output_location) / [`set_output_location(Option<InstanceAssociationOutputLocation>)`](crate::client::fluent_builders::UpdateAssociation::set_output_location): <p>An S3 bucket where you want to store the results of this request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_name): <p>The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.</p>  <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account.</p>  <p>For Systems Manager document (SSM document) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:</p>  <p> <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p>  <p>For example:</p>  <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p>  <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::UpdateAssociation::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::UpdateAssociation::set_targets): <p>The targets of the association.</p>
    ///   - [`association_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::association_name) / [`set_association_name(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_association_name): <p>The name of the association that you want to update.</p>
    ///   - [`association_version(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::association_version) / [`set_association_version(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_association_version): <p>This parameter is provided for concurrency control purposes. You must specify the latest association version in the service. If you want to ensure that this request succeeds, either specify <code>$LATEST</code>, or omit this parameter.</p>
    ///   - [`automation_target_parameter_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::automation_target_parameter_name) / [`set_automation_target_parameter_name(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_automation_target_parameter_name): <p>Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>
    ///   - [`max_errors(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::max_errors) / [`set_max_errors(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_max_errors): <p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p>  <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>
    ///   - [`max_concurrency(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociation::max_concurrency) / [`set_max_concurrency(Option<String>)`](crate::client::fluent_builders::UpdateAssociation::set_max_concurrency): <p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p>  <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>
    ///   - [`compliance_severity(AssociationComplianceSeverity)`](crate::client::fluent_builders::UpdateAssociation::compliance_severity) / [`set_compliance_severity(Option<AssociationComplianceSeverity>)`](crate::client::fluent_builders::UpdateAssociation::set_compliance_severity): <p>The severity level to assign to the association.</p>
    ///   - [`sync_compliance(AssociationSyncCompliance)`](crate::client::fluent_builders::UpdateAssociation::sync_compliance) / [`set_sync_compliance(Option<AssociationSyncCompliance>)`](crate::client::fluent_builders::UpdateAssociation::set_sync_compliance): <p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.</p>  <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <code>PutComplianceItems</code> API operation. In this case, compliance data isn't managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the <code>PutComplianceItems</code> API operation.</p>  <p>By default, all associations use <code>AUTO</code> mode.</p>
    ///   - [`apply_only_at_cron_interval(bool)`](crate::client::fluent_builders::UpdateAssociation::apply_only_at_cron_interval) / [`set_apply_only_at_cron_interval(bool)`](crate::client::fluent_builders::UpdateAssociation::set_apply_only_at_cron_interval): <p>By default, when you update an association, the system runs it immediately after it is updated and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you update it. This parameter isn't supported for rate expressions.</p>  <p>Also, if you specified this option when you created the association, you can reset it. To do so, specify the <code>no-apply-only-at-cron-interval</code> parameter when you update the association from the command line. This parameter forces the association to run immediately after updating it and according to the interval specified.</p>
    ///   - [`calendar_names(Vec<String>)`](crate::client::fluent_builders::UpdateAssociation::calendar_names) / [`set_calendar_names(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateAssociation::set_calendar_names): <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>
    ///   - [`target_locations(Vec<TargetLocation>)`](crate::client::fluent_builders::UpdateAssociation::target_locations) / [`set_target_locations(Option<Vec<TargetLocation>>)`](crate::client::fluent_builders::UpdateAssociation::set_target_locations): <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to update an association in multiple Regions and multiple accounts.</p>
    /// - On success, responds with [`UpdateAssociationOutput`](crate::output::UpdateAssociationOutput) with field(s):
    ///   - [`association_description(Option<AssociationDescription>)`](crate::output::UpdateAssociationOutput::association_description): <p>The description of the association that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateAssociationError>`](crate::error::UpdateAssociationError)
    pub fn update_association(&self) -> fluent_builders::UpdateAssociation {
        fluent_builders::UpdateAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssociationStatus`](crate::client::fluent_builders::UpdateAssociationStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociationStatus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAssociationStatus::set_name): <p>The name of the SSM document.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssociationStatus::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateAssociationStatus::set_instance_id): <p>The managed node ID.</p>
    ///   - [`association_status(AssociationStatus)`](crate::client::fluent_builders::UpdateAssociationStatus::association_status) / [`set_association_status(Option<AssociationStatus>)`](crate::client::fluent_builders::UpdateAssociationStatus::set_association_status): <p>The association status.</p>
    /// - On success, responds with [`UpdateAssociationStatusOutput`](crate::output::UpdateAssociationStatusOutput) with field(s):
    ///   - [`association_description(Option<AssociationDescription>)`](crate::output::UpdateAssociationStatusOutput::association_description): <p>Information about the association.</p>
    /// - On failure, responds with [`SdkError<UpdateAssociationStatusError>`](crate::error::UpdateAssociationStatusError)
    pub fn update_association_status(&self) -> fluent_builders::UpdateAssociationStatus {
        fluent_builders::UpdateAssociationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDocument`](crate::client::fluent_builders::UpdateDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_content): <p>A valid JSON or YAML string.</p>
    ///   - [`attachments(Vec<AttachmentsSource>)`](crate::client::fluent_builders::UpdateDocument::attachments) / [`set_attachments(Option<Vec<AttachmentsSource>>)`](crate::client::fluent_builders::UpdateDocument::set_attachments): <p>A list of key-value pairs that describe attachments to a version of a document.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_name): <p>The name of the SSM document that you want to update.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_display_name): <p>The friendly name of the SSM document that you want to update. This value can differ for each version of the document. If you don't specify a value for this parameter in your request, the existing value is applied to the new document version.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_version_name): <p>An optional field specifying the version of the artifact you are updating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_document_version): <p>The version of the document that you want to update. Currently, Systems Manager supports updating only the latest version of the document. You can specify the version number of the latest version or use the <code>$LATEST</code> variable.</p>
    ///   - [`document_format(DocumentFormat)`](crate::client::fluent_builders::UpdateDocument::document_format) / [`set_document_format(Option<DocumentFormat>)`](crate::client::fluent_builders::UpdateDocument::set_document_format): <p>Specify the document format for the new document version. Systems Manager supports JSON and YAML documents. JSON is the default format.</p>
    ///   - [`target_type(impl Into<String>)`](crate::client::fluent_builders::UpdateDocument::target_type) / [`set_target_type(Option<String>)`](crate::client::fluent_builders::UpdateDocument::set_target_type): <p>Specify a new target type for the document.</p>
    /// - On success, responds with [`UpdateDocumentOutput`](crate::output::UpdateDocumentOutput) with field(s):
    ///   - [`document_description(Option<DocumentDescription>)`](crate::output::UpdateDocumentOutput::document_description): <p>A description of the document that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateDocumentError>`](crate::error::UpdateDocumentError)
    pub fn update_document(&self) -> fluent_builders::UpdateDocument {
        fluent_builders::UpdateDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDocumentDefaultVersion`](crate::client::fluent_builders::UpdateDocumentDefaultVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentDefaultVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDocumentDefaultVersion::set_name): <p>The name of a custom document that you want to set as the default version.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentDefaultVersion::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::UpdateDocumentDefaultVersion::set_document_version): <p>The version of a custom document that you want to set as the default version.</p>
    /// - On success, responds with [`UpdateDocumentDefaultVersionOutput`](crate::output::UpdateDocumentDefaultVersionOutput) with field(s):
    ///   - [`description(Option<DocumentDefaultVersionDescription>)`](crate::output::UpdateDocumentDefaultVersionOutput::description): <p>The description of a custom document that you want to set as the default version.</p>
    /// - On failure, responds with [`SdkError<UpdateDocumentDefaultVersionError>`](crate::error::UpdateDocumentDefaultVersionError)
    pub fn update_document_default_version(&self) -> fluent_builders::UpdateDocumentDefaultVersion {
        fluent_builders::UpdateDocumentDefaultVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDocumentMetadata`](crate::client::fluent_builders::UpdateDocumentMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentMetadata::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDocumentMetadata::set_name): <p>The name of the change template for which a version's metadata is to be updated.</p>
    ///   - [`document_version(impl Into<String>)`](crate::client::fluent_builders::UpdateDocumentMetadata::document_version) / [`set_document_version(Option<String>)`](crate::client::fluent_builders::UpdateDocumentMetadata::set_document_version): <p>The version of a change template in which to update approval metadata.</p>
    ///   - [`document_reviews(DocumentReviews)`](crate::client::fluent_builders::UpdateDocumentMetadata::document_reviews) / [`set_document_reviews(Option<DocumentReviews>)`](crate::client::fluent_builders::UpdateDocumentMetadata::set_document_reviews): <p>The change template review details to update.</p>
    /// - On success, responds with [`UpdateDocumentMetadataOutput`](crate::output::UpdateDocumentMetadataOutput)

    /// - On failure, responds with [`SdkError<UpdateDocumentMetadataError>`](crate::error::UpdateDocumentMetadataError)
    pub fn update_document_metadata(&self) -> fluent_builders::UpdateDocumentMetadata {
        fluent_builders::UpdateDocumentMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMaintenanceWindow`](crate::client::fluent_builders::UpdateMaintenanceWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_window_id): <p>The ID of the maintenance window to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_name): <p>The name of the maintenance window.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_description): <p>An optional description for the update request.</p>
    ///   - [`start_date(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::start_date) / [`set_start_date(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_start_date): <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future date.</p>
    ///   - [`end_date(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::end_date) / [`set_end_date(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_end_date): <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer run.</p>
    ///   - [`schedule(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::schedule) / [`set_schedule(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_schedule): <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    ///   - [`schedule_timezone(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::schedule_timezone) / [`set_schedule_timezone(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_schedule_timezone): <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    ///   - [`schedule_offset(i32)`](crate::client::fluent_builders::UpdateMaintenanceWindow::schedule_offset) / [`set_schedule_offset(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_schedule_offset): <p>The number of days to wait after the date and time specified by a cron expression before running the maintenance window.</p>  <p>For example, the following cron expression schedules a maintenance window to run the third Tuesday of every month at 11:30 PM.</p>  <p> <code>cron(30 23 ? * TUE#3 *)</code> </p>  <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.</p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::UpdateMaintenanceWindow::duration) / [`set_duration(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_duration): <p>The duration of the maintenance window in hours.</p>
    ///   - [`cutoff(i32)`](crate::client::fluent_builders::UpdateMaintenanceWindow::cutoff) / [`set_cutoff(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_cutoff): <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    ///   - [`allow_unassociated_targets(bool)`](crate::client::fluent_builders::UpdateMaintenanceWindow::allow_unassociated_targets) / [`set_allow_unassociated_targets(Option<bool>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_allow_unassociated_targets): <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateMaintenanceWindow::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_enabled): <p>Whether the maintenance window is enabled.</p>
    ///   - [`replace(bool)`](crate::client::fluent_builders::UpdateMaintenanceWindow::replace) / [`set_replace(Option<bool>)`](crate::client::fluent_builders::UpdateMaintenanceWindow::set_replace): <p>If <code>True</code>, then all fields that are required by the <code>CreateMaintenanceWindow</code> operation are also required for this API request. Optional fields that aren't specified are set to null. </p>
    /// - On success, responds with [`UpdateMaintenanceWindowOutput`](crate::output::UpdateMaintenanceWindowOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::UpdateMaintenanceWindowOutput::window_id): <p>The ID of the created maintenance window.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateMaintenanceWindowOutput::name): <p>The name of the maintenance window.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateMaintenanceWindowOutput::description): <p>An optional description of the update.</p>
    ///   - [`start_date(Option<String>)`](crate::output::UpdateMaintenanceWindowOutput::start_date): <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window won't run before this specified time.</p>
    ///   - [`end_date(Option<String>)`](crate::output::UpdateMaintenanceWindowOutput::end_date): <p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window won't run after this specified time.</p>
    ///   - [`schedule(Option<String>)`](crate::output::UpdateMaintenanceWindowOutput::schedule): <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
    ///   - [`schedule_timezone(Option<String>)`](crate::output::UpdateMaintenanceWindowOutput::schedule_timezone): <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
    ///   - [`schedule_offset(Option<i32>)`](crate::output::UpdateMaintenanceWindowOutput::schedule_offset): <p>The number of days to wait to run a maintenance window after the scheduled cron expression date and time.</p>
    ///   - [`duration(i32)`](crate::output::UpdateMaintenanceWindowOutput::duration): <p>The duration of the maintenance window in hours.</p>
    ///   - [`cutoff(i32)`](crate::output::UpdateMaintenanceWindowOutput::cutoff): <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
    ///   - [`allow_unassociated_targets(bool)`](crate::output::UpdateMaintenanceWindowOutput::allow_unassociated_targets): <p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>
    ///   - [`enabled(bool)`](crate::output::UpdateMaintenanceWindowOutput::enabled): <p>Whether the maintenance window is enabled.</p>
    /// - On failure, responds with [`SdkError<UpdateMaintenanceWindowError>`](crate::error::UpdateMaintenanceWindowError)
    pub fn update_maintenance_window(&self) -> fluent_builders::UpdateMaintenanceWindow {
        fluent_builders::UpdateMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMaintenanceWindowTarget`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::set_window_id): <p>The maintenance window ID with which to modify the target.</p>
    ///   - [`window_target_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::window_target_id) / [`set_window_target_id(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::set_window_target_id): <p>The target ID to modify.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::set_targets): <p>The targets to add or replace.</p>
    ///   - [`owner_information(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::owner_information) / [`set_owner_information(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::set_owner_information): <p>User-provided value that will be included in any Amazon CloudWatch Events events raised while running tasks for these targets in this maintenance window.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::set_name): <p>A name for the update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::set_description): <p>An optional description for the update.</p>
    ///   - [`replace(bool)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::replace) / [`set_replace(Option<bool>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget::set_replace): <p>If <code>True</code>, then all fields that are required by the <code>RegisterTargetWithMaintenanceWindow</code> operation are also required for this API request. Optional fields that aren't specified are set to null.</p>
    /// - On success, responds with [`UpdateMaintenanceWindowTargetOutput`](crate::output::UpdateMaintenanceWindowTargetOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::UpdateMaintenanceWindowTargetOutput::window_id): <p>The maintenance window ID specified in the update request.</p>
    ///   - [`window_target_id(Option<String>)`](crate::output::UpdateMaintenanceWindowTargetOutput::window_target_id): <p>The target ID specified in the update request.</p>
    ///   - [`targets(Option<Vec<Target>>)`](crate::output::UpdateMaintenanceWindowTargetOutput::targets): <p>The updated targets.</p>
    ///   - [`owner_information(Option<String>)`](crate::output::UpdateMaintenanceWindowTargetOutput::owner_information): <p>The updated owner.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateMaintenanceWindowTargetOutput::name): <p>The updated name.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateMaintenanceWindowTargetOutput::description): <p>The updated description.</p>
    /// - On failure, responds with [`SdkError<UpdateMaintenanceWindowTargetError>`](crate::error::UpdateMaintenanceWindowTargetError)
    pub fn update_maintenance_window_target(
        &self,
    ) -> fluent_builders::UpdateMaintenanceWindowTarget {
        fluent_builders::UpdateMaintenanceWindowTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMaintenanceWindowTask`](crate::client::fluent_builders::UpdateMaintenanceWindowTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`window_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::window_id) / [`set_window_id(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_window_id): <p>The maintenance window ID that contains the task to modify.</p>
    ///   - [`window_task_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::window_task_id) / [`set_window_task_id(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_window_task_id): <p>The task ID to modify.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_targets): <p>The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the format <code> Key=tag_name,Values=tag_value</code>. </p> <note>   <p>One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>  </note>
    ///   - [`task_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::task_arn) / [`set_task_arn(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_task_arn): <p>The task ARN to modify.</p>
    ///   - [`service_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::service_role_arn) / [`set_service_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_service_role_arn): <p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p>  <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using service-linked roles for Systems Manager</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks? </a> </p> </li>  </ul>
    ///   - [`task_parameters(HashMap<String, MaintenanceWindowTaskParameterValueExpression>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::task_parameters) / [`set_task_parameters(Option<HashMap<String, MaintenanceWindowTaskParameterValueExpression>>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_task_parameters): <p>The parameters to modify.</p> <note>   <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>  <p>The map has the following format:</p>  <p>Key: string, between 1 and 255 characters</p>  <p>Value: an array of strings, each string is between 1 and 255 characters</p>
    ///   - [`task_invocation_parameters(MaintenanceWindowTaskInvocationParameters)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::task_invocation_parameters) / [`set_task_invocation_parameters(Option<MaintenanceWindowTaskInvocationParameters>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_task_invocation_parameters): <p>The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty.</p> <important>   <p>When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>, you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you don't specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.</p>  </important>
    ///   - [`priority(i32)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_priority): <p>The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>
    ///   - [`max_concurrency(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::max_concurrency) / [`set_max_concurrency(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_max_concurrency): <p>The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of targets that are allowed to run this task, in parallel.</p> <note>   <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p>   <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.</p>  </note>
    ///   - [`max_errors(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::max_errors) / [`set_max_errors(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_max_errors): <p>The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors that are allowed before the task stops being scheduled.</p> <note>   <p>Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.</p>   <p>For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't affect the running of your task.</p>  </note>
    ///   - [`logging_info(LoggingInfo)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::logging_info) / [`set_logging_info(Option<LoggingInfo>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_logging_info): <p>The new logging location in Amazon S3 to specify.</p> <note>   <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_name): <p>The new task name to specify.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_description): <p>The new task description to specify.</p>
    ///   - [`replace(bool)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::replace) / [`set_replace(Option<bool>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_replace): <p>If True, then all fields that are required by the <code>RegisterTaskWithMaintenanceWindow</code> operation are also required for this API request. Optional fields that aren't specified are set to null.</p>
    ///   - [`cutoff_behavior(MaintenanceWindowTaskCutoffBehavior)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::cutoff_behavior) / [`set_cutoff_behavior(Option<MaintenanceWindowTaskCutoffBehavior>)`](crate::client::fluent_builders::UpdateMaintenanceWindowTask::set_cutoff_behavior): <p>Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>  <ul>   <li> <p> <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running continue. The default value.</p> </li>   <li> <p> <code>CANCEL_TASK</code>:</p>    <ul>     <li> <p>For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are already running continue, but no new task invocations are started.</p> </li>     <li> <p>For Run Command tasks: When the cutoff time is reached, the system sends a <code>CancelCommand</code> operation that attempts to cancel the command associated with the task. However, there is no guarantee that the command will be terminated and the underlying process stopped.</p> </li>    </ul> <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p> </li>  </ul>
    /// - On success, responds with [`UpdateMaintenanceWindowTaskOutput`](crate::output::UpdateMaintenanceWindowTaskOutput) with field(s):
    ///   - [`window_id(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::window_id): <p>The ID of the maintenance window that was updated.</p>
    ///   - [`window_task_id(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::window_task_id): <p>The task ID of the maintenance window that was updated.</p>
    ///   - [`targets(Option<Vec<Target>>)`](crate::output::UpdateMaintenanceWindowTaskOutput::targets): <p>The updated target values.</p>
    ///   - [`task_arn(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::task_arn): <p>The updated task ARN value.</p>
    ///   - [`service_role_arn(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::service_role_arn): <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
    ///   - [`task_parameters(Option<HashMap<String, MaintenanceWindowTaskParameterValueExpression>>)`](crate::output::UpdateMaintenanceWindowTaskOutput::task_parameters): <p>The updated parameter values.</p> <note>   <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>
    ///   - [`task_invocation_parameters(Option<MaintenanceWindowTaskInvocationParameters>)`](crate::output::UpdateMaintenanceWindowTaskOutput::task_invocation_parameters): <p>The updated parameter values.</p>
    ///   - [`priority(i32)`](crate::output::UpdateMaintenanceWindowTaskOutput::priority): <p>The updated priority value.</p>
    ///   - [`max_concurrency(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::max_concurrency): <p>The updated <code>MaxConcurrency</code> value.</p>
    ///   - [`max_errors(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::max_errors): <p>The updated <code>MaxErrors</code> value.</p>
    ///   - [`logging_info(Option<LoggingInfo>)`](crate::output::UpdateMaintenanceWindowTaskOutput::logging_info): <p>The updated logging information in Amazon S3.</p> <note>   <p> <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see <code>MaintenanceWindowTaskInvocationParameters</code>.</p>  </note>
    ///   - [`name(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::name): <p>The updated task name.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateMaintenanceWindowTaskOutput::description): <p>The updated task description.</p>
    ///   - [`cutoff_behavior(Option<MaintenanceWindowTaskCutoffBehavior>)`](crate::output::UpdateMaintenanceWindowTaskOutput::cutoff_behavior): <p>The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. </p>
    /// - On failure, responds with [`SdkError<UpdateMaintenanceWindowTaskError>`](crate::error::UpdateMaintenanceWindowTaskError)
    pub fn update_maintenance_window_task(&self) -> fluent_builders::UpdateMaintenanceWindowTask {
        fluent_builders::UpdateMaintenanceWindowTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateManagedInstanceRole`](crate::client::fluent_builders::UpdateManagedInstanceRole) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateManagedInstanceRole::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateManagedInstanceRole::set_instance_id): <p>The ID of the managed node where you want to update the role.</p>
    ///   - [`iam_role(impl Into<String>)`](crate::client::fluent_builders::UpdateManagedInstanceRole::iam_role) / [`set_iam_role(Option<String>)`](crate::client::fluent_builders::UpdateManagedInstanceRole::set_iam_role): <p>The IAM role you want to assign or change.</p>
    /// - On success, responds with [`UpdateManagedInstanceRoleOutput`](crate::output::UpdateManagedInstanceRoleOutput)

    /// - On failure, responds with [`SdkError<UpdateManagedInstanceRoleError>`](crate::error::UpdateManagedInstanceRoleError)
    pub fn update_managed_instance_role(&self) -> fluent_builders::UpdateManagedInstanceRole {
        fluent_builders::UpdateManagedInstanceRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOpsItem`](crate::client::fluent_builders::UpdateOpsItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateOpsItem::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateOpsItem::set_description): <p>Update the information about the OpsItem. Provide enough information so that users reading this OpsItem for the first time understand the issue. </p>
    ///   - [`operational_data(HashMap<String, OpsItemDataValue>)`](crate::client::fluent_builders::UpdateOpsItem::operational_data) / [`set_operational_data(Option<HashMap<String, OpsItemDataValue>>)`](crate::client::fluent_builders::UpdateOpsItem::set_operational_data): <p>Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem object.</p>  <p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important>   <p>Operational data keys <i>can't</i> begin with the following: <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>, <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>  </important>  <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <code>DescribeOpsItems</code> API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the <code>GetOpsItem</code> API operation).</p>  <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`operational_data_to_delete(Vec<String>)`](crate::client::fluent_builders::UpdateOpsItem::operational_data_to_delete) / [`set_operational_data_to_delete(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateOpsItem::set_operational_data_to_delete): <p>Keys that you want to remove from the OperationalData map.</p>
    ///   - [`notifications(Vec<OpsItemNotification>)`](crate::client::fluent_builders::UpdateOpsItem::notifications) / [`set_notifications(Option<Vec<OpsItemNotification>>)`](crate::client::fluent_builders::UpdateOpsItem::set_notifications): <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::UpdateOpsItem::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::UpdateOpsItem::set_priority): <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
    ///   - [`related_ops_items(Vec<RelatedOpsItem>)`](crate::client::fluent_builders::UpdateOpsItem::related_ops_items) / [`set_related_ops_items(Option<Vec<RelatedOpsItem>>)`](crate::client::fluent_builders::UpdateOpsItem::set_related_ops_items): <p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>
    ///   - [`status(OpsItemStatus)`](crate::client::fluent_builders::UpdateOpsItem::status) / [`set_status(Option<OpsItemStatus>)`](crate::client::fluent_builders::UpdateOpsItem::set_status): <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`ops_item_id(impl Into<String>)`](crate::client::fluent_builders::UpdateOpsItem::ops_item_id) / [`set_ops_item_id(Option<String>)`](crate::client::fluent_builders::UpdateOpsItem::set_ops_item_id): <p>The ID of the OpsItem.</p>
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::UpdateOpsItem::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::UpdateOpsItem::set_title): <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
    ///   - [`category(impl Into<String>)`](crate::client::fluent_builders::UpdateOpsItem::category) / [`set_category(Option<String>)`](crate::client::fluent_builders::UpdateOpsItem::set_category): <p>Specify a new category for an OpsItem.</p>
    ///   - [`severity(impl Into<String>)`](crate::client::fluent_builders::UpdateOpsItem::severity) / [`set_severity(Option<String>)`](crate::client::fluent_builders::UpdateOpsItem::set_severity): <p>Specify a new severity for an OpsItem.</p>
    ///   - [`actual_start_time(DateTime)`](crate::client::fluent_builders::UpdateOpsItem::actual_start_time) / [`set_actual_start_time(Option<DateTime>)`](crate::client::fluent_builders::UpdateOpsItem::set_actual_start_time): <p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    ///   - [`actual_end_time(DateTime)`](crate::client::fluent_builders::UpdateOpsItem::actual_end_time) / [`set_actual_end_time(Option<DateTime>)`](crate::client::fluent_builders::UpdateOpsItem::set_actual_end_time): <p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    ///   - [`planned_start_time(DateTime)`](crate::client::fluent_builders::UpdateOpsItem::planned_start_time) / [`set_planned_start_time(Option<DateTime>)`](crate::client::fluent_builders::UpdateOpsItem::set_planned_start_time): <p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    ///   - [`planned_end_time(DateTime)`](crate::client::fluent_builders::UpdateOpsItem::planned_end_time) / [`set_planned_end_time(Option<DateTime>)`](crate::client::fluent_builders::UpdateOpsItem::set_planned_end_time): <p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
    /// - On success, responds with [`UpdateOpsItemOutput`](crate::output::UpdateOpsItemOutput)

    /// - On failure, responds with [`SdkError<UpdateOpsItemError>`](crate::error::UpdateOpsItemError)
    pub fn update_ops_item(&self) -> fluent_builders::UpdateOpsItem {
        fluent_builders::UpdateOpsItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOpsMetadata`](crate::client::fluent_builders::UpdateOpsMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ops_metadata_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateOpsMetadata::ops_metadata_arn) / [`set_ops_metadata_arn(Option<String>)`](crate::client::fluent_builders::UpdateOpsMetadata::set_ops_metadata_arn): <p>The Amazon Resource Name (ARN) of the OpsMetadata Object to update.</p>
    ///   - [`metadata_to_update(HashMap<String, MetadataValue>)`](crate::client::fluent_builders::UpdateOpsMetadata::metadata_to_update) / [`set_metadata_to_update(Option<HashMap<String, MetadataValue>>)`](crate::client::fluent_builders::UpdateOpsMetadata::set_metadata_to_update): <p>Metadata to add to an OpsMetadata object.</p>
    ///   - [`keys_to_delete(Vec<String>)`](crate::client::fluent_builders::UpdateOpsMetadata::keys_to_delete) / [`set_keys_to_delete(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateOpsMetadata::set_keys_to_delete): <p>The metadata keys to delete from the OpsMetadata object. </p>
    /// - On success, responds with [`UpdateOpsMetadataOutput`](crate::output::UpdateOpsMetadataOutput) with field(s):
    ///   - [`ops_metadata_arn(Option<String>)`](crate::output::UpdateOpsMetadataOutput::ops_metadata_arn): <p>The Amazon Resource Name (ARN) of the OpsMetadata Object that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateOpsMetadataError>`](crate::error::UpdateOpsMetadataError)
    pub fn update_ops_metadata(&self) -> fluent_builders::UpdateOpsMetadata {
        fluent_builders::UpdateOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePatchBaseline`](crate::client::fluent_builders::UpdatePatchBaseline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`baseline_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::baseline_id) / [`set_baseline_id(Option<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_baseline_id): <p>The ID of the patch baseline to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_name): <p>The name of the patch baseline.</p>
    ///   - [`global_filters(PatchFilterGroup)`](crate::client::fluent_builders::UpdatePatchBaseline::global_filters) / [`set_global_filters(Option<PatchFilterGroup>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_global_filters): <p>A set of global filters used to include patches in the baseline.</p>
    ///   - [`approval_rules(PatchRuleGroup)`](crate::client::fluent_builders::UpdatePatchBaseline::approval_rules) / [`set_approval_rules(Option<PatchRuleGroup>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_approval_rules): <p>A set of rules used to include patches in the baseline.</p>
    ///   - [`approved_patches(Vec<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::approved_patches) / [`set_approved_patches(Option<Vec<String>>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_approved_patches): <p>A list of explicitly approved patches for the baseline.</p>  <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`approved_patches_compliance_level(PatchComplianceLevel)`](crate::client::fluent_builders::UpdatePatchBaseline::approved_patches_compliance_level) / [`set_approved_patches_compliance_level(Option<PatchComplianceLevel>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_approved_patches_compliance_level): <p>Assigns a new compliance severity level to an existing patch baseline.</p>
    ///   - [`approved_patches_enable_non_security(bool)`](crate::client::fluent_builders::UpdatePatchBaseline::approved_patches_enable_non_security) / [`set_approved_patches_enable_non_security(Option<bool>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_approved_patches_enable_non_security): <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    ///   - [`rejected_patches(Vec<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::rejected_patches) / [`set_rejected_patches(Option<Vec<String>>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_rejected_patches): <p>A list of explicitly rejected patches for the baseline.</p>  <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    ///   - [`rejected_patches_action(PatchAction)`](crate::client::fluent_builders::UpdatePatchBaseline::rejected_patches_action) / [`set_rejected_patches_action(Option<PatchAction>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_rejected_patches_action): <p>The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p>  <ul>   <li> <p> <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.</p> </li>   <li> <p> <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the <code>Rejected</code> patches list, it is considered non-compliant with the patch baseline, and its status is reported as <code>InstalledRejected</code>.</p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_description): <p>A description of the patch baseline.</p>
    ///   - [`sources(Vec<PatchSource>)`](crate::client::fluent_builders::UpdatePatchBaseline::sources) / [`set_sources(Option<Vec<PatchSource>>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_sources): <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    ///   - [`replace(bool)`](crate::client::fluent_builders::UpdatePatchBaseline::replace) / [`set_replace(Option<bool>)`](crate::client::fluent_builders::UpdatePatchBaseline::set_replace): <p>If True, then all fields that are required by the <code>CreatePatchBaseline</code> operation are also required for this API request. Optional fields that aren't specified are set to null.</p>
    /// - On success, responds with [`UpdatePatchBaselineOutput`](crate::output::UpdatePatchBaselineOutput) with field(s):
    ///   - [`baseline_id(Option<String>)`](crate::output::UpdatePatchBaselineOutput::baseline_id): <p>The ID of the deleted patch baseline.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdatePatchBaselineOutput::name): <p>The name of the patch baseline.</p>
    ///   - [`operating_system(Option<OperatingSystem>)`](crate::output::UpdatePatchBaselineOutput::operating_system): <p>The operating system rule used by the updated patch baseline.</p>
    ///   - [`global_filters(Option<PatchFilterGroup>)`](crate::output::UpdatePatchBaselineOutput::global_filters): <p>A set of global filters used to exclude patches from the baseline.</p>
    ///   - [`approval_rules(Option<PatchRuleGroup>)`](crate::output::UpdatePatchBaselineOutput::approval_rules): <p>A set of rules used to include patches in the baseline.</p>
    ///   - [`approved_patches(Option<Vec<String>>)`](crate::output::UpdatePatchBaselineOutput::approved_patches): <p>A list of explicitly approved patches for the baseline.</p>
    ///   - [`approved_patches_compliance_level(Option<PatchComplianceLevel>)`](crate::output::UpdatePatchBaselineOutput::approved_patches_compliance_level): <p>The compliance severity level assigned to the patch baseline after the update completed.</p>
    ///   - [`approved_patches_enable_non_security(Option<bool>)`](crate::output::UpdatePatchBaselineOutput::approved_patches_enable_non_security): <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
    ///   - [`rejected_patches(Option<Vec<String>>)`](crate::output::UpdatePatchBaselineOutput::rejected_patches): <p>A list of explicitly rejected patches for the baseline.</p>
    ///   - [`rejected_patches_action(Option<PatchAction>)`](crate::output::UpdatePatchBaselineOutput::rejected_patches_action): <p>The action specified to take on patches included in the <code>RejectedPatches</code> list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::UpdatePatchBaselineOutput::created_date): <p>The date when the patch baseline was created.</p>
    ///   - [`modified_date(Option<DateTime>)`](crate::output::UpdatePatchBaselineOutput::modified_date): <p>The date when the patch baseline was last modified.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdatePatchBaselineOutput::description): <p>A description of the patch baseline.</p>
    ///   - [`sources(Option<Vec<PatchSource>>)`](crate::output::UpdatePatchBaselineOutput::sources): <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
    /// - On failure, responds with [`SdkError<UpdatePatchBaselineError>`](crate::error::UpdatePatchBaselineError)
    pub fn update_patch_baseline(&self) -> fluent_builders::UpdatePatchBaseline {
        fluent_builders::UpdatePatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourceDataSync`](crate::client::fluent_builders::UpdateResourceDataSync) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sync_name(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceDataSync::sync_name) / [`set_sync_name(Option<String>)`](crate::client::fluent_builders::UpdateResourceDataSync::set_sync_name): <p>The name of the resource data sync you want to update.</p>
    ///   - [`sync_type(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceDataSync::sync_type) / [`set_sync_type(Option<String>)`](crate::client::fluent_builders::UpdateResourceDataSync::set_sync_type): <p>The type of resource data sync. The supported <code>SyncType</code> is SyncFromSource.</p>
    ///   - [`sync_source(ResourceDataSyncSource)`](crate::client::fluent_builders::UpdateResourceDataSync::sync_source) / [`set_sync_source(Option<ResourceDataSyncSource>)`](crate::client::fluent_builders::UpdateResourceDataSync::set_sync_source): <p>Specify information about the data sources to synchronize.</p>
    /// - On success, responds with [`UpdateResourceDataSyncOutput`](crate::output::UpdateResourceDataSyncOutput)

    /// - On failure, responds with [`SdkError<UpdateResourceDataSyncError>`](crate::error::UpdateResourceDataSyncError)
    pub fn update_resource_data_sync(&self) -> fluent_builders::UpdateResourceDataSync {
        fluent_builders::UpdateResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateServiceSetting`](crate::client::fluent_builders::UpdateServiceSetting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`setting_id(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceSetting::setting_id) / [`set_setting_id(Option<String>)`](crate::client::fluent_builders::UpdateServiceSetting::set_setting_id): <p>The Amazon Resource Name (ARN) of the service setting to reset. For example, <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>. The setting ID can be one of the following.</p>  <ul>   <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li>   <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li>   <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li>   <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li>   <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li>   <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li>  </ul>
    ///   - [`setting_value(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceSetting::setting_value) / [`set_setting_value(Option<String>)`](crate::client::fluent_builders::UpdateServiceSetting::set_setting_value): <p>The new value to specify for the service setting. The following list specifies the available values for each setting.</p>  <ul>   <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code>: <code>Standard</code>, <code>Advanced</code>, <code>Intelligent-Tiering</code> </p> </li>   <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code>: <code>true</code> or <code>false</code> </p> </li>   <li> <p> <code>/ssm/managed-instance/activation-tier</code>: <code>true</code> or <code>false</code> </p> </li>   <li> <p> <code>/ssm/automation/customer-script-log-destination</code>: <code>CloudWatch</code> </p> </li>   <li> <p> <code>/ssm/automation/customer-script-log-group-name</code>: the name of an Amazon CloudWatch Logs log group</p> </li>   <li> <p> <code>/ssm/documents/console/public-sharing-permission</code>: <code>Enable</code> or <code>Disable</code> </p> </li>   <li> <p> <code>/ssm/managed-instance/activation-tier</code>: <code>standard</code> or <code>advanced</code> </p> </li>  </ul>
    /// - On success, responds with [`UpdateServiceSettingOutput`](crate::output::UpdateServiceSettingOutput)

    /// - On failure, responds with [`SdkError<UpdateServiceSettingError>`](crate::error::UpdateServiceSettingError)
    pub fn update_service_setting(&self) -> fluent_builders::UpdateServiceSetting {
        fluent_builders::UpdateServiceSetting::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account's managed nodes that helps you track each node's owner and stack level. For example:</p>
    /// <ul>
    /// <li> <p> <code>Key=Owner,Value=DbAdmin</code> </p> </li>
    /// <li> <p> <code>Key=Owner,Value=SysAdmin</code> </p> </li>
    /// <li> <p> <code>Key=Owner,Value=Dev</code> </p> </li>
    /// <li> <p> <code>Key=Stack,Value=Production</code> </p> </li>
    /// <li> <p> <code>Key=Stack,Value=Pre-Production</code> </p> </li>
    /// <li> <p> <code>Key=Stack,Value=Test</code> </p> </li>
    /// </ul>
    /// <p>Each resource can have a maximum of 50 tags.</p>
    /// <p>We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of characters. </p>
    /// <p>For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl AddTagsToResource {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the type of resource you are tagging.</p> <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn resource_type(mut self, input: crate::model::ResourceTypeForTagging) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>Specifies the type of resource you are tagging.</p> <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceTypeForTagging>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The resource ID you want to tag.</p>
        /// <p>Use the ID of the resource. Here are some examples:</p>
        /// <p> <code>MaintenanceWindow</code>: <code>mw-012345abcde</code> </p>
        /// <p> <code>PatchBaseline</code>: <code>pb-012345abcde</code> </p>
        /// <p> <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the resource.</p>
        /// <p> <code>ManagedInstance</code>: <code>mi-012345abcde</code> </p> <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource ID you want to tag.</p>
        /// <p>Use the ID of the resource. Here are some examples:</p>
        /// <p> <code>MaintenanceWindow</code>: <code>mw-012345abcde</code> </p>
        /// <p> <code>PatchBaseline</code>: <code>pb-012345abcde</code> </p>
        /// <p> <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the resource.</p>
        /// <p> <code>ManagedInstance</code>: <code>mi-012345abcde</code> </p> <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises managed nodes. You must specify the name of the managed node in the following format: <code>mi-<i>ID_number</i> </code>. For example, <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. The value parameter is required.</p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags. The value parameter is required.</p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateOpsItemRelatedItem`.
    ///
    /// <p>Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of Amazon Web Services Systems Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateOpsItemRelatedItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_ops_item_related_item_input::Builder,
    }
    impl AssociateOpsItemRelatedItem {
        /// Creates a new `AssociateOpsItemRelatedItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateOpsItemRelatedItemOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateOpsItemRelatedItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(input.into());
            self
        }
        /// <p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
        /// <p>The type of association that you want to create between an OpsItem and a resource. OpsCenter supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>
        pub fn association_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_type(input.into());
            self
        }
        /// <p>The type of association that you want to create between an OpsItem and a resource. OpsCenter supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_type(input);
            self
        }
        /// <p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the following types:</p>
        /// <p> <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p>
        /// <p> <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the following types:</p>
        /// <p> <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p>
        /// <p> <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the OpsItem.</p>
        pub fn resource_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_uri(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the OpsItem.</p>
        pub fn set_resource_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelCommand`.
    ///
    /// <p>Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelCommand {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_command_input::Builder,
    }
    impl CancelCommand {
        /// Creates a new `CancelCommand`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelCommandOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelCommandError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the command you want to cancel.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(input.into());
            self
        }
        /// <p>The ID of the command you want to cancel.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// Appends an item to `InstanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>(Optional) A list of managed node IDs on which you want to cancel the command. If not provided, the command is canceled on every node on which it was requested.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(input.into());
            self
        }
        /// <p>(Optional) A list of managed node IDs on which you want to cancel the command. If not provided, the command is canceled on every node on which it was requested.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelMaintenanceWindowExecution`.
    ///
    /// <p>Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't already starting running. Tasks already in progress will continue to completion.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelMaintenanceWindowExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_maintenance_window_execution_input::Builder,
    }
    impl CancelMaintenanceWindowExecution {
        /// Creates a new `CancelMaintenanceWindowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelMaintenanceWindowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelMaintenanceWindowExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution to stop.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution to stop.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateActivation`.
    ///
    /// <p>Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing on-premises machines using Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting up Amazon Web Services Systems Manager for hybrid environments</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p> <note>
    /// <p>Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are configured for Systems Manager are all called <i>managed nodes</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateActivation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_activation_input::Builder,
    }
    impl CreateActivation {
        /// Creates a new `CreateActivation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateActivationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateActivationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-defined description of the resource that you want to register with Systems Manager. </p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A user-defined description of the resource that you want to register with Systems Manager. </p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn default_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_instance_name(input.into());
            self
        }
        /// <p>The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_default_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_instance_name(input);
            self
        }
        /// <p>The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(input.into());
            self
        }
        /// <p>The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
        /// <p>Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.</p>
        pub fn registration_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.registration_limit(input);
            self
        }
        /// <p>Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.</p>
        pub fn set_registration_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_registration_limit(input);
            self
        }
        /// <p>The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires in 24 hours.</p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expiration_date(input);
            self
        }
        /// <p>The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires in 24 hours.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expiration_date(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// </ul> <important>
        /// <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.</p>
        /// </important>
        /// <p>You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed nodes, see <code>AddTagsToResource</code>. For information about how to remove tags from your managed nodes, see <code>RemoveTagsFromResource</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// </ul> <important>
        /// <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.</p>
        /// </important>
        /// <p>You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed nodes, see <code>AddTagsToResource</code>. For information about how to remove tags from your managed nodes, see <code>RemoveTagsFromResource</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `RegistrationMetadata`.
        ///
        /// To override the contents of this collection use [`set_registration_metadata`](Self::set_registration_metadata).
        ///
        /// <p>Reserved for internal use.</p>
        pub fn registration_metadata(
            mut self,
            input: crate::model::RegistrationMetadataItem,
        ) -> Self {
            self.inner = self.inner.registration_metadata(input);
            self
        }
        /// <p>Reserved for internal use.</p>
        pub fn set_registration_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegistrationMetadataItem>>,
        ) -> Self {
            self.inner = self.inner.set_registration_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssociation`.
    ///
    /// <p>A State Manager association defines the state that you want to maintain on your managed nodes. For example, an association can specify that anti-virus software must be installed and running on your managed nodes, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager applies the configuration when new managed nodes are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software isn't installed, then State Manager installs it. If the software is installed, but the service isn't running, then the association might instruct State Manager to start the service. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_association_input::Builder,
    }
    impl CreateAssociation {
        /// Creates a new `CreateAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account.</p>
        /// <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:</p>
        /// <p> <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p>
        /// <p>For example:</p>
        /// <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration information for the managed node.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account.</p>
        /// <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you must specify the complete SSM document ARN, in the following format:</p>
        /// <p> <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p>
        /// <p>For example:</p>
        /// <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The document version you want to associate with the target(s). Can be a specific version or the default version.</p> <important>
        /// <p>State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code>.</p>
        /// </important>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(input.into());
            self
        }
        /// <p>The document version you want to associate with the target(s). Can be a specific version or the default version.</p> <important>
        /// <p>State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code>.</p>
        /// </important>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The managed node ID.</p> <note>
        /// <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The managed node ID.</p> <note>
        /// <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the runtime configuration of the document.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v);
            self
        }
        /// <p>The parameters for the runtime configuration of the document.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all managed nodes in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all managed nodes in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>A cron expression when the association will be applied to the target(s).</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_expression(input.into());
            self
        }
        /// <p>A cron expression when the association will be applied to the target(s).</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_expression(input);
            self
        }
        /// <p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.</p>
        pub fn output_location(
            mut self,
            input: crate::model::InstanceAssociationOutputLocation,
        ) -> Self {
            self.inner = self.inner.output_location(input);
            self
        }
        /// <p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// <p>Specify a descriptive name for the association.</p>
        pub fn association_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_name(input.into());
            self
        }
        /// <p>Specify a descriptive name for the association.</p>
        pub fn set_association_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_name(input);
            self
        }
        /// <p>Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>
        pub fn automation_target_parameter_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.automation_target_parameter_name(input.into());
            self
        }
        /// <p>Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager.</p>
        pub fn set_automation_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_target_parameter_name(input);
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_errors(input.into());
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_errors(input);
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_concurrency(input.into());
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn compliance_severity(
            mut self,
            input: crate::model::AssociationComplianceSeverity,
        ) -> Self {
            self.inner = self.inner.compliance_severity(input);
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn set_compliance_severity(
            mut self,
            input: std::option::Option<crate::model::AssociationComplianceSeverity>,
        ) -> Self {
            self.inner = self.inner.set_compliance_severity(input);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <code>PutComplianceItems</code> API operation. In this case, compliance data isn't managed by State Manager. It is managed by your direct call to the <code>PutComplianceItems</code> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn sync_compliance(mut self, input: crate::model::AssociationSyncCompliance) -> Self {
            self.inner = self.inner.sync_compliance(input);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <code>PutComplianceItems</code> API operation. In this case, compliance data isn't managed by State Manager. It is managed by your direct call to the <code>PutComplianceItems</code> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn set_sync_compliance(
            mut self,
            input: std::option::Option<crate::model::AssociationSyncCompliance>,
        ) -> Self {
            self.inner = self.inner.set_sync_compliance(input);
            self
        }
        /// <p>By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter isn't supported for rate expressions.</p>
        pub fn apply_only_at_cron_interval(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_only_at_cron_interval(input);
            self
        }
        /// <p>By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter isn't supported for rate expressions.</p>
        pub fn set_apply_only_at_cron_interval(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_only_at_cron_interval(input);
            self
        }
        /// Appends an item to `CalendarNames`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>
        pub fn calendar_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calendar_names(input.into());
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change Calendar</a>.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_calendar_names(input);
            self
        }
        /// Appends an item to `TargetLocations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to create an association in multiple Regions and multiple accounts.</p>
        pub fn target_locations(mut self, input: crate::model::TargetLocation) -> Self {
            self.inner = self.inner.target_locations(input);
            self
        }
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the association. Use this action to create an association in multiple Regions and multiple accounts.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.inner = self.inner.set_target_locations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssociationBatch`.
    ///
    /// <p>Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes or targets.</p>
    /// <p>When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems Manager Agent (SSM Agent) running on the managed node processes the document and configures the node as specified.</p>
    /// <p>If you associate a document with a managed node that already has an associated document, the system returns the AssociationAlreadyExists exception.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssociationBatch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_association_batch_input::Builder,
    }
    impl CreateAssociationBatch {
        /// Creates a new `CreateAssociationBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssociationBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssociationBatchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>One or more associations.</p>
        pub fn entries(mut self, input: crate::model::CreateAssociationBatchRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>One or more associations.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssociationBatchRequestEntry>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocument`.
    ///
    /// <p>Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs on your managed nodes. For more information about SSM documents, including information about supported schemas, features, and syntax, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">Amazon Web Services Systems Manager Documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDocument {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_document_input::Builder,
    }
    impl CreateDocument {
        /// Creates a new `CreateDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.</p>
        /// <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a> </p> </li>
        /// </ul>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.</p>
        /// <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a> </p> </li>
        /// </ul>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `Requires`.
        ///
        /// To override the contents of this collection use [`set_requires`](Self::set_requires).
        ///
        /// <p>A list of SSM documents required by a document. This parameter is used exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the <i>AppConfig User Guide</i>.</p>
        pub fn requires(mut self, input: crate::model::DocumentRequires) -> Self {
            self.inner = self.inner.requires(input);
            self
        }
        /// <p>A list of SSM documents required by a document. This parameter is used exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the <i>AppConfig User Guide</i>.</p>
        pub fn set_requires(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        ) -> Self {
            self.inner = self.inner.set_requires(input);
            self
        }
        /// Appends an item to `Attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn attachments(mut self, input: crate::model::AttachmentsSource) -> Self {
            self.inner = self.inner.attachments(input);
            self
        }
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentsSource>>,
        ) -> Self {
            self.inner = self.inner.set_attachments(input);
            self
        }
        /// <p>A name for the SSM document.</p> <important>
        /// <p>You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:</p>
        /// <ul>
        /// <li> <p> <code>aws-</code> </p> </li>
        /// <li> <p> <code>amazon</code> </p> </li>
        /// <li> <p> <code>amzn</code> </p> </li>
        /// </ul>
        /// </important>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the SSM document.</p> <important>
        /// <p>You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:</p>
        /// <ul>
        /// <li> <p> <code>aws-</code> </p> </li>
        /// <li> <p> <code>amazon</code> </p> </li>
        /// <li> <p> <code>amzn</code> </p> </li>
        /// </ul>
        /// </important>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. You can update this value at a later time using the <code>UpdateDocument</code> operation.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. You can update this value at a later time using the <code>UpdateDocument</code> operation.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>An optional field specifying the version of the artifact you are creating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>An optional field specifying the version of the artifact you are creating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The type of document to create.</p> <note>
        /// <p>The <code>DeploymentStrategy</code> document type is an internal-use-only document type reserved for AppConfig.</p>
        /// </note>
        pub fn document_type(mut self, input: crate::model::DocumentType) -> Self {
            self.inner = self.inner.document_type(input);
            self
        }
        /// <p>The type of document to create.</p> <note>
        /// <p>The <code>DeploymentStrategy</code> document type is an internal-use-only document type reserved for AppConfig.</p>
        /// </note>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<crate::model::DocumentType>,
        ) -> Self {
            self.inner = self.inner.set_document_type(input);
            self
        }
        /// <p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.inner = self.inner.document_format(input);
            self
        }
        /// <p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.inner = self.inner.set_document_format(input);
            self
        }
        /// <p>Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: <code>/AWS::EC2::Instance</code>. If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn target_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_type(input.into());
            self
        }
        /// <p>Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: <code>/AWS::EC2::Instance</code>. If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// </ul> <note>
        /// <p>To add tags to an existing SSM document, use the <code>AddTagsToResource</code> operation.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// </ul> <note>
        /// <p>To add tags to an existing SSM document, use the <code>AddTagsToResource</code> operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMaintenanceWindow`.
    ///
    /// <p>Creates a new maintenance window.</p> <note>
    /// <p>The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window tasks can start after 5 PM.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMaintenanceWindow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_maintenance_window_input::Builder,
    }
    impl CreateMaintenanceWindow {
        /// Creates a new `CreateMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMaintenanceWindowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the maintenance window.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the maintenance window. We recommend specifying a description to help you organize your maintenance windows. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the maintenance window. We recommend specifying a description to help you organize your maintenance windows. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future date.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_date(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future date.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer run.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.end_date(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer run.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(input.into());
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
        pub fn schedule_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_timezone(input.into());
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>
        pub fn set_schedule_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_timezone(input);
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run on the third Tuesday of every month at 11:30 PM.</p>
        /// <p> <code>cron(30 23 ? * TUE#3 *)</code> </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.</p>
        pub fn schedule_offset(mut self, input: i32) -> Self {
            self.inner = self.inner.schedule_offset(input);
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run on the third Tuesday of every month at 11:30 PM.</p>
        /// <p> <code>cron(30 23 ? * TUE#3 *)</code> </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.</p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_schedule_offset(input);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.inner = self.inner.duration(input);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
        pub fn cutoff(mut self, input: i32) -> Self {
            self.inner = self.inner.cutoff(input);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling new tasks for execution.</p>
        pub fn set_cutoff(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_cutoff(input);
            self
        }
        /// <p>Enables a maintenance window task to run on managed nodes, even if you haven't registered those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by node ID) when you register a task with the maintenance window.</p>
        /// <p>If you don't enable this option, then you must specify previously-registered targets when you register a task with the maintenance window.</p>
        pub fn allow_unassociated_targets(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_unassociated_targets(input);
            self
        }
        /// <p>Enables a maintenance window task to run on managed nodes, even if you haven't registered those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by node ID) when you register a task with the maintenance window.</p>
        /// <p>If you don't enable this option, then you must specify previously-registered targets when you register a task with the maintenance window.</p>
        pub fn set_allow_unassociated_targets(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_unassociated_targets(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to identify the type of tasks it will run, the types of targets, and the environment it will run in. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=TaskType,Value=AgentUpdate</code> </p> </li>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// </ul> <note>
        /// <p>To add tags to an existing maintenance window, use the <code>AddTagsToResource</code> operation.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to identify the type of tasks it will run, the types of targets, and the environment it will run in. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=TaskType,Value=AgentUpdate</code> </p> </li>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// </ul> <note>
        /// <p>To add tags to an existing maintenance window, use the <code>AddTagsToResource</code> operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOpsItem`.
    ///
    /// <p>Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems Manager OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOpsItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_ops_item_input::Builder,
    }
    impl CreateOpsItem {
        /// Creates a new `CreateOpsItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOpsItemOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOpsItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Information about the OpsItem. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Information about the OpsItem. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of OpsItem to create. Currently, the only valid values are <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>
        pub fn ops_item_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_type(input.into());
            self
        }
        /// <p>The type of OpsItem to create. Currently, the only valid values are <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>
        pub fn set_ops_item_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_type(input);
            self
        }
        /// Adds a key-value pair to `OperationalData`.
        ///
        /// To override the contents of this collection use [`set_operational_data`](Self::set_operational_data).
        ///
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important>
        /// <p>Operational data keys <i>can't</i> begin with the following: <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>, <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <code>DescribeOpsItems</code> API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the <code>GetOpsItem</code> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn operational_data(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::OpsItemDataValue,
        ) -> Self {
            self.inner = self.inner.operational_data(k.into(), v);
            self
        }
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important>
        /// <p>Operational data keys <i>can't</i> begin with the following: <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>, <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <code>DescribeOpsItems</code> API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the <code>GetOpsItem</code> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_operational_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_operational_data(input);
            self
        }
        /// Appends an item to `Notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>
        pub fn notifications(mut self, input: crate::model::OpsItemNotification) -> Self {
            self.inner = self.inner.notifications(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
        ) -> Self {
            self.inner = self.inner.set_notifications(input);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// Appends an item to `RelatedOpsItems`.
        ///
        /// To override the contents of this collection use [`set_related_ops_items`](Self::set_related_ops_items).
        ///
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>
        pub fn related_ops_items(mut self, input: crate::model::RelatedOpsItem) -> Self {
            self.inner = self.inner.related_ops_items(input);
            self
        }
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>
        pub fn set_related_ops_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
        ) -> Self {
            self.inner = self.inner.set_related_ops_items(input);
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p> <note>
        /// <p>The source name can't contain the following strings: <code>aws</code>, <code>amazon</code>, and <code>amzn</code>. </p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p> <note>
        /// <p>The source name can't contain the following strings: <code>aws</code>, <code>amazon</code>, and <code>amzn</code>. </p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(input.into());
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>Tags use a key-value pair. For example:</p>
        /// <p> <code>Key=Department,Value=Finance</code> </p> <important>
        /// <p>To add tags to a new OpsItem, a user must have IAM permissions for both the <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation. To add tags to an existing OpsItem, use the <code>AddTagsToResource</code> operation.</p>
        /// </important>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>Tags use a key-value pair. For example:</p>
        /// <p> <code>Key=Department,Value=Finance</code> </p> <important>
        /// <p>To add tags to a new OpsItem, a user must have IAM permissions for both the <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation. To add tags to an existing OpsItem, use the <code>AddTagsToResource</code> operation.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specify a category to assign to an OpsItem. </p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(input.into());
            self
        }
        /// <p>Specify a category to assign to an OpsItem. </p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>Specify a severity to assign to an OpsItem.</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity(input.into());
            self
        }
        /// <p>Specify a severity to assign to an OpsItem.</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn actual_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.actual_start_time(input);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_actual_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_actual_start_time(input);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn actual_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.actual_end_time(input);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_actual_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_actual_end_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.planned_start_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_planned_start_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.planned_end_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_planned_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOpsMetadata`.
    ///
    /// <p>If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify information about the new application, including the application type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateOpsMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_ops_metadata_input::Builder,
    }
    impl CreateOpsMetadata {
        /// Creates a new `CreateOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOpsMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A resource ID for a new Application Manager application.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>A resource ID for a new Application Manager application.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Adds a key-value pair to `Metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>Metadata for a new Application Manager application. </p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MetadataValue,
        ) -> Self {
            self.inner = self.inner.metadata(k.into(), v);
            self
        }
        /// <p>Metadata for a new Application Manager application. </p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// <li> <p> <code>Key=Region,Value=us-east-2</code> </p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=Environment,Value=Production</code> </p> </li>
        /// <li> <p> <code>Key=Region,Value=us-east-2</code> </p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePatchBaseline`.
    ///
    /// <p>Creates a patch baseline.</p> <note>
    /// <p>For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system type, see <code>PatchFilter</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePatchBaseline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_patch_baseline_input::Builder,
    }
    impl CreatePatchBaseline {
        /// Creates a new `CreatePatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePatchBaselineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(input);
            self
        }
        /// <p>Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn global_filters(mut self, input: crate::model::PatchFilterGroup) -> Self {
            self.inner = self.inner.global_filters(input);
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn set_global_filters(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.inner = self.inner.set_global_filters(input);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn approval_rules(mut self, input: crate::model::PatchRuleGroup) -> Self {
            self.inner = self.inner.approval_rules(input);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<crate::model::PatchRuleGroup>,
        ) -> Self {
            self.inner = self.inner.set_approval_rules(input);
            self
        }
        /// Appends an item to `ApprovedPatches`.
        ///
        /// To override the contents of this collection use [`set_approved_patches`](Self::set_approved_patches).
        ///
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn approved_patches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approved_patches(input.into());
            self
        }
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_approved_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches(input);
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as missing, this value describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.</p>
        pub fn approved_patches_compliance_level(
            mut self,
            input: crate::model::PatchComplianceLevel,
        ) -> Self {
            self.inner = self.inner.approved_patches_compliance_level(input);
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as missing, this value describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.</p>
        pub fn set_approved_patches_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches_compliance_level(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
        pub fn approved_patches_enable_non_security(mut self, input: bool) -> Self {
            self.inner = self.inner.approved_patches_enable_non_security(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.</p>
        pub fn set_approved_patches_enable_non_security(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches_enable_non_security(input);
            self
        }
        /// Appends an item to `RejectedPatches`.
        ///
        /// To override the contents of this collection use [`set_rejected_patches`](Self::set_rejected_patches).
        ///
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn rejected_patches(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rejected_patches(input.into());
            self
        }
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_rejected_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rejected_patches(input);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li> <p> <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.</p> </li>
        /// <li> <p> <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as <code>InstalledRejected</code>.</p> </li>
        /// </ul>
        pub fn rejected_patches_action(mut self, input: crate::model::PatchAction) -> Self {
            self.inner = self.inner.rejected_patches_action(input);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li> <p> <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.</p> </li>
        /// <li> <p> <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as <code>InstalledRejected</code>.</p> </li>
        /// </ul>
        pub fn set_rejected_patches_action(
            mut self,
            input: std::option::Option<crate::model::PatchAction>,
        ) -> Self {
            self.inner = self.inner.set_rejected_patches_action(input);
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn sources(mut self, input: crate::model::PatchSource) -> Self {
            self.inner = self.inner.sources(input);
            self
        }
        /// <p>Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the severity level of patches it specifies and the operating system family it applies to. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=PatchSeverity,Value=Critical</code> </p> </li>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// </ul> <note>
        /// <p>To add tags to an existing patch baseline, use the <code>AddTagsToResource</code> operation.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the severity level of patches it specifies and the operating system family it applies to. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li> <p> <code>Key=PatchSeverity,Value=Critical</code> </p> </li>
        /// <li> <p> <code>Key=OS,Value=Windows</code> </p> </li>
        /// </ul> <note>
        /// <p>To add tags to an existing patch baseline, use the <code>AddTagsToResource</code> operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceDataSync`.
    ///
    /// <p>A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems Manager offers two types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.</p>
    /// <p>You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring resource data sync for Inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple Amazon Web Services accounts and Amazon Web Services Regions or <code>EntireOrganization</code> by using Organizations. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data. To check the status of a sync, use the <code>ListResourceDataSync</code>.</p> <note>
    /// <p>By default, data isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourceDataSync {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resource_data_sync_input::Builder,
    }
    impl CreateResourceDataSync {
        /// Creates a new `CreateResourceDataSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceDataSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceDataSyncError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the configuration.</p>
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_name(input.into());
            self
        }
        /// <p>A name for the configuration.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_name(input);
            self
        }
        /// <p>Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value is SyncToDestination.</p>
        pub fn s3_destination(
            mut self,
            input: crate::model::ResourceDataSyncS3Destination,
        ) -> Self {
            self.inner = self.inner.s3_destination(input);
            self
        }
        /// <p>Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value is SyncToDestination.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncS3Destination>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
        /// <p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_type(input.into());
            self
        }
        /// <p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
        /// <p>Specify information about the data sources to synchronize. This parameter is required if the <code>SyncType</code> value is SyncFromSource.</p>
        pub fn sync_source(mut self, input: crate::model::ResourceDataSyncSource) -> Self {
            self.inner = self.inner.sync_source(input);
            self
        }
        /// <p>Specify information about the data sources to synchronize. This parameter is required if the <code>SyncType</code> value is SyncFromSource.</p>
        pub fn set_sync_source(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncSource>,
        ) -> Self {
            self.inner = self.inner.set_sync_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteActivation`.
    ///
    /// <p>Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no longer use it to register additional managed nodes. Deleting an activation doesn't de-register managed nodes. You must manually de-register managed nodes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteActivation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_activation_input::Builder,
    }
    impl DeleteActivation {
        /// Creates a new `DeleteActivation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteActivationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteActivationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the activation that you want to delete.</p>
        pub fn activation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_id(input.into());
            self
        }
        /// <p>The ID of the activation that you want to delete.</p>
        pub fn set_activation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssociation`.
    ///
    /// <p>Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed node. If you created the association by using the <code>Targets</code> parameter, then you must delete the association by using the association ID.</p>
    /// <p>When you disassociate a document from a managed node, it doesn't change the configuration of the node. To change the configuration state of a managed node after you disassociate a document, you must create a new document with the desired configuration and associate it with the node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_association_input::Builder,
    }
    impl DeleteAssociation {
        /// Creates a new `DeleteAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The managed node ID.</p> <note>
        /// <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The managed node ID.</p> <note>
        /// <p> <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The association ID that you want to delete.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The association ID that you want to delete.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocument`.
    ///
    /// <p>Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the document.</p>
    /// <p>Before you delete the document, we recommend that you use <code>DeleteAssociation</code> to disassociate all managed nodes that are associated with the document.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDocument {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_document_input::Builder,
    }
    impl DeleteDocument {
        /// Creates a new `DeleteDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the document that you want to delete. If not provided, all versions of the document are deleted.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(input.into());
            self
        }
        /// <p>The version of the document that you want to delete. If not provided, all versions of the document are deleted.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The version name of the document that you want to delete. If not provided, all versions of the document are deleted.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>The version name of the document that you want to delete. If not provided, all versions of the document are deleted.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>Some SSM document types require that you specify a <code>Force</code> flag before you can delete the document. For example, you must specify a <code>Force</code> flag to delete a document of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>Some SSM document types require that you specify a <code>Force</code> flag before you can delete the document. For example, you must specify a <code>Force</code> flag to delete a document of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInventory`.
    ///
    /// <p>Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory type is also referred to as deleting a custom inventory schema.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInventory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_inventory_input::Builder,
    }
    impl DeleteInventory {
        /// Creates a new `DeleteInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInventoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom inventory type for which you want to delete either all previously collected data or the inventory type itself. </p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The name of the custom inventory type for which you want to delete either all previously collected data or the inventory type itself. </p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose this option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of the following options:</p>
        /// <p>DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> operation for a version greater than the disabled version.</p>
        /// <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the schema later, if you want.</p>
        pub fn schema_delete_option(
            mut self,
            input: crate::model::InventorySchemaDeleteOption,
        ) -> Self {
            self.inner = self.inner.schema_delete_option(input);
            self
        }
        /// <p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose this option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of the following options:</p>
        /// <p>DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> operation for a version greater than the disabled version.</p>
        /// <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the schema later, if you want.</p>
        pub fn set_schema_delete_option(
            mut self,
            input: std::option::Option<crate::model::InventorySchemaDeleteOption>,
        ) -> Self {
            self.inner = self.inner.set_schema_delete_option(input);
            self
        }
        /// <p>Use this option to view a summary of the deletion request without deleting any data or the data type. This option is useful when you only want to understand what will be deleted. Once you validate that the data to be deleted is what you intend to delete, you can run the same command without specifying the <code>DryRun</code> option.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Use this option to view a summary of the deletion request without deleting any data or the data type. This option is useful when you only want to understand what will be deleted. Once you validate that the data to be deleted is what you intend to delete, you can run the same command without specifying the <code>DryRun</code> option.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMaintenanceWindow`.
    ///
    /// <p>Deletes a maintenance window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMaintenanceWindow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_maintenance_window_input::Builder,
    }
    impl DeleteMaintenanceWindow {
        /// Creates a new `DeleteMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMaintenanceWindowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window to delete.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window to delete.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOpsMetadata`.
    ///
    /// <p>Delete OpsMetadata related to an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteOpsMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_ops_metadata_input::Builder,
    }
    impl DeleteOpsMetadata {
        /// Creates a new `DeleteOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOpsMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>
        pub fn ops_metadata_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_metadata_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_metadata_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParameter`.
    ///
    /// <p>Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteParameter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_parameter_input::Builder,
    }
    impl DeleteParameter {
        /// Creates a new `DeleteParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParameterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the parameter to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParameters`.
    ///
    /// <p>Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_parameters_input::Builder,
    }
    impl DeleteParameters {
        /// Creates a new `DeleteParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the parameters to delete. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the parameters to delete. After deleting a parameter, wait for at least 30 seconds to create a parameter with the same name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePatchBaseline`.
    ///
    /// <p>Deletes a patch baseline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePatchBaseline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_patch_baseline_input::Builder,
    }
    impl DeletePatchBaseline {
        /// Creates a new `DeletePatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePatchBaselineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to delete.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(input.into());
            self
        }
        /// <p>The ID of the patch baseline to delete.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceDataSync`.
    ///
    /// <p>Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed nodes are no longer synced to or from the target. Deleting a sync configuration doesn't delete data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourceDataSync {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_data_sync_input::Builder,
    }
    impl DeleteResourceDataSync {
        /// Creates a new `DeleteResourceDataSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceDataSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceDataSyncError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration to delete.</p>
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_name(input.into());
            self
        }
        /// <p>The name of the configuration to delete.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_name(input);
            self
        }
        /// <p>Specify the type of resource data sync to delete.</p>
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_type(input.into());
            self
        }
        /// <p>Specify the type of resource data sync to delete.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterManagedInstance`.
    ///
    /// <p>Removes the server or virtual machine from the list of registered servers. You can reregister the node again at any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterManagedInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_managed_instance_input::Builder,
    }
    impl DeregisterManagedInstance {
        /// Creates a new `DeregisterManagedInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterManagedInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterManagedInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the managed node when you registered it using the activation process. </p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID assigned to the managed node when you registered it using the activation process. </p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterPatchBaselineForPatchGroup`.
    ///
    /// <p>Removes a patch group from a patch baseline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterPatchBaselineForPatchGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_patch_baseline_for_patch_group_input::Builder,
    }
    impl DeregisterPatchBaselineForPatchGroup {
        /// Creates a new `DeregisterPatchBaselineForPatchGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterPatchBaselineForPatchGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterPatchBaselineForPatchGroupError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to deregister the patch group from.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(input.into());
            self
        }
        /// <p>The ID of the patch baseline to deregister the patch group from.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
        /// <p>The name of the patch group that should be deregistered from the patch baseline.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(input.into());
            self
        }
        /// <p>The name of the patch group that should be deregistered from the patch baseline.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTargetFromMaintenanceWindow`.
    ///
    /// <p>Removes a target from a maintenance window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterTargetFromMaintenanceWindow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_target_from_maintenance_window_input::Builder,
    }
    impl DeregisterTargetFromMaintenanceWindow {
        /// Creates a new `DeregisterTargetFromMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTargetFromMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterTargetFromMaintenanceWindowError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window the target should be removed from.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window the target should be removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The ID of the target definition to remove.</p>
        pub fn window_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_target_id(input.into());
            self
        }
        /// <p>The ID of the target definition to remove.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_target_id(input);
            self
        }
        /// <p>The system checks if the target is being referenced by a task. If the target is being referenced, the system returns an error and doesn't deregister the target from the maintenance window.</p>
        pub fn safe(mut self, input: bool) -> Self {
            self.inner = self.inner.safe(input);
            self
        }
        /// <p>The system checks if the target is being referenced by a task. If the target is being referenced, the system returns an error and doesn't deregister the target from the maintenance window.</p>
        pub fn set_safe(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_safe(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTaskFromMaintenanceWindow`.
    ///
    /// <p>Removes a task from a maintenance window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterTaskFromMaintenanceWindow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_task_from_maintenance_window_input::Builder,
    }
    impl DeregisterTaskFromMaintenanceWindow {
        /// Creates a new `DeregisterTaskFromMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTaskFromMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterTaskFromMaintenanceWindowError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window the task should be removed from.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window the task should be removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The ID of the task to remove from the maintenance window.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_task_id(input.into());
            self
        }
        /// <p>The ID of the task to remove from the maintenance window.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActivations`.
    ///
    /// <p>Describes details about the activation, such as the date and time the activation was created, its expiration date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the number of nodes registered by using this activation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeActivations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_activations_input::Builder,
    }
    impl DescribeActivations {
        /// Creates a new `DescribeActivations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActivationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActivationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeActivationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeActivationsPaginator {
            crate::paginator::DescribeActivationsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter to view information about your activations.</p>
        pub fn filters(mut self, input: crate::model::DescribeActivationsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A filter to view information about your activations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribeActivationsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssociation`.
    ///
    /// <p>Describes the association for the specified target or managed node. If you created the association by using the <code>Targets</code> parameter, then you must retrieve the association by using the association ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_association_input::Builder,
    }
    impl DescribeAssociation {
        /// Creates a new `DescribeAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The managed node ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The managed node ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The association ID for which you want information.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The association ID for which you want information.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>Specify the association version to retrieve. To view the latest version, either specify <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all associations for a managed node, use <code>ListAssociations</code>. To get a list of versions for a specific association, use <code>ListAssociationVersions</code>. </p>
        pub fn association_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_version(input.into());
            self
        }
        /// <p>Specify the association version to retrieve. To view the latest version, either specify <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all associations for a managed node, use <code>ListAssociations</code>. To get a list of versions for a specific association, use <code>ListAssociationVersions</code>. </p>
        pub fn set_association_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssociationExecutions`.
    ///
    /// <p>Views all executions for a specific association ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssociationExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_association_executions_input::Builder,
    }
    impl DescribeAssociationExecutions {
        /// Creates a new `DescribeAssociationExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssociationExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssociationExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAssociationExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAssociationExecutionsPaginator {
            crate::paginator::DescribeAssociationExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The association ID for which you want to view execution history details.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The association ID for which you want to view execution history details.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>ExecutionId (EQUAL)</p>
        /// <p>Status (EQUAL)</p>
        /// <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>
        pub fn filters(mut self, input: crate::model::AssociationExecutionFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>ExecutionId (EQUAL)</p>
        /// <p>Status (EQUAL)</p>
        /// <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationExecutionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssociationExecutionTargets`.
    ///
    /// <p>Views information about a specific execution of a specific association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssociationExecutionTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_association_execution_targets_input::Builder,
    }
    impl DescribeAssociationExecutionTargets {
        /// Creates a new `DescribeAssociationExecutionTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssociationExecutionTargetsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAssociationExecutionTargetsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAssociationExecutionTargetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeAssociationExecutionTargetsPaginator {
            crate::paginator::DescribeAssociationExecutionTargetsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The association ID that includes the execution for which you want to view details.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The association ID that includes the execution for which you want to view details.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The execution ID for which you want to view details.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_id(input.into());
            self
        }
        /// <p>The execution ID for which you want to view details.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_execution_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>Status (EQUAL)</p>
        /// <p>ResourceId (EQUAL)</p>
        /// <p>ResourceType (EQUAL)</p>
        pub fn filters(mut self, input: crate::model::AssociationExecutionTargetsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>Status (EQUAL)</p>
        /// <p>ResourceId (EQUAL)</p>
        /// <p>ResourceType (EQUAL)</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociationExecutionTargetsFilter>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAutomationExecutions`.
    ///
    /// <p>Provides details about all active and terminated Automation executions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAutomationExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_automation_executions_input::Builder,
    }
    impl DescribeAutomationExecutions {
        /// Creates a new `DescribeAutomationExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAutomationExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAutomationExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAutomationExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAutomationExecutionsPaginator {
            crate::paginator::DescribeAutomationExecutionsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters used to limit the scope of executions that are requested.</p>
        pub fn filters(mut self, input: crate::model::AutomationExecutionFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters used to limit the scope of executions that are requested.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomationExecutionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAutomationStepExecutions`.
    ///
    /// <p>Information about all active and terminated step executions in an Automation workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAutomationStepExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_automation_step_executions_input::Builder,
    }
    impl DescribeAutomationStepExecutions {
        /// Creates a new `DescribeAutomationStepExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAutomationStepExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAutomationStepExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAutomationStepExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAutomationStepExecutionsPaginator {
            crate::paginator::DescribeAutomationStepExecutionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The Automation execution ID for which you want step execution descriptions.</p>
        pub fn automation_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.automation_execution_id(input.into());
            self
        }
        /// <p>The Automation execution ID for which you want step execution descriptions.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_execution_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the number of step executions returned by the request.</p>
        pub fn filters(mut self, input: crate::model::StepExecutionFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters to limit the number of step executions returned by the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepExecutionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Indicates whether to list step executions in reverse order by start time. The default value is 'false'.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>Indicates whether to list step executions in reverse order by start time. The default value is 'false'.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAvailablePatches`.
    ///
    /// <p>Lists all patches eligible to be included in a patch baseline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAvailablePatches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_available_patches_input::Builder,
    }
    impl DescribeAvailablePatches {
        /// Creates a new `DescribeAvailablePatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAvailablePatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAvailablePatchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAvailablePatchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAvailablePatchesPaginator {
            crate::paginator::DescribeAvailablePatchesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p> <b>Windows Server</b> </p>
        /// <p>Supported keys for Windows Server managed node patches include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>PATCH_SET</code> </b> </p> <p>Sample values: <code>OS</code> | <code>APPLICATION</code> </p> </li>
        /// <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> | <code>MicrosoftDefenderAntivirus</code> </p> </li>
        /// <li> <p> <b> <code>PRODUCT_FAMILY</code> </b> </p> <p>Sample values: <code>Windows</code> | <code>Office</code> </p> </li>
        /// <li> <p> <b> <code>MSRC_SEVERITY</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code> </p> </li>
        /// <li> <p> <b> <code>CLASSIFICATION</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> | <code>DefinitionUpdates</code> </p> </li>
        /// <li> <p> <b> <code>PATCH_ID</code> </b> </p> <p>Sample values: <code>KB123456</code> | <code>KB4516046</code> </p> </li>
        /// </ul>
        /// <p> <b>Linux</b> </p> <important>
        /// <p>When specifying filters for Linux patches, you must specify a key-pair for <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the following command fails:</p>
        /// <p> <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code> </p>
        /// <p>However, the following command succeeds:</p>
        /// <p> <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03 Key=CVE_ID,Values=CVE-2018-3615</code> </p>
        /// </important>
        /// <p>Supported keys for Linux managed node patches include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code> </p> </li>
        /// <li> <p> <b> <code>NAME</code> </b> </p> <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code> </p> </li>
        /// <li> <p> <b> <code>SEVERITY</code> </b> </p> <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li>
        /// <li> <p> <b> <code>EPOCH</code> </b> </p> <p>Sample values: <code>0</code> | <code>1</code> </p> </li>
        /// <li> <p> <b> <code>VERSION</code> </b> </p> <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code> </p> </li>
        /// <li> <p> <b> <code>RELEASE</code> </b> </p> <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code> </p> </li>
        /// <li> <p> <b> <code>ARCH</code> </b> </p> <p>Sample values: <code>i686</code> | <code>x86_64</code> </p> </li>
        /// <li> <p> <b> <code>REPOSITORY</code> </b> </p> <p>Sample values: <code>Core</code> | <code>Updates</code> </p> </li>
        /// <li> <p> <b> <code>ADVISORY_ID</code> </b> </p> <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code> </p> </li>
        /// <li> <p> <b> <code>CVE_ID</code> </b> </p> <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code> </p> </li>
        /// <li> <p> <b> <code>BUGZILLA_ID</code> </b> </p> <p>Sample values: <code>1463241</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::PatchOrchestratorFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p> <b>Windows Server</b> </p>
        /// <p>Supported keys for Windows Server managed node patches include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>PATCH_SET</code> </b> </p> <p>Sample values: <code>OS</code> | <code>APPLICATION</code> </p> </li>
        /// <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> | <code>MicrosoftDefenderAntivirus</code> </p> </li>
        /// <li> <p> <b> <code>PRODUCT_FAMILY</code> </b> </p> <p>Sample values: <code>Windows</code> | <code>Office</code> </p> </li>
        /// <li> <p> <b> <code>MSRC_SEVERITY</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code> </p> </li>
        /// <li> <p> <b> <code>CLASSIFICATION</code> </b> </p> <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> | <code>DefinitionUpdates</code> </p> </li>
        /// <li> <p> <b> <code>PATCH_ID</code> </b> </p> <p>Sample values: <code>KB123456</code> | <code>KB4516046</code> </p> </li>
        /// </ul>
        /// <p> <b>Linux</b> </p> <important>
        /// <p>When specifying filters for Linux patches, you must specify a key-pair for <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the following command fails:</p>
        /// <p> <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code> </p>
        /// <p>However, the following command succeeds:</p>
        /// <p> <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03 Key=CVE_ID,Values=CVE-2018-3615</code> </p>
        /// </important>
        /// <p>Supported keys for Linux managed node patches include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>PRODUCT</code> </b> </p> <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code> </p> </li>
        /// <li> <p> <b> <code>NAME</code> </b> </p> <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code> </p> </li>
        /// <li> <p> <b> <code>SEVERITY</code> </b> </p> <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li>
        /// <li> <p> <b> <code>EPOCH</code> </b> </p> <p>Sample values: <code>0</code> | <code>1</code> </p> </li>
        /// <li> <p> <b> <code>VERSION</code> </b> </p> <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code> </p> </li>
        /// <li> <p> <b> <code>RELEASE</code> </b> </p> <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code> </p> </li>
        /// <li> <p> <b> <code>ARCH</code> </b> </p> <p>Sample values: <code>i686</code> | <code>x86_64</code> </p> </li>
        /// <li> <p> <b> <code>REPOSITORY</code> </b> </p> <p>Sample values: <code>Core</code> | <code>Updates</code> </p> </li>
        /// <li> <p> <b> <code>ADVISORY_ID</code> </b> </p> <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code> </p> </li>
        /// <li> <p> <b> <code>CVE_ID</code> </b> </p> <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code> </p> </li>
        /// <li> <p> <b> <code>BUGZILLA_ID</code> </b> </p> <p>Sample values: <code>1463241</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocument`.
    ///
    /// <p>Describes the specified Amazon Web Services Systems Manager document (SSM document).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDocument {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_document_input::Builder,
    }
    impl DescribeDocument {
        /// Creates a new `DescribeDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The document version for which you want information. Can be a specific version or the default version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(input.into());
            self
        }
        /// <p>The document version for which you want information. Can be a specific version or the default version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocumentPermission`.
    ///
    /// <p>Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user's Amazon Web Services account ID) or publicly (<i>All</i>). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDocumentPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_document_permission_input::Builder,
    }
    impl DescribeDocumentPermission {
        /// Creates a new `DescribeDocumentPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document for which you are the owner.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the document for which you are the owner.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be <i>Share</i>.</p>
        pub fn permission_type(mut self, input: crate::model::DocumentPermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be <i>Share</i>.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::DocumentPermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEffectiveInstanceAssociations`.
    ///
    /// <p>All associations for the managed node(s).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEffectiveInstanceAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_effective_instance_associations_input::Builder,
    }
    impl DescribeEffectiveInstanceAssociations {
        /// Creates a new `DescribeEffectiveInstanceAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEffectiveInstanceAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEffectiveInstanceAssociationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEffectiveInstanceAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeEffectiveInstanceAssociationsPaginator {
            crate::paginator::DescribeEffectiveInstanceAssociationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The managed node ID for which you want to view all associations.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The managed node ID for which you want to view all associations.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEffectivePatchesForPatchBaseline`.
    ///
    /// <p>Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Applies to patch baselines for Windows only.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEffectivePatchesForPatchBaseline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_effective_patches_for_patch_baseline_input::Builder,
    }
    impl DescribeEffectivePatchesForPatchBaseline {
        /// Creates a new `DescribeEffectivePatchesForPatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEffectivePatchesForPatchBaselineOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEffectivePatchesForPatchBaselineError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEffectivePatchesForPatchBaselinePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeEffectivePatchesForPatchBaselinePaginator {
            crate::paginator::DescribeEffectivePatchesForPatchBaselinePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the patch baseline to retrieve the effective patches for.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(input.into());
            self
        }
        /// <p>The ID of the patch baseline to retrieve the effective patches for.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceAssociationsStatus`.
    ///
    /// <p>The status of the associations for the managed node(s).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstanceAssociationsStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_instance_associations_status_input::Builder,
    }
    impl DescribeInstanceAssociationsStatus {
        /// Creates a new `DescribeInstanceAssociationsStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceAssociationsStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInstanceAssociationsStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInstanceAssociationsStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeInstanceAssociationsStatusPaginator {
            crate::paginator::DescribeInstanceAssociationsStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The managed node IDs for which you want association status information.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The managed node IDs for which you want association status information.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceInformation`.
    ///
    /// <p>Describes one or more of your managed nodes, including information about the operating system platform, the version of SSM Agent installed on the managed node, node status, and so on.</p>
    /// <p>If you specify one or more managed node IDs, it returns information for those managed nodes. If you don't specify node IDs, it returns information for all your managed nodes. If you specify a node ID that isn't valid or a node that you don't own, you receive an error.</p> <note>
    /// <p>The <code>IamRole</code> field for this API operation is the Identity and Access Management (IAM) role assigned to on-premises managed nodes. This call doesn't return the IAM role for EC2 instances.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstanceInformation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_instance_information_input::Builder,
    }
    impl DescribeInstanceInformation {
        /// Creates a new `DescribeInstanceInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceInformationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInstanceInformationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeInstanceInformationPaginator {
            crate::paginator::DescribeInstanceInformationPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `InstanceInformationFilterList`.
        ///
        /// To override the contents of this collection use [`set_instance_information_filter_list`](Self::set_instance_information_filter_list).
        ///
        /// <p>This is a legacy method. We recommend that you don't use this method. Instead, use the <code>Filters</code> data type. <code>Filters</code> enables you to return node information by filtering based on tags applied to managed nodes.</p> <note>
        /// <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception error. </p>
        /// </note>
        pub fn instance_information_filter_list(
            mut self,
            input: crate::model::InstanceInformationFilter,
        ) -> Self {
            self.inner = self.inner.instance_information_filter_list(input);
            self
        }
        /// <p>This is a legacy method. We recommend that you don't use this method. Instead, use the <code>Filters</code> data type. <code>Filters</code> enables you to return node information by filtering based on tags applied to managed nodes.</p> <note>
        /// <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception error. </p>
        /// </note>
        pub fn set_instance_information_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceInformationFilter>>,
        ) -> Self {
            self.inner = self.inner.set_instance_information_filter_list(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of managed nodes. You can filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of <code>InstanceInformationFilterList</code>, which is deprecated.</p>
        pub fn filters(mut self, input: crate::model::InstanceInformationStringFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of managed nodes. You can filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of <code>InstanceInformationFilterList</code>, which is deprecated.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InstanceInformationStringFilter>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancePatches`.
    ///
    /// <p>Retrieves information about the patches on the specified managed node and their state relative to the patch baseline being used for the node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstancePatches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_instance_patches_input::Builder,
    }
    impl DescribeInstancePatches {
        /// Creates a new `DescribeInstancePatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancePatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInstancePatchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeInstancePatchesPaginator {
            crate::paginator::DescribeInstancePatchesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the managed node whose patch state information should be retrieved.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the managed node whose patch state information should be retrieved.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>Classification</code> </b> </p> <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code> </p> </li>
        /// <li> <p> <b> <code>KBId</code> </b> </p> <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code> </p> </li>
        /// <li> <p> <b> <code>Severity</code> </b> </p> <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li>
        /// <li> <p> <b> <code>State</code> </b> </p> <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::PatchOrchestratorFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>Classification</code> </b> </p> <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code> </p> </li>
        /// <li> <p> <b> <code>KBId</code> </b> </p> <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code> </p> </li>
        /// <li> <p> <b> <code>Severity</code> </b> </p> <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code> </p> </li>
        /// <li> <p> <b> <code>State</code> </b> </p> <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> | <code>InstalledPendingReboot</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancePatchStates`.
    ///
    /// <p>Retrieves the high-level patch state of one or more managed nodes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstancePatchStates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_instance_patch_states_input::Builder,
    }
    impl DescribeInstancePatchStates {
        /// Creates a new `DescribeInstancePatchStates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancePatchStatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchStatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInstancePatchStatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeInstancePatchStatesPaginator {
            crate::paginator::DescribeInstancePatchStatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `InstanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The ID of the managed node for which patch state information should be retrieved.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(input.into());
            self
        }
        /// <p>The ID of the managed node for which patch state information should be retrieved.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of managed nodes to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of managed nodes to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancePatchStatesForPatchGroup`.
    ///
    /// <p>Retrieves the high-level patch state for the managed nodes in the specified patch group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstancePatchStatesForPatchGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_instance_patch_states_for_patch_group_input::Builder,
    }
    impl DescribeInstancePatchStatesForPatchGroup {
        /// Creates a new `DescribeInstancePatchStatesForPatchGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancePatchStatesForPatchGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInstancePatchStatesForPatchGroupError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInstancePatchStatesForPatchGroupPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeInstancePatchStatesForPatchGroupPaginator {
            crate::paginator::DescribeInstancePatchStatesForPatchGroupPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the patch group for which the patch state information should be retrieved.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(input.into());
            self
        }
        /// <p>The name of the patch group for which the patch state information should be retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li> <p>Key (string between 1 and 200 characters)</p> </li>
        /// <li> <p>Values (array containing a single string)</p> </li>
        /// <li> <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::InstancePatchStateFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li> <p>Key (string between 1 and 200 characters)</p> </li>
        /// <li> <p>Values (array containing a single string)</p> </li>
        /// <li> <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePatchStateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInventoryDeletions`.
    ///
    /// <p>Describes a specific delete inventory operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInventoryDeletions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_inventory_deletions_input::Builder,
    }
    impl DescribeInventoryDeletions {
        /// Creates a new `DescribeInventoryDeletions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInventoryDeletionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInventoryDeletionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeInventoryDeletionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeInventoryDeletionsPaginator {
            crate::paginator::DescribeInventoryDeletionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify the delete inventory ID for which you want information. This ID was returned by the <code>DeleteInventory</code> operation.</p>
        pub fn deletion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deletion_id(input.into());
            self
        }
        /// <p>Specify the delete inventory ID for which you want information. This ID was returned by the <code>DeleteInventory</code> operation.</p>
        pub fn set_deletion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_deletion_id(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowExecutions`.
    ///
    /// <p>Lists the executions of a maintenance window. This includes information about when the maintenance window was scheduled to be active, and information about tasks registered and run with the maintenance window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_window_executions_input::Builder,
    }
    impl DescribeMaintenanceWindowExecutions {
        /// Creates a new `DescribeMaintenanceWindowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowExecutionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMaintenanceWindowExecutionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeMaintenanceWindowExecutionsPaginator {
            crate::paginator::DescribeMaintenanceWindowExecutionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the maintenance window whose executions should be retrieved.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window whose executions should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li> <p>Key. A string between 1 and 128 characters. Supported keys include <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p> </li>
        /// <li> <p>Values. An array of strings, each between 1 and 256 characters. Supported values are date/time strings in a valid ISO 8601 date/time format, such as <code>2021-11-04T05:00:00Z</code>.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::MaintenanceWindowFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li> <p>Key. A string between 1 and 128 characters. Supported keys include <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p> </li>
        /// <li> <p>Values. An array of strings, each between 1 and 256 characters. Supported values are date/time strings in a valid ISO 8601 date/time format, such as <code>2021-11-04T05:00:00Z</code>.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowExecutionTaskInvocations`.
    ///
    /// <p>Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowExecutionTaskInvocations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_window_execution_task_invocations_input::Builder,
    }
    impl DescribeMaintenanceWindowExecutionTaskInvocations {
        /// Creates a new `DescribeMaintenanceWindowExecutionTaskInvocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowExecutionTaskInvocationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeMaintenanceWindowExecutionTaskInvocationsPaginator {
            crate::paginator::DescribeMaintenanceWindowExecutionTaskInvocationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the maintenance window execution the task is part of.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution the task is part of.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned task invocations. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn filters(mut self, input: crate::model::MaintenanceWindowFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters used to scope down the returned task invocations. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowExecutionTasks`.
    ///
    /// <p>For a given maintenance window execution, lists the tasks that were run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowExecutionTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_window_execution_tasks_input::Builder,
    }
    impl DescribeMaintenanceWindowExecutionTasks {
        /// Creates a new `DescribeMaintenanceWindowExecutionTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowExecutionTasksOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMaintenanceWindowExecutionTasksError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowExecutionTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeMaintenanceWindowExecutionTasksPaginator {
            crate::paginator::DescribeMaintenanceWindowExecutionTasksPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the maintenance window execution whose task executions should be retrieved.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution whose task executions should be retrieved.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned tasks. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn filters(mut self, input: crate::model::MaintenanceWindowFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters used to scope down the returned tasks. The supported filter key is <code>STATUS</code> with the corresponding values <code>PENDING</code>, <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindows`.
    ///
    /// <p>Retrieves the maintenance windows in an Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_windows_input::Builder,
    }
    impl DescribeMaintenanceWindows {
        /// Creates a new `DescribeMaintenanceWindows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeMaintenanceWindowsPaginator {
            crate::paginator::DescribeMaintenanceWindowsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to narrow down the scope of the returned maintenance windows. Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example, <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>
        pub fn filters(mut self, input: crate::model::MaintenanceWindowFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters used to narrow down the scope of the returned maintenance windows. Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example, <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowSchedule`.
    ///
    /// <p>Retrieves information about upcoming executions of a maintenance window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_window_schedule_input::Builder,
    }
    impl DescribeMaintenanceWindowSchedule {
        /// Creates a new `DescribeMaintenanceWindowSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowSchedulePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeMaintenanceWindowSchedulePaginator {
            crate::paginator::DescribeMaintenanceWindowSchedulePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the maintenance window to retrieve information about.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window to retrieve information about.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>
        pub fn resource_type(mut self, input: crate::model::MaintenanceWindowResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters used to limit the range of results. For example, you can limit maintenance window executions to only those scheduled before or after a certain date and time.</p>
        pub fn filters(mut self, input: crate::model::PatchOrchestratorFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters used to limit the range of results. For example, you can limit maintenance window executions to only those scheduled before or after a certain date and time.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowsForTarget`.
    ///
    /// <p>Retrieves information about the maintenance window targets or tasks that a managed node is associated with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowsForTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_windows_for_target_input::Builder,
    }
    impl DescribeMaintenanceWindowsForTarget {
        /// Creates a new `DescribeMaintenanceWindowsForTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowsForTargetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMaintenanceWindowsForTargetError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowsForTargetPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeMaintenanceWindowsForTargetPaginator {
            crate::paginator::DescribeMaintenanceWindowsForTargetPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>
        pub fn resource_type(mut self, input: crate::model::MaintenanceWindowResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example, <code>INSTANCE</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowTargets`.
    ///
    /// <p>Lists the targets registered with the maintenance window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_window_targets_input::Builder,
    }
    impl DescribeMaintenanceWindowTargets {
        /// Creates a new `DescribeMaintenanceWindowTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowTargetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeMaintenanceWindowTargetsPaginator {
            crate::paginator::DescribeMaintenanceWindowTargetsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID of the maintenance window whose targets should be retrieved.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window whose targets should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters that can be used to narrow down the scope of the returned window targets. The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and <code>OwnerInformation</code>.</p>
        pub fn filters(mut self, input: crate::model::MaintenanceWindowFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters that can be used to narrow down the scope of the returned window targets. The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and <code>OwnerInformation</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowTasks`.
    ///
    /// <p>Lists the tasks in a maintenance window.</p> <note>
    /// <p>For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code> and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. These values don't affect the running of your task and can be ignored.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_maintenance_window_tasks_input::Builder,
    }
    impl DescribeMaintenanceWindowTasks {
        /// Creates a new `DescribeMaintenanceWindowTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMaintenanceWindowTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeMaintenanceWindowTasksPaginator {
            crate::paginator::DescribeMaintenanceWindowTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the maintenance window whose tasks should be retrieved.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window whose tasks should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to narrow down the scope of the returned tasks. The supported filter keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and <code>TaskType</code>.</p>
        pub fn filters(mut self, input: crate::model::MaintenanceWindowFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters used to narrow down the scope of the returned tasks. The supported filter keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and <code>TaskType</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOpsItems`.
    ///
    /// <p>Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOpsItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_ops_items_input::Builder,
    }
    impl DescribeOpsItems {
        /// Creates a new `DescribeOpsItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOpsItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOpsItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOpsItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeOpsItemsPaginator {
            crate::paginator::DescribeOpsItemsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `OpsItemFilters`.
        ///
        /// To override the contents of this collection use [`set_ops_item_filters`](Self::set_ops_item_filters).
        ///
        /// <p>One or more filters to limit the response.</p>
        /// <ul>
        /// <li> <p>Key: CreatedTime</p> <p>Operations: GreaterThan, LessThan</p> </li>
        /// <li> <p>Key: LastModifiedBy</p> <p>Operations: Contains, Equals</p> </li>
        /// <li> <p>Key: LastModifiedTime</p> <p>Operations: GreaterThan, LessThan</p> </li>
        /// <li> <p>Key: Priority</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: Source</p> <p>Operations: Contains, Equals</p> </li>
        /// <li> <p>Key: Status</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: Title*</p> <p>Operations: Equals,Contains</p> </li>
        /// <li> <p>Key: OperationalData**</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: OperationalDataKey</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: OperationalDataValue</p> <p>Operations: Equals, Contains</p> </li>
        /// <li> <p>Key: OpsItemId</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: ResourceId</p> <p>Operations: Contains</p> </li>
        /// <li> <p>Key: AutomationId</p> <p>Operations: Equals</p> </li>
        /// </ul>
        /// <p>*The Equals operator for Title matches the first 100 characters. If you specify more than 100 characters, they system returns an error that the filter value exceeds the length limit.</p>
        /// <p>**If you filter the response by using the OperationalData operator, specify a key-value pair by using the following JSON format: {"key":"key_name","value":"a_value"}</p>
        pub fn ops_item_filters(mut self, input: crate::model::OpsItemFilter) -> Self {
            self.inner = self.inner.ops_item_filters(input);
            self
        }
        /// <p>One or more filters to limit the response.</p>
        /// <ul>
        /// <li> <p>Key: CreatedTime</p> <p>Operations: GreaterThan, LessThan</p> </li>
        /// <li> <p>Key: LastModifiedBy</p> <p>Operations: Contains, Equals</p> </li>
        /// <li> <p>Key: LastModifiedTime</p> <p>Operations: GreaterThan, LessThan</p> </li>
        /// <li> <p>Key: Priority</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: Source</p> <p>Operations: Contains, Equals</p> </li>
        /// <li> <p>Key: Status</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: Title*</p> <p>Operations: Equals,Contains</p> </li>
        /// <li> <p>Key: OperationalData**</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: OperationalDataKey</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: OperationalDataValue</p> <p>Operations: Equals, Contains</p> </li>
        /// <li> <p>Key: OpsItemId</p> <p>Operations: Equals</p> </li>
        /// <li> <p>Key: ResourceId</p> <p>Operations: Contains</p> </li>
        /// <li> <p>Key: AutomationId</p> <p>Operations: Equals</p> </li>
        /// </ul>
        /// <p>*The Equals operator for Title matches the first 100 characters. If you specify more than 100 characters, they system returns an error that the filter value exceeds the length limit.</p>
        /// <p>**If you filter the response by using the OperationalData operator, specify a key-value pair by using the following JSON format: {"key":"key_name","value":"a_value"}</p>
        pub fn set_ops_item_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemFilter>>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameters`.
    ///
    /// <p>Get information about a parameter.</p>
    /// <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p> <important>
    /// <p>If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, <code>DescribeParameters</code> retrieves whatever the original key alias was referencing.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_parameters_input::Builder,
    }
    impl DescribeParameters {
        /// Creates a new `DescribeParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeParametersPaginator {
            crate::paginator::DescribeParametersPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>
        pub fn filters(mut self, input: crate::model::ParametersFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParametersFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `ParameterFilters`.
        ///
        /// To override the contents of this collection use [`set_parameter_filters`](Self::set_parameter_filters).
        ///
        /// <p>Filters to limit the request results.</p>
        pub fn parameter_filters(mut self, input: crate::model::ParameterStringFilter) -> Self {
            self.inner = self.inner.parameter_filters(input);
            self
        }
        /// <p>Filters to limit the request results.</p>
        pub fn set_parameter_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchBaselines`.
    ///
    /// <p>Lists the patch baselines in your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePatchBaselines {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_patch_baselines_input::Builder,
    }
    impl DescribePatchBaselines {
        /// Creates a new `DescribePatchBaselines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchBaselinesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchBaselinesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePatchBaselinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePatchBaselinesPaginator {
            crate::paginator::DescribePatchBaselinesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code> </p> </li>
        /// <li> <p> <b> <code>OWNER</code> </b> </p> <p>Sample values: <code>AWS</code> | <code>Self</code> </p> </li>
        /// <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::PatchOrchestratorFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code> </p> </li>
        /// <li> <p> <b> <code>OWNER</code> </b> </p> <p>Sample values: <code>AWS</code> | <code>Self</code> </p> </li>
        /// <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of patch baselines to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of patch baselines to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchGroups`.
    ///
    /// <p>Lists all patch groups that have been registered with patch baselines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePatchGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_patch_groups_input::Builder,
    }
    impl DescribePatchGroups {
        /// Creates a new `DescribePatchGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePatchGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePatchGroupsPaginator {
            crate::paginator::DescribePatchGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of patch groups to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of patch groups to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p> </li>
        /// <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::PatchOrchestratorFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p>
        /// <ul>
        /// <li> <p> <b> <code>NAME_PREFIX</code> </b> </p> <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p> </li>
        /// <li> <p> <b> <code>OPERATING_SYSTEM</code> </b> </p> <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchGroupState`.
    ///
    /// <p>Returns high-level aggregated patch compliance state information for a patch group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePatchGroupState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_patch_group_state_input::Builder,
    }
    impl DescribePatchGroupState {
        /// Creates a new `DescribePatchGroupState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchGroupStateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the patch group whose patch snapshot should be retrieved.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(input.into());
            self
        }
        /// <p>The name of the patch group whose patch snapshot should be retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchProperties`.
    ///
    /// <p>Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches. You can use the reported properties in the filters you specify in requests for operations such as <code>CreatePatchBaseline</code>, <code>UpdatePatchBaseline</code>, <code>DescribeAvailablePatches</code>, and <code>DescribePatchBaselines</code>.</p>
    /// <p>The following section lists the properties that can be used in filters for each major operating system type:</p>
    /// <dl>
    /// <dt>
    /// AMAZON_LINUX
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p>
    /// </dd>
    /// <dt>
    /// AMAZON_LINUX_2
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p>
    /// </dd>
    /// <dt>
    /// CENTOS
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p>
    /// </dd>
    /// <dt>
    /// DEBIAN
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code> </p>
    /// </dd>
    /// <dt>
    /// MACOS
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> </p>
    /// </dd>
    /// <dt>
    /// ORACLE_LINUX
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p>
    /// </dd>
    /// <dt>
    /// REDHAT_ENTERPRISE_LINUX
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p>
    /// </dd>
    /// <dt>
    /// SUSE
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code> </p>
    /// </dd>
    /// <dt>
    /// UBUNTU
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code> </p>
    /// </dd>
    /// <dt>
    /// WINDOWS
    /// </dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>PRODUCT_FAMILY</code> | <code>CLASSIFICATION</code> | <code>MSRC_SEVERITY</code> </p>
    /// </dd>
    /// </dl>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePatchProperties {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_patch_properties_input::Builder,
    }
    impl DescribePatchProperties {
        /// Creates a new `DescribePatchProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchPropertiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePatchPropertiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePatchPropertiesPaginator {
            crate::paginator::DescribePatchPropertiesPaginator::new(self.handle, self.inner)
        }
        /// <p>The operating system type for which to list patches.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(input);
            self
        }
        /// <p>The operating system type for which to list patches.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
        /// <p>The patch property for which you want to view patch details. </p>
        pub fn property(mut self, input: crate::model::PatchProperty) -> Self {
            self.inner = self.inner.property(input);
            self
        }
        /// <p>The patch property for which you want to view patch details. </p>
        pub fn set_property(
            mut self,
            input: std::option::Option<crate::model::PatchProperty>,
        ) -> Self {
            self.inner = self.inner.set_property(input);
            self
        }
        /// <p>Indicates whether to list patches for the Windows operating system or for applications released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>
        pub fn patch_set(mut self, input: crate::model::PatchSet) -> Self {
            self.inner = self.inner.patch_set(input);
            self
        }
        /// <p>Indicates whether to list patches for the Windows operating system or for applications released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>
        pub fn set_patch_set(mut self, input: std::option::Option<crate::model::PatchSet>) -> Self {
            self.inner = self.inner.set_patch_set(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSessions`.
    ///
    /// <p>Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSessions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_sessions_input::Builder,
    }
    impl DescribeSessions {
        /// Creates a new `DescribeSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSessionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSessionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSessionsPaginator {
            crate::paginator::DescribeSessionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The session status to retrieve a list of sessions for. For example, "Active".</p>
        pub fn state(mut self, input: crate::model::SessionState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The session status to retrieve a list of sessions for. For example, "Active".</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::SessionState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the type of sessions returned by the request.</p>
        pub fn filters(mut self, input: crate::model::SessionFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters to limit the type of sessions returned by the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SessionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateOpsItemRelatedItem`.
    ///
    /// <p>Deletes the association between an OpsItem and a related item. For example, this API operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a capability of Amazon Web Services Systems Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateOpsItemRelatedItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_ops_item_related_item_input::Builder,
    }
    impl DisassociateOpsItemRelatedItem {
        /// Creates a new `DisassociateOpsItemRelatedItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateOpsItemRelatedItemOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateOpsItemRelatedItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a related item.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(input.into());
            self
        }
        /// <p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a related item.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
        /// <p>The ID of the association for which you want to delete an association between the OpsItem and a related item.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The ID of the association for which you want to delete an association between the OpsItem and a related item.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAutomationExecution`.
    ///
    /// <p>Get detailed information about a particular Automation execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAutomationExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_automation_execution_input::Builder,
    }
    impl GetAutomationExecution {
        /// Creates a new `GetAutomationExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAutomationExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAutomationExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an existing automation execution to examine. The execution ID is returned by StartAutomationExecution when the execution of an Automation runbook is initiated.</p>
        pub fn automation_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.automation_execution_id(input.into());
            self
        }
        /// <p>The unique identifier for an existing automation execution to examine. The execution ID is returned by StartAutomationExecution when the execution of an Automation runbook is initiated.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCalendarState`.
    ///
    /// <p>Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If you specify a time, <code>GetCalendarState</code> returns the state of the calendar at that specific time, and returns the next time that the change calendar state will transition. If you don't specify a time, <code>GetCalendarState</code> uses the current time. Change Calendar entries have two possible states: <code>OPEN</code> or <code>CLOSED</code>.</p>
    /// <p>If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if all calendars in the request are open. If one or more calendars in the request are closed, the status returned is <code>CLOSED</code>.</p>
    /// <p>For more information about Change Calendar, a capability of Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">Amazon Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCalendarState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_calendar_state_input::Builder,
    }
    impl GetCalendarState {
        /// Creates a new `GetCalendarState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCalendarStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCalendarStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `CalendarNames`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that represent the calendar entries for which you want to get the state.</p>
        pub fn calendar_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calendar_names(input.into());
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that represent the calendar entries for which you want to get the state.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_calendar_names(input);
            self
        }
        /// <p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don't specify a value or <code>AtTime</code>, the current time is used.</p>
        pub fn at_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.at_time(input.into());
            self
        }
        /// <p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don't specify a value or <code>AtTime</code>, the current time is used.</p>
        pub fn set_at_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_at_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommandInvocation`.
    ///
    /// <p>Returns detailed information about command execution for an invocation or plugin.</p>
    /// <p> <code>GetCommandInvocation</code> only gives the execution status of a plugin in a document. To get the command execution status on a specific managed node, use <code>ListCommandInvocations</code>. To get the command execution status across managed nodes, use <code>ListCommands</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCommandInvocation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_command_invocation_input::Builder,
    }
    impl GetCommandInvocation {
        /// Creates a new `GetCommandInvocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommandInvocationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommandInvocationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Required) The parent command ID of the invocation plugin.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(input.into());
            self
        }
        /// <p>(Required) The parent command ID of the invocation plugin.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// <p>(Required) The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, and on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>(Required) The ID of the managed node targeted by the command. A <i>managed node</i> can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, and on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the plugin for which you want detailed results. If the document contains only one plugin, you can omit the name and details for that plugin. If the document contains more than one plugin, you must specify the name of the plugin for which you want to view details.</p>
        /// <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM documents). For example, <code>aws:RunShellScript</code> is a plugin.</p>
        /// <p>To find the <code>PluginName</code>, check the document content and find the name of the plugin. Alternatively, use <code>ListCommandInvocations</code> with the <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the <code>Name</code> attribute of the <code>CommandPlugin</code> object in the <code>CommandPlugins</code> list.</p>
        pub fn plugin_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plugin_name(input.into());
            self
        }
        /// <p>The name of the plugin for which you want detailed results. If the document contains only one plugin, you can omit the name and details for that plugin. If the document contains more than one plugin, you must specify the name of the plugin for which you want to view details.</p>
        /// <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM documents). For example, <code>aws:RunShellScript</code> is a plugin.</p>
        /// <p>To find the <code>PluginName</code>, check the document content and find the name of the plugin. Alternatively, use <code>ListCommandInvocations</code> with the <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the <code>Name</code> attribute of the <code>CommandPlugin</code> object in the <code>CommandPlugins</code> list.</p>
        pub fn set_plugin_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plugin_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectionStatus`.
    ///
    /// <p>Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready to receive Session Manager connections.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_connection_status_input::Builder,
    }
    impl GetConnectionStatus {
        /// Creates a new `GetConnectionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectionStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The managed node ID.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(input.into());
            self
        }
        /// <p>The managed node ID.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDefaultPatchBaseline`.
    ///
    /// <p>Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.</p>
    /// <p>If you don't specify an operating system value, the default patch baseline for Windows is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDefaultPatchBaseline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_default_patch_baseline_input::Builder,
    }
    impl GetDefaultPatchBaseline {
        /// Creates a new `GetDefaultPatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDefaultPatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDefaultPatchBaselineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns the default patch baseline for the specified operating system.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(input);
            self
        }
        /// <p>Returns the default patch baseline for the specified operating system.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployablePatchSnapshotForInstance`.
    ///
    /// <p>Retrieves the current snapshot for the patch baseline the managed node uses. This API is primarily used by the <code>AWS-RunPatchBaseline</code> Systems Manager document (SSM document).</p> <note>
    /// <p>If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local Amazon Web Services credentials and the operation fails. To avoid this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a capability of Amazon Web Services Systems Manager, with an SSM document that enables you to target a managed node with a script or command. For example, run the command using the <code>AWS-RunShellScript</code> document or the <code>AWS-RunPowerShellScript</code> document.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployablePatchSnapshotForInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployable_patch_snapshot_for_instance_input::Builder,
    }
    impl GetDeployablePatchSnapshotForInstance {
        /// Creates a new `GetDeployablePatchSnapshotForInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeployablePatchSnapshotForInstanceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetDeployablePatchSnapshotForInstanceError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the managed node for which the appropriate patch snapshot should be retrieved.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the managed node for which the appropriate patch snapshot should be retrieved.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>Defines the basic information about a patch baseline override.</p>
        pub fn baseline_override(mut self, input: crate::model::BaselineOverride) -> Self {
            self.inner = self.inner.baseline_override(input);
            self
        }
        /// <p>Defines the basic information about a patch baseline override.</p>
        pub fn set_baseline_override(
            mut self,
            input: std::option::Option<crate::model::BaselineOverride>,
        ) -> Self {
            self.inner = self.inner.set_baseline_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocument`.
    ///
    /// <p>Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocument {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_document_input::Builder,
    }
    impl GetDocument {
        /// Creates a new `GetDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document and can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document and can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The document version for which you want information.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(input.into());
            self
        }
        /// <p>The document version for which you want information.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>Returns the document in the specified format. The document format can be either JSON or YAML. JSON is the default format.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.inner = self.inner.document_format(input);
            self
        }
        /// <p>Returns the document in the specified format. The document format can be either JSON or YAML. JSON is the default format.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.inner = self.inner.set_document_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInventory`.
    ///
    /// <p>Query inventory information. This includes managed node status, such as <code>Stopped</code> or <code>Terminated</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInventory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_inventory_input::Builder,
    }
    impl GetInventory {
        /// Creates a new `GetInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInventoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetInventoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetInventoryPaginator {
            crate::paginator::GetInventoryPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: crate::model::InventoryFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried fleet.</p>
        pub fn aggregators(mut self, input: crate::model::InventoryAggregator) -> Self {
            self.inner = self.inner.aggregators(input);
            self
        }
        /// <p>Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried fleet.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryAggregator>>,
        ) -> Self {
            self.inner = self.inner.set_aggregators(input);
            self
        }
        /// Appends an item to `ResultAttributes`.
        ///
        /// To override the contents of this collection use [`set_result_attributes`](Self::set_result_attributes).
        ///
        /// <p>The list of inventory item types to return.</p>
        pub fn result_attributes(mut self, input: crate::model::ResultAttribute) -> Self {
            self.inner = self.inner.result_attributes(input);
            self
        }
        /// <p>The list of inventory item types to return.</p>
        pub fn set_result_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResultAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_result_attributes(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInventorySchema`.
    ///
    /// <p>Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInventorySchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_inventory_schema_input::Builder,
    }
    impl GetInventorySchema {
        /// Creates a new `GetInventorySchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInventorySchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInventorySchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetInventorySchemaPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetInventorySchemaPaginator {
            crate::paginator::GetInventorySchemaPaginator::new(self.handle, self.inner)
        }
        /// <p>The type of inventory item to return.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The type of inventory item to return.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Returns inventory schemas that support aggregation. For example, this call returns the <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.</p>
        pub fn aggregator(mut self, input: bool) -> Self {
            self.inner = self.inner.aggregator(input);
            self
        }
        /// <p>Returns inventory schemas that support aggregation. For example, this call returns the <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.</p>
        pub fn set_aggregator(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_aggregator(input);
            self
        }
        /// <p>Returns the sub-type schema for a specified inventory type.</p>
        pub fn sub_type(mut self, input: bool) -> Self {
            self.inner = self.inner.sub_type(input);
            self
        }
        /// <p>Returns the sub-type schema for a specified inventory type.</p>
        pub fn set_sub_type(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sub_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindow`.
    ///
    /// <p>Retrieves a maintenance window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMaintenanceWindow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_maintenance_window_input::Builder,
    }
    impl GetMaintenanceWindow {
        /// Creates a new `GetMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window for which you want to retrieve information.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window for which you want to retrieve information.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowExecution`.
    ///
    /// <p>Retrieves details about a specific a maintenance window execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMaintenanceWindowExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_maintenance_window_execution_input::Builder,
    }
    impl GetMaintenanceWindowExecution {
        /// Creates a new `GetMaintenanceWindowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowExecutionTask`.
    ///
    /// <p>Retrieves the details about a specific task run as part of a maintenance window execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMaintenanceWindowExecutionTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_maintenance_window_execution_task_input::Builder,
    }
    impl GetMaintenanceWindowExecutionTask {
        /// Creates a new `GetMaintenanceWindowExecutionTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowExecutionTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowExecutionTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that should be retrieved.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that should be retrieved.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowExecutionTaskInvocation`.
    ///
    /// <p>Retrieves information about a specific task running on a specific target.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMaintenanceWindowExecutionTaskInvocation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_maintenance_window_execution_task_invocation_input::Builder,
    }
    impl GetMaintenanceWindowExecutionTaskInvocation {
        /// Creates a new `GetMaintenanceWindowExecutionTaskInvocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetMaintenanceWindowExecutionTaskInvocationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution for which the task is a part.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution for which the task is a part.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>The invocation ID to retrieve.</p>
        pub fn invocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invocation_id(input.into());
            self
        }
        /// <p>The invocation ID to retrieve.</p>
        pub fn set_invocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invocation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowTask`.
    ///
    /// <p>Lists the tasks in a maintenance window.</p> <note>
    /// <p>For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code> and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported in the response to this command. These values don't affect the running of your task and can be ignored.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMaintenanceWindowTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_maintenance_window_task_input::Builder,
    }
    impl GetMaintenanceWindowTask {
        /// Creates a new `GetMaintenanceWindowTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maintenance window ID that includes the task to retrieve.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(input.into());
            self
        }
        /// <p>The maintenance window ID that includes the task to retrieve.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The maintenance window task ID to retrieve.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_task_id(input.into());
            self
        }
        /// <p>The maintenance window task ID to retrieve.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpsItem`.
    ///
    /// <p>Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOpsItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_ops_item_input::Builder,
    }
    impl GetOpsItem {
        /// Creates a new `GetOpsItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpsItemOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpsItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OpsItem that you want to get.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(input.into());
            self
        }
        /// <p>The ID of the OpsItem that you want to get.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpsMetadata`.
    ///
    /// <p>View operational metadata related to an application in Application Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOpsMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_ops_metadata_input::Builder,
    }
    impl GetOpsMetadata {
        /// Creates a new `GetOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpsMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>
        pub fn ops_metadata_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_metadata_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_metadata_arn(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpsSummary`.
    ///
    /// <p>View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager Explorer. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOpsSummary {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_ops_summary_input::Builder,
    }
    impl GetOpsSummary {
        /// Creates a new `GetOpsSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpsSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpsSummaryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetOpsSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetOpsSummaryPaginator {
            crate::paginator::GetOpsSummaryPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify the name of a resource data sync to get.</p>
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_name(input.into());
            self
        }
        /// <p>Specify the name of a resource data sync to get.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned OpsData. </p>
        pub fn filters(mut self, input: crate::model::OpsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters used to scope down the returned OpsData. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>
        pub fn aggregators(mut self, input: crate::model::OpsAggregator) -> Self {
            self.inner = self.inner.aggregators(input);
            self
        }
        /// <p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsAggregator>>,
        ) -> Self {
            self.inner = self.inner.set_aggregators(input);
            self
        }
        /// Appends an item to `ResultAttributes`.
        ///
        /// To override the contents of this collection use [`set_result_attributes`](Self::set_result_attributes).
        ///
        /// <p>The OpsData data type to return.</p>
        pub fn result_attributes(mut self, input: crate::model::OpsResultAttribute) -> Self {
            self.inner = self.inner.result_attributes(input);
            self
        }
        /// <p>The OpsData data type to return.</p>
        pub fn set_result_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsResultAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_result_attributes(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParameter`.
    ///
    /// <p>Get information about a single parameter by specifying the parameter name.</p> <note>
    /// <p>To get information about more than one parameter at a time, use the <code>GetParameters</code> operation.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetParameter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_parameter_input::Builder,
    }
    impl GetParameter {
        /// Creates a new `GetParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParameterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter you want to query.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the parameter you want to query.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.inner = self.inner.with_decryption(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParameterHistory`.
    ///
    /// <p>Retrieves the history of all changes to a parameter.</p> <important>
    /// <p>If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key alias the parameter uses to reference KMS. Otherwise, <code>GetParameterHistory</code> retrieves whatever the original key alias was referencing.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetParameterHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_parameter_history_input::Builder,
    }
    impl GetParameterHistory {
        /// Creates a new `GetParameterHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParameterHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParameterHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetParameterHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetParameterHistoryPaginator {
            crate::paginator::GetParameterHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the parameter for which you want to review history.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the parameter for which you want to review history.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.inner = self.inner.with_decryption(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParameters`.
    ///
    /// <p>Get information about one or more parameters by specifying multiple parameter names.</p> <note>
    /// <p>To get information about a single parameter, you can use the <code>GetParameter</code> operation instead.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_parameters_input::Builder,
    }
    impl GetParameters {
        /// Creates a new `GetParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>Names of the parameters for which you want to query information.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>Names of the parameters for which you want to query information.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter version, use <code>"Name": "name:version"</code>.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.inner = self.inner.with_decryption(input);
            self
        }
        /// <p>Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParametersByPath`.
    ///
    /// <p>Retrieve information about one or more parameters in a specific hierarchy. </p>
    /// <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetParametersByPath {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_parameters_by_path_input::Builder,
    }
    impl GetParametersByPath {
        /// Creates a new `GetParametersByPath`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParametersByPathOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParametersByPathError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetParametersByPathPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetParametersByPathPaginator {
            crate::paginator::GetParametersByPathPaginator::new(self.handle, self.inner)
        }
        /// <p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. For the API call to succeed, the last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33 </code> </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(input.into());
            self
        }
        /// <p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. For the API call to succeed, the last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33 </code> </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>Retrieve all parameters within a hierarchy.</p> <important>
        /// <p>If a user has access to a path, then the user can access all levels of that path. For example, if a user has permission to access path <code>/a</code>, then the user can also access <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation recursively for <code>/a</code> and view <code>/a/b</code>.</p>
        /// </important>
        pub fn recursive(mut self, input: bool) -> Self {
            self.inner = self.inner.recursive(input);
            self
        }
        /// <p>Retrieve all parameters within a hierarchy.</p> <important>
        /// <p>If a user has access to a path, then the user can access all levels of that path. For example, if a user has permission to access path <code>/a</code>, then the user can also access <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation recursively for <code>/a</code> and view <code>/a/b</code>.</p>
        /// </important>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
        /// Appends an item to `ParameterFilters`.
        ///
        /// To override the contents of this collection use [`set_parameter_filters`](Self::set_parameter_filters).
        ///
        /// <p>Filters to limit the request results.</p> <note>
        /// <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>: <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p>
        /// <p>The following <code>Key</code> values aren't supported for <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and <code>Tier</code>.</p>
        /// </note>
        pub fn parameter_filters(mut self, input: crate::model::ParameterStringFilter) -> Self {
            self.inner = self.inner.parameter_filters(input);
            self
        }
        /// <p>Filters to limit the request results.</p> <note>
        /// <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>: <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p>
        /// <p>The following <code>Key</code> values aren't supported for <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and <code>Tier</code>.</p>
        /// </note>
        pub fn set_parameter_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_filters(input);
            self
        }
        /// <p>Retrieve all parameters in a hierarchy with their value decrypted.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.inner = self.inner.with_decryption(input);
            self
        }
        /// <p>Retrieve all parameters in a hierarchy with their value decrypted.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPatchBaseline`.
    ///
    /// <p>Retrieves information about a patch baseline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPatchBaseline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_patch_baseline_input::Builder,
    }
    impl GetPatchBaseline {
        /// Creates a new `GetPatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to retrieve.</p> <note>
        /// <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon Resource Name (ARN) of the baseline. For example, for the baseline <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of <code>pb-0e392de35e7c563b7</code>.</p>
        /// </note>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(input.into());
            self
        }
        /// <p>The ID of the patch baseline to retrieve.</p> <note>
        /// <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon Resource Name (ARN) of the baseline. For example, for the baseline <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of <code>pb-0e392de35e7c563b7</code>.</p>
        /// </note>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPatchBaselineForPatchGroup`.
    ///
    /// <p>Retrieves the patch baseline that should be used for the specified patch group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPatchBaselineForPatchGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_patch_baseline_for_patch_group_input::Builder,
    }
    impl GetPatchBaselineForPatchGroup {
        /// Creates a new `GetPatchBaselineForPatchGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPatchBaselineForPatchGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineForPatchGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the patch group whose patch baseline should be retrieved.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(input.into());
            self
        }
        /// <p>The name of the patch group whose patch baseline should be retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
        /// <p>Returns he operating system rule specified for patch groups using the patch baseline.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(input);
            self
        }
        /// <p>Returns he operating system rule specified for patch groups using the patch baseline.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceSetting`.
    ///
    /// <p> <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of <code>false</code>. This means the user can't use this feature unless they change the setting to <code>true</code> and intentionally opt in for a paid feature.</p>
    /// <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <code>UpdateServiceSetting</code> API operation to change the default setting. Or use the <code>ResetServiceSetting</code> to change the value back to the original value defined by the Amazon Web Services service team.</p>
    /// <p>Query the current service setting for the Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceSetting {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_service_setting_input::Builder,
    }
    impl GetServiceSetting {
        /// Creates a new `GetServiceSetting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceSettingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceSettingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service setting to get. The setting ID can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li>
        /// <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li>
        /// <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li>
        /// <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li>
        /// <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li>
        /// <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li>
        /// </ul>
        pub fn setting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.setting_id(input.into());
            self
        }
        /// <p>The ID of the service setting to get. The setting ID can be one of the following.</p>
        /// <ul>
        /// <li> <p> <code>/ssm/automation/customer-script-log-destination</code> </p> </li>
        /// <li> <p> <code>/ssm/automation/customer-script-log-group-name</code> </p> </li>
        /// <li> <p> <code>/ssm/documents/console/public-sharing-permission</code> </p> </li>
        /// <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li>
        /// <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li>
        /// <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li>
        /// </ul>
        pub fn set_setting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_setting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LabelParameterVersion`.
    ///
    /// <p>A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions. </p>
    /// <p>Parameter labels have the following requirements and restrictions.</p>
    /// <ul>
    /// <li> <p>A version of a parameter can have a maximum of 10 labels.</p> </li>
    /// <li> <p>You can't attach the same label to different versions of the same parameter. For example, if version 1 has the label Production, then you can't attach Production to version 2.</p> </li>
    /// <li> <p>You can move a label from one version of a parameter to another.</p> </li>
    /// <li> <p>You can't create a label when you create a new parameter. You must attach a label to a specific version of a parameter.</p> </li>
    /// <li> <p>If you no longer want to use a parameter label, then you can either delete it or move it to a different version of a parameter.</p> </li>
    /// <li> <p>A label can have a maximum of 100 characters.</p> </li>
    /// <li> <p>Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).</p> </li>
    /// <li> <p>Labels can't begin with a number, "<code>aws</code>" or "<code>ssm</code>" (not case sensitive). If a label fails to meet these requirements, then the label isn't associated with a parameter and the system displays it in the list of InvalidLabels.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct LabelParameterVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::label_parameter_version_input::Builder,
    }
    impl LabelParameterVersion {
        /// Creates a new `LabelParameterVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LabelParameterVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::LabelParameterVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The parameter name on which you want to attach one or more labels.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The parameter name on which you want to attach one or more labels.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The specific version of the parameter on which you want to attach one or more labels. If no version is specified, the system attaches the label to the latest version.</p>
        pub fn parameter_version(mut self, input: i64) -> Self {
            self.inner = self.inner.parameter_version(input);
            self
        }
        /// <p>The specific version of the parameter on which you want to attach one or more labels. If no version is specified, the system attaches the label to the latest version.</p>
        pub fn set_parameter_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_parameter_version(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>One or more labels to attach to the specified parameter version.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(input.into());
            self
        }
        /// <p>One or more labels to attach to the specified parameter version.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociations`.
    ///
    /// <p>Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results to a specific State Manager association document or managed node by specifying a filter. State Manager is a capability of Amazon Web Services Systems Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_associations_input::Builder,
    }
    impl ListAssociations {
        /// Creates a new `ListAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssociationsPaginator {
            crate::paginator::ListAssociationsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `AssociationFilterList`.
        ///
        /// To override the contents of this collection use [`set_association_filter_list`](Self::set_association_filter_list).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p> <note>
        /// <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy associations created using the <code>InstanceID</code> attribute. Associations targeting the managed node that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code> aren't returned.</p>
        /// </note>
        pub fn association_filter_list(mut self, input: crate::model::AssociationFilter) -> Self {
            self.inner = self.inner.association_filter_list(input);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p> <note>
        /// <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy associations created using the <code>InstanceID</code> attribute. Associations targeting the managed node that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code> aren't returned.</p>
        /// </note>
        pub fn set_association_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationFilter>>,
        ) -> Self {
            self.inner = self.inner.set_association_filter_list(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociationVersions`.
    ///
    /// <p>Retrieves all versions of an association for a specific association ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociationVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_association_versions_input::Builder,
    }
    impl ListAssociationVersions {
        /// Creates a new `ListAssociationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociationVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssociationVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssociationVersionsPaginator {
            crate::paginator::ListAssociationVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The association ID for which you want to view all versions.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The association ID for which you want to view all versions.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCommandInvocations`.
    ///
    /// <p>An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed nodes. A command invocation applies to one managed node. For example, if a user runs <code>SendCommand</code> against three managed nodes, then a command invocation is created for each requested managed node ID. <code>ListCommandInvocations</code> provide status about command execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCommandInvocations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_command_invocations_input::Builder,
    }
    impl ListCommandInvocations {
        /// Creates a new `ListCommandInvocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCommandInvocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCommandInvocationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCommandInvocationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCommandInvocationsPaginator {
            crate::paginator::ListCommandInvocationsPaginator::new(self.handle, self.inner)
        }
        /// <p>(Optional) The invocations for a specific command ID.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(input.into());
            self
        }
        /// <p>(Optional) The invocations for a specific command ID.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// <p>(Optional) The command execution details for a specific managed node ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>(Optional) The command execution details for a specific managed node ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: crate::model::CommandFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>(Optional) If set this returns the response of the command executions and any command output. The default value is <code>false</code>. </p>
        pub fn details(mut self, input: bool) -> Self {
            self.inner = self.inner.details(input);
            self
        }
        /// <p>(Optional) If set this returns the response of the command executions and any command output. The default value is <code>false</code>. </p>
        pub fn set_details(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCommands`.
    ///
    /// <p>Lists the commands requested by users of the Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCommands {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_commands_input::Builder,
    }
    impl ListCommands {
        /// Creates a new `ListCommands`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCommandsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCommandsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCommandsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCommandsPaginator {
            crate::paginator::ListCommandsPaginator::new(self.handle, self.inner)
        }
        /// <p>(Optional) If provided, lists only the specified command.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(input.into());
            self
        }
        /// <p>(Optional) If provided, lists only the specified command.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// <p>(Optional) Lists commands issued against this managed node ID.</p> <note>
        /// <p>You can't specify a managed node ID in the same command that you specify <code>Status</code> = <code>Pending</code>. This is because the command hasn't reached the managed node yet.</p>
        /// </note>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>(Optional) Lists commands issued against this managed node ID.</p> <note>
        /// <p>You can't specify a managed node ID in the same command that you specify <code>Status</code> = <code>Pending</code>. This is because the command hasn't reached the managed node yet.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results. </p>
        pub fn filters(mut self, input: crate::model::CommandFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComplianceItems`.
    ///
    /// <p>For a specified resource ID, this API operation returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComplianceItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_compliance_items_input::Builder,
    }
    impl ListComplianceItems {
        /// Creates a new `ListComplianceItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComplianceItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComplianceItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComplianceItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComplianceItemsPaginator {
            crate::paginator::ListComplianceItemsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more compliance filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: crate::model::ComplianceStringFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more compliance filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `ResourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The ID for the resources from which to get compliance information. Currently, you can only specify one resource ID.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(input.into());
            self
        }
        /// <p>The ID for the resources from which to get compliance information. Currently, you can only specify one resource ID.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The type of resource from which to get compliance information. Currently, the only supported resource type is <code>ManagedInstance</code>.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(input.into());
            self
        }
        /// <p>The type of resource from which to get compliance information. Currently, the only supported resource type is <code>ManagedInstance</code>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComplianceSummaries`.
    ///
    /// <p>Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria that you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComplianceSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_compliance_summaries_input::Builder,
    }
    impl ListComplianceSummaries {
        /// Creates a new `ListComplianceSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComplianceSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComplianceSummariesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComplianceSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComplianceSummariesPaginator {
            crate::paginator::ListComplianceSummariesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more compliance or inventory filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: crate::model::ComplianceStringFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more compliance or inventory filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. Currently, you can specify null or 50. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. Currently, you can specify null or 50. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentMetadataHistory`.
    ///
    /// <p>Information about approval reviews for a version of a change template in Change Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDocumentMetadataHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_document_metadata_history_input::Builder,
    }
    impl ListDocumentMetadataHistory {
        /// Creates a new `ListDocumentMetadataHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentMetadataHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentMetadataHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the change template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the change template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the change template.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(input.into());
            self
        }
        /// <p>The version of the change template.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The type of data for which details are being requested. Currently, the only supported value is <code>DocumentReviews</code>.</p>
        pub fn metadata(mut self, input: crate::model::DocumentMetadataEnum) -> Self {
            self.inner = self.inner.metadata(input);
            self
        }
        /// <p>The type of data for which details are being requested. Currently, the only supported value is <code>DocumentReviews</code>.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadataEnum>,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocuments`.
    ///
    /// <p>Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can limit the results of this request by using a filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDocuments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_documents_input::Builder,
    }
    impl ListDocuments {
        /// Creates a new `ListDocuments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDocumentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDocumentsPaginator {
            crate::paginator::ListDocumentsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `DocumentFilterList`.
        ///
        /// To override the contents of this collection use [`set_document_filter_list`](Self::set_document_filter_list).
        ///
        /// <p>This data type is deprecated. Instead, use <code>Filters</code>.</p>
        pub fn document_filter_list(mut self, input: crate::model::DocumentFilter) -> Self {
            self.inner = self.inner.document_filter_list(input);
            self
        }
        /// <p>This data type is deprecated. Instead, use <code>Filters</code>.</p>
        pub fn set_document_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentFilter>>,
        ) -> Self {
            self.inner = self.inner.set_document_filter_list(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more specific list of results. For keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p> <note>
        /// <p>This API operation only supports filtering documents by using a single tag key and one or more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code> </p>
        /// </note>
        pub fn filters(mut self, input: crate::model::DocumentKeyValuesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more specific list of results. For keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p> <note>
        /// <p>This API operation only supports filtering documents by using a single tag key and one or more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code> </p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentKeyValuesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentVersions`.
    ///
    /// <p>List all versions for a document.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDocumentVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_document_versions_input::Builder,
    }
    impl ListDocumentVersions {
        /// Creates a new `ListDocumentVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDocumentVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDocumentVersionsPaginator {
            crate::paginator::ListDocumentVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInventoryEntries`.
    ///
    /// <p>A list of inventory items returned by the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInventoryEntries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_inventory_entries_input::Builder,
    }
    impl ListInventoryEntries {
        /// Creates a new `ListInventoryEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInventoryEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInventoryEntriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The managed node ID for which you want inventory information.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The managed node ID for which you want inventory information.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of inventory item for which you want information.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The type of inventory item for which you want information.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: crate::model::InventoryFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpsItemEvents`.
    ///
    /// <p>Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can limit the results to events associated with specific OpsItems by specifying a filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOpsItemEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_ops_item_events_input::Builder,
    }
    impl ListOpsItemEvents {
        /// Creates a new `ListOpsItemEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpsItemEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpsItemEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOpsItemEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOpsItemEventsPaginator {
            crate::paginator::ListOpsItemEventsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn filters(mut self, input: crate::model::OpsItemEventFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemEventFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpsItemRelatedItems`.
    ///
    /// <p>Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a capability of Amazon Web Services Systems Manager.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOpsItemRelatedItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_ops_item_related_items_input::Builder,
    }
    impl ListOpsItemRelatedItems {
        /// Creates a new `ListOpsItemRelatedItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpsItemRelatedItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpsItemRelatedItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOpsItemRelatedItemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOpsItemRelatedItemsPaginator {
            crate::paginator::ListOpsItemRelatedItemsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the OpsItem for which you want to list all related-item resources.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(input.into());
            self
        }
        /// <p>The ID of the OpsItem for which you want to list all related-item resources.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn filters(mut self, input: crate::model::OpsItemRelatedItemsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemRelatedItemsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpsMetadata`.
    ///
    /// <p>Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or blobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOpsMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_ops_metadata_input::Builder,
    }
    impl ListOpsMetadata {
        /// Creates a new `ListOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpsMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOpsMetadataPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOpsMetadataPaginator {
            crate::paginator::ListOpsMetadataPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>
        pub fn filters(mut self, input: crate::model::OpsMetadataFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsMetadataFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceComplianceSummaries`.
    ///
    /// <p>Returns a resource-level summary count. The summary includes information about compliant and non-compliant statuses and detailed compliance-item severity counts, according to the filter criteria you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceComplianceSummaries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_compliance_summaries_input::Builder,
    }
    impl ListResourceComplianceSummaries {
        /// Creates a new `ListResourceComplianceSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceComplianceSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceComplianceSummariesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceComplianceSummariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceComplianceSummariesPaginator {
            crate::paginator::ListResourceComplianceSummariesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: crate::model::ComplianceStringFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceDataSync`.
    ///
    /// <p>Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed.</p>
    /// <p>The number of sync configurations might be too large to return using a single call to <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceDataSync {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_data_sync_input::Builder,
    }
    impl ListResourceDataSync {
        /// Creates a new `ListResourceDataSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceDataSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceDataSyncError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceDataSyncPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceDataSyncPaginator {
            crate::paginator::ListResourceDataSyncPaginator::new(self.handle, self.inner)
        }
        /// <p>View a list of resource data syncs according to the sync type. Specify <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations or from multiple Amazon Web Services Regions.</p>
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_type(input.into());
            self
        }
        /// <p>View a list of resource data syncs according to the sync type. Specify <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations or from multiple Amazon Web Services Regions.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags assigned to the specified resource.</p>
    /// <p>For information about the ID format for each supported resource type, see <code>AddTagsToResource</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns a list of tags for a specific resource type.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceTypeForTagging) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>Returns a list of tags for a specific resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceTypeForTagging>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The resource ID for which you want to see a list of tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The resource ID for which you want to see a list of tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDocumentPermission`.
    ///
    /// <p>Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document privately, you must specify the Amazon Web Services user account IDs for those people who can use the document. If you share a document publicly, you must specify <i>All</i> as the account ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyDocumentPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_document_permission_input::Builder,
    }
    impl ModifyDocumentPermission {
        /// Creates a new `ModifyDocumentPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDocumentPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDocumentPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document that you want to share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the document that you want to share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be <i>Share</i>.</p>
        pub fn permission_type(mut self, input: crate::model::DocumentPermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be <i>Share</i>.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::DocumentPermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// Appends an item to `AccountIdsToAdd`.
        ///
        /// To override the contents of this collection use [`set_account_ids_to_add`](Self::set_account_ids_to_add).
        ///
        /// <p>The Amazon Web Services user accounts that should have access to the document. The account IDs can either be a group of account IDs or <i>All</i>.</p>
        pub fn account_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids_to_add(input.into());
            self
        }
        /// <p>The Amazon Web Services user accounts that should have access to the document. The account IDs can either be a group of account IDs or <i>All</i>.</p>
        pub fn set_account_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids_to_add(input);
            self
        }
        /// Appends an item to `AccountIdsToRemove`.
        ///
        /// To override the contents of this collection use [`set_account_ids_to_remove`](Self::set_account_ids_to_remove).
        ///
        /// <p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services user account can either be a group of account IDs or <i>All</i>. This action has a higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system removes access to the document.</p>
        pub fn account_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids_to_remove(input.into());
            self
        }
        /// <p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services user account can either be a group of account IDs or <i>All</i>. This action has a higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system removes access to the document.</p>
        pub fn set_account_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids_to_remove(input);
            self
        }
        /// <p>(Optional) The version of the document to share. If it isn't specified, the system choose the <code>Default</code> version to share.</p>
        pub fn shared_document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_document_version(input.into());
            self
        }
        /// <p>(Optional) The version of the document to share. If it isn't specified, the system choose the <code>Default</code> version to share.</p>
        pub fn set_shared_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_document_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutComplianceItems`.
    ///
    /// <p>Registers a compliance type and other compliance details on a designated resource. This operation lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time that you send the request.</p>
    /// <p>ComplianceType can be one of the following:</p>
    /// <ul>
    /// <li> <p>ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.</p> </li>
    /// <li> <p>ExecutionType: Specify patch, association, or Custom:<code>string</code>.</p> </li>
    /// <li> <p>ExecutionTime. The time the patch, association, or custom compliance item was applied to the managed node.</p> </li>
    /// <li> <p>Id: The patch, association, or custom compliance ID.</p> </li>
    /// <li> <p>Title: A title.</p> </li>
    /// <li> <p>Status: The status of the compliance item. For example, <code>approved</code> for patches, or <code>Failed</code> for associations.</p> </li>
    /// <li> <p>Severity: A patch severity. For example, <code>critical</code>.</p> </li>
    /// <li> <p>DocumentName: An SSM document name. For example, <code>AWS-RunPatchBaseline</code>.</p> </li>
    /// <li> <p>DocumentVersion: An SSM document version number. For example, 4.</p> </li>
    /// <li> <p>Classification: A patch classification. For example, <code>security updates</code>.</p> </li>
    /// <li> <p>PatchBaselineId: A patch baseline ID.</p> </li>
    /// <li> <p>PatchSeverity: A patch severity. For example, <code>Critical</code>.</p> </li>
    /// <li> <p>PatchState: A patch state. For example, <code>InstancesWithFailedPatches</code>.</p> </li>
    /// <li> <p>PatchGroup: The name of a patch group.</p> </li>
    /// <li> <p>InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutComplianceItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_compliance_items_input::Builder,
    }
    impl PutComplianceItems {
        /// Creates a new `PutComplianceItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutComplianceItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutComplianceItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify an ID for this resource. For a managed node, this is the node ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Specify an ID for this resource. For a managed node, this is the node ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or Custom:<code>string</code>.</p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compliance_type(input.into());
            self
        }
        /// <p>Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or Custom:<code>string</code>.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compliance_type(input);
            self
        }
        /// <p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn execution_summary(
            mut self,
            input: crate::model::ComplianceExecutionSummary,
        ) -> Self {
            self.inner = self.inner.execution_summary(input);
            self
        }
        /// <p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn set_execution_summary(
            mut self,
            input: std::option::Option<crate::model::ComplianceExecutionSummary>,
        ) -> Self {
            self.inner = self.inner.set_execution_summary(input);
            self
        }
        /// Appends an item to `Items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Information about the compliance as defined by the resource type. For example, for a patch compliance type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.</p>
        pub fn items(mut self, input: crate::model::ComplianceItemEntry) -> Self {
            self.inner = self.inner.items(input);
            self
        }
        /// <p>Information about the compliance as defined by the resource type. For example, for a patch compliance type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceItemEntry>>,
        ) -> Self {
            self.inner = self.inner.set_items(input);
            self
        }
        /// <p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten or ignored. If the content hashes match, the request to put compliance information is ignored.</p>
        pub fn item_content_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.item_content_hash(input.into());
            self
        }
        /// <p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten or ignored. If the content hashes match, the request to put compliance information is ignored.</p>
        pub fn set_item_content_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_item_content_hash(input);
            self
        }
        /// <p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You must provide a full list of compliance items each time you send the request.</p>
        /// <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p> <note>
        /// <p>This attribute is only valid for association compliance.</p>
        /// </note>
        pub fn upload_type(mut self, input: crate::model::ComplianceUploadType) -> Self {
            self.inner = self.inner.upload_type(input);
            self
        }
        /// <p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You must provide a full list of compliance items each time you send the request.</p>
        /// <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p> <note>
        /// <p>This attribute is only valid for association compliance.</p>
        /// </note>
        pub fn set_upload_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceUploadType>,
        ) -> Self {
            self.inner = self.inner.set_upload_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInventory`.
    ///
    /// <p>Bulk update custom inventory items on one or more managed nodes. The request adds an inventory item, if it doesn't already exist, or updates an inventory item, if it does exist.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutInventory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_inventory_input::Builder,
    }
    impl PutInventory {
        /// Creates a new `PutInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInventoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An managed node ID where you want to add or update inventory items.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>An managed node ID where you want to add or update inventory items.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `Items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The inventory items that you want to add or update on managed nodes.</p>
        pub fn items(mut self, input: crate::model::InventoryItem) -> Self {
            self.inner = self.inner.items(input);
            self
        }
        /// <p>The inventory items that you want to add or update on managed nodes.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryItem>>,
        ) -> Self {
            self.inner = self.inner.set_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutParameter`.
    ///
    /// <p>Add a parameter to the system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutParameter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_parameter_input::Builder,
    }
    impl PutParameter {
        /// Creates a new `PutParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::PutParameterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name of the parameter that you want to add to the system. The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: <code>/Dev/DBServer/MySQL/db-string13</code> </p>
        /// <p>Naming Constraints:</p>
        /// <ul>
        /// <li> <p>Parameter names are case sensitive.</p> </li>
        /// <li> <p>A parameter name must be unique within an Amazon Web Services Region</p> </li>
        /// <li> <p>A parameter name can't be prefixed with "<code>aws</code>" or "<code>ssm</code>" (case-insensitive).</p> </li>
        /// <li> <p>Parameter names can include only the following symbols and letters: <code>a-zA-Z0-9_.-</code> </p> <p>In addition, the slash character ( / ) is used to delineate hierarchies in parameter names. For example: <code>/Dev/Production/East/Project-ABC/MyParameter</code> </p> </li>
        /// <li> <p>A parameter name can't include spaces.</p> </li>
        /// <li> <p>Parameter hierarchies are limited to a maximum depth of fifteen levels.</p> </li>
        /// </ul>
        /// <p>For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note>
        /// <p>The maximum length constraint listed below includes capacity for additional system attributes that aren't part of the name. The maximum length for a parameter name, including the full length of the parameter ARN, is 1011 characters. For example, the length of the following parameter name is 65 characters, not 20 characters:</p>
        /// <p> <code>arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName</code> </p>
        /// </note>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The fully qualified name of the parameter that you want to add to the system. The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: <code>/Dev/DBServer/MySQL/db-string13</code> </p>
        /// <p>Naming Constraints:</p>
        /// <ul>
        /// <li> <p>Parameter names are case sensitive.</p> </li>
        /// <li> <p>A parameter name must be unique within an Amazon Web Services Region</p> </li>
        /// <li> <p>A parameter name can't be prefixed with "<code>aws</code>" or "<code>ssm</code>" (case-insensitive).</p> </li>
        /// <li> <p>Parameter names can include only the following symbols and letters: <code>a-zA-Z0-9_.-</code> </p> <p>In addition, the slash character ( / ) is used to delineate hierarchies in parameter names. For example: <code>/Dev/Production/East/Project-ABC/MyParameter</code> </p> </li>
        /// <li> <p>A parameter name can't include spaces.</p> </li>
        /// <li> <p>Parameter hierarchies are limited to a maximum depth of fifteen levels.</p> </li>
        /// </ul>
        /// <p>For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note>
        /// <p>The maximum length constraint listed below includes capacity for additional system attributes that aren't part of the name. The maximum length for a parameter name, including the full length of the parameter ARN, is 1011 characters. For example, the length of the following parameter name is 65 characters, not 20 characters:</p>
        /// <p> <code>arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName</code> </p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Information about the parameter that you want to add to the system. Optional but recommended.</p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Information about the parameter that you want to add to the system. Optional but recommended.</p> <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.</p> <note>
        /// <p>Parameters can't be referenced or nested in the values of other parameters. You can't include <code>{{}}</code> or <code>{{ssm:<i>parameter-name</i>}}</code> in a parameter value.</p>
        /// </note>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.</p> <note>
        /// <p>Parameters can't be referenced or nested in the values of other parameters. You can't include <code>{{}}</code> or <code>{{ssm:<i>parameter-name</i>}}</code> in a parameter value.</p>
        /// </note>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// <p>The type of parameter that you want to add to the system.</p> <note>
        /// <p> <code>SecureString</code> isn't currently supported for CloudFormation templates.</p>
        /// </note>
        /// <p>Items in a <code>StringList</code> must be separated by a comma (,). You can't use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the <code>String</code> data type.</p> <important>
        /// <p>Specifying a parameter type isn't required when updating a parameter. You must specify a parameter type when creating a parameter.</p>
        /// </important>
        pub fn r#type(mut self, input: crate::model::ParameterType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of parameter that you want to add to the system.</p> <note>
        /// <p> <code>SecureString</code> isn't currently supported for CloudFormation templates.</p>
        /// </note>
        /// <p>Items in a <code>StringList</code> must be separated by a comma (,). You can't use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the <code>String</code> data type.</p> <important>
        /// <p>Specifying a parameter type isn't required when updating a parameter. You must specify a parameter type when creating a parameter.</p>
        /// </important>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ParameterType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Key Management Service (KMS) ID that you want to use to encrypt a parameter. Either the default KMS key automatically assigned to your Amazon Web Services account or a custom key. Required for parameters that use the <code>SecureString</code> data type.</p>
        /// <p>If you don't specify a key ID, the system uses the default key associated with your Amazon Web Services account.</p>
        /// <ul>
        /// <li> <p>To use your default KMS key, choose the <code>SecureString</code> data type, and do <i>not</i> specify the <code>Key ID</code> when you create the parameter. The system automatically populates <code>Key ID</code> with your default KMS key.</p> </li>
        /// <li> <p>To use a custom KMS key, choose the <code>SecureString</code> data type with the <code>Key ID</code> parameter.</p> </li>
        /// </ul>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) ID that you want to use to encrypt a parameter. Either the default KMS key automatically assigned to your Amazon Web Services account or a custom key. Required for parameters that use the <code>SecureString</code> data type.</p>
        /// <p>If you don't specify a key ID, the system uses the default key associated with your Amazon Web Services account.</p>
        /// <ul>
        /// <li> <p>To use your default KMS key, choose the <code>SecureString</code> data type, and do <i>not</i> specify the <code>Key ID</code> when you create the parameter. The system automatically populates <code>Key ID</code> with your default KMS key.</p> </li>
        /// <li> <p>To use a custom KMS key, choose the <code>SecureString</code> data type with the <code>Key ID</code> parameter.</p> </li>
        /// </ul>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Overwrite an existing parameter. The default value is <code>false</code>.</p>
