// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_resource`](crate::client::Client::add_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToResource {
    _private: (),
}
impl AddTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToResource {
    type Output = std::result::Result<
        crate::output::AddTagsToResourceOutput,
        crate::error::AddTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `AssociateOpsItemRelatedItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_ops_item_related_item`](crate::client::Client::associate_ops_item_related_item).
///
/// See [`crate::client::fluent_builders::AssociateOpsItemRelatedItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateOpsItemRelatedItem {
    _private: (),
}
impl AssociateOpsItemRelatedItem {
    /// Creates a new builder-style object to manufacture [`AssociateOpsItemRelatedItemInput`](crate::input::AssociateOpsItemRelatedItemInput)
    pub fn builder() -> crate::input::associate_ops_item_related_item_input::Builder {
        crate::input::associate_ops_item_related_item_input::Builder::default()
    }
    /// Creates a new `AssociateOpsItemRelatedItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateOpsItemRelatedItem {
    type Output = std::result::Result<
        crate::output::AssociateOpsItemRelatedItemOutput,
        crate::error::AssociateOpsItemRelatedItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_ops_item_related_item_error(response)
        } else {
            crate::operation_deser::parse_associate_ops_item_related_item_response(response)
        }
    }
}

/// Operation shape for `CancelCommand`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_command`](crate::client::Client::cancel_command).
///
/// See [`crate::client::fluent_builders::CancelCommand`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelCommand {
    _private: (),
}
impl CancelCommand {
    /// Creates a new builder-style object to manufacture [`CancelCommandInput`](crate::input::CancelCommandInput)
    pub fn builder() -> crate::input::cancel_command_input::Builder {
        crate::input::cancel_command_input::Builder::default()
    }
    /// Creates a new `CancelCommand` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelCommand {
    type Output =
        std::result::Result<crate::output::CancelCommandOutput, crate::error::CancelCommandError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_command_error(response)
        } else {
            crate::operation_deser::parse_cancel_command_response(response)
        }
    }
}

/// Operation shape for `CancelMaintenanceWindowExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_maintenance_window_execution`](crate::client::Client::cancel_maintenance_window_execution).
///
/// See [`crate::client::fluent_builders::CancelMaintenanceWindowExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelMaintenanceWindowExecution {
    _private: (),
}
impl CancelMaintenanceWindowExecution {
    /// Creates a new builder-style object to manufacture [`CancelMaintenanceWindowExecutionInput`](crate::input::CancelMaintenanceWindowExecutionInput)
    pub fn builder() -> crate::input::cancel_maintenance_window_execution_input::Builder {
        crate::input::cancel_maintenance_window_execution_input::Builder::default()
    }
    /// Creates a new `CancelMaintenanceWindowExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelMaintenanceWindowExecution {
    type Output = std::result::Result<
        crate::output::CancelMaintenanceWindowExecutionOutput,
        crate::error::CancelMaintenanceWindowExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_maintenance_window_execution_error(response)
        } else {
            crate::operation_deser::parse_cancel_maintenance_window_execution_response(response)
        }
    }
}

/// Operation shape for `CreateActivation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_activation`](crate::client::Client::create_activation).
///
/// See [`crate::client::fluent_builders::CreateActivation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateActivation {
    _private: (),
}
impl CreateActivation {
    /// Creates a new builder-style object to manufacture [`CreateActivationInput`](crate::input::CreateActivationInput)
    pub fn builder() -> crate::input::create_activation_input::Builder {
        crate::input::create_activation_input::Builder::default()
    }
    /// Creates a new `CreateActivation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateActivation {
    type Output = std::result::Result<
        crate::output::CreateActivationOutput,
        crate::error::CreateActivationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_activation_error(response)
        } else {
            crate::operation_deser::parse_create_activation_response(response)
        }
    }
}

/// Operation shape for `CreateAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_association`](crate::client::Client::create_association).
///
/// See [`crate::client::fluent_builders::CreateAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssociation {
    _private: (),
}
impl CreateAssociation {
    /// Creates a new builder-style object to manufacture [`CreateAssociationInput`](crate::input::CreateAssociationInput)
    pub fn builder() -> crate::input::create_association_input::Builder {
        crate::input::create_association_input::Builder::default()
    }
    /// Creates a new `CreateAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssociation {
    type Output = std::result::Result<
        crate::output::CreateAssociationOutput,
        crate::error::CreateAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_association_error(response)
        } else {
            crate::operation_deser::parse_create_association_response(response)
        }
    }
}

/// Operation shape for `CreateAssociationBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_association_batch`](crate::client::Client::create_association_batch).
///
/// See [`crate::client::fluent_builders::CreateAssociationBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssociationBatch {
    _private: (),
}
impl CreateAssociationBatch {
    /// Creates a new builder-style object to manufacture [`CreateAssociationBatchInput`](crate::input::CreateAssociationBatchInput)
    pub fn builder() -> crate::input::create_association_batch_input::Builder {
        crate::input::create_association_batch_input::Builder::default()
    }
    /// Creates a new `CreateAssociationBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssociationBatch {
    type Output = std::result::Result<
        crate::output::CreateAssociationBatchOutput,
        crate::error::CreateAssociationBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_association_batch_error(response)
        } else {
            crate::operation_deser::parse_create_association_batch_response(response)
        }
    }
}

/// Operation shape for `CreateDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_document`](crate::client::Client::create_document).
///
/// See [`crate::client::fluent_builders::CreateDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDocument {
    _private: (),
}
impl CreateDocument {
    /// Creates a new builder-style object to manufacture [`CreateDocumentInput`](crate::input::CreateDocumentInput)
    pub fn builder() -> crate::input::create_document_input::Builder {
        crate::input::create_document_input::Builder::default()
    }
    /// Creates a new `CreateDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDocument {
    type Output =
        std::result::Result<crate::output::CreateDocumentOutput, crate::error::CreateDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_document_error(response)
        } else {
            crate::operation_deser::parse_create_document_response(response)
        }
    }
}

/// Operation shape for `CreateMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_maintenance_window`](crate::client::Client::create_maintenance_window).
///
/// See [`crate::client::fluent_builders::CreateMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMaintenanceWindow {
    _private: (),
}
impl CreateMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`CreateMaintenanceWindowInput`](crate::input::CreateMaintenanceWindowInput)
    pub fn builder() -> crate::input::create_maintenance_window_input::Builder {
        crate::input::create_maintenance_window_input::Builder::default()
    }
    /// Creates a new `CreateMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::CreateMaintenanceWindowOutput,
        crate::error::CreateMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_create_maintenance_window_response(response)
        }
    }
}

/// Operation shape for `CreateOpsItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ops_item`](crate::client::Client::create_ops_item).
///
/// See [`crate::client::fluent_builders::CreateOpsItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOpsItem {
    _private: (),
}
impl CreateOpsItem {
    /// Creates a new builder-style object to manufacture [`CreateOpsItemInput`](crate::input::CreateOpsItemInput)
    pub fn builder() -> crate::input::create_ops_item_input::Builder {
        crate::input::create_ops_item_input::Builder::default()
    }
    /// Creates a new `CreateOpsItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOpsItem {
    type Output =
        std::result::Result<crate::output::CreateOpsItemOutput, crate::error::CreateOpsItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ops_item_error(response)
        } else {
            crate::operation_deser::parse_create_ops_item_response(response)
        }
    }
}

/// Operation shape for `CreateOpsMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ops_metadata`](crate::client::Client::create_ops_metadata).
///
/// See [`crate::client::fluent_builders::CreateOpsMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateOpsMetadata {
    _private: (),
}
impl CreateOpsMetadata {
    /// Creates a new builder-style object to manufacture [`CreateOpsMetadataInput`](crate::input::CreateOpsMetadataInput)
    pub fn builder() -> crate::input::create_ops_metadata_input::Builder {
        crate::input::create_ops_metadata_input::Builder::default()
    }
    /// Creates a new `CreateOpsMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateOpsMetadata {
    type Output = std::result::Result<
        crate::output::CreateOpsMetadataOutput,
        crate::error::CreateOpsMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ops_metadata_error(response)
        } else {
            crate::operation_deser::parse_create_ops_metadata_response(response)
        }
    }
}

/// Operation shape for `CreatePatchBaseline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_patch_baseline`](crate::client::Client::create_patch_baseline).
///
/// See [`crate::client::fluent_builders::CreatePatchBaseline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePatchBaseline {
    _private: (),
}
impl CreatePatchBaseline {
    /// Creates a new builder-style object to manufacture [`CreatePatchBaselineInput`](crate::input::CreatePatchBaselineInput)
    pub fn builder() -> crate::input::create_patch_baseline_input::Builder {
        crate::input::create_patch_baseline_input::Builder::default()
    }
    /// Creates a new `CreatePatchBaseline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePatchBaseline {
    type Output = std::result::Result<
        crate::output::CreatePatchBaselineOutput,
        crate::error::CreatePatchBaselineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_patch_baseline_error(response)
        } else {
            crate::operation_deser::parse_create_patch_baseline_response(response)
        }
    }
}

/// Operation shape for `CreateResourceDataSync`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_data_sync`](crate::client::Client::create_resource_data_sync).
///
/// See [`crate::client::fluent_builders::CreateResourceDataSync`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourceDataSync {
    _private: (),
}
impl CreateResourceDataSync {
    /// Creates a new builder-style object to manufacture [`CreateResourceDataSyncInput`](crate::input::CreateResourceDataSyncInput)
    pub fn builder() -> crate::input::create_resource_data_sync_input::Builder {
        crate::input::create_resource_data_sync_input::Builder::default()
    }
    /// Creates a new `CreateResourceDataSync` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourceDataSync {
    type Output = std::result::Result<
        crate::output::CreateResourceDataSyncOutput,
        crate::error::CreateResourceDataSyncError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_data_sync_error(response)
        } else {
            crate::operation_deser::parse_create_resource_data_sync_response(response)
        }
    }
}

/// Operation shape for `DeleteActivation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_activation`](crate::client::Client::delete_activation).
///
/// See [`crate::client::fluent_builders::DeleteActivation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteActivation {
    _private: (),
}
impl DeleteActivation {
    /// Creates a new builder-style object to manufacture [`DeleteActivationInput`](crate::input::DeleteActivationInput)
    pub fn builder() -> crate::input::delete_activation_input::Builder {
        crate::input::delete_activation_input::Builder::default()
    }
    /// Creates a new `DeleteActivation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteActivation {
    type Output = std::result::Result<
        crate::output::DeleteActivationOutput,
        crate::error::DeleteActivationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_activation_error(response)
        } else {
            crate::operation_deser::parse_delete_activation_response(response)
        }
    }
}

/// Operation shape for `DeleteAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_association`](crate::client::Client::delete_association).
///
/// See [`crate::client::fluent_builders::DeleteAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssociation {
    _private: (),
}
impl DeleteAssociation {
    /// Creates a new builder-style object to manufacture [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
    pub fn builder() -> crate::input::delete_association_input::Builder {
        crate::input::delete_association_input::Builder::default()
    }
    /// Creates a new `DeleteAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssociation {
    type Output = std::result::Result<
        crate::output::DeleteAssociationOutput,
        crate::error::DeleteAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_association_error(response)
        } else {
            crate::operation_deser::parse_delete_association_response(response)
        }
    }
}

/// Operation shape for `DeleteDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_document`](crate::client::Client::delete_document).
///
/// See [`crate::client::fluent_builders::DeleteDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDocument {
    _private: (),
}
impl DeleteDocument {
    /// Creates a new builder-style object to manufacture [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    pub fn builder() -> crate::input::delete_document_input::Builder {
        crate::input::delete_document_input::Builder::default()
    }
    /// Creates a new `DeleteDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDocument {
    type Output =
        std::result::Result<crate::output::DeleteDocumentOutput, crate::error::DeleteDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_document_error(response)
        } else {
            crate::operation_deser::parse_delete_document_response(response)
        }
    }
}

/// Operation shape for `DeleteInventory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_inventory`](crate::client::Client::delete_inventory).
///
/// See [`crate::client::fluent_builders::DeleteInventory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInventory {
    _private: (),
}
impl DeleteInventory {
    /// Creates a new builder-style object to manufacture [`DeleteInventoryInput`](crate::input::DeleteInventoryInput)
    pub fn builder() -> crate::input::delete_inventory_input::Builder {
        crate::input::delete_inventory_input::Builder::default()
    }
    /// Creates a new `DeleteInventory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInventory {
    type Output = std::result::Result<
        crate::output::DeleteInventoryOutput,
        crate::error::DeleteInventoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_inventory_error(response)
        } else {
            crate::operation_deser::parse_delete_inventory_response(response)
        }
    }
}

/// Operation shape for `DeleteMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_maintenance_window`](crate::client::Client::delete_maintenance_window).
///
/// See [`crate::client::fluent_builders::DeleteMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMaintenanceWindow {
    _private: (),
}
impl DeleteMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`DeleteMaintenanceWindowInput`](crate::input::DeleteMaintenanceWindowInput)
    pub fn builder() -> crate::input::delete_maintenance_window_input::Builder {
        crate::input::delete_maintenance_window_input::Builder::default()
    }
    /// Creates a new `DeleteMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::DeleteMaintenanceWindowOutput,
        crate::error::DeleteMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_delete_maintenance_window_response(response)
        }
    }
}

/// Operation shape for `DeleteOpsMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ops_metadata`](crate::client::Client::delete_ops_metadata).
///
/// See [`crate::client::fluent_builders::DeleteOpsMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteOpsMetadata {
    _private: (),
}
impl DeleteOpsMetadata {
    /// Creates a new builder-style object to manufacture [`DeleteOpsMetadataInput`](crate::input::DeleteOpsMetadataInput)
    pub fn builder() -> crate::input::delete_ops_metadata_input::Builder {
        crate::input::delete_ops_metadata_input::Builder::default()
    }
    /// Creates a new `DeleteOpsMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteOpsMetadata {
    type Output = std::result::Result<
        crate::output::DeleteOpsMetadataOutput,
        crate::error::DeleteOpsMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ops_metadata_error(response)
        } else {
            crate::operation_deser::parse_delete_ops_metadata_response(response)
        }
    }
}

/// Operation shape for `DeleteParameter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_parameter`](crate::client::Client::delete_parameter).
///
/// See [`crate::client::fluent_builders::DeleteParameter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteParameter {
    _private: (),
}
impl DeleteParameter {
    /// Creates a new builder-style object to manufacture [`DeleteParameterInput`](crate::input::DeleteParameterInput)
    pub fn builder() -> crate::input::delete_parameter_input::Builder {
        crate::input::delete_parameter_input::Builder::default()
    }
    /// Creates a new `DeleteParameter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteParameter {
    type Output = std::result::Result<
        crate::output::DeleteParameterOutput,
        crate::error::DeleteParameterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_parameter_error(response)
        } else {
            crate::operation_deser::parse_delete_parameter_response(response)
        }
    }
}

/// Operation shape for `DeleteParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_parameters`](crate::client::Client::delete_parameters).
///
/// See [`crate::client::fluent_builders::DeleteParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteParameters {
    _private: (),
}
impl DeleteParameters {
    /// Creates a new builder-style object to manufacture [`DeleteParametersInput`](crate::input::DeleteParametersInput)
    pub fn builder() -> crate::input::delete_parameters_input::Builder {
        crate::input::delete_parameters_input::Builder::default()
    }
    /// Creates a new `DeleteParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteParameters {
    type Output = std::result::Result<
        crate::output::DeleteParametersOutput,
        crate::error::DeleteParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_parameters_error(response)
        } else {
            crate::operation_deser::parse_delete_parameters_response(response)
        }
    }
}

/// Operation shape for `DeletePatchBaseline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_patch_baseline`](crate::client::Client::delete_patch_baseline).
///
/// See [`crate::client::fluent_builders::DeletePatchBaseline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePatchBaseline {
    _private: (),
}
impl DeletePatchBaseline {
    /// Creates a new builder-style object to manufacture [`DeletePatchBaselineInput`](crate::input::DeletePatchBaselineInput)
    pub fn builder() -> crate::input::delete_patch_baseline_input::Builder {
        crate::input::delete_patch_baseline_input::Builder::default()
    }
    /// Creates a new `DeletePatchBaseline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePatchBaseline {
    type Output = std::result::Result<
        crate::output::DeletePatchBaselineOutput,
        crate::error::DeletePatchBaselineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_patch_baseline_error(response)
        } else {
            crate::operation_deser::parse_delete_patch_baseline_response(response)
        }
    }
}

/// Operation shape for `DeleteResourceDataSync`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_data_sync`](crate::client::Client::delete_resource_data_sync).
///
/// See [`crate::client::fluent_builders::DeleteResourceDataSync`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourceDataSync {
    _private: (),
}
impl DeleteResourceDataSync {
    /// Creates a new builder-style object to manufacture [`DeleteResourceDataSyncInput`](crate::input::DeleteResourceDataSyncInput)
    pub fn builder() -> crate::input::delete_resource_data_sync_input::Builder {
        crate::input::delete_resource_data_sync_input::Builder::default()
    }
    /// Creates a new `DeleteResourceDataSync` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourceDataSync {
    type Output = std::result::Result<
        crate::output::DeleteResourceDataSyncOutput,
        crate::error::DeleteResourceDataSyncError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_data_sync_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_data_sync_response(response)
        }
    }
}

/// Operation shape for `DeregisterManagedInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_managed_instance`](crate::client::Client::deregister_managed_instance).
///
/// See [`crate::client::fluent_builders::DeregisterManagedInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterManagedInstance {
    _private: (),
}
impl DeregisterManagedInstance {
    /// Creates a new builder-style object to manufacture [`DeregisterManagedInstanceInput`](crate::input::DeregisterManagedInstanceInput)
    pub fn builder() -> crate::input::deregister_managed_instance_input::Builder {
        crate::input::deregister_managed_instance_input::Builder::default()
    }
    /// Creates a new `DeregisterManagedInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterManagedInstance {
    type Output = std::result::Result<
        crate::output::DeregisterManagedInstanceOutput,
        crate::error::DeregisterManagedInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_managed_instance_error(response)
        } else {
            crate::operation_deser::parse_deregister_managed_instance_response(response)
        }
    }
}

/// Operation shape for `DeregisterPatchBaselineForPatchGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_patch_baseline_for_patch_group`](crate::client::Client::deregister_patch_baseline_for_patch_group).
///
/// See [`crate::client::fluent_builders::DeregisterPatchBaselineForPatchGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterPatchBaselineForPatchGroup {
    _private: (),
}
impl DeregisterPatchBaselineForPatchGroup {
    /// Creates a new builder-style object to manufacture [`DeregisterPatchBaselineForPatchGroupInput`](crate::input::DeregisterPatchBaselineForPatchGroupInput)
    pub fn builder() -> crate::input::deregister_patch_baseline_for_patch_group_input::Builder {
        crate::input::deregister_patch_baseline_for_patch_group_input::Builder::default()
    }
    /// Creates a new `DeregisterPatchBaselineForPatchGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterPatchBaselineForPatchGroup {
    type Output = std::result::Result<
        crate::output::DeregisterPatchBaselineForPatchGroupOutput,
        crate::error::DeregisterPatchBaselineForPatchGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_patch_baseline_for_patch_group_error(response)
        } else {
            crate::operation_deser::parse_deregister_patch_baseline_for_patch_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeregisterTargetFromMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_target_from_maintenance_window`](crate::client::Client::deregister_target_from_maintenance_window).
///
/// See [`crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTargetFromMaintenanceWindow {
    _private: (),
}
impl DeregisterTargetFromMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`DeregisterTargetFromMaintenanceWindowInput`](crate::input::DeregisterTargetFromMaintenanceWindowInput)
    pub fn builder() -> crate::input::deregister_target_from_maintenance_window_input::Builder {
        crate::input::deregister_target_from_maintenance_window_input::Builder::default()
    }
    /// Creates a new `DeregisterTargetFromMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterTargetFromMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::DeregisterTargetFromMaintenanceWindowOutput,
        crate::error::DeregisterTargetFromMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_target_from_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_deregister_target_from_maintenance_window_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeregisterTaskFromMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_task_from_maintenance_window`](crate::client::Client::deregister_task_from_maintenance_window).
///
/// See [`crate::client::fluent_builders::DeregisterTaskFromMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTaskFromMaintenanceWindow {
    _private: (),
}
impl DeregisterTaskFromMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`DeregisterTaskFromMaintenanceWindowInput`](crate::input::DeregisterTaskFromMaintenanceWindowInput)
    pub fn builder() -> crate::input::deregister_task_from_maintenance_window_input::Builder {
        crate::input::deregister_task_from_maintenance_window_input::Builder::default()
    }
    /// Creates a new `DeregisterTaskFromMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterTaskFromMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::DeregisterTaskFromMaintenanceWindowOutput,
        crate::error::DeregisterTaskFromMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_task_from_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_deregister_task_from_maintenance_window_response(response)
        }
    }
}

/// Operation shape for `DescribeActivations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_activations`](crate::client::Client::describe_activations).
///
/// See [`crate::client::fluent_builders::DescribeActivations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeActivations {
    _private: (),
}
impl DescribeActivations {
    /// Creates a new builder-style object to manufacture [`DescribeActivationsInput`](crate::input::DescribeActivationsInput)
    pub fn builder() -> crate::input::describe_activations_input::Builder {
        crate::input::describe_activations_input::Builder::default()
    }
    /// Creates a new `DescribeActivations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeActivations {
    type Output = std::result::Result<
        crate::output::DescribeActivationsOutput,
        crate::error::DescribeActivationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_activations_error(response)
        } else {
            crate::operation_deser::parse_describe_activations_response(response)
        }
    }
}

/// Operation shape for `DescribeAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_association`](crate::client::Client::describe_association).
///
/// See [`crate::client::fluent_builders::DescribeAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssociation {
    _private: (),
}
impl DescribeAssociation {
    /// Creates a new builder-style object to manufacture [`DescribeAssociationInput`](crate::input::DescribeAssociationInput)
    pub fn builder() -> crate::input::describe_association_input::Builder {
        crate::input::describe_association_input::Builder::default()
    }
    /// Creates a new `DescribeAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssociation {
    type Output = std::result::Result<
        crate::output::DescribeAssociationOutput,
        crate::error::DescribeAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_association_error(response)
        } else {
            crate::operation_deser::parse_describe_association_response(response)
        }
    }
}

/// Operation shape for `DescribeAssociationExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_association_executions`](crate::client::Client::describe_association_executions).
///
/// See [`crate::client::fluent_builders::DescribeAssociationExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssociationExecutions {
    _private: (),
}
impl DescribeAssociationExecutions {
    /// Creates a new builder-style object to manufacture [`DescribeAssociationExecutionsInput`](crate::input::DescribeAssociationExecutionsInput)
    pub fn builder() -> crate::input::describe_association_executions_input::Builder {
        crate::input::describe_association_executions_input::Builder::default()
    }
    /// Creates a new `DescribeAssociationExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssociationExecutions {
    type Output = std::result::Result<
        crate::output::DescribeAssociationExecutionsOutput,
        crate::error::DescribeAssociationExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_association_executions_error(response)
        } else {
            crate::operation_deser::parse_describe_association_executions_response(response)
        }
    }
}

/// Operation shape for `DescribeAssociationExecutionTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_association_execution_targets`](crate::client::Client::describe_association_execution_targets).
///
/// See [`crate::client::fluent_builders::DescribeAssociationExecutionTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAssociationExecutionTargets {
    _private: (),
}
impl DescribeAssociationExecutionTargets {
    /// Creates a new builder-style object to manufacture [`DescribeAssociationExecutionTargetsInput`](crate::input::DescribeAssociationExecutionTargetsInput)
    pub fn builder() -> crate::input::describe_association_execution_targets_input::Builder {
        crate::input::describe_association_execution_targets_input::Builder::default()
    }
    /// Creates a new `DescribeAssociationExecutionTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAssociationExecutionTargets {
    type Output = std::result::Result<
        crate::output::DescribeAssociationExecutionTargetsOutput,
        crate::error::DescribeAssociationExecutionTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_association_execution_targets_error(response)
        } else {
            crate::operation_deser::parse_describe_association_execution_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeAutomationExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_automation_executions`](crate::client::Client::describe_automation_executions).
///
/// See [`crate::client::fluent_builders::DescribeAutomationExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutomationExecutions {
    _private: (),
}
impl DescribeAutomationExecutions {
    /// Creates a new builder-style object to manufacture [`DescribeAutomationExecutionsInput`](crate::input::DescribeAutomationExecutionsInput)
    pub fn builder() -> crate::input::describe_automation_executions_input::Builder {
        crate::input::describe_automation_executions_input::Builder::default()
    }
    /// Creates a new `DescribeAutomationExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutomationExecutions {
    type Output = std::result::Result<
        crate::output::DescribeAutomationExecutionsOutput,
        crate::error::DescribeAutomationExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_automation_executions_error(response)
        } else {
            crate::operation_deser::parse_describe_automation_executions_response(response)
        }
    }
}

/// Operation shape for `DescribeAutomationStepExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_automation_step_executions`](crate::client::Client::describe_automation_step_executions).
///
/// See [`crate::client::fluent_builders::DescribeAutomationStepExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutomationStepExecutions {
    _private: (),
}
impl DescribeAutomationStepExecutions {
    /// Creates a new builder-style object to manufacture [`DescribeAutomationStepExecutionsInput`](crate::input::DescribeAutomationStepExecutionsInput)
    pub fn builder() -> crate::input::describe_automation_step_executions_input::Builder {
        crate::input::describe_automation_step_executions_input::Builder::default()
    }
    /// Creates a new `DescribeAutomationStepExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutomationStepExecutions {
    type Output = std::result::Result<
        crate::output::DescribeAutomationStepExecutionsOutput,
        crate::error::DescribeAutomationStepExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_automation_step_executions_error(response)
        } else {
            crate::operation_deser::parse_describe_automation_step_executions_response(response)
        }
    }
}

/// Operation shape for `DescribeAvailablePatches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_available_patches`](crate::client::Client::describe_available_patches).
///
/// See [`crate::client::fluent_builders::DescribeAvailablePatches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAvailablePatches {
    _private: (),
}
impl DescribeAvailablePatches {
    /// Creates a new builder-style object to manufacture [`DescribeAvailablePatchesInput`](crate::input::DescribeAvailablePatchesInput)
    pub fn builder() -> crate::input::describe_available_patches_input::Builder {
        crate::input::describe_available_patches_input::Builder::default()
    }
    /// Creates a new `DescribeAvailablePatches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAvailablePatches {
    type Output = std::result::Result<
        crate::output::DescribeAvailablePatchesOutput,
        crate::error::DescribeAvailablePatchesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_available_patches_error(response)
        } else {
            crate::operation_deser::parse_describe_available_patches_response(response)
        }
    }
}

/// Operation shape for `DescribeDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_document`](crate::client::Client::describe_document).
///
/// See [`crate::client::fluent_builders::DescribeDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDocument {
    _private: (),
}
impl DescribeDocument {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentInput`](crate::input::DescribeDocumentInput)
    pub fn builder() -> crate::input::describe_document_input::Builder {
        crate::input::describe_document_input::Builder::default()
    }
    /// Creates a new `DescribeDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDocument {
    type Output = std::result::Result<
        crate::output::DescribeDocumentOutput,
        crate::error::DescribeDocumentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_document_error(response)
        } else {
            crate::operation_deser::parse_describe_document_response(response)
        }
    }
}

/// Operation shape for `DescribeDocumentPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_document_permission`](crate::client::Client::describe_document_permission).
///
/// See [`crate::client::fluent_builders::DescribeDocumentPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDocumentPermission {
    _private: (),
}
impl DescribeDocumentPermission {
    /// Creates a new builder-style object to manufacture [`DescribeDocumentPermissionInput`](crate::input::DescribeDocumentPermissionInput)
    pub fn builder() -> crate::input::describe_document_permission_input::Builder {
        crate::input::describe_document_permission_input::Builder::default()
    }
    /// Creates a new `DescribeDocumentPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDocumentPermission {
    type Output = std::result::Result<
        crate::output::DescribeDocumentPermissionOutput,
        crate::error::DescribeDocumentPermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_document_permission_error(response)
        } else {
            crate::operation_deser::parse_describe_document_permission_response(response)
        }
    }
}

/// Operation shape for `DescribeEffectiveInstanceAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_effective_instance_associations`](crate::client::Client::describe_effective_instance_associations).
///
/// See [`crate::client::fluent_builders::DescribeEffectiveInstanceAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEffectiveInstanceAssociations {
    _private: (),
}
impl DescribeEffectiveInstanceAssociations {
    /// Creates a new builder-style object to manufacture [`DescribeEffectiveInstanceAssociationsInput`](crate::input::DescribeEffectiveInstanceAssociationsInput)
    pub fn builder() -> crate::input::describe_effective_instance_associations_input::Builder {
        crate::input::describe_effective_instance_associations_input::Builder::default()
    }
    /// Creates a new `DescribeEffectiveInstanceAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEffectiveInstanceAssociations {
    type Output = std::result::Result<
        crate::output::DescribeEffectiveInstanceAssociationsOutput,
        crate::error::DescribeEffectiveInstanceAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_effective_instance_associations_error(response)
        } else {
            crate::operation_deser::parse_describe_effective_instance_associations_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeEffectivePatchesForPatchBaseline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_effective_patches_for_patch_baseline`](crate::client::Client::describe_effective_patches_for_patch_baseline).
///
/// See [`crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEffectivePatchesForPatchBaseline {
    _private: (),
}
impl DescribeEffectivePatchesForPatchBaseline {
    /// Creates a new builder-style object to manufacture [`DescribeEffectivePatchesForPatchBaselineInput`](crate::input::DescribeEffectivePatchesForPatchBaselineInput)
    pub fn builder() -> crate::input::describe_effective_patches_for_patch_baseline_input::Builder {
        crate::input::describe_effective_patches_for_patch_baseline_input::Builder::default()
    }
    /// Creates a new `DescribeEffectivePatchesForPatchBaseline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEffectivePatchesForPatchBaseline {
    type Output = std::result::Result<
        crate::output::DescribeEffectivePatchesForPatchBaselineOutput,
        crate::error::DescribeEffectivePatchesForPatchBaselineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_effective_patches_for_patch_baseline_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_effective_patches_for_patch_baseline_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeInstanceAssociationsStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_associations_status`](crate::client::Client::describe_instance_associations_status).
///
/// See [`crate::client::fluent_builders::DescribeInstanceAssociationsStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceAssociationsStatus {
    _private: (),
}
impl DescribeInstanceAssociationsStatus {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAssociationsStatusInput`](crate::input::DescribeInstanceAssociationsStatusInput)
    pub fn builder() -> crate::input::describe_instance_associations_status_input::Builder {
        crate::input::describe_instance_associations_status_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceAssociationsStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceAssociationsStatus {
    type Output = std::result::Result<
        crate::output::DescribeInstanceAssociationsStatusOutput,
        crate::error::DescribeInstanceAssociationsStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_associations_status_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_associations_status_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceInformation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_information`](crate::client::Client::describe_instance_information).
///
/// See [`crate::client::fluent_builders::DescribeInstanceInformation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceInformation {
    _private: (),
}
impl DescribeInstanceInformation {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceInformationInput`](crate::input::DescribeInstanceInformationInput)
    pub fn builder() -> crate::input::describe_instance_information_input::Builder {
        crate::input::describe_instance_information_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceInformation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceInformation {
    type Output = std::result::Result<
        crate::output::DescribeInstanceInformationOutput,
        crate::error::DescribeInstanceInformationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_information_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_information_response(response)
        }
    }
}

/// Operation shape for `DescribeInstancePatches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_patches`](crate::client::Client::describe_instance_patches).
///
/// See [`crate::client::fluent_builders::DescribeInstancePatches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstancePatches {
    _private: (),
}
impl DescribeInstancePatches {
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchesInput`](crate::input::DescribeInstancePatchesInput)
    pub fn builder() -> crate::input::describe_instance_patches_input::Builder {
        crate::input::describe_instance_patches_input::Builder::default()
    }
    /// Creates a new `DescribeInstancePatches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstancePatches {
    type Output = std::result::Result<
        crate::output::DescribeInstancePatchesOutput,
        crate::error::DescribeInstancePatchesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_patches_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_patches_response(response)
        }
    }
}

/// Operation shape for `DescribeInstancePatchStates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_patch_states`](crate::client::Client::describe_instance_patch_states).
///
/// See [`crate::client::fluent_builders::DescribeInstancePatchStates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstancePatchStates {
    _private: (),
}
impl DescribeInstancePatchStates {
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchStatesInput`](crate::input::DescribeInstancePatchStatesInput)
    pub fn builder() -> crate::input::describe_instance_patch_states_input::Builder {
        crate::input::describe_instance_patch_states_input::Builder::default()
    }
    /// Creates a new `DescribeInstancePatchStates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstancePatchStates {
    type Output = std::result::Result<
        crate::output::DescribeInstancePatchStatesOutput,
        crate::error::DescribeInstancePatchStatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_patch_states_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_patch_states_response(response)
        }
    }
}

/// Operation shape for `DescribeInstancePatchStatesForPatchGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_patch_states_for_patch_group`](crate::client::Client::describe_instance_patch_states_for_patch_group).
///
/// See [`crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstancePatchStatesForPatchGroup {
    _private: (),
}
impl DescribeInstancePatchStatesForPatchGroup {
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchStatesForPatchGroupInput`](crate::input::DescribeInstancePatchStatesForPatchGroupInput)
    pub fn builder() -> crate::input::describe_instance_patch_states_for_patch_group_input::Builder
    {
        crate::input::describe_instance_patch_states_for_patch_group_input::Builder::default()
    }
    /// Creates a new `DescribeInstancePatchStatesForPatchGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstancePatchStatesForPatchGroup {
    type Output = std::result::Result<
        crate::output::DescribeInstancePatchStatesForPatchGroupOutput,
        crate::error::DescribeInstancePatchStatesForPatchGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_patch_states_for_patch_group_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_instance_patch_states_for_patch_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeInventoryDeletions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_inventory_deletions`](crate::client::Client::describe_inventory_deletions).
///
/// See [`crate::client::fluent_builders::DescribeInventoryDeletions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInventoryDeletions {
    _private: (),
}
impl DescribeInventoryDeletions {
    /// Creates a new builder-style object to manufacture [`DescribeInventoryDeletionsInput`](crate::input::DescribeInventoryDeletionsInput)
    pub fn builder() -> crate::input::describe_inventory_deletions_input::Builder {
        crate::input::describe_inventory_deletions_input::Builder::default()
    }
    /// Creates a new `DescribeInventoryDeletions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInventoryDeletions {
    type Output = std::result::Result<
        crate::output::DescribeInventoryDeletionsOutput,
        crate::error::DescribeInventoryDeletionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_inventory_deletions_error(response)
        } else {
            crate::operation_deser::parse_describe_inventory_deletions_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindowExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_window_executions`](crate::client::Client::describe_maintenance_window_executions).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindowExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindowExecutions {
    _private: (),
}
impl DescribeMaintenanceWindowExecutions {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionsInput`](crate::input::DescribeMaintenanceWindowExecutionsInput)
    pub fn builder() -> crate::input::describe_maintenance_window_executions_input::Builder {
        crate::input::describe_maintenance_window_executions_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceWindowExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceWindowExecutions {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowExecutionsOutput,
        crate::error::DescribeMaintenanceWindowExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_window_executions_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_window_executions_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindowExecutionTaskInvocations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_window_execution_task_invocations`](crate::client::Client::describe_maintenance_window_execution_task_invocations).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindowExecutionTaskInvocations {
    _private: (),
}
impl DescribeMaintenanceWindowExecutionTaskInvocations {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionTaskInvocationsInput`](crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput)
    pub fn builder(
    ) -> crate::input::describe_maintenance_window_execution_task_invocations_input::Builder {
        crate::input::describe_maintenance_window_execution_task_invocations_input::Builder::default(
        )
    }
    /// Creates a new `DescribeMaintenanceWindowExecutionTaskInvocations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeMaintenanceWindowExecutionTaskInvocations
{
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput,
        crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_window_execution_task_invocations_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_window_execution_task_invocations_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindowExecutionTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_window_execution_tasks`](crate::client::Client::describe_maintenance_window_execution_tasks).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindowExecutionTasks {
    _private: (),
}
impl DescribeMaintenanceWindowExecutionTasks {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionTasksInput`](crate::input::DescribeMaintenanceWindowExecutionTasksInput)
    pub fn builder() -> crate::input::describe_maintenance_window_execution_tasks_input::Builder {
        crate::input::describe_maintenance_window_execution_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceWindowExecutionTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceWindowExecutionTasks {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowExecutionTasksOutput,
        crate::error::DescribeMaintenanceWindowExecutionTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_window_execution_tasks_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_maintenance_window_execution_tasks_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_windows`](crate::client::Client::describe_maintenance_windows).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindows {
    _private: (),
}
impl DescribeMaintenanceWindows {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowsInput`](crate::input::DescribeMaintenanceWindowsInput)
    pub fn builder() -> crate::input::describe_maintenance_windows_input::Builder {
        crate::input::describe_maintenance_windows_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceWindows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceWindows {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowsOutput,
        crate::error::DescribeMaintenanceWindowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_windows_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_windows_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindowSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_window_schedule`](crate::client::Client::describe_maintenance_window_schedule).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindowSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindowSchedule {
    _private: (),
}
impl DescribeMaintenanceWindowSchedule {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowScheduleInput`](crate::input::DescribeMaintenanceWindowScheduleInput)
    pub fn builder() -> crate::input::describe_maintenance_window_schedule_input::Builder {
        crate::input::describe_maintenance_window_schedule_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceWindowSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceWindowSchedule {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowScheduleOutput,
        crate::error::DescribeMaintenanceWindowScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_window_schedule_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_window_schedule_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindowsForTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_windows_for_target`](crate::client::Client::describe_maintenance_windows_for_target).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindowsForTarget {
    _private: (),
}
impl DescribeMaintenanceWindowsForTarget {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowsForTargetInput`](crate::input::DescribeMaintenanceWindowsForTargetInput)
    pub fn builder() -> crate::input::describe_maintenance_windows_for_target_input::Builder {
        crate::input::describe_maintenance_windows_for_target_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceWindowsForTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceWindowsForTarget {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowsForTargetOutput,
        crate::error::DescribeMaintenanceWindowsForTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_windows_for_target_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_windows_for_target_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindowTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_window_targets`](crate::client::Client::describe_maintenance_window_targets).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindowTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindowTargets {
    _private: (),
}
impl DescribeMaintenanceWindowTargets {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowTargetsInput`](crate::input::DescribeMaintenanceWindowTargetsInput)
    pub fn builder() -> crate::input::describe_maintenance_window_targets_input::Builder {
        crate::input::describe_maintenance_window_targets_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceWindowTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceWindowTargets {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowTargetsOutput,
        crate::error::DescribeMaintenanceWindowTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_window_targets_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_window_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeMaintenanceWindowTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_maintenance_window_tasks`](crate::client::Client::describe_maintenance_window_tasks).
///
/// See [`crate::client::fluent_builders::DescribeMaintenanceWindowTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMaintenanceWindowTasks {
    _private: (),
}
impl DescribeMaintenanceWindowTasks {
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowTasksInput`](crate::input::DescribeMaintenanceWindowTasksInput)
    pub fn builder() -> crate::input::describe_maintenance_window_tasks_input::Builder {
        crate::input::describe_maintenance_window_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeMaintenanceWindowTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMaintenanceWindowTasks {
    type Output = std::result::Result<
        crate::output::DescribeMaintenanceWindowTasksOutput,
        crate::error::DescribeMaintenanceWindowTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_maintenance_window_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_maintenance_window_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeOpsItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ops_items`](crate::client::Client::describe_ops_items).
///
/// See [`crate::client::fluent_builders::DescribeOpsItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOpsItems {
    _private: (),
}
impl DescribeOpsItems {
    /// Creates a new builder-style object to manufacture [`DescribeOpsItemsInput`](crate::input::DescribeOpsItemsInput)
    pub fn builder() -> crate::input::describe_ops_items_input::Builder {
        crate::input::describe_ops_items_input::Builder::default()
    }
    /// Creates a new `DescribeOpsItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOpsItems {
    type Output = std::result::Result<
        crate::output::DescribeOpsItemsOutput,
        crate::error::DescribeOpsItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ops_items_error(response)
        } else {
            crate::operation_deser::parse_describe_ops_items_response(response)
        }
    }
}

/// Operation shape for `DescribeParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_parameters`](crate::client::Client::describe_parameters).
///
/// See [`crate::client::fluent_builders::DescribeParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeParameters {
    _private: (),
}
impl DescribeParameters {
    /// Creates a new builder-style object to manufacture [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    pub fn builder() -> crate::input::describe_parameters_input::Builder {
        crate::input::describe_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeParameters {
    type Output = std::result::Result<
        crate::output::DescribeParametersOutput,
        crate::error::DescribeParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribePatchBaselines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_patch_baselines`](crate::client::Client::describe_patch_baselines).
///
/// See [`crate::client::fluent_builders::DescribePatchBaselines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePatchBaselines {
    _private: (),
}
impl DescribePatchBaselines {
    /// Creates a new builder-style object to manufacture [`DescribePatchBaselinesInput`](crate::input::DescribePatchBaselinesInput)
    pub fn builder() -> crate::input::describe_patch_baselines_input::Builder {
        crate::input::describe_patch_baselines_input::Builder::default()
    }
    /// Creates a new `DescribePatchBaselines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePatchBaselines {
    type Output = std::result::Result<
        crate::output::DescribePatchBaselinesOutput,
        crate::error::DescribePatchBaselinesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_patch_baselines_error(response)
        } else {
            crate::operation_deser::parse_describe_patch_baselines_response(response)
        }
    }
}

/// Operation shape for `DescribePatchGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_patch_groups`](crate::client::Client::describe_patch_groups).
///
/// See [`crate::client::fluent_builders::DescribePatchGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePatchGroups {
    _private: (),
}
impl DescribePatchGroups {
    /// Creates a new builder-style object to manufacture [`DescribePatchGroupsInput`](crate::input::DescribePatchGroupsInput)
    pub fn builder() -> crate::input::describe_patch_groups_input::Builder {
        crate::input::describe_patch_groups_input::Builder::default()
    }
    /// Creates a new `DescribePatchGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePatchGroups {
    type Output = std::result::Result<
        crate::output::DescribePatchGroupsOutput,
        crate::error::DescribePatchGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_patch_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_patch_groups_response(response)
        }
    }
}

/// Operation shape for `DescribePatchGroupState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_patch_group_state`](crate::client::Client::describe_patch_group_state).
///
/// See [`crate::client::fluent_builders::DescribePatchGroupState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePatchGroupState {
    _private: (),
}
impl DescribePatchGroupState {
    /// Creates a new builder-style object to manufacture [`DescribePatchGroupStateInput`](crate::input::DescribePatchGroupStateInput)
    pub fn builder() -> crate::input::describe_patch_group_state_input::Builder {
        crate::input::describe_patch_group_state_input::Builder::default()
    }
    /// Creates a new `DescribePatchGroupState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePatchGroupState {
    type Output = std::result::Result<
        crate::output::DescribePatchGroupStateOutput,
        crate::error::DescribePatchGroupStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_patch_group_state_error(response)
        } else {
            crate::operation_deser::parse_describe_patch_group_state_response(response)
        }
    }
}

/// Operation shape for `DescribePatchProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_patch_properties`](crate::client::Client::describe_patch_properties).
///
/// See [`crate::client::fluent_builders::DescribePatchProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePatchProperties {
    _private: (),
}
impl DescribePatchProperties {
    /// Creates a new builder-style object to manufacture [`DescribePatchPropertiesInput`](crate::input::DescribePatchPropertiesInput)
    pub fn builder() -> crate::input::describe_patch_properties_input::Builder {
        crate::input::describe_patch_properties_input::Builder::default()
    }
    /// Creates a new `DescribePatchProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePatchProperties {
    type Output = std::result::Result<
        crate::output::DescribePatchPropertiesOutput,
        crate::error::DescribePatchPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_patch_properties_error(response)
        } else {
            crate::operation_deser::parse_describe_patch_properties_response(response)
        }
    }
}

/// Operation shape for `DescribeSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_sessions`](crate::client::Client::describe_sessions).
///
/// See [`crate::client::fluent_builders::DescribeSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSessions {
    _private: (),
}
impl DescribeSessions {
    /// Creates a new builder-style object to manufacture [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
    pub fn builder() -> crate::input::describe_sessions_input::Builder {
        crate::input::describe_sessions_input::Builder::default()
    }
    /// Creates a new `DescribeSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSessions {
    type Output = std::result::Result<
        crate::output::DescribeSessionsOutput,
        crate::error::DescribeSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_sessions_error(response)
        } else {
            crate::operation_deser::parse_describe_sessions_response(response)
        }
    }
}

/// Operation shape for `DisassociateOpsItemRelatedItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_ops_item_related_item`](crate::client::Client::disassociate_ops_item_related_item).
///
/// See [`crate::client::fluent_builders::DisassociateOpsItemRelatedItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateOpsItemRelatedItem {
    _private: (),
}
impl DisassociateOpsItemRelatedItem {
    /// Creates a new builder-style object to manufacture [`DisassociateOpsItemRelatedItemInput`](crate::input::DisassociateOpsItemRelatedItemInput)
    pub fn builder() -> crate::input::disassociate_ops_item_related_item_input::Builder {
        crate::input::disassociate_ops_item_related_item_input::Builder::default()
    }
    /// Creates a new `DisassociateOpsItemRelatedItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateOpsItemRelatedItem {
    type Output = std::result::Result<
        crate::output::DisassociateOpsItemRelatedItemOutput,
        crate::error::DisassociateOpsItemRelatedItemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_ops_item_related_item_error(response)
        } else {
            crate::operation_deser::parse_disassociate_ops_item_related_item_response(response)
        }
    }
}

/// Operation shape for `GetAutomationExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_automation_execution`](crate::client::Client::get_automation_execution).
///
/// See [`crate::client::fluent_builders::GetAutomationExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAutomationExecution {
    _private: (),
}
impl GetAutomationExecution {
    /// Creates a new builder-style object to manufacture [`GetAutomationExecutionInput`](crate::input::GetAutomationExecutionInput)
    pub fn builder() -> crate::input::get_automation_execution_input::Builder {
        crate::input::get_automation_execution_input::Builder::default()
    }
    /// Creates a new `GetAutomationExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAutomationExecution {
    type Output = std::result::Result<
        crate::output::GetAutomationExecutionOutput,
        crate::error::GetAutomationExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_automation_execution_error(response)
        } else {
            crate::operation_deser::parse_get_automation_execution_response(response)
        }
    }
}

/// Operation shape for `GetCalendarState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_calendar_state`](crate::client::Client::get_calendar_state).
///
/// See [`crate::client::fluent_builders::GetCalendarState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCalendarState {
    _private: (),
}
impl GetCalendarState {
    /// Creates a new builder-style object to manufacture [`GetCalendarStateInput`](crate::input::GetCalendarStateInput)
    pub fn builder() -> crate::input::get_calendar_state_input::Builder {
        crate::input::get_calendar_state_input::Builder::default()
    }
    /// Creates a new `GetCalendarState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCalendarState {
    type Output = std::result::Result<
        crate::output::GetCalendarStateOutput,
        crate::error::GetCalendarStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_calendar_state_error(response)
        } else {
            crate::operation_deser::parse_get_calendar_state_response(response)
        }
    }
}

/// Operation shape for `GetCommandInvocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_command_invocation`](crate::client::Client::get_command_invocation).
///
/// See [`crate::client::fluent_builders::GetCommandInvocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCommandInvocation {
    _private: (),
}
impl GetCommandInvocation {
    /// Creates a new builder-style object to manufacture [`GetCommandInvocationInput`](crate::input::GetCommandInvocationInput)
    pub fn builder() -> crate::input::get_command_invocation_input::Builder {
        crate::input::get_command_invocation_input::Builder::default()
    }
    /// Creates a new `GetCommandInvocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCommandInvocation {
    type Output = std::result::Result<
        crate::output::GetCommandInvocationOutput,
        crate::error::GetCommandInvocationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_command_invocation_error(response)
        } else {
            crate::operation_deser::parse_get_command_invocation_response(response)
        }
    }
}

/// Operation shape for `GetConnectionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connection_status`](crate::client::Client::get_connection_status).
///
/// See [`crate::client::fluent_builders::GetConnectionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectionStatus {
    _private: (),
}
impl GetConnectionStatus {
    /// Creates a new builder-style object to manufacture [`GetConnectionStatusInput`](crate::input::GetConnectionStatusInput)
    pub fn builder() -> crate::input::get_connection_status_input::Builder {
        crate::input::get_connection_status_input::Builder::default()
    }
    /// Creates a new `GetConnectionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectionStatus {
    type Output = std::result::Result<
        crate::output::GetConnectionStatusOutput,
        crate::error::GetConnectionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connection_status_error(response)
        } else {
            crate::operation_deser::parse_get_connection_status_response(response)
        }
    }
}

/// Operation shape for `GetDefaultPatchBaseline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_default_patch_baseline`](crate::client::Client::get_default_patch_baseline).
///
/// See [`crate::client::fluent_builders::GetDefaultPatchBaseline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDefaultPatchBaseline {
    _private: (),
}
impl GetDefaultPatchBaseline {
    /// Creates a new builder-style object to manufacture [`GetDefaultPatchBaselineInput`](crate::input::GetDefaultPatchBaselineInput)
    pub fn builder() -> crate::input::get_default_patch_baseline_input::Builder {
        crate::input::get_default_patch_baseline_input::Builder::default()
    }
    /// Creates a new `GetDefaultPatchBaseline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDefaultPatchBaseline {
    type Output = std::result::Result<
        crate::output::GetDefaultPatchBaselineOutput,
        crate::error::GetDefaultPatchBaselineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_default_patch_baseline_error(response)
        } else {
            crate::operation_deser::parse_get_default_patch_baseline_response(response)
        }
    }
}

/// Operation shape for `GetDeployablePatchSnapshotForInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployable_patch_snapshot_for_instance`](crate::client::Client::get_deployable_patch_snapshot_for_instance).
///
/// See [`crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeployablePatchSnapshotForInstance {
    _private: (),
}
impl GetDeployablePatchSnapshotForInstance {
    /// Creates a new builder-style object to manufacture [`GetDeployablePatchSnapshotForInstanceInput`](crate::input::GetDeployablePatchSnapshotForInstanceInput)
    pub fn builder() -> crate::input::get_deployable_patch_snapshot_for_instance_input::Builder {
        crate::input::get_deployable_patch_snapshot_for_instance_input::Builder::default()
    }
    /// Creates a new `GetDeployablePatchSnapshotForInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeployablePatchSnapshotForInstance {
    type Output = std::result::Result<
        crate::output::GetDeployablePatchSnapshotForInstanceOutput,
        crate::error::GetDeployablePatchSnapshotForInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployable_patch_snapshot_for_instance_error(response)
        } else {
            crate::operation_deser::parse_get_deployable_patch_snapshot_for_instance_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_document`](crate::client::Client::get_document).
///
/// See [`crate::client::fluent_builders::GetDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDocument {
    _private: (),
}
impl GetDocument {
    /// Creates a new builder-style object to manufacture [`GetDocumentInput`](crate::input::GetDocumentInput)
    pub fn builder() -> crate::input::get_document_input::Builder {
        crate::input::get_document_input::Builder::default()
    }
    /// Creates a new `GetDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDocument {
    type Output =
        std::result::Result<crate::output::GetDocumentOutput, crate::error::GetDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_document_error(response)
        } else {
            crate::operation_deser::parse_get_document_response(response)
        }
    }
}

/// Operation shape for `GetInventory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_inventory`](crate::client::Client::get_inventory).
///
/// See [`crate::client::fluent_builders::GetInventory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInventory {
    _private: (),
}
impl GetInventory {
    /// Creates a new builder-style object to manufacture [`GetInventoryInput`](crate::input::GetInventoryInput)
    pub fn builder() -> crate::input::get_inventory_input::Builder {
        crate::input::get_inventory_input::Builder::default()
    }
    /// Creates a new `GetInventory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInventory {
    type Output =
        std::result::Result<crate::output::GetInventoryOutput, crate::error::GetInventoryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_inventory_error(response)
        } else {
            crate::operation_deser::parse_get_inventory_response(response)
        }
    }
}

/// Operation shape for `GetInventorySchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_inventory_schema`](crate::client::Client::get_inventory_schema).
///
/// See [`crate::client::fluent_builders::GetInventorySchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInventorySchema {
    _private: (),
}
impl GetInventorySchema {
    /// Creates a new builder-style object to manufacture [`GetInventorySchemaInput`](crate::input::GetInventorySchemaInput)
    pub fn builder() -> crate::input::get_inventory_schema_input::Builder {
        crate::input::get_inventory_schema_input::Builder::default()
    }
    /// Creates a new `GetInventorySchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInventorySchema {
    type Output = std::result::Result<
        crate::output::GetInventorySchemaOutput,
        crate::error::GetInventorySchemaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_inventory_schema_error(response)
        } else {
            crate::operation_deser::parse_get_inventory_schema_response(response)
        }
    }
}

/// Operation shape for `GetMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_maintenance_window`](crate::client::Client::get_maintenance_window).
///
/// See [`crate::client::fluent_builders::GetMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMaintenanceWindow {
    _private: (),
}
impl GetMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowInput`](crate::input::GetMaintenanceWindowInput)
    pub fn builder() -> crate::input::get_maintenance_window_input::Builder {
        crate::input::get_maintenance_window_input::Builder::default()
    }
    /// Creates a new `GetMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::GetMaintenanceWindowOutput,
        crate::error::GetMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_get_maintenance_window_response(response)
        }
    }
}

/// Operation shape for `GetMaintenanceWindowExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_maintenance_window_execution`](crate::client::Client::get_maintenance_window_execution).
///
/// See [`crate::client::fluent_builders::GetMaintenanceWindowExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMaintenanceWindowExecution {
    _private: (),
}
impl GetMaintenanceWindowExecution {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionInput`](crate::input::GetMaintenanceWindowExecutionInput)
    pub fn builder() -> crate::input::get_maintenance_window_execution_input::Builder {
        crate::input::get_maintenance_window_execution_input::Builder::default()
    }
    /// Creates a new `GetMaintenanceWindowExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMaintenanceWindowExecution {
    type Output = std::result::Result<
        crate::output::GetMaintenanceWindowExecutionOutput,
        crate::error::GetMaintenanceWindowExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_maintenance_window_execution_error(response)
        } else {
            crate::operation_deser::parse_get_maintenance_window_execution_response(response)
        }
    }
}

/// Operation shape for `GetMaintenanceWindowExecutionTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_maintenance_window_execution_task`](crate::client::Client::get_maintenance_window_execution_task).
///
/// See [`crate::client::fluent_builders::GetMaintenanceWindowExecutionTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMaintenanceWindowExecutionTask {
    _private: (),
}
impl GetMaintenanceWindowExecutionTask {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionTaskInput`](crate::input::GetMaintenanceWindowExecutionTaskInput)
    pub fn builder() -> crate::input::get_maintenance_window_execution_task_input::Builder {
        crate::input::get_maintenance_window_execution_task_input::Builder::default()
    }
    /// Creates a new `GetMaintenanceWindowExecutionTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMaintenanceWindowExecutionTask {
    type Output = std::result::Result<
        crate::output::GetMaintenanceWindowExecutionTaskOutput,
        crate::error::GetMaintenanceWindowExecutionTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_maintenance_window_execution_task_error(response)
        } else {
            crate::operation_deser::parse_get_maintenance_window_execution_task_response(response)
        }
    }
}

/// Operation shape for `GetMaintenanceWindowExecutionTaskInvocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_maintenance_window_execution_task_invocation`](crate::client::Client::get_maintenance_window_execution_task_invocation).
///
/// See [`crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMaintenanceWindowExecutionTaskInvocation {
    _private: (),
}
impl GetMaintenanceWindowExecutionTaskInvocation {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionTaskInvocationInput`](crate::input::GetMaintenanceWindowExecutionTaskInvocationInput)
    pub fn builder() -> crate::input::get_maintenance_window_execution_task_invocation_input::Builder
    {
        crate::input::get_maintenance_window_execution_task_invocation_input::Builder::default()
    }
    /// Creates a new `GetMaintenanceWindowExecutionTaskInvocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for GetMaintenanceWindowExecutionTaskInvocation
{
    type Output = std::result::Result<
        crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput,
        crate::error::GetMaintenanceWindowExecutionTaskInvocationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_maintenance_window_execution_task_invocation_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_maintenance_window_execution_task_invocation_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetMaintenanceWindowTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_maintenance_window_task`](crate::client::Client::get_maintenance_window_task).
///
/// See [`crate::client::fluent_builders::GetMaintenanceWindowTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMaintenanceWindowTask {
    _private: (),
}
impl GetMaintenanceWindowTask {
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowTaskInput`](crate::input::GetMaintenanceWindowTaskInput)
    pub fn builder() -> crate::input::get_maintenance_window_task_input::Builder {
        crate::input::get_maintenance_window_task_input::Builder::default()
    }
    /// Creates a new `GetMaintenanceWindowTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMaintenanceWindowTask {
    type Output = std::result::Result<
        crate::output::GetMaintenanceWindowTaskOutput,
        crate::error::GetMaintenanceWindowTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_maintenance_window_task_error(response)
        } else {
            crate::operation_deser::parse_get_maintenance_window_task_response(response)
        }
    }
}

/// Operation shape for `GetOpsItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ops_item`](crate::client::Client::get_ops_item).
///
/// See [`crate::client::fluent_builders::GetOpsItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOpsItem {
    _private: (),
}
impl GetOpsItem {
    /// Creates a new builder-style object to manufacture [`GetOpsItemInput`](crate::input::GetOpsItemInput)
    pub fn builder() -> crate::input::get_ops_item_input::Builder {
        crate::input::get_ops_item_input::Builder::default()
    }
    /// Creates a new `GetOpsItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOpsItem {
    type Output =
        std::result::Result<crate::output::GetOpsItemOutput, crate::error::GetOpsItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ops_item_error(response)
        } else {
            crate::operation_deser::parse_get_ops_item_response(response)
        }
    }
}

/// Operation shape for `GetOpsMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ops_metadata`](crate::client::Client::get_ops_metadata).
///
/// See [`crate::client::fluent_builders::GetOpsMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOpsMetadata {
    _private: (),
}
impl GetOpsMetadata {
    /// Creates a new builder-style object to manufacture [`GetOpsMetadataInput`](crate::input::GetOpsMetadataInput)
    pub fn builder() -> crate::input::get_ops_metadata_input::Builder {
        crate::input::get_ops_metadata_input::Builder::default()
    }
    /// Creates a new `GetOpsMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOpsMetadata {
    type Output =
        std::result::Result<crate::output::GetOpsMetadataOutput, crate::error::GetOpsMetadataError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ops_metadata_error(response)
        } else {
            crate::operation_deser::parse_get_ops_metadata_response(response)
        }
    }
}

/// Operation shape for `GetOpsSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ops_summary`](crate::client::Client::get_ops_summary).
///
/// See [`crate::client::fluent_builders::GetOpsSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOpsSummary {
    _private: (),
}
impl GetOpsSummary {
    /// Creates a new builder-style object to manufacture [`GetOpsSummaryInput`](crate::input::GetOpsSummaryInput)
    pub fn builder() -> crate::input::get_ops_summary_input::Builder {
        crate::input::get_ops_summary_input::Builder::default()
    }
    /// Creates a new `GetOpsSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOpsSummary {
    type Output =
        std::result::Result<crate::output::GetOpsSummaryOutput, crate::error::GetOpsSummaryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ops_summary_error(response)
        } else {
            crate::operation_deser::parse_get_ops_summary_response(response)
        }
    }
}

/// Operation shape for `GetParameter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_parameter`](crate::client::Client::get_parameter).
///
/// See [`crate::client::fluent_builders::GetParameter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetParameter {
    _private: (),
}
impl GetParameter {
    /// Creates a new builder-style object to manufacture [`GetParameterInput`](crate::input::GetParameterInput)
    pub fn builder() -> crate::input::get_parameter_input::Builder {
        crate::input::get_parameter_input::Builder::default()
    }
    /// Creates a new `GetParameter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetParameter {
    type Output =
        std::result::Result<crate::output::GetParameterOutput, crate::error::GetParameterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_parameter_error(response)
        } else {
            crate::operation_deser::parse_get_parameter_response(response)
        }
    }
}

/// Operation shape for `GetParameterHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_parameter_history`](crate::client::Client::get_parameter_history).
///
/// See [`crate::client::fluent_builders::GetParameterHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetParameterHistory {
    _private: (),
}
impl GetParameterHistory {
    /// Creates a new builder-style object to manufacture [`GetParameterHistoryInput`](crate::input::GetParameterHistoryInput)
    pub fn builder() -> crate::input::get_parameter_history_input::Builder {
        crate::input::get_parameter_history_input::Builder::default()
    }
    /// Creates a new `GetParameterHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetParameterHistory {
    type Output = std::result::Result<
        crate::output::GetParameterHistoryOutput,
        crate::error::GetParameterHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_parameter_history_error(response)
        } else {
            crate::operation_deser::parse_get_parameter_history_response(response)
        }
    }
}

/// Operation shape for `GetParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_parameters`](crate::client::Client::get_parameters).
///
/// See [`crate::client::fluent_builders::GetParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetParameters {
    _private: (),
}
impl GetParameters {
    /// Creates a new builder-style object to manufacture [`GetParametersInput`](crate::input::GetParametersInput)
    pub fn builder() -> crate::input::get_parameters_input::Builder {
        crate::input::get_parameters_input::Builder::default()
    }
    /// Creates a new `GetParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetParameters {
    type Output =
        std::result::Result<crate::output::GetParametersOutput, crate::error::GetParametersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_parameters_error(response)
        } else {
            crate::operation_deser::parse_get_parameters_response(response)
        }
    }
}

/// Operation shape for `GetParametersByPath`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_parameters_by_path`](crate::client::Client::get_parameters_by_path).
///
/// See [`crate::client::fluent_builders::GetParametersByPath`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetParametersByPath {
    _private: (),
}
impl GetParametersByPath {
    /// Creates a new builder-style object to manufacture [`GetParametersByPathInput`](crate::input::GetParametersByPathInput)
    pub fn builder() -> crate::input::get_parameters_by_path_input::Builder {
        crate::input::get_parameters_by_path_input::Builder::default()
    }
    /// Creates a new `GetParametersByPath` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetParametersByPath {
    type Output = std::result::Result<
        crate::output::GetParametersByPathOutput,
        crate::error::GetParametersByPathError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_parameters_by_path_error(response)
        } else {
            crate::operation_deser::parse_get_parameters_by_path_response(response)
        }
    }
}

/// Operation shape for `GetPatchBaseline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_patch_baseline`](crate::client::Client::get_patch_baseline).
///
/// See [`crate::client::fluent_builders::GetPatchBaseline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPatchBaseline {
    _private: (),
}
impl GetPatchBaseline {
    /// Creates a new builder-style object to manufacture [`GetPatchBaselineInput`](crate::input::GetPatchBaselineInput)
    pub fn builder() -> crate::input::get_patch_baseline_input::Builder {
        crate::input::get_patch_baseline_input::Builder::default()
    }
    /// Creates a new `GetPatchBaseline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPatchBaseline {
    type Output = std::result::Result<
        crate::output::GetPatchBaselineOutput,
        crate::error::GetPatchBaselineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_patch_baseline_error(response)
        } else {
            crate::operation_deser::parse_get_patch_baseline_response(response)
        }
    }
}

/// Operation shape for `GetPatchBaselineForPatchGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_patch_baseline_for_patch_group`](crate::client::Client::get_patch_baseline_for_patch_group).
///
/// See [`crate::client::fluent_builders::GetPatchBaselineForPatchGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPatchBaselineForPatchGroup {
    _private: (),
}
impl GetPatchBaselineForPatchGroup {
    /// Creates a new builder-style object to manufacture [`GetPatchBaselineForPatchGroupInput`](crate::input::GetPatchBaselineForPatchGroupInput)
    pub fn builder() -> crate::input::get_patch_baseline_for_patch_group_input::Builder {
        crate::input::get_patch_baseline_for_patch_group_input::Builder::default()
    }
    /// Creates a new `GetPatchBaselineForPatchGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPatchBaselineForPatchGroup {
    type Output = std::result::Result<
        crate::output::GetPatchBaselineForPatchGroupOutput,
        crate::error::GetPatchBaselineForPatchGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_patch_baseline_for_patch_group_error(response)
        } else {
            crate::operation_deser::parse_get_patch_baseline_for_patch_group_response(response)
        }
    }
}

/// Operation shape for `GetServiceSetting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_setting`](crate::client::Client::get_service_setting).
///
/// See [`crate::client::fluent_builders::GetServiceSetting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceSetting {
    _private: (),
}
impl GetServiceSetting {
    /// Creates a new builder-style object to manufacture [`GetServiceSettingInput`](crate::input::GetServiceSettingInput)
    pub fn builder() -> crate::input::get_service_setting_input::Builder {
        crate::input::get_service_setting_input::Builder::default()
    }
    /// Creates a new `GetServiceSetting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceSetting {
    type Output = std::result::Result<
        crate::output::GetServiceSettingOutput,
        crate::error::GetServiceSettingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_setting_error(response)
        } else {
            crate::operation_deser::parse_get_service_setting_response(response)
        }
    }
}

/// Operation shape for `LabelParameterVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`label_parameter_version`](crate::client::Client::label_parameter_version).
///
/// See [`crate::client::fluent_builders::LabelParameterVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct LabelParameterVersion {
    _private: (),
}
impl LabelParameterVersion {
    /// Creates a new builder-style object to manufacture [`LabelParameterVersionInput`](crate::input::LabelParameterVersionInput)
    pub fn builder() -> crate::input::label_parameter_version_input::Builder {
        crate::input::label_parameter_version_input::Builder::default()
    }
    /// Creates a new `LabelParameterVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for LabelParameterVersion {
    type Output = std::result::Result<
        crate::output::LabelParameterVersionOutput,
        crate::error::LabelParameterVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_label_parameter_version_error(response)
        } else {
            crate::operation_deser::parse_label_parameter_version_response(response)
        }
    }
}

/// Operation shape for `ListAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_associations`](crate::client::Client::list_associations).
///
/// See [`crate::client::fluent_builders::ListAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociations {
    _private: (),
}
impl ListAssociations {
    /// Creates a new builder-style object to manufacture [`ListAssociationsInput`](crate::input::ListAssociationsInput)
    pub fn builder() -> crate::input::list_associations_input::Builder {
        crate::input::list_associations_input::Builder::default()
    }
    /// Creates a new `ListAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssociations {
    type Output = std::result::Result<
        crate::output::ListAssociationsOutput,
        crate::error::ListAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_associations_error(response)
        } else {
            crate::operation_deser::parse_list_associations_response(response)
        }
    }
}

/// Operation shape for `ListAssociationVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_association_versions`](crate::client::Client::list_association_versions).
///
/// See [`crate::client::fluent_builders::ListAssociationVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociationVersions {
    _private: (),
}
impl ListAssociationVersions {
    /// Creates a new builder-style object to manufacture [`ListAssociationVersionsInput`](crate::input::ListAssociationVersionsInput)
    pub fn builder() -> crate::input::list_association_versions_input::Builder {
        crate::input::list_association_versions_input::Builder::default()
    }
    /// Creates a new `ListAssociationVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssociationVersions {
    type Output = std::result::Result<
        crate::output::ListAssociationVersionsOutput,
        crate::error::ListAssociationVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_association_versions_error(response)
        } else {
            crate::operation_deser::parse_list_association_versions_response(response)
        }
    }
}

/// Operation shape for `ListCommandInvocations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_command_invocations`](crate::client::Client::list_command_invocations).
///
/// See [`crate::client::fluent_builders::ListCommandInvocations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCommandInvocations {
    _private: (),
}
impl ListCommandInvocations {
    /// Creates a new builder-style object to manufacture [`ListCommandInvocationsInput`](crate::input::ListCommandInvocationsInput)
    pub fn builder() -> crate::input::list_command_invocations_input::Builder {
        crate::input::list_command_invocations_input::Builder::default()
    }
    /// Creates a new `ListCommandInvocations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCommandInvocations {
    type Output = std::result::Result<
        crate::output::ListCommandInvocationsOutput,
        crate::error::ListCommandInvocationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_command_invocations_error(response)
        } else {
            crate::operation_deser::parse_list_command_invocations_response(response)
        }
    }
}

/// Operation shape for `ListCommands`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_commands`](crate::client::Client::list_commands).
///
/// See [`crate::client::fluent_builders::ListCommands`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCommands {
    _private: (),
}
impl ListCommands {
    /// Creates a new builder-style object to manufacture [`ListCommandsInput`](crate::input::ListCommandsInput)
    pub fn builder() -> crate::input::list_commands_input::Builder {
        crate::input::list_commands_input::Builder::default()
    }
    /// Creates a new `ListCommands` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCommands {
    type Output =
        std::result::Result<crate::output::ListCommandsOutput, crate::error::ListCommandsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_commands_error(response)
        } else {
            crate::operation_deser::parse_list_commands_response(response)
        }
    }
}

/// Operation shape for `ListComplianceItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_compliance_items`](crate::client::Client::list_compliance_items).
///
/// See [`crate::client::fluent_builders::ListComplianceItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListComplianceItems {
    _private: (),
}
impl ListComplianceItems {
    /// Creates a new builder-style object to manufacture [`ListComplianceItemsInput`](crate::input::ListComplianceItemsInput)
    pub fn builder() -> crate::input::list_compliance_items_input::Builder {
        crate::input::list_compliance_items_input::Builder::default()
    }
    /// Creates a new `ListComplianceItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListComplianceItems {
    type Output = std::result::Result<
        crate::output::ListComplianceItemsOutput,
        crate::error::ListComplianceItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_compliance_items_error(response)
        } else {
            crate::operation_deser::parse_list_compliance_items_response(response)
        }
    }
}

/// Operation shape for `ListComplianceSummaries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_compliance_summaries`](crate::client::Client::list_compliance_summaries).
///
/// See [`crate::client::fluent_builders::ListComplianceSummaries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListComplianceSummaries {
    _private: (),
}
impl ListComplianceSummaries {
    /// Creates a new builder-style object to manufacture [`ListComplianceSummariesInput`](crate::input::ListComplianceSummariesInput)
    pub fn builder() -> crate::input::list_compliance_summaries_input::Builder {
        crate::input::list_compliance_summaries_input::Builder::default()
    }
    /// Creates a new `ListComplianceSummaries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListComplianceSummaries {
    type Output = std::result::Result<
        crate::output::ListComplianceSummariesOutput,
        crate::error::ListComplianceSummariesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_compliance_summaries_error(response)
        } else {
            crate::operation_deser::parse_list_compliance_summaries_response(response)
        }
    }
}

/// Operation shape for `ListDocumentMetadataHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_document_metadata_history`](crate::client::Client::list_document_metadata_history).
///
/// See [`crate::client::fluent_builders::ListDocumentMetadataHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDocumentMetadataHistory {
    _private: (),
}
impl ListDocumentMetadataHistory {
    /// Creates a new builder-style object to manufacture [`ListDocumentMetadataHistoryInput`](crate::input::ListDocumentMetadataHistoryInput)
    pub fn builder() -> crate::input::list_document_metadata_history_input::Builder {
        crate::input::list_document_metadata_history_input::Builder::default()
    }
    /// Creates a new `ListDocumentMetadataHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDocumentMetadataHistory {
    type Output = std::result::Result<
        crate::output::ListDocumentMetadataHistoryOutput,
        crate::error::ListDocumentMetadataHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_document_metadata_history_error(response)
        } else {
            crate::operation_deser::parse_list_document_metadata_history_response(response)
        }
    }
}

/// Operation shape for `ListDocuments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_documents`](crate::client::Client::list_documents).
///
/// See [`crate::client::fluent_builders::ListDocuments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDocuments {
    _private: (),
}
impl ListDocuments {
    /// Creates a new builder-style object to manufacture [`ListDocumentsInput`](crate::input::ListDocumentsInput)
    pub fn builder() -> crate::input::list_documents_input::Builder {
        crate::input::list_documents_input::Builder::default()
    }
    /// Creates a new `ListDocuments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDocuments {
    type Output =
        std::result::Result<crate::output::ListDocumentsOutput, crate::error::ListDocumentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_documents_error(response)
        } else {
            crate::operation_deser::parse_list_documents_response(response)
        }
    }
}

/// Operation shape for `ListDocumentVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_document_versions`](crate::client::Client::list_document_versions).
///
/// See [`crate::client::fluent_builders::ListDocumentVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDocumentVersions {
    _private: (),
}
impl ListDocumentVersions {
    /// Creates a new builder-style object to manufacture [`ListDocumentVersionsInput`](crate::input::ListDocumentVersionsInput)
    pub fn builder() -> crate::input::list_document_versions_input::Builder {
        crate::input::list_document_versions_input::Builder::default()
    }
    /// Creates a new `ListDocumentVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDocumentVersions {
    type Output = std::result::Result<
        crate::output::ListDocumentVersionsOutput,
        crate::error::ListDocumentVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_document_versions_error(response)
        } else {
            crate::operation_deser::parse_list_document_versions_response(response)
        }
    }
}

/// Operation shape for `ListInventoryEntries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_inventory_entries`](crate::client::Client::list_inventory_entries).
///
/// See [`crate::client::fluent_builders::ListInventoryEntries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInventoryEntries {
    _private: (),
}
impl ListInventoryEntries {
    /// Creates a new builder-style object to manufacture [`ListInventoryEntriesInput`](crate::input::ListInventoryEntriesInput)
    pub fn builder() -> crate::input::list_inventory_entries_input::Builder {
        crate::input::list_inventory_entries_input::Builder::default()
    }
    /// Creates a new `ListInventoryEntries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInventoryEntries {
    type Output = std::result::Result<
        crate::output::ListInventoryEntriesOutput,
        crate::error::ListInventoryEntriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_inventory_entries_error(response)
        } else {
            crate::operation_deser::parse_list_inventory_entries_response(response)
        }
    }
}

/// Operation shape for `ListOpsItemEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ops_item_events`](crate::client::Client::list_ops_item_events).
///
/// See [`crate::client::fluent_builders::ListOpsItemEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOpsItemEvents {
    _private: (),
}
impl ListOpsItemEvents {
    /// Creates a new builder-style object to manufacture [`ListOpsItemEventsInput`](crate::input::ListOpsItemEventsInput)
    pub fn builder() -> crate::input::list_ops_item_events_input::Builder {
        crate::input::list_ops_item_events_input::Builder::default()
    }
    /// Creates a new `ListOpsItemEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOpsItemEvents {
    type Output = std::result::Result<
        crate::output::ListOpsItemEventsOutput,
        crate::error::ListOpsItemEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ops_item_events_error(response)
        } else {
            crate::operation_deser::parse_list_ops_item_events_response(response)
        }
    }
}

/// Operation shape for `ListOpsItemRelatedItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ops_item_related_items`](crate::client::Client::list_ops_item_related_items).
///
/// See [`crate::client::fluent_builders::ListOpsItemRelatedItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOpsItemRelatedItems {
    _private: (),
}
impl ListOpsItemRelatedItems {
    /// Creates a new builder-style object to manufacture [`ListOpsItemRelatedItemsInput`](crate::input::ListOpsItemRelatedItemsInput)
    pub fn builder() -> crate::input::list_ops_item_related_items_input::Builder {
        crate::input::list_ops_item_related_items_input::Builder::default()
    }
    /// Creates a new `ListOpsItemRelatedItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOpsItemRelatedItems {
    type Output = std::result::Result<
        crate::output::ListOpsItemRelatedItemsOutput,
        crate::error::ListOpsItemRelatedItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ops_item_related_items_error(response)
        } else {
            crate::operation_deser::parse_list_ops_item_related_items_response(response)
        }
    }
}

/// Operation shape for `ListOpsMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ops_metadata`](crate::client::Client::list_ops_metadata).
///
/// See [`crate::client::fluent_builders::ListOpsMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOpsMetadata {
    _private: (),
}
impl ListOpsMetadata {
    /// Creates a new builder-style object to manufacture [`ListOpsMetadataInput`](crate::input::ListOpsMetadataInput)
    pub fn builder() -> crate::input::list_ops_metadata_input::Builder {
        crate::input::list_ops_metadata_input::Builder::default()
    }
    /// Creates a new `ListOpsMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOpsMetadata {
    type Output = std::result::Result<
        crate::output::ListOpsMetadataOutput,
        crate::error::ListOpsMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ops_metadata_error(response)
        } else {
            crate::operation_deser::parse_list_ops_metadata_response(response)
        }
    }
}

/// Operation shape for `ListResourceComplianceSummaries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_compliance_summaries`](crate::client::Client::list_resource_compliance_summaries).
///
/// See [`crate::client::fluent_builders::ListResourceComplianceSummaries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceComplianceSummaries {
    _private: (),
}
impl ListResourceComplianceSummaries {
    /// Creates a new builder-style object to manufacture [`ListResourceComplianceSummariesInput`](crate::input::ListResourceComplianceSummariesInput)
    pub fn builder() -> crate::input::list_resource_compliance_summaries_input::Builder {
        crate::input::list_resource_compliance_summaries_input::Builder::default()
    }
    /// Creates a new `ListResourceComplianceSummaries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceComplianceSummaries {
    type Output = std::result::Result<
        crate::output::ListResourceComplianceSummariesOutput,
        crate::error::ListResourceComplianceSummariesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_compliance_summaries_error(response)
        } else {
            crate::operation_deser::parse_list_resource_compliance_summaries_response(response)
        }
    }
}

/// Operation shape for `ListResourceDataSync`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_data_sync`](crate::client::Client::list_resource_data_sync).
///
/// See [`crate::client::fluent_builders::ListResourceDataSync`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceDataSync {
    _private: (),
}
impl ListResourceDataSync {
    /// Creates a new builder-style object to manufacture [`ListResourceDataSyncInput`](crate::input::ListResourceDataSyncInput)
    pub fn builder() -> crate::input::list_resource_data_sync_input::Builder {
        crate::input::list_resource_data_sync_input::Builder::default()
    }
    /// Creates a new `ListResourceDataSync` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceDataSync {
    type Output = std::result::Result<
        crate::output::ListResourceDataSyncOutput,
        crate::error::ListResourceDataSyncError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_data_sync_error(response)
        } else {
            crate::operation_deser::parse_list_resource_data_sync_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ModifyDocumentPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_document_permission`](crate::client::Client::modify_document_permission).
///
/// See [`crate::client::fluent_builders::ModifyDocumentPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDocumentPermission {
    _private: (),
}
impl ModifyDocumentPermission {
    /// Creates a new builder-style object to manufacture [`ModifyDocumentPermissionInput`](crate::input::ModifyDocumentPermissionInput)
    pub fn builder() -> crate::input::modify_document_permission_input::Builder {
        crate::input::modify_document_permission_input::Builder::default()
    }
    /// Creates a new `ModifyDocumentPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDocumentPermission {
    type Output = std::result::Result<
        crate::output::ModifyDocumentPermissionOutput,
        crate::error::ModifyDocumentPermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_document_permission_error(response)
        } else {
            crate::operation_deser::parse_modify_document_permission_response(response)
        }
    }
}

/// Operation shape for `PutComplianceItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_compliance_items`](crate::client::Client::put_compliance_items).
///
/// See [`crate::client::fluent_builders::PutComplianceItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutComplianceItems {
    _private: (),
}
impl PutComplianceItems {
    /// Creates a new builder-style object to manufacture [`PutComplianceItemsInput`](crate::input::PutComplianceItemsInput)
    pub fn builder() -> crate::input::put_compliance_items_input::Builder {
        crate::input::put_compliance_items_input::Builder::default()
    }
    /// Creates a new `PutComplianceItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutComplianceItems {
    type Output = std::result::Result<
        crate::output::PutComplianceItemsOutput,
        crate::error::PutComplianceItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_compliance_items_error(response)
        } else {
            crate::operation_deser::parse_put_compliance_items_response(response)
        }
    }
}

/// Operation shape for `PutInventory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_inventory`](crate::client::Client::put_inventory).
///
/// See [`crate::client::fluent_builders::PutInventory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutInventory {
    _private: (),
}
impl PutInventory {
    /// Creates a new builder-style object to manufacture [`PutInventoryInput`](crate::input::PutInventoryInput)
    pub fn builder() -> crate::input::put_inventory_input::Builder {
        crate::input::put_inventory_input::Builder::default()
    }
    /// Creates a new `PutInventory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutInventory {
    type Output =
        std::result::Result<crate::output::PutInventoryOutput, crate::error::PutInventoryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_inventory_error(response)
        } else {
            crate::operation_deser::parse_put_inventory_response(response)
        }
    }
}

/// Operation shape for `PutParameter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_parameter`](crate::client::Client::put_parameter).
///
/// See [`crate::client::fluent_builders::PutParameter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutParameter {
    _private: (),
}
impl PutParameter {
    /// Creates a new builder-style object to manufacture [`PutParameterInput`](crate::input::PutParameterInput)
    pub fn builder() -> crate::input::put_parameter_input::Builder {
        crate::input::put_parameter_input::Builder::default()
    }
    /// Creates a new `PutParameter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutParameter {
    type Output =
        std::result::Result<crate::output::PutParameterOutput, crate::error::PutParameterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_parameter_error(response)
        } else {
            crate::operation_deser::parse_put_parameter_response(response)
        }
    }
}

/// Operation shape for `RegisterDefaultPatchBaseline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_default_patch_baseline`](crate::client::Client::register_default_patch_baseline).
///
/// See [`crate::client::fluent_builders::RegisterDefaultPatchBaseline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterDefaultPatchBaseline {
    _private: (),
}
impl RegisterDefaultPatchBaseline {
    /// Creates a new builder-style object to manufacture [`RegisterDefaultPatchBaselineInput`](crate::input::RegisterDefaultPatchBaselineInput)
    pub fn builder() -> crate::input::register_default_patch_baseline_input::Builder {
        crate::input::register_default_patch_baseline_input::Builder::default()
    }
    /// Creates a new `RegisterDefaultPatchBaseline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterDefaultPatchBaseline {
    type Output = std::result::Result<
        crate::output::RegisterDefaultPatchBaselineOutput,
        crate::error::RegisterDefaultPatchBaselineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_default_patch_baseline_error(response)
        } else {
            crate::operation_deser::parse_register_default_patch_baseline_response(response)
        }
    }
}

/// Operation shape for `RegisterPatchBaselineForPatchGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_patch_baseline_for_patch_group`](crate::client::Client::register_patch_baseline_for_patch_group).
///
/// See [`crate::client::fluent_builders::RegisterPatchBaselineForPatchGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterPatchBaselineForPatchGroup {
    _private: (),
}
impl RegisterPatchBaselineForPatchGroup {
    /// Creates a new builder-style object to manufacture [`RegisterPatchBaselineForPatchGroupInput`](crate::input::RegisterPatchBaselineForPatchGroupInput)
    pub fn builder() -> crate::input::register_patch_baseline_for_patch_group_input::Builder {
        crate::input::register_patch_baseline_for_patch_group_input::Builder::default()
    }
    /// Creates a new `RegisterPatchBaselineForPatchGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterPatchBaselineForPatchGroup {
    type Output = std::result::Result<
        crate::output::RegisterPatchBaselineForPatchGroupOutput,
        crate::error::RegisterPatchBaselineForPatchGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_patch_baseline_for_patch_group_error(response)
        } else {
            crate::operation_deser::parse_register_patch_baseline_for_patch_group_response(response)
        }
    }
}

/// Operation shape for `RegisterTargetWithMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_target_with_maintenance_window`](crate::client::Client::register_target_with_maintenance_window).
///
/// See [`crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTargetWithMaintenanceWindow {
    _private: (),
}
impl RegisterTargetWithMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`RegisterTargetWithMaintenanceWindowInput`](crate::input::RegisterTargetWithMaintenanceWindowInput)
    pub fn builder() -> crate::input::register_target_with_maintenance_window_input::Builder {
        crate::input::register_target_with_maintenance_window_input::Builder::default()
    }
    /// Creates a new `RegisterTargetWithMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterTargetWithMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::RegisterTargetWithMaintenanceWindowOutput,
        crate::error::RegisterTargetWithMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_target_with_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_register_target_with_maintenance_window_response(response)
        }
    }
}

/// Operation shape for `RegisterTaskWithMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_task_with_maintenance_window`](crate::client::Client::register_task_with_maintenance_window).
///
/// See [`crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTaskWithMaintenanceWindow {
    _private: (),
}
impl RegisterTaskWithMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`RegisterTaskWithMaintenanceWindowInput`](crate::input::RegisterTaskWithMaintenanceWindowInput)
    pub fn builder() -> crate::input::register_task_with_maintenance_window_input::Builder {
        crate::input::register_task_with_maintenance_window_input::Builder::default()
    }
    /// Creates a new `RegisterTaskWithMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterTaskWithMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::RegisterTaskWithMaintenanceWindowOutput,
        crate::error::RegisterTaskWithMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_task_with_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_register_task_with_maintenance_window_response(response)
        }
    }
}

/// Operation shape for `RemoveTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_resource`](crate::client::Client::remove_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromResource {
    _private: (),
}
impl RemoveTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromResourceOutput,
        crate::error::RemoveTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `ResetServiceSetting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_service_setting`](crate::client::Client::reset_service_setting).
///
/// See [`crate::client::fluent_builders::ResetServiceSetting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetServiceSetting {
    _private: (),
}
impl ResetServiceSetting {
    /// Creates a new builder-style object to manufacture [`ResetServiceSettingInput`](crate::input::ResetServiceSettingInput)
    pub fn builder() -> crate::input::reset_service_setting_input::Builder {
        crate::input::reset_service_setting_input::Builder::default()
    }
    /// Creates a new `ResetServiceSetting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetServiceSetting {
    type Output = std::result::Result<
        crate::output::ResetServiceSettingOutput,
        crate::error::ResetServiceSettingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_service_setting_error(response)
        } else {
            crate::operation_deser::parse_reset_service_setting_response(response)
        }
    }
}

/// Operation shape for `ResumeSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resume_session`](crate::client::Client::resume_session).
///
/// See [`crate::client::fluent_builders::ResumeSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResumeSession {
    _private: (),
}
impl ResumeSession {
    /// Creates a new builder-style object to manufacture [`ResumeSessionInput`](crate::input::ResumeSessionInput)
    pub fn builder() -> crate::input::resume_session_input::Builder {
        crate::input::resume_session_input::Builder::default()
    }
    /// Creates a new `ResumeSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResumeSession {
    type Output =
        std::result::Result<crate::output::ResumeSessionOutput, crate::error::ResumeSessionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resume_session_error(response)
        } else {
            crate::operation_deser::parse_resume_session_response(response)
        }
    }
}

/// Operation shape for `SendAutomationSignal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_automation_signal`](crate::client::Client::send_automation_signal).
///
/// See [`crate::client::fluent_builders::SendAutomationSignal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendAutomationSignal {
    _private: (),
}
impl SendAutomationSignal {
    /// Creates a new builder-style object to manufacture [`SendAutomationSignalInput`](crate::input::SendAutomationSignalInput)
    pub fn builder() -> crate::input::send_automation_signal_input::Builder {
        crate::input::send_automation_signal_input::Builder::default()
    }
    /// Creates a new `SendAutomationSignal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendAutomationSignal {
    type Output = std::result::Result<
        crate::output::SendAutomationSignalOutput,
        crate::error::SendAutomationSignalError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_automation_signal_error(response)
        } else {
            crate::operation_deser::parse_send_automation_signal_response(response)
        }
    }
}

/// Operation shape for `SendCommand`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_command`](crate::client::Client::send_command).
///
/// See [`crate::client::fluent_builders::SendCommand`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendCommand {
    _private: (),
}
impl SendCommand {
    /// Creates a new builder-style object to manufacture [`SendCommandInput`](crate::input::SendCommandInput)
    pub fn builder() -> crate::input::send_command_input::Builder {
        crate::input::send_command_input::Builder::default()
    }
    /// Creates a new `SendCommand` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendCommand {
    type Output =
        std::result::Result<crate::output::SendCommandOutput, crate::error::SendCommandError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_command_error(response)
        } else {
            crate::operation_deser::parse_send_command_response(response)
        }
    }
}

/// Operation shape for `StartAssociationsOnce`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_associations_once`](crate::client::Client::start_associations_once).
///
/// See [`crate::client::fluent_builders::StartAssociationsOnce`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAssociationsOnce {
    _private: (),
}
impl StartAssociationsOnce {
    /// Creates a new builder-style object to manufacture [`StartAssociationsOnceInput`](crate::input::StartAssociationsOnceInput)
    pub fn builder() -> crate::input::start_associations_once_input::Builder {
        crate::input::start_associations_once_input::Builder::default()
    }
    /// Creates a new `StartAssociationsOnce` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAssociationsOnce {
    type Output = std::result::Result<
        crate::output::StartAssociationsOnceOutput,
        crate::error::StartAssociationsOnceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_associations_once_error(response)
        } else {
            crate::operation_deser::parse_start_associations_once_response(response)
        }
    }
}

/// Operation shape for `StartAutomationExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_automation_execution`](crate::client::Client::start_automation_execution).
///
/// See [`crate::client::fluent_builders::StartAutomationExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAutomationExecution {
    _private: (),
}
impl StartAutomationExecution {
    /// Creates a new builder-style object to manufacture [`StartAutomationExecutionInput`](crate::input::StartAutomationExecutionInput)
    pub fn builder() -> crate::input::start_automation_execution_input::Builder {
        crate::input::start_automation_execution_input::Builder::default()
    }
    /// Creates a new `StartAutomationExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAutomationExecution {
    type Output = std::result::Result<
        crate::output::StartAutomationExecutionOutput,
        crate::error::StartAutomationExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_automation_execution_error(response)
        } else {
            crate::operation_deser::parse_start_automation_execution_response(response)
        }
    }
}

/// Operation shape for `StartChangeRequestExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_change_request_execution`](crate::client::Client::start_change_request_execution).
///
/// See [`crate::client::fluent_builders::StartChangeRequestExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartChangeRequestExecution {
    _private: (),
}
impl StartChangeRequestExecution {
    /// Creates a new builder-style object to manufacture [`StartChangeRequestExecutionInput`](crate::input::StartChangeRequestExecutionInput)
    pub fn builder() -> crate::input::start_change_request_execution_input::Builder {
        crate::input::start_change_request_execution_input::Builder::default()
    }
    /// Creates a new `StartChangeRequestExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartChangeRequestExecution {
    type Output = std::result::Result<
        crate::output::StartChangeRequestExecutionOutput,
        crate::error::StartChangeRequestExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_change_request_execution_error(response)
        } else {
            crate::operation_deser::parse_start_change_request_execution_response(response)
        }
    }
}

/// Operation shape for `StartSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_session`](crate::client::Client::start_session).
///
/// See [`crate::client::fluent_builders::StartSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSession {
    _private: (),
}
impl StartSession {
    /// Creates a new builder-style object to manufacture [`StartSessionInput`](crate::input::StartSessionInput)
    pub fn builder() -> crate::input::start_session_input::Builder {
        crate::input::start_session_input::Builder::default()
    }
    /// Creates a new `StartSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSession {
    type Output =
        std::result::Result<crate::output::StartSessionOutput, crate::error::StartSessionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_session_error(response)
        } else {
            crate::operation_deser::parse_start_session_response(response)
        }
    }
}

/// Operation shape for `StopAutomationExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_automation_execution`](crate::client::Client::stop_automation_execution).
///
/// See [`crate::client::fluent_builders::StopAutomationExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopAutomationExecution {
    _private: (),
}
impl StopAutomationExecution {
    /// Creates a new builder-style object to manufacture [`StopAutomationExecutionInput`](crate::input::StopAutomationExecutionInput)
    pub fn builder() -> crate::input::stop_automation_execution_input::Builder {
        crate::input::stop_automation_execution_input::Builder::default()
    }
    /// Creates a new `StopAutomationExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopAutomationExecution {
    type Output = std::result::Result<
        crate::output::StopAutomationExecutionOutput,
        crate::error::StopAutomationExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_automation_execution_error(response)
        } else {
            crate::operation_deser::parse_stop_automation_execution_response(response)
        }
    }
}

/// Operation shape for `TerminateSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_session`](crate::client::Client::terminate_session).
///
/// See [`crate::client::fluent_builders::TerminateSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateSession {
    _private: (),
}
impl TerminateSession {
    /// Creates a new builder-style object to manufacture [`TerminateSessionInput`](crate::input::TerminateSessionInput)
    pub fn builder() -> crate::input::terminate_session_input::Builder {
        crate::input::terminate_session_input::Builder::default()
    }
    /// Creates a new `TerminateSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateSession {
    type Output = std::result::Result<
        crate::output::TerminateSessionOutput,
        crate::error::TerminateSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_session_error(response)
        } else {
            crate::operation_deser::parse_terminate_session_response(response)
        }
    }
}

/// Operation shape for `UnlabelParameterVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unlabel_parameter_version`](crate::client::Client::unlabel_parameter_version).
///
/// See [`crate::client::fluent_builders::UnlabelParameterVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnlabelParameterVersion {
    _private: (),
}
impl UnlabelParameterVersion {
    /// Creates a new builder-style object to manufacture [`UnlabelParameterVersionInput`](crate::input::UnlabelParameterVersionInput)
    pub fn builder() -> crate::input::unlabel_parameter_version_input::Builder {
        crate::input::unlabel_parameter_version_input::Builder::default()
    }
    /// Creates a new `UnlabelParameterVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnlabelParameterVersion {
    type Output = std::result::Result<
        crate::output::UnlabelParameterVersionOutput,
        crate::error::UnlabelParameterVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unlabel_parameter_version_error(response)
        } else {
            crate::operation_deser::parse_unlabel_parameter_version_response(response)
        }
    }
}

/// Operation shape for `UpdateAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_association`](crate::client::Client::update_association).
///
/// See [`crate::client::fluent_builders::UpdateAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssociation {
    _private: (),
}
impl UpdateAssociation {
    /// Creates a new builder-style object to manufacture [`UpdateAssociationInput`](crate::input::UpdateAssociationInput)
    pub fn builder() -> crate::input::update_association_input::Builder {
        crate::input::update_association_input::Builder::default()
    }
    /// Creates a new `UpdateAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssociation {
    type Output = std::result::Result<
        crate::output::UpdateAssociationOutput,
        crate::error::UpdateAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_association_error(response)
        } else {
            crate::operation_deser::parse_update_association_response(response)
        }
    }
}

/// Operation shape for `UpdateAssociationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_association_status`](crate::client::Client::update_association_status).
///
/// See [`crate::client::fluent_builders::UpdateAssociationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssociationStatus {
    _private: (),
}
impl UpdateAssociationStatus {
    /// Creates a new builder-style object to manufacture [`UpdateAssociationStatusInput`](crate::input::UpdateAssociationStatusInput)
    pub fn builder() -> crate::input::update_association_status_input::Builder {
        crate::input::update_association_status_input::Builder::default()
    }
    /// Creates a new `UpdateAssociationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssociationStatus {
    type Output = std::result::Result<
        crate::output::UpdateAssociationStatusOutput,
        crate::error::UpdateAssociationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_association_status_error(response)
        } else {
            crate::operation_deser::parse_update_association_status_response(response)
        }
    }
}

/// Operation shape for `UpdateDocument`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_document`](crate::client::Client::update_document).
///
/// See [`crate::client::fluent_builders::UpdateDocument`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDocument {
    _private: (),
}
impl UpdateDocument {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentInput`](crate::input::UpdateDocumentInput)
    pub fn builder() -> crate::input::update_document_input::Builder {
        crate::input::update_document_input::Builder::default()
    }
    /// Creates a new `UpdateDocument` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDocument {
    type Output =
        std::result::Result<crate::output::UpdateDocumentOutput, crate::error::UpdateDocumentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_document_error(response)
        } else {
            crate::operation_deser::parse_update_document_response(response)
        }
    }
}

/// Operation shape for `UpdateDocumentDefaultVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_document_default_version`](crate::client::Client::update_document_default_version).
///
/// See [`crate::client::fluent_builders::UpdateDocumentDefaultVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDocumentDefaultVersion {
    _private: (),
}
impl UpdateDocumentDefaultVersion {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentDefaultVersionInput`](crate::input::UpdateDocumentDefaultVersionInput)
    pub fn builder() -> crate::input::update_document_default_version_input::Builder {
        crate::input::update_document_default_version_input::Builder::default()
    }
    /// Creates a new `UpdateDocumentDefaultVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDocumentDefaultVersion {
    type Output = std::result::Result<
        crate::output::UpdateDocumentDefaultVersionOutput,
        crate::error::UpdateDocumentDefaultVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_document_default_version_error(response)
        } else {
            crate::operation_deser::parse_update_document_default_version_response(response)
        }
    }
}

/// Operation shape for `UpdateDocumentMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_document_metadata`](crate::client::Client::update_document_metadata).
///
/// See [`crate::client::fluent_builders::UpdateDocumentMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDocumentMetadata {
    _private: (),
}
impl UpdateDocumentMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateDocumentMetadataInput`](crate::input::UpdateDocumentMetadataInput)
    pub fn builder() -> crate::input::update_document_metadata_input::Builder {
        crate::input::update_document_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateDocumentMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDocumentMetadata {
    type Output = std::result::Result<
        crate::output::UpdateDocumentMetadataOutput,
        crate::error::UpdateDocumentMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_document_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_document_metadata_response(response)
        }
    }
}

/// Operation shape for `UpdateMaintenanceWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_maintenance_window`](crate::client::Client::update_maintenance_window).
///
/// See [`crate::client::fluent_builders::UpdateMaintenanceWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMaintenanceWindow {
    _private: (),
}
impl UpdateMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceWindowInput`](crate::input::UpdateMaintenanceWindowInput)
    pub fn builder() -> crate::input::update_maintenance_window_input::Builder {
        crate::input::update_maintenance_window_input::Builder::default()
    }
    /// Creates a new `UpdateMaintenanceWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMaintenanceWindow {
    type Output = std::result::Result<
        crate::output::UpdateMaintenanceWindowOutput,
        crate::error::UpdateMaintenanceWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_maintenance_window_error(response)
        } else {
            crate::operation_deser::parse_update_maintenance_window_response(response)
        }
    }
}

/// Operation shape for `UpdateMaintenanceWindowTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_maintenance_window_target`](crate::client::Client::update_maintenance_window_target).
///
/// See [`crate::client::fluent_builders::UpdateMaintenanceWindowTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMaintenanceWindowTarget {
    _private: (),
}
impl UpdateMaintenanceWindowTarget {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceWindowTargetInput`](crate::input::UpdateMaintenanceWindowTargetInput)
    pub fn builder() -> crate::input::update_maintenance_window_target_input::Builder {
        crate::input::update_maintenance_window_target_input::Builder::default()
    }
    /// Creates a new `UpdateMaintenanceWindowTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMaintenanceWindowTarget {
    type Output = std::result::Result<
        crate::output::UpdateMaintenanceWindowTargetOutput,
        crate::error::UpdateMaintenanceWindowTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_maintenance_window_target_error(response)
        } else {
            crate::operation_deser::parse_update_maintenance_window_target_response(response)
        }
    }
}

/// Operation shape for `UpdateMaintenanceWindowTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_maintenance_window_task`](crate::client::Client::update_maintenance_window_task).
///
/// See [`crate::client::fluent_builders::UpdateMaintenanceWindowTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMaintenanceWindowTask {
    _private: (),
}
impl UpdateMaintenanceWindowTask {
    /// Creates a new builder-style object to manufacture [`UpdateMaintenanceWindowTaskInput`](crate::input::UpdateMaintenanceWindowTaskInput)
    pub fn builder() -> crate::input::update_maintenance_window_task_input::Builder {
        crate::input::update_maintenance_window_task_input::Builder::default()
    }
    /// Creates a new `UpdateMaintenanceWindowTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMaintenanceWindowTask {
    type Output = std::result::Result<
        crate::output::UpdateMaintenanceWindowTaskOutput,
        crate::error::UpdateMaintenanceWindowTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_maintenance_window_task_error(response)
        } else {
            crate::operation_deser::parse_update_maintenance_window_task_response(response)
        }
    }
}

/// Operation shape for `UpdateManagedInstanceRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_managed_instance_role`](crate::client::Client::update_managed_instance_role).
///
/// See [`crate::client::fluent_builders::UpdateManagedInstanceRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateManagedInstanceRole {
    _private: (),
}
impl UpdateManagedInstanceRole {
    /// Creates a new builder-style object to manufacture [`UpdateManagedInstanceRoleInput`](crate::input::UpdateManagedInstanceRoleInput)
    pub fn builder() -> crate::input::update_managed_instance_role_input::Builder {
        crate::input::update_managed_instance_role_input::Builder::default()
    }
    /// Creates a new `UpdateManagedInstanceRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateManagedInstanceRole {
    type Output = std::result::Result<
        crate::output::UpdateManagedInstanceRoleOutput,
        crate::error::UpdateManagedInstanceRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_managed_instance_role_error(response)
        } else {
            crate::operation_deser::parse_update_managed_instance_role_response(response)
        }
    }
}

/// Operation shape for `UpdateOpsItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ops_item`](crate::client::Client::update_ops_item).
///
/// See [`crate::client::fluent_builders::UpdateOpsItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOpsItem {
    _private: (),
}
impl UpdateOpsItem {
    /// Creates a new builder-style object to manufacture [`UpdateOpsItemInput`](crate::input::UpdateOpsItemInput)
    pub fn builder() -> crate::input::update_ops_item_input::Builder {
        crate::input::update_ops_item_input::Builder::default()
    }
    /// Creates a new `UpdateOpsItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOpsItem {
    type Output =
        std::result::Result<crate::output::UpdateOpsItemOutput, crate::error::UpdateOpsItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ops_item_error(response)
        } else {
            crate::operation_deser::parse_update_ops_item_response(response)
        }
    }
}

/// Operation shape for `UpdateOpsMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ops_metadata`](crate::client::Client::update_ops_metadata).
///
/// See [`crate::client::fluent_builders::UpdateOpsMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOpsMetadata {
    _private: (),
}
impl UpdateOpsMetadata {
    /// Creates a new builder-style object to manufacture [`UpdateOpsMetadataInput`](crate::input::UpdateOpsMetadataInput)
    pub fn builder() -> crate::input::update_ops_metadata_input::Builder {
        crate::input::update_ops_metadata_input::Builder::default()
    }
    /// Creates a new `UpdateOpsMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOpsMetadata {
    type Output = std::result::Result<
        crate::output::UpdateOpsMetadataOutput,
        crate::error::UpdateOpsMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ops_metadata_error(response)
        } else {
            crate::operation_deser::parse_update_ops_metadata_response(response)
        }
    }
}

/// Operation shape for `UpdatePatchBaseline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_patch_baseline`](crate::client::Client::update_patch_baseline).
///
/// See [`crate::client::fluent_builders::UpdatePatchBaseline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePatchBaseline {
    _private: (),
}
impl UpdatePatchBaseline {
    /// Creates a new builder-style object to manufacture [`UpdatePatchBaselineInput`](crate::input::UpdatePatchBaselineInput)
    pub fn builder() -> crate::input::update_patch_baseline_input::Builder {
        crate::input::update_patch_baseline_input::Builder::default()
    }
    /// Creates a new `UpdatePatchBaseline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePatchBaseline {
    type Output = std::result::Result<
        crate::output::UpdatePatchBaselineOutput,
        crate::error::UpdatePatchBaselineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_patch_baseline_error(response)
        } else {
            crate::operation_deser::parse_update_patch_baseline_response(response)
        }
    }
}

/// Operation shape for `UpdateResourceDataSync`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource_data_sync`](crate::client::Client::update_resource_data_sync).
///
/// See [`crate::client::fluent_builders::UpdateResourceDataSync`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResourceDataSync {
    _private: (),
}
impl UpdateResourceDataSync {
    /// Creates a new builder-style object to manufacture [`UpdateResourceDataSyncInput`](crate::input::UpdateResourceDataSyncInput)
    pub fn builder() -> crate::input::update_resource_data_sync_input::Builder {
        crate::input::update_resource_data_sync_input::Builder::default()
    }
    /// Creates a new `UpdateResourceDataSync` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResourceDataSync {
    type Output = std::result::Result<
        crate::output::UpdateResourceDataSyncOutput,
        crate::error::UpdateResourceDataSyncError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_data_sync_error(response)
        } else {
            crate::operation_deser::parse_update_resource_data_sync_response(response)
        }
    }
}

/// Operation shape for `UpdateServiceSetting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_setting`](crate::client::Client::update_service_setting).
///
/// See [`crate::client::fluent_builders::UpdateServiceSetting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServiceSetting {
    _private: (),
}
impl UpdateServiceSetting {
    /// Creates a new builder-style object to manufacture [`UpdateServiceSettingInput`](crate::input::UpdateServiceSettingInput)
    pub fn builder() -> crate::input::update_service_setting_input::Builder {
        crate::input::update_service_setting_input::Builder::default()
    }
    /// Creates a new `UpdateServiceSetting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServiceSetting {
    type Output = std::result::Result<
        crate::output::UpdateServiceSettingOutput,
        crate::error::UpdateServiceSettingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_setting_error(response)
        } else {
            crate::operation_deser::parse_update_service_setting_response(response)
        }
    }
}
