// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceTypeForTagging>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the type of resource you are tagging.</p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed
        /// nodes. You must specify the name of the managed node in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn resource_type(mut self, input: crate::model::ResourceTypeForTagging) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Specifies the type of resource you are tagging.</p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed
        /// nodes. You must specify the name of the managed node in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceTypeForTagging>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The resource ID you want to tag.</p>
        /// <p>Use the ID of the resource. Here are some examples:</p>
        /// <p>
        /// <code>MaintenanceWindow</code>: <code>mw-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>PatchBaseline</code>: <code>pb-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the
        /// Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from
        /// the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an
        /// OpsMetadata object with an ARN of
        /// <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a
        /// <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or
        /// <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the
        /// resource.</p>
        /// <p>
        /// <code>ManagedInstance</code>: <code>mi-012345abcde</code>
        /// </p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises
        /// managed nodes. You must specify the name of the managed node in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID you want to tag.</p>
        /// <p>Use the ID of the resource. Here are some examples:</p>
        /// <p>
        /// <code>MaintenanceWindow</code>: <code>mw-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>PatchBaseline</code>: <code>pb-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the
        /// Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from
        /// the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an
        /// OpsMetadata object with an ARN of
        /// <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a
        /// <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or
        /// <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the
        /// resource.</p>
        /// <p>
        /// <code>ManagedInstance</code>: <code>mi-012345abcde</code>
        /// </p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises
        /// managed nodes. You must specify the name of the managed node in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. The value parameter is required.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags. The value parameter is required.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.AddTagsToResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`AssociateOpsItemRelatedItemInput`](crate::input::AssociateOpsItemRelatedItemInput)
pub mod associate_ops_item_related_item_input {
    /// A builder for [`AssociateOpsItemRelatedItemInput`](crate::input::AssociateOpsItemRelatedItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) association_type: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// <p>The type of association that you want to create between an OpsItem and a resource. OpsCenter
        /// supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>
        pub fn association_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_type = Some(input.into());
            self
        }
        /// <p>The type of association that you want to create between an OpsItem and a resource. OpsCenter
        /// supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// <p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the
        /// following types:</p>
        /// <p>
        /// <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p>
        /// <p>
        /// <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the
        /// following types:</p>
        /// <p>
        /// <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p>
        /// <p>
        /// <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the
        /// OpsItem.</p>
        pub fn resource_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_uri = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the
        /// OpsItem.</p>
        pub fn set_resource_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateOpsItemRelatedItemInput`](crate::input::AssociateOpsItemRelatedItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateOpsItemRelatedItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateOpsItemRelatedItemInput {
                ops_item_id: self.ops_item_id,
                association_type: self.association_type,
                resource_type: self.resource_type,
                resource_uri: self.resource_uri,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateOpsItemRelatedItemInputOperationOutputAlias =
    crate::operation::AssociateOpsItemRelatedItem;
#[doc(hidden)]
pub type AssociateOpsItemRelatedItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateOpsItemRelatedItemInput {
    /// Consumes the builder and constructs an Operation<[`AssociateOpsItemRelatedItem`](crate::operation::AssociateOpsItemRelatedItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateOpsItemRelatedItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateOpsItemRelatedItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateOpsItemRelatedItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateOpsItemRelatedItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.AssociateOpsItemRelatedItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_ops_item_related_item(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateOpsItemRelatedItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateOpsItemRelatedItem",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateOpsItemRelatedItemInput`](crate::input::AssociateOpsItemRelatedItemInput)
    pub fn builder() -> crate::input::associate_ops_item_related_item_input::Builder {
        crate::input::associate_ops_item_related_item_input::Builder::default()
    }
}

/// See [`CancelCommandInput`](crate::input::CancelCommandInput)
pub mod cancel_command_input {
    /// A builder for [`CancelCommandInput`](crate::input::CancelCommandInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the command you want to cancel.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>The ID of the command you want to cancel.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>(Optional) A list of managed node IDs on which you want to cancel the command. If not provided,
        /// the command is canceled on every node on which it was requested.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>(Optional) A list of managed node IDs on which you want to cancel the command. If not provided,
        /// the command is canceled on every node on which it was requested.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelCommandInput`](crate::input::CancelCommandInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelCommandInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelCommandInput {
                command_id: self.command_id,
                instance_ids: self.instance_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelCommandInputOperationOutputAlias = crate::operation::CancelCommand;
#[doc(hidden)]
pub type CancelCommandInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelCommandInput {
    /// Consumes the builder and constructs an Operation<[`CancelCommand`](crate::operation::CancelCommand)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelCommand,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelCommandInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelCommandInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelCommandInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CancelCommand",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_cancel_command(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelCommand::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelCommand",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelCommandInput`](crate::input::CancelCommandInput)
    pub fn builder() -> crate::input::cancel_command_input::Builder {
        crate::input::cancel_command_input::Builder::default()
    }
}

/// See [`CancelMaintenanceWindowExecutionInput`](crate::input::CancelMaintenanceWindowExecutionInput)
pub mod cancel_maintenance_window_execution_input {
    /// A builder for [`CancelMaintenanceWindowExecutionInput`](crate::input::CancelMaintenanceWindowExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution to stop.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution to stop.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelMaintenanceWindowExecutionInput`](crate::input::CancelMaintenanceWindowExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelMaintenanceWindowExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelMaintenanceWindowExecutionInput {
                window_execution_id: self.window_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelMaintenanceWindowExecutionInputOperationOutputAlias =
    crate::operation::CancelMaintenanceWindowExecution;
#[doc(hidden)]
pub type CancelMaintenanceWindowExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelMaintenanceWindowExecutionInput {
    /// Consumes the builder and constructs an Operation<[`CancelMaintenanceWindowExecution`](crate::operation::CancelMaintenanceWindowExecution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelMaintenanceWindowExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelMaintenanceWindowExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelMaintenanceWindowExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelMaintenanceWindowExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CancelMaintenanceWindowExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_maintenance_window_execution(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelMaintenanceWindowExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelMaintenanceWindowExecution",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelMaintenanceWindowExecutionInput`](crate::input::CancelMaintenanceWindowExecutionInput)
    pub fn builder() -> crate::input::cancel_maintenance_window_execution_input::Builder {
        crate::input::cancel_maintenance_window_execution_input::Builder::default()
    }
}

/// See [`CreateActivationInput`](crate::input::CreateActivationInput)
pub mod create_activation_input {
    /// A builder for [`CreateActivationInput`](crate::input::CreateActivationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_instance_name: std::option::Option<std::string::String>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) registration_limit: std::option::Option<i32>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) registration_metadata:
            std::option::Option<std::vec::Vec<crate::model::RegistrationMetadataItem>>,
    }
    impl Builder {
        /// <p>A user-defined description of the resource that you want to register with Systems Manager. </p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A user-defined description of the resource that you want to register with Systems Manager. </p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when
        /// you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn default_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_instance_name = Some(input.into());
            self
        }
        /// <p>The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or when
        /// you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_default_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_instance_name = input;
            self
        }
        /// <p>The name of the Identity and Access Management (IAM) role that you want to assign to
        /// the managed node. This IAM role must provide AssumeRole permissions for the
        /// Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an
        /// IAM service role for a hybrid environment</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The name of the Identity and Access Management (IAM) role that you want to assign to
        /// the managed node. This IAM role must provide AssumeRole permissions for the
        /// Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an
        /// IAM service role for a hybrid environment</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// <p>Specify the maximum number of managed nodes you want to register. The default value is
        /// <code>1</code>.</p>
        pub fn registration_limit(mut self, input: i32) -> Self {
            self.registration_limit = Some(input);
            self
        }
        /// <p>Specify the maximum number of managed nodes you want to register. The default value is
        /// <code>1</code>.</p>
        pub fn set_registration_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.registration_limit = input;
            self
        }
        /// <p>The date by which this activation request should expire, in timestamp format, such as
        /// "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an
        /// expiration date, the activation code expires in 24 hours.</p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>The date by which this activation request should expire, in timestamp format, such as
        /// "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an
        /// expiration date, the activation code expires in 24 hours.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// activation to identify which servers or virtual machines (VMs) in your on-premises environment
        /// you intend to activate. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID
        /// and code. When you specify the activation ID and code, tags assigned to the activation are
        /// automatically applied to the on-premises servers or VMs.</p>
        /// </important>
        /// <p>You can't add tags to or delete tags from an existing activation. You can tag your
        /// on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a
        /// managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
        /// prefixed with "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes,
        /// see <a>RemoveTagsFromResource</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// activation to identify which servers or virtual machines (VMs) in your on-premises environment
        /// you intend to activate. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID
        /// and code. When you specify the activation ID and code, tags assigned to the activation are
        /// automatically applied to the on-premises servers or VMs.</p>
        /// </important>
        /// <p>You can't add tags to or delete tags from an existing activation. You can tag your
        /// on-premises servers, edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a
        /// managed node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
        /// prefixed with "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes,
        /// see <a>RemoveTagsFromResource</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `registration_metadata`.
        ///
        /// To override the contents of this collection use [`set_registration_metadata`](Self::set_registration_metadata).
        ///
        /// <p>Reserved for internal use.</p>
        pub fn registration_metadata(
            mut self,
            input: impl Into<crate::model::RegistrationMetadataItem>,
        ) -> Self {
            let mut v = self.registration_metadata.unwrap_or_default();
            v.push(input.into());
            self.registration_metadata = Some(v);
            self
        }
        /// <p>Reserved for internal use.</p>
        pub fn set_registration_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegistrationMetadataItem>>,
        ) -> Self {
            self.registration_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateActivationInput`](crate::input::CreateActivationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateActivationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateActivationInput {
                description: self.description,
                default_instance_name: self.default_instance_name,
                iam_role: self.iam_role,
                registration_limit: self.registration_limit,
                expiration_date: self.expiration_date,
                tags: self.tags,
                registration_metadata: self.registration_metadata,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateActivationInputOperationOutputAlias = crate::operation::CreateActivation;
#[doc(hidden)]
pub type CreateActivationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateActivationInput {
    /// Consumes the builder and constructs an Operation<[`CreateActivation`](crate::operation::CreateActivation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateActivation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateActivationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateActivationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateActivationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateActivation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_activation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateActivation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateActivation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateActivationInput`](crate::input::CreateActivationInput)
    pub fn builder() -> crate::input::create_activation_input::Builder {
        crate::input::create_activation_input::Builder::default()
    }
}

/// See [`CreateAssociationInput`](crate::input::CreateAssociationInput)
pub mod create_association_input {
    /// A builder for [`CreateAssociationInput`](crate::input::CreateAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) output_location:
            std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        pub(crate) association_name: std::option::Option<std::string::String>,
        pub(crate) automation_target_parameter_name: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) compliance_severity:
            std::option::Option<crate::model::AssociationComplianceSeverity>,
        pub(crate) sync_compliance: std::option::Option<crate::model::AssociationSyncCompliance>,
        pub(crate) apply_only_at_cron_interval: std::option::Option<bool>,
        pub(crate) calendar_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_locations:
            std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
    }
    impl Builder {
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration
        /// information for the managed node.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
        /// shared with you from another account.</p>
        /// <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you
        /// must specify the complete SSM document ARN, in the following format:</p>
        /// <p>
        /// <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i>
        /// </code>
        /// </p>
        /// <p>For example:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
        /// </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
        /// to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
        /// <code>My-Document</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration
        /// information for the managed node.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
        /// shared with you from another account.</p>
        /// <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you
        /// must specify the complete SSM document ARN, in the following format:</p>
        /// <p>
        /// <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i>
        /// </code>
        /// </p>
        /// <p>For example:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
        /// </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
        /// to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
        /// <code>My-Document</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The document version you want to associate with the target(s). Can be a specific version or
        /// the default version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version you want to associate with the target(s). Can be a specific version or
        /// the default version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The managed node ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the runtime configuration of the document.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameters for the runtime configuration of the document.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource
        /// groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all
        /// managed nodes in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of
        /// <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets for the association. You can target managed nodes by using tags, Amazon Web Services resource
        /// groups, all managed nodes in an Amazon Web Services account, or individual managed node IDs. You can target all
        /// managed nodes in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of
        /// <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>A cron expression when the association will be applied to the target(s).</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A cron expression when the association will be applied to the target(s).</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output
        /// details of the request.</p>
        pub fn output_location(
            mut self,
            input: crate::model::InstanceAssociationOutputLocation,
        ) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output
        /// details of the request.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>Specify a descriptive name for the association.</p>
        pub fn association_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_name = Some(input.into());
            self
        }
        /// <p>Specify a descriptive name for the association.</p>
        pub fn set_association_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_name = input;
            self
        }
        /// <p>Choose the parameter that will define how your automation will branch out. This target is
        /// required for associations that use an Automation runbook and target resources by using rate
        /// controls. Automation is a capability of Amazon Web Services Systems Manager.</p>
        pub fn automation_target_parameter_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.automation_target_parameter_name = Some(input.into());
            self
        }
        /// <p>Choose the parameter that will define how your automation will branch out. This target is
        /// required for associations that use an Automation runbook and target resources by using rate
        /// controls. Automation is a capability of Amazon Web Services Systems Manager.</p>
        pub fn set_automation_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automation_target_parameter_name = input;
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request
        /// when the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request
        /// when the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new managed node starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new managed node will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new managed node starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new managed node will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn compliance_severity(
            mut self,
            input: crate::model::AssociationComplianceSeverity,
        ) -> Self {
            self.compliance_severity = Some(input);
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn set_compliance_severity(
            mut self,
            input: std::option::Option<crate::model::AssociationComplianceSeverity>,
        ) -> Self {
            self.compliance_severity = input;
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn sync_compliance(mut self, input: crate::model::AssociationSyncCompliance) -> Self {
            self.sync_compliance = Some(input);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn set_sync_compliance(
            mut self,
            input: std::option::Option<crate::model::AssociationSyncCompliance>,
        ) -> Self {
            self.sync_compliance = input;
            self
        }
        /// <p>By default, when you create a new association, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn apply_only_at_cron_interval(mut self, input: bool) -> Self {
            self.apply_only_at_cron_interval = Some(input);
            self
        }
        /// <p>By default, when you create a new association, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn set_apply_only_at_cron_interval(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_only_at_cron_interval = input;
            self
        }
        /// Appends an item to `calendar_names`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
        /// gate your associations under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn calendar_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.calendar_names.unwrap_or_default();
            v.push(input.into());
            self.calendar_names = Some(v);
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
        /// gate your associations under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.calendar_names = input;
            self
        }
        /// Appends an item to `target_locations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association. Use this action to create an association in multiple Regions and multiple
        /// accounts.</p>
        pub fn target_locations(mut self, input: impl Into<crate::model::TargetLocation>) -> Self {
            let mut v = self.target_locations.unwrap_or_default();
            v.push(input.into());
            self.target_locations = Some(v);
            self
        }
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association. Use this action to create an association in multiple Regions and multiple
        /// accounts.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.target_locations = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssociationInput`](crate::input::CreateAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssociationInput {
                name: self.name,
                document_version: self.document_version,
                instance_id: self.instance_id,
                parameters: self.parameters,
                targets: self.targets,
                schedule_expression: self.schedule_expression,
                output_location: self.output_location,
                association_name: self.association_name,
                automation_target_parameter_name: self.automation_target_parameter_name,
                max_errors: self.max_errors,
                max_concurrency: self.max_concurrency,
                compliance_severity: self.compliance_severity,
                sync_compliance: self.sync_compliance,
                apply_only_at_cron_interval: self.apply_only_at_cron_interval.unwrap_or_default(),
                calendar_names: self.calendar_names,
                target_locations: self.target_locations,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssociationInputOperationOutputAlias = crate::operation::CreateAssociation;
#[doc(hidden)]
pub type CreateAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssociationInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssociation`](crate::operation::CreateAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_association(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssociation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssociationInput`](crate::input::CreateAssociationInput)
    pub fn builder() -> crate::input::create_association_input::Builder {
        crate::input::create_association_input::Builder::default()
    }
}

/// See [`CreateAssociationBatchInput`](crate::input::CreateAssociationBatchInput)
pub mod create_association_batch_input {
    /// A builder for [`CreateAssociationBatchInput`](crate::input::CreateAssociationBatchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::CreateAssociationBatchRequestEntry>>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>One or more associations.</p>
        pub fn entries(
            mut self,
            input: impl Into<crate::model::CreateAssociationBatchRequestEntry>,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>One or more associations.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssociationBatchRequestEntry>,
            >,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssociationBatchInput`](crate::input::CreateAssociationBatchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssociationBatchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssociationBatchInput {
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssociationBatchInputOperationOutputAlias = crate::operation::CreateAssociationBatch;
#[doc(hidden)]
pub type CreateAssociationBatchInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssociationBatchInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssociationBatch`](crate::operation::CreateAssociationBatch)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssociationBatch,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssociationBatchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssociationBatchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssociationBatchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateAssociationBatch",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_association_batch(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssociationBatch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssociationBatch",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssociationBatchInput`](crate::input::CreateAssociationBatchInput)
    pub fn builder() -> crate::input::create_association_batch_input::Builder {
        crate::input::create_association_batch_input::Builder::default()
    }
}

/// See [`CreateDocumentInput`](crate::input::CreateDocumentInput)
pub mod create_document_input {
    /// A builder for [`CreateDocumentInput`](crate::input::CreateDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) requires: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        pub(crate) attachments: std::option::Option<std::vec::Vec<crate::model::AttachmentsSource>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) document_type: std::option::Option<crate::model::DocumentType>,
        pub(crate) document_format: std::option::Option<crate::model::DocumentFormat>,
        pub(crate) target_type: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The content for the new SSM document in JSON or YAML format. We recommend storing the
        /// contents for your new document in an external JSON or YAML file and referencing the file in a
        /// command.</p>
        /// <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content for the new SSM document in JSON or YAML format. We recommend storing the
        /// contents for your new document in an external JSON or YAML file and referencing the file in a
        /// command.</p>
        /// <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Appends an item to `requires`.
        ///
        /// To override the contents of this collection use [`set_requires`](Self::set_requires).
        ///
        /// <p>A list of SSM documents required by a document. This parameter is used exclusively by
        /// AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also
        /// specify a required document for validation purposes. In this case, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document for validation purposes. For more
        /// information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the
        /// <i>AppConfig User Guide</i>.</p>
        pub fn requires(mut self, input: impl Into<crate::model::DocumentRequires>) -> Self {
            let mut v = self.requires.unwrap_or_default();
            v.push(input.into());
            self.requires = Some(v);
            self
        }
        /// <p>A list of SSM documents required by a document. This parameter is used exclusively by
        /// AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also
        /// specify a required document for validation purposes. In this case, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document for validation purposes. For more
        /// information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the
        /// <i>AppConfig User Guide</i>.</p>
        pub fn set_requires(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        ) -> Self {
            self.requires = input;
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn attachments(mut self, input: impl Into<crate::model::AttachmentsSource>) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input.into());
            self.attachments = Some(v);
            self
        }
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentsSource>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// <p>A name for the SSM document.</p>
        /// <important>
        /// <p>You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services
        /// for use as document name prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aws-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amzn</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the SSM document.</p>
        /// <important>
        /// <p>You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services
        /// for use as document name prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aws-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amzn</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can
        /// differ for each version of the document. You can update this value at a later time using the
        /// <a>UpdateDocument</a> operation.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can
        /// differ for each version of the document. You can update this value at a later time using the
        /// <a>UpdateDocument</a> operation.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>An optional field specifying the version of the artifact you are creating with the document.
        /// For example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>An optional field specifying the version of the artifact you are creating with the document.
        /// For example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>The type of document to create.</p>
        pub fn document_type(mut self, input: crate::model::DocumentType) -> Self {
            self.document_type = Some(input);
            self
        }
        /// <p>The type of document to create.</p>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<crate::model::DocumentType>,
        ) -> Self {
            self.document_type = input;
            self
        }
        /// <p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT.
        /// JSON is the default format.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.document_format = Some(input);
            self
        }
        /// <p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT.
        /// JSON is the default format.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.document_format = input;
            self
        }
        /// <p>Specify a target type to define the kinds of resources the document can run on. For example,
        /// to run a document on EC2 instances, specify the following value:
        /// <code>/AWS::EC2::Instance</code>. If you specify a value of '/' the document can run on all types
        /// of resources. If you don't specify a value, the document can't run on any resources. For a list
        /// of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn target_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_type = Some(input.into());
            self
        }
        /// <p>Specify a target type to define the kinds of resources the document can run on. For example,
        /// to run a document on EC2 instances, specify the following value:
        /// <code>/AWS::EC2::Instance</code>. If you specify a value of '/' the document can run on all types
        /// of resources. If you don't specify a value, the document can't run on any resources. For a list
        /// of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// SSM document to identify the types of targets or the environment where it will run. In this case,
        /// you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing SSM document, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// SSM document to identify the types of targets or the environment where it will run. In this case,
        /// you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing SSM document, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDocumentInput`](crate::input::CreateDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDocumentInput {
                content: self.content,
                requires: self.requires,
                attachments: self.attachments,
                name: self.name,
                display_name: self.display_name,
                version_name: self.version_name,
                document_type: self.document_type,
                document_format: self.document_format,
                target_type: self.target_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDocumentInputOperationOutputAlias = crate::operation::CreateDocument;
#[doc(hidden)]
pub type CreateDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDocumentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDocument`](crate::operation::CreateDocument)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_document(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDocument",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDocumentInput`](crate::input::CreateDocumentInput)
    pub fn builder() -> crate::input::create_document_input::Builder {
        crate::input::create_document_input::Builder::default()
    }
}

/// See [`CreateMaintenanceWindowInput`](crate::input::CreateMaintenanceWindowInput)
pub mod create_maintenance_window_input {
    /// A builder for [`CreateMaintenanceWindowInput`](crate::input::CreateMaintenanceWindowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) schedule_timezone: std::option::Option<std::string::String>,
        pub(crate) schedule_offset: std::option::Option<i32>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) cutoff: std::option::Option<i32>,
        pub(crate) allow_unassociated_targets: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the maintenance window.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description for the maintenance window. We recommend specifying a description to
        /// help you organize your maintenance windows. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the maintenance window. We recommend specifying a description to
        /// help you organize your maintenance windows. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become active. <code>StartDate</code> allows you to delay activation of the maintenance window
        /// until the specified future date.</p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become active. <code>StartDate</code> allows you to delay activation of the maintenance window
        /// until the specified future date.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become inactive. <code>EndDate</code> allows you to set a date and time in the future when the
        /// maintenance window will no longer run.</p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become inactive. <code>EndDate</code> allows you to set a date and time in the future when the
        /// maintenance window will no longer run.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn schedule_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_timezone = Some(input.into());
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn set_schedule_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_timezone = input;
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before
        /// running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run on the
        /// third Tuesday of every month at 11:30 PM.</p>
        /// <p>
        /// <code>cron(30 23 ? * TUE#3 *)</code>
        /// </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days
        /// later.</p>
        pub fn schedule_offset(mut self, input: i32) -> Self {
            self.schedule_offset = Some(input);
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before
        /// running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run on the
        /// third Tuesday of every month at 11:30 PM.</p>
        /// <p>
        /// <code>cron(30 23 ? * TUE#3 *)</code>
        /// </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days
        /// later.</p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.schedule_offset = input;
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
        /// new tasks for execution.</p>
        pub fn cutoff(mut self, input: i32) -> Self {
            self.cutoff = Some(input);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
        /// new tasks for execution.</p>
        pub fn set_cutoff(mut self, input: std::option::Option<i32>) -> Self {
            self.cutoff = input;
            self
        }
        /// <p>Enables a maintenance window task to run on managed nodes, even if you haven't registered
        /// those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by
        /// node ID) when you register a task with the maintenance window.</p>
        /// <p>If you don't enable this option, then you must specify previously-registered targets when
        /// you register a task with the maintenance window.</p>
        pub fn allow_unassociated_targets(mut self, input: bool) -> Self {
            self.allow_unassociated_targets = Some(input);
            self
        }
        /// <p>Enables a maintenance window task to run on managed nodes, even if you haven't registered
        /// those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by
        /// node ID) when you register a task with the maintenance window.</p>
        /// <p>If you don't enable this option, then you must specify previously-registered targets when
        /// you register a task with the maintenance window.</p>
        pub fn set_allow_unassociated_targets(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_unassociated_targets = input;
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// maintenance window to identify the type of tasks it will run, the types of targets, and the
        /// environment it will run in. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=TaskType,Value=AgentUpdate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing maintenance window, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// maintenance window to identify the type of tasks it will run, the types of targets, and the
        /// environment it will run in. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=TaskType,Value=AgentUpdate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing maintenance window, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMaintenanceWindowInput`](crate::input::CreateMaintenanceWindowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMaintenanceWindowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMaintenanceWindowInput {
                name: self.name,
                description: self.description,
                start_date: self.start_date,
                end_date: self.end_date,
                schedule: self.schedule,
                schedule_timezone: self.schedule_timezone,
                schedule_offset: self.schedule_offset,
                duration: self.duration.unwrap_or_default(),
                cutoff: self.cutoff.unwrap_or_default(),
                allow_unassociated_targets: self.allow_unassociated_targets.unwrap_or_default(),
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMaintenanceWindowInputOperationOutputAlias =
    crate::operation::CreateMaintenanceWindow;
#[doc(hidden)]
pub type CreateMaintenanceWindowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMaintenanceWindowInput {
    /// Consumes the builder and constructs an Operation<[`CreateMaintenanceWindow`](crate::operation::CreateMaintenanceWindow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMaintenanceWindow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMaintenanceWindowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMaintenanceWindowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMaintenanceWindowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateMaintenanceWindow",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_maintenance_window(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMaintenanceWindow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMaintenanceWindow",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMaintenanceWindowInput`](crate::input::CreateMaintenanceWindowInput)
    pub fn builder() -> crate::input::create_maintenance_window_input::Builder {
        crate::input::create_maintenance_window_input::Builder::default()
    }
}

/// See [`CreateOpsItemInput`](crate::input::CreateOpsItemInput)
pub mod create_ops_item_input {
    /// A builder for [`CreateOpsItemInput`](crate::input::CreateOpsItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ops_item_type: std::option::Option<std::string::String>,
        pub(crate) operational_data: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
        >,
        pub(crate) notifications:
            std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) related_ops_items:
            std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<std::string::String>,
        pub(crate) actual_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) actual_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) planned_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) planned_end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Information about the OpsItem. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Information about the OpsItem. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of OpsItem to create. Currently, the only valid values are
        /// <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>
        pub fn ops_item_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_type = Some(input.into());
            self
        }
        /// <p>The type of OpsItem to create. Currently, the only valid values are
        /// <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>
        pub fn set_ops_item_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_item_type = input;
            self
        }
        /// Adds a key-value pair to `operational_data`.
        ///
        /// To override the contents of this collection use [`set_operational_data`](Self::set_operational_data).
        ///
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn operational_data(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OpsItemDataValue>,
        ) -> Self {
            let mut hash_map = self.operational_data.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.operational_data = Some(hash_map);
            self
        }
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_operational_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
            >,
        ) -> Self {
            self.operational_data = input;
            self
        }
        /// Appends an item to `notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
        /// OpsItem is edited or changed.</p>
        pub fn notifications(
            mut self,
            input: impl Into<crate::model::OpsItemNotification>,
        ) -> Self {
            let mut v = self.notifications.unwrap_or_default();
            v.push(input.into());
            self.notifications = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
        /// OpsItem is edited or changed.</p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
        ) -> Self {
            self.notifications = input;
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Appends an item to `related_ops_items`.
        ///
        /// To override the contents of this collection use [`set_related_ops_items`](Self::set_related_ops_items).
        ///
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn related_ops_items(mut self, input: impl Into<crate::model::RelatedOpsItem>) -> Self {
            let mut v = self.related_ops_items.unwrap_or_default();
            v.push(input.into());
            self.related_ops_items = Some(v);
            self
        }
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn set_related_ops_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
        ) -> Self {
            self.related_ops_items = input;
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p>
        /// <note>
        /// <p>The source name can't contain the following strings: <code>aws</code>, <code>amazon</code>,
        /// and <code>amzn</code>. </p>
        /// </note>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p>
        /// <note>
        /// <p>The source name can't contain the following strings: <code>aws</code>, <code>amazon</code>,
        /// and <code>amzn</code>. </p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by
        /// using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>Tags use a key-value pair. For example:</p>
        /// <p>
        /// <code>Key=Department,Value=Finance</code>
        /// </p>
        /// <important>
        /// <p>To add tags to a new OpsItem, a user must have IAM permissions for both the
        /// <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation.
        /// To add tags to an existing OpsItem, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </important>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by
        /// using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>Tags use a key-value pair. For example:</p>
        /// <p>
        /// <code>Key=Department,Value=Finance</code>
        /// </p>
        /// <important>
        /// <p>To add tags to a new OpsItem, a user must have IAM permissions for both the
        /// <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation.
        /// To add tags to an existing OpsItem, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specify a category to assign to an OpsItem. </p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>Specify a category to assign to an OpsItem. </p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// <p>Specify a severity to assign to an OpsItem.</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity = Some(input.into());
            self
        }
        /// <p>Specify a severity to assign to an OpsItem.</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.actual_start_time = Some(input);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.actual_start_time = input;
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.actual_end_time = Some(input);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.actual_end_time = input;
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.planned_start_time = Some(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.planned_start_time = input;
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.planned_end_time = Some(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.planned_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOpsItemInput`](crate::input::CreateOpsItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOpsItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOpsItemInput {
                description: self.description,
                ops_item_type: self.ops_item_type,
                operational_data: self.operational_data,
                notifications: self.notifications,
                priority: self.priority,
                related_ops_items: self.related_ops_items,
                source: self.source,
                title: self.title,
                tags: self.tags,
                category: self.category,
                severity: self.severity,
                actual_start_time: self.actual_start_time,
                actual_end_time: self.actual_end_time,
                planned_start_time: self.planned_start_time,
                planned_end_time: self.planned_end_time,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOpsItemInputOperationOutputAlias = crate::operation::CreateOpsItem;
#[doc(hidden)]
pub type CreateOpsItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateOpsItemInput {
    /// Consumes the builder and constructs an Operation<[`CreateOpsItem`](crate::operation::CreateOpsItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOpsItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateOpsItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateOpsItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateOpsItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateOpsItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_ops_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOpsItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOpsItem",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateOpsItemInput`](crate::input::CreateOpsItemInput)
    pub fn builder() -> crate::input::create_ops_item_input::Builder {
        crate::input::create_ops_item_input::Builder::default()
    }
}

/// See [`CreateOpsMetadataInput`](crate::input::CreateOpsMetadataInput)
pub mod create_ops_metadata_input {
    /// A builder for [`CreateOpsMetadataInput`](crate::input::CreateOpsMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
        >,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A resource ID for a new Application Manager application.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>A resource ID for a new Application Manager application.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>Metadata for a new Application Manager application. </p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MetadataValue>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>Metadata for a new Application Manager application. </p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by
        /// purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to
        /// identify an environment or target Amazon Web Services Region. In this case, you could specify the following
        /// key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Region,Value=us-east-2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by
        /// purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to
        /// identify an environment or target Amazon Web Services Region. In this case, you could specify the following
        /// key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Region,Value=us-east-2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOpsMetadataInput`](crate::input::CreateOpsMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOpsMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOpsMetadataInput {
                resource_id: self.resource_id,
                metadata: self.metadata,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOpsMetadataInputOperationOutputAlias = crate::operation::CreateOpsMetadata;
#[doc(hidden)]
pub type CreateOpsMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateOpsMetadataInput {
    /// Consumes the builder and constructs an Operation<[`CreateOpsMetadata`](crate::operation::CreateOpsMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOpsMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateOpsMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateOpsMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateOpsMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateOpsMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_ops_metadata(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOpsMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOpsMetadata",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateOpsMetadataInput`](crate::input::CreateOpsMetadataInput)
    pub fn builder() -> crate::input::create_ops_metadata_input::Builder {
        crate::input::create_ops_metadata_input::Builder::default()
    }
}

/// See [`CreatePatchBaselineInput`](crate::input::CreatePatchBaselineInput)
pub mod create_patch_baseline_input {
    /// A builder for [`CreatePatchBaselineInput`](crate::input::CreatePatchBaselineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) global_filters: std::option::Option<crate::model::PatchFilterGroup>,
        pub(crate) approval_rules: std::option::Option<crate::model::PatchRuleGroup>,
        pub(crate) approved_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) approved_patches_compliance_level:
            std::option::Option<crate::model::PatchComplianceLevel>,
        pub(crate) approved_patches_enable_non_security: std::option::Option<bool>,
        pub(crate) rejected_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rejected_patches_action: std::option::Option<crate::model::PatchAction>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Defines the operating system the patch baseline applies to. The default value is
        /// <code>WINDOWS</code>.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Defines the operating system the patch baseline applies to. The default value is
        /// <code>WINDOWS</code>.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn global_filters(mut self, input: crate::model::PatchFilterGroup) -> Self {
            self.global_filters = Some(input);
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn set_global_filters(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.global_filters = input;
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn approval_rules(mut self, input: crate::model::PatchRuleGroup) -> Self {
            self.approval_rules = Some(input);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<crate::model::PatchRuleGroup>,
        ) -> Self {
            self.approval_rules = input;
            self
        }
        /// Appends an item to `approved_patches`.
        ///
        /// To override the contents of this collection use [`set_approved_patches`](Self::set_approved_patches).
        ///
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn approved_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.approved_patches.unwrap_or_default();
            v.push(input.into());
            self.approved_patches = Some(v);
            self
        }
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_approved_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approved_patches = input;
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as
        /// missing, this value describes the severity of the compliance violation. The default value is
        /// <code>UNSPECIFIED</code>.</p>
        pub fn approved_patches_compliance_level(
            mut self,
            input: crate::model::PatchComplianceLevel,
        ) -> Self {
            self.approved_patches_compliance_level = Some(input);
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as
        /// missing, this value describes the severity of the compliance violation. The default value is
        /// <code>UNSPECIFIED</code>.</p>
        pub fn set_approved_patches_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.approved_patches_compliance_level = input;
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed
        /// nodes only.</p>
        pub fn approved_patches_enable_non_security(mut self, input: bool) -> Self {
            self.approved_patches_enable_non_security = Some(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the managed nodes. The default value is <code>false</code>. Applies to Linux managed
        /// nodes only.</p>
        pub fn set_approved_patches_enable_non_security(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.approved_patches_enable_non_security = input;
            self
        }
        /// Appends an item to `rejected_patches`.
        ///
        /// To override the contents of this collection use [`set_rejected_patches`](Self::set_rejected_patches).
        ///
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn rejected_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rejected_patches.unwrap_or_default();
            v.push(input.into());
            self.rejected_patches = Some(v);
            self
        }
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_rejected_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rejected_patches = input;
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ALLOW_AS_DEPENDENCY</code>
        /// </b>: A package in the
        /// <code>Rejected</code> patches list is installed only if it is a dependency of another package.
        /// It is considered compliant with the patch baseline, and its status is reported as
        /// <code>InstalledOther</code>. This is the default action if no option is specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BLOCK</code>
        /// </b>: Packages in the
        /// <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't
        /// installed under any circumstances. If a package was installed before it was added to the
        /// Rejected patches list, it is considered non-compliant with the patch baseline, and its status
        /// is reported as <code>InstalledRejected</code>.</p>
        /// </li>
        /// </ul>
        pub fn rejected_patches_action(mut self, input: crate::model::PatchAction) -> Self {
            self.rejected_patches_action = Some(input);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ALLOW_AS_DEPENDENCY</code>
        /// </b>: A package in the
        /// <code>Rejected</code> patches list is installed only if it is a dependency of another package.
        /// It is considered compliant with the patch baseline, and its status is reported as
        /// <code>InstalledOther</code>. This is the default action if no option is specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BLOCK</code>
        /// </b>: Packages in the
        /// <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't
        /// installed under any circumstances. If a package was installed before it was added to the
        /// Rejected patches list, it is considered non-compliant with the patch baseline, and its status
        /// is reported as <code>InstalledRejected</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_rejected_patches_action(
            mut self,
            input: std::option::Option<crate::model::PatchAction>,
        ) -> Self {
            self.rejected_patches_action = input;
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>Information about the patches to use to update the managed nodes, including target operating
        /// systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn sources(mut self, input: impl Into<crate::model::PatchSource>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>Information about the patches to use to update the managed nodes, including target operating
        /// systems and source repositories. Applies to Linux managed nodes only.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// patch baseline to identify the severity level of patches it specifies and the operating system
        /// family it applies to. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=PatchSeverity,Value=Critical</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// patch baseline to identify the severity level of patches it specifies and the operating system
        /// family it applies to. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=PatchSeverity,Value=Critical</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePatchBaselineInput`](crate::input::CreatePatchBaselineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePatchBaselineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePatchBaselineInput {
                operating_system: self.operating_system,
                name: self.name,
                global_filters: self.global_filters,
                approval_rules: self.approval_rules,
                approved_patches: self.approved_patches,
                approved_patches_compliance_level: self.approved_patches_compliance_level,
                approved_patches_enable_non_security: self.approved_patches_enable_non_security,
                rejected_patches: self.rejected_patches,
                rejected_patches_action: self.rejected_patches_action,
                description: self.description,
                sources: self.sources,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePatchBaselineInputOperationOutputAlias = crate::operation::CreatePatchBaseline;
#[doc(hidden)]
pub type CreatePatchBaselineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePatchBaselineInput {
    /// Consumes the builder and constructs an Operation<[`CreatePatchBaseline`](crate::operation::CreatePatchBaseline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePatchBaseline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePatchBaselineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePatchBaselineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePatchBaselineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreatePatchBaseline",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_patch_baseline(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePatchBaseline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePatchBaseline",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePatchBaselineInput`](crate::input::CreatePatchBaselineInput)
    pub fn builder() -> crate::input::create_patch_baseline_input::Builder {
        crate::input::create_patch_baseline_input::Builder::default()
    }
}

/// See [`CreateResourceDataSyncInput`](crate::input::CreateResourceDataSyncInput)
pub mod create_resource_data_sync_input {
    /// A builder for [`CreateResourceDataSyncInput`](crate::input::CreateResourceDataSyncInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sync_name: std::option::Option<std::string::String>,
        pub(crate) s3_destination: std::option::Option<crate::model::ResourceDataSyncS3Destination>,
        pub(crate) sync_type: std::option::Option<std::string::String>,
        pub(crate) sync_source: std::option::Option<crate::model::ResourceDataSyncSource>,
    }
    impl Builder {
        /// <p>A name for the configuration.</p>
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_name = Some(input.into());
            self
        }
        /// <p>A name for the configuration.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_name = input;
            self
        }
        /// <p>Amazon S3 configuration details for the sync. This parameter is required if the
        /// <code>SyncType</code> value is SyncToDestination.</p>
        pub fn s3_destination(
            mut self,
            input: crate::model::ResourceDataSyncS3Destination,
        ) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>Amazon S3 configuration details for the sync. This parameter is required if the
        /// <code>SyncType</code> value is SyncToDestination.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncS3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// <p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data
        /// to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a
        /// value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data
        /// from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as
        /// listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a
        /// value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_type = Some(input.into());
            self
        }
        /// <p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data
        /// to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a
        /// value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data
        /// from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as
        /// listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a
        /// value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_type = input;
            self
        }
        /// <p>Specify information about the data sources to synchronize. This parameter is required if the
        /// <code>SyncType</code> value is SyncFromSource.</p>
        pub fn sync_source(mut self, input: crate::model::ResourceDataSyncSource) -> Self {
            self.sync_source = Some(input);
            self
        }
        /// <p>Specify information about the data sources to synchronize. This parameter is required if the
        /// <code>SyncType</code> value is SyncFromSource.</p>
        pub fn set_sync_source(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncSource>,
        ) -> Self {
            self.sync_source = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceDataSyncInput`](crate::input::CreateResourceDataSyncInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceDataSyncInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceDataSyncInput {
                sync_name: self.sync_name,
                s3_destination: self.s3_destination,
                sync_type: self.sync_type,
                sync_source: self.sync_source,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceDataSyncInputOperationOutputAlias = crate::operation::CreateResourceDataSync;
#[doc(hidden)]
pub type CreateResourceDataSyncInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResourceDataSyncInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourceDataSync`](crate::operation::CreateResourceDataSync)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourceDataSync,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceDataSyncInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceDataSyncInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceDataSyncInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.CreateResourceDataSync",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resource_data_sync(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourceDataSync::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourceDataSync",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceDataSyncInput`](crate::input::CreateResourceDataSyncInput)
    pub fn builder() -> crate::input::create_resource_data_sync_input::Builder {
        crate::input::create_resource_data_sync_input::Builder::default()
    }
}

/// See [`DeleteActivationInput`](crate::input::DeleteActivationInput)
pub mod delete_activation_input {
    /// A builder for [`DeleteActivationInput`](crate::input::DeleteActivationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the activation that you want to delete.</p>
        pub fn activation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activation_id = Some(input.into());
            self
        }
        /// <p>The ID of the activation that you want to delete.</p>
        pub fn set_activation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteActivationInput`](crate::input::DeleteActivationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteActivationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteActivationInput {
                activation_id: self.activation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteActivationInputOperationOutputAlias = crate::operation::DeleteActivation;
#[doc(hidden)]
pub type DeleteActivationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteActivationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteActivation`](crate::operation::DeleteActivation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteActivation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteActivationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteActivationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteActivationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteActivation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_activation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteActivation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteActivation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteActivationInput`](crate::input::DeleteActivationInput)
    pub fn builder() -> crate::input::delete_activation_input::Builder {
        crate::input::delete_activation_input::Builder::default()
    }
}

/// See [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
pub mod delete_association_input {
    /// A builder for [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The managed node ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The association ID that you want to delete.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID that you want to delete.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssociationInput {
                name: self.name,
                instance_id: self.instance_id,
                association_id: self.association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssociationInputOperationOutputAlias = crate::operation::DeleteAssociation;
#[doc(hidden)]
pub type DeleteAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssociation`](crate::operation::DeleteAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_association(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssociation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
    pub fn builder() -> crate::input::delete_association_input::Builder {
        crate::input::delete_association_input::Builder::default()
    }
}

/// See [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
pub mod delete_document_input {
    /// A builder for [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the document that you want to delete. If not provided, all versions of the
        /// document are deleted.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of the document that you want to delete. If not provided, all versions of the
        /// document are deleted.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The version name of the document that you want to delete. If not provided, all versions of
        /// the document are deleted.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version name of the document that you want to delete. If not provided, all versions of
        /// the document are deleted.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>Some SSM document types require that you specify a <code>Force</code> flag before you can
        /// delete the document. For example, you must specify a <code>Force</code> flag to delete a document
        /// of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the
        /// <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>Some SSM document types require that you specify a <code>Force</code> flag before you can
        /// delete the document. For example, you must specify a <code>Force</code> flag to delete a document
        /// of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the
        /// <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDocumentInput {
                name: self.name,
                document_version: self.document_version,
                version_name: self.version_name,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDocumentInputOperationOutputAlias = crate::operation::DeleteDocument;
#[doc(hidden)]
pub type DeleteDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDocumentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDocument`](crate::operation::DeleteDocument)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_document(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDocument",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDocumentInput`](crate::input::DeleteDocumentInput)
    pub fn builder() -> crate::input::delete_document_input::Builder {
        crate::input::delete_document_input::Builder::default()
    }
}

/// See [`DeleteInventoryInput`](crate::input::DeleteInventoryInput)
pub mod delete_inventory_input {
    /// A builder for [`DeleteInventoryInput`](crate::input::DeleteInventoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) schema_delete_option:
            std::option::Option<crate::model::InventorySchemaDeleteOption>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom inventory type for which you want to delete either all previously
        /// collected data or the inventory type itself. </p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the custom inventory type for which you want to delete either all previously
        /// collected data or the inventory type itself. </p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you
        /// don't choose this option, the system only deletes existing inventory data associated with the
        /// custom inventory type. Choose one of the following options:</p>
        /// <p>DisableSchema: If you choose this option, the system ignores all inventory data for the
        /// specified version, and any earlier versions. To enable this schema again, you must call the
        /// <code>PutInventory</code> operation for a version greater than the disabled version.</p>
        /// <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You
        /// can recreate the schema later, if you want.</p>
        pub fn schema_delete_option(
            mut self,
            input: crate::model::InventorySchemaDeleteOption,
        ) -> Self {
            self.schema_delete_option = Some(input);
            self
        }
        /// <p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you
        /// don't choose this option, the system only deletes existing inventory data associated with the
        /// custom inventory type. Choose one of the following options:</p>
        /// <p>DisableSchema: If you choose this option, the system ignores all inventory data for the
        /// specified version, and any earlier versions. To enable this schema again, you must call the
        /// <code>PutInventory</code> operation for a version greater than the disabled version.</p>
        /// <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You
        /// can recreate the schema later, if you want.</p>
        pub fn set_schema_delete_option(
            mut self,
            input: std::option::Option<crate::model::InventorySchemaDeleteOption>,
        ) -> Self {
            self.schema_delete_option = input;
            self
        }
        /// <p>Use this option to view a summary of the deletion request without deleting any data or the
        /// data type. This option is useful when you only want to understand what will be deleted. Once you
        /// validate that the data to be deleted is what you intend to delete, you can run the same command
        /// without specifying the <code>DryRun</code> option.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Use this option to view a summary of the deletion request without deleting any data or the
        /// data type. This option is useful when you only want to understand what will be deleted. Once you
        /// validate that the data to be deleted is what you intend to delete, you can run the same command
        /// without specifying the <code>DryRun</code> option.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInventoryInput`](crate::input::DeleteInventoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInventoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInventoryInput {
                type_name: self.type_name,
                schema_delete_option: self.schema_delete_option,
                dry_run: self.dry_run.unwrap_or_default(),
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInventoryInputOperationOutputAlias = crate::operation::DeleteInventory;
#[doc(hidden)]
pub type DeleteInventoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteInventoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInventory`](crate::operation::DeleteInventory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInventory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInventoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInventoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInventoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteInventory",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_inventory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInventory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInventory",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInventoryInput`](crate::input::DeleteInventoryInput)
    pub fn builder() -> crate::input::delete_inventory_input::Builder {
        crate::input::delete_inventory_input::Builder::default()
    }
}

/// See [`DeleteMaintenanceWindowInput`](crate::input::DeleteMaintenanceWindowInput)
pub mod delete_maintenance_window_input {
    /// A builder for [`DeleteMaintenanceWindowInput`](crate::input::DeleteMaintenanceWindowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window to delete.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window to delete.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMaintenanceWindowInput`](crate::input::DeleteMaintenanceWindowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMaintenanceWindowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMaintenanceWindowInput {
                window_id: self.window_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMaintenanceWindowInputOperationOutputAlias =
    crate::operation::DeleteMaintenanceWindow;
#[doc(hidden)]
pub type DeleteMaintenanceWindowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMaintenanceWindowInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMaintenanceWindow`](crate::operation::DeleteMaintenanceWindow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMaintenanceWindow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMaintenanceWindowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMaintenanceWindowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMaintenanceWindowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteMaintenanceWindow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_maintenance_window(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMaintenanceWindow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMaintenanceWindow",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMaintenanceWindowInput`](crate::input::DeleteMaintenanceWindowInput)
    pub fn builder() -> crate::input::delete_maintenance_window_input::Builder {
        crate::input::delete_maintenance_window_input::Builder::default()
    }
}

/// See [`DeleteOpsMetadataInput`](crate::input::DeleteOpsMetadataInput)
pub mod delete_ops_metadata_input {
    /// A builder for [`DeleteOpsMetadataInput`](crate::input::DeleteOpsMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_metadata_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>
        pub fn ops_metadata_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_metadata_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_metadata_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOpsMetadataInput`](crate::input::DeleteOpsMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOpsMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOpsMetadataInput {
                ops_metadata_arn: self.ops_metadata_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOpsMetadataInputOperationOutputAlias = crate::operation::DeleteOpsMetadata;
#[doc(hidden)]
pub type DeleteOpsMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteOpsMetadataInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOpsMetadata`](crate::operation::DeleteOpsMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOpsMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteOpsMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteOpsMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteOpsMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteOpsMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_ops_metadata(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOpsMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOpsMetadata",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteOpsMetadataInput`](crate::input::DeleteOpsMetadataInput)
    pub fn builder() -> crate::input::delete_ops_metadata_input::Builder {
        crate::input::delete_ops_metadata_input::Builder::default()
    }
}

/// See [`DeleteParameterInput`](crate::input::DeleteParameterInput)
pub mod delete_parameter_input {
    /// A builder for [`DeleteParameterInput`](crate::input::DeleteParameterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParameterInput`](crate::input::DeleteParameterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteParameterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteParameterInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteParameterInputOperationOutputAlias = crate::operation::DeleteParameter;
#[doc(hidden)]
pub type DeleteParameterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteParameterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteParameter`](crate::operation::DeleteParameter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteParameter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteParameterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteParameterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteParameterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteParameter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_parameter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteParameter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteParameter",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteParameterInput`](crate::input::DeleteParameterInput)
    pub fn builder() -> crate::input::delete_parameter_input::Builder {
        crate::input::delete_parameter_input::Builder::default()
    }
}

/// See [`DeleteParametersInput`](crate::input::DeleteParametersInput)
pub mod delete_parameters_input {
    /// A builder for [`DeleteParametersInput`](crate::input::DeleteParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the parameters to delete. After deleting a parameter, wait for at least 30
        /// seconds to create a parameter with the same name.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the parameters to delete. After deleting a parameter, wait for at least 30
        /// seconds to create a parameter with the same name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParametersInput`](crate::input::DeleteParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteParametersInput { names: self.names })
        }
    }
}
#[doc(hidden)]
pub type DeleteParametersInputOperationOutputAlias = crate::operation::DeleteParameters;
#[doc(hidden)]
pub type DeleteParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteParametersInput {
    /// Consumes the builder and constructs an Operation<[`DeleteParameters`](crate::operation::DeleteParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_parameters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteParameters",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteParametersInput`](crate::input::DeleteParametersInput)
    pub fn builder() -> crate::input::delete_parameters_input::Builder {
        crate::input::delete_parameters_input::Builder::default()
    }
}

/// See [`DeletePatchBaselineInput`](crate::input::DeletePatchBaselineInput)
pub mod delete_patch_baseline_input {
    /// A builder for [`DeletePatchBaselineInput`](crate::input::DeletePatchBaselineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline to delete.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline to delete.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePatchBaselineInput`](crate::input::DeletePatchBaselineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePatchBaselineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePatchBaselineInput {
                baseline_id: self.baseline_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePatchBaselineInputOperationOutputAlias = crate::operation::DeletePatchBaseline;
#[doc(hidden)]
pub type DeletePatchBaselineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePatchBaselineInput {
    /// Consumes the builder and constructs an Operation<[`DeletePatchBaseline`](crate::operation::DeletePatchBaseline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePatchBaseline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePatchBaselineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePatchBaselineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePatchBaselineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeletePatchBaseline",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_patch_baseline(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePatchBaseline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePatchBaseline",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePatchBaselineInput`](crate::input::DeletePatchBaselineInput)
    pub fn builder() -> crate::input::delete_patch_baseline_input::Builder {
        crate::input::delete_patch_baseline_input::Builder::default()
    }
}

/// See [`DeleteResourceDataSyncInput`](crate::input::DeleteResourceDataSyncInput)
pub mod delete_resource_data_sync_input {
    /// A builder for [`DeleteResourceDataSyncInput`](crate::input::DeleteResourceDataSyncInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sync_name: std::option::Option<std::string::String>,
        pub(crate) sync_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the configuration to delete.</p>
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration to delete.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_name = input;
            self
        }
        /// <p>Specify the type of resource data sync to delete.</p>
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_type = Some(input.into());
            self
        }
        /// <p>Specify the type of resource data sync to delete.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceDataSyncInput`](crate::input::DeleteResourceDataSyncInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceDataSyncInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceDataSyncInput {
                sync_name: self.sync_name,
                sync_type: self.sync_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceDataSyncInputOperationOutputAlias = crate::operation::DeleteResourceDataSync;
#[doc(hidden)]
pub type DeleteResourceDataSyncInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResourceDataSyncInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourceDataSync`](crate::operation::DeleteResourceDataSync)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourceDataSync,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourceDataSyncInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourceDataSyncInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourceDataSyncInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeleteResourceDataSync",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_resource_data_sync(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourceDataSync::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourceDataSync",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceDataSyncInput`](crate::input::DeleteResourceDataSyncInput)
    pub fn builder() -> crate::input::delete_resource_data_sync_input::Builder {
        crate::input::delete_resource_data_sync_input::Builder::default()
    }
}

/// See [`DeregisterManagedInstanceInput`](crate::input::DeregisterManagedInstanceInput)
pub mod deregister_managed_instance_input {
    /// A builder for [`DeregisterManagedInstanceInput`](crate::input::DeregisterManagedInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the managed node when you registered it using the activation process.
        /// </p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the managed node when you registered it using the activation process.
        /// </p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterManagedInstanceInput`](crate::input::DeregisterManagedInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterManagedInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterManagedInstanceInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterManagedInstanceInputOperationOutputAlias =
    crate::operation::DeregisterManagedInstance;
#[doc(hidden)]
pub type DeregisterManagedInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterManagedInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterManagedInstance`](crate::operation::DeregisterManagedInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterManagedInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterManagedInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterManagedInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterManagedInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeregisterManagedInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_managed_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterManagedInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterManagedInstance",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterManagedInstanceInput`](crate::input::DeregisterManagedInstanceInput)
    pub fn builder() -> crate::input::deregister_managed_instance_input::Builder {
        crate::input::deregister_managed_instance_input::Builder::default()
    }
}

/// See [`DeregisterPatchBaselineForPatchGroupInput`](crate::input::DeregisterPatchBaselineForPatchGroupInput)
pub mod deregister_patch_baseline_for_patch_group_input {
    /// A builder for [`DeregisterPatchBaselineForPatchGroupInput`](crate::input::DeregisterPatchBaselineForPatchGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) patch_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline to deregister the patch group from.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline to deregister the patch group from.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The name of the patch group that should be deregistered from the patch baseline.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group that should be deregistered from the patch baseline.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterPatchBaselineForPatchGroupInput`](crate::input::DeregisterPatchBaselineForPatchGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterPatchBaselineForPatchGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterPatchBaselineForPatchGroupInput {
                baseline_id: self.baseline_id,
                patch_group: self.patch_group,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterPatchBaselineForPatchGroupInputOperationOutputAlias =
    crate::operation::DeregisterPatchBaselineForPatchGroup;
#[doc(hidden)]
pub type DeregisterPatchBaselineForPatchGroupInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeregisterPatchBaselineForPatchGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterPatchBaselineForPatchGroup`](crate::operation::DeregisterPatchBaselineForPatchGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterPatchBaselineForPatchGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterPatchBaselineForPatchGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterPatchBaselineForPatchGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterPatchBaselineForPatchGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeregisterPatchBaselineForPatchGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_patch_baseline_for_patch_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterPatchBaselineForPatchGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterPatchBaselineForPatchGroup",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterPatchBaselineForPatchGroupInput`](crate::input::DeregisterPatchBaselineForPatchGroupInput)
    pub fn builder() -> crate::input::deregister_patch_baseline_for_patch_group_input::Builder {
        crate::input::deregister_patch_baseline_for_patch_group_input::Builder::default()
    }
}

/// See [`DeregisterTargetFromMaintenanceWindowInput`](crate::input::DeregisterTargetFromMaintenanceWindowInput)
pub mod deregister_target_from_maintenance_window_input {
    /// A builder for [`DeregisterTargetFromMaintenanceWindowInput`](crate::input::DeregisterTargetFromMaintenanceWindowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_target_id: std::option::Option<std::string::String>,
        pub(crate) safe: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window the target should be removed from.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window the target should be removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The ID of the target definition to remove.</p>
        pub fn window_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_target_id = Some(input.into());
            self
        }
        /// <p>The ID of the target definition to remove.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_target_id = input;
            self
        }
        /// <p>The system checks if the target is being referenced by a task. If the target is being
        /// referenced, the system returns an error and doesn't deregister the target from the maintenance
        /// window.</p>
        pub fn safe(mut self, input: bool) -> Self {
            self.safe = Some(input);
            self
        }
        /// <p>The system checks if the target is being referenced by a task. If the target is being
        /// referenced, the system returns an error and doesn't deregister the target from the maintenance
        /// window.</p>
        pub fn set_safe(mut self, input: std::option::Option<bool>) -> Self {
            self.safe = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTargetFromMaintenanceWindowInput`](crate::input::DeregisterTargetFromMaintenanceWindowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterTargetFromMaintenanceWindowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterTargetFromMaintenanceWindowInput {
                window_id: self.window_id,
                window_target_id: self.window_target_id,
                safe: self.safe,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterTargetFromMaintenanceWindowInputOperationOutputAlias =
    crate::operation::DeregisterTargetFromMaintenanceWindow;
#[doc(hidden)]
pub type DeregisterTargetFromMaintenanceWindowInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeregisterTargetFromMaintenanceWindowInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterTargetFromMaintenanceWindow`](crate::operation::DeregisterTargetFromMaintenanceWindow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterTargetFromMaintenanceWindow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterTargetFromMaintenanceWindowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterTargetFromMaintenanceWindowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterTargetFromMaintenanceWindowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeregisterTargetFromMaintenanceWindow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_target_from_maintenance_window(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterTargetFromMaintenanceWindow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterTargetFromMaintenanceWindow",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterTargetFromMaintenanceWindowInput`](crate::input::DeregisterTargetFromMaintenanceWindowInput)
    pub fn builder() -> crate::input::deregister_target_from_maintenance_window_input::Builder {
        crate::input::deregister_target_from_maintenance_window_input::Builder::default()
    }
}

/// See [`DeregisterTaskFromMaintenanceWindowInput`](crate::input::DeregisterTaskFromMaintenanceWindowInput)
pub mod deregister_task_from_maintenance_window_input {
    /// A builder for [`DeregisterTaskFromMaintenanceWindowInput`](crate::input::DeregisterTaskFromMaintenanceWindowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window the task should be removed from.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window the task should be removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The ID of the task to remove from the maintenance window.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task to remove from the maintenance window.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTaskFromMaintenanceWindowInput`](crate::input::DeregisterTaskFromMaintenanceWindowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterTaskFromMaintenanceWindowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterTaskFromMaintenanceWindowInput {
                window_id: self.window_id,
                window_task_id: self.window_task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterTaskFromMaintenanceWindowInputOperationOutputAlias =
    crate::operation::DeregisterTaskFromMaintenanceWindow;
#[doc(hidden)]
pub type DeregisterTaskFromMaintenanceWindowInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeregisterTaskFromMaintenanceWindowInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterTaskFromMaintenanceWindow`](crate::operation::DeregisterTaskFromMaintenanceWindow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterTaskFromMaintenanceWindow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterTaskFromMaintenanceWindowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterTaskFromMaintenanceWindowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterTaskFromMaintenanceWindowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DeregisterTaskFromMaintenanceWindow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_task_from_maintenance_window(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterTaskFromMaintenanceWindow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterTaskFromMaintenanceWindow",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterTaskFromMaintenanceWindowInput`](crate::input::DeregisterTaskFromMaintenanceWindowInput)
    pub fn builder() -> crate::input::deregister_task_from_maintenance_window_input::Builder {
        crate::input::deregister_task_from_maintenance_window_input::Builder::default()
    }
}

/// See [`DescribeActivationsInput`](crate::input::DescribeActivationsInput)
pub mod describe_activations_input {
    /// A builder for [`DescribeActivationsInput`](crate::input::DescribeActivationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::DescribeActivationsFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter to view information about your activations.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::DescribeActivationsFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A filter to view information about your activations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribeActivationsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActivationsInput`](crate::input::DescribeActivationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActivationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActivationsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeActivationsInputOperationOutputAlias = crate::operation::DescribeActivations;
#[doc(hidden)]
pub type DescribeActivationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeActivationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeActivations`](crate::operation::DescribeActivations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeActivations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeActivationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeActivationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeActivationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeActivations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_activations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeActivations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeActivations",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeActivationsInput`](crate::input::DescribeActivationsInput)
    pub fn builder() -> crate::input::describe_activations_input::Builder {
        crate::input::describe_activations_input::Builder::default()
    }
}

/// See [`DescribeAssociationInput`](crate::input::DescribeAssociationInput)
pub mod describe_association_input {
    /// A builder for [`DescribeAssociationInput`](crate::input::DescribeAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) association_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The managed node ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The association ID for which you want information.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID for which you want information.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>Specify the association version to retrieve. To view the latest version, either specify
        /// <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all
        /// associations for a managed node, use <a>ListAssociations</a>. To get a list of versions
        /// for a specific association, use <a>ListAssociationVersions</a>. </p>
        pub fn association_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_version = Some(input.into());
            self
        }
        /// <p>Specify the association version to retrieve. To view the latest version, either specify
        /// <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all
        /// associations for a managed node, use <a>ListAssociations</a>. To get a list of versions
        /// for a specific association, use <a>ListAssociationVersions</a>. </p>
        pub fn set_association_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssociationInput`](crate::input::DescribeAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssociationInput {
                name: self.name,
                instance_id: self.instance_id,
                association_id: self.association_id,
                association_version: self.association_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssociationInputOperationOutputAlias = crate::operation::DescribeAssociation;
#[doc(hidden)]
pub type DescribeAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssociation`](crate::operation::DescribeAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_association(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssociation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssociationInput`](crate::input::DescribeAssociationInput)
    pub fn builder() -> crate::input::describe_association_input::Builder {
        crate::input::describe_association_input::Builder::default()
    }
}

/// See [`DescribeAssociationExecutionsInput`](crate::input::DescribeAssociationExecutionsInput)
pub mod describe_association_executions_input {
    /// A builder for [`DescribeAssociationExecutionsInput`](crate::input::DescribeAssociationExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::AssociationExecutionFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The association ID for which you want to view execution history details.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID for which you want to view execution history details.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>ExecutionId (EQUAL)</p>
        /// <p>Status (EQUAL)</p>
        /// <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::AssociationExecutionFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>ExecutionId (EQUAL)</p>
        /// <p>Status (EQUAL)</p>
        /// <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationExecutionFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssociationExecutionsInput`](crate::input::DescribeAssociationExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssociationExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssociationExecutionsInput {
                association_id: self.association_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssociationExecutionsInputOperationOutputAlias =
    crate::operation::DescribeAssociationExecutions;
#[doc(hidden)]
pub type DescribeAssociationExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAssociationExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssociationExecutions`](crate::operation::DescribeAssociationExecutions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssociationExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssociationExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssociationExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssociationExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeAssociationExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_association_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssociationExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssociationExecutions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssociationExecutionsInput`](crate::input::DescribeAssociationExecutionsInput)
    pub fn builder() -> crate::input::describe_association_executions_input::Builder {
        crate::input::describe_association_executions_input::Builder::default()
    }
}

/// See [`DescribeAssociationExecutionTargetsInput`](crate::input::DescribeAssociationExecutionTargetsInput)
pub mod describe_association_execution_targets_input {
    /// A builder for [`DescribeAssociationExecutionTargetsInput`](crate::input::DescribeAssociationExecutionTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::AssociationExecutionTargetsFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The association ID that includes the execution for which you want to view details.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID that includes the execution for which you want to view details.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The execution ID for which you want to view details.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>The execution ID for which you want to view details.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>Status (EQUAL)</p>
        /// <p>ResourceId (EQUAL)</p>
        /// <p>ResourceType (EQUAL)</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::AssociationExecutionTargetsFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>Status (EQUAL)</p>
        /// <p>ResourceId (EQUAL)</p>
        /// <p>ResourceType (EQUAL)</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociationExecutionTargetsFilter>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAssociationExecutionTargetsInput`](crate::input::DescribeAssociationExecutionTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAssociationExecutionTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAssociationExecutionTargetsInput {
                association_id: self.association_id,
                execution_id: self.execution_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAssociationExecutionTargetsInputOperationOutputAlias =
    crate::operation::DescribeAssociationExecutionTargets;
#[doc(hidden)]
pub type DescribeAssociationExecutionTargetsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeAssociationExecutionTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAssociationExecutionTargets`](crate::operation::DescribeAssociationExecutionTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAssociationExecutionTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAssociationExecutionTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAssociationExecutionTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAssociationExecutionTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeAssociationExecutionTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_association_execution_targets(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAssociationExecutionTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAssociationExecutionTargets",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAssociationExecutionTargetsInput`](crate::input::DescribeAssociationExecutionTargetsInput)
    pub fn builder() -> crate::input::describe_association_execution_targets_input::Builder {
        crate::input::describe_association_execution_targets_input::Builder::default()
    }
}

/// See [`DescribeAutomationExecutionsInput`](crate::input::DescribeAutomationExecutionsInput)
pub mod describe_automation_executions_input {
    /// A builder for [`DescribeAutomationExecutionsInput`](crate::input::DescribeAutomationExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::AutomationExecutionFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters used to limit the scope of executions that are requested.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::AutomationExecutionFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters used to limit the scope of executions that are requested.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomationExecutionFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutomationExecutionsInput`](crate::input::DescribeAutomationExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAutomationExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAutomationExecutionsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAutomationExecutionsInputOperationOutputAlias =
    crate::operation::DescribeAutomationExecutions;
#[doc(hidden)]
pub type DescribeAutomationExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAutomationExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAutomationExecutions`](crate::operation::DescribeAutomationExecutions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAutomationExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAutomationExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAutomationExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAutomationExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeAutomationExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_automation_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAutomationExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAutomationExecutions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAutomationExecutionsInput`](crate::input::DescribeAutomationExecutionsInput)
    pub fn builder() -> crate::input::describe_automation_executions_input::Builder {
        crate::input::describe_automation_executions_input::Builder::default()
    }
}

/// See [`DescribeAutomationStepExecutionsInput`](crate::input::DescribeAutomationStepExecutionsInput)
pub mod describe_automation_step_executions_input {
    /// A builder for [`DescribeAutomationStepExecutionsInput`](crate::input::DescribeAutomationStepExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automation_execution_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::StepExecutionFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) reverse_order: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Automation execution ID for which you want step execution descriptions.</p>
        pub fn automation_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.automation_execution_id = Some(input.into());
            self
        }
        /// <p>The Automation execution ID for which you want step execution descriptions.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automation_execution_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the number of step executions returned by the request.</p>
        pub fn filters(mut self, input: impl Into<crate::model::StepExecutionFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters to limit the number of step executions returned by the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepExecutionFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Indicates whether to list step executions in reverse order by start time. The default value
        /// is 'false'.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>Indicates whether to list step executions in reverse order by start time. The default value
        /// is 'false'.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutomationStepExecutionsInput`](crate::input::DescribeAutomationStepExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAutomationStepExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAutomationStepExecutionsInput {
                automation_execution_id: self.automation_execution_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
                reverse_order: self.reverse_order,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAutomationStepExecutionsInputOperationOutputAlias =
    crate::operation::DescribeAutomationStepExecutions;
#[doc(hidden)]
pub type DescribeAutomationStepExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAutomationStepExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAutomationStepExecutions`](crate::operation::DescribeAutomationStepExecutions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAutomationStepExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAutomationStepExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAutomationStepExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAutomationStepExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeAutomationStepExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_automation_step_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAutomationStepExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAutomationStepExecutions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAutomationStepExecutionsInput`](crate::input::DescribeAutomationStepExecutionsInput)
    pub fn builder() -> crate::input::describe_automation_step_executions_input::Builder {
        crate::input::describe_automation_step_executions_input::Builder::default()
    }
}

/// See [`DescribeAvailablePatchesInput`](crate::input::DescribeAvailablePatchesInput)
pub mod describe_available_patches_input {
    /// A builder for [`DescribeAvailablePatchesInput`](crate::input::DescribeAvailablePatchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>
        /// <b>Windows Server</b>
        /// </p>
        /// <p>Supported keys for Windows Server managed node patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_SET</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>OS</code> | <code>APPLICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> |
        /// <code>MicrosoftDefenderAntivirus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT_FAMILY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Windows</code> | <code>Office</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MSRC_SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CLASSIFICATION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> |
        /// <code>DefinitionUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB123456</code> | <code>KB4516046</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Linux</b>
        /// </p>
        /// <important>
        /// <p>When specifying filters for Linux patches, you must specify a key-pair for
        /// <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the
        /// following command fails:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// <p>However, the following command succeeds:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03
        /// Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// </important>
        /// <p>Supported keys for Linux managed node patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> |
        /// <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EPOCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>0</code> | <code>1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>VERSION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RELEASE</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ARCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>i686</code> | <code>x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>REPOSITORY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Core</code> | <code>Updates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADVISORY_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CVE_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BUGZILLA_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>1463241</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>
        /// <b>Windows Server</b>
        /// </p>
        /// <p>Supported keys for Windows Server managed node patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_SET</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>OS</code> | <code>APPLICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> |
        /// <code>MicrosoftDefenderAntivirus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT_FAMILY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Windows</code> | <code>Office</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MSRC_SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CLASSIFICATION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> |
        /// <code>DefinitionUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB123456</code> | <code>KB4516046</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Linux</b>
        /// </p>
        /// <important>
        /// <p>When specifying filters for Linux patches, you must specify a key-pair for
        /// <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the
        /// following command fails:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// <p>However, the following command succeeds:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03
        /// Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// </important>
        /// <p>Supported keys for Linux managed node patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> |
        /// <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EPOCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>0</code> | <code>1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>VERSION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RELEASE</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ARCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>i686</code> | <code>x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>REPOSITORY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Core</code> | <code>Updates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADVISORY_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CVE_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BUGZILLA_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>1463241</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAvailablePatchesInput`](crate::input::DescribeAvailablePatchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAvailablePatchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAvailablePatchesInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAvailablePatchesInputOperationOutputAlias =
    crate::operation::DescribeAvailablePatches;
#[doc(hidden)]
pub type DescribeAvailablePatchesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAvailablePatchesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAvailablePatches`](crate::operation::DescribeAvailablePatches)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAvailablePatches,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAvailablePatchesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAvailablePatchesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAvailablePatchesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeAvailablePatches",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_available_patches(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAvailablePatches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAvailablePatches",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAvailablePatchesInput`](crate::input::DescribeAvailablePatchesInput)
    pub fn builder() -> crate::input::describe_available_patches_input::Builder {
        crate::input::describe_available_patches_input::Builder::default()
    }
}

/// See [`DescribeDocumentInput`](crate::input::DescribeDocumentInput)
pub mod describe_document_input {
    /// A builder for [`DescribeDocumentInput`](crate::input::DescribeDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The document version for which you want information. Can be a specific version or the
        /// default version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version for which you want information. Can be a specific version or the
        /// default version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentInput`](crate::input::DescribeDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDocumentInput {
                name: self.name,
                document_version: self.document_version,
                version_name: self.version_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDocumentInputOperationOutputAlias = crate::operation::DescribeDocument;
#[doc(hidden)]
pub type DescribeDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDocumentInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDocument`](crate::operation::DescribeDocument)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_document(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDocument",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDocumentInput`](crate::input::DescribeDocumentInput)
    pub fn builder() -> crate::input::describe_document_input::Builder {
        crate::input::describe_document_input::Builder::default()
    }
}

/// See [`DescribeDocumentPermissionInput`](crate::input::DescribeDocumentPermissionInput)
pub mod describe_document_permission_input {
    /// A builder for [`DescribeDocumentPermissionInput`](crate::input::DescribeDocumentPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::DocumentPermissionType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the document for which you are the owner.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document for which you are the owner.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn permission_type(mut self, input: crate::model::DocumentPermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::DocumentPermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDocumentPermissionInput`](crate::input::DescribeDocumentPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDocumentPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDocumentPermissionInput {
                name: self.name,
                permission_type: self.permission_type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDocumentPermissionInputOperationOutputAlias =
    crate::operation::DescribeDocumentPermission;
#[doc(hidden)]
pub type DescribeDocumentPermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDocumentPermissionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDocumentPermission`](crate::operation::DescribeDocumentPermission)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDocumentPermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDocumentPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDocumentPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDocumentPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeDocumentPermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_document_permission(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDocumentPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDocumentPermission",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDocumentPermissionInput`](crate::input::DescribeDocumentPermissionInput)
    pub fn builder() -> crate::input::describe_document_permission_input::Builder {
        crate::input::describe_document_permission_input::Builder::default()
    }
}

/// See [`DescribeEffectiveInstanceAssociationsInput`](crate::input::DescribeEffectiveInstanceAssociationsInput)
pub mod describe_effective_instance_associations_input {
    /// A builder for [`DescribeEffectiveInstanceAssociationsInput`](crate::input::DescribeEffectiveInstanceAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The managed node ID for which you want to view all associations.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node ID for which you want to view all associations.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEffectiveInstanceAssociationsInput`](crate::input::DescribeEffectiveInstanceAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEffectiveInstanceAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEffectiveInstanceAssociationsInput {
                instance_id: self.instance_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEffectiveInstanceAssociationsInputOperationOutputAlias =
    crate::operation::DescribeEffectiveInstanceAssociations;
#[doc(hidden)]
pub type DescribeEffectiveInstanceAssociationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeEffectiveInstanceAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEffectiveInstanceAssociations`](crate::operation::DescribeEffectiveInstanceAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEffectiveInstanceAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEffectiveInstanceAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEffectiveInstanceAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEffectiveInstanceAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeEffectiveInstanceAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_effective_instance_associations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEffectiveInstanceAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEffectiveInstanceAssociations",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEffectiveInstanceAssociationsInput`](crate::input::DescribeEffectiveInstanceAssociationsInput)
    pub fn builder() -> crate::input::describe_effective_instance_associations_input::Builder {
        crate::input::describe_effective_instance_associations_input::Builder::default()
    }
}

/// See [`DescribeEffectivePatchesForPatchBaselineInput`](crate::input::DescribeEffectivePatchesForPatchBaselineInput)
pub mod describe_effective_patches_for_patch_baseline_input {
    /// A builder for [`DescribeEffectivePatchesForPatchBaselineInput`](crate::input::DescribeEffectivePatchesForPatchBaselineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline to retrieve the effective patches for.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline to retrieve the effective patches for.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEffectivePatchesForPatchBaselineInput`](crate::input::DescribeEffectivePatchesForPatchBaselineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEffectivePatchesForPatchBaselineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeEffectivePatchesForPatchBaselineInput {
                    baseline_id: self.baseline_id,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeEffectivePatchesForPatchBaselineInputOperationOutputAlias =
    crate::operation::DescribeEffectivePatchesForPatchBaseline;
#[doc(hidden)]
pub type DescribeEffectivePatchesForPatchBaselineInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeEffectivePatchesForPatchBaselineInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEffectivePatchesForPatchBaseline`](crate::operation::DescribeEffectivePatchesForPatchBaseline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEffectivePatchesForPatchBaseline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEffectivePatchesForPatchBaselineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEffectivePatchesForPatchBaselineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEffectivePatchesForPatchBaselineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeEffectivePatchesForPatchBaseline",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_effective_patches_for_patch_baseline(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEffectivePatchesForPatchBaseline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEffectivePatchesForPatchBaseline",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEffectivePatchesForPatchBaselineInput`](crate::input::DescribeEffectivePatchesForPatchBaselineInput)
    pub fn builder() -> crate::input::describe_effective_patches_for_patch_baseline_input::Builder {
        crate::input::describe_effective_patches_for_patch_baseline_input::Builder::default()
    }
}

/// See [`DescribeInstanceAssociationsStatusInput`](crate::input::DescribeInstanceAssociationsStatusInput)
pub mod describe_instance_associations_status_input {
    /// A builder for [`DescribeInstanceAssociationsStatusInput`](crate::input::DescribeInstanceAssociationsStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The managed node IDs for which you want association status information.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node IDs for which you want association status information.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceAssociationsStatusInput`](crate::input::DescribeInstanceAssociationsStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceAssociationsStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceAssociationsStatusInput {
                instance_id: self.instance_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceAssociationsStatusInputOperationOutputAlias =
    crate::operation::DescribeInstanceAssociationsStatus;
#[doc(hidden)]
pub type DescribeInstanceAssociationsStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInstanceAssociationsStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceAssociationsStatus`](crate::operation::DescribeInstanceAssociationsStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceAssociationsStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstanceAssociationsStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstanceAssociationsStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstanceAssociationsStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeInstanceAssociationsStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_associations_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceAssociationsStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceAssociationsStatus",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAssociationsStatusInput`](crate::input::DescribeInstanceAssociationsStatusInput)
    pub fn builder() -> crate::input::describe_instance_associations_status_input::Builder {
        crate::input::describe_instance_associations_status_input::Builder::default()
    }
}

/// See [`DescribeInstanceInformationInput`](crate::input::DescribeInstanceInformationInput)
pub mod describe_instance_information_input {
    /// A builder for [`DescribeInstanceInformationInput`](crate::input::DescribeInstanceInformationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_information_filter_list:
            std::option::Option<std::vec::Vec<crate::model::InstanceInformationFilter>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::InstanceInformationStringFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_information_filter_list`.
        ///
        /// To override the contents of this collection use [`set_instance_information_filter_list`](Self::set_instance_information_filter_list).
        ///
        /// <p>This is a legacy method. We recommend that you don't use this method. Instead, use the
        /// <code>Filters</code> data type. <code>Filters</code> enables you to return node information
        /// by filtering based on tags applied to managed nodes.</p>
        /// <note>
        /// <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads
        /// to an exception error. </p>
        /// </note>
        pub fn instance_information_filter_list(
            mut self,
            input: impl Into<crate::model::InstanceInformationFilter>,
        ) -> Self {
            let mut v = self.instance_information_filter_list.unwrap_or_default();
            v.push(input.into());
            self.instance_information_filter_list = Some(v);
            self
        }
        /// <p>This is a legacy method. We recommend that you don't use this method. Instead, use the
        /// <code>Filters</code> data type. <code>Filters</code> enables you to return node information
        /// by filtering based on tags applied to managed nodes.</p>
        /// <note>
        /// <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads
        /// to an exception error. </p>
        /// </note>
        pub fn set_instance_information_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceInformationFilter>>,
        ) -> Self {
            self.instance_information_filter_list = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of managed nodes. You can
        /// filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of
        /// <code>InstanceInformationFilterList</code>, which is deprecated.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::InstanceInformationStringFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of managed nodes. You can
        /// filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of
        /// <code>InstanceInformationFilterList</code>, which is deprecated.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InstanceInformationStringFilter>,
            >,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceInformationInput`](crate::input::DescribeInstanceInformationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceInformationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceInformationInput {
                instance_information_filter_list: self.instance_information_filter_list,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceInformationInputOperationOutputAlias =
    crate::operation::DescribeInstanceInformation;
#[doc(hidden)]
pub type DescribeInstanceInformationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInstanceInformationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceInformation`](crate::operation::DescribeInstanceInformation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceInformation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstanceInformationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstanceInformationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstanceInformationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeInstanceInformation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_information(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceInformation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceInformation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceInformationInput`](crate::input::DescribeInstanceInformationInput)
    pub fn builder() -> crate::input::describe_instance_information_input::Builder {
        crate::input::describe_instance_information_input::Builder::default()
    }
}

/// See [`DescribeInstancePatchesInput`](crate::input::DescribeInstancePatchesInput)
pub mod describe_instance_patches_input {
    /// A builder for [`DescribeInstancePatchesInput`](crate::input::DescribeInstancePatchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the managed node whose patch state information should be retrieved.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the managed node whose patch state information should be retrieved.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Classification</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>KBId</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Severity</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>State</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> |
        /// <code>InstalledPendingReboot</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Classification</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>KBId</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Severity</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>State</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> |
        /// <code>InstalledPendingReboot</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancePatchesInput`](crate::input::DescribeInstancePatchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstancePatchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstancePatchesInput {
                instance_id: self.instance_id,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstancePatchesInputOperationOutputAlias =
    crate::operation::DescribeInstancePatches;
#[doc(hidden)]
pub type DescribeInstancePatchesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInstancePatchesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstancePatches`](crate::operation::DescribeInstancePatches)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstancePatches,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstancePatchesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstancePatchesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstancePatchesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeInstancePatches",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_patches(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstancePatches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstancePatches",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchesInput`](crate::input::DescribeInstancePatchesInput)
    pub fn builder() -> crate::input::describe_instance_patches_input::Builder {
        crate::input::describe_instance_patches_input::Builder::default()
    }
}

/// See [`DescribeInstancePatchStatesInput`](crate::input::DescribeInstancePatchStatesInput)
pub mod describe_instance_patch_states_input {
    /// A builder for [`DescribeInstancePatchStatesInput`](crate::input::DescribeInstancePatchStatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The ID of the managed node for which patch state information should be retrieved.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The ID of the managed node for which patch state information should be retrieved.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of managed nodes to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of managed nodes to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancePatchStatesInput`](crate::input::DescribeInstancePatchStatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstancePatchStatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstancePatchStatesInput {
                instance_ids: self.instance_ids,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstancePatchStatesInputOperationOutputAlias =
    crate::operation::DescribeInstancePatchStates;
#[doc(hidden)]
pub type DescribeInstancePatchStatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInstancePatchStatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstancePatchStates`](crate::operation::DescribeInstancePatchStates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstancePatchStates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstancePatchStatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstancePatchStatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstancePatchStatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeInstancePatchStates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_patch_states(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstancePatchStates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstancePatchStates",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchStatesInput`](crate::input::DescribeInstancePatchStatesInput)
    pub fn builder() -> crate::input::describe_instance_patch_states_input::Builder {
        crate::input::describe_instance_patch_states_input::Builder::default()
    }
}

/// See [`DescribeInstancePatchStatesForPatchGroupInput`](crate::input::DescribeInstancePatchStatesForPatchGroupInput)
pub mod describe_instance_patch_states_for_patch_group_input {
    /// A builder for [`DescribeInstancePatchStatesForPatchGroupInput`](crate::input::DescribeInstancePatchStatesForPatchGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_group: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::InstancePatchStateFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the patch group for which the patch state information should be
        /// retrieved.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group for which the patch state information should be
        /// retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key (string between 1 and 200 characters)</p>
        /// </li>
        /// <li>
        /// <p>Values (array containing a single string)</p>
        /// </li>
        /// <li>
        /// <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::InstancePatchStateFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key (string between 1 and 200 characters)</p>
        /// </li>
        /// <li>
        /// <p>Values (array containing a single string)</p>
        /// </li>
        /// <li>
        /// <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePatchStateFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstancePatchStatesForPatchGroupInput`](crate::input::DescribeInstancePatchStatesForPatchGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstancePatchStatesForPatchGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeInstancePatchStatesForPatchGroupInput {
                    patch_group: self.patch_group,
                    filters: self.filters,
                    next_token: self.next_token,
                    max_results: self.max_results,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeInstancePatchStatesForPatchGroupInputOperationOutputAlias =
    crate::operation::DescribeInstancePatchStatesForPatchGroup;
#[doc(hidden)]
pub type DescribeInstancePatchStatesForPatchGroupInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeInstancePatchStatesForPatchGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstancePatchStatesForPatchGroup`](crate::operation::DescribeInstancePatchStatesForPatchGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstancePatchStatesForPatchGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstancePatchStatesForPatchGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstancePatchStatesForPatchGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstancePatchStatesForPatchGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeInstancePatchStatesForPatchGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_patch_states_for_patch_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstancePatchStatesForPatchGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstancePatchStatesForPatchGroup",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstancePatchStatesForPatchGroupInput`](crate::input::DescribeInstancePatchStatesForPatchGroupInput)
    pub fn builder() -> crate::input::describe_instance_patch_states_for_patch_group_input::Builder
    {
        crate::input::describe_instance_patch_states_for_patch_group_input::Builder::default()
    }
}

/// See [`DescribeInventoryDeletionsInput`](crate::input::DescribeInventoryDeletionsInput)
pub mod describe_inventory_deletions_input {
    /// A builder for [`DescribeInventoryDeletionsInput`](crate::input::DescribeInventoryDeletionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deletion_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specify the delete inventory ID for which you want information. This ID was returned by the
        /// <code>DeleteInventory</code> operation.</p>
        pub fn deletion_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deletion_id = Some(input.into());
            self
        }
        /// <p>Specify the delete inventory ID for which you want information. This ID was returned by the
        /// <code>DeleteInventory</code> operation.</p>
        pub fn set_deletion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.deletion_id = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInventoryDeletionsInput`](crate::input::DescribeInventoryDeletionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInventoryDeletionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInventoryDeletionsInput {
                deletion_id: self.deletion_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInventoryDeletionsInputOperationOutputAlias =
    crate::operation::DescribeInventoryDeletions;
#[doc(hidden)]
pub type DescribeInventoryDeletionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeInventoryDeletionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInventoryDeletions`](crate::operation::DescribeInventoryDeletions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInventoryDeletions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInventoryDeletionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInventoryDeletionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInventoryDeletionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeInventoryDeletions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_inventory_deletions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInventoryDeletions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInventoryDeletions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInventoryDeletionsInput`](crate::input::DescribeInventoryDeletionsInput)
    pub fn builder() -> crate::input::describe_inventory_deletions_input::Builder {
        crate::input::describe_inventory_deletions_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceWindowExecutionsInput`](crate::input::DescribeMaintenanceWindowExecutionsInput)
pub mod describe_maintenance_window_executions_input {
    /// A builder for [`DescribeMaintenanceWindowExecutionsInput`](crate::input::DescribeMaintenanceWindowExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window whose executions should be retrieved.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window whose executions should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key. A string between 1 and 128 characters. Supported keys include
        /// <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p>
        /// </li>
        /// <li>
        /// <p>Values. An array of strings, each between 1 and 256 characters. Supported values are
        /// date/time strings in a valid ISO 8601 date/time format, such as
        /// <code>2021-11-04T05:00:00Z</code>.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key. A string between 1 and 128 characters. Supported keys include
        /// <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p>
        /// </li>
        /// <li>
        /// <p>Values. An array of strings, each between 1 and 256 characters. Supported values are
        /// date/time strings in a valid ISO 8601 date/time format, such as
        /// <code>2021-11-04T05:00:00Z</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowExecutionsInput`](crate::input::DescribeMaintenanceWindowExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceWindowExecutionsInput {
                window_id: self.window_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowExecutionsInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindowExecutions;
#[doc(hidden)]
pub type DescribeMaintenanceWindowExecutionsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindowExecutions`](crate::operation::DescribeMaintenanceWindowExecutions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindowExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindowExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_window_executions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindowExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindowExecutions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionsInput`](crate::input::DescribeMaintenanceWindowExecutionsInput)
    pub fn builder() -> crate::input::describe_maintenance_window_executions_input::Builder {
        crate::input::describe_maintenance_window_executions_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceWindowExecutionTaskInvocationsInput`](crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput)
pub mod describe_maintenance_window_execution_task_invocations_input {
    /// A builder for [`DescribeMaintenanceWindowExecutionTaskInvocationsInput`](crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution the task is part of.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution the task is part of.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned task invocations. The supported filter key
        /// is <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters used to scope down the returned task invocations. The supported filter key
        /// is <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowExecutionTaskInvocationsInput`](crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput {
                    window_execution_id: self.window_execution_id,
                    task_id: self.task_id,
                    filters: self.filters,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowExecutionTaskInvocationsInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindowExecutionTaskInvocations;
#[doc(hidden)]
pub type DescribeMaintenanceWindowExecutionTaskInvocationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowExecutionTaskInvocationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindowExecutionTaskInvocations`](crate::operation::DescribeMaintenanceWindowExecutionTaskInvocations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindowExecutionTaskInvocations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindowExecutionTaskInvocations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_window_execution_task_invocations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindowExecutionTaskInvocations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindowExecutionTaskInvocations",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionTaskInvocationsInput`](crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInput)
    pub fn builder(
    ) -> crate::input::describe_maintenance_window_execution_task_invocations_input::Builder {
        crate::input::describe_maintenance_window_execution_task_invocations_input::Builder::default(
        )
    }
}

/// See [`DescribeMaintenanceWindowExecutionTasksInput`](crate::input::DescribeMaintenanceWindowExecutionTasksInput)
pub mod describe_maintenance_window_execution_tasks_input {
    /// A builder for [`DescribeMaintenanceWindowExecutionTasksInput`](crate::input::DescribeMaintenanceWindowExecutionTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution whose task executions should be retrieved.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution whose task executions should be retrieved.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned tasks. The supported filter key is
        /// <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters used to scope down the returned tasks. The supported filter key is
        /// <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowExecutionTasksInput`](crate::input::DescribeMaintenanceWindowExecutionTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowExecutionTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceWindowExecutionTasksInput {
                window_execution_id: self.window_execution_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowExecutionTasksInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindowExecutionTasks;
#[doc(hidden)]
pub type DescribeMaintenanceWindowExecutionTasksInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowExecutionTasksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindowExecutionTasks`](crate::operation::DescribeMaintenanceWindowExecutionTasks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindowExecutionTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowExecutionTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowExecutionTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowExecutionTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindowExecutionTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_window_execution_tasks(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindowExecutionTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindowExecutionTasks",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowExecutionTasksInput`](crate::input::DescribeMaintenanceWindowExecutionTasksInput)
    pub fn builder() -> crate::input::describe_maintenance_window_execution_tasks_input::Builder {
        crate::input::describe_maintenance_window_execution_tasks_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceWindowsInput`](crate::input::DescribeMaintenanceWindowsInput)
pub mod describe_maintenance_windows_input {
    /// A builder for [`DescribeMaintenanceWindowsInput`](crate::input::DescribeMaintenanceWindowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to narrow down the scope of the returned maintenance windows.
        /// Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example,
        /// <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters used to narrow down the scope of the returned maintenance windows.
        /// Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example,
        /// <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowsInput`](crate::input::DescribeMaintenanceWindowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceWindowsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowsInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindows;
#[doc(hidden)]
pub type DescribeMaintenanceWindowsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindows`](crate::operation::DescribeMaintenanceWindows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindows,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindows",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_windows(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindows",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowsInput`](crate::input::DescribeMaintenanceWindowsInput)
    pub fn builder() -> crate::input::describe_maintenance_windows_input::Builder {
        crate::input::describe_maintenance_windows_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceWindowScheduleInput`](crate::input::DescribeMaintenanceWindowScheduleInput)
pub mod describe_maintenance_window_schedule_input {
    /// A builder for [`DescribeMaintenanceWindowScheduleInput`](crate::input::DescribeMaintenanceWindowScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) resource_type: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window to retrieve information about.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window to retrieve information about.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn resource_type(mut self, input: crate::model::MaintenanceWindowResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters used to limit the range of results. For example, you can limit maintenance window
        /// executions to only those scheduled before or after a certain date and time.</p>
        pub fn filters(mut self, input: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters used to limit the range of results. For example, you can limit maintenance window
        /// executions to only those scheduled before or after a certain date and time.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowScheduleInput`](crate::input::DescribeMaintenanceWindowScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceWindowScheduleInput {
                window_id: self.window_id,
                targets: self.targets,
                resource_type: self.resource_type,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowScheduleInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindowSchedule;
#[doc(hidden)]
pub type DescribeMaintenanceWindowScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindowSchedule`](crate::operation::DescribeMaintenanceWindowSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindowSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindowSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_window_schedule(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindowSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindowSchedule",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowScheduleInput`](crate::input::DescribeMaintenanceWindowScheduleInput)
    pub fn builder() -> crate::input::describe_maintenance_window_schedule_input::Builder {
        crate::input::describe_maintenance_window_schedule_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceWindowsForTargetInput`](crate::input::DescribeMaintenanceWindowsForTargetInput)
pub mod describe_maintenance_windows_for_target_input {
    /// A builder for [`DescribeMaintenanceWindowsForTargetInput`](crate::input::DescribeMaintenanceWindowsForTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) resource_type: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The managed node ID or key-value pair to retrieve information about.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn resource_type(mut self, input: crate::model::MaintenanceWindowResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowsForTargetInput`](crate::input::DescribeMaintenanceWindowsForTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowsForTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceWindowsForTargetInput {
                targets: self.targets,
                resource_type: self.resource_type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowsForTargetInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindowsForTarget;
#[doc(hidden)]
pub type DescribeMaintenanceWindowsForTargetInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowsForTargetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindowsForTarget`](crate::operation::DescribeMaintenanceWindowsForTarget)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindowsForTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowsForTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowsForTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowsForTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindowsForTarget",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_windows_for_target(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindowsForTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindowsForTarget",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowsForTargetInput`](crate::input::DescribeMaintenanceWindowsForTargetInput)
    pub fn builder() -> crate::input::describe_maintenance_windows_for_target_input::Builder {
        crate::input::describe_maintenance_windows_for_target_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceWindowTargetsInput`](crate::input::DescribeMaintenanceWindowTargetsInput)
pub mod describe_maintenance_window_targets_input {
    /// A builder for [`DescribeMaintenanceWindowTargetsInput`](crate::input::DescribeMaintenanceWindowTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window whose targets should be retrieved.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window whose targets should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters that can be used to narrow down the scope of the returned window targets.
        /// The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and
        /// <code>OwnerInformation</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters that can be used to narrow down the scope of the returned window targets.
        /// The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and
        /// <code>OwnerInformation</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowTargetsInput`](crate::input::DescribeMaintenanceWindowTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceWindowTargetsInput {
                window_id: self.window_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowTargetsInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindowTargets;
#[doc(hidden)]
pub type DescribeMaintenanceWindowTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindowTargets`](crate::operation::DescribeMaintenanceWindowTargets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindowTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindowTargets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_window_targets(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindowTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindowTargets",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowTargetsInput`](crate::input::DescribeMaintenanceWindowTargetsInput)
    pub fn builder() -> crate::input::describe_maintenance_window_targets_input::Builder {
        crate::input::describe_maintenance_window_targets_input::Builder::default()
    }
}

/// See [`DescribeMaintenanceWindowTasksInput`](crate::input::DescribeMaintenanceWindowTasksInput)
pub mod describe_maintenance_window_tasks_input {
    /// A builder for [`DescribeMaintenanceWindowTasksInput`](crate::input::DescribeMaintenanceWindowTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window whose tasks should be retrieved.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window whose tasks should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to narrow down the scope of the returned tasks. The supported filter
        /// keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and
        /// <code>TaskType</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters used to narrow down the scope of the returned tasks. The supported filter
        /// keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and
        /// <code>TaskType</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMaintenanceWindowTasksInput`](crate::input::DescribeMaintenanceWindowTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMaintenanceWindowTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMaintenanceWindowTasksInput {
                window_id: self.window_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMaintenanceWindowTasksInputOperationOutputAlias =
    crate::operation::DescribeMaintenanceWindowTasks;
#[doc(hidden)]
pub type DescribeMaintenanceWindowTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMaintenanceWindowTasksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMaintenanceWindowTasks`](crate::operation::DescribeMaintenanceWindowTasks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMaintenanceWindowTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMaintenanceWindowTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMaintenanceWindowTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMaintenanceWindowTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeMaintenanceWindowTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_maintenance_window_tasks(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMaintenanceWindowTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMaintenanceWindowTasks",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMaintenanceWindowTasksInput`](crate::input::DescribeMaintenanceWindowTasksInput)
    pub fn builder() -> crate::input::describe_maintenance_window_tasks_input::Builder {
        crate::input::describe_maintenance_window_tasks_input::Builder::default()
    }
}

/// See [`DescribeOpsItemsInput`](crate::input::DescribeOpsItemsInput)
pub mod describe_ops_items_input {
    /// A builder for [`DescribeOpsItemsInput`](crate::input::DescribeOpsItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_filters:
            std::option::Option<std::vec::Vec<crate::model::OpsItemFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ops_item_filters`.
        ///
        /// To override the contents of this collection use [`set_ops_item_filters`](Self::set_ops_item_filters).
        ///
        /// <p>One or more filters to limit the response.</p>
        /// <ul>
        /// <li>
        /// <p>Key: CreatedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedBy</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: Priority</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Source</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Status</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Title*</p>
        /// <p>Operations: Equals,Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalData**</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataKey</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataValue</p>
        /// <p>Operations: Equals, Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OpsItemId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: ResourceId</p>
        /// <p>Operations: Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: AutomationId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// </ul>
        /// <p>*The Equals operator for Title matches the first 100 characters. If you specify more than
        /// 100 characters, they system returns an error that the filter value exceeds the length
        /// limit.</p>
        /// <p>**If you filter the response by using the OperationalData operator, specify a key-value pair
        /// by using the following JSON format: {"key":"key_name","value":"a_value"}</p>
        pub fn ops_item_filters(mut self, input: impl Into<crate::model::OpsItemFilter>) -> Self {
            let mut v = self.ops_item_filters.unwrap_or_default();
            v.push(input.into());
            self.ops_item_filters = Some(v);
            self
        }
        /// <p>One or more filters to limit the response.</p>
        /// <ul>
        /// <li>
        /// <p>Key: CreatedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedBy</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: Priority</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Source</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Status</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Title*</p>
        /// <p>Operations: Equals,Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalData**</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataKey</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataValue</p>
        /// <p>Operations: Equals, Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OpsItemId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: ResourceId</p>
        /// <p>Operations: Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: AutomationId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// </ul>
        /// <p>*The Equals operator for Title matches the first 100 characters. If you specify more than
        /// 100 characters, they system returns an error that the filter value exceeds the length
        /// limit.</p>
        /// <p>**If you filter the response by using the OperationalData operator, specify a key-value pair
        /// by using the following JSON format: {"key":"key_name","value":"a_value"}</p>
        pub fn set_ops_item_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemFilter>>,
        ) -> Self {
            self.ops_item_filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOpsItemsInput`](crate::input::DescribeOpsItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOpsItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOpsItemsInput {
                ops_item_filters: self.ops_item_filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOpsItemsInputOperationOutputAlias = crate::operation::DescribeOpsItems;
#[doc(hidden)]
pub type DescribeOpsItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOpsItemsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOpsItems`](crate::operation::DescribeOpsItems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOpsItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOpsItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOpsItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOpsItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeOpsItems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_ops_items(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOpsItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOpsItems",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOpsItemsInput`](crate::input::DescribeOpsItemsInput)
    pub fn builder() -> crate::input::describe_ops_items_input::Builder {
        crate::input::describe_ops_items_input::Builder::default()
    }
}

/// See [`DescribeParametersInput`](crate::input::DescribeParametersInput)
pub mod describe_parameters_input {
    /// A builder for [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ParametersFilter>>,
        pub(crate) parameter_filters:
            std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ParametersFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParametersFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `parameter_filters`.
        ///
        /// To override the contents of this collection use [`set_parameter_filters`](Self::set_parameter_filters).
        ///
        /// <p>Filters to limit the request results.</p>
        pub fn parameter_filters(
            mut self,
            input: impl Into<crate::model::ParameterStringFilter>,
        ) -> Self {
            let mut v = self.parameter_filters.unwrap_or_default();
            v.push(input.into());
            self.parameter_filters = Some(v);
            self
        }
        /// <p>Filters to limit the request results.</p>
        pub fn set_parameter_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        ) -> Self {
            self.parameter_filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeParametersInput`](crate::input::DescribeParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeParametersInput {
                filters: self.filters,
                parameter_filters: self.parameter_filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeParametersInputOperationOutputAlias = crate::operation::DescribeParameters;
#[doc(hidden)]
pub type DescribeParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeParameters`](crate::operation::DescribeParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_parameters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeParameters",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeParametersInput`](crate::input::DescribeParametersInput)
    pub fn builder() -> crate::input::describe_parameters_input::Builder {
        crate::input::describe_parameters_input::Builder::default()
    }
}

/// See [`DescribePatchBaselinesInput`](crate::input::DescribePatchBaselinesInput)
pub mod describe_patch_baselines_input {
    /// A builder for [`DescribePatchBaselinesInput`](crate::input::DescribePatchBaselinesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OWNER</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS</code> | <code>Self</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OWNER</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS</code> | <code>Self</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of patch baselines to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of patch baselines to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchBaselinesInput`](crate::input::DescribePatchBaselinesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePatchBaselinesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePatchBaselinesInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePatchBaselinesInputOperationOutputAlias = crate::operation::DescribePatchBaselines;
#[doc(hidden)]
pub type DescribePatchBaselinesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePatchBaselinesInput {
    /// Consumes the builder and constructs an Operation<[`DescribePatchBaselines`](crate::operation::DescribePatchBaselines)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePatchBaselines,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePatchBaselinesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePatchBaselinesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePatchBaselinesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribePatchBaselines",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_patch_baselines(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePatchBaselines::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePatchBaselines",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePatchBaselinesInput`](crate::input::DescribePatchBaselinesInput)
    pub fn builder() -> crate::input::describe_patch_baselines_input::Builder {
        crate::input::describe_patch_baselines_input::Builder::default()
    }
}

/// See [`DescribePatchGroupsInput`](crate::input::DescribePatchGroupsInput)
pub mod describe_patch_groups_input {
    /// A builder for [`DescribePatchGroupsInput`](crate::input::DescribePatchGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of patch groups to return (per page).</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of patch groups to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchGroupsInput`](crate::input::DescribePatchGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePatchGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePatchGroupsInput {
                max_results: self.max_results,
                filters: self.filters,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePatchGroupsInputOperationOutputAlias = crate::operation::DescribePatchGroups;
#[doc(hidden)]
pub type DescribePatchGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePatchGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePatchGroups`](crate::operation::DescribePatchGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePatchGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePatchGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePatchGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePatchGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribePatchGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_patch_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePatchGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePatchGroups",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePatchGroupsInput`](crate::input::DescribePatchGroupsInput)
    pub fn builder() -> crate::input::describe_patch_groups_input::Builder {
        crate::input::describe_patch_groups_input::Builder::default()
    }
}

/// See [`DescribePatchGroupStateInput`](crate::input::DescribePatchGroupStateInput)
pub mod describe_patch_group_state_input {
    /// A builder for [`DescribePatchGroupStateInput`](crate::input::DescribePatchGroupStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the patch group whose patch snapshot should be retrieved.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group whose patch snapshot should be retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchGroupStateInput`](crate::input::DescribePatchGroupStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePatchGroupStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePatchGroupStateInput {
                patch_group: self.patch_group,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePatchGroupStateInputOperationOutputAlias =
    crate::operation::DescribePatchGroupState;
#[doc(hidden)]
pub type DescribePatchGroupStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePatchGroupStateInput {
    /// Consumes the builder and constructs an Operation<[`DescribePatchGroupState`](crate::operation::DescribePatchGroupState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePatchGroupState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePatchGroupStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePatchGroupStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePatchGroupStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribePatchGroupState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_patch_group_state(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePatchGroupState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePatchGroupState",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePatchGroupStateInput`](crate::input::DescribePatchGroupStateInput)
    pub fn builder() -> crate::input::describe_patch_group_state_input::Builder {
        crate::input::describe_patch_group_state_input::Builder::default()
    }
}

/// See [`DescribePatchPropertiesInput`](crate::input::DescribePatchPropertiesInput)
pub mod describe_patch_properties_input {
    /// A builder for [`DescribePatchPropertiesInput`](crate::input::DescribePatchPropertiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) property: std::option::Option<crate::model::PatchProperty>,
        pub(crate) patch_set: std::option::Option<crate::model::PatchSet>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The operating system type for which to list patches.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system type for which to list patches.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>The patch property for which you want to view patch details. </p>
        pub fn property(mut self, input: crate::model::PatchProperty) -> Self {
            self.property = Some(input);
            self
        }
        /// <p>The patch property for which you want to view patch details. </p>
        pub fn set_property(
            mut self,
            input: std::option::Option<crate::model::PatchProperty>,
        ) -> Self {
            self.property = input;
            self
        }
        /// <p>Indicates whether to list patches for the Windows operating system or for applications
        /// released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>
        pub fn patch_set(mut self, input: crate::model::PatchSet) -> Self {
            self.patch_set = Some(input);
            self
        }
        /// <p>Indicates whether to list patches for the Windows operating system or for applications
        /// released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>
        pub fn set_patch_set(mut self, input: std::option::Option<crate::model::PatchSet>) -> Self {
            self.patch_set = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePatchPropertiesInput`](crate::input::DescribePatchPropertiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePatchPropertiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePatchPropertiesInput {
                operating_system: self.operating_system,
                property: self.property,
                patch_set: self.patch_set,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePatchPropertiesInputOperationOutputAlias =
    crate::operation::DescribePatchProperties;
#[doc(hidden)]
pub type DescribePatchPropertiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePatchPropertiesInput {
    /// Consumes the builder and constructs an Operation<[`DescribePatchProperties`](crate::operation::DescribePatchProperties)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePatchProperties,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePatchPropertiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePatchPropertiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePatchPropertiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribePatchProperties",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_patch_properties(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePatchProperties::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePatchProperties",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePatchPropertiesInput`](crate::input::DescribePatchPropertiesInput)
    pub fn builder() -> crate::input::describe_patch_properties_input::Builder {
        crate::input::describe_patch_properties_input::Builder::default()
    }
}

/// See [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
pub mod describe_sessions_input {
    /// A builder for [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::SessionState>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SessionFilter>>,
    }
    impl Builder {
        /// <p>The session status to retrieve a list of sessions for. For example, "Active".</p>
        pub fn state(mut self, input: crate::model::SessionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The session status to retrieve a list of sessions for. For example, "Active".</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::SessionState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the type of sessions returned by the request.</p>
        pub fn filters(mut self, input: impl Into<crate::model::SessionFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters to limit the type of sessions returned by the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SessionFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSessionsInput {
                state: self.state,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSessionsInputOperationOutputAlias = crate::operation::DescribeSessions;
#[doc(hidden)]
pub type DescribeSessionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSessionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSessions`](crate::operation::DescribeSessions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSessions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSessionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSessionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSessionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DescribeSessions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_sessions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSessions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
    pub fn builder() -> crate::input::describe_sessions_input::Builder {
        crate::input::describe_sessions_input::Builder::default()
    }
}

/// See [`DisassociateOpsItemRelatedItemInput`](crate::input::DisassociateOpsItemRelatedItemInput)
pub mod disassociate_ops_item_related_item_input {
    /// A builder for [`DisassociateOpsItemRelatedItemInput`](crate::input::DisassociateOpsItemRelatedItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a
        /// related item.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a
        /// related item.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// <p>The ID of the association for which you want to delete an association between the OpsItem
        /// and a related item.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of the association for which you want to delete an association between the OpsItem
        /// and a related item.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateOpsItemRelatedItemInput`](crate::input::DisassociateOpsItemRelatedItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateOpsItemRelatedItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateOpsItemRelatedItemInput {
                ops_item_id: self.ops_item_id,
                association_id: self.association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateOpsItemRelatedItemInputOperationOutputAlias =
    crate::operation::DisassociateOpsItemRelatedItem;
#[doc(hidden)]
pub type DisassociateOpsItemRelatedItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateOpsItemRelatedItemInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateOpsItemRelatedItem`](crate::operation::DisassociateOpsItemRelatedItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateOpsItemRelatedItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateOpsItemRelatedItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateOpsItemRelatedItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateOpsItemRelatedItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.DisassociateOpsItemRelatedItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_ops_item_related_item(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateOpsItemRelatedItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateOpsItemRelatedItem",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateOpsItemRelatedItemInput`](crate::input::DisassociateOpsItemRelatedItemInput)
    pub fn builder() -> crate::input::disassociate_ops_item_related_item_input::Builder {
        crate::input::disassociate_ops_item_related_item_input::Builder::default()
    }
}

/// See [`GetAutomationExecutionInput`](crate::input::GetAutomationExecutionInput)
pub mod get_automation_execution_input {
    /// A builder for [`GetAutomationExecutionInput`](crate::input::GetAutomationExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automation_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for an existing automation execution to examine. The execution ID is
        /// returned by StartAutomationExecution when the execution of an Automation runbook is
        /// initiated.</p>
        pub fn automation_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.automation_execution_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for an existing automation execution to examine. The execution ID is
        /// returned by StartAutomationExecution when the execution of an Automation runbook is
        /// initiated.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automation_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAutomationExecutionInput`](crate::input::GetAutomationExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAutomationExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAutomationExecutionInput {
                automation_execution_id: self.automation_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAutomationExecutionInputOperationOutputAlias = crate::operation::GetAutomationExecution;
#[doc(hidden)]
pub type GetAutomationExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAutomationExecutionInput {
    /// Consumes the builder and constructs an Operation<[`GetAutomationExecution`](crate::operation::GetAutomationExecution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAutomationExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAutomationExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAutomationExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAutomationExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetAutomationExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_automation_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAutomationExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAutomationExecution",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAutomationExecutionInput`](crate::input::GetAutomationExecutionInput)
    pub fn builder() -> crate::input::get_automation_execution_input::Builder {
        crate::input::get_automation_execution_input::Builder::default()
    }
}

/// See [`GetCalendarStateInput`](crate::input::GetCalendarStateInput)
pub mod get_calendar_state_input {
    /// A builder for [`GetCalendarStateInput`](crate::input::GetCalendarStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calendar_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) at_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `calendar_names`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that
        /// represent the calendar entries for which you want to get the state.</p>
        pub fn calendar_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.calendar_names.unwrap_or_default();
            v.push(input.into());
            self.calendar_names = Some(v);
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that
        /// represent the calendar entries for which you want to get the state.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.calendar_names = input;
            self
        }
        /// <p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don't specify a
        /// value or <code>AtTime</code>, the current time is used.</p>
        pub fn at_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.at_time = Some(input.into());
            self
        }
        /// <p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don't specify a
        /// value or <code>AtTime</code>, the current time is used.</p>
        pub fn set_at_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.at_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCalendarStateInput`](crate::input::GetCalendarStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCalendarStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCalendarStateInput {
                calendar_names: self.calendar_names,
                at_time: self.at_time,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCalendarStateInputOperationOutputAlias = crate::operation::GetCalendarState;
#[doc(hidden)]
pub type GetCalendarStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCalendarStateInput {
    /// Consumes the builder and constructs an Operation<[`GetCalendarState`](crate::operation::GetCalendarState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCalendarState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCalendarStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCalendarStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCalendarStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetCalendarState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_calendar_state(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCalendarState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCalendarState",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCalendarStateInput`](crate::input::GetCalendarStateInput)
    pub fn builder() -> crate::input::get_calendar_state_input::Builder {
        crate::input::get_calendar_state_input::Builder::default()
    }
}

/// See [`GetCommandInvocationInput`](crate::input::GetCommandInvocationInput)
pub mod get_command_invocation_input {
    /// A builder for [`GetCommandInvocationInput`](crate::input::GetCommandInvocationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) plugin_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Required) The parent command ID of the invocation plugin.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>(Required) The parent command ID of the invocation plugin.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// <p>(Required) The ID of the managed node targeted by the command. A <i>managed node</i> can be an
        /// Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, and on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>(Required) The ID of the managed node targeted by the command. A <i>managed node</i> can be an
        /// Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, and on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the plugin for which you want detailed results. If the document contains only
        /// one plugin, you can omit the name and details for that plugin. If the document contains more than
        /// one plugin, you must specify the name of the plugin for which you want to view details.</p>
        /// <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM
        /// documents). For example, <code>aws:RunShellScript</code> is a plugin.</p>
        /// <p>To find the <code>PluginName</code>, check the document content and find the name of the
        /// plugin. Alternatively, use <a>ListCommandInvocations</a> with the
        /// <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the
        /// <code>Name</code> attribute of the <code>CommandPlugin</code> object in the
        /// <code>CommandPlugins</code> list.</p>
        pub fn plugin_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.plugin_name = Some(input.into());
            self
        }
        /// <p>The name of the plugin for which you want detailed results. If the document contains only
        /// one plugin, you can omit the name and details for that plugin. If the document contains more than
        /// one plugin, you must specify the name of the plugin for which you want to view details.</p>
        /// <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM
        /// documents). For example, <code>aws:RunShellScript</code> is a plugin.</p>
        /// <p>To find the <code>PluginName</code>, check the document content and find the name of the
        /// plugin. Alternatively, use <a>ListCommandInvocations</a> with the
        /// <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the
        /// <code>Name</code> attribute of the <code>CommandPlugin</code> object in the
        /// <code>CommandPlugins</code> list.</p>
        pub fn set_plugin_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.plugin_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommandInvocationInput`](crate::input::GetCommandInvocationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCommandInvocationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCommandInvocationInput {
                command_id: self.command_id,
                instance_id: self.instance_id,
                plugin_name: self.plugin_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCommandInvocationInputOperationOutputAlias = crate::operation::GetCommandInvocation;
#[doc(hidden)]
pub type GetCommandInvocationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCommandInvocationInput {
    /// Consumes the builder and constructs an Operation<[`GetCommandInvocation`](crate::operation::GetCommandInvocation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCommandInvocation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCommandInvocationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCommandInvocationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCommandInvocationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetCommandInvocation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_command_invocation(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCommandInvocation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCommandInvocation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCommandInvocationInput`](crate::input::GetCommandInvocationInput)
    pub fn builder() -> crate::input::get_command_invocation_input::Builder {
        crate::input::get_command_invocation_input::Builder::default()
    }
}

/// See [`GetConnectionStatusInput`](crate::input::GetConnectionStatusInput)
pub mod get_connection_status_input {
    /// A builder for [`GetConnectionStatusInput`](crate::input::GetConnectionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The managed node ID.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The managed node ID.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionStatusInput`](crate::input::GetConnectionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConnectionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConnectionStatusInput {
                target: self.target,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConnectionStatusInputOperationOutputAlias = crate::operation::GetConnectionStatus;
#[doc(hidden)]
pub type GetConnectionStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConnectionStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetConnectionStatus`](crate::operation::GetConnectionStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConnectionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConnectionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConnectionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConnectionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetConnectionStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_connection_status(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConnectionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConnectionStatus",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConnectionStatusInput`](crate::input::GetConnectionStatusInput)
    pub fn builder() -> crate::input::get_connection_status_input::Builder {
        crate::input::get_connection_status_input::Builder::default()
    }
}

/// See [`GetDefaultPatchBaselineInput`](crate::input::GetDefaultPatchBaselineInput)
pub mod get_default_patch_baseline_input {
    /// A builder for [`GetDefaultPatchBaselineInput`](crate::input::GetDefaultPatchBaselineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
    }
    impl Builder {
        /// <p>Returns the default patch baseline for the specified operating system.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Returns the default patch baseline for the specified operating system.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDefaultPatchBaselineInput`](crate::input::GetDefaultPatchBaselineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDefaultPatchBaselineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDefaultPatchBaselineInput {
                operating_system: self.operating_system,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDefaultPatchBaselineInputOperationOutputAlias =
    crate::operation::GetDefaultPatchBaseline;
#[doc(hidden)]
pub type GetDefaultPatchBaselineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDefaultPatchBaselineInput {
    /// Consumes the builder and constructs an Operation<[`GetDefaultPatchBaseline`](crate::operation::GetDefaultPatchBaseline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDefaultPatchBaseline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDefaultPatchBaselineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDefaultPatchBaselineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDefaultPatchBaselineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetDefaultPatchBaseline",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_default_patch_baseline(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDefaultPatchBaseline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDefaultPatchBaseline",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDefaultPatchBaselineInput`](crate::input::GetDefaultPatchBaselineInput)
    pub fn builder() -> crate::input::get_default_patch_baseline_input::Builder {
        crate::input::get_default_patch_baseline_input::Builder::default()
    }
}

/// See [`GetDeployablePatchSnapshotForInstanceInput`](crate::input::GetDeployablePatchSnapshotForInstanceInput)
pub mod get_deployable_patch_snapshot_for_instance_input {
    /// A builder for [`GetDeployablePatchSnapshotForInstanceInput`](crate::input::GetDeployablePatchSnapshotForInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) baseline_override: std::option::Option<crate::model::BaselineOverride>,
    }
    impl Builder {
        /// <p>The ID of the managed node for which the appropriate patch snapshot should be retrieved.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the managed node for which the appropriate patch snapshot should be retrieved.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>Defines the basic information about a patch baseline override.</p>
        pub fn baseline_override(mut self, input: crate::model::BaselineOverride) -> Self {
            self.baseline_override = Some(input);
            self
        }
        /// <p>Defines the basic information about a patch baseline override.</p>
        pub fn set_baseline_override(
            mut self,
            input: std::option::Option<crate::model::BaselineOverride>,
        ) -> Self {
            self.baseline_override = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeployablePatchSnapshotForInstanceInput`](crate::input::GetDeployablePatchSnapshotForInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeployablePatchSnapshotForInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeployablePatchSnapshotForInstanceInput {
                instance_id: self.instance_id,
                snapshot_id: self.snapshot_id,
                baseline_override: self.baseline_override,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeployablePatchSnapshotForInstanceInputOperationOutputAlias =
    crate::operation::GetDeployablePatchSnapshotForInstance;
#[doc(hidden)]
pub type GetDeployablePatchSnapshotForInstanceInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetDeployablePatchSnapshotForInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployablePatchSnapshotForInstance`](crate::operation::GetDeployablePatchSnapshotForInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployablePatchSnapshotForInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeployablePatchSnapshotForInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeployablePatchSnapshotForInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeployablePatchSnapshotForInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetDeployablePatchSnapshotForInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_deployable_patch_snapshot_for_instance(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployablePatchSnapshotForInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployablePatchSnapshotForInstance",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeployablePatchSnapshotForInstanceInput`](crate::input::GetDeployablePatchSnapshotForInstanceInput)
    pub fn builder() -> crate::input::get_deployable_patch_snapshot_for_instance_input::Builder {
        crate::input::get_deployable_patch_snapshot_for_instance_input::Builder::default()
    }
}

/// See [`GetDocumentInput`](crate::input::GetDocumentInput)
pub mod get_document_input {
    /// A builder for [`GetDocumentInput`](crate::input::GetDocumentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) document_format: std::option::Option<crate::model::DocumentFormat>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document and can't
        /// be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document and can't
        /// be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>The document version for which you want information.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version for which you want information.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>Returns the document in the specified format. The document format can be either JSON or
        /// YAML. JSON is the default format.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.document_format = Some(input);
            self
        }
        /// <p>Returns the document in the specified format. The document format can be either JSON or
        /// YAML. JSON is the default format.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.document_format = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDocumentInput`](crate::input::GetDocumentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDocumentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDocumentInput {
                name: self.name,
                version_name: self.version_name,
                document_version: self.document_version,
                document_format: self.document_format,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDocumentInputOperationOutputAlias = crate::operation::GetDocument;
#[doc(hidden)]
pub type GetDocumentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDocumentInput {
    /// Consumes the builder and constructs an Operation<[`GetDocument`](crate::operation::GetDocument)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDocument,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDocumentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDocumentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDocumentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetDocument",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_document(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDocument::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDocument",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDocumentInput`](crate::input::GetDocumentInput)
    pub fn builder() -> crate::input::get_document_input::Builder {
        crate::input::get_document_input::Builder::default()
    }
}

/// See [`GetInventoryInput`](crate::input::GetInventoryInput)
pub mod get_inventory_input {
    /// A builder for [`GetInventoryInput`](crate::input::GetInventoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        pub(crate) aggregators:
            std::option::Option<std::vec::Vec<crate::model::InventoryAggregator>>,
        pub(crate) result_attributes:
            std::option::Option<std::vec::Vec<crate::model::ResultAttribute>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: impl Into<crate::model::InventoryFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>Returns counts of inventory types based on one or more expressions. For example, if you
        /// aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code>
        /// type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried
        /// fleet.</p>
        pub fn aggregators(mut self, input: impl Into<crate::model::InventoryAggregator>) -> Self {
            let mut v = self.aggregators.unwrap_or_default();
            v.push(input.into());
            self.aggregators = Some(v);
            self
        }
        /// <p>Returns counts of inventory types based on one or more expressions. For example, if you
        /// aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code>
        /// type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried
        /// fleet.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryAggregator>>,
        ) -> Self {
            self.aggregators = input;
            self
        }
        /// Appends an item to `result_attributes`.
        ///
        /// To override the contents of this collection use [`set_result_attributes`](Self::set_result_attributes).
        ///
        /// <p>The list of inventory item types to return.</p>
        pub fn result_attributes(
            mut self,
            input: impl Into<crate::model::ResultAttribute>,
        ) -> Self {
            let mut v = self.result_attributes.unwrap_or_default();
            v.push(input.into());
            self.result_attributes = Some(v);
            self
        }
        /// <p>The list of inventory item types to return.</p>
        pub fn set_result_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResultAttribute>>,
        ) -> Self {
            self.result_attributes = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInventoryInput`](crate::input::GetInventoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInventoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInventoryInput {
                filters: self.filters,
                aggregators: self.aggregators,
                result_attributes: self.result_attributes,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInventoryInputOperationOutputAlias = crate::operation::GetInventory;
#[doc(hidden)]
pub type GetInventoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInventoryInput {
    /// Consumes the builder and constructs an Operation<[`GetInventory`](crate::operation::GetInventory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInventory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInventoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInventoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInventoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetInventory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_inventory(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInventory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInventory",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInventoryInput`](crate::input::GetInventoryInput)
    pub fn builder() -> crate::input::get_inventory_input::Builder {
        crate::input::get_inventory_input::Builder::default()
    }
}

/// See [`GetInventorySchemaInput`](crate::input::GetInventorySchemaInput)
pub mod get_inventory_schema_input {
    /// A builder for [`GetInventorySchemaInput`](crate::input::GetInventorySchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) aggregator: std::option::Option<bool>,
        pub(crate) sub_type: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The type of inventory item to return.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The type of inventory item to return.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Returns inventory schemas that support aggregation. For example, this call returns the
        /// <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
        /// <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code>
        /// attributes.</p>
        pub fn aggregator(mut self, input: bool) -> Self {
            self.aggregator = Some(input);
            self
        }
        /// <p>Returns inventory schemas that support aggregation. For example, this call returns the
        /// <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
        /// <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code>
        /// attributes.</p>
        pub fn set_aggregator(mut self, input: std::option::Option<bool>) -> Self {
            self.aggregator = input;
            self
        }
        /// <p>Returns the sub-type schema for a specified inventory type.</p>
        pub fn sub_type(mut self, input: bool) -> Self {
            self.sub_type = Some(input);
            self
        }
        /// <p>Returns the sub-type schema for a specified inventory type.</p>
        pub fn set_sub_type(mut self, input: std::option::Option<bool>) -> Self {
            self.sub_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInventorySchemaInput`](crate::input::GetInventorySchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInventorySchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInventorySchemaInput {
                type_name: self.type_name,
                next_token: self.next_token,
                max_results: self.max_results,
                aggregator: self.aggregator.unwrap_or_default(),
                sub_type: self.sub_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInventorySchemaInputOperationOutputAlias = crate::operation::GetInventorySchema;
#[doc(hidden)]
pub type GetInventorySchemaInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInventorySchemaInput {
    /// Consumes the builder and constructs an Operation<[`GetInventorySchema`](crate::operation::GetInventorySchema)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInventorySchema,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInventorySchemaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInventorySchemaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInventorySchemaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetInventorySchema",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_inventory_schema(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInventorySchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInventorySchema",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInventorySchemaInput`](crate::input::GetInventorySchemaInput)
    pub fn builder() -> crate::input::get_inventory_schema_input::Builder {
        crate::input::get_inventory_schema_input::Builder::default()
    }
}

/// See [`GetMaintenanceWindowInput`](crate::input::GetMaintenanceWindowInput)
pub mod get_maintenance_window_input {
    /// A builder for [`GetMaintenanceWindowInput`](crate::input::GetMaintenanceWindowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window for which you want to retrieve information.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window for which you want to retrieve information.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowInput`](crate::input::GetMaintenanceWindowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMaintenanceWindowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMaintenanceWindowInput {
                window_id: self.window_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMaintenanceWindowInputOperationOutputAlias = crate::operation::GetMaintenanceWindow;
#[doc(hidden)]
pub type GetMaintenanceWindowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMaintenanceWindowInput {
    /// Consumes the builder and constructs an Operation<[`GetMaintenanceWindow`](crate::operation::GetMaintenanceWindow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMaintenanceWindow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMaintenanceWindowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMaintenanceWindowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMaintenanceWindowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetMaintenanceWindow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_maintenance_window(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMaintenanceWindow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMaintenanceWindow",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowInput`](crate::input::GetMaintenanceWindowInput)
    pub fn builder() -> crate::input::get_maintenance_window_input::Builder {
        crate::input::get_maintenance_window_input::Builder::default()
    }
}

/// See [`GetMaintenanceWindowExecutionInput`](crate::input::GetMaintenanceWindowExecutionInput)
pub mod get_maintenance_window_execution_input {
    /// A builder for [`GetMaintenanceWindowExecutionInput`](crate::input::GetMaintenanceWindowExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowExecutionInput`](crate::input::GetMaintenanceWindowExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMaintenanceWindowExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMaintenanceWindowExecutionInput {
                window_execution_id: self.window_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMaintenanceWindowExecutionInputOperationOutputAlias =
    crate::operation::GetMaintenanceWindowExecution;
#[doc(hidden)]
pub type GetMaintenanceWindowExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMaintenanceWindowExecutionInput {
    /// Consumes the builder and constructs an Operation<[`GetMaintenanceWindowExecution`](crate::operation::GetMaintenanceWindowExecution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMaintenanceWindowExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMaintenanceWindowExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMaintenanceWindowExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMaintenanceWindowExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetMaintenanceWindowExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_maintenance_window_execution(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMaintenanceWindowExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMaintenanceWindowExecution",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionInput`](crate::input::GetMaintenanceWindowExecutionInput)
    pub fn builder() -> crate::input::get_maintenance_window_execution_input::Builder {
        crate::input::get_maintenance_window_execution_input::Builder::default()
    }
}

/// See [`GetMaintenanceWindowExecutionTaskInput`](crate::input::GetMaintenanceWindowExecutionTaskInput)
pub mod get_maintenance_window_execution_task_input {
    /// A builder for [`GetMaintenanceWindowExecutionTaskInput`](crate::input::GetMaintenanceWindowExecutionTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that should be
        /// retrieved.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that should be
        /// retrieved.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowExecutionTaskInput`](crate::input::GetMaintenanceWindowExecutionTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMaintenanceWindowExecutionTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMaintenanceWindowExecutionTaskInput {
                window_execution_id: self.window_execution_id,
                task_id: self.task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMaintenanceWindowExecutionTaskInputOperationOutputAlias =
    crate::operation::GetMaintenanceWindowExecutionTask;
#[doc(hidden)]
pub type GetMaintenanceWindowExecutionTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMaintenanceWindowExecutionTaskInput {
    /// Consumes the builder and constructs an Operation<[`GetMaintenanceWindowExecutionTask`](crate::operation::GetMaintenanceWindowExecutionTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMaintenanceWindowExecutionTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMaintenanceWindowExecutionTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMaintenanceWindowExecutionTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMaintenanceWindowExecutionTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetMaintenanceWindowExecutionTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_maintenance_window_execution_task(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMaintenanceWindowExecutionTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMaintenanceWindowExecutionTask",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionTaskInput`](crate::input::GetMaintenanceWindowExecutionTaskInput)
    pub fn builder() -> crate::input::get_maintenance_window_execution_task_input::Builder {
        crate::input::get_maintenance_window_execution_task_input::Builder::default()
    }
}

/// See [`GetMaintenanceWindowExecutionTaskInvocationInput`](crate::input::GetMaintenanceWindowExecutionTaskInvocationInput)
pub mod get_maintenance_window_execution_task_invocation_input {
    /// A builder for [`GetMaintenanceWindowExecutionTaskInvocationInput`](crate::input::GetMaintenanceWindowExecutionTaskInvocationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_execution_id: std::option::Option<std::string::String>,
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) invocation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the maintenance window execution for which the task is a part.</p>
        pub fn window_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the maintenance window execution for which the task is a part.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_execution_id = input;
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved. </p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The invocation ID to retrieve.</p>
        pub fn invocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_id = Some(input.into());
            self
        }
        /// <p>The invocation ID to retrieve.</p>
        pub fn set_invocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowExecutionTaskInvocationInput`](crate::input::GetMaintenanceWindowExecutionTaskInvocationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMaintenanceWindowExecutionTaskInvocationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetMaintenanceWindowExecutionTaskInvocationInput {
                    window_execution_id: self.window_execution_id,
                    task_id: self.task_id,
                    invocation_id: self.invocation_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetMaintenanceWindowExecutionTaskInvocationInputOperationOutputAlias =
    crate::operation::GetMaintenanceWindowExecutionTaskInvocation;
#[doc(hidden)]
pub type GetMaintenanceWindowExecutionTaskInvocationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetMaintenanceWindowExecutionTaskInvocationInput {
    /// Consumes the builder and constructs an Operation<[`GetMaintenanceWindowExecutionTaskInvocation`](crate::operation::GetMaintenanceWindowExecutionTaskInvocation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMaintenanceWindowExecutionTaskInvocation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMaintenanceWindowExecutionTaskInvocationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMaintenanceWindowExecutionTaskInvocationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMaintenanceWindowExecutionTaskInvocationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetMaintenanceWindowExecutionTaskInvocation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_maintenance_window_execution_task_invocation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMaintenanceWindowExecutionTaskInvocation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMaintenanceWindowExecutionTaskInvocation",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowExecutionTaskInvocationInput`](crate::input::GetMaintenanceWindowExecutionTaskInvocationInput)
    pub fn builder() -> crate::input::get_maintenance_window_execution_task_invocation_input::Builder
    {
        crate::input::get_maintenance_window_execution_task_invocation_input::Builder::default()
    }
}

/// See [`GetMaintenanceWindowTaskInput`](crate::input::GetMaintenanceWindowTaskInput)
pub mod get_maintenance_window_task_input {
    /// A builder for [`GetMaintenanceWindowTaskInput`](crate::input::GetMaintenanceWindowTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) window_id: std::option::Option<std::string::String>,
        pub(crate) window_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maintenance window ID that includes the task to retrieve.</p>
        pub fn window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_id = Some(input.into());
            self
        }
        /// <p>The maintenance window ID that includes the task to retrieve.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.window_id = input;
            self
        }
        /// <p>The maintenance window task ID to retrieve.</p>
        pub fn window_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.window_task_id = Some(input.into());
            self
        }
        /// <p>The maintenance window task ID to retrieve.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.window_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMaintenanceWindowTaskInput`](crate::input::GetMaintenanceWindowTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMaintenanceWindowTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMaintenanceWindowTaskInput {
                window_id: self.window_id,
                window_task_id: self.window_task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMaintenanceWindowTaskInputOperationOutputAlias =
    crate::operation::GetMaintenanceWindowTask;
#[doc(hidden)]
pub type GetMaintenanceWindowTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMaintenanceWindowTaskInput {
    /// Consumes the builder and constructs an Operation<[`GetMaintenanceWindowTask`](crate::operation::GetMaintenanceWindowTask)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMaintenanceWindowTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMaintenanceWindowTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMaintenanceWindowTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMaintenanceWindowTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetMaintenanceWindowTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_maintenance_window_task(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMaintenanceWindowTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMaintenanceWindowTask",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMaintenanceWindowTaskInput`](crate::input::GetMaintenanceWindowTaskInput)
    pub fn builder() -> crate::input::get_maintenance_window_task_input::Builder {
        crate::input::get_maintenance_window_task_input::Builder::default()
    }
}

/// See [`GetOpsItemInput`](crate::input::GetOpsItemInput)
pub mod get_ops_item_input {
    /// A builder for [`GetOpsItemInput`](crate::input::GetOpsItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the OpsItem that you want to get.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem that you want to get.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpsItemInput`](crate::input::GetOpsItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOpsItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOpsItemInput {
                ops_item_id: self.ops_item_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOpsItemInputOperationOutputAlias = crate::operation::GetOpsItem;
#[doc(hidden)]
pub type GetOpsItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOpsItemInput {
    /// Consumes the builder and constructs an Operation<[`GetOpsItem`](crate::operation::GetOpsItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOpsItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOpsItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOpsItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOpsItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetOpsItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_ops_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOpsItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOpsItem",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOpsItemInput`](crate::input::GetOpsItemInput)
    pub fn builder() -> crate::input::get_ops_item_input::Builder {
        crate::input::get_ops_item_input::Builder::default()
    }
}

/// See [`GetOpsMetadataInput`](crate::input::GetOpsMetadataInput)
pub mod get_ops_metadata_input {
    /// A builder for [`GetOpsMetadataInput`](crate::input::GetOpsMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_metadata_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>
        pub fn ops_metadata_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_metadata_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_metadata_arn = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpsMetadataInput`](crate::input::GetOpsMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOpsMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOpsMetadataInput {
                ops_metadata_arn: self.ops_metadata_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOpsMetadataInputOperationOutputAlias = crate::operation::GetOpsMetadata;
#[doc(hidden)]
pub type GetOpsMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOpsMetadataInput {
    /// Consumes the builder and constructs an Operation<[`GetOpsMetadata`](crate::operation::GetOpsMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOpsMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOpsMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOpsMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOpsMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetOpsMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_ops_metadata(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOpsMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOpsMetadata",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOpsMetadataInput`](crate::input::GetOpsMetadataInput)
    pub fn builder() -> crate::input::get_ops_metadata_input::Builder {
        crate::input::get_ops_metadata_input::Builder::default()
    }
}

/// See [`GetOpsSummaryInput`](crate::input::GetOpsSummaryInput)
pub mod get_ops_summary_input {
    /// A builder for [`GetOpsSummaryInput`](crate::input::GetOpsSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sync_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::OpsFilter>>,
        pub(crate) aggregators: std::option::Option<std::vec::Vec<crate::model::OpsAggregator>>,
        pub(crate) result_attributes:
            std::option::Option<std::vec::Vec<crate::model::OpsResultAttribute>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specify the name of a resource data sync to get.</p>
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_name = Some(input.into());
            self
        }
        /// <p>Specify the name of a resource data sync to get.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned OpsData. </p>
        pub fn filters(mut self, input: impl Into<crate::model::OpsFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters used to scope down the returned OpsData. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>
        pub fn aggregators(mut self, input: impl Into<crate::model::OpsAggregator>) -> Self {
            let mut v = self.aggregators.unwrap_or_default();
            v.push(input.into());
            self.aggregators = Some(v);
            self
        }
        /// <p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsAggregator>>,
        ) -> Self {
            self.aggregators = input;
            self
        }
        /// Appends an item to `result_attributes`.
        ///
        /// To override the contents of this collection use [`set_result_attributes`](Self::set_result_attributes).
        ///
        /// <p>The OpsData data type to return.</p>
        pub fn result_attributes(
            mut self,
            input: impl Into<crate::model::OpsResultAttribute>,
        ) -> Self {
            let mut v = self.result_attributes.unwrap_or_default();
            v.push(input.into());
            self.result_attributes = Some(v);
            self
        }
        /// <p>The OpsData data type to return.</p>
        pub fn set_result_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsResultAttribute>>,
        ) -> Self {
            self.result_attributes = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpsSummaryInput`](crate::input::GetOpsSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOpsSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOpsSummaryInput {
                sync_name: self.sync_name,
                filters: self.filters,
                aggregators: self.aggregators,
                result_attributes: self.result_attributes,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOpsSummaryInputOperationOutputAlias = crate::operation::GetOpsSummary;
#[doc(hidden)]
pub type GetOpsSummaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOpsSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetOpsSummary`](crate::operation::GetOpsSummary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOpsSummary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOpsSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOpsSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOpsSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetOpsSummary",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_ops_summary(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOpsSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOpsSummary",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOpsSummaryInput`](crate::input::GetOpsSummaryInput)
    pub fn builder() -> crate::input::get_ops_summary_input::Builder {
        crate::input::get_ops_summary_input::Builder::default()
    }
}

/// See [`GetParameterInput`](crate::input::GetParameterInput)
pub mod get_parameter_input {
    /// A builder for [`GetParameterInput`](crate::input::GetParameterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) with_decryption: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the parameter you want to query.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter you want to query.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.with_decryption = Some(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.with_decryption = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParameterInput`](crate::input::GetParameterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetParameterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetParameterInput {
                name: self.name,
                with_decryption: self.with_decryption,
            })
        }
    }
}
#[doc(hidden)]
pub type GetParameterInputOperationOutputAlias = crate::operation::GetParameter;
#[doc(hidden)]
pub type GetParameterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetParameterInput {
    /// Consumes the builder and constructs an Operation<[`GetParameter`](crate::operation::GetParameter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetParameter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetParameterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetParameterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetParameterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetParameter",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_parameter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetParameter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetParameter",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetParameterInput`](crate::input::GetParameterInput)
    pub fn builder() -> crate::input::get_parameter_input::Builder {
        crate::input::get_parameter_input::Builder::default()
    }
}

/// See [`GetParameterHistoryInput`](crate::input::GetParameterHistoryInput)
pub mod get_parameter_history_input {
    /// A builder for [`GetParameterHistoryInput`](crate::input::GetParameterHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) with_decryption: std::option::Option<bool>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter for which you want to review history.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter for which you want to review history.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.with_decryption = Some(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.with_decryption = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParameterHistoryInput`](crate::input::GetParameterHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetParameterHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetParameterHistoryInput {
                name: self.name,
                with_decryption: self.with_decryption,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetParameterHistoryInputOperationOutputAlias = crate::operation::GetParameterHistory;
#[doc(hidden)]
pub type GetParameterHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetParameterHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetParameterHistory`](crate::operation::GetParameterHistory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetParameterHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetParameterHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetParameterHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetParameterHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetParameterHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_parameter_history(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetParameterHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetParameterHistory",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetParameterHistoryInput`](crate::input::GetParameterHistoryInput)
    pub fn builder() -> crate::input::get_parameter_history_input::Builder {
        crate::input::get_parameter_history_input::Builder::default()
    }
}

/// See [`GetParametersInput`](crate::input::GetParametersInput)
pub mod get_parameters_input {
    /// A builder for [`GetParametersInput`](crate::input::GetParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) with_decryption: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>Names of the parameters for which you want to query information.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>Names of the parameters for which you want to query information.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>Return decrypted secure string value. Return decrypted values for secure string parameters.
        /// This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.with_decryption = Some(input);
            self
        }
        /// <p>Return decrypted secure string value. Return decrypted values for secure string parameters.
        /// This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.with_decryption = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParametersInput`](crate::input::GetParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetParametersInput {
                names: self.names,
                with_decryption: self.with_decryption,
            })
        }
    }
}
#[doc(hidden)]
pub type GetParametersInputOperationOutputAlias = crate::operation::GetParameters;
#[doc(hidden)]
pub type GetParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetParametersInput {
    /// Consumes the builder and constructs an Operation<[`GetParameters`](crate::operation::GetParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetParameters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_parameters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetParameters",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetParametersInput`](crate::input::GetParametersInput)
    pub fn builder() -> crate::input::get_parameters_input::Builder {
        crate::input::get_parameters_input::Builder::default()
    }
}

/// See [`GetParametersByPathInput`](crate::input::GetParametersByPathInput)
pub mod get_parameters_by_path_input {
    /// A builder for [`GetParametersByPathInput`](crate::input::GetParametersByPathInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) recursive: std::option::Option<bool>,
        pub(crate) parameter_filters:
            std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        pub(crate) with_decryption: std::option::Option<bool>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierachy is
        /// the parameter name except the last part of the parameter. For the API call to succeeed, the last
        /// part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of
        /// 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33
        /// </code>
        /// </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierachy is
        /// the parameter name except the last part of the parameter. For the API call to succeeed, the last
        /// part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of
        /// 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33
        /// </code>
        /// </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Retrieve all parameters within a hierarchy.</p>
        /// <important>
        /// <p>If a user has access to a path, then the user can access all levels of that path. For
        /// example, if a user has permission to access path <code>/a</code>, then the user can also access
        /// <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for
        /// parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation
        /// recursively for <code>/a</code> and view <code>/a/b</code>.</p>
        /// </important>
        pub fn recursive(mut self, input: bool) -> Self {
            self.recursive = Some(input);
            self
        }
        /// <p>Retrieve all parameters within a hierarchy.</p>
        /// <important>
        /// <p>If a user has access to a path, then the user can access all levels of that path. For
        /// example, if a user has permission to access path <code>/a</code>, then the user can also access
        /// <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for
        /// parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation
        /// recursively for <code>/a</code> and view <code>/a/b</code>.</p>
        /// </important>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.recursive = input;
            self
        }
        /// Appends an item to `parameter_filters`.
        ///
        /// To override the contents of this collection use [`set_parameter_filters`](Self::set_parameter_filters).
        ///
        /// <p>Filters to limit the request results.</p>
        /// <note>
        /// <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>:
        /// <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p>
        /// <p>The following <code>Key</code> values aren't supported for
        /// <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>,
        /// <code>Path</code>, and <code>Tier</code>.</p>
        /// </note>
        pub fn parameter_filters(
            mut self,
            input: impl Into<crate::model::ParameterStringFilter>,
        ) -> Self {
            let mut v = self.parameter_filters.unwrap_or_default();
            v.push(input.into());
            self.parameter_filters = Some(v);
            self
        }
        /// <p>Filters to limit the request results.</p>
        /// <note>
        /// <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>:
        /// <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p>
        /// <p>The following <code>Key</code> values aren't supported for
        /// <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>,
        /// <code>Path</code>, and <code>Tier</code>.</p>
        /// </note>
        pub fn set_parameter_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        ) -> Self {
            self.parameter_filters = input;
            self
        }
        /// <p>Retrieve all parameters in a hierarchy with their value decrypted.</p>
        pub fn with_decryption(mut self, input: bool) -> Self {
            self.with_decryption = Some(input);
            self
        }
        /// <p>Retrieve all parameters in a hierarchy with their value decrypted.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.with_decryption = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParametersByPathInput`](crate::input::GetParametersByPathInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetParametersByPathInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetParametersByPathInput {
                path: self.path,
                recursive: self.recursive,
                parameter_filters: self.parameter_filters,
                with_decryption: self.with_decryption,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetParametersByPathInputOperationOutputAlias = crate::operation::GetParametersByPath;
#[doc(hidden)]
pub type GetParametersByPathInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetParametersByPathInput {
    /// Consumes the builder and constructs an Operation<[`GetParametersByPath`](crate::operation::GetParametersByPath)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetParametersByPath,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetParametersByPathInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetParametersByPathInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetParametersByPathInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetParametersByPath",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_parameters_by_path(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetParametersByPath::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetParametersByPath",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetParametersByPathInput`](crate::input::GetParametersByPathInput)
    pub fn builder() -> crate::input::get_parameters_by_path_input::Builder {
        crate::input::get_parameters_by_path_input::Builder::default()
    }
}

/// See [`GetPatchBaselineInput`](crate::input::GetPatchBaselineInput)
pub mod get_patch_baseline_input {
    /// A builder for [`GetPatchBaselineInput`](crate::input::GetPatchBaselineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline to retrieve.</p>
        /// <note>
        /// <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon
        /// Resource Name (ARN) of the baseline. For example, for the baseline
        /// <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify
        /// <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of
        /// <code>pb-0e392de35e7c563b7</code>.</p>
        /// </note>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline to retrieve.</p>
        /// <note>
        /// <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon
        /// Resource Name (ARN) of the baseline. For example, for the baseline
        /// <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify
        /// <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of
        /// <code>pb-0e392de35e7c563b7</code>.</p>
        /// </note>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPatchBaselineInput`](crate::input::GetPatchBaselineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPatchBaselineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPatchBaselineInput {
                baseline_id: self.baseline_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPatchBaselineInputOperationOutputAlias = crate::operation::GetPatchBaseline;
#[doc(hidden)]
pub type GetPatchBaselineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPatchBaselineInput {
    /// Consumes the builder and constructs an Operation<[`GetPatchBaseline`](crate::operation::GetPatchBaseline)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPatchBaseline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPatchBaselineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPatchBaselineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPatchBaselineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetPatchBaseline",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_patch_baseline(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPatchBaseline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPatchBaseline",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPatchBaselineInput`](crate::input::GetPatchBaselineInput)
    pub fn builder() -> crate::input::get_patch_baseline_input::Builder {
        crate::input::get_patch_baseline_input::Builder::default()
    }
}

/// See [`GetPatchBaselineForPatchGroupInput`](crate::input::GetPatchBaselineForPatchGroupInput)
pub mod get_patch_baseline_for_patch_group_input {
    /// A builder for [`GetPatchBaselineForPatchGroupInput`](crate::input::GetPatchBaselineForPatchGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_group: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
    }
    impl Builder {
        /// <p>The name of the patch group whose patch baseline should be retrieved.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group whose patch baseline should be retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// <p>Returns he operating system rule specified for patch groups using the patch baseline.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Returns he operating system rule specified for patch groups using the patch baseline.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPatchBaselineForPatchGroupInput`](crate::input::GetPatchBaselineForPatchGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPatchBaselineForPatchGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPatchBaselineForPatchGroupInput {
                patch_group: self.patch_group,
                operating_system: self.operating_system,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPatchBaselineForPatchGroupInputOperationOutputAlias =
    crate::operation::GetPatchBaselineForPatchGroup;
#[doc(hidden)]
pub type GetPatchBaselineForPatchGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPatchBaselineForPatchGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetPatchBaselineForPatchGroup`](crate::operation::GetPatchBaselineForPatchGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPatchBaselineForPatchGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPatchBaselineForPatchGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPatchBaselineForPatchGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPatchBaselineForPatchGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetPatchBaselineForPatchGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_patch_baseline_for_patch_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPatchBaselineForPatchGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPatchBaselineForPatchGroup",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPatchBaselineForPatchGroupInput`](crate::input::GetPatchBaselineForPatchGroupInput)
    pub fn builder() -> crate::input::get_patch_baseline_for_patch_group_input::Builder {
        crate::input::get_patch_baseline_for_patch_group_input::Builder::default()
    }
}

/// See [`GetServiceSettingInput`](crate::input::GetServiceSettingInput)
pub mod get_service_setting_input {
    /// A builder for [`GetServiceSettingInput`](crate::input::GetServiceSettingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) setting_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the service setting to get. The setting ID can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn setting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.setting_id = Some(input.into());
            self
        }
        /// <p>The ID of the service setting to get. The setting ID can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_setting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.setting_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceSettingInput`](crate::input::GetServiceSettingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceSettingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceSettingInput {
                setting_id: self.setting_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceSettingInputOperationOutputAlias = crate::operation::GetServiceSetting;
#[doc(hidden)]
pub type GetServiceSettingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceSettingInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceSetting`](crate::operation::GetServiceSetting)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceSetting,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceSettingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceSettingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceSettingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.GetServiceSetting",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_setting(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceSetting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceSetting",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceSettingInput`](crate::input::GetServiceSettingInput)
    pub fn builder() -> crate::input::get_service_setting_input::Builder {
        crate::input::get_service_setting_input::Builder::default()
    }
}

/// See [`LabelParameterVersionInput`](crate::input::LabelParameterVersionInput)
pub mod label_parameter_version_input {
    /// A builder for [`LabelParameterVersionInput`](crate::input::LabelParameterVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parameter_version: std::option::Option<i64>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The parameter name on which you want to attach one or more labels.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The parameter name on which you want to attach one or more labels.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The specific version of the parameter on which you want to attach one or more labels. If no
        /// version is specified, the system attaches the label to the latest version.</p>
        pub fn parameter_version(mut self, input: i64) -> Self {
            self.parameter_version = Some(input);
            self
        }
        /// <p>The specific version of the parameter on which you want to attach one or more labels. If no
        /// version is specified, the system attaches the label to the latest version.</p>
        pub fn set_parameter_version(mut self, input: std::option::Option<i64>) -> Self {
            self.parameter_version = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>One or more labels to attach to the specified parameter version.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>One or more labels to attach to the specified parameter version.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Consumes the builder and constructs a [`LabelParameterVersionInput`](crate::input::LabelParameterVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::LabelParameterVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::LabelParameterVersionInput {
                name: self.name,
                parameter_version: self.parameter_version,
                labels: self.labels,
            })
        }
    }
}
#[doc(hidden)]
pub type LabelParameterVersionInputOperationOutputAlias = crate::operation::LabelParameterVersion;
#[doc(hidden)]
pub type LabelParameterVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl LabelParameterVersionInput {
    /// Consumes the builder and constructs an Operation<[`LabelParameterVersion`](crate::operation::LabelParameterVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::LabelParameterVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::LabelParameterVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::LabelParameterVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::LabelParameterVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.LabelParameterVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_label_parameter_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::LabelParameterVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "LabelParameterVersion",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`LabelParameterVersionInput`](crate::input::LabelParameterVersionInput)
    pub fn builder() -> crate::input::label_parameter_version_input::Builder {
        crate::input::label_parameter_version_input::Builder::default()
    }
}

/// See [`ListAssociationsInput`](crate::input::ListAssociationsInput)
pub mod list_associations_input {
    /// A builder for [`ListAssociationsInput`](crate::input::ListAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_filter_list:
            std::option::Option<std::vec::Vec<crate::model::AssociationFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `association_filter_list`.
        ///
        /// To override the contents of this collection use [`set_association_filter_list`](Self::set_association_filter_list).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        /// <note>
        /// <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy
        /// associations created using the <code>InstanceID</code> attribute. Associations targeting the
        /// managed node that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code>
        /// aren't returned.</p>
        /// </note>
        pub fn association_filter_list(
            mut self,
            input: impl Into<crate::model::AssociationFilter>,
        ) -> Self {
            let mut v = self.association_filter_list.unwrap_or_default();
            v.push(input.into());
            self.association_filter_list = Some(v);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        /// <note>
        /// <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy
        /// associations created using the <code>InstanceID</code> attribute. Associations targeting the
        /// managed node that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code>
        /// aren't returned.</p>
        /// </note>
        pub fn set_association_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationFilter>>,
        ) -> Self {
            self.association_filter_list = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociationsInput`](crate::input::ListAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssociationsInput {
                association_filter_list: self.association_filter_list,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssociationsInputOperationOutputAlias = crate::operation::ListAssociations;
#[doc(hidden)]
pub type ListAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociations`](crate::operation::ListAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_associations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociations",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssociationsInput`](crate::input::ListAssociationsInput)
    pub fn builder() -> crate::input::list_associations_input::Builder {
        crate::input::list_associations_input::Builder::default()
    }
}

/// See [`ListAssociationVersionsInput`](crate::input::ListAssociationVersionsInput)
pub mod list_association_versions_input {
    /// A builder for [`ListAssociationVersionsInput`](crate::input::ListAssociationVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The association ID for which you want to view all versions.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID for which you want to view all versions.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociationVersionsInput`](crate::input::ListAssociationVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociationVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssociationVersionsInput {
                association_id: self.association_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssociationVersionsInputOperationOutputAlias =
    crate::operation::ListAssociationVersions;
#[doc(hidden)]
pub type ListAssociationVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssociationVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociationVersions`](crate::operation::ListAssociationVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociationVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssociationVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssociationVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssociationVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListAssociationVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_association_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociationVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociationVersions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssociationVersionsInput`](crate::input::ListAssociationVersionsInput)
    pub fn builder() -> crate::input::list_association_versions_input::Builder {
        crate::input::list_association_versions_input::Builder::default()
    }
}

/// See [`ListCommandInvocationsInput`](crate::input::ListCommandInvocationsInput)
pub mod list_command_invocations_input {
    /// A builder for [`ListCommandInvocationsInput`](crate::input::ListCommandInvocationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
        pub(crate) details: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>(Optional) The invocations for a specific command ID.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>(Optional) The invocations for a specific command ID.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// <p>(Optional) The command execution details for a specific managed node ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>(Optional) The command execution details for a specific managed node ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn filters(mut self, input: impl Into<crate::model::CommandFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>(Optional) If set this returns the response of the command executions and any command
        /// output. The default value is <code>false</code>. </p>
        pub fn details(mut self, input: bool) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>(Optional) If set this returns the response of the command executions and any command
        /// output. The default value is <code>false</code>. </p>
        pub fn set_details(mut self, input: std::option::Option<bool>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCommandInvocationsInput`](crate::input::ListCommandInvocationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCommandInvocationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCommandInvocationsInput {
                command_id: self.command_id,
                instance_id: self.instance_id,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
                details: self.details.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListCommandInvocationsInputOperationOutputAlias = crate::operation::ListCommandInvocations;
#[doc(hidden)]
pub type ListCommandInvocationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCommandInvocationsInput {
    /// Consumes the builder and constructs an Operation<[`ListCommandInvocations`](crate::operation::ListCommandInvocations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCommandInvocations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCommandInvocationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCommandInvocationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCommandInvocationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListCommandInvocations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_command_invocations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCommandInvocations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCommandInvocations",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCommandInvocationsInput`](crate::input::ListCommandInvocationsInput)
    pub fn builder() -> crate::input::list_command_invocations_input::Builder {
        crate::input::list_command_invocations_input::Builder::default()
    }
}

/// See [`ListCommandsInput`](crate::input::ListCommandsInput)
pub mod list_commands_input {
    /// A builder for [`ListCommandsInput`](crate::input::ListCommandsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
    }
    impl Builder {
        /// <p>(Optional) If provided, lists only the specified command.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>(Optional) If provided, lists only the specified command.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// <p>(Optional) Lists commands issued against this managed node ID.</p>
        /// <note>
        /// <p>You can't specify a managed node ID in the same command that you specify <code>Status</code> =
        /// <code>Pending</code>. This is because the command hasn't reached the managed node yet.</p>
        /// </note>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>(Optional) Lists commands issued against this managed node ID.</p>
        /// <note>
        /// <p>You can't specify a managed node ID in the same command that you specify <code>Status</code> =
        /// <code>Pending</code>. This is because the command hasn't reached the managed node yet.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results.
        /// </p>
        pub fn filters(mut self, input: impl Into<crate::model::CommandFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCommandsInput`](crate::input::ListCommandsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCommandsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCommandsInput {
                command_id: self.command_id,
                instance_id: self.instance_id,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCommandsInputOperationOutputAlias = crate::operation::ListCommands;
#[doc(hidden)]
pub type ListCommandsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCommandsInput {
    /// Consumes the builder and constructs an Operation<[`ListCommands`](crate::operation::ListCommands)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCommands,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCommandsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCommandsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCommandsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListCommands",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_commands(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCommands::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCommands",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCommandsInput`](crate::input::ListCommandsInput)
    pub fn builder() -> crate::input::list_commands_input::Builder {
        crate::input::list_commands_input::Builder::default()
    }
}

/// See [`ListComplianceItemsInput`](crate::input::ListComplianceItemsInput)
pub mod list_compliance_items_input {
    /// A builder for [`ListComplianceItemsInput`](crate::input::ListComplianceItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more compliance filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ComplianceStringFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more compliance filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The ID for the resources from which to get compliance information. Currently, you can only
        /// specify one resource ID.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>The ID for the resources from which to get compliance information. Currently, you can only
        /// specify one resource ID.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The type of resource from which to get compliance information. Currently, the only supported
        /// resource type is <code>ManagedInstance</code>.</p>
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        /// <p>The type of resource from which to get compliance information. Currently, the only supported
        /// resource type is <code>ManagedInstance</code>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComplianceItemsInput`](crate::input::ListComplianceItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComplianceItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComplianceItemsInput {
                filters: self.filters,
                resource_ids: self.resource_ids,
                resource_types: self.resource_types,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComplianceItemsInputOperationOutputAlias = crate::operation::ListComplianceItems;
#[doc(hidden)]
pub type ListComplianceItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListComplianceItemsInput {
    /// Consumes the builder and constructs an Operation<[`ListComplianceItems`](crate::operation::ListComplianceItems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComplianceItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListComplianceItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListComplianceItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListComplianceItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListComplianceItems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_compliance_items(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComplianceItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComplianceItems",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListComplianceItemsInput`](crate::input::ListComplianceItemsInput)
    pub fn builder() -> crate::input::list_compliance_items_input::Builder {
        crate::input::list_compliance_items_input::Builder::default()
    }
}

/// See [`ListComplianceSummariesInput`](crate::input::ListComplianceSummariesInput)
pub mod list_compliance_summaries_input {
    /// A builder for [`ListComplianceSummariesInput`](crate::input::ListComplianceSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more compliance or inventory filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ComplianceStringFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more compliance or inventory filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. Currently, you can specify null or 50.
        /// The call also returns a token that you can specify in a subsequent call to get the next set of
        /// results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. Currently, you can specify null or 50.
        /// The call also returns a token that you can specify in a subsequent call to get the next set of
        /// results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComplianceSummariesInput`](crate::input::ListComplianceSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComplianceSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComplianceSummariesInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComplianceSummariesInputOperationOutputAlias =
    crate::operation::ListComplianceSummaries;
#[doc(hidden)]
pub type ListComplianceSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListComplianceSummariesInput {
    /// Consumes the builder and constructs an Operation<[`ListComplianceSummaries`](crate::operation::ListComplianceSummaries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComplianceSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListComplianceSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListComplianceSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListComplianceSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListComplianceSummaries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_compliance_summaries(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComplianceSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComplianceSummaries",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListComplianceSummariesInput`](crate::input::ListComplianceSummariesInput)
    pub fn builder() -> crate::input::list_compliance_summaries_input::Builder {
        crate::input::list_compliance_summaries_input::Builder::default()
    }
}

/// See [`ListDocumentMetadataHistoryInput`](crate::input::ListDocumentMetadataHistoryInput)
pub mod list_document_metadata_history_input {
    /// A builder for [`ListDocumentMetadataHistoryInput`](crate::input::ListDocumentMetadataHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<crate::model::DocumentMetadataEnum>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the change template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the change template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the change template.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of the change template.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The type of data for which details are being requested. Currently, the only supported value
        /// is <code>DocumentReviews</code>.</p>
        pub fn metadata(mut self, input: crate::model::DocumentMetadataEnum) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>The type of data for which details are being requested. Currently, the only supported value
        /// is <code>DocumentReviews</code>.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadataEnum>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentMetadataHistoryInput`](crate::input::ListDocumentMetadataHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDocumentMetadataHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDocumentMetadataHistoryInput {
                name: self.name,
                document_version: self.document_version,
                metadata: self.metadata,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDocumentMetadataHistoryInputOperationOutputAlias =
    crate::operation::ListDocumentMetadataHistory;
#[doc(hidden)]
pub type ListDocumentMetadataHistoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDocumentMetadataHistoryInput {
    /// Consumes the builder and constructs an Operation<[`ListDocumentMetadataHistory`](crate::operation::ListDocumentMetadataHistory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDocumentMetadataHistory,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDocumentMetadataHistoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDocumentMetadataHistoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDocumentMetadataHistoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListDocumentMetadataHistory",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_document_metadata_history(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDocumentMetadataHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDocumentMetadataHistory",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDocumentMetadataHistoryInput`](crate::input::ListDocumentMetadataHistoryInput)
    pub fn builder() -> crate::input::list_document_metadata_history_input::Builder {
        crate::input::list_document_metadata_history_input::Builder::default()
    }
}

/// See [`ListDocumentsInput`](crate::input::ListDocumentsInput)
pub mod list_documents_input {
    /// A builder for [`ListDocumentsInput`](crate::input::ListDocumentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_filter_list:
            std::option::Option<std::vec::Vec<crate::model::DocumentFilter>>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::DocumentKeyValuesFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `document_filter_list`.
        ///
        /// To override the contents of this collection use [`set_document_filter_list`](Self::set_document_filter_list).
        ///
        /// <p>This data type is deprecated. Instead, use <code>Filters</code>.</p>
        pub fn document_filter_list(
            mut self,
            input: impl Into<crate::model::DocumentFilter>,
        ) -> Self {
            let mut v = self.document_filter_list.unwrap_or_default();
            v.push(input.into());
            self.document_filter_list = Some(v);
            self
        }
        /// <p>This data type is deprecated. Instead, use <code>Filters</code>.</p>
        pub fn set_document_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentFilter>>,
        ) -> Self {
            self.document_filter_list = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more
        /// specific list of results. For keys, you can specify one or more key-value pair tags that have
        /// been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>,
        /// <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example,
        /// to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value
        /// pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p>
        /// <note>
        /// <p>This API operation only supports filtering documents by using a single tag key and one or
        /// more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code>
        /// </p>
        /// </note>
        pub fn filters(mut self, input: impl Into<crate::model::DocumentKeyValuesFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more
        /// specific list of results. For keys, you can specify one or more key-value pair tags that have
        /// been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>,
        /// <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example,
        /// to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value
        /// pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p>
        /// <note>
        /// <p>This API operation only supports filtering documents by using a single tag key and one or
        /// more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code>
        /// </p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentKeyValuesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentsInput`](crate::input::ListDocumentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDocumentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDocumentsInput {
                document_filter_list: self.document_filter_list,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDocumentsInputOperationOutputAlias = crate::operation::ListDocuments;
#[doc(hidden)]
pub type ListDocumentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDocumentsInput {
    /// Consumes the builder and constructs an Operation<[`ListDocuments`](crate::operation::ListDocuments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDocuments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDocumentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDocumentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDocumentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListDocuments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_documents(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDocuments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDocuments",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDocumentsInput`](crate::input::ListDocumentsInput)
    pub fn builder() -> crate::input::list_documents_input::Builder {
        crate::input::list_documents_input::Builder::default()
    }
}

/// See [`ListDocumentVersionsInput`](crate::input::ListDocumentVersionsInput)
pub mod list_document_versions_input {
    /// A builder for [`ListDocumentVersionsInput`](crate::input::ListDocumentVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDocumentVersionsInput`](crate::input::ListDocumentVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDocumentVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDocumentVersionsInput {
                name: self.name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDocumentVersionsInputOperationOutputAlias = crate::operation::ListDocumentVersions;
#[doc(hidden)]
pub type ListDocumentVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDocumentVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDocumentVersions`](crate::operation::ListDocumentVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDocumentVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDocumentVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDocumentVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDocumentVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListDocumentVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_document_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDocumentVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDocumentVersions",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDocumentVersionsInput`](crate::input::ListDocumentVersionsInput)
    pub fn builder() -> crate::input::list_document_versions_input::Builder {
        crate::input::list_document_versions_input::Builder::default()
    }
}

/// See [`ListInventoryEntriesInput`](crate::input::ListInventoryEntriesInput)
pub mod list_inventory_entries_input {
    /// A builder for [`ListInventoryEntriesInput`](crate::input::ListInventoryEntriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The managed node ID for which you want inventory information.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The managed node ID for which you want inventory information.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The type of inventory item for which you want information.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The type of inventory item for which you want information.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: impl Into<crate::model::InventoryFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInventoryEntriesInput`](crate::input::ListInventoryEntriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInventoryEntriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInventoryEntriesInput {
                instance_id: self.instance_id,
                type_name: self.type_name,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInventoryEntriesInputOperationOutputAlias = crate::operation::ListInventoryEntries;
#[doc(hidden)]
pub type ListInventoryEntriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInventoryEntriesInput {
    /// Consumes the builder and constructs an Operation<[`ListInventoryEntries`](crate::operation::ListInventoryEntries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInventoryEntries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInventoryEntriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInventoryEntriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInventoryEntriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListInventoryEntries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_inventory_entries(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInventoryEntries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInventoryEntries",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInventoryEntriesInput`](crate::input::ListInventoryEntriesInput)
    pub fn builder() -> crate::input::list_inventory_entries_input::Builder {
        crate::input::list_inventory_entries_input::Builder::default()
    }
}

/// See [`ListOpsItemEventsInput`](crate::input::ListOpsItemEventsInput)
pub mod list_ops_item_events_input {
    /// A builder for [`ListOpsItemEventsInput`](crate::input::ListOpsItemEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::OpsItemEventFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn filters(mut self, input: impl Into<crate::model::OpsItemEventFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemEventFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpsItemEventsInput`](crate::input::ListOpsItemEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOpsItemEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOpsItemEventsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOpsItemEventsInputOperationOutputAlias = crate::operation::ListOpsItemEvents;
#[doc(hidden)]
pub type ListOpsItemEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOpsItemEventsInput {
    /// Consumes the builder and constructs an Operation<[`ListOpsItemEvents`](crate::operation::ListOpsItemEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOpsItemEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOpsItemEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOpsItemEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOpsItemEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListOpsItemEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_ops_item_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOpsItemEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOpsItemEvents",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOpsItemEventsInput`](crate::input::ListOpsItemEventsInput)
    pub fn builder() -> crate::input::list_ops_item_events_input::Builder {
        crate::input::list_ops_item_events_input::Builder::default()
    }
}

/// See [`ListOpsItemRelatedItemsInput`](crate::input::ListOpsItemRelatedItemsInput)
pub mod list_ops_item_related_items_input {
    /// A builder for [`ListOpsItemRelatedItemsInput`](crate::input::ListOpsItemRelatedItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::OpsItemRelatedItemsFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the OpsItem for which you want to list all related-item resources.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem for which you want to list all related-item resources.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::OpsItemRelatedItemsFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemRelatedItemsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpsItemRelatedItemsInput`](crate::input::ListOpsItemRelatedItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOpsItemRelatedItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOpsItemRelatedItemsInput {
                ops_item_id: self.ops_item_id,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOpsItemRelatedItemsInputOperationOutputAlias =
    crate::operation::ListOpsItemRelatedItems;
#[doc(hidden)]
pub type ListOpsItemRelatedItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOpsItemRelatedItemsInput {
    /// Consumes the builder and constructs an Operation<[`ListOpsItemRelatedItems`](crate::operation::ListOpsItemRelatedItems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOpsItemRelatedItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOpsItemRelatedItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOpsItemRelatedItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOpsItemRelatedItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListOpsItemRelatedItems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_ops_item_related_items(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOpsItemRelatedItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOpsItemRelatedItems",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOpsItemRelatedItemsInput`](crate::input::ListOpsItemRelatedItemsInput)
    pub fn builder() -> crate::input::list_ops_item_related_items_input::Builder {
        crate::input::list_ops_item_related_items_input::Builder::default()
    }
}

/// See [`ListOpsMetadataInput`](crate::input::ListOpsMetadataInput)
pub mod list_ops_metadata_input {
    /// A builder for [`ListOpsMetadataInput`](crate::input::ListOpsMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::OpsMetadataFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>
        pub fn filters(mut self, input: impl Into<crate::model::OpsMetadataFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsMetadataFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpsMetadataInput`](crate::input::ListOpsMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOpsMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOpsMetadataInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOpsMetadataInputOperationOutputAlias = crate::operation::ListOpsMetadata;
#[doc(hidden)]
pub type ListOpsMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOpsMetadataInput {
    /// Consumes the builder and constructs an Operation<[`ListOpsMetadata`](crate::operation::ListOpsMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOpsMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOpsMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOpsMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOpsMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListOpsMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_ops_metadata(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOpsMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOpsMetadata",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOpsMetadataInput`](crate::input::ListOpsMetadataInput)
    pub fn builder() -> crate::input::list_ops_metadata_input::Builder {
        crate::input::list_ops_metadata_input::Builder::default()
    }
}

/// See [`ListResourceComplianceSummariesInput`](crate::input::ListResourceComplianceSummariesInput)
pub mod list_resource_compliance_summaries_input {
    /// A builder for [`ListResourceComplianceSummariesInput`](crate::input::ListResourceComplianceSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, input: impl Into<crate::model::ComplianceStringFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceComplianceSummariesInput`](crate::input::ListResourceComplianceSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceComplianceSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceComplianceSummariesInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceComplianceSummariesInputOperationOutputAlias =
    crate::operation::ListResourceComplianceSummaries;
#[doc(hidden)]
pub type ListResourceComplianceSummariesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceComplianceSummariesInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceComplianceSummaries`](crate::operation::ListResourceComplianceSummaries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceComplianceSummaries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceComplianceSummariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceComplianceSummariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceComplianceSummariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListResourceComplianceSummaries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resource_compliance_summaries(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceComplianceSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceComplianceSummaries",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceComplianceSummariesInput`](crate::input::ListResourceComplianceSummariesInput)
    pub fn builder() -> crate::input::list_resource_compliance_summaries_input::Builder {
        crate::input::list_resource_compliance_summaries_input::Builder::default()
    }
}

/// See [`ListResourceDataSyncInput`](crate::input::ListResourceDataSyncInput)
pub mod list_resource_data_sync_input {
    /// A builder for [`ListResourceDataSyncInput`](crate::input::ListResourceDataSyncInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sync_type: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>View a list of resource data syncs according to the sync type. Specify
        /// <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations
        /// or from multiple Amazon Web Services Regions.</p>
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_type = Some(input.into());
            self
        }
        /// <p>View a list of resource data syncs according to the sync type. Specify
        /// <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations
        /// or from multiple Amazon Web Services Regions.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_type = input;
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceDataSyncInput`](crate::input::ListResourceDataSyncInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceDataSyncInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceDataSyncInput {
                sync_type: self.sync_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceDataSyncInputOperationOutputAlias = crate::operation::ListResourceDataSync;
#[doc(hidden)]
pub type ListResourceDataSyncInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceDataSyncInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceDataSync`](crate::operation::ListResourceDataSync)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceDataSync,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceDataSyncInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceDataSyncInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceDataSyncInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListResourceDataSync",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resource_data_sync(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceDataSync::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceDataSync",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceDataSyncInput`](crate::input::ListResourceDataSyncInput)
    pub fn builder() -> crate::input::list_resource_data_sync_input::Builder {
        crate::input::list_resource_data_sync_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceTypeForTagging>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns a list of tags for a specific resource type.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceTypeForTagging) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Returns a list of tags for a specific resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceTypeForTagging>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The resource ID for which you want to see a list of tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID for which you want to see a list of tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ModifyDocumentPermissionInput`](crate::input::ModifyDocumentPermissionInput)
pub mod modify_document_permission_input {
    /// A builder for [`ModifyDocumentPermissionInput`](crate::input::ModifyDocumentPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::DocumentPermissionType>,
        pub(crate) account_ids_to_add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) account_ids_to_remove: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) shared_document_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the document that you want to share.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document that you want to share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn permission_type(mut self, input: crate::model::DocumentPermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::DocumentPermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// Appends an item to `account_ids_to_add`.
        ///
        /// To override the contents of this collection use [`set_account_ids_to_add`](Self::set_account_ids_to_add).
        ///
        /// <p>The Amazon Web Services user accounts that should have access to the document. The account IDs can
        /// either be a group of account IDs or <i>All</i>.</p>
        pub fn account_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids_to_add.unwrap_or_default();
            v.push(input.into());
            self.account_ids_to_add = Some(v);
            self
        }
        /// <p>The Amazon Web Services user accounts that should have access to the document. The account IDs can
        /// either be a group of account IDs or <i>All</i>.</p>
        pub fn set_account_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids_to_add = input;
            self
        }
        /// Appends an item to `account_ids_to_remove`.
        ///
        /// To override the contents of this collection use [`set_account_ids_to_remove`](Self::set_account_ids_to_remove).
        ///
        /// <p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services
        /// user account can either be a group of account IDs or <i>All</i>. This action has a
        /// higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add
        /// and the same ID to remove, the system removes access to the document.</p>
        pub fn account_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids_to_remove.unwrap_or_default();
            v.push(input.into());
            self.account_ids_to_remove = Some(v);
            self
        }
        /// <p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services
        /// user account can either be a group of account IDs or <i>All</i>. This action has a
        /// higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add
        /// and the same ID to remove, the system removes access to the document.</p>
        pub fn set_account_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids_to_remove = input;
            self
        }
        /// <p>(Optional) The version of the document to share. If it isn't specified, the system choose
        /// the <code>Default</code> version to share.</p>
        pub fn shared_document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_document_version = Some(input.into());
            self
        }
        /// <p>(Optional) The version of the document to share. If it isn't specified, the system choose
        /// the <code>Default</code> version to share.</p>
        pub fn set_shared_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_document_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDocumentPermissionInput`](crate::input::ModifyDocumentPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyDocumentPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyDocumentPermissionInput {
                name: self.name,
                permission_type: self.permission_type,
                account_ids_to_add: self.account_ids_to_add,
                account_ids_to_remove: self.account_ids_to_remove,
                shared_document_version: self.shared_document_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyDocumentPermissionInputOperationOutputAlias =
    crate::operation::ModifyDocumentPermission;
#[doc(hidden)]
pub type ModifyDocumentPermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyDocumentPermissionInput {
    /// Consumes the builder and constructs an Operation<[`ModifyDocumentPermission`](crate::operation::ModifyDocumentPermission)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyDocumentPermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyDocumentPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyDocumentPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyDocumentPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.ModifyDocumentPermission",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_document_permission(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyDocumentPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyDocumentPermission",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyDocumentPermissionInput`](crate::input::ModifyDocumentPermissionInput)
    pub fn builder() -> crate::input::modify_document_permission_input::Builder {
        crate::input::modify_document_permission_input::Builder::default()
    }
}

/// See [`PutComplianceItemsInput`](crate::input::PutComplianceItemsInput)
pub mod put_compliance_items_input {
    /// A builder for [`PutComplianceItemsInput`](crate::input::PutComplianceItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) execution_summary: std::option::Option<crate::model::ComplianceExecutionSummary>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::ComplianceItemEntry>>,
        pub(crate) item_content_hash: std::option::Option<std::string::String>,
        pub(crate) upload_type: std::option::Option<crate::model::ComplianceUploadType>,
    }
    impl Builder {
        /// <p>Specify an ID for this resource. For a managed node, this is the node ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specify an ID for this resource. For a managed node, this is the node ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported
        /// resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported
        /// resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Specify the compliance type. For example, specify Association (for a State Manager
        /// association), Patch, or Custom:<code>string</code>.</p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p>Specify the compliance type. For example, specify Association (for a State Manager
        /// association), Patch, or Custom:<code>string</code>.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>A summary of the call execution that includes an execution ID, the type of execution (for
        /// example, <code>Command</code>), and the date/time of the execution using a datetime object that
        /// is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn execution_summary(
            mut self,
            input: crate::model::ComplianceExecutionSummary,
        ) -> Self {
            self.execution_summary = Some(input);
            self
        }
        /// <p>A summary of the call execution that includes an execution ID, the type of execution (for
        /// example, <code>Command</code>), and the date/time of the execution using a datetime object that
        /// is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn set_execution_summary(
            mut self,
            input: std::option::Option<crate::model::ComplianceExecutionSummary>,
        ) -> Self {
            self.execution_summary = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Information about the compliance as defined by the resource type. For example, for a patch
        /// compliance type, <code>Items</code> includes information about the PatchSeverity, Classification,
        /// and so on.</p>
        pub fn items(mut self, input: impl Into<crate::model::ComplianceItemEntry>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>Information about the compliance as defined by the resource type. For example, for a patch
        /// compliance type, <code>Items</code> includes information about the PatchSeverity, Classification,
        /// and so on.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceItemEntry>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information
        /// should be overwritten or ignored. If the content hashes match, the request to put compliance
        /// information is ignored.</p>
        pub fn item_content_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.item_content_hash = Some(input.into());
            self
        }
        /// <p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information
        /// should be overwritten or ignored. If the content hashes match, the request to put compliance
        /// information is ignored.</p>
        pub fn set_item_content_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.item_content_hash = input;
            self
        }
        /// <p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or
        /// <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing
        /// compliance information for the resource. You must provide a full list of compliance items each
        /// time you send the request.</p>
        /// <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific
        /// association. The association must be configured with <code>SyncCompliance</code> set to
        /// <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p>
        /// <note>
        /// <p>This attribute is only valid for association compliance.</p>
        /// </note>
        pub fn upload_type(mut self, input: crate::model::ComplianceUploadType) -> Self {
            self.upload_type = Some(input);
            self
        }
        /// <p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or
        /// <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing
        /// compliance information for the resource. You must provide a full list of compliance items each
        /// time you send the request.</p>
        /// <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific
        /// association. The association must be configured with <code>SyncCompliance</code> set to
        /// <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p>
        /// <note>
        /// <p>This attribute is only valid for association compliance.</p>
        /// </note>
        pub fn set_upload_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceUploadType>,
        ) -> Self {
            self.upload_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PutComplianceItemsInput`](crate::input::PutComplianceItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutComplianceItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutComplianceItemsInput {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                compliance_type: self.compliance_type,
                execution_summary: self.execution_summary,
                items: self.items,
                item_content_hash: self.item_content_hash,
                upload_type: self.upload_type,
            })
        }
    }
}
#[doc(hidden)]
pub type PutComplianceItemsInputOperationOutputAlias = crate::operation::PutComplianceItems;
#[doc(hidden)]
pub type PutComplianceItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutComplianceItemsInput {
    /// Consumes the builder and constructs an Operation<[`PutComplianceItems`](crate::operation::PutComplianceItems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutComplianceItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutComplianceItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutComplianceItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutComplianceItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonSSM.PutComplianceItems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_compliance_items(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutComplianceItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutComplianceItems",
            "ssm",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutComplianceItemsInput`](crate::input::PutComplianceItemsInput)
    pub fn builder() -> crate::input::put_compliance_items_input::Builder {
        crate::input::put_compliance_items_input::Builder::default()
    }
}

/// See [`PutInventoryInput`](crate::input::PutInventoryInput)
pub mod put_inventory_input {
    /// A builder for [`PutInventoryInput`](crate::input::PutInventoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::InventoryItem>>,
    }
    impl Builder {
        /// <p>An managed node ID where you want to add or update inventory items.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>An managed node ID where you want to add or update inventory items.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The inventory items that you want to add or update on managed nodes.</p>
        pub fn items(mut self, input: impl Into<crate::model::InventoryItem>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The inventory items that you want to add or update on managed nodes.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Consumes the builder and constructs a [`PutInventoryInput`](crate::input::PutInventoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutInventoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutInventoryInput {
                instance_id: self.instance_id,
                items: self.items,
            })
        }
    }
}
#[doc(hidden)]
pub type PutInventoryInputOperationOutputAlias = crate::operation::PutInventory;
#[doc(hidden)]
pub type PutInventoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutInventoryInput {
    /// Consumes the builder and constructs an Operation<[`PutInventory`](crate::operation::PutInventory)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Pu