// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Error returned if an attempt is made to register a patch group with a patch baseline that is
    /// already registered with a different patch baseline.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>You must disassociate a document from all managed nodes before you can delete it.</p>
    AssociatedInstances(crate::error::AssociatedInstances),
    /// <p>The specified association already exists.</p>
    AssociationAlreadyExists(crate::error::AssociationAlreadyExists),
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>The specified execution ID doesn't exist. Verify the ID number and try again.</p>
    AssociationExecutionDoesNotExist(crate::error::AssociationExecutionDoesNotExist),
    /// <p>You can have at most 2,000 active associations.</p>
    AssociationLimitExceeded(crate::error::AssociationLimitExceeded),
    /// <p>You have reached the maximum number versions allowed for an association. Each association
    /// has a limit of 1,000 versions. </p>
    AssociationVersionLimitExceeded(crate::error::AssociationVersionLimitExceeded),
    /// <p>Indicates that the Change Manager change template used in the change request was rejected or is
    /// still in a pending state.</p>
    AutomationDefinitionNotApprovedException(
        crate::error::AutomationDefinitionNotApprovedException,
    ),
    /// <p>An Automation runbook with the specified name couldn't be found.</p>
    AutomationDefinitionNotFoundException(crate::error::AutomationDefinitionNotFoundException),
    /// <p>An Automation runbook with the specified name and version couldn't be found.</p>
    AutomationDefinitionVersionNotFoundException(
        crate::error::AutomationDefinitionVersionNotFoundException,
    ),
    /// <p>The number of simultaneously running Automation executions exceeded the allowable
    /// limit.</p>
    AutomationExecutionLimitExceededException(
        crate::error::AutomationExecutionLimitExceededException,
    ),
    /// <p>There is no automation execution information for the requested automation execution
    /// ID.</p>
    AutomationExecutionNotFoundException(crate::error::AutomationExecutionNotFoundException),
    /// <p>The specified step name and execution ID don't exist. Verify the information and try
    /// again.</p>
    AutomationStepNotFoundException(crate::error::AutomationStepNotFoundException),
    /// <p>You specified too many custom compliance types. You can specify a maximum of 10 different
    /// types. </p>
    ComplianceTypeCountLimitExceededException(
        crate::error::ComplianceTypeCountLimitExceededException,
    ),
    /// <p>You have exceeded the limit for custom schemas. Delete one or more custom schemas and try
    /// again.</p>
    CustomSchemaCountLimitExceededException(crate::error::CustomSchemaCountLimitExceededException),
    /// <p>The specified document already exists.</p>
    DocumentAlreadyExists(crate::error::DocumentAlreadyExists),
    /// <p>You can have at most 500 active SSM documents.</p>
    DocumentLimitExceeded(crate::error::DocumentLimitExceeded),
    /// <p>The document can't be shared with more Amazon Web Services user accounts. You can share a document
    /// with a maximum of 20 accounts. You can publicly share up to five documents. If you need to
    /// increase this limit, contact Amazon Web Services Support.</p>
    DocumentPermissionLimit(crate::error::DocumentPermissionLimit),
    /// <p>The document has too many versions. Delete one or more document versions and try
    /// again.</p>
    DocumentVersionLimitExceeded(crate::error::DocumentVersionLimitExceeded),
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>The content of the association document matches another document. Change the content of the
    /// document and try again.</p>
    DuplicateDocumentContent(crate::error::DuplicateDocumentContent),
    /// <p>The version name has already been used in this document. Specify a different version name,
    /// and then try again.</p>
    DuplicateDocumentVersionName(crate::error::DuplicateDocumentVersionName),
    /// <p>You can't specify a managed node ID in more than one association.</p>
    DuplicateInstanceId(crate::error::DuplicateInstanceId),
    /// <p>You attempted to register a <code>LAMBDA</code> or <code>STEP_FUNCTIONS</code> task in a
    /// region where the corresponding service isn't available. </p>
    FeatureNotAvailableException(crate::error::FeatureNotAvailableException),
    /// <p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and
    /// constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    HierarchyLevelLimitExceededException(crate::error::HierarchyLevelLimitExceededException),
    /// <p>Parameter Store doesn't support changing a parameter type in a hierarchy. For example, you
    /// can't change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You
    /// must create a new, unique parameter.</p>
    HierarchyTypeMismatchException(crate::error::HierarchyTypeMismatchException),
    /// <p>Error returned when an idempotent operation is retried and the parameters don't match the
    /// original call to the API with the same idempotency token. </p>
    IdempotentParameterMismatch(crate::error::IdempotentParameterMismatch),
    /// <p>There is a conflict in the policies specified for this parameter. You can't, for example,
    /// specify two Expiration policies for a parameter. Review your policies, and try again.</p>
    IncompatiblePolicyException(crate::error::IncompatiblePolicyException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The activation isn't valid. The activation might have been deleted, or the ActivationId and
    /// the ActivationCode don't match.</p>
    InvalidActivation(crate::error::InvalidActivation),
    /// <p>The activation ID isn't valid. Verify the you entered the correct ActivationId or
    /// ActivationCode and try again.</p>
    InvalidActivationId(crate::error::InvalidActivationId),
    /// <p>The specified aggregator isn't valid for inventory groups. Verify that the aggregator uses a
    /// valid inventory type such as <code>AWS:Application</code> or
    /// <code>AWS:InstanceInformation</code>.</p>
    InvalidAggregatorException(crate::error::InvalidAggregatorException),
    /// <p>The request doesn't meet the regular expression requirement.</p>
    InvalidAllowedPatternException(crate::error::InvalidAllowedPatternException),
    /// <p>The association isn't valid or doesn't exist. </p>
    InvalidAssociation(crate::error::InvalidAssociation),
    /// <p>The version you specified isn't valid. Use ListAssociationVersions to view all versions of
    /// an association according to the association ID. Or, use the <code>$LATEST</code> parameter to
    /// view the latest version of the association.</p>
    InvalidAssociationVersion(crate::error::InvalidAssociationVersion),
    /// <p>The supplied parameters for invoking the specified Automation runbook are incorrect. For
    /// example, they may not match the set of parameters permitted for the specified Automation
    /// document.</p>
    InvalidAutomationExecutionParametersException(
        crate::error::InvalidAutomationExecutionParametersException,
    ),
    /// <p>The signal isn't valid for the current Automation execution.</p>
    InvalidAutomationSignalException(crate::error::InvalidAutomationSignalException),
    /// <p>The specified update status operation isn't valid.</p>
    InvalidAutomationStatusUpdateException(crate::error::InvalidAutomationStatusUpdateException),
    /// <p>The specified command ID isn't valid. Verify the ID and try again.</p>
    InvalidCommandId(crate::error::InvalidCommandId),
    /// <p>One or more of the parameters specified for the delete operation isn't valid. Verify all
    /// parameters and try again.</p>
    InvalidDeleteInventoryParametersException(
        crate::error::InvalidDeleteInventoryParametersException,
    ),
    /// <p>The ID specified for the delete operation doesn't exist or isn't valid. Verify the ID and
    /// try again.</p>
    InvalidDeletionIdException(crate::error::InvalidDeletionIdException),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The content for the document isn't valid.</p>
    InvalidDocumentContent(crate::error::InvalidDocumentContent),
    /// <p>You attempted to delete a document while it is still shared. You must stop sharing the
    /// document before you can delete it.</p>
    InvalidDocumentOperation(crate::error::InvalidDocumentOperation),
    /// <p>The version of the document schema isn't supported.</p>
    InvalidDocumentSchemaVersion(crate::error::InvalidDocumentSchemaVersion),
    /// <p>The SSM document type isn't valid. Valid document types are described in the
    /// <code>DocumentType</code> property.</p>
    InvalidDocumentType(crate::error::InvalidDocumentType),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The specified filter option isn't valid. Valid options are Equals and BeginsWith. For Path
    /// filter, valid options are Recursive and OneLevel.</p>
    InvalidFilterOption(crate::error::InvalidFilterOption),
    /// <p>The filter value isn't valid. Verify the value and try again.</p>
    InvalidFilterValue(crate::error::InvalidFilterValue),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified filter value isn't valid.</p>
    InvalidInstanceInformationFilterValue(crate::error::InvalidInstanceInformationFilterValue),
    /// <p>The specified inventory group isn't valid.</p>
    InvalidInventoryGroupException(crate::error::InvalidInventoryGroupException),
    /// <p>You specified invalid keys or values in the <code>Context</code> attribute for
    /// <code>InventoryItem</code>. Verify the keys and values, and try again.</p>
    InvalidInventoryItemContextException(crate::error::InvalidInventoryItemContextException),
    /// <p>The request isn't valid.</p>
    InvalidInventoryRequestException(crate::error::InvalidInventoryRequestException),
    /// <p>One or more content items isn't valid.</p>
    InvalidItemContentException(crate::error::InvalidItemContentException),
    /// <p>The query key ID isn't valid.</p>
    InvalidKeyId(crate::error::InvalidKeyId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>One or more configuration items isn't valid. Verify that a valid Amazon Resource Name (ARN)
    /// was provided for an Amazon Simple Notification Service topic.</p>
    InvalidNotificationConfig(crate::error::InvalidNotificationConfig),
    /// <p>The delete inventory option specified isn't valid. Verify the option and try again.</p>
    InvalidOptionException(crate::error::InvalidOptionException),
    /// <p>The S3 bucket doesn't exist.</p>
    InvalidOutputFolder(crate::error::InvalidOutputFolder),
    /// <p>The output location isn't valid or doesn't exist.</p>
    InvalidOutputLocation(crate::error::InvalidOutputLocation),
    /// <p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM
    /// document). You can only supply values to parameters defined in the SSM document.</p>
    InvalidParameters(crate::error::InvalidParameters),
    /// <p>The permission type isn't supported. <i>Share</i> is the only supported
    /// permission type.</p>
    InvalidPermissionType(crate::error::InvalidPermissionType),
    /// <p>The plugin name isn't valid.</p>
    InvalidPluginName(crate::error::InvalidPluginName),
    /// <p>A policy attribute or its value is invalid. </p>
    InvalidPolicyAttributeException(crate::error::InvalidPolicyAttributeException),
    /// <p>The policy type isn't supported. Parameter Store supports the following policy types:
    /// Expiration, ExpirationNotification, and NoChangeNotification.</p>
    InvalidPolicyTypeException(crate::error::InvalidPolicyTypeException),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the
    /// instance must be a registered managed node.</p>
    InvalidResourceType(crate::error::InvalidResourceType),
    /// <p>The specified inventory item result attribute isn't valid.</p>
    InvalidResultAttributeException(crate::error::InvalidResultAttributeException),
    /// <p>The role name can't contain invalid characters. Also verify that you specified an IAM role for notifications that includes the required trust policy. For information about
    /// configuring the IAM role for Run Command notifications, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring Amazon SNS Notifications for Run Command</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    InvalidRole(crate::error::InvalidRole),
    /// <p>The schedule is invalid. Verify your cron or rate expression and try again.</p>
    InvalidSchedule(crate::error::InvalidSchedule),
    /// <p>The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might
    /// not have permission to perform the operation.</p>
    InvalidTarget(crate::error::InvalidTarget),
    /// <p>The parameter type name isn't valid.</p>
    InvalidTypeNameException(crate::error::InvalidTypeNameException),
    /// <p>The update isn't valid.</p>
    InvalidUpdate(crate::error::InvalidUpdate),
    /// <p>The command ID and managed node ID you specified didn't match any invocations. Verify the
    /// command ID and the managed node ID and try again. </p>
    InvocationDoesNotExist(crate::error::InvocationDoesNotExist),
    /// <p>The inventory item has invalid content. </p>
    ItemContentMismatchException(crate::error::ItemContentMismatchException),
    /// <p>The inventory item size has exceeded the size limit.</p>
    ItemSizeLimitExceededException(crate::error::ItemSizeLimitExceededException),
    /// <p>The size limit of a document is 64 KB.</p>
    MaxDocumentSizeExceeded(crate::error::MaxDocumentSizeExceeded),
    /// <p>The OpsItem already exists.</p>
    OpsItemAlreadyExistsException(crate::error::OpsItemAlreadyExistsException),
    /// <p>A specified parameter argument isn't valid. Verify the available arguments and try
    /// again.</p>
    OpsItemInvalidParameterException(crate::error::OpsItemInvalidParameterException),
    /// <p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem
    /// quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>
    OpsItemLimitExceededException(crate::error::OpsItemLimitExceededException),
    /// <p>The specified OpsItem ID doesn't exist. Verify the ID and try again.</p>
    OpsItemNotFoundException(crate::error::OpsItemNotFoundException),
    /// <p>The Amazon Resource Name (ARN) is already associated with the OpsItem.</p>
    OpsItemRelatedItemAlreadyExistsException(
        crate::error::OpsItemRelatedItemAlreadyExistsException,
    ),
    /// <p>The association wasn't found using the parameters you specified in the call. Verify the
    /// information and try again.</p>
    OpsItemRelatedItemAssociationNotFoundException(
        crate::error::OpsItemRelatedItemAssociationNotFoundException,
    ),
    /// <p>An OpsMetadata object already exists for the selected resource.</p>
    OpsMetadataAlreadyExistsException(crate::error::OpsMetadataAlreadyExistsException),
    /// <p>One of the arguments passed is invalid. </p>
    OpsMetadataInvalidArgumentException(crate::error::OpsMetadataInvalidArgumentException),
    /// <p>The OpsMetadata object exceeds the maximum number of OpsMetadata keys that you can assign to
    /// an application in Application Manager.</p>
    OpsMetadataKeyLimitExceededException(crate::error::OpsMetadataKeyLimitExceededException),
    /// <p>Your account reached the maximum number of OpsMetadata objects allowed by Application Manager. The
    /// maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata object and try again.</p>
    OpsMetadataLimitExceededException(crate::error::OpsMetadataLimitExceededException),
    /// <p>The OpsMetadata object doesn't exist. </p>
    OpsMetadataNotFoundException(crate::error::OpsMetadataNotFoundException),
    /// <p>The system is processing too many concurrent updates. Wait a few moments and try
    /// again.</p>
    OpsMetadataTooManyUpdatesException(crate::error::OpsMetadataTooManyUpdatesException),
    /// <p>The parameter already exists. You can't create duplicate parameters.</p>
    ParameterAlreadyExists(crate::error::ParameterAlreadyExists),
    /// <p>You have exceeded the number of parameters for this Amazon Web Services account. Delete one or more
    /// parameters and try again.</p>
    ParameterLimitExceeded(crate::error::ParameterLimitExceeded),
    /// <p>Parameter Store retains the 100 most recently created versions of a parameter. After this
    /// number of versions has been created, Parameter Store deletes the oldest version when a new one is
    /// created. However, if the oldest version has a <i>label</i> attached to it,
    /// Parameter Store won't delete the version and instead presents this error message:</p>
    /// <p>
    /// <code>An error occurred (ParameterMaxVersionLimitExceeded) when calling the PutParameter
    /// operation: You attempted to create a new version of <i>parameter-name</i> by
    /// calling the PutParameter API with the overwrite flag. Version
    /// <i>version-number</i>, the oldest version, can't be deleted because it has a
    /// label associated with it. Move the label to another version of the parameter, and try
    /// again.</code>
    /// </p>
    /// <p>This safeguard is to prevent parameter versions with mission critical labels assigned to
    /// them from being deleted. To continue creating new parameters, first move the label from the
    /// oldest version of the parameter to a newer one for use in your operations. For information about
    /// moving parameter labels, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move">Move a parameter label (console)</a> or <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move">Move a parameter label (CLI)</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    ParameterMaxVersionLimitExceeded(crate::error::ParameterMaxVersionLimitExceeded),
    /// <p>The parameter couldn't be found. Verify the name and try again.</p>
    ParameterNotFound(crate::error::ParameterNotFound),
    /// <p>The parameter name isn't valid.</p>
    ParameterPatternMismatchException(crate::error::ParameterPatternMismatchException),
    /// <p>A parameter version can have a maximum of ten labels.</p>
    ParameterVersionLabelLimitExceeded(crate::error::ParameterVersionLabelLimitExceeded),
    /// <p>The specified parameter version wasn't found. Verify the parameter name and version, and try
    /// again.</p>
    ParameterVersionNotFound(crate::error::ParameterVersionNotFound),
    /// <p>You specified more than the maximum number of allowed policies for the parameter. The
    /// maximum is 10.</p>
    PoliciesLimitExceededException(crate::error::PoliciesLimitExceededException),
    /// <p>A sync configuration with the same name already exists.</p>
    ResourceDataSyncAlreadyExistsException(crate::error::ResourceDataSyncAlreadyExistsException),
    /// <p>Another <code>UpdateResourceDataSync</code> request is being processed. Wait a few minutes
    /// and try again.</p>
    ResourceDataSyncConflictException(crate::error::ResourceDataSyncConflictException),
    /// <p>You have exceeded the allowed maximum sync configurations.</p>
    ResourceDataSyncCountExceededException(crate::error::ResourceDataSyncCountExceededException),
    /// <p>The specified sync configuration is invalid.</p>
    ResourceDataSyncInvalidConfigurationException(
        crate::error::ResourceDataSyncInvalidConfigurationException,
    ),
    /// <p>The specified sync name wasn't found.</p>
    ResourceDataSyncNotFoundException(crate::error::ResourceDataSyncNotFoundException),
    /// <p>Error returned if an attempt is made to delete a patch baseline that is registered for a
    /// patch group.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>Error returned when the caller has exceeded the default resource quotas. For example, too
    /// many maintenance windows or patch baselines have been created.</p>
    /// <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The specified service setting wasn't found. Either the service name or the setting hasn't
    /// been provisioned by the Amazon Web Services service team.</p>
    ServiceSettingNotFound(crate::error::ServiceSettingNotFound),
    /// <p>The updated status is the same as the current status.</p>
    StatusUnchanged(crate::error::StatusUnchanged),
    /// <p>The sub-type count exceeded the limit for the inventory type.</p>
    SubTypeCountLimitExceededException(crate::error::SubTypeCountLimitExceededException),
    /// <p>You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow
    /// operation, but the target is still referenced in a task.</p>
    TargetInUseException(crate::error::TargetInUseException),
    /// <p>The specified target managed node for the session isn't fully configured for use with Session Manager. For
    /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html">Getting started with
    /// Session Manager</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. This error is also returned if you
    /// attempt to start a session on a managed node that is located in a different account or Region</p>
    TargetNotConnected(crate::error::TargetNotConnected),
    /// <p>The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try
    /// the command again.</p>
    TooManyTagsError(crate::error::TooManyTagsError),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// <p>The size of inventory data has exceeded the total size limit for the resource.</p>
    TotalSizeLimitExceededException(crate::error::TotalSizeLimitExceededException),
    /// <p>The calendar entry contained in the specified SSM document isn't supported.</p>
    UnsupportedCalendarException(crate::error::UnsupportedCalendarException),
    /// <p>Patching for applications released by Microsoft is only available on EC2 instances and
    /// advanced instances. To patch applications released by Microsoft on on-premises servers and VMs,
    /// you must enable advanced instances. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html">Enabling
    /// the advanced-instances tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    UnsupportedFeatureRequiredException(crate::error::UnsupportedFeatureRequiredException),
    /// <p>The <code>Context</code> attribute that you specified for the <code>InventoryItem</code>
    /// isn't allowed for this inventory type. You can only use the <code>Context</code> attribute with
    /// inventory types like <code>AWS:ComplianceItem</code>.</p>
    UnsupportedInventoryItemContextException(
        crate::error::UnsupportedInventoryItemContextException,
    ),
    /// <p>Inventory item type schema version has to match supported versions in the service. Check
    /// output of GetInventorySchema to see the available schema version for each type.</p>
    UnsupportedInventorySchemaVersionException(
        crate::error::UnsupportedInventorySchemaVersionException,
    ),
    /// <p>The operating systems you specified isn't supported, or the operation isn't supported for
    /// the operating system.</p>
    UnsupportedOperatingSystem(crate::error::UnsupportedOperatingSystem),
    /// <p>The parameter type isn't supported.</p>
    UnsupportedParameterType(crate::error::UnsupportedParameterType),
    /// <p>The document doesn't support the platform type of the given managed node ID(s). For example, you
    /// sent an document for a Windows managed node to a Linux node.</p>
    UnsupportedPlatformType(crate::error::UnsupportedPlatformType),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AlreadyExistsException(inner) => inner.fmt(f),
            Error::AssociatedInstances(inner) => inner.fmt(f),
            Error::AssociationAlreadyExists(inner) => inner.fmt(f),
            Error::AssociationDoesNotExist(inner) => inner.fmt(f),
            Error::AssociationExecutionDoesNotExist(inner) => inner.fmt(f),
            Error::AssociationLimitExceeded(inner) => inner.fmt(f),
            Error::AssociationVersionLimitExceeded(inner) => inner.fmt(f),
            Error::AutomationDefinitionNotApprovedException(inner) => inner.fmt(f),
            Error::AutomationDefinitionNotFoundException(inner) => inner.fmt(f),
            Error::AutomationDefinitionVersionNotFoundException(inner) => inner.fmt(f),
            Error::AutomationExecutionLimitExceededException(inner) => inner.fmt(f),
            Error::AutomationExecutionNotFoundException(inner) => inner.fmt(f),
            Error::AutomationStepNotFoundException(inner) => inner.fmt(f),
            Error::ComplianceTypeCountLimitExceededException(inner) => inner.fmt(f),
            Error::CustomSchemaCountLimitExceededException(inner) => inner.fmt(f),
            Error::DocumentAlreadyExists(inner) => inner.fmt(f),
            Error::DocumentLimitExceeded(inner) => inner.fmt(f),
            Error::DocumentPermissionLimit(inner) => inner.fmt(f),
            Error::DocumentVersionLimitExceeded(inner) => inner.fmt(f),
            Error::DoesNotExistException(inner) => inner.fmt(f),
            Error::DuplicateDocumentContent(inner) => inner.fmt(f),
            Error::DuplicateDocumentVersionName(inner) => inner.fmt(f),
            Error::DuplicateInstanceId(inner) => inner.fmt(f),
            Error::FeatureNotAvailableException(inner) => inner.fmt(f),
            Error::HierarchyLevelLimitExceededException(inner) => inner.fmt(f),
            Error::HierarchyTypeMismatchException(inner) => inner.fmt(f),
            Error::IdempotentParameterMismatch(inner) => inner.fmt(f),
            Error::IncompatiblePolicyException(inner) => inner.fmt(f),
            Error::InternalServerError(inner) => inner.fmt(f),
            Error::InvalidActivation(inner) => inner.fmt(f),
            Error::InvalidActivationId(inner) => inner.fmt(f),
            Error::InvalidAggregatorException(inner) => inner.fmt(f),
            Error::InvalidAllowedPatternException(inner) => inner.fmt(f),
            Error::InvalidAssociation(inner) => inner.fmt(f),
            Error::InvalidAssociationVersion(inner) => inner.fmt(f),
            Error::InvalidAutomationExecutionParametersException(inner) => inner.fmt(f),
            Error::InvalidAutomationSignalException(inner) => inner.fmt(f),
            Error::InvalidAutomationStatusUpdateException(inner) => inner.fmt(f),
            Error::InvalidCommandId(inner) => inner.fmt(f),
            Error::InvalidDeleteInventoryParametersException(inner) => inner.fmt(f),
            Error::InvalidDeletionIdException(inner) => inner.fmt(f),
            Error::InvalidDocument(inner) => inner.fmt(f),
            Error::InvalidDocumentContent(inner) => inner.fmt(f),
            Error::InvalidDocumentOperation(inner) => inner.fmt(f),
            Error::InvalidDocumentSchemaVersion(inner) => inner.fmt(f),
            Error::InvalidDocumentType(inner) => inner.fmt(f),
            Error::InvalidDocumentVersion(inner) => inner.fmt(f),
            Error::InvalidFilter(inner) => inner.fmt(f),
            Error::InvalidFilterKey(inner) => inner.fmt(f),
            Error::InvalidFilterOption(inner) => inner.fmt(f),
            Error::InvalidFilterValue(inner) => inner.fmt(f),
            Error::InvalidInstanceId(inner) => inner.fmt(f),
            Error::InvalidInstanceInformationFilterValue(inner) => inner.fmt(f),
            Error::InvalidInventoryGroupException(inner) => inner.fmt(f),
            Error::InvalidInventoryItemContextException(inner) => inner.fmt(f),
            Error::InvalidInventoryRequestException(inner) => inner.fmt(f),
            Error::InvalidItemContentException(inner) => inner.fmt(f),
            Error::InvalidKeyId(inner) => inner.fmt(f),
            Error::InvalidNextToken(inner) => inner.fmt(f),
            Error::InvalidNotificationConfig(inner) => inner.fmt(f),
            Error::InvalidOptionException(inner) => inner.fmt(f),
            Error::InvalidOutputFolder(inner) => inner.fmt(f),
            Error::InvalidOutputLocation(inner) => inner.fmt(f),
            Error::InvalidParameters(inner) => inner.fmt(f),
            Error::InvalidPermissionType(inner) => inner.fmt(f),
            Error::InvalidPluginName(inner) => inner.fmt(f),
            Error::InvalidPolicyAttributeException(inner) => inner.fmt(f),
            Error::InvalidPolicyTypeException(inner) => inner.fmt(f),
            Error::InvalidResourceId(inner) => inner.fmt(f),
            Error::InvalidResourceType(inner) => inner.fmt(f),
            Error::InvalidResultAttributeException(inner) => inner.fmt(f),
            Error::InvalidRole(inner) => inner.fmt(f),
            Error::InvalidSchedule(inner) => inner.fmt(f),
            Error::InvalidTarget(inner) => inner.fmt(f),
            Error::InvalidTypeNameException(inner) => inner.fmt(f),
            Error::InvalidUpdate(inner) => inner.fmt(f),
            Error::InvocationDoesNotExist(inner) => inner.fmt(f),
            Error::ItemContentMismatchException(inner) => inner.fmt(f),
            Error::ItemSizeLimitExceededException(inner) => inner.fmt(f),
            Error::MaxDocumentSizeExceeded(inner) => inner.fmt(f),
            Error::OpsItemAlreadyExistsException(inner) => inner.fmt(f),
            Error::OpsItemInvalidParameterException(inner) => inner.fmt(f),
            Error::OpsItemLimitExceededException(inner) => inner.fmt(f),
            Error::OpsItemNotFoundException(inner) => inner.fmt(f),
            Error::OpsItemRelatedItemAlreadyExistsException(inner) => inner.fmt(f),
            Error::OpsItemRelatedItemAssociationNotFoundException(inner) => inner.fmt(f),
            Error::OpsMetadataAlreadyExistsException(inner) => inner.fmt(f),
            Error::OpsMetadataInvalidArgumentException(inner) => inner.fmt(f),
            Error::OpsMetadataKeyLimitExceededException(inner) => inner.fmt(f),
            Error::OpsMetadataLimitExceededException(inner) => inner.fmt(f),
            Error::OpsMetadataNotFoundException(inner) => inner.fmt(f),
            Error::OpsMetadataTooManyUpdatesException(inner) => inner.fmt(f),
            Error::ParameterAlreadyExists(inner) => inner.fmt(f),
            Error::ParameterLimitExceeded(inner) => inner.fmt(f),
            Error::ParameterMaxVersionLimitExceeded(inner) => inner.fmt(f),
            Error::ParameterNotFound(inner) => inner.fmt(f),
            Error::ParameterPatternMismatchException(inner) => inner.fmt(f),
            Error::ParameterVersionLabelLimitExceeded(inner) => inner.fmt(f),
            Error::ParameterVersionNotFound(inner) => inner.fmt(f),
            Error::PoliciesLimitExceededException(inner) => inner.fmt(f),
            Error::ResourceDataSyncAlreadyExistsException(inner) => inner.fmt(f),
            Error::ResourceDataSyncConflictException(inner) => inner.fmt(f),
            Error::ResourceDataSyncCountExceededException(inner) => inner.fmt(f),
            Error::ResourceDataSyncInvalidConfigurationException(inner) => inner.fmt(f),
            Error::ResourceDataSyncNotFoundException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceLimitExceededException(inner) => inner.fmt(f),
            Error::ServiceSettingNotFound(inner) => inner.fmt(f),
            Error::StatusUnchanged(inner) => inner.fmt(f),
            Error::SubTypeCountLimitExceededException(inner) => inner.fmt(f),
            Error::TargetInUseException(inner) => inner.fmt(f),
            Error::TargetNotConnected(inner) => inner.fmt(f),
            Error::TooManyTagsError(inner) => inner.fmt(f),
            Error::TooManyUpdates(inner) => inner.fmt(f),
            Error::TotalSizeLimitExceededException(inner) => inner.fmt(f),
            Error::UnsupportedCalendarException(inner) => inner.fmt(f),
            Error::UnsupportedFeatureRequiredException(inner) => inner.fmt(f),
            Error::UnsupportedInventoryItemContextException(inner) => inner.fmt(f),
            Error::UnsupportedInventorySchemaVersionException(inner) => inner.fmt(f),
            Error::UnsupportedOperatingSystem(inner) => inner.fmt(f),
            Error::UnsupportedParameterType(inner) => inner.fmt(f),
            Error::UnsupportedPlatformType(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::AddTagsToResourceErrorKind::InvalidResourceId(inner) => {
                    Error::InvalidResourceId(inner)
                }
                crate::error::AddTagsToResourceErrorKind::InvalidResourceType(inner) => {
                    Error::InvalidResourceType(inner)
                }
                crate::error::AddTagsToResourceErrorKind::TooManyTagsError(inner) => {
                    Error::TooManyTagsError(inner)
                }
                crate::error::AddTagsToResourceErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateOpsItemRelatedItemError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateOpsItemRelatedItemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateOpsItemRelatedItemErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::AssociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(inner) => Error::OpsItemInvalidParameterException(inner),
                crate::error::AssociateOpsItemRelatedItemErrorKind::OpsItemLimitExceededException(inner) => Error::OpsItemLimitExceededException(inner),
                crate::error::AssociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(inner) => Error::OpsItemNotFoundException(inner),
                crate::error::AssociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAlreadyExistsException(inner) => Error::OpsItemRelatedItemAlreadyExistsException(inner),
                crate::error::AssociateOpsItemRelatedItemErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelCommandError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CancelCommandError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelCommandErrorKind::DuplicateInstanceId(inner) => {
                    Error::DuplicateInstanceId(inner)
                }
                crate::error::CancelCommandErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CancelCommandErrorKind::InvalidCommandId(inner) => {
                    Error::InvalidCommandId(inner)
                }
                crate::error::CancelCommandErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::CancelCommandErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CancelMaintenanceWindowExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CancelMaintenanceWindowExecutionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelMaintenanceWindowExecutionErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::CancelMaintenanceWindowExecutionErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::CancelMaintenanceWindowExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateActivationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateActivationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateActivationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateActivationErrorKind::InvalidParameters(inner) => {
                    Error::InvalidParameters(inner)
                }
                crate::error::CreateActivationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAssociationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAssociationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAssociationErrorKind::AssociationAlreadyExists(inner) => {
                    Error::AssociationAlreadyExists(inner)
                }
                crate::error::CreateAssociationErrorKind::AssociationLimitExceeded(inner) => {
                    Error::AssociationLimitExceeded(inner)
                }
                crate::error::CreateAssociationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateAssociationErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::CreateAssociationErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::CreateAssociationErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::CreateAssociationErrorKind::InvalidOutputLocation(inner) => {
                    Error::InvalidOutputLocation(inner)
                }
                crate::error::CreateAssociationErrorKind::InvalidParameters(inner) => {
                    Error::InvalidParameters(inner)
                }
                crate::error::CreateAssociationErrorKind::InvalidSchedule(inner) => {
                    Error::InvalidSchedule(inner)
                }
                crate::error::CreateAssociationErrorKind::InvalidTarget(inner) => {
                    Error::InvalidTarget(inner)
                }
                crate::error::CreateAssociationErrorKind::UnsupportedPlatformType(inner) => {
                    Error::UnsupportedPlatformType(inner)
                }
                crate::error::CreateAssociationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAssociationBatchError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAssociationBatchError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAssociationBatchErrorKind::AssociationLimitExceeded(inner) => {
                    Error::AssociationLimitExceeded(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::DuplicateInstanceId(inner) => {
                    Error::DuplicateInstanceId(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InvalidOutputLocation(inner) => {
                    Error::InvalidOutputLocation(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InvalidParameters(inner) => {
                    Error::InvalidParameters(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InvalidSchedule(inner) => {
                    Error::InvalidSchedule(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::InvalidTarget(inner) => {
                    Error::InvalidTarget(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::UnsupportedPlatformType(inner) => {
                    Error::UnsupportedPlatformType(inner)
                }
                crate::error::CreateAssociationBatchErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDocumentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDocumentErrorKind::DocumentAlreadyExists(inner) => {
                    Error::DocumentAlreadyExists(inner)
                }
                crate::error::CreateDocumentErrorKind::DocumentLimitExceeded(inner) => {
                    Error::DocumentLimitExceeded(inner)
                }
                crate::error::CreateDocumentErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateDocumentErrorKind::InvalidDocumentContent(inner) => {
                    Error::InvalidDocumentContent(inner)
                }
                crate::error::CreateDocumentErrorKind::InvalidDocumentSchemaVersion(inner) => {
                    Error::InvalidDocumentSchemaVersion(inner)
                }
                crate::error::CreateDocumentErrorKind::MaxDocumentSizeExceeded(inner) => {
                    Error::MaxDocumentSizeExceeded(inner)
                }
                crate::error::CreateDocumentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateMaintenanceWindowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateMaintenanceWindowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateMaintenanceWindowErrorKind::IdempotentParameterMismatch(
                    inner,
                ) => Error::IdempotentParameterMismatch(inner),
                crate::error::CreateMaintenanceWindowErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateMaintenanceWindowErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateMaintenanceWindowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateOpsItemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateOpsItemError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateOpsItemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateOpsItemErrorKind::OpsItemAlreadyExistsException(inner) => {
                    Error::OpsItemAlreadyExistsException(inner)
                }
                crate::error::CreateOpsItemErrorKind::OpsItemInvalidParameterException(inner) => {
                    Error::OpsItemInvalidParameterException(inner)
                }
                crate::error::CreateOpsItemErrorKind::OpsItemLimitExceededException(inner) => {
                    Error::OpsItemLimitExceededException(inner)
                }
                crate::error::CreateOpsItemErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateOpsMetadataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateOpsMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateOpsMetadataErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateOpsMetadataErrorKind::OpsMetadataAlreadyExistsException(
                    inner,
                ) => Error::OpsMetadataAlreadyExistsException(inner),
                crate::error::CreateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(
                    inner,
                ) => Error::OpsMetadataInvalidArgumentException(inner),
                crate::error::CreateOpsMetadataErrorKind::OpsMetadataLimitExceededException(
                    inner,
                ) => Error::OpsMetadataLimitExceededException(inner),
                crate::error::CreateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(
                    inner,
                ) => Error::OpsMetadataTooManyUpdatesException(inner),
                crate::error::CreateOpsMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePatchBaselineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePatchBaselineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePatchBaselineErrorKind::IdempotentParameterMismatch(inner) => {
                    Error::IdempotentParameterMismatch(inner)
                }
                crate::error::CreatePatchBaselineErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreatePatchBaselineErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreatePatchBaselineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResourceDataSyncError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateResourceDataSyncError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateResourceDataSyncErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::CreateResourceDataSyncErrorKind::ResourceDataSyncAlreadyExistsException(inner) => Error::ResourceDataSyncAlreadyExistsException(inner),
                crate::error::CreateResourceDataSyncErrorKind::ResourceDataSyncCountExceededException(inner) => Error::ResourceDataSyncCountExceededException(inner),
                crate::error::CreateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(inner) => Error::ResourceDataSyncInvalidConfigurationException(inner),
                crate::error::CreateResourceDataSyncErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteActivationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteActivationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteActivationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteActivationErrorKind::InvalidActivation(inner) => {
                    Error::InvalidActivation(inner)
                }
                crate::error::DeleteActivationErrorKind::InvalidActivationId(inner) => {
                    Error::InvalidActivationId(inner)
                }
                crate::error::DeleteActivationErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::DeleteActivationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAssociationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAssociationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAssociationErrorKind::AssociationDoesNotExist(inner) => {
                    Error::AssociationDoesNotExist(inner)
                }
                crate::error::DeleteAssociationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteAssociationErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::DeleteAssociationErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::DeleteAssociationErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::DeleteAssociationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDocumentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDocumentErrorKind::AssociatedInstances(inner) => {
                    Error::AssociatedInstances(inner)
                }
                crate::error::DeleteDocumentErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteDocumentErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::DeleteDocumentErrorKind::InvalidDocumentOperation(inner) => {
                    Error::InvalidDocumentOperation(inner)
                }
                crate::error::DeleteDocumentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteInventoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteInventoryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteInventoryErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeleteInventoryErrorKind::InvalidDeleteInventoryParametersException(inner) => Error::InvalidDeleteInventoryParametersException(inner),
                crate::error::DeleteInventoryErrorKind::InvalidInventoryRequestException(inner) => Error::InvalidInventoryRequestException(inner),
                crate::error::DeleteInventoryErrorKind::InvalidOptionException(inner) => Error::InvalidOptionException(inner),
                crate::error::DeleteInventoryErrorKind::InvalidTypeNameException(inner) => Error::InvalidTypeNameException(inner),
                crate::error::DeleteInventoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteMaintenanceWindowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteMaintenanceWindowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteMaintenanceWindowErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteMaintenanceWindowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteOpsMetadataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteOpsMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteOpsMetadataErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(
                    inner,
                ) => Error::OpsMetadataInvalidArgumentException(inner),
                crate::error::DeleteOpsMetadataErrorKind::OpsMetadataNotFoundException(inner) => {
                    Error::OpsMetadataNotFoundException(inner)
                }
                crate::error::DeleteOpsMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteParameterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteParameterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteParameterErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteParameterErrorKind::ParameterNotFound(inner) => {
                    Error::ParameterNotFound(inner)
                }
                crate::error::DeleteParameterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteParametersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteParametersErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePatchBaselineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeletePatchBaselineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePatchBaselineErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeletePatchBaselineErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeletePatchBaselineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResourceDataSyncError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResourceDataSyncError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteResourceDataSyncErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeleteResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(inner) => Error::ResourceDataSyncInvalidConfigurationException(inner),
                crate::error::DeleteResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(inner) => Error::ResourceDataSyncNotFoundException(inner),
                crate::error::DeleteResourceDataSyncErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterManagedInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterManagedInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterManagedInstanceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeregisterManagedInstanceErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::DeregisterManagedInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeregisterPatchBaselineForPatchGroupError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeregisterPatchBaselineForPatchGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterPatchBaselineForPatchGroupErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeregisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(inner) => Error::InvalidResourceId(inner),
                crate::error::DeregisterPatchBaselineForPatchGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeregisterTargetFromMaintenanceWindowError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeregisterTargetFromMaintenanceWindowError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterTargetFromMaintenanceWindowErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::DeregisterTargetFromMaintenanceWindowErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeregisterTargetFromMaintenanceWindowErrorKind::TargetInUseException(inner) => Error::TargetInUseException(inner),
                crate::error::DeregisterTargetFromMaintenanceWindowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeregisterTaskFromMaintenanceWindowError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeregisterTaskFromMaintenanceWindowError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterTaskFromMaintenanceWindowErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::DeregisterTaskFromMaintenanceWindowErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeregisterTaskFromMaintenanceWindowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeActivationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeActivationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeActivationsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeActivationsErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::DescribeActivationsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeActivationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAssociationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAssociationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAssociationErrorKind::AssociationDoesNotExist(inner) => {
                    Error::AssociationDoesNotExist(inner)
                }
                crate::error::DescribeAssociationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeAssociationErrorKind::InvalidAssociationVersion(inner) => {
                    Error::InvalidAssociationVersion(inner)
                }
                crate::error::DescribeAssociationErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::DescribeAssociationErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::DescribeAssociationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAssociationExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAssociationExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAssociationExecutionsErrorKind::AssociationDoesNotExist(
                    inner,
                ) => Error::AssociationDoesNotExist(inner),
                crate::error::DescribeAssociationExecutionsErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeAssociationExecutionsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeAssociationExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeAssociationExecutionTargetsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAssociationExecutionTargetsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAssociationExecutionTargetsErrorKind::AssociationDoesNotExist(inner) => Error::AssociationDoesNotExist(inner),
                crate::error::DescribeAssociationExecutionTargetsErrorKind::AssociationExecutionDoesNotExist(inner) => Error::AssociationExecutionDoesNotExist(inner),
                crate::error::DescribeAssociationExecutionTargetsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeAssociationExecutionTargetsErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::DescribeAssociationExecutionTargetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAutomationExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAutomationExecutionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAutomationExecutionsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeAutomationExecutionsErrorKind::InvalidFilterKey(inner) => {
                    Error::InvalidFilterKey(inner)
                }
                crate::error::DescribeAutomationExecutionsErrorKind::InvalidFilterValue(inner) => {
                    Error::InvalidFilterValue(inner)
                }
                crate::error::DescribeAutomationExecutionsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeAutomationExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeAutomationStepExecutionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAutomationStepExecutionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAutomationStepExecutionsErrorKind::AutomationExecutionNotFoundException(inner) => Error::AutomationExecutionNotFoundException(inner),
                crate::error::DescribeAutomationStepExecutionsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeAutomationStepExecutionsErrorKind::InvalidFilterKey(inner) => Error::InvalidFilterKey(inner),
                crate::error::DescribeAutomationStepExecutionsErrorKind::InvalidFilterValue(inner) => Error::InvalidFilterValue(inner),
                crate::error::DescribeAutomationStepExecutionsErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::DescribeAutomationStepExecutionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAvailablePatchesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAvailablePatchesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAvailablePatchesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeAvailablePatchesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDocumentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDocumentErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeDocumentErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::DescribeDocumentErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::DescribeDocumentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDocumentPermissionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDocumentPermissionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDocumentPermissionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeDocumentPermissionErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::DescribeDocumentPermissionErrorKind::InvalidDocumentOperation(
                    inner,
                ) => Error::InvalidDocumentOperation(inner),
                crate::error::DescribeDocumentPermissionErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeDocumentPermissionErrorKind::InvalidPermissionType(inner) => {
                    Error::InvalidPermissionType(inner)
                }
                crate::error::DescribeDocumentPermissionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeEffectiveInstanceAssociationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEffectiveInstanceAssociationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeEffectiveInstanceAssociationsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeEffectiveInstanceAssociationsErrorKind::InvalidInstanceId(inner) => Error::InvalidInstanceId(inner),
                crate::error::DescribeEffectiveInstanceAssociationsErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::DescribeEffectiveInstanceAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeEffectivePatchesForPatchBaselineError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEffectivePatchesForPatchBaselineError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeEffectivePatchesForPatchBaselineErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::DescribeEffectivePatchesForPatchBaselineErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeEffectivePatchesForPatchBaselineErrorKind::InvalidResourceId(inner) => Error::InvalidResourceId(inner),
                crate::error::DescribeEffectivePatchesForPatchBaselineErrorKind::UnsupportedOperatingSystem(inner) => Error::UnsupportedOperatingSystem(inner),
                crate::error::DescribeEffectivePatchesForPatchBaselineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeInstanceAssociationsStatusError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeInstanceAssociationsStatusError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeInstanceAssociationsStatusErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeInstanceAssociationsStatusErrorKind::InvalidInstanceId(
                    inner,
                ) => Error::InvalidInstanceId(inner),
                crate::error::DescribeInstanceAssociationsStatusErrorKind::InvalidNextToken(
                    inner,
                ) => Error::InvalidNextToken(inner),
                crate::error::DescribeInstanceAssociationsStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInstanceInformationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInstanceInformationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeInstanceInformationErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeInstanceInformationErrorKind::InvalidFilterKey(inner) => Error::InvalidFilterKey(inner),
                crate::error::DescribeInstanceInformationErrorKind::InvalidInstanceId(inner) => Error::InvalidInstanceId(inner),
                crate::error::DescribeInstanceInformationErrorKind::InvalidInstanceInformationFilterValue(inner) => Error::InvalidInstanceInformationFilterValue(inner),
                crate::error::DescribeInstanceInformationErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::DescribeInstanceInformationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeInstancePatchesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeInstancePatchesErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::DescribeInstancePatchesErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::DescribeInstancePatchesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeInstancePatchesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchStatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchStatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeInstancePatchStatesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeInstancePatchStatesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeInstancePatchStatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeInstancePatchStatesForPatchGroupError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeInstancePatchStatesForPatchGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeInstancePatchStatesForPatchGroupErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidFilter(inner) => Error::InvalidFilter(inner),
                crate::error::DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::DescribeInstancePatchStatesForPatchGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInventoryDeletionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInventoryDeletionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeInventoryDeletionsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeInventoryDeletionsErrorKind::InvalidDeletionIdException(
                    inner,
                ) => Error::InvalidDeletionIdException(inner),
                crate::error::DescribeInventoryDeletionsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeInventoryDeletionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowExecutionsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowExecutionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMaintenanceWindowExecutionsErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceWindowExecutionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowExecutionTasksError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowExecutionTasksError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeMaintenanceWindowExecutionTasksErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::DescribeMaintenanceWindowExecutionTasksErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceWindowExecutionTasksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMaintenanceWindowsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeMaintenanceWindowsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowScheduleError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMaintenanceWindowScheduleErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::DescribeMaintenanceWindowScheduleErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceWindowScheduleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowsForTargetError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowsForTargetError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMaintenanceWindowsForTargetErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceWindowsForTargetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowTargetsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMaintenanceWindowTargetsErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::DescribeMaintenanceWindowTargetsErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceWindowTargetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowTasksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMaintenanceWindowTasksError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMaintenanceWindowTasksErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::DescribeMaintenanceWindowTasksErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeMaintenanceWindowTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeOpsItemsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeOpsItemsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOpsItemsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeOpsItemsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeParametersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeParametersErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeParametersErrorKind::InvalidFilterKey(inner) => {
                    Error::InvalidFilterKey(inner)
                }
                crate::error::DescribeParametersErrorKind::InvalidFilterOption(inner) => {
                    Error::InvalidFilterOption(inner)
                }
                crate::error::DescribeParametersErrorKind::InvalidFilterValue(inner) => {
                    Error::InvalidFilterValue(inner)
                }
                crate::error::DescribeParametersErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePatchBaselinesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePatchBaselinesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePatchBaselinesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribePatchBaselinesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePatchGroupsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribePatchGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePatchGroupStateErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribePatchGroupStateErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribePatchGroupStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePatchPropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePatchPropertiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePatchPropertiesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribePatchPropertiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSessionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSessionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSessionsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeSessionsErrorKind::InvalidFilterKey(inner) => {
                    Error::InvalidFilterKey(inner)
                }
                crate::error::DescribeSessionsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::DescribeSessionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DisassociateOpsItemRelatedItemError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateOpsItemRelatedItemError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateOpsItemRelatedItemErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DisassociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(inner) => Error::OpsItemInvalidParameterException(inner),
                crate::error::DisassociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(inner) => Error::OpsItemNotFoundException(inner),
                crate::error::DisassociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAssociationNotFoundException(inner) => Error::OpsItemRelatedItemAssociationNotFoundException(inner),
                crate::error::DisassociateOpsItemRelatedItemErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAutomationExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAutomationExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetAutomationExecutionErrorKind::AutomationExecutionNotFoundException(inner) => Error::AutomationExecutionNotFoundException(inner),
                crate::error::GetAutomationExecutionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetAutomationExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCalendarStateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCalendarStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCalendarStateErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetCalendarStateErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::GetCalendarStateErrorKind::InvalidDocumentType(inner) => {
                    Error::InvalidDocumentType(inner)
                }
                crate::error::GetCalendarStateErrorKind::UnsupportedCalendarException(inner) => {
                    Error::UnsupportedCalendarException(inner)
                }
                crate::error::GetCalendarStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCommandInvocationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCommandInvocationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCommandInvocationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetCommandInvocationErrorKind::InvalidCommandId(inner) => {
                    Error::InvalidCommandId(inner)
                }
                crate::error::GetCommandInvocationErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::GetCommandInvocationErrorKind::InvalidPluginName(inner) => {
                    Error::InvalidPluginName(inner)
                }
                crate::error::GetCommandInvocationErrorKind::InvocationDoesNotExist(inner) => {
                    Error::InvocationDoesNotExist(inner)
                }
                crate::error::GetCommandInvocationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetConnectionStatusError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetConnectionStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetConnectionStatusErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetConnectionStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDefaultPatchBaselineError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDefaultPatchBaselineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDefaultPatchBaselineErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetDefaultPatchBaselineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetDeployablePatchSnapshotForInstanceError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetDeployablePatchSnapshotForInstanceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDeployablePatchSnapshotForInstanceErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedFeatureRequiredException(inner) => Error::UnsupportedFeatureRequiredException(inner),
                crate::error::GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedOperatingSystem(inner) => Error::UnsupportedOperatingSystem(inner),
                crate::error::GetDeployablePatchSnapshotForInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDocumentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDocumentErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetDocumentErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::GetDocumentErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::GetDocumentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInventoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetInventoryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInventoryErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetInventoryErrorKind::InvalidAggregatorException(inner) => {
                    Error::InvalidAggregatorException(inner)
                }
                crate::error::GetInventoryErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::GetInventoryErrorKind::InvalidInventoryGroupException(inner) => {
                    Error::InvalidInventoryGroupException(inner)
                }
                crate::error::GetInventoryErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::GetInventoryErrorKind::InvalidResultAttributeException(inner) => {
                    Error::InvalidResultAttributeException(inner)
                }
                crate::error::GetInventoryErrorKind::InvalidTypeNameException(inner) => {
                    Error::InvalidTypeNameException(inner)
                }
                crate::error::GetInventoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInventorySchemaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetInventorySchemaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInventorySchemaErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetInventorySchemaErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::GetInventorySchemaErrorKind::InvalidTypeNameException(inner) => {
                    Error::InvalidTypeNameException(inner)
                }
                crate::error::GetInventorySchemaErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMaintenanceWindowErrorKind::DoesNotExistException(inner) => {
                    Error::DoesNotExistException(inner)
                }
                crate::error::GetMaintenanceWindowErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetMaintenanceWindowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMaintenanceWindowExecutionErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::GetMaintenanceWindowExecutionErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::GetMaintenanceWindowExecutionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowExecutionTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetMaintenanceWindowExecutionTaskError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMaintenanceWindowExecutionTaskErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::GetMaintenanceWindowExecutionTaskErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::GetMaintenanceWindowExecutionTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetMaintenanceWindowExecutionTaskInvocationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetMaintenanceWindowExecutionTaskInvocationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetMaintenanceWindowExecutionTaskInvocationErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::GetMaintenanceWindowExecutionTaskInvocationErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetMaintenanceWindowExecutionTaskInvocationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMaintenanceWindowTaskErrorKind::DoesNotExistException(inner) => {
                    Error::DoesNotExistException(inner)
                }
                crate::error::GetMaintenanceWindowTaskErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetMaintenanceWindowTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOpsItemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetOpsItemError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOpsItemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetOpsItemErrorKind::OpsItemNotFoundException(inner) => {
                    Error::OpsItemNotFoundException(inner)
                }
                crate::error::GetOpsItemErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOpsMetadataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetOpsMetadataError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOpsMetadataErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(
                    inner,
                ) => Error::OpsMetadataInvalidArgumentException(inner),
                crate::error::GetOpsMetadataErrorKind::OpsMetadataNotFoundException(inner) => {
                    Error::OpsMetadataNotFoundException(inner)
                }
                crate::error::GetOpsMetadataErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOpsSummaryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetOpsSummaryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOpsSummaryErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetOpsSummaryErrorKind::InvalidAggregatorException(inner) => {
                    Error::InvalidAggregatorException(inner)
                }
                crate::error::GetOpsSummaryErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::GetOpsSummaryErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::GetOpsSummaryErrorKind::InvalidTypeNameException(inner) => {
                    Error::InvalidTypeNameException(inner)
                }
                crate::error::GetOpsSummaryErrorKind::ResourceDataSyncNotFoundException(inner) => {
                    Error::ResourceDataSyncNotFoundException(inner)
                }
                crate::error::GetOpsSummaryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetParameterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetParameterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetParameterErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetParameterErrorKind::InvalidKeyId(inner) => {
                    Error::InvalidKeyId(inner)
                }
                crate::error::GetParameterErrorKind::ParameterNotFound(inner) => {
                    Error::ParameterNotFound(inner)
                }
                crate::error::GetParameterErrorKind::ParameterVersionNotFound(inner) => {
                    Error::ParameterVersionNotFound(inner)
                }
                crate::error::GetParameterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetParameterHistoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetParameterHistoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetParameterHistoryErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetParameterHistoryErrorKind::InvalidKeyId(inner) => {
                    Error::InvalidKeyId(inner)
                }
                crate::error::GetParameterHistoryErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::GetParameterHistoryErrorKind::ParameterNotFound(inner) => {
                    Error::ParameterNotFound(inner)
                }
                crate::error::GetParameterHistoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetParametersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetParametersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetParametersErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetParametersErrorKind::InvalidKeyId(inner) => {
                    Error::InvalidKeyId(inner)
                }
                crate::error::GetParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetParametersByPathError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetParametersByPathError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetParametersByPathErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetParametersByPathErrorKind::InvalidFilterKey(inner) => {
                    Error::InvalidFilterKey(inner)
                }
                crate::error::GetParametersByPathErrorKind::InvalidFilterOption(inner) => {
                    Error::InvalidFilterOption(inner)
                }
                crate::error::GetParametersByPathErrorKind::InvalidFilterValue(inner) => {
                    Error::InvalidFilterValue(inner)
                }
                crate::error::GetParametersByPathErrorKind::InvalidKeyId(inner) => {
                    Error::InvalidKeyId(inner)
                }
                crate::error::GetParametersByPathErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::GetParametersByPathErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPatchBaselineErrorKind::DoesNotExistException(inner) => {
                    Error::DoesNotExistException(inner)
                }
                crate::error::GetPatchBaselineErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetPatchBaselineErrorKind::InvalidResourceId(inner) => {
                    Error::InvalidResourceId(inner)
                }
                crate::error::GetPatchBaselineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineForPatchGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineForPatchGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPatchBaselineForPatchGroupErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::GetPatchBaselineForPatchGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetServiceSettingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetServiceSettingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetServiceSettingErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetServiceSettingErrorKind::ServiceSettingNotFound(inner) => {
                    Error::ServiceSettingNotFound(inner)
                }
                crate::error::GetServiceSettingErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::LabelParameterVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::LabelParameterVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::LabelParameterVersionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::LabelParameterVersionErrorKind::ParameterNotFound(inner) => Error::ParameterNotFound(inner),
                crate::error::LabelParameterVersionErrorKind::ParameterVersionLabelLimitExceeded(inner) => Error::ParameterVersionLabelLimitExceeded(inner),
                crate::error::LabelParameterVersionErrorKind::ParameterVersionNotFound(inner) => Error::ParameterVersionNotFound(inner),
                crate::error::LabelParameterVersionErrorKind::TooManyUpdates(inner) => Error::TooManyUpdates(inner),
                crate::error::LabelParameterVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAssociationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAssociationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAssociationsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListAssociationsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListAssociationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAssociationVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAssociationVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAssociationVersionsErrorKind::AssociationDoesNotExist(inner) => {
                    Error::AssociationDoesNotExist(inner)
                }
                crate::error::ListAssociationVersionsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListAssociationVersionsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListAssociationVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCommandInvocationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCommandInvocationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCommandInvocationsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListCommandInvocationsErrorKind::InvalidCommandId(inner) => {
                    Error::InvalidCommandId(inner)
                }
                crate::error::ListCommandInvocationsErrorKind::InvalidFilterKey(inner) => {
                    Error::InvalidFilterKey(inner)
                }
                crate::error::ListCommandInvocationsErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::ListCommandInvocationsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListCommandInvocationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCommandsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListCommandsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCommandsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListCommandsErrorKind::InvalidCommandId(inner) => {
                    Error::InvalidCommandId(inner)
                }
                crate::error::ListCommandsErrorKind::InvalidFilterKey(inner) => {
                    Error::InvalidFilterKey(inner)
                }
                crate::error::ListCommandsErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::ListCommandsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListCommandsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListComplianceItemsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListComplianceItemsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListComplianceItemsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListComplianceItemsErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::ListComplianceItemsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListComplianceItemsErrorKind::InvalidResourceId(inner) => {
                    Error::InvalidResourceId(inner)
                }
                crate::error::ListComplianceItemsErrorKind::InvalidResourceType(inner) => {
                    Error::InvalidResourceType(inner)
                }
                crate::error::ListComplianceItemsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListComplianceSummariesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListComplianceSummariesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListComplianceSummariesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListComplianceSummariesErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::ListComplianceSummariesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListComplianceSummariesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDocumentMetadataHistoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDocumentMetadataHistoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDocumentMetadataHistoryErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListDocumentMetadataHistoryErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::ListDocumentMetadataHistoryErrorKind::InvalidDocumentVersion(
                    inner,
                ) => Error::InvalidDocumentVersion(inner),
                crate::error::ListDocumentMetadataHistoryErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListDocumentMetadataHistoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDocumentsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListDocumentsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDocumentsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListDocumentsErrorKind::InvalidFilterKey(inner) => {
                    Error::InvalidFilterKey(inner)
                }
                crate::error::ListDocumentsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListDocumentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDocumentVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDocumentVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDocumentVersionsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListDocumentVersionsErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::ListDocumentVersionsErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListDocumentVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListInventoryEntriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListInventoryEntriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListInventoryEntriesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListInventoryEntriesErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::ListInventoryEntriesErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::ListInventoryEntriesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListInventoryEntriesErrorKind::InvalidTypeNameException(inner) => {
                    Error::InvalidTypeNameException(inner)
                }
                crate::error::ListInventoryEntriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOpsItemEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListOpsItemEventsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListOpsItemEventsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListOpsItemEventsErrorKind::OpsItemInvalidParameterException(
                    inner,
                ) => Error::OpsItemInvalidParameterException(inner),
                crate::error::ListOpsItemEventsErrorKind::OpsItemLimitExceededException(inner) => {
                    Error::OpsItemLimitExceededException(inner)
                }
                crate::error::ListOpsItemEventsErrorKind::OpsItemNotFoundException(inner) => {
                    Error::OpsItemNotFoundException(inner)
                }
                crate::error::ListOpsItemEventsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOpsItemRelatedItemsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListOpsItemRelatedItemsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListOpsItemRelatedItemsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::ListOpsItemRelatedItemsErrorKind::OpsItemInvalidParameterException(inner) => Error::OpsItemInvalidParameterException(inner),
                crate::error::ListOpsItemRelatedItemsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOpsMetadataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListOpsMetadataError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListOpsMetadataErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(
                    inner,
                ) => Error::OpsMetadataInvalidArgumentException(inner),
                crate::error::ListOpsMetadataErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListResourceComplianceSummariesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListResourceComplianceSummariesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourceComplianceSummariesErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::ListResourceComplianceSummariesErrorKind::InvalidFilter(inner) => {
                    Error::InvalidFilter(inner)
                }
                crate::error::ListResourceComplianceSummariesErrorKind::InvalidNextToken(inner) => {
                    Error::InvalidNextToken(inner)
                }
                crate::error::ListResourceComplianceSummariesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourceDataSyncError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResourceDataSyncError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListResourceDataSyncErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::ListResourceDataSyncErrorKind::InvalidNextToken(inner) => Error::InvalidNextToken(inner),
                crate::error::ListResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(inner) => Error::ResourceDataSyncInvalidConfigurationException(inner),
                crate::error::ListResourceDataSyncErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidResourceId(inner) => {
                    Error::InvalidResourceId(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidResourceType(inner) => {
                    Error::InvalidResourceType(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDocumentPermissionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDocumentPermissionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDocumentPermissionErrorKind::DocumentLimitExceeded(inner) => {
                    Error::DocumentLimitExceeded(inner)
                }
                crate::error::ModifyDocumentPermissionErrorKind::DocumentPermissionLimit(inner) => {
                    Error::DocumentPermissionLimit(inner)
                }
                crate::error::ModifyDocumentPermissionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ModifyDocumentPermissionErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::ModifyDocumentPermissionErrorKind::InvalidPermissionType(inner) => {
                    Error::InvalidPermissionType(inner)
                }
                crate::error::ModifyDocumentPermissionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutComplianceItemsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutComplianceItemsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutComplianceItemsErrorKind::ComplianceTypeCountLimitExceededException(inner) => Error::ComplianceTypeCountLimitExceededException(inner),
                crate::error::PutComplianceItemsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::PutComplianceItemsErrorKind::InvalidItemContentException(inner) => Error::InvalidItemContentException(inner),
                crate::error::PutComplianceItemsErrorKind::InvalidResourceId(inner) => Error::InvalidResourceId(inner),
                crate::error::PutComplianceItemsErrorKind::InvalidResourceType(inner) => Error::InvalidResourceType(inner),
                crate::error::PutComplianceItemsErrorKind::ItemSizeLimitExceededException(inner) => Error::ItemSizeLimitExceededException(inner),
                crate::error::PutComplianceItemsErrorKind::TotalSizeLimitExceededException(inner) => Error::TotalSizeLimitExceededException(inner),
                crate::error::PutComplianceItemsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutInventoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutInventoryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutInventoryErrorKind::CustomSchemaCountLimitExceededException(
                    inner,
                ) => Error::CustomSchemaCountLimitExceededException(inner),
                crate::error::PutInventoryErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutInventoryErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::PutInventoryErrorKind::InvalidInventoryItemContextException(
                    inner,
                ) => Error::InvalidInventoryItemContextException(inner),
                crate::error::PutInventoryErrorKind::InvalidItemContentException(inner) => {
                    Error::InvalidItemContentException(inner)
                }
                crate::error::PutInventoryErrorKind::InvalidTypeNameException(inner) => {
                    Error::InvalidTypeNameException(inner)
                }
                crate::error::PutInventoryErrorKind::ItemContentMismatchException(inner) => {
                    Error::ItemContentMismatchException(inner)
                }
                crate::error::PutInventoryErrorKind::ItemSizeLimitExceededException(inner) => {
                    Error::ItemSizeLimitExceededException(inner)
                }
                crate::error::PutInventoryErrorKind::SubTypeCountLimitExceededException(inner) => {
                    Error::SubTypeCountLimitExceededException(inner)
                }
                crate::error::PutInventoryErrorKind::TotalSizeLimitExceededException(inner) => {
                    Error::TotalSizeLimitExceededException(inner)
                }
                crate::error::PutInventoryErrorKind::UnsupportedInventoryItemContextException(
                    inner,
                ) => Error::UnsupportedInventoryItemContextException(inner),
                crate::error::PutInventoryErrorKind::UnsupportedInventorySchemaVersionException(
                    inner,
                ) => Error::UnsupportedInventorySchemaVersionException(inner),
                crate::error::PutInventoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutParameterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutParameterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutParameterErrorKind::HierarchyLevelLimitExceededException(
                    inner,
                ) => Error::HierarchyLevelLimitExceededException(inner),
                crate::error::PutParameterErrorKind::HierarchyTypeMismatchException(inner) => {
                    Error::HierarchyTypeMismatchException(inner)
                }
                crate::error::PutParameterErrorKind::IncompatiblePolicyException(inner) => {
                    Error::IncompatiblePolicyException(inner)
                }
                crate::error::PutParameterErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutParameterErrorKind::InvalidAllowedPatternException(inner) => {
                    Error::InvalidAllowedPatternException(inner)
                }
                crate::error::PutParameterErrorKind::InvalidKeyId(inner) => {
                    Error::InvalidKeyId(inner)
                }
                crate::error::PutParameterErrorKind::InvalidPolicyAttributeException(inner) => {
                    Error::InvalidPolicyAttributeException(inner)
                }
                crate::error::PutParameterErrorKind::InvalidPolicyTypeException(inner) => {
                    Error::InvalidPolicyTypeException(inner)
                }
                crate::error::PutParameterErrorKind::ParameterAlreadyExists(inner) => {
                    Error::ParameterAlreadyExists(inner)
                }
                crate::error::PutParameterErrorKind::ParameterLimitExceeded(inner) => {
                    Error::ParameterLimitExceeded(inner)
                }
                crate::error::PutParameterErrorKind::ParameterMaxVersionLimitExceeded(inner) => {
                    Error::ParameterMaxVersionLimitExceeded(inner)
                }
                crate::error::PutParameterErrorKind::ParameterPatternMismatchException(inner) => {
                    Error::ParameterPatternMismatchException(inner)
                }
                crate::error::PutParameterErrorKind::PoliciesLimitExceededException(inner) => {
                    Error::PoliciesLimitExceededException(inner)
                }
                crate::error::PutParameterErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::PutParameterErrorKind::UnsupportedParameterType(inner) => {
                    Error::UnsupportedParameterType(inner)
                }
                crate::error::PutParameterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterDefaultPatchBaselineError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterDefaultPatchBaselineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterDefaultPatchBaselineErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::RegisterDefaultPatchBaselineErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::RegisterDefaultPatchBaselineErrorKind::InvalidResourceId(inner) => {
                    Error::InvalidResourceId(inner)
                }
                crate::error::RegisterDefaultPatchBaselineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::RegisterPatchBaselineForPatchGroupError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RegisterPatchBaselineForPatchGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterPatchBaselineForPatchGroupErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::RegisterPatchBaselineForPatchGroupErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::RegisterPatchBaselineForPatchGroupErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::RegisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(inner) => Error::InvalidResourceId(inner),
                crate::error::RegisterPatchBaselineForPatchGroupErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::RegisterPatchBaselineForPatchGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::RegisterTargetWithMaintenanceWindowError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RegisterTargetWithMaintenanceWindowError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterTargetWithMaintenanceWindowErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::RegisterTargetWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(inner) => Error::IdempotentParameterMismatch(inner),
                crate::error::RegisterTargetWithMaintenanceWindowErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::RegisterTargetWithMaintenanceWindowErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::RegisterTargetWithMaintenanceWindowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RegisterTaskWithMaintenanceWindowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RegisterTaskWithMaintenanceWindowError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterTaskWithMaintenanceWindowErrorKind::DoesNotExistException(inner) => Error::DoesNotExistException(inner),
                crate::error::RegisterTaskWithMaintenanceWindowErrorKind::FeatureNotAvailableException(inner) => Error::FeatureNotAvailableException(inner),
                crate::error::RegisterTaskWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(inner) => Error::IdempotentParameterMismatch(inner),
                crate::error::RegisterTaskWithMaintenanceWindowErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::RegisterTaskWithMaintenanceWindowErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::RegisterTaskWithMaintenanceWindowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::InvalidResourceId(inner) => {
                    Error::InvalidResourceId(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::InvalidResourceType(inner) => {
                    Error::InvalidResourceType(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetServiceSettingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetServiceSettingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResetServiceSettingErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ResetServiceSettingErrorKind::ServiceSettingNotFound(inner) => {
                    Error::ServiceSettingNotFound(inner)
                }
                crate::error::ResetServiceSettingErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::ResetServiceSettingErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResumeSessionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ResumeSessionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResumeSessionErrorKind::DoesNotExistException(inner) => {
                    Error::DoesNotExistException(inner)
                }
                crate::error::ResumeSessionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ResumeSessionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SendAutomationSignalError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SendAutomationSignalError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::SendAutomationSignalErrorKind::AutomationExecutionNotFoundException(inner) => Error::AutomationExecutionNotFoundException(inner),
                crate::error::SendAutomationSignalErrorKind::AutomationStepNotFoundException(inner) => Error::AutomationStepNotFoundException(inner),
                crate::error::SendAutomationSignalErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::SendAutomationSignalErrorKind::InvalidAutomationSignalException(inner) => Error::InvalidAutomationSignalException(inner),
                crate::error::SendAutomationSignalErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SendCommandError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SendCommandError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SendCommandErrorKind::DuplicateInstanceId(inner) => {
                    Error::DuplicateInstanceId(inner)
                }
                crate::error::SendCommandErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::SendCommandErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::SendCommandErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::SendCommandErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::SendCommandErrorKind::InvalidNotificationConfig(inner) => {
                    Error::InvalidNotificationConfig(inner)
                }
                crate::error::SendCommandErrorKind::InvalidOutputFolder(inner) => {
                    Error::InvalidOutputFolder(inner)
                }
                crate::error::SendCommandErrorKind::InvalidParameters(inner) => {
                    Error::InvalidParameters(inner)
                }
                crate::error::SendCommandErrorKind::InvalidRole(inner) => Error::InvalidRole(inner),
                crate::error::SendCommandErrorKind::MaxDocumentSizeExceeded(inner) => {
                    Error::MaxDocumentSizeExceeded(inner)
                }
                crate::error::SendCommandErrorKind::UnsupportedPlatformType(inner) => {
                    Error::UnsupportedPlatformType(inner)
                }
                crate::error::SendCommandErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartAssociationsOnceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartAssociationsOnceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartAssociationsOnceErrorKind::AssociationDoesNotExist(inner) => {
                    Error::AssociationDoesNotExist(inner)
                }
                crate::error::StartAssociationsOnceErrorKind::InvalidAssociation(inner) => {
                    Error::InvalidAssociation(inner)
                }
                crate::error::StartAssociationsOnceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartAutomationExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartAutomationExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartAutomationExecutionErrorKind::AutomationDefinitionNotFoundException(inner) => Error::AutomationDefinitionNotFoundException(inner),
                crate::error::StartAutomationExecutionErrorKind::AutomationDefinitionVersionNotFoundException(inner) => Error::AutomationDefinitionVersionNotFoundException(inner),
                crate::error::StartAutomationExecutionErrorKind::AutomationExecutionLimitExceededException(inner) => Error::AutomationExecutionLimitExceededException(inner),
                crate::error::StartAutomationExecutionErrorKind::IdempotentParameterMismatch(inner) => Error::IdempotentParameterMismatch(inner),
                crate::error::StartAutomationExecutionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartAutomationExecutionErrorKind::InvalidAutomationExecutionParametersException(inner) => Error::InvalidAutomationExecutionParametersException(inner),
                crate::error::StartAutomationExecutionErrorKind::InvalidTarget(inner) => Error::InvalidTarget(inner),
                crate::error::StartAutomationExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartChangeRequestExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartChangeRequestExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartChangeRequestExecutionErrorKind::AutomationDefinitionNotApprovedException(inner) => Error::AutomationDefinitionNotApprovedException(inner),
                crate::error::StartChangeRequestExecutionErrorKind::AutomationDefinitionNotFoundException(inner) => Error::AutomationDefinitionNotFoundException(inner),
                crate::error::StartChangeRequestExecutionErrorKind::AutomationDefinitionVersionNotFoundException(inner) => Error::AutomationDefinitionVersionNotFoundException(inner),
                crate::error::StartChangeRequestExecutionErrorKind::AutomationExecutionLimitExceededException(inner) => Error::AutomationExecutionLimitExceededException(inner),
                crate::error::StartChangeRequestExecutionErrorKind::IdempotentParameterMismatch(inner) => Error::IdempotentParameterMismatch(inner),
                crate::error::StartChangeRequestExecutionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartChangeRequestExecutionErrorKind::InvalidAutomationExecutionParametersException(inner) => Error::InvalidAutomationExecutionParametersException(inner),
                crate::error::StartChangeRequestExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartSessionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartSessionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartSessionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::StartSessionErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::StartSessionErrorKind::TargetNotConnected(inner) => {
                    Error::TargetNotConnected(inner)
                }
                crate::error::StartSessionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopAutomationExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopAutomationExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopAutomationExecutionErrorKind::AutomationExecutionNotFoundException(inner) => Error::AutomationExecutionNotFoundException(inner),
                crate::error::StopAutomationExecutionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StopAutomationExecutionErrorKind::InvalidAutomationStatusUpdateException(inner) => Error::InvalidAutomationStatusUpdateException(inner),
                crate::error::StopAutomationExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TerminateSessionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::TerminateSessionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TerminateSessionErrorKind::DoesNotExistException(inner) => {
                    Error::DoesNotExistException(inner)
                }
                crate::error::TerminateSessionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::TerminateSessionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UnlabelParameterVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UnlabelParameterVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UnlabelParameterVersionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UnlabelParameterVersionErrorKind::ParameterNotFound(inner) => {
                    Error::ParameterNotFound(inner)
                }
                crate::error::UnlabelParameterVersionErrorKind::ParameterVersionNotFound(inner) => {
                    Error::ParameterVersionNotFound(inner)
                }
                crate::error::UnlabelParameterVersionErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::UnlabelParameterVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAssociationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAssociationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAssociationErrorKind::AssociationDoesNotExist(inner) => {
                    Error::AssociationDoesNotExist(inner)
                }
                crate::error::UpdateAssociationErrorKind::AssociationVersionLimitExceeded(
                    inner,
                ) => Error::AssociationVersionLimitExceeded(inner),
                crate::error::UpdateAssociationErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidAssociationVersion(inner) => {
                    Error::InvalidAssociationVersion(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidOutputLocation(inner) => {
                    Error::InvalidOutputLocation(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidParameters(inner) => {
                    Error::InvalidParameters(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidSchedule(inner) => {
                    Error::InvalidSchedule(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidTarget(inner) => {
                    Error::InvalidTarget(inner)
                }
                crate::error::UpdateAssociationErrorKind::InvalidUpdate(inner) => {
                    Error::InvalidUpdate(inner)
                }
                crate::error::UpdateAssociationErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::UpdateAssociationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAssociationStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAssociationStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAssociationStatusErrorKind::AssociationDoesNotExist(inner) => {
                    Error::AssociationDoesNotExist(inner)
                }
                crate::error::UpdateAssociationStatusErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateAssociationStatusErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::UpdateAssociationStatusErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::UpdateAssociationStatusErrorKind::StatusUnchanged(inner) => {
                    Error::StatusUnchanged(inner)
                }
                crate::error::UpdateAssociationStatusErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::UpdateAssociationStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateDocumentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDocumentErrorKind::DocumentVersionLimitExceeded(inner) => {
                    Error::DocumentVersionLimitExceeded(inner)
                }
                crate::error::UpdateDocumentErrorKind::DuplicateDocumentContent(inner) => {
                    Error::DuplicateDocumentContent(inner)
                }
                crate::error::UpdateDocumentErrorKind::DuplicateDocumentVersionName(inner) => {
                    Error::DuplicateDocumentVersionName(inner)
                }
                crate::error::UpdateDocumentErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateDocumentErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::UpdateDocumentErrorKind::InvalidDocumentContent(inner) => {
                    Error::InvalidDocumentContent(inner)
                }
                crate::error::UpdateDocumentErrorKind::InvalidDocumentOperation(inner) => {
                    Error::InvalidDocumentOperation(inner)
                }
                crate::error::UpdateDocumentErrorKind::InvalidDocumentSchemaVersion(inner) => {
                    Error::InvalidDocumentSchemaVersion(inner)
                }
                crate::error::UpdateDocumentErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::UpdateDocumentErrorKind::MaxDocumentSizeExceeded(inner) => {
                    Error::MaxDocumentSizeExceeded(inner)
                }
                crate::error::UpdateDocumentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDocumentDefaultVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDocumentDefaultVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDocumentDefaultVersionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateDocumentDefaultVersionErrorKind::InvalidDocument(inner) => Error::InvalidDocument(inner),
                crate::error::UpdateDocumentDefaultVersionErrorKind::InvalidDocumentSchemaVersion(inner) => Error::InvalidDocumentSchemaVersion(inner),
                crate::error::UpdateDocumentDefaultVersionErrorKind::InvalidDocumentVersion(inner) => Error::InvalidDocumentVersion(inner),
                crate::error::UpdateDocumentDefaultVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDocumentMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDocumentMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDocumentMetadataErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateDocumentMetadataErrorKind::InvalidDocument(inner) => {
                    Error::InvalidDocument(inner)
                }
                crate::error::UpdateDocumentMetadataErrorKind::InvalidDocumentOperation(inner) => {
                    Error::InvalidDocumentOperation(inner)
                }
                crate::error::UpdateDocumentMetadataErrorKind::InvalidDocumentVersion(inner) => {
                    Error::InvalidDocumentVersion(inner)
                }
                crate::error::UpdateDocumentMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateMaintenanceWindowErrorKind::DoesNotExistException(inner) => {
                    Error::DoesNotExistException(inner)
                }
                crate::error::UpdateMaintenanceWindowErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateMaintenanceWindowErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowTargetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowTargetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateMaintenanceWindowTargetErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::UpdateMaintenanceWindowTargetErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::UpdateMaintenanceWindowTargetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateMaintenanceWindowTaskErrorKind::DoesNotExistException(
                    inner,
                ) => Error::DoesNotExistException(inner),
                crate::error::UpdateMaintenanceWindowTaskErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateMaintenanceWindowTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateManagedInstanceRoleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateManagedInstanceRoleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateManagedInstanceRoleErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateManagedInstanceRoleErrorKind::InvalidInstanceId(inner) => {
                    Error::InvalidInstanceId(inner)
                }
                crate::error::UpdateManagedInstanceRoleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateOpsItemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateOpsItemError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateOpsItemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateOpsItemErrorKind::OpsItemAlreadyExistsException(inner) => {
                    Error::OpsItemAlreadyExistsException(inner)
                }
                crate::error::UpdateOpsItemErrorKind::OpsItemInvalidParameterException(inner) => {
                    Error::OpsItemInvalidParameterException(inner)
                }
                crate::error::UpdateOpsItemErrorKind::OpsItemLimitExceededException(inner) => {
                    Error::OpsItemLimitExceededException(inner)
                }
                crate::error::UpdateOpsItemErrorKind::OpsItemNotFoundException(inner) => {
                    Error::OpsItemNotFoundException(inner)
                }
                crate::error::UpdateOpsItemErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateOpsMetadataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateOpsMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateOpsMetadataErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(
                    inner,
                ) => Error::OpsMetadataInvalidArgumentException(inner),
                crate::error::UpdateOpsMetadataErrorKind::OpsMetadataKeyLimitExceededException(
                    inner,
                ) => Error::OpsMetadataKeyLimitExceededException(inner),
                crate::error::UpdateOpsMetadataErrorKind::OpsMetadataNotFoundException(inner) => {
                    Error::OpsMetadataNotFoundException(inner)
                }
                crate::error::UpdateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(
                    inner,
                ) => Error::OpsMetadataTooManyUpdatesException(inner),
                crate::error::UpdateOpsMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePatchBaselineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdatePatchBaselineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdatePatchBaselineErrorKind::DoesNotExistException(inner) => {
                    Error::DoesNotExistException(inner)
                }
                crate::error::UpdatePatchBaselineErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdatePatchBaselineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResourceDataSyncError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateResourceDataSyncError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateResourceDataSyncErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::UpdateResourceDataSyncErrorKind::ResourceDataSyncConflictException(inner) => Error::ResourceDataSyncConflictException(inner),
                crate::error::UpdateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(inner) => Error::ResourceDataSyncInvalidConfigurationException(inner),
                crate::error::UpdateResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(inner) => Error::ResourceDataSyncNotFoundException(inner),
                crate::error::UpdateResourceDataSyncErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateServiceSettingError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateServiceSettingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateServiceSettingErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateServiceSettingErrorKind::ServiceSettingNotFound(inner) => {
                    Error::ServiceSettingNotFound(inner)
                }
                crate::error::UpdateServiceSettingErrorKind::TooManyUpdates(inner) => {
                    Error::TooManyUpdates(inner)
                }
                crate::error::UpdateServiceSettingErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
