// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToResourceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the
    /// instance must be a registered managed node.</p>
    InvalidResourceType(crate::error::InvalidResourceType),
    /// <p>The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try
    /// the command again.</p>
    TooManyTagsError(crate::error::TooManyTagsError),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::InvalidResourceType(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::TooManyTagsError(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToResourceError {
    /// Creates a new `AddTagsToResourceError`.
    pub fn new(kind: AddTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(&self.kind, AddTagsToResourceErrorKind::InvalidResourceId(_))
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::InvalidResourceType`.
    pub fn is_invalid_resource_type(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::InvalidResourceType(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::TooManyTagsError`.
    pub fn is_too_many_tags_error(&self) -> bool {
        matches!(&self.kind, AddTagsToResourceErrorKind::TooManyTagsError(_))
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(&self.kind, AddTagsToResourceErrorKind::TooManyUpdates(_))
    }
}
impl std::error::Error for AddTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::InvalidResourceId(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::InvalidResourceType(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::TooManyTagsError(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::TooManyUpdates(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateOpsItemRelatedItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateOpsItemRelatedItemError {
    /// Kind of error that occurred.
    pub kind: AssociateOpsItemRelatedItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateOpsItemRelatedItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateOpsItemRelatedItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A specified parameter argument isn't valid. Verify the available arguments and try
    /// again.</p>
    OpsItemInvalidParameterException(crate::error::OpsItemInvalidParameterException),
    /// <p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem
    /// quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>
    OpsItemLimitExceededException(crate::error::OpsItemLimitExceededException),
    /// <p>The specified OpsItem ID doesn't exist. Verify the ID and try again.</p>
    OpsItemNotFoundException(crate::error::OpsItemNotFoundException),
    /// <p>The Amazon Resource Name (ARN) is already associated with the OpsItem.</p>
    OpsItemRelatedItemAlreadyExistsException(
        crate::error::OpsItemRelatedItemAlreadyExistsException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateOpsItemRelatedItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateOpsItemRelatedItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            AssociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateOpsItemRelatedItemErrorKind::OpsItemLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(_inner) => _inner.fmt(f),
            AssociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            AssociateOpsItemRelatedItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateOpsItemRelatedItemError {
    fn code(&self) -> Option<&str> {
        AssociateOpsItemRelatedItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateOpsItemRelatedItemError {
    /// Creates a new `AssociateOpsItemRelatedItemError`.
    pub fn new(kind: AssociateOpsItemRelatedItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateOpsItemRelatedItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateOpsItemRelatedItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateOpsItemRelatedItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateOpsItemRelatedItemErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateOpsItemRelatedItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOpsItemRelatedItemErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException`.
    pub fn is_ops_item_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOpsItemRelatedItemErrorKind::OpsItemLimitExceededException`.
    pub fn is_ops_item_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOpsItemRelatedItemErrorKind::OpsItemLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException`.
    pub fn is_ops_item_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAlreadyExistsException`.
    pub fn is_ops_item_related_item_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for AssociateOpsItemRelatedItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateOpsItemRelatedItemErrorKind::InternalServerError(_inner) => Some(_inner),
            AssociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(_inner) => {
                Some(_inner)
            }
            AssociateOpsItemRelatedItemErrorKind::OpsItemLimitExceededException(_inner) => {
                Some(_inner)
            }
            AssociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(_inner) => Some(_inner),
            AssociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            AssociateOpsItemRelatedItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelCommand` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelCommandError {
    /// Kind of error that occurred.
    pub kind: CancelCommandErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelCommand` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelCommandErrorKind {
    /// <p>You can't specify a managed node ID in more than one association.</p>
    DuplicateInstanceId(crate::error::DuplicateInstanceId),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified command ID isn't valid. Verify the ID and try again.</p>
    InvalidCommandId(crate::error::InvalidCommandId),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelCommandError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelCommandErrorKind::DuplicateInstanceId(_inner) => _inner.fmt(f),
            CancelCommandErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CancelCommandErrorKind::InvalidCommandId(_inner) => _inner.fmt(f),
            CancelCommandErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            CancelCommandErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelCommandError {
    fn code(&self) -> Option<&str> {
        CancelCommandError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelCommandError {
    /// Creates a new `CancelCommandError`.
    pub fn new(kind: CancelCommandErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelCommandError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelCommandErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelCommandError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelCommandErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelCommandErrorKind::DuplicateInstanceId`.
    pub fn is_duplicate_instance_id(&self) -> bool {
        matches!(&self.kind, CancelCommandErrorKind::DuplicateInstanceId(_))
    }
    /// Returns `true` if the error kind is `CancelCommandErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CancelCommandErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CancelCommandErrorKind::InvalidCommandId`.
    pub fn is_invalid_command_id(&self) -> bool {
        matches!(&self.kind, CancelCommandErrorKind::InvalidCommandId(_))
    }
    /// Returns `true` if the error kind is `CancelCommandErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(&self.kind, CancelCommandErrorKind::InvalidInstanceId(_))
    }
}
impl std::error::Error for CancelCommandError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelCommandErrorKind::DuplicateInstanceId(_inner) => Some(_inner),
            CancelCommandErrorKind::InternalServerError(_inner) => Some(_inner),
            CancelCommandErrorKind::InvalidCommandId(_inner) => Some(_inner),
            CancelCommandErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            CancelCommandErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelMaintenanceWindowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelMaintenanceWindowExecutionError {
    /// Kind of error that occurred.
    pub kind: CancelMaintenanceWindowExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelMaintenanceWindowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelMaintenanceWindowExecutionErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelMaintenanceWindowExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelMaintenanceWindowExecutionErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            CancelMaintenanceWindowExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CancelMaintenanceWindowExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelMaintenanceWindowExecutionError {
    fn code(&self) -> Option<&str> {
        CancelMaintenanceWindowExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelMaintenanceWindowExecutionError {
    /// Creates a new `CancelMaintenanceWindowExecutionError`.
    pub fn new(
        kind: CancelMaintenanceWindowExecutionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelMaintenanceWindowExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelMaintenanceWindowExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelMaintenanceWindowExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelMaintenanceWindowExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelMaintenanceWindowExecutionErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMaintenanceWindowExecutionErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMaintenanceWindowExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CancelMaintenanceWindowExecutionErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for CancelMaintenanceWindowExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelMaintenanceWindowExecutionErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            CancelMaintenanceWindowExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            CancelMaintenanceWindowExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateActivation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateActivationError {
    /// Kind of error that occurred.
    pub kind: CreateActivationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateActivation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateActivationErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM
    /// document). You can only supply values to parameters defined in the SSM document.</p>
    InvalidParameters(crate::error::InvalidParameters),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateActivationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateActivationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateActivationErrorKind::InvalidParameters(_inner) => _inner.fmt(f),
            CreateActivationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateActivationError {
    fn code(&self) -> Option<&str> {
        CreateActivationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateActivationError {
    /// Creates a new `CreateActivationError`.
    pub fn new(kind: CreateActivationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateActivationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateActivationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateActivationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateActivationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateActivationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateActivationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateActivationErrorKind::InvalidParameters`.
    pub fn is_invalid_parameters(&self) -> bool {
        matches!(&self.kind, CreateActivationErrorKind::InvalidParameters(_))
    }
}
impl std::error::Error for CreateActivationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateActivationErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateActivationErrorKind::InvalidParameters(_inner) => Some(_inner),
            CreateActivationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssociationError {
    /// Kind of error that occurred.
    pub kind: CreateAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssociationErrorKind {
    /// <p>The specified association already exists.</p>
    AssociationAlreadyExists(crate::error::AssociationAlreadyExists),
    /// <p>You can have at most 2,000 active associations.</p>
    AssociationLimitExceeded(crate::error::AssociationLimitExceeded),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The output location isn't valid or doesn't exist.</p>
    InvalidOutputLocation(crate::error::InvalidOutputLocation),
    /// <p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM
    /// document). You can only supply values to parameters defined in the SSM document.</p>
    InvalidParameters(crate::error::InvalidParameters),
    /// <p>The schedule is invalid. Verify your cron or rate expression and try again.</p>
    InvalidSchedule(crate::error::InvalidSchedule),
    /// <p>The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might
    /// not have permission to perform the operation.</p>
    InvalidTarget(crate::error::InvalidTarget),
    /// <p>The document doesn't support the platform type of the given managed node ID(s). For example, you
    /// sent an document for a Windows managed node to a Linux node.</p>
    UnsupportedPlatformType(crate::error::UnsupportedPlatformType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssociationErrorKind::AssociationAlreadyExists(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::AssociationLimitExceeded(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InvalidOutputLocation(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InvalidParameters(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InvalidSchedule(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::InvalidTarget(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::UnsupportedPlatformType(_inner) => _inner.fmt(f),
            CreateAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssociationError {
    fn code(&self) -> Option<&str> {
        CreateAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssociationError {
    /// Creates a new `CreateAssociationError`.
    pub fn new(kind: CreateAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::AssociationAlreadyExists`.
    pub fn is_association_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationErrorKind::AssociationAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::AssociationLimitExceeded`.
    pub fn is_association_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationErrorKind::AssociationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, CreateAssociationErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationErrorKind::InvalidDocumentVersion(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(&self.kind, CreateAssociationErrorKind::InvalidInstanceId(_))
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InvalidOutputLocation`.
    pub fn is_invalid_output_location(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationErrorKind::InvalidOutputLocation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InvalidParameters`.
    pub fn is_invalid_parameters(&self) -> bool {
        matches!(&self.kind, CreateAssociationErrorKind::InvalidParameters(_))
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InvalidSchedule`.
    pub fn is_invalid_schedule(&self) -> bool {
        matches!(&self.kind, CreateAssociationErrorKind::InvalidSchedule(_))
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::InvalidTarget`.
    pub fn is_invalid_target(&self) -> bool {
        matches!(&self.kind, CreateAssociationErrorKind::InvalidTarget(_))
    }
    /// Returns `true` if the error kind is `CreateAssociationErrorKind::UnsupportedPlatformType`.
    pub fn is_unsupported_platform_type(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationErrorKind::UnsupportedPlatformType(_)
        )
    }
}
impl std::error::Error for CreateAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssociationErrorKind::AssociationAlreadyExists(_inner) => Some(_inner),
            CreateAssociationErrorKind::AssociationLimitExceeded(_inner) => Some(_inner),
            CreateAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateAssociationErrorKind::InvalidDocument(_inner) => Some(_inner),
            CreateAssociationErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            CreateAssociationErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            CreateAssociationErrorKind::InvalidOutputLocation(_inner) => Some(_inner),
            CreateAssociationErrorKind::InvalidParameters(_inner) => Some(_inner),
            CreateAssociationErrorKind::InvalidSchedule(_inner) => Some(_inner),
            CreateAssociationErrorKind::InvalidTarget(_inner) => Some(_inner),
            CreateAssociationErrorKind::UnsupportedPlatformType(_inner) => Some(_inner),
            CreateAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAssociationBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssociationBatchError {
    /// Kind of error that occurred.
    pub kind: CreateAssociationBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssociationBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssociationBatchErrorKind {
    /// <p>You can have at most 2,000 active associations.</p>
    AssociationLimitExceeded(crate::error::AssociationLimitExceeded),
    /// <p>You can't specify a managed node ID in more than one association.</p>
    DuplicateInstanceId(crate::error::DuplicateInstanceId),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The output location isn't valid or doesn't exist.</p>
    InvalidOutputLocation(crate::error::InvalidOutputLocation),
    /// <p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM
    /// document). You can only supply values to parameters defined in the SSM document.</p>
    InvalidParameters(crate::error::InvalidParameters),
    /// <p>The schedule is invalid. Verify your cron or rate expression and try again.</p>
    InvalidSchedule(crate::error::InvalidSchedule),
    /// <p>The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might
    /// not have permission to perform the operation.</p>
    InvalidTarget(crate::error::InvalidTarget),
    /// <p>The document doesn't support the platform type of the given managed node ID(s). For example, you
    /// sent an document for a Windows managed node to a Linux node.</p>
    UnsupportedPlatformType(crate::error::UnsupportedPlatformType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssociationBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssociationBatchErrorKind::AssociationLimitExceeded(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::DuplicateInstanceId(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InvalidOutputLocation(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InvalidParameters(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InvalidSchedule(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::InvalidTarget(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::UnsupportedPlatformType(_inner) => _inner.fmt(f),
            CreateAssociationBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssociationBatchError {
    fn code(&self) -> Option<&str> {
        CreateAssociationBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssociationBatchError {
    /// Creates a new `CreateAssociationBatchError`.
    pub fn new(kind: CreateAssociationBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssociationBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssociationBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssociationBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssociationBatchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::AssociationLimitExceeded`.
    pub fn is_association_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::AssociationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::DuplicateInstanceId`.
    pub fn is_duplicate_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::DuplicateInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InvalidDocumentVersion(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InvalidOutputLocation`.
    pub fn is_invalid_output_location(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InvalidOutputLocation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InvalidParameters`.
    pub fn is_invalid_parameters(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InvalidParameters(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InvalidSchedule`.
    pub fn is_invalid_schedule(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InvalidSchedule(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::InvalidTarget`.
    pub fn is_invalid_target(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::InvalidTarget(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssociationBatchErrorKind::UnsupportedPlatformType`.
    pub fn is_unsupported_platform_type(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssociationBatchErrorKind::UnsupportedPlatformType(_)
        )
    }
}
impl std::error::Error for CreateAssociationBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssociationBatchErrorKind::AssociationLimitExceeded(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::DuplicateInstanceId(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InvalidDocument(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InvalidOutputLocation(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InvalidParameters(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InvalidSchedule(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::InvalidTarget(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::UnsupportedPlatformType(_inner) => Some(_inner),
            CreateAssociationBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDocumentError {
    /// Kind of error that occurred.
    pub kind: CreateDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDocumentErrorKind {
    /// <p>The specified document already exists.</p>
    DocumentAlreadyExists(crate::error::DocumentAlreadyExists),
    /// <p>You can have at most 500 active SSM documents.</p>
    DocumentLimitExceeded(crate::error::DocumentLimitExceeded),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The content for the document isn't valid.</p>
    InvalidDocumentContent(crate::error::InvalidDocumentContent),
    /// <p>The version of the document schema isn't supported.</p>
    InvalidDocumentSchemaVersion(crate::error::InvalidDocumentSchemaVersion),
    /// <p>The size limit of a document is 64 KB.</p>
    MaxDocumentSizeExceeded(crate::error::MaxDocumentSizeExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDocumentErrorKind::DocumentAlreadyExists(_inner) => _inner.fmt(f),
            CreateDocumentErrorKind::DocumentLimitExceeded(_inner) => _inner.fmt(f),
            CreateDocumentErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateDocumentErrorKind::InvalidDocumentContent(_inner) => _inner.fmt(f),
            CreateDocumentErrorKind::InvalidDocumentSchemaVersion(_inner) => _inner.fmt(f),
            CreateDocumentErrorKind::MaxDocumentSizeExceeded(_inner) => _inner.fmt(f),
            CreateDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDocumentError {
    fn code(&self) -> Option<&str> {
        CreateDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDocumentError {
    /// Creates a new `CreateDocumentError`.
    pub fn new(kind: CreateDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDocumentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDocumentErrorKind::DocumentAlreadyExists`.
    pub fn is_document_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentErrorKind::DocumentAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentErrorKind::DocumentLimitExceeded`.
    pub fn is_document_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentErrorKind::DocumentLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateDocumentErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CreateDocumentErrorKind::InvalidDocumentContent`.
    pub fn is_invalid_document_content(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentErrorKind::InvalidDocumentContent(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentErrorKind::InvalidDocumentSchemaVersion`.
    pub fn is_invalid_document_schema_version(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentErrorKind::InvalidDocumentSchemaVersion(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDocumentErrorKind::MaxDocumentSizeExceeded`.
    pub fn is_max_document_size_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateDocumentErrorKind::MaxDocumentSizeExceeded(_)
        )
    }
}
impl std::error::Error for CreateDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDocumentErrorKind::DocumentAlreadyExists(_inner) => Some(_inner),
            CreateDocumentErrorKind::DocumentLimitExceeded(_inner) => Some(_inner),
            CreateDocumentErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateDocumentErrorKind::InvalidDocumentContent(_inner) => Some(_inner),
            CreateDocumentErrorKind::InvalidDocumentSchemaVersion(_inner) => Some(_inner),
            CreateDocumentErrorKind::MaxDocumentSizeExceeded(_inner) => Some(_inner),
            CreateDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: CreateMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMaintenanceWindowErrorKind {
    /// <p>Error returned when an idempotent operation is retried and the parameters don't match the
    /// original call to the API with the same idempotency token. </p>
    IdempotentParameterMismatch(crate::error::IdempotentParameterMismatch),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Error returned when the caller has exceeded the default resource quotas. For example, too
    /// many maintenance windows or patch baselines have been created.</p>
    /// <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMaintenanceWindowErrorKind::IdempotentParameterMismatch(_inner) => _inner.fmt(f),
            CreateMaintenanceWindowErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateMaintenanceWindowErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        CreateMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMaintenanceWindowError {
    /// Creates a new `CreateMaintenanceWindowError`.
    pub fn new(kind: CreateMaintenanceWindowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMaintenanceWindowErrorKind::IdempotentParameterMismatch`.
    pub fn is_idempotent_parameter_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            CreateMaintenanceWindowErrorKind::IdempotentParameterMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMaintenanceWindowErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMaintenanceWindowErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMaintenanceWindowErrorKind::IdempotentParameterMismatch(_inner) => Some(_inner),
            CreateMaintenanceWindowErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateMaintenanceWindowErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateMaintenanceWindowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOpsItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOpsItemError {
    /// Kind of error that occurred.
    pub kind: CreateOpsItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOpsItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOpsItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The OpsItem already exists.</p>
    OpsItemAlreadyExistsException(crate::error::OpsItemAlreadyExistsException),
    /// <p>A specified parameter argument isn't valid. Verify the available arguments and try
    /// again.</p>
    OpsItemInvalidParameterException(crate::error::OpsItemInvalidParameterException),
    /// <p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem
    /// quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>
    OpsItemLimitExceededException(crate::error::OpsItemLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOpsItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOpsItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateOpsItemErrorKind::OpsItemAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateOpsItemErrorKind::OpsItemInvalidParameterException(_inner) => _inner.fmt(f),
            CreateOpsItemErrorKind::OpsItemLimitExceededException(_inner) => _inner.fmt(f),
            CreateOpsItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOpsItemError {
    fn code(&self) -> Option<&str> {
        CreateOpsItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOpsItemError {
    /// Creates a new `CreateOpsItemError`.
    pub fn new(kind: CreateOpsItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOpsItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOpsItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOpsItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOpsItemErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOpsItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateOpsItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CreateOpsItemErrorKind::OpsItemAlreadyExistsException`.
    pub fn is_ops_item_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsItemErrorKind::OpsItemAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpsItemErrorKind::OpsItemInvalidParameterException`.
    pub fn is_ops_item_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsItemErrorKind::OpsItemInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpsItemErrorKind::OpsItemLimitExceededException`.
    pub fn is_ops_item_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsItemErrorKind::OpsItemLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateOpsItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOpsItemErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateOpsItemErrorKind::OpsItemAlreadyExistsException(_inner) => Some(_inner),
            CreateOpsItemErrorKind::OpsItemInvalidParameterException(_inner) => Some(_inner),
            CreateOpsItemErrorKind::OpsItemLimitExceededException(_inner) => Some(_inner),
            CreateOpsItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOpsMetadataError {
    /// Kind of error that occurred.
    pub kind: CreateOpsMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOpsMetadataErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An OpsMetadata object already exists for the selected resource.</p>
    OpsMetadataAlreadyExistsException(crate::error::OpsMetadataAlreadyExistsException),
    /// <p>One of the arguments passed is invalid. </p>
    OpsMetadataInvalidArgumentException(crate::error::OpsMetadataInvalidArgumentException),
    /// <p>Your account reached the maximum number of OpsMetadata objects allowed by Application Manager. The
    /// maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata object and try again.</p>
    OpsMetadataLimitExceededException(crate::error::OpsMetadataLimitExceededException),
    /// <p>The system is processing too many concurrent updates. Wait a few moments and try
    /// again.</p>
    OpsMetadataTooManyUpdatesException(crate::error::OpsMetadataTooManyUpdatesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOpsMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOpsMetadataErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateOpsMetadataErrorKind::OpsMetadataAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            CreateOpsMetadataErrorKind::OpsMetadataLimitExceededException(_inner) => _inner.fmt(f),
            CreateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(_inner) => _inner.fmt(f),
            CreateOpsMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOpsMetadataError {
    fn code(&self) -> Option<&str> {
        CreateOpsMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOpsMetadataError {
    /// Creates a new `CreateOpsMetadataError`.
    pub fn new(kind: CreateOpsMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOpsMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOpsMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOpsMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOpsMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOpsMetadataErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsMetadataErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpsMetadataErrorKind::OpsMetadataAlreadyExistsException`.
    pub fn is_ops_metadata_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsMetadataErrorKind::OpsMetadataAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException`.
    pub fn is_ops_metadata_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpsMetadataErrorKind::OpsMetadataLimitExceededException`.
    pub fn is_ops_metadata_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsMetadataErrorKind::OpsMetadataLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException`.
    pub fn is_ops_metadata_too_many_updates_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(_)
        )
    }
}
impl std::error::Error for CreateOpsMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOpsMetadataErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateOpsMetadataErrorKind::OpsMetadataAlreadyExistsException(_inner) => Some(_inner),
            CreateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => Some(_inner),
            CreateOpsMetadataErrorKind::OpsMetadataLimitExceededException(_inner) => Some(_inner),
            CreateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(_inner) => Some(_inner),
            CreateOpsMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePatchBaselineError {
    /// Kind of error that occurred.
    pub kind: CreatePatchBaselineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePatchBaselineErrorKind {
    /// <p>Error returned when an idempotent operation is retried and the parameters don't match the
    /// original call to the API with the same idempotency token. </p>
    IdempotentParameterMismatch(crate::error::IdempotentParameterMismatch),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Error returned when the caller has exceeded the default resource quotas. For example, too
    /// many maintenance windows or patch baselines have been created.</p>
    /// <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePatchBaselineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePatchBaselineErrorKind::IdempotentParameterMismatch(_inner) => _inner.fmt(f),
            CreatePatchBaselineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreatePatchBaselineErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreatePatchBaselineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePatchBaselineError {
    fn code(&self) -> Option<&str> {
        CreatePatchBaselineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePatchBaselineError {
    /// Creates a new `CreatePatchBaselineError`.
    pub fn new(kind: CreatePatchBaselineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePatchBaselineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePatchBaselineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePatchBaselineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePatchBaselineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePatchBaselineErrorKind::IdempotentParameterMismatch`.
    pub fn is_idempotent_parameter_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            CreatePatchBaselineErrorKind::IdempotentParameterMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePatchBaselineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreatePatchBaselineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePatchBaselineErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePatchBaselineErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreatePatchBaselineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePatchBaselineErrorKind::IdempotentParameterMismatch(_inner) => Some(_inner),
            CreatePatchBaselineErrorKind::InternalServerError(_inner) => Some(_inner),
            CreatePatchBaselineErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreatePatchBaselineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceDataSyncError {
    /// Kind of error that occurred.
    pub kind: CreateResourceDataSyncErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceDataSyncErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A sync configuration with the same name already exists.</p>
    ResourceDataSyncAlreadyExistsException(crate::error::ResourceDataSyncAlreadyExistsException),
    /// <p>You have exceeded the allowed maximum sync configurations.</p>
    ResourceDataSyncCountExceededException(crate::error::ResourceDataSyncCountExceededException),
    /// <p>The specified sync configuration is invalid.</p>
    ResourceDataSyncInvalidConfigurationException(
        crate::error::ResourceDataSyncInvalidConfigurationException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceDataSyncError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceDataSyncErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateResourceDataSyncErrorKind::ResourceDataSyncAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourceDataSyncErrorKind::ResourceDataSyncCountExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            CreateResourceDataSyncErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceDataSyncError {
    fn code(&self) -> Option<&str> {
        CreateResourceDataSyncError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceDataSyncError {
    /// Creates a new `CreateResourceDataSyncError`.
    pub fn new(kind: CreateResourceDataSyncErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceDataSyncError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceDataSyncErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceDataSyncError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceDataSyncErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourceDataSyncErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceDataSyncErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceDataSyncErrorKind::ResourceDataSyncAlreadyExistsException`.
    pub fn is_resource_data_sync_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceDataSyncErrorKind::ResourceDataSyncAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceDataSyncErrorKind::ResourceDataSyncCountExceededException`.
    pub fn is_resource_data_sync_count_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceDataSyncErrorKind::ResourceDataSyncCountExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException`.
    pub fn is_resource_data_sync_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(_)
        )
    }
}
impl std::error::Error for CreateResourceDataSyncError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceDataSyncErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateResourceDataSyncErrorKind::ResourceDataSyncAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateResourceDataSyncErrorKind::ResourceDataSyncCountExceededException(_inner) => {
                Some(_inner)
            }
            CreateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => Some(_inner),
            CreateResourceDataSyncErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteActivation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteActivationError {
    /// Kind of error that occurred.
    pub kind: DeleteActivationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteActivation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteActivationErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The activation isn't valid. The activation might have been deleted, or the ActivationId and
    /// the ActivationCode don't match.</p>
    InvalidActivation(crate::error::InvalidActivation),
    /// <p>The activation ID isn't valid. Verify the you entered the correct ActivationId or
    /// ActivationCode and try again.</p>
    InvalidActivationId(crate::error::InvalidActivationId),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteActivationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteActivationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteActivationErrorKind::InvalidActivation(_inner) => _inner.fmt(f),
            DeleteActivationErrorKind::InvalidActivationId(_inner) => _inner.fmt(f),
            DeleteActivationErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            DeleteActivationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteActivationError {
    fn code(&self) -> Option<&str> {
        DeleteActivationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteActivationError {
    /// Creates a new `DeleteActivationError`.
    pub fn new(kind: DeleteActivationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteActivationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteActivationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteActivationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteActivationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteActivationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteActivationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteActivationErrorKind::InvalidActivation`.
    pub fn is_invalid_activation(&self) -> bool {
        matches!(&self.kind, DeleteActivationErrorKind::InvalidActivation(_))
    }
    /// Returns `true` if the error kind is `DeleteActivationErrorKind::InvalidActivationId`.
    pub fn is_invalid_activation_id(&self) -> bool {
        matches!(
            &self.kind,
            DeleteActivationErrorKind::InvalidActivationId(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteActivationErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(&self.kind, DeleteActivationErrorKind::TooManyUpdates(_))
    }
}
impl std::error::Error for DeleteActivationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteActivationErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteActivationErrorKind::InvalidActivation(_inner) => Some(_inner),
            DeleteActivationErrorKind::InvalidActivationId(_inner) => Some(_inner),
            DeleteActivationErrorKind::TooManyUpdates(_inner) => Some(_inner),
            DeleteActivationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssociationError {
    /// Kind of error that occurred.
    pub kind: DeleteAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssociationErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssociationErrorKind::AssociationDoesNotExist(_inner) => _inner.fmt(f),
            DeleteAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteAssociationErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            DeleteAssociationErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            DeleteAssociationErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            DeleteAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssociationError {
    fn code(&self) -> Option<&str> {
        DeleteAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssociationError {
    /// Creates a new `DeleteAssociationError`.
    pub fn new(kind: DeleteAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssociationErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssociationErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssociationErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, DeleteAssociationErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `DeleteAssociationErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(&self.kind, DeleteAssociationErrorKind::InvalidInstanceId(_))
    }
    /// Returns `true` if the error kind is `DeleteAssociationErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(&self.kind, DeleteAssociationErrorKind::TooManyUpdates(_))
    }
}
impl std::error::Error for DeleteAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssociationErrorKind::AssociationDoesNotExist(_inner) => Some(_inner),
            DeleteAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteAssociationErrorKind::InvalidDocument(_inner) => Some(_inner),
            DeleteAssociationErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            DeleteAssociationErrorKind::TooManyUpdates(_inner) => Some(_inner),
            DeleteAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDocumentError {
    /// Kind of error that occurred.
    pub kind: DeleteDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDocumentErrorKind {
    /// <p>You must disassociate a document from all managed nodes before you can delete it.</p>
    AssociatedInstances(crate::error::AssociatedInstances),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>You attempted to delete a document while it is still shared. You must stop sharing the
    /// document before you can delete it.</p>
    InvalidDocumentOperation(crate::error::InvalidDocumentOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDocumentErrorKind::AssociatedInstances(_inner) => _inner.fmt(f),
            DeleteDocumentErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteDocumentErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            DeleteDocumentErrorKind::InvalidDocumentOperation(_inner) => _inner.fmt(f),
            DeleteDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDocumentError {
    fn code(&self) -> Option<&str> {
        DeleteDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDocumentError {
    /// Creates a new `DeleteDocumentError`.
    pub fn new(kind: DeleteDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDocumentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDocumentErrorKind::AssociatedInstances`.
    pub fn is_associated_instances(&self) -> bool {
        matches!(&self.kind, DeleteDocumentErrorKind::AssociatedInstances(_))
    }
    /// Returns `true` if the error kind is `DeleteDocumentErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteDocumentErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteDocumentErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, DeleteDocumentErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `DeleteDocumentErrorKind::InvalidDocumentOperation`.
    pub fn is_invalid_document_operation(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDocumentErrorKind::InvalidDocumentOperation(_)
        )
    }
}
impl std::error::Error for DeleteDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDocumentErrorKind::AssociatedInstances(_inner) => Some(_inner),
            DeleteDocumentErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteDocumentErrorKind::InvalidDocument(_inner) => Some(_inner),
            DeleteDocumentErrorKind::InvalidDocumentOperation(_inner) => Some(_inner),
            DeleteDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInventoryError {
    /// Kind of error that occurred.
    pub kind: DeleteInventoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInventoryErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>One or more of the parameters specified for the delete operation isn't valid. Verify all
    /// parameters and try again.</p>
    InvalidDeleteInventoryParametersException(
        crate::error::InvalidDeleteInventoryParametersException,
    ),
    /// <p>The request isn't valid.</p>
    InvalidInventoryRequestException(crate::error::InvalidInventoryRequestException),
    /// <p>The delete inventory option specified isn't valid. Verify the option and try again.</p>
    InvalidOptionException(crate::error::InvalidOptionException),
    /// <p>The parameter type name isn't valid.</p>
    InvalidTypeNameException(crate::error::InvalidTypeNameException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInventoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInventoryErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteInventoryErrorKind::InvalidDeleteInventoryParametersException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInventoryErrorKind::InvalidInventoryRequestException(_inner) => _inner.fmt(f),
            DeleteInventoryErrorKind::InvalidOptionException(_inner) => _inner.fmt(f),
            DeleteInventoryErrorKind::InvalidTypeNameException(_inner) => _inner.fmt(f),
            DeleteInventoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInventoryError {
    fn code(&self) -> Option<&str> {
        DeleteInventoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInventoryError {
    /// Creates a new `DeleteInventoryError`.
    pub fn new(kind: DeleteInventoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInventoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInventoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInventoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInventoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInventoryErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteInventoryErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteInventoryErrorKind::InvalidDeleteInventoryParametersException`.
    pub fn is_invalid_delete_inventory_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInventoryErrorKind::InvalidDeleteInventoryParametersException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInventoryErrorKind::InvalidInventoryRequestException`.
    pub fn is_invalid_inventory_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInventoryErrorKind::InvalidInventoryRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInventoryErrorKind::InvalidOptionException`.
    pub fn is_invalid_option_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInventoryErrorKind::InvalidOptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInventoryErrorKind::InvalidTypeNameException`.
    pub fn is_invalid_type_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInventoryErrorKind::InvalidTypeNameException(_)
        )
    }
}
impl std::error::Error for DeleteInventoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInventoryErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteInventoryErrorKind::InvalidDeleteInventoryParametersException(_inner) => {
                Some(_inner)
            }
            DeleteInventoryErrorKind::InvalidInventoryRequestException(_inner) => Some(_inner),
            DeleteInventoryErrorKind::InvalidOptionException(_inner) => Some(_inner),
            DeleteInventoryErrorKind::InvalidTypeNameException(_inner) => Some(_inner),
            DeleteInventoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: DeleteMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMaintenanceWindowErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMaintenanceWindowErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        DeleteMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMaintenanceWindowError {
    /// Creates a new `DeleteMaintenanceWindowError`.
    pub fn new(kind: DeleteMaintenanceWindowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DeleteMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMaintenanceWindowErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteMaintenanceWindowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOpsMetadataError {
    /// Kind of error that occurred.
    pub kind: DeleteOpsMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOpsMetadataErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>One of the arguments passed is invalid. </p>
    OpsMetadataInvalidArgumentException(crate::error::OpsMetadataInvalidArgumentException),
    /// <p>The OpsMetadata object doesn't exist. </p>
    OpsMetadataNotFoundException(crate::error::OpsMetadataNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOpsMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOpsMetadataErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            DeleteOpsMetadataErrorKind::OpsMetadataNotFoundException(_inner) => _inner.fmt(f),
            DeleteOpsMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOpsMetadataError {
    fn code(&self) -> Option<&str> {
        DeleteOpsMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOpsMetadataError {
    /// Creates a new `DeleteOpsMetadataError`.
    pub fn new(kind: DeleteOpsMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOpsMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOpsMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOpsMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOpsMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOpsMetadataErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOpsMetadataErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOpsMetadataErrorKind::OpsMetadataInvalidArgumentException`.
    pub fn is_ops_metadata_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOpsMetadataErrorKind::OpsMetadataNotFoundException`.
    pub fn is_ops_metadata_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOpsMetadataErrorKind::OpsMetadataNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteOpsMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOpsMetadataErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => Some(_inner),
            DeleteOpsMetadataErrorKind::OpsMetadataNotFoundException(_inner) => Some(_inner),
            DeleteOpsMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteParameterError {
    /// Kind of error that occurred.
    pub kind: DeleteParameterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteParameterErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The parameter couldn't be found. Verify the name and try again.</p>
    ParameterNotFound(crate::error::ParameterNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteParameterErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteParameterErrorKind::ParameterNotFound(_inner) => _inner.fmt(f),
            DeleteParameterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteParameterError {
    fn code(&self) -> Option<&str> {
        DeleteParameterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteParameterError {
    /// Creates a new `DeleteParameterError`.
    pub fn new(kind: DeleteParameterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteParameterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteParameterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteParameterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteParameterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteParameterErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteParameterErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteParameterErrorKind::ParameterNotFound`.
    pub fn is_parameter_not_found(&self) -> bool {
        matches!(&self.kind, DeleteParameterErrorKind::ParameterNotFound(_))
    }
}
impl std::error::Error for DeleteParameterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteParameterErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteParameterErrorKind::ParameterNotFound(_inner) => Some(_inner),
            DeleteParameterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteParametersError {
    /// Kind of error that occurred.
    pub kind: DeleteParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteParametersErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteParametersErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteParametersError {
    fn code(&self) -> Option<&str> {
        DeleteParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteParametersError {
    /// Creates a new `DeleteParametersError`.
    pub fn new(kind: DeleteParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteParametersErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParametersErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DeleteParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteParametersErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePatchBaselineError {
    /// Kind of error that occurred.
    pub kind: DeletePatchBaselineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePatchBaselineErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Error returned if an attempt is made to delete a patch baseline that is registered for a
    /// patch group.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePatchBaselineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePatchBaselineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeletePatchBaselineErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeletePatchBaselineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePatchBaselineError {
    fn code(&self) -> Option<&str> {
        DeletePatchBaselineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePatchBaselineError {
    /// Creates a new `DeletePatchBaselineError`.
    pub fn new(kind: DeletePatchBaselineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePatchBaselineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePatchBaselineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePatchBaselineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePatchBaselineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePatchBaselineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeletePatchBaselineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePatchBaselineErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePatchBaselineErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeletePatchBaselineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePatchBaselineErrorKind::InternalServerError(_inner) => Some(_inner),
            DeletePatchBaselineErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeletePatchBaselineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceDataSyncError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceDataSyncErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceDataSyncErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified sync configuration is invalid.</p>
    ResourceDataSyncInvalidConfigurationException(
        crate::error::ResourceDataSyncInvalidConfigurationException,
    ),
    /// <p>The specified sync name wasn't found.</p>
    ResourceDataSyncNotFoundException(crate::error::ResourceDataSyncNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceDataSyncError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceDataSyncErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            DeleteResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteResourceDataSyncErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceDataSyncError {
    fn code(&self) -> Option<&str> {
        DeleteResourceDataSyncError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceDataSyncError {
    /// Creates a new `DeleteResourceDataSyncError`.
    pub fn new(kind: DeleteResourceDataSyncErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceDataSyncError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceDataSyncErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceDataSyncError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceDataSyncErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceDataSyncErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceDataSyncErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException`.
    pub fn is_resource_data_sync_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceDataSyncErrorKind::ResourceDataSyncNotFoundException`.
    pub fn is_resource_data_sync_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteResourceDataSyncError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceDataSyncErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => Some(_inner),
            DeleteResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteResourceDataSyncErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterManagedInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterManagedInstanceError {
    /// Kind of error that occurred.
    pub kind: DeregisterManagedInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterManagedInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterManagedInstanceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterManagedInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterManagedInstanceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeregisterManagedInstanceErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            DeregisterManagedInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterManagedInstanceError {
    fn code(&self) -> Option<&str> {
        DeregisterManagedInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterManagedInstanceError {
    /// Creates a new `DeregisterManagedInstanceError`.
    pub fn new(kind: DeregisterManagedInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterManagedInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterManagedInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterManagedInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterManagedInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterManagedInstanceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterManagedInstanceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterManagedInstanceErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterManagedInstanceErrorKind::InvalidInstanceId(_)
        )
    }
}
impl std::error::Error for DeregisterManagedInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterManagedInstanceErrorKind::InternalServerError(_inner) => Some(_inner),
            DeregisterManagedInstanceErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            DeregisterManagedInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterPatchBaselineForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterPatchBaselineForPatchGroupError {
    /// Kind of error that occurred.
    pub kind: DeregisterPatchBaselineForPatchGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterPatchBaselineForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterPatchBaselineForPatchGroupErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterPatchBaselineForPatchGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterPatchBaselineForPatchGroupErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DeregisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(_inner) => {
                _inner.fmt(f)
            }
            DeregisterPatchBaselineForPatchGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterPatchBaselineForPatchGroupError {
    fn code(&self) -> Option<&str> {
        DeregisterPatchBaselineForPatchGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterPatchBaselineForPatchGroupError {
    /// Creates a new `DeregisterPatchBaselineForPatchGroupError`.
    pub fn new(
        kind: DeregisterPatchBaselineForPatchGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterPatchBaselineForPatchGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterPatchBaselineForPatchGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterPatchBaselineForPatchGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterPatchBaselineForPatchGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterPatchBaselineForPatchGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterPatchBaselineForPatchGroupErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(_)
        )
    }
}
impl std::error::Error for DeregisterPatchBaselineForPatchGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterPatchBaselineForPatchGroupErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DeregisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(_inner) => {
                Some(_inner)
            }
            DeregisterPatchBaselineForPatchGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeregisterTargetFromMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterTargetFromMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: DeregisterTargetFromMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterTargetFromMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterTargetFromMaintenanceWindowErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow
    /// operation, but the target is still referenced in a task.</p>
    TargetInUseException(crate::error::TargetInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterTargetFromMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterTargetFromMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterTargetFromMaintenanceWindowErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DeregisterTargetFromMaintenanceWindowErrorKind::TargetInUseException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterTargetFromMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterTargetFromMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        DeregisterTargetFromMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterTargetFromMaintenanceWindowError {
    /// Creates a new `DeregisterTargetFromMaintenanceWindowError`.
    pub fn new(
        kind: DeregisterTargetFromMaintenanceWindowErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterTargetFromMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterTargetFromMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterTargetFromMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterTargetFromMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterTargetFromMaintenanceWindowErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTargetFromMaintenanceWindowErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTargetFromMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTargetFromMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTargetFromMaintenanceWindowErrorKind::TargetInUseException`.
    pub fn is_target_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTargetFromMaintenanceWindowErrorKind::TargetInUseException(_)
        )
    }
}
impl std::error::Error for DeregisterTargetFromMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterTargetFromMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            DeregisterTargetFromMaintenanceWindowErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DeregisterTargetFromMaintenanceWindowErrorKind::TargetInUseException(_inner) => {
                Some(_inner)
            }
            DeregisterTargetFromMaintenanceWindowErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeregisterTaskFromMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterTaskFromMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: DeregisterTaskFromMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterTaskFromMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterTaskFromMaintenanceWindowErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterTaskFromMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterTaskFromMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterTaskFromMaintenanceWindowErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DeregisterTaskFromMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterTaskFromMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        DeregisterTaskFromMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterTaskFromMaintenanceWindowError {
    /// Creates a new `DeregisterTaskFromMaintenanceWindowError`.
    pub fn new(
        kind: DeregisterTaskFromMaintenanceWindowErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterTaskFromMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterTaskFromMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterTaskFromMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterTaskFromMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterTaskFromMaintenanceWindowErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTaskFromMaintenanceWindowErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTaskFromMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTaskFromMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DeregisterTaskFromMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterTaskFromMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            DeregisterTaskFromMaintenanceWindowErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DeregisterTaskFromMaintenanceWindowErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeActivations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeActivationsError {
    /// Kind of error that occurred.
    pub kind: DescribeActivationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeActivations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeActivationsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeActivationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeActivationsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeActivationsErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            DescribeActivationsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeActivationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeActivationsError {
    fn code(&self) -> Option<&str> {
        DescribeActivationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeActivationsError {
    /// Creates a new `DescribeActivationsError`.
    pub fn new(kind: DescribeActivationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeActivationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeActivationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeActivationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeActivationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeActivationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeActivationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeActivationsErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(&self.kind, DescribeActivationsErrorKind::InvalidFilter(_))
    }
    /// Returns `true` if the error kind is `DescribeActivationsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeActivationsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeActivationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeActivationsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeActivationsErrorKind::InvalidFilter(_inner) => Some(_inner),
            DescribeActivationsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeActivationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssociationError {
    /// Kind of error that occurred.
    pub kind: DescribeAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssociationErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The version you specified isn't valid. Use ListAssociationVersions to view all versions of
    /// an association according to the association ID. Or, use the <code>$LATEST</code> parameter to
    /// view the latest version of the association.</p>
    InvalidAssociationVersion(crate::error::InvalidAssociationVersion),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssociationErrorKind::AssociationDoesNotExist(_inner) => _inner.fmt(f),
            DescribeAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAssociationErrorKind::InvalidAssociationVersion(_inner) => _inner.fmt(f),
            DescribeAssociationErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            DescribeAssociationErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            DescribeAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssociationError {
    fn code(&self) -> Option<&str> {
        DescribeAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssociationError {
    /// Creates a new `DescribeAssociationError`.
    pub fn new(kind: DescribeAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAssociationErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationErrorKind::InvalidAssociationVersion`.
    pub fn is_invalid_association_version(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationErrorKind::InvalidAssociationVersion(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, DescribeAssociationErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `DescribeAssociationErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationErrorKind::InvalidInstanceId(_)
        )
    }
}
impl std::error::Error for DescribeAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssociationErrorKind::AssociationDoesNotExist(_inner) => Some(_inner),
            DescribeAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAssociationErrorKind::InvalidAssociationVersion(_inner) => Some(_inner),
            DescribeAssociationErrorKind::InvalidDocument(_inner) => Some(_inner),
            DescribeAssociationErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            DescribeAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssociationExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssociationExecutionsError {
    /// Kind of error that occurred.
    pub kind: DescribeAssociationExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssociationExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssociationExecutionsErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssociationExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssociationExecutionsErrorKind::AssociationDoesNotExist(_inner) => {
                _inner.fmt(f)
            }
            DescribeAssociationExecutionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAssociationExecutionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAssociationExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssociationExecutionsError {
    fn code(&self) -> Option<&str> {
        DescribeAssociationExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssociationExecutionsError {
    /// Creates a new `DescribeAssociationExecutionsError`.
    pub fn new(
        kind: DescribeAssociationExecutionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssociationExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssociationExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssociationExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssociationExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAssociationExecutionsErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationExecutionsErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationExecutionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationExecutionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationExecutionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationExecutionsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeAssociationExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssociationExecutionsErrorKind::AssociationDoesNotExist(_inner) => Some(_inner),
            DescribeAssociationExecutionsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAssociationExecutionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAssociationExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAssociationExecutionTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAssociationExecutionTargetsError {
    /// Kind of error that occurred.
    pub kind: DescribeAssociationExecutionTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAssociationExecutionTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAssociationExecutionTargetsErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>The specified execution ID doesn't exist. Verify the ID number and try again.</p>
    AssociationExecutionDoesNotExist(crate::error::AssociationExecutionDoesNotExist),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAssociationExecutionTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAssociationExecutionTargetsErrorKind::AssociationDoesNotExist(_inner) => {
                _inner.fmt(f)
            }
            DescribeAssociationExecutionTargetsErrorKind::AssociationExecutionDoesNotExist(
                _inner,
            ) => _inner.fmt(f),
            DescribeAssociationExecutionTargetsErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeAssociationExecutionTargetsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAssociationExecutionTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAssociationExecutionTargetsError {
    fn code(&self) -> Option<&str> {
        DescribeAssociationExecutionTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAssociationExecutionTargetsError {
    /// Creates a new `DescribeAssociationExecutionTargetsError`.
    pub fn new(
        kind: DescribeAssociationExecutionTargetsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAssociationExecutionTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAssociationExecutionTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAssociationExecutionTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAssociationExecutionTargetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAssociationExecutionTargetsErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationExecutionTargetsErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationExecutionTargetsErrorKind::AssociationExecutionDoesNotExist`.
    pub fn is_association_execution_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationExecutionTargetsErrorKind::AssociationExecutionDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationExecutionTargetsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationExecutionTargetsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAssociationExecutionTargetsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAssociationExecutionTargetsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeAssociationExecutionTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAssociationExecutionTargetsErrorKind::AssociationDoesNotExist(_inner) => {
                Some(_inner)
            }
            DescribeAssociationExecutionTargetsErrorKind::AssociationExecutionDoesNotExist(
                _inner,
            ) => Some(_inner),
            DescribeAssociationExecutionTargetsErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeAssociationExecutionTargetsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAssociationExecutionTargetsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAutomationExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAutomationExecutionsError {
    /// Kind of error that occurred.
    pub kind: DescribeAutomationExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAutomationExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAutomationExecutionsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The filter value isn't valid. Verify the value and try again.</p>
    InvalidFilterValue(crate::error::InvalidFilterValue),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAutomationExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAutomationExecutionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAutomationExecutionsErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            DescribeAutomationExecutionsErrorKind::InvalidFilterValue(_inner) => _inner.fmt(f),
            DescribeAutomationExecutionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAutomationExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAutomationExecutionsError {
    fn code(&self) -> Option<&str> {
        DescribeAutomationExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAutomationExecutionsError {
    /// Creates a new `DescribeAutomationExecutionsError`.
    pub fn new(kind: DescribeAutomationExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAutomationExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAutomationExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAutomationExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAutomationExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAutomationExecutionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationExecutionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutomationExecutionsErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationExecutionsErrorKind::InvalidFilterKey(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutomationExecutionsErrorKind::InvalidFilterValue`.
    pub fn is_invalid_filter_value(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationExecutionsErrorKind::InvalidFilterValue(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutomationExecutionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationExecutionsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeAutomationExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAutomationExecutionsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAutomationExecutionsErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            DescribeAutomationExecutionsErrorKind::InvalidFilterValue(_inner) => Some(_inner),
            DescribeAutomationExecutionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAutomationExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAutomationStepExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAutomationStepExecutionsError {
    /// Kind of error that occurred.
    pub kind: DescribeAutomationStepExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAutomationStepExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAutomationStepExecutionsErrorKind {
    /// <p>There is no automation execution information for the requested automation execution
    /// ID.</p>
    AutomationExecutionNotFoundException(crate::error::AutomationExecutionNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The filter value isn't valid. Verify the value and try again.</p>
    InvalidFilterValue(crate::error::InvalidFilterValue),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAutomationStepExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAutomationStepExecutionsErrorKind::AutomationExecutionNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribeAutomationStepExecutionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAutomationStepExecutionsErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            DescribeAutomationStepExecutionsErrorKind::InvalidFilterValue(_inner) => _inner.fmt(f),
            DescribeAutomationStepExecutionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAutomationStepExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAutomationStepExecutionsError {
    fn code(&self) -> Option<&str> {
        DescribeAutomationStepExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAutomationStepExecutionsError {
    /// Creates a new `DescribeAutomationStepExecutionsError`.
    pub fn new(
        kind: DescribeAutomationStepExecutionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAutomationStepExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAutomationStepExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAutomationStepExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAutomationStepExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAutomationStepExecutionsErrorKind::AutomationExecutionNotFoundException`.
    pub fn is_automation_execution_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationStepExecutionsErrorKind::AutomationExecutionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutomationStepExecutionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationStepExecutionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutomationStepExecutionsErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationStepExecutionsErrorKind::InvalidFilterKey(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutomationStepExecutionsErrorKind::InvalidFilterValue`.
    pub fn is_invalid_filter_value(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationStepExecutionsErrorKind::InvalidFilterValue(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAutomationStepExecutionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutomationStepExecutionsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeAutomationStepExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAutomationStepExecutionsErrorKind::AutomationExecutionNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribeAutomationStepExecutionsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAutomationStepExecutionsErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            DescribeAutomationStepExecutionsErrorKind::InvalidFilterValue(_inner) => Some(_inner),
            DescribeAutomationStepExecutionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAutomationStepExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAvailablePatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAvailablePatchesError {
    /// Kind of error that occurred.
    pub kind: DescribeAvailablePatchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAvailablePatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAvailablePatchesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAvailablePatchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAvailablePatchesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAvailablePatchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAvailablePatchesError {
    fn code(&self) -> Option<&str> {
        DescribeAvailablePatchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAvailablePatchesError {
    /// Creates a new `DescribeAvailablePatchesError`.
    pub fn new(kind: DescribeAvailablePatchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAvailablePatchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAvailablePatchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAvailablePatchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAvailablePatchesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAvailablePatchesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAvailablePatchesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeAvailablePatchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAvailablePatchesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAvailablePatchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDocumentError {
    /// Kind of error that occurred.
    pub kind: DescribeDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDocumentErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDocumentErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeDocumentErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            DescribeDocumentErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            DescribeDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDocumentError {
    fn code(&self) -> Option<&str> {
        DescribeDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDocumentError {
    /// Creates a new `DescribeDocumentError`.
    pub fn new(kind: DescribeDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDocumentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDocumentErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, DescribeDocumentErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `DescribeDocumentErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentErrorKind::InvalidDocumentVersion(_)
        )
    }
}
impl std::error::Error for DescribeDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDocumentErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeDocumentErrorKind::InvalidDocument(_inner) => Some(_inner),
            DescribeDocumentErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            DescribeDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDocumentPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDocumentPermissionError {
    /// Kind of error that occurred.
    pub kind: DescribeDocumentPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDocumentPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDocumentPermissionErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>You attempted to delete a document while it is still shared. You must stop sharing the
    /// document before you can delete it.</p>
    InvalidDocumentOperation(crate::error::InvalidDocumentOperation),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The permission type isn't supported. <i>Share</i> is the only supported
    /// permission type.</p>
    InvalidPermissionType(crate::error::InvalidPermissionType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDocumentPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDocumentPermissionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeDocumentPermissionErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            DescribeDocumentPermissionErrorKind::InvalidDocumentOperation(_inner) => _inner.fmt(f),
            DescribeDocumentPermissionErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeDocumentPermissionErrorKind::InvalidPermissionType(_inner) => _inner.fmt(f),
            DescribeDocumentPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDocumentPermissionError {
    fn code(&self) -> Option<&str> {
        DescribeDocumentPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDocumentPermissionError {
    /// Creates a new `DescribeDocumentPermissionError`.
    pub fn new(kind: DescribeDocumentPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDocumentPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDocumentPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDocumentPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDocumentPermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDocumentPermissionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentPermissionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentPermissionErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentPermissionErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentPermissionErrorKind::InvalidDocumentOperation`.
    pub fn is_invalid_document_operation(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentPermissionErrorKind::InvalidDocumentOperation(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentPermissionErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentPermissionErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDocumentPermissionErrorKind::InvalidPermissionType`.
    pub fn is_invalid_permission_type(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDocumentPermissionErrorKind::InvalidPermissionType(_)
        )
    }
}
impl std::error::Error for DescribeDocumentPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDocumentPermissionErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeDocumentPermissionErrorKind::InvalidDocument(_inner) => Some(_inner),
            DescribeDocumentPermissionErrorKind::InvalidDocumentOperation(_inner) => Some(_inner),
            DescribeDocumentPermissionErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeDocumentPermissionErrorKind::InvalidPermissionType(_inner) => Some(_inner),
            DescribeDocumentPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEffectiveInstanceAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEffectiveInstanceAssociationsError {
    /// Kind of error that occurred.
    pub kind: DescribeEffectiveInstanceAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEffectiveInstanceAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEffectiveInstanceAssociationsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEffectiveInstanceAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEffectiveInstanceAssociationsErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectiveInstanceAssociationsErrorKind::InvalidInstanceId(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectiveInstanceAssociationsErrorKind::InvalidNextToken(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectiveInstanceAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEffectiveInstanceAssociationsError {
    fn code(&self) -> Option<&str> {
        DescribeEffectiveInstanceAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEffectiveInstanceAssociationsError {
    /// Creates a new `DescribeEffectiveInstanceAssociationsError`.
    pub fn new(
        kind: DescribeEffectiveInstanceAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEffectiveInstanceAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEffectiveInstanceAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEffectiveInstanceAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEffectiveInstanceAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEffectiveInstanceAssociationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectiveInstanceAssociationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectiveInstanceAssociationsErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectiveInstanceAssociationsErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectiveInstanceAssociationsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectiveInstanceAssociationsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeEffectiveInstanceAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEffectiveInstanceAssociationsErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeEffectiveInstanceAssociationsErrorKind::InvalidInstanceId(_inner) => {
                Some(_inner)
            }
            DescribeEffectiveInstanceAssociationsErrorKind::InvalidNextToken(_inner) => {
                Some(_inner)
            }
            DescribeEffectiveInstanceAssociationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeEffectivePatchesForPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEffectivePatchesForPatchBaselineError {
    /// Kind of error that occurred.
    pub kind: DescribeEffectivePatchesForPatchBaselineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEffectivePatchesForPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEffectivePatchesForPatchBaselineErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>The operating systems you specified isn't supported, or the operation isn't supported for
    /// the operating system.</p>
    UnsupportedOperatingSystem(crate::error::UnsupportedOperatingSystem),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEffectivePatchesForPatchBaselineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEffectivePatchesForPatchBaselineErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectivePatchesForPatchBaselineErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectivePatchesForPatchBaselineErrorKind::InvalidResourceId(_inner) => {
                _inner.fmt(f)
            }
            DescribeEffectivePatchesForPatchBaselineErrorKind::UnsupportedOperatingSystem(
                _inner,
            ) => _inner.fmt(f),
            DescribeEffectivePatchesForPatchBaselineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEffectivePatchesForPatchBaselineError {
    fn code(&self) -> Option<&str> {
        DescribeEffectivePatchesForPatchBaselineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEffectivePatchesForPatchBaselineError {
    /// Creates a new `DescribeEffectivePatchesForPatchBaselineError`.
    pub fn new(
        kind: DescribeEffectivePatchesForPatchBaselineErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEffectivePatchesForPatchBaselineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEffectivePatchesForPatchBaselineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEffectivePatchesForPatchBaselineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEffectivePatchesForPatchBaselineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEffectivePatchesForPatchBaselineErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePatchesForPatchBaselineErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePatchesForPatchBaselineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePatchesForPatchBaselineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePatchesForPatchBaselineErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePatchesForPatchBaselineErrorKind::InvalidResourceId(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEffectivePatchesForPatchBaselineErrorKind::UnsupportedOperatingSystem`.
    pub fn is_unsupported_operating_system(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEffectivePatchesForPatchBaselineErrorKind::UnsupportedOperatingSystem(_)
        )
    }
}
impl std::error::Error for DescribeEffectivePatchesForPatchBaselineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEffectivePatchesForPatchBaselineErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribeEffectivePatchesForPatchBaselineErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeEffectivePatchesForPatchBaselineErrorKind::InvalidResourceId(_inner) => {
                Some(_inner)
            }
            DescribeEffectivePatchesForPatchBaselineErrorKind::UnsupportedOperatingSystem(
                _inner,
            ) => Some(_inner),
            DescribeEffectivePatchesForPatchBaselineErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeInstanceAssociationsStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceAssociationsStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceAssociationsStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceAssociationsStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceAssociationsStatusErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceAssociationsStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceAssociationsStatusErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstanceAssociationsStatusErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            DescribeInstanceAssociationsStatusErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeInstanceAssociationsStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceAssociationsStatusError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceAssociationsStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceAssociationsStatusError {
    /// Creates a new `DescribeInstanceAssociationsStatusError`.
    pub fn new(
        kind: DescribeInstanceAssociationsStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceAssociationsStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceAssociationsStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceAssociationsStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceAssociationsStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceAssociationsStatusErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAssociationsStatusErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAssociationsStatusErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAssociationsStatusErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAssociationsStatusErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAssociationsStatusErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeInstanceAssociationsStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceAssociationsStatusErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeInstanceAssociationsStatusErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            DescribeInstanceAssociationsStatusErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeInstanceAssociationsStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstanceInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceInformationError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceInformationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceInformation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceInformationErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified filter value isn't valid.</p>
    InvalidInstanceInformationFilterValue(crate::error::InvalidInstanceInformationFilterValue),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceInformationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceInformationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeInstanceInformationErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            DescribeInstanceInformationErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            DescribeInstanceInformationErrorKind::InvalidInstanceInformationFilterValue(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstanceInformationErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeInstanceInformationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceInformationError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceInformationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceInformationError {
    /// Creates a new `DescribeInstanceInformationError`.
    pub fn new(kind: DescribeInstanceInformationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceInformationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceInformationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceInformationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceInformationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceInformationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceInformationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceInformationErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceInformationErrorKind::InvalidFilterKey(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceInformationErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceInformationErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceInformationErrorKind::InvalidInstanceInformationFilterValue`.
    pub fn is_invalid_instance_information_filter_value(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceInformationErrorKind::InvalidInstanceInformationFilterValue(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceInformationErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceInformationErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeInstanceInformationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceInformationErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeInstanceInformationErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            DescribeInstanceInformationErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            DescribeInstanceInformationErrorKind::InvalidInstanceInformationFilterValue(_inner) => {
                Some(_inner)
            }
            DescribeInstanceInformationErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeInstanceInformationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstancePatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstancePatchesError {
    /// Kind of error that occurred.
    pub kind: DescribeInstancePatchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstancePatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstancePatchesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstancePatchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstancePatchesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeInstancePatchesErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            DescribeInstancePatchesErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            DescribeInstancePatchesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeInstancePatchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstancePatchesError {
    fn code(&self) -> Option<&str> {
        DescribeInstancePatchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstancePatchesError {
    /// Creates a new `DescribeInstancePatchesError`.
    pub fn new(kind: DescribeInstancePatchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstancePatchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstancePatchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstancePatchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstancePatchesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchesErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchesErrorKind::InvalidFilter(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchesErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchesErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchesErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeInstancePatchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstancePatchesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeInstancePatchesErrorKind::InvalidFilter(_inner) => Some(_inner),
            DescribeInstancePatchesErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            DescribeInstancePatchesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeInstancePatchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstancePatchStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstancePatchStatesError {
    /// Kind of error that occurred.
    pub kind: DescribeInstancePatchStatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstancePatchStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstancePatchStatesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstancePatchStatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstancePatchStatesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeInstancePatchStatesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeInstancePatchStatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstancePatchStatesError {
    fn code(&self) -> Option<&str> {
        DescribeInstancePatchStatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstancePatchStatesError {
    /// Creates a new `DescribeInstancePatchStatesError`.
    pub fn new(kind: DescribeInstancePatchStatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstancePatchStatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstancePatchStatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstancePatchStatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstancePatchStatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchStatesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchStatesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchStatesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchStatesErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeInstancePatchStatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstancePatchStatesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeInstancePatchStatesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeInstancePatchStatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstancePatchStatesForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstancePatchStatesForPatchGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeInstancePatchStatesForPatchGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstancePatchStatesForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstancePatchStatesForPatchGroupErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstancePatchStatesForPatchGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstancePatchStatesForPatchGroupErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidFilter(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidNextToken(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstancePatchStatesForPatchGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstancePatchStatesForPatchGroupError {
    fn code(&self) -> Option<&str> {
        DescribeInstancePatchStatesForPatchGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstancePatchStatesForPatchGroupError {
    /// Creates a new `DescribeInstancePatchStatesForPatchGroupError`.
    pub fn new(
        kind: DescribeInstancePatchStatesForPatchGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstancePatchStatesForPatchGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstancePatchStatesForPatchGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstancePatchStatesForPatchGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstancePatchStatesForPatchGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchStatesForPatchGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchStatesForPatchGroupErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidFilter(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeInstancePatchStatesForPatchGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstancePatchStatesForPatchGroupErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidFilter(_inner) => {
                Some(_inner)
            }
            DescribeInstancePatchStatesForPatchGroupErrorKind::InvalidNextToken(_inner) => {
                Some(_inner)
            }
            DescribeInstancePatchStatesForPatchGroupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeInventoryDeletions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInventoryDeletionsError {
    /// Kind of error that occurred.
    pub kind: DescribeInventoryDeletionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInventoryDeletions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInventoryDeletionsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The ID specified for the delete operation doesn't exist or isn't valid. Verify the ID and
    /// try again.</p>
    InvalidDeletionIdException(crate::error::InvalidDeletionIdException),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInventoryDeletionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInventoryDeletionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeInventoryDeletionsErrorKind::InvalidDeletionIdException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInventoryDeletionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeInventoryDeletionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInventoryDeletionsError {
    fn code(&self) -> Option<&str> {
        DescribeInventoryDeletionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInventoryDeletionsError {
    /// Creates a new `DescribeInventoryDeletionsError`.
    pub fn new(kind: DescribeInventoryDeletionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInventoryDeletionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInventoryDeletionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInventoryDeletionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInventoryDeletionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInventoryDeletionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInventoryDeletionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInventoryDeletionsErrorKind::InvalidDeletionIdException`.
    pub fn is_invalid_deletion_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInventoryDeletionsErrorKind::InvalidDeletionIdException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInventoryDeletionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInventoryDeletionsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeInventoryDeletionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInventoryDeletionsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeInventoryDeletionsErrorKind::InvalidDeletionIdException(_inner) => Some(_inner),
            DescribeInventoryDeletionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeInventoryDeletionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMaintenanceWindowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowExecutionsError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindowExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowExecutionsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowExecutionsErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceWindowExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceWindowExecutionsError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowExecutionsError {
    /// Creates a new `DescribeMaintenanceWindowExecutionsError`.
    pub fn new(
        kind: DescribeMaintenanceWindowExecutionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowExecutionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowExecutionsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowExecutionsErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeMaintenanceWindowExecutionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeMaintenanceWindowExecutionTaskInvocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowExecutionTaskInvocationsError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindowExecutionTaskInvocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowExecutionTaskInvocationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::DoesNotExistException(
                _inner,
            ) => _inner.fmt(f),
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::InternalServerError(
                _inner,
            ) => _inner.fmt(f),
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeMaintenanceWindowExecutionTaskInvocationsError
{
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowExecutionTaskInvocationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowExecutionTaskInvocationsError {
    /// Creates a new `DescribeMaintenanceWindowExecutionTaskInvocationsError`.
    pub fn new(
        kind: DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowExecutionTaskInvocationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowExecutionTaskInvocationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowExecutionTaskInvocationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::DoesNotExistException(
                _inner,
            ) => Some(_inner),
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::InternalServerError(
                _inner,
            ) => Some(_inner),
            DescribeMaintenanceWindowExecutionTaskInvocationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeMaintenanceWindowExecutionTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowExecutionTasksError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowExecutionTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindowExecutionTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowExecutionTasksErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowExecutionTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowExecutionTasksErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceWindowExecutionTasksErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceWindowExecutionTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceWindowExecutionTasksError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowExecutionTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowExecutionTasksError {
    /// Creates a new `DescribeMaintenanceWindowExecutionTasksError`.
    pub fn new(
        kind: DescribeMaintenanceWindowExecutionTasksErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowExecutionTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowExecutionTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowExecutionTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowExecutionTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowExecutionTasksErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowExecutionTasksErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowExecutionTasksErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowExecutionTasksErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowExecutionTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowExecutionTasksErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribeMaintenanceWindowExecutionTasksErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeMaintenanceWindowExecutionTasksErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeMaintenanceWindows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowsError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeMaintenanceWindowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceWindowsError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowsError {
    /// Creates a new `DescribeMaintenanceWindowsError`.
    pub fn new(kind: DescribeMaintenanceWindowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMaintenanceWindowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMaintenanceWindowSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowScheduleError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindowSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowScheduleErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowScheduleErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceWindowScheduleErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceWindowScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceWindowScheduleError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowScheduleError {
    /// Creates a new `DescribeMaintenanceWindowScheduleError`.
    pub fn new(
        kind: DescribeMaintenanceWindowScheduleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowScheduleErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowScheduleErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowScheduleErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowScheduleErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowScheduleErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribeMaintenanceWindowScheduleErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMaintenanceWindowScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMaintenanceWindowsForTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowsForTargetError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowsForTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindowsForTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowsForTargetErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowsForTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowsForTargetErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceWindowsForTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceWindowsForTargetError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowsForTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowsForTargetError {
    /// Creates a new `DescribeMaintenanceWindowsForTargetError`.
    pub fn new(
        kind: DescribeMaintenanceWindowsForTargetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowsForTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowsForTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowsForTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowsForTargetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowsForTargetErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowsForTargetErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowsForTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowsForTargetErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeMaintenanceWindowsForTargetErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeMaintenanceWindowTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowTargetsError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindowTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowTargetsErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowTargetsErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMaintenanceWindowTargetsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeMaintenanceWindowTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceWindowTargetsError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowTargetsError {
    /// Creates a new `DescribeMaintenanceWindowTargetsError`.
    pub fn new(
        kind: DescribeMaintenanceWindowTargetsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowTargetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowTargetsErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowTargetsErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowTargetsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowTargetsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowTargetsErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribeMaintenanceWindowTargetsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMaintenanceWindowTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMaintenanceWindowTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMaintenanceWindowTasksError {
    /// Kind of error that occurred.
    pub kind: DescribeMaintenanceWindowTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMaintenanceWindowTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMaintenanceWindowTasksErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMaintenanceWindowTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMaintenanceWindowTasksErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            DescribeMaintenanceWindowTasksErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeMaintenanceWindowTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMaintenanceWindowTasksError {
    fn code(&self) -> Option<&str> {
        DescribeMaintenanceWindowTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMaintenanceWindowTasksError {
    /// Creates a new `DescribeMaintenanceWindowTasksError`.
    pub fn new(
        kind: DescribeMaintenanceWindowTasksErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMaintenanceWindowTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMaintenanceWindowTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMaintenanceWindowTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMaintenanceWindowTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowTasksErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowTasksErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMaintenanceWindowTasksErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMaintenanceWindowTasksErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeMaintenanceWindowTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMaintenanceWindowTasksErrorKind::DoesNotExistException(_inner) => Some(_inner),
            DescribeMaintenanceWindowTasksErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMaintenanceWindowTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOpsItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOpsItemsError {
    /// Kind of error that occurred.
    pub kind: DescribeOpsItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOpsItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOpsItemsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOpsItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOpsItemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeOpsItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOpsItemsError {
    fn code(&self) -> Option<&str> {
        DescribeOpsItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOpsItemsError {
    /// Creates a new `DescribeOpsItemsError`.
    pub fn new(kind: DescribeOpsItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOpsItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOpsItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOpsItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOpsItemsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOpsItemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOpsItemsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeOpsItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOpsItemsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeOpsItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeParametersErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The specified filter option isn't valid. Valid options are Equals and BeginsWith. For Path
    /// filter, valid options are Recursive and OneLevel.</p>
    InvalidFilterOption(crate::error::InvalidFilterOption),
    /// <p>The filter value isn't valid. Verify the value and try again.</p>
    InvalidFilterValue(crate::error::InvalidFilterValue),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeParametersErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::InvalidFilterOption(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::InvalidFilterValue(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeParametersError {
    fn code(&self) -> Option<&str> {
        DescribeParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeParametersError {
    /// Creates a new `DescribeParametersError`.
    pub fn new(kind: DescribeParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(&self.kind, DescribeParametersErrorKind::InvalidFilterKey(_))
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::InvalidFilterOption`.
    pub fn is_invalid_filter_option(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::InvalidFilterOption(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::InvalidFilterValue`.
    pub fn is_invalid_filter_value(&self) -> bool {
        matches!(
            &self.kind,
            DescribeParametersErrorKind::InvalidFilterValue(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeParametersErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, DescribeParametersErrorKind::InvalidNextToken(_))
    }
}
impl std::error::Error for DescribeParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeParametersErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeParametersErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            DescribeParametersErrorKind::InvalidFilterOption(_inner) => Some(_inner),
            DescribeParametersErrorKind::InvalidFilterValue(_inner) => Some(_inner),
            DescribeParametersErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePatchBaselines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePatchBaselinesError {
    /// Kind of error that occurred.
    pub kind: DescribePatchBaselinesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePatchBaselines` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePatchBaselinesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePatchBaselinesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePatchBaselinesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribePatchBaselinesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePatchBaselinesError {
    fn code(&self) -> Option<&str> {
        DescribePatchBaselinesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePatchBaselinesError {
    /// Creates a new `DescribePatchBaselinesError`.
    pub fn new(kind: DescribePatchBaselinesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePatchBaselinesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePatchBaselinesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePatchBaselinesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePatchBaselinesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePatchBaselinesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribePatchBaselinesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribePatchBaselinesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePatchBaselinesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribePatchBaselinesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePatchGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePatchGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribePatchGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePatchGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePatchGroupsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePatchGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePatchGroupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribePatchGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePatchGroupsError {
    fn code(&self) -> Option<&str> {
        DescribePatchGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePatchGroupsError {
    /// Creates a new `DescribePatchGroupsError`.
    pub fn new(kind: DescribePatchGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePatchGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePatchGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePatchGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePatchGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePatchGroupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribePatchGroupsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribePatchGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePatchGroupsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribePatchGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePatchGroupState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePatchGroupStateError {
    /// Kind of error that occurred.
    pub kind: DescribePatchGroupStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePatchGroupState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePatchGroupStateErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePatchGroupStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePatchGroupStateErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribePatchGroupStateErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribePatchGroupStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePatchGroupStateError {
    fn code(&self) -> Option<&str> {
        DescribePatchGroupStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePatchGroupStateError {
    /// Creates a new `DescribePatchGroupStateError`.
    pub fn new(kind: DescribePatchGroupStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePatchGroupStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePatchGroupStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePatchGroupStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePatchGroupStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePatchGroupStateErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribePatchGroupStateErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePatchGroupStateErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribePatchGroupStateErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribePatchGroupStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePatchGroupStateErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribePatchGroupStateErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribePatchGroupStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePatchProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePatchPropertiesError {
    /// Kind of error that occurred.
    pub kind: DescribePatchPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePatchProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePatchPropertiesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePatchPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePatchPropertiesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribePatchPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePatchPropertiesError {
    fn code(&self) -> Option<&str> {
        DescribePatchPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePatchPropertiesError {
    /// Creates a new `DescribePatchPropertiesError`.
    pub fn new(kind: DescribePatchPropertiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePatchPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePatchPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePatchPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePatchPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePatchPropertiesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribePatchPropertiesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribePatchPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePatchPropertiesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribePatchPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSessionsError {
    /// Kind of error that occurred.
    pub kind: DescribeSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSessionsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSessionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeSessionsErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            DescribeSessionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSessionsError {
    fn code(&self) -> Option<&str> {
        DescribeSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSessionsError {
    /// Creates a new `DescribeSessionsError`.
    pub fn new(kind: DescribeSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSessionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSessionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSessionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSessionsErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(&self.kind, DescribeSessionsErrorKind::InvalidFilterKey(_))
    }
    /// Returns `true` if the error kind is `DescribeSessionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, DescribeSessionsErrorKind::InvalidNextToken(_))
    }
}
impl std::error::Error for DescribeSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSessionsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeSessionsErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            DescribeSessionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateOpsItemRelatedItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateOpsItemRelatedItemError {
    /// Kind of error that occurred.
    pub kind: DisassociateOpsItemRelatedItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateOpsItemRelatedItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateOpsItemRelatedItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A specified parameter argument isn't valid. Verify the available arguments and try
    /// again.</p>
    OpsItemInvalidParameterException(crate::error::OpsItemInvalidParameterException),
    /// <p>The specified OpsItem ID doesn't exist. Verify the ID and try again.</p>
    OpsItemNotFoundException(crate::error::OpsItemNotFoundException),
    /// <p>The association wasn't found using the parameters you specified in the call. Verify the
    /// information and try again.</p>
    OpsItemRelatedItemAssociationNotFoundException(
        crate::error::OpsItemRelatedItemAssociationNotFoundException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateOpsItemRelatedItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateOpsItemRelatedItemErrorKind::InternalServerError(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAssociationNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateOpsItemRelatedItemErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateOpsItemRelatedItemError {
    fn code(&self) -> Option<&str> {
        DisassociateOpsItemRelatedItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateOpsItemRelatedItemError {
    /// Creates a new `DisassociateOpsItemRelatedItemError`.
    pub fn new(
        kind: DisassociateOpsItemRelatedItemErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateOpsItemRelatedItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateOpsItemRelatedItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateOpsItemRelatedItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateOpsItemRelatedItemErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateOpsItemRelatedItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOpsItemRelatedItemErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException`.
    pub fn is_ops_item_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException`.
    pub fn is_ops_item_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAssociationNotFoundException`.
    pub fn is_ops_item_related_item_association_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAssociationNotFoundException(
                _
            )
        )
    }
}
impl std::error::Error for DisassociateOpsItemRelatedItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateOpsItemRelatedItemErrorKind::InternalServerError(_inner) =>
            Some(_inner)
            ,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemInvalidParameterException(_inner) =>
            Some(_inner)
            ,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemNotFoundException(_inner) =>
            Some(_inner)
            ,
            DisassociateOpsItemRelatedItemErrorKind::OpsItemRelatedItemAssociationNotFoundException(_inner) =>
            Some(_inner)
            ,
            DisassociateOpsItemRelatedItemErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAutomationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAutomationExecutionError {
    /// Kind of error that occurred.
    pub kind: GetAutomationExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAutomationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAutomationExecutionErrorKind {
    /// <p>There is no automation execution information for the requested automation execution
    /// ID.</p>
    AutomationExecutionNotFoundException(crate::error::AutomationExecutionNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAutomationExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAutomationExecutionErrorKind::AutomationExecutionNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetAutomationExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetAutomationExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAutomationExecutionError {
    fn code(&self) -> Option<&str> {
        GetAutomationExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAutomationExecutionError {
    /// Creates a new `GetAutomationExecutionError`.
    pub fn new(kind: GetAutomationExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAutomationExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAutomationExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAutomationExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAutomationExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAutomationExecutionErrorKind::AutomationExecutionNotFoundException`.
    pub fn is_automation_execution_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAutomationExecutionErrorKind::AutomationExecutionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAutomationExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetAutomationExecutionErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetAutomationExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAutomationExecutionErrorKind::AutomationExecutionNotFoundException(_inner) => {
                Some(_inner)
            }
            GetAutomationExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            GetAutomationExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCalendarState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCalendarStateError {
    /// Kind of error that occurred.
    pub kind: GetCalendarStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCalendarState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCalendarStateErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The SSM document type isn't valid. Valid document types are described in the
    /// <code>DocumentType</code> property.</p>
    InvalidDocumentType(crate::error::InvalidDocumentType),
    /// <p>The calendar entry contained in the specified SSM document isn't supported.</p>
    UnsupportedCalendarException(crate::error::UnsupportedCalendarException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCalendarStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCalendarStateErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetCalendarStateErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            GetCalendarStateErrorKind::InvalidDocumentType(_inner) => _inner.fmt(f),
            GetCalendarStateErrorKind::UnsupportedCalendarException(_inner) => _inner.fmt(f),
            GetCalendarStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCalendarStateError {
    fn code(&self) -> Option<&str> {
        GetCalendarStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCalendarStateError {
    /// Creates a new `GetCalendarStateError`.
    pub fn new(kind: GetCalendarStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCalendarStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCalendarStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCalendarStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCalendarStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCalendarStateErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetCalendarStateErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetCalendarStateErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, GetCalendarStateErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `GetCalendarStateErrorKind::InvalidDocumentType`.
    pub fn is_invalid_document_type(&self) -> bool {
        matches!(
            &self.kind,
            GetCalendarStateErrorKind::InvalidDocumentType(_)
        )
    }
    /// Returns `true` if the error kind is `GetCalendarStateErrorKind::UnsupportedCalendarException`.
    pub fn is_unsupported_calendar_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCalendarStateErrorKind::UnsupportedCalendarException(_)
        )
    }
}
impl std::error::Error for GetCalendarStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCalendarStateErrorKind::InternalServerError(_inner) => Some(_inner),
            GetCalendarStateErrorKind::InvalidDocument(_inner) => Some(_inner),
            GetCalendarStateErrorKind::InvalidDocumentType(_inner) => Some(_inner),
            GetCalendarStateErrorKind::UnsupportedCalendarException(_inner) => Some(_inner),
            GetCalendarStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCommandInvocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCommandInvocationError {
    /// Kind of error that occurred.
    pub kind: GetCommandInvocationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCommandInvocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCommandInvocationErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified command ID isn't valid. Verify the ID and try again.</p>
    InvalidCommandId(crate::error::InvalidCommandId),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The plugin name isn't valid.</p>
    InvalidPluginName(crate::error::InvalidPluginName),
    /// <p>The command ID and managed node ID you specified didn't match any invocations. Verify the
    /// command ID and the managed node ID and try again. </p>
    InvocationDoesNotExist(crate::error::InvocationDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCommandInvocationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCommandInvocationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetCommandInvocationErrorKind::InvalidCommandId(_inner) => _inner.fmt(f),
            GetCommandInvocationErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            GetCommandInvocationErrorKind::InvalidPluginName(_inner) => _inner.fmt(f),
            GetCommandInvocationErrorKind::InvocationDoesNotExist(_inner) => _inner.fmt(f),
            GetCommandInvocationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCommandInvocationError {
    fn code(&self) -> Option<&str> {
        GetCommandInvocationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCommandInvocationError {
    /// Creates a new `GetCommandInvocationError`.
    pub fn new(kind: GetCommandInvocationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCommandInvocationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCommandInvocationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCommandInvocationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCommandInvocationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCommandInvocationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetCommandInvocationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommandInvocationErrorKind::InvalidCommandId`.
    pub fn is_invalid_command_id(&self) -> bool {
        matches!(
            &self.kind,
            GetCommandInvocationErrorKind::InvalidCommandId(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommandInvocationErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            GetCommandInvocationErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommandInvocationErrorKind::InvalidPluginName`.
    pub fn is_invalid_plugin_name(&self) -> bool {
        matches!(
            &self.kind,
            GetCommandInvocationErrorKind::InvalidPluginName(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommandInvocationErrorKind::InvocationDoesNotExist`.
    pub fn is_invocation_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            GetCommandInvocationErrorKind::InvocationDoesNotExist(_)
        )
    }
}
impl std::error::Error for GetCommandInvocationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCommandInvocationErrorKind::InternalServerError(_inner) => Some(_inner),
            GetCommandInvocationErrorKind::InvalidCommandId(_inner) => Some(_inner),
            GetCommandInvocationErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            GetCommandInvocationErrorKind::InvalidPluginName(_inner) => Some(_inner),
            GetCommandInvocationErrorKind::InvocationDoesNotExist(_inner) => Some(_inner),
            GetCommandInvocationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectionStatusError {
    /// Kind of error that occurred.
    pub kind: GetConnectionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnectionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectionStatusErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectionStatusErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetConnectionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectionStatusError {
    fn code(&self) -> Option<&str> {
        GetConnectionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectionStatusError {
    /// Creates a new `GetConnectionStatusError`.
    pub fn new(kind: GetConnectionStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectionStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConnectionStatusErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionStatusErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetConnectionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectionStatusErrorKind::InternalServerError(_inner) => Some(_inner),
            GetConnectionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDefaultPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDefaultPatchBaselineError {
    /// Kind of error that occurred.
    pub kind: GetDefaultPatchBaselineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDefaultPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDefaultPatchBaselineErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDefaultPatchBaselineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDefaultPatchBaselineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetDefaultPatchBaselineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDefaultPatchBaselineError {
    fn code(&self) -> Option<&str> {
        GetDefaultPatchBaselineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDefaultPatchBaselineError {
    /// Creates a new `GetDefaultPatchBaselineError`.
    pub fn new(kind: GetDefaultPatchBaselineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDefaultPatchBaselineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDefaultPatchBaselineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDefaultPatchBaselineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDefaultPatchBaselineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDefaultPatchBaselineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetDefaultPatchBaselineErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetDefaultPatchBaselineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDefaultPatchBaselineErrorKind::InternalServerError(_inner) => Some(_inner),
            GetDefaultPatchBaselineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeployablePatchSnapshotForInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeployablePatchSnapshotForInstanceError {
    /// Kind of error that occurred.
    pub kind: GetDeployablePatchSnapshotForInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeployablePatchSnapshotForInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeployablePatchSnapshotForInstanceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Patching for applications released by Microsoft is only available on EC2 instances and
    /// advanced instances. To patch applications released by Microsoft on on-premises servers and VMs,
    /// you must enable advanced instances. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html">Enabling
    /// the advanced-instances tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    UnsupportedFeatureRequiredException(crate::error::UnsupportedFeatureRequiredException),
    /// <p>The operating systems you specified isn't supported, or the operation isn't supported for
    /// the operating system.</p>
    UnsupportedOperatingSystem(crate::error::UnsupportedOperatingSystem),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeployablePatchSnapshotForInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeployablePatchSnapshotForInstanceErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedFeatureRequiredException(
                _inner,
            ) => _inner.fmt(f),
            GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedOperatingSystem(_inner) => {
                _inner.fmt(f)
            }
            GetDeployablePatchSnapshotForInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeployablePatchSnapshotForInstanceError {
    fn code(&self) -> Option<&str> {
        GetDeployablePatchSnapshotForInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeployablePatchSnapshotForInstanceError {
    /// Creates a new `GetDeployablePatchSnapshotForInstanceError`.
    pub fn new(
        kind: GetDeployablePatchSnapshotForInstanceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeployablePatchSnapshotForInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeployablePatchSnapshotForInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeployablePatchSnapshotForInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeployablePatchSnapshotForInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeployablePatchSnapshotForInstanceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetDeployablePatchSnapshotForInstanceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedFeatureRequiredException`.
    pub fn is_unsupported_feature_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedFeatureRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedOperatingSystem`.
    pub fn is_unsupported_operating_system(&self) -> bool {
        matches!(
            &self.kind,
            GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedOperatingSystem(_)
        )
    }
}
impl std::error::Error for GetDeployablePatchSnapshotForInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeployablePatchSnapshotForInstanceErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedFeatureRequiredException(
                _inner,
            ) => Some(_inner),
            GetDeployablePatchSnapshotForInstanceErrorKind::UnsupportedOperatingSystem(_inner) => {
                Some(_inner)
            }
            GetDeployablePatchSnapshotForInstanceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDocumentError {
    /// Kind of error that occurred.
    pub kind: GetDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDocumentErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDocumentErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetDocumentErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            GetDocumentErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            GetDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDocumentError {
    fn code(&self) -> Option<&str> {
        GetDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDocumentError {
    /// Creates a new `GetDocumentError`.
    pub fn new(kind: GetDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDocumentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDocumentErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetDocumentErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetDocumentErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, GetDocumentErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `GetDocumentErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(&self.kind, GetDocumentErrorKind::InvalidDocumentVersion(_))
    }
}
impl std::error::Error for GetDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDocumentErrorKind::InternalServerError(_inner) => Some(_inner),
            GetDocumentErrorKind::InvalidDocument(_inner) => Some(_inner),
            GetDocumentErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            GetDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInventoryError {
    /// Kind of error that occurred.
    pub kind: GetInventoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInventoryErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified aggregator isn't valid for inventory groups. Verify that the aggregator uses a
    /// valid inventory type such as <code>AWS:Application</code> or
    /// <code>AWS:InstanceInformation</code>.</p>
    InvalidAggregatorException(crate::error::InvalidAggregatorException),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified inventory group isn't valid.</p>
    InvalidInventoryGroupException(crate::error::InvalidInventoryGroupException),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The specified inventory item result attribute isn't valid.</p>
    InvalidResultAttributeException(crate::error::InvalidResultAttributeException),
    /// <p>The parameter type name isn't valid.</p>
    InvalidTypeNameException(crate::error::InvalidTypeNameException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInventoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInventoryErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetInventoryErrorKind::InvalidAggregatorException(_inner) => _inner.fmt(f),
            GetInventoryErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            GetInventoryErrorKind::InvalidInventoryGroupException(_inner) => _inner.fmt(f),
            GetInventoryErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            GetInventoryErrorKind::InvalidResultAttributeException(_inner) => _inner.fmt(f),
            GetInventoryErrorKind::InvalidTypeNameException(_inner) => _inner.fmt(f),
            GetInventoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInventoryError {
    fn code(&self) -> Option<&str> {
        GetInventoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInventoryError {
    /// Creates a new `GetInventoryError`.
    pub fn new(kind: GetInventoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInventoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInventoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInventoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInventoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInventoryErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetInventoryErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetInventoryErrorKind::InvalidAggregatorException`.
    pub fn is_invalid_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInventoryErrorKind::InvalidAggregatorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInventoryErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(&self.kind, GetInventoryErrorKind::InvalidFilter(_))
    }
    /// Returns `true` if the error kind is `GetInventoryErrorKind::InvalidInventoryGroupException`.
    pub fn is_invalid_inventory_group_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInventoryErrorKind::InvalidInventoryGroupException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInventoryErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, GetInventoryErrorKind::InvalidNextToken(_))
    }
    /// Returns `true` if the error kind is `GetInventoryErrorKind::InvalidResultAttributeException`.
    pub fn is_invalid_result_attribute_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInventoryErrorKind::InvalidResultAttributeException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInventoryErrorKind::InvalidTypeNameException`.
    pub fn is_invalid_type_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInventoryErrorKind::InvalidTypeNameException(_)
        )
    }
}
impl std::error::Error for GetInventoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInventoryErrorKind::InternalServerError(_inner) => Some(_inner),
            GetInventoryErrorKind::InvalidAggregatorException(_inner) => Some(_inner),
            GetInventoryErrorKind::InvalidFilter(_inner) => Some(_inner),
            GetInventoryErrorKind::InvalidInventoryGroupException(_inner) => Some(_inner),
            GetInventoryErrorKind::InvalidNextToken(_inner) => Some(_inner),
            GetInventoryErrorKind::InvalidResultAttributeException(_inner) => Some(_inner),
            GetInventoryErrorKind::InvalidTypeNameException(_inner) => Some(_inner),
            GetInventoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInventorySchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInventorySchemaError {
    /// Kind of error that occurred.
    pub kind: GetInventorySchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInventorySchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInventorySchemaErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The parameter type name isn't valid.</p>
    InvalidTypeNameException(crate::error::InvalidTypeNameException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInventorySchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInventorySchemaErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetInventorySchemaErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            GetInventorySchemaErrorKind::InvalidTypeNameException(_inner) => _inner.fmt(f),
            GetInventorySchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInventorySchemaError {
    fn code(&self) -> Option<&str> {
        GetInventorySchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInventorySchemaError {
    /// Creates a new `GetInventorySchemaError`.
    pub fn new(kind: GetInventorySchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInventorySchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInventorySchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInventorySchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInventorySchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInventorySchemaErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetInventorySchemaErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetInventorySchemaErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, GetInventorySchemaErrorKind::InvalidNextToken(_))
    }
    /// Returns `true` if the error kind is `GetInventorySchemaErrorKind::InvalidTypeNameException`.
    pub fn is_invalid_type_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInventorySchemaErrorKind::InvalidTypeNameException(_)
        )
    }
}
impl std::error::Error for GetInventorySchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInventorySchemaErrorKind::InternalServerError(_inner) => Some(_inner),
            GetInventorySchemaErrorKind::InvalidNextToken(_inner) => Some(_inner),
            GetInventorySchemaErrorKind::InvalidTypeNameException(_inner) => Some(_inner),
            GetInventorySchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: GetMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMaintenanceWindowErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMaintenanceWindowErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            GetMaintenanceWindowErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        GetMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMaintenanceWindowError {
    /// Creates a new `GetMaintenanceWindowError`.
    pub fn new(kind: GetMaintenanceWindowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMaintenanceWindowErrorKind::DoesNotExistException(_inner) => Some(_inner),
            GetMaintenanceWindowErrorKind::InternalServerError(_inner) => Some(_inner),
            GetMaintenanceWindowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMaintenanceWindowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMaintenanceWindowExecutionError {
    /// Kind of error that occurred.
    pub kind: GetMaintenanceWindowExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMaintenanceWindowExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMaintenanceWindowExecutionErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMaintenanceWindowExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMaintenanceWindowExecutionErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            GetMaintenanceWindowExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetMaintenanceWindowExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMaintenanceWindowExecutionError {
    fn code(&self) -> Option<&str> {
        GetMaintenanceWindowExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMaintenanceWindowExecutionError {
    /// Creates a new `GetMaintenanceWindowExecutionError`.
    pub fn new(
        kind: GetMaintenanceWindowExecutionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMaintenanceWindowExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMaintenanceWindowExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMaintenanceWindowExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMaintenanceWindowExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowExecutionErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowExecutionErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowExecutionErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetMaintenanceWindowExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMaintenanceWindowExecutionErrorKind::DoesNotExistException(_inner) => Some(_inner),
            GetMaintenanceWindowExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            GetMaintenanceWindowExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMaintenanceWindowExecutionTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMaintenanceWindowExecutionTaskError {
    /// Kind of error that occurred.
    pub kind: GetMaintenanceWindowExecutionTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMaintenanceWindowExecutionTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMaintenanceWindowExecutionTaskErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMaintenanceWindowExecutionTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMaintenanceWindowExecutionTaskErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetMaintenanceWindowExecutionTaskErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            GetMaintenanceWindowExecutionTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMaintenanceWindowExecutionTaskError {
    fn code(&self) -> Option<&str> {
        GetMaintenanceWindowExecutionTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMaintenanceWindowExecutionTaskError {
    /// Creates a new `GetMaintenanceWindowExecutionTaskError`.
    pub fn new(
        kind: GetMaintenanceWindowExecutionTaskErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMaintenanceWindowExecutionTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMaintenanceWindowExecutionTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMaintenanceWindowExecutionTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMaintenanceWindowExecutionTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowExecutionTaskErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowExecutionTaskErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowExecutionTaskErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowExecutionTaskErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetMaintenanceWindowExecutionTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMaintenanceWindowExecutionTaskErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetMaintenanceWindowExecutionTaskErrorKind::InternalServerError(_inner) => Some(_inner),
            GetMaintenanceWindowExecutionTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMaintenanceWindowExecutionTaskInvocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMaintenanceWindowExecutionTaskInvocationError {
    /// Kind of error that occurred.
    pub kind: GetMaintenanceWindowExecutionTaskInvocationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMaintenanceWindowExecutionTaskInvocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMaintenanceWindowExecutionTaskInvocationErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMaintenanceWindowExecutionTaskInvocationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for GetMaintenanceWindowExecutionTaskInvocationError
{
    fn code(&self) -> Option<&str> {
        GetMaintenanceWindowExecutionTaskInvocationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMaintenanceWindowExecutionTaskInvocationError {
    /// Creates a new `GetMaintenanceWindowExecutionTaskInvocationError`.
    pub fn new(
        kind: GetMaintenanceWindowExecutionTaskInvocationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMaintenanceWindowExecutionTaskInvocationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMaintenanceWindowExecutionTaskInvocationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMaintenanceWindowExecutionTaskInvocationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMaintenanceWindowExecutionTaskInvocationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowExecutionTaskInvocationErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowExecutionTaskInvocationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetMaintenanceWindowExecutionTaskInvocationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            GetMaintenanceWindowExecutionTaskInvocationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetMaintenanceWindowTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMaintenanceWindowTaskError {
    /// Kind of error that occurred.
    pub kind: GetMaintenanceWindowTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMaintenanceWindowTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMaintenanceWindowTaskErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMaintenanceWindowTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMaintenanceWindowTaskErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            GetMaintenanceWindowTaskErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetMaintenanceWindowTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMaintenanceWindowTaskError {
    fn code(&self) -> Option<&str> {
        GetMaintenanceWindowTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMaintenanceWindowTaskError {
    /// Creates a new `GetMaintenanceWindowTaskError`.
    pub fn new(kind: GetMaintenanceWindowTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMaintenanceWindowTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMaintenanceWindowTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMaintenanceWindowTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMaintenanceWindowTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowTaskErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowTaskErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMaintenanceWindowTaskErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetMaintenanceWindowTaskErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetMaintenanceWindowTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMaintenanceWindowTaskErrorKind::DoesNotExistException(_inner) => Some(_inner),
            GetMaintenanceWindowTaskErrorKind::InternalServerError(_inner) => Some(_inner),
            GetMaintenanceWindowTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOpsItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOpsItemError {
    /// Kind of error that occurred.
    pub kind: GetOpsItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOpsItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOpsItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified OpsItem ID doesn't exist. Verify the ID and try again.</p>
    OpsItemNotFoundException(crate::error::OpsItemNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOpsItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOpsItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetOpsItemErrorKind::OpsItemNotFoundException(_inner) => _inner.fmt(f),
            GetOpsItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOpsItemError {
    fn code(&self) -> Option<&str> {
        GetOpsItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOpsItemError {
    /// Creates a new `GetOpsItemError`.
    pub fn new(kind: GetOpsItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOpsItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOpsItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOpsItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOpsItemErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOpsItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetOpsItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetOpsItemErrorKind::OpsItemNotFoundException`.
    pub fn is_ops_item_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetOpsItemErrorKind::OpsItemNotFoundException(_))
    }
}
impl std::error::Error for GetOpsItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOpsItemErrorKind::InternalServerError(_inner) => Some(_inner),
            GetOpsItemErrorKind::OpsItemNotFoundException(_inner) => Some(_inner),
            GetOpsItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOpsMetadataError {
    /// Kind of error that occurred.
    pub kind: GetOpsMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOpsMetadataErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>One of the arguments passed is invalid. </p>
    OpsMetadataInvalidArgumentException(crate::error::OpsMetadataInvalidArgumentException),
    /// <p>The OpsMetadata object doesn't exist. </p>
    OpsMetadataNotFoundException(crate::error::OpsMetadataNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOpsMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOpsMetadataErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => _inner.fmt(f),
            GetOpsMetadataErrorKind::OpsMetadataNotFoundException(_inner) => _inner.fmt(f),
            GetOpsMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOpsMetadataError {
    fn code(&self) -> Option<&str> {
        GetOpsMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOpsMetadataError {
    /// Creates a new `GetOpsMetadataError`.
    pub fn new(kind: GetOpsMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOpsMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOpsMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOpsMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOpsMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOpsMetadataErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetOpsMetadataErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetOpsMetadataErrorKind::OpsMetadataInvalidArgumentException`.
    pub fn is_ops_metadata_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOpsMetadataErrorKind::OpsMetadataNotFoundException`.
    pub fn is_ops_metadata_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpsMetadataErrorKind::OpsMetadataNotFoundException(_)
        )
    }
}
impl std::error::Error for GetOpsMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOpsMetadataErrorKind::InternalServerError(_inner) => Some(_inner),
            GetOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => Some(_inner),
            GetOpsMetadataErrorKind::OpsMetadataNotFoundException(_inner) => Some(_inner),
            GetOpsMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOpsSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOpsSummaryError {
    /// Kind of error that occurred.
    pub kind: GetOpsSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOpsSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOpsSummaryErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified aggregator isn't valid for inventory groups. Verify that the aggregator uses a
    /// valid inventory type such as <code>AWS:Application</code> or
    /// <code>AWS:InstanceInformation</code>.</p>
    InvalidAggregatorException(crate::error::InvalidAggregatorException),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The parameter type name isn't valid.</p>
    InvalidTypeNameException(crate::error::InvalidTypeNameException),
    /// <p>The specified sync name wasn't found.</p>
    ResourceDataSyncNotFoundException(crate::error::ResourceDataSyncNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOpsSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOpsSummaryErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetOpsSummaryErrorKind::InvalidAggregatorException(_inner) => _inner.fmt(f),
            GetOpsSummaryErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            GetOpsSummaryErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            GetOpsSummaryErrorKind::InvalidTypeNameException(_inner) => _inner.fmt(f),
            GetOpsSummaryErrorKind::ResourceDataSyncNotFoundException(_inner) => _inner.fmt(f),
            GetOpsSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOpsSummaryError {
    fn code(&self) -> Option<&str> {
        GetOpsSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOpsSummaryError {
    /// Creates a new `GetOpsSummaryError`.
    pub fn new(kind: GetOpsSummaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOpsSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOpsSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOpsSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOpsSummaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOpsSummaryErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetOpsSummaryErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetOpsSummaryErrorKind::InvalidAggregatorException`.
    pub fn is_invalid_aggregator_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpsSummaryErrorKind::InvalidAggregatorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOpsSummaryErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(&self.kind, GetOpsSummaryErrorKind::InvalidFilter(_))
    }
    /// Returns `true` if the error kind is `GetOpsSummaryErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, GetOpsSummaryErrorKind::InvalidNextToken(_))
    }
    /// Returns `true` if the error kind is `GetOpsSummaryErrorKind::InvalidTypeNameException`.
    pub fn is_invalid_type_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpsSummaryErrorKind::InvalidTypeNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOpsSummaryErrorKind::ResourceDataSyncNotFoundException`.
    pub fn is_resource_data_sync_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpsSummaryErrorKind::ResourceDataSyncNotFoundException(_)
        )
    }
}
impl std::error::Error for GetOpsSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOpsSummaryErrorKind::InternalServerError(_inner) => Some(_inner),
            GetOpsSummaryErrorKind::InvalidAggregatorException(_inner) => Some(_inner),
            GetOpsSummaryErrorKind::InvalidFilter(_inner) => Some(_inner),
            GetOpsSummaryErrorKind::InvalidNextToken(_inner) => Some(_inner),
            GetOpsSummaryErrorKind::InvalidTypeNameException(_inner) => Some(_inner),
            GetOpsSummaryErrorKind::ResourceDataSyncNotFoundException(_inner) => Some(_inner),
            GetOpsSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetParameterError {
    /// Kind of error that occurred.
    pub kind: GetParameterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetParameterErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The query key ID isn't valid.</p>
    InvalidKeyId(crate::error::InvalidKeyId),
    /// <p>The parameter couldn't be found. Verify the name and try again.</p>
    ParameterNotFound(crate::error::ParameterNotFound),
    /// <p>The specified parameter version wasn't found. Verify the parameter name and version, and try
    /// again.</p>
    ParameterVersionNotFound(crate::error::ParameterVersionNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetParameterErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetParameterErrorKind::InvalidKeyId(_inner) => _inner.fmt(f),
            GetParameterErrorKind::ParameterNotFound(_inner) => _inner.fmt(f),
            GetParameterErrorKind::ParameterVersionNotFound(_inner) => _inner.fmt(f),
            GetParameterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetParameterError {
    fn code(&self) -> Option<&str> {
        GetParameterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetParameterError {
    /// Creates a new `GetParameterError`.
    pub fn new(kind: GetParameterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetParameterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetParameterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetParameterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetParameterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetParameterErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetParameterErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetParameterErrorKind::InvalidKeyId`.
    pub fn is_invalid_key_id(&self) -> bool {
        matches!(&self.kind, GetParameterErrorKind::InvalidKeyId(_))
    }
    /// Returns `true` if the error kind is `GetParameterErrorKind::ParameterNotFound`.
    pub fn is_parameter_not_found(&self) -> bool {
        matches!(&self.kind, GetParameterErrorKind::ParameterNotFound(_))
    }
    /// Returns `true` if the error kind is `GetParameterErrorKind::ParameterVersionNotFound`.
    pub fn is_parameter_version_not_found(&self) -> bool {
        matches!(
            &self.kind,
            GetParameterErrorKind::ParameterVersionNotFound(_)
        )
    }
}
impl std::error::Error for GetParameterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetParameterErrorKind::InternalServerError(_inner) => Some(_inner),
            GetParameterErrorKind::InvalidKeyId(_inner) => Some(_inner),
            GetParameterErrorKind::ParameterNotFound(_inner) => Some(_inner),
            GetParameterErrorKind::ParameterVersionNotFound(_inner) => Some(_inner),
            GetParameterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetParameterHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetParameterHistoryError {
    /// Kind of error that occurred.
    pub kind: GetParameterHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetParameterHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetParameterHistoryErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The query key ID isn't valid.</p>
    InvalidKeyId(crate::error::InvalidKeyId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The parameter couldn't be found. Verify the name and try again.</p>
    ParameterNotFound(crate::error::ParameterNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetParameterHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetParameterHistoryErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetParameterHistoryErrorKind::InvalidKeyId(_inner) => _inner.fmt(f),
            GetParameterHistoryErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            GetParameterHistoryErrorKind::ParameterNotFound(_inner) => _inner.fmt(f),
            GetParameterHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetParameterHistoryError {
    fn code(&self) -> Option<&str> {
        GetParameterHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetParameterHistoryError {
    /// Creates a new `GetParameterHistoryError`.
    pub fn new(kind: GetParameterHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetParameterHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetParameterHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetParameterHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetParameterHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetParameterHistoryErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetParameterHistoryErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetParameterHistoryErrorKind::InvalidKeyId`.
    pub fn is_invalid_key_id(&self) -> bool {
        matches!(&self.kind, GetParameterHistoryErrorKind::InvalidKeyId(_))
    }
    /// Returns `true` if the error kind is `GetParameterHistoryErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            GetParameterHistoryErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `GetParameterHistoryErrorKind::ParameterNotFound`.
    pub fn is_parameter_not_found(&self) -> bool {
        matches!(
            &self.kind,
            GetParameterHistoryErrorKind::ParameterNotFound(_)
        )
    }
}
impl std::error::Error for GetParameterHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetParameterHistoryErrorKind::InternalServerError(_inner) => Some(_inner),
            GetParameterHistoryErrorKind::InvalidKeyId(_inner) => Some(_inner),
            GetParameterHistoryErrorKind::InvalidNextToken(_inner) => Some(_inner),
            GetParameterHistoryErrorKind::ParameterNotFound(_inner) => Some(_inner),
            GetParameterHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetParametersError {
    /// Kind of error that occurred.
    pub kind: GetParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetParametersErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The query key ID isn't valid.</p>
    InvalidKeyId(crate::error::InvalidKeyId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetParametersErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetParametersErrorKind::InvalidKeyId(_inner) => _inner.fmt(f),
            GetParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetParametersError {
    fn code(&self) -> Option<&str> {
        GetParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetParametersError {
    /// Creates a new `GetParametersError`.
    pub fn new(kind: GetParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetParametersErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetParametersErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetParametersErrorKind::InvalidKeyId`.
    pub fn is_invalid_key_id(&self) -> bool {
        matches!(&self.kind, GetParametersErrorKind::InvalidKeyId(_))
    }
}
impl std::error::Error for GetParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetParametersErrorKind::InternalServerError(_inner) => Some(_inner),
            GetParametersErrorKind::InvalidKeyId(_inner) => Some(_inner),
            GetParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetParametersByPath` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetParametersByPathError {
    /// Kind of error that occurred.
    pub kind: GetParametersByPathErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetParametersByPath` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetParametersByPathErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The specified filter option isn't valid. Valid options are Equals and BeginsWith. For Path
    /// filter, valid options are Recursive and OneLevel.</p>
    InvalidFilterOption(crate::error::InvalidFilterOption),
    /// <p>The filter value isn't valid. Verify the value and try again.</p>
    InvalidFilterValue(crate::error::InvalidFilterValue),
    /// <p>The query key ID isn't valid.</p>
    InvalidKeyId(crate::error::InvalidKeyId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetParametersByPathError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetParametersByPathErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetParametersByPathErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            GetParametersByPathErrorKind::InvalidFilterOption(_inner) => _inner.fmt(f),
            GetParametersByPathErrorKind::InvalidFilterValue(_inner) => _inner.fmt(f),
            GetParametersByPathErrorKind::InvalidKeyId(_inner) => _inner.fmt(f),
            GetParametersByPathErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            GetParametersByPathErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetParametersByPathError {
    fn code(&self) -> Option<&str> {
        GetParametersByPathError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetParametersByPathError {
    /// Creates a new `GetParametersByPathError`.
    pub fn new(kind: GetParametersByPathErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetParametersByPathError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetParametersByPathErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetParametersByPathError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetParametersByPathErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetParametersByPathErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersByPathErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersByPathErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersByPathErrorKind::InvalidFilterKey(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersByPathErrorKind::InvalidFilterOption`.
    pub fn is_invalid_filter_option(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersByPathErrorKind::InvalidFilterOption(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersByPathErrorKind::InvalidFilterValue`.
    pub fn is_invalid_filter_value(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersByPathErrorKind::InvalidFilterValue(_)
        )
    }
    /// Returns `true` if the error kind is `GetParametersByPathErrorKind::InvalidKeyId`.
    pub fn is_invalid_key_id(&self) -> bool {
        matches!(&self.kind, GetParametersByPathErrorKind::InvalidKeyId(_))
    }
    /// Returns `true` if the error kind is `GetParametersByPathErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            GetParametersByPathErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for GetParametersByPathError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetParametersByPathErrorKind::InternalServerError(_inner) => Some(_inner),
            GetParametersByPathErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            GetParametersByPathErrorKind::InvalidFilterOption(_inner) => Some(_inner),
            GetParametersByPathErrorKind::InvalidFilterValue(_inner) => Some(_inner),
            GetParametersByPathErrorKind::InvalidKeyId(_inner) => Some(_inner),
            GetParametersByPathErrorKind::InvalidNextToken(_inner) => Some(_inner),
            GetParametersByPathErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPatchBaselineError {
    /// Kind of error that occurred.
    pub kind: GetPatchBaselineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPatchBaselineErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPatchBaselineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPatchBaselineErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            GetPatchBaselineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetPatchBaselineErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            GetPatchBaselineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPatchBaselineError {
    fn code(&self) -> Option<&str> {
        GetPatchBaselineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPatchBaselineError {
    /// Creates a new `GetPatchBaselineError`.
    pub fn new(kind: GetPatchBaselineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPatchBaselineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPatchBaselineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPatchBaselineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPatchBaselineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPatchBaselineErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPatchBaselineErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPatchBaselineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetPatchBaselineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetPatchBaselineErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(&self.kind, GetPatchBaselineErrorKind::InvalidResourceId(_))
    }
}
impl std::error::Error for GetPatchBaselineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPatchBaselineErrorKind::DoesNotExistException(_inner) => Some(_inner),
            GetPatchBaselineErrorKind::InternalServerError(_inner) => Some(_inner),
            GetPatchBaselineErrorKind::InvalidResourceId(_inner) => Some(_inner),
            GetPatchBaselineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPatchBaselineForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPatchBaselineForPatchGroupError {
    /// Kind of error that occurred.
    pub kind: GetPatchBaselineForPatchGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPatchBaselineForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPatchBaselineForPatchGroupErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPatchBaselineForPatchGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPatchBaselineForPatchGroupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetPatchBaselineForPatchGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPatchBaselineForPatchGroupError {
    fn code(&self) -> Option<&str> {
        GetPatchBaselineForPatchGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPatchBaselineForPatchGroupError {
    /// Creates a new `GetPatchBaselineForPatchGroupError`.
    pub fn new(
        kind: GetPatchBaselineForPatchGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPatchBaselineForPatchGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPatchBaselineForPatchGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPatchBaselineForPatchGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPatchBaselineForPatchGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPatchBaselineForPatchGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetPatchBaselineForPatchGroupErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for GetPatchBaselineForPatchGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPatchBaselineForPatchGroupErrorKind::InternalServerError(_inner) => Some(_inner),
            GetPatchBaselineForPatchGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceSettingError {
    /// Kind of error that occurred.
    pub kind: GetServiceSettingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceSettingErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified service setting wasn't found. Either the service name or the setting hasn't
    /// been provisioned by the Amazon Web Services service team.</p>
    ServiceSettingNotFound(crate::error::ServiceSettingNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceSettingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceSettingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetServiceSettingErrorKind::ServiceSettingNotFound(_inner) => _inner.fmt(f),
            GetServiceSettingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceSettingError {
    fn code(&self) -> Option<&str> {
        GetServiceSettingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceSettingError {
    /// Creates a new `GetServiceSettingError`.
    pub fn new(kind: GetServiceSettingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceSettingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceSettingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceSettingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceSettingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceSettingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceSettingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceSettingErrorKind::ServiceSettingNotFound`.
    pub fn is_service_setting_not_found(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceSettingErrorKind::ServiceSettingNotFound(_)
        )
    }
}
impl std::error::Error for GetServiceSettingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceSettingErrorKind::InternalServerError(_inner) => Some(_inner),
            GetServiceSettingErrorKind::ServiceSettingNotFound(_inner) => Some(_inner),
            GetServiceSettingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `LabelParameterVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct LabelParameterVersionError {
    /// Kind of error that occurred.
    pub kind: LabelParameterVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `LabelParameterVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum LabelParameterVersionErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The parameter couldn't be found. Verify the name and try again.</p>
    ParameterNotFound(crate::error::ParameterNotFound),
    /// <p>A parameter version can have a maximum of ten labels.</p>
    ParameterVersionLabelLimitExceeded(crate::error::ParameterVersionLabelLimitExceeded),
    /// <p>The specified parameter version wasn't found. Verify the parameter name and version, and try
    /// again.</p>
    ParameterVersionNotFound(crate::error::ParameterVersionNotFound),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for LabelParameterVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            LabelParameterVersionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            LabelParameterVersionErrorKind::ParameterNotFound(_inner) => _inner.fmt(f),
            LabelParameterVersionErrorKind::ParameterVersionLabelLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            LabelParameterVersionErrorKind::ParameterVersionNotFound(_inner) => _inner.fmt(f),
            LabelParameterVersionErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            LabelParameterVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for LabelParameterVersionError {
    fn code(&self) -> Option<&str> {
        LabelParameterVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl LabelParameterVersionError {
    /// Creates a new `LabelParameterVersionError`.
    pub fn new(kind: LabelParameterVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `LabelParameterVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: LabelParameterVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `LabelParameterVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: LabelParameterVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `LabelParameterVersionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            LabelParameterVersionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `LabelParameterVersionErrorKind::ParameterNotFound`.
    pub fn is_parameter_not_found(&self) -> bool {
        matches!(
            &self.kind,
            LabelParameterVersionErrorKind::ParameterNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `LabelParameterVersionErrorKind::ParameterVersionLabelLimitExceeded`.
    pub fn is_parameter_version_label_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            LabelParameterVersionErrorKind::ParameterVersionLabelLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `LabelParameterVersionErrorKind::ParameterVersionNotFound`.
    pub fn is_parameter_version_not_found(&self) -> bool {
        matches!(
            &self.kind,
            LabelParameterVersionErrorKind::ParameterVersionNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `LabelParameterVersionErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(
            &self.kind,
            LabelParameterVersionErrorKind::TooManyUpdates(_)
        )
    }
}
impl std::error::Error for LabelParameterVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            LabelParameterVersionErrorKind::InternalServerError(_inner) => Some(_inner),
            LabelParameterVersionErrorKind::ParameterNotFound(_inner) => Some(_inner),
            LabelParameterVersionErrorKind::ParameterVersionLabelLimitExceeded(_inner) => {
                Some(_inner)
            }
            LabelParameterVersionErrorKind::ParameterVersionNotFound(_inner) => Some(_inner),
            LabelParameterVersionErrorKind::TooManyUpdates(_inner) => Some(_inner),
            LabelParameterVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociationsError {
    /// Kind of error that occurred.
    pub kind: ListAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociationsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociationsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListAssociationsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssociationsError {
    fn code(&self) -> Option<&str> {
        ListAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociationsError {
    /// Creates a new `ListAssociationsError`.
    pub fn new(kind: ListAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssociationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, ListAssociationsErrorKind::InvalidNextToken(_))
    }
}
impl std::error::Error for ListAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociationsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListAssociationsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociationVersionsError {
    /// Kind of error that occurred.
    pub kind: ListAssociationVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociationVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociationVersionsErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociationVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociationVersionsErrorKind::AssociationDoesNotExist(_inner) => _inner.fmt(f),
            ListAssociationVersionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListAssociationVersionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListAssociationVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssociationVersionsError {
    fn code(&self) -> Option<&str> {
        ListAssociationVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociationVersionsError {
    /// Creates a new `ListAssociationVersionsError`.
    pub fn new(kind: ListAssociationVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociationVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociationVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociationVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociationVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssociationVersionsErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationVersionsErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationVersionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationVersionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationVersionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationVersionsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for ListAssociationVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociationVersionsErrorKind::AssociationDoesNotExist(_inner) => Some(_inner),
            ListAssociationVersionsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListAssociationVersionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListAssociationVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCommandInvocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCommandInvocationsError {
    /// Kind of error that occurred.
    pub kind: ListCommandInvocationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCommandInvocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCommandInvocationsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified command ID isn't valid. Verify the ID and try again.</p>
    InvalidCommandId(crate::error::InvalidCommandId),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCommandInvocationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCommandInvocationsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListCommandInvocationsErrorKind::InvalidCommandId(_inner) => _inner.fmt(f),
            ListCommandInvocationsErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            ListCommandInvocationsErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            ListCommandInvocationsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListCommandInvocationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCommandInvocationsError {
    fn code(&self) -> Option<&str> {
        ListCommandInvocationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCommandInvocationsError {
    /// Creates a new `ListCommandInvocationsError`.
    pub fn new(kind: ListCommandInvocationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCommandInvocationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCommandInvocationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCommandInvocationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCommandInvocationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCommandInvocationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListCommandInvocationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListCommandInvocationsErrorKind::InvalidCommandId`.
    pub fn is_invalid_command_id(&self) -> bool {
        matches!(
            &self.kind,
            ListCommandInvocationsErrorKind::InvalidCommandId(_)
        )
    }
    /// Returns `true` if the error kind is `ListCommandInvocationsErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(
            &self.kind,
            ListCommandInvocationsErrorKind::InvalidFilterKey(_)
        )
    }
    /// Returns `true` if the error kind is `ListCommandInvocationsErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            ListCommandInvocationsErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `ListCommandInvocationsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListCommandInvocationsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for ListCommandInvocationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCommandInvocationsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListCommandInvocationsErrorKind::InvalidCommandId(_inner) => Some(_inner),
            ListCommandInvocationsErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            ListCommandInvocationsErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            ListCommandInvocationsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListCommandInvocationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCommands` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCommandsError {
    /// Kind of error that occurred.
    pub kind: ListCommandsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCommands` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCommandsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified command ID isn't valid. Verify the ID and try again.</p>
    InvalidCommandId(crate::error::InvalidCommandId),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCommandsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCommandsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListCommandsErrorKind::InvalidCommandId(_inner) => _inner.fmt(f),
            ListCommandsErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            ListCommandsErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            ListCommandsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListCommandsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCommandsError {
    fn code(&self) -> Option<&str> {
        ListCommandsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCommandsError {
    /// Creates a new `ListCommandsError`.
    pub fn new(kind: ListCommandsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCommandsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCommandsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCommandsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCommandsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCommandsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListCommandsErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ListCommandsErrorKind::InvalidCommandId`.
    pub fn is_invalid_command_id(&self) -> bool {
        matches!(&self.kind, ListCommandsErrorKind::InvalidCommandId(_))
    }
    /// Returns `true` if the error kind is `ListCommandsErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(&self.kind, ListCommandsErrorKind::InvalidFilterKey(_))
    }
    /// Returns `true` if the error kind is `ListCommandsErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(&self.kind, ListCommandsErrorKind::InvalidInstanceId(_))
    }
    /// Returns `true` if the error kind is `ListCommandsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, ListCommandsErrorKind::InvalidNextToken(_))
    }
}
impl std::error::Error for ListCommandsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCommandsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListCommandsErrorKind::InvalidCommandId(_inner) => Some(_inner),
            ListCommandsErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            ListCommandsErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            ListCommandsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListCommandsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListComplianceItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListComplianceItemsError {
    /// Kind of error that occurred.
    pub kind: ListComplianceItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListComplianceItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListComplianceItemsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the
    /// instance must be a registered managed node.</p>
    InvalidResourceType(crate::error::InvalidResourceType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListComplianceItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListComplianceItemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListComplianceItemsErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            ListComplianceItemsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListComplianceItemsErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            ListComplianceItemsErrorKind::InvalidResourceType(_inner) => _inner.fmt(f),
            ListComplianceItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListComplianceItemsError {
    fn code(&self) -> Option<&str> {
        ListComplianceItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListComplianceItemsError {
    /// Creates a new `ListComplianceItemsError`.
    pub fn new(kind: ListComplianceItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListComplianceItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListComplianceItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListComplianceItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListComplianceItemsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListComplianceItemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceItemsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListComplianceItemsErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(&self.kind, ListComplianceItemsErrorKind::InvalidFilter(_))
    }
    /// Returns `true` if the error kind is `ListComplianceItemsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceItemsErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `ListComplianceItemsErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceItemsErrorKind::InvalidResourceId(_)
        )
    }
    /// Returns `true` if the error kind is `ListComplianceItemsErrorKind::InvalidResourceType`.
    pub fn is_invalid_resource_type(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceItemsErrorKind::InvalidResourceType(_)
        )
    }
}
impl std::error::Error for ListComplianceItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListComplianceItemsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListComplianceItemsErrorKind::InvalidFilter(_inner) => Some(_inner),
            ListComplianceItemsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListComplianceItemsErrorKind::InvalidResourceId(_inner) => Some(_inner),
            ListComplianceItemsErrorKind::InvalidResourceType(_inner) => Some(_inner),
            ListComplianceItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListComplianceSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListComplianceSummariesError {
    /// Kind of error that occurred.
    pub kind: ListComplianceSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListComplianceSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListComplianceSummariesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListComplianceSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListComplianceSummariesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListComplianceSummariesErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            ListComplianceSummariesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListComplianceSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListComplianceSummariesError {
    fn code(&self) -> Option<&str> {
        ListComplianceSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListComplianceSummariesError {
    /// Creates a new `ListComplianceSummariesError`.
    pub fn new(kind: ListComplianceSummariesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListComplianceSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListComplianceSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListComplianceSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListComplianceSummariesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListComplianceSummariesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceSummariesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListComplianceSummariesErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceSummariesErrorKind::InvalidFilter(_)
        )
    }
    /// Returns `true` if the error kind is `ListComplianceSummariesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListComplianceSummariesErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for ListComplianceSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListComplianceSummariesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListComplianceSummariesErrorKind::InvalidFilter(_inner) => Some(_inner),
            ListComplianceSummariesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListComplianceSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDocumentMetadataHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDocumentMetadataHistoryError {
    /// Kind of error that occurred.
    pub kind: ListDocumentMetadataHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDocumentMetadataHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDocumentMetadataHistoryErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDocumentMetadataHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDocumentMetadataHistoryErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListDocumentMetadataHistoryErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            ListDocumentMetadataHistoryErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            ListDocumentMetadataHistoryErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListDocumentMetadataHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDocumentMetadataHistoryError {
    fn code(&self) -> Option<&str> {
        ListDocumentMetadataHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDocumentMetadataHistoryError {
    /// Creates a new `ListDocumentMetadataHistoryError`.
    pub fn new(kind: ListDocumentMetadataHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDocumentMetadataHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDocumentMetadataHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDocumentMetadataHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDocumentMetadataHistoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDocumentMetadataHistoryErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentMetadataHistoryErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentMetadataHistoryErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentMetadataHistoryErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentMetadataHistoryErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentMetadataHistoryErrorKind::InvalidDocumentVersion(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentMetadataHistoryErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentMetadataHistoryErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for ListDocumentMetadataHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDocumentMetadataHistoryErrorKind::InternalServerError(_inner) => Some(_inner),
            ListDocumentMetadataHistoryErrorKind::InvalidDocument(_inner) => Some(_inner),
            ListDocumentMetadataHistoryErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            ListDocumentMetadataHistoryErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListDocumentMetadataHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDocuments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDocumentsError {
    /// Kind of error that occurred.
    pub kind: ListDocumentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDocuments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDocumentsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified key isn't valid.</p>
    InvalidFilterKey(crate::error::InvalidFilterKey),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDocumentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDocumentsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListDocumentsErrorKind::InvalidFilterKey(_inner) => _inner.fmt(f),
            ListDocumentsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListDocumentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDocumentsError {
    fn code(&self) -> Option<&str> {
        ListDocumentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDocumentsError {
    /// Creates a new `ListDocumentsError`.
    pub fn new(kind: ListDocumentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDocumentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDocumentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDocumentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDocumentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDocumentsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListDocumentsErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ListDocumentsErrorKind::InvalidFilterKey`.
    pub fn is_invalid_filter_key(&self) -> bool {
        matches!(&self.kind, ListDocumentsErrorKind::InvalidFilterKey(_))
    }
    /// Returns `true` if the error kind is `ListDocumentsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, ListDocumentsErrorKind::InvalidNextToken(_))
    }
}
impl std::error::Error for ListDocumentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDocumentsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListDocumentsErrorKind::InvalidFilterKey(_inner) => Some(_inner),
            ListDocumentsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListDocumentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDocumentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDocumentVersionsError {
    /// Kind of error that occurred.
    pub kind: ListDocumentVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDocumentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDocumentVersionsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDocumentVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDocumentVersionsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListDocumentVersionsErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            ListDocumentVersionsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListDocumentVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDocumentVersionsError {
    fn code(&self) -> Option<&str> {
        ListDocumentVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDocumentVersionsError {
    /// Creates a new `ListDocumentVersionsError`.
    pub fn new(kind: ListDocumentVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDocumentVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDocumentVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDocumentVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDocumentVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDocumentVersionsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentVersionsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentVersionsErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentVersionsErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `ListDocumentVersionsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListDocumentVersionsErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for ListDocumentVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDocumentVersionsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListDocumentVersionsErrorKind::InvalidDocument(_inner) => Some(_inner),
            ListDocumentVersionsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListDocumentVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInventoryEntries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInventoryEntriesError {
    /// Kind of error that occurred.
    pub kind: ListInventoryEntriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInventoryEntries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInventoryEntriesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The parameter type name isn't valid.</p>
    InvalidTypeNameException(crate::error::InvalidTypeNameException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInventoryEntriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInventoryEntriesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListInventoryEntriesErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            ListInventoryEntriesErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            ListInventoryEntriesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListInventoryEntriesErrorKind::InvalidTypeNameException(_inner) => _inner.fmt(f),
            ListInventoryEntriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInventoryEntriesError {
    fn code(&self) -> Option<&str> {
        ListInventoryEntriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInventoryEntriesError {
    /// Creates a new `ListInventoryEntriesError`.
    pub fn new(kind: ListInventoryEntriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInventoryEntriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInventoryEntriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInventoryEntriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInventoryEntriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInventoryEntriesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListInventoryEntriesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListInventoryEntriesErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(&self.kind, ListInventoryEntriesErrorKind::InvalidFilter(_))
    }
    /// Returns `true` if the error kind is `ListInventoryEntriesErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            ListInventoryEntriesErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `ListInventoryEntriesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListInventoryEntriesErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `ListInventoryEntriesErrorKind::InvalidTypeNameException`.
    pub fn is_invalid_type_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInventoryEntriesErrorKind::InvalidTypeNameException(_)
        )
    }
}
impl std::error::Error for ListInventoryEntriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInventoryEntriesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListInventoryEntriesErrorKind::InvalidFilter(_inner) => Some(_inner),
            ListInventoryEntriesErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            ListInventoryEntriesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListInventoryEntriesErrorKind::InvalidTypeNameException(_inner) => Some(_inner),
            ListInventoryEntriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOpsItemEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOpsItemEventsError {
    /// Kind of error that occurred.
    pub kind: ListOpsItemEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOpsItemEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOpsItemEventsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A specified parameter argument isn't valid. Verify the available arguments and try
    /// again.</p>
    OpsItemInvalidParameterException(crate::error::OpsItemInvalidParameterException),
    /// <p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem
    /// quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>
    OpsItemLimitExceededException(crate::error::OpsItemLimitExceededException),
    /// <p>The specified OpsItem ID doesn't exist. Verify the ID and try again.</p>
    OpsItemNotFoundException(crate::error::OpsItemNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOpsItemEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOpsItemEventsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListOpsItemEventsErrorKind::OpsItemInvalidParameterException(_inner) => _inner.fmt(f),
            ListOpsItemEventsErrorKind::OpsItemLimitExceededException(_inner) => _inner.fmt(f),
            ListOpsItemEventsErrorKind::OpsItemNotFoundException(_inner) => _inner.fmt(f),
            ListOpsItemEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOpsItemEventsError {
    fn code(&self) -> Option<&str> {
        ListOpsItemEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOpsItemEventsError {
    /// Creates a new `ListOpsItemEventsError`.
    pub fn new(kind: ListOpsItemEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOpsItemEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOpsItemEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOpsItemEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOpsItemEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOpsItemEventsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListOpsItemEventsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListOpsItemEventsErrorKind::OpsItemInvalidParameterException`.
    pub fn is_ops_item_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpsItemEventsErrorKind::OpsItemInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOpsItemEventsErrorKind::OpsItemLimitExceededException`.
    pub fn is_ops_item_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpsItemEventsErrorKind::OpsItemLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOpsItemEventsErrorKind::OpsItemNotFoundException`.
    pub fn is_ops_item_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpsItemEventsErrorKind::OpsItemNotFoundException(_)
        )
    }
}
impl std::error::Error for ListOpsItemEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOpsItemEventsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListOpsItemEventsErrorKind::OpsItemInvalidParameterException(_inner) => Some(_inner),
            ListOpsItemEventsErrorKind::OpsItemLimitExceededException(_inner) => Some(_inner),
            ListOpsItemEventsErrorKind::OpsItemNotFoundException(_inner) => Some(_inner),
            ListOpsItemEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOpsItemRelatedItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOpsItemRelatedItemsError {
    /// Kind of error that occurred.
    pub kind: ListOpsItemRelatedItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOpsItemRelatedItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOpsItemRelatedItemsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>A specified parameter argument isn't valid. Verify the available arguments and try
    /// again.</p>
    OpsItemInvalidParameterException(crate::error::OpsItemInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOpsItemRelatedItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOpsItemRelatedItemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListOpsItemRelatedItemsErrorKind::OpsItemInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListOpsItemRelatedItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOpsItemRelatedItemsError {
    fn code(&self) -> Option<&str> {
        ListOpsItemRelatedItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOpsItemRelatedItemsError {
    /// Creates a new `ListOpsItemRelatedItemsError`.
    pub fn new(kind: ListOpsItemRelatedItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOpsItemRelatedItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOpsItemRelatedItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOpsItemRelatedItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOpsItemRelatedItemsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOpsItemRelatedItemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListOpsItemRelatedItemsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListOpsItemRelatedItemsErrorKind::OpsItemInvalidParameterException`.
    pub fn is_ops_item_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpsItemRelatedItemsErrorKind::OpsItemInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListOpsItemRelatedItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOpsItemRelatedItemsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListOpsItemRelatedItemsErrorKind::OpsItemInvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListOpsItemRelatedItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOpsMetadataError {
    /// Kind of error that occurred.
    pub kind: ListOpsMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOpsMetadataErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>One of the arguments passed is invalid. </p>
    OpsMetadataInvalidArgumentException(crate::error::OpsMetadataInvalidArgumentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOpsMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOpsMetadataErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => _inner.fmt(f),
            ListOpsMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOpsMetadataError {
    fn code(&self) -> Option<&str> {
        ListOpsMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOpsMetadataError {
    /// Creates a new `ListOpsMetadataError`.
    pub fn new(kind: ListOpsMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOpsMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOpsMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOpsMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOpsMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOpsMetadataErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListOpsMetadataErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ListOpsMetadataErrorKind::OpsMetadataInvalidArgumentException`.
    pub fn is_ops_metadata_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_)
        )
    }
}
impl std::error::Error for ListOpsMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOpsMetadataErrorKind::InternalServerError(_inner) => Some(_inner),
            ListOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => Some(_inner),
            ListOpsMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceComplianceSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceComplianceSummariesError {
    /// Kind of error that occurred.
    pub kind: ListResourceComplianceSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceComplianceSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceComplianceSummariesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The filter name isn't valid. Verify the you entered the correct name and try again.</p>
    InvalidFilter(crate::error::InvalidFilter),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceComplianceSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceComplianceSummariesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListResourceComplianceSummariesErrorKind::InvalidFilter(_inner) => _inner.fmt(f),
            ListResourceComplianceSummariesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListResourceComplianceSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceComplianceSummariesError {
    fn code(&self) -> Option<&str> {
        ListResourceComplianceSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceComplianceSummariesError {
    /// Creates a new `ListResourceComplianceSummariesError`.
    pub fn new(
        kind: ListResourceComplianceSummariesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceComplianceSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceComplianceSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceComplianceSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceComplianceSummariesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceComplianceSummariesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceComplianceSummariesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceComplianceSummariesErrorKind::InvalidFilter`.
    pub fn is_invalid_filter(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceComplianceSummariesErrorKind::InvalidFilter(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceComplianceSummariesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceComplianceSummariesErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for ListResourceComplianceSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceComplianceSummariesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListResourceComplianceSummariesErrorKind::InvalidFilter(_inner) => Some(_inner),
            ListResourceComplianceSummariesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListResourceComplianceSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceDataSyncError {
    /// Kind of error that occurred.
    pub kind: ListResourceDataSyncErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceDataSyncErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified token isn't valid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The specified sync configuration is invalid.</p>
    ResourceDataSyncInvalidConfigurationException(
        crate::error::ResourceDataSyncInvalidConfigurationException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceDataSyncError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceDataSyncErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListResourceDataSyncErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            ListResourceDataSyncErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceDataSyncError {
    fn code(&self) -> Option<&str> {
        ListResourceDataSyncError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceDataSyncError {
    /// Creates a new `ListResourceDataSyncError`.
    pub fn new(kind: ListResourceDataSyncErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceDataSyncError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceDataSyncErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceDataSyncError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceDataSyncErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceDataSyncErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDataSyncErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceDataSyncErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDataSyncErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException`.
    pub fn is_resource_data_sync_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(_)
        )
    }
}
impl std::error::Error for ListResourceDataSyncError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceDataSyncErrorKind::InternalServerError(_inner) => Some(_inner),
            ListResourceDataSyncErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => Some(_inner),
            ListResourceDataSyncErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the
    /// instance must be a registered managed node.</p>
    InvalidResourceType(crate::error::InvalidResourceType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidResourceType(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidResourceId(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidResourceType`.
    pub fn is_invalid_resource_type(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidResourceType(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidResourceId(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidResourceType(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDocumentPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDocumentPermissionError {
    /// Kind of error that occurred.
    pub kind: ModifyDocumentPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDocumentPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDocumentPermissionErrorKind {
    /// <p>You can have at most 500 active SSM documents.</p>
    DocumentLimitExceeded(crate::error::DocumentLimitExceeded),
    /// <p>The document can't be shared with more Amazon Web Services user accounts. You can share a document
    /// with a maximum of 20 accounts. You can publicly share up to five documents. If you need to
    /// increase this limit, contact Amazon Web Services Support.</p>
    DocumentPermissionLimit(crate::error::DocumentPermissionLimit),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The permission type isn't supported. <i>Share</i> is the only supported
    /// permission type.</p>
    InvalidPermissionType(crate::error::InvalidPermissionType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDocumentPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDocumentPermissionErrorKind::DocumentLimitExceeded(_inner) => _inner.fmt(f),
            ModifyDocumentPermissionErrorKind::DocumentPermissionLimit(_inner) => _inner.fmt(f),
            ModifyDocumentPermissionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ModifyDocumentPermissionErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            ModifyDocumentPermissionErrorKind::InvalidPermissionType(_inner) => _inner.fmt(f),
            ModifyDocumentPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDocumentPermissionError {
    fn code(&self) -> Option<&str> {
        ModifyDocumentPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDocumentPermissionError {
    /// Creates a new `ModifyDocumentPermissionError`.
    pub fn new(kind: ModifyDocumentPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDocumentPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDocumentPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDocumentPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDocumentPermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDocumentPermissionErrorKind::DocumentLimitExceeded`.
    pub fn is_document_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDocumentPermissionErrorKind::DocumentLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDocumentPermissionErrorKind::DocumentPermissionLimit`.
    pub fn is_document_permission_limit(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDocumentPermissionErrorKind::DocumentPermissionLimit(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDocumentPermissionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDocumentPermissionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDocumentPermissionErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDocumentPermissionErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDocumentPermissionErrorKind::InvalidPermissionType`.
    pub fn is_invalid_permission_type(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDocumentPermissionErrorKind::InvalidPermissionType(_)
        )
    }
}
impl std::error::Error for ModifyDocumentPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDocumentPermissionErrorKind::DocumentLimitExceeded(_inner) => Some(_inner),
            ModifyDocumentPermissionErrorKind::DocumentPermissionLimit(_inner) => Some(_inner),
            ModifyDocumentPermissionErrorKind::InternalServerError(_inner) => Some(_inner),
            ModifyDocumentPermissionErrorKind::InvalidDocument(_inner) => Some(_inner),
            ModifyDocumentPermissionErrorKind::InvalidPermissionType(_inner) => Some(_inner),
            ModifyDocumentPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutComplianceItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutComplianceItemsError {
    /// Kind of error that occurred.
    pub kind: PutComplianceItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutComplianceItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutComplianceItemsErrorKind {
    /// <p>You specified too many custom compliance types. You can specify a maximum of 10 different
    /// types. </p>
    ComplianceTypeCountLimitExceededException(
        crate::error::ComplianceTypeCountLimitExceededException,
    ),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>One or more content items isn't valid.</p>
    InvalidItemContentException(crate::error::InvalidItemContentException),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the
    /// instance must be a registered managed node.</p>
    InvalidResourceType(crate::error::InvalidResourceType),
    /// <p>The inventory item size has exceeded the size limit.</p>
    ItemSizeLimitExceededException(crate::error::ItemSizeLimitExceededException),
    /// <p>The size of inventory data has exceeded the total size limit for the resource.</p>
    TotalSizeLimitExceededException(crate::error::TotalSizeLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutComplianceItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutComplianceItemsErrorKind::ComplianceTypeCountLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutComplianceItemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutComplianceItemsErrorKind::InvalidItemContentException(_inner) => _inner.fmt(f),
            PutComplianceItemsErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            PutComplianceItemsErrorKind::InvalidResourceType(_inner) => _inner.fmt(f),
            PutComplianceItemsErrorKind::ItemSizeLimitExceededException(_inner) => _inner.fmt(f),
            PutComplianceItemsErrorKind::TotalSizeLimitExceededException(_inner) => _inner.fmt(f),
            PutComplianceItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutComplianceItemsError {
    fn code(&self) -> Option<&str> {
        PutComplianceItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutComplianceItemsError {
    /// Creates a new `PutComplianceItemsError`.
    pub fn new(kind: PutComplianceItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutComplianceItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutComplianceItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutComplianceItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutComplianceItemsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutComplianceItemsErrorKind::ComplianceTypeCountLimitExceededException`.
    pub fn is_compliance_type_count_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutComplianceItemsErrorKind::ComplianceTypeCountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutComplianceItemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutComplianceItemsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `PutComplianceItemsErrorKind::InvalidItemContentException`.
    pub fn is_invalid_item_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutComplianceItemsErrorKind::InvalidItemContentException(_)
        )
    }
    /// Returns `true` if the error kind is `PutComplianceItemsErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            PutComplianceItemsErrorKind::InvalidResourceId(_)
        )
    }
    /// Returns `true` if the error kind is `PutComplianceItemsErrorKind::InvalidResourceType`.
    pub fn is_invalid_resource_type(&self) -> bool {
        matches!(
            &self.kind,
            PutComplianceItemsErrorKind::InvalidResourceType(_)
        )
    }
    /// Returns `true` if the error kind is `PutComplianceItemsErrorKind::ItemSizeLimitExceededException`.
    pub fn is_item_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutComplianceItemsErrorKind::ItemSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutComplianceItemsErrorKind::TotalSizeLimitExceededException`.
    pub fn is_total_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutComplianceItemsErrorKind::TotalSizeLimitExceededException(_)
        )
    }
}
impl std::error::Error for PutComplianceItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutComplianceItemsErrorKind::ComplianceTypeCountLimitExceededException(_inner) => {
                Some(_inner)
            }
            PutComplianceItemsErrorKind::InternalServerError(_inner) => Some(_inner),
            PutComplianceItemsErrorKind::InvalidItemContentException(_inner) => Some(_inner),
            PutComplianceItemsErrorKind::InvalidResourceId(_inner) => Some(_inner),
            PutComplianceItemsErrorKind::InvalidResourceType(_inner) => Some(_inner),
            PutComplianceItemsErrorKind::ItemSizeLimitExceededException(_inner) => Some(_inner),
            PutComplianceItemsErrorKind::TotalSizeLimitExceededException(_inner) => Some(_inner),
            PutComplianceItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutInventoryError {
    /// Kind of error that occurred.
    pub kind: PutInventoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutInventoryErrorKind {
    /// <p>You have exceeded the limit for custom schemas. Delete one or more custom schemas and try
    /// again.</p>
    CustomSchemaCountLimitExceededException(crate::error::CustomSchemaCountLimitExceededException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>You specified invalid keys or values in the <code>Context</code> attribute for
    /// <code>InventoryItem</code>. Verify the keys and values, and try again.</p>
    InvalidInventoryItemContextException(crate::error::InvalidInventoryItemContextException),
    /// <p>One or more content items isn't valid.</p>
    InvalidItemContentException(crate::error::InvalidItemContentException),
    /// <p>The parameter type name isn't valid.</p>
    InvalidTypeNameException(crate::error::InvalidTypeNameException),
    /// <p>The inventory item has invalid content. </p>
    ItemContentMismatchException(crate::error::ItemContentMismatchException),
    /// <p>The inventory item size has exceeded the size limit.</p>
    ItemSizeLimitExceededException(crate::error::ItemSizeLimitExceededException),
    /// <p>The sub-type count exceeded the limit for the inventory type.</p>
    SubTypeCountLimitExceededException(crate::error::SubTypeCountLimitExceededException),
    /// <p>The size of inventory data has exceeded the total size limit for the resource.</p>
    TotalSizeLimitExceededException(crate::error::TotalSizeLimitExceededException),
    /// <p>The <code>Context</code> attribute that you specified for the <code>InventoryItem</code>
    /// isn't allowed for this inventory type. You can only use the <code>Context</code> attribute with
    /// inventory types like <code>AWS:ComplianceItem</code>.</p>
    UnsupportedInventoryItemContextException(
        crate::error::UnsupportedInventoryItemContextException,
    ),
    /// <p>Inventory item type schema version has to match supported versions in the service. Check
    /// output of GetInventorySchema to see the available schema version for each type.</p>
    UnsupportedInventorySchemaVersionException(
        crate::error::UnsupportedInventorySchemaVersionException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutInventoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutInventoryErrorKind::CustomSchemaCountLimitExceededException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::InvalidInventoryItemContextException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::InvalidItemContentException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::InvalidTypeNameException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::ItemContentMismatchException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::ItemSizeLimitExceededException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::SubTypeCountLimitExceededException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::TotalSizeLimitExceededException(_inner) => _inner.fmt(f),
            PutInventoryErrorKind::UnsupportedInventoryItemContextException(_inner) => {
                _inner.fmt(f)
            }
            PutInventoryErrorKind::UnsupportedInventorySchemaVersionException(_inner) => {
                _inner.fmt(f)
            }
            PutInventoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutInventoryError {
    fn code(&self) -> Option<&str> {
        PutInventoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutInventoryError {
    /// Creates a new `PutInventoryError`.
    pub fn new(kind: PutInventoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutInventoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutInventoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutInventoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutInventoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::CustomSchemaCountLimitExceededException`.
    pub fn is_custom_schema_count_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::CustomSchemaCountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, PutInventoryErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(&self.kind, PutInventoryErrorKind::InvalidInstanceId(_))
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::InvalidInventoryItemContextException`.
    pub fn is_invalid_inventory_item_context_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::InvalidInventoryItemContextException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::InvalidItemContentException`.
    pub fn is_invalid_item_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::InvalidItemContentException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::InvalidTypeNameException`.
    pub fn is_invalid_type_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::InvalidTypeNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::ItemContentMismatchException`.
    pub fn is_item_content_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::ItemContentMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::ItemSizeLimitExceededException`.
    pub fn is_item_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::ItemSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::SubTypeCountLimitExceededException`.
    pub fn is_sub_type_count_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::SubTypeCountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::TotalSizeLimitExceededException`.
    pub fn is_total_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::TotalSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::UnsupportedInventoryItemContextException`.
    pub fn is_unsupported_inventory_item_context_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::UnsupportedInventoryItemContextException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInventoryErrorKind::UnsupportedInventorySchemaVersionException`.
    pub fn is_unsupported_inventory_schema_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInventoryErrorKind::UnsupportedInventorySchemaVersionException(_)
        )
    }
}
impl std::error::Error for PutInventoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutInventoryErrorKind::CustomSchemaCountLimitExceededException(_inner) => Some(_inner),
            PutInventoryErrorKind::InternalServerError(_inner) => Some(_inner),
            PutInventoryErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            PutInventoryErrorKind::InvalidInventoryItemContextException(_inner) => Some(_inner),
            PutInventoryErrorKind::InvalidItemContentException(_inner) => Some(_inner),
            PutInventoryErrorKind::InvalidTypeNameException(_inner) => Some(_inner),
            PutInventoryErrorKind::ItemContentMismatchException(_inner) => Some(_inner),
            PutInventoryErrorKind::ItemSizeLimitExceededException(_inner) => Some(_inner),
            PutInventoryErrorKind::SubTypeCountLimitExceededException(_inner) => Some(_inner),
            PutInventoryErrorKind::TotalSizeLimitExceededException(_inner) => Some(_inner),
            PutInventoryErrorKind::UnsupportedInventoryItemContextException(_inner) => Some(_inner),
            PutInventoryErrorKind::UnsupportedInventorySchemaVersionException(_inner) => {
                Some(_inner)
            }
            PutInventoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutParameterError {
    /// Kind of error that occurred.
    pub kind: PutParameterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutParameter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutParameterErrorKind {
    /// <p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and
    /// constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    HierarchyLevelLimitExceededException(crate::error::HierarchyLevelLimitExceededException),
    /// <p>Parameter Store doesn't support changing a parameter type in a hierarchy. For example, you
    /// can't change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You
    /// must create a new, unique parameter.</p>
    HierarchyTypeMismatchException(crate::error::HierarchyTypeMismatchException),
    /// <p>There is a conflict in the policies specified for this parameter. You can't, for example,
    /// specify two Expiration policies for a parameter. Review your policies, and try again.</p>
    IncompatiblePolicyException(crate::error::IncompatiblePolicyException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The request doesn't meet the regular expression requirement.</p>
    InvalidAllowedPatternException(crate::error::InvalidAllowedPatternException),
    /// <p>The query key ID isn't valid.</p>
    InvalidKeyId(crate::error::InvalidKeyId),
    /// <p>A policy attribute or its value is invalid. </p>
    InvalidPolicyAttributeException(crate::error::InvalidPolicyAttributeException),
    /// <p>The policy type isn't supported. Parameter Store supports the following policy types:
    /// Expiration, ExpirationNotification, and NoChangeNotification.</p>
    InvalidPolicyTypeException(crate::error::InvalidPolicyTypeException),
    /// <p>The parameter already exists. You can't create duplicate parameters.</p>
    ParameterAlreadyExists(crate::error::ParameterAlreadyExists),
    /// <p>You have exceeded the number of parameters for this Amazon Web Services account. Delete one or more
    /// parameters and try again.</p>
    ParameterLimitExceeded(crate::error::ParameterLimitExceeded),
    /// <p>Parameter Store retains the 100 most recently created versions of a parameter. After this
    /// number of versions has been created, Parameter Store deletes the oldest version when a new one is
    /// created. However, if the oldest version has a <i>label</i> attached to it,
    /// Parameter Store won't delete the version and instead presents this error message:</p>
    /// <p>
    /// <code>An error occurred (ParameterMaxVersionLimitExceeded) when calling the PutParameter
    /// operation: You attempted to create a new version of <i>parameter-name</i> by
    /// calling the PutParameter API with the overwrite flag. Version
    /// <i>version-number</i>, the oldest version, can't be deleted because it has a
    /// label associated with it. Move the label to another version of the parameter, and try
    /// again.</code>
    /// </p>
    /// <p>This safeguard is to prevent parameter versions with mission critical labels assigned to
    /// them from being deleted. To continue creating new parameters, first move the label from the
    /// oldest version of the parameter to a newer one for use in your operations. For information about
    /// moving parameter labels, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move">Move a parameter label (console)</a> or <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move">Move a parameter label (CLI)</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    ParameterMaxVersionLimitExceeded(crate::error::ParameterMaxVersionLimitExceeded),
    /// <p>The parameter name isn't valid.</p>
    ParameterPatternMismatchException(crate::error::ParameterPatternMismatchException),
    /// <p>You specified more than the maximum number of allowed policies for the parameter. The
    /// maximum is 10.</p>
    PoliciesLimitExceededException(crate::error::PoliciesLimitExceededException),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// <p>The parameter type isn't supported.</p>
    UnsupportedParameterType(crate::error::UnsupportedParameterType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutParameterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutParameterErrorKind::HierarchyLevelLimitExceededException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::HierarchyTypeMismatchException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::IncompatiblePolicyException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutParameterErrorKind::InvalidAllowedPatternException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::InvalidKeyId(_inner) => _inner.fmt(f),
            PutParameterErrorKind::InvalidPolicyAttributeException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::InvalidPolicyTypeException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::ParameterAlreadyExists(_inner) => _inner.fmt(f),
            PutParameterErrorKind::ParameterLimitExceeded(_inner) => _inner.fmt(f),
            PutParameterErrorKind::ParameterMaxVersionLimitExceeded(_inner) => _inner.fmt(f),
            PutParameterErrorKind::ParameterPatternMismatchException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::PoliciesLimitExceededException(_inner) => _inner.fmt(f),
            PutParameterErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            PutParameterErrorKind::UnsupportedParameterType(_inner) => _inner.fmt(f),
            PutParameterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutParameterError {
    fn code(&self) -> Option<&str> {
        PutParameterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutParameterError {
    /// Creates a new `PutParameterError`.
    pub fn new(kind: PutParameterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutParameterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutParameterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutParameterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutParameterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::HierarchyLevelLimitExceededException`.
    pub fn is_hierarchy_level_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::HierarchyLevelLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::HierarchyTypeMismatchException`.
    pub fn is_hierarchy_type_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::HierarchyTypeMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::IncompatiblePolicyException`.
    pub fn is_incompatible_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::IncompatiblePolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, PutParameterErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::InvalidAllowedPatternException`.
    pub fn is_invalid_allowed_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::InvalidAllowedPatternException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::InvalidKeyId`.
    pub fn is_invalid_key_id(&self) -> bool {
        matches!(&self.kind, PutParameterErrorKind::InvalidKeyId(_))
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::InvalidPolicyAttributeException`.
    pub fn is_invalid_policy_attribute_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::InvalidPolicyAttributeException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::InvalidPolicyTypeException`.
    pub fn is_invalid_policy_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::InvalidPolicyTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::ParameterAlreadyExists`.
    pub fn is_parameter_already_exists(&self) -> bool {
        matches!(&self.kind, PutParameterErrorKind::ParameterAlreadyExists(_))
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::ParameterLimitExceeded`.
    pub fn is_parameter_limit_exceeded(&self) -> bool {
        matches!(&self.kind, PutParameterErrorKind::ParameterLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::ParameterMaxVersionLimitExceeded`.
    pub fn is_parameter_max_version_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::ParameterMaxVersionLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::ParameterPatternMismatchException`.
    pub fn is_parameter_pattern_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::ParameterPatternMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::PoliciesLimitExceededException`.
    pub fn is_policies_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::PoliciesLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(&self.kind, PutParameterErrorKind::TooManyUpdates(_))
    }
    /// Returns `true` if the error kind is `PutParameterErrorKind::UnsupportedParameterType`.
    pub fn is_unsupported_parameter_type(&self) -> bool {
        matches!(
            &self.kind,
            PutParameterErrorKind::UnsupportedParameterType(_)
        )
    }
}
impl std::error::Error for PutParameterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutParameterErrorKind::HierarchyLevelLimitExceededException(_inner) => Some(_inner),
            PutParameterErrorKind::HierarchyTypeMismatchException(_inner) => Some(_inner),
            PutParameterErrorKind::IncompatiblePolicyException(_inner) => Some(_inner),
            PutParameterErrorKind::InternalServerError(_inner) => Some(_inner),
            PutParameterErrorKind::InvalidAllowedPatternException(_inner) => Some(_inner),
            PutParameterErrorKind::InvalidKeyId(_inner) => Some(_inner),
            PutParameterErrorKind::InvalidPolicyAttributeException(_inner) => Some(_inner),
            PutParameterErrorKind::InvalidPolicyTypeException(_inner) => Some(_inner),
            PutParameterErrorKind::ParameterAlreadyExists(_inner) => Some(_inner),
            PutParameterErrorKind::ParameterLimitExceeded(_inner) => Some(_inner),
            PutParameterErrorKind::ParameterMaxVersionLimitExceeded(_inner) => Some(_inner),
            PutParameterErrorKind::ParameterPatternMismatchException(_inner) => Some(_inner),
            PutParameterErrorKind::PoliciesLimitExceededException(_inner) => Some(_inner),
            PutParameterErrorKind::TooManyUpdates(_inner) => Some(_inner),
            PutParameterErrorKind::UnsupportedParameterType(_inner) => Some(_inner),
            PutParameterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterDefaultPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterDefaultPatchBaselineError {
    /// Kind of error that occurred.
    pub kind: RegisterDefaultPatchBaselineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterDefaultPatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterDefaultPatchBaselineErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterDefaultPatchBaselineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterDefaultPatchBaselineErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            RegisterDefaultPatchBaselineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RegisterDefaultPatchBaselineErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            RegisterDefaultPatchBaselineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterDefaultPatchBaselineError {
    fn code(&self) -> Option<&str> {
        RegisterDefaultPatchBaselineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterDefaultPatchBaselineError {
    /// Creates a new `RegisterDefaultPatchBaselineError`.
    pub fn new(kind: RegisterDefaultPatchBaselineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterDefaultPatchBaselineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterDefaultPatchBaselineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterDefaultPatchBaselineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterDefaultPatchBaselineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterDefaultPatchBaselineErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDefaultPatchBaselineErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDefaultPatchBaselineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDefaultPatchBaselineErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDefaultPatchBaselineErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDefaultPatchBaselineErrorKind::InvalidResourceId(_)
        )
    }
}
impl std::error::Error for RegisterDefaultPatchBaselineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterDefaultPatchBaselineErrorKind::DoesNotExistException(_inner) => Some(_inner),
            RegisterDefaultPatchBaselineErrorKind::InternalServerError(_inner) => Some(_inner),
            RegisterDefaultPatchBaselineErrorKind::InvalidResourceId(_inner) => Some(_inner),
            RegisterDefaultPatchBaselineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterPatchBaselineForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterPatchBaselineForPatchGroupError {
    /// Kind of error that occurred.
    pub kind: RegisterPatchBaselineForPatchGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterPatchBaselineForPatchGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterPatchBaselineForPatchGroupErrorKind {
    /// <p>Error returned if an attempt is made to register a patch group with a patch baseline that is
    /// already registered with a different patch baseline.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>Error returned when the caller has exceeded the default resource quotas. For example, too
    /// many maintenance windows or patch baselines have been created.</p>
    /// <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterPatchBaselineForPatchGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterPatchBaselineForPatchGroupErrorKind::AlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            RegisterPatchBaselineForPatchGroupErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterPatchBaselineForPatchGroupError {
    fn code(&self) -> Option<&str> {
        RegisterPatchBaselineForPatchGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterPatchBaselineForPatchGroupError {
    /// Creates a new `RegisterPatchBaselineForPatchGroupError`.
    pub fn new(
        kind: RegisterPatchBaselineForPatchGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterPatchBaselineForPatchGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterPatchBaselineForPatchGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterPatchBaselineForPatchGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterPatchBaselineForPatchGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterPatchBaselineForPatchGroupErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPatchBaselineForPatchGroupErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterPatchBaselineForPatchGroupErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPatchBaselineForPatchGroupErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterPatchBaselineForPatchGroupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPatchBaselineForPatchGroupErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterPatchBaselineForPatchGroupErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterPatchBaselineForPatchGroupErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for RegisterPatchBaselineForPatchGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterPatchBaselineForPatchGroupErrorKind::AlreadyExistsException(_inner) => {
                Some(_inner)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::InvalidResourceId(_inner) => Some(_inner),
            RegisterPatchBaselineForPatchGroupErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            RegisterPatchBaselineForPatchGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterTargetWithMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterTargetWithMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: RegisterTargetWithMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterTargetWithMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterTargetWithMaintenanceWindowErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>Error returned when an idempotent operation is retried and the parameters don't match the
    /// original call to the API with the same idempotency token. </p>
    IdempotentParameterMismatch(crate::error::IdempotentParameterMismatch),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Error returned when the caller has exceeded the default resource quotas. For example, too
    /// many maintenance windows or patch baselines have been created.</p>
    /// <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterTargetWithMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterTargetWithMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            RegisterTargetWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(_inner) => {
                _inner.fmt(f)
            }
            RegisterTargetWithMaintenanceWindowErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            RegisterTargetWithMaintenanceWindowErrorKind::ResourceLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            RegisterTargetWithMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterTargetWithMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        RegisterTargetWithMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterTargetWithMaintenanceWindowError {
    /// Creates a new `RegisterTargetWithMaintenanceWindowError`.
    pub fn new(
        kind: RegisterTargetWithMaintenanceWindowErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterTargetWithMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterTargetWithMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterTargetWithMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterTargetWithMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterTargetWithMaintenanceWindowErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetWithMaintenanceWindowErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTargetWithMaintenanceWindowErrorKind::IdempotentParameterMismatch`.
    pub fn is_idempotent_parameter_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTargetWithMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetWithMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTargetWithMaintenanceWindowErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTargetWithMaintenanceWindowErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for RegisterTargetWithMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterTargetWithMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            RegisterTargetWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(_inner) => {
                Some(_inner)
            }
            RegisterTargetWithMaintenanceWindowErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            RegisterTargetWithMaintenanceWindowErrorKind::ResourceLimitExceededException(
                _inner,
            ) => Some(_inner),
            RegisterTargetWithMaintenanceWindowErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RegisterTaskWithMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterTaskWithMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: RegisterTaskWithMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterTaskWithMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterTaskWithMaintenanceWindowErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>You attempted to register a <code>LAMBDA</code> or <code>STEP_FUNCTIONS</code> task in a
    /// region where the corresponding service isn't available. </p>
    FeatureNotAvailableException(crate::error::FeatureNotAvailableException),
    /// <p>Error returned when an idempotent operation is retried and the parameters don't match the
    /// original call to the API with the same idempotency token. </p>
    IdempotentParameterMismatch(crate::error::IdempotentParameterMismatch),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Error returned when the caller has exceeded the default resource quotas. For example, too
    /// many maintenance windows or patch baselines have been created.</p>
    /// <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterTaskWithMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterTaskWithMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::FeatureNotAvailableException(_inner) => {
                _inner.fmt(f)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(_inner) => {
                _inner.fmt(f)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterTaskWithMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        RegisterTaskWithMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterTaskWithMaintenanceWindowError {
    /// Creates a new `RegisterTaskWithMaintenanceWindowError`.
    pub fn new(
        kind: RegisterTaskWithMaintenanceWindowErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterTaskWithMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterTaskWithMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterTaskWithMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterTaskWithMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterTaskWithMaintenanceWindowErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskWithMaintenanceWindowErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTaskWithMaintenanceWindowErrorKind::FeatureNotAvailableException`.
    pub fn is_feature_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskWithMaintenanceWindowErrorKind::FeatureNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTaskWithMaintenanceWindowErrorKind::IdempotentParameterMismatch`.
    pub fn is_idempotent_parameter_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTaskWithMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskWithMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTaskWithMaintenanceWindowErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskWithMaintenanceWindowErrorKind::ResourceLimitExceededException(_)
        )
    }
}
impl std::error::Error for RegisterTaskWithMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterTaskWithMaintenanceWindowErrorKind::DoesNotExistException(_inner) => {
                Some(_inner)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::FeatureNotAvailableException(_inner) => {
                Some(_inner)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::IdempotentParameterMismatch(_inner) => {
                Some(_inner)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::InternalServerError(_inner) => Some(_inner),
            RegisterTaskWithMaintenanceWindowErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            RegisterTaskWithMaintenanceWindowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromResourceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
    InvalidResourceId(crate::error::InvalidResourceId),
    /// <p>The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the
    /// instance must be a registered managed node.</p>
    InvalidResourceType(crate::error::InvalidResourceType),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::InvalidResourceId(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::InvalidResourceType(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromResourceError {
    /// Creates a new `RemoveTagsFromResourceError`.
    pub fn new(kind: RemoveTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::InvalidResourceId`.
    pub fn is_invalid_resource_id(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::InvalidResourceId(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::InvalidResourceType`.
    pub fn is_invalid_resource_type(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::InvalidResourceType(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::TooManyUpdates(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::InvalidResourceId(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::InvalidResourceType(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::TooManyUpdates(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetServiceSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetServiceSettingError {
    /// Kind of error that occurred.
    pub kind: ResetServiceSettingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetServiceSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetServiceSettingErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified service setting wasn't found. Either the service name or the setting hasn't
    /// been provisioned by the Amazon Web Services service team.</p>
    ServiceSettingNotFound(crate::error::ServiceSettingNotFound),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetServiceSettingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetServiceSettingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ResetServiceSettingErrorKind::ServiceSettingNotFound(_inner) => _inner.fmt(f),
            ResetServiceSettingErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            ResetServiceSettingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetServiceSettingError {
    fn code(&self) -> Option<&str> {
        ResetServiceSettingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetServiceSettingError {
    /// Creates a new `ResetServiceSettingError`.
    pub fn new(kind: ResetServiceSettingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetServiceSettingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetServiceSettingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetServiceSettingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetServiceSettingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetServiceSettingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ResetServiceSettingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ResetServiceSettingErrorKind::ServiceSettingNotFound`.
    pub fn is_service_setting_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ResetServiceSettingErrorKind::ServiceSettingNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `ResetServiceSettingErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(&self.kind, ResetServiceSettingErrorKind::TooManyUpdates(_))
    }
}
impl std::error::Error for ResetServiceSettingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetServiceSettingErrorKind::InternalServerError(_inner) => Some(_inner),
            ResetServiceSettingErrorKind::ServiceSettingNotFound(_inner) => Some(_inner),
            ResetServiceSettingErrorKind::TooManyUpdates(_inner) => Some(_inner),
            ResetServiceSettingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResumeSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResumeSessionError {
    /// Kind of error that occurred.
    pub kind: ResumeSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResumeSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResumeSessionErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResumeSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResumeSessionErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            ResumeSessionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ResumeSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResumeSessionError {
    fn code(&self) -> Option<&str> {
        ResumeSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResumeSessionError {
    /// Creates a new `ResumeSessionError`.
    pub fn new(kind: ResumeSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResumeSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResumeSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResumeSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResumeSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResumeSessionErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, ResumeSessionErrorKind::DoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `ResumeSessionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ResumeSessionErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for ResumeSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResumeSessionErrorKind::DoesNotExistException(_inner) => Some(_inner),
            ResumeSessionErrorKind::InternalServerError(_inner) => Some(_inner),
            ResumeSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendAutomationSignal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendAutomationSignalError {
    /// Kind of error that occurred.
    pub kind: SendAutomationSignalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendAutomationSignal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendAutomationSignalErrorKind {
    /// <p>There is no automation execution information for the requested automation execution
    /// ID.</p>
    AutomationExecutionNotFoundException(crate::error::AutomationExecutionNotFoundException),
    /// <p>The specified step name and execution ID don't exist. Verify the information and try
    /// again.</p>
    AutomationStepNotFoundException(crate::error::AutomationStepNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The signal isn't valid for the current Automation execution.</p>
    InvalidAutomationSignalException(crate::error::InvalidAutomationSignalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendAutomationSignalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendAutomationSignalErrorKind::AutomationExecutionNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            SendAutomationSignalErrorKind::AutomationStepNotFoundException(_inner) => _inner.fmt(f),
            SendAutomationSignalErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            SendAutomationSignalErrorKind::InvalidAutomationSignalException(_inner) => {
                _inner.fmt(f)
            }
            SendAutomationSignalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendAutomationSignalError {
    fn code(&self) -> Option<&str> {
        SendAutomationSignalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendAutomationSignalError {
    /// Creates a new `SendAutomationSignalError`.
    pub fn new(kind: SendAutomationSignalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendAutomationSignalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendAutomationSignalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendAutomationSignalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendAutomationSignalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendAutomationSignalErrorKind::AutomationExecutionNotFoundException`.
    pub fn is_automation_execution_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendAutomationSignalErrorKind::AutomationExecutionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendAutomationSignalErrorKind::AutomationStepNotFoundException`.
    pub fn is_automation_step_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendAutomationSignalErrorKind::AutomationStepNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendAutomationSignalErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            SendAutomationSignalErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `SendAutomationSignalErrorKind::InvalidAutomationSignalException`.
    pub fn is_invalid_automation_signal_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendAutomationSignalErrorKind::InvalidAutomationSignalException(_)
        )
    }
}
impl std::error::Error for SendAutomationSignalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendAutomationSignalErrorKind::AutomationExecutionNotFoundException(_inner) => {
                Some(_inner)
            }
            SendAutomationSignalErrorKind::AutomationStepNotFoundException(_inner) => Some(_inner),
            SendAutomationSignalErrorKind::InternalServerError(_inner) => Some(_inner),
            SendAutomationSignalErrorKind::InvalidAutomationSignalException(_inner) => Some(_inner),
            SendAutomationSignalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendCommand` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendCommandError {
    /// Kind of error that occurred.
    pub kind: SendCommandErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendCommand` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendCommandErrorKind {
    /// <p>You can't specify a managed node ID in more than one association.</p>
    DuplicateInstanceId(crate::error::DuplicateInstanceId),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>One or more configuration items isn't valid. Verify that a valid Amazon Resource Name (ARN)
    /// was provided for an Amazon Simple Notification Service topic.</p>
    InvalidNotificationConfig(crate::error::InvalidNotificationConfig),
    /// <p>The S3 bucket doesn't exist.</p>
    InvalidOutputFolder(crate::error::InvalidOutputFolder),
    /// <p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM
    /// document). You can only supply values to parameters defined in the SSM document.</p>
    InvalidParameters(crate::error::InvalidParameters),
    /// <p>The role name can't contain invalid characters. Also verify that you specified an IAM role for notifications that includes the required trust policy. For information about
    /// configuring the IAM role for Run Command notifications, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring Amazon SNS Notifications for Run Command</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    InvalidRole(crate::error::InvalidRole),
    /// <p>The size limit of a document is 64 KB.</p>
    MaxDocumentSizeExceeded(crate::error::MaxDocumentSizeExceeded),
    /// <p>The document doesn't support the platform type of the given managed node ID(s). For example, you
    /// sent an document for a Windows managed node to a Linux node.</p>
    UnsupportedPlatformType(crate::error::UnsupportedPlatformType),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendCommandError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendCommandErrorKind::DuplicateInstanceId(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InvalidNotificationConfig(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InvalidOutputFolder(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InvalidParameters(_inner) => _inner.fmt(f),
            SendCommandErrorKind::InvalidRole(_inner) => _inner.fmt(f),
            SendCommandErrorKind::MaxDocumentSizeExceeded(_inner) => _inner.fmt(f),
            SendCommandErrorKind::UnsupportedPlatformType(_inner) => _inner.fmt(f),
            SendCommandErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendCommandError {
    fn code(&self) -> Option<&str> {
        SendCommandError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendCommandError {
    /// Creates a new `SendCommandError`.
    pub fn new(kind: SendCommandErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendCommandError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendCommandErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendCommandError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendCommandErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::DuplicateInstanceId`.
    pub fn is_duplicate_instance_id(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::DuplicateInstanceId(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::InvalidDocumentVersion(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::InvalidInstanceId(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InvalidNotificationConfig`.
    pub fn is_invalid_notification_config(&self) -> bool {
        matches!(
            &self.kind,
            SendCommandErrorKind::InvalidNotificationConfig(_)
        )
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InvalidOutputFolder`.
    pub fn is_invalid_output_folder(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::InvalidOutputFolder(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InvalidParameters`.
    pub fn is_invalid_parameters(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::InvalidParameters(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::InvalidRole`.
    pub fn is_invalid_role(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::InvalidRole(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::MaxDocumentSizeExceeded`.
    pub fn is_max_document_size_exceeded(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::MaxDocumentSizeExceeded(_))
    }
    /// Returns `true` if the error kind is `SendCommandErrorKind::UnsupportedPlatformType`.
    pub fn is_unsupported_platform_type(&self) -> bool {
        matches!(&self.kind, SendCommandErrorKind::UnsupportedPlatformType(_))
    }
}
impl std::error::Error for SendCommandError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendCommandErrorKind::DuplicateInstanceId(_inner) => Some(_inner),
            SendCommandErrorKind::InternalServerError(_inner) => Some(_inner),
            SendCommandErrorKind::InvalidDocument(_inner) => Some(_inner),
            SendCommandErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            SendCommandErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            SendCommandErrorKind::InvalidNotificationConfig(_inner) => Some(_inner),
            SendCommandErrorKind::InvalidOutputFolder(_inner) => Some(_inner),
            SendCommandErrorKind::InvalidParameters(_inner) => Some(_inner),
            SendCommandErrorKind::InvalidRole(_inner) => Some(_inner),
            SendCommandErrorKind::MaxDocumentSizeExceeded(_inner) => Some(_inner),
            SendCommandErrorKind::UnsupportedPlatformType(_inner) => Some(_inner),
            SendCommandErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAssociationsOnce` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAssociationsOnceError {
    /// Kind of error that occurred.
    pub kind: StartAssociationsOnceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAssociationsOnce` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAssociationsOnceErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>The association isn't valid or doesn't exist. </p>
    InvalidAssociation(crate::error::InvalidAssociation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAssociationsOnceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAssociationsOnceErrorKind::AssociationDoesNotExist(_inner) => _inner.fmt(f),
            StartAssociationsOnceErrorKind::InvalidAssociation(_inner) => _inner.fmt(f),
            StartAssociationsOnceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAssociationsOnceError {
    fn code(&self) -> Option<&str> {
        StartAssociationsOnceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAssociationsOnceError {
    /// Creates a new `StartAssociationsOnceError`.
    pub fn new(kind: StartAssociationsOnceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAssociationsOnceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAssociationsOnceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAssociationsOnceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAssociationsOnceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartAssociationsOnceErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            StartAssociationsOnceErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssociationsOnceErrorKind::InvalidAssociation`.
    pub fn is_invalid_association(&self) -> bool {
        matches!(
            &self.kind,
            StartAssociationsOnceErrorKind::InvalidAssociation(_)
        )
    }
}
impl std::error::Error for StartAssociationsOnceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAssociationsOnceErrorKind::AssociationDoesNotExist(_inner) => Some(_inner),
            StartAssociationsOnceErrorKind::InvalidAssociation(_inner) => Some(_inner),
            StartAssociationsOnceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAutomationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAutomationExecutionError {
    /// Kind of error that occurred.
    pub kind: StartAutomationExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAutomationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAutomationExecutionErrorKind {
    /// <p>An Automation runbook with the specified name couldn't be found.</p>
    AutomationDefinitionNotFoundException(crate::error::AutomationDefinitionNotFoundException),
    /// <p>An Automation runbook with the specified name and version couldn't be found.</p>
    AutomationDefinitionVersionNotFoundException(
        crate::error::AutomationDefinitionVersionNotFoundException,
    ),
    /// <p>The number of simultaneously running Automation executions exceeded the allowable
    /// limit.</p>
    AutomationExecutionLimitExceededException(
        crate::error::AutomationExecutionLimitExceededException,
    ),
    /// <p>Error returned when an idempotent operation is retried and the parameters don't match the
    /// original call to the API with the same idempotency token. </p>
    IdempotentParameterMismatch(crate::error::IdempotentParameterMismatch),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The supplied parameters for invoking the specified Automation runbook are incorrect. For
    /// example, they may not match the set of parameters permitted for the specified Automation
    /// document.</p>
    InvalidAutomationExecutionParametersException(
        crate::error::InvalidAutomationExecutionParametersException,
    ),
    /// <p>The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might
    /// not have permission to perform the operation.</p>
    InvalidTarget(crate::error::InvalidTarget),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAutomationExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAutomationExecutionErrorKind::AutomationDefinitionNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartAutomationExecutionErrorKind::AutomationDefinitionVersionNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            StartAutomationExecutionErrorKind::AutomationExecutionLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            StartAutomationExecutionErrorKind::IdempotentParameterMismatch(_inner) => _inner.fmt(f),
            StartAutomationExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartAutomationExecutionErrorKind::InvalidAutomationExecutionParametersException(
                _inner,
            ) => _inner.fmt(f),
            StartAutomationExecutionErrorKind::InvalidTarget(_inner) => _inner.fmt(f),
            StartAutomationExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAutomationExecutionError {
    fn code(&self) -> Option<&str> {
        StartAutomationExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAutomationExecutionError {
    /// Creates a new `StartAutomationExecutionError`.
    pub fn new(kind: StartAutomationExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAutomationExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAutomationExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAutomationExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAutomationExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartAutomationExecutionErrorKind::AutomationDefinitionNotFoundException`.
    pub fn is_automation_definition_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAutomationExecutionErrorKind::AutomationDefinitionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAutomationExecutionErrorKind::AutomationDefinitionVersionNotFoundException`.
    pub fn is_automation_definition_version_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAutomationExecutionErrorKind::AutomationDefinitionVersionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAutomationExecutionErrorKind::AutomationExecutionLimitExceededException`.
    pub fn is_automation_execution_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAutomationExecutionErrorKind::AutomationExecutionLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAutomationExecutionErrorKind::IdempotentParameterMismatch`.
    pub fn is_idempotent_parameter_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            StartAutomationExecutionErrorKind::IdempotentParameterMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `StartAutomationExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StartAutomationExecutionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `StartAutomationExecutionErrorKind::InvalidAutomationExecutionParametersException`.
    pub fn is_invalid_automation_execution_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAutomationExecutionErrorKind::InvalidAutomationExecutionParametersException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAutomationExecutionErrorKind::InvalidTarget`.
    pub fn is_invalid_target(&self) -> bool {
        matches!(
            &self.kind,
            StartAutomationExecutionErrorKind::InvalidTarget(_)
        )
    }
}
impl std::error::Error for StartAutomationExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAutomationExecutionErrorKind::AutomationDefinitionNotFoundException(_inner) => {
                Some(_inner)
            }
            StartAutomationExecutionErrorKind::AutomationDefinitionVersionNotFoundException(
                _inner,
            ) => Some(_inner),
            StartAutomationExecutionErrorKind::AutomationExecutionLimitExceededException(
                _inner,
            ) => Some(_inner),
            StartAutomationExecutionErrorKind::IdempotentParameterMismatch(_inner) => Some(_inner),
            StartAutomationExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            StartAutomationExecutionErrorKind::InvalidAutomationExecutionParametersException(
                _inner,
            ) => Some(_inner),
            StartAutomationExecutionErrorKind::InvalidTarget(_inner) => Some(_inner),
            StartAutomationExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartChangeRequestExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartChangeRequestExecutionError {
    /// Kind of error that occurred.
    pub kind: StartChangeRequestExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartChangeRequestExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartChangeRequestExecutionErrorKind {
    /// <p>Indicates that the Change Manager change template used in the change request was rejected or is
    /// still in a pending state.</p>
    AutomationDefinitionNotApprovedException(
        crate::error::AutomationDefinitionNotApprovedException,
    ),
    /// <p>An Automation runbook with the specified name couldn't be found.</p>
    AutomationDefinitionNotFoundException(crate::error::AutomationDefinitionNotFoundException),
    /// <p>An Automation runbook with the specified name and version couldn't be found.</p>
    AutomationDefinitionVersionNotFoundException(
        crate::error::AutomationDefinitionVersionNotFoundException,
    ),
    /// <p>The number of simultaneously running Automation executions exceeded the allowable
    /// limit.</p>
    AutomationExecutionLimitExceededException(
        crate::error::AutomationExecutionLimitExceededException,
    ),
    /// <p>Error returned when an idempotent operation is retried and the parameters don't match the
    /// original call to the API with the same idempotency token. </p>
    IdempotentParameterMismatch(crate::error::IdempotentParameterMismatch),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The supplied parameters for invoking the specified Automation runbook are incorrect. For
    /// example, they may not match the set of parameters permitted for the specified Automation
    /// document.</p>
    InvalidAutomationExecutionParametersException(
        crate::error::InvalidAutomationExecutionParametersException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartChangeRequestExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartChangeRequestExecutionErrorKind::AutomationDefinitionNotApprovedException(
                _inner,
            ) => _inner.fmt(f),
            StartChangeRequestExecutionErrorKind::AutomationDefinitionNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartChangeRequestExecutionErrorKind::AutomationDefinitionVersionNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            StartChangeRequestExecutionErrorKind::AutomationExecutionLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            StartChangeRequestExecutionErrorKind::IdempotentParameterMismatch(_inner) => {
                _inner.fmt(f)
            }
            StartChangeRequestExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartChangeRequestExecutionErrorKind::InvalidAutomationExecutionParametersException(
                _inner,
            ) => _inner.fmt(f),
            StartChangeRequestExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartChangeRequestExecutionError {
    fn code(&self) -> Option<&str> {
        StartChangeRequestExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartChangeRequestExecutionError {
    /// Creates a new `StartChangeRequestExecutionError`.
    pub fn new(kind: StartChangeRequestExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartChangeRequestExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartChangeRequestExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartChangeRequestExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartChangeRequestExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartChangeRequestExecutionErrorKind::AutomationDefinitionNotApprovedException`.
    pub fn is_automation_definition_not_approved_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChangeRequestExecutionErrorKind::AutomationDefinitionNotApprovedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChangeRequestExecutionErrorKind::AutomationDefinitionNotFoundException`.
    pub fn is_automation_definition_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChangeRequestExecutionErrorKind::AutomationDefinitionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChangeRequestExecutionErrorKind::AutomationDefinitionVersionNotFoundException`.
    pub fn is_automation_definition_version_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChangeRequestExecutionErrorKind::AutomationDefinitionVersionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChangeRequestExecutionErrorKind::AutomationExecutionLimitExceededException`.
    pub fn is_automation_execution_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChangeRequestExecutionErrorKind::AutomationExecutionLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChangeRequestExecutionErrorKind::IdempotentParameterMismatch`.
    pub fn is_idempotent_parameter_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            StartChangeRequestExecutionErrorKind::IdempotentParameterMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `StartChangeRequestExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StartChangeRequestExecutionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `StartChangeRequestExecutionErrorKind::InvalidAutomationExecutionParametersException`.
    pub fn is_invalid_automation_execution_parameters_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChangeRequestExecutionErrorKind::InvalidAutomationExecutionParametersException(_)
        )
    }
}
impl std::error::Error for StartChangeRequestExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartChangeRequestExecutionErrorKind::AutomationDefinitionNotApprovedException(
                _inner,
            ) => Some(_inner),
            StartChangeRequestExecutionErrorKind::AutomationDefinitionNotFoundException(_inner) => {
                Some(_inner)
            }
            StartChangeRequestExecutionErrorKind::AutomationDefinitionVersionNotFoundException(
                _inner,
            ) => Some(_inner),
            StartChangeRequestExecutionErrorKind::AutomationExecutionLimitExceededException(
                _inner,
            ) => Some(_inner),
            StartChangeRequestExecutionErrorKind::IdempotentParameterMismatch(_inner) => {
                Some(_inner)
            }
            StartChangeRequestExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            StartChangeRequestExecutionErrorKind::InvalidAutomationExecutionParametersException(
                _inner,
            ) => Some(_inner),
            StartChangeRequestExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSessionError {
    /// Kind of error that occurred.
    pub kind: StartSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSessionErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The specified target managed node for the session isn't fully configured for use with Session Manager. For
    /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html">Getting started with
    /// Session Manager</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. This error is also returned if you
    /// attempt to start a session on a managed node that is located in a different account or Region</p>
    TargetNotConnected(crate::error::TargetNotConnected),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSessionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StartSessionErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            StartSessionErrorKind::TargetNotConnected(_inner) => _inner.fmt(f),
            StartSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSessionError {
    fn code(&self) -> Option<&str> {
        StartSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSessionError {
    /// Creates a new `StartSessionError`.
    pub fn new(kind: StartSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartSessionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, StartSessionErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `StartSessionErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, StartSessionErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `StartSessionErrorKind::TargetNotConnected`.
    pub fn is_target_not_connected(&self) -> bool {
        matches!(&self.kind, StartSessionErrorKind::TargetNotConnected(_))
    }
}
impl std::error::Error for StartSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSessionErrorKind::InternalServerError(_inner) => Some(_inner),
            StartSessionErrorKind::InvalidDocument(_inner) => Some(_inner),
            StartSessionErrorKind::TargetNotConnected(_inner) => Some(_inner),
            StartSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopAutomationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopAutomationExecutionError {
    /// Kind of error that occurred.
    pub kind: StopAutomationExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopAutomationExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopAutomationExecutionErrorKind {
    /// <p>There is no automation execution information for the requested automation execution
    /// ID.</p>
    AutomationExecutionNotFoundException(crate::error::AutomationExecutionNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified update status operation isn't valid.</p>
    InvalidAutomationStatusUpdateException(crate::error::InvalidAutomationStatusUpdateException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopAutomationExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopAutomationExecutionErrorKind::AutomationExecutionNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StopAutomationExecutionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            StopAutomationExecutionErrorKind::InvalidAutomationStatusUpdateException(_inner) => {
                _inner.fmt(f)
            }
            StopAutomationExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopAutomationExecutionError {
    fn code(&self) -> Option<&str> {
        StopAutomationExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopAutomationExecutionError {
    /// Creates a new `StopAutomationExecutionError`.
    pub fn new(kind: StopAutomationExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopAutomationExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopAutomationExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopAutomationExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopAutomationExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopAutomationExecutionErrorKind::AutomationExecutionNotFoundException`.
    pub fn is_automation_execution_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAutomationExecutionErrorKind::AutomationExecutionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopAutomationExecutionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            StopAutomationExecutionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `StopAutomationExecutionErrorKind::InvalidAutomationStatusUpdateException`.
    pub fn is_invalid_automation_status_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopAutomationExecutionErrorKind::InvalidAutomationStatusUpdateException(_)
        )
    }
}
impl std::error::Error for StopAutomationExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopAutomationExecutionErrorKind::AutomationExecutionNotFoundException(_inner) => {
                Some(_inner)
            }
            StopAutomationExecutionErrorKind::InternalServerError(_inner) => Some(_inner),
            StopAutomationExecutionErrorKind::InvalidAutomationStatusUpdateException(_inner) => {
                Some(_inner)
            }
            StopAutomationExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TerminateSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TerminateSessionError {
    /// Kind of error that occurred.
    pub kind: TerminateSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TerminateSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TerminateSessionErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TerminateSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TerminateSessionErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            TerminateSessionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TerminateSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TerminateSessionError {
    fn code(&self) -> Option<&str> {
        TerminateSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TerminateSessionError {
    /// Creates a new `TerminateSessionError`.
    pub fn new(kind: TerminateSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TerminateSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TerminateSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TerminateSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TerminateSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TerminateSessionErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            TerminateSessionErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `TerminateSessionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            TerminateSessionErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for TerminateSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TerminateSessionErrorKind::DoesNotExistException(_inner) => Some(_inner),
            TerminateSessionErrorKind::InternalServerError(_inner) => Some(_inner),
            TerminateSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UnlabelParameterVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UnlabelParameterVersionError {
    /// Kind of error that occurred.
    pub kind: UnlabelParameterVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UnlabelParameterVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UnlabelParameterVersionErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The parameter couldn't be found. Verify the name and try again.</p>
    ParameterNotFound(crate::error::ParameterNotFound),
    /// <p>The specified parameter version wasn't found. Verify the parameter name and version, and try
    /// again.</p>
    ParameterVersionNotFound(crate::error::ParameterVersionNotFound),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UnlabelParameterVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UnlabelParameterVersionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UnlabelParameterVersionErrorKind::ParameterNotFound(_inner) => _inner.fmt(f),
            UnlabelParameterVersionErrorKind::ParameterVersionNotFound(_inner) => _inner.fmt(f),
            UnlabelParameterVersionErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            UnlabelParameterVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UnlabelParameterVersionError {
    fn code(&self) -> Option<&str> {
        UnlabelParameterVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UnlabelParameterVersionError {
    /// Creates a new `UnlabelParameterVersionError`.
    pub fn new(kind: UnlabelParameterVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UnlabelParameterVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UnlabelParameterVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UnlabelParameterVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UnlabelParameterVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UnlabelParameterVersionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UnlabelParameterVersionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UnlabelParameterVersionErrorKind::ParameterNotFound`.
    pub fn is_parameter_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UnlabelParameterVersionErrorKind::ParameterNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UnlabelParameterVersionErrorKind::ParameterVersionNotFound`.
    pub fn is_parameter_version_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UnlabelParameterVersionErrorKind::ParameterVersionNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UnlabelParameterVersionErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(
            &self.kind,
            UnlabelParameterVersionErrorKind::TooManyUpdates(_)
        )
    }
}
impl std::error::Error for UnlabelParameterVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UnlabelParameterVersionErrorKind::InternalServerError(_inner) => Some(_inner),
            UnlabelParameterVersionErrorKind::ParameterNotFound(_inner) => Some(_inner),
            UnlabelParameterVersionErrorKind::ParameterVersionNotFound(_inner) => Some(_inner),
            UnlabelParameterVersionErrorKind::TooManyUpdates(_inner) => Some(_inner),
            UnlabelParameterVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssociationError {
    /// Kind of error that occurred.
    pub kind: UpdateAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssociationErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>You have reached the maximum number versions allowed for an association. Each association
    /// has a limit of 1,000 versions. </p>
    AssociationVersionLimitExceeded(crate::error::AssociationVersionLimitExceeded),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The version you specified isn't valid. Use ListAssociationVersions to view all versions of
    /// an association according to the association ID. Or, use the <code>$LATEST</code> parameter to
    /// view the latest version of the association.</p>
    InvalidAssociationVersion(crate::error::InvalidAssociationVersion),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// <p>The output location isn't valid or doesn't exist.</p>
    InvalidOutputLocation(crate::error::InvalidOutputLocation),
    /// <p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM
    /// document). You can only supply values to parameters defined in the SSM document.</p>
    InvalidParameters(crate::error::InvalidParameters),
    /// <p>The schedule is invalid. Verify your cron or rate expression and try again.</p>
    InvalidSchedule(crate::error::InvalidSchedule),
    /// <p>The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might
    /// not have permission to perform the operation.</p>
    InvalidTarget(crate::error::InvalidTarget),
    /// <p>The update isn't valid.</p>
    InvalidUpdate(crate::error::InvalidUpdate),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssociationErrorKind::AssociationDoesNotExist(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::AssociationVersionLimitExceeded(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidAssociationVersion(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidOutputLocation(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidParameters(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidSchedule(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidTarget(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::InvalidUpdate(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            UpdateAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssociationError {
    fn code(&self) -> Option<&str> {
        UpdateAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssociationError {
    /// Creates a new `UpdateAssociationError`.
    pub fn new(kind: UpdateAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::AssociationVersionLimitExceeded`.
    pub fn is_association_version_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationErrorKind::AssociationVersionLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidAssociationVersion`.
    pub fn is_invalid_association_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationErrorKind::InvalidAssociationVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, UpdateAssociationErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationErrorKind::InvalidDocumentVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidOutputLocation`.
    pub fn is_invalid_output_location(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationErrorKind::InvalidOutputLocation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidParameters`.
    pub fn is_invalid_parameters(&self) -> bool {
        matches!(&self.kind, UpdateAssociationErrorKind::InvalidParameters(_))
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidSchedule`.
    pub fn is_invalid_schedule(&self) -> bool {
        matches!(&self.kind, UpdateAssociationErrorKind::InvalidSchedule(_))
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidTarget`.
    pub fn is_invalid_target(&self) -> bool {
        matches!(&self.kind, UpdateAssociationErrorKind::InvalidTarget(_))
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::InvalidUpdate`.
    pub fn is_invalid_update(&self) -> bool {
        matches!(&self.kind, UpdateAssociationErrorKind::InvalidUpdate(_))
    }
    /// Returns `true` if the error kind is `UpdateAssociationErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(&self.kind, UpdateAssociationErrorKind::TooManyUpdates(_))
    }
}
impl std::error::Error for UpdateAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssociationErrorKind::AssociationDoesNotExist(_inner) => Some(_inner),
            UpdateAssociationErrorKind::AssociationVersionLimitExceeded(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidAssociationVersion(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidDocument(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidOutputLocation(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidParameters(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidSchedule(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidTarget(_inner) => Some(_inner),
            UpdateAssociationErrorKind::InvalidUpdate(_inner) => Some(_inner),
            UpdateAssociationErrorKind::TooManyUpdates(_inner) => Some(_inner),
            UpdateAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssociationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssociationStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateAssociationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssociationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssociationStatusErrorKind {
    /// <p>The specified association doesn't exist.</p>
    AssociationDoesNotExist(crate::error::AssociationDoesNotExist),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// <p>The updated status is the same as the current status.</p>
    StatusUnchanged(crate::error::StatusUnchanged),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssociationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssociationStatusErrorKind::AssociationDoesNotExist(_inner) => _inner.fmt(f),
            UpdateAssociationStatusErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateAssociationStatusErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            UpdateAssociationStatusErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            UpdateAssociationStatusErrorKind::StatusUnchanged(_inner) => _inner.fmt(f),
            UpdateAssociationStatusErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            UpdateAssociationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssociationStatusError {
    fn code(&self) -> Option<&str> {
        UpdateAssociationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssociationStatusError {
    /// Creates a new `UpdateAssociationStatusError`.
    pub fn new(kind: UpdateAssociationStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssociationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssociationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssociationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssociationStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssociationStatusErrorKind::AssociationDoesNotExist`.
    pub fn is_association_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationStatusErrorKind::AssociationDoesNotExist(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationStatusErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationStatusErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationStatusErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationStatusErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationStatusErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationStatusErrorKind::InvalidInstanceId(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationStatusErrorKind::StatusUnchanged`.
    pub fn is_status_unchanged(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationStatusErrorKind::StatusUnchanged(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssociationStatusErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssociationStatusErrorKind::TooManyUpdates(_)
        )
    }
}
impl std::error::Error for UpdateAssociationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssociationStatusErrorKind::AssociationDoesNotExist(_inner) => Some(_inner),
            UpdateAssociationStatusErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateAssociationStatusErrorKind::InvalidDocument(_inner) => Some(_inner),
            UpdateAssociationStatusErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            UpdateAssociationStatusErrorKind::StatusUnchanged(_inner) => Some(_inner),
            UpdateAssociationStatusErrorKind::TooManyUpdates(_inner) => Some(_inner),
            UpdateAssociationStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDocumentError {
    /// Kind of error that occurred.
    pub kind: UpdateDocumentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDocument` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDocumentErrorKind {
    /// <p>The document has too many versions. Delete one or more document versions and try
    /// again.</p>
    DocumentVersionLimitExceeded(crate::error::DocumentVersionLimitExceeded),
    /// <p>The content of the association document matches another document. Change the content of the
    /// document and try again.</p>
    DuplicateDocumentContent(crate::error::DuplicateDocumentContent),
    /// <p>The version name has already been used in this document. Specify a different version name,
    /// and then try again.</p>
    DuplicateDocumentVersionName(crate::error::DuplicateDocumentVersionName),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The content for the document isn't valid.</p>
    InvalidDocumentContent(crate::error::InvalidDocumentContent),
    /// <p>You attempted to delete a document while it is still shared. You must stop sharing the
    /// document before you can delete it.</p>
    InvalidDocumentOperation(crate::error::InvalidDocumentOperation),
    /// <p>The version of the document schema isn't supported.</p>
    InvalidDocumentSchemaVersion(crate::error::InvalidDocumentSchemaVersion),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// <p>The size limit of a document is 64 KB.</p>
    MaxDocumentSizeExceeded(crate::error::MaxDocumentSizeExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDocumentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDocumentErrorKind::DocumentVersionLimitExceeded(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::DuplicateDocumentContent(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::DuplicateDocumentVersionName(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::InvalidDocumentContent(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::InvalidDocumentOperation(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::InvalidDocumentSchemaVersion(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::MaxDocumentSizeExceeded(_inner) => _inner.fmt(f),
            UpdateDocumentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDocumentError {
    fn code(&self) -> Option<&str> {
        UpdateDocumentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDocumentError {
    /// Creates a new `UpdateDocumentError`.
    pub fn new(kind: UpdateDocumentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDocumentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDocumentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDocumentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDocumentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::DocumentVersionLimitExceeded`.
    pub fn is_document_version_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::DocumentVersionLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::DuplicateDocumentContent`.
    pub fn is_duplicate_document_content(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::DuplicateDocumentContent(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::DuplicateDocumentVersionName`.
    pub fn is_duplicate_document_version_name(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::DuplicateDocumentVersionName(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UpdateDocumentErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(&self.kind, UpdateDocumentErrorKind::InvalidDocument(_))
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::InvalidDocumentContent`.
    pub fn is_invalid_document_content(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::InvalidDocumentContent(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::InvalidDocumentOperation`.
    pub fn is_invalid_document_operation(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::InvalidDocumentOperation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::InvalidDocumentSchemaVersion`.
    pub fn is_invalid_document_schema_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::InvalidDocumentSchemaVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::InvalidDocumentVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentErrorKind::MaxDocumentSizeExceeded`.
    pub fn is_max_document_size_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentErrorKind::MaxDocumentSizeExceeded(_)
        )
    }
}
impl std::error::Error for UpdateDocumentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDocumentErrorKind::DocumentVersionLimitExceeded(_inner) => Some(_inner),
            UpdateDocumentErrorKind::DuplicateDocumentContent(_inner) => Some(_inner),
            UpdateDocumentErrorKind::DuplicateDocumentVersionName(_inner) => Some(_inner),
            UpdateDocumentErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateDocumentErrorKind::InvalidDocument(_inner) => Some(_inner),
            UpdateDocumentErrorKind::InvalidDocumentContent(_inner) => Some(_inner),
            UpdateDocumentErrorKind::InvalidDocumentOperation(_inner) => Some(_inner),
            UpdateDocumentErrorKind::InvalidDocumentSchemaVersion(_inner) => Some(_inner),
            UpdateDocumentErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            UpdateDocumentErrorKind::MaxDocumentSizeExceeded(_inner) => Some(_inner),
            UpdateDocumentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDocumentDefaultVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDocumentDefaultVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateDocumentDefaultVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDocumentDefaultVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDocumentDefaultVersionErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>The version of the document schema isn't supported.</p>
    InvalidDocumentSchemaVersion(crate::error::InvalidDocumentSchemaVersion),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDocumentDefaultVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDocumentDefaultVersionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateDocumentDefaultVersionErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            UpdateDocumentDefaultVersionErrorKind::InvalidDocumentSchemaVersion(_inner) => {
                _inner.fmt(f)
            }
            UpdateDocumentDefaultVersionErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            UpdateDocumentDefaultVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDocumentDefaultVersionError {
    fn code(&self) -> Option<&str> {
        UpdateDocumentDefaultVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDocumentDefaultVersionError {
    /// Creates a new `UpdateDocumentDefaultVersionError`.
    pub fn new(kind: UpdateDocumentDefaultVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDocumentDefaultVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDocumentDefaultVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDocumentDefaultVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDocumentDefaultVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDocumentDefaultVersionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentDefaultVersionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentDefaultVersionErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentDefaultVersionErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentDefaultVersionErrorKind::InvalidDocumentSchemaVersion`.
    pub fn is_invalid_document_schema_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentDefaultVersionErrorKind::InvalidDocumentSchemaVersion(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentDefaultVersionErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentDefaultVersionErrorKind::InvalidDocumentVersion(_)
        )
    }
}
impl std::error::Error for UpdateDocumentDefaultVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDocumentDefaultVersionErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateDocumentDefaultVersionErrorKind::InvalidDocument(_inner) => Some(_inner),
            UpdateDocumentDefaultVersionErrorKind::InvalidDocumentSchemaVersion(_inner) => {
                Some(_inner)
            }
            UpdateDocumentDefaultVersionErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            UpdateDocumentDefaultVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDocumentMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDocumentMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateDocumentMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDocumentMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDocumentMetadataErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified SSM document doesn't exist.</p>
    InvalidDocument(crate::error::InvalidDocument),
    /// <p>You attempted to delete a document while it is still shared. You must stop sharing the
    /// document before you can delete it.</p>
    InvalidDocumentOperation(crate::error::InvalidDocumentOperation),
    /// <p>The document version isn't valid or doesn't exist.</p>
    InvalidDocumentVersion(crate::error::InvalidDocumentVersion),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDocumentMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDocumentMetadataErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateDocumentMetadataErrorKind::InvalidDocument(_inner) => _inner.fmt(f),
            UpdateDocumentMetadataErrorKind::InvalidDocumentOperation(_inner) => _inner.fmt(f),
            UpdateDocumentMetadataErrorKind::InvalidDocumentVersion(_inner) => _inner.fmt(f),
            UpdateDocumentMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDocumentMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateDocumentMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDocumentMetadataError {
    /// Creates a new `UpdateDocumentMetadataError`.
    pub fn new(kind: UpdateDocumentMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDocumentMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDocumentMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDocumentMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDocumentMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDocumentMetadataErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentMetadataErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentMetadataErrorKind::InvalidDocument`.
    pub fn is_invalid_document(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentMetadataErrorKind::InvalidDocument(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentMetadataErrorKind::InvalidDocumentOperation`.
    pub fn is_invalid_document_operation(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentMetadataErrorKind::InvalidDocumentOperation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDocumentMetadataErrorKind::InvalidDocumentVersion`.
    pub fn is_invalid_document_version(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDocumentMetadataErrorKind::InvalidDocumentVersion(_)
        )
    }
}
impl std::error::Error for UpdateDocumentMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDocumentMetadataErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateDocumentMetadataErrorKind::InvalidDocument(_inner) => Some(_inner),
            UpdateDocumentMetadataErrorKind::InvalidDocumentOperation(_inner) => Some(_inner),
            UpdateDocumentMetadataErrorKind::InvalidDocumentVersion(_inner) => Some(_inner),
            UpdateDocumentMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMaintenanceWindowError {
    /// Kind of error that occurred.
    pub kind: UpdateMaintenanceWindowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMaintenanceWindow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMaintenanceWindowErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMaintenanceWindowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMaintenanceWindowErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            UpdateMaintenanceWindowErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateMaintenanceWindowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMaintenanceWindowError {
    fn code(&self) -> Option<&str> {
        UpdateMaintenanceWindowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMaintenanceWindowError {
    /// Creates a new `UpdateMaintenanceWindowError`.
    pub fn new(kind: UpdateMaintenanceWindowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMaintenanceWindowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMaintenanceWindowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMaintenanceWindowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMaintenanceWindowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMaintenanceWindowErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceWindowErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMaintenanceWindowErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceWindowErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for UpdateMaintenanceWindowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMaintenanceWindowErrorKind::DoesNotExistException(_inner) => Some(_inner),
            UpdateMaintenanceWindowErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateMaintenanceWindowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMaintenanceWindowTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMaintenanceWindowTargetError {
    /// Kind of error that occurred.
    pub kind: UpdateMaintenanceWindowTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMaintenanceWindowTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMaintenanceWindowTargetErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMaintenanceWindowTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMaintenanceWindowTargetErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            UpdateMaintenanceWindowTargetErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateMaintenanceWindowTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMaintenanceWindowTargetError {
    fn code(&self) -> Option<&str> {
        UpdateMaintenanceWindowTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMaintenanceWindowTargetError {
    /// Creates a new `UpdateMaintenanceWindowTargetError`.
    pub fn new(
        kind: UpdateMaintenanceWindowTargetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMaintenanceWindowTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMaintenanceWindowTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMaintenanceWindowTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMaintenanceWindowTargetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMaintenanceWindowTargetErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceWindowTargetErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMaintenanceWindowTargetErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceWindowTargetErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for UpdateMaintenanceWindowTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMaintenanceWindowTargetErrorKind::DoesNotExistException(_inner) => Some(_inner),
            UpdateMaintenanceWindowTargetErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateMaintenanceWindowTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMaintenanceWindowTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMaintenanceWindowTaskError {
    /// Kind of error that occurred.
    pub kind: UpdateMaintenanceWindowTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMaintenanceWindowTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMaintenanceWindowTaskErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMaintenanceWindowTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMaintenanceWindowTaskErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            UpdateMaintenanceWindowTaskErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateMaintenanceWindowTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMaintenanceWindowTaskError {
    fn code(&self) -> Option<&str> {
        UpdateMaintenanceWindowTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMaintenanceWindowTaskError {
    /// Creates a new `UpdateMaintenanceWindowTaskError`.
    pub fn new(kind: UpdateMaintenanceWindowTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMaintenanceWindowTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMaintenanceWindowTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMaintenanceWindowTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMaintenanceWindowTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMaintenanceWindowTaskErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceWindowTaskErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMaintenanceWindowTaskErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMaintenanceWindowTaskErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for UpdateMaintenanceWindowTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMaintenanceWindowTaskErrorKind::DoesNotExistException(_inner) => Some(_inner),
            UpdateMaintenanceWindowTaskErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateMaintenanceWindowTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateManagedInstanceRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateManagedInstanceRoleError {
    /// Kind of error that occurred.
    pub kind: UpdateManagedInstanceRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateManagedInstanceRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateManagedInstanceRoleErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The following problems can cause this exception:</p>
    /// <ul>
    /// <li>
    /// <p>You don't have permission to access the managed node.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
    /// </li>
    /// <li>
    /// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
    /// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
    /// <code>Shutting-down</code> and <code>Terminated</code>.</p>
    /// </li>
    /// </ul>
    InvalidInstanceId(crate::error::InvalidInstanceId),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateManagedInstanceRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateManagedInstanceRoleErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateManagedInstanceRoleErrorKind::InvalidInstanceId(_inner) => _inner.fmt(f),
            UpdateManagedInstanceRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateManagedInstanceRoleError {
    fn code(&self) -> Option<&str> {
        UpdateManagedInstanceRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateManagedInstanceRoleError {
    /// Creates a new `UpdateManagedInstanceRoleError`.
    pub fn new(kind: UpdateManagedInstanceRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateManagedInstanceRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateManagedInstanceRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateManagedInstanceRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateManagedInstanceRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateManagedInstanceRoleErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateManagedInstanceRoleErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateManagedInstanceRoleErrorKind::InvalidInstanceId`.
    pub fn is_invalid_instance_id(&self) -> bool {
        matches!(
            &self.kind,
            UpdateManagedInstanceRoleErrorKind::InvalidInstanceId(_)
        )
    }
}
impl std::error::Error for UpdateManagedInstanceRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateManagedInstanceRoleErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateManagedInstanceRoleErrorKind::InvalidInstanceId(_inner) => Some(_inner),
            UpdateManagedInstanceRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOpsItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOpsItemError {
    /// Kind of error that occurred.
    pub kind: UpdateOpsItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOpsItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOpsItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The OpsItem already exists.</p>
    OpsItemAlreadyExistsException(crate::error::OpsItemAlreadyExistsException),
    /// <p>A specified parameter argument isn't valid. Verify the available arguments and try
    /// again.</p>
    OpsItemInvalidParameterException(crate::error::OpsItemInvalidParameterException),
    /// <p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem
    /// quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>
    OpsItemLimitExceededException(crate::error::OpsItemLimitExceededException),
    /// <p>The specified OpsItem ID doesn't exist. Verify the ID and try again.</p>
    OpsItemNotFoundException(crate::error::OpsItemNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOpsItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOpsItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateOpsItemErrorKind::OpsItemAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateOpsItemErrorKind::OpsItemInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateOpsItemErrorKind::OpsItemLimitExceededException(_inner) => _inner.fmt(f),
            UpdateOpsItemErrorKind::OpsItemNotFoundException(_inner) => _inner.fmt(f),
            UpdateOpsItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOpsItemError {
    fn code(&self) -> Option<&str> {
        UpdateOpsItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateOpsItemError {
    /// Creates a new `UpdateOpsItemError`.
    pub fn new(kind: UpdateOpsItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOpsItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOpsItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOpsItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOpsItemErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOpsItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UpdateOpsItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UpdateOpsItemErrorKind::OpsItemAlreadyExistsException`.
    pub fn is_ops_item_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsItemErrorKind::OpsItemAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpsItemErrorKind::OpsItemInvalidParameterException`.
    pub fn is_ops_item_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsItemErrorKind::OpsItemInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpsItemErrorKind::OpsItemLimitExceededException`.
    pub fn is_ops_item_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsItemErrorKind::OpsItemLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpsItemErrorKind::OpsItemNotFoundException`.
    pub fn is_ops_item_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsItemErrorKind::OpsItemNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateOpsItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOpsItemErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateOpsItemErrorKind::OpsItemAlreadyExistsException(_inner) => Some(_inner),
            UpdateOpsItemErrorKind::OpsItemInvalidParameterException(_inner) => Some(_inner),
            UpdateOpsItemErrorKind::OpsItemLimitExceededException(_inner) => Some(_inner),
            UpdateOpsItemErrorKind::OpsItemNotFoundException(_inner) => Some(_inner),
            UpdateOpsItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOpsMetadataError {
    /// Kind of error that occurred.
    pub kind: UpdateOpsMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOpsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOpsMetadataErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>One of the arguments passed is invalid. </p>
    OpsMetadataInvalidArgumentException(crate::error::OpsMetadataInvalidArgumentException),
    /// <p>The OpsMetadata object exceeds the maximum number of OpsMetadata keys that you can assign to
    /// an application in Application Manager.</p>
    OpsMetadataKeyLimitExceededException(crate::error::OpsMetadataKeyLimitExceededException),
    /// <p>The OpsMetadata object doesn't exist. </p>
    OpsMetadataNotFoundException(crate::error::OpsMetadataNotFoundException),
    /// <p>The system is processing too many concurrent updates. Wait a few moments and try
    /// again.</p>
    OpsMetadataTooManyUpdatesException(crate::error::OpsMetadataTooManyUpdatesException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOpsMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOpsMetadataErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOpsMetadataErrorKind::OpsMetadataKeyLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOpsMetadataErrorKind::OpsMetadataNotFoundException(_inner) => _inner.fmt(f),
            UpdateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(_inner) => _inner.fmt(f),
            UpdateOpsMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOpsMetadataError {
    fn code(&self) -> Option<&str> {
        UpdateOpsMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateOpsMetadataError {
    /// Creates a new `UpdateOpsMetadataError`.
    pub fn new(kind: UpdateOpsMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOpsMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOpsMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOpsMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOpsMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOpsMetadataErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsMetadataErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException`.
    pub fn is_ops_metadata_invalid_argument_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpsMetadataErrorKind::OpsMetadataKeyLimitExceededException`.
    pub fn is_ops_metadata_key_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsMetadataErrorKind::OpsMetadataKeyLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpsMetadataErrorKind::OpsMetadataNotFoundException`.
    pub fn is_ops_metadata_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsMetadataErrorKind::OpsMetadataNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException`.
    pub fn is_ops_metadata_too_many_updates_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(_)
        )
    }
}
impl std::error::Error for UpdateOpsMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOpsMetadataErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateOpsMetadataErrorKind::OpsMetadataInvalidArgumentException(_inner) => Some(_inner),
            UpdateOpsMetadataErrorKind::OpsMetadataKeyLimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateOpsMetadataErrorKind::OpsMetadataNotFoundException(_inner) => Some(_inner),
            UpdateOpsMetadataErrorKind::OpsMetadataTooManyUpdatesException(_inner) => Some(_inner),
            UpdateOpsMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePatchBaselineError {
    /// Kind of error that occurred.
    pub kind: UpdatePatchBaselineErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePatchBaseline` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePatchBaselineErrorKind {
    /// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
    /// baseline, doesn't exist.</p>
    /// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    DoesNotExistException(crate::error::DoesNotExistException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePatchBaselineError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePatchBaselineErrorKind::DoesNotExistException(_inner) => _inner.fmt(f),
            UpdatePatchBaselineErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdatePatchBaselineErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePatchBaselineError {
    fn code(&self) -> Option<&str> {
        UpdatePatchBaselineError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePatchBaselineError {
    /// Creates a new `UpdatePatchBaselineError`.
    pub fn new(kind: UpdatePatchBaselineErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePatchBaselineError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePatchBaselineErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePatchBaselineError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePatchBaselineErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePatchBaselineErrorKind::DoesNotExistException`.
    pub fn is_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePatchBaselineErrorKind::DoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePatchBaselineErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePatchBaselineErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for UpdatePatchBaselineError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePatchBaselineErrorKind::DoesNotExistException(_inner) => Some(_inner),
            UpdatePatchBaselineErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdatePatchBaselineErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceDataSyncError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceDataSyncErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResourceDataSync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceDataSyncErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Another <code>UpdateResourceDataSync</code> request is being processed. Wait a few minutes
    /// and try again.</p>
    ResourceDataSyncConflictException(crate::error::ResourceDataSyncConflictException),
    /// <p>The specified sync configuration is invalid.</p>
    ResourceDataSyncInvalidConfigurationException(
        crate::error::ResourceDataSyncInvalidConfigurationException,
    ),
    /// <p>The specified sync name wasn't found.</p>
    ResourceDataSyncNotFoundException(crate::error::ResourceDataSyncNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceDataSyncError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceDataSyncErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateResourceDataSyncErrorKind::ResourceDataSyncConflictException(_inner) => {
                _inner.fmt(f)
            }
            UpdateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => _inner.fmt(f),
            UpdateResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateResourceDataSyncErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceDataSyncError {
    fn code(&self) -> Option<&str> {
        UpdateResourceDataSyncError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceDataSyncError {
    /// Creates a new `UpdateResourceDataSyncError`.
    pub fn new(kind: UpdateResourceDataSyncErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceDataSyncError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceDataSyncErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceDataSyncError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceDataSyncErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceDataSyncErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceDataSyncErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceDataSyncErrorKind::ResourceDataSyncConflictException`.
    pub fn is_resource_data_sync_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceDataSyncErrorKind::ResourceDataSyncConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException`.
    pub fn is_resource_data_sync_invalid_configuration_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceDataSyncErrorKind::ResourceDataSyncNotFoundException`.
    pub fn is_resource_data_sync_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateResourceDataSyncError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceDataSyncErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateResourceDataSyncErrorKind::ResourceDataSyncConflictException(_inner) => {
                Some(_inner)
            }
            UpdateResourceDataSyncErrorKind::ResourceDataSyncInvalidConfigurationException(
                _inner,
            ) => Some(_inner),
            UpdateResourceDataSyncErrorKind::ResourceDataSyncNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateResourceDataSyncErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceSettingError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceSettingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceSettingErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified service setting wasn't found. Either the service name or the setting hasn't
    /// been provisioned by the Amazon Web Services service team.</p>
    ServiceSettingNotFound(crate::error::ServiceSettingNotFound),
    /// <p>There are concurrent updates for a resource that supports one update at a time.</p>
    TooManyUpdates(crate::error::TooManyUpdates),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceSettingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceSettingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateServiceSettingErrorKind::ServiceSettingNotFound(_inner) => _inner.fmt(f),
            UpdateServiceSettingErrorKind::TooManyUpdates(_inner) => _inner.fmt(f),
            UpdateServiceSettingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceSettingError {
    fn code(&self) -> Option<&str> {
        UpdateServiceSettingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceSettingError {
    /// Creates a new `UpdateServiceSettingError`.
    pub fn new(kind: UpdateServiceSettingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceSettingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceSettingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceSettingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceSettingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSettingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingErrorKind::ServiceSettingNotFound`.
    pub fn is_service_setting_not_found(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSettingErrorKind::ServiceSettingNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingErrorKind::TooManyUpdates`.
    pub fn is_too_many_updates(&self) -> bool {
        matches!(&self.kind, UpdateServiceSettingErrorKind::TooManyUpdates(_))
    }
}
impl std::error::Error for UpdateServiceSettingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceSettingErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateServiceSettingErrorKind::ServiceSettingNotFound(_inner) => Some(_inner),
            UpdateServiceSettingErrorKind::TooManyUpdates(_inner) => Some(_inner),
            UpdateServiceSettingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>There are concurrent updates for a resource that supports one update at a time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyUpdates {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyUpdates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyUpdates");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyUpdates {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyUpdates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyUpdates")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyUpdates {}
/// See [`TooManyUpdates`](crate::error::TooManyUpdates)
pub mod too_many_updates {
    /// A builder for [`TooManyUpdates`](crate::error::TooManyUpdates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyUpdates`](crate::error::TooManyUpdates)
        pub fn build(self) -> crate::error::TooManyUpdates {
            crate::error::TooManyUpdates {
                message: self.message,
            }
        }
    }
}
impl TooManyUpdates {
    /// Creates a new builder-style object to manufacture [`TooManyUpdates`](crate::error::TooManyUpdates)
    pub fn builder() -> crate::error::too_many_updates::Builder {
        crate::error::too_many_updates::Builder::default()
    }
}

/// <p>The specified service setting wasn't found. Either the service name or the setting hasn't
/// been provisioned by the Amazon Web Services service team.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSettingNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceSettingNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSettingNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceSettingNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceSettingNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceSettingNotFound")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceSettingNotFound {}
/// See [`ServiceSettingNotFound`](crate::error::ServiceSettingNotFound)
pub mod service_setting_not_found {
    /// A builder for [`ServiceSettingNotFound`](crate::error::ServiceSettingNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSettingNotFound`](crate::error::ServiceSettingNotFound)
        pub fn build(self) -> crate::error::ServiceSettingNotFound {
            crate::error::ServiceSettingNotFound {
                message: self.message,
            }
        }
    }
}
impl ServiceSettingNotFound {
    /// Creates a new builder-style object to manufacture [`ServiceSettingNotFound`](crate::error::ServiceSettingNotFound)
    pub fn builder() -> crate::error::service_setting_not_found::Builder {
        crate::error::service_setting_not_found::Builder::default()
    }
}

/// <p>An error occurred on the server side.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>The specified sync name wasn't found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub sync_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub sync_type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceDataSyncNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn sync_name(&self) -> std::option::Option<&str> {
        self.sync_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn sync_type(&self) -> std::option::Option<&str> {
        self.sync_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceDataSyncNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncNotFoundException");
        formatter.field("sync_name", &self.sync_name);
        formatter.field("sync_type", &self.sync_type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceDataSyncNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceDataSyncNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceDataSyncNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceDataSyncNotFoundException {}
/// See [`ResourceDataSyncNotFoundException`](crate::error::ResourceDataSyncNotFoundException)
pub mod resource_data_sync_not_found_exception {
    /// A builder for [`ResourceDataSyncNotFoundException`](crate::error::ResourceDataSyncNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sync_name: std::option::Option<std::string::String>,
        pub(crate) sync_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncNotFoundException`](crate::error::ResourceDataSyncNotFoundException)
        pub fn build(self) -> crate::error::ResourceDataSyncNotFoundException {
            crate::error::ResourceDataSyncNotFoundException {
                sync_name: self.sync_name,
                sync_type: self.sync_type,
                message: self.message,
            }
        }
    }
}
impl ResourceDataSyncNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncNotFoundException`](crate::error::ResourceDataSyncNotFoundException)
    pub fn builder() -> crate::error::resource_data_sync_not_found_exception::Builder {
        crate::error::resource_data_sync_not_found_exception::Builder::default()
    }
}

/// <p>The specified sync configuration is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncInvalidConfigurationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceDataSyncInvalidConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncInvalidConfigurationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceDataSyncInvalidConfigurationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceDataSyncInvalidConfigurationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceDataSyncInvalidConfigurationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceDataSyncInvalidConfigurationException {}
/// See [`ResourceDataSyncInvalidConfigurationException`](crate::error::ResourceDataSyncInvalidConfigurationException)
pub mod resource_data_sync_invalid_configuration_exception {
    /// A builder for [`ResourceDataSyncInvalidConfigurationException`](crate::error::ResourceDataSyncInvalidConfigurationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncInvalidConfigurationException`](crate::error::ResourceDataSyncInvalidConfigurationException)
        pub fn build(self) -> crate::error::ResourceDataSyncInvalidConfigurationException {
            crate::error::ResourceDataSyncInvalidConfigurationException {
                message: self.message,
            }
        }
    }
}
impl ResourceDataSyncInvalidConfigurationException {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncInvalidConfigurationException`](crate::error::ResourceDataSyncInvalidConfigurationException)
    pub fn builder() -> crate::error::resource_data_sync_invalid_configuration_exception::Builder {
        crate::error::resource_data_sync_invalid_configuration_exception::Builder::default()
    }
}

/// <p>Another <code>UpdateResourceDataSync</code> request is being processed. Wait a few minutes
/// and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceDataSyncConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceDataSyncConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceDataSyncConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceDataSyncConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceDataSyncConflictException {}
/// See [`ResourceDataSyncConflictException`](crate::error::ResourceDataSyncConflictException)
pub mod resource_data_sync_conflict_exception {
    /// A builder for [`ResourceDataSyncConflictException`](crate::error::ResourceDataSyncConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncConflictException`](crate::error::ResourceDataSyncConflictException)
        pub fn build(self) -> crate::error::ResourceDataSyncConflictException {
            crate::error::ResourceDataSyncConflictException {
                message: self.message,
            }
        }
    }
}
impl ResourceDataSyncConflictException {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncConflictException`](crate::error::ResourceDataSyncConflictException)
    pub fn builder() -> crate::error::resource_data_sync_conflict_exception::Builder {
        crate::error::resource_data_sync_conflict_exception::Builder::default()
    }
}

/// <p>Error returned when the ID specified for a resource, such as a maintenance window or patch
/// baseline, doesn't exist.</p>
/// <p>For information about resource quotas in Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
/// <i>Amazon Web Services General Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DoesNotExistException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DoesNotExistException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DoesNotExistException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DoesNotExistException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DoesNotExistException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for DoesNotExistException {}
/// See [`DoesNotExistException`](crate::error::DoesNotExistException)
pub mod does_not_exist_exception {
    /// A builder for [`DoesNotExistException`](crate::error::DoesNotExistException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DoesNotExistException`](crate::error::DoesNotExistException)
        pub fn build(self) -> crate::error::DoesNotExistException {
            crate::error::DoesNotExistException {
                message: self.message,
            }
        }
    }
}
impl DoesNotExistException {
    /// Creates a new builder-style object to manufacture [`DoesNotExistException`](crate::error::DoesNotExistException)
    pub fn builder() -> crate::error::does_not_exist_exception::Builder {
        crate::error::does_not_exist_exception::Builder::default()
    }
}

/// <p>The system is processing too many concurrent updates. Wait a few moments and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsMetadataTooManyUpdatesException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsMetadataTooManyUpdatesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsMetadataTooManyUpdatesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OpsMetadataTooManyUpdatesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsMetadataTooManyUpdatesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsMetadataTooManyUpdatesException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsMetadataTooManyUpdatesException {}
/// See [`OpsMetadataTooManyUpdatesException`](crate::error::OpsMetadataTooManyUpdatesException)
pub mod ops_metadata_too_many_updates_exception {
    /// A builder for [`OpsMetadataTooManyUpdatesException`](crate::error::OpsMetadataTooManyUpdatesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsMetadataTooManyUpdatesException`](crate::error::OpsMetadataTooManyUpdatesException)
        pub fn build(self) -> crate::error::OpsMetadataTooManyUpdatesException {
            crate::error::OpsMetadataTooManyUpdatesException {
                message: self.message,
            }
        }
    }
}
impl OpsMetadataTooManyUpdatesException {
    /// Creates a new builder-style object to manufacture [`OpsMetadataTooManyUpdatesException`](crate::error::OpsMetadataTooManyUpdatesException)
    pub fn builder() -> crate::error::ops_metadata_too_many_updates_exception::Builder {
        crate::error::ops_metadata_too_many_updates_exception::Builder::default()
    }
}

/// <p>The OpsMetadata object doesn't exist. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsMetadataNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsMetadataNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsMetadataNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OpsMetadataNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsMetadataNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsMetadataNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsMetadataNotFoundException {}
/// See [`OpsMetadataNotFoundException`](crate::error::OpsMetadataNotFoundException)
pub mod ops_metadata_not_found_exception {
    /// A builder for [`OpsMetadataNotFoundException`](crate::error::OpsMetadataNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsMetadataNotFoundException`](crate::error::OpsMetadataNotFoundException)
        pub fn build(self) -> crate::error::OpsMetadataNotFoundException {
            crate::error::OpsMetadataNotFoundException {
                message: self.message,
            }
        }
    }
}
impl OpsMetadataNotFoundException {
    /// Creates a new builder-style object to manufacture [`OpsMetadataNotFoundException`](crate::error::OpsMetadataNotFoundException)
    pub fn builder() -> crate::error::ops_metadata_not_found_exception::Builder {
        crate::error::ops_metadata_not_found_exception::Builder::default()
    }
}

/// <p>The OpsMetadata object exceeds the maximum number of OpsMetadata keys that you can assign to
/// an application in Application Manager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsMetadataKeyLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsMetadataKeyLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsMetadataKeyLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OpsMetadataKeyLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsMetadataKeyLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsMetadataKeyLimitExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsMetadataKeyLimitExceededException {}
/// See [`OpsMetadataKeyLimitExceededException`](crate::error::OpsMetadataKeyLimitExceededException)
pub mod ops_metadata_key_limit_exceeded_exception {
    /// A builder for [`OpsMetadataKeyLimitExceededException`](crate::error::OpsMetadataKeyLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsMetadataKeyLimitExceededException`](crate::error::OpsMetadataKeyLimitExceededException)
        pub fn build(self) -> crate::error::OpsMetadataKeyLimitExceededException {
            crate::error::OpsMetadataKeyLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl OpsMetadataKeyLimitExceededException {
    /// Creates a new builder-style object to manufacture [`OpsMetadataKeyLimitExceededException`](crate::error::OpsMetadataKeyLimitExceededException)
    pub fn builder() -> crate::error::ops_metadata_key_limit_exceeded_exception::Builder {
        crate::error::ops_metadata_key_limit_exceeded_exception::Builder::default()
    }
}

/// <p>One of the arguments passed is invalid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsMetadataInvalidArgumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsMetadataInvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsMetadataInvalidArgumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OpsMetadataInvalidArgumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsMetadataInvalidArgumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsMetadataInvalidArgumentException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsMetadataInvalidArgumentException {}
/// See [`OpsMetadataInvalidArgumentException`](crate::error::OpsMetadataInvalidArgumentException)
pub mod ops_metadata_invalid_argument_exception {
    /// A builder for [`OpsMetadataInvalidArgumentException`](crate::error::OpsMetadataInvalidArgumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsMetadataInvalidArgumentException`](crate::error::OpsMetadataInvalidArgumentException)
        pub fn build(self) -> crate::error::OpsMetadataInvalidArgumentException {
            crate::error::OpsMetadataInvalidArgumentException {
                message: self.message,
            }
        }
    }
}
impl OpsMetadataInvalidArgumentException {
    /// Creates a new builder-style object to manufacture [`OpsMetadataInvalidArgumentException`](crate::error::OpsMetadataInvalidArgumentException)
    pub fn builder() -> crate::error::ops_metadata_invalid_argument_exception::Builder {
        crate::error::ops_metadata_invalid_argument_exception::Builder::default()
    }
}

/// <p>The specified OpsItem ID doesn't exist. Verify the ID and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsItemNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OpsItemNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsItemNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsItemNotFoundException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsItemNotFoundException {}
/// See [`OpsItemNotFoundException`](crate::error::OpsItemNotFoundException)
pub mod ops_item_not_found_exception {
    /// A builder for [`OpsItemNotFoundException`](crate::error::OpsItemNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemNotFoundException`](crate::error::OpsItemNotFoundException)
        pub fn build(self) -> crate::error::OpsItemNotFoundException {
            crate::error::OpsItemNotFoundException {
                message: self.message,
            }
        }
    }
}
impl OpsItemNotFoundException {
    /// Creates a new builder-style object to manufacture [`OpsItemNotFoundException`](crate::error::OpsItemNotFoundException)
    pub fn builder() -> crate::error::ops_item_not_found_exception::Builder {
        crate::error::ops_item_not_found_exception::Builder::default()
    }
}

/// <p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem
/// quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
    #[allow(missing_docs)] // documentation missing in model
    pub limit: i32,
    #[allow(missing_docs)] // documentation missing in model
    pub limit_type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl OpsItemLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_types(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_types.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit(&self) -> i32 {
        self.limit
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn limit_type(&self) -> std::option::Option<&str> {
        self.limit_type.as_deref()
    }
}
impl std::fmt::Debug for OpsItemLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemLimitExceededException");
        formatter.field("resource_types", &self.resource_types);
        formatter.field("limit", &self.limit);
        formatter.field("limit_type", &self.limit_type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OpsItemLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsItemLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsItemLimitExceededException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsItemLimitExceededException {}
/// See [`OpsItemLimitExceededException`](crate::error::OpsItemLimitExceededException)
pub mod ops_item_limit_exceeded_exception {
    /// A builder for [`OpsItemLimitExceededException`](crate::error::OpsItemLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) limit_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_types`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        pub fn resource_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_types.unwrap_or_default();
            v.push(input.into());
            self.resource_types = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_types = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn limit_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_limit_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemLimitExceededException`](crate::error::OpsItemLimitExceededException)
        pub fn build(self) -> crate::error::OpsItemLimitExceededException {
            crate::error::OpsItemLimitExceededException {
                resource_types: self.resource_types,
                limit: self.limit.unwrap_or_default(),
                limit_type: self.limit_type,
                message: self.message,
            }
        }
    }
}
impl OpsItemLimitExceededException {
    /// Creates a new builder-style object to manufacture [`OpsItemLimitExceededException`](crate::error::OpsItemLimitExceededException)
    pub fn builder() -> crate::error::ops_item_limit_exceeded_exception::Builder {
        crate::error::ops_item_limit_exceeded_exception::Builder::default()
    }
}

/// <p>A specified parameter argument isn't valid. Verify the available arguments and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemInvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub parameter_names: std::option::Option<std::vec::Vec<std::string::String>>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl OpsItemInvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn parameter_names(&self) -> std::option::Option<&[std::string::String]> {
        self.parameter_names.as_deref()
    }
}
impl std::fmt::Debug for OpsItemInvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemInvalidParameterException");
        formatter.field("parameter_names", &self.parameter_names);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OpsItemInvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsItemInvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsItemInvalidParameterException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsItemInvalidParameterException {}
/// See [`OpsItemInvalidParameterException`](crate::error::OpsItemInvalidParameterException)
pub mod ops_item_invalid_parameter_exception {
    /// A builder for [`OpsItemInvalidParameterException`](crate::error::OpsItemInvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameter_names`.
        ///
        /// To override the contents of this collection use [`set_parameter_names`](Self::set_parameter_names).
        ///
        pub fn parameter_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parameter_names.unwrap_or_default();
            v.push(input.into());
            self.parameter_names = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_parameter_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parameter_names = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemInvalidParameterException`](crate::error::OpsItemInvalidParameterException)
        pub fn build(self) -> crate::error::OpsItemInvalidParameterException {
            crate::error::OpsItemInvalidParameterException {
                parameter_names: self.parameter_names,
                message: self.message,
            }
        }
    }
}
impl OpsItemInvalidParameterException {
    /// Creates a new builder-style object to manufacture [`OpsItemInvalidParameterException`](crate::error::OpsItemInvalidParameterException)
    pub fn builder() -> crate::error::ops_item_invalid_parameter_exception::Builder {
        crate::error::ops_item_invalid_parameter_exception::Builder::default()
    }
}

/// <p>The OpsItem already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub ops_item_id: std::option::Option<std::string::String>,
}
impl OpsItemAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn ops_item_id(&self) -> std::option::Option<&str> {
        self.ops_item_id.as_deref()
    }
}
impl std::fmt::Debug for OpsItemAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.finish()
    }
}
impl OpsItemAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OpsItemAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OpsItemAlreadyExistsException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for OpsItemAlreadyExistsException {}
/// See [`OpsItemAlreadyExistsException`](crate::error::OpsItemAlreadyExistsException)
pub mod ops_item_already_exists_exception {
    /// A builder for [`OpsItemAlreadyExistsException`](crate::error::OpsItemAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemAlreadyExistsException`](crate::error::OpsItemAlreadyExistsException)
        pub fn build(self) -> crate::error::OpsItemAlreadyExistsException {
            crate::error::OpsItemAlreadyExistsException {
                message: self.message,
                ops_item_id: self.ops_item_id,
            }
        }
    }
}
impl OpsItemAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`OpsItemAlreadyExistsException`](crate::error::OpsItemAlreadyExistsException)
    pub fn builder() -> crate::error::ops_item_already_exists_exception::Builder {
        crate::error::ops_item_already_exists_exception::Builder::default()
    }
}

/// <p>The following problems can cause this exception:</p>
/// <ul>
/// <li>
/// <p>You don't have permission to access the managed node.</p>
/// </li>
/// <li>
/// <p>Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is
/// running.</p>
/// </li>
/// <li>
/// <p>SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.</p>
/// </li>
/// <li>
/// <p>The managed node isn't in valid state. Valid states are: <code>Running</code>,
/// <code>Pending</code>, <code>Stopped</code>, and <code>Stopping</code>. Invalid states are:
/// <code>Shutting-down</code> and <code>Terminated</code>.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInstanceId {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInstanceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInstanceId");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInstanceId {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInstanceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInstanceId")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInstanceId {}
/// See [`InvalidInstanceId`](crate::error::InvalidInstanceId)
pub mod invalid_instance_id {
    /// A builder for [`InvalidInstanceId`](crate::error::InvalidInstanceId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInstanceId`](crate::error::InvalidInstanceId)
        pub fn build(self) -> crate::error::InvalidInstanceId {
            crate::error::InvalidInstanceId {
                message: self.message,
            }
        }
    }
}
impl InvalidInstanceId {
    /// Creates a new builder-style object to manufacture [`InvalidInstanceId`](crate::error::InvalidInstanceId)
    pub fn builder() -> crate::error::invalid_instance_id::Builder {
        crate::error::invalid_instance_id::Builder::default()
    }
}

/// <p>The document version isn't valid or doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDocumentVersion {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDocumentVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDocumentVersion");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDocumentVersion {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDocumentVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDocumentVersion")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDocumentVersion {}
/// See [`InvalidDocumentVersion`](crate::error::InvalidDocumentVersion)
pub mod invalid_document_version {
    /// A builder for [`InvalidDocumentVersion`](crate::error::InvalidDocumentVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDocumentVersion`](crate::error::InvalidDocumentVersion)
        pub fn build(self) -> crate::error::InvalidDocumentVersion {
            crate::error::InvalidDocumentVersion {
                message: self.message,
            }
        }
    }
}
impl InvalidDocumentVersion {
    /// Creates a new builder-style object to manufacture [`InvalidDocumentVersion`](crate::error::InvalidDocumentVersion)
    pub fn builder() -> crate::error::invalid_document_version::Builder {
        crate::error::invalid_document_version::Builder::default()
    }
}

/// <p>You attempted to delete a document while it is still shared. You must stop sharing the
/// document before you can delete it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDocumentOperation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDocumentOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDocumentOperation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDocumentOperation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDocumentOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDocumentOperation")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDocumentOperation {}
/// See [`InvalidDocumentOperation`](crate::error::InvalidDocumentOperation)
pub mod invalid_document_operation {
    /// A builder for [`InvalidDocumentOperation`](crate::error::InvalidDocumentOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDocumentOperation`](crate::error::InvalidDocumentOperation)
        pub fn build(self) -> crate::error::InvalidDocumentOperation {
            crate::error::InvalidDocumentOperation {
                message: self.message,
            }
        }
    }
}
impl InvalidDocumentOperation {
    /// Creates a new builder-style object to manufacture [`InvalidDocumentOperation`](crate::error::InvalidDocumentOperation)
    pub fn builder() -> crate::error::invalid_document_operation::Builder {
        crate::error::invalid_document_operation::Builder::default()
    }
}

/// <p>The specified SSM document doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDocument {
    /// <p>The SSM document doesn't exist or the document isn't available to the user. This exception
    /// can be issued by various API operations. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDocument");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDocument {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDocument")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDocument {}
/// See [`InvalidDocument`](crate::error::InvalidDocument)
pub mod invalid_document {
    /// A builder for [`InvalidDocument`](crate::error::InvalidDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SSM document doesn't exist or the document isn't available to the user. This exception
        /// can be issued by various API operations. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The SSM document doesn't exist or the document isn't available to the user. This exception
        /// can be issued by various API operations. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDocument`](crate::error::InvalidDocument)
        pub fn build(self) -> crate::error::InvalidDocument {
            crate::error::InvalidDocument {
                message: self.message,
            }
        }
    }
}
impl InvalidDocument {
    /// Creates a new builder-style object to manufacture [`InvalidDocument`](crate::error::InvalidDocument)
    pub fn builder() -> crate::error::invalid_document::Builder {
        crate::error::invalid_document::Builder::default()
    }
}

/// <p>The version of the document schema isn't supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDocumentSchemaVersion {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDocumentSchemaVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDocumentSchemaVersion");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDocumentSchemaVersion {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDocumentSchemaVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDocumentSchemaVersion")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDocumentSchemaVersion {}
/// See [`InvalidDocumentSchemaVersion`](crate::error::InvalidDocumentSchemaVersion)
pub mod invalid_document_schema_version {
    /// A builder for [`InvalidDocumentSchemaVersion`](crate::error::InvalidDocumentSchemaVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDocumentSchemaVersion`](crate::error::InvalidDocumentSchemaVersion)
        pub fn build(self) -> crate::error::InvalidDocumentSchemaVersion {
            crate::error::InvalidDocumentSchemaVersion {
                message: self.message,
            }
        }
    }
}
impl InvalidDocumentSchemaVersion {
    /// Creates a new builder-style object to manufacture [`InvalidDocumentSchemaVersion`](crate::error::InvalidDocumentSchemaVersion)
    pub fn builder() -> crate::error::invalid_document_schema_version::Builder {
        crate::error::invalid_document_schema_version::Builder::default()
    }
}

/// <p>The size limit of a document is 64 KB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaxDocumentSizeExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaxDocumentSizeExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaxDocumentSizeExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MaxDocumentSizeExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MaxDocumentSizeExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MaxDocumentSizeExceeded")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for MaxDocumentSizeExceeded {}
/// See [`MaxDocumentSizeExceeded`](crate::error::MaxDocumentSizeExceeded)
pub mod max_document_size_exceeded {
    /// A builder for [`MaxDocumentSizeExceeded`](crate::error::MaxDocumentSizeExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MaxDocumentSizeExceeded`](crate::error::MaxDocumentSizeExceeded)
        pub fn build(self) -> crate::error::MaxDocumentSizeExceeded {
            crate::error::MaxDocumentSizeExceeded {
                message: self.message,
            }
        }
    }
}
impl MaxDocumentSizeExceeded {
    /// Creates a new builder-style object to manufacture [`MaxDocumentSizeExceeded`](crate::error::MaxDocumentSizeExceeded)
    pub fn builder() -> crate::error::max_document_size_exceeded::Builder {
        crate::error::max_document_size_exceeded::Builder::default()
    }
}

/// <p>The content for the document isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDocumentContent {
    /// <p>A description of the validation error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDocumentContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDocumentContent");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDocumentContent {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDocumentContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDocumentContent")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDocumentContent {}
/// See [`InvalidDocumentContent`](crate::error::InvalidDocumentContent)
pub mod invalid_document_content {
    /// A builder for [`InvalidDocumentContent`](crate::error::InvalidDocumentContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the validation error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the validation error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDocumentContent`](crate::error::InvalidDocumentContent)
        pub fn build(self) -> crate::error::InvalidDocumentContent {
            crate::error::InvalidDocumentContent {
                message: self.message,
            }
        }
    }
}
impl InvalidDocumentContent {
    /// Creates a new builder-style object to manufacture [`InvalidDocumentContent`](crate::error::InvalidDocumentContent)
    pub fn builder() -> crate::error::invalid_document_content::Builder {
        crate::error::invalid_document_content::Builder::default()
    }
}

/// <p>The version name has already been used in this document. Specify a different version name,
/// and then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateDocumentVersionName {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateDocumentVersionName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateDocumentVersionName");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateDocumentVersionName {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateDocumentVersionName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateDocumentVersionName")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateDocumentVersionName {}
/// See [`DuplicateDocumentVersionName`](crate::error::DuplicateDocumentVersionName)
pub mod duplicate_document_version_name {
    /// A builder for [`DuplicateDocumentVersionName`](crate::error::DuplicateDocumentVersionName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateDocumentVersionName`](crate::error::DuplicateDocumentVersionName)
        pub fn build(self) -> crate::error::DuplicateDocumentVersionName {
            crate::error::DuplicateDocumentVersionName {
                message: self.message,
            }
        }
    }
}
impl DuplicateDocumentVersionName {
    /// Creates a new builder-style object to manufacture [`DuplicateDocumentVersionName`](crate::error::DuplicateDocumentVersionName)
    pub fn builder() -> crate::error::duplicate_document_version_name::Builder {
        crate::error::duplicate_document_version_name::Builder::default()
    }
}

/// <p>The content of the association document matches another document. Change the content of the
/// document and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateDocumentContent {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateDocumentContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateDocumentContent");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateDocumentContent {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateDocumentContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateDocumentContent")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateDocumentContent {}
/// See [`DuplicateDocumentContent`](crate::error::DuplicateDocumentContent)
pub mod duplicate_document_content {
    /// A builder for [`DuplicateDocumentContent`](crate::error::DuplicateDocumentContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateDocumentContent`](crate::error::DuplicateDocumentContent)
        pub fn build(self) -> crate::error::DuplicateDocumentContent {
            crate::error::DuplicateDocumentContent {
                message: self.message,
            }
        }
    }
}
impl DuplicateDocumentContent {
    /// Creates a new builder-style object to manufacture [`DuplicateDocumentContent`](crate::error::DuplicateDocumentContent)
    pub fn builder() -> crate::error::duplicate_document_content::Builder {
        crate::error::duplicate_document_content::Builder::default()
    }
}

/// <p>The document has too many versions. Delete one or more document versions and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentVersionLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentVersionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentVersionLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DocumentVersionLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DocumentVersionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DocumentVersionLimitExceeded")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for DocumentVersionLimitExceeded {}
/// See [`DocumentVersionLimitExceeded`](crate::error::DocumentVersionLimitExceeded)
pub mod document_version_limit_exceeded {
    /// A builder for [`DocumentVersionLimitExceeded`](crate::error::DocumentVersionLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentVersionLimitExceeded`](crate::error::DocumentVersionLimitExceeded)
        pub fn build(self) -> crate::error::DocumentVersionLimitExceeded {
            crate::error::DocumentVersionLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl DocumentVersionLimitExceeded {
    /// Creates a new builder-style object to manufacture [`DocumentVersionLimitExceeded`](crate::error::DocumentVersionLimitExceeded)
    pub fn builder() -> crate::error::document_version_limit_exceeded::Builder {
        crate::error::document_version_limit_exceeded::Builder::default()
    }
}

/// <p>The updated status is the same as the current status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatusUnchanged {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StatusUnchanged {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatusUnchanged");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StatusUnchanged {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StatusUnchanged {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StatusUnchanged")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for StatusUnchanged {}
/// See [`StatusUnchanged`](crate::error::StatusUnchanged)
pub mod status_unchanged {
    /// A builder for [`StatusUnchanged`](crate::error::StatusUnchanged)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StatusUnchanged`](crate::error::StatusUnchanged)
        pub fn build(self) -> crate::error::StatusUnchanged {
            crate::error::StatusUnchanged {
                message: self.message,
            }
        }
    }
}
impl StatusUnchanged {
    /// Creates a new builder-style object to manufacture [`StatusUnchanged`](crate::error::StatusUnchanged)
    pub fn builder() -> crate::error::status_unchanged::Builder {
        crate::error::status_unchanged::Builder::default()
    }
}

/// <p>The specified association doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociationDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociationDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociationDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AssociationDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AssociationDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AssociationDoesNotExist")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for AssociationDoesNotExist {}
/// See [`AssociationDoesNotExist`](crate::error::AssociationDoesNotExist)
pub mod association_does_not_exist {
    /// A builder for [`AssociationDoesNotExist`](crate::error::AssociationDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociationDoesNotExist`](crate::error::AssociationDoesNotExist)
        pub fn build(self) -> crate::error::AssociationDoesNotExist {
            crate::error::AssociationDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl AssociationDoesNotExist {
    /// Creates a new builder-style object to manufacture [`AssociationDoesNotExist`](crate::error::AssociationDoesNotExist)
    pub fn builder() -> crate::error::association_does_not_exist::Builder {
        crate::error::association_does_not_exist::Builder::default()
    }
}

/// <p>The update isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidUpdate {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidUpdate");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidUpdate {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidUpdate")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidUpdate {}
/// See [`InvalidUpdate`](crate::error::InvalidUpdate)
pub mod invalid_update {
    /// A builder for [`InvalidUpdate`](crate::error::InvalidUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidUpdate`](crate::error::InvalidUpdate)
        pub fn build(self) -> crate::error::InvalidUpdate {
            crate::error::InvalidUpdate {
                message: self.message,
            }
        }
    }
}
impl InvalidUpdate {
    /// Creates a new builder-style object to manufacture [`InvalidUpdate`](crate::error::InvalidUpdate)
    pub fn builder() -> crate::error::invalid_update::Builder {
        crate::error::invalid_update::Builder::default()
    }
}

/// <p>The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might
/// not have permission to perform the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTarget {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTarget");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTarget {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTarget")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTarget {}
/// See [`InvalidTarget`](crate::error::InvalidTarget)
pub mod invalid_target {
    /// A builder for [`InvalidTarget`](crate::error::InvalidTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTarget`](crate::error::InvalidTarget)
        pub fn build(self) -> crate::error::InvalidTarget {
            crate::error::InvalidTarget {
                message: self.message,
            }
        }
    }
}
impl InvalidTarget {
    /// Creates a new builder-style object to manufacture [`InvalidTarget`](crate::error::InvalidTarget)
    pub fn builder() -> crate::error::invalid_target::Builder {
        crate::error::invalid_target::Builder::default()
    }
}

/// <p>The schedule is invalid. Verify your cron or rate expression and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSchedule {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSchedule");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSchedule {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSchedule")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSchedule {}
/// See [`InvalidSchedule`](crate::error::InvalidSchedule)
pub mod invalid_schedule {
    /// A builder for [`InvalidSchedule`](crate::error::InvalidSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSchedule`](crate::error::InvalidSchedule)
        pub fn build(self) -> crate::error::InvalidSchedule {
            crate::error::InvalidSchedule {
                message: self.message,
            }
        }
    }
}
impl InvalidSchedule {
    /// Creates a new builder-style object to manufacture [`InvalidSchedule`](crate::error::InvalidSchedule)
    pub fn builder() -> crate::error::invalid_schedule::Builder {
        crate::error::invalid_schedule::Builder::default()
    }
}

/// <p>You must specify values for all required parameters in the Amazon Web Services Systems Manager document (SSM
/// document). You can only supply values to parameters defined in the SSM document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameters {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameters");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameters {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameters")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameters {}
/// See [`InvalidParameters`](crate::error::InvalidParameters)
pub mod invalid_parameters {
    /// A builder for [`InvalidParameters`](crate::error::InvalidParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameters`](crate::error::InvalidParameters)
        pub fn build(self) -> crate::error::InvalidParameters {
            crate::error::InvalidParameters {
                message: self.message,
            }
        }
    }
}
impl InvalidParameters {
    /// Creates a new builder-style object to manufacture [`InvalidParameters`](crate::error::InvalidParameters)
    pub fn builder() -> crate::error::invalid_parameters::Builder {
        crate::error::invalid_parameters::Builder::default()
    }
}

/// <p>The output location isn't valid or doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOutputLocation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOutputLocation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOutputLocation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOutputLocation")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOutputLocation {}
/// See [`InvalidOutputLocation`](crate::error::InvalidOutputLocation)
pub mod invalid_output_location {
    /// A builder for [`InvalidOutputLocation`](crate::error::InvalidOutputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOutputLocation`](crate::error::InvalidOutputLocation)
        pub fn build(self) -> crate::error::InvalidOutputLocation {
            crate::error::InvalidOutputLocation {
                message: self.message,
            }
        }
    }
}
impl InvalidOutputLocation {
    /// Creates a new builder-style object to manufacture [`InvalidOutputLocation`](crate::error::InvalidOutputLocation)
    pub fn builder() -> crate::error::invalid_output_location::Builder {
        crate::error::invalid_output_location::Builder::default()
    }
}

/// <p>The version you specified isn't valid. Use ListAssociationVersions to view all versions of
/// an association according to the association ID. Or, use the <code>$LATEST</code> parameter to
/// view the latest version of the association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAssociationVersion {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAssociationVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAssociationVersion");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAssociationVersion {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAssociationVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAssociationVersion")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAssociationVersion {}
/// See [`InvalidAssociationVersion`](crate::error::InvalidAssociationVersion)
pub mod invalid_association_version {
    /// A builder for [`InvalidAssociationVersion`](crate::error::InvalidAssociationVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAssociationVersion`](crate::error::InvalidAssociationVersion)
        pub fn build(self) -> crate::error::InvalidAssociationVersion {
            crate::error::InvalidAssociationVersion {
                message: self.message,
            }
        }
    }
}
impl InvalidAssociationVersion {
    /// Creates a new builder-style object to manufacture [`InvalidAssociationVersion`](crate::error::InvalidAssociationVersion)
    pub fn builder() -> crate::error::invalid_association_version::Builder {
        crate::error::invalid_association_version::Builder::default()
    }
}

/// <p>You have reached the maximum number versions allowed for an association. Each association
/// has a limit of 1,000 versions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociationVersionLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociationVersionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociationVersionLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AssociationVersionLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AssociationVersionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AssociationVersionLimitExceeded")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for AssociationVersionLimitExceeded {}
/// See [`AssociationVersionLimitExceeded`](crate::error::AssociationVersionLimitExceeded)
pub mod association_version_limit_exceeded {
    /// A builder for [`AssociationVersionLimitExceeded`](crate::error::AssociationVersionLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociationVersionLimitExceeded`](crate::error::AssociationVersionLimitExceeded)
        pub fn build(self) -> crate::error::AssociationVersionLimitExceeded {
            crate::error::AssociationVersionLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl AssociationVersionLimitExceeded {
    /// Creates a new builder-style object to manufacture [`AssociationVersionLimitExceeded`](crate::error::AssociationVersionLimitExceeded)
    pub fn builder() -> crate::error::association_version_limit_exceeded::Builder {
        crate::error::association_version_limit_exceeded::Builder::default()
    }
}

/// <p>The specified parameter version wasn't found. Verify the parameter name and version, and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterVersionNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterVersionNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterVersionNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterVersionNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterVersionNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterVersionNotFound")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterVersionNotFound {}
/// See [`ParameterVersionNotFound`](crate::error::ParameterVersionNotFound)
pub mod parameter_version_not_found {
    /// A builder for [`ParameterVersionNotFound`](crate::error::ParameterVersionNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterVersionNotFound`](crate::error::ParameterVersionNotFound)
        pub fn build(self) -> crate::error::ParameterVersionNotFound {
            crate::error::ParameterVersionNotFound {
                message: self.message,
            }
        }
    }
}
impl ParameterVersionNotFound {
    /// Creates a new builder-style object to manufacture [`ParameterVersionNotFound`](crate::error::ParameterVersionNotFound)
    pub fn builder() -> crate::error::parameter_version_not_found::Builder {
        crate::error::parameter_version_not_found::Builder::default()
    }
}

/// <p>The parameter couldn't be found. Verify the name and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterNotFound")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterNotFound {}
/// See [`ParameterNotFound`](crate::error::ParameterNotFound)
pub mod parameter_not_found {
    /// A builder for [`ParameterNotFound`](crate::error::ParameterNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterNotFound`](crate::error::ParameterNotFound)
        pub fn build(self) -> crate::error::ParameterNotFound {
            crate::error::ParameterNotFound {
                message: self.message,
            }
        }
    }
}
impl ParameterNotFound {
    /// Creates a new builder-style object to manufacture [`ParameterNotFound`](crate::error::ParameterNotFound)
    pub fn builder() -> crate::error::parameter_not_found::Builder {
        crate::error::parameter_not_found::Builder::default()
    }
}

/// <p>The specified update status operation isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAutomationStatusUpdateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAutomationStatusUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAutomationStatusUpdateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAutomationStatusUpdateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAutomationStatusUpdateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAutomationStatusUpdateException")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAutomationStatusUpdateException {}
/// See [`InvalidAutomationStatusUpdateException`](crate::error::InvalidAutomationStatusUpdateException)
pub mod invalid_automation_status_update_exception {
    /// A builder for [`InvalidAutomationStatusUpdateException`](crate::error::InvalidAutomationStatusUpdateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAutomationStatusUpdateException`](crate::error::InvalidAutomationStatusUpdateException)
        pub fn build(self) -> crate::error::InvalidAutomationStatusUpdateException {
            crate::error::InvalidAutomationStatusUpdateException {
                message: self.message,
            }
        }
    }
}
impl InvalidAutomationStatusUpdateException {
    /// Creates a new builder-style object to manufacture [`InvalidAutomationStatusUpdateException`](crate::error::InvalidAutomationStatusUpdateException)
    pub fn builder() -> crate::error::invalid_automation_status_update_exception::Builder {
        crate::error::invalid_automation_status_update_exception::Builder::default()
    }
}

/// <p>There is no automation execution information for the requested automation execution
/// ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomationExecutionNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomationExecutionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomationExecutionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AutomationExecutionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AutomationExecutionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AutomationExecutionNotFoundException")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for AutomationExecutionNotFoundException {}
/// See [`AutomationExecutionNotFoundException`](crate::error::AutomationExecutionNotFoundException)
pub mod automation_execution_not_found_exception {
    /// A builder for [`AutomationExecutionNotFoundException`](crate::error::AutomationExecutionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomationExecutionNotFoundException`](crate::error::AutomationExecutionNotFoundException)
        pub fn build(self) -> crate::error::AutomationExecutionNotFoundException {
            crate::error::AutomationExecutionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AutomationExecutionNotFoundException {
    /// Creates a new builder-style object to manufacture [`AutomationExecutionNotFoundException`](crate::error::AutomationExecutionNotFoundException)
    pub fn builder() -> crate::error::automation_execution_not_found_exception::Builder {
        crate::error::automation_execution_not_found_exception::Builder::default()
    }
}

/// <p>The specified target managed node for the session isn't fully configured for use with Session Manager. For
/// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html">Getting started with
/// Session Manager</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. This error is also returned if you
/// attempt to start a session on a managed node that is located in a different account or Region</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetNotConnected {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetNotConnected {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetNotConnected");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TargetNotConnected {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TargetNotConnected {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TargetNotConnected")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for TargetNotConnected {}
/// See [`TargetNotConnected`](crate::error::TargetNotConnected)
pub mod target_not_connected {
    /// A builder for [`TargetNotConnected`](crate::error::TargetNotConnected)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetNotConnected`](crate::error::TargetNotConnected)
        pub fn build(self) -> crate::error::TargetNotConnected {
            crate::error::TargetNotConnected {
                message: self.message,
            }
        }
    }
}
impl TargetNotConnected {
    /// Creates a new builder-style object to manufacture [`TargetNotConnected`](crate::error::TargetNotConnected)
    pub fn builder() -> crate::error::target_not_connected::Builder {
        crate::error::target_not_connected::Builder::default()
    }
}

/// <p>The supplied parameters for invoking the specified Automation runbook are incorrect. For
/// example, they may not match the set of parameters permitted for the specified Automation
/// document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAutomationExecutionParametersException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAutomationExecutionParametersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAutomationExecutionParametersException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAutomationExecutionParametersException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAutomationExecutionParametersException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAutomationExecutionParametersException")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAutomationExecutionParametersException {}
/// See [`InvalidAutomationExecutionParametersException`](crate::error::InvalidAutomationExecutionParametersException)
pub mod invalid_automation_execution_parameters_exception {
    /// A builder for [`InvalidAutomationExecutionParametersException`](crate::error::InvalidAutomationExecutionParametersException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAutomationExecutionParametersException`](crate::error::InvalidAutomationExecutionParametersException)
        pub fn build(self) -> crate::error::InvalidAutomationExecutionParametersException {
            crate::error::InvalidAutomationExecutionParametersException {
                message: self.message,
            }
        }
    }
}
impl InvalidAutomationExecutionParametersException {
    /// Creates a new builder-style object to manufacture [`InvalidAutomationExecutionParametersException`](crate::error::InvalidAutomationExecutionParametersException)
    pub fn builder() -> crate::error::invalid_automation_execution_parameters_exception::Builder {
        crate::error::invalid_automation_execution_parameters_exception::Builder::default()
    }
}

/// <p>Error returned when an idempotent operation is retried and the parameters don't match the
/// original call to the API with the same idempotency token. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotentParameterMismatch {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdempotentParameterMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotentParameterMismatch");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdempotentParameterMismatch {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotentParameterMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotentParameterMismatch")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotentParameterMismatch {}
/// See [`IdempotentParameterMismatch`](crate::error::IdempotentParameterMismatch)
pub mod idempotent_parameter_mismatch {
    /// A builder for [`IdempotentParameterMismatch`](crate::error::IdempotentParameterMismatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotentParameterMismatch`](crate::error::IdempotentParameterMismatch)
        pub fn build(self) -> crate::error::IdempotentParameterMismatch {
            crate::error::IdempotentParameterMismatch {
                message: self.message,
            }
        }
    }
}
impl IdempotentParameterMismatch {
    /// Creates a new builder-style object to manufacture [`IdempotentParameterMismatch`](crate::error::IdempotentParameterMismatch)
    pub fn builder() -> crate::error::idempotent_parameter_mismatch::Builder {
        crate::error::idempotent_parameter_mismatch::Builder::default()
    }
}

/// <p>The number of simultaneously running Automation executions exceeded the allowable
/// limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomationExecutionLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomationExecutionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomationExecutionLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AutomationExecutionLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AutomationExecutionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AutomationExecutionLimitExceededException")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for AutomationExecutionLimitExceededException {}
/// See [`AutomationExecutionLimitExceededException`](crate::error::AutomationExecutionLimitExceededException)
pub mod automation_execution_limit_exceeded_exception {
    /// A builder for [`AutomationExecutionLimitExceededException`](crate::error::AutomationExecutionLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomationExecutionLimitExceededException`](crate::error::AutomationExecutionLimitExceededException)
        pub fn build(self) -> crate::error::AutomationExecutionLimitExceededException {
            crate::error::AutomationExecutionLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl AutomationExecutionLimitExceededException {
    /// Creates a new builder-style object to manufacture [`AutomationExecutionLimitExceededException`](crate::error::AutomationExecutionLimitExceededException)
    pub fn builder() -> crate::error::automation_execution_limit_exceeded_exception::Builder {
        crate::error::automation_execution_limit_exceeded_exception::Builder::default()
    }
}

/// <p>An Automation runbook with the specified name and version couldn't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomationDefinitionVersionNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomationDefinitionVersionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomationDefinitionVersionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AutomationDefinitionVersionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AutomationDefinitionVersionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AutomationDefinitionVersionNotFoundException")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for AutomationDefinitionVersionNotFoundException {}
/// See [`AutomationDefinitionVersionNotFoundException`](crate::error::AutomationDefinitionVersionNotFoundException)
pub mod automation_definition_version_not_found_exception {
    /// A builder for [`AutomationDefinitionVersionNotFoundException`](crate::error::AutomationDefinitionVersionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomationDefinitionVersionNotFoundException`](crate::error::AutomationDefinitionVersionNotFoundException)
        pub fn build(self) -> crate::error::AutomationDefinitionVersionNotFoundException {
            crate::error::AutomationDefinitionVersionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AutomationDefinitionVersionNotFoundException {
    /// Creates a new builder-style object to manufacture [`AutomationDefinitionVersionNotFoundException`](crate::error::AutomationDefinitionVersionNotFoundException)
    pub fn builder() -> crate::error::automation_definition_version_not_found_exception::Builder {
        crate::error::automation_definition_version_not_found_exception::Builder::default()
    }
}

/// <p>An Automation runbook with the specified name couldn't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomationDefinitionNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomationDefinitionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomationDefinitionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AutomationDefinitionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AutomationDefinitionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AutomationDefinitionNotFoundException")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for AutomationDefinitionNotFoundException {}
/// See [`AutomationDefinitionNotFoundException`](crate::error::AutomationDefinitionNotFoundException)
pub mod automation_definition_not_found_exception {
    /// A builder for [`AutomationDefinitionNotFoundException`](crate::error::AutomationDefinitionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomationDefinitionNotFoundException`](crate::error::AutomationDefinitionNotFoundException)
        pub fn build(self) -> crate::error::AutomationDefinitionNotFoundException {
            crate::error::AutomationDefinitionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AutomationDefinitionNotFoundException {
    /// Creates a new builder-style object to manufacture [`AutomationDefinitionNotFoundException`](crate::error::AutomationDefinitionNotFoundException)
    pub fn builder() -> crate::error::automation_definition_not_found_exception::Builder {
        crate::error::automation_definition_not_found_exception::Builder::default()
    }
}

/// <p>Indicates that the Change Manager change template used in the change request was rejected or is
/// still in a pending state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomationDefinitionNotApprovedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomationDefinitionNotApprovedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomationDefinitionNotApprovedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AutomationDefinitionNotApprovedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AutomationDefinitionNotApprovedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AutomationDefinitionNotApprovedException")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for AutomationDefinitionNotApprovedException {}
/// See [`AutomationDefinitionNotApprovedException`](crate::error::AutomationDefinitionNotApprovedException)
pub mod automation_definition_not_approved_exception {
    /// A builder for [`AutomationDefinitionNotApprovedException`](crate::error::AutomationDefinitionNotApprovedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomationDefinitionNotApprovedException`](crate::error::AutomationDefinitionNotApprovedException)
        pub fn build(self) -> crate::error::AutomationDefinitionNotApprovedException {
            crate::error::AutomationDefinitionNotApprovedException {
                message: self.message,
            }
        }
    }
}
impl AutomationDefinitionNotApprovedException {
    /// Creates a new builder-style object to manufacture [`AutomationDefinitionNotApprovedException`](crate::error::AutomationDefinitionNotApprovedException)
    pub fn builder() -> crate::error::automation_definition_not_approved_exception::Builder {
        crate::error::automation_definition_not_approved_exception::Builder::default()
    }
}

/// <p>The association isn't valid or doesn't exist. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAssociation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAssociation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAssociation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAssociation")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAssociation {}
/// See [`InvalidAssociation`](crate::error::InvalidAssociation)
pub mod invalid_association {
    /// A builder for [`InvalidAssociation`](crate::error::InvalidAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAssociation`](crate::error::InvalidAssociation)
        pub fn build(self) -> crate::error::InvalidAssociation {
            crate::error::InvalidAssociation {
                message: self.message,
            }
        }
    }
}
impl InvalidAssociation {
    /// Creates a new builder-style object to manufacture [`InvalidAssociation`](crate::error::InvalidAssociation)
    pub fn builder() -> crate::error::invalid_association::Builder {
        crate::error::invalid_association::Builder::default()
    }
}

/// <p>The document doesn't support the platform type of the given managed node ID(s). For example, you
/// sent an document for a Windows managed node to a Linux node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedPlatformType {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedPlatformType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedPlatformType");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedPlatformType {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedPlatformType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedPlatformType")?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedPlatformType {}
/// See [`UnsupportedPlatformType`](crate::error::UnsupportedPlatformType)
pub mod unsupported_platform_type {
    /// A builder for [`UnsupportedPlatformType`](crate::error::UnsupportedPlatformType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedPlatformType`](crate::error::UnsupportedPlatformType)
        pub fn build(self) -> crate::error::UnsupportedPlatformType {
            crate::error::UnsupportedPlatformType {
                message: self.message,
            }
        }
    }
}
impl UnsupportedPlatformType {
    /// Creates a new builder-style object to manufacture [`UnsupportedPlatformType`](crate::error::UnsupportedPlatformType)
    pub fn builder() -> crate::error::unsupported_platform_type::Builder {
        crate::error::unsupported_platform_type::Builder::default()
    }
}

/// <p>The role name can't contain invalid characters. Also verify that you specified an IAM role for notifications that includes the required trust policy. For information about
/// configuring the IAM role for Run Command notifications, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring Amazon SNS Notifications for Run Command</a> in the
/// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRole {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRole");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRole {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRole")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRole {}
/// See [`InvalidRole`](crate::error::InvalidRole)
pub mod invalid_role {
    /// A builder for [`InvalidRole`](crate::error::InvalidRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRole`](crate::error::InvalidRole)
        pub fn build(self) -> crate::error::InvalidRole {
            crate::error::InvalidRole {
                message: self.message,
            }
        }
    }
}
impl InvalidRole {
    /// Creates a new builder-style object to manufacture [`InvalidRole`](crate::error::InvalidRole)
    pub fn builder() -> crate::error::invalid_role::Builder {
        crate::error::invalid_role::Builder::default()
    }
}

/// <p>The S3 bucket doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOutputFolder {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOutputFolder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOutputFolder");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOutputFolder {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOutputFolder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOutputFolder")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOutputFolder {}
/// See [`InvalidOutputFolder`](crate::error::InvalidOutputFolder)
pub mod invalid_output_folder {
    /// A builder for [`InvalidOutputFolder`](crate::error::InvalidOutputFolder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOutputFolder`](crate::error::InvalidOutputFolder)
        pub fn build(self) -> crate::error::InvalidOutputFolder {
            crate::error::InvalidOutputFolder {
                message: self.message,
            }
        }
    }
}
impl InvalidOutputFolder {
    /// Creates a new builder-style object to manufacture [`InvalidOutputFolder`](crate::error::InvalidOutputFolder)
    pub fn builder() -> crate::error::invalid_output_folder::Builder {
        crate::error::invalid_output_folder::Builder::default()
    }
}

/// <p>One or more configuration items isn't valid. Verify that a valid Amazon Resource Name (ARN)
/// was provided for an Amazon Simple Notification Service topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNotificationConfig {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNotificationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNotificationConfig");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNotificationConfig {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNotificationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNotificationConfig")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNotificationConfig {}
/// See [`InvalidNotificationConfig`](crate::error::InvalidNotificationConfig)
pub mod invalid_notification_config {
    /// A builder for [`InvalidNotificationConfig`](crate::error::InvalidNotificationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNotificationConfig`](crate::error::InvalidNotificationConfig)
        pub fn build(self) -> crate::error::InvalidNotificationConfig {
            crate::error::InvalidNotificationConfig {
                message: self.message,
            }
        }
    }
}
impl InvalidNotificationConfig {
    /// Creates a new builder-style object to manufacture [`InvalidNotificationConfig`](crate::error::InvalidNotificationConfig)
    pub fn builder() -> crate::error::invalid_notification_config::Builder {
        crate::error::invalid_notification_config::Builder::default()
    }
}

/// <p>You can't specify a managed node ID in more than one association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateInstanceId {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateInstanceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateInstanceId");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateInstanceId {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateInstanceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateInstanceId")?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateInstanceId {}
/// See [`DuplicateInstanceId`](crate::error::DuplicateInstanceId)
pub mod duplicate_instance_id {
    /// A builder for [`DuplicateInstanceId`](crate::error::DuplicateInstanceId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateInstanceId`](crate::error::DuplicateInstanceId)
        pub fn build(self) -> crate::error::DuplicateInstanceId {
            crate::error::DuplicateInstanceId {
                message: self.message,
            }
        }
    }
}
impl DuplicateInstanceId {
    /// Creates a new builder-style object to manufacture [`DuplicateInstanceId`](crate::error::DuplicateInstanceId)
    pub fn builder() -> crate::error::duplicate_instance_id::Builder {
        crate::error::duplicate_instance_id::Builder::default()
    }
}

/// <p>The signal isn't valid for the current Automation execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAutomationSignalException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAutomationSignalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAutomationSignalException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAutomationSignalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAutomationSignalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAutomationSignalException")?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAutomationSignalException {}
/// See [`InvalidAutomationSignalException`](crate::error::InvalidAutomationSignalException)
pub mod invalid_automation_signal_exception {
    /// A builder for [`InvalidAutomationSignalException`](crate::error::InvalidAutomationSignalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAutomationSignalException`](crate::error::InvalidAutomationSignalException)
        pub fn build(self) -> crate::error::InvalidAutomationSignalException {
            crate::error::InvalidAutomationSignalException {
                message: self.message,
            }
        }
    }
}
impl InvalidAutomationSignalException {
    /// Creates a new builder-style object to manufacture [`InvalidAutomationSignalException`](crate::error::InvalidAutomationSignalException)
    pub fn builder() -> crate::error::invalid_automation_signal_exception::Builder {
        crate::error::invalid_automation_signal_exception::Builder::default()
    }
}

/// <p>The specified step name and execution ID don't exist. Verify the information and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomationStepNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomationStepNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomationStepNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AutomationStepNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AutomationStepNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AutomationStepNotFoundException")?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for AutomationStepNotFoundException {}
/// See [`AutomationStepNotFoundException`](crate::error::AutomationStepNotFoundException)
pub mod automation_step_not_found_exception {
    /// A builder for [`AutomationStepNotFoundException`](crate::error::AutomationStepNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomationStepNotFoundException`](crate::error::AutomationStepNotFoundException)
        pub fn build(self) -> crate::error::AutomationStepNotFoundException {
            crate::error::AutomationStepNotFoundException {
                message: self.message,
            }
        }
    }
}
impl AutomationStepNotFoundException {
    /// Creates a new builder-style object to manufacture [`AutomationStepNotFoundException`](crate::error::AutomationStepNotFoundException)
    pub fn builder() -> crate::error::automation_step_not_found_exception::Builder {
        crate::error::automation_step_not_found_exception::Builder::default()
    }
}

/// <p>The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the
/// instance must be a registered managed node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceType {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceType");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceType {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceType")?;
        if let Some(inner_54) = &self.message {
            write!(f, ": {}", inner_54)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceType {}
/// See [`InvalidResourceType`](crate::error::InvalidResourceType)
pub mod invalid_resource_type {
    /// A builder for [`InvalidResourceType`](crate::error::InvalidResourceType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceType`](crate::error::InvalidResourceType)
        pub fn build(self) -> crate::error::InvalidResourceType {
            crate::error::InvalidResourceType {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceType {
    /// Creates a new builder-style object to manufacture [`InvalidResourceType`](crate::error::InvalidResourceType)
    pub fn builder() -> crate::error::invalid_resource_type::Builder {
        crate::error::invalid_resource_type::Builder::default()
    }
}

/// <p>The resource ID isn't valid. Verify that you entered the correct ID and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceId {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceId");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceId {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceId")?;
        if let Some(inner_55) = &self.message {
            write!(f, ": {}", inner_55)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceId {}
/// See [`InvalidResourceId`](crate::error::InvalidResourceId)
pub mod invalid_resource_id {
    /// A builder for [`InvalidResourceId`](crate::error::InvalidResourceId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceId`](crate::error::InvalidResourceId)
        pub fn build(self) -> crate::error::InvalidResourceId {
            crate::error::InvalidResourceId {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceId {
    /// Creates a new builder-style object to manufacture [`InvalidResourceId`](crate::error::InvalidResourceId)
    pub fn builder() -> crate::error::invalid_resource_id::Builder {
        crate::error::invalid_resource_id::Builder::default()
    }
}

/// <p>Error returned when the caller has exceeded the default resource quotas. For example, too
/// many maintenance windows or patch baselines have been created.</p>
/// <p>For information about resource quotas in Systems Manager, see <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the
/// <i>Amazon Web Services General Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_56) = &self.message {
            write!(f, ": {}", inner_56)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You attempted to register a <code>LAMBDA</code> or <code>STEP_FUNCTIONS</code> task in a
/// region where the corresponding service isn't available. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeatureNotAvailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FeatureNotAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeatureNotAvailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FeatureNotAvailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FeatureNotAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FeatureNotAvailableException")?;
        if let Some(inner_57) = &self.message {
            write!(f, ": {}", inner_57)?;
        }
        Ok(())
    }
}
impl std::error::Error for FeatureNotAvailableException {}
/// See [`FeatureNotAvailableException`](crate::error::FeatureNotAvailableException)
pub mod feature_not_available_exception {
    /// A builder for [`FeatureNotAvailableException`](crate::error::FeatureNotAvailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FeatureNotAvailableException`](crate::error::FeatureNotAvailableException)
        pub fn build(self) -> crate::error::FeatureNotAvailableException {
            crate::error::FeatureNotAvailableException {
                message: self.message,
            }
        }
    }
}
impl FeatureNotAvailableException {
    /// Creates a new builder-style object to manufacture [`FeatureNotAvailableException`](crate::error::FeatureNotAvailableException)
    pub fn builder() -> crate::error::feature_not_available_exception::Builder {
        crate::error::feature_not_available_exception::Builder::default()
    }
}

/// <p>Error returned if an attempt is made to register a patch group with a patch baseline that is
/// already registered with a different patch baseline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_58) = &self.message {
            write!(f, ": {}", inner_58)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>The parameter type isn't supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedParameterType {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedParameterType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedParameterType");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedParameterType {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedParameterType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedParameterType")?;
        if let Some(inner_59) = &self.message {
            write!(f, ": {}", inner_59)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedParameterType {}
/// See [`UnsupportedParameterType`](crate::error::UnsupportedParameterType)
pub mod unsupported_parameter_type {
    /// A builder for [`UnsupportedParameterType`](crate::error::UnsupportedParameterType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedParameterType`](crate::error::UnsupportedParameterType)
        pub fn build(self) -> crate::error::UnsupportedParameterType {
            crate::error::UnsupportedParameterType {
                message: self.message,
            }
        }
    }
}
impl UnsupportedParameterType {
    /// Creates a new builder-style object to manufacture [`UnsupportedParameterType`](crate::error::UnsupportedParameterType)
    pub fn builder() -> crate::error::unsupported_parameter_type::Builder {
        crate::error::unsupported_parameter_type::Builder::default()
    }
}

/// <p>You specified more than the maximum number of allowed policies for the parameter. The
/// maximum is 10.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PoliciesLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PoliciesLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PoliciesLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PoliciesLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PoliciesLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PoliciesLimitExceededException")?;
        if let Some(inner_60) = &self.message {
            write!(f, ": {}", inner_60)?;
        }
        Ok(())
    }
}
impl std::error::Error for PoliciesLimitExceededException {}
/// See [`PoliciesLimitExceededException`](crate::error::PoliciesLimitExceededException)
pub mod policies_limit_exceeded_exception {
    /// A builder for [`PoliciesLimitExceededException`](crate::error::PoliciesLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PoliciesLimitExceededException`](crate::error::PoliciesLimitExceededException)
        pub fn build(self) -> crate::error::PoliciesLimitExceededException {
            crate::error::PoliciesLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl PoliciesLimitExceededException {
    /// Creates a new builder-style object to manufacture [`PoliciesLimitExceededException`](crate::error::PoliciesLimitExceededException)
    pub fn builder() -> crate::error::policies_limit_exceeded_exception::Builder {
        crate::error::policies_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The parameter name isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterPatternMismatchException {
    /// <p>The parameter name isn't valid.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterPatternMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterPatternMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterPatternMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterPatternMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterPatternMismatchException")?;
        if let Some(inner_61) = &self.message {
            write!(f, ": {}", inner_61)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterPatternMismatchException {}
/// See [`ParameterPatternMismatchException`](crate::error::ParameterPatternMismatchException)
pub mod parameter_pattern_mismatch_exception {
    /// A builder for [`ParameterPatternMismatchException`](crate::error::ParameterPatternMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The parameter name isn't valid.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The parameter name isn't valid.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterPatternMismatchException`](crate::error::ParameterPatternMismatchException)
        pub fn build(self) -> crate::error::ParameterPatternMismatchException {
            crate::error::ParameterPatternMismatchException {
                message: self.message,
            }
        }
    }
}
impl ParameterPatternMismatchException {
    /// Creates a new builder-style object to manufacture [`ParameterPatternMismatchException`](crate::error::ParameterPatternMismatchException)
    pub fn builder() -> crate::error::parameter_pattern_mismatch_exception::Builder {
        crate::error::parameter_pattern_mismatch_exception::Builder::default()
    }
}

/// <p>Parameter Store retains the 100 most recently created versions of a parameter. After this
/// number of versions has been created, Parameter Store deletes the oldest version when a new one is
/// created. However, if the oldest version has a <i>label</i> attached to it,
/// Parameter Store won't delete the version and instead presents this error message:</p>
/// <p>
/// <code>An error occurred (ParameterMaxVersionLimitExceeded) when calling the PutParameter
/// operation: You attempted to create a new version of <i>parameter-name</i> by
/// calling the PutParameter API with the overwrite flag. Version
/// <i>version-number</i>, the oldest version, can't be deleted because it has a
/// label associated with it. Move the label to another version of the parameter, and try
/// again.</code>
/// </p>
/// <p>This safeguard is to prevent parameter versions with mission critical labels assigned to
/// them from being deleted. To continue creating new parameters, first move the label from the
/// oldest version of the parameter to a newer one for use in your operations. For information about
/// moving parameter labels, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move">Move a parameter label (console)</a> or <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move">Move a parameter label (CLI)</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterMaxVersionLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterMaxVersionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterMaxVersionLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterMaxVersionLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterMaxVersionLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterMaxVersionLimitExceeded")?;
        if let Some(inner_62) = &self.message {
            write!(f, ": {}", inner_62)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterMaxVersionLimitExceeded {}
/// See [`ParameterMaxVersionLimitExceeded`](crate::error::ParameterMaxVersionLimitExceeded)
pub mod parameter_max_version_limit_exceeded {
    /// A builder for [`ParameterMaxVersionLimitExceeded`](crate::error::ParameterMaxVersionLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterMaxVersionLimitExceeded`](crate::error::ParameterMaxVersionLimitExceeded)
        pub fn build(self) -> crate::error::ParameterMaxVersionLimitExceeded {
            crate::error::ParameterMaxVersionLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl ParameterMaxVersionLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ParameterMaxVersionLimitExceeded`](crate::error::ParameterMaxVersionLimitExceeded)
    pub fn builder() -> crate::error::parameter_max_version_limit_exceeded::Builder {
        crate::error::parameter_max_version_limit_exceeded::Builder::default()
    }
}

/// <p>You have exceeded the number of parameters for this Amazon Web Services account. Delete one or more
/// parameters and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterLimitExceeded")?;
        if let Some(inner_63) = &self.message {
            write!(f, ": {}", inner_63)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterLimitExceeded {}
/// See [`ParameterLimitExceeded`](crate::error::ParameterLimitExceeded)
pub mod parameter_limit_exceeded {
    /// A builder for [`ParameterLimitExceeded`](crate::error::ParameterLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterLimitExceeded`](crate::error::ParameterLimitExceeded)
        pub fn build(self) -> crate::error::ParameterLimitExceeded {
            crate::error::ParameterLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl ParameterLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ParameterLimitExceeded`](crate::error::ParameterLimitExceeded)
    pub fn builder() -> crate::error::parameter_limit_exceeded::Builder {
        crate::error::parameter_limit_exceeded::Builder::default()
    }
}

/// <p>The parameter already exists. You can't create duplicate parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ParameterAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ParameterAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ParameterAlreadyExists")?;
        if let Some(inner_64) = &self.message {
            write!(f, ": {}", inner_64)?;
        }
        Ok(())
    }
}
impl std::error::Error for ParameterAlreadyExists {}
/// See [`ParameterAlreadyExists`](crate::error::ParameterAlreadyExists)
pub mod parameter_already_exists {
    /// A builder for [`ParameterAlreadyExists`](crate::error::ParameterAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterAlreadyExists`](crate::error::ParameterAlreadyExists)
        pub fn build(self) -> crate::error::ParameterAlreadyExists {
            crate::error::ParameterAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl ParameterAlreadyExists {
    /// Creates a new builder-style object to manufacture [`ParameterAlreadyExists`](crate::error::ParameterAlreadyExists)
    pub fn builder() -> crate::error::parameter_already_exists::Builder {
        crate::error::parameter_already_exists::Builder::default()
    }
}

/// <p>The policy type isn't supported. Parameter Store supports the following policy types:
/// Expiration, ExpirationNotification, and NoChangeNotification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPolicyTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPolicyTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPolicyTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPolicyTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPolicyTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPolicyTypeException")?;
        if let Some(inner_65) = &self.message {
            write!(f, ": {}", inner_65)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPolicyTypeException {}
/// See [`InvalidPolicyTypeException`](crate::error::InvalidPolicyTypeException)
pub mod invalid_policy_type_exception {
    /// A builder for [`InvalidPolicyTypeException`](crate::error::InvalidPolicyTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPolicyTypeException`](crate::error::InvalidPolicyTypeException)
        pub fn build(self) -> crate::error::InvalidPolicyTypeException {
            crate::error::InvalidPolicyTypeException {
                message: self.message,
            }
        }
    }
}
impl InvalidPolicyTypeException {
    /// Creates a new builder-style object to manufacture [`InvalidPolicyTypeException`](crate::error::InvalidPolicyTypeException)
    pub fn builder() -> crate::error::invalid_policy_type_exception::Builder {
        crate::error::invalid_policy_type_exception::Builder::default()
    }
}

/// <p>A policy attribute or its value is invalid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPolicyAttributeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPolicyAttributeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPolicyAttributeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPolicyAttributeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPolicyAttributeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPolicyAttributeException")?;
        if let Some(inner_66) = &self.message {
            write!(f, ": {}", inner_66)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPolicyAttributeException {}
/// See [`InvalidPolicyAttributeException`](crate::error::InvalidPolicyAttributeException)
pub mod invalid_policy_attribute_exception {
    /// A builder for [`InvalidPolicyAttributeException`](crate::error::InvalidPolicyAttributeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPolicyAttributeException`](crate::error::InvalidPolicyAttributeException)
        pub fn build(self) -> crate::error::InvalidPolicyAttributeException {
            crate::error::InvalidPolicyAttributeException {
                message: self.message,
            }
        }
    }
}
impl InvalidPolicyAttributeException {
    /// Creates a new builder-style object to manufacture [`InvalidPolicyAttributeException`](crate::error::InvalidPolicyAttributeException)
    pub fn builder() -> crate::error::invalid_policy_attribute_exception::Builder {
        crate::error::invalid_policy_attribute_exception::Builder::default()
    }
}

/// <p>The query key ID isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKeyId {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKeyId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKeyId");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKeyId {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKeyId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKeyId")?;
        if let Some(inner_67) = &self.message {
            write!(f, ": {}", inner_67)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKeyId {}
/// See [`InvalidKeyId`](crate::error::InvalidKeyId)
pub mod invalid_key_id {
    /// A builder for [`InvalidKeyId`](crate::error::InvalidKeyId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKeyId`](crate::error::InvalidKeyId)
        pub fn build(self) -> crate::error::InvalidKeyId {
            crate::error::InvalidKeyId {
                message: self.message,
            }
        }
    }
}
impl InvalidKeyId {
    /// Creates a new builder-style object to manufacture [`InvalidKeyId`](crate::error::InvalidKeyId)
    pub fn builder() -> crate::error::invalid_key_id::Builder {
        crate::error::invalid_key_id::Builder::default()
    }
}

/// <p>The request doesn't meet the regular expression requirement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAllowedPatternException {
    /// <p>The request doesn't meet the regular expression requirement.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAllowedPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAllowedPatternException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAllowedPatternException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAllowedPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAllowedPatternException")?;
        if let Some(inner_68) = &self.message {
            write!(f, ": {}", inner_68)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAllowedPatternException {}
/// See [`InvalidAllowedPatternException`](crate::error::InvalidAllowedPatternException)
pub mod invalid_allowed_pattern_exception {
    /// A builder for [`InvalidAllowedPatternException`](crate::error::InvalidAllowedPatternException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request doesn't meet the regular expression requirement.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The request doesn't meet the regular expression requirement.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAllowedPatternException`](crate::error::InvalidAllowedPatternException)
        pub fn build(self) -> crate::error::InvalidAllowedPatternException {
            crate::error::InvalidAllowedPatternException {
                message: self.message,
            }
        }
    }
}
impl InvalidAllowedPatternException {
    /// Creates a new builder-style object to manufacture [`InvalidAllowedPatternException`](crate::error::InvalidAllowedPatternException)
    pub fn builder() -> crate::error::invalid_allowed_pattern_exception::Builder {
        crate::error::invalid_allowed_pattern_exception::Builder::default()
    }
}

/// <p>There is a conflict in the policies specified for this parameter. You can't, for example,
/// specify two Expiration policies for a parameter. Review your policies, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatiblePolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatiblePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatiblePolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatiblePolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatiblePolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatiblePolicyException")?;
        if let Some(inner_69) = &self.message {
            write!(f, ": {}", inner_69)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatiblePolicyException {}
/// See [`IncompatiblePolicyException`](crate::error::IncompatiblePolicyException)
pub mod incompatible_policy_exception {
    /// A builder for [`IncompatiblePolicyException`](crate::error::IncompatiblePolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatiblePolicyException`](crate::error::IncompatiblePolicyException)
        pub fn build(self) -> crate::error::IncompatiblePolicyException {
            crate::error::IncompatiblePolicyException {
                message: self.message,
            }
        }
    }
}
impl IncompatiblePolicyException {
    /// Creates a new builder-style object to manufacture [`IncompatiblePolicyException`](crate::error::IncompatiblePolicyException)
    pub fn builder() -> crate::error::incompatible_policy_exception::Builder {
        crate::error::incompatible_policy_exception::Builder::default()
    }
}

/// <p>Parameter Store doesn't support changing a parameter type in a hierarchy. For example, you
/// can't change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You
/// must create a new, unique parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyTypeMismatchException {
    /// <p>Parameter Store doesn't support changing a parameter type in a hierarchy. For example, you
    /// can't change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You
    /// must create a new, unique parameter.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HierarchyTypeMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyTypeMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HierarchyTypeMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HierarchyTypeMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HierarchyTypeMismatchException")?;
        if let Some(inner_70) = &self.message {
            write!(f, ": {}", inner_70)?;
        }
        Ok(())
    }
}
impl std::error::Error for HierarchyTypeMismatchException {}
/// See [`HierarchyTypeMismatchException`](crate::error::HierarchyTypeMismatchException)
pub mod hierarchy_type_mismatch_exception {
    /// A builder for [`HierarchyTypeMismatchException`](crate::error::HierarchyTypeMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Parameter Store doesn't support changing a parameter type in a hierarchy. For example, you
        /// can't change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You
        /// must create a new, unique parameter.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Parameter Store doesn't support changing a parameter type in a hierarchy. For example, you
        /// can't change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You
        /// must create a new, unique parameter.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyTypeMismatchException`](crate::error::HierarchyTypeMismatchException)
        pub fn build(self) -> crate::error::HierarchyTypeMismatchException {
            crate::error::HierarchyTypeMismatchException {
                message: self.message,
            }
        }
    }
}
impl HierarchyTypeMismatchException {
    /// Creates a new builder-style object to manufacture [`HierarchyTypeMismatchException`](crate::error::HierarchyTypeMismatchException)
    pub fn builder() -> crate::error::hierarchy_type_mismatch_exception::Builder {
        crate::error::hierarchy_type_mismatch_exception::Builder::default()
    }
}

/// <p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and
/// constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HierarchyLevelLimitExceededException {
    /// <p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and
    /// constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HierarchyLevelLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HierarchyLevelLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HierarchyLevelLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HierarchyLevelLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HierarchyLevelLimitExceededException")?;
        if let Some(inner_71) = &self.message {
            write!(f, ": {}", inner_71)?;
        }
        Ok(())
    }
}
impl std::error::Error for HierarchyLevelLimitExceededException {}
/// See [`HierarchyLevelLimitExceededException`](crate::error::HierarchyLevelLimitExceededException)
pub mod hierarchy_level_limit_exceeded_exception {
    /// A builder for [`HierarchyLevelLimitExceededException`](crate::error::HierarchyLevelLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and
        /// constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and
        /// constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HierarchyLevelLimitExceededException`](crate::error::HierarchyLevelLimitExceededException)
        pub fn build(self) -> crate::error::HierarchyLevelLimitExceededException {
            crate::error::HierarchyLevelLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl HierarchyLevelLimitExceededException {
    /// Creates a new builder-style object to manufacture [`HierarchyLevelLimitExceededException`](crate::error::HierarchyLevelLimitExceededException)
    pub fn builder() -> crate::error::hierarchy_level_limit_exceeded_exception::Builder {
        crate::error::hierarchy_level_limit_exceeded_exception::Builder::default()
    }
}

/// <p>Inventory item type schema version has to match supported versions in the service. Check
/// output of GetInventorySchema to see the available schema version for each type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedInventorySchemaVersionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedInventorySchemaVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedInventorySchemaVersionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedInventorySchemaVersionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedInventorySchemaVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedInventorySchemaVersionException")?;
        if let Some(inner_72) = &self.message {
            write!(f, ": {}", inner_72)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedInventorySchemaVersionException {}
/// See [`UnsupportedInventorySchemaVersionException`](crate::error::UnsupportedInventorySchemaVersionException)
pub mod unsupported_inventory_schema_version_exception {
    /// A builder for [`UnsupportedInventorySchemaVersionException`](crate::error::UnsupportedInventorySchemaVersionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedInventorySchemaVersionException`](crate::error::UnsupportedInventorySchemaVersionException)
        pub fn build(self) -> crate::error::UnsupportedInventorySchemaVersionException {
            crate::error::UnsupportedInventorySchemaVersionException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedInventorySchemaVersionException {
    /// Creates a new builder-style object to manufacture [`UnsupportedInventorySchemaVersionException`](crate::error::UnsupportedInventorySchemaVersionException)
    pub fn builder() -> crate::error::unsupported_inventory_schema_version_exception::Builder {
        crate::error::unsupported_inventory_schema_version_exception::Builder::default()
    }
}

/// <p>The <code>Context</code> attribute that you specified for the <code>InventoryItem</code>
/// isn't allowed for this inventory type. You can only use the <code>Context</code> attribute with
/// inventory types like <code>AWS:ComplianceItem</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedInventoryItemContextException {
    #[allow(missing_docs)] // documentation missing in model
    pub type_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl UnsupportedInventoryItemContextException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedInventoryItemContextException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedInventoryItemContextException");
        formatter.field("type_name", &self.type_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedInventoryItemContextException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedInventoryItemContextException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedInventoryItemContextException")?;
        if let Some(inner_73) = &self.message {
            write!(f, ": {}", inner_73)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedInventoryItemContextException {}
/// See [`UnsupportedInventoryItemContextException`](crate::error::UnsupportedInventoryItemContextException)
pub mod unsupported_inventory_item_context_exception {
    /// A builder for [`UnsupportedInventoryItemContextException`](crate::error::UnsupportedInventoryItemContextException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedInventoryItemContextException`](crate::error::UnsupportedInventoryItemContextException)
        pub fn build(self) -> crate::error::UnsupportedInventoryItemContextException {
            crate::error::UnsupportedInventoryItemContextException {
                type_name: self.type_name,
                message: self.message,
            }
        }
    }
}
impl UnsupportedInventoryItemContextException {
    /// Creates a new builder-style object to manufacture [`UnsupportedInventoryItemContextException`](crate::error::UnsupportedInventoryItemContextException)
    pub fn builder() -> crate::error::unsupported_inventory_item_context_exception::Builder {
        crate::error::unsupported_inventory_item_context_exception::Builder::default()
    }
}

/// <p>The size of inventory data has exceeded the total size limit for the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TotalSizeLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TotalSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TotalSizeLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TotalSizeLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TotalSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TotalSizeLimitExceededException")?;
        if let Some(inner_74) = &self.message {
            write!(f, ": {}", inner_74)?;
        }
        Ok(())
    }
}
impl std::error::Error for TotalSizeLimitExceededException {}
/// See [`TotalSizeLimitExceededException`](crate::error::TotalSizeLimitExceededException)
pub mod total_size_limit_exceeded_exception {
    /// A builder for [`TotalSizeLimitExceededException`](crate::error::TotalSizeLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TotalSizeLimitExceededException`](crate::error::TotalSizeLimitExceededException)
        pub fn build(self) -> crate::error::TotalSizeLimitExceededException {
            crate::error::TotalSizeLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TotalSizeLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TotalSizeLimitExceededException`](crate::error::TotalSizeLimitExceededException)
    pub fn builder() -> crate::error::total_size_limit_exceeded_exception::Builder {
        crate::error::total_size_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The sub-type count exceeded the limit for the inventory type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubTypeCountLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubTypeCountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubTypeCountLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubTypeCountLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubTypeCountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubTypeCountLimitExceededException")?;
        if let Some(inner_75) = &self.message {
            write!(f, ": {}", inner_75)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubTypeCountLimitExceededException {}
/// See [`SubTypeCountLimitExceededException`](crate::error::SubTypeCountLimitExceededException)
pub mod sub_type_count_limit_exceeded_exception {
    /// A builder for [`SubTypeCountLimitExceededException`](crate::error::SubTypeCountLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubTypeCountLimitExceededException`](crate::error::SubTypeCountLimitExceededException)
        pub fn build(self) -> crate::error::SubTypeCountLimitExceededException {
            crate::error::SubTypeCountLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl SubTypeCountLimitExceededException {
    /// Creates a new builder-style object to manufacture [`SubTypeCountLimitExceededException`](crate::error::SubTypeCountLimitExceededException)
    pub fn builder() -> crate::error::sub_type_count_limit_exceeded_exception::Builder {
        crate::error::sub_type_count_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The inventory item size has exceeded the size limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ItemSizeLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub type_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ItemSizeLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
}
impl std::fmt::Debug for ItemSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ItemSizeLimitExceededException");
        formatter.field("type_name", &self.type_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ItemSizeLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ItemSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ItemSizeLimitExceededException")?;
        if let Some(inner_76) = &self.message {
            write!(f, ": {}", inner_76)?;
        }
        Ok(())
    }
}
impl std::error::Error for ItemSizeLimitExceededException {}
/// See [`ItemSizeLimitExceededException`](crate::error::ItemSizeLimitExceededException)
pub mod item_size_limit_exceeded_exception {
    /// A builder for [`ItemSizeLimitExceededException`](crate::error::ItemSizeLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ItemSizeLimitExceededException`](crate::error::ItemSizeLimitExceededException)
        pub fn build(self) -> crate::error::ItemSizeLimitExceededException {
            crate::error::ItemSizeLimitExceededException {
                type_name: self.type_name,
                message: self.message,
            }
        }
    }
}
impl ItemSizeLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ItemSizeLimitExceededException`](crate::error::ItemSizeLimitExceededException)
    pub fn builder() -> crate::error::item_size_limit_exceeded_exception::Builder {
        crate::error::item_size_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The inventory item has invalid content. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ItemContentMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub type_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ItemContentMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
}
impl std::fmt::Debug for ItemContentMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ItemContentMismatchException");
        formatter.field("type_name", &self.type_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ItemContentMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ItemContentMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ItemContentMismatchException")?;
        if let Some(inner_77) = &self.message {
            write!(f, ": {}", inner_77)?;
        }
        Ok(())
    }
}
impl std::error::Error for ItemContentMismatchException {}
/// See [`ItemContentMismatchException`](crate::error::ItemContentMismatchException)
pub mod item_content_mismatch_exception {
    /// A builder for [`ItemContentMismatchException`](crate::error::ItemContentMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ItemContentMismatchException`](crate::error::ItemContentMismatchException)
        pub fn build(self) -> crate::error::ItemContentMismatchException {
            crate::error::ItemContentMismatchException {
                type_name: self.type_name,
                message: self.message,
            }
        }
    }
}
impl ItemContentMismatchException {
    /// Creates a new builder-style object to manufacture [`ItemContentMismatchException`](crate::error::ItemContentMismatchException)
    pub fn builder() -> crate::error::item_content_mismatch_exception::Builder {
        crate::error::item_content_mismatch_exception::Builder::default()
    }
}

/// <p>The parameter type name isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTypeNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTypeNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTypeNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTypeNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTypeNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTypeNameException")?;
        if let Some(inner_78) = &self.message {
            write!(f, ": {}", inner_78)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTypeNameException {}
/// See [`InvalidTypeNameException`](crate::error::InvalidTypeNameException)
pub mod invalid_type_name_exception {
    /// A builder for [`InvalidTypeNameException`](crate::error::InvalidTypeNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTypeNameException`](crate::error::InvalidTypeNameException)
        pub fn build(self) -> crate::error::InvalidTypeNameException {
            crate::error::InvalidTypeNameException {
                message: self.message,
            }
        }
    }
}
impl InvalidTypeNameException {
    /// Creates a new builder-style object to manufacture [`InvalidTypeNameException`](crate::error::InvalidTypeNameException)
    pub fn builder() -> crate::error::invalid_type_name_exception::Builder {
        crate::error::invalid_type_name_exception::Builder::default()
    }
}

/// <p>One or more content items isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidItemContentException {
    #[allow(missing_docs)] // documentation missing in model
    pub type_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidItemContentException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
}
impl std::fmt::Debug for InvalidItemContentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidItemContentException");
        formatter.field("type_name", &self.type_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidItemContentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidItemContentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidItemContentException")?;
        if let Some(inner_79) = &self.message {
            write!(f, ": {}", inner_79)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidItemContentException {}
/// See [`InvalidItemContentException`](crate::error::InvalidItemContentException)
pub mod invalid_item_content_exception {
    /// A builder for [`InvalidItemContentException`](crate::error::InvalidItemContentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidItemContentException`](crate::error::InvalidItemContentException)
        pub fn build(self) -> crate::error::InvalidItemContentException {
            crate::error::InvalidItemContentException {
                type_name: self.type_name,
                message: self.message,
            }
        }
    }
}
impl InvalidItemContentException {
    /// Creates a new builder-style object to manufacture [`InvalidItemContentException`](crate::error::InvalidItemContentException)
    pub fn builder() -> crate::error::invalid_item_content_exception::Builder {
        crate::error::invalid_item_content_exception::Builder::default()
    }
}

/// <p>You specified invalid keys or values in the <code>Context</code> attribute for
/// <code>InventoryItem</code>. Verify the keys and values, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInventoryItemContextException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInventoryItemContextException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInventoryItemContextException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInventoryItemContextException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInventoryItemContextException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInventoryItemContextException")?;
        if let Some(inner_80) = &self.message {
            write!(f, ": {}", inner_80)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInventoryItemContextException {}
/// See [`InvalidInventoryItemContextException`](crate::error::InvalidInventoryItemContextException)
pub mod invalid_inventory_item_context_exception {
    /// A builder for [`InvalidInventoryItemContextException`](crate::error::InvalidInventoryItemContextException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInventoryItemContextException`](crate::error::InvalidInventoryItemContextException)
        pub fn build(self) -> crate::error::InvalidInventoryItemContextException {
            crate::error::InvalidInventoryItemContextException {
                message: self.message,
            }
        }
    }
}
impl InvalidInventoryItemContextException {
    /// Creates a new builder-style object to manufacture [`InvalidInventoryItemContextException`](crate::error::InvalidInventoryItemContextException)
    pub fn builder() -> crate::error::invalid_inventory_item_context_exception::Builder {
        crate::error::invalid_inventory_item_context_exception::Builder::default()
    }
}

/// <p>You have exceeded the limit for custom schemas. Delete one or more custom schemas and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomSchemaCountLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomSchemaCountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomSchemaCountLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CustomSchemaCountLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CustomSchemaCountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CustomSchemaCountLimitExceededException")?;
        if let Some(inner_81) = &self.message {
            write!(f, ": {}", inner_81)?;
        }
        Ok(())
    }
}
impl std::error::Error for CustomSchemaCountLimitExceededException {}
/// See [`CustomSchemaCountLimitExceededException`](crate::error::CustomSchemaCountLimitExceededException)
pub mod custom_schema_count_limit_exceeded_exception {
    /// A builder for [`CustomSchemaCountLimitExceededException`](crate::error::CustomSchemaCountLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomSchemaCountLimitExceededException`](crate::error::CustomSchemaCountLimitExceededException)
        pub fn build(self) -> crate::error::CustomSchemaCountLimitExceededException {
            crate::error::CustomSchemaCountLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl CustomSchemaCountLimitExceededException {
    /// Creates a new builder-style object to manufacture [`CustomSchemaCountLimitExceededException`](crate::error::CustomSchemaCountLimitExceededException)
    pub fn builder() -> crate::error::custom_schema_count_limit_exceeded_exception::Builder {
        crate::error::custom_schema_count_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You specified too many custom compliance types. You can specify a maximum of 10 different
/// types. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceTypeCountLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ComplianceTypeCountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceTypeCountLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ComplianceTypeCountLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ComplianceTypeCountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ComplianceTypeCountLimitExceededException")?;
        if let Some(inner_82) = &self.message {
            write!(f, ": {}", inner_82)?;
        }
        Ok(())
    }
}
impl std::error::Error for ComplianceTypeCountLimitExceededException {}
/// See [`ComplianceTypeCountLimitExceededException`](crate::error::ComplianceTypeCountLimitExceededException)
pub mod compliance_type_count_limit_exceeded_exception {
    /// A builder for [`ComplianceTypeCountLimitExceededException`](crate::error::ComplianceTypeCountLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceTypeCountLimitExceededException`](crate::error::ComplianceTypeCountLimitExceededException)
        pub fn build(self) -> crate::error::ComplianceTypeCountLimitExceededException {
            crate::error::ComplianceTypeCountLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ComplianceTypeCountLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ComplianceTypeCountLimitExceededException`](crate::error::ComplianceTypeCountLimitExceededException)
    pub fn builder() -> crate::error::compliance_type_count_limit_exceeded_exception::Builder {
        crate::error::compliance_type_count_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The permission type isn't supported. <i>Share</i> is the only supported
/// permission type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPermissionType {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPermissionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPermissionType");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPermissionType {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPermissionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPermissionType")?;
        if let Some(inner_83) = &self.message {
            write!(f, ": {}", inner_83)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPermissionType {}
/// See [`InvalidPermissionType`](crate::error::InvalidPermissionType)
pub mod invalid_permission_type {
    /// A builder for [`InvalidPermissionType`](crate::error::InvalidPermissionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPermissionType`](crate::error::InvalidPermissionType)
        pub fn build(self) -> crate::error::InvalidPermissionType {
            crate::error::InvalidPermissionType {
                message: self.message,
            }
        }
    }
}
impl Invalid