// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonSSM`.
///
/// This client allows ergonomic access to a `AmazonSSM`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateOpsItemRelatedItem` operation.
    ///
    /// See [`AssociateOpsItemRelatedItem`](crate::client::fluent_builders::AssociateOpsItemRelatedItem) for more information about the
    /// operation and its arguments.
    pub fn associate_ops_item_related_item(
        &self,
    ) -> fluent_builders::AssociateOpsItemRelatedItem<C, M, R> {
        fluent_builders::AssociateOpsItemRelatedItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelCommand` operation.
    ///
    /// See [`CancelCommand`](crate::client::fluent_builders::CancelCommand) for more information about the
    /// operation and its arguments.
    pub fn cancel_command(&self) -> fluent_builders::CancelCommand<C, M, R> {
        fluent_builders::CancelCommand::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelMaintenanceWindowExecution` operation.
    ///
    /// See [`CancelMaintenanceWindowExecution`](crate::client::fluent_builders::CancelMaintenanceWindowExecution) for more information about the
    /// operation and its arguments.
    pub fn cancel_maintenance_window_execution(
        &self,
    ) -> fluent_builders::CancelMaintenanceWindowExecution<C, M, R> {
        fluent_builders::CancelMaintenanceWindowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateActivation` operation.
    ///
    /// See [`CreateActivation`](crate::client::fluent_builders::CreateActivation) for more information about the
    /// operation and its arguments.
    pub fn create_activation(&self) -> fluent_builders::CreateActivation<C, M, R> {
        fluent_builders::CreateActivation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssociation` operation.
    ///
    /// See [`CreateAssociation`](crate::client::fluent_builders::CreateAssociation) for more information about the
    /// operation and its arguments.
    pub fn create_association(&self) -> fluent_builders::CreateAssociation<C, M, R> {
        fluent_builders::CreateAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssociationBatch` operation.
    ///
    /// See [`CreateAssociationBatch`](crate::client::fluent_builders::CreateAssociationBatch) for more information about the
    /// operation and its arguments.
    pub fn create_association_batch(&self) -> fluent_builders::CreateAssociationBatch<C, M, R> {
        fluent_builders::CreateAssociationBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDocument` operation.
    ///
    /// See [`CreateDocument`](crate::client::fluent_builders::CreateDocument) for more information about the
    /// operation and its arguments.
    pub fn create_document(&self) -> fluent_builders::CreateDocument<C, M, R> {
        fluent_builders::CreateDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMaintenanceWindow` operation.
    ///
    /// See [`CreateMaintenanceWindow`](crate::client::fluent_builders::CreateMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn create_maintenance_window(&self) -> fluent_builders::CreateMaintenanceWindow<C, M, R> {
        fluent_builders::CreateMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOpsItem` operation.
    ///
    /// See [`CreateOpsItem`](crate::client::fluent_builders::CreateOpsItem) for more information about the
    /// operation and its arguments.
    pub fn create_ops_item(&self) -> fluent_builders::CreateOpsItem<C, M, R> {
        fluent_builders::CreateOpsItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOpsMetadata` operation.
    ///
    /// See [`CreateOpsMetadata`](crate::client::fluent_builders::CreateOpsMetadata) for more information about the
    /// operation and its arguments.
    pub fn create_ops_metadata(&self) -> fluent_builders::CreateOpsMetadata<C, M, R> {
        fluent_builders::CreateOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePatchBaseline` operation.
    ///
    /// See [`CreatePatchBaseline`](crate::client::fluent_builders::CreatePatchBaseline) for more information about the
    /// operation and its arguments.
    pub fn create_patch_baseline(&self) -> fluent_builders::CreatePatchBaseline<C, M, R> {
        fluent_builders::CreatePatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourceDataSync` operation.
    ///
    /// See [`CreateResourceDataSync`](crate::client::fluent_builders::CreateResourceDataSync) for more information about the
    /// operation and its arguments.
    pub fn create_resource_data_sync(&self) -> fluent_builders::CreateResourceDataSync<C, M, R> {
        fluent_builders::CreateResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteActivation` operation.
    ///
    /// See [`DeleteActivation`](crate::client::fluent_builders::DeleteActivation) for more information about the
    /// operation and its arguments.
    pub fn delete_activation(&self) -> fluent_builders::DeleteActivation<C, M, R> {
        fluent_builders::DeleteActivation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssociation` operation.
    ///
    /// See [`DeleteAssociation`](crate::client::fluent_builders::DeleteAssociation) for more information about the
    /// operation and its arguments.
    pub fn delete_association(&self) -> fluent_builders::DeleteAssociation<C, M, R> {
        fluent_builders::DeleteAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDocument` operation.
    ///
    /// See [`DeleteDocument`](crate::client::fluent_builders::DeleteDocument) for more information about the
    /// operation and its arguments.
    pub fn delete_document(&self) -> fluent_builders::DeleteDocument<C, M, R> {
        fluent_builders::DeleteDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInventory` operation.
    ///
    /// See [`DeleteInventory`](crate::client::fluent_builders::DeleteInventory) for more information about the
    /// operation and its arguments.
    pub fn delete_inventory(&self) -> fluent_builders::DeleteInventory<C, M, R> {
        fluent_builders::DeleteInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMaintenanceWindow` operation.
    ///
    /// See [`DeleteMaintenanceWindow`](crate::client::fluent_builders::DeleteMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn delete_maintenance_window(&self) -> fluent_builders::DeleteMaintenanceWindow<C, M, R> {
        fluent_builders::DeleteMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOpsMetadata` operation.
    ///
    /// See [`DeleteOpsMetadata`](crate::client::fluent_builders::DeleteOpsMetadata) for more information about the
    /// operation and its arguments.
    pub fn delete_ops_metadata(&self) -> fluent_builders::DeleteOpsMetadata<C, M, R> {
        fluent_builders::DeleteOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteParameter` operation.
    ///
    /// See [`DeleteParameter`](crate::client::fluent_builders::DeleteParameter) for more information about the
    /// operation and its arguments.
    pub fn delete_parameter(&self) -> fluent_builders::DeleteParameter<C, M, R> {
        fluent_builders::DeleteParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteParameters` operation.
    ///
    /// See [`DeleteParameters`](crate::client::fluent_builders::DeleteParameters) for more information about the
    /// operation and its arguments.
    pub fn delete_parameters(&self) -> fluent_builders::DeleteParameters<C, M, R> {
        fluent_builders::DeleteParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePatchBaseline` operation.
    ///
    /// See [`DeletePatchBaseline`](crate::client::fluent_builders::DeletePatchBaseline) for more information about the
    /// operation and its arguments.
    pub fn delete_patch_baseline(&self) -> fluent_builders::DeletePatchBaseline<C, M, R> {
        fluent_builders::DeletePatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourceDataSync` operation.
    ///
    /// See [`DeleteResourceDataSync`](crate::client::fluent_builders::DeleteResourceDataSync) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_data_sync(&self) -> fluent_builders::DeleteResourceDataSync<C, M, R> {
        fluent_builders::DeleteResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterManagedInstance` operation.
    ///
    /// See [`DeregisterManagedInstance`](crate::client::fluent_builders::DeregisterManagedInstance) for more information about the
    /// operation and its arguments.
    pub fn deregister_managed_instance(
        &self,
    ) -> fluent_builders::DeregisterManagedInstance<C, M, R> {
        fluent_builders::DeregisterManagedInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterPatchBaselineForPatchGroup` operation.
    ///
    /// See [`DeregisterPatchBaselineForPatchGroup`](crate::client::fluent_builders::DeregisterPatchBaselineForPatchGroup) for more information about the
    /// operation and its arguments.
    pub fn deregister_patch_baseline_for_patch_group(
        &self,
    ) -> fluent_builders::DeregisterPatchBaselineForPatchGroup<C, M, R> {
        fluent_builders::DeregisterPatchBaselineForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterTargetFromMaintenanceWindow` operation.
    ///
    /// See [`DeregisterTargetFromMaintenanceWindow`](crate::client::fluent_builders::DeregisterTargetFromMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn deregister_target_from_maintenance_window(
        &self,
    ) -> fluent_builders::DeregisterTargetFromMaintenanceWindow<C, M, R> {
        fluent_builders::DeregisterTargetFromMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterTaskFromMaintenanceWindow` operation.
    ///
    /// See [`DeregisterTaskFromMaintenanceWindow`](crate::client::fluent_builders::DeregisterTaskFromMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn deregister_task_from_maintenance_window(
        &self,
    ) -> fluent_builders::DeregisterTaskFromMaintenanceWindow<C, M, R> {
        fluent_builders::DeregisterTaskFromMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeActivations` operation.
    ///
    /// See [`DescribeActivations`](crate::client::fluent_builders::DescribeActivations) for more information about the
    /// operation and its arguments.
    pub fn describe_activations(&self) -> fluent_builders::DescribeActivations<C, M, R> {
        fluent_builders::DescribeActivations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssociation` operation.
    ///
    /// See [`DescribeAssociation`](crate::client::fluent_builders::DescribeAssociation) for more information about the
    /// operation and its arguments.
    pub fn describe_association(&self) -> fluent_builders::DescribeAssociation<C, M, R> {
        fluent_builders::DescribeAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssociationExecutions` operation.
    ///
    /// See [`DescribeAssociationExecutions`](crate::client::fluent_builders::DescribeAssociationExecutions) for more information about the
    /// operation and its arguments.
    pub fn describe_association_executions(
        &self,
    ) -> fluent_builders::DescribeAssociationExecutions<C, M, R> {
        fluent_builders::DescribeAssociationExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssociationExecutionTargets` operation.
    ///
    /// See [`DescribeAssociationExecutionTargets`](crate::client::fluent_builders::DescribeAssociationExecutionTargets) for more information about the
    /// operation and its arguments.
    pub fn describe_association_execution_targets(
        &self,
    ) -> fluent_builders::DescribeAssociationExecutionTargets<C, M, R> {
        fluent_builders::DescribeAssociationExecutionTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAutomationExecutions` operation.
    ///
    /// See [`DescribeAutomationExecutions`](crate::client::fluent_builders::DescribeAutomationExecutions) for more information about the
    /// operation and its arguments.
    pub fn describe_automation_executions(
        &self,
    ) -> fluent_builders::DescribeAutomationExecutions<C, M, R> {
        fluent_builders::DescribeAutomationExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAutomationStepExecutions` operation.
    ///
    /// See [`DescribeAutomationStepExecutions`](crate::client::fluent_builders::DescribeAutomationStepExecutions) for more information about the
    /// operation and its arguments.
    pub fn describe_automation_step_executions(
        &self,
    ) -> fluent_builders::DescribeAutomationStepExecutions<C, M, R> {
        fluent_builders::DescribeAutomationStepExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAvailablePatches` operation.
    ///
    /// See [`DescribeAvailablePatches`](crate::client::fluent_builders::DescribeAvailablePatches) for more information about the
    /// operation and its arguments.
    pub fn describe_available_patches(&self) -> fluent_builders::DescribeAvailablePatches<C, M, R> {
        fluent_builders::DescribeAvailablePatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDocument` operation.
    ///
    /// See [`DescribeDocument`](crate::client::fluent_builders::DescribeDocument) for more information about the
    /// operation and its arguments.
    pub fn describe_document(&self) -> fluent_builders::DescribeDocument<C, M, R> {
        fluent_builders::DescribeDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDocumentPermission` operation.
    ///
    /// See [`DescribeDocumentPermission`](crate::client::fluent_builders::DescribeDocumentPermission) for more information about the
    /// operation and its arguments.
    pub fn describe_document_permission(
        &self,
    ) -> fluent_builders::DescribeDocumentPermission<C, M, R> {
        fluent_builders::DescribeDocumentPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEffectiveInstanceAssociations` operation.
    ///
    /// See [`DescribeEffectiveInstanceAssociations`](crate::client::fluent_builders::DescribeEffectiveInstanceAssociations) for more information about the
    /// operation and its arguments.
    pub fn describe_effective_instance_associations(
        &self,
    ) -> fluent_builders::DescribeEffectiveInstanceAssociations<C, M, R> {
        fluent_builders::DescribeEffectiveInstanceAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEffectivePatchesForPatchBaseline` operation.
    ///
    /// See [`DescribeEffectivePatchesForPatchBaseline`](crate::client::fluent_builders::DescribeEffectivePatchesForPatchBaseline) for more information about the
    /// operation and its arguments.
    pub fn describe_effective_patches_for_patch_baseline(
        &self,
    ) -> fluent_builders::DescribeEffectivePatchesForPatchBaseline<C, M, R> {
        fluent_builders::DescribeEffectivePatchesForPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceAssociationsStatus` operation.
    ///
    /// See [`DescribeInstanceAssociationsStatus`](crate::client::fluent_builders::DescribeInstanceAssociationsStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_associations_status(
        &self,
    ) -> fluent_builders::DescribeInstanceAssociationsStatus<C, M, R> {
        fluent_builders::DescribeInstanceAssociationsStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceInformation` operation.
    ///
    /// See [`DescribeInstanceInformation`](crate::client::fluent_builders::DescribeInstanceInformation) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_information(
        &self,
    ) -> fluent_builders::DescribeInstanceInformation<C, M, R> {
        fluent_builders::DescribeInstanceInformation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstancePatches` operation.
    ///
    /// See [`DescribeInstancePatches`](crate::client::fluent_builders::DescribeInstancePatches) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_patches(&self) -> fluent_builders::DescribeInstancePatches<C, M, R> {
        fluent_builders::DescribeInstancePatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstancePatchStates` operation.
    ///
    /// See [`DescribeInstancePatchStates`](crate::client::fluent_builders::DescribeInstancePatchStates) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_patch_states(
        &self,
    ) -> fluent_builders::DescribeInstancePatchStates<C, M, R> {
        fluent_builders::DescribeInstancePatchStates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstancePatchStatesForPatchGroup` operation.
    ///
    /// See [`DescribeInstancePatchStatesForPatchGroup`](crate::client::fluent_builders::DescribeInstancePatchStatesForPatchGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_patch_states_for_patch_group(
        &self,
    ) -> fluent_builders::DescribeInstancePatchStatesForPatchGroup<C, M, R> {
        fluent_builders::DescribeInstancePatchStatesForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInventoryDeletions` operation.
    ///
    /// See [`DescribeInventoryDeletions`](crate::client::fluent_builders::DescribeInventoryDeletions) for more information about the
    /// operation and its arguments.
    pub fn describe_inventory_deletions(
        &self,
    ) -> fluent_builders::DescribeInventoryDeletions<C, M, R> {
        fluent_builders::DescribeInventoryDeletions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindowExecutions` operation.
    ///
    /// See [`DescribeMaintenanceWindowExecutions`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutions) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_window_executions(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowExecutions<C, M, R> {
        fluent_builders::DescribeMaintenanceWindowExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindowExecutionTaskInvocations` operation.
    ///
    /// See [`DescribeMaintenanceWindowExecutionTaskInvocations`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_window_execution_task_invocations(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations<C, M, R> {
        fluent_builders::DescribeMaintenanceWindowExecutionTaskInvocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindowExecutionTasks` operation.
    ///
    /// See [`DescribeMaintenanceWindowExecutionTasks`](crate::client::fluent_builders::DescribeMaintenanceWindowExecutionTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_window_execution_tasks(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowExecutionTasks<C, M, R> {
        fluent_builders::DescribeMaintenanceWindowExecutionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindows` operation.
    ///
    /// See [`DescribeMaintenanceWindows`](crate::client::fluent_builders::DescribeMaintenanceWindows) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_windows(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindows<C, M, R> {
        fluent_builders::DescribeMaintenanceWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindowSchedule` operation.
    ///
    /// See [`DescribeMaintenanceWindowSchedule`](crate::client::fluent_builders::DescribeMaintenanceWindowSchedule) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_window_schedule(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowSchedule<C, M, R> {
        fluent_builders::DescribeMaintenanceWindowSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindowsForTarget` operation.
    ///
    /// See [`DescribeMaintenanceWindowsForTarget`](crate::client::fluent_builders::DescribeMaintenanceWindowsForTarget) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_windows_for_target(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowsForTarget<C, M, R> {
        fluent_builders::DescribeMaintenanceWindowsForTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindowTargets` operation.
    ///
    /// See [`DescribeMaintenanceWindowTargets`](crate::client::fluent_builders::DescribeMaintenanceWindowTargets) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_window_targets(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowTargets<C, M, R> {
        fluent_builders::DescribeMaintenanceWindowTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMaintenanceWindowTasks` operation.
    ///
    /// See [`DescribeMaintenanceWindowTasks`](crate::client::fluent_builders::DescribeMaintenanceWindowTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_maintenance_window_tasks(
        &self,
    ) -> fluent_builders::DescribeMaintenanceWindowTasks<C, M, R> {
        fluent_builders::DescribeMaintenanceWindowTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOpsItems` operation.
    ///
    /// See [`DescribeOpsItems`](crate::client::fluent_builders::DescribeOpsItems) for more information about the
    /// operation and its arguments.
    pub fn describe_ops_items(&self) -> fluent_builders::DescribeOpsItems<C, M, R> {
        fluent_builders::DescribeOpsItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeParameters` operation.
    ///
    /// See [`DescribeParameters`](crate::client::fluent_builders::DescribeParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_parameters(&self) -> fluent_builders::DescribeParameters<C, M, R> {
        fluent_builders::DescribeParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePatchBaselines` operation.
    ///
    /// See [`DescribePatchBaselines`](crate::client::fluent_builders::DescribePatchBaselines) for more information about the
    /// operation and its arguments.
    pub fn describe_patch_baselines(&self) -> fluent_builders::DescribePatchBaselines<C, M, R> {
        fluent_builders::DescribePatchBaselines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePatchGroups` operation.
    ///
    /// See [`DescribePatchGroups`](crate::client::fluent_builders::DescribePatchGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_patch_groups(&self) -> fluent_builders::DescribePatchGroups<C, M, R> {
        fluent_builders::DescribePatchGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePatchGroupState` operation.
    ///
    /// See [`DescribePatchGroupState`](crate::client::fluent_builders::DescribePatchGroupState) for more information about the
    /// operation and its arguments.
    pub fn describe_patch_group_state(&self) -> fluent_builders::DescribePatchGroupState<C, M, R> {
        fluent_builders::DescribePatchGroupState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePatchProperties` operation.
    ///
    /// See [`DescribePatchProperties`](crate::client::fluent_builders::DescribePatchProperties) for more information about the
    /// operation and its arguments.
    pub fn describe_patch_properties(&self) -> fluent_builders::DescribePatchProperties<C, M, R> {
        fluent_builders::DescribePatchProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSessions` operation.
    ///
    /// See [`DescribeSessions`](crate::client::fluent_builders::DescribeSessions) for more information about the
    /// operation and its arguments.
    pub fn describe_sessions(&self) -> fluent_builders::DescribeSessions<C, M, R> {
        fluent_builders::DescribeSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateOpsItemRelatedItem` operation.
    ///
    /// See [`DisassociateOpsItemRelatedItem`](crate::client::fluent_builders::DisassociateOpsItemRelatedItem) for more information about the
    /// operation and its arguments.
    pub fn disassociate_ops_item_related_item(
        &self,
    ) -> fluent_builders::DisassociateOpsItemRelatedItem<C, M, R> {
        fluent_builders::DisassociateOpsItemRelatedItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAutomationExecution` operation.
    ///
    /// See [`GetAutomationExecution`](crate::client::fluent_builders::GetAutomationExecution) for more information about the
    /// operation and its arguments.
    pub fn get_automation_execution(&self) -> fluent_builders::GetAutomationExecution<C, M, R> {
        fluent_builders::GetAutomationExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCalendarState` operation.
    ///
    /// See [`GetCalendarState`](crate::client::fluent_builders::GetCalendarState) for more information about the
    /// operation and its arguments.
    pub fn get_calendar_state(&self) -> fluent_builders::GetCalendarState<C, M, R> {
        fluent_builders::GetCalendarState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCommandInvocation` operation.
    ///
    /// See [`GetCommandInvocation`](crate::client::fluent_builders::GetCommandInvocation) for more information about the
    /// operation and its arguments.
    pub fn get_command_invocation(&self) -> fluent_builders::GetCommandInvocation<C, M, R> {
        fluent_builders::GetCommandInvocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectionStatus` operation.
    ///
    /// See [`GetConnectionStatus`](crate::client::fluent_builders::GetConnectionStatus) for more information about the
    /// operation and its arguments.
    pub fn get_connection_status(&self) -> fluent_builders::GetConnectionStatus<C, M, R> {
        fluent_builders::GetConnectionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDefaultPatchBaseline` operation.
    ///
    /// See [`GetDefaultPatchBaseline`](crate::client::fluent_builders::GetDefaultPatchBaseline) for more information about the
    /// operation and its arguments.
    pub fn get_default_patch_baseline(&self) -> fluent_builders::GetDefaultPatchBaseline<C, M, R> {
        fluent_builders::GetDefaultPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeployablePatchSnapshotForInstance` operation.
    ///
    /// See [`GetDeployablePatchSnapshotForInstance`](crate::client::fluent_builders::GetDeployablePatchSnapshotForInstance) for more information about the
    /// operation and its arguments.
    pub fn get_deployable_patch_snapshot_for_instance(
        &self,
    ) -> fluent_builders::GetDeployablePatchSnapshotForInstance<C, M, R> {
        fluent_builders::GetDeployablePatchSnapshotForInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDocument` operation.
    ///
    /// See [`GetDocument`](crate::client::fluent_builders::GetDocument) for more information about the
    /// operation and its arguments.
    pub fn get_document(&self) -> fluent_builders::GetDocument<C, M, R> {
        fluent_builders::GetDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInventory` operation.
    ///
    /// See [`GetInventory`](crate::client::fluent_builders::GetInventory) for more information about the
    /// operation and its arguments.
    pub fn get_inventory(&self) -> fluent_builders::GetInventory<C, M, R> {
        fluent_builders::GetInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInventorySchema` operation.
    ///
    /// See [`GetInventorySchema`](crate::client::fluent_builders::GetInventorySchema) for more information about the
    /// operation and its arguments.
    pub fn get_inventory_schema(&self) -> fluent_builders::GetInventorySchema<C, M, R> {
        fluent_builders::GetInventorySchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMaintenanceWindow` operation.
    ///
    /// See [`GetMaintenanceWindow`](crate::client::fluent_builders::GetMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn get_maintenance_window(&self) -> fluent_builders::GetMaintenanceWindow<C, M, R> {
        fluent_builders::GetMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMaintenanceWindowExecution` operation.
    ///
    /// See [`GetMaintenanceWindowExecution`](crate::client::fluent_builders::GetMaintenanceWindowExecution) for more information about the
    /// operation and its arguments.
    pub fn get_maintenance_window_execution(
        &self,
    ) -> fluent_builders::GetMaintenanceWindowExecution<C, M, R> {
        fluent_builders::GetMaintenanceWindowExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMaintenanceWindowExecutionTask` operation.
    ///
    /// See [`GetMaintenanceWindowExecutionTask`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTask) for more information about the
    /// operation and its arguments.
    pub fn get_maintenance_window_execution_task(
        &self,
    ) -> fluent_builders::GetMaintenanceWindowExecutionTask<C, M, R> {
        fluent_builders::GetMaintenanceWindowExecutionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMaintenanceWindowExecutionTaskInvocation` operation.
    ///
    /// See [`GetMaintenanceWindowExecutionTaskInvocation`](crate::client::fluent_builders::GetMaintenanceWindowExecutionTaskInvocation) for more information about the
    /// operation and its arguments.
    pub fn get_maintenance_window_execution_task_invocation(
        &self,
    ) -> fluent_builders::GetMaintenanceWindowExecutionTaskInvocation<C, M, R> {
        fluent_builders::GetMaintenanceWindowExecutionTaskInvocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMaintenanceWindowTask` operation.
    ///
    /// See [`GetMaintenanceWindowTask`](crate::client::fluent_builders::GetMaintenanceWindowTask) for more information about the
    /// operation and its arguments.
    pub fn get_maintenance_window_task(
        &self,
    ) -> fluent_builders::GetMaintenanceWindowTask<C, M, R> {
        fluent_builders::GetMaintenanceWindowTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOpsItem` operation.
    ///
    /// See [`GetOpsItem`](crate::client::fluent_builders::GetOpsItem) for more information about the
    /// operation and its arguments.
    pub fn get_ops_item(&self) -> fluent_builders::GetOpsItem<C, M, R> {
        fluent_builders::GetOpsItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOpsMetadata` operation.
    ///
    /// See [`GetOpsMetadata`](crate::client::fluent_builders::GetOpsMetadata) for more information about the
    /// operation and its arguments.
    pub fn get_ops_metadata(&self) -> fluent_builders::GetOpsMetadata<C, M, R> {
        fluent_builders::GetOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOpsSummary` operation.
    ///
    /// See [`GetOpsSummary`](crate::client::fluent_builders::GetOpsSummary) for more information about the
    /// operation and its arguments.
    pub fn get_ops_summary(&self) -> fluent_builders::GetOpsSummary<C, M, R> {
        fluent_builders::GetOpsSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetParameter` operation.
    ///
    /// See [`GetParameter`](crate::client::fluent_builders::GetParameter) for more information about the
    /// operation and its arguments.
    pub fn get_parameter(&self) -> fluent_builders::GetParameter<C, M, R> {
        fluent_builders::GetParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetParameterHistory` operation.
    ///
    /// See [`GetParameterHistory`](crate::client::fluent_builders::GetParameterHistory) for more information about the
    /// operation and its arguments.
    pub fn get_parameter_history(&self) -> fluent_builders::GetParameterHistory<C, M, R> {
        fluent_builders::GetParameterHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetParameters` operation.
    ///
    /// See [`GetParameters`](crate::client::fluent_builders::GetParameters) for more information about the
    /// operation and its arguments.
    pub fn get_parameters(&self) -> fluent_builders::GetParameters<C, M, R> {
        fluent_builders::GetParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetParametersByPath` operation.
    ///
    /// See [`GetParametersByPath`](crate::client::fluent_builders::GetParametersByPath) for more information about the
    /// operation and its arguments.
    pub fn get_parameters_by_path(&self) -> fluent_builders::GetParametersByPath<C, M, R> {
        fluent_builders::GetParametersByPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPatchBaseline` operation.
    ///
    /// See [`GetPatchBaseline`](crate::client::fluent_builders::GetPatchBaseline) for more information about the
    /// operation and its arguments.
    pub fn get_patch_baseline(&self) -> fluent_builders::GetPatchBaseline<C, M, R> {
        fluent_builders::GetPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPatchBaselineForPatchGroup` operation.
    ///
    /// See [`GetPatchBaselineForPatchGroup`](crate::client::fluent_builders::GetPatchBaselineForPatchGroup) for more information about the
    /// operation and its arguments.
    pub fn get_patch_baseline_for_patch_group(
        &self,
    ) -> fluent_builders::GetPatchBaselineForPatchGroup<C, M, R> {
        fluent_builders::GetPatchBaselineForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceSetting` operation.
    ///
    /// See [`GetServiceSetting`](crate::client::fluent_builders::GetServiceSetting) for more information about the
    /// operation and its arguments.
    pub fn get_service_setting(&self) -> fluent_builders::GetServiceSetting<C, M, R> {
        fluent_builders::GetServiceSetting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `LabelParameterVersion` operation.
    ///
    /// See [`LabelParameterVersion`](crate::client::fluent_builders::LabelParameterVersion) for more information about the
    /// operation and its arguments.
    pub fn label_parameter_version(&self) -> fluent_builders::LabelParameterVersion<C, M, R> {
        fluent_builders::LabelParameterVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociations` operation.
    ///
    /// See [`ListAssociations`](crate::client::fluent_builders::ListAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_associations(&self) -> fluent_builders::ListAssociations<C, M, R> {
        fluent_builders::ListAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociationVersions` operation.
    ///
    /// See [`ListAssociationVersions`](crate::client::fluent_builders::ListAssociationVersions) for more information about the
    /// operation and its arguments.
    pub fn list_association_versions(&self) -> fluent_builders::ListAssociationVersions<C, M, R> {
        fluent_builders::ListAssociationVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCommandInvocations` operation.
    ///
    /// See [`ListCommandInvocations`](crate::client::fluent_builders::ListCommandInvocations) for more information about the
    /// operation and its arguments.
    pub fn list_command_invocations(&self) -> fluent_builders::ListCommandInvocations<C, M, R> {
        fluent_builders::ListCommandInvocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCommands` operation.
    ///
    /// See [`ListCommands`](crate::client::fluent_builders::ListCommands) for more information about the
    /// operation and its arguments.
    pub fn list_commands(&self) -> fluent_builders::ListCommands<C, M, R> {
        fluent_builders::ListCommands::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListComplianceItems` operation.
    ///
    /// See [`ListComplianceItems`](crate::client::fluent_builders::ListComplianceItems) for more information about the
    /// operation and its arguments.
    pub fn list_compliance_items(&self) -> fluent_builders::ListComplianceItems<C, M, R> {
        fluent_builders::ListComplianceItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListComplianceSummaries` operation.
    ///
    /// See [`ListComplianceSummaries`](crate::client::fluent_builders::ListComplianceSummaries) for more information about the
    /// operation and its arguments.
    pub fn list_compliance_summaries(&self) -> fluent_builders::ListComplianceSummaries<C, M, R> {
        fluent_builders::ListComplianceSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDocumentMetadataHistory` operation.
    ///
    /// See [`ListDocumentMetadataHistory`](crate::client::fluent_builders::ListDocumentMetadataHistory) for more information about the
    /// operation and its arguments.
    pub fn list_document_metadata_history(
        &self,
    ) -> fluent_builders::ListDocumentMetadataHistory<C, M, R> {
        fluent_builders::ListDocumentMetadataHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDocuments` operation.
    ///
    /// See [`ListDocuments`](crate::client::fluent_builders::ListDocuments) for more information about the
    /// operation and its arguments.
    pub fn list_documents(&self) -> fluent_builders::ListDocuments<C, M, R> {
        fluent_builders::ListDocuments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDocumentVersions` operation.
    ///
    /// See [`ListDocumentVersions`](crate::client::fluent_builders::ListDocumentVersions) for more information about the
    /// operation and its arguments.
    pub fn list_document_versions(&self) -> fluent_builders::ListDocumentVersions<C, M, R> {
        fluent_builders::ListDocumentVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInventoryEntries` operation.
    ///
    /// See [`ListInventoryEntries`](crate::client::fluent_builders::ListInventoryEntries) for more information about the
    /// operation and its arguments.
    pub fn list_inventory_entries(&self) -> fluent_builders::ListInventoryEntries<C, M, R> {
        fluent_builders::ListInventoryEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOpsItemEvents` operation.
    ///
    /// See [`ListOpsItemEvents`](crate::client::fluent_builders::ListOpsItemEvents) for more information about the
    /// operation and its arguments.
    pub fn list_ops_item_events(&self) -> fluent_builders::ListOpsItemEvents<C, M, R> {
        fluent_builders::ListOpsItemEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOpsItemRelatedItems` operation.
    ///
    /// See [`ListOpsItemRelatedItems`](crate::client::fluent_builders::ListOpsItemRelatedItems) for more information about the
    /// operation and its arguments.
    pub fn list_ops_item_related_items(&self) -> fluent_builders::ListOpsItemRelatedItems<C, M, R> {
        fluent_builders::ListOpsItemRelatedItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOpsMetadata` operation.
    ///
    /// See [`ListOpsMetadata`](crate::client::fluent_builders::ListOpsMetadata) for more information about the
    /// operation and its arguments.
    pub fn list_ops_metadata(&self) -> fluent_builders::ListOpsMetadata<C, M, R> {
        fluent_builders::ListOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceComplianceSummaries` operation.
    ///
    /// See [`ListResourceComplianceSummaries`](crate::client::fluent_builders::ListResourceComplianceSummaries) for more information about the
    /// operation and its arguments.
    pub fn list_resource_compliance_summaries(
        &self,
    ) -> fluent_builders::ListResourceComplianceSummaries<C, M, R> {
        fluent_builders::ListResourceComplianceSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceDataSync` operation.
    ///
    /// See [`ListResourceDataSync`](crate::client::fluent_builders::ListResourceDataSync) for more information about the
    /// operation and its arguments.
    pub fn list_resource_data_sync(&self) -> fluent_builders::ListResourceDataSync<C, M, R> {
        fluent_builders::ListResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDocumentPermission` operation.
    ///
    /// See [`ModifyDocumentPermission`](crate::client::fluent_builders::ModifyDocumentPermission) for more information about the
    /// operation and its arguments.
    pub fn modify_document_permission(&self) -> fluent_builders::ModifyDocumentPermission<C, M, R> {
        fluent_builders::ModifyDocumentPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutComplianceItems` operation.
    ///
    /// See [`PutComplianceItems`](crate::client::fluent_builders::PutComplianceItems) for more information about the
    /// operation and its arguments.
    pub fn put_compliance_items(&self) -> fluent_builders::PutComplianceItems<C, M, R> {
        fluent_builders::PutComplianceItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutInventory` operation.
    ///
    /// See [`PutInventory`](crate::client::fluent_builders::PutInventory) for more information about the
    /// operation and its arguments.
    pub fn put_inventory(&self) -> fluent_builders::PutInventory<C, M, R> {
        fluent_builders::PutInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutParameter` operation.
    ///
    /// See [`PutParameter`](crate::client::fluent_builders::PutParameter) for more information about the
    /// operation and its arguments.
    pub fn put_parameter(&self) -> fluent_builders::PutParameter<C, M, R> {
        fluent_builders::PutParameter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterDefaultPatchBaseline` operation.
    ///
    /// See [`RegisterDefaultPatchBaseline`](crate::client::fluent_builders::RegisterDefaultPatchBaseline) for more information about the
    /// operation and its arguments.
    pub fn register_default_patch_baseline(
        &self,
    ) -> fluent_builders::RegisterDefaultPatchBaseline<C, M, R> {
        fluent_builders::RegisterDefaultPatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterPatchBaselineForPatchGroup` operation.
    ///
    /// See [`RegisterPatchBaselineForPatchGroup`](crate::client::fluent_builders::RegisterPatchBaselineForPatchGroup) for more information about the
    /// operation and its arguments.
    pub fn register_patch_baseline_for_patch_group(
        &self,
    ) -> fluent_builders::RegisterPatchBaselineForPatchGroup<C, M, R> {
        fluent_builders::RegisterPatchBaselineForPatchGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterTargetWithMaintenanceWindow` operation.
    ///
    /// See [`RegisterTargetWithMaintenanceWindow`](crate::client::fluent_builders::RegisterTargetWithMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn register_target_with_maintenance_window(
        &self,
    ) -> fluent_builders::RegisterTargetWithMaintenanceWindow<C, M, R> {
        fluent_builders::RegisterTargetWithMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterTaskWithMaintenanceWindow` operation.
    ///
    /// See [`RegisterTaskWithMaintenanceWindow`](crate::client::fluent_builders::RegisterTaskWithMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn register_task_with_maintenance_window(
        &self,
    ) -> fluent_builders::RegisterTaskWithMaintenanceWindow<C, M, R> {
        fluent_builders::RegisterTaskWithMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetServiceSetting` operation.
    ///
    /// See [`ResetServiceSetting`](crate::client::fluent_builders::ResetServiceSetting) for more information about the
    /// operation and its arguments.
    pub fn reset_service_setting(&self) -> fluent_builders::ResetServiceSetting<C, M, R> {
        fluent_builders::ResetServiceSetting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResumeSession` operation.
    ///
    /// See [`ResumeSession`](crate::client::fluent_builders::ResumeSession) for more information about the
    /// operation and its arguments.
    pub fn resume_session(&self) -> fluent_builders::ResumeSession<C, M, R> {
        fluent_builders::ResumeSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendAutomationSignal` operation.
    ///
    /// See [`SendAutomationSignal`](crate::client::fluent_builders::SendAutomationSignal) for more information about the
    /// operation and its arguments.
    pub fn send_automation_signal(&self) -> fluent_builders::SendAutomationSignal<C, M, R> {
        fluent_builders::SendAutomationSignal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendCommand` operation.
    ///
    /// See [`SendCommand`](crate::client::fluent_builders::SendCommand) for more information about the
    /// operation and its arguments.
    pub fn send_command(&self) -> fluent_builders::SendCommand<C, M, R> {
        fluent_builders::SendCommand::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAssociationsOnce` operation.
    ///
    /// See [`StartAssociationsOnce`](crate::client::fluent_builders::StartAssociationsOnce) for more information about the
    /// operation and its arguments.
    pub fn start_associations_once(&self) -> fluent_builders::StartAssociationsOnce<C, M, R> {
        fluent_builders::StartAssociationsOnce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAutomationExecution` operation.
    ///
    /// See [`StartAutomationExecution`](crate::client::fluent_builders::StartAutomationExecution) for more information about the
    /// operation and its arguments.
    pub fn start_automation_execution(&self) -> fluent_builders::StartAutomationExecution<C, M, R> {
        fluent_builders::StartAutomationExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartChangeRequestExecution` operation.
    ///
    /// See [`StartChangeRequestExecution`](crate::client::fluent_builders::StartChangeRequestExecution) for more information about the
    /// operation and its arguments.
    pub fn start_change_request_execution(
        &self,
    ) -> fluent_builders::StartChangeRequestExecution<C, M, R> {
        fluent_builders::StartChangeRequestExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSession` operation.
    ///
    /// See [`StartSession`](crate::client::fluent_builders::StartSession) for more information about the
    /// operation and its arguments.
    pub fn start_session(&self) -> fluent_builders::StartSession<C, M, R> {
        fluent_builders::StartSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopAutomationExecution` operation.
    ///
    /// See [`StopAutomationExecution`](crate::client::fluent_builders::StopAutomationExecution) for more information about the
    /// operation and its arguments.
    pub fn stop_automation_execution(&self) -> fluent_builders::StopAutomationExecution<C, M, R> {
        fluent_builders::StopAutomationExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateSession` operation.
    ///
    /// See [`TerminateSession`](crate::client::fluent_builders::TerminateSession) for more information about the
    /// operation and its arguments.
    pub fn terminate_session(&self) -> fluent_builders::TerminateSession<C, M, R> {
        fluent_builders::TerminateSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnlabelParameterVersion` operation.
    ///
    /// See [`UnlabelParameterVersion`](crate::client::fluent_builders::UnlabelParameterVersion) for more information about the
    /// operation and its arguments.
    pub fn unlabel_parameter_version(&self) -> fluent_builders::UnlabelParameterVersion<C, M, R> {
        fluent_builders::UnlabelParameterVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssociation` operation.
    ///
    /// See [`UpdateAssociation`](crate::client::fluent_builders::UpdateAssociation) for more information about the
    /// operation and its arguments.
    pub fn update_association(&self) -> fluent_builders::UpdateAssociation<C, M, R> {
        fluent_builders::UpdateAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssociationStatus` operation.
    ///
    /// See [`UpdateAssociationStatus`](crate::client::fluent_builders::UpdateAssociationStatus) for more information about the
    /// operation and its arguments.
    pub fn update_association_status(&self) -> fluent_builders::UpdateAssociationStatus<C, M, R> {
        fluent_builders::UpdateAssociationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDocument` operation.
    ///
    /// See [`UpdateDocument`](crate::client::fluent_builders::UpdateDocument) for more information about the
    /// operation and its arguments.
    pub fn update_document(&self) -> fluent_builders::UpdateDocument<C, M, R> {
        fluent_builders::UpdateDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDocumentDefaultVersion` operation.
    ///
    /// See [`UpdateDocumentDefaultVersion`](crate::client::fluent_builders::UpdateDocumentDefaultVersion) for more information about the
    /// operation and its arguments.
    pub fn update_document_default_version(
        &self,
    ) -> fluent_builders::UpdateDocumentDefaultVersion<C, M, R> {
        fluent_builders::UpdateDocumentDefaultVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDocumentMetadata` operation.
    ///
    /// See [`UpdateDocumentMetadata`](crate::client::fluent_builders::UpdateDocumentMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_document_metadata(&self) -> fluent_builders::UpdateDocumentMetadata<C, M, R> {
        fluent_builders::UpdateDocumentMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMaintenanceWindow` operation.
    ///
    /// See [`UpdateMaintenanceWindow`](crate::client::fluent_builders::UpdateMaintenanceWindow) for more information about the
    /// operation and its arguments.
    pub fn update_maintenance_window(&self) -> fluent_builders::UpdateMaintenanceWindow<C, M, R> {
        fluent_builders::UpdateMaintenanceWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMaintenanceWindowTarget` operation.
    ///
    /// See [`UpdateMaintenanceWindowTarget`](crate::client::fluent_builders::UpdateMaintenanceWindowTarget) for more information about the
    /// operation and its arguments.
    pub fn update_maintenance_window_target(
        &self,
    ) -> fluent_builders::UpdateMaintenanceWindowTarget<C, M, R> {
        fluent_builders::UpdateMaintenanceWindowTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMaintenanceWindowTask` operation.
    ///
    /// See [`UpdateMaintenanceWindowTask`](crate::client::fluent_builders::UpdateMaintenanceWindowTask) for more information about the
    /// operation and its arguments.
    pub fn update_maintenance_window_task(
        &self,
    ) -> fluent_builders::UpdateMaintenanceWindowTask<C, M, R> {
        fluent_builders::UpdateMaintenanceWindowTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateManagedInstanceRole` operation.
    ///
    /// See [`UpdateManagedInstanceRole`](crate::client::fluent_builders::UpdateManagedInstanceRole) for more information about the
    /// operation and its arguments.
    pub fn update_managed_instance_role(
        &self,
    ) -> fluent_builders::UpdateManagedInstanceRole<C, M, R> {
        fluent_builders::UpdateManagedInstanceRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOpsItem` operation.
    ///
    /// See [`UpdateOpsItem`](crate::client::fluent_builders::UpdateOpsItem) for more information about the
    /// operation and its arguments.
    pub fn update_ops_item(&self) -> fluent_builders::UpdateOpsItem<C, M, R> {
        fluent_builders::UpdateOpsItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOpsMetadata` operation.
    ///
    /// See [`UpdateOpsMetadata`](crate::client::fluent_builders::UpdateOpsMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_ops_metadata(&self) -> fluent_builders::UpdateOpsMetadata<C, M, R> {
        fluent_builders::UpdateOpsMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePatchBaseline` operation.
    ///
    /// See [`UpdatePatchBaseline`](crate::client::fluent_builders::UpdatePatchBaseline) for more information about the
    /// operation and its arguments.
    pub fn update_patch_baseline(&self) -> fluent_builders::UpdatePatchBaseline<C, M, R> {
        fluent_builders::UpdatePatchBaseline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResourceDataSync` operation.
    ///
    /// See [`UpdateResourceDataSync`](crate::client::fluent_builders::UpdateResourceDataSync) for more information about the
    /// operation and its arguments.
    pub fn update_resource_data_sync(&self) -> fluent_builders::UpdateResourceDataSync<C, M, R> {
        fluent_builders::UpdateResourceDataSync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceSetting` operation.
    ///
    /// See [`UpdateServiceSetting`](crate::client::fluent_builders::UpdateServiceSetting) for more information about the
    /// operation and its arguments.
    pub fn update_service_setting(&self) -> fluent_builders::UpdateServiceSetting<C, M, R> {
        fluent_builders::UpdateServiceSetting::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified resource. Tags are metadata that you
    /// can assign to your documents, managed instances, maintenance windows, Parameter Store parameters,
    /// and patch baselines. Tags enable you to categorize your resources in different ways, for example,
    /// by purpose, owner, or environment. Each tag consists of a key and an optional value, both of
    /// which you define. For example, you could define a set of tags for your account's managed
    /// instances that helps you track each instance's owner and stack level. For example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Key=Owner,Value=DbAdmin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Key=Owner,Value=SysAdmin</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Key=Owner,Value=Dev</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Key=Stack,Value=Production</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Key=Stack,Value=Pre-Production</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Key=Stack,Value=Test</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Each resource can have a maximum of 50 tags.</p>
    /// <p>We recommend that you devise a set of tag keys that meets your needs for each resource type.
    /// Using a consistent set of tag keys makes it easier for you to manage your resources. You can
    /// search and filter the resources based on the tags you add. Tags don't have any semantic meaning
    /// to and are interpreted strictly as a string of characters. </p>
    /// <p>For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2
    /// resources</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the type of resource you are tagging.</p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed
        /// instances. You must specify the name of the managed instance in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn resource_type(mut self, inp: crate::model::ResourceTypeForTagging) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>Specifies the type of resource you are tagging.</p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is for on-premises managed
        /// instances. You must specify the name of the managed instance in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceTypeForTagging>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The resource ID you want to tag.</p>
        /// <p>Use the ID of the resource. Here are some examples:</p>
        /// <p>
        /// <code>MaintenanceWindow</code>: <code>mw-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>PatchBaseline</code>: <code>pb-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the
        /// Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from
        /// the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an
        /// OpsMetadata object with an ARN of
        /// <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a
        /// <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or
        /// <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the
        /// resource.</p>
        /// <p>
        /// <code>ManagedInstance</code>: <code>mi-012345abcde</code>
        /// </p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises
        /// managed instances. You must specify the name of the managed instance in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The resource ID you want to tag.</p>
        /// <p>Use the ID of the resource. Here are some examples:</p>
        /// <p>
        /// <code>MaintenanceWindow</code>: <code>mw-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>PatchBaseline</code>: <code>pb-012345abcde</code>
        /// </p>
        /// <p>
        /// <code>OpsMetadata</code> object: <code>ResourceID</code> for tagging is created from the
        /// Amazon Resource Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from
        /// the strings that come after the word <code>opsmetadata</code> in the ARN. For example, an
        /// OpsMetadata object with an ARN of
        /// <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code> has a
        /// <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or
        /// <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the <code>Document</code> and <code>Parameter</code> values, use the name of the
        /// resource.</p>
        /// <p>
        /// <code>ManagedInstance</code>: <code>mi-012345abcde</code>
        /// </p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises
        /// managed instances. You must specify the name of the managed instance in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. The value parameter is required.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags. The value parameter is required.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateOpsItemRelatedItem`.
    ///
    /// <p>Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an
    /// Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of
    /// Amazon Web Services Systems Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateOpsItemRelatedItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_ops_item_related_item_input::Builder,
    }
    impl<C, M, R> AssociateOpsItemRelatedItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateOpsItemRelatedItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateOpsItemRelatedItemOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateOpsItemRelatedItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateOpsItemRelatedItemInputOperationOutputAlias,
                crate::output::AssociateOpsItemRelatedItemOutput,
                crate::error::AssociateOpsItemRelatedItemError,
                crate::input::AssociateOpsItemRelatedItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>
        pub fn ops_item_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(inp);
            self
        }
        /// <p>The ID of the OpsItem to which you want to associate a resource as a related item.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
        /// <p>The type of association that you want to create between an OpsItem and a resource. OpsCenter
        /// supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>
        pub fn association_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_type(inp);
            self
        }
        /// <p>The type of association that you want to create between an OpsItem and a resource. OpsCenter
        /// supports <code>IsParentOf</code> and <code>RelatesTo</code> association types.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_type(input);
            self
        }
        /// <p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the
        /// following types:</p>
        /// <p>
        /// <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p>
        /// <p>
        /// <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of resource that you want to associate with an OpsItem. OpsCenter supports the
        /// following types:</p>
        /// <p>
        /// <code>AWS::SSMIncidents::IncidentRecord</code>: an Incident Manager incident. </p>
        /// <p>
        /// <code>AWS::SSM::Document</code>: a Systems Manager (SSM) document.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the
        /// OpsItem.</p>
        pub fn resource_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_uri(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource that you want to associate with the
        /// OpsItem.</p>
        pub fn set_resource_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelCommand`.
    ///
    /// <p>Attempts to cancel the command specified by the Command ID. There is no guarantee that the
    /// command will be terminated and the underlying process stopped.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelCommand<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_command_input::Builder,
    }
    impl<C, M, R> CancelCommand<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelCommand`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelCommandOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelCommandError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelCommandInputOperationOutputAlias,
                crate::output::CancelCommandOutput,
                crate::error::CancelCommandError,
                crate::input::CancelCommandInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the command you want to cancel.</p>
        pub fn command_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(inp);
            self
        }
        /// <p>The ID of the command you want to cancel.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// Appends an item to `InstanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>(Optional) A list of instance IDs on which you want to cancel the command. If not provided,
        /// the command is canceled on every instance on which it was requested.</p>
        pub fn instance_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(inp);
            self
        }
        /// <p>(Optional) A list of instance IDs on which you want to cancel the command. If not provided,
        /// the command is canceled on every instance on which it was requested.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelMaintenanceWindowExecution`.
    ///
    /// <p>Stops a maintenance window execution that is already in progress and cancels any tasks in
    /// the window that haven't already starting running. Tasks already in progress will continue to
    /// completion.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelMaintenanceWindowExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_maintenance_window_execution_input::Builder,
    }
    impl<C, M, R> CancelMaintenanceWindowExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelMaintenanceWindowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelMaintenanceWindowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelMaintenanceWindowExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelMaintenanceWindowExecutionInputOperationOutputAlias,
                crate::output::CancelMaintenanceWindowExecutionOutput,
                crate::error::CancelMaintenanceWindowExecutionError,
                crate::input::CancelMaintenanceWindowExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution to stop.</p>
        pub fn window_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(inp);
            self
        }
        /// <p>The ID of the maintenance window execution to stop.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateActivation`.
    ///
    /// <p>Generates an activation code and activation ID you can use to register your on-premises
    /// server or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager makes it
    /// possible to manage them using Systems Manager capabilities. You use the activation code and ID when
    /// installing SSM Agent on machines in your hybrid environment. For more information about
    /// requirements for managing on-premises instances and VMs using Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting up
    /// Amazon Web Services Systems Manager for hybrid environments</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    /// <note>
    /// <p>On-premises servers or VMs that are registered with Systems Manager and Amazon Elastic Compute Cloud (Amazon EC2) instances
    /// that you manage with Systems Manager are all called <i>managed instances</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateActivation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_activation_input::Builder,
    }
    impl<C, M, R> CreateActivation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateActivation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateActivationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateActivationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateActivationInputOperationOutputAlias,
                crate::output::CreateActivationOutput,
                crate::error::CreateActivationError,
                crate::input::CreateActivationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-defined description of the resource that you want to register with Systems Manager. </p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A user-defined description of the resource that you want to register with Systems Manager. </p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the registered, managed instance as it will appear in the Amazon Web Services Systems Manager console or
        /// when you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn default_instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_instance_name(inp);
            self
        }
        /// <p>The name of the registered, managed instance as it will appear in the Amazon Web Services Systems Manager console or
        /// when you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_default_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_instance_name(input);
            self
        }
        /// <p>The name of the Identity and Access Management (IAM) role that you want to assign to
        /// the managed instance. This IAM role must provide AssumeRole permissions for the
        /// Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an
        /// IAM service role for a hybrid environment</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn iam_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(inp);
            self
        }
        /// <p>The name of the Identity and Access Management (IAM) role that you want to assign to
        /// the managed instance. This IAM role must provide AssumeRole permissions for the
        /// Amazon Web Services Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an
        /// IAM service role for a hybrid environment</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
        /// <p>Specify the maximum number of managed instances you want to register. The default value is
        /// <code>1</code>.</p>
        pub fn registration_limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.registration_limit(inp);
            self
        }
        /// <p>Specify the maximum number of managed instances you want to register. The default value is
        /// <code>1</code>.</p>
        pub fn set_registration_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_registration_limit(input);
            self
        }
        /// <p>The date by which this activation request should expire, in timestamp format, such as
        /// "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an
        /// expiration date, the activation code expires in 24 hours.</p>
        pub fn expiration_date(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.expiration_date(inp);
            self
        }
        /// <p>The date by which this activation request should expire, in timestamp format, such as
        /// "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an
        /// expiration date, the activation code expires in 24 hours.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_expiration_date(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// activation to identify which servers or virtual machines (VMs) in your on-premises environment
        /// you intend to activate. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID
        /// and code. When you specify the activation ID and code, tags assigned to the activation are
        /// automatically applied to the on-premises servers or VMs.</p>
        /// </important>
        /// <p>You can't add tags to or delete tags from an existing activation. You can tag your
        /// on-premises servers and VMs after they connect to Systems Manager for the first time and are assigned a
        /// managed instance ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
        /// prefixed with "mi-". For information about how to add tags to your managed instances, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed
        /// instances, see <a>RemoveTagsFromResource</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// activation to identify which servers or virtual machines (VMs) in your on-premises environment
        /// you intend to activate. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID
        /// and code. When you specify the activation ID and code, tags assigned to the activation are
        /// automatically applied to the on-premises servers or VMs.</p>
        /// </important>
        /// <p>You can't add tags to or delete tags from an existing activation. You can tag your
        /// on-premises servers and VMs after they connect to Systems Manager for the first time and are assigned a
        /// managed instance ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
        /// prefixed with "mi-". For information about how to add tags to your managed instances, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed
        /// instances, see <a>RemoveTagsFromResource</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssociation`.
    ///
    /// <p>A State Manager association defines the state that you want to maintain on your instances.
    /// For example, an association can specify that anti-virus software must be installed and running on
    /// your instances, or that certain ports must be closed. For static targets, the association
    /// specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an
    /// Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager
    /// applies the configuration when new instances are added to the group. The association also
    /// specifies actions to take when applying the configuration. For example, an association for
    /// anti-virus software might run once a day. If the software isn't installed, then State Manager
    /// installs it. If the software is installed, but the service isn't running, then the association
    /// might instruct State Manager to start the service. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_association_input::Builder,
    }
    impl<C, M, R> CreateAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssociationInputOperationOutputAlias,
                crate::output::CreateAssociationOutput,
                crate::error::CreateAssociationError,
                crate::input::CreateAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration
        /// information for the instance.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
        /// shared with you from another account.</p>
        /// <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you
        /// must specify the complete SSM document ARN, in the following format:</p>
        /// <p>
        /// <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i>
        /// </code>
        /// </p>
        /// <p>For example:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
        /// </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
        /// to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
        /// <code>My-Document</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration
        /// information for the instance.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
        /// shared with you from another account.</p>
        /// <p>For Systems Manager documents (SSM documents) that are shared with you from other Amazon Web Services accounts, you
        /// must specify the complete SSM document ARN, in the following format:</p>
        /// <p>
        /// <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i>
        /// </code>
        /// </p>
        /// <p>For example:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
        /// </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
        /// to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
        /// <code>My-Document</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The document version you want to associate with the target(s). Can be a specific version or
        /// the default version.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The document version you want to associate with the target(s). Can be a specific version or
        /// the default version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The instance ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify an instance ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The instance ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify an instance ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the runtime configuration of the document.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>The parameters for the runtime configuration of the document.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the association. You can target instances by using tags, Amazon Web Services resource
        /// groups, all instances in an Amazon Web Services account, or individual instance IDs. You can target all
        /// instances in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of
        /// <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The targets for the association. You can target instances by using tags, Amazon Web Services resource
        /// groups, all instances in an Amazon Web Services account, or individual instance IDs. You can target all
        /// instances in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of
        /// <code>*</code>. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>A cron expression when the association will be applied to the target(s).</p>
        pub fn schedule_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_expression(inp);
            self
        }
        /// <p>A cron expression when the association will be applied to the target(s).</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_expression(input);
            self
        }
        /// <p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output
        /// details of the request.</p>
        pub fn output_location(
            mut self,
            inp: crate::model::InstanceAssociationOutputLocation,
        ) -> Self {
            self.inner = self.inner.output_location(inp);
            self
        }
        /// <p>An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output
        /// details of the request.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// <p>Specify a descriptive name for the association.</p>
        pub fn association_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_name(inp);
            self
        }
        /// <p>Specify a descriptive name for the association.</p>
        pub fn set_association_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_name(input);
            self
        }
        /// <p>Specify the target for the association. This target is required for associations that use an
        /// Automation runbook and target resources by using rate controls. Automation is a capability of
        /// Amazon Web Services Systems Manager.</p>
        pub fn automation_target_parameter_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.automation_target_parameter_name(inp);
            self
        }
        /// <p>Specify the target for the association. This target is required for associations that use an
        /// Automation runbook and target resources by using rate controls. Automation is a capability of
        /// Amazon Web Services Systems Manager.</p>
        pub fn set_automation_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_target_parameter_name(input);
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn max_errors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_errors(inp);
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_errors(input);
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn max_concurrency(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_concurrency(inp);
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn compliance_severity(
            mut self,
            inp: crate::model::AssociationComplianceSeverity,
        ) -> Self {
            self.inner = self.inner.compliance_severity(inp);
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn set_compliance_severity(
            mut self,
            input: std::option::Option<crate::model::AssociationComplianceSeverity>,
        ) -> Self {
            self.inner = self.inner.set_compliance_severity(input);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn sync_compliance(mut self, inp: crate::model::AssociationSyncCompliance) -> Self {
            self.inner = self.inner.sync_compliance(inp);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn set_sync_compliance(
            mut self,
            input: std::option::Option<crate::model::AssociationSyncCompliance>,
        ) -> Self {
            self.inner = self.inner.set_sync_compliance(input);
            self
        }
        /// <p>By default, when you create a new association, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn apply_only_at_cron_interval(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_only_at_cron_interval(inp);
            self
        }
        /// <p>By default, when you create a new association, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn set_apply_only_at_cron_interval(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_only_at_cron_interval(input);
            self
        }
        /// Appends an item to `CalendarNames`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
        /// gate your associations under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn calendar_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calendar_names(inp);
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
        /// gate your associations under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_calendar_names(input);
            self
        }
        /// Appends an item to `TargetLocations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association. Use this action to create an association in multiple Regions and multiple
        /// accounts.</p>
        pub fn target_locations(mut self, inp: impl Into<crate::model::TargetLocation>) -> Self {
            self.inner = self.inner.target_locations(inp);
            self
        }
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association. Use this action to create an association in multiple Regions and multiple
        /// accounts.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.inner = self.inner.set_target_locations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssociationBatch`.
    ///
    /// <p>Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified instances or
    /// targets.</p>
    /// <p>When you associate a document with one or more instances using instance IDs or tags,
    /// Amazon Web Services Systems Manager Agent (SSM Agent) running on the instance processes the document and configures the
    /// instance as specified.</p>
    /// <p>If you associate a document with an instance that already has an associated document, the
    /// system returns the AssociationAlreadyExists exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssociationBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_association_batch_input::Builder,
    }
    impl<C, M, R> CreateAssociationBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssociationBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssociationBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssociationBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssociationBatchInputOperationOutputAlias,
                crate::output::CreateAssociationBatchOutput,
                crate::error::CreateAssociationBatchError,
                crate::input::CreateAssociationBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>One or more associations.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::CreateAssociationBatchRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>One or more associations.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssociationBatchRequestEntry>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDocument`.
    ///
    /// <p>Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs
    /// on your managed instances. For more information about SSM documents, including information about
    /// supported schemas, features, and syntax, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">Amazon Web Services Systems Manager Documents</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_document_input::Builder,
    }
    impl<C, M, R> CreateDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDocumentInputOperationOutputAlias,
                crate::output::CreateDocumentOutput,
                crate::error::CreateDocumentError,
                crate::input::CreateDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The content for the new SSM document in JSON or YAML format. We recommend storing the
        /// contents for your new document in an external JSON or YAML file and referencing the file in a
        /// command.</p>
        /// <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content for the new SSM document in JSON or YAML format. We recommend storing the
        /// contents for your new document in an external JSON or YAML file and referencing the file in a
        /// command.</p>
        /// <p>For examples, see the following topics in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `Requires`.
        ///
        /// To override the contents of this collection use [`set_requires`](Self::set_requires).
        ///
        /// <p>A list of SSM documents required by a document. This parameter is used exclusively by
        /// AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also
        /// specify a required document for validation purposes. In this case, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document for validation purposes. For more
        /// information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the
        /// <i>AppConfig User Guide</i>.</p>
        pub fn requires(mut self, inp: impl Into<crate::model::DocumentRequires>) -> Self {
            self.inner = self.inner.requires(inp);
            self
        }
        /// <p>A list of SSM documents required by a document. This parameter is used exclusively by
        /// AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also
        /// specify a required document for validation purposes. In this case, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document for validation purposes. For more
        /// information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig?</a> in the
        /// <i>AppConfig User Guide</i>.</p>
        pub fn set_requires(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        ) -> Self {
            self.inner = self.inner.set_requires(input);
            self
        }
        /// Appends an item to `Attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn attachments(mut self, inp: impl Into<crate::model::AttachmentsSource>) -> Self {
            self.inner = self.inner.attachments(inp);
            self
        }
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentsSource>>,
        ) -> Self {
            self.inner = self.inner.set_attachments(input);
            self
        }
        /// <p>A name for the SSM document.</p>
        /// <important>
        /// <p>You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services
        /// for use as document name prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aws-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amzn</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name for the SSM document.</p>
        /// <important>
        /// <p>You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services
        /// for use as document name prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>aws-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amazon</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>amzn</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can
        /// differ for each version of the document. You can update this value at a later time using the
        /// <a>UpdateDocument</a> operation.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can
        /// differ for each version of the document. You can update this value at a later time using the
        /// <a>UpdateDocument</a> operation.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>An optional field specifying the version of the artifact you are creating with the document.
        /// For example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>An optional field specifying the version of the artifact you are creating with the document.
        /// For example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The type of document to create.</p>
        pub fn document_type(mut self, inp: crate::model::DocumentType) -> Self {
            self.inner = self.inner.document_type(inp);
            self
        }
        /// <p>The type of document to create.</p>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<crate::model::DocumentType>,
        ) -> Self {
            self.inner = self.inner.set_document_type(input);
            self
        }
        /// <p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT.
        /// JSON is the default format.</p>
        pub fn document_format(mut self, inp: crate::model::DocumentFormat) -> Self {
            self.inner = self.inner.document_format(inp);
            self
        }
        /// <p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT.
        /// JSON is the default format.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.inner = self.inner.set_document_format(input);
            self
        }
        /// <p>Specify a target type to define the kinds of resources the document can run on. For example,
        /// to run a document on EC2 instances, specify the following value:
        /// <code>/AWS::EC2::Instance</code>. If you specify a value of '/' the document can run on all types
        /// of resources. If you don't specify a value, the document can't run on any resources. For a list
        /// of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn target_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_type(inp);
            self
        }
        /// <p>Specify a target type to define the kinds of resources the document can run on. For example,
        /// to run a document on EC2 instances, specify the following value:
        /// <code>/AWS::EC2::Instance</code>. If you specify a value of '/' the document can run on all types
        /// of resources. If you don't specify a value, the document can't run on any resources. For a list
        /// of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// SSM document to identify the types of targets or the environment where it will run. In this case,
        /// you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing SSM document, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag an
        /// SSM document to identify the types of targets or the environment where it will run. In this case,
        /// you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing SSM document, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMaintenanceWindow`.
    ///
    /// <p>Creates a new maintenance window.</p>
    /// <note>
    /// <p>The value you specify for <code>Duration</code> determines the specific end time for the
    /// maintenance window based on the time it begins. No maintenance window tasks are permitted to
    /// start after the resulting endtime minus the number of hours you specify for <code>Cutoff</code>.
    /// For example, if the maintenance window starts at 3 PM, the duration is three hours, and the
    /// value you specify for <code>Cutoff</code> is one hour, no maintenance window tasks can start
    /// after 5 PM.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_maintenance_window_input::Builder,
    }
    impl<C, M, R> CreateMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMaintenanceWindowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMaintenanceWindowInputOperationOutputAlias,
                crate::output::CreateMaintenanceWindowOutput,
                crate::error::CreateMaintenanceWindowError,
                crate::input::CreateMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the maintenance window.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the maintenance window. We recommend specifying a description to
        /// help you organize your maintenance windows. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the maintenance window. We recommend specifying a description to
        /// help you organize your maintenance windows. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become active. <code>StartDate</code> allows you to delay activation of the maintenance window
        /// until the specified future date.</p>
        pub fn start_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become active. <code>StartDate</code> allows you to delay activation of the maintenance window
        /// until the specified future date.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become inactive. <code>EndDate</code> allows you to set a date and time in the future when the
        /// maintenance window will no longer run.</p>
        pub fn end_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become inactive. <code>EndDate</code> allows you to set a date and time in the future when the
        /// maintenance window will no longer run.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn schedule_timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_timezone(inp);
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn set_schedule_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_timezone(input);
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before
        /// running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run on the
        /// third Tuesday of every month at 11:30 PM.</p>
        /// <p>
        /// <code>cron(30 23 ? * TUE#3 *)</code>
        /// </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days
        /// later.</p>
        pub fn schedule_offset(mut self, inp: i32) -> Self {
            self.inner = self.inner.schedule_offset(inp);
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before
        /// running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run on the
        /// third Tuesday of every month at 11:30 PM.</p>
        /// <p>
        /// <code>cron(30 23 ? * TUE#3 *)</code>
        /// </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days
        /// later.</p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_schedule_offset(input);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
        /// new tasks for execution.</p>
        pub fn cutoff(mut self, inp: i32) -> Self {
            self.inner = self.inner.cutoff(inp);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
        /// new tasks for execution.</p>
        pub fn set_cutoff(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_cutoff(input);
            self
        }
        /// <p>Enables a maintenance window task to run on managed instances, even if you haven't
        /// registered those instances as targets. If enabled, then you must specify the unregistered
        /// instances (by instance ID) when you register a task with the maintenance window.</p>
        /// <p>If you don't enable this option, then you must specify previously-registered targets when
        /// you register a task with the maintenance window.</p>
        pub fn allow_unassociated_targets(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_unassociated_targets(inp);
            self
        }
        /// <p>Enables a maintenance window task to run on managed instances, even if you haven't
        /// registered those instances as targets. If enabled, then you must specify the unregistered
        /// instances (by instance ID) when you register a task with the maintenance window.</p>
        /// <p>If you don't enable this option, then you must specify previously-registered targets when
        /// you register a task with the maintenance window.</p>
        pub fn set_allow_unassociated_targets(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_unassociated_targets(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// maintenance window to identify the type of tasks it will run, the types of targets, and the
        /// environment it will run in. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=TaskType,Value=AgentUpdate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing maintenance window, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// maintenance window to identify the type of tasks it will run, the types of targets, and the
        /// environment it will run in. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=TaskType,Value=AgentUpdate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing maintenance window, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOpsItem`.
    ///
    /// <p>Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
    /// OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
    /// remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
    /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems Manager OpsCenter</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOpsItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ops_item_input::Builder,
    }
    impl<C, M, R> CreateOpsItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOpsItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOpsItemOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOpsItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOpsItemInputOperationOutputAlias,
                crate::output::CreateOpsItemOutput,
                crate::error::CreateOpsItemError,
                crate::input::CreateOpsItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Information about the OpsItem. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Information about the OpsItem. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of OpsItem to create. Currently, the only valid values are
        /// <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>
        pub fn ops_item_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_type(inp);
            self
        }
        /// <p>The type of OpsItem to create. Currently, the only valid values are
        /// <code>/aws/changerequest</code> and <code>/aws/issue</code>.</p>
        pub fn set_ops_item_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_type(input);
            self
        }
        /// Adds a key-value pair to `OperationalData`.
        ///
        /// To override the contents of this collection use [`set_operational_data`](Self::set_operational_data).
        ///
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn operational_data(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OpsItemDataValue>,
        ) -> Self {
            self.inner = self.inner.operational_data(k, v);
            self
        }
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_operational_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_operational_data(input);
            self
        }
        /// Appends an item to `Notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
        /// OpsItem is edited or changed.</p>
        pub fn notifications(mut self, inp: impl Into<crate::model::OpsItemNotification>) -> Self {
            self.inner = self.inner.notifications(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
        /// OpsItem is edited or changed.</p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
        ) -> Self {
            self.inner = self.inner.set_notifications(input);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// Appends an item to `RelatedOpsItems`.
        ///
        /// To override the contents of this collection use [`set_related_ops_items`](Self::set_related_ops_items).
        ///
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn related_ops_items(mut self, inp: impl Into<crate::model::RelatedOpsItem>) -> Self {
            self.inner = self.inner.related_ops_items(inp);
            self
        }
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn set_related_ops_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
        ) -> Self {
            self.inner = self.inner.set_related_ops_items(input);
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p>
        /// <note>
        /// <p>The source name can't contain the following strings: <code>aws</code>, <code>amazon</code>,
        /// and <code>amzn</code>. </p>
        /// </note>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p>
        /// <note>
        /// <p>The source name can't contain the following strings: <code>aws</code>, <code>amazon</code>,
        /// and <code>amzn</code>. </p>
        /// </note>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by
        /// using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>Tags use a key-value pair. For example:</p>
        /// <p>
        /// <code>Key=Department,Value=Finance</code>
        /// </p>
        /// <important>
        /// <p>To add tags to a new OpsItem, a user must have IAM permissions for both the
        /// <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation.
        /// To add tags to an existing OpsItem, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </important>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by
        /// using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>Tags use a key-value pair. For example:</p>
        /// <p>
        /// <code>Key=Department,Value=Finance</code>
        /// </p>
        /// <important>
        /// <p>To add tags to a new OpsItem, a user must have IAM permissions for both the
        /// <code>ssm:CreateOpsItems</code> operation and the <code>ssm:AddTagsToResource</code> operation.
        /// To add tags to an existing OpsItem, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </important>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specify a category to assign to an OpsItem. </p>
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// <p>Specify a category to assign to an OpsItem. </p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>Specify a severity to assign to an OpsItem.</p>
        pub fn severity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity(inp);
            self
        }
        /// <p>Specify a severity to assign to an OpsItem.</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.actual_start_time(inp);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_actual_start_time(input);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.actual_end_time(inp);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_actual_end_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.planned_start_time(inp);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_planned_start_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.planned_end_time(inp);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_planned_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOpsMetadata`.
    ///
    /// <p>If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify
    /// information about the new application, including the application type.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateOpsMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ops_metadata_input::Builder,
    }
    impl<C, M, R> CreateOpsMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOpsMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOpsMetadataInputOperationOutputAlias,
                crate::output::CreateOpsMetadataOutput,
                crate::error::CreateOpsMetadataError,
                crate::input::CreateOpsMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A resource ID for a new Application Manager application.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>A resource ID for a new Application Manager application.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Adds a key-value pair to `Metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>Metadata for a new Application Manager application. </p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MetadataValue>,
        ) -> Self {
            self.inner = self.inner.metadata(k, v);
            self
        }
        /// <p>Metadata for a new Application Manager application. </p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by
        /// purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to
        /// identify an environment or target Amazon Web Services Region. In this case, you could specify the following
        /// key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Region,Value=us-east-2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// an OpsMetadata object. Tags enable you to categorize a resource in different ways, such as by
        /// purpose, owner, or environment. For example, you might want to tag an OpsMetadata object to
        /// identify an environment or target Amazon Web Services Region. In this case, you could specify the following
        /// key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Region,Value=us-east-2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePatchBaseline`.
    ///
    /// <p>Creates a patch baseline.</p>
    /// <note>
    /// <p>For information about valid key-value pairs in <code>PatchFilters</code> for each supported
    /// operating system type, see <a>PatchFilter</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreatePatchBaseline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_patch_baseline_input::Builder,
    }
    impl<C, M, R> CreatePatchBaseline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePatchBaselineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePatchBaselineInputOperationOutputAlias,
                crate::output::CreatePatchBaselineOutput,
                crate::error::CreatePatchBaselineError,
                crate::input::CreatePatchBaselineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines the operating system the patch baseline applies to. The default value is
        /// <code>WINDOWS</code>.</p>
        pub fn operating_system(mut self, inp: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(inp);
            self
        }
        /// <p>Defines the operating system the patch baseline applies to. The default value is
        /// <code>WINDOWS</code>.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn global_filters(mut self, inp: crate::model::PatchFilterGroup) -> Self {
            self.inner = self.inner.global_filters(inp);
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn set_global_filters(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.inner = self.inner.set_global_filters(input);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn approval_rules(mut self, inp: crate::model::PatchRuleGroup) -> Self {
            self.inner = self.inner.approval_rules(inp);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<crate::model::PatchRuleGroup>,
        ) -> Self {
            self.inner = self.inner.set_approval_rules(input);
            self
        }
        /// Appends an item to `ApprovedPatches`.
        ///
        /// To override the contents of this collection use [`set_approved_patches`](Self::set_approved_patches).
        ///
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn approved_patches(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approved_patches(inp);
            self
        }
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_approved_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches(input);
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as
        /// missing, this value describes the severity of the compliance violation. The default value is
        /// <code>UNSPECIFIED</code>.</p>
        pub fn approved_patches_compliance_level(
            mut self,
            inp: crate::model::PatchComplianceLevel,
        ) -> Self {
            self.inner = self.inner.approved_patches_compliance_level(inp);
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as
        /// missing, this value describes the severity of the compliance violation. The default value is
        /// <code>UNSPECIFIED</code>.</p>
        pub fn set_approved_patches_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches_compliance_level(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the instances. The default value is <code>false</code>. Applies to Linux instances
        /// only.</p>
        pub fn approved_patches_enable_non_security(mut self, inp: bool) -> Self {
            self.inner = self.inner.approved_patches_enable_non_security(inp);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the instances. The default value is <code>false</code>. Applies to Linux instances
        /// only.</p>
        pub fn set_approved_patches_enable_non_security(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches_enable_non_security(input);
            self
        }
        /// Appends an item to `RejectedPatches`.
        ///
        /// To override the contents of this collection use [`set_rejected_patches`](Self::set_rejected_patches).
        ///
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn rejected_patches(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rejected_patches(inp);
            self
        }
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_rejected_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rejected_patches(input);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ALLOW_AS_DEPENDENCY</code>
        /// </b>: A package in the
        /// <code>Rejected</code> patches list is installed only if it is a dependency of another package.
        /// It is considered compliant with the patch baseline, and its status is reported as
        /// <code>InstalledOther</code>. This is the default action if no option is specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BLOCK</code>
        /// </b>: Packages in the
        /// <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't
        /// installed under any circumstances. If a package was installed before it was added to the
        /// Rejected patches list, it is considered non-compliant with the patch baseline, and its status
        /// is reported as <code>InstalledRejected</code>.</p>
        /// </li>
        /// </ul>
        pub fn rejected_patches_action(mut self, inp: crate::model::PatchAction) -> Self {
            self.inner = self.inner.rejected_patches_action(inp);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ALLOW_AS_DEPENDENCY</code>
        /// </b>: A package in the
        /// <code>Rejected</code> patches list is installed only if it is a dependency of another package.
        /// It is considered compliant with the patch baseline, and its status is reported as
        /// <code>InstalledOther</code>. This is the default action if no option is specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BLOCK</code>
        /// </b>: Packages in the
        /// <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't
        /// installed under any circumstances. If a package was installed before it was added to the
        /// Rejected patches list, it is considered non-compliant with the patch baseline, and its status
        /// is reported as <code>InstalledRejected</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_rejected_patches_action(
            mut self,
            input: std::option::Option<crate::model::PatchAction>,
        ) -> Self {
            self.inner = self.inner.set_rejected_patches_action(input);
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>Information about the patches to use to update the instances, including target operating
        /// systems and source repositories. Applies to Linux instances only.</p>
        pub fn sources(mut self, inp: impl Into<crate::model::PatchSource>) -> Self {
            self.inner = self.inner.sources(inp);
            self
        }
        /// <p>Information about the patches to use to update the instances, including target operating
        /// systems and source repositories. Applies to Linux instances only.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// patch baseline to identify the severity level of patches it specifies and the operating system
        /// family it applies to. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=PatchSeverity,Value=Critical</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// patch baseline to identify the severity level of patches it specifies and the operating system
        /// family it applies to. In this case, you could specify the following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=PatchSeverity,Value=Critical</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceDataSync`.
    ///
    /// <p>A resource data sync helps you view data from multiple sources in a single location.
    /// Amazon Web Services Systems Manager offers two types of resource data sync: <code>SyncToDestination</code> and
    /// <code>SyncFromSource</code>.</p>
    /// <p>You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to
    /// synchronize Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring resource data
    /// sync for Inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize
    /// operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a
    /// single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple
    /// Amazon Web Services accounts and Amazon Web Services Regions or <code>EntireOrganization</code> by using Organizations. For more
    /// information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up Systems Manager
    /// Explorer to display data from multiple accounts and Regions</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>A resource data sync is an asynchronous operation that returns immediately. After a
    /// successful initial sync is completed, the system continuously syncs data. To check the status of
    /// a sync, use the <a>ListResourceDataSync</a>.</p>
    /// <note>
    /// <p>By default, data isn't encrypted in Amazon S3. We strongly recommend that you
    /// enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you
    /// secure access to the Amazon S3 bucket by creating a restrictive bucket policy. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateResourceDataSync<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_data_sync_input::Builder,
    }
    impl<C, M, R> CreateResourceDataSync<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceDataSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceDataSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceDataSyncError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceDataSyncInputOperationOutputAlias,
                crate::output::CreateResourceDataSyncOutput,
                crate::error::CreateResourceDataSyncError,
                crate::input::CreateResourceDataSyncInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the configuration.</p>
        pub fn sync_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_name(inp);
            self
        }
        /// <p>A name for the configuration.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_name(input);
            self
        }
        /// <p>Amazon S3 configuration details for the sync. This parameter is required if the
        /// <code>SyncType</code> value is SyncToDestination.</p>
        pub fn s3_destination(mut self, inp: crate::model::ResourceDataSyncS3Destination) -> Self {
            self.inner = self.inner.s3_destination(inp);
            self
        }
        /// <p>Amazon S3 configuration details for the sync. This parameter is required if the
        /// <code>SyncType</code> value is SyncToDestination.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncS3Destination>,
        ) -> Self {
            self.inner = self.inner.set_s3_destination(input);
            self
        }
        /// <p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data
        /// to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a
        /// value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data
        /// from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as
        /// listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a
        /// value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>
        pub fn sync_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_type(inp);
            self
        }
        /// <p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data
        /// to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a
        /// value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data
        /// from a single account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as
        /// listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a
        /// value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
        /// <p>Specify information about the data sources to synchronize. This parameter is required if the
        /// <code>SyncType</code> value is SyncFromSource.</p>
        pub fn sync_source(mut self, inp: crate::model::ResourceDataSyncSource) -> Self {
            self.inner = self.inner.sync_source(inp);
            self
        }
        /// <p>Specify information about the data sources to synchronize. This parameter is required if the
        /// <code>SyncType</code> value is SyncFromSource.</p>
        pub fn set_sync_source(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncSource>,
        ) -> Self {
            self.inner = self.inner.set_sync_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteActivation`.
    ///
    /// <p>Deletes an activation. You aren't required to delete an activation. If you delete an
    /// activation, you can no longer use it to register additional managed instances. Deleting an
    /// activation doesn't de-register managed instances. You must manually de-register managed
    /// instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteActivation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_activation_input::Builder,
    }
    impl<C, M, R> DeleteActivation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteActivation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteActivationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteActivationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteActivationInputOperationOutputAlias,
                crate::output::DeleteActivationOutput,
                crate::error::DeleteActivationError,
                crate::input::DeleteActivationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the activation that you want to delete.</p>
        pub fn activation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.activation_id(inp);
            self
        }
        /// <p>The ID of the activation that you want to delete.</p>
        pub fn set_activation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_activation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssociation`.
    ///
    /// <p>Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified instance.
    /// If you created the association by using the <code>Targets</code> parameter, then you must delete
    /// the association by using the association ID.</p>
    /// <p>When you disassociate a document from an instance, it doesn't change the configuration of
    /// the instance. To change the configuration state of an instance after you disassociate a document,
    /// you must create a new document with the desired configuration and associate it with the
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_association_input::Builder,
    }
    impl<C, M, R> DeleteAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssociationInputOperationOutputAlias,
                crate::output::DeleteAssociationOutput,
                crate::error::DeleteAssociationError,
                crate::input::DeleteAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The instance ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify an instance ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The instance ID.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated. To specify an instance ID for an association,
        /// use the <code>Targets</code> parameter. Requests that include the
        /// parameter <code>InstanceID</code> with Systems Manager documents (SSM documents) that use schema version
        /// 2.0 or later will fail. In addition, if you use the parameter
        /// <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
        /// <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
        /// <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you
        /// must use the <code>Targets</code> parameter.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The association ID that you want to delete.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The association ID that you want to delete.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDocument`.
    ///
    /// <p>Deletes the Amazon Web Services Systems Manager document (SSM document) and all instance associations to the
    /// document.</p>
    /// <p>Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances that are associated with the document.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_document_input::Builder,
    }
    impl<C, M, R> DeleteDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDocumentInputOperationOutputAlias,
                crate::output::DeleteDocumentOutput,
                crate::error::DeleteDocumentError,
                crate::input::DeleteDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the document that you want to delete. If not provided, all versions of the
        /// document are deleted.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The version of the document that you want to delete. If not provided, all versions of the
        /// document are deleted.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The version name of the document that you want to delete. If not provided, all versions of
        /// the document are deleted.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>The version name of the document that you want to delete. If not provided, all versions of
        /// the document are deleted.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>Some SSM document types require that you specify a <code>Force</code> flag before you can
        /// delete the document. For example, you must specify a <code>Force</code> flag to delete a document
        /// of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the
        /// <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>Some SSM document types require that you specify a <code>Force</code> flag before you can
        /// delete the document. For example, you must specify a <code>Force</code> flag to delete a document
        /// of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the
        /// <code>Force</code> flag in an Identity and Access Management (IAM) policy.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInventory`.
    ///
    /// <p>Delete a custom inventory type or the data associated with a custom Inventory type. Deleting
    /// a custom inventory type is also referred to as deleting a custom inventory schema.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInventory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_inventory_input::Builder,
    }
    impl<C, M, R> DeleteInventory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInventoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInventoryInputOperationOutputAlias,
                crate::output::DeleteInventoryOutput,
                crate::error::DeleteInventoryError,
                crate::input::DeleteInventoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom inventory type for which you want to delete either all previously
        /// collected data or the inventory type itself. </p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the custom inventory type for which you want to delete either all previously
        /// collected data or the inventory type itself. </p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you
        /// don't choose this option, the system only deletes existing inventory data associated with the
        /// custom inventory type. Choose one of the following options:</p>
        /// <p>DisableSchema: If you choose this option, the system ignores all inventory data for the
        /// specified version, and any earlier versions. To enable this schema again, you must call the
        /// <code>PutInventory</code> operation for a version greater than the disabled version.</p>
        /// <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You
        /// can recreate the schema later, if you want.</p>
        pub fn schema_delete_option(
            mut self,
            inp: crate::model::InventorySchemaDeleteOption,
        ) -> Self {
            self.inner = self.inner.schema_delete_option(inp);
            self
        }
        /// <p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you
        /// don't choose this option, the system only deletes existing inventory data associated with the
        /// custom inventory type. Choose one of the following options:</p>
        /// <p>DisableSchema: If you choose this option, the system ignores all inventory data for the
        /// specified version, and any earlier versions. To enable this schema again, you must call the
        /// <code>PutInventory</code> operation for a version greater than the disabled version.</p>
        /// <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You
        /// can recreate the schema later, if you want.</p>
        pub fn set_schema_delete_option(
            mut self,
            input: std::option::Option<crate::model::InventorySchemaDeleteOption>,
        ) -> Self {
            self.inner = self.inner.set_schema_delete_option(input);
            self
        }
        /// <p>Use this option to view a summary of the deletion request without deleting any data or the
        /// data type. This option is useful when you only want to understand what will be deleted. Once you
        /// validate that the data to be deleted is what you intend to delete, you can run the same command
        /// without specifying the <code>DryRun</code> option.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Use this option to view a summary of the deletion request without deleting any data or the
        /// data type. This option is useful when you only want to understand what will be deleted. Once you
        /// validate that the data to be deleted is what you intend to delete, you can run the same command
        /// without specifying the <code>DryRun</code> option.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMaintenanceWindow`.
    ///
    /// <p>Deletes a maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_maintenance_window_input::Builder,
    }
    impl<C, M, R> DeleteMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMaintenanceWindowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMaintenanceWindowInputOperationOutputAlias,
                crate::output::DeleteMaintenanceWindowOutput,
                crate::error::DeleteMaintenanceWindowError,
                crate::input::DeleteMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window to delete.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window to delete.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOpsMetadata`.
    ///
    /// <p>Delete OpsMetadata related to an application.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOpsMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ops_metadata_input::Builder,
    }
    impl<C, M, R> DeleteOpsMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOpsMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOpsMetadataInputOperationOutputAlias,
                crate::output::DeleteOpsMetadataOutput,
                crate::error::DeleteOpsMetadataError,
                crate::input::DeleteOpsMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>
        pub fn ops_metadata_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_metadata_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to delete.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_metadata_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParameter`.
    ///
    /// <p>Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds
    /// to create a parameter with the same name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteParameter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_parameter_input::Builder,
    }
    impl<C, M, R> DeleteParameter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParameterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteParameterInputOperationOutputAlias,
                crate::output::DeleteParameterOutput,
                crate::error::DeleteParameterError,
                crate::input::DeleteParameterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the parameter to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParameters`.
    ///
    /// <p>Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to
    /// create a parameter with the same name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_parameters_input::Builder,
    }
    impl<C, M, R> DeleteParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteParametersInputOperationOutputAlias,
                crate::output::DeleteParametersOutput,
                crate::error::DeleteParametersError,
                crate::input::DeleteParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the parameters to delete. After deleting a parameter, wait for at least 30
        /// seconds to create a parameter with the same name.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>The names of the parameters to delete. After deleting a parameter, wait for at least 30
        /// seconds to create a parameter with the same name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePatchBaseline`.
    ///
    /// <p>Deletes a patch baseline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePatchBaseline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_patch_baseline_input::Builder,
    }
    impl<C, M, R> DeletePatchBaseline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePatchBaselineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePatchBaselineInputOperationOutputAlias,
                crate::output::DeletePatchBaselineOutput,
                crate::error::DeletePatchBaselineError,
                crate::input::DeletePatchBaselineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to delete.</p>
        pub fn baseline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(inp);
            self
        }
        /// <p>The ID of the patch baseline to delete.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceDataSync`.
    ///
    /// <p>Deletes a resource data sync configuration. After the configuration is deleted, changes to
    /// data on managed instances are no longer synced to or from the target. Deleting a sync
    /// configuration doesn't delete data.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourceDataSync<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_data_sync_input::Builder,
    }
    impl<C, M, R> DeleteResourceDataSync<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceDataSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceDataSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceDataSyncError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceDataSyncInputOperationOutputAlias,
                crate::output::DeleteResourceDataSyncOutput,
                crate::error::DeleteResourceDataSyncError,
                crate::input::DeleteResourceDataSyncInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the configuration to delete.</p>
        pub fn sync_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_name(inp);
            self
        }
        /// <p>The name of the configuration to delete.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_name(input);
            self
        }
        /// <p>Specify the type of resource data sync to delete.</p>
        pub fn sync_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_type(inp);
            self
        }
        /// <p>Specify the type of resource data sync to delete.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterManagedInstance`.
    ///
    /// <p>Removes the server or virtual machine from the list of registered servers. You can
    /// reregister the instance again at any time. If you don't plan to use Run Command on the server, we
    /// suggest uninstalling SSM Agent first.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterManagedInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_managed_instance_input::Builder,
    }
    impl<C, M, R> DeregisterManagedInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterManagedInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterManagedInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterManagedInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterManagedInstanceInputOperationOutputAlias,
                crate::output::DeregisterManagedInstanceOutput,
                crate::error::DeregisterManagedInstanceError,
                crate::input::DeregisterManagedInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the managed instance when you registered it using the activation process.
        /// </p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The ID assigned to the managed instance when you registered it using the activation process.
        /// </p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterPatchBaselineForPatchGroup`.
    ///
    /// <p>Removes a patch group from a patch baseline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterPatchBaselineForPatchGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_patch_baseline_for_patch_group_input::Builder,
    }
    impl<C, M, R> DeregisterPatchBaselineForPatchGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterPatchBaselineForPatchGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterPatchBaselineForPatchGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterPatchBaselineForPatchGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterPatchBaselineForPatchGroupInputOperationOutputAlias,
                crate::output::DeregisterPatchBaselineForPatchGroupOutput,
                crate::error::DeregisterPatchBaselineForPatchGroupError,
                crate::input::DeregisterPatchBaselineForPatchGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to deregister the patch group from.</p>
        pub fn baseline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(inp);
            self
        }
        /// <p>The ID of the patch baseline to deregister the patch group from.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
        /// <p>The name of the patch group that should be deregistered from the patch baseline.</p>
        pub fn patch_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(inp);
            self
        }
        /// <p>The name of the patch group that should be deregistered from the patch baseline.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTargetFromMaintenanceWindow`.
    ///
    /// <p>Removes a target from a maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterTargetFromMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_target_from_maintenance_window_input::Builder,
    }
    impl<C, M, R> DeregisterTargetFromMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterTargetFromMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTargetFromMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterTargetFromMaintenanceWindowError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterTargetFromMaintenanceWindowInputOperationOutputAlias,
                crate::output::DeregisterTargetFromMaintenanceWindowOutput,
                crate::error::DeregisterTargetFromMaintenanceWindowError,
                crate::input::DeregisterTargetFromMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window the target should be removed from.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window the target should be removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The ID of the target definition to remove.</p>
        pub fn window_target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_target_id(inp);
            self
        }
        /// <p>The ID of the target definition to remove.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_target_id(input);
            self
        }
        /// <p>The system checks if the target is being referenced by a task. If the target is being
        /// referenced, the system returns an error and doesn't deregister the target from the maintenance
        /// window.</p>
        pub fn safe(mut self, inp: bool) -> Self {
            self.inner = self.inner.safe(inp);
            self
        }
        /// <p>The system checks if the target is being referenced by a task. If the target is being
        /// referenced, the system returns an error and doesn't deregister the target from the maintenance
        /// window.</p>
        pub fn set_safe(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_safe(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTaskFromMaintenanceWindow`.
    ///
    /// <p>Removes a task from a maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterTaskFromMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_task_from_maintenance_window_input::Builder,
    }
    impl<C, M, R> DeregisterTaskFromMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterTaskFromMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTaskFromMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterTaskFromMaintenanceWindowError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterTaskFromMaintenanceWindowInputOperationOutputAlias,
                crate::output::DeregisterTaskFromMaintenanceWindowOutput,
                crate::error::DeregisterTaskFromMaintenanceWindowError,
                crate::input::DeregisterTaskFromMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window the task should be removed from.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window the task should be removed from.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The ID of the task to remove from the maintenance window.</p>
        pub fn window_task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_task_id(inp);
            self
        }
        /// <p>The ID of the task to remove from the maintenance window.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeActivations`.
    ///
    /// <p>Describes details about the activation, such as the date and time the activation was
    /// created, its expiration date, the Identity and Access Management (IAM) role assigned to
    /// the instances in the activation, and the number of instances registered by using this
    /// activation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeActivations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_activations_input::Builder,
    }
    impl<C, M, R> DescribeActivations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeActivations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActivationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActivationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeActivationsInputOperationOutputAlias,
                crate::output::DescribeActivationsOutput,
                crate::error::DescribeActivationsError,
                crate::input::DescribeActivationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter to view information about your activations.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::DescribeActivationsFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A filter to view information about your activations.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribeActivationsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssociation`.
    ///
    /// <p>Describes the association for the specified target or instance. If you created the
    /// association by using the <code>Targets</code> parameter, then you must retrieve the association
    /// by using the association ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_association_input::Builder,
    }
    impl<C, M, R> DescribeAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssociationInputOperationOutputAlias,
                crate::output::DescribeAssociationOutput,
                crate::error::DescribeAssociationError,
                crate::input::DescribeAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The association ID for which you want information.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The association ID for which you want information.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>Specify the association version to retrieve. To view the latest version, either specify
        /// <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all
        /// associations for an instance, use <a>ListAssociations</a>. To get a list of versions
        /// for a specific association, use <a>ListAssociationVersions</a>. </p>
        pub fn association_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_version(inp);
            self
        }
        /// <p>Specify the association version to retrieve. To view the latest version, either specify
        /// <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all
        /// associations for an instance, use <a>ListAssociations</a>. To get a list of versions
        /// for a specific association, use <a>ListAssociationVersions</a>. </p>
        pub fn set_association_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssociationExecutions`.
    ///
    /// <p>Views all executions for a specific association ID. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssociationExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_association_executions_input::Builder,
    }
    impl<C, M, R> DescribeAssociationExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssociationExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssociationExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssociationExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssociationExecutionsInputOperationOutputAlias,
                crate::output::DescribeAssociationExecutionsOutput,
                crate::error::DescribeAssociationExecutionsError,
                crate::input::DescribeAssociationExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The association ID for which you want to view execution history details.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The association ID for which you want to view execution history details.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>ExecutionId (EQUAL)</p>
        /// <p>Status (EQUAL)</p>
        /// <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>
        pub fn filters(mut self, inp: impl Into<crate::model::AssociationExecutionFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>ExecutionId (EQUAL)</p>
        /// <p>Status (EQUAL)</p>
        /// <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationExecutionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssociationExecutionTargets`.
    ///
    /// <p>Views information about a specific execution of a specific association.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssociationExecutionTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_association_execution_targets_input::Builder,
    }
    impl<C, M, R> DescribeAssociationExecutionTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssociationExecutionTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssociationExecutionTargetsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAssociationExecutionTargetsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssociationExecutionTargetsInputOperationOutputAlias,
                crate::output::DescribeAssociationExecutionTargetsOutput,
                crate::error::DescribeAssociationExecutionTargetsError,
                crate::input::DescribeAssociationExecutionTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The association ID that includes the execution for which you want to view details.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The association ID that includes the execution for which you want to view details.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The execution ID for which you want to view details.</p>
        pub fn execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_id(inp);
            self
        }
        /// <p>The execution ID for which you want to view details.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_execution_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>Status (EQUAL)</p>
        /// <p>ResourceId (EQUAL)</p>
        /// <p>ResourceType (EQUAL)</p>
        pub fn filters(
            mut self,
            inp: impl Into<crate::model::AssociationExecutionTargetsFilter>,
        ) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters for the request. You can specify the following filters and values.</p>
        /// <p>Status (EQUAL)</p>
        /// <p>ResourceId (EQUAL)</p>
        /// <p>ResourceType (EQUAL)</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociationExecutionTargetsFilter>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAutomationExecutions`.
    ///
    /// <p>Provides details about all active and terminated Automation executions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAutomationExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_automation_executions_input::Builder,
    }
    impl<C, M, R> DescribeAutomationExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAutomationExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAutomationExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAutomationExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAutomationExecutionsInputOperationOutputAlias,
                crate::output::DescribeAutomationExecutionsOutput,
                crate::error::DescribeAutomationExecutionsError,
                crate::input::DescribeAutomationExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters used to limit the scope of executions that are requested.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::AutomationExecutionFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters used to limit the scope of executions that are requested.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutomationExecutionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAutomationStepExecutions`.
    ///
    /// <p>Information about all active and terminated step executions in an Automation
    /// workflow.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAutomationStepExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_automation_step_executions_input::Builder,
    }
    impl<C, M, R> DescribeAutomationStepExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAutomationStepExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAutomationStepExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAutomationStepExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAutomationStepExecutionsInputOperationOutputAlias,
                crate::output::DescribeAutomationStepExecutionsOutput,
                crate::error::DescribeAutomationStepExecutionsError,
                crate::input::DescribeAutomationStepExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Automation execution ID for which you want step execution descriptions.</p>
        pub fn automation_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.automation_execution_id(inp);
            self
        }
        /// <p>The Automation execution ID for which you want step execution descriptions.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_execution_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the number of step executions returned by the request.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::StepExecutionFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters to limit the number of step executions returned by the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepExecutionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Indicates whether to list step executions in reverse order by start time. The default value
        /// is 'false'.</p>
        pub fn reverse_order(mut self, inp: bool) -> Self {
            self.inner = self.inner.reverse_order(inp);
            self
        }
        /// <p>Indicates whether to list step executions in reverse order by start time. The default value
        /// is 'false'.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAvailablePatches`.
    ///
    /// <p>Lists all patches eligible to be included in a patch baseline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAvailablePatches<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_available_patches_input::Builder,
    }
    impl<C, M, R> DescribeAvailablePatches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAvailablePatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAvailablePatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAvailablePatchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAvailablePatchesInputOperationOutputAlias,
                crate::output::DescribeAvailablePatchesOutput,
                crate::error::DescribeAvailablePatchesError,
                crate::input::DescribeAvailablePatchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>
        /// <b>Windows Server</b>
        /// </p>
        /// <p>Supported keys for Windows Server instance patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_SET</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>OS</code> | <code>APPLICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> |
        /// <code>MicrosoftDefenderAntivirus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT_FAMILY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Windows</code> | <code>Office</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MSRC_SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CLASSIFICATION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> |
        /// <code>DefinitionUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB123456</code> | <code>KB4516046</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Linux</b>
        /// </p>
        /// <important>
        /// <p>When specifying filters for Linux patches, you must specify a key-pair for
        /// <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the
        /// following command fails:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// <p>However, the following command succeeds:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03
        /// Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// </important>
        /// <p>Supported keys for Linux instance patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> |
        /// <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EPOCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>0</code> | <code>1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>VERSION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RELEASE</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ARCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>i686</code> | <code>x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>REPOSITORY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Core</code> | <code>Updates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADVISORY_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CVE_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BUGZILLA_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>1463241</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>
        /// <b>Windows Server</b>
        /// </p>
        /// <p>Supported keys for Windows Server instance patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_SET</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>OS</code> | <code>APPLICATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>WindowsServer2012</code> | <code>Office 2010</code> |
        /// <code>MicrosoftDefenderAntivirus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT_FAMILY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Windows</code> | <code>Office</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>MSRC_SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>Important</code> | <code>Moderate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CLASSIFICATION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ServicePacks</code> | <code>SecurityUpdates</code> |
        /// <code>DefinitionUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PATCH_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB123456</code> | <code>KB4516046</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>Linux</b>
        /// </p>
        /// <important>
        /// <p>When specifying filters for Linux patches, you must specify a key-pair for
        /// <code>PRODUCT</code>. For example, using the Command Line Interface (CLI), the
        /// following command fails:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// <p>However, the following command succeeds:</p>
        /// <p>
        /// <code>aws ssm describe-available-patches --filters Key=PRODUCT,Values=AmazonLinux2018.03
        /// Key=CVE_ID,Values=CVE-2018-3615</code>
        /// </p>
        /// </important>
        /// <p>Supported keys for Linux instance patches include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PRODUCT</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AmazonLinux2018.03</code> | <code>AmazonLinux2.0</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>kernel-headers</code> | <code>samba-python</code> | <code>php</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>SEVERITY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Critical</code> | <code>Important</code> | <code>Medium</code> |
        /// <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>EPOCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>0</code> | <code>1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>VERSION</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>78.6.1</code> | <code>4.10.16</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RELEASE</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>9.56.amzn1</code> | <code>1.amzn2</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ARCH</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>i686</code> | <code>x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>REPOSITORY</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Core</code> | <code>Updates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADVISORY_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>ALAS-2018-1058</code> | <code>ALAS2-2021-1594</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CVE_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>CVE-2018-3615</code> | <code>CVE-2020-1472</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BUGZILLA_ID</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>1463241</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocument`.
    ///
    /// <p>Describes the specified Amazon Web Services Systems Manager document (SSM document).</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_document_input::Builder,
    }
    impl<C, M, R> DescribeDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDocumentInputOperationOutputAlias,
                crate::output::DescribeDocumentOutput,
                crate::error::DescribeDocumentError,
                crate::input::DescribeDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The document version for which you want information. Can be a specific version or the
        /// default version.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The document version for which you want information. Can be a specific version or the
        /// default version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDocumentPermission`.
    ///
    /// <p>Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the
    /// document, you are the owner. If a document is shared, it can either be shared privately (by
    /// specifying a user's Amazon Web Services account ID) or publicly (<i>All</i>). </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDocumentPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_document_permission_input::Builder,
    }
    impl<C, M, R> DescribeDocumentPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDocumentPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDocumentPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDocumentPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDocumentPermissionInputOperationOutputAlias,
                crate::output::DescribeDocumentPermissionOutput,
                crate::error::DescribeDocumentPermissionError,
                crate::input::DescribeDocumentPermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document for which you are the owner.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the document for which you are the owner.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn permission_type(mut self, inp: crate::model::DocumentPermissionType) -> Self {
            self.inner = self.inner.permission_type(inp);
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::DocumentPermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEffectiveInstanceAssociations`.
    ///
    /// <p>All associations for the instance(s).</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEffectiveInstanceAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_effective_instance_associations_input::Builder,
    }
    impl<C, M, R> DescribeEffectiveInstanceAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEffectiveInstanceAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEffectiveInstanceAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEffectiveInstanceAssociationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEffectiveInstanceAssociationsInputOperationOutputAlias,
                crate::output::DescribeEffectiveInstanceAssociationsOutput,
                crate::error::DescribeEffectiveInstanceAssociationsError,
                crate::input::DescribeEffectiveInstanceAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance ID for which you want to view all associations.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The instance ID for which you want to view all associations.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEffectivePatchesForPatchBaseline`.
    ///
    /// <p>Retrieves the current effective patches (the patch and the approval state) for the specified
    /// patch baseline. Applies to patch baselines for Windows only.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEffectivePatchesForPatchBaseline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_effective_patches_for_patch_baseline_input::Builder,
    }
    impl<C, M, R> DescribeEffectivePatchesForPatchBaseline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEffectivePatchesForPatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEffectivePatchesForPatchBaselineOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEffectivePatchesForPatchBaselineError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEffectivePatchesForPatchBaselineInputOperationOutputAlias,
                crate::output::DescribeEffectivePatchesForPatchBaselineOutput,
                crate::error::DescribeEffectivePatchesForPatchBaselineError,
                crate::input::DescribeEffectivePatchesForPatchBaselineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to retrieve the effective patches for.</p>
        pub fn baseline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(inp);
            self
        }
        /// <p>The ID of the patch baseline to retrieve the effective patches for.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceAssociationsStatus`.
    ///
    /// <p>The status of the associations for the instance(s).</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstanceAssociationsStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_associations_status_input::Builder,
    }
    impl<C, M, R> DescribeInstanceAssociationsStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceAssociationsStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceAssociationsStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInstanceAssociationsStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceAssociationsStatusInputOperationOutputAlias,
                crate::output::DescribeInstanceAssociationsStatusOutput,
                crate::error::DescribeInstanceAssociationsStatusError,
                crate::input::DescribeInstanceAssociationsStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance IDs for which you want association status information.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The instance IDs for which you want association status information.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceInformation`.
    ///
    /// <p>Describes one or more of your instances, including information about the operating system
    /// platform, the version of SSM Agent installed on the instance, instance status, and so on.</p>
    /// <p>If you specify one or more instance IDs, it returns information for those instances. If you
    /// don't specify instance IDs, it returns information for all your instances. If you specify an
    /// instance ID that isn't valid or an instance that you don't own, you receive an error.</p>
    /// <note>
    /// <p>The <code>IamRole</code> field for this API operation is the Identity and Access Management
    /// (IAM) role assigned to on-premises instances. This call doesn't return the
    /// IAM role for EC2 instances.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstanceInformation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_information_input::Builder,
    }
    impl<C, M, R> DescribeInstanceInformation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceInformation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceInformationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceInformationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceInformationInputOperationOutputAlias,
                crate::output::DescribeInstanceInformationOutput,
                crate::error::DescribeInstanceInformationError,
                crate::input::DescribeInstanceInformationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `InstanceInformationFilterList`.
        ///
        /// To override the contents of this collection use [`set_instance_information_filter_list`](Self::set_instance_information_filter_list).
        ///
        /// <p>This is a legacy method. We recommend that you don't use this method. Instead, use the
        /// <code>Filters</code> data type. <code>Filters</code> enables you to return instance information
        /// by filtering based on tags applied to managed instances.</p>
        /// <note>
        /// <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads
        /// to an exception error. </p>
        /// </note>
        pub fn instance_information_filter_list(
            mut self,
            inp: impl Into<crate::model::InstanceInformationFilter>,
        ) -> Self {
            self.inner = self.inner.instance_information_filter_list(inp);
            self
        }
        /// <p>This is a legacy method. We recommend that you don't use this method. Instead, use the
        /// <code>Filters</code> data type. <code>Filters</code> enables you to return instance information
        /// by filtering based on tags applied to managed instances.</p>
        /// <note>
        /// <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads
        /// to an exception error. </p>
        /// </note>
        pub fn set_instance_information_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceInformationFilter>>,
        ) -> Self {
            self.inner = self.inner.set_instance_information_filter_list(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of instances. You can
        /// filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of
        /// <code>InstanceInformationFilterList</code>, which is deprecated.</p>
        pub fn filters(
            mut self,
            inp: impl Into<crate::model::InstanceInformationStringFilter>,
        ) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of instances. You can
        /// filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of
        /// <code>InstanceInformationFilterList</code>, which is deprecated.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InstanceInformationStringFilter>,
            >,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancePatches`.
    ///
    /// <p>Retrieves information about the patches on the specified instance and their state relative
    /// to the patch baseline being used for the instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstancePatches<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_patches_input::Builder,
    }
    impl<C, M, R> DescribeInstancePatches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstancePatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancePatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstancePatchesInputOperationOutputAlias,
                crate::output::DescribeInstancePatchesOutput,
                crate::error::DescribeInstancePatchesError,
                crate::input::DescribeInstancePatchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the instance whose patch state information should be retrieved.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The ID of the instance whose patch state information should be retrieved.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Classification</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>KBId</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Severity</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>State</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> |
        /// <code>InstalledPendingReboot</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribeInstancePatches</code>include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Classification</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Security</code> | <code>SecurityUpdates</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>KBId</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>KB4480056</code> | <code>java-1.7.0-openjdk.x86_64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Severity</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Important</code> | <code>Medium</code> | <code>Low</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>State</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>Installed</code> | <code>InstalledOther</code> |
        /// <code>InstalledPendingReboot</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancePatchStates`.
    ///
    /// <p>Retrieves the high-level patch state of one or more instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstancePatchStates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_patch_states_input::Builder,
    }
    impl<C, M, R> DescribeInstancePatchStates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstancePatchStates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancePatchStatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstancePatchStatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstancePatchStatesInputOperationOutputAlias,
                crate::output::DescribeInstancePatchStatesOutput,
                crate::error::DescribeInstancePatchStatesError,
                crate::input::DescribeInstancePatchStatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `InstanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The ID of the instance for which patch state information should be retrieved.</p>
        pub fn instance_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(inp);
            self
        }
        /// <p>The ID of the instance for which patch state information should be retrieved.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of instances to return (per page).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of instances to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstancePatchStatesForPatchGroup`.
    ///
    /// <p>Retrieves the high-level patch state for the instances in the specified patch group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstancePatchStatesForPatchGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_patch_states_for_patch_group_input::Builder,
    }
    impl<C, M, R> DescribeInstancePatchStatesForPatchGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstancePatchStatesForPatchGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstancePatchStatesForPatchGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInstancePatchStatesForPatchGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstancePatchStatesForPatchGroupInputOperationOutputAlias,
                crate::output::DescribeInstancePatchStatesForPatchGroupOutput,
                crate::error::DescribeInstancePatchStatesForPatchGroupError,
                crate::input::DescribeInstancePatchStatesForPatchGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the patch group for which the patch state information should be
        /// retrieved.</p>
        pub fn patch_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(inp);
            self
        }
        /// <p>The name of the patch group for which the patch state information should be
        /// retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key (string between 1 and 200 characters)</p>
        /// </li>
        /// <li>
        /// <p>Values (array containing a single string)</p>
        /// </li>
        /// <li>
        /// <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::InstancePatchStateFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key (string between 1 and 200 characters)</p>
        /// </li>
        /// <li>
        /// <p>Values (array containing a single string)</p>
        /// </li>
        /// <li>
        /// <p>Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePatchStateFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of patches to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInventoryDeletions`.
    ///
    /// <p>Describes a specific delete inventory operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInventoryDeletions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_inventory_deletions_input::Builder,
    }
    impl<C, M, R> DescribeInventoryDeletions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInventoryDeletions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInventoryDeletionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInventoryDeletionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInventoryDeletionsInputOperationOutputAlias,
                crate::output::DescribeInventoryDeletionsOutput,
                crate::error::DescribeInventoryDeletionsError,
                crate::input::DescribeInventoryDeletionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the delete inventory ID for which you want information. This ID was returned by the
        /// <code>DeleteInventory</code> operation.</p>
        pub fn deletion_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deletion_id(inp);
            self
        }
        /// <p>Specify the delete inventory ID for which you want information. This ID was returned by the
        /// <code>DeleteInventory</code> operation.</p>
        pub fn set_deletion_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_deletion_id(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowExecutions`.
    ///
    /// <p>Lists the executions of a maintenance window. This includes information about when the
    /// maintenance window was scheduled to be active, and information about tasks registered and run
    /// with the maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_window_executions_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindowExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindowExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowExecutionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMaintenanceWindowExecutionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceWindowExecutionsInputOperationOutputAlias,
                crate::output::DescribeMaintenanceWindowExecutionsOutput,
                crate::error::DescribeMaintenanceWindowExecutionsError,
                crate::input::DescribeMaintenanceWindowExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window whose executions should be retrieved.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window whose executions should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key. A string between 1 and 128 characters. Supported keys include
        /// <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p>
        /// </li>
        /// <li>
        /// <p>Values. An array of strings, each between 1 and 256 characters. Supported values are
        /// date/time strings in a valid ISO 8601 date/time format, such as
        /// <code>2021-11-04T05:00:00Z</code>.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Each entry in the array is a structure containing:</p>
        /// <ul>
        /// <li>
        /// <p>Key. A string between 1 and 128 characters. Supported keys include
        /// <code>ExecutedBefore</code> and <code>ExecutedAfter</code>.</p>
        /// </li>
        /// <li>
        /// <p>Values. An array of strings, each between 1 and 256 characters. Supported values are
        /// date/time strings in a valid ISO 8601 date/time format, such as
        /// <code>2021-11-04T05:00:00Z</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowExecutionTaskInvocations`.
    ///
    /// <p>Retrieves the individual task executions (one per target) for a particular task run as part
    /// of a maintenance window execution.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowExecutionTaskInvocations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_window_execution_task_invocations_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindowExecutionTaskInvocations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindowExecutionTaskInvocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput, aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInputOperationOutputAlias,
                                    crate::output::DescribeMaintenanceWindowExecutionTaskInvocationsOutput,
                                    crate::error::DescribeMaintenanceWindowExecutionTaskInvocationsError,
                                    crate::input::DescribeMaintenanceWindowExecutionTaskInvocationsInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution the task is part of.</p>
        pub fn window_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(inp);
            self
        }
        /// <p>The ID of the maintenance window execution the task is part of.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved.</p>
        pub fn task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(inp);
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned task invocations. The supported filter key
        /// is <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional filters used to scope down the returned task invocations. The supported filter key
        /// is <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowExecutionTasks`.
    ///
    /// <p>For a given maintenance window execution, lists the tasks that were run.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowExecutionTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_window_execution_tasks_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindowExecutionTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindowExecutionTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowExecutionTasksOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMaintenanceWindowExecutionTasksError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceWindowExecutionTasksInputOperationOutputAlias,
                crate::output::DescribeMaintenanceWindowExecutionTasksOutput,
                crate::error::DescribeMaintenanceWindowExecutionTasksError,
                crate::input::DescribeMaintenanceWindowExecutionTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution whose task executions should be retrieved.</p>
        pub fn window_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(inp);
            self
        }
        /// <p>The ID of the maintenance window execution whose task executions should be retrieved.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned tasks. The supported filter key is
        /// <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional filters used to scope down the returned tasks. The supported filter key is
        /// <code>STATUS</code> with the corresponding values <code>PENDING</code>,
        /// <code>IN_PROGRESS</code>, <code>SUCCESS</code>, <code>FAILED</code>, <code>TIMED_OUT</code>,
        /// <code>CANCELLING</code>, and <code>CANCELLED</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindows`.
    ///
    /// <p>Retrieves the maintenance windows in an Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_windows_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceWindowsInputOperationOutputAlias,
                crate::output::DescribeMaintenanceWindowsOutput,
                crate::error::DescribeMaintenanceWindowsError,
                crate::input::DescribeMaintenanceWindowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to narrow down the scope of the returned maintenance windows.
        /// Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example,
        /// <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional filters used to narrow down the scope of the returned maintenance windows.
        /// Supported filter keys are <code>Name</code> and <code>Enabled</code>. For example,
        /// <code>Name=MyMaintenanceWindow</code> and <code>Enabled=True</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowSchedule`.
    ///
    /// <p>Retrieves information about upcoming executions of a maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_window_schedule_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindowSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindowSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceWindowScheduleInputOperationOutputAlias,
                crate::output::DescribeMaintenanceWindowScheduleOutput,
                crate::error::DescribeMaintenanceWindowScheduleError,
                crate::input::DescribeMaintenanceWindowScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window to retrieve information about.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window to retrieve information about.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The instance ID or key-value pair to retrieve information about.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The instance ID or key-value pair to retrieve information about.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn resource_type(mut self, inp: crate::model::MaintenanceWindowResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters used to limit the range of results. For example, you can limit maintenance window
        /// executions to only those scheduled before or after a certain date and time.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters used to limit the range of results. For example, you can limit maintenance window
        /// executions to only those scheduled before or after a certain date and time.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowsForTarget`.
    ///
    /// <p>Retrieves information about the maintenance window targets or tasks that an instance is
    /// associated with.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowsForTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_windows_for_target_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindowsForTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindowsForTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowsForTargetOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMaintenanceWindowsForTargetError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceWindowsForTargetInputOperationOutputAlias,
                crate::output::DescribeMaintenanceWindowsForTargetOutput,
                crate::error::DescribeMaintenanceWindowsForTargetError,
                crate::input::DescribeMaintenanceWindowsForTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The instance ID or key-value pair to retrieve information about.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The instance ID or key-value pair to retrieve information about.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn resource_type(mut self, inp: crate::model::MaintenanceWindowResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of resource you want to retrieve information about. For example,
        /// <code>INSTANCE</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowTargets`.
    ///
    /// <p>Lists the targets registered with the maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_window_targets_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindowTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindowTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceWindowTargetsInputOperationOutputAlias,
                crate::output::DescribeMaintenanceWindowTargetsOutput,
                crate::error::DescribeMaintenanceWindowTargetsError,
                crate::input::DescribeMaintenanceWindowTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window whose targets should be retrieved.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window whose targets should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters that can be used to narrow down the scope of the returned window targets.
        /// The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and
        /// <code>OwnerInformation</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional filters that can be used to narrow down the scope of the returned window targets.
        /// The supported filter keys are <code>Type</code>, <code>WindowTargetId</code>, and
        /// <code>OwnerInformation</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMaintenanceWindowTasks`.
    ///
    /// <p>Lists the tasks in a maintenance window.</p>
    /// <note>
    /// <p>For maintenance window tasks without a specified target, you can't supply values for
    /// <code>--max-errors</code> and <code>--max-concurrency</code>. Instead, the system inserts a
    /// placeholder value of <code>1</code>, which may be reported in the response to this command.
    /// These values don't affect the running of your task and can be ignored.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMaintenanceWindowTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_maintenance_window_tasks_input::Builder,
    }
    impl<C, M, R> DescribeMaintenanceWindowTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMaintenanceWindowTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMaintenanceWindowTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMaintenanceWindowTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMaintenanceWindowTasksInputOperationOutputAlias,
                crate::output::DescribeMaintenanceWindowTasksOutput,
                crate::error::DescribeMaintenanceWindowTasksError,
                crate::input::DescribeMaintenanceWindowTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window whose tasks should be retrieved.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window whose tasks should be retrieved.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to narrow down the scope of the returned tasks. The supported filter
        /// keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and
        /// <code>TaskType</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::MaintenanceWindowFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional filters used to narrow down the scope of the returned tasks. The supported filter
        /// keys are <code>WindowTaskId</code>, <code>TaskArn</code>, <code>Priority</code>, and
        /// <code>TaskType</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceWindowFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOpsItems`.
    ///
    /// <p>Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
    /// OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
    /// remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
    /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOpsItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ops_items_input::Builder,
    }
    impl<C, M, R> DescribeOpsItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOpsItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOpsItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOpsItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOpsItemsInputOperationOutputAlias,
                crate::output::DescribeOpsItemsOutput,
                crate::error::DescribeOpsItemsError,
                crate::input::DescribeOpsItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `OpsItemFilters`.
        ///
        /// To override the contents of this collection use [`set_ops_item_filters`](Self::set_ops_item_filters).
        ///
        /// <p>One or more filters to limit the response.</p>
        /// <ul>
        /// <li>
        /// <p>Key: CreatedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedBy</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: Priority</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Source</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Status</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Title*</p>
        /// <p>Operations: Equals,Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalData**</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataKey</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataValue</p>
        /// <p>Operations: Equals, Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OpsItemId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: ResourceId</p>
        /// <p>Operations: Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: AutomationId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// </ul>
        /// <p>*The Equals operator for Title matches the first 100 characters. If you specify more than
        /// 100 characters, they system returns an error that the filter value exceeds the length
        /// limit.</p>
        /// <p>**If you filter the response by using the OperationalData operator, specify a key-value pair
        /// by using the following JSON format: {"key":"key_name","value":"a_value"}</p>
        pub fn ops_item_filters(mut self, inp: impl Into<crate::model::OpsItemFilter>) -> Self {
            self.inner = self.inner.ops_item_filters(inp);
            self
        }
        /// <p>One or more filters to limit the response.</p>
        /// <ul>
        /// <li>
        /// <p>Key: CreatedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedBy</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: LastModifiedTime</p>
        /// <p>Operations: GreaterThan, LessThan</p>
        /// </li>
        /// <li>
        /// <p>Key: Priority</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Source</p>
        /// <p>Operations: Contains, Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Status</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: Title*</p>
        /// <p>Operations: Equals,Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalData**</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataKey</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: OperationalDataValue</p>
        /// <p>Operations: Equals, Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: OpsItemId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// <li>
        /// <p>Key: ResourceId</p>
        /// <p>Operations: Contains</p>
        /// </li>
        /// <li>
        /// <p>Key: AutomationId</p>
        /// <p>Operations: Equals</p>
        /// </li>
        /// </ul>
        /// <p>*The Equals operator for Title matches the first 100 characters. If you specify more than
        /// 100 characters, they system returns an error that the filter value exceeds the length
        /// limit.</p>
        /// <p>**If you filter the response by using the OperationalData operator, specify a key-value pair
        /// by using the following JSON format: {"key":"key_name","value":"a_value"}</p>
        pub fn set_ops_item_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemFilter>>,
        ) -> Self {
            self.inner = self.inner.set_ops_item_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeParameters`.
    ///
    /// <p>Get information about a parameter.</p>
    /// <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code>
    /// in the request, the response includes information up to the limit specified. The number of items
    /// returned, however, can be between zero and the value of <code>MaxResults</code>. If the service
    /// reaches an internal limit while processing the results, it stops the operation and returns the
    /// matching values up to that point and a <code>NextToken</code>. You can specify the
    /// <code>NextToken</code> in a subsequent call to get the next set of results.</p>
    /// <important>
    /// <p>If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must
    /// also update the key alias the parameter uses to reference KMS. Otherwise,
    /// <code>DescribeParameters</code> retrieves whatever the original key alias was
    /// referencing.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DescribeParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_parameters_input::Builder,
    }
    impl<C, M, R> DescribeParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeParametersInputOperationOutputAlias,
                crate::output::DescribeParametersOutput,
                crate::error::DescribeParametersError,
                crate::input::DescribeParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ParametersFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParametersFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `ParameterFilters`.
        ///
        /// To override the contents of this collection use [`set_parameter_filters`](Self::set_parameter_filters).
        ///
        /// <p>Filters to limit the request results.</p>
        pub fn parameter_filters(
            mut self,
            inp: impl Into<crate::model::ParameterStringFilter>,
        ) -> Self {
            self.inner = self.inner.parameter_filters(inp);
            self
        }
        /// <p>Filters to limit the request results.</p>
        pub fn set_parameter_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchBaselines`.
    ///
    /// <p>Lists the patch baselines in your Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePatchBaselines<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_patch_baselines_input::Builder,
    }
    impl<C, M, R> DescribePatchBaselines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePatchBaselines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchBaselinesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchBaselinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePatchBaselinesInputOperationOutputAlias,
                crate::output::DescribePatchBaselinesOutput,
                crate::error::DescribePatchBaselinesError,
                crate::input::DescribePatchBaselinesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OWNER</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS</code> | <code>Self</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchBaselines</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OWNER</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS</code> | <code>Self</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of patch baselines to return (per page).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of patch baselines to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchGroups`.
    ///
    /// <p>Lists all patch groups that have been registered with patch baselines.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePatchGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_patch_groups_input::Builder,
    }
    impl<C, M, R> DescribePatchGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePatchGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePatchGroupsInputOperationOutputAlias,
                crate::output::DescribePatchGroupsOutput,
                crate::error::DescribePatchGroupsError,
                crate::input::DescribePatchGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of patch groups to return (per page).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of patch groups to return (per page).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::PatchOrchestratorFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Each element in the array is a structure containing a key-value pair.</p>
        /// <p>Supported keys for <code>DescribePatchGroups</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NAME_PREFIX</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AWS-</code> | <code>My-</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OPERATING_SYSTEM</code>
        /// </b>
        /// </p>
        /// <p>Sample values: <code>AMAZON_LINUX</code> | <code>SUSE</code> | <code>WINDOWS</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchOrchestratorFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchGroupState`.
    ///
    /// <p>Returns high-level aggregated patch compliance state information for a patch group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePatchGroupState<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_patch_group_state_input::Builder,
    }
    impl<C, M, R> DescribePatchGroupState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePatchGroupState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchGroupStateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchGroupStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePatchGroupStateInputOperationOutputAlias,
                crate::output::DescribePatchGroupStateOutput,
                crate::error::DescribePatchGroupStateError,
                crate::input::DescribePatchGroupStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the patch group whose patch snapshot should be retrieved.</p>
        pub fn patch_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(inp);
            self
        }
        /// <p>The name of the patch group whose patch snapshot should be retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePatchProperties`.
    ///
    /// <p>Lists the properties of available patches organized by product, product family,
    /// classification, severity, and other properties of available patches. You can use the reported
    /// properties in the filters you specify in requests for operations such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and <a>DescribePatchBaselines</a>.</p>
    /// <p>The following section lists the properties that can be used in filters for each major
    /// operating system type:</p>
    /// <dl>
    /// <dt>AMAZON_LINUX</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> |
    /// <code>SEVERITY</code>
    /// </p>
    /// </dd>
    /// <dt>AMAZON_LINUX_2</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> |
    /// <code>SEVERITY</code>
    /// </p>
    /// </dd>
    /// <dt>CENTOS</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> |
    /// <code>SEVERITY</code>
    /// </p>
    /// </dd>
    /// <dt>DEBIAN</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
    /// </p>
    /// </dd>
    /// <dt>MACOS</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code>
    /// </p>
    /// </dd>
    /// <dt>ORACLE_LINUX</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> |
    /// <code>SEVERITY</code>
    /// </p>
    /// </dd>
    /// <dt>REDHAT_ENTERPRISE_LINUX</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> |
    /// <code>SEVERITY</code>
    /// </p>
    /// </dd>
    /// <dt>SUSE</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> |
    /// <code>SEVERITY</code>
    /// </p>
    /// </dd>
    /// <dt>UBUNTU</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
    /// </p>
    /// </dd>
    /// <dt>WINDOWS</dt>
    /// <dd>
    /// <p>Valid properties: <code>PRODUCT</code> | <code>PRODUCT_FAMILY</code> |
    /// <code>CLASSIFICATION</code> | <code>MSRC_SEVERITY</code>
    /// </p>
    /// </dd>
    /// </dl>
    #[derive(std::fmt::Debug)]
    pub struct DescribePatchProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_patch_properties_input::Builder,
    }
    impl<C, M, R> DescribePatchProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePatchProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePatchPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePatchPropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePatchPropertiesInputOperationOutputAlias,
                crate::output::DescribePatchPropertiesOutput,
                crate::error::DescribePatchPropertiesError,
                crate::input::DescribePatchPropertiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The operating system type for which to list patches.</p>
        pub fn operating_system(mut self, inp: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(inp);
            self
        }
        /// <p>The operating system type for which to list patches.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
        /// <p>The patch property for which you want to view patch details. </p>
        pub fn property(mut self, inp: crate::model::PatchProperty) -> Self {
            self.inner = self.inner.property(inp);
            self
        }
        /// <p>The patch property for which you want to view patch details. </p>
        pub fn set_property(
            mut self,
            input: std::option::Option<crate::model::PatchProperty>,
        ) -> Self {
            self.inner = self.inner.set_property(input);
            self
        }
        /// <p>Indicates whether to list patches for the Windows operating system or for applications
        /// released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>
        pub fn patch_set(mut self, inp: crate::model::PatchSet) -> Self {
            self.inner = self.inner.patch_set(inp);
            self
        }
        /// <p>Indicates whether to list patches for the Windows operating system or for applications
        /// released by Microsoft. Not applicable for the Linux or macOS operating systems.</p>
        pub fn set_patch_set(mut self, input: std::option::Option<crate::model::PatchSet>) -> Self {
            self.inner = self.inner.set_patch_set(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSessions`.
    ///
    /// <p>Retrieves a list of all active sessions (both connected and disconnected) or terminated
    /// sessions from the past 30 days.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_sessions_input::Builder,
    }
    impl<C, M, R> DescribeSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSessionsInputOperationOutputAlias,
                crate::output::DescribeSessionsOutput,
                crate::error::DescribeSessionsError,
                crate::input::DescribeSessionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The session status to retrieve a list of sessions for. For example, "Active".</p>
        pub fn state(mut self, inp: crate::model::SessionState) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The session status to retrieve a list of sessions for. For example, "Active".</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::SessionState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the type of sessions returned by the request.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::SessionFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters to limit the type of sessions returned by the request.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SessionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateOpsItemRelatedItem`.
    ///
    /// <p>Deletes the association between an OpsItem and a related item. For example, this API
    /// operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a capability of
    /// Amazon Web Services Systems Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateOpsItemRelatedItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_ops_item_related_item_input::Builder,
    }
    impl<C, M, R> DisassociateOpsItemRelatedItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateOpsItemRelatedItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateOpsItemRelatedItemOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateOpsItemRelatedItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateOpsItemRelatedItemInputOperationOutputAlias,
                crate::output::DisassociateOpsItemRelatedItemOutput,
                crate::error::DisassociateOpsItemRelatedItemError,
                crate::input::DisassociateOpsItemRelatedItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a
        /// related item.</p>
        pub fn ops_item_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(inp);
            self
        }
        /// <p>The ID of the OpsItem for which you want to delete an association between the OpsItem and a
        /// related item.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
        /// <p>The ID of the association for which you want to delete an association between the OpsItem
        /// and a related item.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The ID of the association for which you want to delete an association between the OpsItem
        /// and a related item.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAutomationExecution`.
    ///
    /// <p>Get detailed information about a particular Automation execution.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAutomationExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_automation_execution_input::Builder,
    }
    impl<C, M, R> GetAutomationExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAutomationExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAutomationExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAutomationExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAutomationExecutionInputOperationOutputAlias,
                crate::output::GetAutomationExecutionOutput,
                crate::error::GetAutomationExecutionError,
                crate::input::GetAutomationExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an existing automation execution to examine. The execution ID is
        /// returned by StartAutomationExecution when the execution of an Automation runbook is
        /// initiated.</p>
        pub fn automation_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.automation_execution_id(inp);
            self
        }
        /// <p>The unique identifier for an existing automation execution to examine. The execution ID is
        /// returned by StartAutomationExecution when the execution of an Automation runbook is
        /// initiated.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCalendarState`.
    ///
    /// <p>Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If
    /// you specify a time, <code>GetCalendarState</code> returns the state of the calendar at that
    /// specific time, and returns the next time that the change calendar state will transition. If you
    /// don't specify a time, <code>GetCalendarState</code> uses the current time. Change Calendar
    /// entries have two possible states: <code>OPEN</code> or <code>CLOSED</code>.</p>
    /// <p>If you specify more than one calendar in a request, the command returns the status of
    /// <code>OPEN</code> only if all calendars in the request are open. If one or more calendars in the
    /// request are closed, the status returned is <code>CLOSED</code>.</p>
    /// <p>For more information about Change Calendar, a capability of Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">Amazon Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCalendarState<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_calendar_state_input::Builder,
    }
    impl<C, M, R> GetCalendarState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCalendarState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCalendarStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCalendarStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCalendarStateInputOperationOutputAlias,
                crate::output::GetCalendarStateOutput,
                crate::error::GetCalendarStateError,
                crate::input::GetCalendarStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `CalendarNames`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that
        /// represent the calendar entries for which you want to get the state.</p>
        pub fn calendar_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calendar_names(inp);
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents (SSM documents) that
        /// represent the calendar entries for which you want to get the state.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_calendar_names(input);
            self
        }
        /// <p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don't specify a
        /// value or <code>AtTime</code>, the current time is used.</p>
        pub fn at_time(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.at_time(inp);
            self
        }
        /// <p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you don't specify a
        /// value or <code>AtTime</code>, the current time is used.</p>
        pub fn set_at_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_at_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommandInvocation`.
    ///
    /// <p>Returns detailed information about command execution for an invocation or plugin.</p>
    /// <p>
    /// <code>GetCommandInvocation</code> only gives the execution status of a plugin in a document.
    /// To get the command execution status on a specific instance, use <a>ListCommandInvocations</a>. To get the command execution status across instances, use
    /// <a>ListCommands</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCommandInvocation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_command_invocation_input::Builder,
    }
    impl<C, M, R> GetCommandInvocation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCommandInvocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommandInvocationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommandInvocationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCommandInvocationInputOperationOutputAlias,
                crate::output::GetCommandInvocationOutput,
                crate::error::GetCommandInvocationError,
                crate::input::GetCommandInvocationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Required) The parent command ID of the invocation plugin.</p>
        pub fn command_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(inp);
            self
        }
        /// <p>(Required) The parent command ID of the invocation plugin.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// <p>(Required) The ID of the managed instance targeted by the command. A managed instance can be
        /// an Amazon Elastic Compute Cloud (Amazon EC2) instance or an instance in your hybrid environment that is configured for
        /// Amazon Web Services Systems Manager.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>(Required) The ID of the managed instance targeted by the command. A managed instance can be
        /// an Amazon Elastic Compute Cloud (Amazon EC2) instance or an instance in your hybrid environment that is configured for
        /// Amazon Web Services Systems Manager.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the plugin for which you want detailed results. If the document contains only
        /// one plugin, you can omit the name and details for that plugin. If the document contains more than
        /// one plugin, you must specify the name of the plugin for which you want to view details.</p>
        /// <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM
        /// documents). For example, <code>aws:RunShellScript</code> is a plugin.</p>
        /// <p>To find the <code>PluginName</code>, check the document content and find the name of the
        /// plugin. Alternatively, use <a>ListCommandInvocations</a> with the
        /// <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the
        /// <code>Name</code> attribute of the <code>CommandPlugin</code> object in the
        /// <code>CommandPlugins</code> list.</p>
        pub fn plugin_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.plugin_name(inp);
            self
        }
        /// <p>The name of the plugin for which you want detailed results. If the document contains only
        /// one plugin, you can omit the name and details for that plugin. If the document contains more than
        /// one plugin, you must specify the name of the plugin for which you want to view details.</p>
        /// <p>Plugin names are also referred to as <i>step names</i> in Systems Manager documents (SSM
        /// documents). For example, <code>aws:RunShellScript</code> is a plugin.</p>
        /// <p>To find the <code>PluginName</code>, check the document content and find the name of the
        /// plugin. Alternatively, use <a>ListCommandInvocations</a> with the
        /// <code>CommandId</code> and <code>Details</code> parameters. The <code>PluginName</code> is the
        /// <code>Name</code> attribute of the <code>CommandPlugin</code> object in the
        /// <code>CommandPlugins</code> list.</p>
        pub fn set_plugin_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_plugin_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectionStatus`.
    ///
    /// <p>Retrieves the Session Manager connection status for an instance to determine whether it is running and
    /// ready to receive Session Manager connections.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConnectionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connection_status_input::Builder,
    }
    impl<C, M, R> GetConnectionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectionStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectionStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectionStatusInputOperationOutputAlias,
                crate::output::GetConnectionStatusOutput,
                crate::error::GetConnectionStatusError,
                crate::input::GetConnectionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance ID.</p>
        pub fn target(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(inp);
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDefaultPatchBaseline`.
    ///
    /// <p>Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch
    /// baselines. For example, you can create a default patch baseline for each operating system.</p>
    /// <p>If you don't specify an operating system value, the default patch baseline for Windows is
    /// returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDefaultPatchBaseline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_default_patch_baseline_input::Builder,
    }
    impl<C, M, R> GetDefaultPatchBaseline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDefaultPatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDefaultPatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDefaultPatchBaselineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDefaultPatchBaselineInputOperationOutputAlias,
                crate::output::GetDefaultPatchBaselineOutput,
                crate::error::GetDefaultPatchBaselineError,
                crate::input::GetDefaultPatchBaselineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns the default patch baseline for the specified operating system.</p>
        pub fn operating_system(mut self, inp: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(inp);
            self
        }
        /// <p>Returns the default patch baseline for the specified operating system.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployablePatchSnapshotForInstance`.
    ///
    /// <p>Retrieves the current snapshot for the patch baseline the instance uses. This API is
    /// primarily used by the <code>AWS-RunPatchBaseline</code> Systems Manager document (SSM document).</p>
    /// <note>
    /// <p>If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local Amazon Web Services credentials and the operation fails. To avoid
    /// this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a capability of
    /// Amazon Web Services Systems Manager, with an SSM document that enables you to target an instance with a script or command.
    /// For example, run the command using the <code>AWS-RunShellScript</code> document or the
    /// <code>AWS-RunPowerShellScript</code> document.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDeployablePatchSnapshotForInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployable_patch_snapshot_for_instance_input::Builder,
    }
    impl<C, M, R> GetDeployablePatchSnapshotForInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeployablePatchSnapshotForInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeployablePatchSnapshotForInstanceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetDeployablePatchSnapshotForInstanceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeployablePatchSnapshotForInstanceInputOperationOutputAlias,
                crate::output::GetDeployablePatchSnapshotForInstanceOutput,
                crate::error::GetDeployablePatchSnapshotForInstanceError,
                crate::input::GetDeployablePatchSnapshotForInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the instance for which the appropriate patch snapshot should be retrieved.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The ID of the instance for which the appropriate patch snapshot should be retrieved.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>
        pub fn snapshot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(inp);
            self
        }
        /// <p>The snapshot ID provided by the user when running <code>AWS-RunPatchBaseline</code>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>Defines the basic information about a patch baseline override.</p>
        pub fn baseline_override(mut self, inp: crate::model::BaselineOverride) -> Self {
            self.inner = self.inner.baseline_override(inp);
            self
        }
        /// <p>Defines the basic information about a patch baseline override.</p>
        pub fn set_baseline_override(
            mut self,
            input: std::option::Option<crate::model::BaselineOverride>,
        ) -> Self {
            self.inner = self.inner.set_baseline_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocument`.
    ///
    /// <p>Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_document_input::Builder,
    }
    impl<C, M, R> GetDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDocumentInputOperationOutputAlias,
                crate::output::GetDocumentOutput,
                crate::error::GetDocumentError,
                crate::input::GetDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document and can't
        /// be changed.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document and can't
        /// be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The document version for which you want information.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The document version for which you want information.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>Returns the document in the specified format. The document format can be either JSON or
        /// YAML. JSON is the default format.</p>
        pub fn document_format(mut self, inp: crate::model::DocumentFormat) -> Self {
            self.inner = self.inner.document_format(inp);
            self
        }
        /// <p>Returns the document in the specified format. The document format can be either JSON or
        /// YAML. JSON is the default format.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.inner = self.inner.set_document_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInventory`.
    ///
    /// <p>Query inventory information. This includes instance status, such as <code>Stopped</code> or
    /// <code>Terminated</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInventory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_inventory_input::Builder,
    }
    impl<C, M, R> GetInventory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInventoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInventoryInputOperationOutputAlias,
                crate::output::GetInventoryOutput,
                crate::error::GetInventoryError,
                crate::input::GetInventoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::InventoryFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>Returns counts of inventory types based on one or more expressions. For example, if you
        /// aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code>
        /// type, you can see a count of how many Windows and Linux instances exist in your inventoried
        /// fleet.</p>
        pub fn aggregators(mut self, inp: impl Into<crate::model::InventoryAggregator>) -> Self {
            self.inner = self.inner.aggregators(inp);
            self
        }
        /// <p>Returns counts of inventory types based on one or more expressions. For example, if you
        /// aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code>
        /// type, you can see a count of how many Windows and Linux instances exist in your inventoried
        /// fleet.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryAggregator>>,
        ) -> Self {
            self.inner = self.inner.set_aggregators(input);
            self
        }
        /// Appends an item to `ResultAttributes`.
        ///
        /// To override the contents of this collection use [`set_result_attributes`](Self::set_result_attributes).
        ///
        /// <p>The list of inventory item types to return.</p>
        pub fn result_attributes(mut self, inp: impl Into<crate::model::ResultAttribute>) -> Self {
            self.inner = self.inner.result_attributes(inp);
            self
        }
        /// <p>The list of inventory item types to return.</p>
        pub fn set_result_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResultAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_result_attributes(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInventorySchema`.
    ///
    /// <p>Return a list of inventory type names for the account, or return a list of attribute names
    /// for a specific Inventory item type.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInventorySchema<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_inventory_schema_input::Builder,
    }
    impl<C, M, R> GetInventorySchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInventorySchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInventorySchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInventorySchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInventorySchemaInputOperationOutputAlias,
                crate::output::GetInventorySchemaOutput,
                crate::error::GetInventorySchemaError,
                crate::input::GetInventorySchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of inventory item to return.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The type of inventory item to return.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Returns inventory schemas that support aggregation. For example, this call returns the
        /// <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
        /// <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code>
        /// attributes.</p>
        pub fn aggregator(mut self, inp: bool) -> Self {
            self.inner = self.inner.aggregator(inp);
            self
        }
        /// <p>Returns inventory schemas that support aggregation. For example, this call returns the
        /// <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
        /// <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code>
        /// attributes.</p>
        pub fn set_aggregator(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_aggregator(input);
            self
        }
        /// <p>Returns the sub-type schema for a specified inventory type.</p>
        pub fn sub_type(mut self, inp: bool) -> Self {
            self.inner = self.inner.sub_type(inp);
            self
        }
        /// <p>Returns the sub-type schema for a specified inventory type.</p>
        pub fn set_sub_type(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_sub_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindow`.
    ///
    /// <p>Retrieves a maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_maintenance_window_input::Builder,
    }
    impl<C, M, R> GetMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMaintenanceWindowInputOperationOutputAlias,
                crate::output::GetMaintenanceWindowOutput,
                crate::error::GetMaintenanceWindowError,
                crate::input::GetMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window for which you want to retrieve information.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window for which you want to retrieve information.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowExecution`.
    ///
    /// <p>Retrieves details about a specific a maintenance window execution.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMaintenanceWindowExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_maintenance_window_execution_input::Builder,
    }
    impl<C, M, R> GetMaintenanceWindowExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMaintenanceWindowExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMaintenanceWindowExecutionInputOperationOutputAlias,
                crate::output::GetMaintenanceWindowExecutionOutput,
                crate::error::GetMaintenanceWindowExecutionError,
                crate::input::GetMaintenanceWindowExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn window_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(inp);
            self
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowExecutionTask`.
    ///
    /// <p>Retrieves the details about a specific task run as part of a maintenance window
    /// execution.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMaintenanceWindowExecutionTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_maintenance_window_execution_task_input::Builder,
    }
    impl<C, M, R> GetMaintenanceWindowExecutionTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMaintenanceWindowExecutionTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowExecutionTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowExecutionTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMaintenanceWindowExecutionTaskInputOperationOutputAlias,
                crate::output::GetMaintenanceWindowExecutionTaskOutput,
                crate::error::GetMaintenanceWindowExecutionTaskError,
                crate::input::GetMaintenanceWindowExecutionTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn window_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(inp);
            self
        }
        /// <p>The ID of the maintenance window execution that includes the task.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that should be
        /// retrieved.</p>
        pub fn task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(inp);
            self
        }
        /// <p>The ID of the specific task execution in the maintenance window task that should be
        /// retrieved.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowExecutionTaskInvocation`.
    ///
    /// <p>Retrieves information about a specific task running on a specific target.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMaintenanceWindowExecutionTaskInvocation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_maintenance_window_execution_task_invocation_input::Builder,
    }
    impl<C, M, R> GetMaintenanceWindowExecutionTaskInvocation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMaintenanceWindowExecutionTaskInvocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetMaintenanceWindowExecutionTaskInvocationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMaintenanceWindowExecutionTaskInvocationInputOperationOutputAlias,
                crate::output::GetMaintenanceWindowExecutionTaskInvocationOutput,
                crate::error::GetMaintenanceWindowExecutionTaskInvocationError,
                crate::input::GetMaintenanceWindowExecutionTaskInvocationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window execution for which the task is a part.</p>
        pub fn window_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_execution_id(inp);
            self
        }
        /// <p>The ID of the maintenance window execution for which the task is a part.</p>
        pub fn set_window_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_execution_id(input);
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved. </p>
        pub fn task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(inp);
            self
        }
        /// <p>The ID of the specific task in the maintenance window task that should be retrieved. </p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>The invocation ID to retrieve.</p>
        pub fn invocation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invocation_id(inp);
            self
        }
        /// <p>The invocation ID to retrieve.</p>
        pub fn set_invocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invocation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMaintenanceWindowTask`.
    ///
    /// <p>Lists the tasks in a maintenance window.</p>
    /// <note>
    /// <p>For maintenance window tasks without a specified target, you can't supply values for
    /// <code>--max-errors</code> and <code>--max-concurrency</code>. Instead, the system inserts a
    /// placeholder value of <code>1</code>, which may be reported in the response to this command.
    /// These values don't affect the running of your task and can be ignored.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetMaintenanceWindowTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_maintenance_window_task_input::Builder,
    }
    impl<C, M, R> GetMaintenanceWindowTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMaintenanceWindowTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMaintenanceWindowTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMaintenanceWindowTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMaintenanceWindowTaskInputOperationOutputAlias,
                crate::output::GetMaintenanceWindowTaskOutput,
                crate::error::GetMaintenanceWindowTaskError,
                crate::input::GetMaintenanceWindowTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maintenance window ID that includes the task to retrieve.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The maintenance window ID that includes the task to retrieve.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The maintenance window task ID to retrieve.</p>
        pub fn window_task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_task_id(inp);
            self
        }
        /// <p>The maintenance window task ID to retrieve.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpsItem`.
    ///
    /// <p>Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information,
    /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
    /// OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
    /// remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
    /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetOpsItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ops_item_input::Builder,
    }
    impl<C, M, R> GetOpsItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOpsItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpsItemOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpsItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOpsItemInputOperationOutputAlias,
                crate::output::GetOpsItemOutput,
                crate::error::GetOpsItemError,
                crate::input::GetOpsItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OpsItem that you want to get.</p>
        pub fn ops_item_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(inp);
            self
        }
        /// <p>The ID of the OpsItem that you want to get.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpsMetadata`.
    ///
    /// <p>View operational metadata related to an application in Application Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOpsMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ops_metadata_input::Builder,
    }
    impl<C, M, R> GetOpsMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpsMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOpsMetadataInputOperationOutputAlias,
                crate::output::GetOpsMetadataOutput,
                crate::error::GetOpsMetadataError,
                crate::input::GetOpsMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>
        pub fn ops_metadata_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_metadata_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an OpsMetadata Object to view.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_metadata_arn(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpsSummary`.
    ///
    /// <p>View a summary of operations metadata (OpsData) based on specified filters and aggregators.
    /// OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as
    /// well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager
    /// Explorer. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetOpsSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ops_summary_input::Builder,
    }
    impl<C, M, R> GetOpsSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOpsSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpsSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpsSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOpsSummaryInputOperationOutputAlias,
                crate::output::GetOpsSummaryOutput,
                crate::error::GetOpsSummaryError,
                crate::input::GetOpsSummaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the name of a resource data sync to get.</p>
        pub fn sync_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_name(inp);
            self
        }
        /// <p>Specify the name of a resource data sync to get.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters used to scope down the returned OpsData. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::OpsFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional filters used to scope down the returned OpsData. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>
        pub fn aggregators(mut self, inp: impl Into<crate::model::OpsAggregator>) -> Self {
            self.inner = self.inner.aggregators(inp);
            self
        }
        /// <p>Optional aggregators that return counts of OpsData based on one or more expressions.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsAggregator>>,
        ) -> Self {
            self.inner = self.inner.set_aggregators(input);
            self
        }
        /// Appends an item to `ResultAttributes`.
        ///
        /// To override the contents of this collection use [`set_result_attributes`](Self::set_result_attributes).
        ///
        /// <p>The OpsData data type to return.</p>
        pub fn result_attributes(
            mut self,
            inp: impl Into<crate::model::OpsResultAttribute>,
        ) -> Self {
            self.inner = self.inner.result_attributes(inp);
            self
        }
        /// <p>The OpsData data type to return.</p>
        pub fn set_result_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsResultAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_result_attributes(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParameter`.
    ///
    /// <p>Get information about a single parameter by specifying the parameter name.</p>
    /// <note>
    /// <p>To get information about more than one parameter at a time, use the <a>GetParameters</a> operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetParameter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_parameter_input::Builder,
    }
    impl<C, M, R> GetParameter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParameterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetParameterInputOperationOutputAlias,
                crate::output::GetParameterOutput,
                crate::error::GetParameterError,
                crate::input::GetParameterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter you want to query.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the parameter you want to query.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, inp: bool) -> Self {
            self.inner = self.inner.with_decryption(inp);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParameterHistory`.
    ///
    /// <p>Retrieves the history of all changes to a parameter.</p>
    /// <important>
    /// <p>If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must
    /// also update the key alias the parameter uses to reference KMS. Otherwise,
    /// <code>GetParameterHistory</code> retrieves whatever the original key alias was
    /// referencing.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct GetParameterHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_parameter_history_input::Builder,
    }
    impl<C, M, R> GetParameterHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetParameterHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParameterHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParameterHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetParameterHistoryInputOperationOutputAlias,
                crate::output::GetParameterHistoryOutput,
                crate::error::GetParameterHistoryError,
                crate::input::GetParameterHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter for which you want to review history.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the parameter for which you want to review history.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, inp: bool) -> Self {
            self.inner = self.inner.with_decryption(inp);
            self
        }
        /// <p>Return decrypted values for secure string parameters. This flag is ignored for
        /// <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParameters`.
    ///
    /// <p>Get information about one or more parameters by specifying multiple parameter names.</p>
    /// <note>
    /// <p>To get information about a single parameter, you can use the <a>GetParameter</a>
    /// operation instead.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_parameters_input::Builder,
    }
    impl<C, M, R> GetParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetParametersInputOperationOutputAlias,
                crate::output::GetParametersOutput,
                crate::error::GetParametersError,
                crate::input::GetParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>Names of the parameters for which you want to query information.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>Names of the parameters for which you want to query information.</p>
        /// <p>To query by parameter label, use <code>"Name": "name:label"</code>. To query by parameter
        /// version, use <code>"Name": "name:version"</code>.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>Return decrypted secure string value. Return decrypted values for secure string parameters.
        /// This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn with_decryption(mut self, inp: bool) -> Self {
            self.inner = self.inner.with_decryption(inp);
            self
        }
        /// <p>Return decrypted secure string value. Return decrypted values for secure string parameters.
        /// This flag is ignored for <code>String</code> and <code>StringList</code> parameter types.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParametersByPath`.
    ///
    /// <p>Retrieve information about one or more parameters in a specific hierarchy. </p>
    /// <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code>
    /// in the request, the response includes information up to the limit specified. The number of items
    /// returned, however, can be between zero and the value of <code>MaxResults</code>. If the service
    /// reaches an internal limit while processing the results, it stops the operation and returns the
    /// matching values up to that point and a <code>NextToken</code>. You can specify the
    /// <code>NextToken</code> in a subsequent call to get the next set of results.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetParametersByPath<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_parameters_by_path_input::Builder,
    }
    impl<C, M, R> GetParametersByPath<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetParametersByPath`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParametersByPathOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParametersByPathError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetParametersByPathInputOperationOutputAlias,
                crate::output::GetParametersByPathOutput,
                crate::error::GetParametersByPathError,
                crate::input::GetParametersByPathInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierachy is
        /// the parameter name except the last part of the parameter. For the API call to succeeed, the last
        /// part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of
        /// 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33
        /// </code>
        /// </p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierachy is
        /// the parameter name except the last part of the parameter. For the API call to succeeed, the last
        /// part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of
        /// 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33
        /// </code>
        /// </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>Retrieve all parameters within a hierarchy.</p>
        /// <important>
        /// <p>If a user has access to a path, then the user can access all levels of that path. For
        /// example, if a user has permission to access path <code>/a</code>, then the user can also access
        /// <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for
        /// parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation
        /// recursively for <code>/a</code> and view <code>/a/b</code>.</p>
        /// </important>
        pub fn recursive(mut self, inp: bool) -> Self {
            self.inner = self.inner.recursive(inp);
            self
        }
        /// <p>Retrieve all parameters within a hierarchy.</p>
        /// <important>
        /// <p>If a user has access to a path, then the user can access all levels of that path. For
        /// example, if a user has permission to access path <code>/a</code>, then the user can also access
        /// <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for
        /// parameter <code>/a/b</code>, they can still call the GetParametersByPath API operation
        /// recursively for <code>/a</code> and view <code>/a/b</code>.</p>
        /// </important>
        pub fn set_recursive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive(input);
            self
        }
        /// Appends an item to `ParameterFilters`.
        ///
        /// To override the contents of this collection use [`set_parameter_filters`](Self::set_parameter_filters).
        ///
        /// <p>Filters to limit the request results.</p>
        /// <note>
        /// <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>:
        /// <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p>
        /// <p>The following <code>Key</code> values aren't supported for
        /// <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>,
        /// <code>Path</code>, and <code>Tier</code>.</p>
        /// </note>
        pub fn parameter_filters(
            mut self,
            inp: impl Into<crate::model::ParameterStringFilter>,
        ) -> Self {
            self.inner = self.inner.parameter_filters(inp);
            self
        }
        /// <p>Filters to limit the request results.</p>
        /// <note>
        /// <p>The following <code>Key</code> values are supported for <code>GetParametersByPath</code>:
        /// <code>Type</code>, <code>KeyId</code>, and <code>Label</code>.</p>
        /// <p>The following <code>Key</code> values aren't supported for
        /// <code>GetParametersByPath</code>: <code>tag</code>, <code>DataType</code>, <code>Name</code>,
        /// <code>Path</code>, and <code>Tier</code>.</p>
        /// </note>
        pub fn set_parameter_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_filters(input);
            self
        }
        /// <p>Retrieve all parameters in a hierarchy with their value decrypted.</p>
        pub fn with_decryption(mut self, inp: bool) -> Self {
            self.inner = self.inner.with_decryption(inp);
            self
        }
        /// <p>Retrieve all parameters in a hierarchy with their value decrypted.</p>
        pub fn set_with_decryption(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_decryption(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPatchBaseline`.
    ///
    /// <p>Retrieves information about a patch baseline.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPatchBaseline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_patch_baseline_input::Builder,
    }
    impl<C, M, R> GetPatchBaseline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPatchBaselineInputOperationOutputAlias,
                crate::output::GetPatchBaselineOutput,
                crate::error::GetPatchBaselineError,
                crate::input::GetPatchBaselineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to retrieve.</p>
        /// <note>
        /// <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon
        /// Resource Name (ARN) of the baseline. For example, for the baseline
        /// <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify
        /// <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of
        /// <code>pb-0e392de35e7c563b7</code>.</p>
        /// </note>
        pub fn baseline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(inp);
            self
        }
        /// <p>The ID of the patch baseline to retrieve.</p>
        /// <note>
        /// <p>To retrieve information about an Amazon Web Services managed patch baseline, specify the full Amazon
        /// Resource Name (ARN) of the baseline. For example, for the baseline
        /// <code>AWS-AmazonLinuxDefaultPatchBaseline</code>, specify
        /// <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0e392de35e7c563b7</code> instead of
        /// <code>pb-0e392de35e7c563b7</code>.</p>
        /// </note>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPatchBaselineForPatchGroup`.
    ///
    /// <p>Retrieves the patch baseline that should be used for the specified patch group.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPatchBaselineForPatchGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_patch_baseline_for_patch_group_input::Builder,
    }
    impl<C, M, R> GetPatchBaselineForPatchGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPatchBaselineForPatchGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPatchBaselineForPatchGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPatchBaselineForPatchGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPatchBaselineForPatchGroupInputOperationOutputAlias,
                crate::output::GetPatchBaselineForPatchGroupOutput,
                crate::error::GetPatchBaselineForPatchGroupError,
                crate::input::GetPatchBaselineForPatchGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the patch group whose patch baseline should be retrieved.</p>
        pub fn patch_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(inp);
            self
        }
        /// <p>The name of the patch group whose patch baseline should be retrieved.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
        /// <p>Returns he operating system rule specified for patch groups using the patch baseline.</p>
        pub fn operating_system(mut self, inp: crate::model::OperatingSystem) -> Self {
            self.inner = self.inner.operating_system(inp);
            self
        }
        /// <p>Returns he operating system rule specified for patch groups using the patch baseline.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_operating_system(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceSetting`.
    ///
    /// <p>
    /// <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting
    /// defines how a user interacts with or uses a service or a feature of a service. For example, if an
    /// Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
    /// service team might create a default setting of <code>false</code>. This means the user can't use
    /// this feature unless they change the setting to <code>true</code> and intentionally opt in for a
    /// paid feature.</p>
    /// <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define
    /// the default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>,
    /// but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code>
    /// permission for the setting. Use the <a>UpdateServiceSetting</a> API operation to
    /// change the default setting. Or use the <a>ResetServiceSetting</a> to change the value
    /// back to the original value defined by the Amazon Web Services service team.</p>
    /// <p>Query the current service setting for the Amazon Web Services account. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceSetting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_setting_input::Builder,
    }
    impl<C, M, R> GetServiceSetting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceSetting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceSettingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceSettingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceSettingInputOperationOutputAlias,
                crate::output::GetServiceSettingOutput,
                crate::error::GetServiceSettingError,
                crate::input::GetServiceSettingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the service setting to get. The setting ID can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn setting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.setting_id(inp);
            self
        }
        /// <p>The ID of the service setting to get. The setting ID can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_setting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_setting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `LabelParameterVersion`.
    ///
    /// <p>A parameter label is a user-defined alias to help you manage different versions of a
    /// parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and
    /// increments the version number by one. A label can help you remember the purpose of a parameter
    /// when there are multiple versions. </p>
    /// <p>Parameter labels have the following requirements and restrictions.</p>
    /// <ul>
    /// <li>
    /// <p>A version of a parameter can have a maximum of 10 labels.</p>
    /// </li>
    /// <li>
    /// <p>You can't attach the same label to different versions of the same parameter. For example,
    /// if version 1 has the label Production, then you can't attach Production to version 2.</p>
    /// </li>
    /// <li>
    /// <p>You can move a label from one version of a parameter to another.</p>
    /// </li>
    /// <li>
    /// <p>You can't create a label when you create a new parameter. You must attach a label to a
    /// specific version of a parameter.</p>
    /// </li>
    /// <li>
    /// <p>If you no longer want to use a parameter label, then you can either delete it or move it
    /// to a different version of a parameter.</p>
    /// </li>
    /// <li>
    /// <p>A label can have a maximum of 100 characters.</p>
    /// </li>
    /// <li>
    /// <p>Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or
    /// underscores (_).</p>
    /// </li>
    /// <li>
    /// <p>Labels can't begin with a number, "<code>aws</code>" or "<code>ssm</code>" (not case
    /// sensitive). If a label fails to meet these requirements, then the label isn't associated with a
    /// parameter and the system displays it in the list of InvalidLabels.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct LabelParameterVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::label_parameter_version_input::Builder,
    }
    impl<C, M, R> LabelParameterVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `LabelParameterVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::LabelParameterVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::LabelParameterVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::LabelParameterVersionInputOperationOutputAlias,
                crate::output::LabelParameterVersionOutput,
                crate::error::LabelParameterVersionError,
                crate::input::LabelParameterVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The parameter name on which you want to attach one or more labels.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The parameter name on which you want to attach one or more labels.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The specific version of the parameter on which you want to attach one or more labels. If no
        /// version is specified, the system attaches the label to the latest version.</p>
        pub fn parameter_version(mut self, inp: i64) -> Self {
            self.inner = self.inner.parameter_version(inp);
            self
        }
        /// <p>The specific version of the parameter on which you want to attach one or more labels. If no
        /// version is specified, the system attaches the label to the latest version.</p>
        pub fn set_parameter_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_parameter_version(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>One or more labels to attach to the specified parameter version.</p>
        pub fn labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(inp);
            self
        }
        /// <p>One or more labels to attach to the specified parameter version.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociations`.
    ///
    /// <p>Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You
    /// can limit the results to a specific State Manager association document or instance by specifying
    /// a filter. State Manager is a capability of Amazon Web Services Systems Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associations_input::Builder,
    }
    impl<C, M, R> ListAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociationsInputOperationOutputAlias,
                crate::output::ListAssociationsOutput,
                crate::error::ListAssociationsError,
                crate::input::ListAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AssociationFilterList`.
        ///
        /// To override the contents of this collection use [`set_association_filter_list`](Self::set_association_filter_list).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        /// <note>
        /// <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy
        /// associations created using the <code>InstanceID</code> attribute. Associations targeting the
        /// instance that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code>
        /// aren't returned.</p>
        /// </note>
        pub fn association_filter_list(
            mut self,
            inp: impl Into<crate::model::AssociationFilter>,
        ) -> Self {
            self.inner = self.inner.association_filter_list(inp);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        /// <note>
        /// <p>Filtering associations using the <code>InstanceID</code> attribute only returns legacy
        /// associations created using the <code>InstanceID</code> attribute. Associations targeting the
        /// instance that are part of the Target Attributes <code>ResourceGroup</code> or <code>Tags</code>
        /// aren't returned.</p>
        /// </note>
        pub fn set_association_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationFilter>>,
        ) -> Self {
            self.inner = self.inner.set_association_filter_list(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociationVersions`.
    ///
    /// <p>Retrieves all versions of an association for a specific association ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociationVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_association_versions_input::Builder,
    }
    impl<C, M, R> ListAssociationVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociationVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociationVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociationVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociationVersionsInputOperationOutputAlias,
                crate::output::ListAssociationVersionsOutput,
                crate::error::ListAssociationVersionsError,
                crate::input::ListAssociationVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The association ID for which you want to view all versions.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The association ID for which you want to view all versions.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCommandInvocations`.
    ///
    /// <p>An invocation is copy of a command sent to a specific instance. A command can apply to one
    /// or more instances. A command invocation applies to one instance. For example, if a user runs
    /// <code>SendCommand</code> against three instances, then a command invocation is created for each
    /// requested instance ID. <code>ListCommandInvocations</code> provide status about command
    /// execution.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCommandInvocations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_command_invocations_input::Builder,
    }
    impl<C, M, R> ListCommandInvocations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCommandInvocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCommandInvocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCommandInvocationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCommandInvocationsInputOperationOutputAlias,
                crate::output::ListCommandInvocationsOutput,
                crate::error::ListCommandInvocationsError,
                crate::input::ListCommandInvocationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) The invocations for a specific command ID.</p>
        pub fn command_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(inp);
            self
        }
        /// <p>(Optional) The invocations for a specific command ID.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// <p>(Optional) The command execution details for a specific instance ID.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>(Optional) The command execution details for a specific instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::CommandFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>(Optional) If set this returns the response of the command executions and any command
        /// output. The default value is <code>false</code>. </p>
        pub fn details(mut self, inp: bool) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p>(Optional) If set this returns the response of the command executions and any command
        /// output. The default value is <code>false</code>. </p>
        pub fn set_details(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCommands`.
    ///
    /// <p>Lists the commands requested by users of the Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCommands<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_commands_input::Builder,
    }
    impl<C, M, R> ListCommands<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCommands`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCommandsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCommandsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCommandsInputOperationOutputAlias,
                crate::output::ListCommandsOutput,
                crate::error::ListCommandsError,
                crate::input::ListCommandsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) If provided, lists only the specified command.</p>
        pub fn command_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command_id(inp);
            self
        }
        /// <p>(Optional) If provided, lists only the specified command.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command_id(input);
            self
        }
        /// <p>(Optional) Lists commands issued against this instance ID.</p>
        /// <note>
        /// <p>You can't specify an instance ID in the same command that you specify <code>Status</code> =
        /// <code>Pending</code>. This is because the command hasn't reached the instance yet.</p>
        /// </note>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>(Optional) Lists commands issued against this instance ID.</p>
        /// <note>
        /// <p>You can't specify an instance ID in the same command that you specify <code>Status</code> =
        /// <code>Pending</code>. This is because the command hasn't reached the instance yet.</p>
        /// </note>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>(Optional) The maximum number of items to return for this call. The call also returns a
        /// token that you can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>(Optional) The token for the next set of items to return. (You received this token from a
        /// previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results.
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::CommandFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>(Optional) One or more filters. Use a filter to return a more specific list of results.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComplianceItems`.
    ///
    /// <p>For a specified resource ID, this API operation returns a list of compliance statuses for
    /// different resource types. Currently, you can only specify one resource ID per call. List results
    /// depend on the criteria specified in the filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListComplianceItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_compliance_items_input::Builder,
    }
    impl<C, M, R> ListComplianceItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComplianceItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComplianceItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComplianceItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComplianceItemsInputOperationOutputAlias,
                crate::output::ListComplianceItemsOutput,
                crate::error::ListComplianceItemsError,
                crate::input::ListComplianceItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more compliance filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ComplianceStringFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more compliance filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `ResourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The ID for the resources from which to get compliance information. Currently, you can only
        /// specify one resource ID.</p>
        pub fn resource_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(inp);
            self
        }
        /// <p>The ID for the resources from which to get compliance information. Currently, you can only
        /// specify one resource ID.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
        /// Appends an item to `ResourceTypes`.
        ///
        /// To override the contents of this collection use [`set_resource_types`](Self::set_resource_types).
        ///
        /// <p>The type of resource from which to get compliance information. Currently, the only supported
        /// resource type is <code>ManagedInstance</code>.</p>
        pub fn resource_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_types(inp);
            self
        }
        /// <p>The type of resource from which to get compliance information. Currently, the only supported
        /// resource type is <code>ManagedInstance</code>.</p>
        pub fn set_resource_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_types(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComplianceSummaries`.
    ///
    /// <p>Returns a summary count of compliant and non-compliant resources for a compliance type. For
    /// example, this call can return State Manager associations, patches, or custom compliance types
    /// according to the filter criteria that you specify.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListComplianceSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_compliance_summaries_input::Builder,
    }
    impl<C, M, R> ListComplianceSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComplianceSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComplianceSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComplianceSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComplianceSummariesInputOperationOutputAlias,
                crate::output::ListComplianceSummariesOutput,
                crate::error::ListComplianceSummariesError,
                crate::input::ListComplianceSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more compliance or inventory filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ComplianceStringFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more compliance or inventory filters. Use a filter to return a more specific list of
        /// results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. Currently, you can specify null or 50.
        /// The call also returns a token that you can specify in a subsequent call to get the next set of
        /// results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. Currently, you can specify null or 50.
        /// The call also returns a token that you can specify in a subsequent call to get the next set of
        /// results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentMetadataHistory`.
    ///
    /// <p>Information about approval reviews for a version of a change template in Change Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDocumentMetadataHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_document_metadata_history_input::Builder,
    }
    impl<C, M, R> ListDocumentMetadataHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDocumentMetadataHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentMetadataHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentMetadataHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDocumentMetadataHistoryInputOperationOutputAlias,
                crate::output::ListDocumentMetadataHistoryOutput,
                crate::error::ListDocumentMetadataHistoryError,
                crate::input::ListDocumentMetadataHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the change template.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the change template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the change template.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The version of the change template.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The type of data for which details are being requested. Currently, the only supported value
        /// is <code>DocumentReviews</code>.</p>
        pub fn metadata(mut self, inp: crate::model::DocumentMetadataEnum) -> Self {
            self.inner = self.inner.metadata(inp);
            self
        }
        /// <p>The type of data for which details are being requested. Currently, the only supported value
        /// is <code>DocumentReviews</code>.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::DocumentMetadataEnum>,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocuments`.
    ///
    /// <p>Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can
    /// limit the results of this request by using a filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDocuments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_documents_input::Builder,
    }
    impl<C, M, R> ListDocuments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDocuments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDocumentsInputOperationOutputAlias,
                crate::output::ListDocumentsOutput,
                crate::error::ListDocumentsError,
                crate::input::ListDocumentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DocumentFilterList`.
        ///
        /// To override the contents of this collection use [`set_document_filter_list`](Self::set_document_filter_list).
        ///
        /// <p>This data type is deprecated. Instead, use <code>Filters</code>.</p>
        pub fn document_filter_list(
            mut self,
            inp: impl Into<crate::model::DocumentFilter>,
        ) -> Self {
            self.inner = self.inner.document_filter_list(inp);
            self
        }
        /// <p>This data type is deprecated. Instead, use <code>Filters</code>.</p>
        pub fn set_document_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentFilter>>,
        ) -> Self {
            self.inner = self.inner.set_document_filter_list(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more
        /// specific list of results. For keys, you can specify one or more key-value pair tags that have
        /// been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>,
        /// <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example,
        /// to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value
        /// pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p>
        /// <note>
        /// <p>This API operation only supports filtering documents by using a single tag key and one or
        /// more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code>
        /// </p>
        /// </note>
        pub fn filters(mut self, inp: impl Into<crate::model::DocumentKeyValuesFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more <code>DocumentKeyValuesFilter</code> objects. Use a filter to return a more
        /// specific list of results. For keys, you can specify one or more key-value pair tags that have
        /// been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>,
        /// <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example,
        /// to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value
        /// pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p>
        /// <note>
        /// <p>This API operation only supports filtering documents by using a single tag key and one or
        /// more tag values. For example: <code>Key=tag:tagName,Values=valueName1,valueName2</code>
        /// </p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentKeyValuesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDocumentVersions`.
    ///
    /// <p>List all versions for a document.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDocumentVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_document_versions_input::Builder,
    }
    impl<C, M, R> ListDocumentVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDocumentVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDocumentVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDocumentVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDocumentVersionsInputOperationOutputAlias,
                crate::output::ListDocumentVersionsOutput,
                crate::error::ListDocumentVersionsError,
                crate::input::ListDocumentVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInventoryEntries`.
    ///
    /// <p>A list of inventory items returned by the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInventoryEntries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_inventory_entries_input::Builder,
    }
    impl<C, M, R> ListInventoryEntries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInventoryEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInventoryEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInventoryEntriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInventoryEntriesInputOperationOutputAlias,
                crate::output::ListInventoryEntriesOutput,
                crate::error::ListInventoryEntriesError,
                crate::input::ListInventoryEntriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance ID for which you want inventory information.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The instance ID for which you want inventory information.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of inventory item for which you want information.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The type of inventory item for which you want information.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::InventoryFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpsItemEvents`.
    ///
    /// <p>Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can
    /// limit the results to events associated with specific OpsItems by specifying a filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOpsItemEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ops_item_events_input::Builder,
    }
    impl<C, M, R> ListOpsItemEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOpsItemEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpsItemEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpsItemEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOpsItemEventsInputOperationOutputAlias,
                crate::output::ListOpsItemEventsOutput,
                crate::error::ListOpsItemEventsError,
                crate::input::ListOpsItemEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::OpsItemEventFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemEventFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpsItemRelatedItems`.
    ///
    /// <p>Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a
    /// capability of Amazon Web Services Systems Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOpsItemRelatedItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ops_item_related_items_input::Builder,
    }
    impl<C, M, R> ListOpsItemRelatedItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOpsItemRelatedItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpsItemRelatedItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpsItemRelatedItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOpsItemRelatedItemsInputOperationOutputAlias,
                crate::output::ListOpsItemRelatedItemsOutput,
                crate::error::ListOpsItemRelatedItemsError,
                crate::input::ListOpsItemRelatedItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the OpsItem for which you want to list all related-item resources.</p>
        pub fn ops_item_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(inp);
            self
        }
        /// <p>The ID of the OpsItem for which you want to list all related-item resources.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::OpsItemRelatedItemsFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more OpsItem filters. Use a filter to return a more specific list of results. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemRelatedItemsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous
        /// call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpsMetadata`.
    ///
    /// <p>Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or
    /// blobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOpsMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ops_metadata_input::Builder,
    }
    impl<C, M, R> ListOpsMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpsMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOpsMetadataInputOperationOutputAlias,
                crate::output::ListOpsMetadataOutput,
                crate::error::ListOpsMetadataError,
                crate::input::ListOpsMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::OpsMetadataFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters to limit the number of OpsMetadata objects returned by the call.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsMetadataFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceComplianceSummaries`.
    ///
    /// <p>Returns a resource-level summary count. The summary includes information about compliant and
    /// non-compliant statuses and detailed compliance-item severity counts, according to the filter
    /// criteria you specify.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourceComplianceSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_compliance_summaries_input::Builder,
    }
    impl<C, M, R> ListResourceComplianceSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceComplianceSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceComplianceSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceComplianceSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceComplianceSummariesInputOperationOutputAlias,
                crate::output::ListResourceComplianceSummariesOutput,
                crate::error::ListResourceComplianceSummariesError,
                crate::input::ListResourceComplianceSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ComplianceStringFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>One or more filters. Use a filter to return a more specific list of results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceStringFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceDataSync`.
    ///
    /// <p>Lists your resource data sync configurations. Includes information about the last time a
    /// sync attempted to start, the last sync status, and the last time a sync successfully
    /// completed.</p>
    /// <p>The number of sync configurations might be too large to return using a single call to
    /// <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by
    /// using the <code>MaxResults</code> parameter. To determine whether there are more sync
    /// configurations to list, check the value of <code>NextToken</code> in the output. If there are
    /// more sync configurations to list, you can request them by specifying the <code>NextToken</code>
    /// returned in the call to the parameter of a subsequent call. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourceDataSync<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_data_sync_input::Builder,
    }
    impl<C, M, R> ListResourceDataSync<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceDataSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceDataSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceDataSyncError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceDataSyncInputOperationOutputAlias,
                crate::output::ListResourceDataSyncOutput,
                crate::error::ListResourceDataSyncError,
                crate::input::ListResourceDataSyncInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>View a list of resource data syncs according to the sync type. Specify
        /// <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations
        /// or from multiple Amazon Web Services Regions.</p>
        pub fn sync_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_type(inp);
            self
        }
        /// <p>View a list of resource data syncs according to the sync type. Specify
        /// <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 bucket. Specify <code>SyncFromSource</code> to view resource data syncs from Organizations
        /// or from multiple Amazon Web Services Regions.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to start the list. Use this token to get the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to return for this call. The call also returns a token that you
        /// can specify in a subsequent call to get the next set of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of the tags assigned to the specified resource.</p>
    /// <p>For information about the ID format for each supported resource type, see <a>AddTagsToResource</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns a list of tags for a specific resource type.</p>
        pub fn resource_type(mut self, inp: crate::model::ResourceTypeForTagging) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>Returns a list of tags for a specific resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceTypeForTagging>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The resource ID for which you want to see a list of tags.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The resource ID for which you want to see a list of tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyDocumentPermission`.
    ///
    /// <p>Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document
    /// privately, you must specify the Amazon Web Services user account IDs for those people who can use the
    /// document. If you share a document publicly, you must specify <i>All</i> as the
    /// account ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyDocumentPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_document_permission_input::Builder,
    }
    impl<C, M, R> ModifyDocumentPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyDocumentPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyDocumentPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyDocumentPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyDocumentPermissionInputOperationOutputAlias,
                crate::output::ModifyDocumentPermissionOutput,
                crate::error::ModifyDocumentPermissionError,
                crate::input::ModifyDocumentPermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the document that you want to share.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the document that you want to share.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn permission_type(mut self, inp: crate::model::DocumentPermissionType) -> Self {
            self.inner = self.inner.permission_type(inp);
            self
        }
        /// <p>The permission type for the document. The permission type can be
        /// <i>Share</i>.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::DocumentPermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// Appends an item to `AccountIdsToAdd`.
        ///
        /// To override the contents of this collection use [`set_account_ids_to_add`](Self::set_account_ids_to_add).
        ///
        /// <p>The Amazon Web Services user accounts that should have access to the document. The account IDs can
        /// either be a group of account IDs or <i>All</i>.</p>
        pub fn account_ids_to_add(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids_to_add(inp);
            self
        }
        /// <p>The Amazon Web Services user accounts that should have access to the document. The account IDs can
        /// either be a group of account IDs or <i>All</i>.</p>
        pub fn set_account_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids_to_add(input);
            self
        }
        /// Appends an item to `AccountIdsToRemove`.
        ///
        /// To override the contents of this collection use [`set_account_ids_to_remove`](Self::set_account_ids_to_remove).
        ///
        /// <p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services
        /// user account can either be a group of account IDs or <i>All</i>. This action has a
        /// higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add
        /// and the same ID to remove, the system removes access to the document.</p>
        pub fn account_ids_to_remove(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids_to_remove(inp);
            self
        }
        /// <p>The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services
        /// user account can either be a group of account IDs or <i>All</i>. This action has a
        /// higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add
        /// and the same ID to remove, the system removes access to the document.</p>
        pub fn set_account_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids_to_remove(input);
            self
        }
        /// <p>(Optional) The version of the document to share. If it isn't specified, the system choose
        /// the <code>Default</code> version to share.</p>
        pub fn shared_document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_document_version(inp);
            self
        }
        /// <p>(Optional) The version of the document to share. If it isn't specified, the system choose
        /// the <code>Default</code> version to share.</p>
        pub fn set_shared_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_document_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutComplianceItems`.
    ///
    /// <p>Registers a compliance type and other compliance details on a designated resource. This
    /// operation lets you register custom compliance details with a resource. This call overwrites
    /// existing compliance information on the resource, so you must provide a full list of compliance
    /// items each time that you send the request.</p>
    /// <p>ComplianceType can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>ExecutionId: The execution ID when the patch, association, or custom compliance item was
    /// applied.</p>
    /// </li>
    /// <li>
    /// <p>ExecutionType: Specify patch, association, or Custom:<code>string</code>.</p>
    /// </li>
    /// <li>
    /// <p>ExecutionTime. The time the patch, association, or custom compliance item was applied to
    /// the instance.</p>
    /// </li>
    /// <li>
    /// <p>Id: The patch, association, or custom compliance ID.</p>
    /// </li>
    /// <li>
    /// <p>Title: A title.</p>
    /// </li>
    /// <li>
    /// <p>Status: The status of the compliance item. For example, <code>approved</code> for patches,
    /// or <code>Failed</code> for associations.</p>
    /// </li>
    /// <li>
    /// <p>Severity: A patch severity. For example, <code>critical</code>.</p>
    /// </li>
    /// <li>
    /// <p>DocumentName: An SSM document name. For example, <code>AWS-RunPatchBaseline</code>.</p>
    /// </li>
    /// <li>
    /// <p>DocumentVersion: An SSM document version number. For example, 4.</p>
    /// </li>
    /// <li>
    /// <p>Classification: A patch classification. For example, <code>security updates</code>.</p>
    /// </li>
    /// <li>
    /// <p>PatchBaselineId: A patch baseline ID.</p>
    /// </li>
    /// <li>
    /// <p>PatchSeverity: A patch severity. For example, <code>Critical</code>.</p>
    /// </li>
    /// <li>
    /// <p>PatchState: A patch state. For example, <code>InstancesWithFailedPatches</code>.</p>
    /// </li>
    /// <li>
    /// <p>PatchGroup: The name of a patch group.</p>
    /// </li>
    /// <li>
    /// <p>InstalledTime: The time the association, patch, or custom compliance item was applied to
    /// the resource. Specify the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutComplianceItems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_compliance_items_input::Builder,
    }
    impl<C, M, R> PutComplianceItems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutComplianceItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutComplianceItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutComplianceItemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutComplianceItemsInputOperationOutputAlias,
                crate::output::PutComplianceItemsOutput,
                crate::error::PutComplianceItemsError,
                crate::input::PutComplianceItemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify an ID for this resource. For a managed instance, this is the instance ID.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Specify an ID for this resource. For a managed instance, this is the instance ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported
        /// resource type.</p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported
        /// resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>Specify the compliance type. For example, specify Association (for a State Manager
        /// association), Patch, or Custom:<code>string</code>.</p>
        pub fn compliance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compliance_type(inp);
            self
        }
        /// <p>Specify the compliance type. For example, specify Association (for a State Manager
        /// association), Patch, or Custom:<code>string</code>.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compliance_type(input);
            self
        }
        /// <p>A summary of the call execution that includes an execution ID, the type of execution (for
        /// example, <code>Command</code>), and the date/time of the execution using a datetime object that
        /// is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn execution_summary(mut self, inp: crate::model::ComplianceExecutionSummary) -> Self {
            self.inner = self.inner.execution_summary(inp);
            self
        }
        /// <p>A summary of the call execution that includes an execution ID, the type of execution (for
        /// example, <code>Command</code>), and the date/time of the execution using a datetime object that
        /// is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn set_execution_summary(
            mut self,
            input: std::option::Option<crate::model::ComplianceExecutionSummary>,
        ) -> Self {
            self.inner = self.inner.set_execution_summary(input);
            self
        }
        /// Appends an item to `Items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>Information about the compliance as defined by the resource type. For example, for a patch
        /// compliance type, <code>Items</code> includes information about the PatchSeverity, Classification,
        /// and so on.</p>
        pub fn items(mut self, inp: impl Into<crate::model::ComplianceItemEntry>) -> Self {
            self.inner = self.inner.items(inp);
            self
        }
        /// <p>Information about the compliance as defined by the resource type. For example, for a patch
        /// compliance type, <code>Items</code> includes information about the PatchSeverity, Classification,
        /// and so on.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComplianceItemEntry>>,
        ) -> Self {
            self.inner = self.inner.set_items(input);
            self
        }
        /// <p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information
        /// should be overwritten or ignored. If the content hashes match, the request to put compliance
        /// information is ignored.</p>
        pub fn item_content_hash(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.item_content_hash(inp);
            self
        }
        /// <p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information
        /// should be overwritten or ignored. If the content hashes match, the request to put compliance
        /// information is ignored.</p>
        pub fn set_item_content_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_item_content_hash(input);
            self
        }
        /// <p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or
        /// <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing
        /// compliance information for the resource. You must provide a full list of compliance items each
        /// time you send the request.</p>
        /// <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific
        /// association. The association must be configured with <code>SyncCompliance</code> set to
        /// <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p>
        /// <note>
        /// <p>This attribute is only valid for association compliance.</p>
        /// </note>
        pub fn upload_type(mut self, inp: crate::model::ComplianceUploadType) -> Self {
            self.inner = self.inner.upload_type(inp);
            self
        }
        /// <p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or
        /// <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing
        /// compliance information for the resource. You must provide a full list of compliance items each
        /// time you send the request.</p>
        /// <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific
        /// association. The association must be configured with <code>SyncCompliance</code> set to
        /// <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p>
        /// <note>
        /// <p>This attribute is only valid for association compliance.</p>
        /// </note>
        pub fn set_upload_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceUploadType>,
        ) -> Self {
            self.inner = self.inner.set_upload_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInventory`.
    ///
    /// <p>Bulk update custom inventory items on one more instance. The request adds an inventory item,
    /// if it doesn't already exist, or updates an inventory item, if it does exist.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutInventory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_inventory_input::Builder,
    }
    impl<C, M, R> PutInventory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInventoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutInventoryInputOperationOutputAlias,
                crate::output::PutInventoryOutput,
                crate::error::PutInventoryError,
                crate::input::PutInventoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An instance ID where you want to add or update inventory items.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>An instance ID where you want to add or update inventory items.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `Items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The inventory items that you want to add or update on instances.</p>
        pub fn items(mut self, inp: impl Into<crate::model::InventoryItem>) -> Self {
            self.inner = self.inner.items(inp);
            self
        }
        /// <p>The inventory items that you want to add or update on instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryItem>>,
        ) -> Self {
            self.inner = self.inner.set_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutParameter`.
    ///
    /// <p>Add a parameter to the system.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutParameter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_parameter_input::Builder,
    }
    impl<C, M, R> PutParameter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutParameter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutParameterOutput,
            aws_smithy_http::result::SdkError<crate::error::PutParameterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutParameterInputOperationOutputAlias,
                crate::output::PutParameterOutput,
                crate::error::PutParameterError,
                crate::input::PutParameterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name of the parameter that you want to add to the system. The fully
        /// qualified name includes the complete hierarchy of the parameter path and name. For parameters in
        /// a hierarchy, you must include a leading forward slash character (/) when you create or reference
        /// a parameter. For example: <code>/Dev/DBServer/MySQL/db-string13</code>
        /// </p>
        /// <p>Naming Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Parameter names are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>A parameter name must be unique within an Amazon Web Services Region</p>
        /// </li>
        /// <li>
        /// <p>A parameter name can't be prefixed with "<code>aws</code>" or "<code>ssm</code>"
        /// (case-insensitive).</p>
        /// </li>
        /// <li>
        /// <p>Parameter names can include only the following symbols and letters:
        /// <code>a-zA-Z0-9_.-</code>
        /// </p>
        /// <p>In addition, the slash character ( / ) is used to delineate hierarchies in parameter
        /// names. For example: <code>/Dev/Production/East/Project-ABC/MyParameter</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>A parameter name can't include spaces.</p>
        /// </li>
        /// <li>
        /// <p>Parameter hierarchies are limited to a maximum depth of fifteen levels.</p>
        /// </li>
        /// </ul>
        /// <p>For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <note>
        /// <p>The maximum length constraint listed below includes capacity for additional system
        /// attributes that aren't part of the name. The maximum length for a parameter name, including the
        /// full length of the parameter ARN, is 1011 characters. For example, the length of the following
        /// parameter name is 65 characters, not 20 characters:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName</code>
        /// </p>
        /// </note>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The fully qualified name of the parameter that you want to add to the system. The fully
        /// qualified name includes the complete hierarchy of the parameter path and name. For parameters in
        /// a hierarchy, you must include a leading forward slash character (/) when you create or reference
        /// a parameter. For example: <code>/Dev/DBServer/MySQL/db-string13</code>
        /// </p>
        /// <p>Naming Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Parameter names are case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>A parameter name must be unique within an Amazon Web Services Region</p>
        /// </li>
        /// <li>
        /// <p>A parameter name can't be prefixed with "<code>aws</code>" or "<code>ssm</code>"
        /// (case-insensitive).</p>
        /// </li>
        /// <li>
        /// <p>Parameter names can include only the following symbols and letters:
        /// <code>a-zA-Z0-9_.-</code>
        /// </p>
        /// <p>In addition, the slash character ( / ) is used to delineate hierarchies in parameter
        /// names. For example: <code>/Dev/Production/East/Project-ABC/MyParameter</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>A parameter name can't include spaces.</p>
        /// </li>
        /// <li>
        /// <p>Parameter hierarchies are limited to a maximum depth of fifteen levels.</p>
        /// </li>
        /// </ul>
        /// <p>For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <note>
        /// <p>The maximum length constraint listed below includes capacity for additional system
        /// attributes that aren't part of the name. The maximum length for a parameter name, including the
        /// full length of the parameter ARN, is 1011 characters. For example, the length of the following
        /// parameter name is 65 characters, not 20 characters:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName</code>
        /// </p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Information about the parameter that you want to add to the system. Optional but
        /// recommended.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Information about the parameter that you want to add to the system. Optional but
        /// recommended.</p>
        /// <important>
        /// <p>Don't enter personally identifiable information in this field.</p>
        /// </important>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The parameter value that you want to add to the system. Standard parameters have a value
        /// limit of 4 KB. Advanced parameters have a value limit of 8 KB.</p>
        /// <note>
        /// <p>Parameters can't be referenced or nested in the values of other parameters. You can't
        /// include <code>{{}}</code> or <code>{{ssm:<i>parameter-name</i>}}</code> in a
        /// parameter value.</p>
        /// </note>
        pub fn value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(inp);
            self
        }
        /// <p>The parameter value that you want to add to the system. Standard parameters have a value
        /// limit of 4 KB. Advanced parameters have a value limit of 8 KB.</p>
        /// <note>
        /// <p>Parameters can't be referenced or nested in the values of other parameters. You can't
        /// include <code>{{}}</code> or <code>{{ssm:<i>parameter-name</i>}}</code> in a
        /// parameter value.</p>
        /// </note>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// <p>The type of parameter that you want to add to the system.</p>
        /// <note>
        /// <p>
        /// <code>SecureString</code> isn't currently supported for CloudFormation templates.</p>
        /// </note>
        /// <p>Items in a <code>StringList</code> must be separated by a comma (,). You can't
        /// use other punctuation or special character to escape items in the list. If you have a parameter
        /// value that requires a comma, then use the <code>String</code> data type.</p>
        /// <important>
        /// <p>Specifying a parameter type isn't required when updating a parameter. You must specify a
        /// parameter type when creating a parameter.</p>
        /// </important>
        pub fn r#type(mut self, inp: crate::model::ParameterType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of parameter that you want to add to the system.</p>
        /// <note>
        /// <p>
        /// <code>SecureString</code> isn't currently supported for CloudFormation templates.</p>
        /// </note>
        /// <p>Items in a <code>StringList</code> must be separated by a comma (,). You can't
        /// use other punctuation or special character to escape items in the list. If you have a parameter
        /// value that requires a comma, then use the <code>String</code> data type.</p>
        /// <important>
        /// <p>Specifying a parameter type isn't required when updating a parameter. You must specify a
        /// parameter type when creating a parameter.</p>
        /// </important>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ParameterType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Key Management Service (KMS) ID that you want to use to encrypt a
        /// parameter. Either the default KMS key automatically assigned to your Amazon Web Services account
        /// or a custom key. Required for parameters that use the <code>SecureString</code>
        /// data type.</p>
        /// <p>If you don't specify a key ID, the system uses the default key associated with your
        /// Amazon Web Services account.</p>
        /// <ul>
        /// <li>
        /// <p>To use your default KMS key, choose the <code>SecureString</code> data type, and do <i>not</i> specify the <code>Key ID</code> when you create the parameter. The system automatically populates
        /// <code>Key ID</code> with your default KMS key.</p>
        /// </li>
        /// <li>
        /// <p>To use a custom KMS key, choose the <code>SecureString</code>
        /// data type with the <code>Key ID</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_id(inp);
            self
        }
        /// <p>The Key Management Service (KMS) ID that you want to use to encrypt a
        /// parameter. Either the default KMS key automatically assigned to your Amazon Web Services account
        /// or a custom key. Required for parameters that use the <code>SecureString</code>
        /// data type.</p>
        /// <p>If you don't specify a key ID, the system uses the default key associated with your
        /// Amazon Web Services account.</p>
        /// <ul>
        /// <li>
        /// <p>To use your default KMS key, choose the <code>SecureString</code> data type, and do <i>not</i> specify the <code>Key ID</code> when you create the parameter. The system automatically populates
        /// <code>Key ID</code> with your default KMS key.</p>
        /// </li>
        /// <li>
        /// <p>To use a custom KMS key, choose the <code>SecureString</code>
        /// data type with the <code>Key ID</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_id(input);
            self
        }
        /// <p>Overwrite an existing parameter. The default value is <code>false</code>.</p>
        pub fn overwrite(mut self, inp: bool) -> Self {
            self.inner = self.inner.overwrite(inp);
            self
        }
        /// <p>Overwrite an existing parameter. The default value is <code>false</code>.</p>
        pub fn set_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_overwrite(input);
            self
        }
        /// <p>A regular expression used to validate the parameter value. For example, for String types
        /// with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$ </p>
        pub fn allowed_pattern(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.allowed_pattern(inp);
            self
        }
        /// <p>A regular expression used to validate the parameter value. For example, for String types
        /// with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$ </p>
        pub fn set_allowed_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_allowed_pattern(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// Systems Manager parameter to identify the type of resource to which it applies, the environment, or the
        /// type of configuration data referenced by the parameter. In this case, you could specify the
        /// following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Resource,Value=S3bucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=ParameterType,Value=LicenseKey</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing Systems Manager parameter, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
        /// different ways, such as by purpose, owner, or environment. For example, you might want to tag a
        /// Systems Manager parameter to identify the type of resource to which it applies, the environment, or the
        /// type of configuration data referenced by the parameter. In this case, you could specify the
        /// following key-value pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Resource,Value=S3bucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=ParameterType,Value=LicenseKey</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing Systems Manager parameter, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The parameter tier to assign to a parameter.</p>
        /// <p>Parameter Store offers a standard tier and an advanced tier for parameters. Standard
        /// parameters have a content size limit of 4 KB and can't be configured to use parameter policies.
        /// You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account.
        /// Standard parameters are offered at no additional cost. </p>
        /// <p>Advanced parameters have a content size limit of 8 KB and can be configured to use parameter
        /// policies. You can create a maximum of 100,000 advanced parameters for each Region in an
        /// Amazon Web Services account. Advanced parameters incur a charge. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html">Standard and
        /// advanced parameter tiers</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>You can change a standard parameter to an advanced parameter any time. But you can't revert
        /// an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard
        /// parameter would result in data loss because the system would truncate the size of the parameter
        /// from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly,
        /// advanced parameters use a different form of encryption than standard parameters. </p>
        /// <p>If you no longer need an advanced parameter, or if you no longer want to incur charges for
        /// an advanced parameter, you must delete it and recreate it as a new standard parameter. </p>
        /// <p>
        /// <b>Using the Default Tier Configuration</b>
        /// </p>
        /// <p>In <code>PutParameter</code> requests, you can specify the tier to create the parameter in.
        /// Whenever you specify a tier in the request, Parameter Store creates or updates the parameter
        /// according to that request. However, if you don't specify a tier in a request, Parameter Store
        /// assigns the tier based on the current Parameter Store default tier configuration.</p>
        /// <p>The default tier when you begin using Parameter Store is the standard-parameter tier. If you
        /// use the advanced-parameter tier, you can specify one of the following as the default:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Advanced</b>: With this option, Parameter Store evaluates all
        /// requests as advanced parameters. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Intelligent-Tiering</b>: With this option, Parameter Store
        /// evaluates each request to determine if the parameter is standard or advanced. </p>
        /// <p>If the request doesn't include any options that require an advanced parameter, the
        /// parameter is created in the standard-parameter tier. If one or more options requiring an
        /// advanced parameter are included in the request, Parameter Store create a parameter in the
        /// advanced-parameter tier.</p>
        /// <p>This approach helps control your parameter-related costs by always creating standard
        /// parameters unless an advanced parameter is necessary. </p>
        /// </li>
        /// </ul>
        /// <p>Options that require an advanced parameter include the following:</p>
        /// <ul>
        /// <li>
        /// <p>The content size of the parameter is more than 4 KB.</p>
        /// </li>
        /// <li>
        /// <p>The parameter uses a parameter policy.</p>
        /// </li>
        /// <li>
        /// <p>More than 10,000 parameters already exist in your Amazon Web Services account in the current
        /// Amazon Web Services Region.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about configuring the default tier option, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html">Specifying a
        /// default parameter tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn tier(mut self, inp: crate::model::ParameterTier) -> Self {
            self.inner = self.inner.tier(inp);
            self
        }
        /// <p>The parameter tier to assign to a parameter.</p>
        /// <p>Parameter Store offers a standard tier and an advanced tier for parameters. Standard
        /// parameters have a content size limit of 4 KB and can't be configured to use parameter policies.
        /// You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account.
        /// Standard parameters are offered at no additional cost. </p>
        /// <p>Advanced parameters have a content size limit of 8 KB and can be configured to use parameter
        /// policies. You can create a maximum of 100,000 advanced parameters for each Region in an
        /// Amazon Web Services account. Advanced parameters incur a charge. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html">Standard and
        /// advanced parameter tiers</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <p>You can change a standard parameter to an advanced parameter any time. But you can't revert
        /// an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard
        /// parameter would result in data loss because the system would truncate the size of the parameter
        /// from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly,
        /// advanced parameters use a different form of encryption than standard parameters. </p>
        /// <p>If you no longer need an advanced parameter, or if you no longer want to incur charges for
        /// an advanced parameter, you must delete it and recreate it as a new standard parameter. </p>
        /// <p>
        /// <b>Using the Default Tier Configuration</b>
        /// </p>
        /// <p>In <code>PutParameter</code> requests, you can specify the tier to create the parameter in.
        /// Whenever you specify a tier in the request, Parameter Store creates or updates the parameter
        /// according to that request. However, if you don't specify a tier in a request, Parameter Store
        /// assigns the tier based on the current Parameter Store default tier configuration.</p>
        /// <p>The default tier when you begin using Parameter Store is the standard-parameter tier. If you
        /// use the advanced-parameter tier, you can specify one of the following as the default:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Advanced</b>: With this option, Parameter Store evaluates all
        /// requests as advanced parameters. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Intelligent-Tiering</b>: With this option, Parameter Store
        /// evaluates each request to determine if the parameter is standard or advanced. </p>
        /// <p>If the request doesn't include any options that require an advanced parameter, the
        /// parameter is created in the standard-parameter tier. If one or more options requiring an
        /// advanced parameter are included in the request, Parameter Store create a parameter in the
        /// advanced-parameter tier.</p>
        /// <p>This approach helps control your parameter-related costs by always creating standard
        /// parameters unless an advanced parameter is necessary. </p>
        /// </li>
        /// </ul>
        /// <p>Options that require an advanced parameter include the following:</p>
        /// <ul>
        /// <li>
        /// <p>The content size of the parameter is more than 4 KB.</p>
        /// </li>
        /// <li>
        /// <p>The parameter uses a parameter policy.</p>
        /// </li>
        /// <li>
        /// <p>More than 10,000 parameters already exist in your Amazon Web Services account in the current
        /// Amazon Web Services Region.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about configuring the default tier option, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html">Specifying a
        /// default parameter tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::ParameterTier>) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// <p>One or more policies to apply to a parameter. This operation takes a JSON array. Parameter
        /// Store, a capability of Amazon Web Services Systems Manager supports the following policy types:</p>
        /// <p>Expiration: This policy deletes the parameter after it expires. When you create the policy,
        /// you specify the expiration date. You can update the expiration date and time by updating the
        /// policy. Updating the <i>parameter</i> doesn't affect the expiration date and time.
        /// When the expiration time is reached, Parameter Store deletes the parameter.</p>
        /// <p>ExpirationNotification: This policy triggers an event in Amazon CloudWatch Events that
        /// notifies you about the expiration. By using this policy, you can receive notification before or
        /// after the expiration time is reached, in units of days or hours.</p>
        /// <p>NoChangeNotification: This policy triggers a CloudWatch Events event if a parameter hasn't
        /// been modified for a specified period of time. This policy type is useful when, for example, a
        /// secret needs to be changed within a period of time, but it hasn't been changed.</p>
        /// <p>All existing policies are preserved until you send new policies or an empty policy. For more
        /// information about parameter policies, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
        /// policies</a>. </p>
        pub fn policies(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policies(inp);
            self
        }
        /// <p>One or more policies to apply to a parameter. This operation takes a JSON array. Parameter
        /// Store, a capability of Amazon Web Services Systems Manager supports the following policy types:</p>
        /// <p>Expiration: This policy deletes the parameter after it expires. When you create the policy,
        /// you specify the expiration date. You can update the expiration date and time by updating the
        /// policy. Updating the <i>parameter</i> doesn't affect the expiration date and time.
        /// When the expiration time is reached, Parameter Store deletes the parameter.</p>
        /// <p>ExpirationNotification: This policy triggers an event in Amazon CloudWatch Events that
        /// notifies you about the expiration. By using this policy, you can receive notification before or
        /// after the expiration time is reached, in units of days or hours.</p>
        /// <p>NoChangeNotification: This policy triggers a CloudWatch Events event if a parameter hasn't
        /// been modified for a specified period of time. This policy type is useful when, for example, a
        /// secret needs to be changed within a period of time, but it hasn't been changed.</p>
        /// <p>All existing policies are preserved until you send new policies or an empty policy. For more
        /// information about parameter policies, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
        /// policies</a>. </p>
        pub fn set_policies(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policies(input);
            self
        }
        /// <p>The data type for a <code>String</code> parameter. Supported data types include plain text
        /// and Amazon Machine Image (AMI) IDs.</p>
        /// <p>
        /// <b>The following data type values are supported.</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>text</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aws:ec2:image</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you create a <code>String</code> parameter and specify <code>aws:ec2:image</code>,
        /// Amazon Web Services Systems Manager validates the parameter value is in the required format, such as
        /// <code>ami-12345abcdeEXAMPLE</code>, and that the specified AMI is available in your
        /// Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html">Native parameter support
        /// for Amazon Machine Image (AMI) IDs</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn data_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_type(inp);
            self
        }
        /// <p>The data type for a <code>String</code> parameter. Supported data types include plain text
        /// and Amazon Machine Image (AMI) IDs.</p>
        /// <p>
        /// <b>The following data type values are supported.</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>text</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>aws:ec2:image</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you create a <code>String</code> parameter and specify <code>aws:ec2:image</code>,
        /// Amazon Web Services Systems Manager validates the parameter value is in the required format, such as
        /// <code>ami-12345abcdeEXAMPLE</code>, and that the specified AMI is available in your
        /// Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html">Native parameter support
        /// for Amazon Machine Image (AMI) IDs</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDefaultPatchBaseline`.
    ///
    /// <p>Defines the default patch baseline for the relevant operating system.</p>
    /// <p>To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline
    /// Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify
    /// <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed</code> instead of
    /// <code>pb-0574b43a65ea646ed</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterDefaultPatchBaseline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_default_patch_baseline_input::Builder,
    }
    impl<C, M, R> RegisterDefaultPatchBaseline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterDefaultPatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDefaultPatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDefaultPatchBaselineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterDefaultPatchBaselineInputOperationOutputAlias,
                crate::output::RegisterDefaultPatchBaselineOutput,
                crate::error::RegisterDefaultPatchBaselineError,
                crate::input::RegisterDefaultPatchBaselineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline that should be the default patch baseline.</p>
        pub fn baseline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(inp);
            self
        }
        /// <p>The ID of the patch baseline that should be the default patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterPatchBaselineForPatchGroup`.
    ///
    /// <p>Registers a patch baseline for a patch group.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterPatchBaselineForPatchGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_patch_baseline_for_patch_group_input::Builder,
    }
    impl<C, M, R> RegisterPatchBaselineForPatchGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterPatchBaselineForPatchGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterPatchBaselineForPatchGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RegisterPatchBaselineForPatchGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterPatchBaselineForPatchGroupInputOperationOutputAlias,
                crate::output::RegisterPatchBaselineForPatchGroupOutput,
                crate::error::RegisterPatchBaselineForPatchGroupError,
                crate::input::RegisterPatchBaselineForPatchGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to register with the patch group.</p>
        pub fn baseline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(inp);
            self
        }
        /// <p>The ID of the patch baseline to register with the patch group.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
        /// <p>The name of the patch group to be registered with the patch baseline.</p>
        pub fn patch_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.patch_group(inp);
            self
        }
        /// <p>The name of the patch group to be registered with the patch baseline.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_patch_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterTargetWithMaintenanceWindow`.
    ///
    /// <p>Registers a target with a maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterTargetWithMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_target_with_maintenance_window_input::Builder,
    }
    impl<C, M, R> RegisterTargetWithMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterTargetWithMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTargetWithMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RegisterTargetWithMaintenanceWindowError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterTargetWithMaintenanceWindowInputOperationOutputAlias,
                crate::output::RegisterTargetWithMaintenanceWindowOutput,
                crate::error::RegisterTargetWithMaintenanceWindowError,
                crate::input::RegisterTargetWithMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window the target should be registered with.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window the target should be registered with.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The type of target being registered with the maintenance window.</p>
        pub fn resource_type(mut self, inp: crate::model::MaintenanceWindowResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of target being registered with the maintenance window.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets to register with the maintenance window. In other words, the instances to run
        /// commands on when the maintenance window runs.</p>
        /// <note>
        /// <p>If a single maintenance window task is registered with multiple targets, its task
        /// invocations occur sequentially and not in parallel. If your task must run on multiple targets at
        /// the same time, register a task for each target individually and assign each task the same
        /// priority level.</p>
        /// </note>
        /// <p>You can specify targets using instance IDs, resource group names, or tags that have been
        /// applied to instances.</p>
        /// <p>
        /// <b>Example 1</b>: Specify instance IDs</p>
        /// <p>
        /// <code>Key=InstanceIds,Values=<i>instance-id-1</i>,<i>instance-id-2</i>,<i>instance-id-3</i>
        /// </code>
        /// </p>
        /// <p>
        /// <b>Example 2</b>: Use tag key-pairs applied to instances</p>
        /// <p>
        /// <code>Key=tag:<i>my-tag-key</i>,Values=<i>my-tag-value-1</i>,<i>my-tag-value-2</i>
        /// </code>
        /// </p>
        /// <p>
        /// <b>Example 3</b>: Use tag-keys applied to instances</p>
        /// <p>
        /// <code>Key=tag-key,Values=<i>my-tag-key-1</i>,<i>my-tag-key-2</i>
        /// </code>
        /// </p>
        ///
        /// <p>
        /// <b>Example 4</b>: Use resource group names</p>
        /// <p>
        /// <code>Key=resource-groups:Name,Values=<i>resource-group-name</i>
        /// </code>
        /// </p>
        /// <p>
        /// <b>Example 5</b>: Use filters for resource group types</p>
        /// <p>
        /// <code>Key=resource-groups:ResourceTypeFilters,Values=<i>resource-type-1</i>,<i>resource-type-2</i>
        /// </code>
        /// </p>
        /// <note>
        /// <p>For <code>Key=resource-groups:ResourceTypeFilters</code>, specify resource types in the
        /// following format</p>
        /// <p>
        /// <code>Key=resource-groups:ResourceTypeFilters,Values=<i>AWS::EC2::INSTANCE</i>,<i>AWS::EC2::VPC</i>
        /// </code>
        /// </p>
        /// </note>
        ///
        /// <p>For more information about these examples formats, including the best use case for each one,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html">Examples: Register
        /// targets with a maintenance window</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The targets to register with the maintenance window. In other words, the instances to run
        /// commands on when the maintenance window runs.</p>
        /// <note>
        /// <p>If a single maintenance window task is registered with multiple targets, its task
        /// invocations occur sequentially and not in parallel. If your task must run on multiple targets at
        /// the same time, register a task for each target individually and assign each task the same
        /// priority level.</p>
        /// </note>
        /// <p>You can specify targets using instance IDs, resource group names, or tags that have been
        /// applied to instances.</p>
        /// <p>
        /// <b>Example 1</b>: Specify instance IDs</p>
        /// <p>
        /// <code>Key=InstanceIds,Values=<i>instance-id-1</i>,<i>instance-id-2</i>,<i>instance-id-3</i>
        /// </code>
        /// </p>
        /// <p>
        /// <b>Example 2</b>: Use tag key-pairs applied to instances</p>
        /// <p>
        /// <code>Key=tag:<i>my-tag-key</i>,Values=<i>my-tag-value-1</i>,<i>my-tag-value-2</i>
        /// </code>
        /// </p>
        /// <p>
        /// <b>Example 3</b>: Use tag-keys applied to instances</p>
        /// <p>
        /// <code>Key=tag-key,Values=<i>my-tag-key-1</i>,<i>my-tag-key-2</i>
        /// </code>
        /// </p>
        ///
        /// <p>
        /// <b>Example 4</b>: Use resource group names</p>
        /// <p>
        /// <code>Key=resource-groups:Name,Values=<i>resource-group-name</i>
        /// </code>
        /// </p>
        /// <p>
        /// <b>Example 5</b>: Use filters for resource group types</p>
        /// <p>
        /// <code>Key=resource-groups:ResourceTypeFilters,Values=<i>resource-type-1</i>,<i>resource-type-2</i>
        /// </code>
        /// </p>
        /// <note>
        /// <p>For <code>Key=resource-groups:ResourceTypeFilters</code>, specify resource types in the
        /// following format</p>
        /// <p>
        /// <code>Key=resource-groups:ResourceTypeFilters,Values=<i>AWS::EC2::INSTANCE</i>,<i>AWS::EC2::VPC</i>
        /// </code>
        /// </p>
        /// </note>
        ///
        /// <p>For more information about these examples formats, including the best use case for each one,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html">Examples: Register
        /// targets with a maintenance window</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>User-provided value that will be included in any Amazon CloudWatch Events events raised while
        /// running tasks for these targets in this maintenance window.</p>
        pub fn owner_information(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_information(inp);
            self
        }
        /// <p>User-provided value that will be included in any Amazon CloudWatch Events events raised while
        /// running tasks for these targets in this maintenance window.</p>
        pub fn set_owner_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_information(input);
            self
        }
        /// <p>An optional name for the target.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>An optional name for the target.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the target.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the target.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterTaskWithMaintenanceWindow`.
    ///
    /// <p>Adds a new task to a maintenance window.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterTaskWithMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_task_with_maintenance_window_input::Builder,
    }
    impl<C, M, R> RegisterTaskWithMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterTaskWithMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTaskWithMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterTaskWithMaintenanceWindowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterTaskWithMaintenanceWindowInputOperationOutputAlias,
                crate::output::RegisterTaskWithMaintenanceWindowOutput,
                crate::error::RegisterTaskWithMaintenanceWindowError,
                crate::input::RegisterTaskWithMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window the task should be added to.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window the task should be added to.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets (either instances or maintenance window targets).</p>
        /// <note>
        /// <p>One or more targets must be specified for maintenance window Run Command-type tasks.
        /// Depending on the task, targets are optional for other maintenance window task types (Automation,
        /// Lambda, and Step Functions). For more information about running tasks
        /// that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
        /// maintenance window tasks without targets</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// </note>
        /// <p>Specify instances using the following format: </p>
        /// <p>
        /// <code>Key=InstanceIds,Values=<instance-id-1>,<instance-id-2></code>
        /// </p>
        /// <p>Specify maintenance window targets using the following format:</p>
        /// <p>
        /// <code>Key=WindowTargetIds,Values=<window-target-id-1>,<window-target-id-2></code>
        /// </p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The targets (either instances or maintenance window targets).</p>
        /// <note>
        /// <p>One or more targets must be specified for maintenance window Run Command-type tasks.
        /// Depending on the task, targets are optional for other maintenance window task types (Automation,
        /// Lambda, and Step Functions). For more information about running tasks
        /// that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
        /// maintenance window tasks without targets</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// </note>
        /// <p>Specify instances using the following format: </p>
        /// <p>
        /// <code>Key=InstanceIds,Values=<instance-id-1>,<instance-id-2></code>
        /// </p>
        /// <p>Specify maintenance window targets using the following format:</p>
        /// <p>
        /// <code>Key=WindowTargetIds,Values=<window-target-id-1>,<window-target-id-2></code>
        /// </p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The ARN of the task to run.</p>
        pub fn task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(inp);
            self
        }
        /// <p>The ARN of the task to run.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a
        /// maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's
        /// service-linked role.  If no service-linked role for Systems Manager exists in your account, it is created when you run
        /// <code>RegisterTaskWithMaintenanceWindow</code>.</p>
        /// <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using
        /// service-linked roles for Systems Manager</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks?
        /// </a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a
        /// maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's
        /// service-linked role.  If no service-linked role for Systems Manager exists in your account, it is created when you run
        /// <code>RegisterTaskWithMaintenanceWindow</code>.</p>
        /// <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using
        /// service-linked roles for Systems Manager</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks?
        /// </a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// <p>The type of task being registered.</p>
        pub fn task_type(mut self, inp: crate::model::MaintenanceWindowTaskType) -> Self {
            self.inner = self.inner.task_type(inp);
            self
        }
        /// <p>The type of task being registered.</p>
        pub fn set_task_type(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskType>,
        ) -> Self {
            self.inner = self.inner.set_task_type(input);
            self
        }
        /// Adds a key-value pair to `TaskParameters`.
        ///
        /// To override the contents of this collection use [`set_task_parameters`](Self::set_task_parameters).
        ///
        /// <p>The parameters that should be passed to the task when it is run.</p>
        /// <note>
        /// <p>
        /// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
        /// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
        /// about how Systems Manager handles these options for the supported maintenance window task
        /// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        pub fn task_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MaintenanceWindowTaskParameterValueExpression>,
        ) -> Self {
            self.inner = self.inner.task_parameters(k, v);
            self
        }
        /// <p>The parameters that should be passed to the task when it is run.</p>
        /// <note>
        /// <p>
        /// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
        /// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
        /// about how Systems Manager handles these options for the supported maintenance window task
        /// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        pub fn set_task_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::MaintenanceWindowTaskParameterValueExpression,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_task_parameters(input);
            self
        }
        /// <p>The parameters that the task should use during execution. Populate only the fields that
        /// match the task type. All other fields should be empty. </p>
        pub fn task_invocation_parameters(
            mut self,
            inp: crate::model::MaintenanceWindowTaskInvocationParameters,
        ) -> Self {
            self.inner = self.inner.task_invocation_parameters(inp);
            self
        }
        /// <p>The parameters that the task should use during execution. Populate only the fields that
        /// match the task type. All other fields should be empty. </p>
        pub fn set_task_invocation_parameters(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
        ) -> Self {
            self.inner = self.inner.set_task_invocation_parameters(input);
            self
        }
        /// <p>The priority of the task in the maintenance window, the lower the number the higher the
        /// priority. Tasks in a maintenance window are scheduled in priority order with tasks that have the
        /// same priority scheduled in parallel.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The priority of the task in the maintenance window, the lower the number the higher the
        /// priority. Tasks in a maintenance window are scheduled in priority order with tasks that have the
        /// same priority scheduled in parallel.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The maximum number of targets this task can be run for in parallel.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't
        /// affect the running of your task.</p>
        /// </note>
        pub fn max_concurrency(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_concurrency(inp);
            self
        }
        /// <p>The maximum number of targets this task can be run for in parallel.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't
        /// affect the running of your task.</p>
        /// </note>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The maximum number of errors allowed before this task stops being scheduled.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't
        /// affect the running of your task.</p>
        /// </note>
        pub fn max_errors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_errors(inp);
            self
        }
        /// <p>The maximum number of errors allowed before this task stops being scheduled.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>. This value doesn't
        /// affect the running of your task.</p>
        /// </note>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_errors(input);
            self
        }
        /// <p>A structure containing information about an Amazon Simple Storage Service (Amazon S3) bucket
        /// to write instance-level logs to. </p>
        /// <note>
        /// <p>
        /// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
        /// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
        /// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
        /// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        pub fn logging_info(mut self, inp: crate::model::LoggingInfo) -> Self {
            self.inner = self.inner.logging_info(inp);
            self
        }
        /// <p>A structure containing information about an Amazon Simple Storage Service (Amazon S3) bucket
        /// to write instance-level logs to. </p>
        /// <note>
        /// <p>
        /// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
        /// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
        /// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
        /// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        pub fn set_logging_info(
            mut self,
            input: std::option::Option<crate::model::LoggingInfo>,
        ) -> Self {
            self.inner = self.inner.set_logging_info(input);
            self
        }
        /// <p>An optional name for the task.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>An optional name for the task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the task.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the task.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>User-provided idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Indicates whether tasks should continue to run after the cutoff time specified in the
        /// maintenance windows is reached. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running
        /// continue. The default value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_TASK</code>:</p>
        /// <ul>
        /// <li>
        /// <p>For Automation, Lambda, Step Functions tasks: When the cutoff
        /// time is reached, any task invocations that are already running continue, but no new task
        /// invocations are started.</p>
        /// </li>
        /// <li>
        /// <p>For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that attempts to cancel the command associated with the
        /// task. However, there is no guarantee that the command will be terminated and the underlying
        /// process stopped.</p>
        /// </li>
        /// </ul>
        /// <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p>
        /// </li>
        /// </ul>
        pub fn cutoff_behavior(
            mut self,
            inp: crate::model::MaintenanceWindowTaskCutoffBehavior,
        ) -> Self {
            self.inner = self.inner.cutoff_behavior(inp);
            self
        }
        /// <p>Indicates whether tasks should continue to run after the cutoff time specified in the
        /// maintenance windows is reached. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running
        /// continue. The default value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_TASK</code>:</p>
        /// <ul>
        /// <li>
        /// <p>For Automation, Lambda, Step Functions tasks: When the cutoff
        /// time is reached, any task invocations that are already running continue, but no new task
        /// invocations are started.</p>
        /// </li>
        /// <li>
        /// <p>For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that attempts to cancel the command associated with the
        /// task. However, there is no guarantee that the command will be terminated and the underlying
        /// process stopped.</p>
        /// </li>
        /// </ul>
        /// <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_cutoff_behavior(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
        ) -> Self {
            self.inner = self.inner.set_cutoff_behavior(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes tag keys from the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of resource from which you want to remove a tag.</p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises
        /// managed instances. Specify the name of the managed instance in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn resource_type(mut self, inp: crate::model::ResourceTypeForTagging) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of resource from which you want to remove a tag.</p>
        /// <note>
        /// <p>The <code>ManagedInstance</code> type for this API operation is only for on-premises
        /// managed instances. Specify the name of the managed instance in the following format:
        /// <code>mi-<i>ID_number</i>
        /// </code>. For example,
        /// <code>mi-1a2b3c4d5e6f</code>.</p>
        /// </note>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceTypeForTagging>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource from which you want to remove tags. For example:</p>
        /// <p>ManagedInstance: mi-012345abcde</p>
        /// <p>MaintenanceWindow: mw-012345abcde</p>
        /// <p>PatchBaseline: pb-012345abcde</p>
        /// <p>OpsMetadata object: <code>ResourceID</code> for tagging is created from the Amazon Resource
        /// Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that
        /// come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with
        /// an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code>
        /// has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or
        /// <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the Document and Parameter values, use the name of the resource.</p>
        /// <note>
        /// <p>The ManagedInstance type for this API operation is only for on-premises managed instances.
        /// Specify the name of the managed instance in the following format: mi-ID_number. For example,
        /// mi-1a2b3c4d5e6f.</p>
        /// </note>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the resource from which you want to remove tags. For example:</p>
        /// <p>ManagedInstance: mi-012345abcde</p>
        /// <p>MaintenanceWindow: mw-012345abcde</p>
        /// <p>PatchBaseline: pb-012345abcde</p>
        /// <p>OpsMetadata object: <code>ResourceID</code> for tagging is created from the Amazon Resource
        /// Name (ARN) for the object. Specifically, <code>ResourceID</code> is created from the strings that
        /// come after the word <code>opsmetadata</code> in the ARN. For example, an OpsMetadata object with
        /// an ARN of <code>arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager</code>
        /// has a <code>ResourceID</code> of either <code>aws/ssm/MyGroup/appmanager</code> or
        /// <code>/aws/ssm/MyGroup/appmanager</code>.</p>
        /// <p>For the Document and Parameter values, use the name of the resource.</p>
        /// <note>
        /// <p>The ManagedInstance type for this API operation is only for on-premises managed instances.
        /// Specify the name of the managed instance in the following format: mi-ID_number. For example,
        /// mi-1a2b3c4d5e6f.</p>
        /// </note>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Tag keys that you want to remove from the specified resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Tag keys that you want to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetServiceSetting`.
    ///
    /// <p>
    /// <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting
    /// defines how a user interacts with or uses a service or a feature of a service. For example, if an
    /// Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
    /// service team might create a default setting of "false". This means the user can't use this
    /// feature unless they change the setting to "true" and intentionally opt in for a paid
    /// feature.</p>
    /// <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define
    /// the default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>,
    /// but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code>
    /// permission for the setting. Use the <a>GetServiceSetting</a> API operation to view the
    /// current value. Use the <a>UpdateServiceSetting</a> API operation to change the default
    /// setting. </p>
    /// <p>Reset the service setting for the account to the default value as provisioned by the Amazon Web Services
    /// service team. </p>
    #[derive(std::fmt::Debug)]
    pub struct ResetServiceSetting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_service_setting_input::Builder,
    }
    impl<C, M, R> ResetServiceSetting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetServiceSetting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetServiceSettingOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetServiceSettingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetServiceSettingInputOperationOutputAlias,
                crate::output::ResetServiceSettingOutput,
                crate::error::ResetServiceSettingError,
                crate::input::ResetServiceSettingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be one of
        /// the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn setting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.setting_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be one of
        /// the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_setting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_setting_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResumeSession`.
    ///
    /// <p>Reconnects a session to an instance after it has been disconnected. Connections can be
    /// resumed for disconnected sessions, but not terminated sessions.</p>
    /// <note>
    /// <p>This command is primarily for use by client machines to automatically reconnect during
    /// intermittent network issues. It isn't intended for any other use.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ResumeSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resume_session_input::Builder,
    }
    impl<C, M, R> ResumeSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResumeSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResumeSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::ResumeSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResumeSessionInputOperationOutputAlias,
                crate::output::ResumeSessionOutput,
                crate::error::ResumeSessionError,
                crate::input::ResumeSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the disconnected session to resume.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The ID of the disconnected session to resume.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendAutomationSignal`.
    ///
    /// <p>Sends a signal to an Automation execution to change the current behavior or status of the
    /// execution. </p>
    #[derive(std::fmt::Debug)]
    pub struct SendAutomationSignal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_automation_signal_input::Builder,
    }
    impl<C, M, R> SendAutomationSignal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendAutomationSignal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendAutomationSignalOutput,
            aws_smithy_http::result::SdkError<crate::error::SendAutomationSignalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendAutomationSignalInputOperationOutputAlias,
                crate::output::SendAutomationSignalOutput,
                crate::error::SendAutomationSignalError,
                crate::input::SendAutomationSignalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for an existing Automation execution that you want to send the signal
        /// to.</p>
        pub fn automation_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.automation_execution_id(inp);
            self
        }
        /// <p>The unique identifier for an existing Automation execution that you want to send the signal
        /// to.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_execution_id(input);
            self
        }
        /// <p>The type of signal to send to an Automation execution. </p>
        pub fn signal_type(mut self, inp: crate::model::SignalType) -> Self {
            self.inner = self.inner.signal_type(inp);
            self
        }
        /// <p>The type of signal to send to an Automation execution. </p>
        pub fn set_signal_type(
            mut self,
            input: std::option::Option<crate::model::SignalType>,
        ) -> Self {
            self.inner = self.inner.set_signal_type(input);
            self
        }
        /// Adds a key-value pair to `Payload`.
        ///
        /// To override the contents of this collection use [`set_payload`](Self::set_payload).
        ///
        /// <p>The data sent with the signal. The data schema depends on the type of signal used in the
        /// request.</p>
        /// <p>For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional
        /// comment that you can send with the signal type. For example:</p>
        /// <p>
        /// <code>Comment="Looks good"</code>
        /// </p>
        /// <p>For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of
        /// the Automation step to start or resume as the payload. For example:</p>
        /// <p>
        /// <code>StepName="step1"</code>
        /// </p>
        /// <p>For the <code>StopStep</code> signal type, you must send the step execution ID as the
        /// payload. For example:</p>
        /// <p>
        /// <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code>
        /// </p>
        pub fn payload(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.payload(k, v);
            self
        }
        /// <p>The data sent with the signal. The data schema depends on the type of signal used in the
        /// request.</p>
        /// <p>For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional
        /// comment that you can send with the signal type. For example:</p>
        /// <p>
        /// <code>Comment="Looks good"</code>
        /// </p>
        /// <p>For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of
        /// the Automation step to start or resume as the payload. For example:</p>
        /// <p>
        /// <code>StepName="step1"</code>
        /// </p>
        /// <p>For the <code>StopStep</code> signal type, you must send the step execution ID as the
        /// payload. For example:</p>
        /// <p>
        /// <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code>
        /// </p>
        pub fn set_payload(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_payload(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendCommand`.
    ///
    /// <p>Runs commands on one or more managed instances.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendCommand<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_command_input::Builder,
    }
    impl<C, M, R> SendCommand<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendCommand`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendCommandOutput,
            aws_smithy_http::result::SdkError<crate::error::SendCommandError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendCommandInputOperationOutputAlias,
                crate::output::SendCommandOutput,
                crate::error::SendCommandError,
                crate::input::SendCommandInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `InstanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The IDs of the instances where the command should run. Specifying instance IDs is most
        /// useful when you are targeting a limited number of instances, though you can specify up to 50
        /// IDs.</p>
        /// <p>To target a larger number of instances, or if you prefer not to list individual instance
        /// IDs, we recommend using the <code>Targets</code> option instead. Using <code>Targets</code>,
        /// which accepts tag key-value pairs to identify the instances to send commands to, you can a send
        /// command to tens, hundreds, or thousands of instances at once.</p>
        /// <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Using targets and rate
        /// controls to send commands to a fleet</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn instance_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(inp);
            self
        }
        /// <p>The IDs of the instances where the command should run. Specifying instance IDs is most
        /// useful when you are targeting a limited number of instances, though you can specify up to 50
        /// IDs.</p>
        /// <p>To target a larger number of instances, or if you prefer not to list individual instance
        /// IDs, we recommend using the <code>Targets</code> option instead. Using <code>Targets</code>,
        /// which accepts tag key-value pairs to identify the instances to send commands to, you can a send
        /// command to tens, hundreds, or thousands of instances at once.</p>
        /// <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Using targets and rate
        /// controls to send commands to a fleet</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>An array of search criteria that targets instances using a <code>Key,Value</code>
        /// combination that you specify. Specifying targets is most useful when you want to send a command
        /// to a large number of instances at once. Using <code>Targets</code>, which accepts tag key-value
        /// pairs to identify instances, you can send a command to tens, hundreds, or thousands of instances
        /// at once.</p>
        /// <p>To send a command to a smaller number of instances, you can use the <code>InstanceIds</code>
        /// option instead.</p>
        /// <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending commands to a
        /// fleet</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>An array of search criteria that targets instances using a <code>Key,Value</code>
        /// combination that you specify. Specifying targets is most useful when you want to send a command
        /// to a large number of instances at once. Using <code>Targets</code>, which accepts tag key-value
        /// pairs to identify instances, you can send a command to tens, hundreds, or thousands of instances
        /// at once.</p>
        /// <p>To send a command to a smaller number of instances, you can use the <code>InstanceIds</code>
        /// option instead.</p>
        /// <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending commands to a
        /// fleet</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The name of the Amazon Web Services Systems Manager document (SSM document) to run. This can be a public document or a
        /// custom document. To run a shared document belonging to another account, specify the document
        /// Amazon Resource Name (ARN). For more information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared
        /// SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <note>
        /// <p>If you specify a document name or ARN that hasn't been shared with your account, you
        /// receive an <code>InvalidDocument</code> error. </p>
        /// </note>
        pub fn document_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_name(inp);
            self
        }
        /// <p>The name of the Amazon Web Services Systems Manager document (SSM document) to run. This can be a public document or a
        /// custom document. To run a shared document belonging to another account, specify the document
        /// Amazon Resource Name (ARN). For more information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared
        /// SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// <note>
        /// <p>If you specify a document name or ARN that hasn't been shared with your account, you
        /// receive an <code>InvalidDocument</code> error. </p>
        /// </note>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_name(input);
            self
        }
        /// <p>The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a
        /// specific version number. If you run commands by using the Command Line Interface (Amazon Web Services CLI), then
        /// you must escape the first two options by using a backslash. If you specify a version number, then
        /// you don't need to use the backslash. For example:</p>
        /// <p>--document-version "\$DEFAULT"</p>
        /// <p>--document-version "\$LATEST"</p>
        /// <p>--document-version "3"</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a
        /// specific version number. If you run commands by using the Command Line Interface (Amazon Web Services CLI), then
        /// you must escape the first two options by using a backslash. If you specify a version number, then
        /// you don't need to use the backslash. For example:</p>
        /// <p>--document-version "\$DEFAULT"</p>
        /// <p>--document-version "\$LATEST"</p>
        /// <p>--document-version "3"</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The Sha256 or Sha1 hash created by the system when the document was created. </p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn document_hash(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_hash(inp);
            self
        }
        /// <p>The Sha256 or Sha1 hash created by the system when the document was created. </p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn set_document_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_hash(input);
            self
        }
        /// <p>Sha256 or Sha1.</p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn document_hash_type(mut self, inp: crate::model::DocumentHashType) -> Self {
            self.inner = self.inner.document_hash_type(inp);
            self
        }
        /// <p>Sha256 or Sha1.</p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn set_document_hash_type(
            mut self,
            input: std::option::Option<crate::model::DocumentHashType>,
        ) -> Self {
            self.inner = self.inner.set_document_hash_type(input);
            self
        }
        /// <p>If this time is reached and the command hasn't already started running, it won't run.</p>
        pub fn timeout_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout_seconds(inp);
            self
        }
        /// <p>If this time is reached and the command hasn't already started running, it won't run.</p>
        pub fn set_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_seconds(input);
            self
        }
        /// <p>User-specified information about the command, such as a brief description of what the
        /// command should do.</p>
        pub fn comment(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(inp);
            self
        }
        /// <p>User-specified information about the command, such as a brief description of what the
        /// command should do.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The required and optional parameters specified in the document being run.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>The required and optional parameters specified in the document being run.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
        /// automatically determines the Amazon Web Services Region of the S3 bucket.</p>
        pub fn output_s3_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_region(inp);
            self
        }
        /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
        /// automatically determines the Amazon Web Services Region of the S3 bucket.</p>
        pub fn set_output_s3_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_region(input);
            self
        }
        /// <p>The name of the S3 bucket where command execution responses should be stored.</p>
        pub fn output_s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_bucket_name(inp);
            self
        }
        /// <p>The name of the S3 bucket where command execution responses should be stored.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_bucket_name(input);
            self
        }
        /// <p>The directory structure within the S3 bucket where the responses should be stored.</p>
        pub fn output_s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_key_prefix(inp);
            self
        }
        /// <p>The directory structure within the S3 bucket where the responses should be stored.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_key_prefix(input);
            self
        }
        /// <p>(Optional) The maximum number of instances that are allowed to run the command at the same
        /// time. You can specify a number such as 10 or a percentage such as 10%. The default value is
        /// <code>50</code>. For more information about how to use <code>MaxConcurrency</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity">Using
        /// concurrency controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn max_concurrency(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_concurrency(inp);
            self
        }
        /// <p>(Optional) The maximum number of instances that are allowed to run the command at the same
        /// time. You can specify a number such as 10 or a percentage such as 10%. The default value is
        /// <code>50</code>. For more information about how to use <code>MaxConcurrency</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity">Using
        /// concurrency controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The maximum number of errors allowed without the command failing. When the command fails one
        /// more time beyond the value of <code>MaxErrors</code>, the systems stops sending the command to
        /// additional targets. You can specify a number like 10 or a percentage like 10%. The default value
        /// is <code>0</code>. For more information about how to use <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors">Using
        /// error controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn max_errors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_errors(inp);
            self
        }
        /// <p>The maximum number of errors allowed without the command failing. When the command fails one
        /// more time beyond the value of <code>MaxErrors</code>, the systems stops sending the command to
        /// additional targets. You can specify a number like 10 or a percentage like 10%. The default value
        /// is <code>0</code>. For more information about how to use <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors">Using
        /// error controls</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_errors(input);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) service role to use to publish
        /// Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands.</p>
        pub fn service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(inp);
            self
        }
        /// <p>The ARN of the Identity and Access Management (IAM) service role to use to publish
        /// Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// <p>Configurations for sending notifications.</p>
        pub fn notification_config(mut self, inp: crate::model::NotificationConfig) -> Self {
            self.inner = self.inner.notification_config(inp);
            self
        }
        /// <p>Configurations for sending notifications.</p>
        pub fn set_notification_config(
            mut self,
            input: std::option::Option<crate::model::NotificationConfig>,
        ) -> Self {
            self.inner = self.inner.set_notification_config(input);
            self
        }
        /// <p>Enables Amazon Web Services Systems Manager to send Run Command output to Amazon CloudWatch Logs. Run Command is a
        /// capability of Amazon Web Services Systems Manager.</p>
        pub fn cloud_watch_output_config(
            mut self,
            inp: crate::model::CloudWatchOutputConfig,
        ) -> Self {
            self.inner = self.inner.cloud_watch_output_config(inp);
            self
        }
        /// <p>Enables Amazon Web Services Systems Manager to send Run Command output to Amazon CloudWatch Logs. Run Command is a
        /// capability of Amazon Web Services Systems Manager.</p>
        pub fn set_cloud_watch_output_config(
            mut self,
            input: std::option::Option<crate::model::CloudWatchOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_output_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAssociationsOnce`.
    ///
    /// <p>Runs an association immediately and only one time. This operation can be helpful when
    /// troubleshooting associations.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartAssociationsOnce<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_associations_once_input::Builder,
    }
    impl<C, M, R> StartAssociationsOnce<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAssociationsOnce`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAssociationsOnceOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAssociationsOnceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAssociationsOnceInputOperationOutputAlias,
                crate::output::StartAssociationsOnceOutput,
                crate::error::StartAssociationsOnceError,
                crate::input::StartAssociationsOnceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AssociationIds`.
        ///
        /// To override the contents of this collection use [`set_association_ids`](Self::set_association_ids).
        ///
        /// <p>The association IDs that you want to run immediately and only one time.</p>
        pub fn association_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_ids(inp);
            self
        }
        /// <p>The association IDs that you want to run immediately and only one time.</p>
        pub fn set_association_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_association_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAutomationExecution`.
    ///
    /// <p>Initiates execution of an Automation runbook.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartAutomationExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_automation_execution_input::Builder,
    }
    impl<C, M, R> StartAutomationExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAutomationExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAutomationExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAutomationExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAutomationExecutionInputOperationOutputAlias,
                crate::output::StartAutomationExecutionOutput,
                crate::error::StartAutomationExecutionError,
                crate::input::StartAutomationExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document to run. This can be a public document or a custom document. To
        /// run a shared document belonging to another account, specify the document ARN. For more
        /// information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents</a>
        /// in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn document_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_name(inp);
            self
        }
        /// <p>The name of the SSM document to run. This can be a public document or a custom document. To
        /// run a shared document belonging to another account, specify the document ARN. For more
        /// information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents</a>
        /// in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_name(input);
            self
        }
        /// <p>The version of the Automation runbook to use for this execution.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The version of the Automation runbook to use for this execution.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of execution parameters, which match the declared parameters in the
        /// Automation runbook.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>A key-value map of execution parameters, which match the declared parameters in the
        /// Automation runbook.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>User-provided idempotency token. The token must be unique, is case insensitive, enforces the
        /// UUID format, and can't be reused.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>User-provided idempotency token. The token must be unique, is case insensitive, enforces the
        /// UUID format, and can't be reused.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The execution mode of the automation. Valid modes include the following: Auto and
        /// Interactive. The default mode is Auto.</p>
        pub fn mode(mut self, inp: crate::model::ExecutionMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// <p>The execution mode of the automation. Valid modes include the following: Auto and
        /// Interactive. The default mode is Auto.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ExecutionMode>) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// <p>The name of the parameter used as the target resource for the rate-controlled execution.
        /// Required if you specify targets.</p>
        pub fn target_parameter_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_parameter_name(inp);
            self
        }
        /// <p>The name of the parameter used as the target resource for the rate-controlled execution.
        /// Required if you specify targets.</p>
        pub fn set_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_parameter_name(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A key-value mapping to target resources. Required if you specify TargetParameterName.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>A key-value mapping to target resources. Required if you specify TargetParameterName.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// Appends an item to `TargetMaps`.
        ///
        /// To override the contents of this collection use [`set_target_maps`](Self::set_target_maps).
        ///
        /// <p>A key-value mapping of document parameters to target resources. Both Targets and TargetMaps
        /// can't be specified together.</p>
        pub fn target_maps(
            mut self,
            inp: impl Into<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.target_maps(inp);
            self
        }
        /// <p>A key-value mapping of document parameters to target resources. Both Targets and TargetMaps
        /// can't be specified together.</p>
        pub fn set_target_maps(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<
                        std::string::String,
                        std::vec::Vec<std::string::String>,
                    >,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_target_maps(input);
            self
        }
        /// <p>The maximum number of targets allowed to run this task in parallel. You can specify a
        /// number, such as 10, or a percentage, such as 10%. The default value is <code>10</code>.</p>
        pub fn max_concurrency(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_concurrency(inp);
            self
        }
        /// <p>The maximum number of targets allowed to run this task in parallel. You can specify a
        /// number, such as 10, or a percentage, such as 10%. The default value is <code>10</code>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The number of errors that are allowed before the system stops running the automation on
        /// additional targets. You can specify either an absolute number of errors, for example 10, or a
        /// percentage of the target set, for example 10%. If you specify 3, for example, the system stops
        /// running the automation when the fourth error is received. If you specify 0, then the system stops
        /// running the automation on additional targets after the first error result is returned. If you run
        /// an automation on 50 resources and set max-errors to 10%, then the system stops running the
        /// automation on additional targets when the sixth error is received.</p>
        /// <p>Executions that are already running an automation when max-errors is reached are allowed to
        /// complete, but some of these executions may fail as well. If you need to ensure that there won't
        /// be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one
        /// at a time.</p>
        pub fn max_errors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_errors(inp);
            self
        }
        /// <p>The number of errors that are allowed before the system stops running the automation on
        /// additional targets. You can specify either an absolute number of errors, for example 10, or a
        /// percentage of the target set, for example 10%. If you specify 3, for example, the system stops
        /// running the automation when the fourth error is received. If you specify 0, then the system stops
        /// running the automation on additional targets after the first error result is returned. If you run
        /// an automation on 50 resources and set max-errors to 10%, then the system stops running the
        /// automation on additional targets when the sixth error is received.</p>
        /// <p>Executions that are already running an automation when max-errors is reached are allowed to
        /// complete, but some of these executions may fail as well. If you need to ensure that there won't
        /// be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one
        /// at a time.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_errors(input);
            self
        }
        /// Appends an item to `TargetLocations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the
        /// automation. Use this operation to start an automation in multiple Amazon Web Services Regions and multiple
        /// Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>. </p>
        pub fn target_locations(mut self, inp: impl Into<crate::model::TargetLocation>) -> Self {
            self.inner = self.inner.target_locations(inp);
            self
        }
        /// <p>A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the
        /// automation. Use this operation to start an automation in multiple Amazon Web Services Regions and multiple
        /// Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>. </p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.inner = self.inner.set_target_locations(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// an automation. Tags enable you to categorize a resource in different ways, such as by purpose,
        /// owner, or environment. For example, you might want to tag an automation to identify an
        /// environment or operating system. In this case, you could specify the following key-value
        /// pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=environment,Value=test</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// an automation. Tags enable you to categorize a resource in different ways, such as by purpose,
        /// owner, or environment. For example, you might want to tag an automation to identify an
        /// environment or operating system. In this case, you could specify the following key-value
        /// pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=environment,Value=test</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=OS,Value=Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a>
        /// operation.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartChangeRequestExecution`.
    ///
    /// <p>Creates a change request for Change Manager. The Automation runbooks specified in the
    /// change request run only after all required approvals for the change request have been
    /// received.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartChangeRequestExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_change_request_execution_input::Builder,
    }
    impl<C, M, R> StartChangeRequestExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartChangeRequestExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartChangeRequestExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartChangeRequestExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartChangeRequestExecutionInputOperationOutputAlias,
                crate::output::StartChangeRequestExecutionOutput,
                crate::error::StartChangeRequestExecutionError,
                crate::input::StartChangeRequestExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The date and time specified in the change request to run the Automation runbooks.</p>
        /// <note>
        /// <p>The Automation runbooks specified for the runbook workflow can't run until all required
        /// approvals for the change request have been received.</p>
        /// </note>
        pub fn scheduled_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.scheduled_time(inp);
            self
        }
        /// <p>The date and time specified in the change request to run the Automation runbooks.</p>
        /// <note>
        /// <p>The Automation runbooks specified for the runbook workflow can't run until all required
        /// approvals for the change request have been received.</p>
        /// </note>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_time(input);
            self
        }
        /// <p>The name of the change template document to run during the runbook workflow.</p>
        pub fn document_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_name(inp);
            self
        }
        /// <p>The name of the change template document to run during the runbook workflow.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_name(input);
            self
        }
        /// <p>The version of the change template document to run during the runbook workflow.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The version of the change template document to run during the runbook workflow.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A key-value map of parameters that match the declared parameters in the change template
        /// document.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>A key-value map of parameters that match the declared parameters in the change template
        /// document.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The name of the change request associated with the runbook workflow to be run.</p>
        pub fn change_request_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_request_name(inp);
            self
        }
        /// <p>The name of the change request associated with the runbook workflow to be run.</p>
        pub fn set_change_request_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_request_name(input);
            self
        }
        /// <p>The user-provided idempotency token. The token must be unique, is case insensitive, enforces
        /// the UUID format, and can't be reused.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The user-provided idempotency token. The token must be unique, is case insensitive, enforces
        /// the UUID format, and can't be reused.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Indicates whether the change request can be approved automatically without the need for
        /// manual approvals.</p>
        /// <p>If <code>AutoApprovable</code> is enabled in a change template, then setting
        /// <code>AutoApprove</code> to <code>true</code> in <code>StartChangeRequestExecution</code>
        /// creates a change request that bypasses approver review.</p>
        /// <note>
        /// <p>Change Calendar restrictions are not bypassed in this scenario. If the state of an
        /// associated calendar is <code>CLOSED</code>, change freeze approvers must still grant permission
        /// for this change request to run. If they don't, the change won't be processed until the calendar
        /// state is again <code>OPEN</code>. </p>
        /// </note>
        pub fn auto_approve(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_approve(inp);
            self
        }
        /// <p>Indicates whether the change request can be approved automatically without the need for
        /// manual approvals.</p>
        /// <p>If <code>AutoApprovable</code> is enabled in a change template, then setting
        /// <code>AutoApprove</code> to <code>true</code> in <code>StartChangeRequestExecution</code>
        /// creates a change request that bypasses approver review.</p>
        /// <note>
        /// <p>Change Calendar restrictions are not bypassed in this scenario. If the state of an
        /// associated calendar is <code>CLOSED</code>, change freeze approvers must still grant permission
        /// for this change request to run. If they don't, the change won't be processed until the calendar
        /// state is again <code>OPEN</code>. </p>
        /// </note>
        pub fn set_auto_approve(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_approve(input);
            self
        }
        /// Appends an item to `Runbooks`.
        ///
        /// To override the contents of this collection use [`set_runbooks`](Self::set_runbooks).
        ///
        /// <p>Information about the Automation runbooks that are run during the runbook workflow.</p>
        /// <note>
        /// <p>The Automation runbooks specified for the runbook workflow can't run until all required
        /// approvals for the change request have been received.</p>
        /// </note>
        pub fn runbooks(mut self, inp: impl Into<crate::model::Runbook>) -> Self {
            self.inner = self.inner.runbooks(inp);
            self
        }
        /// <p>Information about the Automation runbooks that are run during the runbook workflow.</p>
        /// <note>
        /// <p>The Automation runbooks specified for the runbook workflow can't run until all required
        /// approvals for the change request have been received.</p>
        /// </note>
        pub fn set_runbooks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runbook>>,
        ) -> Self {
            self.inner = self.inner.set_runbooks(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// a change request. Tags enable you to categorize a resource in different ways, such as by
        /// purpose, owner, or environment. For example, you might want to tag a change request to identify
        /// an environment or target Amazon Web Services Region. In this case, you could specify the following key-value
        /// pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Region,Value=us-east-2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for
        /// a change request. Tags enable you to categorize a resource in different ways, such as by
        /// purpose, owner, or environment. For example, you might want to tag a change request to identify
        /// an environment or target Amazon Web Services Region. In this case, you could specify the following key-value
        /// pairs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key=Environment,Value=Production</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Key=Region,Value=us-east-2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The time that the requester expects the runbook workflow related to the change request to
        /// complete. The time is an estimate only that the requester provides for reviewers.</p>
        pub fn scheduled_end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.scheduled_end_time(inp);
            self
        }
        /// <p>The time that the requester expects the runbook workflow related to the change request to
        /// complete. The time is an estimate only that the requester provides for reviewers.</p>
        pub fn set_scheduled_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_end_time(input);
            self
        }
        /// <p>User-provided details about the change. If no details are provided, content specified in the
        /// <b>Template information</b> section of the associated change template
        /// is added.</p>
        pub fn change_details(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_details(inp);
            self
        }
        /// <p>User-provided details about the change. If no details are provided, content specified in the
        /// <b>Template information</b> section of the associated change template
        /// is added.</p>
        pub fn set_change_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSession`.
    ///
    /// <p>Initiates a connection to a target (for example, an instance) for a Session Manager session. Returns a
    /// URL and token that can be used to open a WebSocket connection for sending input and receiving
    /// outputs.</p>
    /// <note>
    /// <p>Amazon Web Services CLI usage: <code>start-session</code> is an interactive command that requires the Session Manager
    /// plugin to be installed on the client machine making the call. For information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html">Install
    /// the Session Manager plugin for the Amazon Web Services CLI</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services Tools
    /// for PowerShell on Windows local machines.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct StartSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_session_input::Builder,
    }
    impl<C, M, R> StartSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSessionInputOperationOutputAlias,
                crate::output::StartSessionOutput,
                crate::error::StartSessionError,
                crate::input::StartSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The instance to connect to for the session.</p>
        pub fn target(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target(inp);
            self
        }
        /// <p>The instance to connect to for the session.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target(input);
            self
        }
        /// <p>The name of the SSM document to define the parameters and plugin settings for the session.
        /// For example, <code>SSM-SessionManagerRunShell</code>. You can call the <a>GetDocument</a> API to verify the document exists before attempting to start a session.
        /// If no document name is provided, a shell to the instance is launched by default.</p>
        pub fn document_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_name(inp);
            self
        }
        /// <p>The name of the SSM document to define the parameters and plugin settings for the session.
        /// For example, <code>SSM-SessionManagerRunShell</code>. You can call the <a>GetDocument</a> API to verify the document exists before attempting to start a session.
        /// If no document name is provided, a shell to the instance is launched by default.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_name(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Reserved for future use.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopAutomationExecution`.
    ///
    /// <p>Stop an Automation that is currently running.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopAutomationExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_automation_execution_input::Builder,
    }
    impl<C, M, R> StopAutomationExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopAutomationExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopAutomationExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopAutomationExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopAutomationExecutionInputOperationOutputAlias,
                crate::output::StopAutomationExecutionOutput,
                crate::error::StopAutomationExecutionError,
                crate::input::StopAutomationExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The execution ID of the Automation to stop.</p>
        pub fn automation_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.automation_execution_id(inp);
            self
        }
        /// <p>The execution ID of the Automation to stop.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_execution_id(input);
            self
        }
        /// <p>The stop request type. Valid types include the following: Cancel and Complete. The default
        /// type is Cancel.</p>
        pub fn r#type(mut self, inp: crate::model::StopType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The stop request type. Valid types include the following: Cancel and Complete. The default
        /// type is Cancel.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::StopType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TerminateSession`.
    ///
    /// <p>Permanently ends a session and closes the data connection between the Session Manager client and
    /// SSM Agent on the instance. A terminated session isn't be resumed.</p>
    #[derive(std::fmt::Debug)]
    pub struct TerminateSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::terminate_session_input::Builder,
    }
    impl<C, M, R> TerminateSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TerminateSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TerminateSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::TerminateSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TerminateSessionInputOperationOutputAlias,
                crate::output::TerminateSessionOutput,
                crate::error::TerminateSessionError,
                crate::input::TerminateSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the session to terminate.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The ID of the session to terminate.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnlabelParameterVersion`.
    ///
    /// <p>Remove a label or labels from a parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct UnlabelParameterVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unlabel_parameter_version_input::Builder,
    }
    impl<C, M, R> UnlabelParameterVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnlabelParameterVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnlabelParameterVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UnlabelParameterVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnlabelParameterVersionInputOperationOutputAlias,
                crate::output::UnlabelParameterVersionOutput,
                crate::error::UnlabelParameterVersionError,
                crate::input::UnlabelParameterVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter from which you want to delete one or more labels.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the parameter from which you want to delete one or more labels.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The specific version of the parameter which you want to delete one or more labels from. If
        /// it isn't present, the call will fail.</p>
        pub fn parameter_version(mut self, inp: i64) -> Self {
            self.inner = self.inner.parameter_version(inp);
            self
        }
        /// <p>The specific version of the parameter which you want to delete one or more labels from. If
        /// it isn't present, the call will fail.</p>
        pub fn set_parameter_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_parameter_version(input);
            self
        }
        /// Appends an item to `Labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>One or more labels to delete from the specified parameter version.</p>
        pub fn labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labels(inp);
            self
        }
        /// <p>One or more labels to delete from the specified parameter version.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssociation`.
    ///
    /// <p>Updates an association. You can update the association name and version, the document
    /// version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. </p>
    /// <p>In order to call this API operation, your Identity and Access Management (IAM) user
    /// account, group, or role must be configured with permission to call the <a>DescribeAssociation</a> API operation. If you don't have permission to call
    /// <code>DescribeAssociation</code>, then you receive the following error: <code>An error occurred
    /// (AccessDeniedException) when calling the UpdateAssociation operation: User: <user_arn>
    /// isn't authorized to perform: ssm:DescribeAssociation on resource:
    /// <resource_arn></code>
    /// </p>
    /// <important>
    /// <p>When you update an association, the association immediately runs against the specified
    /// targets.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_association_input::Builder,
    }
    impl<C, M, R> UpdateAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssociationInputOperationOutputAlias,
                crate::output::UpdateAssociationOutput,
                crate::error::UpdateAssociationError,
                crate::input::UpdateAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the association you want to update. </p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The ID of the association you want to update. </p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters you want to update for the association. If you create a parameter using
        /// Parameter Store, a capability of Amazon Web Services Systems Manager, you can reference the parameter using
        /// <code>{{ssm:parameter-name}}</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>The parameters you want to update for the association. If you create a parameter using
        /// Parameter Store, a capability of Amazon Web Services Systems Manager, you can reference the parameter using
        /// <code>{{ssm:parameter-name}}</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The document version you want update for the association. </p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The document version you want update for the association. </p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The cron expression used to schedule the association that you want to update.</p>
        pub fn schedule_expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_expression(inp);
            self
        }
        /// <p>The cron expression used to schedule the association that you want to update.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_expression(input);
            self
        }
        /// <p>An S3 bucket where you want to store the results of this request.</p>
        pub fn output_location(
            mut self,
            inp: crate::model::InstanceAssociationOutputLocation,
        ) -> Self {
            self.inner = self.inner.output_location(inp);
            self
        }
        /// <p>An S3 bucket where you want to store the results of this request.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration
        /// information for the instance.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
        /// shared with you from another account.</p>
        /// <p>For Systems Manager document (SSM document) that are shared with you from other Amazon Web Services accounts, you
        /// must specify the complete SSM document ARN, in the following format:</p>
        /// <p>
        /// <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i>
        /// </code>
        /// </p>
        /// <p>For example:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
        /// </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
        /// to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
        /// <code>My-Document</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM Command document or Automation runbook that contains the configuration
        /// information for the instance.</p>
        /// <p>You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
        /// shared with you from another account.</p>
        /// <p>For Systems Manager document (SSM document) that are shared with you from other Amazon Web Services accounts, you
        /// must specify the complete SSM document ARN, in the following format:</p>
        /// <p>
        /// <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i>
        /// </code>
        /// </p>
        /// <p>For example:</p>
        /// <p>
        /// <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
        /// </p>
        /// <p>For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
        /// to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
        /// <code>My-Document</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets of the association.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The targets of the association.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The name of the association that you want to update.</p>
        pub fn association_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_name(inp);
            self
        }
        /// <p>The name of the association that you want to update.</p>
        pub fn set_association_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_name(input);
            self
        }
        /// <p>This parameter is provided for concurrency control purposes. You must specify the latest
        /// association version in the service. If you want to ensure that this request succeeds, either
        /// specify <code>$LATEST</code>, or omit this parameter.</p>
        pub fn association_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_version(inp);
            self
        }
        /// <p>This parameter is provided for concurrency control purposes. You must specify the latest
        /// association version in the service. If you want to ensure that this request succeeds, either
        /// specify <code>$LATEST</code>, or omit this parameter.</p>
        pub fn set_association_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_version(input);
            self
        }
        /// <p>Specify the target for the association. This target is required for associations that use an
        /// Automation runbook and target resources by using rate controls. Automation is a capability of
        /// Amazon Web Services Systems Manager.</p>
        pub fn automation_target_parameter_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.automation_target_parameter_name(inp);
            self
        }
        /// <p>Specify the target for the association. This target is required for associations that use an
        /// Automation runbook and target resources by using rate controls. Automation is a capability of
        /// Amazon Web Services Systems Manager.</p>
        pub fn set_automation_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_automation_target_parameter_name(input);
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn max_errors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_errors(inp);
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_errors(input);
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn max_concurrency(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_concurrency(inp);
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn compliance_severity(
            mut self,
            inp: crate::model::AssociationComplianceSeverity,
        ) -> Self {
            self.inner = self.inner.compliance_severity(inp);
            self
        }
        /// <p>The severity level to assign to the association.</p>
        pub fn set_compliance_severity(
            mut self,
            input: std::option::Option<crate::model::AssociationComplianceSeverity>,
        ) -> Self {
            self.inner = self.inner.set_compliance_severity(input);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
        /// <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn sync_compliance(mut self, inp: crate::model::AssociationSyncCompliance) -> Self {
            self.inner = self.inner.sync_compliance(inp);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
        /// <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn set_sync_compliance(
            mut self,
            input: std::option::Option<crate::model::AssociationSyncCompliance>,
        ) -> Self {
            self.inner = self.inner.set_sync_compliance(input);
            self
        }
        /// <p>By default, when you update an association, the system runs it immediately after it is
        /// updated and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you update it. This parameter isn't supported for rate
        /// expressions.</p>
        /// <p>Also, if you specified this option when you created the association, you can reset it. To do
        /// so, specify the <code>no-apply-only-at-cron-interval</code> parameter when you update the
        /// association from the command line. This parameter forces the association to run immediately after
        /// updating it and according to the interval specified.</p>
        pub fn apply_only_at_cron_interval(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_only_at_cron_interval(inp);
            self
        }
        /// <p>By default, when you update an association, the system runs it immediately after it is
        /// updated and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you update it. This parameter isn't supported for rate
        /// expressions.</p>
        /// <p>Also, if you specified this option when you created the association, you can reset it. To do
        /// so, specify the <code>no-apply-only-at-cron-interval</code> parameter when you update the
        /// association from the command line. This parameter forces the association to run immediately after
        /// updating it and according to the interval specified.</p>
        pub fn set_apply_only_at_cron_interval(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_only_at_cron_interval(input);
            self
        }
        /// Appends an item to `CalendarNames`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
        /// gate your associations under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn calendar_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calendar_names(inp);
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
        /// gate your associations under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_calendar_names(input);
            self
        }
        /// Appends an item to `TargetLocations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association. Use this action to update an association in multiple Regions and multiple
        /// accounts.</p>
        pub fn target_locations(mut self, inp: impl Into<crate::model::TargetLocation>) -> Self {
            self.inner = self.inner.target_locations(inp);
            self
        }
        /// <p>A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association. Use this action to update an association in multiple Regions and multiple
        /// accounts.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.inner = self.inner.set_target_locations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssociationStatus`.
    ///
    /// <p>Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified
    /// instance.</p>
    /// <p>
    /// <code>UpdateAssociationStatus</code> is primarily used by the Amazon Web Services Systems Manager Agent (SSM Agent) to
    /// report status updates about your associations and is only used for associations created with the
    /// <code>InstanceId</code> legacy parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssociationStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_association_status_input::Builder,
    }
    impl<C, M, R> UpdateAssociationStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssociationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssociationStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssociationStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssociationStatusInputOperationOutputAlias,
                crate::output::UpdateAssociationStatusOutput,
                crate::error::UpdateAssociationStatusError,
                crate::input::UpdateAssociationStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The association status.</p>
        pub fn association_status(mut self, inp: crate::model::AssociationStatus) -> Self {
            self.inner = self.inner.association_status(inp);
            self
        }
        /// <p>The association status.</p>
        pub fn set_association_status(
            mut self,
            input: std::option::Option<crate::model::AssociationStatus>,
        ) -> Self {
            self.inner = self.inner.set_association_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocument`.
    ///
    /// <p>Updates one or more values for an SSM document.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDocument<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_document_input::Builder,
    }
    impl<C, M, R> UpdateDocument<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentInputOperationOutputAlias,
                crate::output::UpdateDocumentOutput,
                crate::error::UpdateDocumentError,
                crate::input::UpdateDocumentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A valid JSON or YAML string.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>A valid JSON or YAML string.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `Attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn attachments(mut self, inp: impl Into<crate::model::AttachmentsSource>) -> Self {
            self.inner = self.inner.attachments(inp);
            self
        }
        /// <p>A list of key-value pairs that describe attachments to a version of a document.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentsSource>>,
        ) -> Self {
            self.inner = self.inner.set_attachments(input);
            self
        }
        /// <p>The name of the SSM document that you want to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the SSM document that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The friendly name of the SSM document that you want to update. This value can differ for
        /// each version of the document. If you don't specify a value for this parameter in your request,
        /// the existing value is applied to the new document version.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The friendly name of the SSM document that you want to update. This value can differ for
        /// each version of the document. If you don't specify a value for this parameter in your request,
        /// the existing value is applied to the new document version.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>An optional field specifying the version of the artifact you are updating with the document.
        /// For example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>An optional field specifying the version of the artifact you are updating with the document.
        /// For example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The version of the document that you want to update. Currently, Systems Manager supports updating only
        /// the latest version of the document. You can specify the version number of the latest version or
        /// use the <code>$LATEST</code> variable.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The version of the document that you want to update. Currently, Systems Manager supports updating only
        /// the latest version of the document. You can specify the version number of the latest version or
        /// use the <code>$LATEST</code> variable.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>Specify the document format for the new document version. Systems Manager supports JSON and YAML
        /// documents. JSON is the default format.</p>
        pub fn document_format(mut self, inp: crate::model::DocumentFormat) -> Self {
            self.inner = self.inner.document_format(inp);
            self
        }
        /// <p>Specify the document format for the new document version. Systems Manager supports JSON and YAML
        /// documents. JSON is the default format.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.inner = self.inner.set_document_format(input);
            self
        }
        /// <p>Specify a new target type for the document.</p>
        pub fn target_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_type(inp);
            self
        }
        /// <p>Specify a new target type for the document.</p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocumentDefaultVersion`.
    ///
    /// <p>Set the default version of a document. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDocumentDefaultVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_document_default_version_input::Builder,
    }
    impl<C, M, R> UpdateDocumentDefaultVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocumentDefaultVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentDefaultVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentDefaultVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentDefaultVersionInputOperationOutputAlias,
                crate::output::UpdateDocumentDefaultVersionOutput,
                crate::error::UpdateDocumentDefaultVersionError,
                crate::input::UpdateDocumentDefaultVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a custom document that you want to set as the default version.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of a custom document that you want to set as the default version.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of a custom document that you want to set as the default version.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The version of a custom document that you want to set as the default version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDocumentMetadata`.
    ///
    /// <p>Updates information related to approval reviews for a specific version of a change template
    /// in Change Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDocumentMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_document_metadata_input::Builder,
    }
    impl<C, M, R> UpdateDocumentMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDocumentMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDocumentMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDocumentMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDocumentMetadataInputOperationOutputAlias,
                crate::output::UpdateDocumentMetadataOutput,
                crate::error::UpdateDocumentMetadataError,
                crate::input::UpdateDocumentMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the change template for which a version's metadata is to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the change template for which a version's metadata is to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of a change template in which to update approval metadata.</p>
        pub fn document_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document_version(inp);
            self
        }
        /// <p>The version of a change template in which to update approval metadata.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_document_version(input);
            self
        }
        /// <p>The change template review details to update.</p>
        pub fn document_reviews(mut self, inp: crate::model::DocumentReviews) -> Self {
            self.inner = self.inner.document_reviews(inp);
            self
        }
        /// <p>The change template review details to update.</p>
        pub fn set_document_reviews(
            mut self,
            input: std::option::Option<crate::model::DocumentReviews>,
        ) -> Self {
            self.inner = self.inner.set_document_reviews(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMaintenanceWindow`.
    ///
    /// <p>Updates an existing maintenance window. Only specified parameters are modified.</p>
    /// <note>
    /// <p>The value you specify for <code>Duration</code> determines the specific end time for the
    /// maintenance window based on the time it begins. No maintenance window tasks are permitted to
    /// start after the resulting endtime minus the number of hours you specify for <code>Cutoff</code>.
    /// For example, if the maintenance window starts at 3 PM, the duration is three hours, and the
    /// value you specify for <code>Cutoff</code> is one hour, no maintenance window tasks can start
    /// after 5 PM.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMaintenanceWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_maintenance_window_input::Builder,
    }
    impl<C, M, R> UpdateMaintenanceWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMaintenanceWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMaintenanceWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMaintenanceWindowInputOperationOutputAlias,
                crate::output::UpdateMaintenanceWindowOutput,
                crate::error::UpdateMaintenanceWindowError,
                crate::input::UpdateMaintenanceWindowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the maintenance window to update.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The ID of the maintenance window to update.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the maintenance window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the update request.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the update request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn start_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_date(inp);
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_date(input);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become inactive. <code>EndDate</code> allows you to set a date and time in the future when the
        /// maintenance window will no longer run.</p>
        pub fn end_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.end_date(inp);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
        /// become inactive. <code>EndDate</code> allows you to set a date and time in the future when the
        /// maintenance window will no longer run.</p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>The schedule of the maintenance window in the form of a cron or rate expression.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn schedule_timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_timezone(inp);
            self
        }
        /// <p>The time zone that the scheduled maintenance window executions are based on, in Internet
        /// Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
        /// "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
        /// Zone Database</a> on the IANA website.</p>
        pub fn set_schedule_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_timezone(input);
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before
        /// running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run the third
        /// Tuesday of every month at 11:30 PM.</p>
        /// <p>
        /// <code>cron(30 23 ? * TUE#3 *)</code>
        /// </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days
        /// later.</p>
        pub fn schedule_offset(mut self, inp: i32) -> Self {
            self.inner = self.inner.schedule_offset(inp);
            self
        }
        /// <p>The number of days to wait after the date and time specified by a cron expression before
        /// running the maintenance window.</p>
        /// <p>For example, the following cron expression schedules a maintenance window to run the third
        /// Tuesday of every month at 11:30 PM.</p>
        /// <p>
        /// <code>cron(30 23 ? * TUE#3 *)</code>
        /// </p>
        /// <p>If the schedule offset is <code>2</code>, the maintenance window won't run until two days
        /// later.</p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_schedule_offset(input);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The duration of the maintenance window in hours.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
        /// new tasks for execution.</p>
        pub fn cutoff(mut self, inp: i32) -> Self {
            self.inner = self.inner.cutoff(inp);
            self
        }
        /// <p>The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
        /// new tasks for execution.</p>
        pub fn set_cutoff(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_cutoff(input);
            self
        }
        /// <p>Whether targets must be registered with the maintenance window before tasks can be defined
        /// for those targets.</p>
        pub fn allow_unassociated_targets(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_unassociated_targets(inp);
            self
        }
        /// <p>Whether targets must be registered with the maintenance window before tasks can be defined
        /// for those targets.</p>
        pub fn set_allow_unassociated_targets(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_unassociated_targets(input);
            self
        }
        /// <p>Whether the maintenance window is enabled.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Whether the maintenance window is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>If <code>True</code>, then all fields that are required by the <a>CreateMaintenanceWindow</a> operation are also required for this API request. Optional
        /// fields that aren't specified are set to null. </p>
        pub fn replace(mut self, inp: bool) -> Self {
            self.inner = self.inner.replace(inp);
            self
        }
        /// <p>If <code>True</code>, then all fields that are required by the <a>CreateMaintenanceWindow</a> operation are also required for this API request. Optional
        /// fields that aren't specified are set to null. </p>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMaintenanceWindowTarget`.
    ///
    /// <p>Modifies the target of an existing maintenance window. You
    /// can change the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Name</p>
    /// </li>
    /// <li>
    /// <p>Description</p>
    /// </li>
    /// <li>
    /// <p>Owner</p>
    /// </li>
    /// <li>
    /// <p>IDs for an ID target</p>
    /// </li>
    /// <li>
    /// <p>Tags for a Tag target</p>
    /// </li>
    /// <li>
    /// <p>From any supported tag type to another. The three supported tag types are ID target, Tag
    /// target, and resource group. For more information, see <a>Target</a>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If a parameter is null, then the corresponding field isn't modified.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMaintenanceWindowTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_maintenance_window_target_input::Builder,
    }
    impl<C, M, R> UpdateMaintenanceWindowTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMaintenanceWindowTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMaintenanceWindowTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMaintenanceWindowTargetInputOperationOutputAlias,
                crate::output::UpdateMaintenanceWindowTargetOutput,
                crate::error::UpdateMaintenanceWindowTargetError,
                crate::input::UpdateMaintenanceWindowTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maintenance window ID with which to modify the target.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The maintenance window ID with which to modify the target.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The target ID to modify.</p>
        pub fn window_target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_target_id(inp);
            self
        }
        /// <p>The target ID to modify.</p>
        pub fn set_window_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_target_id(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets to add or replace.</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The targets to add or replace.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>User-provided value that will be included in any Amazon CloudWatch Events events raised while
        /// running tasks for these targets in this maintenance window.</p>
        pub fn owner_information(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_information(inp);
            self
        }
        /// <p>User-provided value that will be included in any Amazon CloudWatch Events events raised while
        /// running tasks for these targets in this maintenance window.</p>
        pub fn set_owner_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_information(input);
            self
        }
        /// <p>A name for the update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name for the update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the update.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If <code>True</code>, then all fields that are required by the <a>RegisterTargetWithMaintenanceWindow</a> operation are also required for this API
        /// request. Optional fields that aren't specified are set to null.</p>
        pub fn replace(mut self, inp: bool) -> Self {
            self.inner = self.inner.replace(inp);
            self
        }
        /// <p>If <code>True</code>, then all fields that are required by the <a>RegisterTargetWithMaintenanceWindow</a> operation are also required for this API
        /// request. Optional fields that aren't specified are set to null.</p>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMaintenanceWindowTask`.
    ///
    /// <p>Modifies a task assigned to a maintenance window. You can't change the task type, but you
    /// can change the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TaskARN</code>. For example, you can change a <code>RUN_COMMAND</code> task from
    /// <code>AWS-RunPowerShellScript</code> to <code>AWS-RunShellScript</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ServiceRoleArn</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TaskInvocationParameters</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Priority</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaxConcurrency</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaxErrors</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>One or more targets must be specified for maintenance window Run Command-type tasks.
    /// Depending on the task, targets are optional for other maintenance window task types (Automation,
    /// Lambda, and Step Functions). For more information about running tasks
    /// that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
    /// maintenance window tasks without targets</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// </note>
    /// <p>If the value for a parameter in <code>UpdateMaintenanceWindowTask</code> is null, then the
    /// corresponding field isn't modified. If you set <code>Replace</code> to true, then all fields
    /// required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are required for
    /// this request. Optional fields that aren't specified are set to null.</p>
    /// <important>
    /// <p>When you update a maintenance window task that has options specified in
    /// <code>TaskInvocationParameters</code>, you must provide again all the
    /// <code>TaskInvocationParameters</code> values that you want to retain. The values you don't
    /// specify again are removed. For example, suppose that when you registered a Run Command task, you
    /// specified <code>TaskInvocationParameters</code> values for <code>Comment</code>,
    /// <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the
    /// maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the
    /// values for <code>Comment</code> and <code>NotificationConfig</code> are removed.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMaintenanceWindowTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_maintenance_window_task_input::Builder,
    }
    impl<C, M, R> UpdateMaintenanceWindowTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMaintenanceWindowTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMaintenanceWindowTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMaintenanceWindowTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMaintenanceWindowTaskInputOperationOutputAlias,
                crate::output::UpdateMaintenanceWindowTaskOutput,
                crate::error::UpdateMaintenanceWindowTaskError,
                crate::input::UpdateMaintenanceWindowTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maintenance window ID that contains the task to modify.</p>
        pub fn window_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_id(inp);
            self
        }
        /// <p>The maintenance window ID that contains the task to modify.</p>
        pub fn set_window_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_window_id(input);
            self
        }
        /// <p>The task ID to modify.</p>
        pub fn window_task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.window_task_id(inp);
            self
        }
        /// <p>The task ID to modify.</p>
        pub fn set_window_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_window_task_id(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets (either instances or tags) to modify. Instances are specified using the format
        /// <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the
        /// format <code> Key=tag_name,Values=tag_value</code>. </p>
        /// <note>
        /// <p>One or more targets must be specified for maintenance window Run Command-type tasks.
        /// Depending on the task, targets are optional for other maintenance window task types (Automation,
        /// Lambda, and Step Functions). For more information about running tasks
        /// that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
        /// maintenance window tasks without targets</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// </note>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The targets (either instances or tags) to modify. Instances are specified using the format
        /// <code>Key=instanceids,Values=instanceID_1,instanceID_2</code>. Tags are specified using the
        /// format <code> Key=tag_name,Values=tag_value</code>. </p>
        /// <note>
        /// <p>One or more targets must be specified for maintenance window Run Command-type tasks.
        /// Depending on the task, targets are optional for other maintenance window task types (Automation,
        /// Lambda, and Step Functions). For more information about running tasks
        /// that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
        /// maintenance window tasks without targets</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// </note>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The task ARN to modify.</p>
        pub fn task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_arn(inp);
            self
        }
        /// <p>The task ARN to modify.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a
        /// maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's
        /// service-linked role.  If no service-linked role for Systems Manager exists in your account, it is created when you run
        /// <code>RegisterTaskWithMaintenanceWindow</code>.</p>
        /// <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using
        /// service-linked roles for Systems Manager</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks?
        /// </a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a
        /// maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's
        /// service-linked role.  If no service-linked role for Systems Manager exists in your account, it is created when you run
        /// <code>RegisterTaskWithMaintenanceWindow</code>.</p>
        /// <p>For more information, see the following topics in the in the <i>Amazon Web Services Systems Manager User Guide</i>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using
        /// service-linked roles for Systems Manager</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks?
        /// </a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// Adds a key-value pair to `TaskParameters`.
        ///
        /// To override the contents of this collection use [`set_task_parameters`](Self::set_task_parameters).
        ///
        /// <p>The parameters to modify.</p>
        /// <note>
        /// <p>
        /// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
        /// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
        /// about how Systems Manager handles these options for the supported maintenance window task
        /// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        /// <p>The map has the following format:</p>
        /// <p>Key: string, between 1 and 255 characters</p>
        /// <p>Value: an array of strings, each string is between 1 and 255 characters</p>
        pub fn task_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MaintenanceWindowTaskParameterValueExpression>,
        ) -> Self {
            self.inner = self.inner.task_parameters(k, v);
            self
        }
        /// <p>The parameters to modify.</p>
        /// <note>
        /// <p>
        /// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
        /// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
        /// about how Systems Manager handles these options for the supported maintenance window task
        /// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        /// <p>The map has the following format:</p>
        /// <p>Key: string, between 1 and 255 characters</p>
        /// <p>Value: an array of strings, each string is between 1 and 255 characters</p>
        pub fn set_task_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::MaintenanceWindowTaskParameterValueExpression,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_task_parameters(input);
            self
        }
        /// <p>The parameters that the task should use during execution. Populate only the fields that
        /// match the task type. All other fields should be empty.</p>
        /// <important>
        /// <p>When you update a maintenance window task that has options specified in
        /// <code>TaskInvocationParameters</code>, you must provide again all the
        /// <code>TaskInvocationParameters</code> values that you want to retain. The values you don't
        /// specify again are removed. For example, suppose that when you registered a Run Command task, you
        /// specified <code>TaskInvocationParameters</code> values for <code>Comment</code>,
        /// <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the
        /// maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the
        /// values for <code>Comment</code> and <code>NotificationConfig</code> are removed.</p>
        /// </important>
        pub fn task_invocation_parameters(
            mut self,
            inp: crate::model::MaintenanceWindowTaskInvocationParameters,
        ) -> Self {
            self.inner = self.inner.task_invocation_parameters(inp);
            self
        }
        /// <p>The parameters that the task should use during execution. Populate only the fields that
        /// match the task type. All other fields should be empty.</p>
        /// <important>
        /// <p>When you update a maintenance window task that has options specified in
        /// <code>TaskInvocationParameters</code>, you must provide again all the
        /// <code>TaskInvocationParameters</code> values that you want to retain. The values you don't
        /// specify again are removed. For example, suppose that when you registered a Run Command task, you
        /// specified <code>TaskInvocationParameters</code> values for <code>Comment</code>,
        /// <code>NotificationConfig</code>, and <code>OutputS3BucketName</code>. If you update the
        /// maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the
        /// values for <code>Comment</code> and <code>NotificationConfig</code> are removed.</p>
        /// </important>
        pub fn set_task_invocation_parameters(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskInvocationParameters>,
        ) -> Self {
            self.inner = self.inner.set_task_invocation_parameters(input);
            self
        }
        /// <p>The new task priority to specify. The lower the number, the higher the priority. Tasks that
        /// have the same priority are scheduled in parallel.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The new task priority to specify. The lower the number, the higher the priority. Tasks that
        /// have the same priority are scheduled in parallel.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code>
        /// is the number of targets that are allowed to run this task in parallel.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported
        /// in the response to this command. This value doesn't affect the running of your task and can be
        /// ignored.</p>
        /// </note>
        pub fn max_concurrency(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_concurrency(inp);
            self
        }
        /// <p>The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code>
        /// is the number of targets that are allowed to run this task in parallel.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported
        /// in the response to this command. This value doesn't affect the running of your task and can be
        /// ignored.</p>
        /// </note>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum
        /// number of errors that are allowed before the task stops being scheduled.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported
        /// in the response to this command. This value doesn't affect the running of your task and can be
        /// ignored.</p>
        /// </note>
        pub fn max_errors(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_errors(inp);
            self
        }
        /// <p>The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum
        /// number of errors that are allowed before the task stops being scheduled.</p>
        /// <note>
        /// <p>For maintenance window tasks without a target specified, you can't supply a value for this
        /// option. Instead, the system inserts a placeholder value of <code>1</code>, which may be reported
        /// in the response to this command. This value doesn't affect the running of your task and can be
        /// ignored.</p>
        /// </note>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_errors(input);
            self
        }
        /// <p>The new logging location in Amazon S3 to specify.</p>
        /// <note>
        /// <p>
        /// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
        /// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
        /// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
        /// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        pub fn logging_info(mut self, inp: crate::model::LoggingInfo) -> Self {
            self.inner = self.inner.logging_info(inp);
            self
        }
        /// <p>The new logging location in Amazon S3 to specify.</p>
        /// <note>
        /// <p>
        /// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
        /// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
        /// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
        /// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// </note>
        pub fn set_logging_info(
            mut self,
            input: std::option::Option<crate::model::LoggingInfo>,
        ) -> Self {
            self.inner = self.inner.set_logging_info(input);
            self
        }
        /// <p>The new task name to specify.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new task name to specify.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new task description to specify.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new task description to specify.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>If True, then all fields that are required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are also required for this API request.
        /// Optional fields that aren't specified are set to null.</p>
        pub fn replace(mut self, inp: bool) -> Self {
            self.inner = self.inner.replace(inp);
            self
        }
        /// <p>If True, then all fields that are required by the <a>RegisterTaskWithMaintenanceWindow</a> operation are also required for this API request.
        /// Optional fields that aren't specified are set to null.</p>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace(input);
            self
        }
        /// <p>Indicates whether tasks should continue to run after the cutoff time specified in the
        /// maintenance windows is reached. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running
        /// continue. The default value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_TASK</code>:</p>
        /// <ul>
        /// <li>
        /// <p>For Automation, Lambda, Step Functions tasks: When the cutoff
        /// time is reached, any task invocations that are already running continue, but no new task
        /// invocations are started.</p>
        /// </li>
        /// <li>
        /// <p>For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that attempts to cancel the command associated with the
        /// task. However, there is no guarantee that the command will be terminated and the underlying
        /// process stopped.</p>
        /// </li>
        /// </ul>
        /// <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p>
        /// </li>
        /// </ul>
        pub fn cutoff_behavior(
            mut self,
            inp: crate::model::MaintenanceWindowTaskCutoffBehavior,
        ) -> Self {
            self.inner = self.inner.cutoff_behavior(inp);
            self
        }
        /// <p>Indicates whether tasks should continue to run after the cutoff time specified in the
        /// maintenance windows is reached. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CONTINUE_TASK</code>: When the cutoff time is reached, any tasks that are running
        /// continue. The default value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANCEL_TASK</code>:</p>
        /// <ul>
        /// <li>
        /// <p>For Automation, Lambda, Step Functions tasks: When the cutoff
        /// time is reached, any task invocations that are already running continue, but no new task
        /// invocations are started.</p>
        /// </li>
        /// <li>
        /// <p>For Run Command tasks: When the cutoff time is reached, the system sends a <a>CancelCommand</a> operation that attempts to cancel the command associated with the
        /// task. However, there is no guarantee that the command will be terminated and the underlying
        /// process stopped.</p>
        /// </li>
        /// </ul>
        /// <p>The status for tasks that are not completed is <code>TIMED_OUT</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_cutoff_behavior(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowTaskCutoffBehavior>,
        ) -> Self {
            self.inner = self.inner.set_cutoff_behavior(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateManagedInstanceRole`.
    ///
    /// <p>Changes the Identity and Access Management (IAM) role that is assigned to the
    /// on-premises instance or virtual machines (VM). IAM roles are first assigned to
    /// these hybrid instances during the activation process. For more information, see <a>CreateActivation</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateManagedInstanceRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_managed_instance_role_input::Builder,
    }
    impl<C, M, R> UpdateManagedInstanceRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateManagedInstanceRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateManagedInstanceRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateManagedInstanceRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateManagedInstanceRoleInputOperationOutputAlias,
                crate::output::UpdateManagedInstanceRoleOutput,
                crate::error::UpdateManagedInstanceRoleError,
                crate::input::UpdateManagedInstanceRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the managed instance where you want to update the role.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The ID of the managed instance where you want to update the role.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The IAM role you want to assign or change.</p>
        pub fn iam_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(inp);
            self
        }
        /// <p>The IAM role you want to assign or change.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOpsItem`.
    ///
    /// <p>Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
    /// OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
    /// remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
    /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateOpsItem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ops_item_input::Builder,
    }
    impl<C, M, R> UpdateOpsItem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOpsItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOpsItemOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOpsItemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOpsItemInputOperationOutputAlias,
                crate::output::UpdateOpsItemOutput,
                crate::error::UpdateOpsItemError,
                crate::input::UpdateOpsItemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Update the information about the OpsItem. Provide enough information so that users reading
        /// this OpsItem for the first time understand the issue. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Update the information about the OpsItem. Provide enough information so that users reading
        /// this OpsItem for the first time understand the issue. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `OperationalData`.
        ///
        /// To override the contents of this collection use [`set_operational_data`](Self::set_operational_data).
        ///
        /// <p>Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem
        /// object.</p>
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn operational_data(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OpsItemDataValue>,
        ) -> Self {
            self.inner = self.inner.operational_data(k, v);
            self
        }
        /// <p>Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem
        /// object.</p>
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_operational_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_operational_data(input);
            self
        }
        /// Appends an item to `OperationalDataToDelete`.
        ///
        /// To override the contents of this collection use [`set_operational_data_to_delete`](Self::set_operational_data_to_delete).
        ///
        /// <p>Keys that you want to remove from the OperationalData map.</p>
        pub fn operational_data_to_delete(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operational_data_to_delete(inp);
            self
        }
        /// <p>Keys that you want to remove from the OperationalData map.</p>
        pub fn set_operational_data_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_operational_data_to_delete(input);
            self
        }
        /// Appends an item to `Notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
        /// OpsItem is edited or changed.</p>
        pub fn notifications(mut self, inp: impl Into<crate::model::OpsItemNotification>) -> Self {
            self.inner = self.inner.notifications(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
        /// OpsItem is edited or changed.</p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
        ) -> Self {
            self.inner = self.inner.set_notifications(input);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// Appends an item to `RelatedOpsItems`.
        ///
        /// To override the contents of this collection use [`set_related_ops_items`](Self::set_related_ops_items).
        ///
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn related_ops_items(mut self, inp: impl Into<crate::model::RelatedOpsItem>) -> Self {
            self.inner = self.inner.related_ops_items(inp);
            self
        }
        /// <p>One or more OpsItems that share something in common with the current OpsItems. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn set_related_ops_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
        ) -> Self {
            self.inner = self.inner.set_related_ops_items(input);
            self
        }
        /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
        /// <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn status(mut self, inp: crate::model::OpsItemStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
        /// <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OpsItemStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn ops_item_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_item_id(inp);
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ops_item_id(input);
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>Specify a new category for an OpsItem.</p>
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// <p>Specify a new category for an OpsItem.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// <p>Specify a new severity for an OpsItem.</p>
        pub fn severity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity(inp);
            self
        }
        /// <p>Specify a new severity for an OpsItem.</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.actual_start_time(inp);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_actual_start_time(input);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.actual_end_time(inp);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_actual_end_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.planned_start_time(inp);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_planned_start_time(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.planned_end_time(inp);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_planned_end_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOpsMetadata`.
    ///
    /// <p>Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateOpsMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ops_metadata_input::Builder,
    }
    impl<C, M, R> UpdateOpsMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOpsMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOpsMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOpsMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOpsMetadataInputOperationOutputAlias,
                crate::output::UpdateOpsMetadataOutput,
                crate::error::UpdateOpsMetadataError,
                crate::input::UpdateOpsMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resoure Name (ARN) of the OpsMetadata Object to update.</p>
        pub fn ops_metadata_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ops_metadata_arn(inp);
            self
        }
        /// <p>The Amazon Resoure Name (ARN) of the OpsMetadata Object to update.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ops_metadata_arn(input);
            self
        }
        /// Adds a key-value pair to `MetadataToUpdate`.
        ///
        /// To override the contents of this collection use [`set_metadata_to_update`](Self::set_metadata_to_update).
        ///
        /// <p>Metadata to add to an OpsMetadata object.</p>
        pub fn metadata_to_update(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MetadataValue>,
        ) -> Self {
            self.inner = self.inner.metadata_to_update(k, v);
            self
        }
        /// <p>Metadata to add to an OpsMetadata object.</p>
        pub fn set_metadata_to_update(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetadataValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata_to_update(input);
            self
        }
        /// Appends an item to `KeysToDelete`.
        ///
        /// To override the contents of this collection use [`set_keys_to_delete`](Self::set_keys_to_delete).
        ///
        /// <p>The metadata keys to delete from the OpsMetadata object. </p>
        pub fn keys_to_delete(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keys_to_delete(inp);
            self
        }
        /// <p>The metadata keys to delete from the OpsMetadata object. </p>
        pub fn set_keys_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keys_to_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePatchBaseline`.
    ///
    /// <p>Modifies an existing patch baseline. Fields not specified in the request are left
    /// unchanged.</p>
    /// <note>
    /// <p>For information about valid key-value pairs in <code>PatchFilters</code> for each supported
    /// operating system type, see <a>PatchFilter</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePatchBaseline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_patch_baseline_input::Builder,
    }
    impl<C, M, R> UpdatePatchBaseline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePatchBaseline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePatchBaselineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePatchBaselineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePatchBaselineInputOperationOutputAlias,
                crate::output::UpdatePatchBaselineOutput,
                crate::error::UpdatePatchBaselineError,
                crate::input::UpdatePatchBaselineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the patch baseline to update.</p>
        pub fn baseline_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.baseline_id(inp);
            self
        }
        /// <p>The ID of the patch baseline to update.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_baseline_id(input);
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn global_filters(mut self, inp: crate::model::PatchFilterGroup) -> Self {
            self.inner = self.inner.global_filters(inp);
            self
        }
        /// <p>A set of global filters used to include patches in the baseline.</p>
        pub fn set_global_filters(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.inner = self.inner.set_global_filters(input);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn approval_rules(mut self, inp: crate::model::PatchRuleGroup) -> Self {
            self.inner = self.inner.approval_rules(inp);
            self
        }
        /// <p>A set of rules used to include patches in the baseline.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<crate::model::PatchRuleGroup>,
        ) -> Self {
            self.inner = self.inner.set_approval_rules(input);
            self
        }
        /// Appends an item to `ApprovedPatches`.
        ///
        /// To override the contents of this collection use [`set_approved_patches`](Self::set_approved_patches).
        ///
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn approved_patches(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approved_patches(inp);
            self
        }
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_approved_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches(input);
            self
        }
        /// <p>Assigns a new compliance severity level to an existing patch baseline.</p>
        pub fn approved_patches_compliance_level(
            mut self,
            inp: crate::model::PatchComplianceLevel,
        ) -> Self {
            self.inner = self.inner.approved_patches_compliance_level(inp);
            self
        }
        /// <p>Assigns a new compliance severity level to an existing patch baseline.</p>
        pub fn set_approved_patches_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches_compliance_level(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the instances. The default value is <code>false</code>. Applies to Linux instances
        /// only.</p>
        pub fn approved_patches_enable_non_security(mut self, inp: bool) -> Self {
            self.inner = self.inner.approved_patches_enable_non_security(inp);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the instances. The default value is <code>false</code>. Applies to Linux instances
        /// only.</p>
        pub fn set_approved_patches_enable_non_security(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_approved_patches_enable_non_security(input);
            self
        }
        /// Appends an item to `RejectedPatches`.
        ///
        /// To override the contents of this collection use [`set_rejected_patches`](Self::set_rejected_patches).
        ///
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn rejected_patches(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rejected_patches(inp);
            self
        }
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_rejected_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rejected_patches(input);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ALLOW_AS_DEPENDENCY</code>
        /// </b>: A package in the
        /// <code>Rejected</code> patches list is installed only if it is a dependency of another package.
        /// It is considered compliant with the patch baseline, and its status is reported as
        /// <code>InstalledOther</code>. This is the default action if no option is specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BLOCK</code>
        /// </b>: Packages in the
        /// <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't
        /// installed under any circumstances. If a package was installed before it was added to the
        /// <code>Rejected</code> patches list, it is considered non-compliant with the patch baseline,
        /// and its status is reported as <code>InstalledRejected</code>.</p>
        /// </li>
        /// </ul>
        pub fn rejected_patches_action(mut self, inp: crate::model::PatchAction) -> Self {
            self.inner = self.inner.rejected_patches_action(inp);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ALLOW_AS_DEPENDENCY</code>
        /// </b>: A package in the
        /// <code>Rejected</code> patches list is installed only if it is a dependency of another package.
        /// It is considered compliant with the patch baseline, and its status is reported as
        /// <code>InstalledOther</code>. This is the default action if no option is specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BLOCK</code>
        /// </b>: Packages in the
        /// <code>RejectedPatches</code> list, and packages that include them as dependencies, aren't
        /// installed under any circumstances. If a package was installed before it was added to the
        /// <code>Rejected</code> patches list, it is considered non-compliant with the patch baseline,
        /// and its status is reported as <code>InstalledRejected</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_rejected_patches_action(
            mut self,
            input: std::option::Option<crate::model::PatchAction>,
        ) -> Self {
            self.inner = self.inner.set_rejected_patches_action(input);
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the patch baseline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>Information about the patches to use to update the instances, including target operating
        /// systems and source repositories. Applies to Linux instances only.</p>
        pub fn sources(mut self, inp: impl Into<crate::model::PatchSource>) -> Self {
            self.inner = self.inner.sources(inp);
            self
        }
        /// <p>Information about the patches to use to update the instances, including target operating
        /// systems and source repositories. Applies to Linux instances only.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// <p>If True, then all fields that are required by the <a>CreatePatchBaseline</a>
        /// operation are also required for this API request. Optional fields that aren't specified are set
        /// to null.</p>
        pub fn replace(mut self, inp: bool) -> Self {
            self.inner = self.inner.replace(inp);
            self
        }
        /// <p>If True, then all fields that are required by the <a>CreatePatchBaseline</a>
        /// operation are also required for this API request. Optional fields that aren't specified are set
        /// to null.</p>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceDataSync`.
    ///
    /// <p>Update a resource data sync. After you create a resource data sync for a Region, you can't
    /// change the account options for that sync. For example, if you create a sync in the us-east-2
    /// (Ohio) Region and you choose the <code>Include only the current account</code> option, you can't
    /// edit that sync later and choose the <code>Include all accounts from my Organizations
    /// configuration</code> option. Instead, you must delete the first resource data sync, and create a
    /// new one.</p>
    /// <note>
    /// <p>This API operation only supports a resource data sync that was created with a
    /// SyncFromSource <code>SyncType</code>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResourceDataSync<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_data_sync_input::Builder,
    }
    impl<C, M, R> UpdateResourceDataSync<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceDataSync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceDataSyncOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceDataSyncError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceDataSyncInputOperationOutputAlias,
                crate::output::UpdateResourceDataSyncOutput,
                crate::error::UpdateResourceDataSyncError,
                crate::input::UpdateResourceDataSyncInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource data sync you want to update.</p>
        pub fn sync_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_name(inp);
            self
        }
        /// <p>The name of the resource data sync you want to update.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_name(input);
            self
        }
        /// <p>The type of resource data sync. The supported <code>SyncType</code> is
        /// SyncFromSource.</p>
        pub fn sync_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sync_type(inp);
            self
        }
        /// <p>The type of resource data sync. The supported <code>SyncType</code> is
        /// SyncFromSource.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sync_type(input);
            self
        }
        /// <p>Specify information about the data sources to synchronize.</p>
        pub fn sync_source(mut self, inp: crate::model::ResourceDataSyncSource) -> Self {
            self.inner = self.inner.sync_source(inp);
            self
        }
        /// <p>Specify information about the data sources to synchronize.</p>
        pub fn set_sync_source(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncSource>,
        ) -> Self {
            self.inner = self.inner.set_sync_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceSetting`.
    ///
    /// <p>
    /// <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting
    /// defines how a user interacts with or uses a service or a feature of a service. For example, if an
    /// Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
    /// service team might create a default setting of "false". This means the user can't use this
    /// feature unless they change the setting to "true" and intentionally opt in for a paid
    /// feature.</p>
    /// <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define
    /// the default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>,
    /// but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code>
    /// permission for the setting. Use the <a>GetServiceSetting</a> API operation to view the
    /// current value. Or, use the <a>ResetServiceSetting</a> to change the value back to the
    /// original value defined by the Amazon Web Services service team.</p>
    /// <p>Update the service setting for the account. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServiceSetting<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_setting_input::Builder,
    }
    impl<C, M, R> UpdateServiceSetting<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceSetting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceSettingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceSettingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceSettingInputOperationOutputAlias,
                crate::output::UpdateServiceSettingOutput,
                crate::error::UpdateServiceSettingError,
                crate::input::UpdateServiceSettingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the service setting to reset. For example,
        /// <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>.
        /// The setting ID can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn setting_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.setting_id(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service setting to reset. For example,
        /// <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>.
        /// The setting ID can be one of the following.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_setting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_setting_id(input);
            self
        }
        /// <p>The new value to specify for the service setting. The following list specifies the available
        /// values for each setting.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>: <code>Standard</code>,
        /// <code>Advanced</code>, <code>Intelligent-Tiering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>: <code>true</code> or
        /// <code>false</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>: <code>true</code> or
        /// <code>false</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>: <code>CloudWatch</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>: the name of an Amazon CloudWatch Logs log group</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>: <code>Enable</code> or
        /// <code>Disable</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>: <code>standard</code> or
        /// <code>advanced</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn setting_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.setting_value(inp);
            self
        }
        /// <p>The new value to specify for the service setting. The following list specifies the available
        /// values for each setting.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/default-parameter-tier</code>: <code>Standard</code>,
        /// <code>Advanced</code>, <code>Intelligent-Tiering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/parameter-store/high-throughput-enabled</code>: <code>true</code> or
        /// <code>false</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>: <code>true</code> or
        /// <code>false</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-destination</code>: <code>CloudWatch</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/automation/customer-script-log-group-name</code>: the name of an Amazon CloudWatch Logs log group</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/documents/console/public-sharing-permission</code>: <code>Enable</code> or
        /// <code>Disable</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>/ssm/managed-instance/activation-tier</code>: <code>standard</code> or
        /// <code>advanced</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_setting_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_setting_value(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
