// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about the source of the data included in the resource data sync.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncSource {
    /// <p>The type of data source for the resource data sync. <code>SourceType</code> is either
    /// <code>AwsOrganizations</code> (if an organization is present in Organizations) or
    /// <code>SingleAccountMultiRegions</code>.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>Information about the <code>AwsOrganizationsSource</code> resource data sync source. A sync
    /// source of this type can synchronize data from Organizations.</p>
    pub aws_organizations_source:
        std::option::Option<crate::model::ResourceDataSyncAwsOrganizationsSource>,
    /// <p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>
    pub source_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those
    /// Regions come online.</p>
    pub include_future_regions: bool,
    /// <p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager
    /// automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in
    /// your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub enable_all_ops_data_sources: bool,
}
impl std::fmt::Debug for ResourceDataSyncSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncSource");
        formatter.field("source_type", &self.source_type);
        formatter.field("aws_organizations_source", &self.aws_organizations_source);
        formatter.field("source_regions", &self.source_regions);
        formatter.field("include_future_regions", &self.include_future_regions);
        formatter.field(
            "enable_all_ops_data_sources",
            &self.enable_all_ops_data_sources,
        );
        formatter.finish()
    }
}
/// See [`ResourceDataSyncSource`](crate::model::ResourceDataSyncSource)
pub mod resource_data_sync_source {
    /// A builder for [`ResourceDataSyncSource`](crate::model::ResourceDataSyncSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) aws_organizations_source:
            std::option::Option<crate::model::ResourceDataSyncAwsOrganizationsSource>,
        pub(crate) source_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include_future_regions: std::option::Option<bool>,
        pub(crate) enable_all_ops_data_sources: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The type of data source for the resource data sync. <code>SourceType</code> is either
        /// <code>AwsOrganizations</code> (if an organization is present in Organizations) or
        /// <code>SingleAccountMultiRegions</code>.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of data source for the resource data sync. <code>SourceType</code> is either
        /// <code>AwsOrganizations</code> (if an organization is present in Organizations) or
        /// <code>SingleAccountMultiRegions</code>.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// <p>Information about the <code>AwsOrganizationsSource</code> resource data sync source. A sync
        /// source of this type can synchronize data from Organizations.</p>
        pub fn aws_organizations_source(
            mut self,
            input: crate::model::ResourceDataSyncAwsOrganizationsSource,
        ) -> Self {
            self.aws_organizations_source = Some(input);
            self
        }
        /// <p>Information about the <code>AwsOrganizationsSource</code> resource data sync source. A sync
        /// source of this type can synchronize data from Organizations.</p>
        pub fn set_aws_organizations_source(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncAwsOrganizationsSource>,
        ) -> Self {
            self.aws_organizations_source = input;
            self
        }
        /// Appends an item to `source_regions`.
        ///
        /// To override the contents of this collection use [`set_source_regions`](Self::set_source_regions).
        ///
        /// <p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>
        pub fn source_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_regions.unwrap_or_default();
            v.push(input.into());
            self.source_regions = Some(v);
            self
        }
        /// <p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>
        pub fn set_source_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_regions = input;
            self
        }
        /// <p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those
        /// Regions come online.</p>
        pub fn include_future_regions(mut self, input: bool) -> Self {
            self.include_future_regions = Some(input);
            self
        }
        /// <p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those
        /// Regions come online.</p>
        pub fn set_include_future_regions(mut self, input: std::option::Option<bool>) -> Self {
            self.include_future_regions = input;
            self
        }
        /// <p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager
        /// automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in
        /// your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn enable_all_ops_data_sources(mut self, input: bool) -> Self {
            self.enable_all_ops_data_sources = Some(input);
            self
        }
        /// <p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager
        /// automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in
        /// your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_enable_all_ops_data_sources(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_all_ops_data_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncSource`](crate::model::ResourceDataSyncSource)
        pub fn build(self) -> crate::model::ResourceDataSyncSource {
            crate::model::ResourceDataSyncSource {
                source_type: self.source_type,
                aws_organizations_source: self.aws_organizations_source,
                source_regions: self.source_regions,
                include_future_regions: self.include_future_regions.unwrap_or_default(),
                enable_all_ops_data_sources: self.enable_all_ops_data_sources.unwrap_or_default(),
            }
        }
    }
}
impl ResourceDataSyncSource {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncSource`](crate::model::ResourceDataSyncSource)
    pub fn builder() -> crate::model::resource_data_sync_source::Builder {
        crate::model::resource_data_sync_source::Builder::default()
    }
}

/// <p>Information about the <code>AwsOrganizationsSource</code> resource data sync source. A sync
/// source of this type can synchronize data from Organizations or, if an Amazon Web Services organization isn't
/// present, from multiple Amazon Web Services Regions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncAwsOrganizationsSource {
    /// <p>If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or
    /// <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated
    /// from a set of organization units. For <code>EntireOrganization</code>, the data is aggregated
    /// from the entire Amazon Web Services organization.</p>
    pub organization_source_type: std::option::Option<std::string::String>,
    /// <p>The Organizations organization units included in the sync.</p>
    pub organizational_units:
        std::option::Option<std::vec::Vec<crate::model::ResourceDataSyncOrganizationalUnit>>,
}
impl std::fmt::Debug for ResourceDataSyncAwsOrganizationsSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncAwsOrganizationsSource");
        formatter.field("organization_source_type", &self.organization_source_type);
        formatter.field("organizational_units", &self.organizational_units);
        formatter.finish()
    }
}
/// See [`ResourceDataSyncAwsOrganizationsSource`](crate::model::ResourceDataSyncAwsOrganizationsSource)
pub mod resource_data_sync_aws_organizations_source {
    /// A builder for [`ResourceDataSyncAwsOrganizationsSource`](crate::model::ResourceDataSyncAwsOrganizationsSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_source_type: std::option::Option<std::string::String>,
        pub(crate) organizational_units:
            std::option::Option<std::vec::Vec<crate::model::ResourceDataSyncOrganizationalUnit>>,
    }
    impl Builder {
        /// <p>If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or
        /// <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated
        /// from a set of organization units. For <code>EntireOrganization</code>, the data is aggregated
        /// from the entire Amazon Web Services organization.</p>
        pub fn organization_source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_source_type = Some(input.into());
            self
        }
        /// <p>If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or
        /// <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated
        /// from a set of organization units. For <code>EntireOrganization</code>, the data is aggregated
        /// from the entire Amazon Web Services organization.</p>
        pub fn set_organization_source_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_source_type = input;
            self
        }
        /// Appends an item to `organizational_units`.
        ///
        /// To override the contents of this collection use [`set_organizational_units`](Self::set_organizational_units).
        ///
        /// <p>The Organizations organization units included in the sync.</p>
        pub fn organizational_units(
            mut self,
            input: impl Into<crate::model::ResourceDataSyncOrganizationalUnit>,
        ) -> Self {
            let mut v = self.organizational_units.unwrap_or_default();
            v.push(input.into());
            self.organizational_units = Some(v);
            self
        }
        /// <p>The Organizations organization units included in the sync.</p>
        pub fn set_organizational_units(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ResourceDataSyncOrganizationalUnit>,
            >,
        ) -> Self {
            self.organizational_units = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncAwsOrganizationsSource`](crate::model::ResourceDataSyncAwsOrganizationsSource)
        pub fn build(self) -> crate::model::ResourceDataSyncAwsOrganizationsSource {
            crate::model::ResourceDataSyncAwsOrganizationsSource {
                organization_source_type: self.organization_source_type,
                organizational_units: self.organizational_units,
            }
        }
    }
}
impl ResourceDataSyncAwsOrganizationsSource {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncAwsOrganizationsSource`](crate::model::ResourceDataSyncAwsOrganizationsSource)
    pub fn builder() -> crate::model::resource_data_sync_aws_organizations_source::Builder {
        crate::model::resource_data_sync_aws_organizations_source::Builder::default()
    }
}

/// <p>The Organizations organizational unit data source for the sync.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncOrganizationalUnit {
    /// <p>The Organizations unit ID data source for the sync.</p>
    pub organizational_unit_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceDataSyncOrganizationalUnit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncOrganizationalUnit");
        formatter.field("organizational_unit_id", &self.organizational_unit_id);
        formatter.finish()
    }
}
/// See [`ResourceDataSyncOrganizationalUnit`](crate::model::ResourceDataSyncOrganizationalUnit)
pub mod resource_data_sync_organizational_unit {
    /// A builder for [`ResourceDataSyncOrganizationalUnit`](crate::model::ResourceDataSyncOrganizationalUnit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organizational_unit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Organizations unit ID data source for the sync.</p>
        pub fn organizational_unit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizational_unit_id = Some(input.into());
            self
        }
        /// <p>The Organizations unit ID data source for the sync.</p>
        pub fn set_organizational_unit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncOrganizationalUnit`](crate::model::ResourceDataSyncOrganizationalUnit)
        pub fn build(self) -> crate::model::ResourceDataSyncOrganizationalUnit {
            crate::model::ResourceDataSyncOrganizationalUnit {
                organizational_unit_id: self.organizational_unit_id,
            }
        }
    }
}
impl ResourceDataSyncOrganizationalUnit {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncOrganizationalUnit`](crate::model::ResourceDataSyncOrganizationalUnit)
    pub fn builder() -> crate::model::resource_data_sync_organizational_unit::Builder {
        crate::model::resource_data_sync_organizational_unit::Builder::default()
    }
}

/// <p>Information about the patches to use to update the instances, including target operating
/// systems and source repository. Applies to Linux instances only.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchSource {
    /// <p>The name specified to identify the patch source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The specific operating system versions a patch repository applies to, such as "Ubuntu16.04",
    /// "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product
    /// values, see <a>PatchFilter</a>.</p>
    pub products: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The value of the yum repo configuration. For example:</p>
    /// <p>
    /// <code>[main]</code>
    /// </p>
    /// <p>
    /// <code>name=MyCustomRepository</code>
    /// </p>
    /// <p>
    /// <code>baseurl=https://my-custom-repository</code>
    /// </p>
    /// <p>
    /// <code>enabled=1</code>
    /// </p>
    /// <note>
    /// <p>For information about other options available for your yum repository configuration, see
    /// <a href="https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5)</a>.</p>
    /// </note>
    pub configuration: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PatchSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchSource");
        formatter.field("name", &self.name);
        formatter.field("products", &self.products);
        formatter.field("configuration", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`PatchSource`](crate::model::PatchSource)
pub mod patch_source {
    /// A builder for [`PatchSource`](crate::model::PatchSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) products: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) configuration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name specified to identify the patch source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name specified to identify the patch source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `products`.
        ///
        /// To override the contents of this collection use [`set_products`](Self::set_products).
        ///
        /// <p>The specific operating system versions a patch repository applies to, such as "Ubuntu16.04",
        /// "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product
        /// values, see <a>PatchFilter</a>.</p>
        pub fn products(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.products.unwrap_or_default();
            v.push(input.into());
            self.products = Some(v);
            self
        }
        /// <p>The specific operating system versions a patch repository applies to, such as "Ubuntu16.04",
        /// "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product
        /// values, see <a>PatchFilter</a>.</p>
        pub fn set_products(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.products = input;
            self
        }
        /// <p>The value of the yum repo configuration. For example:</p>
        /// <p>
        /// <code>[main]</code>
        /// </p>
        /// <p>
        /// <code>name=MyCustomRepository</code>
        /// </p>
        /// <p>
        /// <code>baseurl=https://my-custom-repository</code>
        /// </p>
        /// <p>
        /// <code>enabled=1</code>
        /// </p>
        /// <note>
        /// <p>For information about other options available for your yum repository configuration, see
        /// <a href="https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5)</a>.</p>
        /// </note>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>The value of the yum repo configuration. For example:</p>
        /// <p>
        /// <code>[main]</code>
        /// </p>
        /// <p>
        /// <code>name=MyCustomRepository</code>
        /// </p>
        /// <p>
        /// <code>baseurl=https://my-custom-repository</code>
        /// </p>
        /// <p>
        /// <code>enabled=1</code>
        /// </p>
        /// <note>
        /// <p>For information about other options available for your yum repository configuration, see
        /// <a href="https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5)</a>.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchSource`](crate::model::PatchSource)
        pub fn build(self) -> crate::model::PatchSource {
            crate::model::PatchSource {
                name: self.name,
                products: self.products,
                configuration: self.configuration,
            }
        }
    }
}
impl PatchSource {
    /// Creates a new builder-style object to manufacture [`PatchSource`](crate::model::PatchSource)
    pub fn builder() -> crate::model::patch_source::Builder {
        crate::model::patch_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PatchAction {
    #[allow(missing_docs)] // documentation missing in model
    AllowAsDependency,
    #[allow(missing_docs)] // documentation missing in model
    Block,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PatchAction {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW_AS_DEPENDENCY" => PatchAction::AllowAsDependency,
            "BLOCK" => PatchAction::Block,
            other => PatchAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PatchAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PatchAction::from(s))
    }
}
impl PatchAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PatchAction::AllowAsDependency => "ALLOW_AS_DEPENDENCY",
            PatchAction::Block => "BLOCK",
            PatchAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW_AS_DEPENDENCY", "BLOCK"]
    }
}
impl AsRef<str> for PatchAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PatchComplianceLevel {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Informational,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Unspecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PatchComplianceLevel {
    fn from(s: &str) -> Self {
        match s {
            "CRITICAL" => PatchComplianceLevel::Critical,
            "HIGH" => PatchComplianceLevel::High,
            "INFORMATIONAL" => PatchComplianceLevel::Informational,
            "LOW" => PatchComplianceLevel::Low,
            "MEDIUM" => PatchComplianceLevel::Medium,
            "UNSPECIFIED" => PatchComplianceLevel::Unspecified,
            other => PatchComplianceLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PatchComplianceLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PatchComplianceLevel::from(s))
    }
}
impl PatchComplianceLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PatchComplianceLevel::Critical => "CRITICAL",
            PatchComplianceLevel::High => "HIGH",
            PatchComplianceLevel::Informational => "INFORMATIONAL",
            PatchComplianceLevel::Low => "LOW",
            PatchComplianceLevel::Medium => "MEDIUM",
            PatchComplianceLevel::Unspecified => "UNSPECIFIED",
            PatchComplianceLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CRITICAL",
            "HIGH",
            "INFORMATIONAL",
            "LOW",
            "MEDIUM",
            "UNSPECIFIED",
        ]
    }
}
impl AsRef<str> for PatchComplianceLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of rules defining the approval rules for a patch baseline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchRuleGroup {
    /// <p>The rules that make up the rule group.</p>
    pub patch_rules: std::option::Option<std::vec::Vec<crate::model::PatchRule>>,
}
impl std::fmt::Debug for PatchRuleGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchRuleGroup");
        formatter.field("patch_rules", &self.patch_rules);
        formatter.finish()
    }
}
/// See [`PatchRuleGroup`](crate::model::PatchRuleGroup)
pub mod patch_rule_group {
    /// A builder for [`PatchRuleGroup`](crate::model::PatchRuleGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_rules: std::option::Option<std::vec::Vec<crate::model::PatchRule>>,
    }
    impl Builder {
        /// Appends an item to `patch_rules`.
        ///
        /// To override the contents of this collection use [`set_patch_rules`](Self::set_patch_rules).
        ///
        /// <p>The rules that make up the rule group.</p>
        pub fn patch_rules(mut self, input: impl Into<crate::model::PatchRule>) -> Self {
            let mut v = self.patch_rules.unwrap_or_default();
            v.push(input.into());
            self.patch_rules = Some(v);
            self
        }
        /// <p>The rules that make up the rule group.</p>
        pub fn set_patch_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchRule>>,
        ) -> Self {
            self.patch_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchRuleGroup`](crate::model::PatchRuleGroup)
        pub fn build(self) -> crate::model::PatchRuleGroup {
            crate::model::PatchRuleGroup {
                patch_rules: self.patch_rules,
            }
        }
    }
}
impl PatchRuleGroup {
    /// Creates a new builder-style object to manufacture [`PatchRuleGroup`](crate::model::PatchRuleGroup)
    pub fn builder() -> crate::model::patch_rule_group::Builder {
        crate::model::patch_rule_group::Builder::default()
    }
}

/// <p>Defines an approval rule for a patch baseline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchRule {
    /// <p>The patch filter group that defines the criteria for the rule.</p>
    pub patch_filter_group: std::option::Option<crate::model::PatchFilterGroup>,
    /// <p>A compliance severity level for all approved patches in a patch baseline.</p>
    pub compliance_level: std::option::Option<crate::model::PatchComplianceLevel>,
    /// <p>The number of days after the release date of each patch matched by the rule that the patch
    /// is marked as approved in the patch baseline. For example, a value of <code>7</code> means that
    /// patches are approved seven days after they are released. Not supported on Debian Server or Ubuntu
    /// Server.</p>
    pub approve_after_days: std::option::Option<i32>,
    /// <p>The cutoff date for auto approval of released patches. Any patches released on or before
    /// this date are installed automatically. Not supported on Debian Server or Ubuntu Server.</p>
    /// <p>Enter dates in the format <code>YYYY-MM-DD</code>. For example,
    /// <code>2021-12-31</code>.</p>
    pub approve_until_date: std::option::Option<std::string::String>,
    /// <p>For instances identified by the approval rule filters, enables a patch baseline to apply
    /// non-security updates available in the specified repository. The default value is
    /// <code>false</code>. Applies to Linux instances only.</p>
    pub enable_non_security: std::option::Option<bool>,
}
impl std::fmt::Debug for PatchRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchRule");
        formatter.field("patch_filter_group", &self.patch_filter_group);
        formatter.field("compliance_level", &self.compliance_level);
        formatter.field("approve_after_days", &self.approve_after_days);
        formatter.field("approve_until_date", &self.approve_until_date);
        formatter.field("enable_non_security", &self.enable_non_security);
        formatter.finish()
    }
}
/// See [`PatchRule`](crate::model::PatchRule)
pub mod patch_rule {
    /// A builder for [`PatchRule`](crate::model::PatchRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_filter_group: std::option::Option<crate::model::PatchFilterGroup>,
        pub(crate) compliance_level: std::option::Option<crate::model::PatchComplianceLevel>,
        pub(crate) approve_after_days: std::option::Option<i32>,
        pub(crate) approve_until_date: std::option::Option<std::string::String>,
        pub(crate) enable_non_security: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The patch filter group that defines the criteria for the rule.</p>
        pub fn patch_filter_group(mut self, input: crate::model::PatchFilterGroup) -> Self {
            self.patch_filter_group = Some(input);
            self
        }
        /// <p>The patch filter group that defines the criteria for the rule.</p>
        pub fn set_patch_filter_group(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.patch_filter_group = input;
            self
        }
        /// <p>A compliance severity level for all approved patches in a patch baseline.</p>
        pub fn compliance_level(mut self, input: crate::model::PatchComplianceLevel) -> Self {
            self.compliance_level = Some(input);
            self
        }
        /// <p>A compliance severity level for all approved patches in a patch baseline.</p>
        pub fn set_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.compliance_level = input;
            self
        }
        /// <p>The number of days after the release date of each patch matched by the rule that the patch
        /// is marked as approved in the patch baseline. For example, a value of <code>7</code> means that
        /// patches are approved seven days after they are released. Not supported on Debian Server or Ubuntu
        /// Server.</p>
        pub fn approve_after_days(mut self, input: i32) -> Self {
            self.approve_after_days = Some(input);
            self
        }
        /// <p>The number of days after the release date of each patch matched by the rule that the patch
        /// is marked as approved in the patch baseline. For example, a value of <code>7</code> means that
        /// patches are approved seven days after they are released. Not supported on Debian Server or Ubuntu
        /// Server.</p>
        pub fn set_approve_after_days(mut self, input: std::option::Option<i32>) -> Self {
            self.approve_after_days = input;
            self
        }
        /// <p>The cutoff date for auto approval of released patches. Any patches released on or before
        /// this date are installed automatically. Not supported on Debian Server or Ubuntu Server.</p>
        /// <p>Enter dates in the format <code>YYYY-MM-DD</code>. For example,
        /// <code>2021-12-31</code>.</p>
        pub fn approve_until_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.approve_until_date = Some(input.into());
            self
        }
        /// <p>The cutoff date for auto approval of released patches. Any patches released on or before
        /// this date are installed automatically. Not supported on Debian Server or Ubuntu Server.</p>
        /// <p>Enter dates in the format <code>YYYY-MM-DD</code>. For example,
        /// <code>2021-12-31</code>.</p>
        pub fn set_approve_until_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approve_until_date = input;
            self
        }
        /// <p>For instances identified by the approval rule filters, enables a patch baseline to apply
        /// non-security updates available in the specified repository. The default value is
        /// <code>false</code>. Applies to Linux instances only.</p>
        pub fn enable_non_security(mut self, input: bool) -> Self {
            self.enable_non_security = Some(input);
            self
        }
        /// <p>For instances identified by the approval rule filters, enables a patch baseline to apply
        /// non-security updates available in the specified repository. The default value is
        /// <code>false</code>. Applies to Linux instances only.</p>
        pub fn set_enable_non_security(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_non_security = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchRule`](crate::model::PatchRule)
        pub fn build(self) -> crate::model::PatchRule {
            crate::model::PatchRule {
                patch_filter_group: self.patch_filter_group,
                compliance_level: self.compliance_level,
                approve_after_days: self.approve_after_days,
                approve_until_date: self.approve_until_date,
                enable_non_security: self.enable_non_security,
            }
        }
    }
}
impl PatchRule {
    /// Creates a new builder-style object to manufacture [`PatchRule`](crate::model::PatchRule)
    pub fn builder() -> crate::model::patch_rule::Builder {
        crate::model::patch_rule::Builder::default()
    }
}

/// <p>A set of patch filters, typically used for approval rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchFilterGroup {
    /// <p>The set of patch filters that make up the group.</p>
    pub patch_filters: std::option::Option<std::vec::Vec<crate::model::PatchFilter>>,
}
impl std::fmt::Debug for PatchFilterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchFilterGroup");
        formatter.field("patch_filters", &self.patch_filters);
        formatter.finish()
    }
}
/// See [`PatchFilterGroup`](crate::model::PatchFilterGroup)
pub mod patch_filter_group {
    /// A builder for [`PatchFilterGroup`](crate::model::PatchFilterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_filters: std::option::Option<std::vec::Vec<crate::model::PatchFilter>>,
    }
    impl Builder {
        /// Appends an item to `patch_filters`.
        ///
        /// To override the contents of this collection use [`set_patch_filters`](Self::set_patch_filters).
        ///
        /// <p>The set of patch filters that make up the group.</p>
        pub fn patch_filters(mut self, input: impl Into<crate::model::PatchFilter>) -> Self {
            let mut v = self.patch_filters.unwrap_or_default();
            v.push(input.into());
            self.patch_filters = Some(v);
            self
        }
        /// <p>The set of patch filters that make up the group.</p>
        pub fn set_patch_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchFilter>>,
        ) -> Self {
            self.patch_filters = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchFilterGroup`](crate::model::PatchFilterGroup)
        pub fn build(self) -> crate::model::PatchFilterGroup {
            crate::model::PatchFilterGroup {
                patch_filters: self.patch_filters,
            }
        }
    }
}
impl PatchFilterGroup {
    /// Creates a new builder-style object to manufacture [`PatchFilterGroup`](crate::model::PatchFilterGroup)
    pub fn builder() -> crate::model::patch_filter_group::Builder {
        crate::model::patch_filter_group::Builder::default()
    }
}

/// <p> Defines which patches should be included in a patch baseline.</p>
/// <p>A patch filter consists of a key and a set of values. The filter key is a patch property.
/// For example, the available filter keys for <code>WINDOWS</code> are <code>PATCH_SET</code>,
/// <code>PRODUCT</code>, <code>PRODUCT_FAMILY</code>, <code>CLASSIFICATION</code>, and
/// <code>MSRC_SEVERITY</code>.</p>
/// <p>The filter values define a matching criterion for the patch property indicated by the key.
/// For example, if the filter key is <code>PRODUCT</code> and the filter values are <code>["Office
/// 2013", "Office 2016"]</code>, then the filter accepts all patches where product name is either
/// "Office 2013" or "Office 2016". The filter values can be exact values for the patch property
/// given as a key, or a wildcard (*), which matches all values.</p>
/// <p>You can view lists of valid values for the patch properties by running the
/// <code>DescribePatchProperties</code> command. For information about which patch properties can
/// be used with each major operating system, see <a>DescribePatchProperties</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchFilter {
    /// <p>The key for the filter.</p>
    /// <p>Run the <a>DescribePatchProperties</a> command to view lists of valid keys for
    /// each operating system type.</p>
    pub key: std::option::Option<crate::model::PatchFilterKey>,
    /// <p>The value for the filter key.</p>
    /// <p>Run the <a>DescribePatchProperties</a> command to view lists of valid values for
    /// each key based on operating system type.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PatchFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PatchFilter`](crate::model::PatchFilter)
pub mod patch_filter {
    /// A builder for [`PatchFilter`](crate::model::PatchFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::PatchFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The key for the filter.</p>
        /// <p>Run the <a>DescribePatchProperties</a> command to view lists of valid keys for
        /// each operating system type.</p>
        pub fn key(mut self, input: crate::model::PatchFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The key for the filter.</p>
        /// <p>Run the <a>DescribePatchProperties</a> command to view lists of valid keys for
        /// each operating system type.</p>
        pub fn set_key(mut self, input: std::option::Option<crate::model::PatchFilterKey>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value for the filter key.</p>
        /// <p>Run the <a>DescribePatchProperties</a> command to view lists of valid values for
        /// each key based on operating system type.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value for the filter key.</p>
        /// <p>Run the <a>DescribePatchProperties</a> command to view lists of valid values for
        /// each key based on operating system type.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchFilter`](crate::model::PatchFilter)
        pub fn build(self) -> crate::model::PatchFilter {
            crate::model::PatchFilter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl PatchFilter {
    /// Creates a new builder-style object to manufacture [`PatchFilter`](crate::model::PatchFilter)
    pub fn builder() -> crate::model::patch_filter::Builder {
        crate::model::patch_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PatchFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    AdvisoryId,
    #[allow(missing_docs)] // documentation missing in model
    Arch,
    #[allow(missing_docs)] // documentation missing in model
    BugzillaId,
    #[allow(missing_docs)] // documentation missing in model
    Classification,
    #[allow(missing_docs)] // documentation missing in model
    CveId,
    #[allow(missing_docs)] // documentation missing in model
    Epoch,
    #[allow(missing_docs)] // documentation missing in model
    MsrcSeverity,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    PatchId,
    #[allow(missing_docs)] // documentation missing in model
    PatchSet,
    #[allow(missing_docs)] // documentation missing in model
    Priority,
    #[allow(missing_docs)] // documentation missing in model
    Product,
    #[allow(missing_docs)] // documentation missing in model
    ProductFamily,
    #[allow(missing_docs)] // documentation missing in model
    Release,
    #[allow(missing_docs)] // documentation missing in model
    Repository,
    #[allow(missing_docs)] // documentation missing in model
    Section,
    #[allow(missing_docs)] // documentation missing in model
    Security,
    #[allow(missing_docs)] // documentation missing in model
    Severity,
    #[allow(missing_docs)] // documentation missing in model
    Version,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PatchFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "ADVISORY_ID" => PatchFilterKey::AdvisoryId,
            "ARCH" => PatchFilterKey::Arch,
            "BUGZILLA_ID" => PatchFilterKey::BugzillaId,
            "CLASSIFICATION" => PatchFilterKey::Classification,
            "CVE_ID" => PatchFilterKey::CveId,
            "EPOCH" => PatchFilterKey::Epoch,
            "MSRC_SEVERITY" => PatchFilterKey::MsrcSeverity,
            "NAME" => PatchFilterKey::Name,
            "PATCH_ID" => PatchFilterKey::PatchId,
            "PATCH_SET" => PatchFilterKey::PatchSet,
            "PRIORITY" => PatchFilterKey::Priority,
            "PRODUCT" => PatchFilterKey::Product,
            "PRODUCT_FAMILY" => PatchFilterKey::ProductFamily,
            "RELEASE" => PatchFilterKey::Release,
            "REPOSITORY" => PatchFilterKey::Repository,
            "SECTION" => PatchFilterKey::Section,
            "SECURITY" => PatchFilterKey::Security,
            "SEVERITY" => PatchFilterKey::Severity,
            "VERSION" => PatchFilterKey::Version,
            other => PatchFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PatchFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PatchFilterKey::from(s))
    }
}
impl PatchFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PatchFilterKey::AdvisoryId => "ADVISORY_ID",
            PatchFilterKey::Arch => "ARCH",
            PatchFilterKey::BugzillaId => "BUGZILLA_ID",
            PatchFilterKey::Classification => "CLASSIFICATION",
            PatchFilterKey::CveId => "CVE_ID",
            PatchFilterKey::Epoch => "EPOCH",
            PatchFilterKey::MsrcSeverity => "MSRC_SEVERITY",
            PatchFilterKey::Name => "NAME",
            PatchFilterKey::PatchId => "PATCH_ID",
            PatchFilterKey::PatchSet => "PATCH_SET",
            PatchFilterKey::Priority => "PRIORITY",
            PatchFilterKey::Product => "PRODUCT",
            PatchFilterKey::ProductFamily => "PRODUCT_FAMILY",
            PatchFilterKey::Release => "RELEASE",
            PatchFilterKey::Repository => "REPOSITORY",
            PatchFilterKey::Section => "SECTION",
            PatchFilterKey::Security => "SECURITY",
            PatchFilterKey::Severity => "SEVERITY",
            PatchFilterKey::Version => "VERSION",
            PatchFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADVISORY_ID",
            "ARCH",
            "BUGZILLA_ID",
            "CLASSIFICATION",
            "CVE_ID",
            "EPOCH",
            "MSRC_SEVERITY",
            "NAME",
            "PATCH_ID",
            "PATCH_SET",
            "PRIORITY",
            "PRODUCT",
            "PRODUCT_FAMILY",
            "RELEASE",
            "REPOSITORY",
            "SECTION",
            "SECURITY",
            "SEVERITY",
            "VERSION",
        ]
    }
}
impl AsRef<str> for PatchFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperatingSystem {
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux,
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux2,
    #[allow(missing_docs)] // documentation missing in model
    CentOs,
    #[allow(missing_docs)] // documentation missing in model
    Debian,
    #[allow(missing_docs)] // documentation missing in model
    MacOs,
    #[allow(missing_docs)] // documentation missing in model
    OracleLinux,
    #[allow(missing_docs)] // documentation missing in model
    RedhatEnterpriseLinux,
    #[allow(missing_docs)] // documentation missing in model
    Suse,
    #[allow(missing_docs)] // documentation missing in model
    Ubuntu,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperatingSystem {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_LINUX" => OperatingSystem::AmazonLinux,
            "AMAZON_LINUX_2" => OperatingSystem::AmazonLinux2,
            "CENTOS" => OperatingSystem::CentOs,
            "DEBIAN" => OperatingSystem::Debian,
            "MACOS" => OperatingSystem::MacOs,
            "ORACLE_LINUX" => OperatingSystem::OracleLinux,
            "REDHAT_ENTERPRISE_LINUX" => OperatingSystem::RedhatEnterpriseLinux,
            "SUSE" => OperatingSystem::Suse,
            "UBUNTU" => OperatingSystem::Ubuntu,
            "WINDOWS" => OperatingSystem::Windows,
            other => OperatingSystem::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperatingSystem {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperatingSystem::from(s))
    }
}
impl OperatingSystem {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperatingSystem::AmazonLinux => "AMAZON_LINUX",
            OperatingSystem::AmazonLinux2 => "AMAZON_LINUX_2",
            OperatingSystem::CentOs => "CENTOS",
            OperatingSystem::Debian => "DEBIAN",
            OperatingSystem::MacOs => "MACOS",
            OperatingSystem::OracleLinux => "ORACLE_LINUX",
            OperatingSystem::RedhatEnterpriseLinux => "REDHAT_ENTERPRISE_LINUX",
            OperatingSystem::Suse => "SUSE",
            OperatingSystem::Ubuntu => "UBUNTU",
            OperatingSystem::Windows => "WINDOWS",
            OperatingSystem::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMAZON_LINUX",
            "AMAZON_LINUX_2",
            "CENTOS",
            "DEBIAN",
            "MACOS",
            "ORACLE_LINUX",
            "REDHAT_ENTERPRISE_LINUX",
            "SUSE",
            "UBUNTU",
            "WINDOWS",
        ]
    }
}
impl AsRef<str> for OperatingSystem {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata to assign to an Application Manager application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetadataValue {
    /// <p>Metadata value to assign to an Application Manager application.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MetadataValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetadataValue");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MetadataValue`](crate::model::MetadataValue)
pub mod metadata_value {
    /// A builder for [`MetadataValue`](crate::model::MetadataValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Metadata value to assign to an Application Manager application.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Metadata value to assign to an Application Manager application.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetadataValue`](crate::model::MetadataValue)
        pub fn build(self) -> crate::model::MetadataValue {
            crate::model::MetadataValue { value: self.value }
        }
    }
}
impl MetadataValue {
    /// Creates a new builder-style object to manufacture [`MetadataValue`](crate::model::MetadataValue)
    pub fn builder() -> crate::model::metadata_value::Builder {
        crate::model::metadata_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    ChangeCalendarOverrideApproved,
    #[allow(missing_docs)] // documentation missing in model
    ChangeCalendarOverrideRejected,
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithFailure,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithSuccess,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingApproval,
    #[allow(missing_docs)] // documentation missing in model
    PendingChangeCalendarOverride,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Resolved,
    #[allow(missing_docs)] // documentation missing in model
    RunbookInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemStatus {
    fn from(s: &str) -> Self {
        match s {
            "Approved" => OpsItemStatus::Approved,
            "Cancelled" => OpsItemStatus::Cancelled,
            "Cancelling" => OpsItemStatus::Cancelling,
            "ChangeCalendarOverrideApproved" => OpsItemStatus::ChangeCalendarOverrideApproved,
            "ChangeCalendarOverrideRejected" => OpsItemStatus::ChangeCalendarOverrideRejected,
            "Closed" => OpsItemStatus::Closed,
            "CompletedWithFailure" => OpsItemStatus::CompletedWithFailure,
            "CompletedWithSuccess" => OpsItemStatus::CompletedWithSuccess,
            "Failed" => OpsItemStatus::Failed,
            "InProgress" => OpsItemStatus::InProgress,
            "Open" => OpsItemStatus::Open,
            "Pending" => OpsItemStatus::Pending,
            "PendingApproval" => OpsItemStatus::PendingApproval,
            "PendingChangeCalendarOverride" => OpsItemStatus::PendingChangeCalendarOverride,
            "Rejected" => OpsItemStatus::Rejected,
            "Resolved" => OpsItemStatus::Resolved,
            "RunbookInProgress" => OpsItemStatus::RunbookInProgress,
            "Scheduled" => OpsItemStatus::Scheduled,
            "TimedOut" => OpsItemStatus::TimedOut,
            other => OpsItemStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsItemStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsItemStatus::from(s))
    }
}
impl OpsItemStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsItemStatus::Approved => "Approved",
            OpsItemStatus::Cancelled => "Cancelled",
            OpsItemStatus::Cancelling => "Cancelling",
            OpsItemStatus::ChangeCalendarOverrideApproved => "ChangeCalendarOverrideApproved",
            OpsItemStatus::ChangeCalendarOverrideRejected => "ChangeCalendarOverrideRejected",
            OpsItemStatus::Closed => "Closed",
            OpsItemStatus::CompletedWithFailure => "CompletedWithFailure",
            OpsItemStatus::CompletedWithSuccess => "CompletedWithSuccess",
            OpsItemStatus::Failed => "Failed",
            OpsItemStatus::InProgress => "InProgress",
            OpsItemStatus::Open => "Open",
            OpsItemStatus::Pending => "Pending",
            OpsItemStatus::PendingApproval => "PendingApproval",
            OpsItemStatus::PendingChangeCalendarOverride => "PendingChangeCalendarOverride",
            OpsItemStatus::Rejected => "Rejected",
            OpsItemStatus::Resolved => "Resolved",
            OpsItemStatus::RunbookInProgress => "RunbookInProgress",
            OpsItemStatus::Scheduled => "Scheduled",
            OpsItemStatus::TimedOut => "TimedOut",
            OpsItemStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Approved",
            "Cancelled",
            "Cancelling",
            "ChangeCalendarOverrideApproved",
            "ChangeCalendarOverrideRejected",
            "Closed",
            "CompletedWithFailure",
            "CompletedWithSuccess",
            "Failed",
            "InProgress",
            "Open",
            "Pending",
            "PendingApproval",
            "PendingChangeCalendarOverride",
            "Rejected",
            "Resolved",
            "RunbookInProgress",
            "Scheduled",
            "TimedOut",
        ]
    }
}
impl AsRef<str> for OpsItemStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An OpsItems that shares something in common with the current OpsItem. For example, related
/// OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for
/// the impacted resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelatedOpsItem {
    /// <p>The ID of an OpsItem related to the current OpsItem.</p>
    pub ops_item_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RelatedOpsItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelatedOpsItem");
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.finish()
    }
}
/// See [`RelatedOpsItem`](crate::model::RelatedOpsItem)
pub mod related_ops_item {
    /// A builder for [`RelatedOpsItem`](crate::model::RelatedOpsItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of an OpsItem related to the current OpsItem.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of an OpsItem related to the current OpsItem.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RelatedOpsItem`](crate::model::RelatedOpsItem)
        pub fn build(self) -> crate::model::RelatedOpsItem {
            crate::model::RelatedOpsItem {
                ops_item_id: self.ops_item_id,
            }
        }
    }
}
impl RelatedOpsItem {
    /// Creates a new builder-style object to manufacture [`RelatedOpsItem`](crate::model::RelatedOpsItem)
    pub fn builder() -> crate::model::related_ops_item::Builder {
        crate::model::related_ops_item::Builder::default()
    }
}

/// <p>A notification about the OpsItem.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemNotification {
    /// <p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
    /// notifications are sent when this OpsItem is edited or changed.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsItemNotification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemNotification");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`OpsItemNotification`](crate::model::OpsItemNotification)
pub mod ops_item_notification {
    /// A builder for [`OpsItemNotification`](crate::model::OpsItemNotification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
        /// notifications are sent when this OpsItem is edited or changed.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
        /// notifications are sent when this OpsItem is edited or changed.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemNotification`](crate::model::OpsItemNotification)
        pub fn build(self) -> crate::model::OpsItemNotification {
            crate::model::OpsItemNotification { arn: self.arn }
        }
    }
}
impl OpsItemNotification {
    /// Creates a new builder-style object to manufacture [`OpsItemNotification`](crate::model::OpsItemNotification)
    pub fn builder() -> crate::model::ops_item_notification::Builder {
        crate::model::ops_item_notification::Builder::default()
    }
}

/// <p>An object that defines the value of the key and its type in the OperationalData map.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemDataValue {
    /// <p>The value of the OperationalData key.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The type of key-value pair. Valid types include <code>SearchableString</code> and
    /// <code>String</code>.</p>
    pub r#type: std::option::Option<crate::model::OpsItemDataType>,
}
impl std::fmt::Debug for OpsItemDataValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemDataValue");
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`OpsItemDataValue`](crate::model::OpsItemDataValue)
pub mod ops_item_data_value {
    /// A builder for [`OpsItemDataValue`](crate::model::OpsItemDataValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::OpsItemDataType>,
    }
    impl Builder {
        /// <p>The value of the OperationalData key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the OperationalData key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The type of key-value pair. Valid types include <code>SearchableString</code> and
        /// <code>String</code>.</p>
        pub fn r#type(mut self, input: crate::model::OpsItemDataType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of key-value pair. Valid types include <code>SearchableString</code> and
        /// <code>String</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OpsItemDataType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemDataValue`](crate::model::OpsItemDataValue)
        pub fn build(self) -> crate::model::OpsItemDataValue {
            crate::model::OpsItemDataValue {
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl OpsItemDataValue {
    /// Creates a new builder-style object to manufacture [`OpsItemDataValue`](crate::model::OpsItemDataValue)
    pub fn builder() -> crate::model::ops_item_data_value::Builder {
        crate::model::ops_item_data_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemDataType {
    #[allow(missing_docs)] // documentation missing in model
    SearchableString,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemDataType {
    fn from(s: &str) -> Self {
        match s {
            "SearchableString" => OpsItemDataType::SearchableString,
            "String" => OpsItemDataType::String,
            other => OpsItemDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsItemDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsItemDataType::from(s))
    }
}
impl OpsItemDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsItemDataType::SearchableString => "SearchableString",
            OpsItemDataType::String => "String",
            OpsItemDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SearchableString", "String"]
    }
}
impl AsRef<str> for OpsItemDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MaintenanceWindowTaskCutoffBehavior {
    #[allow(missing_docs)] // documentation missing in model
    CancelTask,
    #[allow(missing_docs)] // documentation missing in model
    ContinueTask,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MaintenanceWindowTaskCutoffBehavior {
    fn from(s: &str) -> Self {
        match s {
            "CANCEL_TASK" => MaintenanceWindowTaskCutoffBehavior::CancelTask,
            "CONTINUE_TASK" => MaintenanceWindowTaskCutoffBehavior::ContinueTask,
            other => MaintenanceWindowTaskCutoffBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MaintenanceWindowTaskCutoffBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MaintenanceWindowTaskCutoffBehavior::from(s))
    }
}
impl MaintenanceWindowTaskCutoffBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MaintenanceWindowTaskCutoffBehavior::CancelTask => "CANCEL_TASK",
            MaintenanceWindowTaskCutoffBehavior::ContinueTask => "CONTINUE_TASK",
            MaintenanceWindowTaskCutoffBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCEL_TASK", "CONTINUE_TASK"]
    }
}
impl AsRef<str> for MaintenanceWindowTaskCutoffBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an Amazon Simple Storage Service (Amazon S3) bucket to write
/// instance-level logs to.</p>
/// <note>
/// <p>
/// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
/// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
/// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
/// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingInfo {
    /// <p>The name of an S3 bucket where execution logs are stored .</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>(Optional) The S3 bucket subfolder. </p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where the S3 bucket is located.</p>
    pub s3_region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LoggingInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingInfo");
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field("s3_region", &self.s3_region);
        formatter.finish()
    }
}
/// See [`LoggingInfo`](crate::model::LoggingInfo)
pub mod logging_info {
    /// A builder for [`LoggingInfo`](crate::model::LoggingInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) s3_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an S3 bucket where execution logs are stored .</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of an S3 bucket where execution logs are stored .</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>(Optional) The S3 bucket subfolder. </p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>(Optional) The S3 bucket subfolder. </p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The Amazon Web Services Region where the S3 bucket is located.</p>
        pub fn s3_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where the S3 bucket is located.</p>
        pub fn set_s3_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_region = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingInfo`](crate::model::LoggingInfo)
        pub fn build(self) -> crate::model::LoggingInfo {
            crate::model::LoggingInfo {
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                s3_region: self.s3_region,
            }
        }
    }
}
impl LoggingInfo {
    /// Creates a new builder-style object to manufacture [`LoggingInfo`](crate::model::LoggingInfo)
    pub fn builder() -> crate::model::logging_info::Builder {
        crate::model::logging_info::Builder::default()
    }
}

/// <p>The parameters for task execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaintenanceWindowTaskInvocationParameters {
    /// <p>The parameters for a <code>RUN_COMMAND</code> task type.</p>
    pub run_command: std::option::Option<crate::model::MaintenanceWindowRunCommandParameters>,
    /// <p>The parameters for an <code>AUTOMATION</code> task type.</p>
    pub automation: std::option::Option<crate::model::MaintenanceWindowAutomationParameters>,
    /// <p>The parameters for a <code>STEP_FUNCTIONS</code> task type.</p>
    pub step_functions: std::option::Option<crate::model::MaintenanceWindowStepFunctionsParameters>,
    /// <p>The parameters for a <code>LAMBDA</code> task type.</p>
    pub lambda: std::option::Option<crate::model::MaintenanceWindowLambdaParameters>,
}
impl std::fmt::Debug for MaintenanceWindowTaskInvocationParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaintenanceWindowTaskInvocationParameters");
        formatter.field("run_command", &self.run_command);
        formatter.field("automation", &self.automation);
        formatter.field("step_functions", &self.step_functions);
        formatter.field("lambda", &self.lambda);
        formatter.finish()
    }
}
/// See [`MaintenanceWindowTaskInvocationParameters`](crate::model::MaintenanceWindowTaskInvocationParameters)
pub mod maintenance_window_task_invocation_parameters {
    /// A builder for [`MaintenanceWindowTaskInvocationParameters`](crate::model::MaintenanceWindowTaskInvocationParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_command:
            std::option::Option<crate::model::MaintenanceWindowRunCommandParameters>,
        pub(crate) automation:
            std::option::Option<crate::model::MaintenanceWindowAutomationParameters>,
        pub(crate) step_functions:
            std::option::Option<crate::model::MaintenanceWindowStepFunctionsParameters>,
        pub(crate) lambda: std::option::Option<crate::model::MaintenanceWindowLambdaParameters>,
    }
    impl Builder {
        /// <p>The parameters for a <code>RUN_COMMAND</code> task type.</p>
        pub fn run_command(
            mut self,
            input: crate::model::MaintenanceWindowRunCommandParameters,
        ) -> Self {
            self.run_command = Some(input);
            self
        }
        /// <p>The parameters for a <code>RUN_COMMAND</code> task type.</p>
        pub fn set_run_command(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowRunCommandParameters>,
        ) -> Self {
            self.run_command = input;
            self
        }
        /// <p>The parameters for an <code>AUTOMATION</code> task type.</p>
        pub fn automation(
            mut self,
            input: crate::model::MaintenanceWindowAutomationParameters,
        ) -> Self {
            self.automation = Some(input);
            self
        }
        /// <p>The parameters for an <code>AUTOMATION</code> task type.</p>
        pub fn set_automation(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowAutomationParameters>,
        ) -> Self {
            self.automation = input;
            self
        }
        /// <p>The parameters for a <code>STEP_FUNCTIONS</code> task type.</p>
        pub fn step_functions(
            mut self,
            input: crate::model::MaintenanceWindowStepFunctionsParameters,
        ) -> Self {
            self.step_functions = Some(input);
            self
        }
        /// <p>The parameters for a <code>STEP_FUNCTIONS</code> task type.</p>
        pub fn set_step_functions(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowStepFunctionsParameters>,
        ) -> Self {
            self.step_functions = input;
            self
        }
        /// <p>The parameters for a <code>LAMBDA</code> task type.</p>
        pub fn lambda(mut self, input: crate::model::MaintenanceWindowLambdaParameters) -> Self {
            self.lambda = Some(input);
            self
        }
        /// <p>The parameters for a <code>LAMBDA</code> task type.</p>
        pub fn set_lambda(
            mut self,
            input: std::option::Option<crate::model::MaintenanceWindowLambdaParameters>,
        ) -> Self {
            self.lambda = input;
            self
        }
        /// Consumes the builder and constructs a [`MaintenanceWindowTaskInvocationParameters`](crate::model::MaintenanceWindowTaskInvocationParameters)
        pub fn build(self) -> crate::model::MaintenanceWindowTaskInvocationParameters {
            crate::model::MaintenanceWindowTaskInvocationParameters {
                run_command: self.run_command,
                automation: self.automation,
                step_functions: self.step_functions,
                lambda: self.lambda,
            }
        }
    }
}
impl MaintenanceWindowTaskInvocationParameters {
    /// Creates a new builder-style object to manufacture [`MaintenanceWindowTaskInvocationParameters`](crate::model::MaintenanceWindowTaskInvocationParameters)
    pub fn builder() -> crate::model::maintenance_window_task_invocation_parameters::Builder {
        crate::model::maintenance_window_task_invocation_parameters::Builder::default()
    }
}

/// <p>The parameters for a <code>LAMBDA</code> task type.</p>
/// <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p>
/// <note>
/// <p>
/// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
/// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
/// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
/// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
///
/// <p>
/// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
/// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
/// about how Systems Manager handles these options for the supported maintenance window task
/// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
/// <p>For Lambda tasks, Systems Manager ignores any values specified for TaskParameters and
/// LoggingInfo.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaintenanceWindowLambdaParameters {
    /// <p>Pass client-specific information to the Lambda function that you are
    /// invoking. You can then process the client information in your Lambda function as you
    /// choose through the context variable.</p>
    pub client_context: std::option::Option<std::string::String>,
    /// <p>(Optional) Specify an Lambda function version or alias name. If you specify a
    /// function version, the operation uses the qualified function Amazon Resource Name (ARN) to invoke
    /// a specific Lambda function. If you specify an alias name, the operation uses the
    /// alias ARN to invoke the Lambda function version to which the alias points.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>JSON to provide to your Lambda function as input.</p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
}
impl std::fmt::Debug for MaintenanceWindowLambdaParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaintenanceWindowLambdaParameters");
        formatter.field("client_context", &self.client_context);
        formatter.field("qualifier", &self.qualifier);
        formatter.field("payload", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`MaintenanceWindowLambdaParameters`](crate::model::MaintenanceWindowLambdaParameters)
pub mod maintenance_window_lambda_parameters {
    /// A builder for [`MaintenanceWindowLambdaParameters`](crate::model::MaintenanceWindowLambdaParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_context: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>Pass client-specific information to the Lambda function that you are
        /// invoking. You can then process the client information in your Lambda function as you
        /// choose through the context variable.</p>
        pub fn client_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_context = Some(input.into());
            self
        }
        /// <p>Pass client-specific information to the Lambda function that you are
        /// invoking. You can then process the client information in your Lambda function as you
        /// choose through the context variable.</p>
        pub fn set_client_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_context = input;
            self
        }
        /// <p>(Optional) Specify an Lambda function version or alias name. If you specify a
        /// function version, the operation uses the qualified function Amazon Resource Name (ARN) to invoke
        /// a specific Lambda function. If you specify an alias name, the operation uses the
        /// alias ARN to invoke the Lambda function version to which the alias points.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>(Optional) Specify an Lambda function version or alias name. If you specify a
        /// function version, the operation uses the qualified function Amazon Resource Name (ARN) to invoke
        /// a specific Lambda function. If you specify an alias name, the operation uses the
        /// alias ARN to invoke the Lambda function version to which the alias points.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>JSON to provide to your Lambda function as input.</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>JSON to provide to your Lambda function as input.</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`MaintenanceWindowLambdaParameters`](crate::model::MaintenanceWindowLambdaParameters)
        pub fn build(self) -> crate::model::MaintenanceWindowLambdaParameters {
            crate::model::MaintenanceWindowLambdaParameters {
                client_context: self.client_context,
                qualifier: self.qualifier,
                payload: self.payload,
            }
        }
    }
}
impl MaintenanceWindowLambdaParameters {
    /// Creates a new builder-style object to manufacture [`MaintenanceWindowLambdaParameters`](crate::model::MaintenanceWindowLambdaParameters)
    pub fn builder() -> crate::model::maintenance_window_lambda_parameters::Builder {
        crate::model::maintenance_window_lambda_parameters::Builder::default()
    }
}

/// <p>The parameters for a <code>STEP_FUNCTIONS</code> task.</p>
/// <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p>
/// <note>
/// <p>
/// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
/// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
/// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
/// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
///
/// <p>
/// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
/// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
/// about how Systems Manager handles these options for the supported maintenance window task
/// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
/// <p>For Step Functions tasks, Systems Manager ignores any values specified for
/// <code>TaskParameters</code> and <code>LoggingInfo</code>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaintenanceWindowStepFunctionsParameters {
    /// <p>The inputs for the <code>STEP_FUNCTIONS</code> task.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The name of the <code>STEP_FUNCTIONS</code> task.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MaintenanceWindowStepFunctionsParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaintenanceWindowStepFunctionsParameters");
        formatter.field("input", &"*** Sensitive Data Redacted ***");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`MaintenanceWindowStepFunctionsParameters`](crate::model::MaintenanceWindowStepFunctionsParameters)
pub mod maintenance_window_step_functions_parameters {
    /// A builder for [`MaintenanceWindowStepFunctionsParameters`](crate::model::MaintenanceWindowStepFunctionsParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The inputs for the <code>STEP_FUNCTIONS</code> task.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>The inputs for the <code>STEP_FUNCTIONS</code> task.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The name of the <code>STEP_FUNCTIONS</code> task.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>STEP_FUNCTIONS</code> task.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`MaintenanceWindowStepFunctionsParameters`](crate::model::MaintenanceWindowStepFunctionsParameters)
        pub fn build(self) -> crate::model::MaintenanceWindowStepFunctionsParameters {
            crate::model::MaintenanceWindowStepFunctionsParameters {
                input: self.input,
                name: self.name,
            }
        }
    }
}
impl MaintenanceWindowStepFunctionsParameters {
    /// Creates a new builder-style object to manufacture [`MaintenanceWindowStepFunctionsParameters`](crate::model::MaintenanceWindowStepFunctionsParameters)
    pub fn builder() -> crate::model::maintenance_window_step_functions_parameters::Builder {
        crate::model::maintenance_window_step_functions_parameters::Builder::default()
    }
}

/// <p>The parameters for an <code>AUTOMATION</code> task type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaintenanceWindowAutomationParameters {
    /// <p>The version of an Automation runbook to use during task execution.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The parameters for the <code>AUTOMATION</code> task.</p>
    /// <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p>
    /// <note>
    /// <p>
    /// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
    /// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
    /// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
    /// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
    ///
    /// <p>
    /// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
    /// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
    /// about how Systems Manager handles these options for the supported maintenance window task
    /// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
    /// <p>For <code>AUTOMATION</code> task types, Amazon Web Services Systems Manager ignores any values specified for these
    /// parameters.</p>
    /// </note>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl std::fmt::Debug for MaintenanceWindowAutomationParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaintenanceWindowAutomationParameters");
        formatter.field("document_version", &self.document_version);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`MaintenanceWindowAutomationParameters`](crate::model::MaintenanceWindowAutomationParameters)
pub mod maintenance_window_automation_parameters {
    /// A builder for [`MaintenanceWindowAutomationParameters`](crate::model::MaintenanceWindowAutomationParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The version of an Automation runbook to use during task execution.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of an Automation runbook to use during task execution.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the <code>AUTOMATION</code> task.</p>
        /// <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p>
        /// <note>
        /// <p>
        /// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
        /// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
        /// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
        /// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        ///
        /// <p>
        /// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
        /// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
        /// about how Systems Manager handles these options for the supported maintenance window task
        /// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// <p>For <code>AUTOMATION</code> task types, Amazon Web Services Systems Manager ignores any values specified for these
        /// parameters.</p>
        /// </note>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameters for the <code>AUTOMATION</code> task.</p>
        /// <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p>
        /// <note>
        /// <p>
        /// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
        /// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
        /// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
        /// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        ///
        /// <p>
        /// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
        /// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
        /// about how Systems Manager handles these options for the supported maintenance window task
        /// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
        /// <p>For <code>AUTOMATION</code> task types, Amazon Web Services Systems Manager ignores any values specified for these
        /// parameters.</p>
        /// </note>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`MaintenanceWindowAutomationParameters`](crate::model::MaintenanceWindowAutomationParameters)
        pub fn build(self) -> crate::model::MaintenanceWindowAutomationParameters {
            crate::model::MaintenanceWindowAutomationParameters {
                document_version: self.document_version,
                parameters: self.parameters,
            }
        }
    }
}
impl MaintenanceWindowAutomationParameters {
    /// Creates a new builder-style object to manufacture [`MaintenanceWindowAutomationParameters`](crate::model::MaintenanceWindowAutomationParameters)
    pub fn builder() -> crate::model::maintenance_window_automation_parameters::Builder {
        crate::model::maintenance_window_automation_parameters::Builder::default()
    }
}

/// <p>The parameters for a <code>RUN_COMMAND</code> task type.</p>
/// <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p>
/// <note>
/// <p>
/// <code>LoggingInfo</code> has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
/// <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure.
/// For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
/// window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
///
/// <p>
/// <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
/// instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
/// about how Systems Manager handles these options for the supported maintenance window task
/// types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p>
/// <p>For <code>RUN_COMMAND</code> tasks, Systems Manager uses specified values for
/// <code>TaskParameters</code> and <code>LoggingInfo</code> only if no values are specified for
/// <code>TaskInvocationParameters</code>. </p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaintenanceWindowRunCommandParameters {
    /// <p>Information about the commands to run.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>Configuration options for sending command output to Amazon CloudWatch Logs.</p>
    pub cloud_watch_output_config: std::option::Option<crate::model::CloudWatchOutputConfig>,
    /// <p>The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes
    /// have been deprecated.</p>
    pub document_hash: std::option::Option<std::string::String>,
    /// <p>SHA-256 or SHA-1. SHA-1 hashes have been deprecated.</p>
    pub document_hash_type: std::option::Option<crate::model::DocumentHashType>,
    /// <p>The Amazon Web Services Systems Manager document (SSM document) version to use in the request. You can specify
    /// <code>$DEFAULT</code>, <code>$LATEST</code>, or a specific version number. If you run commands
    /// by using the Amazon Web Services CLI, then you must escape the first two options by using a backslash. If you
    /// specify a version number, then you don't need to use the backslash. For example:</p>
    /// <p>
    /// <code>--document-version "\$DEFAULT"</code>
    /// </p>
    /// <p>
    /// <code>--document-version "\$LATEST"</code>
    /// </p>
    /// <p>
    /// <code>--document-version "3"</code>
    /// </p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>Configurations for sending notifications about command status changes on a per-instance
    /// basis.</p>
    pub notification_config: std::option::Option<crate::model::NotificationConfig>,
    /// <p>The name of the Amazon Simple Storage Service (Amazon S3) bucket.</p>
    pub output_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket subfolder.</p>
    pub output_s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The parameters for the <code>RUN_COMMAND</code> task execution.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service
    /// (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>If this time is reached and the command hasn't already started running, it doesn't
    /// run.</p>
    pub timeout_seconds: std::option::Option<i32>,
}
impl std::fmt::Debug for MaintenanceWindowRunCommandParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaintenanceWindowRunCommandParameters");
        formatter.field("comment", &self.comment);
        formatter.field("cloud_watch_output_config", &self.cloud_watch_output_config);
        formatter.field("document_hash", &self.document_hash);
        formatter.field("document_hash_type", &self.document_hash_type);
        formatter.field("document_version", &self.document_version);
        formatter.field("notification_config", &self.notification_config);
        formatter.field("output_s3_bucket_name", &self.output_s3_bucket_name);
        formatter.field("output_s3_key_prefix", &self.output_s3_key_prefix);
        formatter.field("parameters", &self.parameters);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("timeout_seconds", &self.timeout_seconds);
        formatter.finish()
    }
}
/// See [`MaintenanceWindowRunCommandParameters`](crate::model::MaintenanceWindowRunCommandParameters)
pub mod maintenance_window_run_command_parameters {
    /// A builder for [`MaintenanceWindowRunCommandParameters`](crate::model::MaintenanceWindowRunCommandParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_output_config:
            std::option::Option<crate::model::CloudWatchOutputConfig>,
        pub(crate) document_hash: std::option::Option<std::string::String>,
        pub(crate) document_hash_type: std::option::Option<crate::model::DocumentHashType>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) notification_config: std::option::Option<crate::model::NotificationConfig>,
        pub(crate) output_s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) output_s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) timeout_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Information about the commands to run.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>Information about the commands to run.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>Configuration options for sending command output to Amazon CloudWatch Logs.</p>
        pub fn cloud_watch_output_config(
            mut self,
            input: crate::model::CloudWatchOutputConfig,
        ) -> Self {
            self.cloud_watch_output_config = Some(input);
            self
        }
        /// <p>Configuration options for sending command output to Amazon CloudWatch Logs.</p>
        pub fn set_cloud_watch_output_config(
            mut self,
            input: std::option::Option<crate::model::CloudWatchOutputConfig>,
        ) -> Self {
            self.cloud_watch_output_config = input;
            self
        }
        /// <p>The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes
        /// have been deprecated.</p>
        pub fn document_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_hash = Some(input.into());
            self
        }
        /// <p>The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes
        /// have been deprecated.</p>
        pub fn set_document_hash(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_hash = input;
            self
        }
        /// <p>SHA-256 or SHA-1. SHA-1 hashes have been deprecated.</p>
        pub fn document_hash_type(mut self, input: crate::model::DocumentHashType) -> Self {
            self.document_hash_type = Some(input);
            self
        }
        /// <p>SHA-256 or SHA-1. SHA-1 hashes have been deprecated.</p>
        pub fn set_document_hash_type(
            mut self,
            input: std::option::Option<crate::model::DocumentHashType>,
        ) -> Self {
            self.document_hash_type = input;
            self
        }
        /// <p>The Amazon Web Services Systems Manager document (SSM document) version to use in the request. You can specify
        /// <code>$DEFAULT</code>, <code>$LATEST</code>, or a specific version number. If you run commands
        /// by using the Amazon Web Services CLI, then you must escape the first two options by using a backslash. If you
        /// specify a version number, then you don't need to use the backslash. For example:</p>
        /// <p>
        /// <code>--document-version "\$DEFAULT"</code>
        /// </p>
        /// <p>
        /// <code>--document-version "\$LATEST"</code>
        /// </p>
        /// <p>
        /// <code>--document-version "3"</code>
        /// </p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Systems Manager document (SSM document) version to use in the request. You can specify
        /// <code>$DEFAULT</code>, <code>$LATEST</code>, or a specific version number. If you run commands
        /// by using the Amazon Web Services CLI, then you must escape the first two options by using a backslash. If you
        /// specify a version number, then you don't need to use the backslash. For example:</p>
        /// <p>
        /// <code>--document-version "\$DEFAULT"</code>
        /// </p>
        /// <p>
        /// <code>--document-version "\$LATEST"</code>
        /// </p>
        /// <p>
        /// <code>--document-version "3"</code>
        /// </p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>Configurations for sending notifications about command status changes on a per-instance
        /// basis.</p>
        pub fn notification_config(mut self, input: crate::model::NotificationConfig) -> Self {
            self.notification_config = Some(input);
            self
        }
        /// <p>Configurations for sending notifications about command status changes on a per-instance
        /// basis.</p>
        pub fn set_notification_config(
            mut self,
            input: std::option::Option<crate::model::NotificationConfig>,
        ) -> Self {
            self.notification_config = input;
            self
        }
        /// <p>The name of the Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn output_s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Simple Storage Service (Amazon S3) bucket.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_bucket_name = input;
            self
        }
        /// <p>The S3 bucket subfolder.</p>
        pub fn output_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The S3 bucket subfolder.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_key_prefix = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the <code>RUN_COMMAND</code> task execution.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameters for the <code>RUN_COMMAND</code> task execution.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service
        /// (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service
        /// (Amazon SNS) notifications for maintenance window Run Command tasks.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>If this time is reached and the command hasn't already started running, it doesn't
        /// run.</p>
        pub fn timeout_seconds(mut self, input: i32) -> Self {
            self.timeout_seconds = Some(input);
            self
        }
        /// <p>If this time is reached and the command hasn't already started running, it doesn't
        /// run.</p>
        pub fn set_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`MaintenanceWindowRunCommandParameters`](crate::model::MaintenanceWindowRunCommandParameters)
        pub fn build(self) -> crate::model::MaintenanceWindowRunCommandParameters {
            crate::model::MaintenanceWindowRunCommandParameters {
                comment: self.comment,
                cloud_watch_output_config: self.cloud_watch_output_config,
                document_hash: self.document_hash,
                document_hash_type: self.document_hash_type,
                document_version: self.document_version,
                notification_config: self.notification_config,
                output_s3_bucket_name: self.output_s3_bucket_name,
                output_s3_key_prefix: self.output_s3_key_prefix,
                parameters: self.parameters,
                service_role_arn: self.service_role_arn,
                timeout_seconds: self.timeout_seconds,
            }
        }
    }
}
impl MaintenanceWindowRunCommandParameters {
    /// Creates a new builder-style object to manufacture [`MaintenanceWindowRunCommandParameters`](crate::model::MaintenanceWindowRunCommandParameters)
    pub fn builder() -> crate::model::maintenance_window_run_command_parameters::Builder {
        crate::model::maintenance_window_run_command_parameters::Builder::default()
    }
}

/// <p>Configurations for sending notifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfig {
    /// <p>An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run
    /// Command pushes notifications about command status changes to this topic.</p>
    pub notification_arn: std::option::Option<std::string::String>,
    /// <p>The different events for which you can receive notifications. To learn more about these
    /// events, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Monitoring Systems Manager status
    /// changes using Amazon SNS notifications</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub notification_events: std::option::Option<std::vec::Vec<crate::model::NotificationEvent>>,
    /// <p>The type of notification.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Command</code>: Receive notification when the status of a command changes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Invocation</code>: For commands sent to multiple instances, receive notification on
    /// a per-instance basis when the status of a command changes. </p>
    /// </li>
    /// </ul>
    pub notification_type: std::option::Option<crate::model::NotificationType>,
}
impl std::fmt::Debug for NotificationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfig");
        formatter.field("notification_arn", &self.notification_arn);
        formatter.field("notification_events", &self.notification_events);
        formatter.field("notification_type", &self.notification_type);
        formatter.finish()
    }
}
/// See [`NotificationConfig`](crate::model::NotificationConfig)
pub mod notification_config {
    /// A builder for [`NotificationConfig`](crate::model::NotificationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_arn: std::option::Option<std::string::String>,
        pub(crate) notification_events:
            std::option::Option<std::vec::Vec<crate::model::NotificationEvent>>,
        pub(crate) notification_type: std::option::Option<crate::model::NotificationType>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run
        /// Command pushes notifications about command status changes to this topic.</p>
        pub fn notification_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run
        /// Command pushes notifications about command status changes to this topic.</p>
        pub fn set_notification_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_arn = input;
            self
        }
        /// Appends an item to `notification_events`.
        ///
        /// To override the contents of this collection use [`set_notification_events`](Self::set_notification_events).
        ///
        /// <p>The different events for which you can receive notifications. To learn more about these
        /// events, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Monitoring Systems Manager status
        /// changes using Amazon SNS notifications</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn notification_events(
            mut self,
            input: impl Into<crate::model::NotificationEvent>,
        ) -> Self {
            let mut v = self.notification_events.unwrap_or_default();
            v.push(input.into());
            self.notification_events = Some(v);
            self
        }
        /// <p>The different events for which you can receive notifications. To learn more about these
        /// events, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Monitoring Systems Manager status
        /// changes using Amazon SNS notifications</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_notification_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationEvent>>,
        ) -> Self {
            self.notification_events = input;
            self
        }
        /// <p>The type of notification.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Command</code>: Receive notification when the status of a command changes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Invocation</code>: For commands sent to multiple instances, receive notification on
        /// a per-instance basis when the status of a command changes. </p>
        /// </li>
        /// </ul>
        pub fn notification_type(mut self, input: crate::model::NotificationType) -> Self {
            self.notification_type = Some(input);
            self
        }
        /// <p>The type of notification.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Command</code>: Receive notification when the status of a command changes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Invocation</code>: For commands sent to multiple instances, receive notification on
        /// a per-instance basis when the status of a command changes. </p>
        /// </li>
        /// </ul>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfig`](crate::model::NotificationConfig)
        pub fn build(self) -> crate::model::NotificationConfig {
            crate::model::NotificationConfig {
                notification_arn: self.notification_arn,
                notification_events: self.notification_events,
                notification_type: self.notification_type,
            }
        }
    }
}
impl NotificationConfig {
    /// Creates a new builder-style object to manufacture [`NotificationConfig`](crate::model::NotificationConfig)
    pub fn builder() -> crate::model::notification_config::Builder {
        crate::model::notification_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationType {
    #[allow(missing_docs)] // documentation missing in model
    Command,
    #[allow(missing_docs)] // documentation missing in model
    Invocation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationType {
    fn from(s: &str) -> Self {
        match s {
            "Command" => NotificationType::Command,
            "Invocation" => NotificationType::Invocation,
            other => NotificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationType::from(s))
    }
}
impl NotificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationType::Command => "Command",
            NotificationType::Invocation => "Invocation",
            NotificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Command", "Invocation"]
    }
}
impl AsRef<str> for NotificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationEvent {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationEvent {
    fn from(s: &str) -> Self {
        match s {
            "All" => NotificationEvent::All,
            "Cancelled" => NotificationEvent::Cancelled,
            "Failed" => NotificationEvent::Failed,
            "InProgress" => NotificationEvent::InProgress,
            "Success" => NotificationEvent::Success,
            "TimedOut" => NotificationEvent::TimedOut,
            other => NotificationEvent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationEvent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationEvent::from(s))
    }
}
impl NotificationEvent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationEvent::All => "All",
            NotificationEvent::Cancelled => "Cancelled",
            NotificationEvent::Failed => "Failed",
            NotificationEvent::InProgress => "InProgress",
            NotificationEvent::Success => "Success",
            NotificationEvent::TimedOut => "TimedOut",
            NotificationEvent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "All",
            "Cancelled",
            "Failed",
            "InProgress",
            "Success",
            "TimedOut",
        ]
    }
}
impl AsRef<str> for NotificationEvent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentHashType {
    #[allow(missing_docs)] // documentation missing in model
    Sha1,
    #[allow(missing_docs)] // documentation missing in model
    Sha256,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentHashType {
    fn from(s: &str) -> Self {
        match s {
            "Sha1" => DocumentHashType::Sha1,
            "Sha256" => DocumentHashType::Sha256,
            other => DocumentHashType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentHashType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentHashType::from(s))
    }
}
impl DocumentHashType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentHashType::Sha1 => "Sha1",
            DocumentHashType::Sha256 => "Sha256",
            DocumentHashType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Sha1", "Sha256"]
    }
}
impl AsRef<str> for DocumentHashType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration options for sending command output to Amazon CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchOutputConfig {
    /// <p>The name of the CloudWatch Logs log group where you want to send command output. If you
    /// don't specify a group name, Amazon Web Services Systems Manager automatically creates a log group for you. The log group
    /// uses the following naming format:</p>
    /// <p>
    /// <code>aws/ssm/<i>SystemsManagerDocumentName</i>
    /// </code>
    /// </p>
    pub cloud_watch_log_group_name: std::option::Option<std::string::String>,
    /// <p>Enables Systems Manager to send command output to CloudWatch Logs.</p>
    pub cloud_watch_output_enabled: bool,
}
impl std::fmt::Debug for CloudWatchOutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchOutputConfig");
        formatter.field(
            "cloud_watch_log_group_name",
            &self.cloud_watch_log_group_name,
        );
        formatter.field(
            "cloud_watch_output_enabled",
            &self.cloud_watch_output_enabled,
        );
        formatter.finish()
    }
}
/// See [`CloudWatchOutputConfig`](crate::model::CloudWatchOutputConfig)
pub mod cloud_watch_output_config {
    /// A builder for [`CloudWatchOutputConfig`](crate::model::CloudWatchOutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_log_group_name: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_output_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch Logs log group where you want to send command output. If you
        /// don't specify a group name, Amazon Web Services Systems Manager automatically creates a log group for you. The log group
        /// uses the following naming format:</p>
        /// <p>
        /// <code>aws/ssm/<i>SystemsManagerDocumentName</i>
        /// </code>
        /// </p>
        pub fn cloud_watch_log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch Logs log group where you want to send command output. If you
        /// don't specify a group name, Amazon Web Services Systems Manager automatically creates a log group for you. The log group
        /// uses the following naming format:</p>
        /// <p>
        /// <code>aws/ssm/<i>SystemsManagerDocumentName</i>
        /// </code>
        /// </p>
        pub fn set_cloud_watch_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_log_group_name = input;
            self
        }
        /// <p>Enables Systems Manager to send command output to CloudWatch Logs.</p>
        pub fn cloud_watch_output_enabled(mut self, input: bool) -> Self {
            self.cloud_watch_output_enabled = Some(input);
            self
        }
        /// <p>Enables Systems Manager to send command output to CloudWatch Logs.</p>
        pub fn set_cloud_watch_output_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cloud_watch_output_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchOutputConfig`](crate::model::CloudWatchOutputConfig)
        pub fn build(self) -> crate::model::CloudWatchOutputConfig {
            crate::model::CloudWatchOutputConfig {
                cloud_watch_log_group_name: self.cloud_watch_log_group_name,
                cloud_watch_output_enabled: self.cloud_watch_output_enabled.unwrap_or_default(),
            }
        }
    }
}
impl CloudWatchOutputConfig {
    /// Creates a new builder-style object to manufacture [`CloudWatchOutputConfig`](crate::model::CloudWatchOutputConfig)
    pub fn builder() -> crate::model::cloud_watch_output_config::Builder {
        crate::model::cloud_watch_output_config::Builder::default()
    }
}

/// <p>Defines the values for a task parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaintenanceWindowTaskParameterValueExpression {
    /// <p>This field contains an array of 0 or more strings, each 1 to 255 characters in
    /// length.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for MaintenanceWindowTaskParameterValueExpression {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaintenanceWindowTaskParameterValueExpression");
        formatter.field("values", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`MaintenanceWindowTaskParameterValueExpression`](crate::model::MaintenanceWindowTaskParameterValueExpression)
pub mod maintenance_window_task_parameter_value_expression {
    /// A builder for [`MaintenanceWindowTaskParameterValueExpression`](crate::model::MaintenanceWindowTaskParameterValueExpression)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>This field contains an array of 0 or more strings, each 1 to 255 characters in
        /// length.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>This field contains an array of 0 or more strings, each 1 to 255 characters in
        /// length.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`MaintenanceWindowTaskParameterValueExpression`](crate::model::MaintenanceWindowTaskParameterValueExpression)
        pub fn build(self) -> crate::model::MaintenanceWindowTaskParameterValueExpression {
            crate::model::MaintenanceWindowTaskParameterValueExpression {
                values: self.values,
            }
        }
    }
}
impl MaintenanceWindowTaskParameterValueExpression {
    /// Creates a new builder-style object to manufacture [`MaintenanceWindowTaskParameterValueExpression`](crate::model::MaintenanceWindowTaskParameterValueExpression)
    pub fn builder() -> crate::model::maintenance_window_task_parameter_value_expression::Builder {
        crate::model::maintenance_window_task_parameter_value_expression::Builder::default()
    }
}

/// <p>An array of search criteria that targets instances using a key-value pair that you
/// specify.</p>
/// <note>
/// <p> One or more targets must be specified for maintenance window Run Command-type tasks.
/// Depending on the task, targets are optional for other maintenance window task types (Automation,
/// Lambda, and Step Functions). For more information about running tasks
/// that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
/// maintenance window tasks without targets</a> in the
/// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
/// </note>
/// <p>Supported formats include the following.</p>
/// <ul>
/// <li>
/// <p>
/// <code>Key=InstanceIds,Values=<i>instance-id-1</i>,<i>instance-id-2</i>,<i>instance-id-3</i>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Key=tag:<i>my-tag-key</i>,Values=<i>my-tag-value-1</i>,<i>my-tag-value-2</i>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Key=tag-key,Values=<i>my-tag-key-1</i>,<i>my-tag-key-2</i>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <b>Run Command and Maintenance window targets only</b>:
/// <code>Key=resource-groups:Name,Values=<i>resource-group-name</i>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <b>Maintenance window targets only</b>:
/// <code>Key=resource-groups:ResourceTypeFilters,Values=<i>resource-type-1</i>,<i>resource-type-2</i>
/// </code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <b>Automation targets only</b>:
/// <code>Key=ResourceGroup;Values=<i>resource-group-name</i>
/// </code>
/// </p>
/// </li>
/// </ul>
/// <p>For example:</p>
/// <ul>
/// <li>
/// <p>
/// <code>Key=InstanceIds,Values=i-02573cafcfEXAMPLE,i-0471e04240EXAMPLE,i-07782c72faEXAMPLE</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Key=tag:CostCenter,Values=CostCenter1,CostCenter2,CostCenter3</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Key=tag-key,Values=Name,Instance-Type,CostCenter</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <b>Run Command and Maintenance window targets only</b>:
/// <code>Key=resource-groups:Name,Values=ProductionResourceGroup</code>
/// </p>
/// <p>This example demonstrates how to target all resources in the resource group <b>ProductionResourceGroup</b> in your maintenance window.</p>
/// </li>
/// <li>
/// <p>
/// <b>Maintenance window targets only</b>:
/// <code>Key=resource-groups:ResourceTypeFilters,Values=<i>AWS::EC2::INSTANCE</i>,<i>AWS::EC2::VPC</i>
/// </code>
/// </p>
/// <p>This example demonstrates how to target only Amazon Elastic Compute Cloud (Amazon EC2)
/// instances and VPCs in your maintenance window.</p>
/// </li>
/// <li>
/// <p>
/// <b>Automation targets only</b>:
/// <code>Key=ResourceGroup,Values=MyResourceGroup</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <b>State Manager association targets only</b>:
/// <code>Key=InstanceIds,Values=<i>*</i>
/// </code>
/// </p>
/// <p>This example demonstrates how to target all managed instances in the Amazon Web Services Region where
/// the association was created.</p>
/// </li>
/// </ul>
/// <p>For more information about how to send commands that target instances using
/// <code>Key,Value</code> parameters, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-targeting">Targeting multiple instances</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Target {
    /// <p>User-defined criteria for sending commands that target instances that meet the
    /// criteria.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>User-defined criteria that maps to <code>Key</code>. For example, if you specified
    /// <code>tag:ServerRole</code>, you could specify <code>value:WebServer</code> to run a command on
    /// instances that include EC2 tags of <code>ServerRole,WebServer</code>. </p>
    /// <p>Depending on the type of target, the maximum number of values for a key might be lower than
    /// the global maximum of 50.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Target {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Target");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Target`](crate::model::Target)
pub mod target {
    /// A builder for [`Target`](crate::model::Target)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>User-defined criteria for sending commands that target instances that meet the
        /// criteria.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>User-defined criteria for sending commands that target instances that meet the
        /// criteria.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>User-defined criteria that maps to <code>Key</code>. For example, if you specified
        /// <code>tag:ServerRole</code>, you could specify <code>value:WebServer</code> to run a command on
        /// instances that include EC2 tags of <code>ServerRole,WebServer</code>. </p>
        /// <p>Depending on the type of target, the maximum number of values for a key might be lower than
        /// the global maximum of 50.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>User-defined criteria that maps to <code>Key</code>. For example, if you specified
        /// <code>tag:ServerRole</code>, you could specify <code>value:WebServer</code> to run a command on
        /// instances that include EC2 tags of <code>ServerRole,WebServer</code>. </p>
        /// <p>Depending on the type of target, the maximum number of values for a key might be lower than
        /// the global maximum of 50.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Target`](crate::model::Target)
        pub fn build(self) -> crate::model::Target {
            crate::model::Target {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl Target {
    /// Creates a new builder-style object to manufacture [`Target`](crate::model::Target)
    pub fn builder() -> crate::model::target::Builder {
        crate::model::target::Builder::default()
    }
}

/// <p>Information about a document approval review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentReviews {
    /// <p>The action to take on a document approval review request.</p>
    pub action: std::option::Option<crate::model::DocumentReviewAction>,
    /// <p>A comment entered by a user in your organization about the document review request.</p>
    pub comment: std::option::Option<std::vec::Vec<crate::model::DocumentReviewCommentSource>>,
}
impl std::fmt::Debug for DocumentReviews {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentReviews");
        formatter.field("action", &self.action);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`DocumentReviews`](crate::model::DocumentReviews)
pub mod document_reviews {
    /// A builder for [`DocumentReviews`](crate::model::DocumentReviews)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::DocumentReviewAction>,
        pub(crate) comment:
            std::option::Option<std::vec::Vec<crate::model::DocumentReviewCommentSource>>,
    }
    impl Builder {
        /// <p>The action to take on a document approval review request.</p>
        pub fn action(mut self, input: crate::model::DocumentReviewAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to take on a document approval review request.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::DocumentReviewAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Appends an item to `comment`.
        ///
        /// To override the contents of this collection use [`set_comment`](Self::set_comment).
        ///
        /// <p>A comment entered by a user in your organization about the document review request.</p>
        pub fn comment(
            mut self,
            input: impl Into<crate::model::DocumentReviewCommentSource>,
        ) -> Self {
            let mut v = self.comment.unwrap_or_default();
            v.push(input.into());
            self.comment = Some(v);
            self
        }
        /// <p>A comment entered by a user in your organization about the document review request.</p>
        pub fn set_comment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentReviewCommentSource>>,
        ) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentReviews`](crate::model::DocumentReviews)
        pub fn build(self) -> crate::model::DocumentReviews {
            crate::model::DocumentReviews {
                action: self.action,
                comment: self.comment,
            }
        }
    }
}
impl DocumentReviews {
    /// Creates a new builder-style object to manufacture [`DocumentReviews`](crate::model::DocumentReviews)
    pub fn builder() -> crate::model::document_reviews::Builder {
        crate::model::document_reviews::Builder::default()
    }
}

/// <p>Information about comments added to a document review request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentReviewCommentSource {
    /// <p>The type of information added to a review request. Currently, only the value
    /// <code>Comment</code> is supported.</p>
    pub r#type: std::option::Option<crate::model::DocumentReviewCommentType>,
    /// <p>The content of a comment entered by a user who requests a review of a new document version,
    /// or who reviews the new version.</p>
    pub content: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentReviewCommentSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentReviewCommentSource");
        formatter.field("r#type", &self.r#type);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`DocumentReviewCommentSource`](crate::model::DocumentReviewCommentSource)
pub mod document_review_comment_source {
    /// A builder for [`DocumentReviewCommentSource`](crate::model::DocumentReviewCommentSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DocumentReviewCommentType>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of information added to a review request. Currently, only the value
        /// <code>Comment</code> is supported.</p>
        pub fn r#type(mut self, input: crate::model::DocumentReviewCommentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of information added to a review request. Currently, only the value
        /// <code>Comment</code> is supported.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DocumentReviewCommentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The content of a comment entered by a user who requests a review of a new document version,
        /// or who reviews the new version.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of a comment entered by a user who requests a review of a new document version,
        /// or who reviews the new version.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentReviewCommentSource`](crate::model::DocumentReviewCommentSource)
        pub fn build(self) -> crate::model::DocumentReviewCommentSource {
            crate::model::DocumentReviewCommentSource {
                r#type: self.r#type,
                content: self.content,
            }
        }
    }
}
impl DocumentReviewCommentSource {
    /// Creates a new builder-style object to manufacture [`DocumentReviewCommentSource`](crate::model::DocumentReviewCommentSource)
    pub fn builder() -> crate::model::document_review_comment_source::Builder {
        crate::model::document_review_comment_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentReviewCommentType {
    #[allow(missing_docs)] // documentation missing in model
    Comment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentReviewCommentType {
    fn from(s: &str) -> Self {
        match s {
            "Comment" => DocumentReviewCommentType::Comment,
            other => DocumentReviewCommentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentReviewCommentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentReviewCommentType::from(s))
    }
}
impl DocumentReviewCommentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentReviewCommentType::Comment => "Comment",
            DocumentReviewCommentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Comment"]
    }
}
impl AsRef<str> for DocumentReviewCommentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentReviewAction {
    #[allow(missing_docs)] // documentation missing in model
    Approve,
    #[allow(missing_docs)] // documentation missing in model
    Reject,
    #[allow(missing_docs)] // documentation missing in model
    SendForReview,
    #[allow(missing_docs)] // documentation missing in model
    UpdateReview,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentReviewAction {
    fn from(s: &str) -> Self {
        match s {
            "Approve" => DocumentReviewAction::Approve,
            "Reject" => DocumentReviewAction::Reject,
            "SendForReview" => DocumentReviewAction::SendForReview,
            "UpdateReview" => DocumentReviewAction::UpdateReview,
            other => DocumentReviewAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentReviewAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentReviewAction::from(s))
    }
}
impl DocumentReviewAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentReviewAction::Approve => "Approve",
            DocumentReviewAction::Reject => "Reject",
            DocumentReviewAction::SendForReview => "SendForReview",
            DocumentReviewAction::UpdateReview => "UpdateReview",
            DocumentReviewAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Approve", "Reject", "SendForReview", "UpdateReview"]
    }
}
impl AsRef<str> for DocumentReviewAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A default version of a document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentDefaultVersionDescription {
    /// <p>The name of the document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The default version of the document.</p>
    pub default_version: std::option::Option<std::string::String>,
    /// <p>The default version of the artifact associated with the document.</p>
    pub default_version_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentDefaultVersionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentDefaultVersionDescription");
        formatter.field("name", &self.name);
        formatter.field("default_version", &self.default_version);
        formatter.field("default_version_name", &self.default_version_name);
        formatter.finish()
    }
}
/// See [`DocumentDefaultVersionDescription`](crate::model::DocumentDefaultVersionDescription)
pub mod document_default_version_description {
    /// A builder for [`DocumentDefaultVersionDescription`](crate::model::DocumentDefaultVersionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_version: std::option::Option<std::string::String>,
        pub(crate) default_version_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The default version of the document.</p>
        pub fn default_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_version = Some(input.into());
            self
        }
        /// <p>The default version of the document.</p>
        pub fn set_default_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_version = input;
            self
        }
        /// <p>The default version of the artifact associated with the document.</p>
        pub fn default_version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_version_name = Some(input.into());
            self
        }
        /// <p>The default version of the artifact associated with the document.</p>
        pub fn set_default_version_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_version_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentDefaultVersionDescription`](crate::model::DocumentDefaultVersionDescription)
        pub fn build(self) -> crate::model::DocumentDefaultVersionDescription {
            crate::model::DocumentDefaultVersionDescription {
                name: self.name,
                default_version: self.default_version,
                default_version_name: self.default_version_name,
            }
        }
    }
}
impl DocumentDefaultVersionDescription {
    /// Creates a new builder-style object to manufacture [`DocumentDefaultVersionDescription`](crate::model::DocumentDefaultVersionDescription)
    pub fn builder() -> crate::model::document_default_version_description::Builder {
        crate::model::document_default_version_description::Builder::default()
    }
}

/// <p>Describes a Amazon Web Services Systems Manager document (SSM document). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentDescription {
    /// <p>The SHA1 hash of the document, which you can use for verification.</p>
    pub sha1: std::option::Option<std::string::String>,
    /// <p>The Sha256 or Sha1 hash created by the system when the document was created. </p>
    /// <note>
    /// <p>Sha1 hashes have been deprecated.</p>
    /// </note>
    pub hash: std::option::Option<std::string::String>,
    /// <p>The hash type of the document. Valid values include <code>Sha256</code> or
    /// <code>Sha1</code>.</p>
    /// <note>
    /// <p>Sha1 hashes have been deprecated.</p>
    /// </note>
    pub hash_type: std::option::Option<crate::model::DocumentHashType>,
    /// <p>The name of the SSM document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The friendly name of the SSM document. This value can differ for each version of the
    /// document. If you want to update this value, see <a>UpdateDocument</a>.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The version of the artifact associated with the document.</p>
    pub version_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services user account that created the document.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The date when the document was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the SSM document.</p>
    pub status: std::option::Option<crate::model::DocumentStatus>,
    /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a
    /// <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
    /// "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
    pub status_information: std::option::Option<std::string::String>,
    /// <p>The document version.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>A description of the document. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A description of the parameters for a document.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::DocumentParameter>>,
    /// <p>The list of OS platforms compatible with this SSM document. </p>
    pub platform_types: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
    /// <p>The type of document.</p>
    pub document_type: std::option::Option<crate::model::DocumentType>,
    /// <p>The schema version.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The latest version of the document.</p>
    pub latest_version: std::option::Option<std::string::String>,
    /// <p>The default version.</p>
    pub default_version: std::option::Option<std::string::String>,
    /// <p>The document format, either JSON or YAML.</p>
    pub document_format: std::option::Option<crate::model::DocumentFormat>,
    /// <p>The target type which defines the kinds of resources the document can run on. For example,
    /// <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
    /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
    pub target_type: std::option::Option<std::string::String>,
    /// <p>The tags, or metadata, that have been applied to the document.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Details about the document attachments, including names, locations, sizes, and so on.</p>
    pub attachments_information:
        std::option::Option<std::vec::Vec<crate::model::AttachmentInformation>>,
    /// <p>A list of SSM documents required by a document. For example, an
    /// <code>ApplicationConfiguration</code> document requires an
    /// <code>ApplicationConfigurationSchema</code> document.</p>
    pub requires: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
    /// <p>The user in your organization who created the document.</p>
    pub author: std::option::Option<std::string::String>,
    /// <p>Details about the review of a document.</p>
    pub review_information: std::option::Option<std::vec::Vec<crate::model::ReviewInformation>>,
    /// <p>The version of the document currently approved for use in the organization.</p>
    pub approved_version: std::option::Option<std::string::String>,
    /// <p>The version of the document that is currently under review.</p>
    pub pending_review_version: std::option::Option<std::string::String>,
    /// <p>The current status of the review.</p>
    pub review_status: std::option::Option<crate::model::ReviewStatus>,
}
impl std::fmt::Debug for DocumentDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentDescription");
        formatter.field("sha1", &self.sha1);
        formatter.field("hash", &self.hash);
        formatter.field("hash_type", &self.hash_type);
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("version_name", &self.version_name);
        formatter.field("owner", &self.owner);
        formatter.field("created_date", &self.created_date);
        formatter.field("status", &self.status);
        formatter.field("status_information", &self.status_information);
        formatter.field("document_version", &self.document_version);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("platform_types", &self.platform_types);
        formatter.field("document_type", &self.document_type);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("latest_version", &self.latest_version);
        formatter.field("default_version", &self.default_version);
        formatter.field("document_format", &self.document_format);
        formatter.field("target_type", &self.target_type);
        formatter.field("tags", &self.tags);
        formatter.field("attachments_information", &self.attachments_information);
        formatter.field("requires", &self.requires);
        formatter.field("author", &self.author);
        formatter.field("review_information", &self.review_information);
        formatter.field("approved_version", &self.approved_version);
        formatter.field("pending_review_version", &self.pending_review_version);
        formatter.field("review_status", &self.review_status);
        formatter.finish()
    }
}
/// See [`DocumentDescription`](crate::model::DocumentDescription)
pub mod document_description {
    /// A builder for [`DocumentDescription`](crate::model::DocumentDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sha1: std::option::Option<std::string::String>,
        pub(crate) hash: std::option::Option<std::string::String>,
        pub(crate) hash_type: std::option::Option<crate::model::DocumentHashType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::DocumentStatus>,
        pub(crate) status_information: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::DocumentParameter>>,
        pub(crate) platform_types: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
        pub(crate) document_type: std::option::Option<crate::model::DocumentType>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) latest_version: std::option::Option<std::string::String>,
        pub(crate) default_version: std::option::Option<std::string::String>,
        pub(crate) document_format: std::option::Option<crate::model::DocumentFormat>,
        pub(crate) target_type: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) attachments_information:
            std::option::Option<std::vec::Vec<crate::model::AttachmentInformation>>,
        pub(crate) requires: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) review_information:
            std::option::Option<std::vec::Vec<crate::model::ReviewInformation>>,
        pub(crate) approved_version: std::option::Option<std::string::String>,
        pub(crate) pending_review_version: std::option::Option<std::string::String>,
        pub(crate) review_status: std::option::Option<crate::model::ReviewStatus>,
    }
    impl Builder {
        /// <p>The SHA1 hash of the document, which you can use for verification.</p>
        pub fn sha1(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha1 = Some(input.into());
            self
        }
        /// <p>The SHA1 hash of the document, which you can use for verification.</p>
        pub fn set_sha1(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sha1 = input;
            self
        }
        /// <p>The Sha256 or Sha1 hash created by the system when the document was created. </p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash = Some(input.into());
            self
        }
        /// <p>The Sha256 or Sha1 hash created by the system when the document was created. </p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn set_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hash = input;
            self
        }
        /// <p>The hash type of the document. Valid values include <code>Sha256</code> or
        /// <code>Sha1</code>.</p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn hash_type(mut self, input: crate::model::DocumentHashType) -> Self {
            self.hash_type = Some(input);
            self
        }
        /// <p>The hash type of the document. Valid values include <code>Sha256</code> or
        /// <code>Sha1</code>.</p>
        /// <note>
        /// <p>Sha1 hashes have been deprecated.</p>
        /// </note>
        pub fn set_hash_type(
            mut self,
            input: std::option::Option<crate::model::DocumentHashType>,
        ) -> Self {
            self.hash_type = input;
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The friendly name of the SSM document. This value can differ for each version of the
        /// document. If you want to update this value, see <a>UpdateDocument</a>.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the SSM document. This value can differ for each version of the
        /// document. If you want to update this value, see <a>UpdateDocument</a>.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The version of the artifact associated with the document.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version of the artifact associated with the document.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>The Amazon Web Services user account that created the document.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services user account that created the document.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The date when the document was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date when the document was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The status of the SSM document.</p>
        pub fn status(mut self, input: crate::model::DocumentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SSM document.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DocumentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a
        /// <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
        /// "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
        pub fn status_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_information = Some(input.into());
            self
        }
        /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a
        /// <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
        /// "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
        pub fn set_status_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_information = input;
            self
        }
        /// <p>The document version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>A description of the document. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the document. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A description of the parameters for a document.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::DocumentParameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A description of the parameters for a document.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentParameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `platform_types`.
        ///
        /// To override the contents of this collection use [`set_platform_types`](Self::set_platform_types).
        ///
        /// <p>The list of OS platforms compatible with this SSM document. </p>
        pub fn platform_types(mut self, input: impl Into<crate::model::PlatformType>) -> Self {
            let mut v = self.platform_types.unwrap_or_default();
            v.push(input.into());
            self.platform_types = Some(v);
            self
        }
        /// <p>The list of OS platforms compatible with this SSM document. </p>
        pub fn set_platform_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
        ) -> Self {
            self.platform_types = input;
            self
        }
        /// <p>The type of document.</p>
        pub fn document_type(mut self, input: crate::model::DocumentType) -> Self {
            self.document_type = Some(input);
            self
        }
        /// <p>The type of document.</p>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<crate::model::DocumentType>,
        ) -> Self {
            self.document_type = input;
            self
        }
        /// <p>The schema version.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The latest version of the document.</p>
        pub fn latest_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version = Some(input.into());
            self
        }
        /// <p>The latest version of the document.</p>
        pub fn set_latest_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version = input;
            self
        }
        /// <p>The default version.</p>
        pub fn default_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_version = Some(input.into());
            self
        }
        /// <p>The default version.</p>
        pub fn set_default_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_version = input;
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.document_format = Some(input);
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.document_format = input;
            self
        }
        /// <p>The target type which defines the kinds of resources the document can run on. For example,
        /// <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn target_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_type = Some(input.into());
            self
        }
        /// <p>The target type which defines the kinds of resources the document can run on. For example,
        /// <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags, or metadata, that have been applied to the document.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags, or metadata, that have been applied to the document.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `attachments_information`.
        ///
        /// To override the contents of this collection use [`set_attachments_information`](Self::set_attachments_information).
        ///
        /// <p>Details about the document attachments, including names, locations, sizes, and so on.</p>
        pub fn attachments_information(
            mut self,
            input: impl Into<crate::model::AttachmentInformation>,
        ) -> Self {
            let mut v = self.attachments_information.unwrap_or_default();
            v.push(input.into());
            self.attachments_information = Some(v);
            self
        }
        /// <p>Details about the document attachments, including names, locations, sizes, and so on.</p>
        pub fn set_attachments_information(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentInformation>>,
        ) -> Self {
            self.attachments_information = input;
            self
        }
        /// Appends an item to `requires`.
        ///
        /// To override the contents of this collection use [`set_requires`](Self::set_requires).
        ///
        /// <p>A list of SSM documents required by a document. For example, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document.</p>
        pub fn requires(mut self, input: impl Into<crate::model::DocumentRequires>) -> Self {
            let mut v = self.requires.unwrap_or_default();
            v.push(input.into());
            self.requires = Some(v);
            self
        }
        /// <p>A list of SSM documents required by a document. For example, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document.</p>
        pub fn set_requires(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        ) -> Self {
            self.requires = input;
            self
        }
        /// <p>The user in your organization who created the document.</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The user in your organization who created the document.</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// Appends an item to `review_information`.
        ///
        /// To override the contents of this collection use [`set_review_information`](Self::set_review_information).
        ///
        /// <p>Details about the review of a document.</p>
        pub fn review_information(
            mut self,
            input: impl Into<crate::model::ReviewInformation>,
        ) -> Self {
            let mut v = self.review_information.unwrap_or_default();
            v.push(input.into());
            self.review_information = Some(v);
            self
        }
        /// <p>Details about the review of a document.</p>
        pub fn set_review_information(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReviewInformation>>,
        ) -> Self {
            self.review_information = input;
            self
        }
        /// <p>The version of the document currently approved for use in the organization.</p>
        pub fn approved_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.approved_version = Some(input.into());
            self
        }
        /// <p>The version of the document currently approved for use in the organization.</p>
        pub fn set_approved_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approved_version = input;
            self
        }
        /// <p>The version of the document that is currently under review.</p>
        pub fn pending_review_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.pending_review_version = Some(input.into());
            self
        }
        /// <p>The version of the document that is currently under review.</p>
        pub fn set_pending_review_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pending_review_version = input;
            self
        }
        /// <p>The current status of the review.</p>
        pub fn review_status(mut self, input: crate::model::ReviewStatus) -> Self {
            self.review_status = Some(input);
            self
        }
        /// <p>The current status of the review.</p>
        pub fn set_review_status(
            mut self,
            input: std::option::Option<crate::model::ReviewStatus>,
        ) -> Self {
            self.review_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentDescription`](crate::model::DocumentDescription)
        pub fn build(self) -> crate::model::DocumentDescription {
            crate::model::DocumentDescription {
                sha1: self.sha1,
                hash: self.hash,
                hash_type: self.hash_type,
                name: self.name,
                display_name: self.display_name,
                version_name: self.version_name,
                owner: self.owner,
                created_date: self.created_date,
                status: self.status,
                status_information: self.status_information,
                document_version: self.document_version,
                description: self.description,
                parameters: self.parameters,
                platform_types: self.platform_types,
                document_type: self.document_type,
                schema_version: self.schema_version,
                latest_version: self.latest_version,
                default_version: self.default_version,
                document_format: self.document_format,
                target_type: self.target_type,
                tags: self.tags,
                attachments_information: self.attachments_information,
                requires: self.requires,
                author: self.author,
                review_information: self.review_information,
                approved_version: self.approved_version,
                pending_review_version: self.pending_review_version,
                review_status: self.review_status,
            }
        }
    }
}
impl DocumentDescription {
    /// Creates a new builder-style object to manufacture [`DocumentDescription`](crate::model::DocumentDescription)
    pub fn builder() -> crate::model::document_description::Builder {
        crate::model::document_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReviewStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    NotReviewed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReviewStatus {
    fn from(s: &str) -> Self {
        match s {
            "APPROVED" => ReviewStatus::Approved,
            "NOT_REVIEWED" => ReviewStatus::NotReviewed,
            "PENDING" => ReviewStatus::Pending,
            "REJECTED" => ReviewStatus::Rejected,
            other => ReviewStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReviewStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReviewStatus::from(s))
    }
}
impl ReviewStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReviewStatus::Approved => "APPROVED",
            ReviewStatus::NotReviewed => "NOT_REVIEWED",
            ReviewStatus::Pending => "PENDING",
            ReviewStatus::Rejected => "REJECTED",
            ReviewStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPROVED", "NOT_REVIEWED", "PENDING", "REJECTED"]
    }
}
impl AsRef<str> for ReviewStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the result of a document review request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReviewInformation {
    /// <p>The time that the reviewer took action on the document review request.</p>
    pub reviewed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of the document review request.</p>
    pub status: std::option::Option<crate::model::ReviewStatus>,
    /// <p>The reviewer assigned to take action on the document review request.</p>
    pub reviewer: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReviewInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReviewInformation");
        formatter.field("reviewed_time", &self.reviewed_time);
        formatter.field("status", &self.status);
        formatter.field("reviewer", &self.reviewer);
        formatter.finish()
    }
}
/// See [`ReviewInformation`](crate::model::ReviewInformation)
pub mod review_information {
    /// A builder for [`ReviewInformation`](crate::model::ReviewInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reviewed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::ReviewStatus>,
        pub(crate) reviewer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time that the reviewer took action on the document review request.</p>
        pub fn reviewed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.reviewed_time = Some(input);
            self
        }
        /// <p>The time that the reviewer took action on the document review request.</p>
        pub fn set_reviewed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.reviewed_time = input;
            self
        }
        /// <p>The current status of the document review request.</p>
        pub fn status(mut self, input: crate::model::ReviewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the document review request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReviewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reviewer assigned to take action on the document review request.</p>
        pub fn reviewer(mut self, input: impl Into<std::string::String>) -> Self {
            self.reviewer = Some(input.into());
            self
        }
        /// <p>The reviewer assigned to take action on the document review request.</p>
        pub fn set_reviewer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reviewer = input;
            self
        }
        /// Consumes the builder and constructs a [`ReviewInformation`](crate::model::ReviewInformation)
        pub fn build(self) -> crate::model::ReviewInformation {
            crate::model::ReviewInformation {
                reviewed_time: self.reviewed_time,
                status: self.status,
                reviewer: self.reviewer,
            }
        }
    }
}
impl ReviewInformation {
    /// Creates a new builder-style object to manufacture [`ReviewInformation`](crate::model::ReviewInformation)
    pub fn builder() -> crate::model::review_information::Builder {
        crate::model::review_information::Builder::default()
    }
}

/// <p>An SSM document required by the current document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentRequires {
    /// <p>The name of the required SSM document. The name can be an Amazon Resource Name (ARN).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The document version required by the current document.</p>
    pub version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentRequires {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentRequires");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`DocumentRequires`](crate::model::DocumentRequires)
pub mod document_requires {
    /// A builder for [`DocumentRequires`](crate::model::DocumentRequires)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the required SSM document. The name can be an Amazon Resource Name (ARN).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the required SSM document. The name can be an Amazon Resource Name (ARN).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The document version required by the current document.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The document version required by the current document.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentRequires`](crate::model::DocumentRequires)
        pub fn build(self) -> crate::model::DocumentRequires {
            crate::model::DocumentRequires {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl DocumentRequires {
    /// Creates a new builder-style object to manufacture [`DocumentRequires`](crate::model::DocumentRequires)
    pub fn builder() -> crate::model::document_requires::Builder {
        crate::model::document_requires::Builder::default()
    }
}

/// <p>An attribute of an attachment, such as the attachment name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentInformation {
    /// <p>The name of the attachment.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentInformation");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AttachmentInformation`](crate::model::AttachmentInformation)
pub mod attachment_information {
    /// A builder for [`AttachmentInformation`](crate::model::AttachmentInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attachment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attachment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentInformation`](crate::model::AttachmentInformation)
        pub fn build(self) -> crate::model::AttachmentInformation {
            crate::model::AttachmentInformation { name: self.name }
        }
    }
}
impl AttachmentInformation {
    /// Creates a new builder-style object to manufacture [`AttachmentInformation`](crate::model::AttachmentInformation)
    pub fn builder() -> crate::model::attachment_information::Builder {
        crate::model::attachment_information::Builder::default()
    }
}

/// <p>Metadata that you assign to your Amazon Web Services resources. Tags enable you to categorize your
/// resources in different ways, for example, by purpose, owner, or environment. In Amazon Web Services Systems Manager, you
/// can apply tags to Systems Manager documents (SSM documents), managed instances, maintenance windows,
/// parameters, patch baselines, OpsItems, and OpsMetadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The name of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Text,
    #[allow(missing_docs)] // documentation missing in model
    Yaml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentFormat {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => DocumentFormat::Json,
            "TEXT" => DocumentFormat::Text,
            "YAML" => DocumentFormat::Yaml,
            other => DocumentFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentFormat::from(s))
    }
}
impl DocumentFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentFormat::Json => "JSON",
            DocumentFormat::Text => "TEXT",
            DocumentFormat::Yaml => "YAML",
            DocumentFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "TEXT", "YAML"]
    }
}
impl AsRef<str> for DocumentFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentType {
    #[allow(missing_docs)] // documentation missing in model
    ApplicationConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    ApplicationConfigurationSchema,
    #[allow(missing_docs)] // documentation missing in model
    Automation,
    #[allow(missing_docs)] // documentation missing in model
    ChangeTemplate,
    #[allow(missing_docs)] // documentation missing in model
    ChangeCalendar,
    #[allow(missing_docs)] // documentation missing in model
    Command,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentStrategy,
    #[allow(missing_docs)] // documentation missing in model
    Package,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    #[allow(missing_docs)] // documentation missing in model
    ProblemAnalysis,
    #[allow(missing_docs)] // documentation missing in model
    ProblemAnalysisTemplate,
    #[allow(missing_docs)] // documentation missing in model
    Session,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentType {
    fn from(s: &str) -> Self {
        match s {
            "ApplicationConfiguration" => DocumentType::ApplicationConfiguration,
            "ApplicationConfigurationSchema" => DocumentType::ApplicationConfigurationSchema,
            "Automation" => DocumentType::Automation,
            "Automation.ChangeTemplate" => DocumentType::ChangeTemplate,
            "ChangeCalendar" => DocumentType::ChangeCalendar,
            "Command" => DocumentType::Command,
            "DeploymentStrategy" => DocumentType::DeploymentStrategy,
            "Package" => DocumentType::Package,
            "Policy" => DocumentType::Policy,
            "ProblemAnalysis" => DocumentType::ProblemAnalysis,
            "ProblemAnalysisTemplate" => DocumentType::ProblemAnalysisTemplate,
            "Session" => DocumentType::Session,
            other => DocumentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentType::from(s))
    }
}
impl DocumentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentType::ApplicationConfiguration => "ApplicationConfiguration",
            DocumentType::ApplicationConfigurationSchema => "ApplicationConfigurationSchema",
            DocumentType::Automation => "Automation",
            DocumentType::ChangeTemplate => "Automation.ChangeTemplate",
            DocumentType::ChangeCalendar => "ChangeCalendar",
            DocumentType::Command => "Command",
            DocumentType::DeploymentStrategy => "DeploymentStrategy",
            DocumentType::Package => "Package",
            DocumentType::Policy => "Policy",
            DocumentType::ProblemAnalysis => "ProblemAnalysis",
            DocumentType::ProblemAnalysisTemplate => "ProblemAnalysisTemplate",
            DocumentType::Session => "Session",
            DocumentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ApplicationConfiguration",
            "ApplicationConfigurationSchema",
            "Automation",
            "Automation.ChangeTemplate",
            "ChangeCalendar",
            "Command",
            "DeploymentStrategy",
            "Package",
            "Policy",
            "ProblemAnalysis",
            "ProblemAnalysisTemplate",
            "Session",
        ]
    }
}
impl AsRef<str> for DocumentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlatformType {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlatformType {
    fn from(s: &str) -> Self {
        match s {
            "Linux" => PlatformType::Linux,
            "Windows" => PlatformType::Windows,
            other => PlatformType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlatformType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlatformType::from(s))
    }
}
impl PlatformType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlatformType::Linux => "Linux",
            PlatformType::Windows => "Windows",
            PlatformType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Linux", "Windows"]
    }
}
impl AsRef<str> for PlatformType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Parameters specified in a System Manager document that run on the server when the command is
/// run. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentParameter {
    /// <p>The name of the parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of parameter. The type can be either String or StringList.</p>
    pub r#type: std::option::Option<crate::model::DocumentParameterType>,
    /// <p>A description of what the parameter does, how to use it, the default value, and whether or
    /// not the parameter is optional.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If specified, the default values for the parameters. Parameters without a default value are
    /// required. Parameters with a default value are optional.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentParameter");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`DocumentParameter`](crate::model::DocumentParameter)
pub mod document_parameter {
    /// A builder for [`DocumentParameter`](crate::model::DocumentParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DocumentParameterType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of parameter. The type can be either String or StringList.</p>
        pub fn r#type(mut self, input: crate::model::DocumentParameterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of parameter. The type can be either String or StringList.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DocumentParameterType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A description of what the parameter does, how to use it, the default value, and whether or
        /// not the parameter is optional.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of what the parameter does, how to use it, the default value, and whether or
        /// not the parameter is optional.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If specified, the default values for the parameters. Parameters without a default value are
        /// required. Parameters with a default value are optional.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>If specified, the default values for the parameters. Parameters without a default value are
        /// required. Parameters with a default value are optional.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentParameter`](crate::model::DocumentParameter)
        pub fn build(self) -> crate::model::DocumentParameter {
            crate::model::DocumentParameter {
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                default_value: self.default_value,
            }
        }
    }
}
impl DocumentParameter {
    /// Creates a new builder-style object to manufacture [`DocumentParameter`](crate::model::DocumentParameter)
    pub fn builder() -> crate::model::document_parameter::Builder {
        crate::model::document_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentParameterType {
    #[allow(missing_docs)] // documentation missing in model
    String,
    #[allow(missing_docs)] // documentation missing in model
    StringList,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentParameterType {
    fn from(s: &str) -> Self {
        match s {
            "String" => DocumentParameterType::String,
            "StringList" => DocumentParameterType::StringList,
            other => DocumentParameterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentParameterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentParameterType::from(s))
    }
}
impl DocumentParameterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentParameterType::String => "String",
            DocumentParameterType::StringList => "StringList",
            DocumentParameterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["String", "StringList"]
    }
}
impl AsRef<str> for DocumentParameterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of a document.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => DocumentStatus::Active,
            "Creating" => DocumentStatus::Creating,
            "Deleting" => DocumentStatus::Deleting,
            "Failed" => DocumentStatus::Failed,
            "Updating" => DocumentStatus::Updating,
            other => DocumentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentStatus::from(s))
    }
}
impl DocumentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentStatus::Active => "Active",
            DocumentStatus::Creating => "Creating",
            DocumentStatus::Deleting => "Deleting",
            DocumentStatus::Failed => "Failed",
            DocumentStatus::Updating => "Updating",
            DocumentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Creating", "Deleting", "Failed", "Updating"]
    }
}
impl AsRef<str> for DocumentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifying information about a document attachment, including the file name and a key-value
/// pair that identifies the location of an attachment to a document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentsSource {
    /// <p>The key of a key-value pair that identifies the location of an attachment to a
    /// document.</p>
    pub key: std::option::Option<crate::model::AttachmentsSourceKey>,
    /// <p>The value of a key-value pair that identifies the location of an attachment to a document.
    /// The format for <b>Value</b> depends on the type of key you
    /// specify.</p>
    /// <ul>
    /// <li>
    /// <p>For the key <i>SourceUrl</i>, the value is an S3 bucket location. For
    /// example:</p>
    /// <p>
    /// <code>"Values": [ "s3://doc-example-bucket/my-folder" ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For
    /// example:</p>
    /// <p>
    /// <code>"Values": [ "s3://doc-example-bucket/my-folder/my-file.py" ]</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For the key <i>AttachmentReference</i>, the value is constructed from the
    /// name of another SSM document in your account, a version number of that document, and a file
    /// attached to that document version that you want to reuse. For example:</p>
    /// <p>
    /// <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
    /// </p>
    /// <p>However, if the SSM document is shared with you from another account, the full SSM
    /// document ARN must be specified instead of the document name only. For example:</p>
    /// <p>
    /// <code>"Values": [
    /// "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py"
    /// ]</code>
    /// </p>
    /// </li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the document attachment file.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentsSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentsSource");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AttachmentsSource`](crate::model::AttachmentsSource)
pub mod attachments_source {
    /// A builder for [`AttachmentsSource`](crate::model::AttachmentsSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::AttachmentsSourceKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of a key-value pair that identifies the location of an attachment to a
        /// document.</p>
        pub fn key(mut self, input: crate::model::AttachmentsSourceKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The key of a key-value pair that identifies the location of an attachment to a
        /// document.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::AttachmentsSourceKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value of a key-value pair that identifies the location of an attachment to a document.
        /// The format for <b>Value</b> depends on the type of key you
        /// specify.</p>
        /// <ul>
        /// <li>
        /// <p>For the key <i>SourceUrl</i>, the value is an S3 bucket location. For
        /// example:</p>
        /// <p>
        /// <code>"Values": [ "s3://doc-example-bucket/my-folder" ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For
        /// example:</p>
        /// <p>
        /// <code>"Values": [ "s3://doc-example-bucket/my-folder/my-file.py" ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the key <i>AttachmentReference</i>, the value is constructed from the
        /// name of another SSM document in your account, a version number of that document, and a file
        /// attached to that document version that you want to reuse. For example:</p>
        /// <p>
        /// <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
        /// </p>
        /// <p>However, if the SSM document is shared with you from another account, the full SSM
        /// document ARN must be specified instead of the document name only. For example:</p>
        /// <p>
        /// <code>"Values": [
        /// "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py"
        /// ]</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value of a key-value pair that identifies the location of an attachment to a document.
        /// The format for <b>Value</b> depends on the type of key you
        /// specify.</p>
        /// <ul>
        /// <li>
        /// <p>For the key <i>SourceUrl</i>, the value is an S3 bucket location. For
        /// example:</p>
        /// <p>
        /// <code>"Values": [ "s3://doc-example-bucket/my-folder" ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For
        /// example:</p>
        /// <p>
        /// <code>"Values": [ "s3://doc-example-bucket/my-folder/my-file.py" ]</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the key <i>AttachmentReference</i>, the value is constructed from the
        /// name of another SSM document in your account, a version number of that document, and a file
        /// attached to that document version that you want to reuse. For example:</p>
        /// <p>
        /// <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
        /// </p>
        /// <p>However, if the SSM document is shared with you from another account, the full SSM
        /// document ARN must be specified instead of the document name only. For example:</p>
        /// <p>
        /// <code>"Values": [
        /// "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py"
        /// ]</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The name of the document attachment file.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the document attachment file.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentsSource`](crate::model::AttachmentsSource)
        pub fn build(self) -> crate::model::AttachmentsSource {
            crate::model::AttachmentsSource {
                key: self.key,
                values: self.values,
                name: self.name,
            }
        }
    }
}
impl AttachmentsSource {
    /// Creates a new builder-style object to manufacture [`AttachmentsSource`](crate::model::AttachmentsSource)
    pub fn builder() -> crate::model::attachments_source::Builder {
        crate::model::attachments_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttachmentsSourceKey {
    #[allow(missing_docs)] // documentation missing in model
    AttachmentReference,
    #[allow(missing_docs)] // documentation missing in model
    S3FileUrl,
    #[allow(missing_docs)] // documentation missing in model
    SourceUrl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttachmentsSourceKey {
    fn from(s: &str) -> Self {
        match s {
            "AttachmentReference" => AttachmentsSourceKey::AttachmentReference,
            "S3FileUrl" => AttachmentsSourceKey::S3FileUrl,
            "SourceUrl" => AttachmentsSourceKey::SourceUrl,
            other => AttachmentsSourceKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttachmentsSourceKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttachmentsSourceKey::from(s))
    }
}
impl AttachmentsSourceKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttachmentsSourceKey::AttachmentReference => "AttachmentReference",
            AttachmentsSourceKey::S3FileUrl => "S3FileUrl",
            AttachmentsSourceKey::SourceUrl => "SourceUrl",
            AttachmentsSourceKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AttachmentReference", "S3FileUrl", "SourceUrl"]
    }
}
impl AsRef<str> for AttachmentsSourceKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the parameters for a document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociationDescription {
    /// <p>The name of the SSM document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The association version.</p>
    pub association_version: std::option::Option<std::string::String>,
    /// <p>The date when the association was made.</p>
    pub date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the association was last updated.</p>
    pub last_update_association_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The association status.</p>
    pub status: std::option::Option<crate::model::AssociationStatus>,
    /// <p>Information about the association.</p>
    pub overview: std::option::Option<crate::model::AssociationOverview>,
    /// <p>The document version.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>Specify the target for the association. This target is required for associations that use an
    /// Automation runbook and target resources by using rate controls. Automation is a capability of
    /// Amazon Web Services Systems Manager.</p>
    pub automation_target_parameter_name: std::option::Option<std::string::String>,
    /// <p>A description of the parameters for a document. </p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The association ID.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The instances targeted by the request. </p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>A cron expression that specifies a schedule when the association runs.</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>An S3 bucket where you want to store the output details of the request.</p>
    pub output_location: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
    /// <p>The date on which the association was last run.</p>
    pub last_execution_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last date on which the association was successfully run.</p>
    pub last_successful_execution_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The association name.</p>
    pub association_name: std::option::Option<std::string::String>,
    /// <p>The number of errors that are allowed before the system stops sending requests to run the
    /// association on additional targets. You can specify either an absolute number of errors, for
    /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
    /// the system stops sending requests when the fourth error is received. If you specify 0, then the
    /// system stops sending requests after the first error is returned. If you run an association on 50
    /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
    /// the sixth error is received.</p>
    /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
    /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
    /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
    /// so that executions proceed one at a time.</p>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>The maximum number of targets allowed to run the association at the same time. You can
    /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
    /// value is 100%, which means all targets run the association at the same time.</p>
    /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
    /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
    /// association interval, the new instance will process its association within the limit specified
    /// for <code>MaxConcurrency</code>.</p>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The severity level that is assigned to the association.</p>
    pub compliance_severity: std::option::Option<crate::model::AssociationComplianceSeverity>,
    /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
    /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
    /// execution to determine the compliance status. If the association execution runs successfully,
    /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
    /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
    /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
    /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
    /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
    /// <a>PutComplianceItems</a> API operation.</p>
    /// <p>By default, all associations use <code>AUTO</code> mode.</p>
    pub sync_compliance: std::option::Option<crate::model::AssociationSyncCompliance>,
    /// <p>By default, when you create a new associations, the system runs it immediately after it is
    /// created and then according to the schedule you specified. Specify this option if you don't want
    /// an association to run immediately after you create it. This parameter isn't supported for rate
    /// expressions.</p>
    pub apply_only_at_cron_interval: bool,
    /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
    /// associations are gated under. The associations only run when that change calendar is open. For
    /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
    /// Calendar</a>.</p>
    pub calendar_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
    /// association.</p>
    pub target_locations: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
}
impl std::fmt::Debug for AssociationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociationDescription");
        formatter.field("name", &self.name);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("association_version", &self.association_version);
        formatter.field("date", &self.date);
        formatter.field(
            "last_update_association_date",
            &self.last_update_association_date,
        );
        formatter.field("status", &self.status);
        formatter.field("overview", &self.overview);
        formatter.field("document_version", &self.document_version);
        formatter.field(
            "automation_target_parameter_name",
            &self.automation_target_parameter_name,
        );
        formatter.field("parameters", &self.parameters);
        formatter.field("association_id", &self.association_id);
        formatter.field("targets", &self.targets);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("output_location", &self.output_location);
        formatter.field("last_execution_date", &self.last_execution_date);
        formatter.field(
            "last_successful_execution_date",
            &self.last_successful_execution_date,
        );
        formatter.field("association_name", &self.association_name);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("compliance_severity", &self.compliance_severity);
        formatter.field("sync_compliance", &self.sync_compliance);
        formatter.field(
            "apply_only_at_cron_interval",
            &self.apply_only_at_cron_interval,
        );
        formatter.field("calendar_names", &self.calendar_names);
        formatter.field("target_locations", &self.target_locations);
        formatter.finish()
    }
}
/// See [`AssociationDescription`](crate::model::AssociationDescription)
pub mod association_description {
    /// A builder for [`AssociationDescription`](crate::model::AssociationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) association_version: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_association_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::AssociationStatus>,
        pub(crate) overview: std::option::Option<crate::model::AssociationOverview>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) automation_target_parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) output_location:
            std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        pub(crate) last_execution_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_successful_execution_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) association_name: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) compliance_severity:
            std::option::Option<crate::model::AssociationComplianceSeverity>,
        pub(crate) sync_compliance: std::option::Option<crate::model::AssociationSyncCompliance>,
        pub(crate) apply_only_at_cron_interval: std::option::Option<bool>,
        pub(crate) calendar_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_locations:
            std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The association version.</p>
        pub fn association_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_version = Some(input.into());
            self
        }
        /// <p>The association version.</p>
        pub fn set_association_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_version = input;
            self
        }
        /// <p>The date when the association was made.</p>
        pub fn date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>The date when the association was made.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.date = input;
            self
        }
        /// <p>The date when the association was last updated.</p>
        pub fn last_update_association_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_association_date = Some(input);
            self
        }
        /// <p>The date when the association was last updated.</p>
        pub fn set_last_update_association_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_association_date = input;
            self
        }
        /// <p>The association status.</p>
        pub fn status(mut self, input: crate::model::AssociationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The association status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssociationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about the association.</p>
        pub fn overview(mut self, input: crate::model::AssociationOverview) -> Self {
            self.overview = Some(input);
            self
        }
        /// <p>Information about the association.</p>
        pub fn set_overview(
            mut self,
            input: std::option::Option<crate::model::AssociationOverview>,
        ) -> Self {
            self.overview = input;
            self
        }
        /// <p>The document version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>Specify the target for the association. This target is required for associations that use an
        /// Automation runbook and target resources by using rate controls. Automation is a capability of
        /// Amazon Web Services Systems Manager.</p>
        pub fn automation_target_parameter_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.automation_target_parameter_name = Some(input.into());
            self
        }
        /// <p>Specify the target for the association. This target is required for associations that use an
        /// Automation runbook and target resources by using rate controls. Automation is a capability of
        /// Amazon Web Services Systems Manager.</p>
        pub fn set_automation_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automation_target_parameter_name = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A description of the parameters for a document. </p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A description of the parameters for a document. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The association ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The instances targeted by the request. </p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The instances targeted by the request. </p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>A cron expression that specifies a schedule when the association runs.</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A cron expression that specifies a schedule when the association runs.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>An S3 bucket where you want to store the output details of the request.</p>
        pub fn output_location(
            mut self,
            input: crate::model::InstanceAssociationOutputLocation,
        ) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>An S3 bucket where you want to store the output details of the request.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The date on which the association was last run.</p>
        pub fn last_execution_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_execution_date = Some(input);
            self
        }
        /// <p>The date on which the association was last run.</p>
        pub fn set_last_execution_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_execution_date = input;
            self
        }
        /// <p>The last date on which the association was successfully run.</p>
        pub fn last_successful_execution_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_successful_execution_date = Some(input);
            self
        }
        /// <p>The last date on which the association was successfully run.</p>
        pub fn set_last_successful_execution_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_successful_execution_date = input;
            self
        }
        /// <p>The association name.</p>
        pub fn association_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_name = Some(input.into());
            self
        }
        /// <p>The association name.</p>
        pub fn set_association_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_name = input;
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The severity level that is assigned to the association.</p>
        pub fn compliance_severity(
            mut self,
            input: crate::model::AssociationComplianceSeverity,
        ) -> Self {
            self.compliance_severity = Some(input);
            self
        }
        /// <p>The severity level that is assigned to the association.</p>
        pub fn set_compliance_severity(
            mut self,
            input: std::option::Option<crate::model::AssociationComplianceSeverity>,
        ) -> Self {
            self.compliance_severity = input;
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
        /// <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn sync_compliance(mut self, input: crate::model::AssociationSyncCompliance) -> Self {
            self.sync_compliance = Some(input);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
        /// <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn set_sync_compliance(
            mut self,
            input: std::option::Option<crate::model::AssociationSyncCompliance>,
        ) -> Self {
            self.sync_compliance = input;
            self
        }
        /// <p>By default, when you create a new associations, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn apply_only_at_cron_interval(mut self, input: bool) -> Self {
            self.apply_only_at_cron_interval = Some(input);
            self
        }
        /// <p>By default, when you create a new associations, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn set_apply_only_at_cron_interval(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_only_at_cron_interval = input;
            self
        }
        /// Appends an item to `calendar_names`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
        /// associations are gated under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn calendar_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.calendar_names.unwrap_or_default();
            v.push(input.into());
            self.calendar_names = Some(v);
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
        /// associations are gated under. The associations only run when that change calendar is open. For
        /// more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.calendar_names = input;
            self
        }
        /// Appends an item to `target_locations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association.</p>
        pub fn target_locations(mut self, input: impl Into<crate::model::TargetLocation>) -> Self {
            let mut v = self.target_locations.unwrap_or_default();
            v.push(input.into());
            self.target_locations = Some(v);
            self
        }
        /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
        /// association.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.target_locations = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociationDescription`](crate::model::AssociationDescription)
        pub fn build(self) -> crate::model::AssociationDescription {
            crate::model::AssociationDescription {
                name: self.name,
                instance_id: self.instance_id,
                association_version: self.association_version,
                date: self.date,
                last_update_association_date: self.last_update_association_date,
                status: self.status,
                overview: self.overview,
                document_version: self.document_version,
                automation_target_parameter_name: self.automation_target_parameter_name,
                parameters: self.parameters,
                association_id: self.association_id,
                targets: self.targets,
                schedule_expression: self.schedule_expression,
                output_location: self.output_location,
                last_execution_date: self.last_execution_date,
                last_successful_execution_date: self.last_successful_execution_date,
                association_name: self.association_name,
                max_errors: self.max_errors,
                max_concurrency: self.max_concurrency,
                compliance_severity: self.compliance_severity,
                sync_compliance: self.sync_compliance,
                apply_only_at_cron_interval: self.apply_only_at_cron_interval.unwrap_or_default(),
                calendar_names: self.calendar_names,
                target_locations: self.target_locations,
            }
        }
    }
}
impl AssociationDescription {
    /// Creates a new builder-style object to manufacture [`AssociationDescription`](crate::model::AssociationDescription)
    pub fn builder() -> crate::model::association_description::Builder {
        crate::model::association_description::Builder::default()
    }
}

/// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
/// execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetLocation {
    /// <p>The Amazon Web Services accounts targeted by the current Automation execution.</p>
    pub accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Web Services Regions targeted by the current Automation execution.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation
    /// concurrently.</p>
    pub target_location_max_concurrency: std::option::Option<std::string::String>,
    /// <p>The maximum number of errors allowed before the system stops queueing additional Automation
    /// executions for the currently running Automation.</p>
    pub target_location_max_errors: std::option::Option<std::string::String>,
    /// <p>The Automation execution role used by the currently running Automation. If not specified,
    /// the default value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.</p>
    pub execution_role_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetLocation");
        formatter.field("accounts", &self.accounts);
        formatter.field("regions", &self.regions);
        formatter.field(
            "target_location_max_concurrency",
            &self.target_location_max_concurrency,
        );
        formatter.field(
            "target_location_max_errors",
            &self.target_location_max_errors,
        );
        formatter.field("execution_role_name", &self.execution_role_name);
        formatter.finish()
    }
}
/// See [`TargetLocation`](crate::model::TargetLocation)
pub mod target_location {
    /// A builder for [`TargetLocation`](crate::model::TargetLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accounts: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_location_max_concurrency: std::option::Option<std::string::String>,
        pub(crate) target_location_max_errors: std::option::Option<std::string::String>,
        pub(crate) execution_role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `accounts`.
        ///
        /// To override the contents of this collection use [`set_accounts`](Self::set_accounts).
        ///
        /// <p>The Amazon Web Services accounts targeted by the current Automation execution.</p>
        pub fn accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accounts.unwrap_or_default();
            v.push(input.into());
            self.accounts = Some(v);
            self
        }
        /// <p>The Amazon Web Services accounts targeted by the current Automation execution.</p>
        pub fn set_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accounts = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The Amazon Web Services Regions targeted by the current Automation execution.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>The Amazon Web Services Regions targeted by the current Automation execution.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation
        /// concurrently.</p>
        pub fn target_location_max_concurrency(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_location_max_concurrency = Some(input.into());
            self
        }
        /// <p>The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation
        /// concurrently.</p>
        pub fn set_target_location_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_location_max_concurrency = input;
            self
        }
        /// <p>The maximum number of errors allowed before the system stops queueing additional Automation
        /// executions for the currently running Automation.</p>
        pub fn target_location_max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_location_max_errors = Some(input.into());
            self
        }
        /// <p>The maximum number of errors allowed before the system stops queueing additional Automation
        /// executions for the currently running Automation.</p>
        pub fn set_target_location_max_errors(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_location_max_errors = input;
            self
        }
        /// <p>The Automation execution role used by the currently running Automation. If not specified,
        /// the default value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.</p>
        pub fn execution_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_name = Some(input.into());
            self
        }
        /// <p>The Automation execution role used by the currently running Automation. If not specified,
        /// the default value is <code>AWS-SystemsManager-AutomationExecutionRole</code>.</p>
        pub fn set_execution_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetLocation`](crate::model::TargetLocation)
        pub fn build(self) -> crate::model::TargetLocation {
            crate::model::TargetLocation {
                accounts: self.accounts,
                regions: self.regions,
                target_location_max_concurrency: self.target_location_max_concurrency,
                target_location_max_errors: self.target_location_max_errors,
                execution_role_name: self.execution_role_name,
            }
        }
    }
}
impl TargetLocation {
    /// Creates a new builder-style object to manufacture [`TargetLocation`](crate::model::TargetLocation)
    pub fn builder() -> crate::model::target_location::Builder {
        crate::model::target_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssociationSyncCompliance {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssociationSyncCompliance {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => AssociationSyncCompliance::Auto,
            "MANUAL" => AssociationSyncCompliance::Manual,
            other => AssociationSyncCompliance::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssociationSyncCompliance {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssociationSyncCompliance::from(s))
    }
}
impl AssociationSyncCompliance {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssociationSyncCompliance::Auto => "AUTO",
            AssociationSyncCompliance::Manual => "MANUAL",
            AssociationSyncCompliance::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "MANUAL"]
    }
}
impl AsRef<str> for AssociationSyncCompliance {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssociationComplianceSeverity {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Unspecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssociationComplianceSeverity {
    fn from(s: &str) -> Self {
        match s {
            "CRITICAL" => AssociationComplianceSeverity::Critical,
            "HIGH" => AssociationComplianceSeverity::High,
            "LOW" => AssociationComplianceSeverity::Low,
            "MEDIUM" => AssociationComplianceSeverity::Medium,
            "UNSPECIFIED" => AssociationComplianceSeverity::Unspecified,
            other => AssociationComplianceSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssociationComplianceSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssociationComplianceSeverity::from(s))
    }
}
impl AssociationComplianceSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssociationComplianceSeverity::Critical => "CRITICAL",
            AssociationComplianceSeverity::High => "HIGH",
            AssociationComplianceSeverity::Low => "LOW",
            AssociationComplianceSeverity::Medium => "MEDIUM",
            AssociationComplianceSeverity::Unspecified => "UNSPECIFIED",
            AssociationComplianceSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CRITICAL", "HIGH", "LOW", "MEDIUM", "UNSPECIFIED"]
    }
}
impl AsRef<str> for AssociationComplianceSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An S3 bucket where you want to store the results of this request.</p>
/// <p>For the minimal permissions required to enable Amazon S3 output for an association,
/// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-state-assoc.html">Creating associations</a> in the <i>Systems Manager User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceAssociationOutputLocation {
    /// <p>An S3 bucket where you want to store the results of this request.</p>
    pub s3_location: std::option::Option<crate::model::S3OutputLocation>,
}
impl std::fmt::Debug for InstanceAssociationOutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceAssociationOutputLocation");
        formatter.field("s3_location", &self.s3_location);
        formatter.finish()
    }
}
/// See [`InstanceAssociationOutputLocation`](crate::model::InstanceAssociationOutputLocation)
pub mod instance_association_output_location {
    /// A builder for [`InstanceAssociationOutputLocation`](crate::model::InstanceAssociationOutputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_location: std::option::Option<crate::model::S3OutputLocation>,
    }
    impl Builder {
        /// <p>An S3 bucket where you want to store the results of this request.</p>
        pub fn s3_location(mut self, input: crate::model::S3OutputLocation) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>An S3 bucket where you want to store the results of this request.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3OutputLocation>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceAssociationOutputLocation`](crate::model::InstanceAssociationOutputLocation)
        pub fn build(self) -> crate::model::InstanceAssociationOutputLocation {
            crate::model::InstanceAssociationOutputLocation {
                s3_location: self.s3_location,
            }
        }
    }
}
impl InstanceAssociationOutputLocation {
    /// Creates a new builder-style object to manufacture [`InstanceAssociationOutputLocation`](crate::model::InstanceAssociationOutputLocation)
    pub fn builder() -> crate::model::instance_association_output_location::Builder {
        crate::model::instance_association_output_location::Builder::default()
    }
}

/// <p>An S3 bucket where you want to store the results of this request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3OutputLocation {
    /// <p>The Amazon Web Services Region of the S3 bucket.</p>
    pub output_s3_region: std::option::Option<std::string::String>,
    /// <p>The name of the S3 bucket.</p>
    pub output_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket subfolder.</p>
    pub output_s3_key_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3OutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3OutputLocation");
        formatter.field("output_s3_region", &self.output_s3_region);
        formatter.field("output_s3_bucket_name", &self.output_s3_bucket_name);
        formatter.field("output_s3_key_prefix", &self.output_s3_key_prefix);
        formatter.finish()
    }
}
/// See [`S3OutputLocation`](crate::model::S3OutputLocation)
pub mod s3_output_location {
    /// A builder for [`S3OutputLocation`](crate::model::S3OutputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_s3_region: std::option::Option<std::string::String>,
        pub(crate) output_s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) output_s3_key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services Region of the S3 bucket.</p>
        pub fn output_s3_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the S3 bucket.</p>
        pub fn set_output_s3_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_region = input;
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn output_s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_bucket_name = input;
            self
        }
        /// <p>The S3 bucket subfolder.</p>
        pub fn output_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The S3 bucket subfolder.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3OutputLocation`](crate::model::S3OutputLocation)
        pub fn build(self) -> crate::model::S3OutputLocation {
            crate::model::S3OutputLocation {
                output_s3_region: self.output_s3_region,
                output_s3_bucket_name: self.output_s3_bucket_name,
                output_s3_key_prefix: self.output_s3_key_prefix,
            }
        }
    }
}
impl S3OutputLocation {
    /// Creates a new builder-style object to manufacture [`S3OutputLocation`](crate::model::S3OutputLocation)
    pub fn builder() -> crate::model::s3_output_location::Builder {
        crate::model::s3_output_location::Builder::default()
    }
}

/// <p>Information about the association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociationOverview {
    /// <p>The status of the association. Status can be: Pending, Success, or Failed.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>A detailed status of the association.</p>
    pub detailed_status: std::option::Option<std::string::String>,
    /// <p>Returns the number of targets for the association status. For example, if you created an
    /// association with two instances, and one of them was successful, this would return the count of
    /// instances by status.</p>
    pub association_status_aggregated_count:
        std::option::Option<std::collections::HashMap<std::string::String, i32>>,
}
impl std::fmt::Debug for AssociationOverview {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociationOverview");
        formatter.field("status", &self.status);
        formatter.field("detailed_status", &self.detailed_status);
        formatter.field(
            "association_status_aggregated_count",
            &self.association_status_aggregated_count,
        );
        formatter.finish()
    }
}
/// See [`AssociationOverview`](crate::model::AssociationOverview)
pub mod association_overview {
    /// A builder for [`AssociationOverview`](crate::model::AssociationOverview)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) detailed_status: std::option::Option<std::string::String>,
        pub(crate) association_status_aggregated_count:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    }
    impl Builder {
        /// <p>The status of the association. Status can be: Pending, Success, or Failed.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the association. Status can be: Pending, Success, or Failed.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed status of the association.</p>
        pub fn detailed_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.detailed_status = Some(input.into());
            self
        }
        /// <p>A detailed status of the association.</p>
        pub fn set_detailed_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detailed_status = input;
            self
        }
        /// Adds a key-value pair to `association_status_aggregated_count`.
        ///
        /// To override the contents of this collection use [`set_association_status_aggregated_count`](Self::set_association_status_aggregated_count).
        ///
        /// <p>Returns the number of targets for the association status. For example, if you created an
        /// association with two instances, and one of them was successful, this would return the count of
        /// instances by status.</p>
        pub fn association_status_aggregated_count(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.association_status_aggregated_count.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.association_status_aggregated_count = Some(hash_map);
            self
        }
        /// <p>Returns the number of targets for the association status. For example, if you created an
        /// association with two instances, and one of them was successful, this would return the count of
        /// instances by status.</p>
        pub fn set_association_status_aggregated_count(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.association_status_aggregated_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociationOverview`](crate::model::AssociationOverview)
        pub fn build(self) -> crate::model::AssociationOverview {
            crate::model::AssociationOverview {
                status: self.status,
                detailed_status: self.detailed_status,
                association_status_aggregated_count: self.association_status_aggregated_count,
            }
        }
    }
}
impl AssociationOverview {
    /// Creates a new builder-style object to manufacture [`AssociationOverview`](crate::model::AssociationOverview)
    pub fn builder() -> crate::model::association_overview::Builder {
        crate::model::association_overview::Builder::default()
    }
}

/// <p>Describes an association status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociationStatus {
    /// <p>The date when the status changed.</p>
    pub date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status.</p>
    pub name: std::option::Option<crate::model::AssociationStatusName>,
    /// <p>The reason for the status.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>A user-defined string.</p>
    pub additional_info: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociationStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociationStatus");
        formatter.field("date", &self.date);
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.field("additional_info", &self.additional_info);
        formatter.finish()
    }
}
/// See [`AssociationStatus`](crate::model::AssociationStatus)
pub mod association_status {
    /// A builder for [`AssociationStatus`](crate::model::AssociationStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<crate::model::AssociationStatusName>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) additional_info: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date when the status changed.</p>
        pub fn date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>The date when the status changed.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.date = input;
            self
        }
        /// <p>The status.</p>
        pub fn name(mut self, input: crate::model::AssociationStatusName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The status.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::AssociationStatusName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The reason for the status.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The reason for the status.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A user-defined string.</p>
        pub fn additional_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_info = Some(input.into());
            self
        }
        /// <p>A user-defined string.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_info = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociationStatus`](crate::model::AssociationStatus)
        pub fn build(self) -> crate::model::AssociationStatus {
            crate::model::AssociationStatus {
                date: self.date,
                name: self.name,
                message: self.message,
                additional_info: self.additional_info,
            }
        }
    }
}
impl AssociationStatus {
    /// Creates a new builder-style object to manufacture [`AssociationStatus`](crate::model::AssociationStatus)
    pub fn builder() -> crate::model::association_status::Builder {
        crate::model::association_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssociationStatusName {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssociationStatusName {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => AssociationStatusName::Failed,
            "Pending" => AssociationStatusName::Pending,
            "Success" => AssociationStatusName::Success,
            other => AssociationStatusName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssociationStatusName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssociationStatusName::from(s))
    }
}
impl AssociationStatusName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssociationStatusName::Failed => "Failed",
            AssociationStatusName::Pending => "Pending",
            AssociationStatusName::Success => "Success",
            AssociationStatusName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "Pending", "Success"]
    }
}
impl AsRef<str> for AssociationStatusName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StopType {
    #[allow(missing_docs)] // documentation missing in model
    Cancel,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StopType {
    fn from(s: &str) -> Self {
        match s {
            "Cancel" => StopType::Cancel,
            "Complete" => StopType::Complete,
            other => StopType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StopType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StopType::from(s))
    }
}
impl StopType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StopType::Cancel => "Cancel",
            StopType::Complete => "Complete",
            StopType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Cancel", "Complete"]
    }
}
impl AsRef<str> for StopType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an Automation runbook used in a runbook workflow in Change Manager.</p>
/// <note>
/// <p>The Automation runbooks specified for the runbook workflow can't run until all required
/// approvals for the change request have been received.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Runbook {
    /// <p>The name of the Automation runbook used in a runbook workflow.</p>
    pub document_name: std::option::Option<std::string::String>,
    /// <p>The version of the Automation runbook used in a runbook workflow.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The key-value map of execution parameters, which were supplied when calling
    /// <code>StartChangeRequestExecution</code>.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The name of the parameter used as the target resource for the rate-controlled
    /// runbook workflow. Required if you specify <code>Targets</code>. </p>
    pub target_parameter_name: std::option::Option<std::string::String>,
    /// <p>A key-value mapping to target resources that the runbook operation performs tasks on.
    /// Required if you specify <code>TargetParameterName</code>.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The <code>MaxConcurrency</code> value specified by the user when the operation started,
    /// indicating the maximum number of resources that the runbook operation can run on at the same
    /// time.</p>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The <code>MaxErrors</code> value specified by the user when the execution started,
    /// indicating the maximum number of errors that can occur during the operation before the updates
    /// are stopped or rolled back.</p>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook
    /// operation.</p>
    pub target_locations: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
}
impl std::fmt::Debug for Runbook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Runbook");
        formatter.field("document_name", &self.document_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("parameters", &self.parameters);
        formatter.field("target_parameter_name", &self.target_parameter_name);
        formatter.field("targets", &self.targets);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("target_locations", &self.target_locations);
        formatter.finish()
    }
}
/// See [`Runbook`](crate::model::Runbook)
pub mod runbook {
    /// A builder for [`Runbook`](crate::model::Runbook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) target_parameter_name: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) target_locations:
            std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
    }
    impl Builder {
        /// <p>The name of the Automation runbook used in a runbook workflow.</p>
        pub fn document_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_name = Some(input.into());
            self
        }
        /// <p>The name of the Automation runbook used in a runbook workflow.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_name = input;
            self
        }
        /// <p>The version of the Automation runbook used in a runbook workflow.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of the Automation runbook used in a runbook workflow.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The key-value map of execution parameters, which were supplied when calling
        /// <code>StartChangeRequestExecution</code>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The key-value map of execution parameters, which were supplied when calling
        /// <code>StartChangeRequestExecution</code>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The name of the parameter used as the target resource for the rate-controlled
        /// runbook workflow. Required if you specify <code>Targets</code>. </p>
        pub fn target_parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter used as the target resource for the rate-controlled
        /// runbook workflow. Required if you specify <code>Targets</code>. </p>
        pub fn set_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_parameter_name = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A key-value mapping to target resources that the runbook operation performs tasks on.
        /// Required if you specify <code>TargetParameterName</code>.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>A key-value mapping to target resources that the runbook operation performs tasks on.
        /// Required if you specify <code>TargetParameterName</code>.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The <code>MaxConcurrency</code> value specified by the user when the operation started,
        /// indicating the maximum number of resources that the runbook operation can run on at the same
        /// time.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The <code>MaxConcurrency</code> value specified by the user when the operation started,
        /// indicating the maximum number of resources that the runbook operation can run on at the same
        /// time.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The <code>MaxErrors</code> value specified by the user when the execution started,
        /// indicating the maximum number of errors that can occur during the operation before the updates
        /// are stopped or rolled back.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The <code>MaxErrors</code> value specified by the user when the execution started,
        /// indicating the maximum number of errors that can occur during the operation before the updates
        /// are stopped or rolled back.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// Appends an item to `target_locations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook
        /// operation.</p>
        pub fn target_locations(mut self, input: impl Into<crate::model::TargetLocation>) -> Self {
            let mut v = self.target_locations.unwrap_or_default();
            v.push(input.into());
            self.target_locations = Some(v);
            self
        }
        /// <p>Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook
        /// operation.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.target_locations = input;
            self
        }
        /// Consumes the builder and constructs a [`Runbook`](crate::model::Runbook)
        pub fn build(self) -> crate::model::Runbook {
            crate::model::Runbook {
                document_name: self.document_name,
                document_version: self.document_version,
                parameters: self.parameters,
                target_parameter_name: self.target_parameter_name,
                targets: self.targets,
                max_concurrency: self.max_concurrency,
                max_errors: self.max_errors,
                target_locations: self.target_locations,
            }
        }
    }
}
impl Runbook {
    /// Creates a new builder-style object to manufacture [`Runbook`](crate::model::Runbook)
    pub fn builder() -> crate::model::runbook::Builder {
        crate::model::runbook::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionMode {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Interactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionMode {
    fn from(s: &str) -> Self {
        match s {
            "Auto" => ExecutionMode::Auto,
            "Interactive" => ExecutionMode::Interactive,
            other => ExecutionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionMode::from(s))
    }
}
impl ExecutionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionMode::Auto => "Auto",
            ExecutionMode::Interactive => "Interactive",
            ExecutionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Auto", "Interactive"]
    }
}
impl AsRef<str> for ExecutionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a command request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Command {
    /// <p>A unique identifier for this command.</p>
    pub command_id: std::option::Option<std::string::String>,
    /// <p>The name of the document requested for execution.</p>
    pub document_name: std::option::Option<std::string::String>,
    /// <p>The Systems Manager document (SSM document) version.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>User-specified information about the command, such as a brief description of what the
    /// command should do.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>If this time is reached and the command hasn't already started running, it won't run.
    /// Calculated based on the <code>ExpiresAfter</code> user input provided as part of the
    /// <code>SendCommand</code> API operation.</p>
    pub expires_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The parameter values to be inserted in the document when running the command.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The instance IDs against which this command was requested.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of search criteria that targets instances using a Key,Value combination that you
    /// specify. Targets is required if you don't provide one or more instance IDs in the call.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The date and time the command was requested.</p>
    pub requested_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the command.</p>
    pub status: std::option::Option<crate::model::CommandStatus>,
    /// <p>A detailed status of the command execution. <code>StatusDetails</code> includes more
    /// information than <code>Status</code> because it includes states resulting from error and
    /// concurrency control parameters. <code>StatusDetails</code> can show different results than
    /// Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
    /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>Pending: The command hasn't been sent to any instances.</p>
    /// </li>
    /// <li>
    /// <p>In Progress: The command has been sent to at least one instance but hasn't reached a final
    /// state on all instances.</p>
    /// </li>
    /// <li>
    /// <p>Success: The command successfully ran on all invocations. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of
    /// Delivery Timed Out. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Execution Timed Out: The value of MaxErrors or more command invocations shows a status of
    /// Execution Timed Out. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Failed: The value of MaxErrors or more command invocations shows a status of Failed. This
    /// is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Incomplete: The command was attempted on all instances and one or more invocations doesn't
    /// have a value of Success but not enough invocations failed for the status to be Failed. This is
    /// a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Canceled: The command was terminated before it was completed. This is a terminal
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>Rate Exceeded: The number of instances targeted by the command exceeded the account limit
    /// for pending invocations. The system has canceled the command before running it on any instance.
    /// This is a terminal state.</p>
    /// </li>
    /// </ul>
    pub status_details: std::option::Option<std::string::String>,
    /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
    /// automatically determines the Amazon Web Services Region of the S3 bucket.</p>
    pub output_s3_region: std::option::Option<std::string::String>,
    /// <p>The S3 bucket where the responses to the command executions should be stored. This was
    /// requested when issuing the command.</p>
    pub output_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 directory path inside the bucket where the responses to the command executions should
    /// be stored. This was requested when issuing the command.</p>
    pub output_s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The maximum number of instances that are allowed to run the command at the same time. You
    /// can specify a number of instances, such as 10, or a percentage of instances, such as 10%. The
    /// default value is 50. For more information about how to use <code>MaxConcurrency</code>, see
    /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running
    /// commands using Systems Manager Run Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The maximum number of errors allowed before the system stops sending the command to
    /// additional targets. You can specify a number of errors, such as 10, or a percentage or errors,
    /// such as 10%. The default value is <code>0</code>. For more information about how to use
    /// <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run
    /// Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>The number of targets for the command.</p>
    pub target_count: i32,
    /// <p>The number of targets for which the command invocation reached a terminal state. Terminal
    /// states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled,
    /// Terminated, or Undeliverable.</p>
    pub completed_count: i32,
    /// <p>The number of targets for which the status is Failed or Execution Timed Out.</p>
    pub error_count: i32,
    /// <p>The number of targets for which the status is Delivery Timed Out.</p>
    pub delivery_timed_out_count: i32,
    /// <p>The Identity and Access Management (IAM) service role that Run Command, a capability
    /// of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes.
    /// </p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>Configurations for sending notifications about command status changes. </p>
    pub notification_config: std::option::Option<crate::model::NotificationConfig>,
    /// <p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
    /// output.</p>
    pub cloud_watch_output_config: std::option::Option<crate::model::CloudWatchOutputConfig>,
    /// <p>The <code>TimeoutSeconds</code> value specified for a command.</p>
    pub timeout_seconds: i32,
}
impl std::fmt::Debug for Command {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Command");
        formatter.field("command_id", &self.command_id);
        formatter.field("document_name", &self.document_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("comment", &self.comment);
        formatter.field("expires_after", &self.expires_after);
        formatter.field("parameters", &self.parameters);
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("targets", &self.targets);
        formatter.field("requested_date_time", &self.requested_date_time);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("output_s3_region", &self.output_s3_region);
        formatter.field("output_s3_bucket_name", &self.output_s3_bucket_name);
        formatter.field("output_s3_key_prefix", &self.output_s3_key_prefix);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("target_count", &self.target_count);
        formatter.field("completed_count", &self.completed_count);
        formatter.field("error_count", &self.error_count);
        formatter.field("delivery_timed_out_count", &self.delivery_timed_out_count);
        formatter.field("service_role", &self.service_role);
        formatter.field("notification_config", &self.notification_config);
        formatter.field("cloud_watch_output_config", &self.cloud_watch_output_config);
        formatter.field("timeout_seconds", &self.timeout_seconds);
        formatter.finish()
    }
}
/// See [`Command`](crate::model::Command)
pub mod command {
    /// A builder for [`Command`](crate::model::Command)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) document_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) expires_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) requested_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::CommandStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) output_s3_region: std::option::Option<std::string::String>,
        pub(crate) output_s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) output_s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) target_count: std::option::Option<i32>,
        pub(crate) completed_count: std::option::Option<i32>,
        pub(crate) error_count: std::option::Option<i32>,
        pub(crate) delivery_timed_out_count: std::option::Option<i32>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) notification_config: std::option::Option<crate::model::NotificationConfig>,
        pub(crate) cloud_watch_output_config:
            std::option::Option<crate::model::CloudWatchOutputConfig>,
        pub(crate) timeout_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A unique identifier for this command.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for this command.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// <p>The name of the document requested for execution.</p>
        pub fn document_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_name = Some(input.into());
            self
        }
        /// <p>The name of the document requested for execution.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_name = input;
            self
        }
        /// <p>The Systems Manager document (SSM document) version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The Systems Manager document (SSM document) version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>User-specified information about the command, such as a brief description of what the
        /// command should do.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>User-specified information about the command, such as a brief description of what the
        /// command should do.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>If this time is reached and the command hasn't already started running, it won't run.
        /// Calculated based on the <code>ExpiresAfter</code> user input provided as part of the
        /// <code>SendCommand</code> API operation.</p>
        pub fn expires_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires_after = Some(input);
            self
        }
        /// <p>If this time is reached and the command hasn't already started running, it won't run.
        /// Calculated based on the <code>ExpiresAfter</code> user input provided as part of the
        /// <code>SendCommand</code> API operation.</p>
        pub fn set_expires_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires_after = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameter values to be inserted in the document when running the command.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The parameter values to be inserted in the document when running the command.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The instance IDs against which this command was requested.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The instance IDs against which this command was requested.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>An array of search criteria that targets instances using a Key,Value combination that you
        /// specify. Targets is required if you don't provide one or more instance IDs in the call.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>An array of search criteria that targets instances using a Key,Value combination that you
        /// specify. Targets is required if you don't provide one or more instance IDs in the call.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The date and time the command was requested.</p>
        pub fn requested_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.requested_date_time = Some(input);
            self
        }
        /// <p>The date and time the command was requested.</p>
        pub fn set_requested_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.requested_date_time = input;
            self
        }
        /// <p>The status of the command.</p>
        pub fn status(mut self, input: crate::model::CommandStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the command.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CommandStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed status of the command execution. <code>StatusDetails</code> includes more
        /// information than <code>Status</code> because it includes states resulting from error and
        /// concurrency control parameters. <code>StatusDetails</code> can show different results than
        /// Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
        /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The command hasn't been sent to any instances.</p>
        /// </li>
        /// <li>
        /// <p>In Progress: The command has been sent to at least one instance but hasn't reached a final
        /// state on all instances.</p>
        /// </li>
        /// <li>
        /// <p>Success: The command successfully ran on all invocations. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of
        /// Delivery Timed Out. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Execution Timed Out: The value of MaxErrors or more command invocations shows a status of
        /// Execution Timed Out. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Failed: The value of MaxErrors or more command invocations shows a status of Failed. This
        /// is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Incomplete: The command was attempted on all instances and one or more invocations doesn't
        /// have a value of Success but not enough invocations failed for the status to be Failed. This is
        /// a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Canceled: The command was terminated before it was completed. This is a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Rate Exceeded: The number of instances targeted by the command exceeded the account limit
        /// for pending invocations. The system has canceled the command before running it on any instance.
        /// This is a terminal state.</p>
        /// </li>
        /// </ul>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>A detailed status of the command execution. <code>StatusDetails</code> includes more
        /// information than <code>Status</code> because it includes states resulting from error and
        /// concurrency control parameters. <code>StatusDetails</code> can show different results than
        /// Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
        /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The command hasn't been sent to any instances.</p>
        /// </li>
        /// <li>
        /// <p>In Progress: The command has been sent to at least one instance but hasn't reached a final
        /// state on all instances.</p>
        /// </li>
        /// <li>
        /// <p>Success: The command successfully ran on all invocations. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of
        /// Delivery Timed Out. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Execution Timed Out: The value of MaxErrors or more command invocations shows a status of
        /// Execution Timed Out. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Failed: The value of MaxErrors or more command invocations shows a status of Failed. This
        /// is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Incomplete: The command was attempted on all instances and one or more invocations doesn't
        /// have a value of Success but not enough invocations failed for the status to be Failed. This is
        /// a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Canceled: The command was terminated before it was completed. This is a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Rate Exceeded: The number of instances targeted by the command exceeded the account limit
        /// for pending invocations. The system has canceled the command before running it on any instance.
        /// This is a terminal state.</p>
        /// </li>
        /// </ul>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
        /// automatically determines the Amazon Web Services Region of the S3 bucket.</p>
        pub fn output_s3_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_region = Some(input.into());
            self
        }
        /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
        /// automatically determines the Amazon Web Services Region of the S3 bucket.</p>
        pub fn set_output_s3_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_region = input;
            self
        }
        /// <p>The S3 bucket where the responses to the command executions should be stored. This was
        /// requested when issuing the command.</p>
        pub fn output_s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 bucket where the responses to the command executions should be stored. This was
        /// requested when issuing the command.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_bucket_name = input;
            self
        }
        /// <p>The S3 directory path inside the bucket where the responses to the command executions should
        /// be stored. This was requested when issuing the command.</p>
        pub fn output_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The S3 directory path inside the bucket where the responses to the command executions should
        /// be stored. This was requested when issuing the command.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_key_prefix = input;
            self
        }
        /// <p>The maximum number of instances that are allowed to run the command at the same time. You
        /// can specify a number of instances, such as 10, or a percentage of instances, such as 10%. The
        /// default value is 50. For more information about how to use <code>MaxConcurrency</code>, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running
        /// commands using Systems Manager Run Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The maximum number of instances that are allowed to run the command at the same time. You
        /// can specify a number of instances, such as 10, or a percentage of instances, such as 10%. The
        /// default value is 50. For more information about how to use <code>MaxConcurrency</code>, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running
        /// commands using Systems Manager Run Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The maximum number of errors allowed before the system stops sending the command to
        /// additional targets. You can specify a number of errors, such as 10, or a percentage or errors,
        /// such as 10%. The default value is <code>0</code>. For more information about how to use
        /// <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run
        /// Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The maximum number of errors allowed before the system stops sending the command to
        /// additional targets. You can specify a number of errors, such as 10, or a percentage or errors,
        /// such as 10%. The default value is <code>0</code>. For more information about how to use
        /// <code>MaxErrors</code>, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run
        /// Command</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The number of targets for the command.</p>
        pub fn target_count(mut self, input: i32) -> Self {
            self.target_count = Some(input);
            self
        }
        /// <p>The number of targets for the command.</p>
        pub fn set_target_count(mut self, input: std::option::Option<i32>) -> Self {
            self.target_count = input;
            self
        }
        /// <p>The number of targets for which the command invocation reached a terminal state. Terminal
        /// states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled,
        /// Terminated, or Undeliverable.</p>
        pub fn completed_count(mut self, input: i32) -> Self {
            self.completed_count = Some(input);
            self
        }
        /// <p>The number of targets for which the command invocation reached a terminal state. Terminal
        /// states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled,
        /// Terminated, or Undeliverable.</p>
        pub fn set_completed_count(mut self, input: std::option::Option<i32>) -> Self {
            self.completed_count = input;
            self
        }
        /// <p>The number of targets for which the status is Failed or Execution Timed Out.</p>
        pub fn error_count(mut self, input: i32) -> Self {
            self.error_count = Some(input);
            self
        }
        /// <p>The number of targets for which the status is Failed or Execution Timed Out.</p>
        pub fn set_error_count(mut self, input: std::option::Option<i32>) -> Self {
            self.error_count = input;
            self
        }
        /// <p>The number of targets for which the status is Delivery Timed Out.</p>
        pub fn delivery_timed_out_count(mut self, input: i32) -> Self {
            self.delivery_timed_out_count = Some(input);
            self
        }
        /// <p>The number of targets for which the status is Delivery Timed Out.</p>
        pub fn set_delivery_timed_out_count(mut self, input: std::option::Option<i32>) -> Self {
            self.delivery_timed_out_count = input;
            self
        }
        /// <p>The Identity and Access Management (IAM) service role that Run Command, a capability
        /// of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes.
        /// </p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The Identity and Access Management (IAM) service role that Run Command, a capability
        /// of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes.
        /// </p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>Configurations for sending notifications about command status changes. </p>
        pub fn notification_config(mut self, input: crate::model::NotificationConfig) -> Self {
            self.notification_config = Some(input);
            self
        }
        /// <p>Configurations for sending notifications about command status changes. </p>
        pub fn set_notification_config(
            mut self,
            input: std::option::Option<crate::model::NotificationConfig>,
        ) -> Self {
            self.notification_config = input;
            self
        }
        /// <p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
        /// output.</p>
        pub fn cloud_watch_output_config(
            mut self,
            input: crate::model::CloudWatchOutputConfig,
        ) -> Self {
            self.cloud_watch_output_config = Some(input);
            self
        }
        /// <p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
        /// output.</p>
        pub fn set_cloud_watch_output_config(
            mut self,
            input: std::option::Option<crate::model::CloudWatchOutputConfig>,
        ) -> Self {
            self.cloud_watch_output_config = input;
            self
        }
        /// <p>The <code>TimeoutSeconds</code> value specified for a command.</p>
        pub fn timeout_seconds(mut self, input: i32) -> Self {
            self.timeout_seconds = Some(input);
            self
        }
        /// <p>The <code>TimeoutSeconds</code> value specified for a command.</p>
        pub fn set_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`Command`](crate::model::Command)
        pub fn build(self) -> crate::model::Command {
            crate::model::Command {
                command_id: self.command_id,
                document_name: self.document_name,
                document_version: self.document_version,
                comment: self.comment,
                expires_after: self.expires_after,
                parameters: self.parameters,
                instance_ids: self.instance_ids,
                targets: self.targets,
                requested_date_time: self.requested_date_time,
                status: self.status,
                status_details: self.status_details,
                output_s3_region: self.output_s3_region,
                output_s3_bucket_name: self.output_s3_bucket_name,
                output_s3_key_prefix: self.output_s3_key_prefix,
                max_concurrency: self.max_concurrency,
                max_errors: self.max_errors,
                target_count: self.target_count.unwrap_or_default(),
                completed_count: self.completed_count.unwrap_or_default(),
                error_count: self.error_count.unwrap_or_default(),
                delivery_timed_out_count: self.delivery_timed_out_count.unwrap_or_default(),
                service_role: self.service_role,
                notification_config: self.notification_config,
                cloud_watch_output_config: self.cloud_watch_output_config,
                timeout_seconds: self.timeout_seconds.unwrap_or_default(),
            }
        }
    }
}
impl Command {
    /// Creates a new builder-style object to manufacture [`Command`](crate::model::Command)
    pub fn builder() -> crate::model::command::Builder {
        crate::model::command::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CommandStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CommandStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => CommandStatus::Cancelled,
            "Cancelling" => CommandStatus::Cancelling,
            "Failed" => CommandStatus::Failed,
            "InProgress" => CommandStatus::InProgress,
            "Pending" => CommandStatus::Pending,
            "Success" => CommandStatus::Success,
            "TimedOut" => CommandStatus::TimedOut,
            other => CommandStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CommandStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CommandStatus::from(s))
    }
}
impl CommandStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CommandStatus::Cancelled => "Cancelled",
            CommandStatus::Cancelling => "Cancelling",
            CommandStatus::Failed => "Failed",
            CommandStatus::InProgress => "InProgress",
            CommandStatus::Pending => "Pending",
            CommandStatus::Success => "Success",
            CommandStatus::TimedOut => "TimedOut",
            CommandStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Cancelling",
            "Failed",
            "InProgress",
            "Pending",
            "Success",
            "TimedOut",
        ]
    }
}
impl AsRef<str> for CommandStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SignalType {
    #[allow(missing_docs)] // documentation missing in model
    Approve,
    #[allow(missing_docs)] // documentation missing in model
    Reject,
    #[allow(missing_docs)] // documentation missing in model
    Resume,
    #[allow(missing_docs)] // documentation missing in model
    StartStep,
    #[allow(missing_docs)] // documentation missing in model
    StopStep,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SignalType {
    fn from(s: &str) -> Self {
        match s {
            "Approve" => SignalType::Approve,
            "Reject" => SignalType::Reject,
            "Resume" => SignalType::Resume,
            "StartStep" => SignalType::StartStep,
            "StopStep" => SignalType::StopStep,
            other => SignalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SignalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SignalType::from(s))
    }
}
impl SignalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SignalType::Approve => "Approve",
            SignalType::Reject => "Reject",
            SignalType::Resume => "Resume",
            SignalType::StartStep => "StartStep",
            SignalType::StopStep => "StopStep",
            SignalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Approve", "Reject", "Resume", "StartStep", "StopStep"]
    }
}
impl AsRef<str> for SignalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The service setting data structure.</p>
/// <p>
/// <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting
/// defines how a user interacts with or uses a service or a feature of a service. For example, if an
/// Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
/// service team might create a default setting of "false". This means the user can't use this
/// feature unless they change the setting to "true" and intentionally opt in for a paid
/// feature.</p>
/// <p>Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define
/// the default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>,
/// but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code>
/// permission for the setting. Use the <a>UpdateServiceSetting</a> API operation to
/// change the default setting. Or, use the <a>ResetServiceSetting</a> to change the value
/// back to the original value defined by the Amazon Web Services service team.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSetting {
    /// <p>The ID of the service setting.</p>
    pub setting_id: std::option::Option<std::string::String>,
    /// <p>The value of the service setting.</p>
    pub setting_value: std::option::Option<std::string::String>,
    /// <p>The last time the service setting was modified.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the last modified user. This field is populated only if the setting value was
    /// overwritten.</p>
    pub last_modified_user: std::option::Option<std::string::String>,
    /// <p>The ARN of the service setting.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the service setting. The value can be Default, Customized or
    /// PendingUpdate.</p>
    /// <ul>
    /// <li>
    /// <p>Default: The current setting uses a default value provisioned by the Amazon Web Services service
    /// team.</p>
    /// </li>
    /// <li>
    /// <p>Customized: The current setting use a custom value specified by the customer.</p>
    /// </li>
    /// <li>
    /// <p>PendingUpdate: The current setting uses a default or custom value, but a setting change
    /// request is pending approval.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSetting");
        formatter.field("setting_id", &self.setting_id);
        formatter.field("setting_value", &self.setting_value);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_user", &self.last_modified_user);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ServiceSetting`](crate::model::ServiceSetting)
pub mod service_setting {
    /// A builder for [`ServiceSetting`](crate::model::ServiceSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) setting_id: std::option::Option<std::string::String>,
        pub(crate) setting_value: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_user: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the service setting.</p>
        pub fn setting_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.setting_id = Some(input.into());
            self
        }
        /// <p>The ID of the service setting.</p>
        pub fn set_setting_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.setting_id = input;
            self
        }
        /// <p>The value of the service setting.</p>
        pub fn setting_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.setting_value = Some(input.into());
            self
        }
        /// <p>The value of the service setting.</p>
        pub fn set_setting_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.setting_value = input;
            self
        }
        /// <p>The last time the service setting was modified.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The last time the service setting was modified.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The ARN of the last modified user. This field is populated only if the setting value was
        /// overwritten.</p>
        pub fn last_modified_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_user = Some(input.into());
            self
        }
        /// <p>The ARN of the last modified user. This field is populated only if the setting value was
        /// overwritten.</p>
        pub fn set_last_modified_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_user = input;
            self
        }
        /// <p>The ARN of the service setting.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the service setting.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the service setting. The value can be Default, Customized or
        /// PendingUpdate.</p>
        /// <ul>
        /// <li>
        /// <p>Default: The current setting uses a default value provisioned by the Amazon Web Services service
        /// team.</p>
        /// </li>
        /// <li>
        /// <p>Customized: The current setting use a custom value specified by the customer.</p>
        /// </li>
        /// <li>
        /// <p>PendingUpdate: The current setting uses a default or custom value, but a setting change
        /// request is pending approval.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the service setting. The value can be Default, Customized or
        /// PendingUpdate.</p>
        /// <ul>
        /// <li>
        /// <p>Default: The current setting uses a default value provisioned by the Amazon Web Services service
        /// team.</p>
        /// </li>
        /// <li>
        /// <p>Customized: The current setting use a custom value specified by the customer.</p>
        /// </li>
        /// <li>
        /// <p>PendingUpdate: The current setting uses a default or custom value, but a setting change
        /// request is pending approval.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSetting`](crate::model::ServiceSetting)
        pub fn build(self) -> crate::model::ServiceSetting {
            crate::model::ServiceSetting {
                setting_id: self.setting_id,
                setting_value: self.setting_value,
                last_modified_date: self.last_modified_date,
                last_modified_user: self.last_modified_user,
                arn: self.arn,
                status: self.status,
            }
        }
    }
}
impl ServiceSetting {
    /// Creates a new builder-style object to manufacture [`ServiceSetting`](crate::model::ServiceSetting)
    pub fn builder() -> crate::model::service_setting::Builder {
        crate::model::service_setting::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceTypeForTagging {
    #[allow(missing_docs)] // documentation missing in model
    Document,
    #[allow(missing_docs)] // documentation missing in model
    MaintenanceWindow,
    #[allow(missing_docs)] // documentation missing in model
    ManagedInstance,
    #[allow(missing_docs)] // documentation missing in model
    OpsItem,
    #[allow(missing_docs)] // documentation missing in model
    Opsmetadata,
    #[allow(missing_docs)] // documentation missing in model
    Parameter,
    #[allow(missing_docs)] // documentation missing in model
    PatchBaseline,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceTypeForTagging {
    fn from(s: &str) -> Self {
        match s {
            "Document" => ResourceTypeForTagging::Document,
            "MaintenanceWindow" => ResourceTypeForTagging::MaintenanceWindow,
            "ManagedInstance" => ResourceTypeForTagging::ManagedInstance,
            "OpsItem" => ResourceTypeForTagging::OpsItem,
            "OpsMetadata" => ResourceTypeForTagging::Opsmetadata,
            "Parameter" => ResourceTypeForTagging::Parameter,
            "PatchBaseline" => ResourceTypeForTagging::PatchBaseline,
            other => ResourceTypeForTagging::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceTypeForTagging {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceTypeForTagging::from(s))
    }
}
impl ResourceTypeForTagging {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceTypeForTagging::Document => "Document",
            ResourceTypeForTagging::MaintenanceWindow => "MaintenanceWindow",
            ResourceTypeForTagging::ManagedInstance => "ManagedInstance",
            ResourceTypeForTagging::OpsItem => "OpsItem",
            ResourceTypeForTagging::Opsmetadata => "OpsMetadata",
            ResourceTypeForTagging::Parameter => "Parameter",
            ResourceTypeForTagging::PatchBaseline => "PatchBaseline",
            ResourceTypeForTagging::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Document",
            "MaintenanceWindow",
            "ManagedInstance",
            "OpsItem",
            "OpsMetadata",
            "Parameter",
            "PatchBaseline",
        ]
    }
}
impl AsRef<str> for ResourceTypeForTagging {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MaintenanceWindowTaskType {
    #[allow(missing_docs)] // documentation missing in model
    Automation,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    RunCommand,
    #[allow(missing_docs)] // documentation missing in model
    StepFunctions,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MaintenanceWindowTaskType {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATION" => MaintenanceWindowTaskType::Automation,
            "LAMBDA" => MaintenanceWindowTaskType::Lambda,
            "RUN_COMMAND" => MaintenanceWindowTaskType::RunCommand,
            "STEP_FUNCTIONS" => MaintenanceWindowTaskType::StepFunctions,
            other => MaintenanceWindowTaskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MaintenanceWindowTaskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MaintenanceWindowTaskType::from(s))
    }
}
impl MaintenanceWindowTaskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MaintenanceWindowTaskType::Automation => "AUTOMATION",
            MaintenanceWindowTaskType::Lambda => "LAMBDA",
            MaintenanceWindowTaskType::RunCommand => "RUN_COMMAND",
            MaintenanceWindowTaskType::StepFunctions => "STEP_FUNCTIONS",
            MaintenanceWindowTaskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATION", "LAMBDA", "RUN_COMMAND", "STEP_FUNCTIONS"]
    }
}
impl AsRef<str> for MaintenanceWindowTaskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MaintenanceWindowResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    ResourceGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MaintenanceWindowResourceType {
    fn from(s: &str) -> Self {
        match s {
            "INSTANCE" => MaintenanceWindowResourceType::Instance,
            "RESOURCE_GROUP" => MaintenanceWindowResourceType::ResourceGroup,
            other => MaintenanceWindowResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MaintenanceWindowResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MaintenanceWindowResourceType::from(s))
    }
}
impl MaintenanceWindowResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MaintenanceWindowResourceType::Instance => "INSTANCE",
            MaintenanceWindowResourceType::ResourceGroup => "RESOURCE_GROUP",
            MaintenanceWindowResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSTANCE", "RESOURCE_GROUP"]
    }
}
impl AsRef<str> for MaintenanceWindowResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParameterTier {
    #[allow(missing_docs)] // documentation missing in model
    Advanced,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParameterTier {
    fn from(s: &str) -> Self {
        match s {
            "Advanced" => ParameterTier::Advanced,
            "Intelligent-Tiering" => ParameterTier::IntelligentTiering,
            "Standard" => ParameterTier::Standard,
            other => ParameterTier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParameterTier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParameterTier::from(s))
    }
}
impl ParameterTier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParameterTier::Advanced => "Advanced",
            ParameterTier::IntelligentTiering => "Intelligent-Tiering",
            ParameterTier::Standard => "Standard",
            ParameterTier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Advanced", "Intelligent-Tiering", "Standard"]
    }
}
impl AsRef<str> for ParameterTier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParameterType {
    #[allow(missing_docs)] // documentation missing in model
    SecureString,
    #[allow(missing_docs)] // documentation missing in model
    String,
    #[allow(missing_docs)] // documentation missing in model
    StringList,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParameterType {
    fn from(s: &str) -> Self {
        match s {
            "SecureString" => ParameterType::SecureString,
            "String" => ParameterType::String,
            "StringList" => ParameterType::StringList,
            other => ParameterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParameterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParameterType::from(s))
    }
}
impl ParameterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParameterType::SecureString => "SecureString",
            ParameterType::String => "String",
            ParameterType::StringList => "StringList",
            ParameterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SecureString", "String", "StringList"]
    }
}
impl AsRef<str> for ParameterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information collected from managed instances based on your inventory policy document</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryItem {
    /// <p>The name of the inventory type. Default inventory item type names start with
    /// <code>AWS</code>. Custom inventory type names will start with Custom. Default inventory item
    /// types include the following: <code>AWS:AWSComponent</code>, <code>AWS:Application</code>,
    /// <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and
    /// <code>AWS:WindowsUpdate</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The schema version for the inventory item.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The time the inventory information was collected.</p>
    pub capture_time: std::option::Option<std::string::String>,
    /// <p>MD5 hash of the inventory item type contents. The content hash is used to determine whether
    /// to update inventory information. The PutInventory API doesn't update the inventory item type
    /// contents if the MD5 hash hasn't changed since last update. </p>
    pub content_hash: std::option::Option<std::string::String>,
    /// <p>The inventory data of the inventory type.</p>
    pub content: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
    /// <p>A map of associated properties for a specified inventory type. For example, with this
    /// attribute, you can specify the <code>ExecutionId</code>, <code>ExecutionType</code>,
    /// <code>ComplianceType</code> properties of the <code>AWS:ComplianceItem</code> type.</p>
    pub context:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for InventoryItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryItem");
        formatter.field("type_name", &self.type_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("capture_time", &self.capture_time);
        formatter.field("content_hash", &self.content_hash);
        formatter.field("content", &self.content);
        formatter.field("context", &self.context);
        formatter.finish()
    }
}
/// See [`InventoryItem`](crate::model::InventoryItem)
pub mod inventory_item {
    /// A builder for [`InventoryItem`](crate::model::InventoryItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) capture_time: std::option::Option<std::string::String>,
        pub(crate) content_hash: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
        pub(crate) context: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the inventory type. Default inventory item type names start with
        /// <code>AWS</code>. Custom inventory type names will start with Custom. Default inventory item
        /// types include the following: <code>AWS:AWSComponent</code>, <code>AWS:Application</code>,
        /// <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and
        /// <code>AWS:WindowsUpdate</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the inventory type. Default inventory item type names start with
        /// <code>AWS</code>. Custom inventory type names will start with Custom. Default inventory item
        /// types include the following: <code>AWS:AWSComponent</code>, <code>AWS:Application</code>,
        /// <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and
        /// <code>AWS:WindowsUpdate</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The schema version for the inventory item.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version for the inventory item.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The time the inventory information was collected.</p>
        pub fn capture_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.capture_time = Some(input.into());
            self
        }
        /// <p>The time the inventory information was collected.</p>
        pub fn set_capture_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capture_time = input;
            self
        }
        /// <p>MD5 hash of the inventory item type contents. The content hash is used to determine whether
        /// to update inventory information. The PutInventory API doesn't update the inventory item type
        /// contents if the MD5 hash hasn't changed since last update. </p>
        pub fn content_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_hash = Some(input.into());
            self
        }
        /// <p>MD5 hash of the inventory item type contents. The content hash is used to determine whether
        /// to update inventory information. The PutInventory API doesn't update the inventory item type
        /// contents if the MD5 hash hasn't changed since last update. </p>
        pub fn set_content_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_hash = input;
            self
        }
        /// Appends an item to `content`.
        ///
        /// To override the contents of this collection use [`set_content`](Self::set_content).
        ///
        /// <p>The inventory data of the inventory type.</p>
        pub fn content(
            mut self,
            input: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut v = self.content.unwrap_or_default();
            v.push(input.into());
            self.content = Some(v);
            self
        }
        /// <p>The inventory data of the inventory type.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.content = input;
            self
        }
        /// Adds a key-value pair to `context`.
        ///
        /// To override the contents of this collection use [`set_context`](Self::set_context).
        ///
        /// <p>A map of associated properties for a specified inventory type. For example, with this
        /// attribute, you can specify the <code>ExecutionId</code>, <code>ExecutionType</code>,
        /// <code>ComplianceType</code> properties of the <code>AWS:ComplianceItem</code> type.</p>
        pub fn context(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context = Some(hash_map);
            self
        }
        /// <p>A map of associated properties for a specified inventory type. For example, with this
        /// attribute, you can specify the <code>ExecutionId</code>, <code>ExecutionType</code>,
        /// <code>ComplianceType</code> properties of the <code>AWS:ComplianceItem</code> type.</p>
        pub fn set_context(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryItem`](crate::model::InventoryItem)
        pub fn build(self) -> crate::model::InventoryItem {
            crate::model::InventoryItem {
                type_name: self.type_name,
                schema_version: self.schema_version,
                capture_time: self.capture_time,
                content_hash: self.content_hash,
                content: self.content,
                context: self.context,
            }
        }
    }
}
impl InventoryItem {
    /// Creates a new builder-style object to manufacture [`InventoryItem`](crate::model::InventoryItem)
    pub fn builder() -> crate::model::inventory_item::Builder {
        crate::model::inventory_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComplianceUploadType {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Partial,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComplianceUploadType {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ComplianceUploadType::Complete,
            "PARTIAL" => ComplianceUploadType::Partial,
            other => ComplianceUploadType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComplianceUploadType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComplianceUploadType::from(s))
    }
}
impl ComplianceUploadType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComplianceUploadType::Complete => "COMPLETE",
            ComplianceUploadType::Partial => "PARTIAL",
            ComplianceUploadType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "PARTIAL"]
    }
}
impl AsRef<str> for ComplianceUploadType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a compliance item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceItemEntry {
    /// <p>The compliance item ID. For example, if the compliance item is a Windows patch, the ID could
    /// be the number of the KB article.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The title of the compliance item. For example, if the compliance item is a Windows patch,
    /// the title could be the title of the KB article for the patch; for example: Security Update for
    /// Active Directory Federation Services. </p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The severity of the compliance status. Severity can be one of the following: Critical, High,
    /// Medium, Low, Informational, Unspecified.</p>
    pub severity: std::option::Option<crate::model::ComplianceSeverity>,
    /// <p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>
    pub status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>A "Key": "Value" tag combination for the compliance item.</p>
    pub details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ComplianceItemEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceItemEntry");
        formatter.field("id", &self.id);
        formatter.field("title", &self.title);
        formatter.field("severity", &self.severity);
        formatter.field("status", &self.status);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`ComplianceItemEntry`](crate::model::ComplianceItemEntry)
pub mod compliance_item_entry {
    /// A builder for [`ComplianceItemEntry`](crate::model::ComplianceItemEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::ComplianceSeverity>,
        pub(crate) status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The compliance item ID. For example, if the compliance item is a Windows patch, the ID could
        /// be the number of the KB article.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The compliance item ID. For example, if the compliance item is a Windows patch, the ID could
        /// be the number of the KB article.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The title of the compliance item. For example, if the compliance item is a Windows patch,
        /// the title could be the title of the KB article for the patch; for example: Security Update for
        /// Active Directory Federation Services. </p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the compliance item. For example, if the compliance item is a Windows patch,
        /// the title could be the title of the KB article for the patch; for example: Security Update for
        /// Active Directory Federation Services. </p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The severity of the compliance status. Severity can be one of the following: Critical, High,
        /// Medium, Low, Informational, Unspecified.</p>
        pub fn severity(mut self, input: crate::model::ComplianceSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the compliance status. Severity can be one of the following: Critical, High,
        /// Medium, Low, Informational, Unspecified.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::ComplianceSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>
        pub fn status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p>A "Key": "Value" tag combination for the compliance item.</p>
        pub fn details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.details = Some(hash_map);
            self
        }
        /// <p>A "Key": "Value" tag combination for the compliance item.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceItemEntry`](crate::model::ComplianceItemEntry)
        pub fn build(self) -> crate::model::ComplianceItemEntry {
            crate::model::ComplianceItemEntry {
                id: self.id,
                title: self.title,
                severity: self.severity,
                status: self.status,
                details: self.details,
            }
        }
    }
}
impl ComplianceItemEntry {
    /// Creates a new builder-style object to manufacture [`ComplianceItemEntry`](crate::model::ComplianceItemEntry)
    pub fn builder() -> crate::model::compliance_item_entry::Builder {
        crate::model::compliance_item_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComplianceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Compliant,
    #[allow(missing_docs)] // documentation missing in model
    NonCompliant,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComplianceStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANT" => ComplianceStatus::Compliant,
            "NON_COMPLIANT" => ComplianceStatus::NonCompliant,
            other => ComplianceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComplianceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComplianceStatus::from(s))
    }
}
impl ComplianceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComplianceStatus::Compliant => "COMPLIANT",
            ComplianceStatus::NonCompliant => "NON_COMPLIANT",
            ComplianceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANT", "NON_COMPLIANT"]
    }
}
impl AsRef<str> for ComplianceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComplianceSeverity {
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Informational,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Unspecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComplianceSeverity {
    fn from(s: &str) -> Self {
        match s {
            "CRITICAL" => ComplianceSeverity::Critical,
            "HIGH" => ComplianceSeverity::High,
            "INFORMATIONAL" => ComplianceSeverity::Informational,
            "LOW" => ComplianceSeverity::Low,
            "MEDIUM" => ComplianceSeverity::Medium,
            "UNSPECIFIED" => ComplianceSeverity::Unspecified,
            other => ComplianceSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComplianceSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComplianceSeverity::from(s))
    }
}
impl ComplianceSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComplianceSeverity::Critical => "CRITICAL",
            ComplianceSeverity::High => "HIGH",
            ComplianceSeverity::Informational => "INFORMATIONAL",
            ComplianceSeverity::Low => "LOW",
            ComplianceSeverity::Medium => "MEDIUM",
            ComplianceSeverity::Unspecified => "UNSPECIFIED",
            ComplianceSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CRITICAL",
            "HIGH",
            "INFORMATIONAL",
            "LOW",
            "MEDIUM",
            "UNSPECIFIED",
        ]
    }
}
impl AsRef<str> for ComplianceSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of the call execution that includes an execution ID, the type of execution (for
/// example, <code>Command</code>), and the date/time of the execution using a datetime object that
/// is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceExecutionSummary {
    /// <p>The time the execution ran as a datetime object that is saved in the following format:
    /// yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
    pub execution_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An ID created by the system when <code>PutComplianceItems</code> was called. For example,
    /// <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>The type of execution. For example, <code>Command</code> is a valid execution type.</p>
    pub execution_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ComplianceExecutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceExecutionSummary");
        formatter.field("execution_time", &self.execution_time);
        formatter.field("execution_id", &self.execution_id);
        formatter.field("execution_type", &self.execution_type);
        formatter.finish()
    }
}
/// See [`ComplianceExecutionSummary`](crate::model::ComplianceExecutionSummary)
pub mod compliance_execution_summary {
    /// A builder for [`ComplianceExecutionSummary`](crate::model::ComplianceExecutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) execution_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time the execution ran as a datetime object that is saved in the following format:
        /// yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn execution_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_time = Some(input);
            self
        }
        /// <p>The time the execution ran as a datetime object that is saved in the following format:
        /// yyyy-MM-dd'T'HH:mm:ss'Z'.</p>
        pub fn set_execution_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_time = input;
            self
        }
        /// <p>An ID created by the system when <code>PutComplianceItems</code> was called. For example,
        /// <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>An ID created by the system when <code>PutComplianceItems</code> was called. For example,
        /// <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>The type of execution. For example, <code>Command</code> is a valid execution type.</p>
        pub fn execution_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_type = Some(input.into());
            self
        }
        /// <p>The type of execution. For example, <code>Command</code> is a valid execution type.</p>
        pub fn set_execution_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceExecutionSummary`](crate::model::ComplianceExecutionSummary)
        pub fn build(self) -> crate::model::ComplianceExecutionSummary {
            crate::model::ComplianceExecutionSummary {
                execution_time: self.execution_time,
                execution_id: self.execution_id,
                execution_type: self.execution_type,
            }
        }
    }
}
impl ComplianceExecutionSummary {
    /// Creates a new builder-style object to manufacture [`ComplianceExecutionSummary`](crate::model::ComplianceExecutionSummary)
    pub fn builder() -> crate::model::compliance_execution_summary::Builder {
        crate::model::compliance_execution_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentPermissionType {
    #[allow(missing_docs)] // documentation missing in model
    Share,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentPermissionType {
    fn from(s: &str) -> Self {
        match s {
            "Share" => DocumentPermissionType::Share,
            other => DocumentPermissionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentPermissionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentPermissionType::from(s))
    }
}
impl DocumentPermissionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentPermissionType::Share => "Share",
            DocumentPermissionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Share"]
    }
}
impl AsRef<str> for DocumentPermissionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a resource data sync configuration, including its current status and last
/// successful sync.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncItem {
    /// <p>The name of the resource data sync.</p>
    pub sync_name: std::option::Option<std::string::String>,
    /// <p>The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>,
    /// then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is
    /// <code>SyncFromSource</code> then the resource data sync synchronizes data from Organizations or from
    /// multiple Amazon Web Services Regions.</p>
    pub sync_type: std::option::Option<std::string::String>,
    /// <p>Information about the source where the data was synchronized. </p>
    pub sync_source: std::option::Option<crate::model::ResourceDataSyncSourceWithState>,
    /// <p>Configuration information for the target S3 bucket.</p>
    pub s3_destination: std::option::Option<crate::model::ResourceDataSyncS3Destination>,
    /// <p>The last time the configuration attempted to sync (UTC).</p>
    pub last_sync_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time the sync operations returned a status of <code>SUCCESSFUL</code> (UTC).</p>
    pub last_successful_sync_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time the resource data sync was changed. </p>
    pub sync_last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status reported by the last sync.</p>
    pub last_status: std::option::Option<crate::model::LastResourceDataSyncStatus>,
    /// <p>The date and time the configuration was created (UTC).</p>
    pub sync_created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status message details reported by the last sync.</p>
    pub last_sync_status_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceDataSyncItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncItem");
        formatter.field("sync_name", &self.sync_name);
        formatter.field("sync_type", &self.sync_type);
        formatter.field("sync_source", &self.sync_source);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.field("last_sync_time", &self.last_sync_time);
        formatter.field("last_successful_sync_time", &self.last_successful_sync_time);
        formatter.field("sync_last_modified_time", &self.sync_last_modified_time);
        formatter.field("last_status", &self.last_status);
        formatter.field("sync_created_time", &self.sync_created_time);
        formatter.field("last_sync_status_message", &self.last_sync_status_message);
        formatter.finish()
    }
}
/// See [`ResourceDataSyncItem`](crate::model::ResourceDataSyncItem)
pub mod resource_data_sync_item {
    /// A builder for [`ResourceDataSyncItem`](crate::model::ResourceDataSyncItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sync_name: std::option::Option<std::string::String>,
        pub(crate) sync_type: std::option::Option<std::string::String>,
        pub(crate) sync_source: std::option::Option<crate::model::ResourceDataSyncSourceWithState>,
        pub(crate) s3_destination: std::option::Option<crate::model::ResourceDataSyncS3Destination>,
        pub(crate) last_sync_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_successful_sync_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) sync_last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_status: std::option::Option<crate::model::LastResourceDataSyncStatus>,
        pub(crate) sync_created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_sync_status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource data sync.</p>
        pub fn sync_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_name = Some(input.into());
            self
        }
        /// <p>The name of the resource data sync.</p>
        pub fn set_sync_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_name = input;
            self
        }
        /// <p>The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>,
        /// then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is
        /// <code>SyncFromSource</code> then the resource data sync synchronizes data from Organizations or from
        /// multiple Amazon Web Services Regions.</p>
        pub fn sync_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.sync_type = Some(input.into());
            self
        }
        /// <p>The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>,
        /// then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is
        /// <code>SyncFromSource</code> then the resource data sync synchronizes data from Organizations or from
        /// multiple Amazon Web Services Regions.</p>
        pub fn set_sync_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sync_type = input;
            self
        }
        /// <p>Information about the source where the data was synchronized. </p>
        pub fn sync_source(mut self, input: crate::model::ResourceDataSyncSourceWithState) -> Self {
            self.sync_source = Some(input);
            self
        }
        /// <p>Information about the source where the data was synchronized. </p>
        pub fn set_sync_source(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncSourceWithState>,
        ) -> Self {
            self.sync_source = input;
            self
        }
        /// <p>Configuration information for the target S3 bucket.</p>
        pub fn s3_destination(
            mut self,
            input: crate::model::ResourceDataSyncS3Destination,
        ) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>Configuration information for the target S3 bucket.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncS3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// <p>The last time the configuration attempted to sync (UTC).</p>
        pub fn last_sync_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_sync_time = Some(input);
            self
        }
        /// <p>The last time the configuration attempted to sync (UTC).</p>
        pub fn set_last_sync_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_sync_time = input;
            self
        }
        /// <p>The last time the sync operations returned a status of <code>SUCCESSFUL</code> (UTC).</p>
        pub fn last_successful_sync_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_successful_sync_time = Some(input);
            self
        }
        /// <p>The last time the sync operations returned a status of <code>SUCCESSFUL</code> (UTC).</p>
        pub fn set_last_successful_sync_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_successful_sync_time = input;
            self
        }
        /// <p>The date and time the resource data sync was changed. </p>
        pub fn sync_last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.sync_last_modified_time = Some(input);
            self
        }
        /// <p>The date and time the resource data sync was changed. </p>
        pub fn set_sync_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.sync_last_modified_time = input;
            self
        }
        /// <p>The status reported by the last sync.</p>
        pub fn last_status(mut self, input: crate::model::LastResourceDataSyncStatus) -> Self {
            self.last_status = Some(input);
            self
        }
        /// <p>The status reported by the last sync.</p>
        pub fn set_last_status(
            mut self,
            input: std::option::Option<crate::model::LastResourceDataSyncStatus>,
        ) -> Self {
            self.last_status = input;
            self
        }
        /// <p>The date and time the configuration was created (UTC).</p>
        pub fn sync_created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.sync_created_time = Some(input);
            self
        }
        /// <p>The date and time the configuration was created (UTC).</p>
        pub fn set_sync_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.sync_created_time = input;
            self
        }
        /// <p>The status message details reported by the last sync.</p>
        pub fn last_sync_status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_sync_status_message = Some(input.into());
            self
        }
        /// <p>The status message details reported by the last sync.</p>
        pub fn set_last_sync_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_sync_status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncItem`](crate::model::ResourceDataSyncItem)
        pub fn build(self) -> crate::model::ResourceDataSyncItem {
            crate::model::ResourceDataSyncItem {
                sync_name: self.sync_name,
                sync_type: self.sync_type,
                sync_source: self.sync_source,
                s3_destination: self.s3_destination,
                last_sync_time: self.last_sync_time,
                last_successful_sync_time: self.last_successful_sync_time,
                sync_last_modified_time: self.sync_last_modified_time,
                last_status: self.last_status,
                sync_created_time: self.sync_created_time,
                last_sync_status_message: self.last_sync_status_message,
            }
        }
    }
}
impl ResourceDataSyncItem {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncItem`](crate::model::ResourceDataSyncItem)
    pub fn builder() -> crate::model::resource_data_sync_item::Builder {
        crate::model::resource_data_sync_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LastResourceDataSyncStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inprogress,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LastResourceDataSyncStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => LastResourceDataSyncStatus::Failed,
            "InProgress" => LastResourceDataSyncStatus::Inprogress,
            "Successful" => LastResourceDataSyncStatus::Successful,
            other => LastResourceDataSyncStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LastResourceDataSyncStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LastResourceDataSyncStatus::from(s))
    }
}
impl LastResourceDataSyncStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LastResourceDataSyncStatus::Failed => "Failed",
            LastResourceDataSyncStatus::Inprogress => "InProgress",
            LastResourceDataSyncStatus::Successful => "Successful",
            LastResourceDataSyncStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Successful"]
    }
}
impl AsRef<str> for LastResourceDataSyncStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the target S3 bucket for the resource data sync.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncS3Destination {
    /// <p>The name of the S3 bucket where the aggregated data is stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>An Amazon S3 prefix for the bucket.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A supported sync format. The following format is currently supported: JsonSerDe</p>
    pub sync_format: std::option::Option<crate::model::ResourceDataSyncS3Format>,
    /// <p>The Amazon Web Services Region with the S3 bucket targeted by the resource data sync.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The ARN of an encryption key for a destination in Amazon S3. Must belong to the same
    /// Region as the destination S3 bucket.</p>
    pub awskms_key_arn: std::option::Option<std::string::String>,
    /// <p>Enables destination data sharing. By default, this field is <code>null</code>.</p>
    pub destination_data_sharing:
        std::option::Option<crate::model::ResourceDataSyncDestinationDataSharing>,
}
impl std::fmt::Debug for ResourceDataSyncS3Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncS3Destination");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("prefix", &self.prefix);
        formatter.field("sync_format", &self.sync_format);
        formatter.field("region", &self.region);
        formatter.field("awskms_key_arn", &self.awskms_key_arn);
        formatter.field("destination_data_sharing", &self.destination_data_sharing);
        formatter.finish()
    }
}
/// See [`ResourceDataSyncS3Destination`](crate::model::ResourceDataSyncS3Destination)
pub mod resource_data_sync_s3_destination {
    /// A builder for [`ResourceDataSyncS3Destination`](crate::model::ResourceDataSyncS3Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) sync_format: std::option::Option<crate::model::ResourceDataSyncS3Format>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) awskms_key_arn: std::option::Option<std::string::String>,
        pub(crate) destination_data_sharing:
            std::option::Option<crate::model::ResourceDataSyncDestinationDataSharing>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket where the aggregated data is stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket where the aggregated data is stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>An Amazon S3 prefix for the bucket.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An Amazon S3 prefix for the bucket.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A supported sync format. The following format is currently supported: JsonSerDe</p>
        pub fn sync_format(mut self, input: crate::model::ResourceDataSyncS3Format) -> Self {
            self.sync_format = Some(input);
            self
        }
        /// <p>A supported sync format. The following format is currently supported: JsonSerDe</p>
        pub fn set_sync_format(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncS3Format>,
        ) -> Self {
            self.sync_format = input;
            self
        }
        /// <p>The Amazon Web Services Region with the S3 bucket targeted by the resource data sync.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region with the S3 bucket targeted by the resource data sync.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The ARN of an encryption key for a destination in Amazon S3. Must belong to the same
        /// Region as the destination S3 bucket.</p>
        pub fn awskms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.awskms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an encryption key for a destination in Amazon S3. Must belong to the same
        /// Region as the destination S3 bucket.</p>
        pub fn set_awskms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.awskms_key_arn = input;
            self
        }
        /// <p>Enables destination data sharing. By default, this field is <code>null</code>.</p>
        pub fn destination_data_sharing(
            mut self,
            input: crate::model::ResourceDataSyncDestinationDataSharing,
        ) -> Self {
            self.destination_data_sharing = Some(input);
            self
        }
        /// <p>Enables destination data sharing. By default, this field is <code>null</code>.</p>
        pub fn set_destination_data_sharing(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncDestinationDataSharing>,
        ) -> Self {
            self.destination_data_sharing = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncS3Destination`](crate::model::ResourceDataSyncS3Destination)
        pub fn build(self) -> crate::model::ResourceDataSyncS3Destination {
            crate::model::ResourceDataSyncS3Destination {
                bucket_name: self.bucket_name,
                prefix: self.prefix,
                sync_format: self.sync_format,
                region: self.region,
                awskms_key_arn: self.awskms_key_arn,
                destination_data_sharing: self.destination_data_sharing,
            }
        }
    }
}
impl ResourceDataSyncS3Destination {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncS3Destination`](crate::model::ResourceDataSyncS3Destination)
    pub fn builder() -> crate::model::resource_data_sync_s3_destination::Builder {
        crate::model::resource_data_sync_s3_destination::Builder::default()
    }
}

/// <p>Synchronize Amazon Web Services Systems Manager Inventory data from multiple Amazon Web Services accounts defined in Organizations to a
/// centralized Amazon S3 bucket. Data is synchronized to individual key prefixes in the
/// central bucket. Each key prefix represents a different Amazon Web Services account ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncDestinationDataSharing {
    /// <p>The sharing data type. Only <code>Organization</code> is supported.</p>
    pub destination_data_sharing_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceDataSyncDestinationDataSharing {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncDestinationDataSharing");
        formatter.field(
            "destination_data_sharing_type",
            &self.destination_data_sharing_type,
        );
        formatter.finish()
    }
}
/// See [`ResourceDataSyncDestinationDataSharing`](crate::model::ResourceDataSyncDestinationDataSharing)
pub mod resource_data_sync_destination_data_sharing {
    /// A builder for [`ResourceDataSyncDestinationDataSharing`](crate::model::ResourceDataSyncDestinationDataSharing)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_data_sharing_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The sharing data type. Only <code>Organization</code> is supported.</p>
        pub fn destination_data_sharing_type(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_data_sharing_type = Some(input.into());
            self
        }
        /// <p>The sharing data type. Only <code>Organization</code> is supported.</p>
        pub fn set_destination_data_sharing_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_data_sharing_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncDestinationDataSharing`](crate::model::ResourceDataSyncDestinationDataSharing)
        pub fn build(self) -> crate::model::ResourceDataSyncDestinationDataSharing {
            crate::model::ResourceDataSyncDestinationDataSharing {
                destination_data_sharing_type: self.destination_data_sharing_type,
            }
        }
    }
}
impl ResourceDataSyncDestinationDataSharing {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncDestinationDataSharing`](crate::model::ResourceDataSyncDestinationDataSharing)
    pub fn builder() -> crate::model::resource_data_sync_destination_data_sharing::Builder {
        crate::model::resource_data_sync_destination_data_sharing::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceDataSyncS3Format {
    #[allow(missing_docs)] // documentation missing in model
    JsonSerde,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceDataSyncS3Format {
    fn from(s: &str) -> Self {
        match s {
            "JsonSerDe" => ResourceDataSyncS3Format::JsonSerde,
            other => ResourceDataSyncS3Format::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceDataSyncS3Format {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceDataSyncS3Format::from(s))
    }
}
impl ResourceDataSyncS3Format {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceDataSyncS3Format::JsonSerde => "JsonSerDe",
            ResourceDataSyncS3Format::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JsonSerDe"]
    }
}
impl AsRef<str> for ResourceDataSyncS3Format {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The data type name for including resource data sync state. There are four sync
/// states:</p>
/// <p>
/// <code>OrganizationNotExists</code> (Your organization doesn't exist)</p>
/// <p>
/// <code>NoPermissions</code> (The system can't locate the service-linked role. This role is
/// automatically created when a user creates a resource data sync in Amazon Web Services Systems Manager Explorer.)</p>
/// <p>
/// <code>InvalidOrganizationalUnit</code> (You specified or selected an invalid unit in the
/// resource data sync configuration.)</p>
/// <p>
/// <code>TrustedAccessDisabled</code> (You disabled Systems Manager access in the organization in
/// Organizations.)</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataSyncSourceWithState {
    /// <p>The type of data source for the resource data sync. <code>SourceType</code> is either
    /// <code>AwsOrganizations</code> (if an organization is present in Organizations) or
    /// <code>singleAccountMultiRegions</code>.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The field name in <code>SyncSource</code> for the
    /// <code>ResourceDataSyncAwsOrganizationsSource</code> type.</p>
    pub aws_organizations_source:
        std::option::Option<crate::model::ResourceDataSyncAwsOrganizationsSource>,
    /// <p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>
    pub source_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those
    /// Regions come online.</p>
    pub include_future_regions: bool,
    /// <p>The data type name for including resource data sync state. There are four sync
    /// states:</p>
    /// <p>
    /// <code>OrganizationNotExists</code>: Your organization doesn't exist.</p>
    /// <p>
    /// <code>NoPermissions</code>: The system can't locate the service-linked role. This role is
    /// automatically created when a user creates a resource data sync in Explorer.</p>
    /// <p>
    /// <code>InvalidOrganizationalUnit</code>: You specified or selected an invalid unit in the
    /// resource data sync configuration.</p>
    /// <p>
    /// <code>TrustedAccessDisabled</code>: You disabled Systems Manager access in the organization in
    /// Organizations.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager
    /// automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in
    /// your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the
    /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub enable_all_ops_data_sources: bool,
}
impl std::fmt::Debug for ResourceDataSyncSourceWithState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataSyncSourceWithState");
        formatter.field("source_type", &self.source_type);
        formatter.field("aws_organizations_source", &self.aws_organizations_source);
        formatter.field("source_regions", &self.source_regions);
        formatter.field("include_future_regions", &self.include_future_regions);
        formatter.field("state", &self.state);
        formatter.field(
            "enable_all_ops_data_sources",
            &self.enable_all_ops_data_sources,
        );
        formatter.finish()
    }
}
/// See [`ResourceDataSyncSourceWithState`](crate::model::ResourceDataSyncSourceWithState)
pub mod resource_data_sync_source_with_state {
    /// A builder for [`ResourceDataSyncSourceWithState`](crate::model::ResourceDataSyncSourceWithState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) aws_organizations_source:
            std::option::Option<crate::model::ResourceDataSyncAwsOrganizationsSource>,
        pub(crate) source_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include_future_regions: std::option::Option<bool>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) enable_all_ops_data_sources: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The type of data source for the resource data sync. <code>SourceType</code> is either
        /// <code>AwsOrganizations</code> (if an organization is present in Organizations) or
        /// <code>singleAccountMultiRegions</code>.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of data source for the resource data sync. <code>SourceType</code> is either
        /// <code>AwsOrganizations</code> (if an organization is present in Organizations) or
        /// <code>singleAccountMultiRegions</code>.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The field name in <code>SyncSource</code> for the
        /// <code>ResourceDataSyncAwsOrganizationsSource</code> type.</p>
        pub fn aws_organizations_source(
            mut self,
            input: crate::model::ResourceDataSyncAwsOrganizationsSource,
        ) -> Self {
            self.aws_organizations_source = Some(input);
            self
        }
        /// <p>The field name in <code>SyncSource</code> for the
        /// <code>ResourceDataSyncAwsOrganizationsSource</code> type.</p>
        pub fn set_aws_organizations_source(
            mut self,
            input: std::option::Option<crate::model::ResourceDataSyncAwsOrganizationsSource>,
        ) -> Self {
            self.aws_organizations_source = input;
            self
        }
        /// Appends an item to `source_regions`.
        ///
        /// To override the contents of this collection use [`set_source_regions`](Self::set_source_regions).
        ///
        /// <p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>
        pub fn source_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_regions.unwrap_or_default();
            v.push(input.into());
            self.source_regions = Some(v);
            self
        }
        /// <p>The <code>SyncSource</code> Amazon Web Services Regions included in the resource data sync.</p>
        pub fn set_source_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_regions = input;
            self
        }
        /// <p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those
        /// Regions come online.</p>
        pub fn include_future_regions(mut self, input: bool) -> Self {
            self.include_future_regions = Some(input);
            self
        }
        /// <p>Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those
        /// Regions come online.</p>
        pub fn set_include_future_regions(mut self, input: std::option::Option<bool>) -> Self {
            self.include_future_regions = input;
            self
        }
        /// <p>The data type name for including resource data sync state. There are four sync
        /// states:</p>
        /// <p>
        /// <code>OrganizationNotExists</code>: Your organization doesn't exist.</p>
        /// <p>
        /// <code>NoPermissions</code>: The system can't locate the service-linked role. This role is
        /// automatically created when a user creates a resource data sync in Explorer.</p>
        /// <p>
        /// <code>InvalidOrganizationalUnit</code>: You specified or selected an invalid unit in the
        /// resource data sync configuration.</p>
        /// <p>
        /// <code>TrustedAccessDisabled</code>: You disabled Systems Manager access in the organization in
        /// Organizations.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The data type name for including resource data sync state. There are four sync
        /// states:</p>
        /// <p>
        /// <code>OrganizationNotExists</code>: Your organization doesn't exist.</p>
        /// <p>
        /// <code>NoPermissions</code>: The system can't locate the service-linked role. This role is
        /// automatically created when a user creates a resource data sync in Explorer.</p>
        /// <p>
        /// <code>InvalidOrganizationalUnit</code>: You specified or selected an invalid unit in the
        /// resource data sync configuration.</p>
        /// <p>
        /// <code>TrustedAccessDisabled</code>: You disabled Systems Manager access in the organization in
        /// Organizations.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager
        /// automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in
        /// your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn enable_all_ops_data_sources(mut self, input: bool) -> Self {
            self.enable_all_ops_data_sources = Some(input);
            self
        }
        /// <p>When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager
        /// automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in
        /// your organization (or in the selected organization units). For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html">About multiple account and Region resource data syncs</a> in the
        /// <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_enable_all_ops_data_sources(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_all_ops_data_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataSyncSourceWithState`](crate::model::ResourceDataSyncSourceWithState)
        pub fn build(self) -> crate::model::ResourceDataSyncSourceWithState {
            crate::model::ResourceDataSyncSourceWithState {
                source_type: self.source_type,
                aws_organizations_source: self.aws_organizations_source,
                source_regions: self.source_regions,
                include_future_regions: self.include_future_regions.unwrap_or_default(),
                state: self.state,
                enable_all_ops_data_sources: self.enable_all_ops_data_sources.unwrap_or_default(),
            }
        }
    }
}
impl ResourceDataSyncSourceWithState {
    /// Creates a new builder-style object to manufacture [`ResourceDataSyncSourceWithState`](crate::model::ResourceDataSyncSourceWithState)
    pub fn builder() -> crate::model::resource_data_sync_source_with_state::Builder {
        crate::model::resource_data_sync_source_with_state::Builder::default()
    }
}

/// <p>Compliance summary information for a specific resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceComplianceSummaryItem {
    /// <p>The compliance type.</p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The resource ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The compliance status for the resource.</p>
    pub status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>The highest severity item found for the resource. The resource is compliant for this
    /// item.</p>
    pub overall_severity: std::option::Option<crate::model::ComplianceSeverity>,
    /// <p>Information about the execution.</p>
    pub execution_summary: std::option::Option<crate::model::ComplianceExecutionSummary>,
    /// <p>A list of items that are compliant for the resource.</p>
    pub compliant_summary: std::option::Option<crate::model::CompliantSummary>,
    /// <p>A list of items that aren't compliant for the resource.</p>
    pub non_compliant_summary: std::option::Option<crate::model::NonCompliantSummary>,
}
impl std::fmt::Debug for ResourceComplianceSummaryItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceComplianceSummaryItem");
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("status", &self.status);
        formatter.field("overall_severity", &self.overall_severity);
        formatter.field("execution_summary", &self.execution_summary);
        formatter.field("compliant_summary", &self.compliant_summary);
        formatter.field("non_compliant_summary", &self.non_compliant_summary);
        formatter.finish()
    }
}
/// See [`ResourceComplianceSummaryItem`](crate::model::ResourceComplianceSummaryItem)
pub mod resource_compliance_summary_item {
    /// A builder for [`ResourceComplianceSummaryItem`](crate::model::ResourceComplianceSummaryItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) overall_severity: std::option::Option<crate::model::ComplianceSeverity>,
        pub(crate) execution_summary: std::option::Option<crate::model::ComplianceExecutionSummary>,
        pub(crate) compliant_summary: std::option::Option<crate::model::CompliantSummary>,
        pub(crate) non_compliant_summary: std::option::Option<crate::model::NonCompliantSummary>,
    }
    impl Builder {
        /// <p>The compliance type.</p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p>The compliance type.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The resource ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The compliance status for the resource.</p>
        pub fn status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The compliance status for the resource.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The highest severity item found for the resource. The resource is compliant for this
        /// item.</p>
        pub fn overall_severity(mut self, input: crate::model::ComplianceSeverity) -> Self {
            self.overall_severity = Some(input);
            self
        }
        /// <p>The highest severity item found for the resource. The resource is compliant for this
        /// item.</p>
        pub fn set_overall_severity(
            mut self,
            input: std::option::Option<crate::model::ComplianceSeverity>,
        ) -> Self {
            self.overall_severity = input;
            self
        }
        /// <p>Information about the execution.</p>
        pub fn execution_summary(
            mut self,
            input: crate::model::ComplianceExecutionSummary,
        ) -> Self {
            self.execution_summary = Some(input);
            self
        }
        /// <p>Information about the execution.</p>
        pub fn set_execution_summary(
            mut self,
            input: std::option::Option<crate::model::ComplianceExecutionSummary>,
        ) -> Self {
            self.execution_summary = input;
            self
        }
        /// <p>A list of items that are compliant for the resource.</p>
        pub fn compliant_summary(mut self, input: crate::model::CompliantSummary) -> Self {
            self.compliant_summary = Some(input);
            self
        }
        /// <p>A list of items that are compliant for the resource.</p>
        pub fn set_compliant_summary(
            mut self,
            input: std::option::Option<crate::model::CompliantSummary>,
        ) -> Self {
            self.compliant_summary = input;
            self
        }
        /// <p>A list of items that aren't compliant for the resource.</p>
        pub fn non_compliant_summary(mut self, input: crate::model::NonCompliantSummary) -> Self {
            self.non_compliant_summary = Some(input);
            self
        }
        /// <p>A list of items that aren't compliant for the resource.</p>
        pub fn set_non_compliant_summary(
            mut self,
            input: std::option::Option<crate::model::NonCompliantSummary>,
        ) -> Self {
            self.non_compliant_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceComplianceSummaryItem`](crate::model::ResourceComplianceSummaryItem)
        pub fn build(self) -> crate::model::ResourceComplianceSummaryItem {
            crate::model::ResourceComplianceSummaryItem {
                compliance_type: self.compliance_type,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                status: self.status,
                overall_severity: self.overall_severity,
                execution_summary: self.execution_summary,
                compliant_summary: self.compliant_summary,
                non_compliant_summary: self.non_compliant_summary,
            }
        }
    }
}
impl ResourceComplianceSummaryItem {
    /// Creates a new builder-style object to manufacture [`ResourceComplianceSummaryItem`](crate::model::ResourceComplianceSummaryItem)
    pub fn builder() -> crate::model::resource_compliance_summary_item::Builder {
        crate::model::resource_compliance_summary_item::Builder::default()
    }
}

/// <p>A summary of resources that aren't compliant. The summary is organized according to resource
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NonCompliantSummary {
    /// <p>The total number of compliance items that aren't compliant.</p>
    pub non_compliant_count: i32,
    /// <p>A summary of the non-compliance severity by compliance type</p>
    pub severity_summary: std::option::Option<crate::model::SeveritySummary>,
}
impl std::fmt::Debug for NonCompliantSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NonCompliantSummary");
        formatter.field("non_compliant_count", &self.non_compliant_count);
        formatter.field("severity_summary", &self.severity_summary);
        formatter.finish()
    }
}
/// See [`NonCompliantSummary`](crate::model::NonCompliantSummary)
pub mod non_compliant_summary {
    /// A builder for [`NonCompliantSummary`](crate::model::NonCompliantSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) non_compliant_count: std::option::Option<i32>,
        pub(crate) severity_summary: std::option::Option<crate::model::SeveritySummary>,
    }
    impl Builder {
        /// <p>The total number of compliance items that aren't compliant.</p>
        pub fn non_compliant_count(mut self, input: i32) -> Self {
            self.non_compliant_count = Some(input);
            self
        }
        /// <p>The total number of compliance items that aren't compliant.</p>
        pub fn set_non_compliant_count(mut self, input: std::option::Option<i32>) -> Self {
            self.non_compliant_count = input;
            self
        }
        /// <p>A summary of the non-compliance severity by compliance type</p>
        pub fn severity_summary(mut self, input: crate::model::SeveritySummary) -> Self {
            self.severity_summary = Some(input);
            self
        }
        /// <p>A summary of the non-compliance severity by compliance type</p>
        pub fn set_severity_summary(
            mut self,
            input: std::option::Option<crate::model::SeveritySummary>,
        ) -> Self {
            self.severity_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`NonCompliantSummary`](crate::model::NonCompliantSummary)
        pub fn build(self) -> crate::model::NonCompliantSummary {
            crate::model::NonCompliantSummary {
                non_compliant_count: self.non_compliant_count.unwrap_or_default(),
                severity_summary: self.severity_summary,
            }
        }
    }
}
impl NonCompliantSummary {
    /// Creates a new builder-style object to manufacture [`NonCompliantSummary`](crate::model::NonCompliantSummary)
    pub fn builder() -> crate::model::non_compliant_summary::Builder {
        crate::model::non_compliant_summary::Builder::default()
    }
}

/// <p>The number of managed instances found for each patch severity level defined in the request
/// filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SeveritySummary {
    /// <p>The total number of resources or compliance items that have a severity level of critical.
    /// Critical severity is determined by the organization that published the compliance items.</p>
    pub critical_count: i32,
    /// <p>The total number of resources or compliance items that have a severity level of high. High
    /// severity is determined by the organization that published the compliance items.</p>
    pub high_count: i32,
    /// <p>The total number of resources or compliance items that have a severity level of medium.
    /// Medium severity is determined by the organization that published the compliance items.</p>
    pub medium_count: i32,
    /// <p>The total number of resources or compliance items that have a severity level of low. Low
    /// severity is determined by the organization that published the compliance items.</p>
    pub low_count: i32,
    /// <p>The total number of resources or compliance items that have a severity level of
    /// informational. Informational severity is determined by the organization that published the
    /// compliance items.</p>
    pub informational_count: i32,
    /// <p>The total number of resources or compliance items that have a severity level of unspecified.
    /// Unspecified severity is determined by the organization that published the compliance
    /// items.</p>
    pub unspecified_count: i32,
}
impl std::fmt::Debug for SeveritySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SeveritySummary");
        formatter.field("critical_count", &self.critical_count);
        formatter.field("high_count", &self.high_count);
        formatter.field("medium_count", &self.medium_count);
        formatter.field("low_count", &self.low_count);
        formatter.field("informational_count", &self.informational_count);
        formatter.field("unspecified_count", &self.unspecified_count);
        formatter.finish()
    }
}
/// See [`SeveritySummary`](crate::model::SeveritySummary)
pub mod severity_summary {
    /// A builder for [`SeveritySummary`](crate::model::SeveritySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) critical_count: std::option::Option<i32>,
        pub(crate) high_count: std::option::Option<i32>,
        pub(crate) medium_count: std::option::Option<i32>,
        pub(crate) low_count: std::option::Option<i32>,
        pub(crate) informational_count: std::option::Option<i32>,
        pub(crate) unspecified_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The total number of resources or compliance items that have a severity level of critical.
        /// Critical severity is determined by the organization that published the compliance items.</p>
        pub fn critical_count(mut self, input: i32) -> Self {
            self.critical_count = Some(input);
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of critical.
        /// Critical severity is determined by the organization that published the compliance items.</p>
        pub fn set_critical_count(mut self, input: std::option::Option<i32>) -> Self {
            self.critical_count = input;
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of high. High
        /// severity is determined by the organization that published the compliance items.</p>
        pub fn high_count(mut self, input: i32) -> Self {
            self.high_count = Some(input);
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of high. High
        /// severity is determined by the organization that published the compliance items.</p>
        pub fn set_high_count(mut self, input: std::option::Option<i32>) -> Self {
            self.high_count = input;
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of medium.
        /// Medium severity is determined by the organization that published the compliance items.</p>
        pub fn medium_count(mut self, input: i32) -> Self {
            self.medium_count = Some(input);
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of medium.
        /// Medium severity is determined by the organization that published the compliance items.</p>
        pub fn set_medium_count(mut self, input: std::option::Option<i32>) -> Self {
            self.medium_count = input;
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of low. Low
        /// severity is determined by the organization that published the compliance items.</p>
        pub fn low_count(mut self, input: i32) -> Self {
            self.low_count = Some(input);
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of low. Low
        /// severity is determined by the organization that published the compliance items.</p>
        pub fn set_low_count(mut self, input: std::option::Option<i32>) -> Self {
            self.low_count = input;
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of
        /// informational. Informational severity is determined by the organization that published the
        /// compliance items.</p>
        pub fn informational_count(mut self, input: i32) -> Self {
            self.informational_count = Some(input);
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of
        /// informational. Informational severity is determined by the organization that published the
        /// compliance items.</p>
        pub fn set_informational_count(mut self, input: std::option::Option<i32>) -> Self {
            self.informational_count = input;
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of unspecified.
        /// Unspecified severity is determined by the organization that published the compliance
        /// items.</p>
        pub fn unspecified_count(mut self, input: i32) -> Self {
            self.unspecified_count = Some(input);
            self
        }
        /// <p>The total number of resources or compliance items that have a severity level of unspecified.
        /// Unspecified severity is determined by the organization that published the compliance
        /// items.</p>
        pub fn set_unspecified_count(mut self, input: std::option::Option<i32>) -> Self {
            self.unspecified_count = input;
            self
        }
        /// Consumes the builder and constructs a [`SeveritySummary`](crate::model::SeveritySummary)
        pub fn build(self) -> crate::model::SeveritySummary {
            crate::model::SeveritySummary {
                critical_count: self.critical_count.unwrap_or_default(),
                high_count: self.high_count.unwrap_or_default(),
                medium_count: self.medium_count.unwrap_or_default(),
                low_count: self.low_count.unwrap_or_default(),
                informational_count: self.informational_count.unwrap_or_default(),
                unspecified_count: self.unspecified_count.unwrap_or_default(),
            }
        }
    }
}
impl SeveritySummary {
    /// Creates a new builder-style object to manufacture [`SeveritySummary`](crate::model::SeveritySummary)
    pub fn builder() -> crate::model::severity_summary::Builder {
        crate::model::severity_summary::Builder::default()
    }
}

/// <p>A summary of resources that are compliant. The summary is organized according to the
/// resource count for each compliance type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompliantSummary {
    /// <p>The total number of resources that are compliant.</p>
    pub compliant_count: i32,
    /// <p>A summary of the compliance severity by compliance type.</p>
    pub severity_summary: std::option::Option<crate::model::SeveritySummary>,
}
impl std::fmt::Debug for CompliantSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompliantSummary");
        formatter.field("compliant_count", &self.compliant_count);
        formatter.field("severity_summary", &self.severity_summary);
        formatter.finish()
    }
}
/// See [`CompliantSummary`](crate::model::CompliantSummary)
pub mod compliant_summary {
    /// A builder for [`CompliantSummary`](crate::model::CompliantSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliant_count: std::option::Option<i32>,
        pub(crate) severity_summary: std::option::Option<crate::model::SeveritySummary>,
    }
    impl Builder {
        /// <p>The total number of resources that are compliant.</p>
        pub fn compliant_count(mut self, input: i32) -> Self {
            self.compliant_count = Some(input);
            self
        }
        /// <p>The total number of resources that are compliant.</p>
        pub fn set_compliant_count(mut self, input: std::option::Option<i32>) -> Self {
            self.compliant_count = input;
            self
        }
        /// <p>A summary of the compliance severity by compliance type.</p>
        pub fn severity_summary(mut self, input: crate::model::SeveritySummary) -> Self {
            self.severity_summary = Some(input);
            self
        }
        /// <p>A summary of the compliance severity by compliance type.</p>
        pub fn set_severity_summary(
            mut self,
            input: std::option::Option<crate::model::SeveritySummary>,
        ) -> Self {
            self.severity_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CompliantSummary`](crate::model::CompliantSummary)
        pub fn build(self) -> crate::model::CompliantSummary {
            crate::model::CompliantSummary {
                compliant_count: self.compliant_count.unwrap_or_default(),
                severity_summary: self.severity_summary,
            }
        }
    }
}
impl CompliantSummary {
    /// Creates a new builder-style object to manufacture [`CompliantSummary`](crate::model::CompliantSummary)
    pub fn builder() -> crate::model::compliant_summary::Builder {
        crate::model::compliant_summary::Builder::default()
    }
}

/// <p>One or more filters. Use a filter to return a more specific list of results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceStringFilter {
    /// <p>The name of the filter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for which to search.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith,
    /// LessThan, or GreaterThan.</p>
    pub r#type: std::option::Option<crate::model::ComplianceQueryOperatorType>,
}
impl std::fmt::Debug for ComplianceStringFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceStringFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ComplianceStringFilter`](crate::model::ComplianceStringFilter)
pub mod compliance_string_filter {
    /// A builder for [`ComplianceStringFilter`](crate::model::ComplianceStringFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::ComplianceQueryOperatorType>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value for which to search.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value for which to search.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith,
        /// LessThan, or GreaterThan.</p>
        pub fn r#type(mut self, input: crate::model::ComplianceQueryOperatorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith,
        /// LessThan, or GreaterThan.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ComplianceQueryOperatorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceStringFilter`](crate::model::ComplianceStringFilter)
        pub fn build(self) -> crate::model::ComplianceStringFilter {
            crate::model::ComplianceStringFilter {
                key: self.key,
                values: self.values,
                r#type: self.r#type,
            }
        }
    }
}
impl ComplianceStringFilter {
    /// Creates a new builder-style object to manufacture [`ComplianceStringFilter`](crate::model::ComplianceStringFilter)
    pub fn builder() -> crate::model::compliance_string_filter::Builder {
        crate::model::compliance_string_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComplianceQueryOperatorType {
    #[allow(missing_docs)] // documentation missing in model
    BeginWith,
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    NotEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComplianceQueryOperatorType {
    fn from(s: &str) -> Self {
        match s {
            "BEGIN_WITH" => ComplianceQueryOperatorType::BeginWith,
            "EQUAL" => ComplianceQueryOperatorType::Equal,
            "GREATER_THAN" => ComplianceQueryOperatorType::GreaterThan,
            "LESS_THAN" => ComplianceQueryOperatorType::LessThan,
            "NOT_EQUAL" => ComplianceQueryOperatorType::NotEqual,
            other => ComplianceQueryOperatorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComplianceQueryOperatorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComplianceQueryOperatorType::from(s))
    }
}
impl ComplianceQueryOperatorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComplianceQueryOperatorType::BeginWith => "BEGIN_WITH",
            ComplianceQueryOperatorType::Equal => "EQUAL",
            ComplianceQueryOperatorType::GreaterThan => "GREATER_THAN",
            ComplianceQueryOperatorType::LessThan => "LESS_THAN",
            ComplianceQueryOperatorType::NotEqual => "NOT_EQUAL",
            ComplianceQueryOperatorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BEGIN_WITH",
            "EQUAL",
            "GREATER_THAN",
            "LESS_THAN",
            "NOT_EQUAL",
        ]
    }
}
impl AsRef<str> for ComplianceQueryOperatorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Operational metadata for an application in Application Manager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsMetadata {
    /// <p>The ID of the Application Manager application.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.</p>
    pub ops_metadata_arn: std::option::Option<std::string::String>,
    /// <p>The date the OpsMetadata object was last updated.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user name who last updated the OpsMetadata object.</p>
    pub last_modified_user: std::option::Option<std::string::String>,
    /// <p>The date the OpsMetadata objects was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for OpsMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsMetadata");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("ops_metadata_arn", &self.ops_metadata_arn);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_user", &self.last_modified_user);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`OpsMetadata`](crate::model::OpsMetadata)
pub mod ops_metadata {
    /// A builder for [`OpsMetadata`](crate::model::OpsMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) ops_metadata_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_user: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the Application Manager application.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Application Manager application.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.</p>
        pub fn ops_metadata_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_metadata_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.</p>
        pub fn set_ops_metadata_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_metadata_arn = input;
            self
        }
        /// <p>The date the OpsMetadata object was last updated.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the OpsMetadata object was last updated.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The user name who last updated the OpsMetadata object.</p>
        pub fn last_modified_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_user = Some(input.into());
            self
        }
        /// <p>The user name who last updated the OpsMetadata object.</p>
        pub fn set_last_modified_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_user = input;
            self
        }
        /// <p>The date the OpsMetadata objects was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the OpsMetadata objects was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsMetadata`](crate::model::OpsMetadata)
        pub fn build(self) -> crate::model::OpsMetadata {
            crate::model::OpsMetadata {
                resource_id: self.resource_id,
                ops_metadata_arn: self.ops_metadata_arn,
                last_modified_date: self.last_modified_date,
                last_modified_user: self.last_modified_user,
                creation_date: self.creation_date,
            }
        }
    }
}
impl OpsMetadata {
    /// Creates a new builder-style object to manufacture [`OpsMetadata`](crate::model::OpsMetadata)
    pub fn builder() -> crate::model::ops_metadata::Builder {
        crate::model::ops_metadata::Builder::default()
    }
}

/// <p>A filter to limit the number of OpsMetadata objects displayed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsMetadataFilter {
    /// <p>A filter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A filter value.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for OpsMetadataFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsMetadataFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`OpsMetadataFilter`](crate::model::OpsMetadataFilter)
pub mod ops_metadata_filter {
    /// A builder for [`OpsMetadataFilter`](crate::model::OpsMetadataFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A filter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A filter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A filter value.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A filter value.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsMetadataFilter`](crate::model::OpsMetadataFilter)
        pub fn build(self) -> crate::model::OpsMetadataFilter {
            crate::model::OpsMetadataFilter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl OpsMetadataFilter {
    /// Creates a new builder-style object to manufacture [`OpsMetadataFilter`](crate::model::OpsMetadataFilter)
    pub fn builder() -> crate::model::ops_metadata_filter::Builder {
        crate::model::ops_metadata_filter::Builder::default()
    }
}

/// <p>Summary information about related-item resources for an OpsItem.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemRelatedItemSummary {
    /// <p>The OpsItem ID.</p>
    pub ops_item_id: std::option::Option<std::string::String>,
    /// <p>The association ID.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The association type.</p>
    pub association_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the related-item resource.</p>
    pub resource_uri: std::option::Option<std::string::String>,
    /// <p>Information about the user or resource that created an OpsItem event.</p>
    pub created_by: std::option::Option<crate::model::OpsItemIdentity>,
    /// <p>The time the related-item association was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Information about the user or resource that created an OpsItem event.</p>
    pub last_modified_by: std::option::Option<crate::model::OpsItemIdentity>,
    /// <p>The time the related-item association was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for OpsItemRelatedItemSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemRelatedItemSummary");
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.field("association_id", &self.association_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("association_type", &self.association_type);
        formatter.field("resource_uri", &self.resource_uri);
        formatter.field("created_by", &self.created_by);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`OpsItemRelatedItemSummary`](crate::model::OpsItemRelatedItemSummary)
pub mod ops_item_related_item_summary {
    /// A builder for [`OpsItemRelatedItemSummary`](crate::model::OpsItemRelatedItemSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) association_type: std::option::Option<std::string::String>,
        pub(crate) resource_uri: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::OpsItemIdentity>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<crate::model::OpsItemIdentity>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The OpsItem ID.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The OpsItem ID.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// <p>The association ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The association ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The association type.</p>
        pub fn association_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_type = Some(input.into());
            self
        }
        /// <p>The association type.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the related-item resource.</p>
        pub fn resource_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_uri = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the related-item resource.</p>
        pub fn set_resource_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_uri = input;
            self
        }
        /// <p>Information about the user or resource that created an OpsItem event.</p>
        pub fn created_by(mut self, input: crate::model::OpsItemIdentity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user or resource that created an OpsItem event.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::OpsItemIdentity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The time the related-item association was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time the related-item association was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Information about the user or resource that created an OpsItem event.</p>
        pub fn last_modified_by(mut self, input: crate::model::OpsItemIdentity) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user or resource that created an OpsItem event.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::OpsItemIdentity>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The time the related-item association was last updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time the related-item association was last updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemRelatedItemSummary`](crate::model::OpsItemRelatedItemSummary)
        pub fn build(self) -> crate::model::OpsItemRelatedItemSummary {
            crate::model::OpsItemRelatedItemSummary {
                ops_item_id: self.ops_item_id,
                association_id: self.association_id,
                resource_type: self.resource_type,
                association_type: self.association_type,
                resource_uri: self.resource_uri,
                created_by: self.created_by,
                created_time: self.created_time,
                last_modified_by: self.last_modified_by,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl OpsItemRelatedItemSummary {
    /// Creates a new builder-style object to manufacture [`OpsItemRelatedItemSummary`](crate::model::OpsItemRelatedItemSummary)
    pub fn builder() -> crate::model::ops_item_related_item_summary::Builder {
        crate::model::ops_item_related_item_summary::Builder::default()
    }
}

/// <p>Information about the user or resource that created an OpsItem event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemIdentity {
    /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem
    /// event.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsItemIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemIdentity");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`OpsItemIdentity`](crate::model::OpsItemIdentity)
pub mod ops_item_identity {
    /// A builder for [`OpsItemIdentity`](crate::model::OpsItemIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem
        /// event.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem
        /// event.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemIdentity`](crate::model::OpsItemIdentity)
        pub fn build(self) -> crate::model::OpsItemIdentity {
            crate::model::OpsItemIdentity { arn: self.arn }
        }
    }
}
impl OpsItemIdentity {
    /// Creates a new builder-style object to manufacture [`OpsItemIdentity`](crate::model::OpsItemIdentity)
    pub fn builder() -> crate::model::ops_item_identity::Builder {
        crate::model::ops_item_identity::Builder::default()
    }
}

/// <p>Describes a filter for a specific list of related-item resources. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemRelatedItemsFilter {
    /// <p>The name of the filter key. Supported values include <code>ResourceUri</code>,
    /// <code>ResourceType</code>, or <code>AssociationId</code>.</p>
    pub key: std::option::Option<crate::model::OpsItemRelatedItemsFilterKey>,
    /// <p>The values for the filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator used by the filter call. The only supported operator is
    /// <code>EQUAL</code>.</p>
    pub operator: std::option::Option<crate::model::OpsItemRelatedItemsFilterOperator>,
}
impl std::fmt::Debug for OpsItemRelatedItemsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemRelatedItemsFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`OpsItemRelatedItemsFilter`](crate::model::OpsItemRelatedItemsFilter)
pub mod ops_item_related_items_filter {
    /// A builder for [`OpsItemRelatedItemsFilter`](crate::model::OpsItemRelatedItemsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::OpsItemRelatedItemsFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::OpsItemRelatedItemsFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the filter key. Supported values include <code>ResourceUri</code>,
        /// <code>ResourceType</code>, or <code>AssociationId</code>.</p>
        pub fn key(mut self, input: crate::model::OpsItemRelatedItemsFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter key. Supported values include <code>ResourceUri</code>,
        /// <code>ResourceType</code>, or <code>AssociationId</code>.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::OpsItemRelatedItemsFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values for the filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values for the filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator used by the filter call. The only supported operator is
        /// <code>EQUAL</code>.</p>
        pub fn operator(mut self, input: crate::model::OpsItemRelatedItemsFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator used by the filter call. The only supported operator is
        /// <code>EQUAL</code>.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::OpsItemRelatedItemsFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemRelatedItemsFilter`](crate::model::OpsItemRelatedItemsFilter)
        pub fn build(self) -> crate::model::OpsItemRelatedItemsFilter {
            crate::model::OpsItemRelatedItemsFilter {
                key: self.key,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl OpsItemRelatedItemsFilter {
    /// Creates a new builder-style object to manufacture [`OpsItemRelatedItemsFilter`](crate::model::OpsItemRelatedItemsFilter)
    pub fn builder() -> crate::model::ops_item_related_items_filter::Builder {
        crate::model::ops_item_related_items_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemRelatedItemsFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemRelatedItemsFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "Equal" => OpsItemRelatedItemsFilterOperator::Equal,
            other => OpsItemRelatedItemsFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsItemRelatedItemsFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsItemRelatedItemsFilterOperator::from(s))
    }
}
impl OpsItemRelatedItemsFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsItemRelatedItemsFilterOperator::Equal => "Equal",
            OpsItemRelatedItemsFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Equal"]
    }
}
impl AsRef<str> for OpsItemRelatedItemsFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemRelatedItemsFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    AssociationId,
    #[allow(missing_docs)] // documentation missing in model
    ResourceType,
    #[allow(missing_docs)] // documentation missing in model
    ResourceUri,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemRelatedItemsFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "AssociationId" => OpsItemRelatedItemsFilterKey::AssociationId,
            "ResourceType" => OpsItemRelatedItemsFilterKey::ResourceType,
            "ResourceUri" => OpsItemRelatedItemsFilterKey::ResourceUri,
            other => OpsItemRelatedItemsFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsItemRelatedItemsFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsItemRelatedItemsFilterKey::from(s))
    }
}
impl OpsItemRelatedItemsFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsItemRelatedItemsFilterKey::AssociationId => "AssociationId",
            OpsItemRelatedItemsFilterKey::ResourceType => "ResourceType",
            OpsItemRelatedItemsFilterKey::ResourceUri => "ResourceUri",
            OpsItemRelatedItemsFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AssociationId", "ResourceType", "ResourceUri"]
    }
}
impl AsRef<str> for OpsItemRelatedItemsFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about an OpsItem event or that associated an OpsItem with a related
/// item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemEventSummary {
    /// <p>The ID of the OpsItem.</p>
    pub ops_item_id: std::option::Option<std::string::String>,
    /// <p>The ID of the OpsItem event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The source of the OpsItem event.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The type of information provided as a detail.</p>
    pub detail_type: std::option::Option<std::string::String>,
    /// <p>Specific information about the OpsItem event.</p>
    pub detail: std::option::Option<std::string::String>,
    /// <p>Information about the user or resource that created the OpsItem event.</p>
    pub created_by: std::option::Option<crate::model::OpsItemIdentity>,
    /// <p>The date and time the OpsItem event was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for OpsItemEventSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemEventSummary");
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.field("event_id", &self.event_id);
        formatter.field("source", &self.source);
        formatter.field("detail_type", &self.detail_type);
        formatter.field("detail", &self.detail);
        formatter.field("created_by", &self.created_by);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`OpsItemEventSummary`](crate::model::OpsItemEventSummary)
pub mod ops_item_event_summary {
    /// A builder for [`OpsItemEventSummary`](crate::model::OpsItemEventSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) detail_type: std::option::Option<std::string::String>,
        pub(crate) detail: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<crate::model::OpsItemIdentity>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the OpsItem.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// <p>The ID of the OpsItem event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The source of the OpsItem event.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the OpsItem event.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The type of information provided as a detail.</p>
        pub fn detail_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail_type = Some(input.into());
            self
        }
        /// <p>The type of information provided as a detail.</p>
        pub fn set_detail_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail_type = input;
            self
        }
        /// <p>Specific information about the OpsItem event.</p>
        pub fn detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail = Some(input.into());
            self
        }
        /// <p>Specific information about the OpsItem event.</p>
        pub fn set_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail = input;
            self
        }
        /// <p>Information about the user or resource that created the OpsItem event.</p>
        pub fn created_by(mut self, input: crate::model::OpsItemIdentity) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user or resource that created the OpsItem event.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::OpsItemIdentity>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time the OpsItem event was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time the OpsItem event was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemEventSummary`](crate::model::OpsItemEventSummary)
        pub fn build(self) -> crate::model::OpsItemEventSummary {
            crate::model::OpsItemEventSummary {
                ops_item_id: self.ops_item_id,
                event_id: self.event_id,
                source: self.source,
                detail_type: self.detail_type,
                detail: self.detail,
                created_by: self.created_by,
                created_time: self.created_time,
            }
        }
    }
}
impl OpsItemEventSummary {
    /// Creates a new builder-style object to manufacture [`OpsItemEventSummary`](crate::model::OpsItemEventSummary)
    pub fn builder() -> crate::model::ops_item_event_summary::Builder {
        crate::model::ops_item_event_summary::Builder::default()
    }
}

/// <p>Describes a filter for a specific list of OpsItem events. You can filter event information
/// by using tags. You specify tags by using a key-value pair mapping. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemEventFilter {
    /// <p>The name of the filter key. Currently, the only supported value is
    /// <code>OpsItemId</code>.</p>
    pub key: std::option::Option<crate::model::OpsItemEventFilterKey>,
    /// <p>The values for the filter, consisting of one or more OpsItem IDs.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator used by the filter call. Currently, the only supported value is
    /// <code>Equal</code>.</p>
    pub operator: std::option::Option<crate::model::OpsItemEventFilterOperator>,
}
impl std::fmt::Debug for OpsItemEventFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemEventFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`OpsItemEventFilter`](crate::model::OpsItemEventFilter)
pub mod ops_item_event_filter {
    /// A builder for [`OpsItemEventFilter`](crate::model::OpsItemEventFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::OpsItemEventFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::OpsItemEventFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the filter key. Currently, the only supported value is
        /// <code>OpsItemId</code>.</p>
        pub fn key(mut self, input: crate::model::OpsItemEventFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter key. Currently, the only supported value is
        /// <code>OpsItemId</code>.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::OpsItemEventFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values for the filter, consisting of one or more OpsItem IDs.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values for the filter, consisting of one or more OpsItem IDs.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator used by the filter call. Currently, the only supported value is
        /// <code>Equal</code>.</p>
        pub fn operator(mut self, input: crate::model::OpsItemEventFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator used by the filter call. Currently, the only supported value is
        /// <code>Equal</code>.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::OpsItemEventFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemEventFilter`](crate::model::OpsItemEventFilter)
        pub fn build(self) -> crate::model::OpsItemEventFilter {
            crate::model::OpsItemEventFilter {
                key: self.key,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl OpsItemEventFilter {
    /// Creates a new builder-style object to manufacture [`OpsItemEventFilter`](crate::model::OpsItemEventFilter)
    pub fn builder() -> crate::model::ops_item_event_filter::Builder {
        crate::model::ops_item_event_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemEventFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemEventFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "Equal" => OpsItemEventFilterOperator::Equal,
            other => OpsItemEventFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsItemEventFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsItemEventFilterOperator::from(s))
    }
}
impl OpsItemEventFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsItemEventFilterOperator::Equal => "Equal",
            OpsItemEventFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Equal"]
    }
}
impl AsRef<str> for OpsItemEventFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemEventFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    OpsitemId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemEventFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "OpsItemId" => OpsItemEventFilterKey::OpsitemId,
            other => OpsItemEventFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsItemEventFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsItemEventFilterKey::from(s))
    }
}
impl OpsItemEventFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsItemEventFilterKey::OpsitemId => "OpsItemId",
            OpsItemEventFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OpsItemId"]
    }
}
impl AsRef<str> for OpsItemEventFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>One or more filters. Use a filter to return a more specific list of results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryFilter {
    /// <p>The name of the filter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Inventory filter values. Example: inventory filter where instance IDs are specified as
    /// values <code>Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g,
    /// i-1a2b3c4d5e6,Type=Equal</code>. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of filter.</p>
    /// <note>
    /// <p>The <code>Exists</code> filter must be used with aggregators. For more information, see
    /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html">Aggregating inventory
    /// data</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    /// </note>
    pub r#type: std::option::Option<crate::model::InventoryQueryOperatorType>,
}
impl std::fmt::Debug for InventoryFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`InventoryFilter`](crate::model::InventoryFilter)
pub mod inventory_filter {
    /// A builder for [`InventoryFilter`](crate::model::InventoryFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::InventoryQueryOperatorType>,
    }
    impl Builder {
        /// <p>The name of the filter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the filter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>Inventory filter values. Example: inventory filter where instance IDs are specified as
        /// values <code>Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g,
        /// i-1a2b3c4d5e6,Type=Equal</code>. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>Inventory filter values. Example: inventory filter where instance IDs are specified as
        /// values <code>Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g,
        /// i-1a2b3c4d5e6,Type=Equal</code>. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The type of filter.</p>
        /// <note>
        /// <p>The <code>Exists</code> filter must be used with aggregators. For more information, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html">Aggregating inventory
        /// data</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// </note>
        pub fn r#type(mut self, input: crate::model::InventoryQueryOperatorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of filter.</p>
        /// <note>
        /// <p>The <code>Exists</code> filter must be used with aggregators. For more information, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html">Aggregating inventory
        /// data</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        /// </note>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::InventoryQueryOperatorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryFilter`](crate::model::InventoryFilter)
        pub fn build(self) -> crate::model::InventoryFilter {
            crate::model::InventoryFilter {
                key: self.key,
                values: self.values,
                r#type: self.r#type,
            }
        }
    }
}
impl InventoryFilter {
    /// Creates a new builder-style object to manufacture [`InventoryFilter`](crate::model::InventoryFilter)
    pub fn builder() -> crate::model::inventory_filter::Builder {
        crate::model::inventory_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InventoryQueryOperatorType {
    #[allow(missing_docs)] // documentation missing in model
    BeginWith,
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    Exists,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    NotEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InventoryQueryOperatorType {
    fn from(s: &str) -> Self {
        match s {
            "BeginWith" => InventoryQueryOperatorType::BeginWith,
            "Equal" => InventoryQueryOperatorType::Equal,
            "Exists" => InventoryQueryOperatorType::Exists,
            "GreaterThan" => InventoryQueryOperatorType::GreaterThan,
            "LessThan" => InventoryQueryOperatorType::LessThan,
            "NotEqual" => InventoryQueryOperatorType::NotEqual,
            other => InventoryQueryOperatorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InventoryQueryOperatorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InventoryQueryOperatorType::from(s))
    }
}
impl InventoryQueryOperatorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InventoryQueryOperatorType::BeginWith => "BeginWith",
            InventoryQueryOperatorType::Equal => "Equal",
            InventoryQueryOperatorType::Exists => "Exists",
            InventoryQueryOperatorType::GreaterThan => "GreaterThan",
            InventoryQueryOperatorType::LessThan => "LessThan",
            InventoryQueryOperatorType::NotEqual => "NotEqual",
            InventoryQueryOperatorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BeginWith",
            "Equal",
            "Exists",
            "GreaterThan",
            "LessThan",
            "NotEqual",
        ]
    }
}
impl AsRef<str> for InventoryQueryOperatorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Version information about the document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentVersionInfo {
    /// <p>The document name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The friendly name of the SSM document. This value can differ for each version of the
    /// document. If you want to update this value, see <a>UpdateDocument</a>.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The document version.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The version of the artifact associated with the document. For example, "Release 12, Update
    /// 6". This value is unique across all versions of a document, and can't be changed.</p>
    pub version_name: std::option::Option<std::string::String>,
    /// <p>The date the document was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An identifier for the default version of the document.</p>
    pub is_default_version: bool,
    /// <p>The document format, either JSON or YAML.</p>
    pub document_format: std::option::Option<crate::model::DocumentFormat>,
    /// <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>,
    /// <code>Failed</code>, and <code>Deleting</code>.</p>
    pub status: std::option::Option<crate::model::DocumentStatus>,
    /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a
    /// <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
    /// "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
    pub status_information: std::option::Option<std::string::String>,
    /// <p>The current status of the approval review for the latest version of the document.</p>
    pub review_status: std::option::Option<crate::model::ReviewStatus>,
}
impl std::fmt::Debug for DocumentVersionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentVersionInfo");
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("version_name", &self.version_name);
        formatter.field("created_date", &self.created_date);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.field("document_format", &self.document_format);
        formatter.field("status", &self.status);
        formatter.field("status_information", &self.status_information);
        formatter.field("review_status", &self.review_status);
        formatter.finish()
    }
}
/// See [`DocumentVersionInfo`](crate::model::DocumentVersionInfo)
pub mod document_version_info {
    /// A builder for [`DocumentVersionInfo`](crate::model::DocumentVersionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) is_default_version: std::option::Option<bool>,
        pub(crate) document_format: std::option::Option<crate::model::DocumentFormat>,
        pub(crate) status: std::option::Option<crate::model::DocumentStatus>,
        pub(crate) status_information: std::option::Option<std::string::String>,
        pub(crate) review_status: std::option::Option<crate::model::ReviewStatus>,
    }
    impl Builder {
        /// <p>The document name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The document name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The friendly name of the SSM document. This value can differ for each version of the
        /// document. If you want to update this value, see <a>UpdateDocument</a>.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the SSM document. This value can differ for each version of the
        /// document. If you want to update this value, see <a>UpdateDocument</a>.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The document version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The version of the artifact associated with the document. For example, "Release 12, Update
        /// 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>The version of the artifact associated with the document. For example, "Release 12, Update
        /// 6". This value is unique across all versions of a document, and can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// <p>The date the document was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the document was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>An identifier for the default version of the document.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>An identifier for the default version of the document.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.document_format = Some(input);
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.document_format = input;
            self
        }
        /// <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>,
        /// <code>Failed</code>, and <code>Deleting</code>.</p>
        pub fn status(mut self, input: crate::model::DocumentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SSM document, such as <code>Creating</code>, <code>Active</code>,
        /// <code>Failed</code>, and <code>Deleting</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DocumentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a
        /// <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
        /// "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
        pub fn status_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_information = Some(input.into());
            self
        }
        /// <p>A message returned by Amazon Web Services Systems Manager that explains the <code>Status</code> value. For example, a
        /// <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
        /// "The specified S3 bucket doesn't exist. Verify that the URL of the S3 bucket is correct."</p>
        pub fn set_status_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_information = input;
            self
        }
        /// <p>The current status of the approval review for the latest version of the document.</p>
        pub fn review_status(mut self, input: crate::model::ReviewStatus) -> Self {
            self.review_status = Some(input);
            self
        }
        /// <p>The current status of the approval review for the latest version of the document.</p>
        pub fn set_review_status(
            mut self,
            input: std::option::Option<crate::model::ReviewStatus>,
        ) -> Self {
            self.review_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentVersionInfo`](crate::model::DocumentVersionInfo)
        pub fn build(self) -> crate::model::DocumentVersionInfo {
            crate::model::DocumentVersionInfo {
                name: self.name,
                display_name: self.display_name,
                document_version: self.document_version,
                version_name: self.version_name,
                created_date: self.created_date,
                is_default_version: self.is_default_version.unwrap_or_default(),
                document_format: self.document_format,
                status: self.status,
                status_information: self.status_information,
                review_status: self.review_status,
            }
        }
    }
}
impl DocumentVersionInfo {
    /// Creates a new builder-style object to manufacture [`DocumentVersionInfo`](crate::model::DocumentVersionInfo)
    pub fn builder() -> crate::model::document_version_info::Builder {
        crate::model::document_version_info::Builder::default()
    }
}

/// <p>Describes the name of a SSM document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentIdentifier {
    /// <p>The name of the SSM document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The date the SSM document was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An optional field where you can specify a friendly name for the SSM document. This value can
    /// differ for each version of the document. If you want to update this value, see <a>UpdateDocument</a>.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services user account that created the document.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>An optional field specifying the version of the artifact associated with the document. For
    /// example, "Release 12, Update 6". This value is unique across all versions of a document, and
    /// can't be changed.</p>
    pub version_name: std::option::Option<std::string::String>,
    /// <p>The operating system platform. </p>
    pub platform_types: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
    /// <p>The document version.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The document type.</p>
    pub document_type: std::option::Option<crate::model::DocumentType>,
    /// <p>The schema version.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The document format, either JSON or YAML.</p>
    pub document_format: std::option::Option<crate::model::DocumentFormat>,
    /// <p>The target type which defines the kinds of resources the document can run on. For example,
    /// <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
    /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
    pub target_type: std::option::Option<std::string::String>,
    /// <p>The tags, or metadata, that have been applied to the document.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A list of SSM documents required by a document. For example, an
    /// <code>ApplicationConfiguration</code> document requires an
    /// <code>ApplicationConfigurationSchema</code> document.</p>
    pub requires: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
    /// <p>The current status of a document review.</p>
    pub review_status: std::option::Option<crate::model::ReviewStatus>,
    /// <p>The user in your organization who created the document.</p>
    pub author: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentIdentifier");
        formatter.field("name", &self.name);
        formatter.field("created_date", &self.created_date);
        formatter.field("display_name", &self.display_name);
        formatter.field("owner", &self.owner);
        formatter.field("version_name", &self.version_name);
        formatter.field("platform_types", &self.platform_types);
        formatter.field("document_version", &self.document_version);
        formatter.field("document_type", &self.document_type);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("document_format", &self.document_format);
        formatter.field("target_type", &self.target_type);
        formatter.field("tags", &self.tags);
        formatter.field("requires", &self.requires);
        formatter.field("review_status", &self.review_status);
        formatter.field("author", &self.author);
        formatter.finish()
    }
}
/// See [`DocumentIdentifier`](crate::model::DocumentIdentifier)
pub mod document_identifier {
    /// A builder for [`DocumentIdentifier`](crate::model::DocumentIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) version_name: std::option::Option<std::string::String>,
        pub(crate) platform_types: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) document_type: std::option::Option<crate::model::DocumentType>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) document_format: std::option::Option<crate::model::DocumentFormat>,
        pub(crate) target_type: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) requires: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        pub(crate) review_status: std::option::Option<crate::model::ReviewStatus>,
        pub(crate) author: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The date the SSM document was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the SSM document was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can
        /// differ for each version of the document. If you want to update this value, see <a>UpdateDocument</a>.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>An optional field where you can specify a friendly name for the SSM document. This value can
        /// differ for each version of the document. If you want to update this value, see <a>UpdateDocument</a>.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The Amazon Web Services user account that created the document.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services user account that created the document.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_name = Some(input.into());
            self
        }
        /// <p>An optional field specifying the version of the artifact associated with the document. For
        /// example, "Release 12, Update 6". This value is unique across all versions of a document, and
        /// can't be changed.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_name = input;
            self
        }
        /// Appends an item to `platform_types`.
        ///
        /// To override the contents of this collection use [`set_platform_types`](Self::set_platform_types).
        ///
        /// <p>The operating system platform. </p>
        pub fn platform_types(mut self, input: impl Into<crate::model::PlatformType>) -> Self {
            let mut v = self.platform_types.unwrap_or_default();
            v.push(input.into());
            self.platform_types = Some(v);
            self
        }
        /// <p>The operating system platform. </p>
        pub fn set_platform_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
        ) -> Self {
            self.platform_types = input;
            self
        }
        /// <p>The document version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The document version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The document type.</p>
        pub fn document_type(mut self, input: crate::model::DocumentType) -> Self {
            self.document_type = Some(input);
            self
        }
        /// <p>The document type.</p>
        pub fn set_document_type(
            mut self,
            input: std::option::Option<crate::model::DocumentType>,
        ) -> Self {
            self.document_type = input;
            self
        }
        /// <p>The schema version.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn document_format(mut self, input: crate::model::DocumentFormat) -> Self {
            self.document_format = Some(input);
            self
        }
        /// <p>The document format, either JSON or YAML.</p>
        pub fn set_document_format(
            mut self,
            input: std::option::Option<crate::model::DocumentFormat>,
        ) -> Self {
            self.document_format = input;
            self
        }
        /// <p>The target type which defines the kinds of resources the document can run on. For example,
        /// <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn target_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_type = Some(input.into());
            self
        }
        /// <p>The target type which defines the kinds of resources the document can run on. For example,
        /// <code>/AWS::EC2::Instance</code>. For a list of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
        /// property types reference</a> in the <i>CloudFormation User Guide</i>. </p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags, or metadata, that have been applied to the document.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags, or metadata, that have been applied to the document.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `requires`.
        ///
        /// To override the contents of this collection use [`set_requires`](Self::set_requires).
        ///
        /// <p>A list of SSM documents required by a document. For example, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document.</p>
        pub fn requires(mut self, input: impl Into<crate::model::DocumentRequires>) -> Self {
            let mut v = self.requires.unwrap_or_default();
            v.push(input.into());
            self.requires = Some(v);
            self
        }
        /// <p>A list of SSM documents required by a document. For example, an
        /// <code>ApplicationConfiguration</code> document requires an
        /// <code>ApplicationConfigurationSchema</code> document.</p>
        pub fn set_requires(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentRequires>>,
        ) -> Self {
            self.requires = input;
            self
        }
        /// <p>The current status of a document review.</p>
        pub fn review_status(mut self, input: crate::model::ReviewStatus) -> Self {
            self.review_status = Some(input);
            self
        }
        /// <p>The current status of a document review.</p>
        pub fn set_review_status(
            mut self,
            input: std::option::Option<crate::model::ReviewStatus>,
        ) -> Self {
            self.review_status = input;
            self
        }
        /// <p>The user in your organization who created the document.</p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p>The user in your organization who created the document.</p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentIdentifier`](crate::model::DocumentIdentifier)
        pub fn build(self) -> crate::model::DocumentIdentifier {
            crate::model::DocumentIdentifier {
                name: self.name,
                created_date: self.created_date,
                display_name: self.display_name,
                owner: self.owner,
                version_name: self.version_name,
                platform_types: self.platform_types,
                document_version: self.document_version,
                document_type: self.document_type,
                schema_version: self.schema_version,
                document_format: self.document_format,
                target_type: self.target_type,
                tags: self.tags,
                requires: self.requires,
                review_status: self.review_status,
                author: self.author,
            }
        }
    }
}
impl DocumentIdentifier {
    /// Creates a new builder-style object to manufacture [`DocumentIdentifier`](crate::model::DocumentIdentifier)
    pub fn builder() -> crate::model::document_identifier::Builder {
        crate::model::document_identifier::Builder::default()
    }
}

/// <p>One or more filters. Use a filter to return a more specific list of documents.</p>
/// <p>For keys, you can specify one or more tags that have been applied to a document. </p>
/// <p>You can also use Amazon Web Services-provided keys, some of which have specific allowed values. These keys
/// and their associated values are as follows:</p>
/// <dl>
/// <dt>DocumentType</dt>
/// <dd>
/// <ul>
/// <li>
/// <p>
/// <code>ApplicationConfiguration</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ApplicationConfigurationSchema</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Automation</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ChangeCalendar</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Command</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DeploymentStrategy</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Package</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Policy</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Session</code>
/// </p>
/// </li>
/// </ul>
/// </dd>
/// <dt>Owner</dt>
/// <dd>
/// <p>Note that only one <code>Owner</code> can be specified in a request. For example:
/// <code>Key=Owner,Values=Self</code>.</p>
/// <ul>
/// <li>
/// <p>
/// <code>Amazon</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Private</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Public</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Self</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ThirdParty</code>
/// </p>
/// </li>
/// </ul>
/// </dd>
/// <dt>PlatformTypes</dt>
/// <dd>
/// <ul>
/// <li>
/// <p>
/// <code>Linux</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>Windows</code>
/// </p>
/// </li>
/// </ul>
/// </dd>
/// </dl>
/// <p>
/// <code>Name</code> is another Amazon Web Services-provided key. If you use <code>Name</code> as a key, you
/// can use a name prefix to return a list of documents. For example, in the Amazon Web Services CLI, to return a list
/// of all documents that begin with <code>Te</code>, run the following command:</p>
/// <p>
/// <code>aws ssm list-documents --filters Key=Name,Values=Te</code>
/// </p>
/// <p>You can also use the <code>TargetType</code> Amazon Web Services-provided key. For a list of valid
/// resource type values that can be used with this key, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
/// property types reference</a> in the <i>CloudFormation User Guide</i>.</p>
/// <p>If you specify more than two keys, only documents that are identified by all the tags are
/// returned in the results. If you specify more than two values for a key, documents that are
/// identified by any of the values are returned in the results.</p>
/// <p>To specify a custom key-value pair, use the format
/// <code>Key=tag:tagName,Values=valueName</code>.</p>
/// <p>For example, if you created a key called region and are using the Amazon Web Services CLI to call the
/// <code>list-documents</code> command: </p>
/// <p>
/// <code>aws ssm list-documents --filters Key=tag:region,Values=east,west
/// Key=Owner,Values=Self</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentKeyValuesFilter {
    /// <p>The name of the filter key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for the filter key.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DocumentKeyValuesFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentKeyValuesFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`DocumentKeyValuesFilter`](crate::model::DocumentKeyValuesFilter)
pub mod document_key_values_filter {
    /// A builder for [`DocumentKeyValuesFilter`](crate::model::DocumentKeyValuesFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the filter key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value for the filter key.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value for the filter key.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentKeyValuesFilter`](crate::model::DocumentKeyValuesFilter)
        pub fn build(self) -> crate::model::DocumentKeyValuesFilter {
            crate::model::DocumentKeyValuesFilter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl DocumentKeyValuesFilter {
    /// Creates a new builder-style object to manufacture [`DocumentKeyValuesFilter`](crate::model::DocumentKeyValuesFilter)
    pub fn builder() -> crate::model::document_key_values_filter::Builder {
        crate::model::document_key_values_filter::Builder::default()
    }
}

/// <p>This data type is deprecated. Instead, use <a>DocumentKeyValuesFilter</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentFilter {
    /// <p>The name of the filter.</p>
    pub key: std::option::Option<crate::model::DocumentFilterKey>,
    /// <p>The value of the filter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DocumentFilter`](crate::model::DocumentFilter)
pub mod document_filter {
    /// A builder for [`DocumentFilter`](crate::model::DocumentFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::DocumentFilterKey>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn key(mut self, input: crate::model::DocumentFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::DocumentFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the filter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the filter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentFilter`](crate::model::DocumentFilter)
        pub fn build(self) -> crate::model::DocumentFilter {
            crate::model::DocumentFilter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl DocumentFilter {
    /// Creates a new builder-style object to manufacture [`DocumentFilter`](crate::model::DocumentFilter)
    pub fn builder() -> crate::model::document_filter::Builder {
        crate::model::document_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    DocumentType,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Owner,
    #[allow(missing_docs)] // documentation missing in model
    PlatformTypes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "DocumentType" => DocumentFilterKey::DocumentType,
            "Name" => DocumentFilterKey::Name,
            "Owner" => DocumentFilterKey::Owner,
            "PlatformTypes" => DocumentFilterKey::PlatformTypes,
            other => DocumentFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentFilterKey::from(s))
    }
}
impl DocumentFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentFilterKey::DocumentType => "DocumentType",
            DocumentFilterKey::Name => "Name",
            DocumentFilterKey::Owner => "Owner",
            DocumentFilterKey::PlatformTypes => "PlatformTypes",
            DocumentFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DocumentType", "Name", "Owner", "PlatformTypes"]
    }
}
impl AsRef<str> for DocumentFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the response to a document review request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentMetadataResponseInfo {
    /// <p>Details about a reviewer's response to a document review request.</p>
    pub reviewer_response:
        std::option::Option<std::vec::Vec<crate::model::DocumentReviewerResponseSource>>,
}
impl std::fmt::Debug for DocumentMetadataResponseInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentMetadataResponseInfo");
        formatter.field("reviewer_response", &self.reviewer_response);
        formatter.finish()
    }
}
/// See [`DocumentMetadataResponseInfo`](crate::model::DocumentMetadataResponseInfo)
pub mod document_metadata_response_info {
    /// A builder for [`DocumentMetadataResponseInfo`](crate::model::DocumentMetadataResponseInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reviewer_response:
            std::option::Option<std::vec::Vec<crate::model::DocumentReviewerResponseSource>>,
    }
    impl Builder {
        /// Appends an item to `reviewer_response`.
        ///
        /// To override the contents of this collection use [`set_reviewer_response`](Self::set_reviewer_response).
        ///
        /// <p>Details about a reviewer's response to a document review request.</p>
        pub fn reviewer_response(
            mut self,
            input: impl Into<crate::model::DocumentReviewerResponseSource>,
        ) -> Self {
            let mut v = self.reviewer_response.unwrap_or_default();
            v.push(input.into());
            self.reviewer_response = Some(v);
            self
        }
        /// <p>Details about a reviewer's response to a document review request.</p>
        pub fn set_reviewer_response(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentReviewerResponseSource>>,
        ) -> Self {
            self.reviewer_response = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentMetadataResponseInfo`](crate::model::DocumentMetadataResponseInfo)
        pub fn build(self) -> crate::model::DocumentMetadataResponseInfo {
            crate::model::DocumentMetadataResponseInfo {
                reviewer_response: self.reviewer_response,
            }
        }
    }
}
impl DocumentMetadataResponseInfo {
    /// Creates a new builder-style object to manufacture [`DocumentMetadataResponseInfo`](crate::model::DocumentMetadataResponseInfo)
    pub fn builder() -> crate::model::document_metadata_response_info::Builder {
        crate::model::document_metadata_response_info::Builder::default()
    }
}

/// <p>Information about a reviewer's response to a document review request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentReviewerResponseSource {
    /// <p>The date and time that a reviewer entered a response to a document review request.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that a reviewer last updated a response to a document review
    /// request.</p>
    pub updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current review status of a new custom SSM document created by a member of your
    /// organization, or of the latest version of an existing SSM document.</p>
    /// <p>Only one version of a document can be in the APPROVED state at a time. When a new version is
    /// approved, the status of the previous version changes to REJECTED.</p>
    /// <p>Only one version of a document can be in review, or PENDING, at a time.</p>
    pub review_status: std::option::Option<crate::model::ReviewStatus>,
    /// <p>The comment entered by a reviewer as part of their document review response.</p>
    pub comment: std::option::Option<std::vec::Vec<crate::model::DocumentReviewCommentSource>>,
    /// <p>The user in your organization assigned to review a document request.</p>
    pub reviewer: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DocumentReviewerResponseSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentReviewerResponseSource");
        formatter.field("create_time", &self.create_time);
        formatter.field("updated_time", &self.updated_time);
        formatter.field("review_status", &self.review_status);
        formatter.field("comment", &self.comment);
        formatter.field("reviewer", &self.reviewer);
        formatter.finish()
    }
}
/// See [`DocumentReviewerResponseSource`](crate::model::DocumentReviewerResponseSource)
pub mod document_reviewer_response_source {
    /// A builder for [`DocumentReviewerResponseSource`](crate::model::DocumentReviewerResponseSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) review_status: std::option::Option<crate::model::ReviewStatus>,
        pub(crate) comment:
            std::option::Option<std::vec::Vec<crate::model::DocumentReviewCommentSource>>,
        pub(crate) reviewer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time that a reviewer entered a response to a document review request.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The date and time that a reviewer entered a response to a document review request.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The date and time that a reviewer last updated a response to a document review
        /// request.</p>
        pub fn updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_time = Some(input);
            self
        }
        /// <p>The date and time that a reviewer last updated a response to a document review
        /// request.</p>
        pub fn set_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_time = input;
            self
        }
        /// <p>The current review status of a new custom SSM document created by a member of your
        /// organization, or of the latest version of an existing SSM document.</p>
        /// <p>Only one version of a document can be in the APPROVED state at a time. When a new version is
        /// approved, the status of the previous version changes to REJECTED.</p>
        /// <p>Only one version of a document can be in review, or PENDING, at a time.</p>
        pub fn review_status(mut self, input: crate::model::ReviewStatus) -> Self {
            self.review_status = Some(input);
            self
        }
        /// <p>The current review status of a new custom SSM document created by a member of your
        /// organization, or of the latest version of an existing SSM document.</p>
        /// <p>Only one version of a document can be in the APPROVED state at a time. When a new version is
        /// approved, the status of the previous version changes to REJECTED.</p>
        /// <p>Only one version of a document can be in review, or PENDING, at a time.</p>
        pub fn set_review_status(
            mut self,
            input: std::option::Option<crate::model::ReviewStatus>,
        ) -> Self {
            self.review_status = input;
            self
        }
        /// Appends an item to `comment`.
        ///
        /// To override the contents of this collection use [`set_comment`](Self::set_comment).
        ///
        /// <p>The comment entered by a reviewer as part of their document review response.</p>
        pub fn comment(
            mut self,
            input: impl Into<crate::model::DocumentReviewCommentSource>,
        ) -> Self {
            let mut v = self.comment.unwrap_or_default();
            v.push(input.into());
            self.comment = Some(v);
            self
        }
        /// <p>The comment entered by a reviewer as part of their document review response.</p>
        pub fn set_comment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DocumentReviewCommentSource>>,
        ) -> Self {
            self.comment = input;
            self
        }
        /// <p>The user in your organization assigned to review a document request.</p>
        pub fn reviewer(mut self, input: impl Into<std::string::String>) -> Self {
            self.reviewer = Some(input.into());
            self
        }
        /// <p>The user in your organization assigned to review a document request.</p>
        pub fn set_reviewer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reviewer = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentReviewerResponseSource`](crate::model::DocumentReviewerResponseSource)
        pub fn build(self) -> crate::model::DocumentReviewerResponseSource {
            crate::model::DocumentReviewerResponseSource {
                create_time: self.create_time,
                updated_time: self.updated_time,
                review_status: self.review_status,
                comment: self.comment,
                reviewer: self.reviewer,
            }
        }
    }
}
impl DocumentReviewerResponseSource {
    /// Creates a new builder-style object to manufacture [`DocumentReviewerResponseSource`](crate::model::DocumentReviewerResponseSource)
    pub fn builder() -> crate::model::document_reviewer_response_source::Builder {
        crate::model::document_reviewer_response_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DocumentMetadataEnum {
    #[allow(missing_docs)] // documentation missing in model
    DocumentReviews,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DocumentMetadataEnum {
    fn from(s: &str) -> Self {
        match s {
            "DocumentReviews" => DocumentMetadataEnum::DocumentReviews,
            other => DocumentMetadataEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DocumentMetadataEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DocumentMetadataEnum::from(s))
    }
}
impl DocumentMetadataEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DocumentMetadataEnum::DocumentReviews => "DocumentReviews",
            DocumentMetadataEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DocumentReviews"]
    }
}
impl AsRef<str> for DocumentMetadataEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of compliance information by compliance type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceSummaryItem {
    /// <p>The type of compliance item. For example, the compliance type can be Association, Patch, or
    /// Custom:string.</p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p>A list of COMPLIANT items for the specified compliance type.</p>
    pub compliant_summary: std::option::Option<crate::model::CompliantSummary>,
    /// <p>A list of NON_COMPLIANT items for the specified compliance type.</p>
    pub non_compliant_summary: std::option::Option<crate::model::NonCompliantSummary>,
}
impl std::fmt::Debug for ComplianceSummaryItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceSummaryItem");
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("compliant_summary", &self.compliant_summary);
        formatter.field("non_compliant_summary", &self.non_compliant_summary);
        formatter.finish()
    }
}
/// See [`ComplianceSummaryItem`](crate::model::ComplianceSummaryItem)
pub mod compliance_summary_item {
    /// A builder for [`ComplianceSummaryItem`](crate::model::ComplianceSummaryItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) compliant_summary: std::option::Option<crate::model::CompliantSummary>,
        pub(crate) non_compliant_summary: std::option::Option<crate::model::NonCompliantSummary>,
    }
    impl Builder {
        /// <p>The type of compliance item. For example, the compliance type can be Association, Patch, or
        /// Custom:string.</p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p>The type of compliance item. For example, the compliance type can be Association, Patch, or
        /// Custom:string.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>A list of COMPLIANT items for the specified compliance type.</p>
        pub fn compliant_summary(mut self, input: crate::model::CompliantSummary) -> Self {
            self.compliant_summary = Some(input);
            self
        }
        /// <p>A list of COMPLIANT items for the specified compliance type.</p>
        pub fn set_compliant_summary(
            mut self,
            input: std::option::Option<crate::model::CompliantSummary>,
        ) -> Self {
            self.compliant_summary = input;
            self
        }
        /// <p>A list of NON_COMPLIANT items for the specified compliance type.</p>
        pub fn non_compliant_summary(mut self, input: crate::model::NonCompliantSummary) -> Self {
            self.non_compliant_summary = Some(input);
            self
        }
        /// <p>A list of NON_COMPLIANT items for the specified compliance type.</p>
        pub fn set_non_compliant_summary(
            mut self,
            input: std::option::Option<crate::model::NonCompliantSummary>,
        ) -> Self {
            self.non_compliant_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceSummaryItem`](crate::model::ComplianceSummaryItem)
        pub fn build(self) -> crate::model::ComplianceSummaryItem {
            crate::model::ComplianceSummaryItem {
                compliance_type: self.compliance_type,
                compliant_summary: self.compliant_summary,
                non_compliant_summary: self.non_compliant_summary,
            }
        }
    }
}
impl ComplianceSummaryItem {
    /// Creates a new builder-style object to manufacture [`ComplianceSummaryItem`](crate::model::ComplianceSummaryItem)
    pub fn builder() -> crate::model::compliance_summary_item::Builder {
        crate::model::compliance_summary_item::Builder::default()
    }
}

/// <p>Information about the compliance as defined by the resource type. For example, for a patch
/// resource type, <code>Items</code> includes information about the PatchSeverity, Classification,
/// and so on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComplianceItem {
    /// <p>The compliance type. For example, Association (for a State Manager association), Patch, or
    /// Custom:<code>string</code> are all valid compliance types.</p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p>The type of resource. <code>ManagedInstance</code> is currently the only supported resource
    /// type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>An ID for the resource. For a managed instance, this is the instance ID.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>An ID for the compliance item. For example, if the compliance item is a Windows patch, the
    /// ID could be the number of the KB article; for example: KB4010320.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A title for the compliance item. For example, if the compliance item is a Windows patch, the
    /// title could be the title of the KB article for the patch; for example: Security Update for Active
    /// Directory Federation Services.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The status of the compliance item. An item is either COMPLIANT, NON_COMPLIANT, or an empty
    /// string (for Windows patches that aren't applicable).</p>
    pub status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>The severity of the compliance status. Severity can be one of the following: Critical, High,
    /// Medium, Low, Informational, Unspecified.</p>
    pub severity: std::option::Option<crate::model::ComplianceSeverity>,
    /// <p>A summary for the compliance item. The summary includes an execution ID, the execution type
    /// (for example, command), and the execution time.</p>
    pub execution_summary: std::option::Option<crate::model::ComplianceExecutionSummary>,
    /// <p>A "Key": "Value" tag combination for the compliance item.</p>
    pub details:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ComplianceItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComplianceItem");
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("id", &self.id);
        formatter.field("title", &self.title);
        formatter.field("status", &self.status);
        formatter.field("severity", &self.severity);
        formatter.field("execution_summary", &self.execution_summary);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`ComplianceItem`](crate::model::ComplianceItem)
pub mod compliance_item {
    /// A builder for [`ComplianceItem`](crate::model::ComplianceItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) severity: std::option::Option<crate::model::ComplianceSeverity>,
        pub(crate) execution_summary: std::option::Option<crate::model::ComplianceExecutionSummary>,
        pub(crate) details: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The compliance type. For example, Association (for a State Manager association), Patch, or
        /// Custom:<code>string</code> are all valid compliance types.</p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p>The compliance type. For example, Association (for a State Manager association), Patch, or
        /// Custom:<code>string</code> are all valid compliance types.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p>The type of resource. <code>ManagedInstance</code> is currently the only supported resource
        /// type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource. <code>ManagedInstance</code> is currently the only supported resource
        /// type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>An ID for the resource. For a managed instance, this is the instance ID.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>An ID for the resource. For a managed instance, this is the instance ID.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>An ID for the compliance item. For example, if the compliance item is a Windows patch, the
        /// ID could be the number of the KB article; for example: KB4010320.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An ID for the compliance item. For example, if the compliance item is a Windows patch, the
        /// ID could be the number of the KB article; for example: KB4010320.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A title for the compliance item. For example, if the compliance item is a Windows patch, the
        /// title could be the title of the KB article for the patch; for example: Security Update for Active
        /// Directory Federation Services.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>A title for the compliance item. For example, if the compliance item is a Windows patch, the
        /// title could be the title of the KB article for the patch; for example: Security Update for Active
        /// Directory Federation Services.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The status of the compliance item. An item is either COMPLIANT, NON_COMPLIANT, or an empty
        /// string (for Windows patches that aren't applicable).</p>
        pub fn status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the compliance item. An item is either COMPLIANT, NON_COMPLIANT, or an empty
        /// string (for Windows patches that aren't applicable).</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The severity of the compliance status. Severity can be one of the following: Critical, High,
        /// Medium, Low, Informational, Unspecified.</p>
        pub fn severity(mut self, input: crate::model::ComplianceSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the compliance status. Severity can be one of the following: Critical, High,
        /// Medium, Low, Informational, Unspecified.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::ComplianceSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// <p>A summary for the compliance item. The summary includes an execution ID, the execution type
        /// (for example, command), and the execution time.</p>
        pub fn execution_summary(
            mut self,
            input: crate::model::ComplianceExecutionSummary,
        ) -> Self {
            self.execution_summary = Some(input);
            self
        }
        /// <p>A summary for the compliance item. The summary includes an execution ID, the execution type
        /// (for example, command), and the execution time.</p>
        pub fn set_execution_summary(
            mut self,
            input: std::option::Option<crate::model::ComplianceExecutionSummary>,
        ) -> Self {
            self.execution_summary = input;
            self
        }
        /// Adds a key-value pair to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p>A "Key": "Value" tag combination for the compliance item.</p>
        pub fn details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.details = Some(hash_map);
            self
        }
        /// <p>A "Key": "Value" tag combination for the compliance item.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ComplianceItem`](crate::model::ComplianceItem)
        pub fn build(self) -> crate::model::ComplianceItem {
            crate::model::ComplianceItem {
                compliance_type: self.compliance_type,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                id: self.id,
                title: self.title,
                status: self.status,
                severity: self.severity,
                execution_summary: self.execution_summary,
                details: self.details,
            }
        }
    }
}
impl ComplianceItem {
    /// Creates a new builder-style object to manufacture [`ComplianceItem`](crate::model::ComplianceItem)
    pub fn builder() -> crate::model::compliance_item::Builder {
        crate::model::compliance_item::Builder::default()
    }
}

/// <p>Describes a command filter.</p>
/// <note>
/// <p>An instance ID can't be specified when a command status is <code>Pending</code> because the
/// command hasn't run on the instance yet.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommandFilter {
    /// <p>The name of the filter.</p>
    pub key: std::option::Option<crate::model::CommandFilterKey>,
    /// <p>The filter value. Valid values for each filter key are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>InvokedAfter</b>: Specify a timestamp to limit your results.
    /// For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions
    /// occurring July 7, 2021, and later.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>InvokedBefore</b>: Specify a timestamp to limit your results.
    /// For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions from
    /// before July 7, 2021.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Status</b>: Specify a valid command status to see a list of
    /// all command executions with that status. The status choices depend on the API you call.</p>
    /// <p>The status values you can specify for <code>ListCommands</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Pending</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InProgress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Success</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Cancelled</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccessDenied</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DeliveryTimedOut</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ExecutionTimedOut</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Incomplete</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NoInstancesInTag</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LimitExceeded</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The status values you can specify for <code>ListCommandInvocations</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Pending</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InProgress</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Delayed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Success</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Cancelled</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccessDenied</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DeliveryTimedOut</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ExecutionTimedOut</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Undeliverable</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InvalidPlatform</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Terminated</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM
    /// document) for which you want to see command execution results. For example, specify
    /// <code>AWS-RunPatchBaseline</code> to see command executions that used this SSM document to
    /// perform security patching operations on instances. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ExecutionStage</b>: Specify one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Executing</code>: Returns a list of command executions that are currently still
    /// running.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Complete</code>: Returns a list of command executions that have already completed.
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CommandFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommandFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CommandFilter`](crate::model::CommandFilter)
pub mod command_filter {
    /// A builder for [`CommandFilter`](crate::model::CommandFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::CommandFilterKey>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn key(mut self, input: crate::model::CommandFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::CommandFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>The filter value. Valid values for each filter key are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>InvokedAfter</b>: Specify a timestamp to limit your results.
        /// For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions
        /// occurring July 7, 2021, and later.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InvokedBefore</b>: Specify a timestamp to limit your results.
        /// For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions from
        /// before July 7, 2021.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Status</b>: Specify a valid command status to see a list of
        /// all command executions with that status. The status choices depend on the API you call.</p>
        /// <p>The status values you can specify for <code>ListCommands</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Success</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccessDenied</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DeliveryTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExecutionTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Incomplete</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoInstancesInTag</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LimitExceeded</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The status values you can specify for <code>ListCommandInvocations</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delayed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Success</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccessDenied</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DeliveryTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExecutionTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Undeliverable</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InvalidPlatform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminated</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM
        /// document) for which you want to see command execution results. For example, specify
        /// <code>AWS-RunPatchBaseline</code> to see command executions that used this SSM document to
        /// perform security patching operations on instances. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ExecutionStage</b>: Specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Executing</code>: Returns a list of command executions that are currently still
        /// running.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Complete</code>: Returns a list of command executions that have already completed.
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The filter value. Valid values for each filter key are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>InvokedAfter</b>: Specify a timestamp to limit your results.
        /// For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions
        /// occurring July 7, 2021, and later.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InvokedBefore</b>: Specify a timestamp to limit your results.
        /// For example, specify <code>2021-07-07T00:00:00Z</code> to see a list of command executions from
        /// before July 7, 2021.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Status</b>: Specify a valid command status to see a list of
        /// all command executions with that status. The status choices depend on the API you call.</p>
        /// <p>The status values you can specify for <code>ListCommands</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Success</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccessDenied</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DeliveryTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExecutionTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Incomplete</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NoInstancesInTag</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LimitExceeded</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The status values you can specify for <code>ListCommandInvocations</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delayed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Success</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelled</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TimedOut</code> (this includes both Delivery and Execution time outs) </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccessDenied</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DeliveryTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExecutionTimedOut</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Undeliverable</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InvalidPlatform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminated</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM
        /// document) for which you want to see command execution results. For example, specify
        /// <code>AWS-RunPatchBaseline</code> to see command executions that used this SSM document to
        /// perform security patching operations on instances. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ExecutionStage</b>: Specify one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Executing</code>: Returns a list of command executions that are currently still
        /// running.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Complete</code>: Returns a list of command executions that have already completed.
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CommandFilter`](crate::model::CommandFilter)
        pub fn build(self) -> crate::model::CommandFilter {
            crate::model::CommandFilter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl CommandFilter {
    /// Creates a new builder-style object to manufacture [`CommandFilter`](crate::model::CommandFilter)
    pub fn builder() -> crate::model::command_filter::Builder {
        crate::model::command_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CommandFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    DocumentName,
    #[allow(missing_docs)] // documentation missing in model
    ExecutionStage,
    #[allow(missing_docs)] // documentation missing in model
    InvokedAfter,
    #[allow(missing_docs)] // documentation missing in model
    InvokedBefore,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CommandFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "DocumentName" => CommandFilterKey::DocumentName,
            "ExecutionStage" => CommandFilterKey::ExecutionStage,
            "InvokedAfter" => CommandFilterKey::InvokedAfter,
            "InvokedBefore" => CommandFilterKey::InvokedBefore,
            "Status" => CommandFilterKey::Status,
            other => CommandFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CommandFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CommandFilterKey::from(s))
    }
}
impl CommandFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CommandFilterKey::DocumentName => "DocumentName",
            CommandFilterKey::ExecutionStage => "ExecutionStage",
            CommandFilterKey::InvokedAfter => "InvokedAfter",
            CommandFilterKey::InvokedBefore => "InvokedBefore",
            CommandFilterKey::Status => "Status",
            CommandFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DocumentName",
            "ExecutionStage",
            "InvokedAfter",
            "InvokedBefore",
            "Status",
        ]
    }
}
impl AsRef<str> for CommandFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An invocation is copy of a command sent to a specific instance. A command can apply to one
/// or more instances. A command invocation applies to one instance. For example, if a user runs
/// SendCommand against three instances, then a command invocation is created for each requested
/// instance ID. A command invocation returns status and detail information about a command you ran.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommandInvocation {
    /// <p>The command against which this invocation was requested.</p>
    pub command_id: std::option::Option<std::string::String>,
    /// <p>The instance ID in which this invocation was requested.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified host name of the managed instance.</p>
    pub instance_name: std::option::Option<std::string::String>,
    /// <p>User-specified information about the command, such as a brief description of what the
    /// command should do.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The document name that was requested for execution.</p>
    pub document_name: std::option::Option<std::string::String>,
    /// <p>The Systems Manager document (SSM document) version.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The time and date the request was sent to this instance.</p>
    pub requested_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Whether or not the invocation succeeded, failed, or is pending.</p>
    pub status: std::option::Option<crate::model::CommandInvocationStatus>,
    /// <p>A detailed status of the command execution for each invocation (each instance targeted by
    /// the command). StatusDetails includes more information than Status because it includes states
    /// resulting from error and concurrency control parameters. StatusDetails can show different results
    /// than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
    /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>Pending: The command hasn't been sent to the instance.</p>
    /// </li>
    /// <li>
    /// <p>In Progress: The command has been sent to the instance but hasn't reached a terminal
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>Success: The execution of the command or plugin was successfully completed. This is a
    /// terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Delivery Timed Out: The command wasn't delivered to the instance before the delivery
    /// timeout expired. Delivery timeouts don't count against the parent command's
    /// <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is
    /// Success or Incomplete. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Execution Timed Out: Command execution started on the instance, but the execution wasn't
    /// complete before the execution timeout expired. Execution timeouts count against the
    /// <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Failed: The command wasn't successful on the instance. For a plugin, this indicates that
    /// the result code wasn't zero. For a command invocation, this indicates that the result code for
    /// one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code>
    /// limit of the parent command. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Canceled: The command was terminated before it was completed. This is a terminal
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>Undeliverable: The command can't be delivered to the instance. The instance might not
    /// exist or might not be responding. Undeliverable invocations don't count against the parent
    /// command's MaxErrors limit and don't contribute to whether the parent command status is Success
    /// or Incomplete. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command
    /// invocations were canceled by the system. This is a terminal state.</p>
    /// </li>
    /// </ul>
    pub status_details: std::option::Option<std::string::String>,
    /// <p> Gets the trace output sent by the agent. </p>
    pub trace_output: std::option::Option<std::string::String>,
    /// <p>The URL to the plugin's StdOut file in Amazon Simple Storage Service (Amazon S3), if the S3
    /// bucket was defined for the parent command. For an invocation, <code>StandardOutputUrl</code> is
    /// populated if there is just one plugin defined for the command, and the S3 bucket was defined for
    /// the command.</p>
    pub standard_output_url: std::option::Option<std::string::String>,
    /// <p>The URL to the plugin's StdErr file in Amazon Simple Storage Service (Amazon S3), if the S3
    /// bucket was defined for the parent command. For an invocation, <code>StandardErrorUrl</code> is
    /// populated if there is just one plugin defined for the command, and the S3 bucket was defined for
    /// the command.</p>
    pub standard_error_url: std::option::Option<std::string::String>,
    /// <p>Plugins processed by the command.</p>
    pub command_plugins: std::option::Option<std::vec::Vec<crate::model::CommandPlugin>>,
    /// <p>The Identity and Access Management (IAM) service role that Run Command, a capability
    /// of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes
    /// on a per instance basis.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>Configurations for sending notifications about command status changes on a per instance
    /// basis.</p>
    pub notification_config: std::option::Option<crate::model::NotificationConfig>,
    /// <p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
    /// output.</p>
    pub cloud_watch_output_config: std::option::Option<crate::model::CloudWatchOutputConfig>,
}
impl std::fmt::Debug for CommandInvocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommandInvocation");
        formatter.field("command_id", &self.command_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_name", &self.instance_name);
        formatter.field("comment", &self.comment);
        formatter.field("document_name", &self.document_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("requested_date_time", &self.requested_date_time);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("trace_output", &self.trace_output);
        formatter.field("standard_output_url", &self.standard_output_url);
        formatter.field("standard_error_url", &self.standard_error_url);
        formatter.field("command_plugins", &self.command_plugins);
        formatter.field("service_role", &self.service_role);
        formatter.field("notification_config", &self.notification_config);
        formatter.field("cloud_watch_output_config", &self.cloud_watch_output_config);
        formatter.finish()
    }
}
/// See [`CommandInvocation`](crate::model::CommandInvocation)
pub mod command_invocation {
    /// A builder for [`CommandInvocation`](crate::model::CommandInvocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) document_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) requested_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::CommandInvocationStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) trace_output: std::option::Option<std::string::String>,
        pub(crate) standard_output_url: std::option::Option<std::string::String>,
        pub(crate) standard_error_url: std::option::Option<std::string::String>,
        pub(crate) command_plugins: std::option::Option<std::vec::Vec<crate::model::CommandPlugin>>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) notification_config: std::option::Option<crate::model::NotificationConfig>,
        pub(crate) cloud_watch_output_config:
            std::option::Option<crate::model::CloudWatchOutputConfig>,
    }
    impl Builder {
        /// <p>The command against which this invocation was requested.</p>
        pub fn command_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.command_id = Some(input.into());
            self
        }
        /// <p>The command against which this invocation was requested.</p>
        pub fn set_command_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command_id = input;
            self
        }
        /// <p>The instance ID in which this invocation was requested.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID in which this invocation was requested.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The fully qualified host name of the managed instance.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The fully qualified host name of the managed instance.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>User-specified information about the command, such as a brief description of what the
        /// command should do.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>User-specified information about the command, such as a brief description of what the
        /// command should do.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The document name that was requested for execution.</p>
        pub fn document_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_name = Some(input.into());
            self
        }
        /// <p>The document name that was requested for execution.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_name = input;
            self
        }
        /// <p>The Systems Manager document (SSM document) version.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The Systems Manager document (SSM document) version.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The time and date the request was sent to this instance.</p>
        pub fn requested_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.requested_date_time = Some(input);
            self
        }
        /// <p>The time and date the request was sent to this instance.</p>
        pub fn set_requested_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.requested_date_time = input;
            self
        }
        /// <p>Whether or not the invocation succeeded, failed, or is pending.</p>
        pub fn status(mut self, input: crate::model::CommandInvocationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Whether or not the invocation succeeded, failed, or is pending.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CommandInvocationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed status of the command execution for each invocation (each instance targeted by
        /// the command). StatusDetails includes more information than Status because it includes states
        /// resulting from error and concurrency control parameters. StatusDetails can show different results
        /// than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
        /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The command hasn't been sent to the instance.</p>
        /// </li>
        /// <li>
        /// <p>In Progress: The command has been sent to the instance but hasn't reached a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Success: The execution of the command or plugin was successfully completed. This is a
        /// terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Delivery Timed Out: The command wasn't delivered to the instance before the delivery
        /// timeout expired. Delivery timeouts don't count against the parent command's
        /// <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is
        /// Success or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Execution Timed Out: Command execution started on the instance, but the execution wasn't
        /// complete before the execution timeout expired. Execution timeouts count against the
        /// <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Failed: The command wasn't successful on the instance. For a plugin, this indicates that
        /// the result code wasn't zero. For a command invocation, this indicates that the result code for
        /// one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code>
        /// limit of the parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Canceled: The command was terminated before it was completed. This is a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Undeliverable: The command can't be delivered to the instance. The instance might not
        /// exist or might not be responding. Undeliverable invocations don't count against the parent
        /// command's MaxErrors limit and don't contribute to whether the parent command status is Success
        /// or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command
        /// invocations were canceled by the system. This is a terminal state.</p>
        /// </li>
        /// </ul>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>A detailed status of the command execution for each invocation (each instance targeted by
        /// the command). StatusDetails includes more information than Status because it includes states
        /// resulting from error and concurrency control parameters. StatusDetails can show different results
        /// than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
        /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The command hasn't been sent to the instance.</p>
        /// </li>
        /// <li>
        /// <p>In Progress: The command has been sent to the instance but hasn't reached a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Success: The execution of the command or plugin was successfully completed. This is a
        /// terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Delivery Timed Out: The command wasn't delivered to the instance before the delivery
        /// timeout expired. Delivery timeouts don't count against the parent command's
        /// <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is
        /// Success or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Execution Timed Out: Command execution started on the instance, but the execution wasn't
        /// complete before the execution timeout expired. Execution timeouts count against the
        /// <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Failed: The command wasn't successful on the instance. For a plugin, this indicates that
        /// the result code wasn't zero. For a command invocation, this indicates that the result code for
        /// one or more plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code>
        /// limit of the parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Canceled: The command was terminated before it was completed. This is a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Undeliverable: The command can't be delivered to the instance. The instance might not
        /// exist or might not be responding. Undeliverable invocations don't count against the parent
        /// command's MaxErrors limit and don't contribute to whether the parent command status is Success
        /// or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command
        /// invocations were canceled by the system. This is a terminal state.</p>
        /// </li>
        /// </ul>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p> Gets the trace output sent by the agent. </p>
        pub fn trace_output(mut self, input: impl Into<std::string::String>) -> Self {
            self.trace_output = Some(input.into());
            self
        }
        /// <p> Gets the trace output sent by the agent. </p>
        pub fn set_trace_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trace_output = input;
            self
        }
        /// <p>The URL to the plugin's StdOut file in Amazon Simple Storage Service (Amazon S3), if the S3
        /// bucket was defined for the parent command. For an invocation, <code>StandardOutputUrl</code> is
        /// populated if there is just one plugin defined for the command, and the S3 bucket was defined for
        /// the command.</p>
        pub fn standard_output_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_output_url = Some(input.into());
            self
        }
        /// <p>The URL to the plugin's StdOut file in Amazon Simple Storage Service (Amazon S3), if the S3
        /// bucket was defined for the parent command. For an invocation, <code>StandardOutputUrl</code> is
        /// populated if there is just one plugin defined for the command, and the S3 bucket was defined for
        /// the command.</p>
        pub fn set_standard_output_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_output_url = input;
            self
        }
        /// <p>The URL to the plugin's StdErr file in Amazon Simple Storage Service (Amazon S3), if the S3
        /// bucket was defined for the parent command. For an invocation, <code>StandardErrorUrl</code> is
        /// populated if there is just one plugin defined for the command, and the S3 bucket was defined for
        /// the command.</p>
        pub fn standard_error_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_error_url = Some(input.into());
            self
        }
        /// <p>The URL to the plugin's StdErr file in Amazon Simple Storage Service (Amazon S3), if the S3
        /// bucket was defined for the parent command. For an invocation, <code>StandardErrorUrl</code> is
        /// populated if there is just one plugin defined for the command, and the S3 bucket was defined for
        /// the command.</p>
        pub fn set_standard_error_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_error_url = input;
            self
        }
        /// Appends an item to `command_plugins`.
        ///
        /// To override the contents of this collection use [`set_command_plugins`](Self::set_command_plugins).
        ///
        /// <p>Plugins processed by the command.</p>
        pub fn command_plugins(mut self, input: impl Into<crate::model::CommandPlugin>) -> Self {
            let mut v = self.command_plugins.unwrap_or_default();
            v.push(input.into());
            self.command_plugins = Some(v);
            self
        }
        /// <p>Plugins processed by the command.</p>
        pub fn set_command_plugins(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommandPlugin>>,
        ) -> Self {
            self.command_plugins = input;
            self
        }
        /// <p>The Identity and Access Management (IAM) service role that Run Command, a capability
        /// of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes
        /// on a per instance basis.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The Identity and Access Management (IAM) service role that Run Command, a capability
        /// of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes
        /// on a per instance basis.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>Configurations for sending notifications about command status changes on a per instance
        /// basis.</p>
        pub fn notification_config(mut self, input: crate::model::NotificationConfig) -> Self {
            self.notification_config = Some(input);
            self
        }
        /// <p>Configurations for sending notifications about command status changes on a per instance
        /// basis.</p>
        pub fn set_notification_config(
            mut self,
            input: std::option::Option<crate::model::NotificationConfig>,
        ) -> Self {
            self.notification_config = input;
            self
        }
        /// <p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
        /// output.</p>
        pub fn cloud_watch_output_config(
            mut self,
            input: crate::model::CloudWatchOutputConfig,
        ) -> Self {
            self.cloud_watch_output_config = Some(input);
            self
        }
        /// <p>Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
        /// output.</p>
        pub fn set_cloud_watch_output_config(
            mut self,
            input: std::option::Option<crate::model::CloudWatchOutputConfig>,
        ) -> Self {
            self.cloud_watch_output_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CommandInvocation`](crate::model::CommandInvocation)
        pub fn build(self) -> crate::model::CommandInvocation {
            crate::model::CommandInvocation {
                command_id: self.command_id,
                instance_id: self.instance_id,
                instance_name: self.instance_name,
                comment: self.comment,
                document_name: self.document_name,
                document_version: self.document_version,
                requested_date_time: self.requested_date_time,
                status: self.status,
                status_details: self.status_details,
                trace_output: self.trace_output,
                standard_output_url: self.standard_output_url,
                standard_error_url: self.standard_error_url,
                command_plugins: self.command_plugins,
                service_role: self.service_role,
                notification_config: self.notification_config,
                cloud_watch_output_config: self.cloud_watch_output_config,
            }
        }
    }
}
impl CommandInvocation {
    /// Creates a new builder-style object to manufacture [`CommandInvocation`](crate::model::CommandInvocation)
    pub fn builder() -> crate::model::command_invocation::Builder {
        crate::model::command_invocation::Builder::default()
    }
}

/// <p>Describes plugin details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommandPlugin {
    /// <p>The name of the plugin. Must be one of the following: <code>aws:updateAgent</code>,
    /// <code>aws:domainjoin</code>, <code>aws:applications</code>,
    /// <code>aws:runPowerShellScript</code>, <code>aws:psmodule</code>, <code>aws:cloudWatch</code>,
    /// <code>aws:runShellScript</code>, or <code>aws:updateSSMAgent</code>. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of this plugin. You can run a document with multiple plugins.</p>
    pub status: std::option::Option<crate::model::CommandPluginStatus>,
    /// <p>A detailed status of the plugin execution. <code>StatusDetails</code> includes more
    /// information than Status because it includes states resulting from error and concurrency control
    /// parameters. StatusDetails can show different results than Status. For more information about
    /// these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
    /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
    /// following values:</p>
    /// <ul>
    /// <li>
    /// <p>Pending: The command hasn't been sent to the instance.</p>
    /// </li>
    /// <li>
    /// <p>In Progress: The command has been sent to the instance but hasn't reached a terminal
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>Success: The execution of the command or plugin was successfully completed. This is a
    /// terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Delivery Timed Out: The command wasn't delivered to the instance before the delivery
    /// timeout expired. Delivery timeouts don't count against the parent command's
    /// <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is
    /// Success or Incomplete. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Execution Timed Out: Command execution started on the instance, but the execution wasn't
    /// complete before the execution timeout expired. Execution timeouts count against the
    /// <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Failed: The command wasn't successful on the instance. For a plugin, this indicates that
    /// the result code wasn't zero. For a command invocation, this indicates that the result code for
    /// one or more plugins wasn't zero. Invocation failures count against the MaxErrors limit of the
    /// parent command. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Canceled: The command was terminated before it was completed. This is a terminal
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>Undeliverable: The command can't be delivered to the instance. The instance might not
    /// exist, or it might not be responding. Undeliverable invocations don't count against the parent
    /// command's MaxErrors limit, and they don't contribute to whether the parent command status is
    /// Success or Incomplete. This is a terminal state.</p>
    /// </li>
    /// <li>
    /// <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command
    /// invocations were canceled by the system. This is a terminal state.</p>
    /// </li>
    /// </ul>
    pub status_details: std::option::Option<std::string::String>,
    /// <p>A numeric response code generated after running the plugin. </p>
    pub response_code: i32,
    /// <p>The time the plugin started running. </p>
    pub response_start_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the plugin stopped running. Could stop prematurely if, for example, a cancel
    /// command was sent. </p>
    pub response_finish_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Output of the plugin execution.</p>
    pub output: std::option::Option<std::string::String>,
    /// <p>The URL for the complete text written by the plugin to stdout in Amazon S3. If the
    /// S3 bucket for the command wasn't specified, then this string is empty.</p>
    pub standard_output_url: std::option::Option<std::string::String>,
    /// <p>The URL for the complete text written by the plugin to stderr. If execution isn't yet
    /// complete, then this string is empty.</p>
    pub standard_error_url: std::option::Option<std::string::String>,
    /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead,
    /// Amazon Web Services Systems Manager automatically determines the S3 bucket region.</p>
    pub output_s3_region: std::option::Option<std::string::String>,
    /// <p>The S3 bucket where the responses to the command executions should be stored. This was
    /// requested when issuing the command. For example, in the following response:</p>
    /// <p>
    /// <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code>
    /// </p>
    /// <p>
    /// <code>doc-example-bucket</code> is the name of the S3 bucket;</p>
    /// <p>
    /// <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p>
    /// <p>
    /// <code>i-02573cafcfEXAMPLE</code> is the instance ID;</p>
    /// <p>
    /// <code>awsrunShellScript</code> is the name of the plugin.</p>
    pub output_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The S3 directory path inside the bucket where the responses to the command executions should
    /// be stored. This was requested when issuing the command. For example, in the following
    /// response:</p>
    /// <p>
    /// <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code>
    /// </p>
    /// <p>
    /// <code>doc-example-bucket</code> is the name of the S3 bucket;</p>
    /// <p>
    /// <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p>
    /// <p>
    /// <code>i-02573cafcfEXAMPLE</code> is the instance ID;</p>
    /// <p>
    /// <code>awsrunShellScript</code> is the name of the plugin.</p>
    pub output_s3_key_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CommandPlugin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommandPlugin");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("status_details", &self.status_details);
        formatter.field("response_code", &self.response_code);
        formatter.field("response_start_date_time", &self.response_start_date_time);
        formatter.field("response_finish_date_time", &self.response_finish_date_time);
        formatter.field("output", &self.output);
        formatter.field("standard_output_url", &self.standard_output_url);
        formatter.field("standard_error_url", &self.standard_error_url);
        formatter.field("output_s3_region", &self.output_s3_region);
        formatter.field("output_s3_bucket_name", &self.output_s3_bucket_name);
        formatter.field("output_s3_key_prefix", &self.output_s3_key_prefix);
        formatter.finish()
    }
}
/// See [`CommandPlugin`](crate::model::CommandPlugin)
pub mod command_plugin {
    /// A builder for [`CommandPlugin`](crate::model::CommandPlugin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CommandPluginStatus>,
        pub(crate) status_details: std::option::Option<std::string::String>,
        pub(crate) response_code: std::option::Option<i32>,
        pub(crate) response_start_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) response_finish_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) output: std::option::Option<std::string::String>,
        pub(crate) standard_output_url: std::option::Option<std::string::String>,
        pub(crate) standard_error_url: std::option::Option<std::string::String>,
        pub(crate) output_s3_region: std::option::Option<std::string::String>,
        pub(crate) output_s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) output_s3_key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the plugin. Must be one of the following: <code>aws:updateAgent</code>,
        /// <code>aws:domainjoin</code>, <code>aws:applications</code>,
        /// <code>aws:runPowerShellScript</code>, <code>aws:psmodule</code>, <code>aws:cloudWatch</code>,
        /// <code>aws:runShellScript</code>, or <code>aws:updateSSMAgent</code>. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the plugin. Must be one of the following: <code>aws:updateAgent</code>,
        /// <code>aws:domainjoin</code>, <code>aws:applications</code>,
        /// <code>aws:runPowerShellScript</code>, <code>aws:psmodule</code>, <code>aws:cloudWatch</code>,
        /// <code>aws:runShellScript</code>, or <code>aws:updateSSMAgent</code>. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of this plugin. You can run a document with multiple plugins.</p>
        pub fn status(mut self, input: crate::model::CommandPluginStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of this plugin. You can run a document with multiple plugins.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CommandPluginStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed status of the plugin execution. <code>StatusDetails</code> includes more
        /// information than Status because it includes states resulting from error and concurrency control
        /// parameters. StatusDetails can show different results than Status. For more information about
        /// these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
        /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The command hasn't been sent to the instance.</p>
        /// </li>
        /// <li>
        /// <p>In Progress: The command has been sent to the instance but hasn't reached a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Success: The execution of the command or plugin was successfully completed. This is a
        /// terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Delivery Timed Out: The command wasn't delivered to the instance before the delivery
        /// timeout expired. Delivery timeouts don't count against the parent command's
        /// <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is
        /// Success or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Execution Timed Out: Command execution started on the instance, but the execution wasn't
        /// complete before the execution timeout expired. Execution timeouts count against the
        /// <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Failed: The command wasn't successful on the instance. For a plugin, this indicates that
        /// the result code wasn't zero. For a command invocation, this indicates that the result code for
        /// one or more plugins wasn't zero. Invocation failures count against the MaxErrors limit of the
        /// parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Canceled: The command was terminated before it was completed. This is a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Undeliverable: The command can't be delivered to the instance. The instance might not
        /// exist, or it might not be responding. Undeliverable invocations don't count against the parent
        /// command's MaxErrors limit, and they don't contribute to whether the parent command status is
        /// Success or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command
        /// invocations were canceled by the system. This is a terminal state.</p>
        /// </li>
        /// </ul>
        pub fn status_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_details = Some(input.into());
            self
        }
        /// <p>A detailed status of the plugin execution. <code>StatusDetails</code> includes more
        /// information than Status because it includes states resulting from error and concurrency control
        /// parameters. StatusDetails can show different results than Status. For more information about
        /// these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
        /// statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. StatusDetails can be one of the
        /// following values:</p>
        /// <ul>
        /// <li>
        /// <p>Pending: The command hasn't been sent to the instance.</p>
        /// </li>
        /// <li>
        /// <p>In Progress: The command has been sent to the instance but hasn't reached a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Success: The execution of the command or plugin was successfully completed. This is a
        /// terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Delivery Timed Out: The command wasn't delivered to the instance before the delivery
        /// timeout expired. Delivery timeouts don't count against the parent command's
        /// <code>MaxErrors</code> limit, but they do contribute to whether the parent command status is
        /// Success or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Execution Timed Out: Command execution started on the instance, but the execution wasn't
        /// complete before the execution timeout expired. Execution timeouts count against the
        /// <code>MaxErrors</code> limit of the parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Failed: The command wasn't successful on the instance. For a plugin, this indicates that
        /// the result code wasn't zero. For a command invocation, this indicates that the result code for
        /// one or more plugins wasn't zero. Invocation failures count against the MaxErrors limit of the
        /// parent command. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Canceled: The command was terminated before it was completed. This is a terminal
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>Undeliverable: The command can't be delivered to the instance. The instance might not
        /// exist, or it might not be responding. Undeliverable invocations don't count against the parent
        /// command's MaxErrors limit, and they don't contribute to whether the parent command status is
        /// Success or Incomplete. This is a terminal state.</p>
        /// </li>
        /// <li>
        /// <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command
        /// invocations were canceled by the system. This is a terminal state.</p>
        /// </li>
        /// </ul>
        pub fn set_status_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_details = input;
            self
        }
        /// <p>A numeric response code generated after running the plugin. </p>
        pub fn response_code(mut self, input: i32) -> Self {
            self.response_code = Some(input);
            self
        }
        /// <p>A numeric response code generated after running the plugin. </p>
        pub fn set_response_code(mut self, input: std::option::Option<i32>) -> Self {
            self.response_code = input;
            self
        }
        /// <p>The time the plugin started running. </p>
        pub fn response_start_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.response_start_date_time = Some(input);
            self
        }
        /// <p>The time the plugin started running. </p>
        pub fn set_response_start_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.response_start_date_time = input;
            self
        }
        /// <p>The time the plugin stopped running. Could stop prematurely if, for example, a cancel
        /// command was sent. </p>
        pub fn response_finish_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.response_finish_date_time = Some(input);
            self
        }
        /// <p>The time the plugin stopped running. Could stop prematurely if, for example, a cancel
        /// command was sent. </p>
        pub fn set_response_finish_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.response_finish_date_time = input;
            self
        }
        /// <p>Output of the plugin execution.</p>
        pub fn output(mut self, input: impl Into<std::string::String>) -> Self {
            self.output = Some(input.into());
            self
        }
        /// <p>Output of the plugin execution.</p>
        pub fn set_output(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output = input;
            self
        }
        /// <p>The URL for the complete text written by the plugin to stdout in Amazon S3. If the
        /// S3 bucket for the command wasn't specified, then this string is empty.</p>
        pub fn standard_output_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_output_url = Some(input.into());
            self
        }
        /// <p>The URL for the complete text written by the plugin to stdout in Amazon S3. If the
        /// S3 bucket for the command wasn't specified, then this string is empty.</p>
        pub fn set_standard_output_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_output_url = input;
            self
        }
        /// <p>The URL for the complete text written by the plugin to stderr. If execution isn't yet
        /// complete, then this string is empty.</p>
        pub fn standard_error_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.standard_error_url = Some(input.into());
            self
        }
        /// <p>The URL for the complete text written by the plugin to stderr. If execution isn't yet
        /// complete, then this string is empty.</p>
        pub fn set_standard_error_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.standard_error_url = input;
            self
        }
        /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead,
        /// Amazon Web Services Systems Manager automatically determines the S3 bucket region.</p>
        pub fn output_s3_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_region = Some(input.into());
            self
        }
        /// <p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead,
        /// Amazon Web Services Systems Manager automatically determines the S3 bucket region.</p>
        pub fn set_output_s3_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_region = input;
            self
        }
        /// <p>The S3 bucket where the responses to the command executions should be stored. This was
        /// requested when issuing the command. For example, in the following response:</p>
        /// <p>
        /// <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code>
        /// </p>
        /// <p>
        /// <code>doc-example-bucket</code> is the name of the S3 bucket;</p>
        /// <p>
        /// <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p>
        /// <p>
        /// <code>i-02573cafcfEXAMPLE</code> is the instance ID;</p>
        /// <p>
        /// <code>awsrunShellScript</code> is the name of the plugin.</p>
        pub fn output_s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 bucket where the responses to the command executions should be stored. This was
        /// requested when issuing the command. For example, in the following response:</p>
        /// <p>
        /// <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code>
        /// </p>
        /// <p>
        /// <code>doc-example-bucket</code> is the name of the S3 bucket;</p>
        /// <p>
        /// <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p>
        /// <p>
        /// <code>i-02573cafcfEXAMPLE</code> is the instance ID;</p>
        /// <p>
        /// <code>awsrunShellScript</code> is the name of the plugin.</p>
        pub fn set_output_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_bucket_name = input;
            self
        }
        /// <p>The S3 directory path inside the bucket where the responses to the command executions should
        /// be stored. This was requested when issuing the command. For example, in the following
        /// response:</p>
        /// <p>
        /// <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code>
        /// </p>
        /// <p>
        /// <code>doc-example-bucket</code> is the name of the S3 bucket;</p>
        /// <p>
        /// <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p>
        /// <p>
        /// <code>i-02573cafcfEXAMPLE</code> is the instance ID;</p>
        /// <p>
        /// <code>awsrunShellScript</code> is the name of the plugin.</p>
        pub fn output_s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The S3 directory path inside the bucket where the responses to the command executions should
        /// be stored. This was requested when issuing the command. For example, in the following
        /// response:</p>
        /// <p>
        /// <code>doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript</code>
        /// </p>
        /// <p>
        /// <code>doc-example-bucket</code> is the name of the S3 bucket;</p>
        /// <p>
        /// <code>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix</code> is the name of the S3 prefix;</p>
        /// <p>
        /// <code>i-02573cafcfEXAMPLE</code> is the instance ID;</p>
        /// <p>
        /// <code>awsrunShellScript</code> is the name of the plugin.</p>
        pub fn set_output_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`CommandPlugin`](crate::model::CommandPlugin)
        pub fn build(self) -> crate::model::CommandPlugin {
            crate::model::CommandPlugin {
                name: self.name,
                status: self.status,
                status_details: self.status_details,
                response_code: self.response_code.unwrap_or_default(),
                response_start_date_time: self.response_start_date_time,
                response_finish_date_time: self.response_finish_date_time,
                output: self.output,
                standard_output_url: self.standard_output_url,
                standard_error_url: self.standard_error_url,
                output_s3_region: self.output_s3_region,
                output_s3_bucket_name: self.output_s3_bucket_name,
                output_s3_key_prefix: self.output_s3_key_prefix,
            }
        }
    }
}
impl CommandPlugin {
    /// Creates a new builder-style object to manufacture [`CommandPlugin`](crate::model::CommandPlugin)
    pub fn builder() -> crate::model::command_plugin::Builder {
        crate::model::command_plugin::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CommandPluginStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CommandPluginStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => CommandPluginStatus::Cancelled,
            "Failed" => CommandPluginStatus::Failed,
            "InProgress" => CommandPluginStatus::InProgress,
            "Pending" => CommandPluginStatus::Pending,
            "Success" => CommandPluginStatus::Success,
            "TimedOut" => CommandPluginStatus::TimedOut,
            other => CommandPluginStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CommandPluginStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CommandPluginStatus::from(s))
    }
}
impl CommandPluginStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CommandPluginStatus::Cancelled => "Cancelled",
            CommandPluginStatus::Failed => "Failed",
            CommandPluginStatus::InProgress => "InProgress",
            CommandPluginStatus::Pending => "Pending",
            CommandPluginStatus::Success => "Success",
            CommandPluginStatus::TimedOut => "TimedOut",
            CommandPluginStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Failed",
            "InProgress",
            "Pending",
            "Success",
            "TimedOut",
        ]
    }
}
impl AsRef<str> for CommandPluginStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CommandInvocationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Delayed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CommandInvocationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => CommandInvocationStatus::Cancelled,
            "Cancelling" => CommandInvocationStatus::Cancelling,
            "Delayed" => CommandInvocationStatus::Delayed,
            "Failed" => CommandInvocationStatus::Failed,
            "InProgress" => CommandInvocationStatus::InProgress,
            "Pending" => CommandInvocationStatus::Pending,
            "Success" => CommandInvocationStatus::Success,
            "TimedOut" => CommandInvocationStatus::TimedOut,
            other => CommandInvocationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CommandInvocationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CommandInvocationStatus::from(s))
    }
}
impl CommandInvocationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CommandInvocationStatus::Cancelled => "Cancelled",
            CommandInvocationStatus::Cancelling => "Cancelling",
            CommandInvocationStatus::Delayed => "Delayed",
            CommandInvocationStatus::Failed => "Failed",
            CommandInvocationStatus::InProgress => "InProgress",
            CommandInvocationStatus::Pending => "Pending",
            CommandInvocationStatus::Success => "Success",
            CommandInvocationStatus::TimedOut => "TimedOut",
            CommandInvocationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Cancelling",
            "Delayed",
            "Failed",
            "InProgress",
            "Pending",
            "Success",
            "TimedOut",
        ]
    }
}
impl AsRef<str> for CommandInvocationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the association version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociationVersionInfo {
    /// <p>The ID created by the system when the association was created.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The association version.</p>
    pub association_version: std::option::Option<std::string::String>,
    /// <p>The date the association version was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name specified when the association was created.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of an Amazon Web Services Systems Manager document (SSM document) used when the association version was
    /// created.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>Parameters specified when the association version was created.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The targets specified for the association when the association version was created. </p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The cron or rate schedule specified for the association when the association version was
    /// created.</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>The location in Amazon S3 specified for the association when the association version
    /// was created.</p>
    pub output_location: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
    /// <p>The name specified for the association version when the association version was
    /// created.</p>
    pub association_name: std::option::Option<std::string::String>,
    /// <p>The number of errors that are allowed before the system stops sending requests to run the
    /// association on additional targets. You can specify either an absolute number of errors, for
    /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
    /// the system stops sending requests when the fourth error is received. If you specify 0, then the
    /// system stops sending requests after the first error is returned. If you run an association on 50
    /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
    /// the sixth error is received.</p>
    /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
    /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
    /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
    /// so that executions proceed one at a time.</p>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>The maximum number of targets allowed to run the association at the same time. You can
    /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
    /// value is 100%, which means all targets run the association at the same time.</p>
    /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
    /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
    /// association interval, the new instance will process its association within the limit specified
    /// for <code>MaxConcurrency</code>.</p>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The severity level that is assigned to the association.</p>
    pub compliance_severity: std::option::Option<crate::model::AssociationComplianceSeverity>,
    /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
    /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
    /// execution to determine the compliance status. If the association execution runs successfully,
    /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
    /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
    /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
    /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
    /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
    /// <a>PutComplianceItems</a> API operation.</p>
    /// <p>By default, all associations use <code>AUTO</code> mode.</p>
    pub sync_compliance: std::option::Option<crate::model::AssociationSyncCompliance>,
    /// <p>By default, when you create a new associations, the system runs it immediately after it is
    /// created and then according to the schedule you specified. Specify this option if you don't want
    /// an association to run immediately after you create it. This parameter isn't supported for rate
    /// expressions.</p>
    pub apply_only_at_cron_interval: bool,
    /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
    /// associations are gated under. The associations for this version only run when that Change
    /// Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
    /// Calendar</a>.</p>
    pub calendar_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you wanted to run the association
    /// when this association version was created.</p>
    pub target_locations: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
}
impl std::fmt::Debug for AssociationVersionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociationVersionInfo");
        formatter.field("association_id", &self.association_id);
        formatter.field("association_version", &self.association_version);
        formatter.field("created_date", &self.created_date);
        formatter.field("name", &self.name);
        formatter.field("document_version", &self.document_version);
        formatter.field("parameters", &self.parameters);
        formatter.field("targets", &self.targets);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("output_location", &self.output_location);
        formatter.field("association_name", &self.association_name);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("compliance_severity", &self.compliance_severity);
        formatter.field("sync_compliance", &self.sync_compliance);
        formatter.field(
            "apply_only_at_cron_interval",
            &self.apply_only_at_cron_interval,
        );
        formatter.field("calendar_names", &self.calendar_names);
        formatter.field("target_locations", &self.target_locations);
        formatter.finish()
    }
}
/// See [`AssociationVersionInfo`](crate::model::AssociationVersionInfo)
pub mod association_version_info {
    /// A builder for [`AssociationVersionInfo`](crate::model::AssociationVersionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) association_version: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) output_location:
            std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        pub(crate) association_name: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) compliance_severity:
            std::option::Option<crate::model::AssociationComplianceSeverity>,
        pub(crate) sync_compliance: std::option::Option<crate::model::AssociationSyncCompliance>,
        pub(crate) apply_only_at_cron_interval: std::option::Option<bool>,
        pub(crate) calendar_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_locations:
            std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
    }
    impl Builder {
        /// <p>The ID created by the system when the association was created.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID created by the system when the association was created.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The association version.</p>
        pub fn association_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_version = Some(input.into());
            self
        }
        /// <p>The association version.</p>
        pub fn set_association_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_version = input;
            self
        }
        /// <p>The date the association version was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date the association version was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The name specified when the association was created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name specified when the association was created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of an Amazon Web Services Systems Manager document (SSM document) used when the association version was
        /// created.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of an Amazon Web Services Systems Manager document (SSM document) used when the association version was
        /// created.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Parameters specified when the association version was created.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>Parameters specified when the association version was created.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets specified for the association when the association version was created. </p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets specified for the association when the association version was created. </p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The cron or rate schedule specified for the association when the association version was
        /// created.</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>The cron or rate schedule specified for the association when the association version was
        /// created.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>The location in Amazon S3 specified for the association when the association version
        /// was created.</p>
        pub fn output_location(
            mut self,
            input: crate::model::InstanceAssociationOutputLocation,
        ) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>The location in Amazon S3 specified for the association when the association version
        /// was created.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::InstanceAssociationOutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The name specified for the association version when the association version was
        /// created.</p>
        pub fn association_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_name = Some(input.into());
            self
        }
        /// <p>The name specified for the association version when the association version was
        /// created.</p>
        pub fn set_association_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_name = input;
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The number of errors that are allowed before the system stops sending requests to run the
        /// association on additional targets. You can specify either an absolute number of errors, for
        /// example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
        /// the system stops sending requests when the fourth error is received. If you specify 0, then the
        /// system stops sending requests after the first error is returned. If you run an association on 50
        /// instances and set <code>MaxError</code> to 10%, then the system stops sending the request when
        /// the sixth error is received.</p>
        /// <p>Executions that are already running an association when <code>MaxErrors</code> is reached
        /// are allowed to complete, but some of these executions may fail as well. If you need to ensure
        /// that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1
        /// so that executions proceed one at a time.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The maximum number of targets allowed to run the association at the same time. You can
        /// specify a number, for example 10, or a percentage of the target set, for example 10%. The default
        /// value is 100%, which means all targets run the association at the same time.</p>
        /// <p>If a new instance starts and attempts to run an association while Systems Manager is running
        /// <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
        /// association interval, the new instance will process its association within the limit specified
        /// for <code>MaxConcurrency</code>.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The severity level that is assigned to the association.</p>
        pub fn compliance_severity(
            mut self,
            input: crate::model::AssociationComplianceSeverity,
        ) -> Self {
            self.compliance_severity = Some(input);
            self
        }
        /// <p>The severity level that is assigned to the association.</p>
        pub fn set_compliance_severity(
            mut self,
            input: std::option::Option<crate::model::AssociationComplianceSeverity>,
        ) -> Self {
            self.compliance_severity = input;
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
        /// <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn sync_compliance(mut self, input: crate::model::AssociationSyncCompliance) -> Self {
            self.sync_compliance = Some(input);
            self
        }
        /// <p>The mode for generating association compliance. You can specify <code>AUTO</code> or
        /// <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
        /// execution to determine the compliance status. If the association execution runs successfully,
        /// then the association is <code>COMPLIANT</code>. If the association execution doesn't run
        /// successfully, the association is <code>NON-COMPLIANT</code>.</p>
        /// <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter
        /// for the <a>PutComplianceItems</a> API operation. In this case, compliance data isn't
        /// managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
        /// <a>PutComplianceItems</a> API operation.</p>
        /// <p>By default, all associations use <code>AUTO</code> mode.</p>
        pub fn set_sync_compliance(
            mut self,
            input: std::option::Option<crate::model::AssociationSyncCompliance>,
        ) -> Self {
            self.sync_compliance = input;
            self
        }
        /// <p>By default, when you create a new associations, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn apply_only_at_cron_interval(mut self, input: bool) -> Self {
            self.apply_only_at_cron_interval = Some(input);
            self
        }
        /// <p>By default, when you create a new associations, the system runs it immediately after it is
        /// created and then according to the schedule you specified. Specify this option if you don't want
        /// an association to run immediately after you create it. This parameter isn't supported for rate
        /// expressions.</p>
        pub fn set_apply_only_at_cron_interval(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_only_at_cron_interval = input;
            self
        }
        /// Appends an item to `calendar_names`.
        ///
        /// To override the contents of this collection use [`set_calendar_names`](Self::set_calendar_names).
        ///
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
        /// associations are gated under. The associations for this version only run when that Change
        /// Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn calendar_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.calendar_names.unwrap_or_default();
            v.push(input.into());
            self.calendar_names = Some(v);
            self
        }
        /// <p>The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
        /// associations are gated under. The associations for this version only run when that Change
        /// Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
        /// Calendar</a>.</p>
        pub fn set_calendar_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.calendar_names = input;
            self
        }
        /// Appends an item to `target_locations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you wanted to run the association
        /// when this association version was created.</p>
        pub fn target_locations(mut self, input: impl Into<crate::model::TargetLocation>) -> Self {
            let mut v = self.target_locations.unwrap_or_default();
            v.push(input.into());
            self.target_locations = Some(v);
            self
        }
        /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts where you wanted to run the association
        /// when this association version was created.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.target_locations = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociationVersionInfo`](crate::model::AssociationVersionInfo)
        pub fn build(self) -> crate::model::AssociationVersionInfo {
            crate::model::AssociationVersionInfo {
                association_id: self.association_id,
                association_version: self.association_version,
                created_date: self.created_date,
                name: self.name,
                document_version: self.document_version,
                parameters: self.parameters,
                targets: self.targets,
                schedule_expression: self.schedule_expression,
                output_location: self.output_location,
                association_name: self.association_name,
                max_errors: self.max_errors,
                max_concurrency: self.max_concurrency,
                compliance_severity: self.compliance_severity,
                sync_compliance: self.sync_compliance,
                apply_only_at_cron_interval: self.apply_only_at_cron_interval.unwrap_or_default(),
                calendar_names: self.calendar_names,
                target_locations: self.target_locations,
            }
        }
    }
}
impl AssociationVersionInfo {
    /// Creates a new builder-style object to manufacture [`AssociationVersionInfo`](crate::model::AssociationVersionInfo)
    pub fn builder() -> crate::model::association_version_info::Builder {
        crate::model::association_version_info::Builder::default()
    }
}

/// <p>Describes an association of a Amazon Web Services Systems Manager document (SSM document) and an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Association {
    /// <p>The name of the SSM document.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The instance ID.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The ID created by the system when you create an association. An association is a binding
    /// between a document and a set of targets with a schedule.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The association version.</p>
    pub association_version: std::option::Option<std::string::String>,
    /// <p>The version of the document used in the association.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The instances targeted by the request to create an association. You can target all instances
    /// in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of
    /// <code>*</code>.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The date on which the association was last run.</p>
    pub last_execution_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Information about the association.</p>
    pub overview: std::option::Option<crate::model::AssociationOverview>,
    /// <p>A cron expression that specifies a schedule when the association runs. The schedule runs in
    /// Coordinated Universal Time (UTC).</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>The association name.</p>
    pub association_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Association {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Association");
        formatter.field("name", &self.name);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("association_id", &self.association_id);
        formatter.field("association_version", &self.association_version);
        formatter.field("document_version", &self.document_version);
        formatter.field("targets", &self.targets);
        formatter.field("last_execution_date", &self.last_execution_date);
        formatter.field("overview", &self.overview);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("association_name", &self.association_name);
        formatter.finish()
    }
}
/// See [`Association`](crate::model::Association)
pub mod association {
    /// A builder for [`Association`](crate::model::Association)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) association_version: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) last_execution_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) overview: std::option::Option<crate::model::AssociationOverview>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) association_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the SSM document.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSM document.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The instance ID.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The ID created by the system when you create an association. An association is a binding
        /// between a document and a set of targets with a schedule.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID created by the system when you create an association. An association is a binding
        /// between a document and a set of targets with a schedule.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The association version.</p>
        pub fn association_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_version = Some(input.into());
            self
        }
        /// <p>The association version.</p>
        pub fn set_association_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_version = input;
            self
        }
        /// <p>The version of the document used in the association.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of the document used in the association.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The instances targeted by the request to create an association. You can target all instances
        /// in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of
        /// <code>*</code>.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The instances targeted by the request to create an association. You can target all instances
        /// in an Amazon Web Services account by specifying the <code>InstanceIds</code> key with a value of
        /// <code>*</code>.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The date on which the association was last run.</p>
        pub fn last_execution_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_execution_date = Some(input);
            self
        }
        /// <p>The date on which the association was last run.</p>
        pub fn set_last_execution_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_execution_date = input;
            self
        }
        /// <p>Information about the association.</p>
        pub fn overview(mut self, input: crate::model::AssociationOverview) -> Self {
            self.overview = Some(input);
            self
        }
        /// <p>Information about the association.</p>
        pub fn set_overview(
            mut self,
            input: std::option::Option<crate::model::AssociationOverview>,
        ) -> Self {
            self.overview = input;
            self
        }
        /// <p>A cron expression that specifies a schedule when the association runs. The schedule runs in
        /// Coordinated Universal Time (UTC).</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A cron expression that specifies a schedule when the association runs. The schedule runs in
        /// Coordinated Universal Time (UTC).</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>The association name.</p>
        pub fn association_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_name = Some(input.into());
            self
        }
        /// <p>The association name.</p>
        pub fn set_association_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Association`](crate::model::Association)
        pub fn build(self) -> crate::model::Association {
            crate::model::Association {
                name: self.name,
                instance_id: self.instance_id,
                association_id: self.association_id,
                association_version: self.association_version,
                document_version: self.document_version,
                targets: self.targets,
                last_execution_date: self.last_execution_date,
                overview: self.overview,
                schedule_expression: self.schedule_expression,
                association_name: self.association_name,
            }
        }
    }
}
impl Association {
    /// Creates a new builder-style object to manufacture [`Association`](crate::model::Association)
    pub fn builder() -> crate::model::association::Builder {
        crate::model::association::Builder::default()
    }
}

/// <p>Describes a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociationFilter {
    /// <p>The name of the filter.</p>
    /// <note>
    /// <p>
    /// <code>InstanceId</code> has been deprecated.</p>
    /// </note>
    pub key: std::option::Option<crate::model::AssociationFilterKey>,
    /// <p>The filter value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociationFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociationFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`AssociationFilter`](crate::model::AssociationFilter)
pub mod association_filter {
    /// A builder for [`AssociationFilter`](crate::model::AssociationFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::AssociationFilterKey>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated.</p>
        /// </note>
        pub fn key(mut self, input: crate::model::AssociationFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        /// <note>
        /// <p>
        /// <code>InstanceId</code> has been deprecated.</p>
        /// </note>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::AssociationFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>The filter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The filter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociationFilter`](crate::model::AssociationFilter)
        pub fn build(self) -> crate::model::AssociationFilter {
            crate::model::AssociationFilter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl AssociationFilter {
    /// Creates a new builder-style object to manufacture [`AssociationFilter`](crate::model::AssociationFilter)
    pub fn builder() -> crate::model::association_filter::Builder {
        crate::model::association_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssociationFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    AssociationId,
    #[allow(missing_docs)] // documentation missing in model
    AssociationName,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    InstanceId,
    #[allow(missing_docs)] // documentation missing in model
    LastExecutedAfter,
    #[allow(missing_docs)] // documentation missing in model
    LastExecutedBefore,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    ResourceGroupName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssociationFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "AssociationId" => AssociationFilterKey::AssociationId,
            "AssociationName" => AssociationFilterKey::AssociationName,
            "AssociationStatusName" => AssociationFilterKey::Status,
            "InstanceId" => AssociationFilterKey::InstanceId,
            "LastExecutedAfter" => AssociationFilterKey::LastExecutedAfter,
            "LastExecutedBefore" => AssociationFilterKey::LastExecutedBefore,
            "Name" => AssociationFilterKey::Name,
            "ResourceGroupName" => AssociationFilterKey::ResourceGroupName,
            other => AssociationFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssociationFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssociationFilterKey::from(s))
    }
}
impl AssociationFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssociationFilterKey::AssociationId => "AssociationId",
            AssociationFilterKey::AssociationName => "AssociationName",
            AssociationFilterKey::Status => "AssociationStatusName",
            AssociationFilterKey::InstanceId => "InstanceId",
            AssociationFilterKey::LastExecutedAfter => "LastExecutedAfter",
            AssociationFilterKey::LastExecutedBefore => "LastExecutedBefore",
            AssociationFilterKey::Name => "Name",
            AssociationFilterKey::ResourceGroupName => "ResourceGroupName",
            AssociationFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AssociationId",
            "AssociationName",
            "AssociationStatusName",
            "InstanceId",
            "LastExecutedAfter",
            "LastExecutedBefore",
            "Name",
            "ResourceGroupName",
        ]
    }
}
impl AsRef<str> for AssociationFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An Amazon Web Services Systems Manager parameter in Parameter Store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>The name of the parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of parameter. Valid values include the following: <code>String</code>,
    /// <code>StringList</code>, and <code>SecureString</code>.</p>
    pub r#type: std::option::Option<crate::model::ParameterType>,
    /// <p>The parameter value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The parameter version.</p>
    pub version: i64,
    /// <p>Either the version number or the label used to retrieve the parameter value. Specify
    /// selectors by using one of the following formats:</p>
    /// <p>parameter_name:version</p>
    /// <p>parameter_name:label</p>
    pub selector: std::option::Option<std::string::String>,
    /// <p>Applies to parameters that reference information in other Amazon Web Services services.
    /// <code>SourceResult</code> is the raw result or response from the source.</p>
    pub source_result: std::option::Option<std::string::String>,
    /// <p>Date the parameter was last changed or updated and the parameter version was created.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the parameter.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
    /// default is <code>text</code>.</p>
    pub data_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.field("version", &self.version);
        formatter.field("selector", &self.selector);
        formatter.field("source_result", &self.source_result);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("arn", &self.arn);
        formatter.field("data_type", &self.data_type);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ParameterType>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) selector: std::option::Option<std::string::String>,
        pub(crate) source_result: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of parameter. Valid values include the following: <code>String</code>,
        /// <code>StringList</code>, and <code>SecureString</code>.</p>
        pub fn r#type(mut self, input: crate::model::ParameterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of parameter. Valid values include the following: <code>String</code>,
        /// <code>StringList</code>, and <code>SecureString</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ParameterType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The parameter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The parameter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The parameter version.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The parameter version.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>Either the version number or the label used to retrieve the parameter value. Specify
        /// selectors by using one of the following formats:</p>
        /// <p>parameter_name:version</p>
        /// <p>parameter_name:label</p>
        pub fn selector(mut self, input: impl Into<std::string::String>) -> Self {
            self.selector = Some(input.into());
            self
        }
        /// <p>Either the version number or the label used to retrieve the parameter value. Specify
        /// selectors by using one of the following formats:</p>
        /// <p>parameter_name:version</p>
        /// <p>parameter_name:label</p>
        pub fn set_selector(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.selector = input;
            self
        }
        /// <p>Applies to parameters that reference information in other Amazon Web Services services.
        /// <code>SourceResult</code> is the raw result or response from the source.</p>
        pub fn source_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_result = Some(input.into());
            self
        }
        /// <p>Applies to parameters that reference information in other Amazon Web Services services.
        /// <code>SourceResult</code> is the raw result or response from the source.</p>
        pub fn set_source_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_result = input;
            self
        }
        /// <p>Date the parameter was last changed or updated and the parameter version was created.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>Date the parameter was last changed or updated and the parameter version was created.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the parameter.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the parameter.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
        /// default is <code>text</code>.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
        /// default is <code>text</code>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                name: self.name,
                r#type: self.r#type,
                value: self.value,
                version: self.version.unwrap_or_default(),
                selector: self.selector,
                source_result: self.source_result,
                last_modified_date: self.last_modified_date,
                arn: self.arn,
                data_type: self.data_type,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

/// <p>One or more filters. Use a filter to return a more specific list of results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterStringFilter {
    /// <p>The name of the filter.</p>
    /// <p>The <code>ParameterStringFilter</code> object is used by the <a>DescribeParameters</a> and <a>GetParametersByPath</a> API operations.
    /// However, not all of the pattern values listed for <code>Key</code> can be used with both
    /// operations.</p>
    /// <p>For <code>DescribeActions</code>, all of the listed patterns are valid except
    /// <code>Label</code>.</p>
    /// <p>For <code>GetParametersByPath</code>, the following patterns listed for <code>Key</code>
    /// aren't valid: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and
    /// <code>Tier</code>.</p>
    /// <p>For examples of Amazon Web Services CLI commands demonstrating valid parameter filter constructions, see
    /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>For all filters used with <a>DescribeParameters</a>, valid options include
    /// <code>Equals</code> and <code>BeginsWith</code>. The <code>Name</code> filter additionally
    /// supports the <code>Contains</code> option. (Exception: For filters using the key
    /// <code>Path</code>, valid options include <code>Recursive</code> and
    /// <code>OneLevel</code>.)</p>
    /// <p>For filters used with <a>GetParametersByPath</a>, valid options include
    /// <code>Equals</code> and <code>BeginsWith</code>. (Exception: For filters using
    /// <code>Label</code> as the Key name, the only valid option is <code>Equals</code>.)</p>
    pub option: std::option::Option<std::string::String>,
    /// <p>The value you want to search for.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ParameterStringFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterStringFilter");
        formatter.field("key", &self.key);
        formatter.field("option", &self.option);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ParameterStringFilter`](crate::model::ParameterStringFilter)
pub mod parameter_string_filter {
    /// A builder for [`ParameterStringFilter`](crate::model::ParameterStringFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) option: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        /// <p>The <code>ParameterStringFilter</code> object is used by the <a>DescribeParameters</a> and <a>GetParametersByPath</a> API operations.
        /// However, not all of the pattern values listed for <code>Key</code> can be used with both
        /// operations.</p>
        /// <p>For <code>DescribeActions</code>, all of the listed patterns are valid except
        /// <code>Label</code>.</p>
        /// <p>For <code>GetParametersByPath</code>, the following patterns listed for <code>Key</code>
        /// aren't valid: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and
        /// <code>Tier</code>.</p>
        /// <p>For examples of Amazon Web Services CLI commands demonstrating valid parameter filter constructions, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        /// <p>The <code>ParameterStringFilter</code> object is used by the <a>DescribeParameters</a> and <a>GetParametersByPath</a> API operations.
        /// However, not all of the pattern values listed for <code>Key</code> can be used with both
        /// operations.</p>
        /// <p>For <code>DescribeActions</code>, all of the listed patterns are valid except
        /// <code>Label</code>.</p>
        /// <p>For <code>GetParametersByPath</code>, the following patterns listed for <code>Key</code>
        /// aren't valid: <code>tag</code>, <code>DataType</code>, <code>Name</code>, <code>Path</code>, and
        /// <code>Tier</code>.</p>
        /// <p>For examples of Amazon Web Services CLI commands demonstrating valid parameter filter constructions, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems Manager parameters</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>For all filters used with <a>DescribeParameters</a>, valid options include
        /// <code>Equals</code> and <code>BeginsWith</code>. The <code>Name</code> filter additionally
        /// supports the <code>Contains</code> option. (Exception: For filters using the key
        /// <code>Path</code>, valid options include <code>Recursive</code> and
        /// <code>OneLevel</code>.)</p>
        /// <p>For filters used with <a>GetParametersByPath</a>, valid options include
        /// <code>Equals</code> and <code>BeginsWith</code>. (Exception: For filters using
        /// <code>Label</code> as the Key name, the only valid option is <code>Equals</code>.)</p>
        pub fn option(mut self, input: impl Into<std::string::String>) -> Self {
            self.option = Some(input.into());
            self
        }
        /// <p>For all filters used with <a>DescribeParameters</a>, valid options include
        /// <code>Equals</code> and <code>BeginsWith</code>. The <code>Name</code> filter additionally
        /// supports the <code>Contains</code> option. (Exception: For filters using the key
        /// <code>Path</code>, valid options include <code>Recursive</code> and
        /// <code>OneLevel</code>.)</p>
        /// <p>For filters used with <a>GetParametersByPath</a>, valid options include
        /// <code>Equals</code> and <code>BeginsWith</code>. (Exception: For filters using
        /// <code>Label</code> as the Key name, the only valid option is <code>Equals</code>.)</p>
        pub fn set_option(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.option = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value you want to search for.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value you want to search for.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterStringFilter`](crate::model::ParameterStringFilter)
        pub fn build(self) -> crate::model::ParameterStringFilter {
            crate::model::ParameterStringFilter {
                key: self.key,
                option: self.option,
                values: self.values,
            }
        }
    }
}
impl ParameterStringFilter {
    /// Creates a new builder-style object to manufacture [`ParameterStringFilter`](crate::model::ParameterStringFilter)
    pub fn builder() -> crate::model::parameter_string_filter::Builder {
        crate::model::parameter_string_filter::Builder::default()
    }
}

/// <p>Information about parameter usage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterHistory {
    /// <p>The name of the parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of parameter used.</p>
    pub r#type: std::option::Option<crate::model::ParameterType>,
    /// <p>The ID of the query key used for this parameter.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>Date the parameter was last changed or updated.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>
    pub last_modified_user: std::option::Option<std::string::String>,
    /// <p>Information about the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The parameter value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Parameter names can include the following letters and symbols.</p>
    /// <p>a-zA-Z0-9_.-</p>
    pub allowed_pattern: std::option::Option<std::string::String>,
    /// <p>The parameter version.</p>
    pub version: i64,
    /// <p>Labels assigned to the parameter version.</p>
    pub labels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The parameter tier.</p>
    pub tier: std::option::Option<crate::model::ParameterTier>,
    /// <p>Information about the policies assigned to a parameter.</p>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
    /// policies</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::ParameterInlinePolicy>>,
    /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
    /// default is <code>text</code>.</p>
    pub data_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterHistory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterHistory");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("key_id", &self.key_id);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_user", &self.last_modified_user);
        formatter.field("description", &self.description);
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.field("allowed_pattern", &self.allowed_pattern);
        formatter.field("version", &self.version);
        formatter.field("labels", &self.labels);
        formatter.field("tier", &self.tier);
        formatter.field("policies", &self.policies);
        formatter.field("data_type", &self.data_type);
        formatter.finish()
    }
}
/// See [`ParameterHistory`](crate::model::ParameterHistory)
pub mod parameter_history {
    /// A builder for [`ParameterHistory`](crate::model::ParameterHistory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ParameterType>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_user: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) allowed_pattern: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) labels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tier: std::option::Option<crate::model::ParameterTier>,
        pub(crate) policies:
            std::option::Option<std::vec::Vec<crate::model::ParameterInlinePolicy>>,
        pub(crate) data_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of parameter used.</p>
        pub fn r#type(mut self, input: crate::model::ParameterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of parameter used.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ParameterType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the query key used for this parameter.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The ID of the query key used for this parameter.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>Date the parameter was last changed or updated.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>Date the parameter was last changed or updated.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>
        pub fn last_modified_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_user = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>
        pub fn set_last_modified_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_user = input;
            self
        }
        /// <p>Information about the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Information about the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The parameter value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The parameter value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Parameter names can include the following letters and symbols.</p>
        /// <p>a-zA-Z0-9_.-</p>
        pub fn allowed_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_pattern = Some(input.into());
            self
        }
        /// <p>Parameter names can include the following letters and symbols.</p>
        /// <p>a-zA-Z0-9_.-</p>
        pub fn set_allowed_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_pattern = input;
            self
        }
        /// <p>The parameter version.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The parameter version.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Labels assigned to the parameter version.</p>
        pub fn labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.labels.unwrap_or_default();
            v.push(input.into());
            self.labels = Some(v);
            self
        }
        /// <p>Labels assigned to the parameter version.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.labels = input;
            self
        }
        /// <p>The parameter tier.</p>
        pub fn tier(mut self, input: crate::model::ParameterTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The parameter tier.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::ParameterTier>) -> Self {
            self.tier = input;
            self
        }
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>Information about the policies assigned to a parameter.</p>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
        /// policies</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn policies(mut self, input: impl Into<crate::model::ParameterInlinePolicy>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>Information about the policies assigned to a parameter.</p>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
        /// policies</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterInlinePolicy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
        /// default is <code>text</code>.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
        /// default is <code>text</code>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterHistory`](crate::model::ParameterHistory)
        pub fn build(self) -> crate::model::ParameterHistory {
            crate::model::ParameterHistory {
                name: self.name,
                r#type: self.r#type,
                key_id: self.key_id,
                last_modified_date: self.last_modified_date,
                last_modified_user: self.last_modified_user,
                description: self.description,
                value: self.value,
                allowed_pattern: self.allowed_pattern,
                version: self.version.unwrap_or_default(),
                labels: self.labels,
                tier: self.tier,
                policies: self.policies,
                data_type: self.data_type,
            }
        }
    }
}
impl ParameterHistory {
    /// Creates a new builder-style object to manufacture [`ParameterHistory`](crate::model::ParameterHistory)
    pub fn builder() -> crate::model::parameter_history::Builder {
        crate::model::parameter_history::Builder::default()
    }
}

/// <p>One or more policies assigned to a parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterInlinePolicy {
    /// <p>The JSON text of the policy.</p>
    pub policy_text: std::option::Option<std::string::String>,
    /// <p>The type of policy. Parameter Store, a capablility of Amazon Web Services Systems Manager, supports the following
    /// policy types: Expiration, ExpirationNotification, and NoChangeNotification. </p>
    pub policy_type: std::option::Option<std::string::String>,
    /// <p>The status of the policy. Policies report the following statuses: Pending (the policy hasn't
    /// been enforced or applied yet), Finished (the policy was applied), Failed (the policy wasn't
    /// applied), or InProgress (the policy is being applied now). </p>
    pub policy_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterInlinePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterInlinePolicy");
        formatter.field("policy_text", &self.policy_text);
        formatter.field("policy_type", &self.policy_type);
        formatter.field("policy_status", &self.policy_status);
        formatter.finish()
    }
}
/// See [`ParameterInlinePolicy`](crate::model::ParameterInlinePolicy)
pub mod parameter_inline_policy {
    /// A builder for [`ParameterInlinePolicy`](crate::model::ParameterInlinePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_text: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<std::string::String>,
        pub(crate) policy_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The JSON text of the policy.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON text of the policy.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// <p>The type of policy. Parameter Store, a capablility of Amazon Web Services Systems Manager, supports the following
        /// policy types: Expiration, ExpirationNotification, and NoChangeNotification. </p>
        pub fn policy_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_type = Some(input.into());
            self
        }
        /// <p>The type of policy. Parameter Store, a capablility of Amazon Web Services Systems Manager, supports the following
        /// policy types: Expiration, ExpirationNotification, and NoChangeNotification. </p>
        pub fn set_policy_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>The status of the policy. Policies report the following statuses: Pending (the policy hasn't
        /// been enforced or applied yet), Finished (the policy was applied), Failed (the policy wasn't
        /// applied), or InProgress (the policy is being applied now). </p>
        pub fn policy_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_status = Some(input.into());
            self
        }
        /// <p>The status of the policy. Policies report the following statuses: Pending (the policy hasn't
        /// been enforced or applied yet), Finished (the policy was applied), Failed (the policy wasn't
        /// applied), or InProgress (the policy is being applied now). </p>
        pub fn set_policy_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterInlinePolicy`](crate::model::ParameterInlinePolicy)
        pub fn build(self) -> crate::model::ParameterInlinePolicy {
            crate::model::ParameterInlinePolicy {
                policy_text: self.policy_text,
                policy_type: self.policy_type,
                policy_status: self.policy_status,
            }
        }
    }
}
impl ParameterInlinePolicy {
    /// Creates a new builder-style object to manufacture [`ParameterInlinePolicy`](crate::model::ParameterInlinePolicy)
    pub fn builder() -> crate::model::parameter_inline_policy::Builder {
        crate::model::parameter_inline_policy::Builder::default()
    }
}

/// <p>The result of the query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsEntity {
    /// <p>The query ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The data returned by the query.</p>
    pub data: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::OpsEntityItem>,
    >,
}
impl std::fmt::Debug for OpsEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsEntity");
        formatter.field("id", &self.id);
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`OpsEntity`](crate::model::OpsEntity)
pub mod ops_entity {
    /// A builder for [`OpsEntity`](crate::model::OpsEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::OpsEntityItem>,
        >,
    }
    impl Builder {
        /// <p>The query ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The query ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `data`.
        ///
        /// To override the contents of this collection use [`set_data`](Self::set_data).
        ///
        /// <p>The data returned by the query.</p>
        pub fn data(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OpsEntityItem>,
        ) -> Self {
            let mut hash_map = self.data.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.data = Some(hash_map);
            self
        }
        /// <p>The data returned by the query.</p>
        pub fn set_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OpsEntityItem>,
            >,
        ) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsEntity`](crate::model::OpsEntity)
        pub fn build(self) -> crate::model::OpsEntity {
            crate::model::OpsEntity {
                id: self.id,
                data: self.data,
            }
        }
    }
}
impl OpsEntity {
    /// Creates a new builder-style object to manufacture [`OpsEntity`](crate::model::OpsEntity)
    pub fn builder() -> crate::model::ops_entity::Builder {
        crate::model::ops_entity::Builder::default()
    }
}

/// <p>The OpsData summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsEntityItem {
    /// <p>The time the OpsData was captured.</p>
    pub capture_time: std::option::Option<std::string::String>,
    /// <p>The details of an OpsData summary.</p>
    pub content: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
}
impl std::fmt::Debug for OpsEntityItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsEntityItem");
        formatter.field("capture_time", &self.capture_time);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`OpsEntityItem`](crate::model::OpsEntityItem)
pub mod ops_entity_item {
    /// A builder for [`OpsEntityItem`](crate::model::OpsEntityItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capture_time: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The time the OpsData was captured.</p>
        pub fn capture_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.capture_time = Some(input.into());
            self
        }
        /// <p>The time the OpsData was captured.</p>
        pub fn set_capture_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capture_time = input;
            self
        }
        /// Appends an item to `content`.
        ///
        /// To override the contents of this collection use [`set_content`](Self::set_content).
        ///
        /// <p>The details of an OpsData summary.</p>
        pub fn content(
            mut self,
            input: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut v = self.content.unwrap_or_default();
            v.push(input.into());
            self.content = Some(v);
            self
        }
        /// <p>The details of an OpsData summary.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsEntityItem`](crate::model::OpsEntityItem)
        pub fn build(self) -> crate::model::OpsEntityItem {
            crate::model::OpsEntityItem {
                capture_time: self.capture_time,
                content: self.content,
            }
        }
    }
}
impl OpsEntityItem {
    /// Creates a new builder-style object to manufacture [`OpsEntityItem`](crate::model::OpsEntityItem)
    pub fn builder() -> crate::model::ops_entity_item::Builder {
        crate::model::ops_entity_item::Builder::default()
    }
}

/// <p>The OpsItem data type to return.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsResultAttribute {
    /// <p>Name of the data type. Valid value: <code>AWS:OpsItem</code>,
    /// <code>AWS:EC2InstanceInformation</code>, <code>AWS:OpsItemTrendline</code>, or
    /// <code>AWS:ComplianceSummary</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OpsResultAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsResultAttribute");
        formatter.field("type_name", &self.type_name);
        formatter.finish()
    }
}
/// See [`OpsResultAttribute`](crate::model::OpsResultAttribute)
pub mod ops_result_attribute {
    /// A builder for [`OpsResultAttribute`](crate::model::OpsResultAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the data type. Valid value: <code>AWS:OpsItem</code>,
        /// <code>AWS:EC2InstanceInformation</code>, <code>AWS:OpsItemTrendline</code>, or
        /// <code>AWS:ComplianceSummary</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>Name of the data type. Valid value: <code>AWS:OpsItem</code>,
        /// <code>AWS:EC2InstanceInformation</code>, <code>AWS:OpsItemTrendline</code>, or
        /// <code>AWS:ComplianceSummary</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsResultAttribute`](crate::model::OpsResultAttribute)
        pub fn build(self) -> crate::model::OpsResultAttribute {
            crate::model::OpsResultAttribute {
                type_name: self.type_name,
            }
        }
    }
}
impl OpsResultAttribute {
    /// Creates a new builder-style object to manufacture [`OpsResultAttribute`](crate::model::OpsResultAttribute)
    pub fn builder() -> crate::model::ops_result_attribute::Builder {
        crate::model::ops_result_attribute::Builder::default()
    }
}

/// <p>One or more aggregators for viewing counts of OpsData using different dimensions such as
/// <code>Source</code>, <code>CreatedTime</code>, or <code>Source and CreatedTime</code>, to name a
/// few.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsAggregator {
    /// <p>Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData
    /// summary.</p>
    pub aggregator_type: std::option::Option<std::string::String>,
    /// <p>The data type name to use for viewing counts of OpsData.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The name of an OpsData attribute on which to limit the count of OpsData.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The aggregator value.</p>
    pub values:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The aggregator filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::OpsFilter>>,
    /// <p>A nested aggregator for viewing counts of OpsData.</p>
    pub aggregators: std::option::Option<std::vec::Vec<crate::model::OpsAggregator>>,
}
impl std::fmt::Debug for OpsAggregator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsAggregator");
        formatter.field("aggregator_type", &self.aggregator_type);
        formatter.field("type_name", &self.type_name);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("values", &self.values);
        formatter.field("filters", &self.filters);
        formatter.field("aggregators", &self.aggregators);
        formatter.finish()
    }
}
/// See [`OpsAggregator`](crate::model::OpsAggregator)
pub mod ops_aggregator {
    /// A builder for [`OpsAggregator`](crate::model::OpsAggregator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aggregator_type: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::OpsFilter>>,
        pub(crate) aggregators: std::option::Option<std::vec::Vec<crate::model::OpsAggregator>>,
    }
    impl Builder {
        /// <p>Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData
        /// summary.</p>
        pub fn aggregator_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregator_type = Some(input.into());
            self
        }
        /// <p>Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData
        /// summary.</p>
        pub fn set_aggregator_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregator_type = input;
            self
        }
        /// <p>The data type name to use for viewing counts of OpsData.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The data type name to use for viewing counts of OpsData.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The name of an OpsData attribute on which to limit the count of OpsData.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of an OpsData attribute on which to limit the count of OpsData.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Adds a key-value pair to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The aggregator value.</p>
        pub fn values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.values = Some(hash_map);
            self
        }
        /// <p>The aggregator value.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The aggregator filters.</p>
        pub fn filters(mut self, input: impl Into<crate::model::OpsFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The aggregator filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>A nested aggregator for viewing counts of OpsData.</p>
        pub fn aggregators(mut self, input: impl Into<crate::model::OpsAggregator>) -> Self {
            let mut v = self.aggregators.unwrap_or_default();
            v.push(input.into());
            self.aggregators = Some(v);
            self
        }
        /// <p>A nested aggregator for viewing counts of OpsData.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsAggregator>>,
        ) -> Self {
            self.aggregators = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsAggregator`](crate::model::OpsAggregator)
        pub fn build(self) -> crate::model::OpsAggregator {
            crate::model::OpsAggregator {
                aggregator_type: self.aggregator_type,
                type_name: self.type_name,
                attribute_name: self.attribute_name,
                values: self.values,
                filters: self.filters,
                aggregators: self.aggregators,
            }
        }
    }
}
impl OpsAggregator {
    /// Creates a new builder-style object to manufacture [`OpsAggregator`](crate::model::OpsAggregator)
    pub fn builder() -> crate::model::ops_aggregator::Builder {
        crate::model::ops_aggregator::Builder::default()
    }
}

/// <p>A filter for viewing OpsData summaries.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsFilter {
    /// <p>The name of the filter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The filter value.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of filter.</p>
    pub r#type: std::option::Option<crate::model::OpsFilterOperatorType>,
}
impl std::fmt::Debug for OpsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`OpsFilter`](crate::model::OpsFilter)
pub mod ops_filter {
    /// A builder for [`OpsFilter`](crate::model::OpsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::OpsFilterOperatorType>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter value.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter value.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The type of filter.</p>
        pub fn r#type(mut self, input: crate::model::OpsFilterOperatorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of filter.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::OpsFilterOperatorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsFilter`](crate::model::OpsFilter)
        pub fn build(self) -> crate::model::OpsFilter {
            crate::model::OpsFilter {
                key: self.key,
                values: self.values,
                r#type: self.r#type,
            }
        }
    }
}
impl OpsFilter {
    /// Creates a new builder-style object to manufacture [`OpsFilter`](crate::model::OpsFilter)
    pub fn builder() -> crate::model::ops_filter::Builder {
        crate::model::ops_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsFilterOperatorType {
    #[allow(missing_docs)] // documentation missing in model
    BeginWith,
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    Exists,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    NotEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsFilterOperatorType {
    fn from(s: &str) -> Self {
        match s {
            "BeginWith" => OpsFilterOperatorType::BeginWith,
            "Equal" => OpsFilterOperatorType::Equal,
            "Exists" => OpsFilterOperatorType::Exists,
            "GreaterThan" => OpsFilterOperatorType::GreaterThan,
            "LessThan" => OpsFilterOperatorType::LessThan,
            "NotEqual" => OpsFilterOperatorType::NotEqual,
            other => OpsFilterOperatorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsFilterOperatorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsFilterOperatorType::from(s))
    }
}
impl OpsFilterOperatorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsFilterOperatorType::BeginWith => "BeginWith",
            OpsFilterOperatorType::Equal => "Equal",
            OpsFilterOperatorType::Exists => "Exists",
            OpsFilterOperatorType::GreaterThan => "GreaterThan",
            OpsFilterOperatorType::LessThan => "LessThan",
            OpsFilterOperatorType::NotEqual => "NotEqual",
            OpsFilterOperatorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BeginWith",
            "Equal",
            "Exists",
            "GreaterThan",
            "LessThan",
            "NotEqual",
        ]
    }
}
impl AsRef<str> for OpsFilterOperatorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
/// remediate operational work items (OpsItems) impacting the performance and health of their Amazon Web Services
/// resources. OpsCenter is integrated with Amazon EventBridge and Amazon CloudWatch. This
/// means you can configure these services to automatically create an OpsItem in OpsCenter when a
/// CloudWatch alarm enters the ALARM state or when EventBridge processes an event from
/// any Amazon Web Services service that publishes events. Configuring Amazon CloudWatch alarms and EventBridge events to automatically create OpsItems allows you to quickly diagnose and remediate
/// issues with Amazon Web Services resources from a single console.</p>
/// <p>To help you diagnose issues, each OpsItem includes contextually relevant information such as
/// the name and ID of the Amazon Web Services resource that generated the OpsItem, alarm or event details, alarm
/// history, and an alarm timeline graph. For the Amazon Web Services resource, OpsCenter aggregates information
/// from Config, CloudTrail logs, and EventBridge, so you don't have
/// to navigate across multiple console pages during your investigation. For more information, see
/// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItem {
    /// <p>The ARN of the Amazon Web Services account that created the OpsItem.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code>
    /// and <code>/aws/issue</code>.</p>
    pub ops_item_type: std::option::Option<std::string::String>,
    /// <p>The date and time the OpsItem was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The OpsItem description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ARN of the Amazon Web Services account that last updated the OpsItem.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time the OpsItem was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
    /// notifications are sent when this OpsItem is edited or changed.</p>
    pub notifications: std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
    /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
    pub priority: std::option::Option<i32>,
    /// <p>One or more OpsItems that share something in common with the current OpsItem. For example,
    /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
    /// statuses for the impacted resource.</p>
    pub related_ops_items: std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
    /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
    /// <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub status: std::option::Option<crate::model::OpsItemStatus>,
    /// <p>The ID of the OpsItem.</p>
    pub ops_item_id: std::option::Option<std::string::String>,
    /// <p>The version of this OpsItem. Each time the OpsItem is edited the version number increments
    /// by one.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of
    /// source.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
    /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
    /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
    /// of 128 characters. The value has a maximum size of 20 KB.</p>
    /// <important>
    /// <p>Operational data keys <i>can't</i> begin with the following:
    /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
    /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
    /// </important>
    /// <p>You can choose to make the data searchable by other users in the account or you can restrict
    /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
    /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
    /// specified data. Operational data that isn't searchable is only viewable by users who have access
    /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
    /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
    /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
    /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
    /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub operational_data: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
    >,
    /// <p>An OpsItem category. Category options include: Availability, Cost, Performance, Recovery,
    /// Security.</p>
    pub category: std::option::Option<std::string::String>,
    /// <p>The severity of the OpsItem. Severity options range from 1 to 4.</p>
    pub severity: std::option::Option<std::string::String>,
    /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
    /// <code>/aws/changerequest</code>.</p>
    pub actual_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
    /// <code>/aws/changerequest</code>.</p>
    pub actual_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
    /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
    pub planned_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
    /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
    pub planned_end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for OpsItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItem");
        formatter.field("created_by", &self.created_by);
        formatter.field("ops_item_type", &self.ops_item_type);
        formatter.field("created_time", &self.created_time);
        formatter.field("description", &self.description);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("notifications", &self.notifications);
        formatter.field("priority", &self.priority);
        formatter.field("related_ops_items", &self.related_ops_items);
        formatter.field("status", &self.status);
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.field("version", &self.version);
        formatter.field("title", &self.title);
        formatter.field("source", &self.source);
        formatter.field("operational_data", &self.operational_data);
        formatter.field("category", &self.category);
        formatter.field("severity", &self.severity);
        formatter.field("actual_start_time", &self.actual_start_time);
        formatter.field("actual_end_time", &self.actual_end_time);
        formatter.field("planned_start_time", &self.planned_start_time);
        formatter.field("planned_end_time", &self.planned_end_time);
        formatter.finish()
    }
}
/// See [`OpsItem`](crate::model::OpsItem)
pub mod ops_item {
    /// A builder for [`OpsItem`](crate::model::OpsItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) ops_item_type: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) notifications:
            std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) related_ops_items:
            std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
        pub(crate) status: std::option::Option<crate::model::OpsItemStatus>,
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) operational_data: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
        >,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<std::string::String>,
        pub(crate) actual_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) actual_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) planned_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) planned_end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the Amazon Web Services account that created the OpsItem.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Web Services account that created the OpsItem.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code>
        /// and <code>/aws/issue</code>.</p>
        pub fn ops_item_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_type = Some(input.into());
            self
        }
        /// <p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code>
        /// and <code>/aws/issue</code>.</p>
        pub fn set_ops_item_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_item_type = input;
            self
        }
        /// <p>The date and time the OpsItem was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time the OpsItem was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The OpsItem description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The OpsItem description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ARN of the Amazon Web Services account that last updated the OpsItem.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Web Services account that last updated the OpsItem.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time the OpsItem was last updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time the OpsItem was last updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Appends an item to `notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
        /// notifications are sent when this OpsItem is edited or changed.</p>
        pub fn notifications(
            mut self,
            input: impl Into<crate::model::OpsItemNotification>,
        ) -> Self {
            let mut v = self.notifications.unwrap_or_default();
            v.push(input.into());
            self.notifications = Some(v);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
        /// notifications are sent when this OpsItem is edited or changed.</p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpsItemNotification>>,
        ) -> Self {
            self.notifications = input;
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Appends an item to `related_ops_items`.
        ///
        /// To override the contents of this collection use [`set_related_ops_items`](Self::set_related_ops_items).
        ///
        /// <p>One or more OpsItems that share something in common with the current OpsItem. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn related_ops_items(mut self, input: impl Into<crate::model::RelatedOpsItem>) -> Self {
            let mut v = self.related_ops_items.unwrap_or_default();
            v.push(input.into());
            self.related_ops_items = Some(v);
            self
        }
        /// <p>One or more OpsItems that share something in common with the current OpsItem. For example,
        /// related OpsItems can include OpsItems with similar error messages, impacted resources, or
        /// statuses for the impacted resource.</p>
        pub fn set_related_ops_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelatedOpsItem>>,
        ) -> Self {
            self.related_ops_items = input;
            self
        }
        /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
        /// <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn status(mut self, input: crate::model::OpsItemStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
        /// <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html">Editing OpsItem details</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OpsItemStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// <p>The version of this OpsItem. Each time the OpsItem is edited the version number increments
        /// by one.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of this OpsItem. Each time the OpsItem is edited the version number increments
        /// by one.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of
        /// source.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of
        /// source.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Adds a key-value pair to `operational_data`.
        ///
        /// To override the contents of this collection use [`set_operational_data`](Self::set_operational_data).
        ///
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn operational_data(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OpsItemDataValue>,
        ) -> Self {
            let mut hash_map = self.operational_data.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.operational_data = Some(hash_map);
            self
        }
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// For example, you can specify log files, error strings, license keys, troubleshooting tips, or
        /// other relevant data. You enter operational data as key-value pairs. The key has a maximum length
        /// of 128 characters. The value has a maximum size of 20 KB.</p>
        /// <important>
        /// <p>Operational data keys <i>can't</i> begin with the following:
        /// <code>amazon</code>, <code>aws</code>, <code>amzn</code>, <code>ssm</code>,
        /// <code>/amazon</code>, <code>/aws</code>, <code>/amzn</code>, <code>/ssm</code>.</p>
        /// </important>
        /// <p>You can choose to make the data searchable by other users in the account or you can restrict
        /// search access. Searchable data means that all users with access to the OpsItem Overview page (as
        /// provided by the <a>DescribeOpsItems</a> API operation) can view and search on the
        /// specified data. Operational data that isn't searchable is only viewable by users who have access
        /// to the OpsItem (as provided by the <a>GetOpsItem</a> API operation).</p>
        /// <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in
        /// the request. Use the <code>/aws/automations</code> key in OperationalData to associate an
        /// Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
        /// <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_operational_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
            >,
        ) -> Self {
            self.operational_data = input;
            self
        }
        /// <p>An OpsItem category. Category options include: Availability, Cost, Performance, Recovery,
        /// Security.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>An OpsItem category. Category options include: Availability, Cost, Performance, Recovery,
        /// Security.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// <p>The severity of the OpsItem. Severity options range from 1 to 4.</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity = Some(input.into());
            self
        }
        /// <p>The severity of the OpsItem. Severity options range from 1 to 4.</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.actual_start_time = Some(input);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.actual_start_time = input;
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.actual_end_time = Some(input);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.actual_end_time = input;
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.planned_start_time = Some(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.planned_start_time = input;
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.planned_end_time = Some(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.planned_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItem`](crate::model::OpsItem)
        pub fn build(self) -> crate::model::OpsItem {
            crate::model::OpsItem {
                created_by: self.created_by,
                ops_item_type: self.ops_item_type,
                created_time: self.created_time,
                description: self.description,
                last_modified_by: self.last_modified_by,
                last_modified_time: self.last_modified_time,
                notifications: self.notifications,
                priority: self.priority,
                related_ops_items: self.related_ops_items,
                status: self.status,
                ops_item_id: self.ops_item_id,
                version: self.version,
                title: self.title,
                source: self.source,
                operational_data: self.operational_data,
                category: self.category,
                severity: self.severity,
                actual_start_time: self.actual_start_time,
                actual_end_time: self.actual_end_time,
                planned_start_time: self.planned_start_time,
                planned_end_time: self.planned_end_time,
            }
        }
    }
}
impl OpsItem {
    /// Creates a new builder-style object to manufacture [`OpsItem`](crate::model::OpsItem)
    pub fn builder() -> crate::model::ops_item::Builder {
        crate::model::ops_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MaintenanceWindowExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    SkippedOverlapping,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MaintenanceWindowExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => MaintenanceWindowExecutionStatus::Cancelled,
            "CANCELLING" => MaintenanceWindowExecutionStatus::Cancelling,
            "FAILED" => MaintenanceWindowExecutionStatus::Failed,
            "IN_PROGRESS" => MaintenanceWindowExecutionStatus::InProgress,
            "PENDING" => MaintenanceWindowExecutionStatus::Pending,
            "SKIPPED_OVERLAPPING" => MaintenanceWindowExecutionStatus::SkippedOverlapping,
            "SUCCESS" => MaintenanceWindowExecutionStatus::Success,
            "TIMED_OUT" => MaintenanceWindowExecutionStatus::TimedOut,
            other => MaintenanceWindowExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MaintenanceWindowExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MaintenanceWindowExecutionStatus::from(s))
    }
}
impl MaintenanceWindowExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MaintenanceWindowExecutionStatus::Cancelled => "CANCELLED",
            MaintenanceWindowExecutionStatus::Cancelling => "CANCELLING",
            MaintenanceWindowExecutionStatus::Failed => "FAILED",
            MaintenanceWindowExecutionStatus::InProgress => "IN_PROGRESS",
            MaintenanceWindowExecutionStatus::Pending => "PENDING",
            MaintenanceWindowExecutionStatus::SkippedOverlapping => "SKIPPED_OVERLAPPING",
            MaintenanceWindowExecutionStatus::Success => "SUCCESS",
            MaintenanceWindowExecutionStatus::TimedOut => "TIMED_OUT",
            MaintenanceWindowExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "CANCELLING",
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "SKIPPED_OVERLAPPING",
            "SUCCESS",
            "TIMED_OUT",
        ]
    }
}
impl AsRef<str> for MaintenanceWindowExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The inventory item schema definition. Users can use this to compose inventory query
/// filters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryItemSchema {
    /// <p>The name of the inventory type. Default inventory item type names start with Amazon Web Services. Custom
    /// inventory type names will start with Custom. Default inventory item types include the following:
    /// <code>AWS:AWSComponent</code>, <code>AWS:Application</code>,
    /// <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and
    /// <code>AWS:WindowsUpdate</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The schema version for the inventory item.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The schema attributes for inventory. This contains data type and attribute name.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::InventoryItemAttribute>>,
    /// <p>The alias name of the inventory type. The alias name is used for display purposes.</p>
    pub display_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InventoryItemSchema {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryItemSchema");
        formatter.field("type_name", &self.type_name);
        formatter.field("version", &self.version);
        formatter.field("attributes", &self.attributes);
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`InventoryItemSchema`](crate::model::InventoryItemSchema)
pub mod inventory_item_schema {
    /// A builder for [`InventoryItemSchema`](crate::model::InventoryItemSchema)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::InventoryItemAttribute>>,
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the inventory type. Default inventory item type names start with Amazon Web Services. Custom
        /// inventory type names will start with Custom. Default inventory item types include the following:
        /// <code>AWS:AWSComponent</code>, <code>AWS:Application</code>,
        /// <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and
        /// <code>AWS:WindowsUpdate</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the inventory type. Default inventory item type names start with Amazon Web Services. Custom
        /// inventory type names will start with Custom. Default inventory item types include the following:
        /// <code>AWS:AWSComponent</code>, <code>AWS:Application</code>,
        /// <code>AWS:InstanceInformation</code>, <code>AWS:Network</code>, and
        /// <code>AWS:WindowsUpdate</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The schema version for the inventory item.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The schema version for the inventory item.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The schema attributes for inventory. This contains data type and attribute name.</p>
        pub fn attributes(
            mut self,
            input: impl Into<crate::model::InventoryItemAttribute>,
        ) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The schema attributes for inventory. This contains data type and attribute name.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryItemAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The alias name of the inventory type. The alias name is used for display purposes.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The alias name of the inventory type. The alias name is used for display purposes.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryItemSchema`](crate::model::InventoryItemSchema)
        pub fn build(self) -> crate::model::InventoryItemSchema {
            crate::model::InventoryItemSchema {
                type_name: self.type_name,
                version: self.version,
                attributes: self.attributes,
                display_name: self.display_name,
            }
        }
    }
}
impl InventoryItemSchema {
    /// Creates a new builder-style object to manufacture [`InventoryItemSchema`](crate::model::InventoryItemSchema)
    pub fn builder() -> crate::model::inventory_item_schema::Builder {
        crate::model::inventory_item_schema::Builder::default()
    }
}

/// <p>Attributes are the entries within the inventory item content. It contains name and
/// value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryItemAttribute {
    /// <p>Name of the inventory item attribute.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the inventory item attribute. </p>
    pub data_type: std::option::Option<crate::model::InventoryAttributeDataType>,
}
impl std::fmt::Debug for InventoryItemAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryItemAttribute");
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.finish()
    }
}
/// See [`InventoryItemAttribute`](crate::model::InventoryItemAttribute)
pub mod inventory_item_attribute {
    /// A builder for [`InventoryItemAttribute`](crate::model::InventoryItemAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<crate::model::InventoryAttributeDataType>,
    }
    impl Builder {
        /// <p>Name of the inventory item attribute.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the inventory item attribute.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the inventory item attribute. </p>
        pub fn data_type(mut self, input: crate::model::InventoryAttributeDataType) -> Self {
            self.data_type = Some(input);
            self
        }
        /// <p>The data type of the inventory item attribute. </p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<crate::model::InventoryAttributeDataType>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryItemAttribute`](crate::model::InventoryItemAttribute)
        pub fn build(self) -> crate::model::InventoryItemAttribute {
            crate::model::InventoryItemAttribute {
                name: self.name,
                data_type: self.data_type,
            }
        }
    }
}
impl InventoryItemAttribute {
    /// Creates a new builder-style object to manufacture [`InventoryItemAttribute`](crate::model::InventoryItemAttribute)
    pub fn builder() -> crate::model::inventory_item_attribute::Builder {
        crate::model::inventory_item_attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InventoryAttributeDataType {
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InventoryAttributeDataType {
    fn from(s: &str) -> Self {
        match s {
            "number" => InventoryAttributeDataType::Number,
            "string" => InventoryAttributeDataType::String,
            other => InventoryAttributeDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InventoryAttributeDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InventoryAttributeDataType::from(s))
    }
}
impl InventoryAttributeDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InventoryAttributeDataType::Number => "number",
            InventoryAttributeDataType::String => "string",
            InventoryAttributeDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["number", "string"]
    }
}
impl AsRef<str> for InventoryAttributeDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Inventory query results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryResultEntity {
    /// <p>ID of the inventory result entity. For example, for managed instance inventory the result
    /// will be the managed instance ID. For EC2 instance inventory, the result will be the instance ID.
    /// </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The data section in the inventory result entity JSON.</p>
    pub data: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::InventoryResultItem>,
    >,
}
impl std::fmt::Debug for InventoryResultEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryResultEntity");
        formatter.field("id", &self.id);
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`InventoryResultEntity`](crate::model::InventoryResultEntity)
pub mod inventory_result_entity {
    /// A builder for [`InventoryResultEntity`](crate::model::InventoryResultEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::InventoryResultItem>,
        >,
    }
    impl Builder {
        /// <p>ID of the inventory result entity. For example, for managed instance inventory the result
        /// will be the managed instance ID. For EC2 instance inventory, the result will be the instance ID.
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>ID of the inventory result entity. For example, for managed instance inventory the result
        /// will be the managed instance ID. For EC2 instance inventory, the result will be the instance ID.
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `data`.
        ///
        /// To override the contents of this collection use [`set_data`](Self::set_data).
        ///
        /// <p>The data section in the inventory result entity JSON.</p>
        pub fn data(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::InventoryResultItem>,
        ) -> Self {
            let mut hash_map = self.data.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.data = Some(hash_map);
            self
        }
        /// <p>The data section in the inventory result entity JSON.</p>
        pub fn set_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::InventoryResultItem>,
            >,
        ) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryResultEntity`](crate::model::InventoryResultEntity)
        pub fn build(self) -> crate::model::InventoryResultEntity {
            crate::model::InventoryResultEntity {
                id: self.id,
                data: self.data,
            }
        }
    }
}
impl InventoryResultEntity {
    /// Creates a new builder-style object to manufacture [`InventoryResultEntity`](crate::model::InventoryResultEntity)
    pub fn builder() -> crate::model::inventory_result_entity::Builder {
        crate::model::inventory_result_entity::Builder::default()
    }
}

/// <p>The inventory result item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryResultItem {
    /// <p>The name of the inventory result item type.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The schema version for the inventory result item/</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The time inventory item data was captured.</p>
    pub capture_time: std::option::Option<std::string::String>,
    /// <p>MD5 hash of the inventory item type contents. The content hash is used to determine whether
    /// to update inventory information. The PutInventory API doesn't update the inventory item type
    /// contents if the MD5 hash hasn't changed since last update. </p>
    pub content_hash: std::option::Option<std::string::String>,
    /// <p>Contains all the inventory data of the item type. Results include attribute names and
    /// values. </p>
    pub content: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
}
impl std::fmt::Debug for InventoryResultItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryResultItem");
        formatter.field("type_name", &self.type_name);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("capture_time", &self.capture_time);
        formatter.field("content_hash", &self.content_hash);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`InventoryResultItem`](crate::model::InventoryResultItem)
pub mod inventory_result_item {
    /// A builder for [`InventoryResultItem`](crate::model::InventoryResultItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) capture_time: std::option::Option<std::string::String>,
        pub(crate) content_hash: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The name of the inventory result item type.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the inventory result item type.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The schema version for the inventory result item/</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The schema version for the inventory result item/</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The time inventory item data was captured.</p>
        pub fn capture_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.capture_time = Some(input.into());
            self
        }
        /// <p>The time inventory item data was captured.</p>
        pub fn set_capture_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.capture_time = input;
            self
        }
        /// <p>MD5 hash of the inventory item type contents. The content hash is used to determine whether
        /// to update inventory information. The PutInventory API doesn't update the inventory item type
        /// contents if the MD5 hash hasn't changed since last update. </p>
        pub fn content_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_hash = Some(input.into());
            self
        }
        /// <p>MD5 hash of the inventory item type contents. The content hash is used to determine whether
        /// to update inventory information. The PutInventory API doesn't update the inventory item type
        /// contents if the MD5 hash hasn't changed since last update. </p>
        pub fn set_content_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_hash = input;
            self
        }
        /// Appends an item to `content`.
        ///
        /// To override the contents of this collection use [`set_content`](Self::set_content).
        ///
        /// <p>Contains all the inventory data of the item type. Results include attribute names and
        /// values. </p>
        pub fn content(
            mut self,
            input: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut v = self.content.unwrap_or_default();
            v.push(input.into());
            self.content = Some(v);
            self
        }
        /// <p>Contains all the inventory data of the item type. Results include attribute names and
        /// values. </p>
        pub fn set_content(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryResultItem`](crate::model::InventoryResultItem)
        pub fn build(self) -> crate::model::InventoryResultItem {
            crate::model::InventoryResultItem {
                type_name: self.type_name,
                schema_version: self.schema_version,
                capture_time: self.capture_time,
                content_hash: self.content_hash,
                content: self.content,
            }
        }
    }
}
impl InventoryResultItem {
    /// Creates a new builder-style object to manufacture [`InventoryResultItem`](crate::model::InventoryResultItem)
    pub fn builder() -> crate::model::inventory_result_item::Builder {
        crate::model::inventory_result_item::Builder::default()
    }
}

/// <p>The inventory item result attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultAttribute {
    /// <p>Name of the inventory item type. Valid value: <code>AWS:InstanceInformation</code>. Default
    /// Value: <code>AWS:InstanceInformation</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResultAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultAttribute");
        formatter.field("type_name", &self.type_name);
        formatter.finish()
    }
}
/// See [`ResultAttribute`](crate::model::ResultAttribute)
pub mod result_attribute {
    /// A builder for [`ResultAttribute`](crate::model::ResultAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the inventory item type. Valid value: <code>AWS:InstanceInformation</code>. Default
        /// Value: <code>AWS:InstanceInformation</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>Name of the inventory item type. Valid value: <code>AWS:InstanceInformation</code>. Default
        /// Value: <code>AWS:InstanceInformation</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultAttribute`](crate::model::ResultAttribute)
        pub fn build(self) -> crate::model::ResultAttribute {
            crate::model::ResultAttribute {
                type_name: self.type_name,
            }
        }
    }
}
impl ResultAttribute {
    /// Creates a new builder-style object to manufacture [`ResultAttribute`](crate::model::ResultAttribute)
    pub fn builder() -> crate::model::result_attribute::Builder {
        crate::model::result_attribute::Builder::default()
    }
}

/// <p>Specifies the inventory type and attribute for the aggregation execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryAggregator {
    /// <p>The inventory type and attribute name for aggregation.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>Nested aggregators to further refine aggregation for an inventory type.</p>
    pub aggregators: std::option::Option<std::vec::Vec<crate::model::InventoryAggregator>>,
    /// <p>A user-defined set of one or more filters on which to aggregate inventory data. Groups
    /// return a count of resources that match and don't match the specified criteria.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::InventoryGroup>>,
}
impl std::fmt::Debug for InventoryAggregator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryAggregator");
        formatter.field("expression", &self.expression);
        formatter.field("aggregators", &self.aggregators);
        formatter.field("groups", &self.groups);
        formatter.finish()
    }
}
/// See [`InventoryAggregator`](crate::model::InventoryAggregator)
pub mod inventory_aggregator {
    /// A builder for [`InventoryAggregator`](crate::model::InventoryAggregator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) aggregators:
            std::option::Option<std::vec::Vec<crate::model::InventoryAggregator>>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::InventoryGroup>>,
    }
    impl Builder {
        /// <p>The inventory type and attribute name for aggregation.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The inventory type and attribute name for aggregation.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Appends an item to `aggregators`.
        ///
        /// To override the contents of this collection use [`set_aggregators`](Self::set_aggregators).
        ///
        /// <p>Nested aggregators to further refine aggregation for an inventory type.</p>
        pub fn aggregators(mut self, input: impl Into<crate::model::InventoryAggregator>) -> Self {
            let mut v = self.aggregators.unwrap_or_default();
            v.push(input.into());
            self.aggregators = Some(v);
            self
        }
        /// <p>Nested aggregators to further refine aggregation for an inventory type.</p>
        pub fn set_aggregators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryAggregator>>,
        ) -> Self {
            self.aggregators = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>A user-defined set of one or more filters on which to aggregate inventory data. Groups
        /// return a count of resources that match and don't match the specified criteria.</p>
        pub fn groups(mut self, input: impl Into<crate::model::InventoryGroup>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>A user-defined set of one or more filters on which to aggregate inventory data. Groups
        /// return a count of resources that match and don't match the specified criteria.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryGroup>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryAggregator`](crate::model::InventoryAggregator)
        pub fn build(self) -> crate::model::InventoryAggregator {
            crate::model::InventoryAggregator {
                expression: self.expression,
                aggregators: self.aggregators,
                groups: self.groups,
            }
        }
    }
}
impl InventoryAggregator {
    /// Creates a new builder-style object to manufacture [`InventoryAggregator`](crate::model::InventoryAggregator)
    pub fn builder() -> crate::model::inventory_aggregator::Builder {
        crate::model::inventory_aggregator::Builder::default()
    }
}

/// <p>A user-defined set of one or more filters on which to aggregate inventory data. Groups
/// return a count of resources that match and don't match the specified criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryGroup {
    /// <p>The name of the group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Filters define the criteria for the group. The <code>matchingCount</code> field displays the
    /// number of resources that match the criteria. The <code>notMatchingCount</code> field displays the
    /// number of resources that don't match the criteria. </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
}
impl std::fmt::Debug for InventoryGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryGroup");
        formatter.field("name", &self.name);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}
/// See [`InventoryGroup`](crate::model::InventoryGroup)
pub mod inventory_group {
    /// A builder for [`InventoryGroup`](crate::model::InventoryGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters define the criteria for the group. The <code>matchingCount</code> field displays the
        /// number of resources that match the criteria. The <code>notMatchingCount</code> field displays the
        /// number of resources that don't match the criteria. </p>
        pub fn filters(mut self, input: impl Into<crate::model::InventoryFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters define the criteria for the group. The <code>matchingCount</code> field displays the
        /// number of resources that match the criteria. The <code>notMatchingCount</code> field displays the
        /// number of resources that don't match the criteria. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryGroup`](crate::model::InventoryGroup)
        pub fn build(self) -> crate::model::InventoryGroup {
            crate::model::InventoryGroup {
                name: self.name,
                filters: self.filters,
            }
        }
    }
}
impl InventoryGroup {
    /// Creates a new builder-style object to manufacture [`InventoryGroup`](crate::model::InventoryGroup)
    pub fn builder() -> crate::model::inventory_group::Builder {
        crate::model::inventory_group::Builder::default()
    }
}

/// <p>A structure that includes attributes that describe a document attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentContent {
    /// <p>The name of an attachment.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The size of an attachment in bytes.</p>
    pub size: i64,
    /// <p>The cryptographic hash value of the document content.</p>
    pub hash: std::option::Option<std::string::String>,
    /// <p>The hash algorithm used to calculate the hash value.</p>
    pub hash_type: std::option::Option<crate::model::AttachmentHashType>,
    /// <p>The URL location of the attachment content.</p>
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentContent");
        formatter.field("name", &self.name);
        formatter.field("size", &self.size);
        formatter.field("hash", &self.hash);
        formatter.field("hash_type", &self.hash_type);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`AttachmentContent`](crate::model::AttachmentContent)
pub mod attachment_content {
    /// A builder for [`AttachmentContent`](crate::model::AttachmentContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) hash: std::option::Option<std::string::String>,
        pub(crate) hash_type: std::option::Option<crate::model::AttachmentHashType>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an attachment.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an attachment.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The size of an attachment in bytes.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of an attachment in bytes.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p>The cryptographic hash value of the document content.</p>
        pub fn hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.hash = Some(input.into());
            self
        }
        /// <p>The cryptographic hash value of the document content.</p>
        pub fn set_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hash = input;
            self
        }
        /// <p>The hash algorithm used to calculate the hash value.</p>
        pub fn hash_type(mut self, input: crate::model::AttachmentHashType) -> Self {
            self.hash_type = Some(input);
            self
        }
        /// <p>The hash algorithm used to calculate the hash value.</p>
        pub fn set_hash_type(
            mut self,
            input: std::option::Option<crate::model::AttachmentHashType>,
        ) -> Self {
            self.hash_type = input;
            self
        }
        /// <p>The URL location of the attachment content.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL location of the attachment content.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentContent`](crate::model::AttachmentContent)
        pub fn build(self) -> crate::model::AttachmentContent {
            crate::model::AttachmentContent {
                name: self.name,
                size: self.size.unwrap_or_default(),
                hash: self.hash,
                hash_type: self.hash_type,
                url: self.url,
            }
        }
    }
}
impl AttachmentContent {
    /// Creates a new builder-style object to manufacture [`AttachmentContent`](crate::model::AttachmentContent)
    pub fn builder() -> crate::model::attachment_content::Builder {
        crate::model::attachment_content::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttachmentHashType {
    #[allow(missing_docs)] // documentation missing in model
    Sha256,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttachmentHashType {
    fn from(s: &str) -> Self {
        match s {
            "Sha256" => AttachmentHashType::Sha256,
            other => AttachmentHashType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttachmentHashType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttachmentHashType::from(s))
    }
}
impl AttachmentHashType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttachmentHashType::Sha256 => "Sha256",
            AttachmentHashType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Sha256"]
    }
}
impl AsRef<str> for AttachmentHashType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the basic information about a patch baseline override.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaselineOverride {
    /// <p>The operating system rule used by the patch baseline override.</p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>A set of patch filters, typically used for approval rules.</p>
    pub global_filters: std::option::Option<crate::model::PatchFilterGroup>,
    /// <p>A set of rules defining the approval rules for a patch baseline.</p>
    pub approval_rules: std::option::Option<crate::model::PatchRuleGroup>,
    /// <p>A list of explicitly approved patches for the baseline.</p>
    /// <p>For information about accepted formats for lists of approved patches and rejected patches,
    /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
    /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub approved_patches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Defines the compliance level for approved patches. When an approved patch is reported as
    /// missing, this value describes the severity of the compliance violation.</p>
    pub approved_patches_compliance_level: std::option::Option<crate::model::PatchComplianceLevel>,
    /// <p>A list of explicitly rejected patches for the baseline.</p>
    /// <p>For information about accepted formats for lists of approved patches and rejected patches,
    /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
    /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
    pub rejected_patches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The action for Patch Manager to take on patches included in the
    /// <code>RejectedPackages</code> list. A patch can be allowed only if it is a dependency of another
    /// package, or blocked entirely along with packages that include it as a dependency.</p>
    pub rejected_patches_action: std::option::Option<crate::model::PatchAction>,
    /// <p>Indicates whether the list of approved patches includes non-security updates that should be
    /// applied to the instances. The default value is <code>false</code>. Applies to Linux instances
    /// only.</p>
    pub approved_patches_enable_non_security: bool,
    /// <p>Information about the patches to use to update the instances, including target operating
    /// systems and source repositories. Applies to Linux instances only.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
}
impl std::fmt::Debug for BaselineOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaselineOverride");
        formatter.field("operating_system", &self.operating_system);
        formatter.field("global_filters", &self.global_filters);
        formatter.field("approval_rules", &self.approval_rules);
        formatter.field("approved_patches", &self.approved_patches);
        formatter.field(
            "approved_patches_compliance_level",
            &self.approved_patches_compliance_level,
        );
        formatter.field("rejected_patches", &self.rejected_patches);
        formatter.field("rejected_patches_action", &self.rejected_patches_action);
        formatter.field(
            "approved_patches_enable_non_security",
            &self.approved_patches_enable_non_security,
        );
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}
/// See [`BaselineOverride`](crate::model::BaselineOverride)
pub mod baseline_override {
    /// A builder for [`BaselineOverride`](crate::model::BaselineOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) global_filters: std::option::Option<crate::model::PatchFilterGroup>,
        pub(crate) approval_rules: std::option::Option<crate::model::PatchRuleGroup>,
        pub(crate) approved_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) approved_patches_compliance_level:
            std::option::Option<crate::model::PatchComplianceLevel>,
        pub(crate) rejected_patches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rejected_patches_action: std::option::Option<crate::model::PatchAction>,
        pub(crate) approved_patches_enable_non_security: std::option::Option<bool>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
    }
    impl Builder {
        /// <p>The operating system rule used by the patch baseline override.</p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>The operating system rule used by the patch baseline override.</p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>A set of patch filters, typically used for approval rules.</p>
        pub fn global_filters(mut self, input: crate::model::PatchFilterGroup) -> Self {
            self.global_filters = Some(input);
            self
        }
        /// <p>A set of patch filters, typically used for approval rules.</p>
        pub fn set_global_filters(
            mut self,
            input: std::option::Option<crate::model::PatchFilterGroup>,
        ) -> Self {
            self.global_filters = input;
            self
        }
        /// <p>A set of rules defining the approval rules for a patch baseline.</p>
        pub fn approval_rules(mut self, input: crate::model::PatchRuleGroup) -> Self {
            self.approval_rules = Some(input);
            self
        }
        /// <p>A set of rules defining the approval rules for a patch baseline.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<crate::model::PatchRuleGroup>,
        ) -> Self {
            self.approval_rules = input;
            self
        }
        /// Appends an item to `approved_patches`.
        ///
        /// To override the contents of this collection use [`set_approved_patches`](Self::set_approved_patches).
        ///
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn approved_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.approved_patches.unwrap_or_default();
            v.push(input.into());
            self.approved_patches = Some(v);
            self
        }
        /// <p>A list of explicitly approved patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_approved_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approved_patches = input;
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as
        /// missing, this value describes the severity of the compliance violation.</p>
        pub fn approved_patches_compliance_level(
            mut self,
            input: crate::model::PatchComplianceLevel,
        ) -> Self {
            self.approved_patches_compliance_level = Some(input);
            self
        }
        /// <p>Defines the compliance level for approved patches. When an approved patch is reported as
        /// missing, this value describes the severity of the compliance violation.</p>
        pub fn set_approved_patches_compliance_level(
            mut self,
            input: std::option::Option<crate::model::PatchComplianceLevel>,
        ) -> Self {
            self.approved_patches_compliance_level = input;
            self
        }
        /// Appends an item to `rejected_patches`.
        ///
        /// To override the contents of this collection use [`set_rejected_patches`](Self::set_rejected_patches).
        ///
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn rejected_patches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.rejected_patches.unwrap_or_default();
            v.push(input.into());
            self.rejected_patches = Some(v);
            self
        }
        /// <p>A list of explicitly rejected patches for the baseline.</p>
        /// <p>For information about accepted formats for lists of approved patches and rejected patches,
        /// see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
        /// package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.</p>
        pub fn set_rejected_patches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.rejected_patches = input;
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list. A patch can be allowed only if it is a dependency of another
        /// package, or blocked entirely along with packages that include it as a dependency.</p>
        pub fn rejected_patches_action(mut self, input: crate::model::PatchAction) -> Self {
            self.rejected_patches_action = Some(input);
            self
        }
        /// <p>The action for Patch Manager to take on patches included in the
        /// <code>RejectedPackages</code> list. A patch can be allowed only if it is a dependency of another
        /// package, or blocked entirely along with packages that include it as a dependency.</p>
        pub fn set_rejected_patches_action(
            mut self,
            input: std::option::Option<crate::model::PatchAction>,
        ) -> Self {
            self.rejected_patches_action = input;
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the instances. The default value is <code>false</code>. Applies to Linux instances
        /// only.</p>
        pub fn approved_patches_enable_non_security(mut self, input: bool) -> Self {
            self.approved_patches_enable_non_security = Some(input);
            self
        }
        /// <p>Indicates whether the list of approved patches includes non-security updates that should be
        /// applied to the instances. The default value is <code>false</code>. Applies to Linux instances
        /// only.</p>
        pub fn set_approved_patches_enable_non_security(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.approved_patches_enable_non_security = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>Information about the patches to use to update the instances, including target operating
        /// systems and source repositories. Applies to Linux instances only.</p>
        pub fn sources(mut self, input: impl Into<crate::model::PatchSource>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>Information about the patches to use to update the instances, including target operating
        /// systems and source repositories. Applies to Linux instances only.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PatchSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`BaselineOverride`](crate::model::BaselineOverride)
        pub fn build(self) -> crate::model::BaselineOverride {
            crate::model::BaselineOverride {
                operating_system: self.operating_system,
                global_filters: self.global_filters,
                approval_rules: self.approval_rules,
                approved_patches: self.approved_patches,
                approved_patches_compliance_level: self.approved_patches_compliance_level,
                rejected_patches: self.rejected_patches,
                rejected_patches_action: self.rejected_patches_action,
                approved_patches_enable_non_security: self
                    .approved_patches_enable_non_security
                    .unwrap_or_default(),
                sources: self.sources,
            }
        }
    }
}
impl BaselineOverride {
    /// Creates a new builder-style object to manufacture [`BaselineOverride`](crate::model::BaselineOverride)
    pub fn builder() -> crate::model::baseline_override::Builder {
        crate::model::baseline_override::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    NotConnected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Connected" => ConnectionStatus::Connected,
            "NotConnected" => ConnectionStatus::NotConnected,
            other => ConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionStatus::from(s))
    }
}
impl ConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionStatus::Connected => "Connected",
            ConnectionStatus::NotConnected => "NotConnected",
            ConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Connected", "NotConnected"]
    }
}
impl AsRef<str> for ConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CalendarState {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CalendarState {
    fn from(s: &str) -> Self {
        match s {
            "CLOSED" => CalendarState::Closed,
            "OPEN" => CalendarState::Open,
            other => CalendarState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CalendarState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CalendarState::from(s))
    }
}
impl CalendarState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CalendarState::Closed => "CLOSED",
            CalendarState::Open => "OPEN",
            CalendarState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSED", "OPEN"]
    }
}
impl AsRef<str> for CalendarState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Detailed information about the current state of an individual Automation execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomationExecution {
    /// <p>The execution ID.</p>
    pub automation_execution_id: std::option::Option<std::string::String>,
    /// <p>The name of the Automation runbook used during the execution.</p>
    pub document_name: std::option::Option<std::string::String>,
    /// <p>The version of the document to use during execution.</p>
    pub document_version: std::option::Option<std::string::String>,
    /// <p>The time the execution started.</p>
    pub execution_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time the execution finished.</p>
    pub execution_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The execution status of the Automation.</p>
    pub automation_execution_status: std::option::Option<crate::model::AutomationExecutionStatus>,
    /// <p>A list of details about the current state of all steps that comprise an execution. An
    /// Automation runbook contains a list of steps that are run in order.</p>
    pub step_executions: std::option::Option<std::vec::Vec<crate::model::StepExecution>>,
    /// <p>A boolean value that indicates if the response contains the full list of the Automation step
    /// executions. If true, use the DescribeAutomationStepExecutions API operation to get the full list
    /// of step executions.</p>
    pub step_executions_truncated: bool,
    /// <p>The key-value map of execution parameters, which were supplied when calling <a>StartAutomationExecution</a>.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The list of execution outputs as defined in the Automation runbook.</p>
    pub outputs: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>A message describing why an execution has failed, if the status is set to Failed.</p>
    pub failure_message: std::option::Option<std::string::String>,
    /// <p>The automation execution mode.</p>
    pub mode: std::option::Option<crate::model::ExecutionMode>,
    /// <p>The AutomationExecutionId of the parent automation.</p>
    pub parent_automation_execution_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the user who ran the automation.</p>
    pub executed_by: std::option::Option<std::string::String>,
    /// <p>The name of the step that is currently running.</p>
    pub current_step_name: std::option::Option<std::string::String>,
    /// <p>The action of the step that is currently running.</p>
    pub current_action: std::option::Option<std::string::String>,
    /// <p>The parameter name.</p>
    pub target_parameter_name: std::option::Option<std::string::String>,
    /// <p>The specified targets.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The specified key-value mapping of document parameters to target resources.</p>
    pub target_maps: std::option::Option<
        std::vec::Vec<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    >,
    /// <p>A list of resolved targets in the rate control execution.</p>
    pub resolved_targets: std::option::Option<crate::model::ResolvedTargets>,
    /// <p>The <code>MaxConcurrency</code> value specified by the user when the execution
    /// started.</p>
    pub max_concurrency: std::option::Option<std::string::String>,
    /// <p>The MaxErrors value specified by the user when the execution started.</p>
    pub max_errors: std::option::Option<std::string::String>,
    /// <p>The target of the execution.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the
    /// Automation.</p>
    pub target_locations: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
    /// <p>An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a
    /// multi-Region and multi-account Automation execution.</p>
    pub progress_counters: std::option::Option<crate::model::ProgressCounters>,
    /// <p>The subtype of the Automation operation. Currently, the only supported value is
    /// <code>ChangeRequest</code>.</p>
    pub automation_subtype: std::option::Option<crate::model::AutomationSubtype>,
    /// <p>The date and time the Automation operation is scheduled to start.</p>
    pub scheduled_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Information about the Automation runbooks that are run as part of a runbook workflow.</p>
    /// <note>
    /// <p>The Automation runbooks specified for the runbook workflow can't run until all required
    /// approvals for the change request have been received.</p>
    /// </note>
    pub runbooks: std::option::Option<std::vec::Vec<crate::model::Runbook>>,
    /// <p>The ID of an OpsItem that is created to represent a Change Manager change request.</p>
    pub ops_item_id: std::option::Option<std::string::String>,
    /// <p>The ID of a State Manager association used in the Automation operation.</p>
    pub association_id: std::option::Option<std::string::String>,
    /// <p>The name of the Change Manager change request.</p>
    pub change_request_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomationExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomationExecution");
        formatter.field("automation_execution_id", &self.automation_execution_id);
        formatter.field("document_name", &self.document_name);
        formatter.field("document_version", &self.document_version);
        formatter.field("execution_start_time", &self.execution_start_time);
        formatter.field("execution_end_time", &self.execution_end_time);
        formatter.field(
            "automation_execution_status",
            &self.automation_execution_status,
        );
        formatter.field("step_executions", &self.step_executions);
        formatter.field("step_executions_truncated", &self.step_executions_truncated);
        formatter.field("parameters", &self.parameters);
        formatter.field("outputs", &self.outputs);
        formatter.field("failure_message", &self.failure_message);
        formatter.field("mode", &self.mode);
        formatter.field(
            "parent_automation_execution_id",
            &self.parent_automation_execution_id,
        );
        formatter.field("executed_by", &self.executed_by);
        formatter.field("current_step_name", &self.current_step_name);
        formatter.field("current_action", &self.current_action);
        formatter.field("target_parameter_name", &self.target_parameter_name);
        formatter.field("targets", &self.targets);
        formatter.field("target_maps", &self.target_maps);
        formatter.field("resolved_targets", &self.resolved_targets);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("max_errors", &self.max_errors);
        formatter.field("target", &self.target);
        formatter.field("target_locations", &self.target_locations);
        formatter.field("progress_counters", &self.progress_counters);
        formatter.field("automation_subtype", &self.automation_subtype);
        formatter.field("scheduled_time", &self.scheduled_time);
        formatter.field("runbooks", &self.runbooks);
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.field("association_id", &self.association_id);
        formatter.field("change_request_name", &self.change_request_name);
        formatter.finish()
    }
}
/// See [`AutomationExecution`](crate::model::AutomationExecution)
pub mod automation_execution {
    /// A builder for [`AutomationExecution`](crate::model::AutomationExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automation_execution_id: std::option::Option<std::string::String>,
        pub(crate) document_name: std::option::Option<std::string::String>,
        pub(crate) document_version: std::option::Option<std::string::String>,
        pub(crate) execution_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) automation_execution_status:
            std::option::Option<crate::model::AutomationExecutionStatus>,
        pub(crate) step_executions: std::option::Option<std::vec::Vec<crate::model::StepExecution>>,
        pub(crate) step_executions_truncated: std::option::Option<bool>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) outputs: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) failure_message: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<crate::model::ExecutionMode>,
        pub(crate) parent_automation_execution_id: std::option::Option<std::string::String>,
        pub(crate) executed_by: std::option::Option<std::string::String>,
        pub(crate) current_step_name: std::option::Option<std::string::String>,
        pub(crate) current_action: std::option::Option<std::string::String>,
        pub(crate) target_parameter_name: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) target_maps: std::option::Option<
            std::vec::Vec<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        >,
        pub(crate) resolved_targets: std::option::Option<crate::model::ResolvedTargets>,
        pub(crate) max_concurrency: std::option::Option<std::string::String>,
        pub(crate) max_errors: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) target_locations:
            std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        pub(crate) progress_counters: std::option::Option<crate::model::ProgressCounters>,
        pub(crate) automation_subtype: std::option::Option<crate::model::AutomationSubtype>,
        pub(crate) scheduled_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) runbooks: std::option::Option<std::vec::Vec<crate::model::Runbook>>,
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) change_request_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The execution ID.</p>
        pub fn automation_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.automation_execution_id = Some(input.into());
            self
        }
        /// <p>The execution ID.</p>
        pub fn set_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.automation_execution_id = input;
            self
        }
        /// <p>The name of the Automation runbook used during the execution.</p>
        pub fn document_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_name = Some(input.into());
            self
        }
        /// <p>The name of the Automation runbook used during the execution.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_name = input;
            self
        }
        /// <p>The version of the document to use during execution.</p>
        pub fn document_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_version = Some(input.into());
            self
        }
        /// <p>The version of the document to use during execution.</p>
        pub fn set_document_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_version = input;
            self
        }
        /// <p>The time the execution started.</p>
        pub fn execution_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_start_time = Some(input);
            self
        }
        /// <p>The time the execution started.</p>
        pub fn set_execution_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_start_time = input;
            self
        }
        /// <p>The time the execution finished.</p>
        pub fn execution_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_end_time = Some(input);
            self
        }
        /// <p>The time the execution finished.</p>
        pub fn set_execution_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_end_time = input;
            self
        }
        /// <p>The execution status of the Automation.</p>
        pub fn automation_execution_status(
            mut self,
            input: crate::model::AutomationExecutionStatus,
        ) -> Self {
            self.automation_execution_status = Some(input);
            self
        }
        /// <p>The execution status of the Automation.</p>
        pub fn set_automation_execution_status(
            mut self,
            input: std::option::Option<crate::model::AutomationExecutionStatus>,
        ) -> Self {
            self.automation_execution_status = input;
            self
        }
        /// Appends an item to `step_executions`.
        ///
        /// To override the contents of this collection use [`set_step_executions`](Self::set_step_executions).
        ///
        /// <p>A list of details about the current state of all steps that comprise an execution. An
        /// Automation runbook contains a list of steps that are run in order.</p>
        pub fn step_executions(mut self, input: impl Into<crate::model::StepExecution>) -> Self {
            let mut v = self.step_executions.unwrap_or_default();
            v.push(input.into());
            self.step_executions = Some(v);
            self
        }
        /// <p>A list of details about the current state of all steps that comprise an execution. An
        /// Automation runbook contains a list of steps that are run in order.</p>
        pub fn set_step_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepExecution>>,
        ) -> Self {
            self.step_executions = input;
            self
        }
        /// <p>A boolean value that indicates if the response contains the full list of the Automation step
        /// executions. If true, use the DescribeAutomationStepExecutions API operation to get the full list
        /// of step executions.</p>
        pub fn step_executions_truncated(mut self, input: bool) -> Self {
            self.step_executions_truncated = Some(input);
            self
        }
        /// <p>A boolean value that indicates if the response contains the full list of the Automation step
        /// executions. If true, use the DescribeAutomationStepExecutions API operation to get the full list
        /// of step executions.</p>
        pub fn set_step_executions_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.step_executions_truncated = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The key-value map of execution parameters, which were supplied when calling <a>StartAutomationExecution</a>.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The key-value map of execution parameters, which were supplied when calling <a>StartAutomationExecution</a>.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>The list of execution outputs as defined in the Automation runbook.</p>
        pub fn outputs(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.outputs.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.outputs = Some(hash_map);
            self
        }
        /// <p>The list of execution outputs as defined in the Automation runbook.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// <p>A message describing why an execution has failed, if the status is set to Failed.</p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p>A message describing why an execution has failed, if the status is set to Failed.</p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// <p>The automation execution mode.</p>
        pub fn mode(mut self, input: crate::model::ExecutionMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The automation execution mode.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::ExecutionMode>) -> Self {
            self.mode = input;
            self
        }
        /// <p>The AutomationExecutionId of the parent automation.</p>
        pub fn parent_automation_execution_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.parent_automation_execution_id = Some(input.into());
            self
        }
        /// <p>The AutomationExecutionId of the parent automation.</p>
        pub fn set_parent_automation_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_automation_execution_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who ran the automation.</p>
        pub fn executed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.executed_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who ran the automation.</p>
        pub fn set_executed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.executed_by = input;
            self
        }
        /// <p>The name of the step that is currently running.</p>
        pub fn current_step_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_step_name = Some(input.into());
            self
        }
        /// <p>The name of the step that is currently running.</p>
        pub fn set_current_step_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_step_name = input;
            self
        }
        /// <p>The action of the step that is currently running.</p>
        pub fn current_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_action = Some(input.into());
            self
        }
        /// <p>The action of the step that is currently running.</p>
        pub fn set_current_action(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_action = input;
            self
        }
        /// <p>The parameter name.</p>
        pub fn target_parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_parameter_name = Some(input.into());
            self
        }
        /// <p>The parameter name.</p>
        pub fn set_target_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_parameter_name = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The specified targets.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The specified targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// Appends an item to `target_maps`.
        ///
        /// To override the contents of this collection use [`set_target_maps`](Self::set_target_maps).
        ///
        /// <p>The specified key-value mapping of document parameters to target resources.</p>
        pub fn target_maps(
            mut self,
            input: impl Into<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            let mut v = self.target_maps.unwrap_or_default();
            v.push(input.into());
            self.target_maps = Some(v);
            self
        }
        /// <p>The specified key-value mapping of document parameters to target resources.</p>
        pub fn set_target_maps(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<
                        std::string::String,
                        std::vec::Vec<std::string::String>,
                    >,
                >,
            >,
        ) -> Self {
            self.target_maps = input;
            self
        }
        /// <p>A list of resolved targets in the rate control execution.</p>
        pub fn resolved_targets(mut self, input: crate::model::ResolvedTargets) -> Self {
            self.resolved_targets = Some(input);
            self
        }
        /// <p>A list of resolved targets in the rate control execution.</p>
        pub fn set_resolved_targets(
            mut self,
            input: std::option::Option<crate::model::ResolvedTargets>,
        ) -> Self {
            self.resolved_targets = input;
            self
        }
        /// <p>The <code>MaxConcurrency</code> value specified by the user when the execution
        /// started.</p>
        pub fn max_concurrency(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_concurrency = Some(input.into());
            self
        }
        /// <p>The <code>MaxConcurrency</code> value specified by the user when the execution
        /// started.</p>
        pub fn set_max_concurrency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The MaxErrors value specified by the user when the execution started.</p>
        pub fn max_errors(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_errors = Some(input.into());
            self
        }
        /// <p>The MaxErrors value specified by the user when the execution started.</p>
        pub fn set_max_errors(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_errors = input;
            self
        }
        /// <p>The target of the execution.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target of the execution.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Appends an item to `target_locations`.
        ///
        /// To override the contents of this collection use [`set_target_locations`](Self::set_target_locations).
        ///
        /// <p>The combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the
        /// Automation.</p>
        pub fn target_locations(mut self, input: impl Into<crate::model::TargetLocation>) -> Self {
            let mut v = self.target_locations.unwrap_or_default();
            v.push(input.into());
            self.target_locations = Some(v);
            self
        }
        /// <p>The combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the
        /// Automation.</p>
        pub fn set_target_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetLocation>>,
        ) -> Self {
            self.target_locations = input;
            self
        }
        /// <p>An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a
        /// multi-Region and multi-account Automation execution.</p>
        pub fn progress_counters(mut self, input: crate::model::ProgressCounters) -> Self {
            self.progress_counters = Some(input);
            self
        }
        /// <p>An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a
        /// multi-Region and multi-account Automation execution.</p>
        pub fn set_progress_counters(
            mut self,
            input: std::option::Option<crate::model::ProgressCounters>,
        ) -> Self {
            self.progress_counters = input;
            self
        }
        /// <p>The subtype of the Automation operation. Currently, the only supported value is
        /// <code>ChangeRequest</code>.</p>
        pub fn automation_subtype(mut self, input: crate::model::AutomationSubtype) -> Self {
            self.automation_subtype = Some(input);
            self
        }
        /// <p>The subtype of the Automation operation. Currently, the only supported value is
        /// <code>ChangeRequest</code>.</p>
        pub fn set_automation_subtype(
            mut self,
            input: std::option::Option<crate::model::AutomationSubtype>,
        ) -> Self {
            self.automation_subtype = input;
            self
        }
        /// <p>The date and time the Automation operation is scheduled to start.</p>
        pub fn scheduled_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.scheduled_time = Some(input);
            self
        }
        /// <p>The date and time the Automation operation is scheduled to start.</p>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.scheduled_time = input;
            self
        }
        /// Appends an item to `runbooks`.
        ///
        /// To override the contents of this collection use [`set_runbooks`](Self::set_runbooks).
        ///
        /// <p>Information about the Automation runbooks that are run as part of a runbook workflow.</p>
        /// <note>
        /// <p>The Automation runbooks specified for the runbook workflow can't run until all required
        /// approvals for the change request have been received.</p>
        /// </note>
        pub fn runbooks(mut self, input: impl Into<crate::model::Runbook>) -> Self {
            let mut v = self.runbooks.unwrap_or_default();
            v.push(input.into());
            self.runbooks = Some(v);
            self
        }
        /// <p>Information about the Automation runbooks that are run as part of a runbook workflow.</p>
        /// <note>
        /// <p>The Automation runbooks specified for the runbook workflow can't run until all required
        /// approvals for the change request have been received.</p>
        /// </note>
        pub fn set_runbooks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runbook>>,
        ) -> Self {
            self.runbooks = input;
            self
        }
        /// <p>The ID of an OpsItem that is created to represent a Change Manager change request.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of an OpsItem that is created to represent a Change Manager change request.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// <p>The ID of a State Manager association used in the Automation operation.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The ID of a State Manager association used in the Automation operation.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>The name of the Change Manager change request.</p>
        pub fn change_request_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_request_name = Some(input.into());
            self
        }
        /// <p>The name of the Change Manager change request.</p>
        pub fn set_change_request_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_request_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomationExecution`](crate::model::AutomationExecution)
        pub fn build(self) -> crate::model::AutomationExecution {
            crate::model::AutomationExecution {
                automation_execution_id: self.automation_execution_id,
                document_name: self.document_name,
                document_version: self.document_version,
                execution_start_time: self.execution_start_time,
                execution_end_time: self.execution_end_time,
                automation_execution_status: self.automation_execution_status,
                step_executions: self.step_executions,
                step_executions_truncated: self.step_executions_truncated.unwrap_or_default(),
                parameters: self.parameters,
                outputs: self.outputs,
                failure_message: self.failure_message,
                mode: self.mode,
                parent_automation_execution_id: self.parent_automation_execution_id,
                executed_by: self.executed_by,
                current_step_name: self.current_step_name,
                current_action: self.current_action,
                target_parameter_name: self.target_parameter_name,
                targets: self.targets,
                target_maps: self.target_maps,
                resolved_targets: self.resolved_targets,
                max_concurrency: self.max_concurrency,
                max_errors: self.max_errors,
                target: self.target,
                target_locations: self.target_locations,
                progress_counters: self.progress_counters,
                automation_subtype: self.automation_subtype,
                scheduled_time: self.scheduled_time,
                runbooks: self.runbooks,
                ops_item_id: self.ops_item_id,
                association_id: self.association_id,
                change_request_name: self.change_request_name,
            }
        }
    }
}
impl AutomationExecution {
    /// Creates a new builder-style object to manufacture [`AutomationExecution`](crate::model::AutomationExecution)
    pub fn builder() -> crate::model::automation_execution::Builder {
        crate::model::automation_execution::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutomationSubtype {
    #[allow(missing_docs)] // documentation missing in model
    ChangeRequest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutomationSubtype {
    fn from(s: &str) -> Self {
        match s {
            "ChangeRequest" => AutomationSubtype::ChangeRequest,
            other => AutomationSubtype::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutomationSubtype {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutomationSubtype::from(s))
    }
}
impl AutomationSubtype {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutomationSubtype::ChangeRequest => "ChangeRequest",
            AutomationSubtype::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ChangeRequest"]
    }
}
impl AsRef<str> for AutomationSubtype {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a
/// multi-Region and multi-account Automation execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProgressCounters {
    /// <p>The total number of steps run in all specified Amazon Web Services Regions and Amazon Web Services accounts for the
    /// current Automation execution.</p>
    pub total_steps: i32,
    /// <p>The total number of steps that successfully completed in all specified Amazon Web Services Regions and
    /// Amazon Web Services accounts for the current Automation execution.</p>
    pub success_steps: i32,
    /// <p>The total number of steps that failed to run in all specified Amazon Web Services Regions and
    /// Amazon Web Services accounts for the current Automation execution.</p>
    pub failed_steps: i32,
    /// <p>The total number of steps that the system cancelled in all specified Amazon Web Services Regions and
    /// Amazon Web Services accounts for the current Automation execution.</p>
    pub cancelled_steps: i32,
    /// <p>The total number of steps that timed out in all specified Amazon Web Services Regions and Amazon Web Services accounts
    /// for the current Automation execution.</p>
    pub timed_out_steps: i32,
}
impl std::fmt::Debug for ProgressCounters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProgressCounters");
        formatter.field("total_steps", &self.total_steps);
        formatter.field("success_steps", &self.success_steps);
        formatter.field("failed_steps", &self.failed_steps);
        formatter.field("cancelled_steps", &self.cancelled_steps);
        formatter.field("timed_out_steps", &self.timed_out_steps);
        formatter.finish()
    }
}
/// See [`ProgressCounters`](crate::model::ProgressCounters)
pub mod progress_counters {
    /// A builder for [`ProgressCounters`](crate::model::ProgressCounters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_steps: std::option::Option<i32>,
        pub(crate) success_steps: std::option::Option<i32>,
        pub(crate) failed_steps: std::option::Option<i32>,
        pub(crate) cancelled_steps: std::option::Option<i32>,
        pub(crate) timed_out_steps: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The total number of steps run in all specified Amazon Web Services Regions and Amazon Web Services accounts for the
        /// current Automation execution.</p>
        pub fn total_steps(mut self, input: i32) -> Self {
            self.total_steps = Some(input);
            self
        }
        /// <p>The total number of steps run in all specified Amazon Web Services Regions and Amazon Web Services accounts for the
        /// current Automation execution.</p>
        pub fn set_total_steps(mut self, input: std::option::Option<i32>) -> Self {
            self.total_steps = input;
            self
        }
        /// <p>The total number of steps that successfully completed in all specified Amazon Web Services Regions and
        /// Amazon Web Services accounts for the current Automation execution.</p>
        pub fn success_steps(mut self, input: i32) -> Self {
            self.success_steps = Some(input);
            self
        }
        /// <p>The total number of steps that successfully completed in all specified Amazon Web Services Regions and
        /// Amazon Web Services accounts for the current Automation execution.</p>
        pub fn set_success_steps(mut self, input: std::option::Option<i32>) -> Self {
            self.success_steps = input;
            self
        }
        /// <p>The total number of steps that failed to run in all specified Amazon Web Services Regions and
        /// Amazon Web Services accounts for the current Automation execution.</p>
        pub fn failed_steps(mut self, input: i32) -> Self {
            self.failed_steps = Some(input);
            self
        }
        /// <p>The total number of steps that failed to run in all specified Amazon Web Services Regions and
        /// Amazon Web Services accounts for the current Automation execution.</p>
        pub fn set_failed_steps(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_steps = input;
            self
        }
        /// <p>The total number of steps that the system cancelled in all specified Amazon Web Services Regions and
        /// Amazon Web Services accounts for the current Automation execution.</p>
        pub fn cancelled_steps(mut self, input: i32) -> Self {
            self.cancelled_steps = Some(input);
            self
        }
        /// <p>The total number of steps that the system cancelled in all specified Amazon Web Services Regions and
        /// Amazon Web Services accounts for the current Automation execution.</p>
        pub fn set_cancelled_steps(mut self, input: std::option::Option<i32>) -> Self {
            self.cancelled_steps = input;
            self
        }
        /// <p>The total number of steps that timed out in all specified Amazon Web Services Regions and Amazon Web Services accounts
        /// for the current Automation execution.</p>
        pub fn timed_out_steps(mut self, input: i32) -> Self {
            self.timed_out_steps = Some(input);
            self
        }
        /// <p>The total number of steps that timed out in all specified Amazon Web Services Regions and Amazon Web Services accounts
        /// for the current Automation execution.</p>
        pub fn set_timed_out_steps(mut self, input: std::option::Option<i32>) -> Self {
            self.timed_out_steps = input;
            self
        }
        /// Consumes the builder and constructs a [`ProgressCounters`](crate::model::ProgressCounters)
        pub fn build(self) -> crate::model::ProgressCounters {
            crate::model::ProgressCounters {
                total_steps: self.total_steps.unwrap_or_default(),
                success_steps: self.success_steps.unwrap_or_default(),
                failed_steps: self.failed_steps.unwrap_or_default(),
                cancelled_steps: self.cancelled_steps.unwrap_or_default(),
                timed_out_steps: self.timed_out_steps.unwrap_or_default(),
            }
        }
    }
}
impl ProgressCounters {
    /// Creates a new builder-style object to manufacture [`ProgressCounters`](crate::model::ProgressCounters)
    pub fn builder() -> crate::model::progress_counters::Builder {
        crate::model::progress_counters::Builder::default()
    }
}

/// <p>Information about targets that resolved during the Automation execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolvedTargets {
    /// <p>A list of parameter values sent to targets that resolved during the Automation
    /// execution.</p>
    pub parameter_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A boolean value indicating whether the resolved target list is truncated.</p>
    pub truncated: bool,
}
impl std::fmt::Debug for ResolvedTargets {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolvedTargets");
        formatter.field("parameter_values", &self.parameter_values);
        formatter.field("truncated", &self.truncated);
        formatter.finish()
    }
}
/// See [`ResolvedTargets`](crate::model::ResolvedTargets)
pub mod resolved_targets {
    /// A builder for [`ResolvedTargets`](crate::model::ResolvedTargets)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) truncated: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `parameter_values`.
        ///
        /// To override the contents of this collection use [`set_parameter_values`](Self::set_parameter_values).
        ///
        /// <p>A list of parameter values sent to targets that resolved during the Automation
        /// execution.</p>
        pub fn parameter_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parameter_values.unwrap_or_default();
            v.push(input.into());
            self.parameter_values = Some(v);
            self
        }
        /// <p>A list of parameter values sent to targets that resolved during the Automation
        /// execution.</p>
        pub fn set_parameter_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parameter_values = input;
            self
        }
        /// <p>A boolean value indicating whether the resolved target list is truncated.</p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p>A boolean value indicating whether the resolved target list is truncated.</p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolvedTargets`](crate::model::ResolvedTargets)
        pub fn build(self) -> crate::model::ResolvedTargets {
            crate::model::ResolvedTargets {
                parameter_values: self.parameter_values,
                truncated: self.truncated.unwrap_or_default(),
            }
        }
    }
}
impl ResolvedTargets {
    /// Creates a new builder-style object to manufacture [`ResolvedTargets`](crate::model::ResolvedTargets)
    pub fn builder() -> crate::model::resolved_targets::Builder {
        crate::model::resolved_targets::Builder::default()
    }
}

/// <p>Detailed information about an the execution state of an Automation step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepExecution {
    /// <p>The name of this execution step.</p>
    pub step_name: std::option::Option<std::string::String>,
    /// <p>The action this step performs. The action determines the behavior of the step.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The timeout seconds of the step.</p>
    pub timeout_seconds: std::option::Option<i64>,
    /// <p>The action to take if the step fails. The default value is <code>Abort</code>.</p>
    pub on_failure: std::option::Option<std::string::String>,
    /// <p>The maximum number of tries to run the action of the step. The default value is
    /// <code>1</code>.</p>
    pub max_attempts: std::option::Option<i32>,
    /// <p>If a step has begun execution, this contains the time the step started. If the step is in
    /// Pending status, this field isn't populated.</p>
    pub execution_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>If a step has finished execution, this contains the time the execution ended. If the step
    /// hasn't yet concluded, this field isn't populated.</p>
    pub execution_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The execution status for this step.</p>
    pub step_status: std::option::Option<crate::model::AutomationExecutionStatus>,
    /// <p>The response code returned by the execution of the step.</p>
    pub response_code: std::option::Option<std::string::String>,
    /// <p>Fully-resolved values passed into the step before execution.</p>
    pub inputs:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Returned values from the execution of the step.</p>
    pub outputs: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>A message associated with the response code for an execution.</p>
    pub response: std::option::Option<std::string::String>,
    /// <p>If a step failed, this message explains why the execution failed.</p>
    pub failure_message: std::option::Option<std::string::String>,
    /// <p>Information about the Automation failure.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
    /// <p>The unique ID of a step execution.</p>
    pub step_execution_id: std::option::Option<std::string::String>,
    /// <p>A user-specified list of parameters to override when running a step.</p>
    pub overridden_parameters: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The flag which can be used to end automation no matter whether the step succeeds or
    /// fails.</p>
    pub is_end: std::option::Option<bool>,
    /// <p>The next step after the step succeeds.</p>
    pub next_step: std::option::Option<std::string::String>,
    /// <p>The flag which can be used to help decide whether the failure of current step leads to the
    /// Automation failure.</p>
    pub is_critical: std::option::Option<bool>,
    /// <p>Strategies used when step fails, we support Continue and Abort. Abort will fail the
    /// automation when the step fails. Continue will ignore the failure of current step and allow
    /// automation to run the next step. With conditional branching, we add step:stepName to support the
    /// automation to go to another specific step.</p>
    pub valid_next_steps: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The targets for the step execution.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
    /// execution.</p>
    pub target_location: std::option::Option<crate::model::TargetLocation>,
}
impl std::fmt::Debug for StepExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepExecution");
        formatter.field("step_name", &self.step_name);
        formatter.field("action", &self.action);
        formatter.field("timeout_seconds", &self.timeout_seconds);
        formatter.field("on_failure", &self.on_failure);
        formatter.field("max_attempts", &self.max_attempts);
        formatter.field("execution_start_time", &self.execution_start_time);
        formatter.field("execution_end_time", &self.execution_end_time);
        formatter.field("step_status", &self.step_status);
        formatter.field("response_code", &self.response_code);
        formatter.field("inputs", &self.inputs);
        formatter.field("outputs", &self.outputs);
        formatter.field("response", &self.response);
        formatter.field("failure_message", &self.failure_message);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("step_execution_id", &self.step_execution_id);
        formatter.field("overridden_parameters", &self.overridden_parameters);
        formatter.field("is_end", &self.is_end);
        formatter.field("next_step", &self.next_step);
        formatter.field("is_critical", &self.is_critical);
        formatter.field("valid_next_steps", &self.valid_next_steps);
        formatter.field("targets", &self.targets);
        formatter.field("target_location", &self.target_location);
        formatter.finish()
    }
}
/// See [`StepExecution`](crate::model::StepExecution)
pub mod step_execution {
    /// A builder for [`StepExecution`](crate::model::StepExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) step_name: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) timeout_seconds: std::option::Option<i64>,
        pub(crate) on_failure: std::option::Option<std::string::String>,
        pub(crate) max_attempts: std::option::Option<i32>,
        pub(crate) execution_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) step_status: std::option::Option<crate::model::AutomationExecutionStatus>,
        pub(crate) response_code: std::option::Option<std::string::String>,
        pub(crate) inputs: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) outputs: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) response: std::option::Option<std::string::String>,
        pub(crate) failure_message: std::option::Option<std::string::String>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
        pub(crate) step_execution_id: std::option::Option<std::string::String>,
        pub(crate) overridden_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) is_end: std::option::Option<bool>,
        pub(crate) next_step: std::option::Option<std::string::String>,
        pub(crate) is_critical: std::option::Option<bool>,
        pub(crate) valid_next_steps: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) target_location: std::option::Option<crate::model::TargetLocation>,
    }
    impl Builder {
        /// <p>The name of this execution step.</p>
        pub fn step_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.step_name = Some(input.into());
            self
        }
        /// <p>The name of this execution step.</p>
        pub fn set_step_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.step_name = input;
            self
        }
        /// <p>The action this step performs. The action determines the behavior of the step.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The action this step performs. The action determines the behavior of the step.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The timeout seconds of the step.</p>
        pub fn timeout_seconds(mut self, input: i64) -> Self {
            self.timeout_seconds = Some(input);
            self
        }
        /// <p>The timeout seconds of the step.</p>
        pub fn set_timeout_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.timeout_seconds = input;
            self
        }
        /// <p>The action to take if the step fails. The default value is <code>Abort</code>.</p>
        pub fn on_failure(mut self, input: impl Into<std::string::String>) -> Self {
            self.on_failure = Some(input.into());
            self
        }
        /// <p>The action to take if the step fails. The default value is <code>Abort</code>.</p>
        pub fn set_on_failure(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.on_failure = input;
            self
        }
        /// <p>The maximum number of tries to run the action of the step. The default value is
        /// <code>1</code>.</p>
        pub fn max_attempts(mut self, input: i32) -> Self {
            self.max_attempts = Some(input);
            self
        }
        /// <p>The maximum number of tries to run the action of the step. The default value is
        /// <code>1</code>.</p>
        pub fn set_max_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.max_attempts = input;
            self
        }
        /// <p>If a step has begun execution, this contains the time the step started. If the step is in
        /// Pending status, this field isn't populated.</p>
        pub fn execution_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_start_time = Some(input);
            self
        }
        /// <p>If a step has begun execution, this contains the time the step started. If the step is in
        /// Pending status, this field isn't populated.</p>
        pub fn set_execution_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_start_time = input;
            self
        }
        /// <p>If a step has finished execution, this contains the time the execution ended. If the step
        /// hasn't yet concluded, this field isn't populated.</p>
        pub fn execution_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_end_time = Some(input);
            self
        }
        /// <p>If a step has finished execution, this contains the time the execution ended. If the step
        /// hasn't yet concluded, this field isn't populated.</p>
        pub fn set_execution_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_end_time = input;
            self
        }
        /// <p>The execution status for this step.</p>
        pub fn step_status(mut self, input: crate::model::AutomationExecutionStatus) -> Self {
            self.step_status = Some(input);
            self
        }
        /// <p>The execution status for this step.</p>
        pub fn set_step_status(
            mut self,
            input: std::option::Option<crate::model::AutomationExecutionStatus>,
        ) -> Self {
            self.step_status = input;
            self
        }
        /// <p>The response code returned by the execution of the step.</p>
        pub fn response_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_code = Some(input.into());
            self
        }
        /// <p>The response code returned by the execution of the step.</p>
        pub fn set_response_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_code = input;
            self
        }
        /// Adds a key-value pair to `inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// <p>Fully-resolved values passed into the step before execution.</p>
        pub fn inputs(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.inputs.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.inputs = Some(hash_map);
            self
        }
        /// <p>Fully-resolved values passed into the step before execution.</p>
        pub fn set_inputs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inputs = input;
            self
        }
        /// Adds a key-value pair to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// <p>Returned values from the execution of the step.</p>
        pub fn outputs(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.outputs.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.outputs = Some(hash_map);
            self
        }
        /// <p>Returned values from the execution of the step.</p>
        pub fn set_outputs(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// <p>A message associated with the response code for an execution.</p>
        pub fn response(mut self, input: impl Into<std::string::String>) -> Self {
            self.response = Some(input.into());
            self
        }
        /// <p>A message associated with the response code for an execution.</p>
        pub fn set_response(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.response = input;
            self
        }
        /// <p>If a step failed, this message explains why the execution failed.</p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p>If a step failed, this message explains why the execution failed.</p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// <p>Information about the Automation failure.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Information about the Automation failure.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>The unique ID of a step execution.</p>
        pub fn step_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.step_execution_id = Some(input.into());
            self
        }
        /// <p>The unique ID of a step execution.</p>
        pub fn set_step_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.step_execution_id = input;
            self
        }
        /// Adds a key-value pair to `overridden_parameters`.
        ///
        /// To override the contents of this collection use [`set_overridden_parameters`](Self::set_overridden_parameters).
        ///
        /// <p>A user-specified list of parameters to override when running a step.</p>
        pub fn overridden_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.overridden_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.overridden_parameters = Some(hash_map);
            self
        }
        /// <p>A user-specified list of parameters to override when running a step.</p>
        pub fn set_overridden_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.overridden_parameters = input;
            self
        }
        /// <p>The flag which can be used to end automation no matter whether the step succeeds or
        /// fails.</p>
        pub fn is_end(mut self, input: bool) -> Self {
            self.is_end = Some(input);
            self
        }
        /// <p>The flag which can be used to end automation no matter whether the step succeeds or
        /// fails.</p>
        pub fn set_is_end(mut self, input: std::option::Option<bool>) -> Self {
            self.is_end = input;
            self
        }
        /// <p>The next step after the step succeeds.</p>
        pub fn next_step(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_step = Some(input.into());
            self
        }
        /// <p>The next step after the step succeeds.</p>
        pub fn set_next_step(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_step = input;
            self
        }
        /// <p>The flag which can be used to help decide whether the failure of current step leads to the
        /// Automation failure.</p>
        pub fn is_critical(mut self, input: bool) -> Self {
            self.is_critical = Some(input);
            self
        }
        /// <p>The flag which can be used to help decide whether the failure of current step leads to the
        /// Automation failure.</p>
        pub fn set_is_critical(mut self, input: std::option::Option<bool>) -> Self {
            self.is_critical = input;
            self
        }
        /// Appends an item to `valid_next_steps`.
        ///
        /// To override the contents of this collection use [`set_valid_next_steps`](Self::set_valid_next_steps).
        ///
        /// <p>Strategies used when step fails, we support Continue and Abort. Abort will fail the
        /// automation when the step fails. Continue will ignore the failure of current step and allow
        /// automation to run the next step. With conditional branching, we add step:stepName to support the
        /// automation to go to another specific step.</p>
        pub fn valid_next_steps(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.valid_next_steps.unwrap_or_default();
            v.push(input.into());
            self.valid_next_steps = Some(v);
            self
        }
        /// <p>Strategies used when step fails, we support Continue and Abort. Abort will fail the
        /// automation when the step fails. Continue will ignore the failure of current step and allow
        /// automation to run the next step. With conditional branching, we add step:stepName to support the
        /// automation to go to another specific step.</p>
        pub fn set_valid_next_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.valid_next_steps = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the step execution.</p>
        pub fn targets(mut self, input: impl Into<crate::model::Target>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The targets for the step execution.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
        /// execution.</p>
        pub fn target_location(mut self, input: crate::model::TargetLocation) -> Self {
            self.target_location = Some(input);
            self
        }
        /// <p>The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
        /// execution.</p>
        pub fn set_target_location(
            mut self,
            input: std::option::Option<crate::model::TargetLocation>,
        ) -> Self {
            self.target_location = input;
            self
        }
        /// Consumes the builder and constructs a [`StepExecution`](crate::model::StepExecution)
        pub fn build(self) -> crate::model::StepExecution {
            crate::model::StepExecution {
                step_name: self.step_name,
                action: self.action,
                timeout_seconds: self.timeout_seconds,
                on_failure: self.on_failure,
                max_attempts: self.max_attempts,
                execution_start_time: self.execution_start_time,
                execution_end_time: self.execution_end_time,
                step_status: self.step_status,
                response_code: self.response_code,
                inputs: self.inputs,
                outputs: self.outputs,
                response: self.response,
                failure_message: self.failure_message,
                failure_details: self.failure_details,
                step_execution_id: self.step_execution_id,
                overridden_parameters: self.overridden_parameters,
                is_end: self.is_end,
                next_step: self.next_step,
                is_critical: self.is_critical,
                valid_next_steps: self.valid_next_steps,
                targets: self.targets,
                target_location: self.target_location,
            }
        }
    }
}
impl StepExecution {
    /// Creates a new builder-style object to manufacture [`StepExecution`](crate::model::StepExecution)
    pub fn builder() -> crate::model::step_execution::Builder {
        crate::model::step_execution::Builder::default()
    }
}

/// <p>Information about an Automation failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureDetails {
    /// <p>The stage of the Automation execution when the failure occurred. The stages include the
    /// following: InputValidation, PreVerification, Invocation, PostVerification.</p>
    pub failure_stage: std::option::Option<std::string::String>,
    /// <p>The type of Automation failure. Failure types include the following: Action, Permission,
    /// Throttling, Verification, Internal.</p>
    pub failure_type: std::option::Option<std::string::String>,
    /// <p>Detailed information about the Automation step failure.</p>
    pub details: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
}
impl std::fmt::Debug for FailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureDetails");
        formatter.field("failure_stage", &self.failure_stage);
        formatter.field("failure_type", &self.failure_type);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`FailureDetails`](crate::model::FailureDetails)
pub mod failure_details {
    /// A builder for [`FailureDetails`](crate::model::FailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_stage: std::option::Option<std::string::String>,
        pub(crate) failure_type: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
    }
    impl Builder {
        /// <p>The stage of the Automation execution when the failure occurred. The stages include the
        /// following: InputValidation, PreVerification, Invocation, PostVerification.</p>
        pub fn failure_stage(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_stage = Some(input.into());
            self
        }
        /// <p>The stage of the Automation execution when the failure occurred. The stages include the
        /// following: InputValidation, PreVerification, Invocation, PostVerification.</p>
        pub fn set_failure_stage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_stage = input;
            self
        }
        /// <p>The type of Automation failure. Failure types include the following: Action, Permission,
        /// Throttling, Verification, Internal.</p>
        pub fn failure_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_type = Some(input.into());
            self
        }
        /// <p>The type of Automation failure. Failure types include the following: Action, Permission,
        /// Throttling, Verification, Internal.</p>
        pub fn set_failure_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.failure_type = input;
            self
        }
        /// Adds a key-value pair to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p>Detailed information about the Automation step failure.</p>
        pub fn details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.details = Some(hash_map);
            self
        }
        /// <p>Detailed information about the Automation step failure.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureDetails`](crate::model::FailureDetails)
        pub fn build(self) -> crate::model::FailureDetails {
            crate::model::FailureDetails {
                failure_stage: self.failure_stage,
                failure_type: self.failure_type,
                details: self.details,
            }
        }
    }
}
impl FailureDetails {
    /// Creates a new builder-style object to manufacture [`FailureDetails`](crate::model::FailureDetails)
    pub fn builder() -> crate::model::failure_details::Builder {
        crate::model::failure_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutomationExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    ChangeCalendarOverrideApproved,
    #[allow(missing_docs)] // documentation missing in model
    ChangeCalendarOverrideRejected,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithFailure,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithSuccess,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inprogress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingApproval,
    #[allow(missing_docs)] // documentation missing in model
    PendingChangeCalendarOverride,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    RunbookInprogress,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    #[allow(missing_docs)] // documentation missing in model
    Timedout,
    #[allow(missing_docs)] // documentation missing in model
    Waiting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutomationExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Approved" => AutomationExecutionStatus::Approved,
            "Cancelled" => AutomationExecutionStatus::Cancelled,
            "Cancelling" => AutomationExecutionStatus::Cancelling,
            "ChangeCalendarOverrideApproved" => {
                AutomationExecutionStatus::ChangeCalendarOverrideApproved
            }
            "ChangeCalendarOverrideRejected" => {
                AutomationExecutionStatus::ChangeCalendarOverrideRejected
            }
            "CompletedWithFailure" => AutomationExecutionStatus::CompletedWithFailure,
            "CompletedWithSuccess" => AutomationExecutionStatus::CompletedWithSuccess,
            "Failed" => AutomationExecutionStatus::Failed,
            "InProgress" => AutomationExecutionStatus::Inprogress,
            "Pending" => AutomationExecutionStatus::Pending,
            "PendingApproval" => AutomationExecutionStatus::PendingApproval,
            "PendingChangeCalendarOverride" => {
                AutomationExecutionStatus::PendingChangeCalendarOverride
            }
            "Rejected" => AutomationExecutionStatus::Rejected,
            "RunbookInProgress" => AutomationExecutionStatus::RunbookInprogress,
            "Scheduled" => AutomationExecutionStatus::Scheduled,
            "Success" => AutomationExecutionStatus::Success,
            "TimedOut" => AutomationExecutionStatus::Timedout,
            "Waiting" => AutomationExecutionStatus::Waiting,
            other => AutomationExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutomationExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutomationExecutionStatus::from(s))
    }
}
impl AutomationExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutomationExecutionStatus::Approved => "Approved",
            AutomationExecutionStatus::Cancelled => "Cancelled",
            AutomationExecutionStatus::Cancelling => "Cancelling",
            AutomationExecutionStatus::ChangeCalendarOverrideApproved => {
                "ChangeCalendarOverrideApproved"
            }
            AutomationExecutionStatus::ChangeCalendarOverrideRejected => {
                "ChangeCalendarOverrideRejected"
            }
            AutomationExecutionStatus::CompletedWithFailure => "CompletedWithFailure",
            AutomationExecutionStatus::CompletedWithSuccess => "CompletedWithSuccess",
            AutomationExecutionStatus::Failed => "Failed",
            AutomationExecutionStatus::Inprogress => "InProgress",
            AutomationExecutionStatus::Pending => "Pending",
            AutomationExecutionStatus::PendingApproval => "PendingApproval",
            AutomationExecutionStatus::PendingChangeCalendarOverride => {
                "PendingChangeCalendarOverride"
            }
            AutomationExecutionStatus::Rejected => "Rejected",
            AutomationExecutionStatus::RunbookInprogress => "RunbookInProgress",
            AutomationExecutionStatus::Scheduled => "Scheduled",
            AutomationExecutionStatus::Success => "Success",
            AutomationExecutionStatus::Timedout => "TimedOut",
            AutomationExecutionStatus::Waiting => "Waiting",
            AutomationExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Approved",
            "Cancelled",
            "Cancelling",
            "ChangeCalendarOverrideApproved",
            "ChangeCalendarOverrideRejected",
            "CompletedWithFailure",
            "CompletedWithSuccess",
            "Failed",
            "InProgress",
            "Pending",
            "PendingApproval",
            "PendingChangeCalendarOverride",
            "Rejected",
            "RunbookInProgress",
            "Scheduled",
            "Success",
            "TimedOut",
            "Waiting",
        ]
    }
}
impl AsRef<str> for AutomationExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a Session Manager connection to an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Session {
    /// <p>The ID of the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The instance that the Session Manager session connected to.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The status of the session. For example, "Connected" or "Terminated".</p>
    pub status: std::option::Option<crate::model::SessionStatus>,
    /// <p>The date and time, in ISO-8601 Extended format, when the session began.</p>
    pub start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time, in ISO-8601 Extended format, when the session was terminated.</p>
    pub end_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the Session Manager SSM document used to define the parameters and plugin settings for the
    /// session. For example, <code>SSM-SessionManagerRunShell</code>.</p>
    pub document_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services user account that started the session.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub output_url: std::option::Option<crate::model::SessionManagerOutputUrl>,
}
impl std::fmt::Debug for Session {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Session");
        formatter.field("session_id", &self.session_id);
        formatter.field("target", &self.target);
        formatter.field("status", &self.status);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("document_name", &self.document_name);
        formatter.field("owner", &self.owner);
        formatter.field("details", &self.details);
        formatter.field("output_url", &self.output_url);
        formatter.finish()
    }
}
/// See [`Session`](crate::model::Session)
pub mod session {
    /// A builder for [`Session`](crate::model::Session)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SessionStatus>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) document_name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) output_url: std::option::Option<crate::model::SessionManagerOutputUrl>,
    }
    impl Builder {
        /// <p>The ID of the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The ID of the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The instance that the Session Manager session connected to.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The instance that the Session Manager session connected to.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The status of the session. For example, "Connected" or "Terminated".</p>
        pub fn status(mut self, input: crate::model::SessionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the session. For example, "Connected" or "Terminated".</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SessionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, when the session began.</p>
        pub fn start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, when the session began.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, when the session was terminated.</p>
        pub fn end_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The date and time, in ISO-8601 Extended format, when the session was terminated.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// <p>The name of the Session Manager SSM document used to define the parameters and plugin settings for the
        /// session. For example, <code>SSM-SessionManagerRunShell</code>.</p>
        pub fn document_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.document_name = Some(input.into());
            self
        }
        /// <p>The name of the Session Manager SSM document used to define the parameters and plugin settings for the
        /// session. For example, <code>SSM-SessionManagerRunShell</code>.</p>
        pub fn set_document_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.document_name = input;
            self
        }
        /// <p>The ID of the Amazon Web Services user account that started the session.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services user account that started the session.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn output_url(mut self, input: crate::model::SessionManagerOutputUrl) -> Self {
            self.output_url = Some(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_output_url(
            mut self,
            input: std::option::Option<crate::model::SessionManagerOutputUrl>,
        ) -> Self {
            self.output_url = input;
            self
        }
        /// Consumes the builder and constructs a [`Session`](crate::model::Session)
        pub fn build(self) -> crate::model::Session {
            crate::model::Session {
                session_id: self.session_id,
                target: self.target,
                status: self.status,
                start_date: self.start_date,
                end_date: self.end_date,
                document_name: self.document_name,
                owner: self.owner,
                details: self.details,
                output_url: self.output_url,
            }
        }
    }
}
impl Session {
    /// Creates a new builder-style object to manufacture [`Session`](crate::model::Session)
    pub fn builder() -> crate::model::session::Builder {
        crate::model::session::Builder::default()
    }
}

/// <p>Reserved for future use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionManagerOutputUrl {
    /// <p>Reserved for future use.</p>
    pub s3_output_url: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub cloud_watch_output_url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SessionManagerOutputUrl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionManagerOutputUrl");
        formatter.field("s3_output_url", &self.s3_output_url);
        formatter.field("cloud_watch_output_url", &self.cloud_watch_output_url);
        formatter.finish()
    }
}
/// See [`SessionManagerOutputUrl`](crate::model::SessionManagerOutputUrl)
pub mod session_manager_output_url {
    /// A builder for [`SessionManagerOutputUrl`](crate::model::SessionManagerOutputUrl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_output_url: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_output_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Reserved for future use.</p>
        pub fn s3_output_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_output_url = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_s3_output_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_output_url = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn cloud_watch_output_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_output_url = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_cloud_watch_output_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_output_url = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionManagerOutputUrl`](crate::model::SessionManagerOutputUrl)
        pub fn build(self) -> crate::model::SessionManagerOutputUrl {
            crate::model::SessionManagerOutputUrl {
                s3_output_url: self.s3_output_url,
                cloud_watch_output_url: self.cloud_watch_output_url,
            }
        }
    }
}
impl SessionManagerOutputUrl {
    /// Creates a new builder-style object to manufacture [`SessionManagerOutputUrl`](crate::model::SessionManagerOutputUrl)
    pub fn builder() -> crate::model::session_manager_output_url::Builder {
        crate::model::session_manager_output_url::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SessionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Connecting,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SessionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Connected" => SessionStatus::Connected,
            "Connecting" => SessionStatus::Connecting,
            "Disconnected" => SessionStatus::Disconnected,
            "Failed" => SessionStatus::Failed,
            "Terminated" => SessionStatus::Terminated,
            "Terminating" => SessionStatus::Terminating,
            other => SessionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SessionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SessionStatus::from(s))
    }
}
impl SessionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SessionStatus::Connected => "Connected",
            SessionStatus::Connecting => "Connecting",
            SessionStatus::Disconnected => "Disconnected",
            SessionStatus::Failed => "Failed",
            SessionStatus::Terminated => "Terminated",
            SessionStatus::Terminating => "Terminating",
            SessionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Connected",
            "Connecting",
            "Disconnected",
            "Failed",
            "Terminated",
            "Terminating",
        ]
    }
}
impl AsRef<str> for SessionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a filter for Session Manager information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionFilter {
    /// <p>The name of the filter.</p>
    pub key: std::option::Option<crate::model::SessionFilterKey>,
    /// <p>The filter value. Valid values for each filter key are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>InvokedAfter: Specify a timestamp to limit your results. For example, specify
    /// 2018-08-29T00:00:00Z to see sessions that started August 29, 2018, and later.</p>
    /// </li>
    /// <li>
    /// <p>InvokedBefore: Specify a timestamp to limit your results. For example, specify
    /// 2018-08-29T00:00:00Z to see sessions that started before August 29, 2018.</p>
    /// </li>
    /// <li>
    /// <p>Target: Specify an instance to which session connections have been made.</p>
    /// </li>
    /// <li>
    /// <p>Owner: Specify an Amazon Web Services user account to see a list of sessions started by that
    /// user.</p>
    /// </li>
    /// <li>
    /// <p>Status: Specify a valid session status to see a list of all sessions with that status.
    /// Status values you can specify include:</p>
    /// <ul>
    /// <li>
    /// <p>Connected</p>
    /// </li>
    /// <li>
    /// <p>Connecting</p>
    /// </li>
    /// <li>
    /// <p>Disconnected</p>
    /// </li>
    /// <li>
    /// <p>Terminated</p>
    /// </li>
    /// <li>
    /// <p>Terminating</p>
    /// </li>
    /// <li>
    /// <p>Failed</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>SessionId: Specify a session ID to return details about the session.</p>
    /// </li>
    /// </ul>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SessionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionFilter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SessionFilter`](crate::model::SessionFilter)
pub mod session_filter {
    /// A builder for [`SessionFilter`](crate::model::SessionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::SessionFilterKey>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn key(mut self, input: crate::model::SessionFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::SessionFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>The filter value. Valid values for each filter key are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>InvokedAfter: Specify a timestamp to limit your results. For example, specify
        /// 2018-08-29T00:00:00Z to see sessions that started August 29, 2018, and later.</p>
        /// </li>
        /// <li>
        /// <p>InvokedBefore: Specify a timestamp to limit your results. For example, specify
        /// 2018-08-29T00:00:00Z to see sessions that started before August 29, 2018.</p>
        /// </li>
        /// <li>
        /// <p>Target: Specify an instance to which session connections have been made.</p>
        /// </li>
        /// <li>
        /// <p>Owner: Specify an Amazon Web Services user account to see a list of sessions started by that
        /// user.</p>
        /// </li>
        /// <li>
        /// <p>Status: Specify a valid session status to see a list of all sessions with that status.
        /// Status values you can specify include:</p>
        /// <ul>
        /// <li>
        /// <p>Connected</p>
        /// </li>
        /// <li>
        /// <p>Connecting</p>
        /// </li>
        /// <li>
        /// <p>Disconnected</p>
        /// </li>
        /// <li>
        /// <p>Terminated</p>
        /// </li>
        /// <li>
        /// <p>Terminating</p>
        /// </li>
        /// <li>
        /// <p>Failed</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>SessionId: Specify a session ID to return details about the session.</p>
        /// </li>
        /// </ul>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The filter value. Valid values for each filter key are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>InvokedAfter: Specify a timestamp to limit your results. For example, specify
        /// 2018-08-29T00:00:00Z to see sessions that started August 29, 2018, and later.</p>
        /// </li>
        /// <li>
        /// <p>InvokedBefore: Specify a timestamp to limit your results. For example, specify
        /// 2018-08-29T00:00:00Z to see sessions that started before August 29, 2018.</p>
        /// </li>
        /// <li>
        /// <p>Target: Specify an instance to which session connections have been made.</p>
        /// </li>
        /// <li>
        /// <p>Owner: Specify an Amazon Web Services user account to see a list of sessions started by that
        /// user.</p>
        /// </li>
        /// <li>
        /// <p>Status: Specify a valid session status to see a list of all sessions with that status.
        /// Status values you can specify include:</p>
        /// <ul>
        /// <li>
        /// <p>Connected</p>
        /// </li>
        /// <li>
        /// <p>Connecting</p>
        /// </li>
        /// <li>
        /// <p>Disconnected</p>
        /// </li>
        /// <li>
        /// <p>Terminated</p>
        /// </li>
        /// <li>
        /// <p>Terminating</p>
        /// </li>
        /// <li>
        /// <p>Failed</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>SessionId: Specify a session ID to return details about the session.</p>
        /// </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionFilter`](crate::model::SessionFilter)
        pub fn build(self) -> crate::model::SessionFilter {
            crate::model::SessionFilter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl SessionFilter {
    /// Creates a new builder-style object to manufacture [`SessionFilter`](crate::model::SessionFilter)
    pub fn builder() -> crate::model::session_filter::Builder {
        crate::model::session_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SessionFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    InvokedAfter,
    #[allow(missing_docs)] // documentation missing in model
    InvokedBefore,
    #[allow(missing_docs)] // documentation missing in model
    Owner,
    #[allow(missing_docs)] // documentation missing in model
    SessionId,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    TargetId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SessionFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "InvokedAfter" => SessionFilterKey::InvokedAfter,
            "InvokedBefore" => SessionFilterKey::InvokedBefore,
            "Owner" => SessionFilterKey::Owner,
            "SessionId" => SessionFilterKey::SessionId,
            "Status" => SessionFilterKey::Status,
            "Target" => SessionFilterKey::TargetId,
            other => SessionFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SessionFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SessionFilterKey::from(s))
    }
}
impl SessionFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SessionFilterKey::InvokedAfter => "InvokedAfter",
            SessionFilterKey::InvokedBefore => "InvokedBefore",
            SessionFilterKey::Owner => "Owner",
            SessionFilterKey::SessionId => "SessionId",
            SessionFilterKey::Status => "Status",
            SessionFilterKey::TargetId => "Target",
            SessionFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "InvokedAfter",
            "InvokedBefore",
            "Owner",
            "SessionId",
            "Status",
            "Target",
        ]
    }
}
impl AsRef<str> for SessionFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SessionState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    History,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SessionState {
    fn from(s: &str) -> Self {
        match s {
            "Active" => SessionState::Active,
            "History" => SessionState::History,
            other => SessionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SessionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SessionState::from(s))
    }
}
impl SessionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SessionState::Active => "Active",
            SessionState::History => "History",
            SessionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "History"]
    }
}
impl AsRef<str> for SessionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PatchSet {
    #[allow(missing_docs)] // documentation missing in model
    Application,
    #[allow(missing_docs)] // documentation missing in model
    Os,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PatchSet {
    fn from(s: &str) -> Self {
        match s {
            "APPLICATION" => PatchSet::Application,
            "OS" => PatchSet::Os,
            other => PatchSet::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PatchSet {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PatchSet::from(s))
    }
}
impl PatchSet {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PatchSet::Application => "APPLICATION",
            PatchSet::Os => "OS",
            PatchSet::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLICATION", "OS"]
    }
}
impl AsRef<str> for PatchSet {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PatchProperty {
    #[allow(missing_docs)] // documentation missing in model
    PatchClassification,
    #[allow(missing_docs)] // documentation missing in model
    PatchMsrcSeverity,
    #[allow(missing_docs)] // documentation missing in model
    PatchPriority,
    #[allow(missing_docs)] // documentation missing in model
    Product,
    #[allow(missing_docs)] // documentation missing in model
    PatchProductFamily,
    #[allow(missing_docs)] // documentation missing in model
    PatchSeverity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PatchProperty {
    fn from(s: &str) -> Self {
        match s {
            "CLASSIFICATION" => PatchProperty::PatchClassification,
            "MSRC_SEVERITY" => PatchProperty::PatchMsrcSeverity,
            "PRIORITY" => PatchProperty::PatchPriority,
            "PRODUCT" => PatchProperty::Product,
            "PRODUCT_FAMILY" => PatchProperty::PatchProductFamily,
            "SEVERITY" => PatchProperty::PatchSeverity,
            other => PatchProperty::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PatchProperty {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PatchProperty::from(s))
    }
}
impl PatchProperty {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PatchProperty::PatchClassification => "CLASSIFICATION",
            PatchProperty::PatchMsrcSeverity => "MSRC_SEVERITY",
            PatchProperty::PatchPriority => "PRIORITY",
            PatchProperty::Product => "PRODUCT",
            PatchProperty::PatchProductFamily => "PRODUCT_FAMILY",
            PatchProperty::PatchSeverity => "SEVERITY",
            PatchProperty::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLASSIFICATION",
            "MSRC_SEVERITY",
            "PRIORITY",
            "PRODUCT",
            "PRODUCT_FAMILY",
            "SEVERITY",
        ]
    }
}
impl AsRef<str> for PatchProperty {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The mapping between a patch group and the patch baseline the patch group is registered
/// with.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchGroupPatchBaselineMapping {
    /// <p>The name of the patch group registered with the patch baseline.</p>
    pub patch_group: std::option::Option<std::string::String>,
    /// <p>The patch baseline the patch group is registered with.</p>
    pub baseline_identity: std::option::Option<crate::model::PatchBaselineIdentity>,
}
impl std::fmt::Debug for PatchGroupPatchBaselineMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchGroupPatchBaselineMapping");
        formatter.field("patch_group", &self.patch_group);
        formatter.field("baseline_identity", &self.baseline_identity);
        formatter.finish()
    }
}
/// See [`PatchGroupPatchBaselineMapping`](crate::model::PatchGroupPatchBaselineMapping)
pub mod patch_group_patch_baseline_mapping {
    /// A builder for [`PatchGroupPatchBaselineMapping`](crate::model::PatchGroupPatchBaselineMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) patch_group: std::option::Option<std::string::String>,
        pub(crate) baseline_identity: std::option::Option<crate::model::PatchBaselineIdentity>,
    }
    impl Builder {
        /// <p>The name of the patch group registered with the patch baseline.</p>
        pub fn patch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.patch_group = Some(input.into());
            self
        }
        /// <p>The name of the patch group registered with the patch baseline.</p>
        pub fn set_patch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.patch_group = input;
            self
        }
        /// <p>The patch baseline the patch group is registered with.</p>
        pub fn baseline_identity(mut self, input: crate::model::PatchBaselineIdentity) -> Self {
            self.baseline_identity = Some(input);
            self
        }
        /// <p>The patch baseline the patch group is registered with.</p>
        pub fn set_baseline_identity(
            mut self,
            input: std::option::Option<crate::model::PatchBaselineIdentity>,
        ) -> Self {
            self.baseline_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchGroupPatchBaselineMapping`](crate::model::PatchGroupPatchBaselineMapping)
        pub fn build(self) -> crate::model::PatchGroupPatchBaselineMapping {
            crate::model::PatchGroupPatchBaselineMapping {
                patch_group: self.patch_group,
                baseline_identity: self.baseline_identity,
            }
        }
    }
}
impl PatchGroupPatchBaselineMapping {
    /// Creates a new builder-style object to manufacture [`PatchGroupPatchBaselineMapping`](crate::model::PatchGroupPatchBaselineMapping)
    pub fn builder() -> crate::model::patch_group_patch_baseline_mapping::Builder {
        crate::model::patch_group_patch_baseline_mapping::Builder::default()
    }
}

/// <p>Defines the basic information about a patch baseline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchBaselineIdentity {
    /// <p>The ID of the patch baseline.</p>
    pub baseline_id: std::option::Option<std::string::String>,
    /// <p>The name of the patch baseline.</p>
    pub baseline_name: std::option::Option<std::string::String>,
    /// <p>Defines the operating system the patch baseline applies to. The default value is
    /// <code>WINDOWS</code>. </p>
    pub operating_system: std::option::Option<crate::model::OperatingSystem>,
    /// <p>The description of the patch baseline.</p>
    pub baseline_description: std::option::Option<std::string::String>,
    /// <p>Whether this is the default baseline. Amazon Web Services Systems Manager supports creating multiple default patch
    /// baselines. For example, you can create a default patch baseline for each operating system.</p>
    pub default_baseline: bool,
}
impl std::fmt::Debug for PatchBaselineIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchBaselineIdentity");
        formatter.field("baseline_id", &self.baseline_id);
        formatter.field("baseline_name", &self.baseline_name);
        formatter.field("operating_system", &self.operating_system);
        formatter.field("baseline_description", &self.baseline_description);
        formatter.field("default_baseline", &self.default_baseline);
        formatter.finish()
    }
}
/// See [`PatchBaselineIdentity`](crate::model::PatchBaselineIdentity)
pub mod patch_baseline_identity {
    /// A builder for [`PatchBaselineIdentity`](crate::model::PatchBaselineIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_id: std::option::Option<std::string::String>,
        pub(crate) baseline_name: std::option::Option<std::string::String>,
        pub(crate) operating_system: std::option::Option<crate::model::OperatingSystem>,
        pub(crate) baseline_description: std::option::Option<std::string::String>,
        pub(crate) default_baseline: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the patch baseline.</p>
        pub fn baseline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_id = Some(input.into());
            self
        }
        /// <p>The ID of the patch baseline.</p>
        pub fn set_baseline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.baseline_id = input;
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn baseline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_name = Some(input.into());
            self
        }
        /// <p>The name of the patch baseline.</p>
        pub fn set_baseline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.baseline_name = input;
            self
        }
        /// <p>Defines the operating system the patch baseline applies to. The default value is
        /// <code>WINDOWS</code>. </p>
        pub fn operating_system(mut self, input: crate::model::OperatingSystem) -> Self {
            self.operating_system = Some(input);
            self
        }
        /// <p>Defines the operating system the patch baseline applies to. The default value is
        /// <code>WINDOWS</code>. </p>
        pub fn set_operating_system(
            mut self,
            input: std::option::Option<crate::model::OperatingSystem>,
        ) -> Self {
            self.operating_system = input;
            self
        }
        /// <p>The description of the patch baseline.</p>
        pub fn baseline_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.baseline_description = Some(input.into());
            self
        }
        /// <p>The description of the patch baseline.</p>
        pub fn set_baseline_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.baseline_description = input;
            self
        }
        /// <p>Whether this is the default baseline. Amazon Web Services Systems Manager supports creating multiple default patch
        /// baselines. For example, you can create a default patch baseline for each operating system.</p>
        pub fn default_baseline(mut self, input: bool) -> Self {
            self.default_baseline = Some(input);
            self
        }
        /// <p>Whether this is the default baseline. Amazon Web Services Systems Manager supports creating multiple default patch
        /// baselines. For example, you can create a default patch baseline for each operating system.</p>
        pub fn set_default_baseline(mut self, input: std::option::Option<bool>) -> Self {
            self.default_baseline = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchBaselineIdentity`](crate::model::PatchBaselineIdentity)
        pub fn build(self) -> crate::model::PatchBaselineIdentity {
            crate::model::PatchBaselineIdentity {
                baseline_id: self.baseline_id,
                baseline_name: self.baseline_name,
                operating_system: self.operating_system,
                baseline_description: self.baseline_description,
                default_baseline: self.default_baseline.unwrap_or_default(),
            }
        }
    }
}
impl PatchBaselineIdentity {
    /// Creates a new builder-style object to manufacture [`PatchBaselineIdentity`](crate::model::PatchBaselineIdentity)
    pub fn builder() -> crate::model::patch_baseline_identity::Builder {
        crate::model::patch_baseline_identity::Builder::default()
    }
}

/// <p>Defines a filter used in Patch Manager APIs. Supported filter keys depend on the API
/// operation that includes the filter. Patch Manager API operations that use
/// <code>PatchOrchestratorFilter</code> include the following:</p>
/// <ul>
/// <li>
/// <p>
/// <a>DescribeAvailablePatches</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>DescribeInstancePatches</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>DescribePatchBaselines</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>DescribePatchGroups</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PatchOrchestratorFilter {
    /// <p>The key for the filter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for the filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PatchOrchestratorFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PatchOrchestratorFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PatchOrchestratorFilter`](crate::model::PatchOrchestratorFilter)
pub mod patch_orchestrator_filter {
    /// A builder for [`PatchOrchestratorFilter`](crate::model::PatchOrchestratorFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The key for the filter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the filter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value for the filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value for the filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PatchOrchestratorFilter`](crate::model::PatchOrchestratorFilter)
        pub fn build(self) -> crate::model::PatchOrchestratorFilter {
            crate::model::PatchOrchestratorFilter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl PatchOrchestratorFilter {
    /// Creates a new builder-style object to manufacture [`PatchOrchestratorFilter`](crate::model::PatchOrchestratorFilter)
    pub fn builder() -> crate::model::patch_orchestrator_filter::Builder {
        crate::model::patch_orchestrator_filter::Builder::default()
    }
}

/// <p>Metadata includes information like the ARN of the last user and the date/time the parameter
/// was last used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterMetadata {
    /// <p>The parameter name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of parameter. Valid parameter types include the following: <code>String</code>,
    /// <code>StringList</code>, and <code>SecureString</code>.</p>
    pub r#type: std::option::Option<crate::model::ParameterType>,
    /// <p>The ID of the query key used for this parameter.</p>
    pub key_id: std::option::Option<std::string::String>,
    /// <p>Date the parameter was last changed or updated.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>
    pub last_modified_user: std::option::Option<std::string::String>,
    /// <p>Description of the parameter actions.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A parameter name can include only the following letters and symbols.</p>
    /// <p>a-zA-Z0-9_.-</p>
    pub allowed_pattern: std::option::Option<std::string::String>,
    /// <p>The parameter version.</p>
    pub version: i64,
    /// <p>The parameter tier.</p>
    pub tier: std::option::Option<crate::model::ParameterTier>,
    /// <p>A list of policies associated with a parameter.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::ParameterInlinePolicy>>,
    /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
    /// default is <code>text</code>.</p>
    pub data_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ParameterMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterMetadata");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("key_id", &self.key_id);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("last_modified_user", &self.last_modified_user);
        formatter.field("description", &self.description);
        formatter.field("allowed_pattern", &self.allowed_pattern);
        formatter.field("version", &self.version);
        formatter.field("tier", &self.tier);
        formatter.field("policies", &self.policies);
        formatter.field("data_type", &self.data_type);
        formatter.finish()
    }
}
/// See [`ParameterMetadata`](crate::model::ParameterMetadata)
pub mod parameter_metadata {
    /// A builder for [`ParameterMetadata`](crate::model::ParameterMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ParameterType>,
        pub(crate) key_id: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_user: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) allowed_pattern: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) tier: std::option::Option<crate::model::ParameterTier>,
        pub(crate) policies:
            std::option::Option<std::vec::Vec<crate::model::ParameterInlinePolicy>>,
        pub(crate) data_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The parameter name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The parameter name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of parameter. Valid parameter types include the following: <code>String</code>,
        /// <code>StringList</code>, and <code>SecureString</code>.</p>
        pub fn r#type(mut self, input: crate::model::ParameterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of parameter. Valid parameter types include the following: <code>String</code>,
        /// <code>StringList</code>, and <code>SecureString</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ParameterType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the query key used for this parameter.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>The ID of the query key used for this parameter.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// <p>Date the parameter was last changed or updated.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>Date the parameter was last changed or updated.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>
        pub fn last_modified_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_user = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.</p>
        pub fn set_last_modified_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_user = input;
            self
        }
        /// <p>Description of the parameter actions.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the parameter actions.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A parameter name can include only the following letters and symbols.</p>
        /// <p>a-zA-Z0-9_.-</p>
        pub fn allowed_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_pattern = Some(input.into());
            self
        }
        /// <p>A parameter name can include only the following letters and symbols.</p>
        /// <p>a-zA-Z0-9_.-</p>
        pub fn set_allowed_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_pattern = input;
            self
        }
        /// <p>The parameter version.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The parameter version.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The parameter tier.</p>
        pub fn tier(mut self, input: crate::model::ParameterTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The parameter tier.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::ParameterTier>) -> Self {
            self.tier = input;
            self
        }
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>A list of policies associated with a parameter.</p>
        pub fn policies(mut self, input: impl Into<crate::model::ParameterInlinePolicy>) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>A list of policies associated with a parameter.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterInlinePolicy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
        /// default is <code>text</code>.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The
        /// default is <code>text</code>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterMetadata`](crate::model::ParameterMetadata)
        pub fn build(self) -> crate::model::ParameterMetadata {
            crate::model::ParameterMetadata {
                name: self.name,
                r#type: self.r#type,
                key_id: self.key_id,
                last_modified_date: self.last_modified_date,
                last_modified_user: self.last_modified_user,
                description: self.description,
                allowed_pattern: self.allowed_pattern,
                version: self.version.unwrap_or_default(),
                tier: self.tier,
                policies: self.policies,
                data_type: self.data_type,
            }
        }
    }
}
impl ParameterMetadata {
    /// Creates a new builder-style object to manufacture [`ParameterMetadata`](crate::model::ParameterMetadata)
    pub fn builder() -> crate::model::parameter_metadata::Builder {
        crate::model::parameter_metadata::Builder::default()
    }
}

/// <p>This data type is deprecated. Instead, use <a>ParameterStringFilter</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParametersFilter {
    /// <p>The name of the filter.</p>
    pub key: std::option::Option<crate::model::ParametersFilterKey>,
    /// <p>The filter values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ParametersFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParametersFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ParametersFilter`](crate::model::ParametersFilter)
pub mod parameters_filter {
    /// A builder for [`ParametersFilter`](crate::model::ParametersFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::ParametersFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn key(mut self, input: crate::model::ParametersFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::ParametersFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ParametersFilter`](crate::model::ParametersFilter)
        pub fn build(self) -> crate::model::ParametersFilter {
            crate::model::ParametersFilter {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl ParametersFilter {
    /// Creates a new builder-style object to manufacture [`ParametersFilter`](crate::model::ParametersFilter)
    pub fn builder() -> crate::model::parameters_filter::Builder {
        crate::model::parameters_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParametersFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    KeyId,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Type,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParametersFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "KeyId" => ParametersFilterKey::KeyId,
            "Name" => ParametersFilterKey::Name,
            "Type" => ParametersFilterKey::Type,
            other => ParametersFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParametersFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParametersFilterKey::from(s))
    }
}
impl ParametersFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParametersFilterKey::KeyId => "KeyId",
            ParametersFilterKey::Name => "Name",
            ParametersFilterKey::Type => "Type",
            ParametersFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KeyId", "Name", "Type"]
    }
}
impl AsRef<str> for ParametersFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A count of OpsItems.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemSummary {
    /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the
    /// OpsItem.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time the OpsItem was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the
    /// OpsItem.</p>
    pub last_modified_by: std::option::Option<std::string::String>,
    /// <p>The date and time the OpsItem was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The impacted Amazon Web Services resource.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
    /// <code>Resolved</code>.</p>
    pub status: std::option::Option<crate::model::OpsItemStatus>,
    /// <p>The ID of the OpsItem.</p>
    pub ops_item_id: std::option::Option<std::string::String>,
    /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
    /// </p>
    pub operational_data: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
    >,
    /// <p>A list of OpsItems by category.</p>
    pub category: std::option::Option<std::string::String>,
    /// <p>A list of OpsItems by severity.</p>
    pub severity: std::option::Option<std::string::String>,
    /// <p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code>
    /// and <code>/aws/issue</code>.</p>
    pub ops_item_type: std::option::Option<std::string::String>,
    /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
    /// <code>/aws/changerequest</code>.</p>
    pub actual_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
    /// <code>/aws/changerequest</code>.</p>
    pub actual_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
    /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
    pub planned_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
    /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
    pub planned_end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for OpsItemSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemSummary");
        formatter.field("created_by", &self.created_by);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("priority", &self.priority);
        formatter.field("source", &self.source);
        formatter.field("status", &self.status);
        formatter.field("ops_item_id", &self.ops_item_id);
        formatter.field("title", &self.title);
        formatter.field("operational_data", &self.operational_data);
        formatter.field("category", &self.category);
        formatter.field("severity", &self.severity);
        formatter.field("ops_item_type", &self.ops_item_type);
        formatter.field("actual_start_time", &self.actual_start_time);
        formatter.field("actual_end_time", &self.actual_end_time);
        formatter.field("planned_start_time", &self.planned_start_time);
        formatter.field("planned_end_time", &self.planned_end_time);
        formatter.finish()
    }
}
/// See [`OpsItemSummary`](crate::model::OpsItemSummary)
pub mod ops_item_summary {
    /// A builder for [`OpsItemSummary`](crate::model::OpsItemSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_by: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OpsItemStatus>,
        pub(crate) ops_item_id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) operational_data: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
        >,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<std::string::String>,
        pub(crate) ops_item_type: std::option::Option<std::string::String>,
        pub(crate) actual_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) actual_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) planned_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) planned_end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the
        /// OpsItem.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the
        /// OpsItem.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time the OpsItem was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time the OpsItem was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the
        /// OpsItem.</p>
        pub fn last_modified_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM entity that created the
        /// OpsItem.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The date and time the OpsItem was last updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time the OpsItem was last updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The importance of this OpsItem in relation to other OpsItems in the system.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The impacted Amazon Web Services resource.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The impacted Amazon Web Services resource.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
        /// <code>Resolved</code>.</p>
        pub fn status(mut self, input: crate::model::OpsItemStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or
        /// <code>Resolved</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OpsItemStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn ops_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_id = Some(input.into());
            self
        }
        /// <p>The ID of the OpsItem.</p>
        pub fn set_ops_item_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ops_item_id = input;
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// Adds a key-value pair to `operational_data`.
        ///
        /// To override the contents of this collection use [`set_operational_data`](Self::set_operational_data).
        ///
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// </p>
        pub fn operational_data(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::OpsItemDataValue>,
        ) -> Self {
            let mut hash_map = self.operational_data.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.operational_data = Some(hash_map);
            self
        }
        /// <p>Operational data is custom data that provides useful reference details about the OpsItem.
        /// </p>
        pub fn set_operational_data(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::OpsItemDataValue>,
            >,
        ) -> Self {
            self.operational_data = input;
            self
        }
        /// <p>A list of OpsItems by category.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>A list of OpsItems by category.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// <p>A list of OpsItems by severity.</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity = Some(input.into());
            self
        }
        /// <p>A list of OpsItems by severity.</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code>
        /// and <code>/aws/issue</code>.</p>
        pub fn ops_item_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.ops_item_type = Some(input.into());
            self
        }
        /// <p>The type of OpsItem. Currently, the only valid values are <code>/aws/changerequest</code>
        /// and <code>/aws/issue</code>.</p>
        pub fn set_ops_item_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ops_item_type = input;
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.actual_start_time = Some(input);
            self
        }
        /// <p>The time a runbook workflow started. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.actual_start_time = input;
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn actual_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.actual_end_time = Some(input);
            self
        }
        /// <p>The time a runbook workflow ended. Currently reported only for the OpsItem type
        /// <code>/aws/changerequest</code>.</p>
        pub fn set_actual_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.actual_end_time = input;
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.planned_start_time = Some(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to start. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.planned_start_time = input;
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn planned_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.planned_end_time = Some(input);
            self
        }
        /// <p>The time specified in a change request for a runbook workflow to end. Currently supported
        /// only for the OpsItem type <code>/aws/changerequest</code>.</p>
        pub fn set_planned_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.planned_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemSummary`](crate::model::OpsItemSummary)
        pub fn build(self) -> crate::model::OpsItemSummary {
            crate::model::OpsItemSummary {
                created_by: self.created_by,
                created_time: self.created_time,
                last_modified_by: self.last_modified_by,
                last_modified_time: self.last_modified_time,
                priority: self.priority,
                source: self.source,
                status: self.status,
                ops_item_id: self.ops_item_id,
                title: self.title,
                operational_data: self.operational_data,
                category: self.category,
                severity: self.severity,
                ops_item_type: self.ops_item_type,
                actual_start_time: self.actual_start_time,
                actual_end_time: self.actual_end_time,
                planned_start_time: self.planned_start_time,
                planned_end_time: self.planned_end_time,
            }
        }
    }
}
impl OpsItemSummary {
    /// Creates a new builder-style object to manufacture [`OpsItemSummary`](crate::model::OpsItemSummary)
    pub fn builder() -> crate::model::ops_item_summary::Builder {
        crate::model::ops_item_summary::Builder::default()
    }
}

/// <p>Describes an OpsItem filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpsItemFilter {
    /// <p>The name of the filter.</p>
    pub key: std::option::Option<crate::model::OpsItemFilterKey>,
    /// <p>The filter value.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator used by the filter call.</p>
    pub operator: std::option::Option<crate::model::OpsItemFilterOperator>,
}
impl std::fmt::Debug for OpsItemFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpsItemFilter");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`OpsItemFilter`](crate::model::OpsItemFilter)
pub mod ops_item_filter {
    /// A builder for [`OpsItemFilter`](crate::model::OpsItemFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::OpsItemFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::OpsItemFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn key(mut self, input: crate::model::OpsItemFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::OpsItemFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter value.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter value.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator used by the filter call.</p>
        pub fn operator(mut self, input: crate::model::OpsItemFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator used by the filter call.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::OpsItemFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`OpsItemFilter`](crate::model::OpsItemFilter)
        pub fn build(self) -> crate::model::OpsItemFilter {
            crate::model::OpsItemFilter {
                key: self.key,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl OpsItemFilter {
    /// Creates a new builder-style object to manufacture [`OpsItemFilter`](crate::model::OpsItemFilter)
    pub fn builder() -> crate::model::ops_item_filter::Builder {
        crate::model::ops_item_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "Contains" => OpsItemFilterOperator::Contains,
            "Equal" => OpsItemFilterOperator::Equal,
            "GreaterThan" => OpsItemFilterOperator::GreaterThan,
            "LessThan" => OpsItemFilterOperator::LessThan,
            other => OpsItemFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OpsItemFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OpsItemFilterOperator::from(s))
    }
}
impl OpsItemFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OpsItemFilterOperator::Contains => "Contains",
            OpsItemFilterOperator::Equal => "Equal",
            OpsItemFilterOperator::GreaterThan => "GreaterThan",
            OpsItemFilterOperator::LessThan => "LessThan",
            OpsItemFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Contains", "Equal", "GreaterThan", "LessThan"]
    }
}
impl AsRef<str> for OpsItemFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OpsItemFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    ActualEndTime,
    #[allow(missing_docs)] // documentation missing in model
    ActualStartTime,
    #[allow(missing_docs)] // documentation missing in model
    AutomationId,
    #[allow(missing_docs)] // documentation missing in model
    Category,
    #[allow(missing_docs)] // documentation missing in model
    ChangeRequestApproverArn,
    #[allow(missing_docs)] // documentation missing in model
    ChangeRequestApproverName,
    #[allow(missing_docs)] // documentation missing in model
    ChangeRequestRequesterArn,
    #[allow(missing_docs)] // documentation missing in model
    ChangeRequestRequesterName,
    #[allow(missing_docs)] // documentation missing in model
    ChangeRequestTargetsResourceGroup,
    #[allow(missing_docs)] // documentation missing in model
    ChangeRequestTemplate,
    #[allow(missing_docs)] // documentation missing in model
    CreatedBy,
    #[allow(missing_docs)] // documentation missing in model
    CreatedTime,
    #[allow(missing_docs)] // documentation missing in model
    InsightType,
    #[allow(missing_docs)] // documentation missing in model
    LastModifiedTime,
    #[allow(missing_docs)] // documentation missing in model
    OperationalData,
    #[allow(missing_docs)] // documentation missing in model
    OperationalDataKey,
    #[allow(missing_docs)] // documentation missing in model
    OperationalDataValue,
    #[allow(missing_docs)] // documentation missing in model
    OpsitemId,
    #[allow(missing_docs)] // documentation missing in model
    OpsitemType,
    #[allow(missing_docs)] // documentation missing in model
    PlannedEndTime,
    #[allow(missing_docs)] // documentation missing in model
    PlannedStartTime,
    #[allow(missing_docs)] // documentation missing in model
    Priority,
    #[allow(missing_docs)] // documentation missing in model
    ResourceId,
    #[allow(missing_docs)] // documentation missing in model
    Severity,
    #[allow(missing_docs)] // documentation missing in model
    Source,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    Title,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OpsItemFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "ActualEndTime" => OpsItemFilterKey::ActualEndTime,
            "ActualStartTime" => OpsItemFilterKey::ActualStartTime,
            "AutomationId" => OpsItemFilterKey::AutomationId,
            "Category" => OpsItemFilterKey::Category,
            "ChangeRequestByApproverArn" => OpsItemFilterKey::ChangeRequestApproverArn,
            "ChangeRequestByApproverName" => OpsItemFilterKey::ChangeRequestApproverName,
            "ChangeRequestByRequesterArn" => OpsItemFilterKey::ChangeRequestRequesterArn,
            "ChangeRequestByRequesterName" => OpsItemFilterKey::ChangeRequestRequesterName,
            "ChangeRequestByTargetsResourceGroup" => {
                OpsItemFilterKey::ChangeRequestTargetsResourceGroup
            }
            "ChangeRequestByTemplate" => OpsItemFilterKey::ChangeRequestTemplate,
            "CreatedBy" => OpsItemFilterKey::CreatedBy,
            "CreatedTime" => OpsItemFilterKey::CreatedTime,
            "InsightByType" => OpsItemFilterKey::InsightType,
            "LastModifiedTime" => Op