// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagQueueOutput {}
impl std::fmt::Debug for UntagQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagQueueOutput");
        formatter.finish()
    }
}
/// See [`UntagQueueOutput`](crate::output::UntagQueueOutput)
pub mod untag_queue_output {
    /// A builder for [`UntagQueueOutput`](crate::output::UntagQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagQueueOutput`](crate::output::UntagQueueOutput)
        pub fn build(self) -> crate::output::UntagQueueOutput {
            crate::output::UntagQueueOutput {}
        }
    }
}
impl UntagQueueOutput {
    /// Creates a new builder-style object to manufacture [`UntagQueueOutput`](crate::output::UntagQueueOutput)
    pub fn builder() -> crate::output::untag_queue_output::Builder {
        crate::output::untag_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagQueueOutput {}
impl std::fmt::Debug for TagQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagQueueOutput");
        formatter.finish()
    }
}
/// See [`TagQueueOutput`](crate::output::TagQueueOutput)
pub mod tag_queue_output {
    /// A builder for [`TagQueueOutput`](crate::output::TagQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagQueueOutput`](crate::output::TagQueueOutput)
        pub fn build(self) -> crate::output::TagQueueOutput {
            crate::output::TagQueueOutput {}
        }
    }
}
impl TagQueueOutput {
    /// Creates a new builder-style object to manufacture [`TagQueueOutput`](crate::output::TagQueueOutput)
    pub fn builder() -> crate::output::tag_queue_output::Builder {
        crate::output::tag_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetQueueAttributesOutput {}
impl std::fmt::Debug for SetQueueAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetQueueAttributesOutput");
        formatter.finish()
    }
}
/// See [`SetQueueAttributesOutput`](crate::output::SetQueueAttributesOutput)
pub mod set_queue_attributes_output {
    /// A builder for [`SetQueueAttributesOutput`](crate::output::SetQueueAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetQueueAttributesOutput`](crate::output::SetQueueAttributesOutput)
        pub fn build(self) -> crate::output::SetQueueAttributesOutput {
            crate::output::SetQueueAttributesOutput {}
        }
    }
}
impl SetQueueAttributesOutput {
    /// Creates a new builder-style object to manufacture [`SetQueueAttributesOutput`](crate::output::SetQueueAttributesOutput)
    pub fn builder() -> crate::output::set_queue_attributes_output::Builder {
        crate::output::set_queue_attributes_output::Builder::default()
    }
}

/// <p>For each message in the batch, the response contains a <code> <code>SendMessageBatchResultEntry</code> </code> tag if the message succeeds or a <code> <code>BatchResultErrorEntry</code> </code> tag if the message fails.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendMessageBatchOutput {
    /// <p>A list of <code> <code>SendMessageBatchResultEntry</code> </code> items.</p>
    pub successful: std::option::Option<std::vec::Vec<crate::model::SendMessageBatchResultEntry>>,
    /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items with error details about each message that can't be enqueued.</p>
    pub failed: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
}
impl SendMessageBatchOutput {
    /// <p>A list of <code> <code>SendMessageBatchResultEntry</code> </code> items.</p>
    pub fn successful(&self) -> std::option::Option<&[crate::model::SendMessageBatchResultEntry]> {
        self.successful.as_deref()
    }
    /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items with error details about each message that can't be enqueued.</p>
    pub fn failed(&self) -> std::option::Option<&[crate::model::BatchResultErrorEntry]> {
        self.failed.as_deref()
    }
}
impl std::fmt::Debug for SendMessageBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendMessageBatchOutput");
        formatter.field("successful", &self.successful);
        formatter.field("failed", &self.failed);
        formatter.finish()
    }
}
/// See [`SendMessageBatchOutput`](crate::output::SendMessageBatchOutput)
pub mod send_message_batch_output {
    /// A builder for [`SendMessageBatchOutput`](crate::output::SendMessageBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful:
            std::option::Option<std::vec::Vec<crate::model::SendMessageBatchResultEntry>>,
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
    }
    impl Builder {
        /// Appends an item to `successful`.
        ///
        /// To override the contents of this collection use [`set_successful`](Self::set_successful).
        ///
        /// <p>A list of <code> <code>SendMessageBatchResultEntry</code> </code> items.</p>
        pub fn successful(mut self, input: crate::model::SendMessageBatchResultEntry) -> Self {
            let mut v = self.successful.unwrap_or_default();
            v.push(input);
            self.successful = Some(v);
            self
        }
        /// <p>A list of <code> <code>SendMessageBatchResultEntry</code> </code> items.</p>
        pub fn set_successful(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SendMessageBatchResultEntry>>,
        ) -> Self {
            self.successful = input;
            self
        }
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items with error details about each message that can't be enqueued.</p>
        pub fn failed(mut self, input: crate::model::BatchResultErrorEntry) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input);
            self.failed = Some(v);
            self
        }
        /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items with error details about each message that can't be enqueued.</p>
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Consumes the builder and constructs a [`SendMessageBatchOutput`](crate::output::SendMessageBatchOutput)
        pub fn build(self) -> crate::output::SendMessageBatchOutput {
            crate::output::SendMessageBatchOutput {
                successful: self.successful,
                failed: self.failed,
            }
        }
    }
}
impl SendMessageBatchOutput {
    /// Creates a new builder-style object to manufacture [`SendMessageBatchOutput`](crate::output::SendMessageBatchOutput)
    pub fn builder() -> crate::output::send_message_batch_output::Builder {
        crate::output::send_message_batch_output::Builder::default()
    }
}

/// <p>The <code>MD5OfMessageBody</code> and <code>MessageId</code> elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendMessageOutput {
    /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub md5_of_message_body: std::option::Option<std::string::String>,
    /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub md5_of_message_attributes: std::option::Option<std::string::String>,
    /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.</p>
    pub md5_of_message_system_attributes: std::option::Option<std::string::String>,
    /// <p>An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html">Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>. </p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
    /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
    pub sequence_number: std::option::Option<std::string::String>,
}
impl SendMessageOutput {
    /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub fn md5_of_message_body(&self) -> std::option::Option<&str> {
        self.md5_of_message_body.as_deref()
    }
    /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub fn md5_of_message_attributes(&self) -> std::option::Option<&str> {
        self.md5_of_message_attributes.as_deref()
    }
    /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.</p>
    pub fn md5_of_message_system_attributes(&self) -> std::option::Option<&str> {
        self.md5_of_message_system_attributes.as_deref()
    }
    /// <p>An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html">Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>. </p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
    /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
    pub fn sequence_number(&self) -> std::option::Option<&str> {
        self.sequence_number.as_deref()
    }
}
impl std::fmt::Debug for SendMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendMessageOutput");
        formatter.field("md5_of_message_body", &self.md5_of_message_body);
        formatter.field("md5_of_message_attributes", &self.md5_of_message_attributes);
        formatter.field(
            "md5_of_message_system_attributes",
            &self.md5_of_message_system_attributes,
        );
        formatter.field("message_id", &self.message_id);
        formatter.field("sequence_number", &self.sequence_number);
        formatter.finish()
    }
}
/// See [`SendMessageOutput`](crate::output::SendMessageOutput)
pub mod send_message_output {
    /// A builder for [`SendMessageOutput`](crate::output::SendMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) md5_of_message_body: std::option::Option<std::string::String>,
        pub(crate) md5_of_message_attributes: std::option::Option<std::string::String>,
        pub(crate) md5_of_message_system_attributes: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) sequence_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn md5_of_message_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_of_message_body = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn set_md5_of_message_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.md5_of_message_body = input;
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn md5_of_message_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_of_message_attributes = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn set_md5_of_message_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.md5_of_message_attributes = input;
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.</p>
        pub fn md5_of_message_system_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.md5_of_message_system_attributes = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest.</p>
        pub fn set_md5_of_message_system_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.md5_of_message_system_attributes = input;
            self
        }
        /// <p>An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html">Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>. </p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>An attribute containing the <code>MessageId</code> of the message sent to the queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html">Queue and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>. </p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
        /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
        pub fn sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.sequence_number = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
        /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sequence_number = input;
            self
        }
        /// Consumes the builder and constructs a [`SendMessageOutput`](crate::output::SendMessageOutput)
        pub fn build(self) -> crate::output::SendMessageOutput {
            crate::output::SendMessageOutput {
                md5_of_message_body: self.md5_of_message_body,
                md5_of_message_attributes: self.md5_of_message_attributes,
                md5_of_message_system_attributes: self.md5_of_message_system_attributes,
                message_id: self.message_id,
                sequence_number: self.sequence_number,
            }
        }
    }
}
impl SendMessageOutput {
    /// Creates a new builder-style object to manufacture [`SendMessageOutput`](crate::output::SendMessageOutput)
    pub fn builder() -> crate::output::send_message_output::Builder {
        crate::output::send_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionOutput {}
impl std::fmt::Debug for RemovePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionOutput");
        formatter.finish()
    }
}
/// See [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
pub mod remove_permission_output {
    /// A builder for [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
        pub fn build(self) -> crate::output::RemovePermissionOutput {
            crate::output::RemovePermissionOutput {}
        }
    }
}
impl RemovePermissionOutput {
    /// Creates a new builder-style object to manufacture [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    pub fn builder() -> crate::output::remove_permission_output::Builder {
        crate::output::remove_permission_output::Builder::default()
    }
}

/// <p>A list of received messages.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceiveMessageOutput {
    /// <p>A list of messages.</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
}
impl ReceiveMessageOutput {
    /// <p>A list of messages.</p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::Message]> {
        self.messages.as_deref()
    }
}
impl std::fmt::Debug for ReceiveMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceiveMessageOutput");
        formatter.field("messages", &self.messages);
        formatter.finish()
    }
}
/// See [`ReceiveMessageOutput`](crate::output::ReceiveMessageOutput)
pub mod receive_message_output {
    /// A builder for [`ReceiveMessageOutput`](crate::output::ReceiveMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>A list of messages.</p>
        pub fn messages(mut self, input: crate::model::Message) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input);
            self.messages = Some(v);
            self
        }
        /// <p>A list of messages.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceiveMessageOutput`](crate::output::ReceiveMessageOutput)
        pub fn build(self) -> crate::output::ReceiveMessageOutput {
            crate::output::ReceiveMessageOutput {
                messages: self.messages,
            }
        }
    }
}
impl ReceiveMessageOutput {
    /// Creates a new builder-style object to manufacture [`ReceiveMessageOutput`](crate::output::ReceiveMessageOutput)
    pub fn builder() -> crate::output::receive_message_output::Builder {
        crate::output::receive_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurgeQueueOutput {}
impl std::fmt::Debug for PurgeQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurgeQueueOutput");
        formatter.finish()
    }
}
/// See [`PurgeQueueOutput`](crate::output::PurgeQueueOutput)
pub mod purge_queue_output {
    /// A builder for [`PurgeQueueOutput`](crate::output::PurgeQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PurgeQueueOutput`](crate::output::PurgeQueueOutput)
        pub fn build(self) -> crate::output::PurgeQueueOutput {
            crate::output::PurgeQueueOutput {}
        }
    }
}
impl PurgeQueueOutput {
    /// Creates a new builder-style object to manufacture [`PurgeQueueOutput`](crate::output::PurgeQueueOutput)
    pub fn builder() -> crate::output::purge_queue_output::Builder {
        crate::output::purge_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueueTagsOutput {
    /// <p>The list of all tags added to the specified queue.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListQueueTagsOutput {
    /// <p>The list of all tags added to the specified queue.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListQueueTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueueTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListQueueTagsOutput`](crate::output::ListQueueTagsOutput)
pub mod list_queue_tags_output {
    /// A builder for [`ListQueueTagsOutput`](crate::output::ListQueueTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified queue.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified queue.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueueTagsOutput`](crate::output::ListQueueTagsOutput)
        pub fn build(self) -> crate::output::ListQueueTagsOutput {
            crate::output::ListQueueTagsOutput { tags: self.tags }
        }
    }
}
impl ListQueueTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListQueueTagsOutput`](crate::output::ListQueueTagsOutput)
    pub fn builder() -> crate::output::list_queue_tags_output::Builder {
        crate::output::list_queue_tags_output::Builder::default()
    }
}

/// <p>A list of your queues.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueuesOutput {
    /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of queue URLs, up to 1,000 entries, or the value of MaxResults that you sent in the request.</p>
    pub queue_urls: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListQueuesOutput {
    /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of queue URLs, up to 1,000 entries, or the value of MaxResults that you sent in the request.</p>
    pub fn queue_urls(&self) -> std::option::Option<&[std::string::String]> {
        self.queue_urls.as_deref()
    }
}
impl std::fmt::Debug for ListQueuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueuesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("queue_urls", &self.queue_urls);
        formatter.finish()
    }
}
/// See [`ListQueuesOutput`](crate::output::ListQueuesOutput)
pub mod list_queues_output {
    /// A builder for [`ListQueuesOutput`](crate::output::ListQueuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) queue_urls: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `queue_urls`.
        ///
        /// To override the contents of this collection use [`set_queue_urls`](Self::set_queue_urls).
        ///
        /// <p>A list of queue URLs, up to 1,000 entries, or the value of MaxResults that you sent in the request.</p>
        pub fn queue_urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queue_urls.unwrap_or_default();
            v.push(input.into());
            self.queue_urls = Some(v);
            self
        }
        /// <p>A list of queue URLs, up to 1,000 entries, or the value of MaxResults that you sent in the request.</p>
        pub fn set_queue_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queue_urls = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueuesOutput`](crate::output::ListQueuesOutput)
        pub fn build(self) -> crate::output::ListQueuesOutput {
            crate::output::ListQueuesOutput {
                next_token: self.next_token,
                queue_urls: self.queue_urls,
            }
        }
    }
}
impl ListQueuesOutput {
    /// Creates a new builder-style object to manufacture [`ListQueuesOutput`](crate::output::ListQueuesOutput)
    pub fn builder() -> crate::output::list_queues_output::Builder {
        crate::output::list_queues_output::Builder::default()
    }
}

/// <p>A list of your dead letter source queues.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeadLetterSourceQueuesOutput {
    /// <p>A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a dead-letter queue.</p>
    pub queue_urls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeadLetterSourceQueuesOutput {
    /// <p>A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a dead-letter queue.</p>
    pub fn queue_urls(&self) -> std::option::Option<&[std::string::String]> {
        self.queue_urls.as_deref()
    }
    /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeadLetterSourceQueuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeadLetterSourceQueuesOutput");
        formatter.field("queue_urls", &self.queue_urls);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeadLetterSourceQueuesOutput`](crate::output::ListDeadLetterSourceQueuesOutput)
pub mod list_dead_letter_source_queues_output {
    /// A builder for [`ListDeadLetterSourceQueuesOutput`](crate::output::ListDeadLetterSourceQueuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_urls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `queue_urls`.
        ///
        /// To override the contents of this collection use [`set_queue_urls`](Self::set_queue_urls).
        ///
        /// <p>A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a dead-letter queue.</p>
        pub fn queue_urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queue_urls.unwrap_or_default();
            v.push(input.into());
            self.queue_urls = Some(v);
            self
        }
        /// <p>A list of source queue URLs that have the <code>RedrivePolicy</code> queue attribute configured with a dead-letter queue.</p>
        pub fn set_queue_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queue_urls = input;
            self
        }
        /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token to include in the next request. Token value is <code>null</code> if there are no additional results to request, or if you did not set <code>MaxResults</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeadLetterSourceQueuesOutput`](crate::output::ListDeadLetterSourceQueuesOutput)
        pub fn build(self) -> crate::output::ListDeadLetterSourceQueuesOutput {
            crate::output::ListDeadLetterSourceQueuesOutput {
                queue_urls: self.queue_urls,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeadLetterSourceQueuesOutput {
    /// Creates a new builder-style object to manufacture [`ListDeadLetterSourceQueuesOutput`](crate::output::ListDeadLetterSourceQueuesOutput)
    pub fn builder() -> crate::output::list_dead_letter_source_queues_output::Builder {
        crate::output::list_dead_letter_source_queues_output::Builder::default()
    }
}

/// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-api-responses.html">Interpreting Responses</a> in the <i>Amazon SQS Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueueUrlOutput {
    /// <p>The URL of the queue.</p>
    pub queue_url: std::option::Option<std::string::String>,
}
impl GetQueueUrlOutput {
    /// <p>The URL of the queue.</p>
    pub fn queue_url(&self) -> std::option::Option<&str> {
        self.queue_url.as_deref()
    }
}
impl std::fmt::Debug for GetQueueUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueueUrlOutput");
        formatter.field("queue_url", &self.queue_url);
        formatter.finish()
    }
}
/// See [`GetQueueUrlOutput`](crate::output::GetQueueUrlOutput)
pub mod get_queue_url_output {
    /// A builder for [`GetQueueUrlOutput`](crate::output::GetQueueUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL of the queue.</p>
        pub fn queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the queue.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueueUrlOutput`](crate::output::GetQueueUrlOutput)
        pub fn build(self) -> crate::output::GetQueueUrlOutput {
            crate::output::GetQueueUrlOutput {
                queue_url: self.queue_url,
            }
        }
    }
}
impl GetQueueUrlOutput {
    /// Creates a new builder-style object to manufacture [`GetQueueUrlOutput`](crate::output::GetQueueUrlOutput)
    pub fn builder() -> crate::output::get_queue_url_output::Builder {
        crate::output::get_queue_url_output::Builder::default()
    }
}

/// <p>A list of returned queue attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueueAttributesOutput {
    /// <p>A map of attributes to their respective values.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>,
    >,
}
impl GetQueueAttributesOutput {
    /// <p>A map of attributes to their respective values.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>,
    > {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for GetQueueAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueueAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`GetQueueAttributesOutput`](crate::output::GetQueueAttributesOutput)
pub mod get_queue_attributes_output {
    /// A builder for [`GetQueueAttributesOutput`](crate::output::GetQueueAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of attributes to their respective values.</p>
        pub fn attributes(
            mut self,
            k: crate::model::QueueAttributeName,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of attributes to their respective values.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueueAttributesOutput`](crate::output::GetQueueAttributesOutput)
        pub fn build(self) -> crate::output::GetQueueAttributesOutput {
            crate::output::GetQueueAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl GetQueueAttributesOutput {
    /// Creates a new builder-style object to manufacture [`GetQueueAttributesOutput`](crate::output::GetQueueAttributesOutput)
    pub fn builder() -> crate::output::get_queue_attributes_output::Builder {
        crate::output::get_queue_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQueueOutput {}
impl std::fmt::Debug for DeleteQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQueueOutput");
        formatter.finish()
    }
}
/// See [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
pub mod delete_queue_output {
    /// A builder for [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
        pub fn build(self) -> crate::output::DeleteQueueOutput {
            crate::output::DeleteQueueOutput {}
        }
    }
}
impl DeleteQueueOutput {
    /// Creates a new builder-style object to manufacture [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
    pub fn builder() -> crate::output::delete_queue_output::Builder {
        crate::output::delete_queue_output::Builder::default()
    }
}

/// <p>For each message in the batch, the response contains a <code> <code>DeleteMessageBatchResultEntry</code> </code> tag if the message is deleted or a <code> <code>BatchResultErrorEntry</code> </code> tag if the message can't be deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMessageBatchOutput {
    /// <p>A list of <code> <code>DeleteMessageBatchResultEntry</code> </code> items.</p>
    pub successful: std::option::Option<std::vec::Vec<crate::model::DeleteMessageBatchResultEntry>>,
    /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
    pub failed: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
}
impl DeleteMessageBatchOutput {
    /// <p>A list of <code> <code>DeleteMessageBatchResultEntry</code> </code> items.</p>
    pub fn successful(
        &self,
    ) -> std::option::Option<&[crate::model::DeleteMessageBatchResultEntry]> {
        self.successful.as_deref()
    }
    /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
    pub fn failed(&self) -> std::option::Option<&[crate::model::BatchResultErrorEntry]> {
        self.failed.as_deref()
    }
}
impl std::fmt::Debug for DeleteMessageBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMessageBatchOutput");
        formatter.field("successful", &self.successful);
        formatter.field("failed", &self.failed);
        formatter.finish()
    }
}
/// See [`DeleteMessageBatchOutput`](crate::output::DeleteMessageBatchOutput)
pub mod delete_message_batch_output {
    /// A builder for [`DeleteMessageBatchOutput`](crate::output::DeleteMessageBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful:
            std::option::Option<std::vec::Vec<crate::model::DeleteMessageBatchResultEntry>>,
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
    }
    impl Builder {
        /// Appends an item to `successful`.
        ///
        /// To override the contents of this collection use [`set_successful`](Self::set_successful).
        ///
        /// <p>A list of <code> <code>DeleteMessageBatchResultEntry</code> </code> items.</p>
        pub fn successful(mut self, input: crate::model::DeleteMessageBatchResultEntry) -> Self {
            let mut v = self.successful.unwrap_or_default();
            v.push(input);
            self.successful = Some(v);
            self
        }
        /// <p>A list of <code> <code>DeleteMessageBatchResultEntry</code> </code> items.</p>
        pub fn set_successful(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteMessageBatchResultEntry>>,
        ) -> Self {
            self.successful = input;
            self
        }
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
        pub fn failed(mut self, input: crate::model::BatchResultErrorEntry) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input);
            self.failed = Some(v);
            self
        }
        /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMessageBatchOutput`](crate::output::DeleteMessageBatchOutput)
        pub fn build(self) -> crate::output::DeleteMessageBatchOutput {
            crate::output::DeleteMessageBatchOutput {
                successful: self.successful,
                failed: self.failed,
            }
        }
    }
}
impl DeleteMessageBatchOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMessageBatchOutput`](crate::output::DeleteMessageBatchOutput)
    pub fn builder() -> crate::output::delete_message_batch_output::Builder {
        crate::output::delete_message_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMessageOutput {}
impl std::fmt::Debug for DeleteMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMessageOutput");
        formatter.finish()
    }
}
/// See [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
pub mod delete_message_output {
    /// A builder for [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
        pub fn build(self) -> crate::output::DeleteMessageOutput {
            crate::output::DeleteMessageOutput {}
        }
    }
}
impl DeleteMessageOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMessageOutput`](crate::output::DeleteMessageOutput)
    pub fn builder() -> crate::output::delete_message_output::Builder {
        crate::output::delete_message_output::Builder::default()
    }
}

/// <p>Returns the <code>QueueUrl</code> attribute of the created queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateQueueOutput {
    /// <p>The URL of the created Amazon SQS queue.</p>
    pub queue_url: std::option::Option<std::string::String>,
}
impl CreateQueueOutput {
    /// <p>The URL of the created Amazon SQS queue.</p>
    pub fn queue_url(&self) -> std::option::Option<&str> {
        self.queue_url.as_deref()
    }
}
impl std::fmt::Debug for CreateQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateQueueOutput");
        formatter.field("queue_url", &self.queue_url);
        formatter.finish()
    }
}
/// See [`CreateQueueOutput`](crate::output::CreateQueueOutput)
pub mod create_queue_output {
    /// A builder for [`CreateQueueOutput`](crate::output::CreateQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL of the created Amazon SQS queue.</p>
        pub fn queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the created Amazon SQS queue.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQueueOutput`](crate::output::CreateQueueOutput)
        pub fn build(self) -> crate::output::CreateQueueOutput {
            crate::output::CreateQueueOutput {
                queue_url: self.queue_url,
            }
        }
    }
}
impl CreateQueueOutput {
    /// Creates a new builder-style object to manufacture [`CreateQueueOutput`](crate::output::CreateQueueOutput)
    pub fn builder() -> crate::output::create_queue_output::Builder {
        crate::output::create_queue_output::Builder::default()
    }
}

/// <p>For each message in the batch, the response contains a <code> <code>ChangeMessageVisibilityBatchResultEntry</code> </code> tag if the message succeeds or a <code> <code>BatchResultErrorEntry</code> </code> tag if the message fails.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeMessageVisibilityBatchOutput {
    /// <p>A list of <code> <code>ChangeMessageVisibilityBatchResultEntry</code> </code> items.</p>
    pub successful:
        std::option::Option<std::vec::Vec<crate::model::ChangeMessageVisibilityBatchResultEntry>>,
    /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
    pub failed: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
}
impl ChangeMessageVisibilityBatchOutput {
    /// <p>A list of <code> <code>ChangeMessageVisibilityBatchResultEntry</code> </code> items.</p>
    pub fn successful(
        &self,
    ) -> std::option::Option<&[crate::model::ChangeMessageVisibilityBatchResultEntry]> {
        self.successful.as_deref()
    }
    /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
    pub fn failed(&self) -> std::option::Option<&[crate::model::BatchResultErrorEntry]> {
        self.failed.as_deref()
    }
}
impl std::fmt::Debug for ChangeMessageVisibilityBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeMessageVisibilityBatchOutput");
        formatter.field("successful", &self.successful);
        formatter.field("failed", &self.failed);
        formatter.finish()
    }
}
/// See [`ChangeMessageVisibilityBatchOutput`](crate::output::ChangeMessageVisibilityBatchOutput)
pub mod change_message_visibility_batch_output {
    /// A builder for [`ChangeMessageVisibilityBatchOutput`](crate::output::ChangeMessageVisibilityBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful: std::option::Option<
            std::vec::Vec<crate::model::ChangeMessageVisibilityBatchResultEntry>,
        >,
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
    }
    impl Builder {
        /// Appends an item to `successful`.
        ///
        /// To override the contents of this collection use [`set_successful`](Self::set_successful).
        ///
        /// <p>A list of <code> <code>ChangeMessageVisibilityBatchResultEntry</code> </code> items.</p>
        pub fn successful(
            mut self,
            input: crate::model::ChangeMessageVisibilityBatchResultEntry,
        ) -> Self {
            let mut v = self.successful.unwrap_or_default();
            v.push(input);
            self.successful = Some(v);
            self
        }
        /// <p>A list of <code> <code>ChangeMessageVisibilityBatchResultEntry</code> </code> items.</p>
        pub fn set_successful(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ChangeMessageVisibilityBatchResultEntry>,
            >,
        ) -> Self {
            self.successful = input;
            self
        }
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
        pub fn failed(mut self, input: crate::model::BatchResultErrorEntry) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input);
            self.failed = Some(v);
            self
        }
        /// <p>A list of <code> <code>BatchResultErrorEntry</code> </code> items.</p>
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchResultErrorEntry>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeMessageVisibilityBatchOutput`](crate::output::ChangeMessageVisibilityBatchOutput)
        pub fn build(self) -> crate::output::ChangeMessageVisibilityBatchOutput {
            crate::output::ChangeMessageVisibilityBatchOutput {
                successful: self.successful,
                failed: self.failed,
            }
        }
    }
}
impl ChangeMessageVisibilityBatchOutput {
    /// Creates a new builder-style object to manufacture [`ChangeMessageVisibilityBatchOutput`](crate::output::ChangeMessageVisibilityBatchOutput)
    pub fn builder() -> crate::output::change_message_visibility_batch_output::Builder {
        crate::output::change_message_visibility_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeMessageVisibilityOutput {}
impl std::fmt::Debug for ChangeMessageVisibilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeMessageVisibilityOutput");
        formatter.finish()
    }
}
/// See [`ChangeMessageVisibilityOutput`](crate::output::ChangeMessageVisibilityOutput)
pub mod change_message_visibility_output {
    /// A builder for [`ChangeMessageVisibilityOutput`](crate::output::ChangeMessageVisibilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ChangeMessageVisibilityOutput`](crate::output::ChangeMessageVisibilityOutput)
        pub fn build(self) -> crate::output::ChangeMessageVisibilityOutput {
            crate::output::ChangeMessageVisibilityOutput {}
        }
    }
}
impl ChangeMessageVisibilityOutput {
    /// Creates a new builder-style object to manufacture [`ChangeMessageVisibilityOutput`](crate::output::ChangeMessageVisibilityOutput)
    pub fn builder() -> crate::output::change_message_visibility_output::Builder {
        crate::output::change_message_visibility_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddPermissionOutput {}
impl std::fmt::Debug for AddPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddPermissionOutput");
        formatter.finish()
    }
}
/// See [`AddPermissionOutput`](crate::output::AddPermissionOutput)
pub mod add_permission_output {
    /// A builder for [`AddPermissionOutput`](crate::output::AddPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddPermissionOutput`](crate::output::AddPermissionOutput)
        pub fn build(self) -> crate::output::AddPermissionOutput {
            crate::output::AddPermissionOutput {}
        }
    }
}
impl AddPermissionOutput {
    /// Creates a new builder-style object to manufacture [`AddPermissionOutput`](crate::output::AddPermissionOutput)
    pub fn builder() -> crate::output::add_permission_output::Builder {
        crate::output::add_permission_output::Builder::default()
    }
}
