// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueueAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    ApproximateNumberOfMessages,
    #[allow(missing_docs)] // documentation missing in model
    ApproximateNumberOfMessagesDelayed,
    #[allow(missing_docs)] // documentation missing in model
    ApproximateNumberOfMessagesNotVisible,
    #[allow(missing_docs)] // documentation missing in model
    ContentBasedDeduplication,
    #[allow(missing_docs)] // documentation missing in model
    CreatedTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    DeduplicationScope,
    #[allow(missing_docs)] // documentation missing in model
    DelaySeconds,
    #[allow(missing_docs)] // documentation missing in model
    FifoQueue,
    #[allow(missing_docs)] // documentation missing in model
    FifoThroughputLimit,
    #[allow(missing_docs)] // documentation missing in model
    KmsDataKeyReusePeriodSeconds,
    #[allow(missing_docs)] // documentation missing in model
    KmsMasterKeyId,
    #[allow(missing_docs)] // documentation missing in model
    LastModifiedTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    MaximumMessageSize,
    #[allow(missing_docs)] // documentation missing in model
    MessageRetentionPeriod,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    #[allow(missing_docs)] // documentation missing in model
    QueueArn,
    #[allow(missing_docs)] // documentation missing in model
    ReceiveMessageWaitTimeSeconds,
    #[allow(missing_docs)] // documentation missing in model
    RedriveAllowPolicy,
    #[allow(missing_docs)] // documentation missing in model
    RedrivePolicy,
    #[allow(missing_docs)] // documentation missing in model
    SqsManagedSseEnabled,
    #[allow(missing_docs)] // documentation missing in model
    VisibilityTimeout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueueAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "All" => QueueAttributeName::All,
            "ApproximateNumberOfMessages" => QueueAttributeName::ApproximateNumberOfMessages,
            "ApproximateNumberOfMessagesDelayed" => {
                QueueAttributeName::ApproximateNumberOfMessagesDelayed
            }
            "ApproximateNumberOfMessagesNotVisible" => {
                QueueAttributeName::ApproximateNumberOfMessagesNotVisible
            }
            "ContentBasedDeduplication" => QueueAttributeName::ContentBasedDeduplication,
            "CreatedTimestamp" => QueueAttributeName::CreatedTimestamp,
            "DeduplicationScope" => QueueAttributeName::DeduplicationScope,
            "DelaySeconds" => QueueAttributeName::DelaySeconds,
            "FifoQueue" => QueueAttributeName::FifoQueue,
            "FifoThroughputLimit" => QueueAttributeName::FifoThroughputLimit,
            "KmsDataKeyReusePeriodSeconds" => QueueAttributeName::KmsDataKeyReusePeriodSeconds,
            "KmsMasterKeyId" => QueueAttributeName::KmsMasterKeyId,
            "LastModifiedTimestamp" => QueueAttributeName::LastModifiedTimestamp,
            "MaximumMessageSize" => QueueAttributeName::MaximumMessageSize,
            "MessageRetentionPeriod" => QueueAttributeName::MessageRetentionPeriod,
            "Policy" => QueueAttributeName::Policy,
            "QueueArn" => QueueAttributeName::QueueArn,
            "ReceiveMessageWaitTimeSeconds" => QueueAttributeName::ReceiveMessageWaitTimeSeconds,
            "RedriveAllowPolicy" => QueueAttributeName::RedriveAllowPolicy,
            "RedrivePolicy" => QueueAttributeName::RedrivePolicy,
            "SqsManagedSseEnabled" => QueueAttributeName::SqsManagedSseEnabled,
            "VisibilityTimeout" => QueueAttributeName::VisibilityTimeout,
            other => QueueAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueueAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueueAttributeName::from(s))
    }
}
impl QueueAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueueAttributeName::All => "All",
            QueueAttributeName::ApproximateNumberOfMessages => "ApproximateNumberOfMessages",
            QueueAttributeName::ApproximateNumberOfMessagesDelayed => {
                "ApproximateNumberOfMessagesDelayed"
            }
            QueueAttributeName::ApproximateNumberOfMessagesNotVisible => {
                "ApproximateNumberOfMessagesNotVisible"
            }
            QueueAttributeName::ContentBasedDeduplication => "ContentBasedDeduplication",
            QueueAttributeName::CreatedTimestamp => "CreatedTimestamp",
            QueueAttributeName::DeduplicationScope => "DeduplicationScope",
            QueueAttributeName::DelaySeconds => "DelaySeconds",
            QueueAttributeName::FifoQueue => "FifoQueue",
            QueueAttributeName::FifoThroughputLimit => "FifoThroughputLimit",
            QueueAttributeName::KmsDataKeyReusePeriodSeconds => "KmsDataKeyReusePeriodSeconds",
            QueueAttributeName::KmsMasterKeyId => "KmsMasterKeyId",
            QueueAttributeName::LastModifiedTimestamp => "LastModifiedTimestamp",
            QueueAttributeName::MaximumMessageSize => "MaximumMessageSize",
            QueueAttributeName::MessageRetentionPeriod => "MessageRetentionPeriod",
            QueueAttributeName::Policy => "Policy",
            QueueAttributeName::QueueArn => "QueueArn",
            QueueAttributeName::ReceiveMessageWaitTimeSeconds => "ReceiveMessageWaitTimeSeconds",
            QueueAttributeName::RedriveAllowPolicy => "RedriveAllowPolicy",
            QueueAttributeName::RedrivePolicy => "RedrivePolicy",
            QueueAttributeName::SqsManagedSseEnabled => "SqsManagedSseEnabled",
            QueueAttributeName::VisibilityTimeout => "VisibilityTimeout",
            QueueAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "All",
            "ApproximateNumberOfMessages",
            "ApproximateNumberOfMessagesDelayed",
            "ApproximateNumberOfMessagesNotVisible",
            "ContentBasedDeduplication",
            "CreatedTimestamp",
            "DeduplicationScope",
            "DelaySeconds",
            "FifoQueue",
            "FifoThroughputLimit",
            "KmsDataKeyReusePeriodSeconds",
            "KmsMasterKeyId",
            "LastModifiedTimestamp",
            "MaximumMessageSize",
            "MessageRetentionPeriod",
            "Policy",
            "QueueArn",
            "ReceiveMessageWaitTimeSeconds",
            "RedriveAllowPolicy",
            "RedrivePolicy",
            "SqsManagedSseEnabled",
            "VisibilityTimeout",
        ]
    }
}
impl AsRef<str> for QueueAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Gives a detailed description of the result of an action on each entry in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchResultErrorEntry {
    /// <p>The <code>Id</code> of an entry in a batch request.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
    pub sender_fault: bool,
    /// <p>An error code representing why the action failed on this entry.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A message explaining why the action failed on this entry.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BatchResultErrorEntry {
    /// <p>The <code>Id</code> of an entry in a batch request.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
    pub fn sender_fault(&self) -> bool {
        self.sender_fault
    }
    /// <p>An error code representing why the action failed on this entry.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>A message explaining why the action failed on this entry.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BatchResultErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchResultErrorEntry");
        formatter.field("id", &self.id);
        formatter.field("sender_fault", &self.sender_fault);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
pub mod batch_result_error_entry {
    /// A builder for [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) sender_fault: std::option::Option<bool>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>Id</code> of an entry in a batch request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The <code>Id</code> of an entry in a batch request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
        pub fn sender_fault(mut self, input: bool) -> Self {
            self.sender_fault = Some(input);
            self
        }
        /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
        pub fn set_sender_fault(mut self, input: std::option::Option<bool>) -> Self {
            self.sender_fault = input;
            self
        }
        /// <p>An error code representing why the action failed on this entry.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>An error code representing why the action failed on this entry.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A message explaining why the action failed on this entry.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message explaining why the action failed on this entry.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
        pub fn build(self) -> crate::model::BatchResultErrorEntry {
            crate::model::BatchResultErrorEntry {
                id: self.id,
                sender_fault: self.sender_fault.unwrap_or_default(),
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BatchResultErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
    pub fn builder() -> crate::model::batch_result_error_entry::Builder {
        crate::model::batch_result_error_entry::Builder::default()
    }
}

/// <p>Encloses a <code>MessageId</code> for a successfully-enqueued message in a <code> <code>SendMessageBatch</code>.</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendMessageBatchResultEntry {
    /// <p>An identifier for the message in this batch.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>An identifier for the message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub md5_of_message_body: std::option::Option<std::string::String>,
    /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub md5_of_message_attributes: std::option::Option<std::string::String>,
    /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub md5_of_message_system_attributes: std::option::Option<std::string::String>,
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
    /// <p>The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
    pub sequence_number: std::option::Option<std::string::String>,
}
impl SendMessageBatchResultEntry {
    /// <p>An identifier for the message in this batch.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>An identifier for the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub fn md5_of_message_body(&self) -> std::option::Option<&str> {
        self.md5_of_message_body.as_deref()
    }
    /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub fn md5_of_message_attributes(&self) -> std::option::Option<&str> {
        self.md5_of_message_attributes.as_deref()
    }
    /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub fn md5_of_message_system_attributes(&self) -> std::option::Option<&str> {
        self.md5_of_message_system_attributes.as_deref()
    }
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
    /// <p>The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
    pub fn sequence_number(&self) -> std::option::Option<&str> {
        self.sequence_number.as_deref()
    }
}
impl std::fmt::Debug for SendMessageBatchResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendMessageBatchResultEntry");
        formatter.field("id", &self.id);
        formatter.field("message_id", &self.message_id);
        formatter.field("md5_of_message_body", &self.md5_of_message_body);
        formatter.field("md5_of_message_attributes", &self.md5_of_message_attributes);
        formatter.field(
            "md5_of_message_system_attributes",
            &self.md5_of_message_system_attributes,
        );
        formatter.field("sequence_number", &self.sequence_number);
        formatter.finish()
    }
}
/// See [`SendMessageBatchResultEntry`](crate::model::SendMessageBatchResultEntry)
pub mod send_message_batch_result_entry {
    /// A builder for [`SendMessageBatchResultEntry`](crate::model::SendMessageBatchResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) md5_of_message_body: std::option::Option<std::string::String>,
        pub(crate) md5_of_message_attributes: std::option::Option<std::string::String>,
        pub(crate) md5_of_message_system_attributes: std::option::Option<std::string::String>,
        pub(crate) sequence_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for the message in this batch.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An identifier for the message in this batch.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>An identifier for the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>An identifier for the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn md5_of_message_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_of_message_body = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn set_md5_of_message_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.md5_of_message_body = input;
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn md5_of_message_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_of_message_attributes = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn set_md5_of_message_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.md5_of_message_attributes = input;
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn md5_of_message_system_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.md5_of_message_system_attributes = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn set_md5_of_message_system_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.md5_of_message_system_attributes = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
        /// <p>The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
        pub fn sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.sequence_number = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The large, non-consecutive number that Amazon SQS assigns to each message.</p>
        /// <p>The length of <code>SequenceNumber</code> is 128 bits. As <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sequence_number = input;
            self
        }
        /// Consumes the builder and constructs a [`SendMessageBatchResultEntry`](crate::model::SendMessageBatchResultEntry)
        pub fn build(self) -> crate::model::SendMessageBatchResultEntry {
            crate::model::SendMessageBatchResultEntry {
                id: self.id,
                message_id: self.message_id,
                md5_of_message_body: self.md5_of_message_body,
                md5_of_message_attributes: self.md5_of_message_attributes,
                md5_of_message_system_attributes: self.md5_of_message_system_attributes,
                sequence_number: self.sequence_number,
            }
        }
    }
}
impl SendMessageBatchResultEntry {
    /// Creates a new builder-style object to manufacture [`SendMessageBatchResultEntry`](crate::model::SendMessageBatchResultEntry)
    pub fn builder() -> crate::model::send_message_batch_result_entry::Builder {
        crate::model::send_message_batch_result_entry::Builder::default()
    }
}

/// <p>Contains the details of a single Amazon SQS message along with an <code>Id</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendMessageBatchRequestEntry {
    /// <p>An identifier for a message in this batch used to communicate the result.</p> <note>
    /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
    /// </note>
    pub id: std::option::Option<std::string::String>,
    /// <p>The body of the message.</p>
    pub message_body: std::option::Option<std::string::String>,
    /// <p>The length of time, in seconds, for which a specific message is delayed. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the delay period is finished. If you don't specify a value, the default value for the queue is applied. </p> <note>
    /// <p>When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this parameter only on a queue level.</p>
    /// </note>
    pub delay_seconds: i32,
    /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub message_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    >,
    /// <p>The message system attribute to send Each message system attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>.</p> <important>
    /// <ul>
    /// <li> <p>Currently, the only supported message system attribute is <code>AWSTraceHeader</code>. Its type must be <code>String</code> and its value must be a correctly formatted X-Ray trace header string.</p> </li>
    /// <li> <p>The size of a message system attribute doesn't count towards the total size of a message.</p> </li>
    /// </ul>
    /// </important>
    pub message_system_attributes: std::option::Option<
        std::collections::HashMap<
            crate::model::MessageSystemAttributeNameForSends,
            crate::model::MessageSystemAttributeValue,
        >,
    >,
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"> Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <ul>
    /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>,</p>
    /// <ul>
    /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
    /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message). </p> </li>
    /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
    /// <li> <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p> </li>
    /// </ul> </li>
    /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
    /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
    /// </ul> <note>
    /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
    /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate messages.</p>
    /// <p>Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.</p>
    /// </note>
    /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (<code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).</p>
    /// <p>For best practices of using <code>MessageDeduplicationId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the MessageDeduplicationId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub message_deduplication_id: std::option::Option<std::string::String>,
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single queue, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the queue, but the session data of each user is processed in a FIFO fashion.</p>
    /// <ul>
    /// <li> <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails.</p> </li>
    /// <li> <p> <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a <code>MessageGroupId</code>.</p> </li>
    /// </ul>
    /// <p>The length of <code>MessageGroupId</code> is 128 characters. Valid values: alphanumeric characters and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
    /// <p>For best practices of using <code>MessageGroupId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html">Using the MessageGroupId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p> <important>
    /// <p> <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.</p>
    /// </important>
    pub message_group_id: std::option::Option<std::string::String>,
}
impl SendMessageBatchRequestEntry {
    /// <p>An identifier for a message in this batch used to communicate the result.</p> <note>
    /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
    /// </note>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The body of the message.</p>
    pub fn message_body(&self) -> std::option::Option<&str> {
        self.message_body.as_deref()
    }
    /// <p>The length of time, in seconds, for which a specific message is delayed. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the delay period is finished. If you don't specify a value, the default value for the queue is applied. </p> <note>
    /// <p>When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this parameter only on a queue level.</p>
    /// </note>
    pub fn delay_seconds(&self) -> i32 {
        self.delay_seconds
    }
    /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub fn message_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    > {
        self.message_attributes.as_ref()
    }
    /// <p>The message system attribute to send Each message system attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>.</p> <important>
    /// <ul>
    /// <li> <p>Currently, the only supported message system attribute is <code>AWSTraceHeader</code>. Its type must be <code>String</code> and its value must be a correctly formatted X-Ray trace header string.</p> </li>
    /// <li> <p>The size of a message system attribute doesn't count towards the total size of a message.</p> </li>
    /// </ul>
    /// </important>
    pub fn message_system_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::MessageSystemAttributeNameForSends,
            crate::model::MessageSystemAttributeValue,
        >,
    > {
        self.message_system_attributes.as_ref()
    }
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"> Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <ul>
    /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>,</p>
    /// <ul>
    /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
    /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message). </p> </li>
    /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
    /// <li> <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p> </li>
    /// </ul> </li>
    /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
    /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
    /// </ul> <note>
    /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
    /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate messages.</p>
    /// <p>Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.</p>
    /// </note>
    /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (<code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).</p>
    /// <p>For best practices of using <code>MessageDeduplicationId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the MessageDeduplicationId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub fn message_deduplication_id(&self) -> std::option::Option<&str> {
        self.message_deduplication_id.as_deref()
    }
    /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
    /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single queue, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the queue, but the session data of each user is processed in a FIFO fashion.</p>
    /// <ul>
    /// <li> <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails.</p> </li>
    /// <li> <p> <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a <code>MessageGroupId</code>.</p> </li>
    /// </ul>
    /// <p>The length of <code>MessageGroupId</code> is 128 characters. Valid values: alphanumeric characters and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
    /// <p>For best practices of using <code>MessageGroupId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html">Using the MessageGroupId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p> <important>
    /// <p> <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.</p>
    /// </important>
    pub fn message_group_id(&self) -> std::option::Option<&str> {
        self.message_group_id.as_deref()
    }
}
impl std::fmt::Debug for SendMessageBatchRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendMessageBatchRequestEntry");
        formatter.field("id", &self.id);
        formatter.field("message_body", &self.message_body);
        formatter.field("delay_seconds", &self.delay_seconds);
        formatter.field("message_attributes", &self.message_attributes);
        formatter.field("message_system_attributes", &self.message_system_attributes);
        formatter.field("message_deduplication_id", &self.message_deduplication_id);
        formatter.field("message_group_id", &self.message_group_id);
        formatter.finish()
    }
}
/// See [`SendMessageBatchRequestEntry`](crate::model::SendMessageBatchRequestEntry)
pub mod send_message_batch_request_entry {
    /// A builder for [`SendMessageBatchRequestEntry`](crate::model::SendMessageBatchRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) message_body: std::option::Option<std::string::String>,
        pub(crate) delay_seconds: std::option::Option<i32>,
        pub(crate) message_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
        >,
        pub(crate) message_system_attributes: std::option::Option<
            std::collections::HashMap<
                crate::model::MessageSystemAttributeNameForSends,
                crate::model::MessageSystemAttributeValue,
            >,
        >,
        pub(crate) message_deduplication_id: std::option::Option<std::string::String>,
        pub(crate) message_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for a message in this batch used to communicate the result.</p> <note>
        /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
        /// </note>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An identifier for a message in this batch used to communicate the result.</p> <note>
        /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
        /// </note>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The body of the message.</p>
        pub fn message_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_body = Some(input.into());
            self
        }
        /// <p>The body of the message.</p>
        pub fn set_message_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_body = input;
            self
        }
        /// <p>The length of time, in seconds, for which a specific message is delayed. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the delay period is finished. If you don't specify a value, the default value for the queue is applied. </p> <note>
        /// <p>When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this parameter only on a queue level.</p>
        /// </note>
        pub fn delay_seconds(mut self, input: i32) -> Self {
            self.delay_seconds = Some(input);
            self
        }
        /// <p>The length of time, in seconds, for which a specific message is delayed. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the delay period is finished. If you don't specify a value, the default value for the queue is applied. </p> <note>
        /// <p>When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this parameter only on a queue level.</p>
        /// </note>
        pub fn set_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.delay_seconds = input;
            self
        }
        /// Adds a key-value pair to `message_attributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MessageAttributeValue,
        ) -> Self {
            let mut hash_map = self.message_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.message_attributes = Some(hash_map);
            self
        }
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.message_attributes = input;
            self
        }
        /// Adds a key-value pair to `message_system_attributes`.
        ///
        /// To override the contents of this collection use [`set_message_system_attributes`](Self::set_message_system_attributes).
        ///
        /// <p>The message system attribute to send Each message system attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>.</p> <important>
        /// <ul>
        /// <li> <p>Currently, the only supported message system attribute is <code>AWSTraceHeader</code>. Its type must be <code>String</code> and its value must be a correctly formatted X-Ray trace header string.</p> </li>
        /// <li> <p>The size of a message system attribute doesn't count towards the total size of a message.</p> </li>
        /// </ul>
        /// </important>
        pub fn message_system_attributes(
            mut self,
            k: crate::model::MessageSystemAttributeNameForSends,
            v: crate::model::MessageSystemAttributeValue,
        ) -> Self {
            let mut hash_map = self.message_system_attributes.unwrap_or_default();
            hash_map.insert(k, v);
            self.message_system_attributes = Some(hash_map);
            self
        }
        /// <p>The message system attribute to send Each message system attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>.</p> <important>
        /// <ul>
        /// <li> <p>Currently, the only supported message system attribute is <code>AWSTraceHeader</code>. Its type must be <code>String</code> and its value must be a correctly formatted X-Ray trace header string.</p> </li>
        /// <li> <p>The size of a message system attribute doesn't count towards the total size of a message.</p> </li>
        /// </ul>
        /// </important>
        pub fn set_message_system_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::MessageSystemAttributeNameForSends,
                    crate::model::MessageSystemAttributeValue,
                >,
            >,
        ) -> Self {
            self.message_system_attributes = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"> Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <ul>
        /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>,</p>
        /// <ul>
        /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
        /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message). </p> </li>
        /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
        /// <li> <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p> </li>
        /// </ul> </li>
        /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
        /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
        /// </ul> <note>
        /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
        /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate messages.</p>
        /// <p>Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.</p>
        /// </note>
        /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (<code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).</p>
        /// <p>For best practices of using <code>MessageDeduplicationId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the MessageDeduplicationId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn message_deduplication_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_deduplication_id = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html"> Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <ul>
        /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>,</p>
        /// <ul>
        /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
        /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue, Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message). </p> </li>
        /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
        /// <li> <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p> </li>
        /// </ul> </li>
        /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
        /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
        /// </ul> <note>
        /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
        /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate messages.</p>
        /// <p>Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.</p>
        /// </note>
        /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and punctuation (<code>!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~</code>).</p>
        /// <p>For best practices of using <code>MessageDeduplicationId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the MessageDeduplicationId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_message_deduplication_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_deduplication_id = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single queue, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the queue, but the session data of each user is processed in a FIFO fashion.</p>
        /// <ul>
        /// <li> <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails.</p> </li>
        /// <li> <p> <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a <code>MessageGroupId</code>.</p> </li>
        /// </ul>
        /// <p>The length of <code>MessageGroupId</code> is 128 characters. Valid values: alphanumeric characters and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
        /// <p>For best practices of using <code>MessageGroupId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html">Using the MessageGroupId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p> <important>
        /// <p> <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.</p>
        /// </important>
        pub fn message_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_group_id = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single queue, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the queue, but the session data of each user is processed in a FIFO fashion.</p>
        /// <ul>
        /// <li> <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails.</p> </li>
        /// <li> <p> <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't specify a <code>MessageGroupId</code>.</p> </li>
        /// </ul>
        /// <p>The length of <code>MessageGroupId</code> is 128 characters. Valid values: alphanumeric characters and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
        /// <p>For best practices of using <code>MessageGroupId</code>, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html">Using the MessageGroupId Property</a> in the <i>Amazon SQS Developer Guide</i>.</p> <important>
        /// <p> <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.</p>
        /// </important>
        pub fn set_message_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SendMessageBatchRequestEntry`](crate::model::SendMessageBatchRequestEntry)
        pub fn build(self) -> crate::model::SendMessageBatchRequestEntry {
            crate::model::SendMessageBatchRequestEntry {
                id: self.id,
                message_body: self.message_body,
                delay_seconds: self.delay_seconds.unwrap_or_default(),
                message_attributes: self.message_attributes,
                message_system_attributes: self.message_system_attributes,
                message_deduplication_id: self.message_deduplication_id,
                message_group_id: self.message_group_id,
            }
        }
    }
}
impl SendMessageBatchRequestEntry {
    /// Creates a new builder-style object to manufacture [`SendMessageBatchRequestEntry`](crate::model::SendMessageBatchRequestEntry)
    pub fn builder() -> crate::model::send_message_batch_request_entry::Builder {
        crate::model::send_message_batch_request_entry::Builder::default()
    }
}

/// <p>The user-specified message system attribute value. For string data types, the <code>Value</code> attribute has the same restrictions on the content as the message body. For more information, see <code> <code>SendMessage</code>.</code> </p>
/// <p> <code>Name</code>, <code>type</code>, <code>value</code> and the message body must not be empty or null.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageSystemAttributeValue {
    /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
    pub binary_value: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Not implemented. Reserved for future use.</p>
    pub string_list_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Not implemented. Reserved for future use.</p>
    pub binary_list_values: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
    /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
    /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub data_type: std::option::Option<std::string::String>,
}
impl MessageSystemAttributeValue {
    /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
    pub fn binary_value(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.binary_value.as_ref()
    }
    /// <p>Not implemented. Reserved for future use.</p>
    pub fn string_list_values(&self) -> std::option::Option<&[std::string::String]> {
        self.string_list_values.as_deref()
    }
    /// <p>Not implemented. Reserved for future use.</p>
    pub fn binary_list_values(&self) -> std::option::Option<&[aws_smithy_types::Blob]> {
        self.binary_list_values.as_deref()
    }
    /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
    /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
}
impl std::fmt::Debug for MessageSystemAttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageSystemAttributeValue");
        formatter.field("string_value", &self.string_value);
        formatter.field("binary_value", &self.binary_value);
        formatter.field("string_list_values", &self.string_list_values);
        formatter.field("binary_list_values", &self.binary_list_values);
        formatter.field("data_type", &self.data_type);
        formatter.finish()
    }
}
/// See [`MessageSystemAttributeValue`](crate::model::MessageSystemAttributeValue)
pub mod message_system_attribute_value {
    /// A builder for [`MessageSystemAttributeValue`](crate::model::MessageSystemAttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) binary_value: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) string_list_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) binary_list_values: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        pub(crate) data_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
        pub fn binary_value(mut self, input: aws_smithy_types::Blob) -> Self {
            self.binary_value = Some(input);
            self
        }
        /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
        pub fn set_binary_value(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.binary_value = input;
            self
        }
        /// Appends an item to `string_list_values`.
        ///
        /// To override the contents of this collection use [`set_string_list_values`](Self::set_string_list_values).
        ///
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn string_list_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_list_values.unwrap_or_default();
            v.push(input.into());
            self.string_list_values = Some(v);
            self
        }
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn set_string_list_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_list_values = input;
            self
        }
        /// Appends an item to `binary_list_values`.
        ///
        /// To override the contents of this collection use [`set_binary_list_values`](Self::set_binary_list_values).
        ///
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn binary_list_values(mut self, input: aws_smithy_types::Blob) -> Self {
            let mut v = self.binary_list_values.unwrap_or_default();
            v.push(input);
            self.binary_list_values = Some(v);
            self
        }
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn set_binary_list_values(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.binary_list_values = input;
            self
        }
        /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
        /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
        /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageSystemAttributeValue`](crate::model::MessageSystemAttributeValue)
        pub fn build(self) -> crate::model::MessageSystemAttributeValue {
            crate::model::MessageSystemAttributeValue {
                string_value: self.string_value,
                binary_value: self.binary_value,
                string_list_values: self.string_list_values,
                binary_list_values: self.binary_list_values,
                data_type: self.data_type,
            }
        }
    }
}
impl MessageSystemAttributeValue {
    /// Creates a new builder-style object to manufacture [`MessageSystemAttributeValue`](crate::model::MessageSystemAttributeValue)
    pub fn builder() -> crate::model::message_system_attribute_value::Builder {
        crate::model::message_system_attribute_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageSystemAttributeNameForSends {
    #[allow(missing_docs)] // documentation missing in model
    AwsTraceHeader,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageSystemAttributeNameForSends {
    fn from(s: &str) -> Self {
        match s {
            "AWSTraceHeader" => MessageSystemAttributeNameForSends::AwsTraceHeader,
            other => MessageSystemAttributeNameForSends::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageSystemAttributeNameForSends {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageSystemAttributeNameForSends::from(s))
    }
}
impl MessageSystemAttributeNameForSends {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageSystemAttributeNameForSends::AwsTraceHeader => "AWSTraceHeader",
            MessageSystemAttributeNameForSends::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWSTraceHeader"]
    }
}
impl AsRef<str> for MessageSystemAttributeNameForSends {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The user-specified message attribute value. For string data types, the <code>Value</code> attribute has the same restrictions on the content as the message body. For more information, see <code> <code>SendMessage</code>.</code> </p>
/// <p> <code>Name</code>, <code>type</code>, <code>value</code> and the message body must not be empty or null. All parts of the message attribute, including <code>Name</code>, <code>Type</code>, and <code>Value</code>, are part of the message size restriction (256 KB or 262,144 bytes).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageAttributeValue {
    /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
    pub binary_value: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Not implemented. Reserved for future use.</p>
    pub string_list_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Not implemented. Reserved for future use.</p>
    pub binary_list_values: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
    /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
    /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub data_type: std::option::Option<std::string::String>,
}
impl MessageAttributeValue {
    /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
    pub fn binary_value(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.binary_value.as_ref()
    }
    /// <p>Not implemented. Reserved for future use.</p>
    pub fn string_list_values(&self) -> std::option::Option<&[std::string::String]> {
        self.string_list_values.as_deref()
    }
    /// <p>Not implemented. Reserved for future use.</p>
    pub fn binary_list_values(&self) -> std::option::Option<&[aws_smithy_types::Blob]> {
        self.binary_list_values.as_deref()
    }
    /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
    /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
}
impl std::fmt::Debug for MessageAttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageAttributeValue");
        formatter.field("string_value", &self.string_value);
        formatter.field("binary_value", &self.binary_value);
        formatter.field("string_list_values", &self.string_list_values);
        formatter.field("binary_list_values", &self.binary_list_values);
        formatter.field("data_type", &self.data_type);
        formatter.finish()
    }
}
/// See [`MessageAttributeValue`](crate::model::MessageAttributeValue)
pub mod message_attribute_value {
    /// A builder for [`MessageAttributeValue`](crate::model::MessageAttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) binary_value: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) string_list_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) binary_list_values: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        pub(crate) data_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>Strings are Unicode with UTF-8 binary encoding. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
        pub fn binary_value(mut self, input: aws_smithy_types::Blob) -> Self {
            self.binary_value = Some(input);
            self
        }
        /// <p>Binary type attributes can store any binary data, such as compressed data, encrypted data, or images.</p>
        pub fn set_binary_value(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.binary_value = input;
            self
        }
        /// Appends an item to `string_list_values`.
        ///
        /// To override the contents of this collection use [`set_string_list_values`](Self::set_string_list_values).
        ///
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn string_list_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_list_values.unwrap_or_default();
            v.push(input.into());
            self.string_list_values = Some(v);
            self
        }
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn set_string_list_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_list_values = input;
            self
        }
        /// Appends an item to `binary_list_values`.
        ///
        /// To override the contents of this collection use [`set_binary_list_values`](Self::set_binary_list_values).
        ///
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn binary_list_values(mut self, input: aws_smithy_types::Blob) -> Self {
            let mut v = self.binary_list_values.unwrap_or_default();
            v.push(input);
            self.binary_list_values = Some(v);
            self
        }
        /// <p>Not implemented. Reserved for future use.</p>
        pub fn set_binary_list_values(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Blob>>,
        ) -> Self {
            self.binary_list_values = input;
            self
        }
        /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
        /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Amazon SQS supports the following logical data types: <code>String</code>, <code>Number</code>, and <code>Binary</code>. For the <code>Number</code> data type, you must use <code>StringValue</code>.</p>
        /// <p>You can also append custom labels. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS Message Attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageAttributeValue`](crate::model::MessageAttributeValue)
        pub fn build(self) -> crate::model::MessageAttributeValue {
            crate::model::MessageAttributeValue {
                string_value: self.string_value,
                binary_value: self.binary_value,
                string_list_values: self.string_list_values,
                binary_list_values: self.binary_list_values,
                data_type: self.data_type,
            }
        }
    }
}
impl MessageAttributeValue {
    /// Creates a new builder-style object to manufacture [`MessageAttributeValue`](crate::model::MessageAttributeValue)
    pub fn builder() -> crate::model::message_attribute_value::Builder {
        crate::model::message_attribute_value::Builder::default()
    }
}

/// <p>An Amazon SQS message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>A unique identifier for the message. A <code>MessageId</code>is considered unique across all Amazon Web Services accounts for an extended period of time.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>An identifier associated with the act of receiving the message. A new receipt handle is returned every time you receive a message. When deleting a message, you provide the last received receipt handle to delete the message.</p>
    pub receipt_handle: std::option::Option<std::string::String>,
    /// <p>An MD5 digest of the non-URL-encoded message body string.</p>
    pub md5_of_body: std::option::Option<std::string::String>,
    /// <p>The message's contents (not URL-encoded).</p>
    pub body: std::option::Option<std::string::String>,
    /// <p>A map of the attributes requested in <code> <code>ReceiveMessage</code> </code> to their respective values. Supported attributes:</p>
    /// <ul>
    /// <li> <p> <code>ApproximateReceiveCount</code> </p> </li>
    /// <li> <p> <code>ApproximateFirstReceiveTimestamp</code> </p> </li>
    /// <li> <p> <code>MessageDeduplicationId</code> </p> </li>
    /// <li> <p> <code>MessageGroupId</code> </p> </li>
    /// <li> <p> <code>SenderId</code> </p> </li>
    /// <li> <p> <code>SentTimestamp</code> </p> </li>
    /// <li> <p> <code>SequenceNumber</code> </p> </li>
    /// </ul>
    /// <p> <code>ApproximateFirstReceiveTimestamp</code> and <code>SentTimestamp</code> are each returned as an integer representing the <a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<crate::model::MessageSystemAttributeName, std::string::String>,
    >,
    /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub md5_of_message_attributes: std::option::Option<std::string::String>,
    /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub message_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    >,
}
impl Message {
    /// <p>A unique identifier for the message. A <code>MessageId</code>is considered unique across all Amazon Web Services accounts for an extended period of time.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>An identifier associated with the act of receiving the message. A new receipt handle is returned every time you receive a message. When deleting a message, you provide the last received receipt handle to delete the message.</p>
    pub fn receipt_handle(&self) -> std::option::Option<&str> {
        self.receipt_handle.as_deref()
    }
    /// <p>An MD5 digest of the non-URL-encoded message body string.</p>
    pub fn md5_of_body(&self) -> std::option::Option<&str> {
        self.md5_of_body.as_deref()
    }
    /// <p>The message's contents (not URL-encoded).</p>
    pub fn body(&self) -> std::option::Option<&str> {
        self.body.as_deref()
    }
    /// <p>A map of the attributes requested in <code> <code>ReceiveMessage</code> </code> to their respective values. Supported attributes:</p>
    /// <ul>
    /// <li> <p> <code>ApproximateReceiveCount</code> </p> </li>
    /// <li> <p> <code>ApproximateFirstReceiveTimestamp</code> </p> </li>
    /// <li> <p> <code>MessageDeduplicationId</code> </p> </li>
    /// <li> <p> <code>MessageGroupId</code> </p> </li>
    /// <li> <p> <code>SenderId</code> </p> </li>
    /// <li> <p> <code>SentTimestamp</code> </p> </li>
    /// <li> <p> <code>SequenceNumber</code> </p> </li>
    /// </ul>
    /// <p> <code>ApproximateFirstReceiveTimestamp</code> and <code>SentTimestamp</code> are each returned as an integer representing the <a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::MessageSystemAttributeName, std::string::String>,
    > {
        self.attributes.as_ref()
    }
    /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    pub fn md5_of_message_attributes(&self) -> std::option::Option<&str> {
        self.md5_of_message_attributes.as_deref()
    }
    /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    pub fn message_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    > {
        self.message_attributes.as_ref()
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("message_id", &self.message_id);
        formatter.field("receipt_handle", &self.receipt_handle);
        formatter.field("md5_of_body", &self.md5_of_body);
        formatter.field("body", &self.body);
        formatter.field("attributes", &self.attributes);
        formatter.field("md5_of_message_attributes", &self.md5_of_message_attributes);
        formatter.field("message_attributes", &self.message_attributes);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) receipt_handle: std::option::Option<std::string::String>,
        pub(crate) md5_of_body: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<
                crate::model::MessageSystemAttributeName,
                std::string::String,
            >,
        >,
        pub(crate) md5_of_message_attributes: std::option::Option<std::string::String>,
        pub(crate) message_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
        >,
    }
    impl Builder {
        /// <p>A unique identifier for the message. A <code>MessageId</code>is considered unique across all Amazon Web Services accounts for an extended period of time.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the message. A <code>MessageId</code>is considered unique across all Amazon Web Services accounts for an extended period of time.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>An identifier associated with the act of receiving the message. A new receipt handle is returned every time you receive a message. When deleting a message, you provide the last received receipt handle to delete the message.</p>
        pub fn receipt_handle(mut self, input: impl Into<std::string::String>) -> Self {
            self.receipt_handle = Some(input.into());
            self
        }
        /// <p>An identifier associated with the act of receiving the message. A new receipt handle is returned every time you receive a message. When deleting a message, you provide the last received receipt handle to delete the message.</p>
        pub fn set_receipt_handle(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.receipt_handle = input;
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message body string.</p>
        pub fn md5_of_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_of_body = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message body string.</p>
        pub fn set_md5_of_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.md5_of_body = input;
            self
        }
        /// <p>The message's contents (not URL-encoded).</p>
        pub fn body(mut self, input: impl Into<std::string::String>) -> Self {
            self.body = Some(input.into());
            self
        }
        /// <p>The message's contents (not URL-encoded).</p>
        pub fn set_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.body = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of the attributes requested in <code> <code>ReceiveMessage</code> </code> to their respective values. Supported attributes:</p>
        /// <ul>
        /// <li> <p> <code>ApproximateReceiveCount</code> </p> </li>
        /// <li> <p> <code>ApproximateFirstReceiveTimestamp</code> </p> </li>
        /// <li> <p> <code>MessageDeduplicationId</code> </p> </li>
        /// <li> <p> <code>MessageGroupId</code> </p> </li>
        /// <li> <p> <code>SenderId</code> </p> </li>
        /// <li> <p> <code>SentTimestamp</code> </p> </li>
        /// <li> <p> <code>SequenceNumber</code> </p> </li>
        /// </ul>
        /// <p> <code>ApproximateFirstReceiveTimestamp</code> and <code>SentTimestamp</code> are each returned as an integer representing the <a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds.</p>
        pub fn attributes(
            mut self,
            k: crate::model::MessageSystemAttributeName,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k, v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of the attributes requested in <code> <code>ReceiveMessage</code> </code> to their respective values. Supported attributes:</p>
        /// <ul>
        /// <li> <p> <code>ApproximateReceiveCount</code> </p> </li>
        /// <li> <p> <code>ApproximateFirstReceiveTimestamp</code> </p> </li>
        /// <li> <p> <code>MessageDeduplicationId</code> </p> </li>
        /// <li> <p> <code>MessageGroupId</code> </p> </li>
        /// <li> <p> <code>SenderId</code> </p> </li>
        /// <li> <p> <code>SentTimestamp</code> </p> </li>
        /// <li> <p> <code>SequenceNumber</code> </p> </li>
        /// </ul>
        /// <p> <code>ApproximateFirstReceiveTimestamp</code> and <code>SentTimestamp</code> are each returned as an integer representing the <a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::MessageSystemAttributeName,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn md5_of_message_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5_of_message_attributes = Some(input.into());
            self
        }
        /// <p>An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
        pub fn set_md5_of_message_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.md5_of_message_attributes = input;
            self
        }
        /// Adds a key-value pair to `message_attributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MessageAttributeValue,
        ) -> Self {
            let mut hash_map = self.message_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.message_attributes = Some(hash_map);
            self
        }
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.message_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                message_id: self.message_id,
                receipt_handle: self.receipt_handle,
                md5_of_body: self.md5_of_body,
                body: self.body,
                attributes: self.attributes,
                md5_of_message_attributes: self.md5_of_message_attributes,
                message_attributes: self.message_attributes,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageSystemAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    AwsTraceHeader,
    #[allow(missing_docs)] // documentation missing in model
    ApproximateFirstReceiveTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    ApproximateReceiveCount,
    #[allow(missing_docs)] // documentation missing in model
    MessageDeduplicationId,
    #[allow(missing_docs)] // documentation missing in model
    MessageGroupId,
    #[allow(missing_docs)] // documentation missing in model
    SenderId,
    #[allow(missing_docs)] // documentation missing in model
    SentTimestamp,
    #[allow(missing_docs)] // documentation missing in model
    SequenceNumber,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageSystemAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "AWSTraceHeader" => MessageSystemAttributeName::AwsTraceHeader,
            "ApproximateFirstReceiveTimestamp" => {
                MessageSystemAttributeName::ApproximateFirstReceiveTimestamp
            }
            "ApproximateReceiveCount" => MessageSystemAttributeName::ApproximateReceiveCount,
            "MessageDeduplicationId" => MessageSystemAttributeName::MessageDeduplicationId,
            "MessageGroupId" => MessageSystemAttributeName::MessageGroupId,
            "SenderId" => MessageSystemAttributeName::SenderId,
            "SentTimestamp" => MessageSystemAttributeName::SentTimestamp,
            "SequenceNumber" => MessageSystemAttributeName::SequenceNumber,
            other => MessageSystemAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageSystemAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageSystemAttributeName::from(s))
    }
}
impl MessageSystemAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageSystemAttributeName::AwsTraceHeader => "AWSTraceHeader",
            MessageSystemAttributeName::ApproximateFirstReceiveTimestamp => {
                "ApproximateFirstReceiveTimestamp"
            }
            MessageSystemAttributeName::ApproximateReceiveCount => "ApproximateReceiveCount",
            MessageSystemAttributeName::MessageDeduplicationId => "MessageDeduplicationId",
            MessageSystemAttributeName::MessageGroupId => "MessageGroupId",
            MessageSystemAttributeName::SenderId => "SenderId",
            MessageSystemAttributeName::SentTimestamp => "SentTimestamp",
            MessageSystemAttributeName::SequenceNumber => "SequenceNumber",
            MessageSystemAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWSTraceHeader",
            "ApproximateFirstReceiveTimestamp",
            "ApproximateReceiveCount",
            "MessageDeduplicationId",
            "MessageGroupId",
            "SenderId",
            "SentTimestamp",
            "SequenceNumber",
        ]
    }
}
impl AsRef<str> for MessageSystemAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Encloses the <code>Id</code> of an entry in <code> <code>DeleteMessageBatch</code>.</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMessageBatchResultEntry {
    /// <p>Represents a successfully deleted message.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteMessageBatchResultEntry {
    /// <p>Represents a successfully deleted message.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMessageBatchResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMessageBatchResultEntry");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`DeleteMessageBatchResultEntry`](crate::model::DeleteMessageBatchResultEntry)
pub mod delete_message_batch_result_entry {
    /// A builder for [`DeleteMessageBatchResultEntry`](crate::model::DeleteMessageBatchResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents a successfully deleted message.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Represents a successfully deleted message.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMessageBatchResultEntry`](crate::model::DeleteMessageBatchResultEntry)
        pub fn build(self) -> crate::model::DeleteMessageBatchResultEntry {
            crate::model::DeleteMessageBatchResultEntry { id: self.id }
        }
    }
}
impl DeleteMessageBatchResultEntry {
    /// Creates a new builder-style object to manufacture [`DeleteMessageBatchResultEntry`](crate::model::DeleteMessageBatchResultEntry)
    pub fn builder() -> crate::model::delete_message_batch_result_entry::Builder {
        crate::model::delete_message_batch_result_entry::Builder::default()
    }
}

/// <p>Encloses a receipt handle and an identifier for it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMessageBatchRequestEntry {
    /// <p>An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
    /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
    /// </note>
    pub id: std::option::Option<std::string::String>,
    /// <p>A receipt handle.</p>
    pub receipt_handle: std::option::Option<std::string::String>,
}
impl DeleteMessageBatchRequestEntry {
    /// <p>An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
    /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
    /// </note>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A receipt handle.</p>
    pub fn receipt_handle(&self) -> std::option::Option<&str> {
        self.receipt_handle.as_deref()
    }
}
impl std::fmt::Debug for DeleteMessageBatchRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMessageBatchRequestEntry");
        formatter.field("id", &self.id);
        formatter.field("receipt_handle", &self.receipt_handle);
        formatter.finish()
    }
}
/// See [`DeleteMessageBatchRequestEntry`](crate::model::DeleteMessageBatchRequestEntry)
pub mod delete_message_batch_request_entry {
    /// A builder for [`DeleteMessageBatchRequestEntry`](crate::model::DeleteMessageBatchRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) receipt_handle: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
        /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
        /// </note>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An identifier for this particular receipt handle. This is used to communicate the result.</p> <note>
        /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
        /// </note>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A receipt handle.</p>
        pub fn receipt_handle(mut self, input: impl Into<std::string::String>) -> Self {
            self.receipt_handle = Some(input.into());
            self
        }
        /// <p>A receipt handle.</p>
        pub fn set_receipt_handle(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.receipt_handle = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMessageBatchRequestEntry`](crate::model::DeleteMessageBatchRequestEntry)
        pub fn build(self) -> crate::model::DeleteMessageBatchRequestEntry {
            crate::model::DeleteMessageBatchRequestEntry {
                id: self.id,
                receipt_handle: self.receipt_handle,
            }
        }
    }
}
impl DeleteMessageBatchRequestEntry {
    /// Creates a new builder-style object to manufacture [`DeleteMessageBatchRequestEntry`](crate::model::DeleteMessageBatchRequestEntry)
    pub fn builder() -> crate::model::delete_message_batch_request_entry::Builder {
        crate::model::delete_message_batch_request_entry::Builder::default()
    }
}

/// <p>Encloses the <code>Id</code> of an entry in <code> <code>ChangeMessageVisibilityBatch</code>.</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeMessageVisibilityBatchResultEntry {
    /// <p>Represents a message whose visibility timeout has been changed successfully.</p>
    pub id: std::option::Option<std::string::String>,
}
impl ChangeMessageVisibilityBatchResultEntry {
    /// <p>Represents a message whose visibility timeout has been changed successfully.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ChangeMessageVisibilityBatchResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeMessageVisibilityBatchResultEntry");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`ChangeMessageVisibilityBatchResultEntry`](crate::model::ChangeMessageVisibilityBatchResultEntry)
pub mod change_message_visibility_batch_result_entry {
    /// A builder for [`ChangeMessageVisibilityBatchResultEntry`](crate::model::ChangeMessageVisibilityBatchResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents a message whose visibility timeout has been changed successfully.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Represents a message whose visibility timeout has been changed successfully.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeMessageVisibilityBatchResultEntry`](crate::model::ChangeMessageVisibilityBatchResultEntry)
        pub fn build(self) -> crate::model::ChangeMessageVisibilityBatchResultEntry {
            crate::model::ChangeMessageVisibilityBatchResultEntry { id: self.id }
        }
    }
}
impl ChangeMessageVisibilityBatchResultEntry {
    /// Creates a new builder-style object to manufacture [`ChangeMessageVisibilityBatchResultEntry`](crate::model::ChangeMessageVisibilityBatchResultEntry)
    pub fn builder() -> crate::model::change_message_visibility_batch_result_entry::Builder {
        crate::model::change_message_visibility_batch_result_entry::Builder::default()
    }
}

/// <p>Encloses a receipt handle and an entry id for each message in <code> <code>ChangeMessageVisibilityBatch</code>.</code> </p> <important>
/// <p>All of the following list parameters must be prefixed with <code>ChangeMessageVisibilityBatchRequestEntry.n</code>, where <code>n</code> is an integer value starting with <code>1</code>. For example, a parameter list for this action might look like this:</p>
/// </important>
/// <p> <code>&amp;ChangeMessageVisibilityBatchRequestEntry.1.Id=change_visibility_msg_2</code> </p>
/// <p> <code>&amp;ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle=your_receipt_handle</code> </p>
/// <p> <code>&amp;ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout=45</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeMessageVisibilityBatchRequestEntry {
    /// <p>An identifier for this particular receipt handle used to communicate the result.</p> <note>
    /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
    /// </note>
    pub id: std::option::Option<std::string::String>,
    /// <p>A receipt handle.</p>
    pub receipt_handle: std::option::Option<std::string::String>,
    /// <p>The new value (in seconds) for the message's visibility timeout.</p>
    pub visibility_timeout: i32,
}
impl ChangeMessageVisibilityBatchRequestEntry {
    /// <p>An identifier for this particular receipt handle used to communicate the result.</p> <note>
    /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
    /// </note>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A receipt handle.</p>
    pub fn receipt_handle(&self) -> std::option::Option<&str> {
        self.receipt_handle.as_deref()
    }
    /// <p>The new value (in seconds) for the message's visibility timeout.</p>
    pub fn visibility_timeout(&self) -> i32 {
        self.visibility_timeout
    }
}
impl std::fmt::Debug for ChangeMessageVisibilityBatchRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeMessageVisibilityBatchRequestEntry");
        formatter.field("id", &self.id);
        formatter.field("receipt_handle", &self.receipt_handle);
        formatter.field("visibility_timeout", &self.visibility_timeout);
        formatter.finish()
    }
}
/// See [`ChangeMessageVisibilityBatchRequestEntry`](crate::model::ChangeMessageVisibilityBatchRequestEntry)
pub mod change_message_visibility_batch_request_entry {
    /// A builder for [`ChangeMessageVisibilityBatchRequestEntry`](crate::model::ChangeMessageVisibilityBatchRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) receipt_handle: std::option::Option<std::string::String>,
        pub(crate) visibility_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An identifier for this particular receipt handle used to communicate the result.</p> <note>
        /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
        /// </note>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An identifier for this particular receipt handle used to communicate the result.</p> <note>
        /// <p>The <code>Id</code>s of a batch request need to be unique within a request.</p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).</p>
        /// </note>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A receipt handle.</p>
        pub fn receipt_handle(mut self, input: impl Into<std::string::String>) -> Self {
            self.receipt_handle = Some(input.into());
            self
        }
        /// <p>A receipt handle.</p>
        pub fn set_receipt_handle(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.receipt_handle = input;
            self
        }
        /// <p>The new value (in seconds) for the message's visibility timeout.</p>
        pub fn visibility_timeout(mut self, input: i32) -> Self {
            self.visibility_timeout = Some(input);
            self
        }
        /// <p>The new value (in seconds) for the message's visibility timeout.</p>
        pub fn set_visibility_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.visibility_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeMessageVisibilityBatchRequestEntry`](crate::model::ChangeMessageVisibilityBatchRequestEntry)
        pub fn build(self) -> crate::model::ChangeMessageVisibilityBatchRequestEntry {
            crate::model::ChangeMessageVisibilityBatchRequestEntry {
                id: self.id,
                receipt_handle: self.receipt_handle,
                visibility_timeout: self.visibility_timeout.unwrap_or_default(),
            }
        }
    }
}
impl ChangeMessageVisibilityBatchRequestEntry {
    /// Creates a new builder-style object to manufacture [`ChangeMessageVisibilityBatchRequestEntry`](crate::model::ChangeMessageVisibilityBatchRequestEntry)
    pub fn builder() -> crate::model::change_message_visibility_batch_request_entry::Builder {
        crate::model::change_message_visibility_batch_request_entry::Builder::default()
    }
}
