// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddPermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddPermissionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OverLimit" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::OverLimit({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::over_limit::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_over_limit_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddPermissionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_message_visibility_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ChangeMessageVisibilityOutput,
    crate::error::ChangeMessageVisibilityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ChangeMessageVisibilityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ChangeMessageVisibilityError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.MessageNotInflight" => {
            crate::error::ChangeMessageVisibilityError {
                meta: generic,
                kind: crate::error::ChangeMessageVisibilityErrorKind::MessageNotInflight({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::message_not_inflight::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_message_not_inflight_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangeMessageVisibilityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ReceiptHandleIsInvalid" => crate::error::ChangeMessageVisibilityError {
            meta: generic,
            kind: crate::error::ChangeMessageVisibilityErrorKind::ReceiptHandleIsInvalid({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::receipt_handle_is_invalid::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_receipt_handle_is_invalid_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangeMessageVisibilityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ChangeMessageVisibilityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_message_visibility_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ChangeMessageVisibilityOutput,
    crate::error::ChangeMessageVisibilityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::change_message_visibility_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_message_visibility_batch_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ChangeMessageVisibilityBatchOutput,
    crate::error::ChangeMessageVisibilityBatchError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ChangeMessageVisibilityBatchError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ChangeMessageVisibilityBatchError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.BatchEntryIdsNotDistinct" => crate::error::ChangeMessageVisibilityBatchError { meta: generic, kind: crate::error::ChangeMessageVisibilityBatchErrorKind::BatchEntryIdsNotDistinct({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::batch_entry_ids_not_distinct::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_entry_ids_not_distinct_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangeMessageVisibilityBatchError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWS.SimpleQueueService.EmptyBatchRequest" => crate::error::ChangeMessageVisibilityBatchError { meta: generic, kind: crate::error::ChangeMessageVisibilityBatchErrorKind::EmptyBatchRequest({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::empty_batch_request::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_empty_batch_request_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangeMessageVisibilityBatchError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWS.SimpleQueueService.InvalidBatchEntryId" => crate::error::ChangeMessageVisibilityBatchError { meta: generic, kind: crate::error::ChangeMessageVisibilityBatchErrorKind::InvalidBatchEntryId({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_batch_entry_id::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_batch_entry_id_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangeMessageVisibilityBatchError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AWS.SimpleQueueService.TooManyEntriesInBatchRequest" => crate::error::ChangeMessageVisibilityBatchError { meta: generic, kind: crate::error::ChangeMessageVisibilityBatchErrorKind::TooManyEntriesInBatchRequest({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_entries_in_batch_request::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_entries_in_batch_request_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangeMessageVisibilityBatchError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ChangeMessageVisibilityBatchError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_message_visibility_batch_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ChangeMessageVisibilityBatchOutput,
    crate::error::ChangeMessageVisibilityBatchError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::change_message_visibility_batch_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_change_message_visibility_batch(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ChangeMessageVisibilityBatchError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateQueueOutput, crate::error::CreateQueueError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateQueueError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateQueueError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.QueueDeletedRecently" => crate::error::CreateQueueError {
            meta: generic,
            kind: crate::error::CreateQueueErrorKind::QueueDeletedRecently({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::queue_deleted_recently::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_queue_deleted_recently_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateQueueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "QueueAlreadyExists" => {
            crate::error::CreateQueueError {
                meta: generic,
                kind: crate::error::CreateQueueErrorKind::QueueNameExists({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::queue_name_exists::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_queue_name_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateQueueError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateQueueOutput, crate::error::CreateQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_queue_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_queue(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateQueueError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteMessageOutput, crate::error::DeleteMessageError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidIdFormat" => {
            crate::error::DeleteMessageError {
                meta: generic,
                kind: crate::error::DeleteMessageErrorKind::InvalidIdFormat({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_id_format::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_id_format_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMessageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ReceiptHandleIsInvalid" => crate::error::DeleteMessageError {
            meta: generic,
            kind: crate::error::DeleteMessageErrorKind::ReceiptHandleIsInvalid({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::receipt_handle_is_invalid::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_receipt_handle_is_invalid_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteMessageOutput, crate::error::DeleteMessageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_message_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_message_batch_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMessageBatchOutput,
    crate::error::DeleteMessageBatchError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMessageBatchError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteMessageBatchError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.BatchEntryIdsNotDistinct" => {
            crate::error::DeleteMessageBatchError {
                meta: generic,
                kind: crate::error::DeleteMessageBatchErrorKind::BatchEntryIdsNotDistinct({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::batch_entry_ids_not_distinct::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_batch_entry_ids_not_distinct_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMessageBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "AWS.SimpleQueueService.EmptyBatchRequest" => {
            crate::error::DeleteMessageBatchError {
                meta: generic,
                kind: crate::error::DeleteMessageBatchErrorKind::EmptyBatchRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::empty_batch_request::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_empty_batch_request_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMessageBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "AWS.SimpleQueueService.InvalidBatchEntryId" => crate::error::DeleteMessageBatchError {
            meta: generic,
            kind: crate::error::DeleteMessageBatchErrorKind::InvalidBatchEntryId({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_batch_entry_id::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_batch_entry_id_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMessageBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWS.SimpleQueueService.TooManyEntriesInBatchRequest" => {
            crate::error::DeleteMessageBatchError {
                meta: generic,
                kind: crate::error::DeleteMessageBatchErrorKind::TooManyEntriesInBatchRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_entries_in_batch_request::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_too_many_entries_in_batch_request_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMessageBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteMessageBatchError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_message_batch_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMessageBatchOutput,
    crate::error::DeleteMessageBatchError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_message_batch_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_message_batch(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteMessageBatchError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteQueueOutput, crate::error::DeleteQueueError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteQueueError::unhandled)?;
    Err(crate::error::DeleteQueueError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteQueueOutput, crate::error::DeleteQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_queue_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_queue_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetQueueAttributesOutput,
    crate::error::GetQueueAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetQueueAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetQueueAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidAttributeName" => crate::error::GetQueueAttributesError {
            meta: generic,
            kind: crate::error::GetQueueAttributesErrorKind::InvalidAttributeName({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_attribute_name::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_attribute_name_xml_err(response.body().as_ref(), output).map_err(crate::error::GetQueueAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetQueueAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_queue_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetQueueAttributesOutput,
    crate::error::GetQueueAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_queue_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_queue_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetQueueAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_queue_url_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetQueueUrlOutput, crate::error::GetQueueUrlError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetQueueUrlError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetQueueUrlError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.NonExistentQueue" => {
            crate::error::GetQueueUrlError {
                meta: generic,
                kind: crate::error::GetQueueUrlErrorKind::QueueDoesNotExist({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::queue_does_not_exist::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_queue_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::GetQueueUrlError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetQueueUrlError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_queue_url_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetQueueUrlOutput, crate::error::GetQueueUrlError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_queue_url_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_queue_url(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetQueueUrlError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_dead_letter_source_queues_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDeadLetterSourceQueuesOutput,
    crate::error::ListDeadLetterSourceQueuesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDeadLetterSourceQueuesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListDeadLetterSourceQueuesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.NonExistentQueue" => {
            crate::error::ListDeadLetterSourceQueuesError {
                meta: generic,
                kind: crate::error::ListDeadLetterSourceQueuesErrorKind::QueueDoesNotExist({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::queue_does_not_exist::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_queue_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDeadLetterSourceQueuesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListDeadLetterSourceQueuesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_dead_letter_source_queues_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListDeadLetterSourceQueuesOutput,
    crate::error::ListDeadLetterSourceQueuesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_dead_letter_source_queues_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_dead_letter_source_queues(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDeadLetterSourceQueuesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_queues_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListQueuesOutput, crate::error::ListQueuesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListQueuesError::unhandled)?;
    Err(crate::error::ListQueuesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_queues_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListQueuesOutput, crate::error::ListQueuesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_queues_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_queues(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListQueuesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_queue_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListQueueTagsOutput, crate::error::ListQueueTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListQueueTagsError::unhandled)?;
    Err(crate::error::ListQueueTagsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_queue_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListQueueTagsOutput, crate::error::ListQueueTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_queue_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_queue_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListQueueTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purge_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PurgeQueueOutput, crate::error::PurgeQueueError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PurgeQueueError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PurgeQueueError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.PurgeQueueInProgress" => crate::error::PurgeQueueError {
            meta: generic,
            kind: crate::error::PurgeQueueErrorKind::PurgeQueueInProgress({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::purge_queue_in_progress::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_purge_queue_in_progress_xml_err(response.body().as_ref(), output).map_err(crate::error::PurgeQueueError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWS.SimpleQueueService.NonExistentQueue" => {
            crate::error::PurgeQueueError {
                meta: generic,
                kind: crate::error::PurgeQueueErrorKind::QueueDoesNotExist({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::queue_does_not_exist::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_queue_does_not_exist_xml_err(response.body().as_ref(), output).map_err(crate::error::PurgeQueueError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PurgeQueueError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purge_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PurgeQueueOutput, crate::error::PurgeQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::purge_queue_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_receive_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReceiveMessageOutput, crate::error::ReceiveMessageError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReceiveMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReceiveMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OverLimit" => crate::error::ReceiveMessageError {
            meta: generic,
            kind: crate::error::ReceiveMessageErrorKind::OverLimit({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::over_limit::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_over_limit_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ReceiveMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReceiveMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_receive_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReceiveMessageOutput, crate::error::ReceiveMessageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::receive_message_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_receive_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReceiveMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemovePermissionOutput, crate::error::RemovePermissionError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemovePermissionError::unhandled)?;
    Err(crate::error::RemovePermissionError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemovePermissionOutput, crate::error::RemovePermissionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendMessageOutput, crate::error::SendMessageError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidMessageContents" => crate::error::SendMessageError {
            meta: generic,
            kind: crate::error::SendMessageErrorKind::InvalidMessageContents({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_message_contents::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_message_contents_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWS.SimpleQueueService.UnsupportedOperation" => crate::error::SendMessageError {
            meta: generic,
            kind: crate::error::SendMessageErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendMessageOutput, crate::error::SendMessageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_message_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_message_batch_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendMessageBatchOutput, crate::error::SendMessageBatchError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendMessageBatchError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendMessageBatchError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AWS.SimpleQueueService.BatchEntryIdsNotDistinct" => crate::error::SendMessageBatchError {
            meta: generic,
            kind: crate::error::SendMessageBatchErrorKind::BatchEntryIdsNotDistinct({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::batch_entry_ids_not_distinct::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_entry_ids_not_distinct_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWS.SimpleQueueService.BatchRequestTooLong" => crate::error::SendMessageBatchError {
            meta: generic,
            kind: crate::error::SendMessageBatchErrorKind::BatchRequestTooLong({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::batch_request_too_long::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_request_too_long_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWS.SimpleQueueService.EmptyBatchRequest" => {
            crate::error::SendMessageBatchError {
                meta: generic,
                kind: crate::error::SendMessageBatchErrorKind::EmptyBatchRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::empty_batch_request::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_empty_batch_request_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "AWS.SimpleQueueService.InvalidBatchEntryId" => crate::error::SendMessageBatchError {
            meta: generic,
            kind: crate::error::SendMessageBatchErrorKind::InvalidBatchEntryId({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_batch_entry_id::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_batch_entry_id_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AWS.SimpleQueueService.TooManyEntriesInBatchRequest" => {
            crate::error::SendMessageBatchError {
                meta: generic,
                kind: crate::error::SendMessageBatchErrorKind::TooManyEntriesInBatchRequest({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::too_many_entries_in_batch_request::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_too_many_entries_in_batch_request_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "AWS.SimpleQueueService.UnsupportedOperation" => crate::error::SendMessageBatchError {
            meta: generic,
            kind: crate::error::SendMessageBatchErrorKind::UnsupportedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::SendMessageBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendMessageBatchError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_message_batch_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendMessageBatchOutput, crate::error::SendMessageBatchError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_message_batch_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_send_message_batch(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendMessageBatchError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_queue_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetQueueAttributesOutput,
    crate::error::SetQueueAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetQueueAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetQueueAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidAttributeName" => crate::error::SetQueueAttributesError {
            meta: generic,
            kind: crate::error::SetQueueAttributesErrorKind::InvalidAttributeName({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_attribute_name::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_attribute_name_xml_err(response.body().as_ref(), output).map_err(crate::error::SetQueueAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetQueueAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_queue_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetQueueAttributesOutput,
    crate::error::SetQueueAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_queue_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagQueueOutput, crate::error::TagQueueError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagQueueError::unhandled)?;
    Err(crate::error::TagQueueError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagQueueOutput, crate::error::TagQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_queue_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_queue_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagQueueOutput, crate::error::UntagQueueError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagQueueError::unhandled)?;
    Err(crate::error::UntagQueueError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_queue_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagQueueOutput, crate::error::UntagQueueError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_queue_output::Builder::default();
        let _ = response;
        output.build()
    })
}
