// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddPermissionError {
    /// Kind of error that occurred.
    pub kind: AddPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddPermissionErrorKind {
    /// <p>The specified action violates a limit. For example, <code>ReceiveMessage</code>
    /// returns this error if the maximum number of inflight messages is reached and
    /// <code>AddPermission</code> returns this error if the maximum number of permissions
    /// for the queue is reached.</p>
    OverLimit(crate::error::OverLimit),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddPermissionErrorKind::OverLimit(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddPermissionError {
    fn code(&self) -> Option<&str> {
        AddPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddPermissionError {
    /// Creates a new `AddPermissionError`.
    pub fn new(kind: AddPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddPermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::OverLimit`.
    pub fn is_over_limit(&self) -> bool {
        matches!(&self.kind, AddPermissionErrorKind::OverLimit(_))
    }
}
impl std::error::Error for AddPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddPermissionErrorKind::OverLimit(_inner) => Some(_inner),
            AddPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ChangeMessageVisibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChangeMessageVisibilityError {
    /// Kind of error that occurred.
    pub kind: ChangeMessageVisibilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChangeMessageVisibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChangeMessageVisibilityErrorKind {
    /// <p>The specified message isn't in flight.</p>
    MessageNotInflight(crate::error::MessageNotInflight),
    /// <p>The specified receipt handle isn't valid.</p>
    ReceiptHandleIsInvalid(crate::error::ReceiptHandleIsInvalid),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChangeMessageVisibilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChangeMessageVisibilityErrorKind::MessageNotInflight(_inner) => _inner.fmt(f),
            ChangeMessageVisibilityErrorKind::ReceiptHandleIsInvalid(_inner) => _inner.fmt(f),
            ChangeMessageVisibilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChangeMessageVisibilityError {
    fn code(&self) -> Option<&str> {
        ChangeMessageVisibilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChangeMessageVisibilityError {
    /// Creates a new `ChangeMessageVisibilityError`.
    pub fn new(kind: ChangeMessageVisibilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChangeMessageVisibilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChangeMessageVisibilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChangeMessageVisibilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChangeMessageVisibilityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ChangeMessageVisibilityErrorKind::MessageNotInflight`.
    pub fn is_message_not_inflight(&self) -> bool {
        matches!(
            &self.kind,
            ChangeMessageVisibilityErrorKind::MessageNotInflight(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeMessageVisibilityErrorKind::ReceiptHandleIsInvalid`.
    pub fn is_receipt_handle_is_invalid(&self) -> bool {
        matches!(
            &self.kind,
            ChangeMessageVisibilityErrorKind::ReceiptHandleIsInvalid(_)
        )
    }
}
impl std::error::Error for ChangeMessageVisibilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChangeMessageVisibilityErrorKind::MessageNotInflight(_inner) => Some(_inner),
            ChangeMessageVisibilityErrorKind::ReceiptHandleIsInvalid(_inner) => Some(_inner),
            ChangeMessageVisibilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ChangeMessageVisibilityBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChangeMessageVisibilityBatchError {
    /// Kind of error that occurred.
    pub kind: ChangeMessageVisibilityBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChangeMessageVisibilityBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChangeMessageVisibilityBatchErrorKind {
    /// <p>Two or more batch entries in the request have the same <code>Id</code>.</p>
    BatchEntryIdsNotDistinct(crate::error::BatchEntryIdsNotDistinct),
    /// <p>The batch request doesn't contain any entries.</p>
    EmptyBatchRequest(crate::error::EmptyBatchRequest),
    /// <p>The <code>Id</code> of a batch entry in a batch request doesn't abide by the specification.</p>
    InvalidBatchEntryId(crate::error::InvalidBatchEntryId),
    /// <p>The batch request contains more entries than permissible.</p>
    TooManyEntriesInBatchRequest(crate::error::TooManyEntriesInBatchRequest),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChangeMessageVisibilityBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChangeMessageVisibilityBatchErrorKind::BatchEntryIdsNotDistinct(_inner) => {
                _inner.fmt(f)
            }
            ChangeMessageVisibilityBatchErrorKind::EmptyBatchRequest(_inner) => _inner.fmt(f),
            ChangeMessageVisibilityBatchErrorKind::InvalidBatchEntryId(_inner) => _inner.fmt(f),
            ChangeMessageVisibilityBatchErrorKind::TooManyEntriesInBatchRequest(_inner) => {
                _inner.fmt(f)
            }
            ChangeMessageVisibilityBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChangeMessageVisibilityBatchError {
    fn code(&self) -> Option<&str> {
        ChangeMessageVisibilityBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChangeMessageVisibilityBatchError {
    /// Creates a new `ChangeMessageVisibilityBatchError`.
    pub fn new(kind: ChangeMessageVisibilityBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChangeMessageVisibilityBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChangeMessageVisibilityBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChangeMessageVisibilityBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChangeMessageVisibilityBatchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ChangeMessageVisibilityBatchErrorKind::BatchEntryIdsNotDistinct`.
    pub fn is_batch_entry_ids_not_distinct(&self) -> bool {
        matches!(
            &self.kind,
            ChangeMessageVisibilityBatchErrorKind::BatchEntryIdsNotDistinct(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeMessageVisibilityBatchErrorKind::EmptyBatchRequest`.
    pub fn is_empty_batch_request(&self) -> bool {
        matches!(
            &self.kind,
            ChangeMessageVisibilityBatchErrorKind::EmptyBatchRequest(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeMessageVisibilityBatchErrorKind::InvalidBatchEntryId`.
    pub fn is_invalid_batch_entry_id(&self) -> bool {
        matches!(
            &self.kind,
            ChangeMessageVisibilityBatchErrorKind::InvalidBatchEntryId(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeMessageVisibilityBatchErrorKind::TooManyEntriesInBatchRequest`.
    pub fn is_too_many_entries_in_batch_request(&self) -> bool {
        matches!(
            &self.kind,
            ChangeMessageVisibilityBatchErrorKind::TooManyEntriesInBatchRequest(_)
        )
    }
}
impl std::error::Error for ChangeMessageVisibilityBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChangeMessageVisibilityBatchErrorKind::BatchEntryIdsNotDistinct(_inner) => Some(_inner),
            ChangeMessageVisibilityBatchErrorKind::EmptyBatchRequest(_inner) => Some(_inner),
            ChangeMessageVisibilityBatchErrorKind::InvalidBatchEntryId(_inner) => Some(_inner),
            ChangeMessageVisibilityBatchErrorKind::TooManyEntriesInBatchRequest(_inner) => {
                Some(_inner)
            }
            ChangeMessageVisibilityBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateQueueError {
    /// Kind of error that occurred.
    pub kind: CreateQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateQueueErrorKind {
    /// <p>You must wait 60 seconds after deleting a queue before you can create another queue
    /// with the same name.</p>
    QueueDeletedRecently(crate::error::QueueDeletedRecently),
    /// <p>A queue with this name already exists. Amazon SQS returns this error only if the request
    /// includes attributes whose values differ from those of the existing queue.</p>
    QueueNameExists(crate::error::QueueNameExists),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateQueueErrorKind::QueueDeletedRecently(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::QueueNameExists(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateQueueError {
    fn code(&self) -> Option<&str> {
        CreateQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateQueueError {
    /// Creates a new `CreateQueueError`.
    pub fn new(kind: CreateQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::QueueDeletedRecently`.
    pub fn is_queue_deleted_recently(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::QueueDeletedRecently(_))
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::QueueNameExists`.
    pub fn is_queue_name_exists(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::QueueNameExists(_))
    }
}
impl std::error::Error for CreateQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateQueueErrorKind::QueueDeletedRecently(_inner) => Some(_inner),
            CreateQueueErrorKind::QueueNameExists(_inner) => Some(_inner),
            CreateQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMessageError {
    /// Kind of error that occurred.
    pub kind: DeleteMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMessageErrorKind {
    /// <p>The specified receipt handle isn't valid for the current version.</p>
    InvalidIdFormat(crate::error::InvalidIdFormat),
    /// <p>The specified receipt handle isn't valid.</p>
    ReceiptHandleIsInvalid(crate::error::ReceiptHandleIsInvalid),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMessageErrorKind::InvalidIdFormat(_inner) => _inner.fmt(f),
            DeleteMessageErrorKind::ReceiptHandleIsInvalid(_inner) => _inner.fmt(f),
            DeleteMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMessageError {
    fn code(&self) -> Option<&str> {
        DeleteMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMessageError {
    /// Creates a new `DeleteMessageError`.
    pub fn new(kind: DeleteMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMessageErrorKind::InvalidIdFormat`.
    pub fn is_invalid_id_format(&self) -> bool {
        matches!(&self.kind, DeleteMessageErrorKind::InvalidIdFormat(_))
    }
    /// Returns `true` if the error kind is `DeleteMessageErrorKind::ReceiptHandleIsInvalid`.
    pub fn is_receipt_handle_is_invalid(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMessageErrorKind::ReceiptHandleIsInvalid(_)
        )
    }
}
impl std::error::Error for DeleteMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMessageErrorKind::InvalidIdFormat(_inner) => Some(_inner),
            DeleteMessageErrorKind::ReceiptHandleIsInvalid(_inner) => Some(_inner),
            DeleteMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMessageBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMessageBatchError {
    /// Kind of error that occurred.
    pub kind: DeleteMessageBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMessageBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMessageBatchErrorKind {
    /// <p>Two or more batch entries in the request have the same <code>Id</code>.</p>
    BatchEntryIdsNotDistinct(crate::error::BatchEntryIdsNotDistinct),
    /// <p>The batch request doesn't contain any entries.</p>
    EmptyBatchRequest(crate::error::EmptyBatchRequest),
    /// <p>The <code>Id</code> of a batch entry in a batch request doesn't abide by the specification.</p>
    InvalidBatchEntryId(crate::error::InvalidBatchEntryId),
    /// <p>The batch request contains more entries than permissible.</p>
    TooManyEntriesInBatchRequest(crate::error::TooManyEntriesInBatchRequest),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMessageBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMessageBatchErrorKind::BatchEntryIdsNotDistinct(_inner) => _inner.fmt(f),
            DeleteMessageBatchErrorKind::EmptyBatchRequest(_inner) => _inner.fmt(f),
            DeleteMessageBatchErrorKind::InvalidBatchEntryId(_inner) => _inner.fmt(f),
            DeleteMessageBatchErrorKind::TooManyEntriesInBatchRequest(_inner) => _inner.fmt(f),
            DeleteMessageBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMessageBatchError {
    fn code(&self) -> Option<&str> {
        DeleteMessageBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMessageBatchError {
    /// Creates a new `DeleteMessageBatchError`.
    pub fn new(kind: DeleteMessageBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMessageBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMessageBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMessageBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMessageBatchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMessageBatchErrorKind::BatchEntryIdsNotDistinct`.
    pub fn is_batch_entry_ids_not_distinct(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMessageBatchErrorKind::BatchEntryIdsNotDistinct(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMessageBatchErrorKind::EmptyBatchRequest`.
    pub fn is_empty_batch_request(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMessageBatchErrorKind::EmptyBatchRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMessageBatchErrorKind::InvalidBatchEntryId`.
    pub fn is_invalid_batch_entry_id(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMessageBatchErrorKind::InvalidBatchEntryId(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMessageBatchErrorKind::TooManyEntriesInBatchRequest`.
    pub fn is_too_many_entries_in_batch_request(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMessageBatchErrorKind::TooManyEntriesInBatchRequest(_)
        )
    }
}
impl std::error::Error for DeleteMessageBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMessageBatchErrorKind::BatchEntryIdsNotDistinct(_inner) => Some(_inner),
            DeleteMessageBatchErrorKind::EmptyBatchRequest(_inner) => Some(_inner),
            DeleteMessageBatchErrorKind::InvalidBatchEntryId(_inner) => Some(_inner),
            DeleteMessageBatchErrorKind::TooManyEntriesInBatchRequest(_inner) => Some(_inner),
            DeleteMessageBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQueueError {
    /// Kind of error that occurred.
    pub kind: DeleteQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQueueErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQueueError {
    fn code(&self) -> Option<&str> {
        DeleteQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQueueError {
    /// Creates a new `DeleteQueueError`.
    pub fn new(kind: DeleteQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DeleteQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueueAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueueAttributesError {
    /// Kind of error that occurred.
    pub kind: GetQueueAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueueAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueueAttributesErrorKind {
    /// <p>The specified attribute doesn't exist.</p>
    InvalidAttributeName(crate::error::InvalidAttributeName),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueueAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueueAttributesErrorKind::InvalidAttributeName(_inner) => _inner.fmt(f),
            GetQueueAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueueAttributesError {
    fn code(&self) -> Option<&str> {
        GetQueueAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueueAttributesError {
    /// Creates a new `GetQueueAttributesError`.
    pub fn new(kind: GetQueueAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueueAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueueAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueueAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueueAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetQueueAttributesErrorKind::InvalidAttributeName`.
    pub fn is_invalid_attribute_name(&self) -> bool {
        matches!(
            &self.kind,
            GetQueueAttributesErrorKind::InvalidAttributeName(_)
        )
    }
}
impl std::error::Error for GetQueueAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueueAttributesErrorKind::InvalidAttributeName(_inner) => Some(_inner),
            GetQueueAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueueUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueueUrlError {
    /// Kind of error that occurred.
    pub kind: GetQueueUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueueUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueueUrlErrorKind {
    /// <p>The specified queue doesn't exist.</p>
    QueueDoesNotExist(crate::error::QueueDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueueUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueueUrlErrorKind::QueueDoesNotExist(_inner) => _inner.fmt(f),
            GetQueueUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueueUrlError {
    fn code(&self) -> Option<&str> {
        GetQueueUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueueUrlError {
    /// Creates a new `GetQueueUrlError`.
    pub fn new(kind: GetQueueUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueueUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueueUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueueUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueueUrlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetQueueUrlErrorKind::QueueDoesNotExist`.
    pub fn is_queue_does_not_exist(&self) -> bool {
        matches!(&self.kind, GetQueueUrlErrorKind::QueueDoesNotExist(_))
    }
}
impl std::error::Error for GetQueueUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueueUrlErrorKind::QueueDoesNotExist(_inner) => Some(_inner),
            GetQueueUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeadLetterSourceQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeadLetterSourceQueuesError {
    /// Kind of error that occurred.
    pub kind: ListDeadLetterSourceQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeadLetterSourceQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeadLetterSourceQueuesErrorKind {
    /// <p>The specified queue doesn't exist.</p>
    QueueDoesNotExist(crate::error::QueueDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeadLetterSourceQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeadLetterSourceQueuesErrorKind::QueueDoesNotExist(_inner) => _inner.fmt(f),
            ListDeadLetterSourceQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeadLetterSourceQueuesError {
    fn code(&self) -> Option<&str> {
        ListDeadLetterSourceQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeadLetterSourceQueuesError {
    /// Creates a new `ListDeadLetterSourceQueuesError`.
    pub fn new(kind: ListDeadLetterSourceQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeadLetterSourceQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeadLetterSourceQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeadLetterSourceQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeadLetterSourceQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDeadLetterSourceQueuesErrorKind::QueueDoesNotExist`.
    pub fn is_queue_does_not_exist(&self) -> bool {
        matches!(
            &self.kind,
            ListDeadLetterSourceQueuesErrorKind::QueueDoesNotExist(_)
        )
    }
}
impl std::error::Error for ListDeadLetterSourceQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeadLetterSourceQueuesErrorKind::QueueDoesNotExist(_inner) => Some(_inner),
            ListDeadLetterSourceQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueuesError {
    /// Kind of error that occurred.
    pub kind: ListQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueuesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueuesError {
    fn code(&self) -> Option<&str> {
        ListQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueuesError {
    /// Creates a new `ListQueuesError`.
    pub fn new(kind: ListQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueueTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueueTagsError {
    /// Kind of error that occurred.
    pub kind: ListQueueTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueueTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueueTagsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueueTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueueTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueueTagsError {
    fn code(&self) -> Option<&str> {
        ListQueueTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueueTagsError {
    /// Creates a new `ListQueueTagsError`.
    pub fn new(kind: ListQueueTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueueTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueueTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueueTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueueTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListQueueTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueueTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurgeQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurgeQueueError {
    /// Kind of error that occurred.
    pub kind: PurgeQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurgeQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurgeQueueErrorKind {
    /// <p>Indicates that the specified queue previously received a <code>PurgeQueue</code> request within the last 60 seconds (the time it can take to delete the messages in the queue).</p>
    PurgeQueueInProgress(crate::error::PurgeQueueInProgress),
    /// <p>The specified queue doesn't exist.</p>
    QueueDoesNotExist(crate::error::QueueDoesNotExist),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurgeQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurgeQueueErrorKind::PurgeQueueInProgress(_inner) => _inner.fmt(f),
            PurgeQueueErrorKind::QueueDoesNotExist(_inner) => _inner.fmt(f),
            PurgeQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurgeQueueError {
    fn code(&self) -> Option<&str> {
        PurgeQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurgeQueueError {
    /// Creates a new `PurgeQueueError`.
    pub fn new(kind: PurgeQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurgeQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurgeQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurgeQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurgeQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PurgeQueueErrorKind::PurgeQueueInProgress`.
    pub fn is_purge_queue_in_progress(&self) -> bool {
        matches!(&self.kind, PurgeQueueErrorKind::PurgeQueueInProgress(_))
    }
    /// Returns `true` if the error kind is `PurgeQueueErrorKind::QueueDoesNotExist`.
    pub fn is_queue_does_not_exist(&self) -> bool {
        matches!(&self.kind, PurgeQueueErrorKind::QueueDoesNotExist(_))
    }
}
impl std::error::Error for PurgeQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurgeQueueErrorKind::PurgeQueueInProgress(_inner) => Some(_inner),
            PurgeQueueErrorKind::QueueDoesNotExist(_inner) => Some(_inner),
            PurgeQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReceiveMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReceiveMessageError {
    /// Kind of error that occurred.
    pub kind: ReceiveMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReceiveMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReceiveMessageErrorKind {
    /// <p>The specified action violates a limit. For example, <code>ReceiveMessage</code>
    /// returns this error if the maximum number of inflight messages is reached and
    /// <code>AddPermission</code> returns this error if the maximum number of permissions
    /// for the queue is reached.</p>
    OverLimit(crate::error::OverLimit),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReceiveMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReceiveMessageErrorKind::OverLimit(_inner) => _inner.fmt(f),
            ReceiveMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReceiveMessageError {
    fn code(&self) -> Option<&str> {
        ReceiveMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReceiveMessageError {
    /// Creates a new `ReceiveMessageError`.
    pub fn new(kind: ReceiveMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReceiveMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReceiveMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReceiveMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReceiveMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReceiveMessageErrorKind::OverLimit`.
    pub fn is_over_limit(&self) -> bool {
        matches!(&self.kind, ReceiveMessageErrorKind::OverLimit(_))
    }
}
impl std::error::Error for ReceiveMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReceiveMessageErrorKind::OverLimit(_inner) => Some(_inner),
            ReceiveMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemovePermissionError {
    /// Kind of error that occurred.
    pub kind: RemovePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemovePermissionErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemovePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemovePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemovePermissionError {
    fn code(&self) -> Option<&str> {
        RemovePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemovePermissionError {
    /// Creates a new `RemovePermissionError`.
    pub fn new(kind: RemovePermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for RemovePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemovePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendMessageError {
    /// Kind of error that occurred.
    pub kind: SendMessageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendMessage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendMessageErrorKind {
    /// <p>The message contains characters outside the allowed set.</p>
    InvalidMessageContents(crate::error::InvalidMessageContents),
    /// <p>Error code 400. Unsupported operation.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendMessageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendMessageErrorKind::InvalidMessageContents(_inner) => _inner.fmt(f),
            SendMessageErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            SendMessageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendMessageError {
    fn code(&self) -> Option<&str> {
        SendMessageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendMessageError {
    /// Creates a new `SendMessageError`.
    pub fn new(kind: SendMessageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendMessageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendMessageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendMessageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendMessageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendMessageErrorKind::InvalidMessageContents`.
    pub fn is_invalid_message_contents(&self) -> bool {
        matches!(&self.kind, SendMessageErrorKind::InvalidMessageContents(_))
    }
    /// Returns `true` if the error kind is `SendMessageErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(&self.kind, SendMessageErrorKind::UnsupportedOperation(_))
    }
}
impl std::error::Error for SendMessageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendMessageErrorKind::InvalidMessageContents(_inner) => Some(_inner),
            SendMessageErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            SendMessageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendMessageBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendMessageBatchError {
    /// Kind of error that occurred.
    pub kind: SendMessageBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendMessageBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendMessageBatchErrorKind {
    /// <p>Two or more batch entries in the request have the same <code>Id</code>.</p>
    BatchEntryIdsNotDistinct(crate::error::BatchEntryIdsNotDistinct),
    /// <p>The length of all the messages put together is more than the limit.</p>
    BatchRequestTooLong(crate::error::BatchRequestTooLong),
    /// <p>The batch request doesn't contain any entries.</p>
    EmptyBatchRequest(crate::error::EmptyBatchRequest),
    /// <p>The <code>Id</code> of a batch entry in a batch request doesn't abide by the specification.</p>
    InvalidBatchEntryId(crate::error::InvalidBatchEntryId),
    /// <p>The batch request contains more entries than permissible.</p>
    TooManyEntriesInBatchRequest(crate::error::TooManyEntriesInBatchRequest),
    /// <p>Error code 400. Unsupported operation.</p>
    UnsupportedOperation(crate::error::UnsupportedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendMessageBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendMessageBatchErrorKind::BatchEntryIdsNotDistinct(_inner) => _inner.fmt(f),
            SendMessageBatchErrorKind::BatchRequestTooLong(_inner) => _inner.fmt(f),
            SendMessageBatchErrorKind::EmptyBatchRequest(_inner) => _inner.fmt(f),
            SendMessageBatchErrorKind::InvalidBatchEntryId(_inner) => _inner.fmt(f),
            SendMessageBatchErrorKind::TooManyEntriesInBatchRequest(_inner) => _inner.fmt(f),
            SendMessageBatchErrorKind::UnsupportedOperation(_inner) => _inner.fmt(f),
            SendMessageBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendMessageBatchError {
    fn code(&self) -> Option<&str> {
        SendMessageBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendMessageBatchError {
    /// Creates a new `SendMessageBatchError`.
    pub fn new(kind: SendMessageBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendMessageBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendMessageBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendMessageBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendMessageBatchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendMessageBatchErrorKind::BatchEntryIdsNotDistinct`.
    pub fn is_batch_entry_ids_not_distinct(&self) -> bool {
        matches!(
            &self.kind,
            SendMessageBatchErrorKind::BatchEntryIdsNotDistinct(_)
        )
    }
    /// Returns `true` if the error kind is `SendMessageBatchErrorKind::BatchRequestTooLong`.
    pub fn is_batch_request_too_long(&self) -> bool {
        matches!(
            &self.kind,
            SendMessageBatchErrorKind::BatchRequestTooLong(_)
        )
    }
    /// Returns `true` if the error kind is `SendMessageBatchErrorKind::EmptyBatchRequest`.
    pub fn is_empty_batch_request(&self) -> bool {
        matches!(&self.kind, SendMessageBatchErrorKind::EmptyBatchRequest(_))
    }
    /// Returns `true` if the error kind is `SendMessageBatchErrorKind::InvalidBatchEntryId`.
    pub fn is_invalid_batch_entry_id(&self) -> bool {
        matches!(
            &self.kind,
            SendMessageBatchErrorKind::InvalidBatchEntryId(_)
        )
    }
    /// Returns `true` if the error kind is `SendMessageBatchErrorKind::TooManyEntriesInBatchRequest`.
    pub fn is_too_many_entries_in_batch_request(&self) -> bool {
        matches!(
            &self.kind,
            SendMessageBatchErrorKind::TooManyEntriesInBatchRequest(_)
        )
    }
    /// Returns `true` if the error kind is `SendMessageBatchErrorKind::UnsupportedOperation`.
    pub fn is_unsupported_operation(&self) -> bool {
        matches!(
            &self.kind,
            SendMessageBatchErrorKind::UnsupportedOperation(_)
        )
    }
}
impl std::error::Error for SendMessageBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendMessageBatchErrorKind::BatchEntryIdsNotDistinct(_inner) => Some(_inner),
            SendMessageBatchErrorKind::BatchRequestTooLong(_inner) => Some(_inner),
            SendMessageBatchErrorKind::EmptyBatchRequest(_inner) => Some(_inner),
            SendMessageBatchErrorKind::InvalidBatchEntryId(_inner) => Some(_inner),
            SendMessageBatchErrorKind::TooManyEntriesInBatchRequest(_inner) => Some(_inner),
            SendMessageBatchErrorKind::UnsupportedOperation(_inner) => Some(_inner),
            SendMessageBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetQueueAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetQueueAttributesError {
    /// Kind of error that occurred.
    pub kind: SetQueueAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetQueueAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetQueueAttributesErrorKind {
    /// <p>The specified attribute doesn't exist.</p>
    InvalidAttributeName(crate::error::InvalidAttributeName),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetQueueAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetQueueAttributesErrorKind::InvalidAttributeName(_inner) => _inner.fmt(f),
            SetQueueAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetQueueAttributesError {
    fn code(&self) -> Option<&str> {
        SetQueueAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetQueueAttributesError {
    /// Creates a new `SetQueueAttributesError`.
    pub fn new(kind: SetQueueAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetQueueAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetQueueAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetQueueAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetQueueAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetQueueAttributesErrorKind::InvalidAttributeName`.
    pub fn is_invalid_attribute_name(&self) -> bool {
        matches!(
            &self.kind,
            SetQueueAttributesErrorKind::InvalidAttributeName(_)
        )
    }
}
impl std::error::Error for SetQueueAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetQueueAttributesErrorKind::InvalidAttributeName(_inner) => Some(_inner),
            SetQueueAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagQueueError {
    /// Kind of error that occurred.
    pub kind: TagQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagQueueErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagQueueError {
    fn code(&self) -> Option<&str> {
        TagQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagQueueError {
    /// Creates a new `TagQueueError`.
    pub fn new(kind: TagQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for TagQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagQueueError {
    /// Kind of error that occurred.
    pub kind: UntagQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagQueueErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagQueueError {
    fn code(&self) -> Option<&str> {
        UntagQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagQueueError {
    /// Creates a new `UntagQueueError`.
    pub fn new(kind: UntagQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UntagQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified attribute doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAttributeName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAttributeName");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAttributeName {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAttributeName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAttributeName")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAttributeName {}
/// See [`InvalidAttributeName`](crate::error::InvalidAttributeName)
pub mod invalid_attribute_name {
    /// A builder for [`InvalidAttributeName`](crate::error::InvalidAttributeName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAttributeName`](crate::error::InvalidAttributeName)
        pub fn build(self) -> crate::error::InvalidAttributeName {
            crate::error::InvalidAttributeName {
                message: self.message,
            }
        }
    }
}
impl InvalidAttributeName {
    /// Creates a new builder-style object to manufacture [`InvalidAttributeName`](crate::error::InvalidAttributeName)
    pub fn builder() -> crate::error::invalid_attribute_name::Builder {
        crate::error::invalid_attribute_name::Builder::default()
    }
}

/// <p>Error code 400. Unsupported operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperation")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperation {}
/// See [`UnsupportedOperation`](crate::error::UnsupportedOperation)
pub mod unsupported_operation {
    /// A builder for [`UnsupportedOperation`](crate::error::UnsupportedOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperation`](crate::error::UnsupportedOperation)
        pub fn build(self) -> crate::error::UnsupportedOperation {
            crate::error::UnsupportedOperation {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperation {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperation`](crate::error::UnsupportedOperation)
    pub fn builder() -> crate::error::unsupported_operation::Builder {
        crate::error::unsupported_operation::Builder::default()
    }
}

/// <p>The batch request contains more entries than permissible.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyEntriesInBatchRequest {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyEntriesInBatchRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyEntriesInBatchRequest");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyEntriesInBatchRequest {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyEntriesInBatchRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyEntriesInBatchRequest")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyEntriesInBatchRequest {}
/// See [`TooManyEntriesInBatchRequest`](crate::error::TooManyEntriesInBatchRequest)
pub mod too_many_entries_in_batch_request {
    /// A builder for [`TooManyEntriesInBatchRequest`](crate::error::TooManyEntriesInBatchRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyEntriesInBatchRequest`](crate::error::TooManyEntriesInBatchRequest)
        pub fn build(self) -> crate::error::TooManyEntriesInBatchRequest {
            crate::error::TooManyEntriesInBatchRequest {
                message: self.message,
            }
        }
    }
}
impl TooManyEntriesInBatchRequest {
    /// Creates a new builder-style object to manufacture [`TooManyEntriesInBatchRequest`](crate::error::TooManyEntriesInBatchRequest)
    pub fn builder() -> crate::error::too_many_entries_in_batch_request::Builder {
        crate::error::too_many_entries_in_batch_request::Builder::default()
    }
}

/// <p>The <code>Id</code> of a batch entry in a batch request doesn't abide by the specification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidBatchEntryId {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidBatchEntryId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidBatchEntryId");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidBatchEntryId {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidBatchEntryId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidBatchEntryId")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidBatchEntryId {}
/// See [`InvalidBatchEntryId`](crate::error::InvalidBatchEntryId)
pub mod invalid_batch_entry_id {
    /// A builder for [`InvalidBatchEntryId`](crate::error::InvalidBatchEntryId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidBatchEntryId`](crate::error::InvalidBatchEntryId)
        pub fn build(self) -> crate::error::InvalidBatchEntryId {
            crate::error::InvalidBatchEntryId {
                message: self.message,
            }
        }
    }
}
impl InvalidBatchEntryId {
    /// Creates a new builder-style object to manufacture [`InvalidBatchEntryId`](crate::error::InvalidBatchEntryId)
    pub fn builder() -> crate::error::invalid_batch_entry_id::Builder {
        crate::error::invalid_batch_entry_id::Builder::default()
    }
}

/// <p>The batch request doesn't contain any entries.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmptyBatchRequest {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EmptyBatchRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmptyBatchRequest");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EmptyBatchRequest {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EmptyBatchRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EmptyBatchRequest")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for EmptyBatchRequest {}
/// See [`EmptyBatchRequest`](crate::error::EmptyBatchRequest)
pub mod empty_batch_request {
    /// A builder for [`EmptyBatchRequest`](crate::error::EmptyBatchRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EmptyBatchRequest`](crate::error::EmptyBatchRequest)
        pub fn build(self) -> crate::error::EmptyBatchRequest {
            crate::error::EmptyBatchRequest {
                message: self.message,
            }
        }
    }
}
impl EmptyBatchRequest {
    /// Creates a new builder-style object to manufacture [`EmptyBatchRequest`](crate::error::EmptyBatchRequest)
    pub fn builder() -> crate::error::empty_batch_request::Builder {
        crate::error::empty_batch_request::Builder::default()
    }
}

/// <p>The length of all the messages put together is more than the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchRequestTooLong {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchRequestTooLong {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchRequestTooLong");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BatchRequestTooLong {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchRequestTooLong {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchRequestTooLong")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchRequestTooLong {}
/// See [`BatchRequestTooLong`](crate::error::BatchRequestTooLong)
pub mod batch_request_too_long {
    /// A builder for [`BatchRequestTooLong`](crate::error::BatchRequestTooLong)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchRequestTooLong`](crate::error::BatchRequestTooLong)
        pub fn build(self) -> crate::error::BatchRequestTooLong {
            crate::error::BatchRequestTooLong {
                message: self.message,
            }
        }
    }
}
impl BatchRequestTooLong {
    /// Creates a new builder-style object to manufacture [`BatchRequestTooLong`](crate::error::BatchRequestTooLong)
    pub fn builder() -> crate::error::batch_request_too_long::Builder {
        crate::error::batch_request_too_long::Builder::default()
    }
}

/// <p>Two or more batch entries in the request have the same <code>Id</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEntryIdsNotDistinct {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchEntryIdsNotDistinct {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEntryIdsNotDistinct");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BatchEntryIdsNotDistinct {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchEntryIdsNotDistinct {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchEntryIdsNotDistinct")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchEntryIdsNotDistinct {}
/// See [`BatchEntryIdsNotDistinct`](crate::error::BatchEntryIdsNotDistinct)
pub mod batch_entry_ids_not_distinct {
    /// A builder for [`BatchEntryIdsNotDistinct`](crate::error::BatchEntryIdsNotDistinct)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEntryIdsNotDistinct`](crate::error::BatchEntryIdsNotDistinct)
        pub fn build(self) -> crate::error::BatchEntryIdsNotDistinct {
            crate::error::BatchEntryIdsNotDistinct {
                message: self.message,
            }
        }
    }
}
impl BatchEntryIdsNotDistinct {
    /// Creates a new builder-style object to manufacture [`BatchEntryIdsNotDistinct`](crate::error::BatchEntryIdsNotDistinct)
    pub fn builder() -> crate::error::batch_entry_ids_not_distinct::Builder {
        crate::error::batch_entry_ids_not_distinct::Builder::default()
    }
}

/// <p>The message contains characters outside the allowed set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidMessageContents {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidMessageContents {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidMessageContents");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidMessageContents {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidMessageContents {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidMessageContents")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidMessageContents {}
/// See [`InvalidMessageContents`](crate::error::InvalidMessageContents)
pub mod invalid_message_contents {
    /// A builder for [`InvalidMessageContents`](crate::error::InvalidMessageContents)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidMessageContents`](crate::error::InvalidMessageContents)
        pub fn build(self) -> crate::error::InvalidMessageContents {
            crate::error::InvalidMessageContents {
                message: self.message,
            }
        }
    }
}
impl InvalidMessageContents {
    /// Creates a new builder-style object to manufacture [`InvalidMessageContents`](crate::error::InvalidMessageContents)
    pub fn builder() -> crate::error::invalid_message_contents::Builder {
        crate::error::invalid_message_contents::Builder::default()
    }
}

/// <p>The specified action violates a limit. For example, <code>ReceiveMessage</code>
/// returns this error if the maximum number of inflight messages is reached and
/// <code>AddPermission</code> returns this error if the maximum number of permissions
/// for the queue is reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OverLimit {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OverLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OverLimit");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OverLimit {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OverLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OverLimit")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for OverLimit {}
/// See [`OverLimit`](crate::error::OverLimit)
pub mod over_limit {
    /// A builder for [`OverLimit`](crate::error::OverLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OverLimit`](crate::error::OverLimit)
        pub fn build(self) -> crate::error::OverLimit {
            crate::error::OverLimit {
                message: self.message,
            }
        }
    }
}
impl OverLimit {
    /// Creates a new builder-style object to manufacture [`OverLimit`](crate::error::OverLimit)
    pub fn builder() -> crate::error::over_limit::Builder {
        crate::error::over_limit::Builder::default()
    }
}

/// <p>The specified queue doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueDoesNotExist {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueueDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueDoesNotExist");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl QueueDoesNotExist {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QueueDoesNotExist {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QueueDoesNotExist")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for QueueDoesNotExist {}
/// See [`QueueDoesNotExist`](crate::error::QueueDoesNotExist)
pub mod queue_does_not_exist {
    /// A builder for [`QueueDoesNotExist`](crate::error::QueueDoesNotExist)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueDoesNotExist`](crate::error::QueueDoesNotExist)
        pub fn build(self) -> crate::error::QueueDoesNotExist {
            crate::error::QueueDoesNotExist {
                message: self.message,
            }
        }
    }
}
impl QueueDoesNotExist {
    /// Creates a new builder-style object to manufacture [`QueueDoesNotExist`](crate::error::QueueDoesNotExist)
    pub fn builder() -> crate::error::queue_does_not_exist::Builder {
        crate::error::queue_does_not_exist::Builder::default()
    }
}

/// <p>Indicates that the specified queue previously received a <code>PurgeQueue</code> request within the last 60 seconds (the time it can take to delete the messages in the queue).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurgeQueueInProgress {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PurgeQueueInProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurgeQueueInProgress");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PurgeQueueInProgress {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PurgeQueueInProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PurgeQueueInProgress")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for PurgeQueueInProgress {}
/// See [`PurgeQueueInProgress`](crate::error::PurgeQueueInProgress)
pub mod purge_queue_in_progress {
    /// A builder for [`PurgeQueueInProgress`](crate::error::PurgeQueueInProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PurgeQueueInProgress`](crate::error::PurgeQueueInProgress)
        pub fn build(self) -> crate::error::PurgeQueueInProgress {
            crate::error::PurgeQueueInProgress {
                message: self.message,
            }
        }
    }
}
impl PurgeQueueInProgress {
    /// Creates a new builder-style object to manufacture [`PurgeQueueInProgress`](crate::error::PurgeQueueInProgress)
    pub fn builder() -> crate::error::purge_queue_in_progress::Builder {
        crate::error::purge_queue_in_progress::Builder::default()
    }
}

/// <p>The specified receipt handle isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceiptHandleIsInvalid {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReceiptHandleIsInvalid {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceiptHandleIsInvalid");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReceiptHandleIsInvalid {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReceiptHandleIsInvalid {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReceiptHandleIsInvalid")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReceiptHandleIsInvalid {}
/// See [`ReceiptHandleIsInvalid`](crate::error::ReceiptHandleIsInvalid)
pub mod receipt_handle_is_invalid {
    /// A builder for [`ReceiptHandleIsInvalid`](crate::error::ReceiptHandleIsInvalid)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceiptHandleIsInvalid`](crate::error::ReceiptHandleIsInvalid)
        pub fn build(self) -> crate::error::ReceiptHandleIsInvalid {
            crate::error::ReceiptHandleIsInvalid {
                message: self.message,
            }
        }
    }
}
impl ReceiptHandleIsInvalid {
    /// Creates a new builder-style object to manufacture [`ReceiptHandleIsInvalid`](crate::error::ReceiptHandleIsInvalid)
    pub fn builder() -> crate::error::receipt_handle_is_invalid::Builder {
        crate::error::receipt_handle_is_invalid::Builder::default()
    }
}

/// <p>The specified receipt handle isn't valid for the current version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidIdFormat {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidIdFormat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidIdFormat");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidIdFormat {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidIdFormat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidIdFormat")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidIdFormat {}
/// See [`InvalidIdFormat`](crate::error::InvalidIdFormat)
pub mod invalid_id_format {
    /// A builder for [`InvalidIdFormat`](crate::error::InvalidIdFormat)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidIdFormat`](crate::error::InvalidIdFormat)
        pub fn build(self) -> crate::error::InvalidIdFormat {
            crate::error::InvalidIdFormat {
                message: self.message,
            }
        }
    }
}
impl InvalidIdFormat {
    /// Creates a new builder-style object to manufacture [`InvalidIdFormat`](crate::error::InvalidIdFormat)
    pub fn builder() -> crate::error::invalid_id_format::Builder {
        crate::error::invalid_id_format::Builder::default()
    }
}

/// <p>A queue with this name already exists. Amazon SQS returns this error only if the request
/// includes attributes whose values differ from those of the existing queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueNameExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueueNameExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueNameExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl QueueNameExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QueueNameExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QueueNameExists")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for QueueNameExists {}
/// See [`QueueNameExists`](crate::error::QueueNameExists)
pub mod queue_name_exists {
    /// A builder for [`QueueNameExists`](crate::error::QueueNameExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueNameExists`](crate::error::QueueNameExists)
        pub fn build(self) -> crate::error::QueueNameExists {
            crate::error::QueueNameExists {
                message: self.message,
            }
        }
    }
}
impl QueueNameExists {
    /// Creates a new builder-style object to manufacture [`QueueNameExists`](crate::error::QueueNameExists)
    pub fn builder() -> crate::error::queue_name_exists::Builder {
        crate::error::queue_name_exists::Builder::default()
    }
}

/// <p>You must wait 60 seconds after deleting a queue before you can create another queue
/// with the same name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueDeletedRecently {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueueDeletedRecently {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueDeletedRecently");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl QueueDeletedRecently {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QueueDeletedRecently {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QueueDeletedRecently")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for QueueDeletedRecently {}
/// See [`QueueDeletedRecently`](crate::error::QueueDeletedRecently)
pub mod queue_deleted_recently {
    /// A builder for [`QueueDeletedRecently`](crate::error::QueueDeletedRecently)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueDeletedRecently`](crate::error::QueueDeletedRecently)
        pub fn build(self) -> crate::error::QueueDeletedRecently {
            crate::error::QueueDeletedRecently {
                message: self.message,
            }
        }
    }
}
impl QueueDeletedRecently {
    /// Creates a new builder-style object to manufacture [`QueueDeletedRecently`](crate::error::QueueDeletedRecently)
    pub fn builder() -> crate::error::queue_deleted_recently::Builder {
        crate::error::queue_deleted_recently::Builder::default()
    }
}

/// <p>The specified message isn't in flight.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageNotInflight {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MessageNotInflight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageNotInflight");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MessageNotInflight {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MessageNotInflight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MessageNotInflight")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for MessageNotInflight {}
/// See [`MessageNotInflight`](crate::error::MessageNotInflight)
pub mod message_not_inflight {
    /// A builder for [`MessageNotInflight`](crate::error::MessageNotInflight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageNotInflight`](crate::error::MessageNotInflight)
        pub fn build(self) -> crate::error::MessageNotInflight {
            crate::error::MessageNotInflight {
                message: self.message,
            }
        }
    }
}
impl MessageNotInflight {
    /// Creates a new builder-style object to manufacture [`MessageNotInflight`](crate::error::MessageNotInflight)
    pub fn builder() -> crate::error::message_not_inflight::Builder {
        crate::error::message_not_inflight::Builder::default()
    }
}
