// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_over_limit_xml_err(
    inp: &[u8],
    mut builder: crate::error::over_limit::Builder,
) -> Result<crate::error::over_limit::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#OverLimit$message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_message_not_inflight_xml_err(
    inp: &[u8],
    mut builder: crate::error::message_not_inflight::Builder,
) -> Result<crate::error::message_not_inflight::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#MessageNotInflight$message */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_receipt_handle_is_invalid_xml_err(
    inp: &[u8],
    mut builder: crate::error::receipt_handle_is_invalid::Builder,
) -> Result<crate::error::receipt_handle_is_invalid::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#ReceiptHandleIsInvalid$message */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_batch_entry_ids_not_distinct_xml_err(
    inp: &[u8],
    mut builder: crate::error::batch_entry_ids_not_distinct::Builder,
) -> Result<crate::error::batch_entry_ids_not_distinct::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#BatchEntryIdsNotDistinct$message */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_4);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_empty_batch_request_xml_err(
    inp: &[u8],
    mut builder: crate::error::empty_batch_request::Builder,
) -> Result<crate::error::empty_batch_request::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#EmptyBatchRequest$message */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_5);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_batch_entry_id_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_batch_entry_id::Builder,
) -> Result<crate::error::invalid_batch_entry_id::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#InvalidBatchEntryId$message */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_entries_in_batch_request_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_entries_in_batch_request::Builder,
) -> Result<
    crate::error::too_many_entries_in_batch_request::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#TooManyEntriesInBatchRequest$message */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_change_message_visibility_batch(
    inp: &[u8],
    mut builder: crate::output::change_message_visibility_batch_output::Builder,
) -> Result<
    crate::output::change_message_visibility_batch_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ChangeMessageVisibilityBatchResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ChangeMessageVisibilityBatchResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ChangeMessageVisibilityBatchResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ChangeMessageVisibilityBatchResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ChangeMessageVisibilityBatchResultEntry") /* Successful com.amazonaws.sqs.synthetic#ChangeMessageVisibilityBatchOutput$Successful */ =>  {
                let var_8 =
                    Some(
                        Result::<std::vec::Vec<crate::model::ChangeMessageVisibilityBatchResultEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_9 = builder.successful.take().unwrap_or_default();
                            list_9.push(
                                crate::xml_deser::deser_structure_crate_model_change_message_visibility_batch_result_entry(&mut tag)
                                ?
                            );
                            list_9
                        })
                        ?
                    )
                ;
                builder = builder.set_successful(var_8);
            }
            ,
            s if s.matches("BatchResultErrorEntry") /* Failed com.amazonaws.sqs.synthetic#ChangeMessageVisibilityBatchOutput$Failed */ =>  {
                let var_10 =
                    Some(
                        Result::<std::vec::Vec<crate::model::BatchResultErrorEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_11 = builder.failed.take().unwrap_or_default();
                            list_11.push(
                                crate::xml_deser::deser_structure_crate_model_batch_result_error_entry(&mut tag)
                                ?
                            );
                            list_11
                        })
                        ?
                    )
                ;
                builder = builder.set_failed(var_10);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ChangeMessageVisibilityBatchResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_queue_deleted_recently_xml_err(
    inp: &[u8],
    mut builder: crate::error::queue_deleted_recently::Builder,
) -> Result<crate::error::queue_deleted_recently::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#QueueDeletedRecently$message */ =>  {
                let var_12 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_12);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_queue_name_exists_xml_err(
    inp: &[u8],
    mut builder: crate::error::queue_name_exists::Builder,
) -> Result<crate::error::queue_name_exists::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#QueueNameExists$message */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_13);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_queue(
    inp: &[u8],
    mut builder: crate::output::create_queue_output::Builder,
) -> Result<crate::output::create_queue_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateQueueResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateQueueResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateQueueResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateQueueResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("QueueUrl") /* QueueUrl com.amazonaws.sqs.synthetic#CreateQueueOutput$QueueUrl */ =>  {
                let var_14 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_queue_url(var_14);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateQueueResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_id_format_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_id_format::Builder,
) -> Result<crate::error::invalid_id_format::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#InvalidIdFormat$message */ =>  {
                let var_15 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_15);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_message_batch(
    inp: &[u8],
    mut builder: crate::output::delete_message_batch_output::Builder,
) -> Result<crate::output::delete_message_batch_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteMessageBatchResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteMessageBatchResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteMessageBatchResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteMessageBatchResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DeleteMessageBatchResultEntry") /* Successful com.amazonaws.sqs.synthetic#DeleteMessageBatchOutput$Successful */ =>  {
                let var_16 =
                    Some(
                        Result::<std::vec::Vec<crate::model::DeleteMessageBatchResultEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_17 = builder.successful.take().unwrap_or_default();
                            list_17.push(
                                crate::xml_deser::deser_structure_crate_model_delete_message_batch_result_entry(&mut tag)
                                ?
                            );
                            list_17
                        })
                        ?
                    )
                ;
                builder = builder.set_successful(var_16);
            }
            ,
            s if s.matches("BatchResultErrorEntry") /* Failed com.amazonaws.sqs.synthetic#DeleteMessageBatchOutput$Failed */ =>  {
                let var_18 =
                    Some(
                        Result::<std::vec::Vec<crate::model::BatchResultErrorEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_19 = builder.failed.take().unwrap_or_default();
                            list_19.push(
                                crate::xml_deser::deser_structure_crate_model_batch_result_error_entry(&mut tag)
                                ?
                            );
                            list_19
                        })
                        ?
                    )
                ;
                builder = builder.set_failed(var_18);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteMessageBatchResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_attribute_name_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_attribute_name::Builder,
) -> Result<crate::error::invalid_attribute_name::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#InvalidAttributeName$message */ =>  {
                let var_20 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_20);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_queue_attributes(
    inp: &[u8],
    mut builder: crate::output::get_queue_attributes_output::Builder,
) -> Result<crate::output::get_queue_attributes_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetQueueAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetQueueAttributesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetQueueAttributesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetQueueAttributesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Attribute") /* Attributes com.amazonaws.sqs.synthetic#GetQueueAttributesOutput$Attributes */ =>  {
                let var_21 =
                    Some(
                        Result::<std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut map_22 = builder.attributes.take().unwrap_or_default();
                                            crate::xml_deser::deser_map_com_amazonaws_sqs_queue_attribute_map_entry(&mut tag, &mut map_22)?;
                                            map_22
                        })
                        ?
                    )
                ;
                builder = builder.set_attributes(var_21);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetQueueAttributesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_queue_does_not_exist_xml_err(
    inp: &[u8],
    mut builder: crate::error::queue_does_not_exist::Builder,
) -> Result<crate::error::queue_does_not_exist::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#QueueDoesNotExist$message */ =>  {
                let var_23 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_23);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_queue_url(
    inp: &[u8],
    mut builder: crate::output::get_queue_url_output::Builder,
) -> Result<crate::output::get_queue_url_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetQueueUrlResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetQueueUrlResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetQueueUrlResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetQueueUrlResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("QueueUrl") /* QueueUrl com.amazonaws.sqs.synthetic#GetQueueUrlOutput$QueueUrl */ =>  {
                let var_24 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_queue_url(var_24);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetQueueUrlResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_dead_letter_source_queues(
    inp: &[u8],
    mut builder: crate::output::list_dead_letter_source_queues_output::Builder,
) -> Result<
    crate::output::list_dead_letter_source_queues_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListDeadLetterSourceQueuesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListDeadLetterSourceQueuesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListDeadLetterSourceQueuesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListDeadLetterSourceQueuesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("QueueUrl") /* queueUrls com.amazonaws.sqs.synthetic#ListDeadLetterSourceQueuesOutput$queueUrls */ =>  {
                let var_25 =
                    Some(
                        Result::<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_26 = builder.queue_urls.take().unwrap_or_default();
                            list_26.push(
                                Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    .into()
                                )
                                ?
                            );
                            list_26
                        })
                        ?
                    )
                ;
                builder = builder.set_queue_urls(var_25);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.sqs.synthetic#ListDeadLetterSourceQueuesOutput$NextToken */ =>  {
                let var_27 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_27);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListDeadLetterSourceQueuesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_queues(
    inp: &[u8],
    mut builder: crate::output::list_queues_output::Builder,
) -> Result<crate::output::list_queues_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListQueuesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListQueuesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListQueuesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListQueuesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("NextToken") /* NextToken com.amazonaws.sqs.synthetic#ListQueuesOutput$NextToken */ =>  {
                let var_28 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_28);
            }
            ,
            s if s.matches("QueueUrl") /* QueueUrls com.amazonaws.sqs.synthetic#ListQueuesOutput$QueueUrls */ =>  {
                let var_29 =
                    Some(
                        Result::<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_30 = builder.queue_urls.take().unwrap_or_default();
                            list_30.push(
                                Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    .into()
                                )
                                ?
                            );
                            list_30
                        })
                        ?
                    )
                ;
                builder = builder.set_queue_urls(var_29);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListQueuesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_queue_tags(
    inp: &[u8],
    mut builder: crate::output::list_queue_tags_output::Builder,
) -> Result<crate::output::list_queue_tags_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListQueueTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListQueueTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListQueueTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListQueueTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tag") /* Tags com.amazonaws.sqs.synthetic#ListQueueTagsOutput$Tags */ =>  {
                let var_31 =
                    Some(
                        Result::<std::collections::HashMap<std::string::String, std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut map_32 = builder.tags.take().unwrap_or_default();
                                            crate::xml_deser::deser_map_com_amazonaws_sqs_tag_map_entry(&mut tag, &mut map_32)?;
                                            map_32
                        })
                        ?
                    )
                ;
                builder = builder.set_tags(var_31);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListQueueTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_purge_queue_in_progress_xml_err(
    inp: &[u8],
    mut builder: crate::error::purge_queue_in_progress::Builder,
) -> Result<crate::error::purge_queue_in_progress::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#PurgeQueueInProgress$message */ =>  {
                let var_33 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_33);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_receive_message(
    inp: &[u8],
    mut builder: crate::output::receive_message_output::Builder,
) -> Result<crate::output::receive_message_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReceiveMessageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReceiveMessageResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ReceiveMessageResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ReceiveMessageResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Message") /* Messages com.amazonaws.sqs.synthetic#ReceiveMessageOutput$Messages */ =>  {
                let var_34 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Message>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_35 = builder.messages.take().unwrap_or_default();
                            list_35.push(
                                crate::xml_deser::deser_structure_crate_model_message(&mut tag)
                                ?
                            );
                            list_35
                        })
                        ?
                    )
                ;
                builder = builder.set_messages(var_34);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ReceiveMessageResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_message_contents_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_message_contents::Builder,
) -> Result<crate::error::invalid_message_contents::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#InvalidMessageContents$message */ =>  {
                let var_36 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_36);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unsupported_operation_xml_err(
    inp: &[u8],
    mut builder: crate::error::unsupported_operation::Builder,
) -> Result<crate::error::unsupported_operation::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#UnsupportedOperation$message */ =>  {
                let var_37 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_37);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_message(
    inp: &[u8],
    mut builder: crate::output::send_message_output::Builder,
) -> Result<crate::output::send_message_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendMessageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendMessageResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendMessageResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendMessageResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MD5OfMessageBody") /* MD5OfMessageBody com.amazonaws.sqs.synthetic#SendMessageOutput$MD5OfMessageBody */ =>  {
                let var_38 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_message_body(var_38);
            }
            ,
            s if s.matches("MD5OfMessageAttributes") /* MD5OfMessageAttributes com.amazonaws.sqs.synthetic#SendMessageOutput$MD5OfMessageAttributes */ =>  {
                let var_39 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_message_attributes(var_39);
            }
            ,
            s if s.matches("MD5OfMessageSystemAttributes") /* MD5OfMessageSystemAttributes com.amazonaws.sqs.synthetic#SendMessageOutput$MD5OfMessageSystemAttributes */ =>  {
                let var_40 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_message_system_attributes(var_40);
            }
            ,
            s if s.matches("MessageId") /* MessageId com.amazonaws.sqs.synthetic#SendMessageOutput$MessageId */ =>  {
                let var_41 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_41);
            }
            ,
            s if s.matches("SequenceNumber") /* SequenceNumber com.amazonaws.sqs.synthetic#SendMessageOutput$SequenceNumber */ =>  {
                let var_42 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_sequence_number(var_42);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendMessageResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_batch_request_too_long_xml_err(
    inp: &[u8],
    mut builder: crate::error::batch_request_too_long::Builder,
) -> Result<crate::error::batch_request_too_long::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.sqs#BatchRequestTooLong$message */ =>  {
                let var_43 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_43);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_send_message_batch(
    inp: &[u8],
    mut builder: crate::output::send_message_batch_output::Builder,
) -> Result<crate::output::send_message_batch_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SendMessageBatchResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SendMessageBatchResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SendMessageBatchResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SendMessageBatchResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SendMessageBatchResultEntry") /* Successful com.amazonaws.sqs.synthetic#SendMessageBatchOutput$Successful */ =>  {
                let var_44 =
                    Some(
                        Result::<std::vec::Vec<crate::model::SendMessageBatchResultEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_45 = builder.successful.take().unwrap_or_default();
                            list_45.push(
                                crate::xml_deser::deser_structure_crate_model_send_message_batch_result_entry(&mut tag)
                                ?
                            );
                            list_45
                        })
                        ?
                    )
                ;
                builder = builder.set_successful(var_44);
            }
            ,
            s if s.matches("BatchResultErrorEntry") /* Failed com.amazonaws.sqs.synthetic#SendMessageBatchOutput$Failed */ =>  {
                let var_46 =
                    Some(
                        Result::<std::vec::Vec<crate::model::BatchResultErrorEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_47 = builder.failed.take().unwrap_or_default();
                            list_47.push(
                                crate::xml_deser::deser_structure_crate_model_batch_result_error_entry(&mut tag)
                                ?
                            );
                            list_47
                        })
                        ?
                    )
                ;
                builder = builder.set_failed(var_46);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SendMessageBatchResult tag",
        ));
    };
    Ok(builder)
}

pub fn deser_structure_crate_model_change_message_visibility_batch_result_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ChangeMessageVisibilityBatchResultEntry, aws_smithy_xml::decode::XmlError>
{
    #[allow(unused_mut)]
    let mut builder = crate::model::ChangeMessageVisibilityBatchResultEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.sqs#ChangeMessageVisibilityBatchResultEntry$Id */ =>  {
                let var_48 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_48);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_batch_result_error_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::BatchResultErrorEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::BatchResultErrorEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.sqs#BatchResultErrorEntry$Id */ =>  {
                let var_49 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_49);
            }
            ,
            s if s.matches("SenderFault") /* SenderFault com.amazonaws.sqs#BatchResultErrorEntry$SenderFault */ =>  {
                let var_50 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.sqs#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sender_fault(var_50);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.sqs#BatchResultErrorEntry$Code */ =>  {
                let var_51 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_51);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.sqs#BatchResultErrorEntry$Message */ =>  {
                let var_52 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_52);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_delete_message_batch_result_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeleteMessageBatchResultEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeleteMessageBatchResultEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.sqs#DeleteMessageBatchResultEntry$Id */ =>  {
                let var_53 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_53);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_sqs_queue_attribute_map_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<crate::model::QueueAttributeName> = None;
    let mut v: Option<std::string::String> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* key com.amazonaws.sqs#QueueAttributeMap$key */ =>  {
                k = Some(
                    Result::<crate::model::QueueAttributeName, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::QueueAttributeName::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                )
            }
            ,
            s if s.matches("Value") /* value com.amazonaws.sqs#QueueAttributeMap$value */ =>  {
                v = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_map_com_amazonaws_sqs_tag_map_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, std::string::String>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<std::string::String> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* key com.amazonaws.sqs#TagMap$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("Value") /* value com.amazonaws.sqs#TagMap$value */ =>  {
                v = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_message(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Message, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Message::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MessageId") /* MessageId com.amazonaws.sqs#Message$MessageId */ =>  {
                let var_54 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_54);
            }
            ,
            s if s.matches("ReceiptHandle") /* ReceiptHandle com.amazonaws.sqs#Message$ReceiptHandle */ =>  {
                let var_55 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_receipt_handle(var_55);
            }
            ,
            s if s.matches("MD5OfBody") /* MD5OfBody com.amazonaws.sqs#Message$MD5OfBody */ =>  {
                let var_56 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_body(var_56);
            }
            ,
            s if s.matches("Body") /* Body com.amazonaws.sqs#Message$Body */ =>  {
                let var_57 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_body(var_57);
            }
            ,
            s if s.matches("Attribute") /* Attributes com.amazonaws.sqs#Message$Attributes */ =>  {
                let var_58 =
                    Some(
                        Result::<std::collections::HashMap<crate::model::MessageSystemAttributeName, std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut map_59 = builder.attributes.take().unwrap_or_default();
                                            crate::xml_deser::deser_map_com_amazonaws_sqs_message_system_attribute_map_entry(&mut tag, &mut map_59)?;
                                            map_59
                        })
                        ?
                    )
                ;
                builder = builder.set_attributes(var_58);
            }
            ,
            s if s.matches("MD5OfMessageAttributes") /* MD5OfMessageAttributes com.amazonaws.sqs#Message$MD5OfMessageAttributes */ =>  {
                let var_60 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_message_attributes(var_60);
            }
            ,
            s if s.matches("MessageAttribute") /* MessageAttributes com.amazonaws.sqs#Message$MessageAttributes */ =>  {
                let var_61 =
                    Some(
                        Result::<std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut map_62 = builder.message_attributes.take().unwrap_or_default();
                                            crate::xml_deser::deser_map_com_amazonaws_sqs_message_body_attribute_map_entry(&mut tag, &mut map_62)?;
                                            map_62
                        })
                        ?
                    )
                ;
                builder = builder.set_message_attributes(var_61);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_send_message_batch_result_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SendMessageBatchResultEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SendMessageBatchResultEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.sqs#SendMessageBatchResultEntry$Id */ =>  {
                let var_63 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_63);
            }
            ,
            s if s.matches("MessageId") /* MessageId com.amazonaws.sqs#SendMessageBatchResultEntry$MessageId */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message_id(var_64);
            }
            ,
            s if s.matches("MD5OfMessageBody") /* MD5OfMessageBody com.amazonaws.sqs#SendMessageBatchResultEntry$MD5OfMessageBody */ =>  {
                let var_65 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_message_body(var_65);
            }
            ,
            s if s.matches("MD5OfMessageAttributes") /* MD5OfMessageAttributes com.amazonaws.sqs#SendMessageBatchResultEntry$MD5OfMessageAttributes */ =>  {
                let var_66 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_message_attributes(var_66);
            }
            ,
            s if s.matches("MD5OfMessageSystemAttributes") /* MD5OfMessageSystemAttributes com.amazonaws.sqs#SendMessageBatchResultEntry$MD5OfMessageSystemAttributes */ =>  {
                let var_67 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_md5_of_message_system_attributes(var_67);
            }
            ,
            s if s.matches("SequenceNumber") /* SequenceNumber com.amazonaws.sqs#SendMessageBatchResultEntry$SequenceNumber */ =>  {
                let var_68 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_sequence_number(var_68);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_sqs_message_system_attribute_map_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<
        crate::model::MessageSystemAttributeName,
        std::string::String,
    >,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<crate::model::MessageSystemAttributeName> = None;
    let mut v: Option<std::string::String> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* key com.amazonaws.sqs#MessageSystemAttributeMap$key */ =>  {
                k = Some(
                    Result::<crate::model::MessageSystemAttributeName, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::MessageSystemAttributeName::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                )
            }
            ,
            s if s.matches("Value") /* value com.amazonaws.sqs#MessageSystemAttributeMap$value */ =>  {
                v = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_map_com_amazonaws_sqs_message_body_attribute_map_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<crate::model::MessageAttributeValue> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* key com.amazonaws.sqs#MessageBodyAttributeMap$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("Value") /* value com.amazonaws.sqs#MessageBodyAttributeMap$value */ =>  {
                v = Some(
                    crate::xml_deser::deser_structure_crate_model_message_attribute_value(&mut tag)
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_message_attribute_value(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MessageAttributeValue, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MessageAttributeValue::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("StringValue") /* StringValue com.amazonaws.sqs#MessageAttributeValue$StringValue */ =>  {
                let var_69 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_string_value(var_69);
            }
            ,
            s if s.matches("BinaryValue") /* BinaryValue com.amazonaws.sqs#MessageAttributeValue$BinaryValue */ =>  {
                let var_70 =
                    Some(
                        aws_smithy_types::base64::decode(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|err|aws_smithy_xml::decode::XmlError::custom(format!("invalid base64: {:?}", err))).map(aws_smithy_types::Blob::new)
                        ?
                    )
                ;
                builder = builder.set_binary_value(var_70);
            }
            ,
            s if s.matches("StringListValue") /* StringListValues com.amazonaws.sqs#MessageAttributeValue$StringListValues */ =>  {
                let var_71 =
                    Some(
                        Result::<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_72 = builder.string_list_values.take().unwrap_or_default();
                            list_72.push(
                                Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    .into()
                                )
                                ?
                            );
                            list_72
                        })
                        ?
                    )
                ;
                builder = builder.set_string_list_values(var_71);
            }
            ,
            s if s.matches("BinaryListValue") /* BinaryListValues com.amazonaws.sqs#MessageAttributeValue$BinaryListValues */ =>  {
                let var_73 =
                    Some(
                        Result::<std::vec::Vec<aws_smithy_types::Blob>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_74 = builder.binary_list_values.take().unwrap_or_default();
                            list_74.push(
                                aws_smithy_types::base64::decode(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                )
                                .map_err(|err|aws_smithy_xml::decode::XmlError::custom(format!("invalid base64: {:?}", err))).map(aws_smithy_types::Blob::new)
                                ?
                            );
                            list_74
                        })
                        ?
                    )
                ;
                builder = builder.set_binary_list_values(var_73);
            }
            ,
            s if s.matches("DataType") /* DataType com.amazonaws.sqs#MessageAttributeValue$DataType */ =>  {
                let var_75 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_type(var_75);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
