// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonSQS`.
///
/// This client allows ergonomic access to a `AmazonSQS`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddPermission` operation.
    ///
    /// See [`AddPermission`](crate::client::fluent_builders::AddPermission) for more information about the
    /// operation and its arguments.
    pub fn add_permission(&self) -> fluent_builders::AddPermission<C, M, R> {
        fluent_builders::AddPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ChangeMessageVisibility` operation.
    ///
    /// See [`ChangeMessageVisibility`](crate::client::fluent_builders::ChangeMessageVisibility) for more information about the
    /// operation and its arguments.
    pub fn change_message_visibility(&self) -> fluent_builders::ChangeMessageVisibility<C, M, R> {
        fluent_builders::ChangeMessageVisibility::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ChangeMessageVisibilityBatch` operation.
    ///
    /// See [`ChangeMessageVisibilityBatch`](crate::client::fluent_builders::ChangeMessageVisibilityBatch) for more information about the
    /// operation and its arguments.
    pub fn change_message_visibility_batch(
        &self,
    ) -> fluent_builders::ChangeMessageVisibilityBatch<C, M, R> {
        fluent_builders::ChangeMessageVisibilityBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateQueue` operation.
    ///
    /// See [`CreateQueue`](crate::client::fluent_builders::CreateQueue) for more information about the
    /// operation and its arguments.
    pub fn create_queue(&self) -> fluent_builders::CreateQueue<C, M, R> {
        fluent_builders::CreateQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMessage` operation.
    ///
    /// See [`DeleteMessage`](crate::client::fluent_builders::DeleteMessage) for more information about the
    /// operation and its arguments.
    pub fn delete_message(&self) -> fluent_builders::DeleteMessage<C, M, R> {
        fluent_builders::DeleteMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMessageBatch` operation.
    ///
    /// See [`DeleteMessageBatch`](crate::client::fluent_builders::DeleteMessageBatch) for more information about the
    /// operation and its arguments.
    pub fn delete_message_batch(&self) -> fluent_builders::DeleteMessageBatch<C, M, R> {
        fluent_builders::DeleteMessageBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQueue` operation.
    ///
    /// See [`DeleteQueue`](crate::client::fluent_builders::DeleteQueue) for more information about the
    /// operation and its arguments.
    pub fn delete_queue(&self) -> fluent_builders::DeleteQueue<C, M, R> {
        fluent_builders::DeleteQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQueueAttributes` operation.
    ///
    /// See [`GetQueueAttributes`](crate::client::fluent_builders::GetQueueAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_queue_attributes(&self) -> fluent_builders::GetQueueAttributes<C, M, R> {
        fluent_builders::GetQueueAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQueueUrl` operation.
    ///
    /// See [`GetQueueUrl`](crate::client::fluent_builders::GetQueueUrl) for more information about the
    /// operation and its arguments.
    pub fn get_queue_url(&self) -> fluent_builders::GetQueueUrl<C, M, R> {
        fluent_builders::GetQueueUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeadLetterSourceQueues` operation.
    ///
    /// See [`ListDeadLetterSourceQueues`](crate::client::fluent_builders::ListDeadLetterSourceQueues) for more information about the
    /// operation and its arguments.
    pub fn list_dead_letter_source_queues(
        &self,
    ) -> fluent_builders::ListDeadLetterSourceQueues<C, M, R> {
        fluent_builders::ListDeadLetterSourceQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQueues` operation.
    ///
    /// See [`ListQueues`](crate::client::fluent_builders::ListQueues) for more information about the
    /// operation and its arguments.
    pub fn list_queues(&self) -> fluent_builders::ListQueues<C, M, R> {
        fluent_builders::ListQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQueueTags` operation.
    ///
    /// See [`ListQueueTags`](crate::client::fluent_builders::ListQueueTags) for more information about the
    /// operation and its arguments.
    pub fn list_queue_tags(&self) -> fluent_builders::ListQueueTags<C, M, R> {
        fluent_builders::ListQueueTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurgeQueue` operation.
    ///
    /// See [`PurgeQueue`](crate::client::fluent_builders::PurgeQueue) for more information about the
    /// operation and its arguments.
    pub fn purge_queue(&self) -> fluent_builders::PurgeQueue<C, M, R> {
        fluent_builders::PurgeQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReceiveMessage` operation.
    ///
    /// See [`ReceiveMessage`](crate::client::fluent_builders::ReceiveMessage) for more information about the
    /// operation and its arguments.
    pub fn receive_message(&self) -> fluent_builders::ReceiveMessage<C, M, R> {
        fluent_builders::ReceiveMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemovePermission` operation.
    ///
    /// See [`RemovePermission`](crate::client::fluent_builders::RemovePermission) for more information about the
    /// operation and its arguments.
    pub fn remove_permission(&self) -> fluent_builders::RemovePermission<C, M, R> {
        fluent_builders::RemovePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendMessage` operation.
    ///
    /// See [`SendMessage`](crate::client::fluent_builders::SendMessage) for more information about the
    /// operation and its arguments.
    pub fn send_message(&self) -> fluent_builders::SendMessage<C, M, R> {
        fluent_builders::SendMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendMessageBatch` operation.
    ///
    /// See [`SendMessageBatch`](crate::client::fluent_builders::SendMessageBatch) for more information about the
    /// operation and its arguments.
    pub fn send_message_batch(&self) -> fluent_builders::SendMessageBatch<C, M, R> {
        fluent_builders::SendMessageBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetQueueAttributes` operation.
    ///
    /// See [`SetQueueAttributes`](crate::client::fluent_builders::SetQueueAttributes) for more information about the
    /// operation and its arguments.
    pub fn set_queue_attributes(&self) -> fluent_builders::SetQueueAttributes<C, M, R> {
        fluent_builders::SetQueueAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagQueue` operation.
    ///
    /// See [`TagQueue`](crate::client::fluent_builders::TagQueue) for more information about the
    /// operation and its arguments.
    pub fn tag_queue(&self) -> fluent_builders::TagQueue<C, M, R> {
        fluent_builders::TagQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagQueue` operation.
    ///
    /// See [`UntagQueue`](crate::client::fluent_builders::UntagQueue) for more information about the
    /// operation and its arguments.
    pub fn untag_queue(&self) -> fluent_builders::UntagQueue<C, M, R> {
        fluent_builders::UntagQueue::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddPermission`.
    ///
    /// <p>Adds a permission to a queue for a specific
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principal</a>.
    /// This allows sharing access to the queue.</p>
    /// <p>When you create a queue, you have full control access rights for the queue.
    /// Only you, the owner of the queue, can grant or deny permissions to the queue.
    /// For more information about these permissions, see
    /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue">Allow
    /// Developers to Write Messages to a Shared Queue</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AddPermission</code> generates a policy for you. You can use
    /// <code>
    /// <a>SetQueueAttributes</a>
    /// </code> to
    /// upload your policy. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-creating-custom-policies.html">Using Custom Policies with the Amazon SQS Access Policy Language</a> in
    /// the <i>Amazon SQS Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>An Amazon SQS policy can have a maximum of 7 actions.</p>
    /// </li>
    /// <li>
    /// <p>To remove the ability to change queue permissions, you must deny permission to the <code>AddPermission</code>, <code>RemovePermission</code>, and <code>SetQueueAttributes</code> actions in your IAM policy.</p>
    /// </li>
    /// </ul>
    /// </note>
    /// <p>Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values of <code>n</code> are integers starting from 1. For example, a parameter list with two elements looks like this:</p>
    /// <p>
    /// <code>&AttributeName.1=first</code>
    /// </p>
    /// <p>
    /// <code>&AttributeName.2=second</code>
    /// </p>
    /// <note>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AddPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_permission_input::Builder,
    }
    impl<C, M, R> AddPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddPermissionInputOperationOutputAlias,
                crate::output::AddPermissionOutput,
                crate::error::AddPermissionError,
                crate::input::AddPermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue to which permissions are added.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue to which permissions are added.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// <p>The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>). Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
        pub fn label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(inp);
            self
        }
        /// <p>The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>). Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
        /// Appends an item to `AWSAccountIds`.
        ///
        /// To override the contents of this collection use [`set_aws_account_ids`](Self::set_aws_account_ids).
        ///
        /// <p>The account numbers of the <a href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to receive
        /// permission. For information about locating the account identification, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication">Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer
        /// Guide</i>.</p>
        pub fn aws_account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_ids(inp);
            self
        }
        /// <p>The account numbers of the <a href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to receive
        /// permission. For information about locating the account identification, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication">Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer
        /// Guide</i>.</p>
        pub fn set_aws_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_ids(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The action the client wants to allow for the specified principal. Valid values: the name of any action or <code>*</code>.</p>
        /// <p>For more information about these actions, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html">Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <p>Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions: <code>SendMessageBatch</code>,
        /// <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.</p>
        pub fn actions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>The action the client wants to allow for the specified principal. Valid values: the name of any action or <code>*</code>.</p>
        /// <p>For more information about these actions, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html">Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <p>Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions: <code>SendMessageBatch</code>,
        /// <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangeMessageVisibility`.
    ///
    /// <p>Changes the visibility timeout of a specified message in a queue to a new value. The
    /// default visibility timeout for a message is 30 seconds. The minimum is 0 seconds. The
    /// maximum is 12 hours. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <p>For example, you have a message with a visibility timeout of 5 minutes. After 3
    /// minutes, you call <code>ChangeMessageVisibility</code> with a timeout of 10 minutes. You
    /// can continue to call <code>ChangeMessageVisibility</code> to extend the visibility
    /// timeout to the maximum allowed time. If you try to extend the visibility timeout beyond
    /// the maximum, your request is rejected.</p>
    /// <p>An Amazon SQS message has three basic states:</p>
    /// <ol>
    /// <li>
    /// <p>Sent to a queue by a producer.</p>
    /// </li>
    /// <li>
    /// <p>Received from the queue by a consumer.</p>
    /// </li>
    /// <li>
    /// <p>Deleted from the queue.</p>
    /// </li>
    /// </ol>
    /// <p>A message is considered to be <i>stored</i> after it is sent to a queue by a producer, but not yet received from the queue by a consumer (that is, between states 1 and 2). There is no limit to the number of stored messages.
    /// A message is considered to be <i>in flight</i> after it is received from a queue by a consumer, but not yet deleted from the queue (that is, between states 2 and 3). There is a limit to the number of inflight messages.</p>
    /// <p>Limits that apply to inflight messages are unrelated to the <i>unlimited</i> number of stored messages.</p>
    /// <p>For most standard queues (depending on queue traffic and message backlog), there can be a maximum of approximately 120,000 inflight messages (received from a queue by a consumer, but not yet deleted from the queue).
    /// If you reach this limit, Amazon SQS returns the <code>OverLimit</code> error message.
    /// To avoid reaching the limit, you should delete messages from the queue after they're processed. You can also increase the number of queues you use to process your messages.
    /// To request a limit increase, <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sqs">file a support request</a>.</p>
    /// <p>For FIFO queues, there can be a maximum of 20,000 inflight messages (received from a queue by a consumer, but not yet deleted from the queue). If you reach this limit, Amazon SQS returns no error messages.</p>
    ///
    /// <important>
    /// <p>If you attempt to set the <code>VisibilityTimeout</code> to a value greater than the maximum time left, Amazon SQS returns an error. Amazon SQS doesn't automatically recalculate and increase the timeout to the maximum remaining time.</p>
    /// <p>Unlike with a queue, when you change the visibility timeout for a specific message the timeout value is applied immediately but isn't saved in memory for that message. If you don't delete a message after it is received, the visibility timeout
    /// for the message reverts to the original timeout value (not to the value you set using the <code>ChangeMessageVisibility</code> action) the next time the message is received.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct ChangeMessageVisibility<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::change_message_visibility_input::Builder,
    }
    impl<C, M, R> ChangeMessageVisibility<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChangeMessageVisibility`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeMessageVisibilityOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeMessageVisibilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChangeMessageVisibilityInputOperationOutputAlias,
                crate::output::ChangeMessageVisibilityOutput,
                crate::error::ChangeMessageVisibilityError,
                crate::input::ChangeMessageVisibilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue whose message's visibility is changed.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue whose message's visibility is changed.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// <p>The receipt handle associated with the message whose visibility timeout is changed. This parameter is returned by the <code>
        /// <a>ReceiveMessage</a>
        /// </code> action.</p>
        pub fn receipt_handle(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.receipt_handle(inp);
            self
        }
        /// <p>The receipt handle associated with the message whose visibility timeout is changed. This parameter is returned by the <code>
        /// <a>ReceiveMessage</a>
        /// </code> action.</p>
        pub fn set_receipt_handle(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_receipt_handle(input);
            self
        }
        /// <p>The new value for the message's visibility timeout (in seconds). Values range: <code>0</code> to <code>43200</code>. Maximum: 12 hours.</p>
        pub fn visibility_timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.visibility_timeout(inp);
            self
        }
        /// <p>The new value for the message's visibility timeout (in seconds). Values range: <code>0</code> to <code>43200</code>. Maximum: 12 hours.</p>
        pub fn set_visibility_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_visibility_timeout(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangeMessageVisibilityBatch`.
    ///
    /// <p>Changes the visibility timeout of multiple messages. This is a batch version of <code>
    /// <a>ChangeMessageVisibility</a>.</code> The result of the action on each message is reported individually in the response.
    /// You can send up to 10 <code>
    /// <a>ChangeMessageVisibility</a>
    /// </code> requests with each <code>ChangeMessageVisibilityBatch</code> action.</p>   
    /// <important>
    /// <p>Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of <code>200</code>.</p>
    /// </important>
    /// <p>Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values of <code>n</code> are integers starting from 1. For example, a parameter list with two elements looks like this:</p>
    /// <p>
    /// <code>&AttributeName.1=first</code>
    /// </p>
    /// <p>
    /// <code>&AttributeName.2=second</code>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ChangeMessageVisibilityBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::change_message_visibility_batch_input::Builder,
    }
    impl<C, M, R> ChangeMessageVisibilityBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChangeMessageVisibilityBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeMessageVisibilityBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeMessageVisibilityBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChangeMessageVisibilityBatchInputOperationOutputAlias,
                crate::output::ChangeMessageVisibilityBatchOutput,
                crate::error::ChangeMessageVisibilityBatchError,
                crate::input::ChangeMessageVisibilityBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue whose messages' visibility is changed.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue whose messages' visibility is changed.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of receipt handles of the messages for which the visibility timeout must be changed.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::ChangeMessageVisibilityBatchRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>A list of receipt handles of the messages for which the visibility timeout must be changed.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ChangeMessageVisibilityBatchRequestEntry>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQueue`.
    ///
    /// <p>Creates a new standard or FIFO queue. You can pass one or more attributes in
    /// the request. Keep the following in mind:</p>
    /// <ul>
    /// <li>
    /// <p>If you don't specify the <code>FifoQueue</code> attribute, Amazon SQS creates a standard queue.</p>
    /// <note>
    /// <p>You can't change the queue type after you create it and you can't convert
    /// an existing standard queue into a FIFO queue. You must either create a new
    /// FIFO queue for your application or delete your existing standard queue and
    /// recreate it as a FIFO queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-moving">Moving From a Standard Queue to a FIFO Queue</a> in the
    /// <i>Amazon SQS Developer Guide</i>. </p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>If you don't provide a value for an attribute, the queue is created with the default value for the attribute.</p>
    /// </li>
    /// <li>
    /// <p>If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>To successfully create a new queue, you must provide a queue name that adheres to the <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html">limits related to queues</a> and is unique within the scope of your queues.</p>
    /// <note>
    /// <p>After you create a queue, you must wait at least one second after the queue is
    /// created to be able to use the queue.</p>
    /// </note>
    /// <p>To get the queue URL, use the <code>
    /// <a>GetQueueUrl</a>
    /// </code> action. <code>
    /// <a>GetQueueUrl</a>
    /// </code> requires only the <code>QueueName</code> parameter.
    /// be aware of existing queue names:</p>
    /// <ul>
    /// <li>
    /// <p>If you provide the name of an existing queue along with the exact names and values of all the queue's attributes, <code>CreateQueue</code> returns the queue URL for the existing queue.</p>
    /// </li>
    /// <li>
    /// <p>If the queue name, attribute names, or attribute values don't match an existing queue, <code>CreateQueue</code> returns an error.</p>
    /// </li>
    /// </ul>
    /// <p>Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values of <code>n</code> are integers starting from 1. For example, a parameter list with two elements looks like this:</p>
    /// <p>
    /// <code>&AttributeName.1=first</code>
    /// </p>
    /// <p>
    /// <code>&AttributeName.2=second</code>
    /// </p>
    /// <note>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_queue_input::Builder,
    }
    impl<C, M, R> CreateQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQueueInputOperationOutputAlias,
                crate::output::CreateQueueOutput,
                crate::error::CreateQueueError,
                crate::input::CreateQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new queue. The following limits apply to this name:</p>
        /// <ul>
        /// <li>
        /// <p>A queue name can have up to 80 characters.</p>               
        /// </li>
        /// <li>
        /// <p>Valid values: alphanumeric characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
        /// </li>
        /// <li>
        /// <p>A FIFO queue name must end with the <code>.fifo</code> suffix.</p>
        /// </li>
        /// </ul>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_name(inp);
            self
        }
        /// <p>The name of the new queue. The following limits apply to this name:</p>
        /// <ul>
        /// <li>
        /// <p>A queue name can have up to 80 characters.</p>               
        /// </li>
        /// <li>
        /// <p>Valid values: alphanumeric characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
        /// </li>
        /// <li>
        /// <p>A FIFO queue name must end with the <code>.fifo</code> suffix.</p>
        /// </li>
        /// </ul>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Add cost allocation tags to the specified Amazon SQS queue. For an overview, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html">Tagging
        /// Your Amazon SQS Queues</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        ///
        /// <p>When you use queue tags, keep the following guidelines in mind:</p>
        /// <ul>
        /// <li>
        /// <p>Adding more than 50 tags to a queue isn't recommended.</p>
        /// </li>
        /// <li>
        /// <p>Tags don't have any semantic meaning. Amazon SQS interprets tags as character strings.</p>
        /// </li>
        /// <li>
        /// <p>Tags are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>A new tag with a key identical to that of an existing tag overwrites the existing tag.</p>
        /// </li>
        /// </ul>
        /// <p>For a full list of tag restrictions, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues">Quotas related to queues</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <note>
        /// <p>To be able to tag a queue on creation, you must have the
        /// <code>sqs:CreateQueue</code> and <code>sqs:TagQueue</code> permissions.</p>
        /// <p>Cross-account permissions don't apply to this action. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
        /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </note>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Add cost allocation tags to the specified Amazon SQS queue. For an overview, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html">Tagging
        /// Your Amazon SQS Queues</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        ///
        /// <p>When you use queue tags, keep the following guidelines in mind:</p>
        /// <ul>
        /// <li>
        /// <p>Adding more than 50 tags to a queue isn't recommended.</p>
        /// </li>
        /// <li>
        /// <p>Tags don't have any semantic meaning. Amazon SQS interprets tags as character strings.</p>
        /// </li>
        /// <li>
        /// <p>Tags are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>A new tag with a key identical to that of an existing tag overwrites the existing tag.</p>
        /// </li>
        /// </ul>
        /// <p>For a full list of tag restrictions, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues">Quotas related to queues</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <note>
        /// <p>To be able to tag a queue on creation, you must have the
        /// <code>sqs:CreateQueue</code> and <code>sqs:TagQueue</code> permissions.</p>
        /// <p>Cross-account permissions don't apply to this action. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
        /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request parameters that the <code>CreateQueue</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DelaySeconds</code> – The length of time, in seconds, for which the delivery of all messages in the queue is delayed. Valid values: An integer from 0 to 900 seconds (15 minutes). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaximumMessageSize</code> – The limit of how many bytes a message can contain before Amazon SQS rejects it. Valid values: An integer from 1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). Default: 262,144 (256 KiB).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRetentionPeriod</code> – The length of time, in seconds, for which Amazon SQS retains a message. Valid values: An integer from 60 seconds (1 minute) to 1,209,600 seconds (14 days). Default: 345,600 (4 days).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The queue's policy. A valid Amazon Web Services policy. For more information about policy structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PoliciesOverview.html">Overview of Amazon Web Services IAM Policies</a> in the <i>Amazon IAM User Guide</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessageWaitTimeSeconds</code> – The length of time, in seconds, for which a <code>
        /// <a>ReceiveMessage</a>
        /// </code> action waits for a message to arrive. Valid values: An integer from 0 to 20 (seconds). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityTimeout</code> – The visibility timeout for the queue, in seconds. Valid values: An integer from 0 to 43,200 (12 hours). Default: 30. For more information about the visibility timeout, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">dead-letter queues:</a>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
        /// of the source queue as a JSON object. The parameters are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to
        /// which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
        /// moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code>
        /// for a queue, Amazon SQS moves the message to the dead-letter-queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
        /// queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters are as follows:</p>              
        /// <ul>
        /// <li>
        /// <p>
        /// <code>redrivePermission</code> – The permission type that defines which source queues can
        /// specify the current queue as the dead-letter queue. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
        /// specify this queue as the dead-letter queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>denyAll</code> – No source queues can specify this queue as the dead-letter
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
        /// this queue as the dead-letter queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
        /// this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
        /// <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue ARNs.
        /// To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter
        /// to <code>allowAll</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The dead-letter queue of a
        /// FIFO queue must also be a FIFO queue. Similarly, the dead-letter
        /// queue of a standard queue must also be a standard queue.</p>
        /// </note>
        ///
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">server-side-encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SQS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms">Key Terms</a>.
        /// While the alias of the Amazon Web Services managed CMK for Amazon SQS is always <code>alias/aws/sqs</code>, the alias of a custom CMK can, for example, be <code>alias/<i>MyAlias</i>
        /// </code>.
        /// For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API Reference</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsDataKeyReusePeriodSeconds</code> – The length of time, in seconds, for which Amazon SQS can reuse a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys">data key</a> to encrypt
        /// or decrypt messages before calling KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). Default: 300 (5 minutes). A shorter time period provides better security
        /// but results in more calls to KMS which might incur charges after Free Tier. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">How Does the Data Key Reuse Period Work?</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO (first-in-first-out) queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FifoQueue</code> – Designates a queue as FIFO. Valid values are <code>true</code> and <code>false</code>. If you don't specify the <code>FifoQueue</code> attribute, Amazon SQS creates a standard queue.
        /// You can provide this attribute only during queue creation. You can't change it for an existing queue.
        /// When you set this attribute, you must also provide the <code>MessageGroupId</code> for your messages explicitly.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html">FIFO queue logic</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication. Valid values are <code>true</code> and <code>false</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">Exactly-once processing</a> in the
        /// <i>Amazon SQS Developer Guide</i>. Note the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
        /// <ul>
        /// <li>
        /// <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue,
        /// Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set,
        /// the action fails with an error.</p>
        /// </li>
        /// <li>
        /// <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates
        /// and only one copy of the message is delivered.</p>
        /// </li>
        /// <li>
        /// <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same
        /// as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered.
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>  
        ///
        ///
        /// <p>The following attributes apply only to
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high throughput
        /// for FIFO queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the
        /// message group or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput
        /// quota applies to the entire queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>.
        /// The <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is <code>messageGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <p>To enable high throughput for FIFO queues, do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Set <code>DeduplicationScope</code> to <code>messageGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If you set these attributes to anything other than the values shown for enabling high
        /// throughput, normal throughput is in effect and deduplication occurs as specified.</p>
        /// <p>For information on throughput quotas,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<crate::model::QueueAttributeName>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request parameters that the <code>CreateQueue</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DelaySeconds</code> – The length of time, in seconds, for which the delivery of all messages in the queue is delayed. Valid values: An integer from 0 to 900 seconds (15 minutes). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaximumMessageSize</code> – The limit of how many bytes a message can contain before Amazon SQS rejects it. Valid values: An integer from 1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). Default: 262,144 (256 KiB).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRetentionPeriod</code> – The length of time, in seconds, for which Amazon SQS retains a message. Valid values: An integer from 60 seconds (1 minute) to 1,209,600 seconds (14 days). Default: 345,600 (4 days).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The queue's policy. A valid Amazon Web Services policy. For more information about policy structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PoliciesOverview.html">Overview of Amazon Web Services IAM Policies</a> in the <i>Amazon IAM User Guide</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessageWaitTimeSeconds</code> – The length of time, in seconds, for which a <code>
        /// <a>ReceiveMessage</a>
        /// </code> action waits for a message to arrive. Valid values: An integer from 0 to 20 (seconds). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityTimeout</code> – The visibility timeout for the queue, in seconds. Valid values: An integer from 0 to 43,200 (12 hours). Default: 30. For more information about the visibility timeout, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">dead-letter queues:</a>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
        /// of the source queue as a JSON object. The parameters are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to
        /// which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
        /// moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code>
        /// for a queue, Amazon SQS moves the message to the dead-letter-queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
        /// queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters are as follows:</p>              
        /// <ul>
        /// <li>
        /// <p>
        /// <code>redrivePermission</code> – The permission type that defines which source queues can
        /// specify the current queue as the dead-letter queue. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
        /// specify this queue as the dead-letter queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>denyAll</code> – No source queues can specify this queue as the dead-letter
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
        /// this queue as the dead-letter queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
        /// this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
        /// <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue ARNs.
        /// To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter
        /// to <code>allowAll</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The dead-letter queue of a
        /// FIFO queue must also be a FIFO queue. Similarly, the dead-letter
        /// queue of a standard queue must also be a standard queue.</p>
        /// </note>
        ///
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">server-side-encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SQS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms">Key Terms</a>.
        /// While the alias of the Amazon Web Services managed CMK for Amazon SQS is always <code>alias/aws/sqs</code>, the alias of a custom CMK can, for example, be <code>alias/<i>MyAlias</i>
        /// </code>.
        /// For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API Reference</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsDataKeyReusePeriodSeconds</code> – The length of time, in seconds, for which Amazon SQS can reuse a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys">data key</a> to encrypt
        /// or decrypt messages before calling KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). Default: 300 (5 minutes). A shorter time period provides better security
        /// but results in more calls to KMS which might incur charges after Free Tier. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">How Does the Data Key Reuse Period Work?</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO (first-in-first-out) queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FifoQueue</code> – Designates a queue as FIFO. Valid values are <code>true</code> and <code>false</code>. If you don't specify the <code>FifoQueue</code> attribute, Amazon SQS creates a standard queue.
        /// You can provide this attribute only during queue creation. You can't change it for an existing queue.
        /// When you set this attribute, you must also provide the <code>MessageGroupId</code> for your messages explicitly.</p>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html">FIFO queue logic</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication. Valid values are <code>true</code> and <code>false</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">Exactly-once processing</a> in the
        /// <i>Amazon SQS Developer Guide</i>. Note the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
        /// <ul>
        /// <li>
        /// <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue,
        /// Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set,
        /// the action fails with an error.</p>
        /// </li>
        /// <li>
        /// <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates
        /// and only one copy of the message is delivered.</p>
        /// </li>
        /// <li>
        /// <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same
        /// as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered.
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>  
        ///
        ///
        /// <p>The following attributes apply only to
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high throughput
        /// for FIFO queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the
        /// message group or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput
        /// quota applies to the entire queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>.
        /// The <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is <code>messageGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <p>To enable high throughput for FIFO queues, do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Set <code>DeduplicationScope</code> to <code>messageGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If you set these attributes to anything other than the values shown for enabling high
        /// throughput, normal throughput is in effect and deduplication occurs as specified.</p>
        /// <p>For information on throughput quotas,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMessage`.
    ///
    /// <p>Deletes the specified message from the specified queue. To select the message to
    /// delete, use the <code>ReceiptHandle</code> of the message (<i>not</i> the
    /// <code>MessageId</code> which you receive when you send the message). Amazon SQS can
    /// delete a message from a queue even if a visibility timeout setting causes the message to
    /// be locked by another consumer. Amazon SQS automatically deletes messages left in a queue
    /// longer than the retention period configured for the queue. </p>
    /// <note>
    /// <p>The <code>ReceiptHandle</code> is associated with a <i>specific
    /// instance</i> of receiving a message. If you receive a message more than
    /// once, the <code>ReceiptHandle</code> is different each time you receive a message.
    /// When you use the <code>DeleteMessage</code> action, you must provide the most
    /// recently received <code>ReceiptHandle</code> for the message (otherwise, the request
    /// succeeds, but the message might not be deleted).</p>
    /// <p>For standard queues, it is possible to receive a message even after you
    /// delete it. This might happen on rare occasions if one of the servers which stores a
    /// copy of the message is unavailable when you send the request to delete the message.
    /// The copy remains on the server and might be returned to you during a subsequent
    /// receive request. You should ensure that your application is idempotent, so that
    /// receiving a message more than once does not cause issues.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_message_input::Builder,
    }
    impl<C, M, R> DeleteMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMessageInputOperationOutputAlias,
                crate::output::DeleteMessageOutput,
                crate::error::DeleteMessageError,
                crate::input::DeleteMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue from which messages are deleted.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue from which messages are deleted.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// <p>The receipt handle associated with the message to delete.</p>
        pub fn receipt_handle(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.receipt_handle(inp);
            self
        }
        /// <p>The receipt handle associated with the message to delete.</p>
        pub fn set_receipt_handle(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_receipt_handle(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMessageBatch`.
    ///
    /// <p>Deletes up to ten messages from the specified queue. This is a batch version of <code>
    /// <a>DeleteMessage</a>.</code> The result of the action on each message is reported individually in the response.</p>
    /// <important>
    /// <p>Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of <code>200</code>.</p>
    /// </important>
    /// <p>Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values of <code>n</code> are integers starting from 1. For example, a parameter list with two elements looks like this:</p>
    /// <p>
    /// <code>&AttributeName.1=first</code>
    /// </p>
    /// <p>
    /// <code>&AttributeName.2=second</code>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMessageBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_message_batch_input::Builder,
    }
    impl<C, M, R> DeleteMessageBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMessageBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMessageBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMessageBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMessageBatchInputOperationOutputAlias,
                crate::output::DeleteMessageBatchOutput,
                crate::error::DeleteMessageBatchError,
                crate::input::DeleteMessageBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue from which messages are deleted.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue from which messages are deleted.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of receipt handles for the messages to be deleted.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::DeleteMessageBatchRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>A list of receipt handles for the messages to be deleted.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteMessageBatchRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueue`.
    ///
    /// <p>Deletes the queue specified by the <code>QueueUrl</code>, regardless of the queue's contents.</p>
    /// <important>
    /// <p>Be careful with the <code>DeleteQueue</code> action: When you delete a queue, any messages in the queue are no longer available.
    /// </p>
    /// </important>
    /// <p>When you delete a queue, the deletion process takes up to 60 seconds. Requests you send involving that queue during the 60 seconds might succeed. For example, a
    /// <code>
    /// <a>SendMessage</a>
    /// </code> request might succeed, but after 60 seconds the queue and the message you sent no longer exist.</p>
    /// <p>When you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.</p>
    /// <note>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_queue_input::Builder,
    }
    impl<C, M, R> DeleteQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQueueInputOperationOutputAlias,
                crate::output::DeleteQueueOutput,
                crate::error::DeleteQueueError,
                crate::input::DeleteQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue to delete.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue to delete.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueueAttributes`.
    ///
    /// <p>Gets attributes for the specified queue.</p>
    /// <note>
    /// <p>To determine whether a queue is <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetQueueAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_queue_attributes_input::Builder,
    }
    impl<C, M, R> GetQueueAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueueAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueueAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueueAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueueAttributesInputOperationOutputAlias,
                crate::output::GetQueueAttributesOutput,
                crate::error::GetQueueAttributesError,
                crate::input::GetQueueAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue whose attribute information is retrieved.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue whose attribute information is retrieved.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attributes for which to retrieve information.</p>
        /// <p>The <code>AttributeName.N</code> parameter is optional, but if you don't specify values for this parameter,
        /// the request returns empty results.</p>
        /// <note>
        /// <p>In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.</p>
        /// </note>
        /// <p>The following attributes are supported:</p>
        /// <important>
        /// <p>The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>,
        /// and <code>ApproximateNumberOfMessagesVisible</code> metrics may not achieve consistency
        /// until at least 1 minute after the producers stop sending messages. This period is required for
        /// the queue metadata to reach eventual consistency. </p>
        /// </important>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>All</code> – Returns all values. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateNumberOfMessages</code> – Returns the approximate number of
        /// messages available for retrieval from the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number
        /// of messages in the queue that are delayed and not available for reading
        /// immediately. This can happen when the queue is configured as a delay queue or
        /// when a message has been sent with a delay parameter.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate
        /// number of messages that are in flight. Messages are considered to be
        /// <i>in flight</i> if they have been sent to a client but have
        /// not yet been deleted or have not yet reached the end of their visibility window. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatedTimestamp</code> – Returns the time when the queue was created in
        /// seconds (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch
        /// time</a>).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DelaySeconds</code> – Returns the default delay on the queue in
        /// seconds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LastModifiedTimestamp</code> – Returns the time when the queue was last
        /// changed in seconds (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch
        /// time</a>).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message
        /// can contain before Amazon SQS rejects it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds,
        /// for which Amazon SQS retains a message.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – Returns the policy of the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in
        /// seconds, for which the <code>ReceiveMessage</code> action waits for a message to
        /// arrive. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the visibility timeout, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">dead-letter queues:</a>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
        /// of the source queue as a JSON object. The parameters are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to
        /// which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
        /// moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code>
        /// for a queue, Amazon SQS moves the message to the dead-letter-queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
        /// queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters are as follows:</p>              
        /// <ul>
        /// <li>
        /// <p>
        /// <code>redrivePermission</code> – The permission type that defines which source queues can
        /// specify the current queue as the dead-letter queue. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
        /// specify this queue as the dead-letter queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>denyAll</code> – No source queues can specify this queue as the dead-letter
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
        /// this queue as the dead-letter queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
        /// this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
        /// <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue ARNs.
        /// To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter
        /// to <code>allowAll</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The dead-letter queue of a
        /// FIFO queue must also be a FIFO queue. Similarly, the dead-letter
        /// queue of a standard queue must also be a standard queue.</p>
        /// </note>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">server-side-encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for Amazon SQS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms">Key Terms</a>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling KMS again.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">How Does the Data Key Reuse Period Work?</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO (first-in-first-out) queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html">FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <note>
        /// <p>To determine whether a queue is <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high throughput
        /// for FIFO queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the
        /// message group or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput
        /// quota applies to the entire queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>.
        /// The <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is <code>messageGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <p>To enable high throughput for FIFO queues, do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Set <code>DeduplicationScope</code> to <code>messageGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If you set these attributes to anything other than the values shown for enabling high
        /// throughput, normal throughput is in effect and deduplication occurs as specified.</p>
        /// <p>For information on throughput quotas,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn attribute_names(mut self, inp: impl Into<crate::model::QueueAttributeName>) -> Self {
            self.inner = self.inner.attribute_names(inp);
            self
        }
        /// <p>A list of attributes for which to retrieve information.</p>
        /// <p>The <code>AttributeName.N</code> parameter is optional, but if you don't specify values for this parameter,
        /// the request returns empty results.</p>
        /// <note>
        /// <p>In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.</p>
        /// </note>
        /// <p>The following attributes are supported:</p>
        /// <important>
        /// <p>The <code>ApproximateNumberOfMessagesDelayed</code>, <code>ApproximateNumberOfMessagesNotVisible</code>,
        /// and <code>ApproximateNumberOfMessagesVisible</code> metrics may not achieve consistency
        /// until at least 1 minute after the producers stop sending messages. This period is required for
        /// the queue metadata to reach eventual consistency. </p>
        /// </important>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>All</code> – Returns all values. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateNumberOfMessages</code> – Returns the approximate number of
        /// messages available for retrieval from the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateNumberOfMessagesDelayed</code> – Returns the approximate number
        /// of messages in the queue that are delayed and not available for reading
        /// immediately. This can happen when the queue is configured as a delay queue or
        /// when a message has been sent with a delay parameter.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateNumberOfMessagesNotVisible</code> – Returns the approximate
        /// number of messages that are in flight. Messages are considered to be
        /// <i>in flight</i> if they have been sent to a client but have
        /// not yet been deleted or have not yet reached the end of their visibility window. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatedTimestamp</code> – Returns the time when the queue was created in
        /// seconds (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch
        /// time</a>).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DelaySeconds</code> – Returns the default delay on the queue in
        /// seconds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LastModifiedTimestamp</code> – Returns the time when the queue was last
        /// changed in seconds (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch
        /// time</a>).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaximumMessageSize</code> – Returns the limit of how many bytes a message
        /// can contain before Amazon SQS rejects it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRetentionPeriod</code> – Returns the length of time, in seconds,
        /// for which Amazon SQS retains a message.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – Returns the policy of the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>QueueArn</code> – Returns the Amazon resource name (ARN) of the
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessageWaitTimeSeconds</code> – Returns the length of time, in
        /// seconds, for which the <code>ReceiveMessage</code> action waits for a message to
        /// arrive. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityTimeout</code> – Returns the visibility timeout for the queue. For more information about the visibility timeout, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">dead-letter queues:</a>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
        /// of the source queue as a JSON object. The parameters are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to
        /// which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
        /// moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code>
        /// for a queue, Amazon SQS moves the message to the dead-letter-queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
        /// queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters are as follows:</p>              
        /// <ul>
        /// <li>
        /// <p>
        /// <code>redrivePermission</code> – The permission type that defines which source queues can
        /// specify the current queue as the dead-letter queue. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
        /// specify this queue as the dead-letter queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>denyAll</code> – No source queues can specify this queue as the dead-letter
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
        /// this queue as the dead-letter queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
        /// this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
        /// <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue ARNs.
        /// To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter
        /// to <code>allowAll</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The dead-letter queue of a
        /// FIFO queue must also be a FIFO queue. Similarly, the dead-letter
        /// queue of a standard queue must also be a standard queue.</p>
        /// </note>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">server-side-encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – Returns the ID of an Amazon Web Services managed customer master key (CMK) for Amazon SQS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms">Key Terms</a>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsDataKeyReusePeriodSeconds</code> – Returns the length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling KMS again.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">How Does the Data Key Reuse Period Work?</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO (first-in-first-out) queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FifoQueue</code> – Returns information about whether the queue is FIFO. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html">FIFO queue logic</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <note>
        /// <p>To determine whether a queue is <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO</a>, you can check whether <code>QueueName</code> ends with the <code>.fifo</code> suffix.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Returns whether content-based deduplication is enabled for the queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high throughput
        /// for FIFO queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the
        /// message group or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput
        /// quota applies to the entire queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>.
        /// The <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is <code>messageGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <p>To enable high throughput for FIFO queues, do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Set <code>DeduplicationScope</code> to <code>messageGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If you set these attributes to anything other than the values shown for enabling high
        /// throughput, normal throughput is in effect and deduplication occurs as specified.</p>
        /// <p>For information on throughput quotas,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueueAttributeName>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueueUrl`.
    ///
    /// <p>Returns the URL of an existing Amazon SQS queue.</p>
    /// <p>To access a queue that belongs to another AWS account, use the <code>QueueOwnerAWSAccountId</code> parameter to specify the account ID of the queue's owner. The queue's owner must grant you permission to access the queue.
    /// For more information about shared queue access, see <code>
    /// <a>AddPermission</a>
    /// </code> or see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue">Allow Developers to Write Messages to a Shared Queue</a> in the <i>Amazon SQS Developer Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetQueueUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_queue_url_input::Builder,
    }
    impl<C, M, R> GetQueueUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueueUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueueUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueueUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueueUrlInputOperationOutputAlias,
                crate::output::GetQueueUrlOutput,
                crate::error::GetQueueUrlError,
                crate::input::GetQueueUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_name(inp);
            self
        }
        /// <p>The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric characters, hyphens (<code>-</code>), and underscores (<code>_</code>).</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_name(input);
            self
        }
        /// <p>The account ID of the account that created the queue.</p>
        pub fn queue_owner_aws_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_owner_aws_account_id(inp);
            self
        }
        /// <p>The account ID of the account that created the queue.</p>
        pub fn set_queue_owner_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_queue_owner_aws_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeadLetterSourceQueues`.
    ///
    /// <p>Returns a list of your queues that have the <code>RedrivePolicy</code> queue attribute configured with a dead-letter queue.</p>   
    /// <p> The <code>ListDeadLetterSourceQueues</code> methods supports
    /// pagination. Set parameter <code>MaxResults</code> in the request to specify the maximum number of
    /// results to be returned in the response. If you do not set <code>MaxResults</code>,
    /// the response includes a maximum of 1,000 results. If you set <code>MaxResults</code> and there are additional results to
    /// display, the response includes a value for <code>NextToken</code>. Use
    /// <code>NextToken</code> as a parameter in your next request to
    /// <code>ListDeadLetterSourceQueues</code> to receive the next page of results.   </p>
    ///
    /// <p>For more information about using dead-letter queues, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">Using Amazon SQS Dead-Letter Queues</a>
    /// in the <i>Amazon SQS Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDeadLetterSourceQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dead_letter_source_queues_input::Builder,
    }
    impl<C, M, R> ListDeadLetterSourceQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeadLetterSourceQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeadLetterSourceQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeadLetterSourceQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeadLetterSourceQueuesInputOperationOutputAlias,
                crate::output::ListDeadLetterSourceQueuesOutput,
                crate::error::ListDeadLetterSourceQueuesError,
                crate::input::ListDeadLetterSourceQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of a dead-letter queue.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of a dead-letter queue.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// <p>Pagination token to request the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token to request the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to include in the response. Value range is 1 to 1000.
        /// You must set <code>MaxResults</code> to receive a value for <code>NextToken</code> in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to include in the response. Value range is 1 to 1000.
        /// You must set <code>MaxResults</code> to receive a value for <code>NextToken</code> in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueues`.
    ///
    /// <p>Returns a list of your queues in the current region. The response includes a maximum of 1,000 results. If you specify a value for the optional
    /// <code>QueueNamePrefix</code> parameter, only queues with a name that begins with the specified value are returned.</p>
    /// <p> The <code>listQueues</code> methods supports
    /// pagination. Set parameter <code>MaxResults</code> in the request to specify the maximum number of
    /// results to be returned in the response. If you do not set <code>MaxResults</code>,
    /// the response includes a maximum of 1,000 results. If you set <code>MaxResults</code> and there are additional results to
    /// display, the response includes a value for <code>NextToken</code>. Use
    /// <code>NextToken</code> as a parameter in your next request to
    /// <code>listQueues</code> to receive the next page of results.  </p>
    /// <note>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queues_input::Builder,
    }
    impl<C, M, R> ListQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueuesInputOperationOutputAlias,
                crate::output::ListQueuesOutput,
                crate::error::ListQueuesError,
                crate::input::ListQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string to use for filtering the list results. Only those queues whose name begins with the specified string are returned.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_name_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_name_prefix(inp);
            self
        }
        /// <p>A string to use for filtering the list results. Only those queues whose name begins with the specified string are returned.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_queue_name_prefix(input);
            self
        }
        /// <p>Pagination token to request the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token to request the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to include in the response. Value range is 1 to 1000.
        /// You must set <code>MaxResults</code> to receive a value for <code>NextToken</code> in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to include in the response. Value range is 1 to 1000.
        /// You must set <code>MaxResults</code> to receive a value for <code>NextToken</code> in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueueTags`.
    ///
    /// <p>List all cost allocation tags added to the specified Amazon SQS queue. For an overview, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html">Tagging
    /// Your Amazon SQS Queues</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <note>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListQueueTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queue_tags_input::Builder,
    }
    impl<C, M, R> ListQueueTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueueTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueueTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueueTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueueTagsInputOperationOutputAlias,
                crate::output::ListQueueTagsOutput,
                crate::error::ListQueueTagsError,
                crate::input::ListQueueTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the queue.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the queue.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurgeQueue`.
    ///
    /// <p>Deletes the messages in a queue specified by the <code>QueueURL</code>
    /// parameter.</p>
    ///
    /// <important>
    /// <p>When you use the <code>PurgeQueue</code> action, you can't retrieve any messages
    /// deleted from a queue.</p>
    /// <p>The message deletion process takes up to 60 seconds. We recommend waiting for
    /// 60 seconds regardless of your queue's size. </p>
    /// </important>
    /// <p>Messages sent to the queue <i>before</i> you call
    /// <code>PurgeQueue</code> might be received but are deleted within the next
    /// minute.</p>
    /// <p>Messages sent to the queue <i>after</i> you call
    /// <code>PurgeQueue</code> might be deleted while the queue is being purged.</p>
    #[derive(std::fmt::Debug)]
    pub struct PurgeQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::purge_queue_input::Builder,
    }
    impl<C, M, R> PurgeQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PurgeQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurgeQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::PurgeQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PurgeQueueInputOperationOutputAlias,
                crate::output::PurgeQueueOutput,
                crate::error::PurgeQueueError,
                crate::input::PurgeQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the queue from which the <code>PurgeQueue</code> action deletes messages.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the queue from which the <code>PurgeQueue</code> action deletes messages.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReceiveMessage`.
    ///
    /// <p>Retrieves one or more messages (up to 10), from the specified queue. Using the <code>WaitTimeSeconds</code> parameter enables long-poll support.
    /// For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-long-polling.html">Amazon SQS Long Polling</a> in the <i>Amazon SQS Developer Guide</i>.
    /// </p>
    /// <p>Short poll is the default behavior where a weighted random set of machines is sampled on a <code>ReceiveMessage</code> call. Thus, only the messages on the sampled machines are returned.
    /// If the number of messages in the queue is small (fewer than 1,000), you most likely get fewer messages than you requested per <code>ReceiveMessage</code> call. If the number of messages in the queue is extremely small,
    /// you might not receive any messages in a particular <code>ReceiveMessage</code> response. If this happens, repeat the request.
    /// </p>
    /// <p>For each message returned, the response includes the following:</p>
    /// <ul>
    /// <li>
    /// <p>The message body.</p>
    /// </li>
    /// <li>
    /// <p>An MD5 digest of the message body. For information about MD5, see <a href="https://www.ietf.org/rfc/rfc1321.txt">RFC1321</a>.</p>
    /// </li>
    /// <li>
    /// <p>The <code>MessageId</code> you received when you sent the message to the queue.</p>
    /// </li>
    /// <li>
    /// <p>The receipt handle.</p>
    /// </li>
    /// <li>
    /// <p>The message attributes.</p>
    /// </li>
    /// <li>
    /// <p>An MD5 digest of the message attributes.</p>
    /// </li>
    /// </ul>
    /// <p>The receipt handle is the identifier you must provide when deleting the message. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html">Queue
    /// and Message Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <p>You can provide the <code>VisibilityTimeout</code> parameter in your request. The parameter is applied to the messages that Amazon SQS returns in the response. If you don't include the parameter, the overall visibility timeout for the queue
    /// is used for the returned messages. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <p>A message that isn't deleted or a message whose visibility isn't extended before the visibility timeout expires counts as a failed receive. Depending on the configuration of the queue, the message might be sent to the dead-letter queue.</p>
    /// <note>
    /// <p>In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ReceiveMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::receive_message_input::Builder,
    }
    impl<C, M, R> ReceiveMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReceiveMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReceiveMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::ReceiveMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReceiveMessageInputOperationOutputAlias,
                crate::output::ReceiveMessageOutput,
                crate::error::ReceiveMessageError,
                crate::input::ReceiveMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue from which messages are received.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue from which messages are received.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attributes that need to be returned along with each message. These attributes
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>All</code> – Returns all values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateFirstReceiveTimestamp</code> – Returns the time the message was first received from the queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateReceiveCount</code> – Returns the number of times a message has been received across all queues but not deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWSTraceHeader</code> – Returns the X-Ray trace header string.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SenderId</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.</p>
        /// </li>
        /// <li>
        /// <p>For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SentTimestamp</code> – Returns the time the message was sent to the queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageDeduplicationId</code> – Returns the value provided by the
        /// producer that calls the <code>
        /// <a>SendMessage</a>
        /// </code>
        /// action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageGroupId</code> – Returns the value provided by the producer that
        /// calls the <code>
        /// <a>SendMessage</a>
        /// </code> action. Messages with the
        /// same <code>MessageGroupId</code> are returned in sequence.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SequenceNumber</code> – Returns the value provided by Amazon SQS.</p>
        /// </li>
        /// </ul>
        pub fn attribute_names(mut self, inp: impl Into<crate::model::QueueAttributeName>) -> Self {
            self.inner = self.inner.attribute_names(inp);
            self
        }
        /// <p>A list of attributes that need to be returned along with each message. These attributes
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>All</code> – Returns all values.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateFirstReceiveTimestamp</code> – Returns the time the message was first received from the queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ApproximateReceiveCount</code> – Returns the number of times a message has been received across all queues but not deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWSTraceHeader</code> – Returns the X-Ray trace header string.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SenderId</code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>For an IAM user, returns the IAM user ID, for example <code>ABCDEFGHI1JKLMNOPQ23R</code>.</p>
        /// </li>
        /// <li>
        /// <p>For an IAM role, returns the IAM role ID, for example <code>ABCDE1F2GH3I4JK5LMNOP:i-a123b456</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SentTimestamp</code> – Returns the time the message was sent to the queue (<a href="http://en.wikipedia.org/wiki/Unix_time">epoch time</a> in milliseconds).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageDeduplicationId</code> – Returns the value provided by the
        /// producer that calls the <code>
        /// <a>SendMessage</a>
        /// </code>
        /// action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageGroupId</code> – Returns the value provided by the producer that
        /// calls the <code>
        /// <a>SendMessage</a>
        /// </code> action. Messages with the
        /// same <code>MessageGroupId</code> are returned in sequence.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SequenceNumber</code> – Returns the value provided by Amazon SQS.</p>
        /// </li>
        /// </ul>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueueAttributeName>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
        /// Appends an item to `MessageAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_message_attribute_names`](Self::set_message_attribute_names).
        ///
        /// <p>The name of the message attribute, where <i>N</i> is the index.</p>
        /// <ul>
        /// <li>
        /// <p>The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (<code>-</code>), and period (<code>.</code>).</p>
        /// </li>
        /// <li>
        /// <p>The name is case-sensitive and must be unique among all attribute names for the message.</p>
        /// </li>
        /// <li>
        /// <p>The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code> (or any casing variants).</p>
        /// </li>
        /// <li>
        /// <p>The name must not start or end with a period (<code>.</code>), and it should not have periods in succession (<code>..</code>).</p>
        /// </li>
        /// <li>
        /// <p>The name can be up to 256 characters long.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can return all of the attributes by specifying <code>All</code> or <code>.*</code> in your request.
        /// You can also use all message attributes starting with a prefix, for example <code>bar.*</code>.</p>
        pub fn message_attribute_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_attribute_names(inp);
            self
        }
        /// <p>The name of the message attribute, where <i>N</i> is the index.</p>
        /// <ul>
        /// <li>
        /// <p>The name can contain alphanumeric characters and the underscore (<code>_</code>), hyphen (<code>-</code>), and period (<code>.</code>).</p>
        /// </li>
        /// <li>
        /// <p>The name is case-sensitive and must be unique among all attribute names for the message.</p>
        /// </li>
        /// <li>
        /// <p>The name must not start with AWS-reserved prefixes such as <code>AWS.</code> or <code>Amazon.</code> (or any casing variants).</p>
        /// </li>
        /// <li>
        /// <p>The name must not start or end with a period (<code>.</code>), and it should not have periods in succession (<code>..</code>).</p>
        /// </li>
        /// <li>
        /// <p>The name can be up to 256 characters long.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When using <code>ReceiveMessage</code>, you can send a list of attribute names to receive, or you can return all of the attributes by specifying <code>All</code> or <code>.*</code> in your request.
        /// You can also use all message attributes starting with a prefix, for example <code>bar.*</code>.</p>
        pub fn set_message_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_message_attribute_names(input);
            self
        }
        /// <p>The maximum number of messages to return. Amazon SQS never returns more messages than this value (however, fewer messages might be returned). Valid values: 1 to 10. Default: 1.</p>
        pub fn max_number_of_messages(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_number_of_messages(inp);
            self
        }
        /// <p>The maximum number of messages to return. Amazon SQS never returns more messages than this value (however, fewer messages might be returned). Valid values: 1 to 10. Default: 1.</p>
        pub fn set_max_number_of_messages(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_number_of_messages(input);
            self
        }
        /// <p>The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being retrieved by a <code>ReceiveMessage</code> request.</p>
        pub fn visibility_timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.visibility_timeout(inp);
            self
        }
        /// <p>The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being retrieved by a <code>ReceiveMessage</code> request.</p>
        pub fn set_visibility_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_visibility_timeout(input);
            self
        }
        /// <p>The duration (in seconds) for which the call waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than <code>WaitTimeSeconds</code>.
        /// If no messages are available and the wait time expires, the call returns successfully with an empty list of messages.</p>
        /// <important>
        /// <p>To avoid HTTP errors, ensure that the HTTP response timeout for <code>ReceiveMessage</code>
        /// requests is longer than the <code>WaitTimeSeconds</code> parameter. For example,
        /// with the Java SDK, you can set HTTP transport settings using the <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/nio/netty/NettyNioAsyncHttpClient.html"> NettyNioAsyncHttpClient</a> for asynchronous clients, or the <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/apache/ApacheHttpClient.html"> ApacheHttpClient</a> for synchronous clients. </p>
        /// </important>
        pub fn wait_time_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.wait_time_seconds(inp);
            self
        }
        /// <p>The duration (in seconds) for which the call waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than <code>WaitTimeSeconds</code>.
        /// If no messages are available and the wait time expires, the call returns successfully with an empty list of messages.</p>
        /// <important>
        /// <p>To avoid HTTP errors, ensure that the HTTP response timeout for <code>ReceiveMessage</code>
        /// requests is longer than the <code>WaitTimeSeconds</code> parameter. For example,
        /// with the Java SDK, you can set HTTP transport settings using the <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/nio/netty/NettyNioAsyncHttpClient.html"> NettyNioAsyncHttpClient</a> for asynchronous clients, or the <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/apache/ApacheHttpClient.html"> ApacheHttpClient</a> for synchronous clients. </p>
        /// </important>
        pub fn set_wait_time_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_wait_time_seconds(input);
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The token used for deduplication of <code>ReceiveMessage</code> calls. If a networking issue occurs after a <code>ReceiveMessage</code> action, and instead of a response you receive a generic error,
        /// it is possible to retry the same action with an identical <code>ReceiveRequestAttemptId</code> to retrieve the same set of messages, even if their visibility timeout has not yet expired.</p>
        /// <ul>
        /// <li>
        /// <p>You can use <code>ReceiveRequestAttemptId</code> only for 5 minutes after a <code>ReceiveMessage</code> action.</p>
        /// </li>
        /// <li>
        /// <p>When you set <code>FifoQueue</code>, a caller of the <code>ReceiveMessage</code> action can provide a <code>ReceiveRequestAttemptId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If a caller of the <code>ReceiveMessage</code> action doesn't provide a <code>ReceiveRequestAttemptId</code>, Amazon SQS generates a <code>ReceiveRequestAttemptId</code>.</p>
        /// </li>
        /// <li>
        /// <p>It is possible to retry the <code>ReceiveMessage</code> action with the same <code>ReceiveRequestAttemptId</code> if none of the messages have been modified (deleted or had their visibility changes).</p>
        /// </li>
        /// <li>
        /// <p>During a visibility timeout, subsequent calls with the same <code>ReceiveRequestAttemptId</code> return the same messages and receipt handles. If a retry occurs within the deduplication interval,
        /// it resets the visibility timeout. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <important>
        /// <p>If a caller of the <code>ReceiveMessage</code> action still processes
        /// messages when the visibility timeout expires and messages become visible,
        /// another worker consuming from the same queue can receive the same messages
        /// and therefore process duplicates. Also, if a consumer whose message
        /// processing time is longer than the visibility timeout tries to delete the
        /// processed messages, the action fails with an error.</p>
        /// <p>To mitigate this effect, ensure that your application observes a safe threshold before the visibility timeout expires and extend the visibility timeout as necessary.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>While messages with a particular <code>MessageGroupId</code> are invisible, no more messages belonging to the same <code>MessageGroupId</code> are returned until the visibility timeout expires. You can still receive
        /// messages with another <code>MessageGroupId</code> as long as it is also visible.</p>
        /// </li>
        /// <li>
        /// <p>If a caller of <code>ReceiveMessage</code> can't track the <code>ReceiveRequestAttemptId</code>, no retries work until the original visibility timeout expires. As a result, delays might occur but
        /// the messages in the queue remain in a strict order.</p>
        /// </li>
        /// </ul>
        /// <p>The maximum length of <code>ReceiveRequestAttemptId</code> is 128 characters. <code>ReceiveRequestAttemptId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and
        /// punctuation (<code>!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~</code>).</p>
        /// <p>For best practices of using <code>ReceiveRequestAttemptId</code>, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-receiverequestattemptid-request-parameter.html">Using the ReceiveRequestAttemptId Request Parameter</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn receive_request_attempt_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.receive_request_attempt_id(inp);
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The token used for deduplication of <code>ReceiveMessage</code> calls. If a networking issue occurs after a <code>ReceiveMessage</code> action, and instead of a response you receive a generic error,
        /// it is possible to retry the same action with an identical <code>ReceiveRequestAttemptId</code> to retrieve the same set of messages, even if their visibility timeout has not yet expired.</p>
        /// <ul>
        /// <li>
        /// <p>You can use <code>ReceiveRequestAttemptId</code> only for 5 minutes after a <code>ReceiveMessage</code> action.</p>
        /// </li>
        /// <li>
        /// <p>When you set <code>FifoQueue</code>, a caller of the <code>ReceiveMessage</code> action can provide a <code>ReceiveRequestAttemptId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If a caller of the <code>ReceiveMessage</code> action doesn't provide a <code>ReceiveRequestAttemptId</code>, Amazon SQS generates a <code>ReceiveRequestAttemptId</code>.</p>
        /// </li>
        /// <li>
        /// <p>It is possible to retry the <code>ReceiveMessage</code> action with the same <code>ReceiveRequestAttemptId</code> if none of the messages have been modified (deleted or had their visibility changes).</p>
        /// </li>
        /// <li>
        /// <p>During a visibility timeout, subsequent calls with the same <code>ReceiveRequestAttemptId</code> return the same messages and receipt handles. If a retry occurs within the deduplication interval,
        /// it resets the visibility timeout. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <important>
        /// <p>If a caller of the <code>ReceiveMessage</code> action still processes
        /// messages when the visibility timeout expires and messages become visible,
        /// another worker consuming from the same queue can receive the same messages
        /// and therefore process duplicates. Also, if a consumer whose message
        /// processing time is longer than the visibility timeout tries to delete the
        /// processed messages, the action fails with an error.</p>
        /// <p>To mitigate this effect, ensure that your application observes a safe threshold before the visibility timeout expires and extend the visibility timeout as necessary.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>While messages with a particular <code>MessageGroupId</code> are invisible, no more messages belonging to the same <code>MessageGroupId</code> are returned until the visibility timeout expires. You can still receive
        /// messages with another <code>MessageGroupId</code> as long as it is also visible.</p>
        /// </li>
        /// <li>
        /// <p>If a caller of <code>ReceiveMessage</code> can't track the <code>ReceiveRequestAttemptId</code>, no retries work until the original visibility timeout expires. As a result, delays might occur but
        /// the messages in the queue remain in a strict order.</p>
        /// </li>
        /// </ul>
        /// <p>The maximum length of <code>ReceiveRequestAttemptId</code> is 128 characters. <code>ReceiveRequestAttemptId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and
        /// punctuation (<code>!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~</code>).</p>
        /// <p>For best practices of using <code>ReceiveRequestAttemptId</code>, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-receiverequestattemptid-request-parameter.html">Using the ReceiveRequestAttemptId Request Parameter</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_receive_request_attempt_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_receive_request_attempt_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemovePermission`.
    ///
    /// <p>Revokes any permissions in the queue policy that matches the specified <code>Label</code> parameter.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>Only the owner of a queue can remove permissions from it.</p>
    /// </li>
    /// <li>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>To remove the ability to change queue permissions, you must deny permission to the <code>AddPermission</code>, <code>RemovePermission</code>, and <code>SetQueueAttributes</code> actions in your IAM policy.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RemovePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_permission_input::Builder,
    }
    impl<C, M, R> RemovePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemovePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemovePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemovePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemovePermissionInputOperationOutputAlias,
                crate::output::RemovePermissionOutput,
                crate::error::RemovePermissionError,
                crate::input::RemovePermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue from which permissions are removed.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue from which permissions are removed.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// <p>The identification of the permission to remove. This is the label added using the <code>
        /// <a>AddPermission</a>
        /// </code> action.</p>
        pub fn label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(inp);
            self
        }
        /// <p>The identification of the permission to remove. This is the label added using the <code>
        /// <a>AddPermission</a>
        /// </code> action.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendMessage`.
    ///
    /// <p>Delivers a message to the specified queue.</p>
    /// <important>
    /// <p>A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:</p>
    /// <p>
    /// <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> | <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
    /// </p>
    /// <p>Any characters not included in this list will be rejected. For more information, see the <a href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct SendMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_message_input::Builder,
    }
    impl<C, M, R> SendMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendMessageInputOperationOutputAlias,
                crate::output::SendMessageOutput,
                crate::error::SendMessageError,
                crate::input::SendMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue to which a message is sent.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue to which a message is sent.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// <p>The message to send. The minimum size is one character. The maximum size is 256 KB.</p>
        /// <important>
        /// <p>A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:</p>
        /// <p>
        /// <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> | <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
        /// </p>
        /// <p>Any characters not included in this list will be rejected. For more information, see the <a href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.</p>
        /// </important>
        pub fn message_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_body(inp);
            self
        }
        /// <p>The message to send. The minimum size is one character. The maximum size is 256 KB.</p>
        /// <important>
        /// <p>A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:</p>
        /// <p>
        /// <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> | <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
        /// </p>
        /// <p>Any characters not included in this list will be rejected. For more information, see the <a href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.</p>
        /// </important>
        pub fn set_message_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message_body(input);
            self
        }
        /// <p>
        /// The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the delay period is finished.
        /// If you don't specify a value, the default value for the queue applies.
        /// </p>
        /// <note>
        /// <p>When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this parameter only on a queue level.</p>
        /// </note>
        pub fn delay_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.delay_seconds(inp);
            self
        }
        /// <p>
        /// The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive <code>DelaySeconds</code> value become available for processing after the delay period is finished.
        /// If you don't specify a value, the default value for the queue applies.
        /// </p>
        /// <note>
        /// <p>When you set <code>FifoQueue</code>, you can't set <code>DelaySeconds</code> per message. You can set this parameter only on a queue level.</p>
        /// </note>
        pub fn set_delay_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_delay_seconds(input);
            self
        }
        /// Adds a key-value pair to `MessageAttributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>,
        /// and <code>Value</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS
        /// message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MessageAttributeValue>,
        ) -> Self {
            self.inner = self.inner.message_attributes(k, v);
            self
        }
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>,
        /// and <code>Value</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes">Amazon SQS
        /// message attributes</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_message_attributes(input);
            self
        }
        /// Adds a key-value pair to `MessageSystemAttributes`.
        ///
        /// To override the contents of this collection use [`set_message_system_attributes`](Self::set_message_system_attributes).
        ///
        /// <p>The message system attribute to send. Each message system attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>.</p>
        /// <important>
        /// <ul>
        /// <li>
        /// <p>Currently, the only supported message system attribute is <code>AWSTraceHeader</code>.
        /// Its type must be <code>String</code> and its value must be a correctly formatted
        /// X-Ray trace header string.</p>
        /// </li>
        /// <li>
        /// <p>The size of a message system attribute doesn't count towards the total size of a message.</p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn message_system_attributes(
            mut self,
            k: impl Into<crate::model::MessageSystemAttributeNameForSends>,
            v: impl Into<crate::model::MessageSystemAttributeValue>,
        ) -> Self {
            self.inner = self.inner.message_system_attributes(k, v);
            self
        }
        /// <p>The message system attribute to send. Each message system attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>.</p>
        /// <important>
        /// <ul>
        /// <li>
        /// <p>Currently, the only supported message system attribute is <code>AWSTraceHeader</code>.
        /// Its type must be <code>String</code> and its value must be a correctly formatted
        /// X-Ray trace header string.</p>
        /// </li>
        /// <li>
        /// <p>The size of a message system attribute doesn't count towards the total size of a message.</p>
        /// </li>
        /// </ul>
        /// </important>
        pub fn set_message_system_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::MessageSystemAttributeNameForSends,
                    crate::model::MessageSystemAttributeValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_message_system_attributes(input);
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The token used for deduplication of sent messages. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, any messages sent with the same <code>MessageDeduplicationId</code>
        /// are accepted successfully but aren't delivered during the 5-minute deduplication interval. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">
        /// Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>,</p>
        /// <ul>
        /// <li>
        /// <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue,
        /// Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set,
        /// the action fails with an error.</p>
        /// </li>
        /// <li>
        /// <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates
        /// and only one copy of the message is delivered.</p>
        /// </li>
        /// <li>
        /// <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same
        /// as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered.
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the
        /// message (this can be useful for troubleshooting delivery issues).</p>
        /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same
        /// <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate messages.</p>
        /// <p>Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.</p>
        /// </note>
        /// <p>The maximum length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and
        /// punctuation (<code>!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~</code>).</p>
        /// <p>For best practices of using <code>MessageDeduplicationId</code>, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the MessageDeduplicationId Property</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn message_deduplication_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_deduplication_id(inp);
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The token used for deduplication of sent messages. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, any messages sent with the same <code>MessageDeduplicationId</code>
        /// are accepted successfully but aren't delivered during the 5-minute deduplication interval. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">
        /// Exactly-once processing</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>,</p>
        /// <ul>
        /// <li>
        /// <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue,
        /// Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set,
        /// the action fails with an error.</p>
        /// </li>
        /// <li>
        /// <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates
        /// and only one copy of the message is delivered.</p>
        /// </li>
        /// <li>
        /// <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same
        /// as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered.
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the
        /// message (this can be useful for troubleshooting delivery issues).</p>
        /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same
        /// <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SQS can't detect duplicate messages.</p>
        /// <p>Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.</p>
        /// </note>
        /// <p>The maximum length of <code>MessageDeduplicationId</code> is 128 characters. <code>MessageDeduplicationId</code> can contain alphanumeric characters (<code>a-z</code>, <code>A-Z</code>, <code>0-9</code>) and
        /// punctuation (<code>!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~</code>).</p>
        /// <p>For best practices of using <code>MessageDeduplicationId</code>, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html">Using the MessageDeduplicationId Property</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_message_deduplication_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_message_deduplication_id(input);
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The tag that specifies that a message belongs to a specific message group. Messages
        /// that belong to the same message group are processed in a FIFO manner (however,
        /// messages in different message groups might be processed out of order). To interleave
        /// multiple ordered streams within a single queue, use <code>MessageGroupId</code> values
        /// (for example, session data for multiple users). In this scenario, multiple consumers can
        /// process the queue, but the session data of each user is processed in a FIFO
        /// fashion.</p>
        /// <ul>
        /// <li>
        /// <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't
        /// specify a <code>MessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length of <code>MessageGroupId</code> is 128 characters. Valid values: alphanumeric characters and punctuation <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
        /// <p>For best practices of using <code>MessageGroupId</code>, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html">Using the MessageGroupId Property</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <important>
        /// <p>
        /// <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.</p>
        /// </important>
        pub fn message_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message_group_id(inp);
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) queues.</p>
        /// <p>The tag that specifies that a message belongs to a specific message group. Messages
        /// that belong to the same message group are processed in a FIFO manner (however,
        /// messages in different message groups might be processed out of order). To interleave
        /// multiple ordered streams within a single queue, use <code>MessageGroupId</code> values
        /// (for example, session data for multiple users). In this scenario, multiple consumers can
        /// process the queue, but the session data of each user is processed in a FIFO
        /// fashion.</p>
        /// <ul>
        /// <li>
        /// <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessage</code> might return messages with multiple <code>MessageGroupId</code> values. For each <code>MessageGroupId</code>, the messages are sorted by time sent. The caller can't
        /// specify a <code>MessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length of <code>MessageGroupId</code> is 128 characters. Valid values: alphanumeric characters and punctuation <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
        /// <p>For best practices of using <code>MessageGroupId</code>, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html">Using the MessageGroupId Property</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        /// <important>
        /// <p>
        /// <code>MessageGroupId</code> is required for FIFO queues. You can't use it for Standard queues.</p>
        /// </important>
        pub fn set_message_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_message_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendMessageBatch`.
    ///
    /// <p>Delivers up to ten messages to the specified queue. This is a batch version of <code>
    /// <a>SendMessage</a>.</code> For a FIFO queue, multiple messages within a single batch are enqueued in the order they are sent.</p>
    /// <p>The result of sending each message is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of <code>200</code>.</p>
    /// <p>The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths of all of the batched messages) are both 256 KB (262,144 bytes).</p>
    /// <important>
    /// <p>A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:</p>
    /// <p>
    /// <code>#x9</code> | <code>#xA</code> | <code>#xD</code> | <code>#x20</code> to <code>#xD7FF</code> | <code>#xE000</code> to <code>#xFFFD</code> | <code>#x10000</code> to <code>#x10FFFF</code>
    /// </p>
    /// <p>Any characters not included in this list will be rejected. For more information, see the <a href="http://www.w3.org/TR/REC-xml/#charsets">W3C specification for characters</a>.</p>
    /// </important>
    /// <p>If you don't specify the <code>DelaySeconds</code> parameter for an entry, Amazon SQS uses the default value for the queue.</p>
    /// <p>Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values of <code>n</code> are integers starting from 1. For example, a parameter list with two elements looks like this:</p>
    /// <p>
    /// <code>&AttributeName.1=first</code>
    /// </p>
    /// <p>
    /// <code>&AttributeName.2=second</code>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct SendMessageBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_message_batch_input::Builder,
    }
    impl<C, M, R> SendMessageBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendMessageBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendMessageBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::SendMessageBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendMessageBatchInputOperationOutputAlias,
                crate::output::SendMessageBatchOutput,
                crate::error::SendMessageBatchError,
                crate::input::SendMessageBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue to which batched messages are sent.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue to which batched messages are sent.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of <code>
        /// <a>SendMessageBatchRequestEntry</a>
        /// </code> items.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::SendMessageBatchRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>A list of <code>
        /// <a>SendMessageBatchRequestEntry</a>
        /// </code> items.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SendMessageBatchRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetQueueAttributes`.
    ///
    /// <p>Sets the value of one or more queue attributes. When you change a queue's attributes, the change can take up to 60 seconds for most of the attributes to propagate throughout the Amazon SQS system.
    /// Changes made to the <code>MessageRetentionPeriod</code> attribute can take up to 15 minutes.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.</p>
    /// </li>
    /// <li>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>To remove the ability to change queue permissions, you must deny permission to the <code>AddPermission</code>, <code>RemovePermission</code>, and <code>SetQueueAttributes</code> actions in your IAM policy.</p>
    /// </li>
    /// </ul>          
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SetQueueAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_queue_attributes_input::Builder,
    }
    impl<C, M, R> SetQueueAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetQueueAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetQueueAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::SetQueueAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetQueueAttributesInputOperationOutputAlias,
                crate::output::SetQueueAttributesOutput,
                crate::error::SetQueueAttributesError,
                crate::input::SetQueueAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the Amazon SQS queue whose attributes are set.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the Amazon SQS queue whose attributes are set.</p>
        /// <p>Queue URLs and names are case-sensitive.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of attributes to set.</p>
        /// <p>The following lists the names, descriptions, and values of the special request parameters that the <code>SetQueueAttributes</code> action uses:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DelaySeconds</code> – The length of time, in seconds, for which the delivery of all messages in the queue is delayed. Valid values: An integer from 0 to 900 (15 minutes). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaximumMessageSize</code> – The limit of how many bytes a message can contain before Amazon SQS rejects it. Valid values: An integer from 1,024 bytes (1 KiB) up to 262,144 bytes (256 KiB). Default: 262,144 (256 KiB).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRetentionPeriod</code> – The length of time, in seconds, for which Amazon SQS retains a message. Valid values: An integer representing seconds, from 60 (1 minute) to 1,209,600 (14 days). Default: 345,600 (4 days).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The queue's policy. A valid Amazon Web Services policy. For more information about policy structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PoliciesOverview.html">Overview of Amazon Web Services IAM Policies</a>
        /// in the <i>Identity and Access Management User Guide</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessageWaitTimeSeconds</code> – The length of time, in seconds, for which a <code>
        /// <a>ReceiveMessage</a>
        /// </code> action waits for a message to arrive. Valid values: An integer from 0 to 20 (seconds). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityTimeout</code> – The visibility timeout for the queue, in seconds. Valid values: An integer from 0 to 43,200 (12 hours). Default: 30. For more information about the visibility timeout,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">dead-letter queues:</a>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
        /// of the source queue as a JSON object. The parameters are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to
        /// which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
        /// moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code>
        /// for a queue, Amazon SQS moves the message to the dead-letter-queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
        /// queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters are as follows:</p>              
        /// <ul>
        /// <li>
        /// <p>
        /// <code>redrivePermission</code> – The permission type that defines which source queues can
        /// specify the current queue as the dead-letter queue. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
        /// specify this queue as the dead-letter queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>denyAll</code> – No source queues can specify this queue as the dead-letter
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
        /// this queue as the dead-letter queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
        /// this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
        /// <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue ARNs.
        /// To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter
        /// to <code>allowAll</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The dead-letter queue of a
        /// FIFO queue must also be a FIFO queue. Similarly, the dead-letter
        /// queue of a standard queue must also be a standard queue.</p>
        /// </note>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">server-side-encryption</a>:</p>     
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SQS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms">Key Terms</a>.
        /// While the alias of the AWS-managed CMK for Amazon SQS is always <code>alias/aws/sqs</code>, the alias of a custom CMK can, for example, be <code>alias/<i>MyAlias</i>
        /// </code>.
        /// For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API Reference</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsDataKeyReusePeriodSeconds</code> – The length of time, in seconds, for which Amazon SQS can reuse a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys">data key</a> to encrypt
        /// or decrypt messages before calling KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). Default: 300 (5 minutes). A shorter time period provides better security
        /// but results in more calls to KMS which might incur charges after Free Tier. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">How Does the Data Key Reuse Period Work?</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO (first-in-first-out) queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">Exactly-once processing</a> in the
        /// <i>Amazon SQS Developer Guide</i>. Note the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
        /// <ul>
        /// <li>
        /// <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue,
        /// Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set,
        /// the action fails with an error.</p>
        /// </li>
        /// <li>
        /// <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates
        /// and only one copy of the message is delivered.</p>
        /// </li>
        /// <li>
        /// <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same
        /// as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered.
        /// </p>
        /// </li>
        /// </ul>  
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high throughput
        /// for FIFO queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the
        /// message group or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput
        /// quota applies to the entire queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>.
        /// The <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is <code>messageGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <p>To enable high throughput for FIFO queues, do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Set <code>DeduplicationScope</code> to <code>messageGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If you set these attributes to anything other than the values shown for enabling high
        /// throughput, normal throughput is in effect and deduplication occurs as specified.</p>
        /// <p>For information on throughput quotas,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<crate::model::QueueAttributeName>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>A map of attributes to set.</p>
        /// <p>The following lists the names, descriptions, and values of the special request parameters that the <code>SetQueueAttributes</code> action uses:</p>      
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DelaySeconds</code> – The length of time, in seconds, for which the delivery of all messages in the queue is delayed. Valid values: An integer from 0 to 900 (15 minutes). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaximumMessageSize</code> – The limit of how many bytes a message can contain before Amazon SQS rejects it. Valid values: An integer from 1,024 bytes (1 KiB) up to 262,144 bytes (256 KiB). Default: 262,144 (256 KiB).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MessageRetentionPeriod</code> – The length of time, in seconds, for which Amazon SQS retains a message. Valid values: An integer representing seconds, from 60 (1 minute) to 1,209,600 (14 days). Default: 345,600 (4 days).
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The queue's policy. A valid Amazon Web Services policy. For more information about policy structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PoliciesOverview.html">Overview of Amazon Web Services IAM Policies</a>
        /// in the <i>Identity and Access Management User Guide</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReceiveMessageWaitTimeSeconds</code> – The length of time, in seconds, for which a <code>
        /// <a>ReceiveMessage</a>
        /// </code> action waits for a message to arrive. Valid values: An integer from 0 to 20 (seconds). Default: 0.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VisibilityTimeout</code> – The visibility timeout for the queue, in seconds. Valid values: An integer from 0 to 43,200 (12 hours). Default: 30. For more information about the visibility timeout,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility Timeout</a> in the <i>Amazon SQS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">dead-letter queues:</a>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – The string that includes the parameters for the dead-letter queue functionality
        /// of the source queue as a JSON object. The parameters are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>deadLetterTargetArn</code> – The Amazon Resource Name (ARN) of the dead-letter queue to
        /// which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maxReceiveCount</code> – The number of times a message is delivered to the source queue before being
        /// moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code>
        /// for a queue, Amazon SQS moves the message to the dead-letter-queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedriveAllowPolicy</code> – The string that includes the parameters for the permissions for the dead-letter
        /// queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters are as follows:</p>              
        /// <ul>
        /// <li>
        /// <p>
        /// <code>redrivePermission</code> – The permission type that defines which source queues can
        /// specify the current queue as the dead-letter queue. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allowAll</code> – (Default) Any source queues in this Amazon Web Services account in the same Region can
        /// specify this queue as the dead-letter queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>denyAll</code> – No source queues can specify this queue as the dead-letter
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>byQueue</code> – Only queues specified by the <code>sourceQueueArns</code> parameter can specify
        /// this queue as the dead-letter queue.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sourceQueueArns</code> – The Amazon Resource Names (ARN)s of the source queues that can specify
        /// this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the
        /// <code>redrivePermission</code> parameter is set to <code>byQueue</code>. You can specify up to 10 source queue ARNs.
        /// To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter
        /// to <code>allowAll</code>.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The dead-letter queue of a
        /// FIFO queue must also be a FIFO queue. Similarly, the dead-letter
        /// queue of a standard queue must also be a standard queue.</p>
        /// </note>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">server-side-encryption</a>:</p>     
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SQS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms">Key Terms</a>.
        /// While the alias of the AWS-managed CMK for Amazon SQS is always <code>alias/aws/sqs</code>, the alias of a custom CMK can, for example, be <code>alias/<i>MyAlias</i>
        /// </code>.
        /// For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API Reference</i>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KmsDataKeyReusePeriodSeconds</code> – The length of time, in seconds, for which Amazon SQS can reuse a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys">data key</a> to encrypt
        /// or decrypt messages before calling KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). Default: 300 (5 minutes). A shorter time period provides better security
        /// but results in more calls to KMS which might incur charges after Free Tier. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">How Does the Data Key Reuse Period Work?</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO (first-in-first-out) queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html">Exactly-once processing</a> in the
        /// <i>Amazon SQS Developer Guide</i>. Note the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
        /// <ul>
        /// <li>
        /// <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p>
        /// </li>
        /// <li>
        /// <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your queue,
        /// Amazon SQS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you don't provide a <code>MessageDeduplicationId</code> and the queue doesn't have <code>ContentBasedDeduplication</code> set,
        /// the action fails with an error.</p>
        /// </li>
        /// <li>
        /// <p>If the queue has <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates
        /// and only one copy of the message is delivered.</p>
        /// </li>
        /// <li>
        /// <p>If you send one message with <code>ContentBasedDeduplication</code> enabled and then another message with a <code>MessageDeduplicationId</code> that is the same
        /// as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered.
        /// </p>
        /// </li>
        /// </ul>  
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to
        /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">high throughput
        /// for FIFO queues</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeduplicationScope</code> – Specifies whether message deduplication occurs at the
        /// message group or queue level. Valid values are <code>messageGroup</code> and <code>queue</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoThroughputLimit</code> – Specifies whether the FIFO queue throughput
        /// quota applies to the entire queue or per message group. Valid values are <code>perQueue</code> and <code>perMessageGroupId</code>.
        /// The <code>perMessageGroupId</code> value is allowed only when the value for <code>DeduplicationScope</code> is <code>messageGroup</code>.</p>
        /// </li>
        /// </ul>
        /// <p>To enable high throughput for FIFO queues, do the following:</p>
        /// <ul>
        /// <li>
        /// <p>Set <code>DeduplicationScope</code> to <code>messageGroup</code>.</p>
        /// </li>
        /// <li>
        /// <p>Set <code>FifoThroughputLimit</code> to <code>perMessageGroupId</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If you set these attributes to anything other than the values shown for enabling high
        /// throughput, normal throughput is in effect and deduplication occurs as specified.</p>
        /// <p>For information on throughput quotas,
        /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a>
        /// in the <i>Amazon SQS Developer Guide</i>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::QueueAttributeName, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagQueue`.
    ///
    /// <p>Add cost allocation tags to the specified Amazon SQS queue. For an overview, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html">Tagging
    /// Your Amazon SQS Queues</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    ///
    /// <p>When you use queue tags, keep the following guidelines in mind:</p>
    /// <ul>
    /// <li>
    /// <p>Adding more than 50 tags to a queue isn't recommended.</p>
    /// </li>
    /// <li>
    /// <p>Tags don't have any semantic meaning. Amazon SQS interprets tags as character strings.</p>
    /// </li>
    /// <li>
    /// <p>Tags are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>A new tag with a key identical to that of an existing tag overwrites the existing tag.</p>
    /// </li>
    /// </ul>
    /// <p>For a full list of tag restrictions, see
    /// <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues">Quotas related to queues</a>
    /// in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <note>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_queue_input::Builder,
    }
    impl<C, M, R> TagQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::TagQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagQueueInputOperationOutputAlias,
                crate::output::TagQueueOutput,
                crate::error::TagQueueError,
                crate::input::TagQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the queue.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the queue.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to be added to the specified queue.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The list of tags to be added to the specified queue.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagQueue`.
    ///
    /// <p>Remove cost allocation tags from the specified Amazon SQS queue. For an overview, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html">Tagging
    /// Your Amazon SQS Queues</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// <note>
    /// <p>Cross-account permissions don't apply to this action. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name">Grant
    /// cross-account permissions to a role and a user name</a> in the <i>Amazon SQS Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UntagQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_queue_input::Builder,
    }
    impl<C, M, R> UntagQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagQueueInputOperationOutputAlias,
                crate::output::UntagQueueOutput,
                crate::error::UntagQueueError,
                crate::input::UntagQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the queue.</p>
        pub fn queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_url(inp);
            self
        }
        /// <p>The URL of the queue.</p>
        pub fn set_queue_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_url(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tags to be removed from the specified queue.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tags to be removed from the specified queue.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
