// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_permission`](crate::client::Client::add_permission).
///
/// See [`crate::client::fluent_builders::AddPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddPermission {
    _private: (),
}
impl AddPermission {
    /// Creates a new builder-style object to manufacture [`AddPermissionInput`](crate::input::AddPermissionInput)
    pub fn builder() -> crate::input::add_permission_input::Builder {
        crate::input::add_permission_input::Builder::default()
    }
    /// Creates a new `AddPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddPermission {
    type Output =
        std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_permission_error(response)
        } else {
            crate::operation_deser::parse_add_permission_response(response)
        }
    }
}

/// Operation shape for `CheckIfPhoneNumberIsOptedOut`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`check_if_phone_number_is_opted_out`](crate::client::Client::check_if_phone_number_is_opted_out).
///
/// See [`crate::client::fluent_builders::CheckIfPhoneNumberIsOptedOut`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CheckIfPhoneNumberIsOptedOut {
    _private: (),
}
impl CheckIfPhoneNumberIsOptedOut {
    /// Creates a new builder-style object to manufacture [`CheckIfPhoneNumberIsOptedOutInput`](crate::input::CheckIfPhoneNumberIsOptedOutInput)
    pub fn builder() -> crate::input::check_if_phone_number_is_opted_out_input::Builder {
        crate::input::check_if_phone_number_is_opted_out_input::Builder::default()
    }
    /// Creates a new `CheckIfPhoneNumberIsOptedOut` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CheckIfPhoneNumberIsOptedOut {
    type Output = std::result::Result<
        crate::output::CheckIfPhoneNumberIsOptedOutOutput,
        crate::error::CheckIfPhoneNumberIsOptedOutError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_check_if_phone_number_is_opted_out_error(response)
        } else {
            crate::operation_deser::parse_check_if_phone_number_is_opted_out_response(response)
        }
    }
}

/// Operation shape for `ConfirmSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`confirm_subscription`](crate::client::Client::confirm_subscription).
///
/// See [`crate::client::fluent_builders::ConfirmSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfirmSubscription {
    _private: (),
}
impl ConfirmSubscription {
    /// Creates a new builder-style object to manufacture [`ConfirmSubscriptionInput`](crate::input::ConfirmSubscriptionInput)
    pub fn builder() -> crate::input::confirm_subscription_input::Builder {
        crate::input::confirm_subscription_input::Builder::default()
    }
    /// Creates a new `ConfirmSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfirmSubscription {
    type Output = std::result::Result<
        crate::output::ConfirmSubscriptionOutput,
        crate::error::ConfirmSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_confirm_subscription_error(response)
        } else {
            crate::operation_deser::parse_confirm_subscription_response(response)
        }
    }
}

/// Operation shape for `CreatePlatformApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_platform_application`](crate::client::Client::create_platform_application).
///
/// See [`crate::client::fluent_builders::CreatePlatformApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePlatformApplication {
    _private: (),
}
impl CreatePlatformApplication {
    /// Creates a new builder-style object to manufacture [`CreatePlatformApplicationInput`](crate::input::CreatePlatformApplicationInput)
    pub fn builder() -> crate::input::create_platform_application_input::Builder {
        crate::input::create_platform_application_input::Builder::default()
    }
    /// Creates a new `CreatePlatformApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePlatformApplication {
    type Output = std::result::Result<
        crate::output::CreatePlatformApplicationOutput,
        crate::error::CreatePlatformApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_platform_application_error(response)
        } else {
            crate::operation_deser::parse_create_platform_application_response(response)
        }
    }
}

/// Operation shape for `CreatePlatformEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_platform_endpoint`](crate::client::Client::create_platform_endpoint).
///
/// See [`crate::client::fluent_builders::CreatePlatformEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePlatformEndpoint {
    _private: (),
}
impl CreatePlatformEndpoint {
    /// Creates a new builder-style object to manufacture [`CreatePlatformEndpointInput`](crate::input::CreatePlatformEndpointInput)
    pub fn builder() -> crate::input::create_platform_endpoint_input::Builder {
        crate::input::create_platform_endpoint_input::Builder::default()
    }
    /// Creates a new `CreatePlatformEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePlatformEndpoint {
    type Output = std::result::Result<
        crate::output::CreatePlatformEndpointOutput,
        crate::error::CreatePlatformEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_platform_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_platform_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateSMSSandboxPhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sms_sandbox_phone_number`](crate::client::Client::create_sms_sandbox_phone_number).
///
/// See [`crate::client::fluent_builders::CreateSMSSandboxPhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSMSSandboxPhoneNumber {
    _private: (),
}
impl CreateSMSSandboxPhoneNumber {
    /// Creates a new builder-style object to manufacture [`CreateSmsSandboxPhoneNumberInput`](crate::input::CreateSmsSandboxPhoneNumberInput)
    pub fn builder() -> crate::input::create_sms_sandbox_phone_number_input::Builder {
        crate::input::create_sms_sandbox_phone_number_input::Builder::default()
    }
    /// Creates a new `CreateSMSSandboxPhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSMSSandboxPhoneNumber {
    type Output = std::result::Result<
        crate::output::CreateSmsSandboxPhoneNumberOutput,
        crate::error::CreateSMSSandboxPhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_sms_sandbox_phone_number_error(response)
        } else {
            crate::operation_deser::parse_create_sms_sandbox_phone_number_response(response)
        }
    }
}

/// Operation shape for `CreateTopic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_topic`](crate::client::Client::create_topic).
///
/// See [`crate::client::fluent_builders::CreateTopic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTopic {
    _private: (),
}
impl CreateTopic {
    /// Creates a new builder-style object to manufacture [`CreateTopicInput`](crate::input::CreateTopicInput)
    pub fn builder() -> crate::input::create_topic_input::Builder {
        crate::input::create_topic_input::Builder::default()
    }
    /// Creates a new `CreateTopic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTopic {
    type Output =
        std::result::Result<crate::output::CreateTopicOutput, crate::error::CreateTopicError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_topic_error(response)
        } else {
            crate::operation_deser::parse_create_topic_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint`](crate::client::Client::delete_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpoint {
    _private: (),
}
impl DeleteEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpoint {
    type Output =
        std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeletePlatformApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_platform_application`](crate::client::Client::delete_platform_application).
///
/// See [`crate::client::fluent_builders::DeletePlatformApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePlatformApplication {
    _private: (),
}
impl DeletePlatformApplication {
    /// Creates a new builder-style object to manufacture [`DeletePlatformApplicationInput`](crate::input::DeletePlatformApplicationInput)
    pub fn builder() -> crate::input::delete_platform_application_input::Builder {
        crate::input::delete_platform_application_input::Builder::default()
    }
    /// Creates a new `DeletePlatformApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePlatformApplication {
    type Output = std::result::Result<
        crate::output::DeletePlatformApplicationOutput,
        crate::error::DeletePlatformApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_platform_application_error(response)
        } else {
            crate::operation_deser::parse_delete_platform_application_response(response)
        }
    }
}

/// Operation shape for `DeleteSMSSandboxPhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_sms_sandbox_phone_number`](crate::client::Client::delete_sms_sandbox_phone_number).
///
/// See [`crate::client::fluent_builders::DeleteSMSSandboxPhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSMSSandboxPhoneNumber {
    _private: (),
}
impl DeleteSMSSandboxPhoneNumber {
    /// Creates a new builder-style object to manufacture [`DeleteSmsSandboxPhoneNumberInput`](crate::input::DeleteSmsSandboxPhoneNumberInput)
    pub fn builder() -> crate::input::delete_sms_sandbox_phone_number_input::Builder {
        crate::input::delete_sms_sandbox_phone_number_input::Builder::default()
    }
    /// Creates a new `DeleteSMSSandboxPhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSMSSandboxPhoneNumber {
    type Output = std::result::Result<
        crate::output::DeleteSmsSandboxPhoneNumberOutput,
        crate::error::DeleteSMSSandboxPhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_sms_sandbox_phone_number_error(response)
        } else {
            crate::operation_deser::parse_delete_sms_sandbox_phone_number_response(response)
        }
    }
}

/// Operation shape for `DeleteTopic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_topic`](crate::client::Client::delete_topic).
///
/// See [`crate::client::fluent_builders::DeleteTopic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTopic {
    _private: (),
}
impl DeleteTopic {
    /// Creates a new builder-style object to manufacture [`DeleteTopicInput`](crate::input::DeleteTopicInput)
    pub fn builder() -> crate::input::delete_topic_input::Builder {
        crate::input::delete_topic_input::Builder::default()
    }
    /// Creates a new `DeleteTopic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTopic {
    type Output =
        std::result::Result<crate::output::DeleteTopicOutput, crate::error::DeleteTopicError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_topic_error(response)
        } else {
            crate::operation_deser::parse_delete_topic_response(response)
        }
    }
}

/// Operation shape for `GetEndpointAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_endpoint_attributes`](crate::client::Client::get_endpoint_attributes).
///
/// See [`crate::client::fluent_builders::GetEndpointAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEndpointAttributes {
    _private: (),
}
impl GetEndpointAttributes {
    /// Creates a new builder-style object to manufacture [`GetEndpointAttributesInput`](crate::input::GetEndpointAttributesInput)
    pub fn builder() -> crate::input::get_endpoint_attributes_input::Builder {
        crate::input::get_endpoint_attributes_input::Builder::default()
    }
    /// Creates a new `GetEndpointAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEndpointAttributes {
    type Output = std::result::Result<
        crate::output::GetEndpointAttributesOutput,
        crate::error::GetEndpointAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_endpoint_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_endpoint_attributes_response(response)
        }
    }
}

/// Operation shape for `GetPlatformApplicationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_platform_application_attributes`](crate::client::Client::get_platform_application_attributes).
///
/// See [`crate::client::fluent_builders::GetPlatformApplicationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPlatformApplicationAttributes {
    _private: (),
}
impl GetPlatformApplicationAttributes {
    /// Creates a new builder-style object to manufacture [`GetPlatformApplicationAttributesInput`](crate::input::GetPlatformApplicationAttributesInput)
    pub fn builder() -> crate::input::get_platform_application_attributes_input::Builder {
        crate::input::get_platform_application_attributes_input::Builder::default()
    }
    /// Creates a new `GetPlatformApplicationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPlatformApplicationAttributes {
    type Output = std::result::Result<
        crate::output::GetPlatformApplicationAttributesOutput,
        crate::error::GetPlatformApplicationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_platform_application_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_platform_application_attributes_response(response)
        }
    }
}

/// Operation shape for `GetSMSAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sms_attributes`](crate::client::Client::get_sms_attributes).
///
/// See [`crate::client::fluent_builders::GetSMSAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSMSAttributes {
    _private: (),
}
impl GetSMSAttributes {
    /// Creates a new builder-style object to manufacture [`GetSmsAttributesInput`](crate::input::GetSmsAttributesInput)
    pub fn builder() -> crate::input::get_sms_attributes_input::Builder {
        crate::input::get_sms_attributes_input::Builder::default()
    }
    /// Creates a new `GetSMSAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSMSAttributes {
    type Output = std::result::Result<
        crate::output::GetSmsAttributesOutput,
        crate::error::GetSMSAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sms_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_sms_attributes_response(response)
        }
    }
}

/// Operation shape for `GetSMSSandboxAccountStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sms_sandbox_account_status`](crate::client::Client::get_sms_sandbox_account_status).
///
/// See [`crate::client::fluent_builders::GetSMSSandboxAccountStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSMSSandboxAccountStatus {
    _private: (),
}
impl GetSMSSandboxAccountStatus {
    /// Creates a new builder-style object to manufacture [`GetSmsSandboxAccountStatusInput`](crate::input::GetSmsSandboxAccountStatusInput)
    pub fn builder() -> crate::input::get_sms_sandbox_account_status_input::Builder {
        crate::input::get_sms_sandbox_account_status_input::Builder::default()
    }
    /// Creates a new `GetSMSSandboxAccountStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSMSSandboxAccountStatus {
    type Output = std::result::Result<
        crate::output::GetSmsSandboxAccountStatusOutput,
        crate::error::GetSMSSandboxAccountStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sms_sandbox_account_status_error(response)
        } else {
            crate::operation_deser::parse_get_sms_sandbox_account_status_response(response)
        }
    }
}

/// Operation shape for `GetSubscriptionAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_subscription_attributes`](crate::client::Client::get_subscription_attributes).
///
/// See [`crate::client::fluent_builders::GetSubscriptionAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSubscriptionAttributes {
    _private: (),
}
impl GetSubscriptionAttributes {
    /// Creates a new builder-style object to manufacture [`GetSubscriptionAttributesInput`](crate::input::GetSubscriptionAttributesInput)
    pub fn builder() -> crate::input::get_subscription_attributes_input::Builder {
        crate::input::get_subscription_attributes_input::Builder::default()
    }
    /// Creates a new `GetSubscriptionAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSubscriptionAttributes {
    type Output = std::result::Result<
        crate::output::GetSubscriptionAttributesOutput,
        crate::error::GetSubscriptionAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_subscription_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_subscription_attributes_response(response)
        }
    }
}

/// Operation shape for `GetTopicAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_topic_attributes`](crate::client::Client::get_topic_attributes).
///
/// See [`crate::client::fluent_builders::GetTopicAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTopicAttributes {
    _private: (),
}
impl GetTopicAttributes {
    /// Creates a new builder-style object to manufacture [`GetTopicAttributesInput`](crate::input::GetTopicAttributesInput)
    pub fn builder() -> crate::input::get_topic_attributes_input::Builder {
        crate::input::get_topic_attributes_input::Builder::default()
    }
    /// Creates a new `GetTopicAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTopicAttributes {
    type Output = std::result::Result<
        crate::output::GetTopicAttributesOutput,
        crate::error::GetTopicAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_topic_attributes_error(response)
        } else {
            crate::operation_deser::parse_get_topic_attributes_response(response)
        }
    }
}

/// Operation shape for `ListEndpointsByPlatformApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_endpoints_by_platform_application`](crate::client::Client::list_endpoints_by_platform_application).
///
/// See [`crate::client::fluent_builders::ListEndpointsByPlatformApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEndpointsByPlatformApplication {
    _private: (),
}
impl ListEndpointsByPlatformApplication {
    /// Creates a new builder-style object to manufacture [`ListEndpointsByPlatformApplicationInput`](crate::input::ListEndpointsByPlatformApplicationInput)
    pub fn builder() -> crate::input::list_endpoints_by_platform_application_input::Builder {
        crate::input::list_endpoints_by_platform_application_input::Builder::default()
    }
    /// Creates a new `ListEndpointsByPlatformApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEndpointsByPlatformApplication {
    type Output = std::result::Result<
        crate::output::ListEndpointsByPlatformApplicationOutput,
        crate::error::ListEndpointsByPlatformApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_endpoints_by_platform_application_error(response)
        } else {
            crate::operation_deser::parse_list_endpoints_by_platform_application_response(response)
        }
    }
}

/// Operation shape for `ListOriginationNumbers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_origination_numbers`](crate::client::Client::list_origination_numbers).
///
/// See [`crate::client::fluent_builders::ListOriginationNumbers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOriginationNumbers {
    _private: (),
}
impl ListOriginationNumbers {
    /// Creates a new builder-style object to manufacture [`ListOriginationNumbersInput`](crate::input::ListOriginationNumbersInput)
    pub fn builder() -> crate::input::list_origination_numbers_input::Builder {
        crate::input::list_origination_numbers_input::Builder::default()
    }
    /// Creates a new `ListOriginationNumbers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOriginationNumbers {
    type Output = std::result::Result<
        crate::output::ListOriginationNumbersOutput,
        crate::error::ListOriginationNumbersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_origination_numbers_error(response)
        } else {
            crate::operation_deser::parse_list_origination_numbers_response(response)
        }
    }
}

/// Operation shape for `ListPhoneNumbersOptedOut`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_phone_numbers_opted_out`](crate::client::Client::list_phone_numbers_opted_out).
///
/// See [`crate::client::fluent_builders::ListPhoneNumbersOptedOut`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPhoneNumbersOptedOut {
    _private: (),
}
impl ListPhoneNumbersOptedOut {
    /// Creates a new builder-style object to manufacture [`ListPhoneNumbersOptedOutInput`](crate::input::ListPhoneNumbersOptedOutInput)
    pub fn builder() -> crate::input::list_phone_numbers_opted_out_input::Builder {
        crate::input::list_phone_numbers_opted_out_input::Builder::default()
    }
    /// Creates a new `ListPhoneNumbersOptedOut` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPhoneNumbersOptedOut {
    type Output = std::result::Result<
        crate::output::ListPhoneNumbersOptedOutOutput,
        crate::error::ListPhoneNumbersOptedOutError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_phone_numbers_opted_out_error(response)
        } else {
            crate::operation_deser::parse_list_phone_numbers_opted_out_response(response)
        }
    }
}

/// Operation shape for `ListPlatformApplications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_platform_applications`](crate::client::Client::list_platform_applications).
///
/// See [`crate::client::fluent_builders::ListPlatformApplications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPlatformApplications {
    _private: (),
}
impl ListPlatformApplications {
    /// Creates a new builder-style object to manufacture [`ListPlatformApplicationsInput`](crate::input::ListPlatformApplicationsInput)
    pub fn builder() -> crate::input::list_platform_applications_input::Builder {
        crate::input::list_platform_applications_input::Builder::default()
    }
    /// Creates a new `ListPlatformApplications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPlatformApplications {
    type Output = std::result::Result<
        crate::output::ListPlatformApplicationsOutput,
        crate::error::ListPlatformApplicationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_platform_applications_error(response)
        } else {
            crate::operation_deser::parse_list_platform_applications_response(response)
        }
    }
}

/// Operation shape for `ListSMSSandboxPhoneNumbers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sms_sandbox_phone_numbers`](crate::client::Client::list_sms_sandbox_phone_numbers).
///
/// See [`crate::client::fluent_builders::ListSMSSandboxPhoneNumbers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSMSSandboxPhoneNumbers {
    _private: (),
}
impl ListSMSSandboxPhoneNumbers {
    /// Creates a new builder-style object to manufacture [`ListSmsSandboxPhoneNumbersInput`](crate::input::ListSmsSandboxPhoneNumbersInput)
    pub fn builder() -> crate::input::list_sms_sandbox_phone_numbers_input::Builder {
        crate::input::list_sms_sandbox_phone_numbers_input::Builder::default()
    }
    /// Creates a new `ListSMSSandboxPhoneNumbers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSMSSandboxPhoneNumbers {
    type Output = std::result::Result<
        crate::output::ListSmsSandboxPhoneNumbersOutput,
        crate::error::ListSMSSandboxPhoneNumbersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sms_sandbox_phone_numbers_error(response)
        } else {
            crate::operation_deser::parse_list_sms_sandbox_phone_numbers_response(response)
        }
    }
}

/// Operation shape for `ListSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_subscriptions`](crate::client::Client::list_subscriptions).
///
/// See [`crate::client::fluent_builders::ListSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSubscriptions {
    _private: (),
}
impl ListSubscriptions {
    /// Creates a new builder-style object to manufacture [`ListSubscriptionsInput`](crate::input::ListSubscriptionsInput)
    pub fn builder() -> crate::input::list_subscriptions_input::Builder {
        crate::input::list_subscriptions_input::Builder::default()
    }
    /// Creates a new `ListSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSubscriptions {
    type Output = std::result::Result<
        crate::output::ListSubscriptionsOutput,
        crate::error::ListSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_list_subscriptions_response(response)
        }
    }
}

/// Operation shape for `ListSubscriptionsByTopic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_subscriptions_by_topic`](crate::client::Client::list_subscriptions_by_topic).
///
/// See [`crate::client::fluent_builders::ListSubscriptionsByTopic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSubscriptionsByTopic {
    _private: (),
}
impl ListSubscriptionsByTopic {
    /// Creates a new builder-style object to manufacture [`ListSubscriptionsByTopicInput`](crate::input::ListSubscriptionsByTopicInput)
    pub fn builder() -> crate::input::list_subscriptions_by_topic_input::Builder {
        crate::input::list_subscriptions_by_topic_input::Builder::default()
    }
    /// Creates a new `ListSubscriptionsByTopic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSubscriptionsByTopic {
    type Output = std::result::Result<
        crate::output::ListSubscriptionsByTopicOutput,
        crate::error::ListSubscriptionsByTopicError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_subscriptions_by_topic_error(response)
        } else {
            crate::operation_deser::parse_list_subscriptions_by_topic_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTopics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_topics`](crate::client::Client::list_topics).
///
/// See [`crate::client::fluent_builders::ListTopics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTopics {
    _private: (),
}
impl ListTopics {
    /// Creates a new builder-style object to manufacture [`ListTopicsInput`](crate::input::ListTopicsInput)
    pub fn builder() -> crate::input::list_topics_input::Builder {
        crate::input::list_topics_input::Builder::default()
    }
    /// Creates a new `ListTopics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTopics {
    type Output =
        std::result::Result<crate::output::ListTopicsOutput, crate::error::ListTopicsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_topics_error(response)
        } else {
            crate::operation_deser::parse_list_topics_response(response)
        }
    }
}

/// Operation shape for `OptInPhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`opt_in_phone_number`](crate::client::Client::opt_in_phone_number).
///
/// See [`crate::client::fluent_builders::OptInPhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct OptInPhoneNumber {
    _private: (),
}
impl OptInPhoneNumber {
    /// Creates a new builder-style object to manufacture [`OptInPhoneNumberInput`](crate::input::OptInPhoneNumberInput)
    pub fn builder() -> crate::input::opt_in_phone_number_input::Builder {
        crate::input::opt_in_phone_number_input::Builder::default()
    }
    /// Creates a new `OptInPhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for OptInPhoneNumber {
    type Output = std::result::Result<
        crate::output::OptInPhoneNumberOutput,
        crate::error::OptInPhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_opt_in_phone_number_error(response)
        } else {
            crate::operation_deser::parse_opt_in_phone_number_response(response)
        }
    }
}

/// Operation shape for `Publish`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish`](crate::client::Client::publish).
///
/// See [`crate::client::fluent_builders::Publish`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Publish {
    _private: (),
}
impl Publish {
    /// Creates a new builder-style object to manufacture [`PublishInput`](crate::input::PublishInput)
    pub fn builder() -> crate::input::publish_input::Builder {
        crate::input::publish_input::Builder::default()
    }
    /// Creates a new `Publish` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Publish {
    type Output = std::result::Result<crate::output::PublishOutput, crate::error::PublishError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_publish_error(response)
        } else {
            crate::operation_deser::parse_publish_response(response)
        }
    }
}

/// Operation shape for `PublishBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_batch`](crate::client::Client::publish_batch).
///
/// See [`crate::client::fluent_builders::PublishBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishBatch {
    _private: (),
}
impl PublishBatch {
    /// Creates a new builder-style object to manufacture [`PublishBatchInput`](crate::input::PublishBatchInput)
    pub fn builder() -> crate::input::publish_batch_input::Builder {
        crate::input::publish_batch_input::Builder::default()
    }
    /// Creates a new `PublishBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishBatch {
    type Output =
        std::result::Result<crate::output::PublishBatchOutput, crate::error::PublishBatchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_publish_batch_error(response)
        } else {
            crate::operation_deser::parse_publish_batch_response(response)
        }
    }
}

/// Operation shape for `RemovePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_permission`](crate::client::Client::remove_permission).
///
/// See [`crate::client::fluent_builders::RemovePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemovePermission {
    _private: (),
}
impl RemovePermission {
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
    /// Creates a new `RemovePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemovePermission {
    type Output = std::result::Result<
        crate::output::RemovePermissionOutput,
        crate::error::RemovePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_permission_error(response)
        } else {
            crate::operation_deser::parse_remove_permission_response(response)
        }
    }
}

/// Operation shape for `SetEndpointAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_endpoint_attributes`](crate::client::Client::set_endpoint_attributes).
///
/// See [`crate::client::fluent_builders::SetEndpointAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetEndpointAttributes {
    _private: (),
}
impl SetEndpointAttributes {
    /// Creates a new builder-style object to manufacture [`SetEndpointAttributesInput`](crate::input::SetEndpointAttributesInput)
    pub fn builder() -> crate::input::set_endpoint_attributes_input::Builder {
        crate::input::set_endpoint_attributes_input::Builder::default()
    }
    /// Creates a new `SetEndpointAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetEndpointAttributes {
    type Output = std::result::Result<
        crate::output::SetEndpointAttributesOutput,
        crate::error::SetEndpointAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_endpoint_attributes_error(response)
        } else {
            crate::operation_deser::parse_set_endpoint_attributes_response(response)
        }
    }
}

/// Operation shape for `SetPlatformApplicationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_platform_application_attributes`](crate::client::Client::set_platform_application_attributes).
///
/// See [`crate::client::fluent_builders::SetPlatformApplicationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetPlatformApplicationAttributes {
    _private: (),
}
impl SetPlatformApplicationAttributes {
    /// Creates a new builder-style object to manufacture [`SetPlatformApplicationAttributesInput`](crate::input::SetPlatformApplicationAttributesInput)
    pub fn builder() -> crate::input::set_platform_application_attributes_input::Builder {
        crate::input::set_platform_application_attributes_input::Builder::default()
    }
    /// Creates a new `SetPlatformApplicationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetPlatformApplicationAttributes {
    type Output = std::result::Result<
        crate::output::SetPlatformApplicationAttributesOutput,
        crate::error::SetPlatformApplicationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_platform_application_attributes_error(response)
        } else {
            crate::operation_deser::parse_set_platform_application_attributes_response(response)
        }
    }
}

/// Operation shape for `SetSMSAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_sms_attributes`](crate::client::Client::set_sms_attributes).
///
/// See [`crate::client::fluent_builders::SetSMSAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetSMSAttributes {
    _private: (),
}
impl SetSMSAttributes {
    /// Creates a new builder-style object to manufacture [`SetSmsAttributesInput`](crate::input::SetSmsAttributesInput)
    pub fn builder() -> crate::input::set_sms_attributes_input::Builder {
        crate::input::set_sms_attributes_input::Builder::default()
    }
    /// Creates a new `SetSMSAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetSMSAttributes {
    type Output = std::result::Result<
        crate::output::SetSmsAttributesOutput,
        crate::error::SetSMSAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_sms_attributes_error(response)
        } else {
            crate::operation_deser::parse_set_sms_attributes_response(response)
        }
    }
}

/// Operation shape for `SetSubscriptionAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_subscription_attributes`](crate::client::Client::set_subscription_attributes).
///
/// See [`crate::client::fluent_builders::SetSubscriptionAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetSubscriptionAttributes {
    _private: (),
}
impl SetSubscriptionAttributes {
    /// Creates a new builder-style object to manufacture [`SetSubscriptionAttributesInput`](crate::input::SetSubscriptionAttributesInput)
    pub fn builder() -> crate::input::set_subscription_attributes_input::Builder {
        crate::input::set_subscription_attributes_input::Builder::default()
    }
    /// Creates a new `SetSubscriptionAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetSubscriptionAttributes {
    type Output = std::result::Result<
        crate::output::SetSubscriptionAttributesOutput,
        crate::error::SetSubscriptionAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_subscription_attributes_error(response)
        } else {
            crate::operation_deser::parse_set_subscription_attributes_response(response)
        }
    }
}

/// Operation shape for `SetTopicAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_topic_attributes`](crate::client::Client::set_topic_attributes).
///
/// See [`crate::client::fluent_builders::SetTopicAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetTopicAttributes {
    _private: (),
}
impl SetTopicAttributes {
    /// Creates a new builder-style object to manufacture [`SetTopicAttributesInput`](crate::input::SetTopicAttributesInput)
    pub fn builder() -> crate::input::set_topic_attributes_input::Builder {
        crate::input::set_topic_attributes_input::Builder::default()
    }
    /// Creates a new `SetTopicAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetTopicAttributes {
    type Output = std::result::Result<
        crate::output::SetTopicAttributesOutput,
        crate::error::SetTopicAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_topic_attributes_error(response)
        } else {
            crate::operation_deser::parse_set_topic_attributes_response(response)
        }
    }
}

/// Operation shape for `Subscribe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`subscribe`](crate::client::Client::subscribe).
///
/// See [`crate::client::fluent_builders::Subscribe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Subscribe {
    _private: (),
}
impl Subscribe {
    /// Creates a new builder-style object to manufacture [`SubscribeInput`](crate::input::SubscribeInput)
    pub fn builder() -> crate::input::subscribe_input::Builder {
        crate::input::subscribe_input::Builder::default()
    }
    /// Creates a new `Subscribe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Subscribe {
    type Output = std::result::Result<crate::output::SubscribeOutput, crate::error::SubscribeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_subscribe_error(response)
        } else {
            crate::operation_deser::parse_subscribe_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `Unsubscribe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unsubscribe`](crate::client::Client::unsubscribe).
///
/// See [`crate::client::fluent_builders::Unsubscribe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Unsubscribe {
    _private: (),
}
impl Unsubscribe {
    /// Creates a new builder-style object to manufacture [`UnsubscribeInput`](crate::input::UnsubscribeInput)
    pub fn builder() -> crate::input::unsubscribe_input::Builder {
        crate::input::unsubscribe_input::Builder::default()
    }
    /// Creates a new `Unsubscribe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Unsubscribe {
    type Output =
        std::result::Result<crate::output::UnsubscribeOutput, crate::error::UnsubscribeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unsubscribe_error(response)
        } else {
            crate::operation_deser::parse_unsubscribe_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `VerifySMSSandboxPhoneNumber`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`verify_sms_sandbox_phone_number`](crate::client::Client::verify_sms_sandbox_phone_number).
///
/// See [`crate::client::fluent_builders::VerifySMSSandboxPhoneNumber`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VerifySMSSandboxPhoneNumber {
    _private: (),
}
impl VerifySMSSandboxPhoneNumber {
    /// Creates a new builder-style object to manufacture [`VerifySmsSandboxPhoneNumberInput`](crate::input::VerifySmsSandboxPhoneNumberInput)
    pub fn builder() -> crate::input::verify_sms_sandbox_phone_number_input::Builder {
        crate::input::verify_sms_sandbox_phone_number_input::Builder::default()
    }
    /// Creates a new `VerifySMSSandboxPhoneNumber` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VerifySMSSandboxPhoneNumber {
    type Output = std::result::Result<
        crate::output::VerifySmsSandboxPhoneNumberOutput,
        crate::error::VerifySMSSandboxPhoneNumberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_verify_sms_sandbox_phone_number_error(response)
        } else {
            crate::operation_deser::parse_verify_sms_sandbox_phone_number_response(response)
        }
    }
}
