// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The list of tags to be added to the specified topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The required key portion of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional value portion of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The required key portion of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional value portion of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The required key portion of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The required key portion of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional value portion of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional value portion of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Gives a detailed description of failed messages in the batch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchResultErrorEntry {
    /// <p>The <code>Id</code> of an entry in a batch request</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>An error code representing why the action failed on this entry.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A message explaining why the action failed on this entry.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
    pub sender_fault: bool,
}
impl BatchResultErrorEntry {
    /// <p>The <code>Id</code> of an entry in a batch request</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>An error code representing why the action failed on this entry.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>A message explaining why the action failed on this entry.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
    pub fn sender_fault(&self) -> bool {
        self.sender_fault
    }
}
impl std::fmt::Debug for BatchResultErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchResultErrorEntry");
        formatter.field("id", &self.id);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("sender_fault", &self.sender_fault);
        formatter.finish()
    }
}
/// See [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
pub mod batch_result_error_entry {
    /// A builder for [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) sender_fault: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The <code>Id</code> of an entry in a batch request</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The <code>Id</code> of an entry in a batch request</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>An error code representing why the action failed on this entry.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>An error code representing why the action failed on this entry.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A message explaining why the action failed on this entry.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message explaining why the action failed on this entry.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
        pub fn sender_fault(mut self, input: bool) -> Self {
            self.sender_fault = Some(input);
            self
        }
        /// <p>Specifies whether the error happened due to the caller of the batch API action.</p>
        pub fn set_sender_fault(mut self, input: std::option::Option<bool>) -> Self {
            self.sender_fault = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
        pub fn build(self) -> crate::model::BatchResultErrorEntry {
            crate::model::BatchResultErrorEntry {
                id: self.id,
                code: self.code,
                message: self.message,
                sender_fault: self.sender_fault.unwrap_or_default(),
            }
        }
    }
}
impl BatchResultErrorEntry {
    /// Creates a new builder-style object to manufacture [`BatchResultErrorEntry`](crate::model::BatchResultErrorEntry)
    pub fn builder() -> crate::model::batch_result_error_entry::Builder {
        crate::model::batch_result_error_entry::Builder::default()
    }
}

/// <p>Encloses data related to a successful message in a batch request for topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishBatchResultEntry {
    /// <p>The <code>Id</code> of an entry in a batch request.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>An identifier for the message.</p>
    pub message_id: std::option::Option<std::string::String>,
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
    /// <p>The large, non-consecutive number that Amazon SNS assigns to each message.</p>
    /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
    pub sequence_number: std::option::Option<std::string::String>,
}
impl PublishBatchResultEntry {
    /// <p>The <code>Id</code> of an entry in a batch request.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>An identifier for the message.</p>
    pub fn message_id(&self) -> std::option::Option<&str> {
        self.message_id.as_deref()
    }
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
    /// <p>The large, non-consecutive number that Amazon SNS assigns to each message.</p>
    /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
    pub fn sequence_number(&self) -> std::option::Option<&str> {
        self.sequence_number.as_deref()
    }
}
impl std::fmt::Debug for PublishBatchResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishBatchResultEntry");
        formatter.field("id", &self.id);
        formatter.field("message_id", &self.message_id);
        formatter.field("sequence_number", &self.sequence_number);
        formatter.finish()
    }
}
/// See [`PublishBatchResultEntry`](crate::model::PublishBatchResultEntry)
pub mod publish_batch_result_entry {
    /// A builder for [`PublishBatchResultEntry`](crate::model::PublishBatchResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) message_id: std::option::Option<std::string::String>,
        pub(crate) sequence_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>Id</code> of an entry in a batch request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The <code>Id</code> of an entry in a batch request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>An identifier for the message.</p>
        pub fn message_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_id = Some(input.into());
            self
        }
        /// <p>An identifier for the message.</p>
        pub fn set_message_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_id = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
        /// <p>The large, non-consecutive number that Amazon SNS assigns to each message.</p>
        /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
        pub fn sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.sequence_number = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
        /// <p>The large, non-consecutive number that Amazon SNS assigns to each message.</p>
        /// <p>The length of <code>SequenceNumber</code> is 128 bits. <code>SequenceNumber</code> continues to increase for a particular <code>MessageGroupId</code>.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sequence_number = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishBatchResultEntry`](crate::model::PublishBatchResultEntry)
        pub fn build(self) -> crate::model::PublishBatchResultEntry {
            crate::model::PublishBatchResultEntry {
                id: self.id,
                message_id: self.message_id,
                sequence_number: self.sequence_number,
            }
        }
    }
}
impl PublishBatchResultEntry {
    /// Creates a new builder-style object to manufacture [`PublishBatchResultEntry`](crate::model::PublishBatchResultEntry)
    pub fn builder() -> crate::model::publish_batch_result_entry::Builder {
        crate::model::publish_batch_result_entry::Builder::default()
    }
}

/// <p>Contains the details of a single Amazon SNS message along with an <code>Id</code> that identifies a message within the batch. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishBatchRequestEntry {
    /// <p>An identifier for the message in this batch.</p> <note>
    /// <p>The <code>Ids</code> of a batch request must be unique within a request. </p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_). </p>
    /// </note>
    pub id: std::option::Option<std::string::String>,
    /// <p>The body of the message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The subject of the batch message.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the value of the <code>Message</code> parameter must: </p>
    /// <ul>
    /// <li> <p>be a syntactically valid JSON object; and</p> </li>
    /// <li> <p>contain at least a top-level JSON key of "default" with a value that is a string.</p> </li>
    /// </ul>
    /// <p>You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g. http). </p>
    pub message_structure: std::option::Option<std::string::String>,
    /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html">Amazon SNS message attributes</a> in the Amazon SNS Developer Guide.</p>
    pub message_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    >,
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
    /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered.</p>
    /// <ul>
    /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
    /// <ul>
    /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
    /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your topic, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> </li>
    /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the topic doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
    /// <li> <p>If the topic has a <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one. </p> </li>
    /// </ul> </li>
    /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
    /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled, and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
    /// </ul> <note>
    /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
    /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SNS can't detect duplicate messages. </p>
    /// <p>Amazon SNS continues to keep track of the message deduplication ID even after the message is received and deleted. </p>
    /// </note>
    /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters.</p>
    /// <p> <code>MessageDeduplicationId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
    pub message_deduplication_id: std::option::Option<std::string::String>,
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
    /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single topic, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the topic, but the session data of each user is processed in a FIFO fashion. </p>
    /// <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails. </p>
    /// <p>The length of <code>MessageGroupId</code> is 128 characters.</p>
    /// <p> <code>MessageGroupId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p> <important>
    /// <p> <code>MessageGroupId</code> is required for FIFO topics. You can't use it for standard topics. </p>
    /// </important>
    pub message_group_id: std::option::Option<std::string::String>,
}
impl PublishBatchRequestEntry {
    /// <p>An identifier for the message in this batch.</p> <note>
    /// <p>The <code>Ids</code> of a batch request must be unique within a request. </p>
    /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_). </p>
    /// </note>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The body of the message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The subject of the batch message.</p>
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// <p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the value of the <code>Message</code> parameter must: </p>
    /// <ul>
    /// <li> <p>be a syntactically valid JSON object; and</p> </li>
    /// <li> <p>contain at least a top-level JSON key of "default" with a value that is a string.</p> </li>
    /// </ul>
    /// <p>You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g. http). </p>
    pub fn message_structure(&self) -> std::option::Option<&str> {
        self.message_structure.as_deref()
    }
    /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html">Amazon SNS message attributes</a> in the Amazon SNS Developer Guide.</p>
    pub fn message_attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    > {
        self.message_attributes.as_ref()
    }
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
    /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered.</p>
    /// <ul>
    /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
    /// <ul>
    /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
    /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your topic, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> </li>
    /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the topic doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
    /// <li> <p>If the topic has a <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one. </p> </li>
    /// </ul> </li>
    /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
    /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled, and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
    /// </ul> <note>
    /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
    /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SNS can't detect duplicate messages. </p>
    /// <p>Amazon SNS continues to keep track of the message deduplication ID even after the message is received and deleted. </p>
    /// </note>
    /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters.</p>
    /// <p> <code>MessageDeduplicationId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
    pub fn message_deduplication_id(&self) -> std::option::Option<&str> {
        self.message_deduplication_id.as_deref()
    }
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
    /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single topic, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the topic, but the session data of each user is processed in a FIFO fashion. </p>
    /// <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails. </p>
    /// <p>The length of <code>MessageGroupId</code> is 128 characters.</p>
    /// <p> <code>MessageGroupId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p> <important>
    /// <p> <code>MessageGroupId</code> is required for FIFO topics. You can't use it for standard topics. </p>
    /// </important>
    pub fn message_group_id(&self) -> std::option::Option<&str> {
        self.message_group_id.as_deref()
    }
}
impl std::fmt::Debug for PublishBatchRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishBatchRequestEntry");
        formatter.field("id", &self.id);
        formatter.field("message", &self.message);
        formatter.field("subject", &self.subject);
        formatter.field("message_structure", &self.message_structure);
        formatter.field("message_attributes", &self.message_attributes);
        formatter.field("message_deduplication_id", &self.message_deduplication_id);
        formatter.field("message_group_id", &self.message_group_id);
        formatter.finish()
    }
}
/// See [`PublishBatchRequestEntry`](crate::model::PublishBatchRequestEntry)
pub mod publish_batch_request_entry {
    /// A builder for [`PublishBatchRequestEntry`](crate::model::PublishBatchRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) message_structure: std::option::Option<std::string::String>,
        pub(crate) message_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
        >,
        pub(crate) message_deduplication_id: std::option::Option<std::string::String>,
        pub(crate) message_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for the message in this batch.</p> <note>
        /// <p>The <code>Ids</code> of a batch request must be unique within a request. </p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_). </p>
        /// </note>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An identifier for the message in this batch.</p> <note>
        /// <p>The <code>Ids</code> of a batch request must be unique within a request. </p>
        /// <p>This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_). </p>
        /// </note>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The body of the message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The body of the message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The subject of the batch message.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The subject of the batch message.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the value of the <code>Message</code> parameter must: </p>
        /// <ul>
        /// <li> <p>be a syntactically valid JSON object; and</p> </li>
        /// <li> <p>contain at least a top-level JSON key of "default" with a value that is a string.</p> </li>
        /// </ul>
        /// <p>You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g. http). </p>
        pub fn message_structure(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_structure = Some(input.into());
            self
        }
        /// <p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set <code>MessageStructure</code> to <code>json</code>, the value of the <code>Message</code> parameter must: </p>
        /// <ul>
        /// <li> <p>be a syntactically valid JSON object; and</p> </li>
        /// <li> <p>contain at least a top-level JSON key of "default" with a value that is a string.</p> </li>
        /// </ul>
        /// <p>You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g. http). </p>
        pub fn set_message_structure(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_structure = input;
            self
        }
        /// Adds a key-value pair to `message_attributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html">Amazon SNS message attributes</a> in the Amazon SNS Developer Guide.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MessageAttributeValue,
        ) -> Self {
            let mut hash_map = self.message_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.message_attributes = Some(hash_map);
            self
        }
        /// <p>Each message attribute consists of a <code>Name</code>, <code>Type</code>, and <code>Value</code>. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html">Amazon SNS message attributes</a> in the Amazon SNS Developer Guide.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.message_attributes = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
        /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered.</p>
        /// <ul>
        /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
        /// <ul>
        /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
        /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your topic, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> </li>
        /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the topic doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
        /// <li> <p>If the topic has a <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one. </p> </li>
        /// </ul> </li>
        /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
        /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled, and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
        /// </ul> <note>
        /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
        /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SNS can't detect duplicate messages. </p>
        /// <p>Amazon SNS continues to keep track of the message deduplication ID even after the message is received and deleted. </p>
        /// </note>
        /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters.</p>
        /// <p> <code>MessageDeduplicationId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
        pub fn message_deduplication_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_deduplication_id = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
        /// <p>The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular <code>MessageDeduplicationId</code> is sent successfully, subsequent messages with the same <code>MessageDeduplicationId</code> are accepted successfully but aren't delivered.</p>
        /// <ul>
        /// <li> <p>Every message must have a unique <code>MessageDeduplicationId</code>.</p>
        /// <ul>
        /// <li> <p>You may provide a <code>MessageDeduplicationId</code> explicitly.</p> </li>
        /// <li> <p>If you aren't able to provide a <code>MessageDeduplicationId</code> and you enable <code>ContentBasedDeduplication</code> for your topic, Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</p> </li>
        /// <li> <p>If you don't provide a <code>MessageDeduplicationId</code> and the topic doesn't have <code>ContentBasedDeduplication</code> set, the action fails with an error.</p> </li>
        /// <li> <p>If the topic has a <code>ContentBasedDeduplication</code> set, your <code>MessageDeduplicationId</code> overrides the generated one. </p> </li>
        /// </ul> </li>
        /// <li> <p>When <code>ContentBasedDeduplication</code> is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.</p> </li>
        /// <li> <p>If you send one message with <code>ContentBasedDeduplication</code> enabled, and then another message with a <code>MessageDeduplicationId</code> that is the same as the one generated for the first <code>MessageDeduplicationId</code>, the two messages are treated as duplicates and only one copy of the message is delivered. </p> </li>
        /// </ul> <note>
        /// <p>The <code>MessageDeduplicationId</code> is available to the consumer of the message (this can be useful for troubleshooting delivery issues).</p>
        /// <p>If a message is sent successfully but the acknowledgement is lost and the message is resent with the same <code>MessageDeduplicationId</code> after the deduplication interval, Amazon SNS can't detect duplicate messages. </p>
        /// <p>Amazon SNS continues to keep track of the message deduplication ID even after the message is received and deleted. </p>
        /// </note>
        /// <p>The length of <code>MessageDeduplicationId</code> is 128 characters.</p>
        /// <p> <code>MessageDeduplicationId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p>
        pub fn set_message_deduplication_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_deduplication_id = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
        /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single topic, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the topic, but the session data of each user is processed in a FIFO fashion. </p>
        /// <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails. </p>
        /// <p>The length of <code>MessageGroupId</code> is 128 characters.</p>
        /// <p> <code>MessageGroupId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p> <important>
        /// <p> <code>MessageGroupId</code> is required for FIFO topics. You can't use it for standard topics. </p>
        /// </important>
        pub fn message_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_group_id = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics.</p>
        /// <p>The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single topic, use <code>MessageGroupId</code> values (for example, session data for multiple users). In this scenario, multiple consumers can process the topic, but the session data of each user is processed in a FIFO fashion. </p>
        /// <p>You must associate a non-empty <code>MessageGroupId</code> with a message. If you don't provide a <code>MessageGroupId</code>, the action fails. </p>
        /// <p>The length of <code>MessageGroupId</code> is 128 characters.</p>
        /// <p> <code>MessageGroupId</code> can contain alphanumeric characters <code>(a-z, A-Z, 0-9)</code> and punctuation <code>(!"#$%&amp;'()*+,-./:;&lt;=&gt;?@[\]^_`{|}~)</code>.</p> <important>
        /// <p> <code>MessageGroupId</code> is required for FIFO topics. You can't use it for standard topics. </p>
        /// </important>
        pub fn set_message_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishBatchRequestEntry`](crate::model::PublishBatchRequestEntry)
        pub fn build(self) -> crate::model::PublishBatchRequestEntry {
            crate::model::PublishBatchRequestEntry {
                id: self.id,
                message: self.message,
                subject: self.subject,
                message_structure: self.message_structure,
                message_attributes: self.message_attributes,
                message_deduplication_id: self.message_deduplication_id,
                message_group_id: self.message_group_id,
            }
        }
    }
}
impl PublishBatchRequestEntry {
    /// Creates a new builder-style object to manufacture [`PublishBatchRequestEntry`](crate::model::PublishBatchRequestEntry)
    pub fn builder() -> crate::model::publish_batch_request_entry::Builder {
        crate::model::publish_batch_request_entry::Builder::default()
    }
}

/// <p>The user-specified message attribute value. For string data types, the value attribute has the same restrictions on the content as the message body. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a>.</p>
/// <p>Name, type, and value must not be empty or null. In addition, the message body should not be empty or null. All parts of the message attribute, including name, type, and value, are included in the message size restriction, which is currently 256 KB (262,144 bytes). For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html">Amazon SNS message attributes</a> and <a href="https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html">Publishing to a mobile phone</a> in the <i>Amazon SNS Developer Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageAttributeValue {
    /// <p>Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes">Message Attribute Data Types</a>.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>Strings are Unicode with UTF8 binary encoding. For a list of code values, see <a href="https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
    pub string_value: std::option::Option<std::string::String>,
    /// <p>Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.</p>
    pub binary_value: std::option::Option<aws_smithy_types::Blob>,
}
impl MessageAttributeValue {
    /// <p>Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes">Message Attribute Data Types</a>.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>Strings are Unicode with UTF8 binary encoding. For a list of code values, see <a href="https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
    pub fn string_value(&self) -> std::option::Option<&str> {
        self.string_value.as_deref()
    }
    /// <p>Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.</p>
    pub fn binary_value(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.binary_value.as_ref()
    }
}
impl std::fmt::Debug for MessageAttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageAttributeValue");
        formatter.field("data_type", &self.data_type);
        formatter.field("string_value", &self.string_value);
        formatter.field("binary_value", &self.binary_value);
        formatter.finish()
    }
}
/// See [`MessageAttributeValue`](crate::model::MessageAttributeValue)
pub mod message_attribute_value {
    /// A builder for [`MessageAttributeValue`](crate::model::MessageAttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) string_value: std::option::Option<std::string::String>,
        pub(crate) binary_value: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes">Message Attribute Data Types</a>.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes">Message Attribute Data Types</a>.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>Strings are Unicode with UTF8 binary encoding. For a list of code values, see <a href="https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
        pub fn string_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.string_value = Some(input.into());
            self
        }
        /// <p>Strings are Unicode with UTF8 binary encoding. For a list of code values, see <a href="https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">ASCII Printable Characters</a>.</p>
        pub fn set_string_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.string_value = input;
            self
        }
        /// <p>Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.</p>
        pub fn binary_value(mut self, input: aws_smithy_types::Blob) -> Self {
            self.binary_value = Some(input);
            self
        }
        /// <p>Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.</p>
        pub fn set_binary_value(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.binary_value = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageAttributeValue`](crate::model::MessageAttributeValue)
        pub fn build(self) -> crate::model::MessageAttributeValue {
            crate::model::MessageAttributeValue {
                data_type: self.data_type,
                string_value: self.string_value,
                binary_value: self.binary_value,
            }
        }
    }
}
impl MessageAttributeValue {
    /// Creates a new builder-style object to manufacture [`MessageAttributeValue`](crate::model::MessageAttributeValue)
    pub fn builder() -> crate::model::message_attribute_value::Builder {
        crate::model::message_attribute_value::Builder::default()
    }
}

/// <p>A wrapper type for the topic's Amazon Resource Name (ARN). To retrieve a topic's attributes, use <code>GetTopicAttributes</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Topic {
    /// <p>The topic's ARN.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl Topic {
    /// <p>The topic's ARN.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for Topic {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Topic");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`Topic`](crate::model::Topic)
pub mod topic {
    /// A builder for [`Topic`](crate::model::Topic)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The topic's ARN.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The topic's ARN.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Topic`](crate::model::Topic)
        pub fn build(self) -> crate::model::Topic {
            crate::model::Topic {
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl Topic {
    /// Creates a new builder-style object to manufacture [`Topic`](crate::model::Topic)
    pub fn builder() -> crate::model::topic::Builder {
        crate::model::topic::Builder::default()
    }
}

/// <p>A wrapper type for the attributes of an Amazon SNS subscription.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subscription {
    /// <p>The subscription's ARN.</p>
    pub subscription_arn: std::option::Option<std::string::String>,
    /// <p>The subscription's owner.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The subscription's protocol.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The subscription's endpoint (format depends on the protocol).</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The ARN of the subscription's topic.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl Subscription {
    /// <p>The subscription's ARN.</p>
    pub fn subscription_arn(&self) -> std::option::Option<&str> {
        self.subscription_arn.as_deref()
    }
    /// <p>The subscription's owner.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The subscription's protocol.</p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
    /// <p>The subscription's endpoint (format depends on the protocol).</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The ARN of the subscription's topic.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for Subscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subscription");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.field("owner", &self.owner);
        formatter.field("protocol", &self.protocol);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}
/// See [`Subscription`](crate::model::Subscription)
pub mod subscription {
    /// A builder for [`Subscription`](crate::model::Subscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subscription's ARN.</p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The subscription's ARN.</p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// <p>The subscription's owner.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The subscription's owner.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The subscription's protocol.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The subscription's protocol.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The subscription's endpoint (format depends on the protocol).</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The subscription's endpoint (format depends on the protocol).</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The ARN of the subscription's topic.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the subscription's topic.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Subscription`](crate::model::Subscription)
        pub fn build(self) -> crate::model::Subscription {
            crate::model::Subscription {
                subscription_arn: self.subscription_arn,
                owner: self.owner,
                protocol: self.protocol,
                endpoint: self.endpoint,
                topic_arn: self.topic_arn,
            }
        }
    }
}
impl Subscription {
    /// Creates a new builder-style object to manufacture [`Subscription`](crate::model::Subscription)
    pub fn builder() -> crate::model::subscription::Builder {
        crate::model::subscription::Builder::default()
    }
}

/// <p>A verified or pending destination phone number in the SMS sandbox.</p>
/// <p>When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SmsSandboxPhoneNumber {
    /// <p>The destination phone number.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The destination phone number's verification status.</p>
    pub status: std::option::Option<crate::model::SmsSandboxPhoneNumberVerificationStatus>,
}
impl SmsSandboxPhoneNumber {
    /// <p>The destination phone number.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The destination phone number's verification status.</p>
    pub fn status(
        &self,
    ) -> std::option::Option<&crate::model::SmsSandboxPhoneNumberVerificationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SmsSandboxPhoneNumber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SmsSandboxPhoneNumber");
        formatter.field("phone_number", &self.phone_number);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SmsSandboxPhoneNumber`](crate::model::SmsSandboxPhoneNumber)
pub mod sms_sandbox_phone_number {
    /// A builder for [`SmsSandboxPhoneNumber`](crate::model::SmsSandboxPhoneNumber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) status:
            std::option::Option<crate::model::SmsSandboxPhoneNumberVerificationStatus>,
    }
    impl Builder {
        /// <p>The destination phone number.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The destination phone number.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The destination phone number's verification status.</p>
        pub fn status(
            mut self,
            input: crate::model::SmsSandboxPhoneNumberVerificationStatus,
        ) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The destination phone number's verification status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SmsSandboxPhoneNumberVerificationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SmsSandboxPhoneNumber`](crate::model::SmsSandboxPhoneNumber)
        pub fn build(self) -> crate::model::SmsSandboxPhoneNumber {
            crate::model::SmsSandboxPhoneNumber {
                phone_number: self.phone_number,
                status: self.status,
            }
        }
    }
}
impl SmsSandboxPhoneNumber {
    /// Creates a new builder-style object to manufacture [`SmsSandboxPhoneNumber`](crate::model::SmsSandboxPhoneNumber)
    pub fn builder() -> crate::model::sms_sandbox_phone_number::Builder {
        crate::model::sms_sandbox_phone_number::Builder::default()
    }
}

/// Enum listing out all supported destination phone number verification statuses. The following enum values are
/// supported.
/// 1. PENDING : The destination phone number is pending verification.
/// 2. VERIFIED : The destination phone number is verified.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmsSandboxPhoneNumberVerificationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Verified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmsSandboxPhoneNumberVerificationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Pending" => SmsSandboxPhoneNumberVerificationStatus::Pending,
            "Verified" => SmsSandboxPhoneNumberVerificationStatus::Verified,
            other => SmsSandboxPhoneNumberVerificationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmsSandboxPhoneNumberVerificationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmsSandboxPhoneNumberVerificationStatus::from(s))
    }
}
impl SmsSandboxPhoneNumberVerificationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmsSandboxPhoneNumberVerificationStatus::Pending => "Pending",
            SmsSandboxPhoneNumberVerificationStatus::Verified => "Verified",
            SmsSandboxPhoneNumberVerificationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Pending", "Verified"]
    }
}
impl AsRef<str> for SmsSandboxPhoneNumberVerificationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Platform application object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformApplication {
    /// <p>PlatformApplicationArn for platform application object.</p>
    pub platform_application_arn: std::option::Option<std::string::String>,
    /// <p>Attributes for platform application object.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PlatformApplication {
    /// <p>PlatformApplicationArn for platform application object.</p>
    pub fn platform_application_arn(&self) -> std::option::Option<&str> {
        self.platform_application_arn.as_deref()
    }
    /// <p>Attributes for platform application object.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for PlatformApplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformApplication");
        formatter.field("platform_application_arn", &self.platform_application_arn);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`PlatformApplication`](crate::model::PlatformApplication)
pub mod platform_application {
    /// A builder for [`PlatformApplication`](crate::model::PlatformApplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_application_arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>PlatformApplicationArn for platform application object.</p>
        pub fn platform_application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_application_arn = Some(input.into());
            self
        }
        /// <p>PlatformApplicationArn for platform application object.</p>
        pub fn set_platform_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_application_arn = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Attributes for platform application object.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>Attributes for platform application object.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformApplication`](crate::model::PlatformApplication)
        pub fn build(self) -> crate::model::PlatformApplication {
            crate::model::PlatformApplication {
                platform_application_arn: self.platform_application_arn,
                attributes: self.attributes,
            }
        }
    }
}
impl PlatformApplication {
    /// Creates a new builder-style object to manufacture [`PlatformApplication`](crate::model::PlatformApplication)
    pub fn builder() -> crate::model::platform_application::Builder {
        crate::model::platform_application::Builder::default()
    }
}

/// <p>A list of phone numbers and their metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhoneNumberInformation {
    /// <p>The date and time when the phone number was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The phone number.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The status of the phone number.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The two-character code for the country or region, in ISO 3166-1 alpha-2 format.</p>
    pub iso2_country_code: std::option::Option<std::string::String>,
    /// <p>The list of supported routes.</p>
    pub route_type: std::option::Option<crate::model::RouteType>,
    /// <p>The capabilities of each phone number.</p>
    pub number_capabilities: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
}
impl PhoneNumberInformation {
    /// <p>The date and time when the phone number was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The phone number.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The status of the phone number.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The two-character code for the country or region, in ISO 3166-1 alpha-2 format.</p>
    pub fn iso2_country_code(&self) -> std::option::Option<&str> {
        self.iso2_country_code.as_deref()
    }
    /// <p>The list of supported routes.</p>
    pub fn route_type(&self) -> std::option::Option<&crate::model::RouteType> {
        self.route_type.as_ref()
    }
    /// <p>The capabilities of each phone number.</p>
    pub fn number_capabilities(&self) -> std::option::Option<&[crate::model::NumberCapability]> {
        self.number_capabilities.as_deref()
    }
}
impl std::fmt::Debug for PhoneNumberInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhoneNumberInformation");
        formatter.field("created_at", &self.created_at);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("status", &self.status);
        formatter.field("iso2_country_code", &self.iso2_country_code);
        formatter.field("route_type", &self.route_type);
        formatter.field("number_capabilities", &self.number_capabilities);
        formatter.finish()
    }
}
/// See [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
pub mod phone_number_information {
    /// A builder for [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) iso2_country_code: std::option::Option<std::string::String>,
        pub(crate) route_type: std::option::Option<crate::model::RouteType>,
        pub(crate) number_capabilities:
            std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
    }
    impl Builder {
        /// <p>The date and time when the phone number was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time when the phone number was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The phone number.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The status of the phone number.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the phone number.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The two-character code for the country or region, in ISO 3166-1 alpha-2 format.</p>
        pub fn iso2_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.iso2_country_code = Some(input.into());
            self
        }
        /// <p>The two-character code for the country or region, in ISO 3166-1 alpha-2 format.</p>
        pub fn set_iso2_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iso2_country_code = input;
            self
        }
        /// <p>The list of supported routes.</p>
        pub fn route_type(mut self, input: crate::model::RouteType) -> Self {
            self.route_type = Some(input);
            self
        }
        /// <p>The list of supported routes.</p>
        pub fn set_route_type(
            mut self,
            input: std::option::Option<crate::model::RouteType>,
        ) -> Self {
            self.route_type = input;
            self
        }
        /// Appends an item to `number_capabilities`.
        ///
        /// To override the contents of this collection use [`set_number_capabilities`](Self::set_number_capabilities).
        ///
        /// <p>The capabilities of each phone number.</p>
        pub fn number_capabilities(mut self, input: crate::model::NumberCapability) -> Self {
            let mut v = self.number_capabilities.unwrap_or_default();
            v.push(input);
            self.number_capabilities = Some(v);
            self
        }
        /// <p>The capabilities of each phone number.</p>
        pub fn set_number_capabilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NumberCapability>>,
        ) -> Self {
            self.number_capabilities = input;
            self
        }
        /// Consumes the builder and constructs a [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
        pub fn build(self) -> crate::model::PhoneNumberInformation {
            crate::model::PhoneNumberInformation {
                created_at: self.created_at,
                phone_number: self.phone_number,
                status: self.status,
                iso2_country_code: self.iso2_country_code,
                route_type: self.route_type,
                number_capabilities: self.number_capabilities,
            }
        }
    }
}
impl PhoneNumberInformation {
    /// Creates a new builder-style object to manufacture [`PhoneNumberInformation`](crate::model::PhoneNumberInformation)
    pub fn builder() -> crate::model::phone_number_information::Builder {
        crate::model::phone_number_information::Builder::default()
    }
}

/// Enum listing out all supported number capabilities.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NumberCapability {
    #[allow(missing_docs)] // documentation missing in model
    Mms,
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    #[allow(missing_docs)] // documentation missing in model
    Voice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NumberCapability {
    fn from(s: &str) -> Self {
        match s {
            "MMS" => NumberCapability::Mms,
            "SMS" => NumberCapability::Sms,
            "VOICE" => NumberCapability::Voice,
            other => NumberCapability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NumberCapability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NumberCapability::from(s))
    }
}
impl NumberCapability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NumberCapability::Mms => "MMS",
            NumberCapability::Sms => "SMS",
            NumberCapability::Voice => "VOICE",
            NumberCapability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MMS", "SMS", "VOICE"]
    }
}
impl AsRef<str> for NumberCapability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enum listing out all supported route types. The following enum values are supported.
/// 1. Transactional : Non-marketing traffic
/// 2. Promotional : Marketing
/// 3. Premium : Premium routes for OTP delivery to the carriers
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RouteType {
    #[allow(missing_docs)] // documentation missing in model
    Premium,
    #[allow(missing_docs)] // documentation missing in model
    Promotional,
    #[allow(missing_docs)] // documentation missing in model
    Transactional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RouteType {
    fn from(s: &str) -> Self {
        match s {
            "Premium" => RouteType::Premium,
            "Promotional" => RouteType::Promotional,
            "Transactional" => RouteType::Transactional,
            other => RouteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RouteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RouteType::from(s))
    }
}
impl RouteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RouteType::Premium => "Premium",
            RouteType::Promotional => "Promotional",
            RouteType::Transactional => "Transactional",
            RouteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Premium", "Promotional", "Transactional"]
    }
}
impl AsRef<str> for RouteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The endpoint for mobile app and device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The <code>EndpointArn</code> for mobile app and device.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>Attributes for endpoint.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Endpoint {
    /// <p>The <code>EndpointArn</code> for mobile app and device.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
    /// <p>Attributes for endpoint.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The <code>EndpointArn</code> for mobile app and device.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The <code>EndpointArn</code> for mobile app and device.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>Attributes for endpoint.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>Attributes for endpoint.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                endpoint_arn: self.endpoint_arn,
                attributes: self.attributes,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// Supported language code for sending OTP message
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LanguageCodeString {
    #[allow(missing_docs)] // documentation missing in model
    DeDe,
    #[allow(missing_docs)] // documentation missing in model
    EnGb,
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    #[allow(missing_docs)] // documentation missing in model
    Es419,
    #[allow(missing_docs)] // documentation missing in model
    EsEs,
    #[allow(missing_docs)] // documentation missing in model
    FrCa,
    #[allow(missing_docs)] // documentation missing in model
    FrFr,
    #[allow(missing_docs)] // documentation missing in model
    ItIt,
    #[allow(missing_docs)] // documentation missing in model
    JpJp,
    #[allow(missing_docs)] // documentation missing in model
    KrKr,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    #[allow(missing_docs)] // documentation missing in model
    ZhTw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LanguageCodeString {
    fn from(s: &str) -> Self {
        match s {
            "de-DE" => LanguageCodeString::DeDe,
            "en-GB" => LanguageCodeString::EnGb,
            "en-US" => LanguageCodeString::EnUs,
            "es-419" => LanguageCodeString::Es419,
            "es-ES" => LanguageCodeString::EsEs,
            "fr-CA" => LanguageCodeString::FrCa,
            "fr-FR" => LanguageCodeString::FrFr,
            "it-IT" => LanguageCodeString::ItIt,
            "ja-JP" => LanguageCodeString::JpJp,
            "kr-KR" => LanguageCodeString::KrKr,
            "pt-BR" => LanguageCodeString::PtBr,
            "zh-CN" => LanguageCodeString::ZhCn,
            "zh-TW" => LanguageCodeString::ZhTw,
            other => LanguageCodeString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LanguageCodeString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LanguageCodeString::from(s))
    }
}
impl LanguageCodeString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LanguageCodeString::DeDe => "de-DE",
            LanguageCodeString::EnGb => "en-GB",
            LanguageCodeString::EnUs => "en-US",
            LanguageCodeString::Es419 => "es-419",
            LanguageCodeString::EsEs => "es-ES",
            LanguageCodeString::FrCa => "fr-CA",
            LanguageCodeString::FrFr => "fr-FR",
            LanguageCodeString::ItIt => "it-IT",
            LanguageCodeString::JpJp => "ja-JP",
            LanguageCodeString::KrKr => "kr-KR",
            LanguageCodeString::PtBr => "pt-BR",
            LanguageCodeString::ZhCn => "zh-CN",
            LanguageCodeString::ZhTw => "zh-TW",
            LanguageCodeString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "de-DE", "en-GB", "en-US", "es-419", "es-ES", "fr-CA", "fr-FR", "it-IT", "ja-JP",
            "kr-KR", "pt-BR", "zh-CN", "zh-TW",
        ]
    }
}
impl AsRef<str> for LanguageCodeString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
