// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddPermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddPermissionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::AddPermissionError {
                meta: generic,
                kind: crate::error::AddPermissionErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::AddPermissionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_check_if_phone_number_is_opted_out_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CheckIfPhoneNumberIsOptedOutOutput,
    crate::error::CheckIfPhoneNumberIsOptedOutError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CheckIfPhoneNumberIsOptedOutError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CheckIfPhoneNumberIsOptedOutError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::CheckIfPhoneNumberIsOptedOutError {
            meta: generic,
            kind: crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::AuthorizationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::authorization_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CheckIfPhoneNumberIsOptedOutError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalError" => crate::error::CheckIfPhoneNumberIsOptedOutError {
            meta: generic,
            kind: crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CheckIfPhoneNumberIsOptedOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::CheckIfPhoneNumberIsOptedOutError {
            meta: generic,
            kind: crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CheckIfPhoneNumberIsOptedOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::CheckIfPhoneNumberIsOptedOutError {
                meta: generic,
                kind: crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CheckIfPhoneNumberIsOptedOutError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CheckIfPhoneNumberIsOptedOutError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_check_if_phone_number_is_opted_out_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CheckIfPhoneNumberIsOptedOutOutput,
    crate::error::CheckIfPhoneNumberIsOptedOutError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::check_if_phone_number_is_opted_out_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_check_if_phone_number_is_opted_out(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CheckIfPhoneNumberIsOptedOutError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConfirmSubscriptionOutput,
    crate::error::ConfirmSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ConfirmSubscriptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ConfirmSubscriptionError {
            meta: generic,
            kind: crate::error::ConfirmSubscriptionErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FilterPolicyLimitExceeded" => crate::error::ConfirmSubscriptionError {
            meta: generic,
            kind: crate::error::ConfirmSubscriptionErrorKind::FilterPolicyLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::filter_policy_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_filter_policy_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ConfirmSubscriptionError {
            meta: generic,
            kind: crate::error::ConfirmSubscriptionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ConfirmSubscriptionError {
            meta: generic,
            kind: crate::error::ConfirmSubscriptionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::ConfirmSubscriptionError {
                meta: generic,
                kind: crate::error::ConfirmSubscriptionErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SubscriptionLimitExceeded" => crate::error::ConfirmSubscriptionError {
            meta: generic,
            kind: crate::error::ConfirmSubscriptionErrorKind::SubscriptionLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::subscription_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ConfirmSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_confirm_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ConfirmSubscriptionOutput,
    crate::error::ConfirmSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::confirm_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_confirm_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ConfirmSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_platform_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePlatformApplicationOutput,
    crate::error::CreatePlatformApplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePlatformApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreatePlatformApplicationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::CreatePlatformApplicationError {
            meta: generic,
            kind: crate::error::CreatePlatformApplicationErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::CreatePlatformApplicationError {
            meta: generic,
            kind: crate::error::CreatePlatformApplicationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::CreatePlatformApplicationError {
            meta: generic,
            kind: crate::error::CreatePlatformApplicationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePlatformApplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_platform_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePlatformApplicationOutput,
    crate::error::CreatePlatformApplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_platform_application_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_platform_application(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePlatformApplicationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_platform_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePlatformEndpointOutput,
    crate::error::CreatePlatformEndpointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePlatformEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreatePlatformEndpointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::CreatePlatformEndpointError {
            meta: generic,
            kind: crate::error::CreatePlatformEndpointErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::CreatePlatformEndpointError {
            meta: generic,
            kind: crate::error::CreatePlatformEndpointErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::CreatePlatformEndpointError {
            meta: generic,
            kind: crate::error::CreatePlatformEndpointErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::CreatePlatformEndpointError {
                meta: generic,
                kind: crate::error::CreatePlatformEndpointErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePlatformEndpointError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreatePlatformEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_platform_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePlatformEndpointOutput,
    crate::error::CreatePlatformEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_platform_endpoint_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_platform_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePlatformEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_sms_sandbox_phone_number_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSmsSandboxPhoneNumberOutput,
    crate::error::CreateSMSSandboxPhoneNumberError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::CreateSMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::CreateSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::authorization_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalError" => crate::error::CreateSMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::CreateSMSSandboxPhoneNumberErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::CreateSMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::CreateSMSSandboxPhoneNumberErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptedOut" => {
            crate::error::CreateSMSSandboxPhoneNumberError {
                meta: generic,
                kind: crate::error::CreateSMSSandboxPhoneNumberErrorKind::OptedOutException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::opted_out_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_opted_out_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "Throttled" => {
            crate::error::CreateSMSSandboxPhoneNumberError {
                meta: generic,
                kind: crate::error::CreateSMSSandboxPhoneNumberErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UserError" => {
            crate::error::CreateSMSSandboxPhoneNumberError {
                meta: generic,
                kind: crate::error::CreateSMSSandboxPhoneNumberErrorKind::UserErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateSMSSandboxPhoneNumberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_sms_sandbox_phone_number_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSmsSandboxPhoneNumberOutput,
    crate::error::CreateSMSSandboxPhoneNumberError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_sms_sandbox_phone_number_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_topic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTopicOutput, crate::error::CreateTopicError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTopicError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTopicError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::CreateTopicError {
            meta: generic,
            kind: crate::error::CreateTopicErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentAccess" => crate::error::CreateTopicError {
            meta: generic,
            kind: crate::error::CreateTopicErrorKind::ConcurrentAccessException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::concurrent_access_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_access_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::CreateTopicError {
            meta: generic,
            kind: crate::error::CreateTopicErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::CreateTopicError {
            meta: generic,
            kind: crate::error::CreateTopicErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurity" => crate::error::CreateTopicError {
            meta: generic,
            kind: crate::error::CreateTopicErrorKind::InvalidSecurityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_security_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleTag" => {
            crate::error::CreateTopicError {
                meta: generic,
                kind: crate::error::CreateTopicErrorKind::StaleTagException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::stale_tag_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_stale_tag_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagLimitExceeded" => crate::error::CreateTopicError {
            meta: generic,
            kind: crate::error::CreateTopicErrorKind::TagLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagPolicy" => {
            crate::error::CreateTopicError {
                meta: generic,
                kind: crate::error::CreateTopicErrorKind::TagPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::tag_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_tag_policy_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TopicLimitExceeded" => crate::error::CreateTopicError {
            meta: generic,
            kind: crate::error::CreateTopicErrorKind::TopicLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::topic_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_topic_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTopicError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_topic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTopicOutput, crate::error::CreateTopicError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_topic_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_topic(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTopicError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::DeleteEndpointError {
            meta: generic,
            kind: crate::error::DeleteEndpointErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_endpoint_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_platform_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePlatformApplicationOutput,
    crate::error::DeletePlatformApplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePlatformApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeletePlatformApplicationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::DeletePlatformApplicationError {
            meta: generic,
            kind: crate::error::DeletePlatformApplicationErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePlatformApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::DeletePlatformApplicationError {
            meta: generic,
            kind: crate::error::DeletePlatformApplicationErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePlatformApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::DeletePlatformApplicationError {
            meta: generic,
            kind: crate::error::DeletePlatformApplicationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePlatformApplicationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePlatformApplicationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_platform_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePlatformApplicationOutput,
    crate::error::DeletePlatformApplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_platform_application_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_sms_sandbox_phone_number_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSmsSandboxPhoneNumberOutput,
    crate::error::DeleteSMSSandboxPhoneNumberError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::DeleteSMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::DeleteSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::authorization_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalError" => crate::error::DeleteSMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::DeleteSMSSandboxPhoneNumberErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::DeleteSMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::DeleteSMSSandboxPhoneNumberErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::DeleteSMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::DeleteSMSSandboxPhoneNumberErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::DeleteSMSSandboxPhoneNumberError {
                meta: generic,
                kind: crate::error::DeleteSMSSandboxPhoneNumberErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UserError" => {
            crate::error::DeleteSMSSandboxPhoneNumberError {
                meta: generic,
                kind: crate::error::DeleteSMSSandboxPhoneNumberErrorKind::UserErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::user_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_user_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteSMSSandboxPhoneNumberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_sms_sandbox_phone_number_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSmsSandboxPhoneNumberOutput,
    crate::error::DeleteSMSSandboxPhoneNumberError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_sms_sandbox_phone_number_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_topic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTopicOutput, crate::error::DeleteTopicError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTopicError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTopicError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::DeleteTopicError {
            meta: generic,
            kind: crate::error::DeleteTopicErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentAccess" => crate::error::DeleteTopicError {
            meta: generic,
            kind: crate::error::DeleteTopicErrorKind::ConcurrentAccessException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::concurrent_access_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_access_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::DeleteTopicError {
            meta: generic,
            kind: crate::error::DeleteTopicErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::DeleteTopicError {
            meta: generic,
            kind: crate::error::DeleteTopicErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::DeleteTopicError {
                meta: generic,
                kind: crate::error::DeleteTopicErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "StaleTag" => {
            crate::error::DeleteTopicError {
                meta: generic,
                kind: crate::error::DeleteTopicErrorKind::StaleTagException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::stale_tag_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_stale_tag_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagPolicy" => {
            crate::error::DeleteTopicError {
                meta: generic,
                kind: crate::error::DeleteTopicErrorKind::TagPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::tag_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_tag_policy_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteTopicError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_topic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTopicOutput, crate::error::DeleteTopicError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_topic_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_endpoint_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetEndpointAttributesOutput,
    crate::error::GetEndpointAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetEndpointAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetEndpointAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::GetEndpointAttributesError {
            meta: generic,
            kind: crate::error::GetEndpointAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetEndpointAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::GetEndpointAttributesError {
            meta: generic,
            kind: crate::error::GetEndpointAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetEndpointAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::GetEndpointAttributesError {
            meta: generic,
            kind: crate::error::GetEndpointAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetEndpointAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::GetEndpointAttributesError {
                meta: generic,
                kind: crate::error::GetEndpointAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetEndpointAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetEndpointAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_endpoint_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetEndpointAttributesOutput,
    crate::error::GetEndpointAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_endpoint_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_endpoint_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetEndpointAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_platform_application_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPlatformApplicationAttributesOutput,
    crate::error::GetPlatformApplicationAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPlatformApplicationAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetPlatformApplicationAttributesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::GetPlatformApplicationAttributesError {
            meta: generic,
            kind:
                crate::error::GetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::authorization_error_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPlatformApplicationAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalError" => crate::error::GetPlatformApplicationAttributesError {
            meta: generic,
            kind: crate::error::GetPlatformApplicationAttributesErrorKind::InternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPlatformApplicationAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameter" => crate::error::GetPlatformApplicationAttributesError {
            meta: generic,
            kind:
                crate::error::GetPlatformApplicationAttributesErrorKind::InvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPlatformApplicationAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFound" => {
            crate::error::GetPlatformApplicationAttributesError {
                meta: generic,
                kind: crate::error::GetPlatformApplicationAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPlatformApplicationAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetPlatformApplicationAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_platform_application_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPlatformApplicationAttributesOutput,
    crate::error::GetPlatformApplicationAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_platform_application_attributes_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_platform_application_attributes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetPlatformApplicationAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sms_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSmsAttributesOutput, crate::error::GetSMSAttributesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSMSAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSMSAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::GetSMSAttributesError {
            meta: generic,
            kind: crate::error::GetSMSAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSMSAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::GetSMSAttributesError {
            meta: generic,
            kind: crate::error::GetSMSAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSMSAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::GetSMSAttributesError {
            meta: generic,
            kind: crate::error::GetSMSAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSMSAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::GetSMSAttributesError {
                meta: generic,
                kind: crate::error::GetSMSAttributesErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSMSAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetSMSAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sms_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSmsAttributesOutput, crate::error::GetSMSAttributesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_sms_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_sms_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSMSAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sms_sandbox_account_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSmsSandboxAccountStatusOutput,
    crate::error::GetSMSSandboxAccountStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSMSSandboxAccountStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetSMSSandboxAccountStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::GetSMSSandboxAccountStatusError {
            meta: generic,
            kind: crate::error::GetSMSSandboxAccountStatusErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSMSSandboxAccountStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::GetSMSSandboxAccountStatusError {
            meta: generic,
            kind: crate::error::GetSMSSandboxAccountStatusErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSMSSandboxAccountStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::GetSMSSandboxAccountStatusError {
                meta: generic,
                kind: crate::error::GetSMSSandboxAccountStatusErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSMSSandboxAccountStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetSMSSandboxAccountStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sms_sandbox_account_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSmsSandboxAccountStatusOutput,
    crate::error::GetSMSSandboxAccountStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_sms_sandbox_account_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_sms_sandbox_account_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSMSSandboxAccountStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_subscription_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSubscriptionAttributesOutput,
    crate::error::GetSubscriptionAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSubscriptionAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetSubscriptionAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::GetSubscriptionAttributesError {
            meta: generic,
            kind: crate::error::GetSubscriptionAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSubscriptionAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::GetSubscriptionAttributesError {
            meta: generic,
            kind: crate::error::GetSubscriptionAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSubscriptionAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::GetSubscriptionAttributesError {
            meta: generic,
            kind: crate::error::GetSubscriptionAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSubscriptionAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::GetSubscriptionAttributesError {
                meta: generic,
                kind: crate::error::GetSubscriptionAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSubscriptionAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetSubscriptionAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_subscription_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSubscriptionAttributesOutput,
    crate::error::GetSubscriptionAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_subscription_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_subscription_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSubscriptionAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_topic_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetTopicAttributesOutput,
    crate::error::GetTopicAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTopicAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTopicAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::GetTopicAttributesError {
            meta: generic,
            kind: crate::error::GetTopicAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::GetTopicAttributesError {
            meta: generic,
            kind: crate::error::GetTopicAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::GetTopicAttributesError {
            meta: generic,
            kind: crate::error::GetTopicAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurity" => crate::error::GetTopicAttributesError {
            meta: generic,
            kind: crate::error::GetTopicAttributesErrorKind::InvalidSecurityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_security_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::GetTopicAttributesError {
                meta: generic,
                kind: crate::error::GetTopicAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetTopicAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetTopicAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_topic_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetTopicAttributesOutput,
    crate::error::GetTopicAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_topic_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_topic_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTopicAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoints_by_platform_application_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEndpointsByPlatformApplicationOutput,
    crate::error::ListEndpointsByPlatformApplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEndpointsByPlatformApplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListEndpointsByPlatformApplicationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListEndpointsByPlatformApplicationError { meta: generic, kind: crate::error::ListEndpointsByPlatformApplicationErrorKind::AuthorizationErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointsByPlatformApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalError" => crate::error::ListEndpointsByPlatformApplicationError { meta: generic, kind: crate::error::ListEndpointsByPlatformApplicationErrorKind::InternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointsByPlatformApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameter" => crate::error::ListEndpointsByPlatformApplicationError { meta: generic, kind: crate::error::ListEndpointsByPlatformApplicationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointsByPlatformApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFound" => crate::error::ListEndpointsByPlatformApplicationError { meta: generic, kind: crate::error::ListEndpointsByPlatformApplicationErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointsByPlatformApplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListEndpointsByPlatformApplicationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoints_by_platform_application_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEndpointsByPlatformApplicationOutput,
    crate::error::ListEndpointsByPlatformApplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_endpoints_by_platform_application_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_endpoints_by_platform_application(response.body().as_ref(), output).map_err(crate::error::ListEndpointsByPlatformApplicationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_origination_numbers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOriginationNumbersOutput,
    crate::error::ListOriginationNumbersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOriginationNumbersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListOriginationNumbersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListOriginationNumbersError {
            meta: generic,
            kind: crate::error::ListOriginationNumbersErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOriginationNumbersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ListOriginationNumbersError {
            meta: generic,
            kind: crate::error::ListOriginationNumbersErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOriginationNumbersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListOriginationNumbersError {
            meta: generic,
            kind: crate::error::ListOriginationNumbersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOriginationNumbersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::ListOriginationNumbersError {
                meta: generic,
                kind: crate::error::ListOriginationNumbersErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOriginationNumbersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => {
            crate::error::ListOriginationNumbersError {
                meta: generic,
                kind: crate::error::ListOriginationNumbersErrorKind::ValidationException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::validation_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_validation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOriginationNumbersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListOriginationNumbersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_origination_numbers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOriginationNumbersOutput,
    crate::error::ListOriginationNumbersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_origination_numbers_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_origination_numbers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListOriginationNumbersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_phone_numbers_opted_out_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPhoneNumbersOptedOutOutput,
    crate::error::ListPhoneNumbersOptedOutError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPhoneNumbersOptedOutError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPhoneNumbersOptedOutError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListPhoneNumbersOptedOutError {
            meta: generic,
            kind: crate::error::ListPhoneNumbersOptedOutErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPhoneNumbersOptedOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ListPhoneNumbersOptedOutError {
            meta: generic,
            kind: crate::error::ListPhoneNumbersOptedOutErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPhoneNumbersOptedOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListPhoneNumbersOptedOutError {
            meta: generic,
            kind: crate::error::ListPhoneNumbersOptedOutErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPhoneNumbersOptedOutError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::ListPhoneNumbersOptedOutError {
                meta: generic,
                kind: crate::error::ListPhoneNumbersOptedOutErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPhoneNumbersOptedOutError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListPhoneNumbersOptedOutError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_phone_numbers_opted_out_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPhoneNumbersOptedOutOutput,
    crate::error::ListPhoneNumbersOptedOutError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_phone_numbers_opted_out_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_phone_numbers_opted_out(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPhoneNumbersOptedOutError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_platform_applications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPlatformApplicationsOutput,
    crate::error::ListPlatformApplicationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPlatformApplicationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPlatformApplicationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListPlatformApplicationsError {
            meta: generic,
            kind: crate::error::ListPlatformApplicationsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPlatformApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ListPlatformApplicationsError {
            meta: generic,
            kind: crate::error::ListPlatformApplicationsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPlatformApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListPlatformApplicationsError {
            meta: generic,
            kind: crate::error::ListPlatformApplicationsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPlatformApplicationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPlatformApplicationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_platform_applications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPlatformApplicationsOutput,
    crate::error::ListPlatformApplicationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_platform_applications_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_platform_applications(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPlatformApplicationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_sms_sandbox_phone_numbers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSmsSandboxPhoneNumbersOutput,
    crate::error::ListSMSSandboxPhoneNumbersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListSMSSandboxPhoneNumbersError {
            meta: generic,
            kind: crate::error::ListSMSSandboxPhoneNumbersErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ListSMSSandboxPhoneNumbersError {
            meta: generic,
            kind: crate::error::ListSMSSandboxPhoneNumbersErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListSMSSandboxPhoneNumbersError {
            meta: generic,
            kind: crate::error::ListSMSSandboxPhoneNumbersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::ListSMSSandboxPhoneNumbersError {
            meta: generic,
            kind: crate::error::ListSMSSandboxPhoneNumbersErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::ListSMSSandboxPhoneNumbersError {
                meta: generic,
                kind: crate::error::ListSMSSandboxPhoneNumbersErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListSMSSandboxPhoneNumbersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_sms_sandbox_phone_numbers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSmsSandboxPhoneNumbersOutput,
    crate::error::ListSMSSandboxPhoneNumbersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_sms_sandbox_phone_numbers_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_sms_sandbox_phone_numbers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSMSSandboxPhoneNumbersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscriptions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSubscriptionsOutput, crate::error::ListSubscriptionsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSubscriptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSubscriptionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListSubscriptionsError {
            meta: generic,
            kind: crate::error::ListSubscriptionsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ListSubscriptionsError {
            meta: generic,
            kind: crate::error::ListSubscriptionsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListSubscriptionsError {
            meta: generic,
            kind: crate::error::ListSubscriptionsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSubscriptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscriptions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSubscriptionsOutput, crate::error::ListSubscriptionsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_subscriptions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_subscriptions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSubscriptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscriptions_by_topic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSubscriptionsByTopicOutput,
    crate::error::ListSubscriptionsByTopicError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSubscriptionsByTopicError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSubscriptionsByTopicError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListSubscriptionsByTopicError {
            meta: generic,
            kind: crate::error::ListSubscriptionsByTopicErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSubscriptionsByTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ListSubscriptionsByTopicError {
            meta: generic,
            kind: crate::error::ListSubscriptionsByTopicErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSubscriptionsByTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListSubscriptionsByTopicError {
            meta: generic,
            kind: crate::error::ListSubscriptionsByTopicErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSubscriptionsByTopicError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::ListSubscriptionsByTopicError {
                meta: generic,
                kind: crate::error::ListSubscriptionsByTopicErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSubscriptionsByTopicError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListSubscriptionsByTopicError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscriptions_by_topic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSubscriptionsByTopicOutput,
    crate::error::ListSubscriptionsByTopicError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_subscriptions_by_topic_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_subscriptions_by_topic(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSubscriptionsByTopicError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentAccess" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ConcurrentAccessException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::concurrent_access_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_access_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagPolicy" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::TagPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::tag_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_tag_policy_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_topics_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTopicsOutput, crate::error::ListTopicsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTopicsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTopicsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::ListTopicsError {
            meta: generic,
            kind: crate::error::ListTopicsErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTopicsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::ListTopicsError {
            meta: generic,
            kind: crate::error::ListTopicsErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTopicsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::ListTopicsError {
            meta: generic,
            kind: crate::error::ListTopicsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTopicsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTopicsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_topics_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTopicsOutput, crate::error::ListTopicsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_topics_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_topics(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTopicsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_opt_in_phone_number_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::OptInPhoneNumberOutput, crate::error::OptInPhoneNumberError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::OptInPhoneNumberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::OptInPhoneNumberError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::OptInPhoneNumberError {
            meta: generic,
            kind: crate::error::OptInPhoneNumberErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::OptInPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::OptInPhoneNumberError {
            meta: generic,
            kind: crate::error::OptInPhoneNumberErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::OptInPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::OptInPhoneNumberError {
            meta: generic,
            kind: crate::error::OptInPhoneNumberErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::OptInPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::OptInPhoneNumberError {
                meta: generic,
                kind: crate::error::OptInPhoneNumberErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::OptInPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::OptInPhoneNumberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_opt_in_phone_number_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::OptInPhoneNumberOutput, crate::error::OptInPhoneNumberError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::opt_in_phone_number_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishOutput, crate::error::PublishError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PublishError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PublishError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointDisabled" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::EndpointDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::endpoint_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ParameterValueInvalid" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurity" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::InvalidSecurityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_security_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSAccessDenied" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::KmsAccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_access_denied_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSDisabled" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::KmsDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidState" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_invalid_state_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSNotFound" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::KmsNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSOptInRequired" => {
            crate::error::PublishError {
                meta: generic,
                kind: crate::error::PublishErrorKind::KmsOptInRequired({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::kms_opt_in_required::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_kms_opt_in_required_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "KMSThrottling" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::KmsThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_throttling_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::PublishError {
                meta: generic,
                kind: crate::error::PublishErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PlatformApplicationDisabled" => crate::error::PublishError {
            meta: generic,
            kind: crate::error::PublishErrorKind::PlatformApplicationDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::platform_application_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_platform_application_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PublishError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishOutput, crate::error::PublishError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::publish_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_publish(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PublishError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_batch_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishBatchOutput, crate::error::PublishBatchError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PublishBatchError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PublishBatchError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BatchEntryIdsNotDistinct" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::BatchEntryIdsNotDistinctException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::batch_entry_ids_not_distinct_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_entry_ids_not_distinct_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BatchRequestTooLong" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::BatchRequestTooLongException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::batch_request_too_long_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_request_too_long_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EmptyBatchRequest" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::EmptyBatchRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::empty_batch_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_empty_batch_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointDisabled" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::EndpointDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::endpoint_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidBatchEntryId" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::InvalidBatchEntryIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_batch_entry_id_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_batch_entry_id_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ParameterValueInvalid" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurity" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::InvalidSecurityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_security_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSAccessDenied" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::KmsAccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_access_denied_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSDisabled" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::KmsDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidState" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_invalid_state_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSNotFound" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::KmsNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSOptInRequired" => {
            crate::error::PublishBatchError {
                meta: generic,
                kind: crate::error::PublishBatchErrorKind::KmsOptInRequired({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::kms_opt_in_required::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_kms_opt_in_required_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "KMSThrottling" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::KmsThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_throttling_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::PublishBatchError {
                meta: generic,
                kind: crate::error::PublishBatchErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "PlatformApplicationDisabled" => crate::error::PublishBatchError {
            meta: generic,
            kind: crate::error::PublishBatchErrorKind::PlatformApplicationDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::platform_application_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_platform_application_disabled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyEntriesInBatchRequest" => {
            crate::error::PublishBatchError {
                meta: generic,
                kind: crate::error::PublishBatchErrorKind::TooManyEntriesInBatchRequestException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::too_many_entries_in_batch_request_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_too_many_entries_in_batch_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PublishBatchError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PublishBatchError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_batch_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishBatchOutput, crate::error::PublishBatchError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::publish_batch_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_publish_batch(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PublishBatchError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemovePermissionOutput, crate::error::RemovePermissionError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemovePermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemovePermissionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::RemovePermissionError {
            meta: generic,
            kind: crate::error::RemovePermissionErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::RemovePermissionError {
            meta: generic,
            kind: crate::error::RemovePermissionErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::RemovePermissionError {
            meta: generic,
            kind: crate::error::RemovePermissionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::RemovePermissionError {
                meta: generic,
                kind: crate::error::RemovePermissionErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RemovePermissionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemovePermissionOutput, crate::error::RemovePermissionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_endpoint_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetEndpointAttributesOutput,
    crate::error::SetEndpointAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetEndpointAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetEndpointAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::SetEndpointAttributesError {
            meta: generic,
            kind: crate::error::SetEndpointAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetEndpointAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::SetEndpointAttributesError {
            meta: generic,
            kind: crate::error::SetEndpointAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetEndpointAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::SetEndpointAttributesError {
            meta: generic,
            kind: crate::error::SetEndpointAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetEndpointAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::SetEndpointAttributesError {
                meta: generic,
                kind: crate::error::SetEndpointAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetEndpointAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SetEndpointAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_endpoint_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetEndpointAttributesOutput,
    crate::error::SetEndpointAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_endpoint_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_platform_application_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetPlatformApplicationAttributesOutput,
    crate::error::SetPlatformApplicationAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetPlatformApplicationAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetPlatformApplicationAttributesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::SetPlatformApplicationAttributesError {
            meta: generic,
            kind:
                crate::error::SetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::authorization_error_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetPlatformApplicationAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalError" => crate::error::SetPlatformApplicationAttributesError {
            meta: generic,
            kind: crate::error::SetPlatformApplicationAttributesErrorKind::InternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetPlatformApplicationAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidParameter" => crate::error::SetPlatformApplicationAttributesError {
            meta: generic,
            kind:
                crate::error::SetPlatformApplicationAttributesErrorKind::InvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetPlatformApplicationAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NotFound" => {
            crate::error::SetPlatformApplicationAttributesError {
                meta: generic,
                kind: crate::error::SetPlatformApplicationAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetPlatformApplicationAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SetPlatformApplicationAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_platform_application_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetPlatformApplicationAttributesOutput,
    crate::error::SetPlatformApplicationAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::set_platform_application_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_sms_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetSmsAttributesOutput, crate::error::SetSMSAttributesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetSMSAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetSMSAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::SetSMSAttributesError {
            meta: generic,
            kind: crate::error::SetSMSAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSMSAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::SetSMSAttributesError {
            meta: generic,
            kind: crate::error::SetSMSAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSMSAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::SetSMSAttributesError {
            meta: generic,
            kind: crate::error::SetSMSAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSMSAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::SetSMSAttributesError {
                meta: generic,
                kind: crate::error::SetSMSAttributesErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSMSAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SetSMSAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_sms_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetSmsAttributesOutput, crate::error::SetSMSAttributesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_sms_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_subscription_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetSubscriptionAttributesOutput,
    crate::error::SetSubscriptionAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetSubscriptionAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetSubscriptionAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::SetSubscriptionAttributesError {
            meta: generic,
            kind: crate::error::SetSubscriptionAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubscriptionAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FilterPolicyLimitExceeded" => crate::error::SetSubscriptionAttributesError {
            meta: generic,
            kind:
                crate::error::SetSubscriptionAttributesErrorKind::FilterPolicyLimitExceededException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::filter_policy_limit_exceeded_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_filter_policy_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubscriptionAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalError" => crate::error::SetSubscriptionAttributesError {
            meta: generic,
            kind: crate::error::SetSubscriptionAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubscriptionAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::SetSubscriptionAttributesError {
            meta: generic,
            kind: crate::error::SetSubscriptionAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubscriptionAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::SetSubscriptionAttributesError {
                meta: generic,
                kind: crate::error::SetSubscriptionAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSubscriptionAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SetSubscriptionAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_subscription_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetSubscriptionAttributesOutput,
    crate::error::SetSubscriptionAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_subscription_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_topic_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetTopicAttributesOutput,
    crate::error::SetTopicAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetTopicAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetTopicAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::SetTopicAttributesError {
            meta: generic,
            kind: crate::error::SetTopicAttributesErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::SetTopicAttributesError {
            meta: generic,
            kind: crate::error::SetTopicAttributesErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::SetTopicAttributesError {
            meta: generic,
            kind: crate::error::SetTopicAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurity" => crate::error::SetTopicAttributesError {
            meta: generic,
            kind: crate::error::SetTopicAttributesErrorKind::InvalidSecurityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_security_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTopicAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::SetTopicAttributesError {
                meta: generic,
                kind: crate::error::SetTopicAttributesErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetTopicAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SetTopicAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_topic_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetTopicAttributesOutput,
    crate::error::SetTopicAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_topic_attributes_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_subscribe_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SubscribeOutput, crate::error::SubscribeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SubscribeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SubscribeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::SubscribeError {
            meta: generic,
            kind: crate::error::SubscribeErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FilterPolicyLimitExceeded" => crate::error::SubscribeError {
            meta: generic,
            kind: crate::error::SubscribeErrorKind::FilterPolicyLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::filter_policy_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_filter_policy_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::SubscribeError {
            meta: generic,
            kind: crate::error::SubscribeErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::SubscribeError {
            meta: generic,
            kind: crate::error::SubscribeErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurity" => crate::error::SubscribeError {
            meta: generic,
            kind: crate::error::SubscribeErrorKind::InvalidSecurityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_security_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::SubscribeError {
                meta: generic,
                kind: crate::error::SubscribeErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SubscribeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SubscriptionLimitExceeded" => crate::error::SubscribeError {
            meta: generic,
            kind: crate::error::SubscribeErrorKind::SubscriptionLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::subscription_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SubscribeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_subscribe_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SubscribeOutput, crate::error::SubscribeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::subscribe_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_subscribe(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SubscribeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentAccess" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ConcurrentAccessException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::concurrent_access_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_access_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleTag" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::StaleTagException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::stale_tag_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_stale_tag_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagLimitExceeded" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TagLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagPolicy" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::TagPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::tag_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_tag_policy_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_unsubscribe_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UnsubscribeOutput, crate::error::UnsubscribeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UnsubscribeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UnsubscribeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::UnsubscribeError {
            meta: generic,
            kind: crate::error::UnsubscribeErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UnsubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalError" => crate::error::UnsubscribeError {
            meta: generic,
            kind: crate::error::UnsubscribeErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UnsubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::UnsubscribeError {
            meta: generic,
            kind: crate::error::UnsubscribeErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UnsubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurity" => crate::error::UnsubscribeError {
            meta: generic,
            kind: crate::error::UnsubscribeErrorKind::InvalidSecurityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_security_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_security_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UnsubscribeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFound" => {
            crate::error::UnsubscribeError {
                meta: generic,
                kind: crate::error::UnsubscribeErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UnsubscribeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UnsubscribeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_unsubscribe_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UnsubscribeOutput, crate::error::UnsubscribeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::unsubscribe_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AuthorizationErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentAccess" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ConcurrentAccessException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::concurrent_access_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_access_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StaleTag" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::StaleTagException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::stale_tag_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_stale_tag_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagLimitExceeded" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TagLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagPolicy" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::TagPolicyException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::tag_policy_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_tag_policy_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_sms_sandbox_phone_number_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifySmsSandboxPhoneNumberOutput,
    crate::error::VerifySMSSandboxPhoneNumberError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationError" => crate::error::VerifySMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::VerifySMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::authorization_error_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_authorization_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalError" => crate::error::VerifySMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::VerifySMSSandboxPhoneNumberErrorKind::InternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_error_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameter" => crate::error::VerifySMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::VerifySMSSandboxPhoneNumberErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFound" => crate::error::VerifySMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::VerifySMSSandboxPhoneNumberErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Throttled" => {
            crate::error::VerifySMSSandboxPhoneNumberError {
                meta: generic,
                kind: crate::error::VerifySMSSandboxPhoneNumberErrorKind::ThrottledException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::throttled_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_throttled_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "VerificationException" => crate::error::VerifySMSSandboxPhoneNumberError {
            meta: generic,
            kind: crate::error::VerifySMSSandboxPhoneNumberErrorKind::VerificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::verification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_verification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::VerifySMSSandboxPhoneNumberError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::VerifySMSSandboxPhoneNumberError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_verify_sms_sandbox_phone_number_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::VerifySmsSandboxPhoneNumberOutput,
    crate::error::VerifySMSSandboxPhoneNumberError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::verify_sms_sandbox_phone_number_output::Builder::default();
        let _ = response;
        output.build()
    })
}
