// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Two or more batch entries in the request have the same <code>Id</code>.</p>
    BatchEntryIdsNotDistinctException(crate::error::BatchEntryIdsNotDistinctException),
    /// <p>The length of all the batch messages put together is more than the limit.</p>
    BatchRequestTooLongException(crate::error::BatchRequestTooLongException),
    /// <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
    /// sequentially.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>The batch request doesn't contain any entries.</p>
    EmptyBatchRequestException(crate::error::EmptyBatchRequestException),
    /// <p>Exception error indicating endpoint disabled.</p>
    EndpointDisabledException(crate::error::EndpointDisabledException),
    /// <p>Indicates that the number of filter polices in your Amazon Web Services account exceeds the limit. To
    /// add more filter polices, submit an Amazon SNS Limit Increase case in the Amazon Web Services Support
    /// Center.</p>
    FilterPolicyLimitExceededException(crate::error::FilterPolicyLimitExceededException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>The <code>Id</code> of a batch entry in a batch request doesn't abide by the specification. </p>
    InvalidBatchEntryIdException(crate::error::InvalidBatchEntryIdException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that a request parameter does not comply with the associated constraints.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
    /// request using Signature Version 4.</p>
    InvalidSecurityException(crate::error::InvalidSecurityException),
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access
    /// to.</p>
    KmsAccessDeniedException(crate::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't
    /// enabled.</p>
    KmsDisabledException(crate::error::KmsDisabledException),
    /// <p>The request was rejected because the state of the specified resource isn't valid for
    /// this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
    /// Customer Master Key</a> in the <i>Key Management Service Developer
    /// Guide</i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource can't be
    /// found.</p>
    KmsNotFoundException(crate::error::KmsNotFoundException),
    /// <p>The Amazon Web Services access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about
    /// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
    /// the <i>Key Management Service Developer Guide.</i>
    /// </p>
    KmsThrottlingException(crate::error::KmsThrottlingException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Indicates that the specified phone number opted out of receiving SMS messages from
    /// your Amazon Web Services account. You can't send SMS messages to phone numbers that opt out.</p>
    OptedOutException(crate::error::OptedOutException),
    /// <p>Exception error indicating platform application disabled.</p>
    PlatformApplicationDisabledException(crate::error::PlatformApplicationDisabledException),
    /// <p>Can’t perform the action on the specified resource. Make sure that the resource
    /// exists.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
    /// short while and then retry the operation.</p>
    StaleTagException(crate::error::StaleTagException),
    /// <p>Indicates that the customer already owns the maximum allowed number of
    /// subscriptions.</p>
    SubscriptionLimitExceededException(crate::error::SubscriptionLimitExceededException),
    /// <p>Can't add more than 50 tags to a topic.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>The request doesn't comply with the IAM tag policy. Correct your request and then
    /// retry it.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds the limit for your Amazon Web Services account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// <p>The batch request contains more entries than permissible.</p>
    TooManyEntriesInBatchRequestException(crate::error::TooManyEntriesInBatchRequestException),
    /// <p>Indicates that the customer already owns the maximum allowed number of topics.</p>
    TopicLimitExceededException(crate::error::TopicLimitExceededException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    UserErrorException(crate::error::UserErrorException),
    /// <p>Indicates that a parameter in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// <p>Indicates that the one-time password (OTP) used for verification is invalid.</p>
    VerificationException(crate::error::VerificationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AuthorizationErrorException(inner) => inner.fmt(f),
            Error::BatchEntryIdsNotDistinctException(inner) => inner.fmt(f),
            Error::BatchRequestTooLongException(inner) => inner.fmt(f),
            Error::ConcurrentAccessException(inner) => inner.fmt(f),
            Error::EmptyBatchRequestException(inner) => inner.fmt(f),
            Error::EndpointDisabledException(inner) => inner.fmt(f),
            Error::FilterPolicyLimitExceededException(inner) => inner.fmt(f),
            Error::InternalErrorException(inner) => inner.fmt(f),
            Error::InvalidBatchEntryIdException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidSecurityException(inner) => inner.fmt(f),
            Error::KmsAccessDeniedException(inner) => inner.fmt(f),
            Error::KmsDisabledException(inner) => inner.fmt(f),
            Error::KmsInvalidStateException(inner) => inner.fmt(f),
            Error::KmsNotFoundException(inner) => inner.fmt(f),
            Error::KmsOptInRequired(inner) => inner.fmt(f),
            Error::KmsThrottlingException(inner) => inner.fmt(f),
            Error::NotFoundException(inner) => inner.fmt(f),
            Error::OptedOutException(inner) => inner.fmt(f),
            Error::PlatformApplicationDisabledException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::StaleTagException(inner) => inner.fmt(f),
            Error::SubscriptionLimitExceededException(inner) => inner.fmt(f),
            Error::TagLimitExceededException(inner) => inner.fmt(f),
            Error::TagPolicyException(inner) => inner.fmt(f),
            Error::ThrottledException(inner) => inner.fmt(f),
            Error::TooManyEntriesInBatchRequestException(inner) => inner.fmt(f),
            Error::TopicLimitExceededException(inner) => inner.fmt(f),
            Error::UserErrorException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::VerificationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddPermissionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddPermissionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddPermissionErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::AddPermissionErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::AddPermissionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::AddPermissionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::AddPermissionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CheckIfPhoneNumberIsOptedOutError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CheckIfPhoneNumberIsOptedOutError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::InternalErrorException(inner) => Error::InternalErrorException(inner),
                crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::ThrottledException(inner) => Error::ThrottledException(inner),
                crate::error::CheckIfPhoneNumberIsOptedOutErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ConfirmSubscriptionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ConfirmSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ConfirmSubscriptionErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::ConfirmSubscriptionErrorKind::FilterPolicyLimitExceededException(
                    inner,
                ) => Error::FilterPolicyLimitExceededException(inner),
                crate::error::ConfirmSubscriptionErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::ConfirmSubscriptionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ConfirmSubscriptionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ConfirmSubscriptionErrorKind::SubscriptionLimitExceededException(
                    inner,
                ) => Error::SubscriptionLimitExceededException(inner),
                crate::error::ConfirmSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePlatformApplicationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePlatformApplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePlatformApplicationErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::CreatePlatformApplicationErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::CreatePlatformApplicationErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::CreatePlatformApplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePlatformEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePlatformEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePlatformEndpointErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::CreatePlatformEndpointErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::CreatePlatformEndpointErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreatePlatformEndpointErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreatePlatformEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSMSSandboxPhoneNumberError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateSMSSandboxPhoneNumberError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::CreateSMSSandboxPhoneNumberErrorKind::InternalErrorException(
                    inner,
                ) => Error::InternalErrorException(inner),
                crate::error::CreateSMSSandboxPhoneNumberErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::CreateSMSSandboxPhoneNumberErrorKind::OptedOutException(inner) => {
                    Error::OptedOutException(inner)
                }
                crate::error::CreateSMSSandboxPhoneNumberErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::CreateSMSSandboxPhoneNumberErrorKind::UserErrorException(inner) => {
                    Error::UserErrorException(inner)
                }
                crate::error::CreateSMSSandboxPhoneNumberErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTopicError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTopicError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTopicErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::CreateTopicErrorKind::ConcurrentAccessException(inner) => {
                    Error::ConcurrentAccessException(inner)
                }
                crate::error::CreateTopicErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::CreateTopicErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateTopicErrorKind::InvalidSecurityException(inner) => {
                    Error::InvalidSecurityException(inner)
                }
                crate::error::CreateTopicErrorKind::StaleTagException(inner) => {
                    Error::StaleTagException(inner)
                }
                crate::error::CreateTopicErrorKind::TagLimitExceededException(inner) => {
                    Error::TagLimitExceededException(inner)
                }
                crate::error::CreateTopicErrorKind::TagPolicyException(inner) => {
                    Error::TagPolicyException(inner)
                }
                crate::error::CreateTopicErrorKind::TopicLimitExceededException(inner) => {
                    Error::TopicLimitExceededException(inner)
                }
                crate::error::CreateTopicErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEndpointErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DeleteEndpointErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::DeleteEndpointErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePlatformApplicationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeletePlatformApplicationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePlatformApplicationErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::DeletePlatformApplicationErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::DeletePlatformApplicationErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DeletePlatformApplicationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSMSSandboxPhoneNumberError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteSMSSandboxPhoneNumberError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::DeleteSMSSandboxPhoneNumberErrorKind::InternalErrorException(
                    inner,
                ) => Error::InternalErrorException(inner),
                crate::error::DeleteSMSSandboxPhoneNumberErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DeleteSMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteSMSSandboxPhoneNumberErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::DeleteSMSSandboxPhoneNumberErrorKind::UserErrorException(inner) => {
                    Error::UserErrorException(inner)
                }
                crate::error::DeleteSMSSandboxPhoneNumberErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTopicError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTopicError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTopicErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::DeleteTopicErrorKind::ConcurrentAccessException(inner) => {
                    Error::ConcurrentAccessException(inner)
                }
                crate::error::DeleteTopicErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::DeleteTopicErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteTopicErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteTopicErrorKind::StaleTagException(inner) => {
                    Error::StaleTagException(inner)
                }
                crate::error::DeleteTopicErrorKind::TagPolicyException(inner) => {
                    Error::TagPolicyException(inner)
                }
                crate::error::DeleteTopicErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetEndpointAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetEndpointAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetEndpointAttributesErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::GetEndpointAttributesErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::GetEndpointAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetEndpointAttributesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetEndpointAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetPlatformApplicationAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetPlatformApplicationAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::GetPlatformApplicationAttributesErrorKind::InternalErrorException(inner) => Error::InternalErrorException(inner),
                crate::error::GetPlatformApplicationAttributesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetPlatformApplicationAttributesErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetPlatformApplicationAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSMSAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSMSAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSMSAttributesErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::GetSMSAttributesErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::GetSMSAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetSMSAttributesErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::GetSMSAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSMSSandboxAccountStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSMSSandboxAccountStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSMSSandboxAccountStatusErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::GetSMSSandboxAccountStatusErrorKind::InternalErrorException(
                    inner,
                ) => Error::InternalErrorException(inner),
                crate::error::GetSMSSandboxAccountStatusErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::GetSMSSandboxAccountStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSubscriptionAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSubscriptionAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSubscriptionAttributesErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::GetSubscriptionAttributesErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::GetSubscriptionAttributesErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::GetSubscriptionAttributesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetSubscriptionAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTopicAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTopicAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTopicAttributesErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::GetTopicAttributesErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::GetTopicAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetTopicAttributesErrorKind::InvalidSecurityException(inner) => {
                    Error::InvalidSecurityException(inner)
                }
                crate::error::GetTopicAttributesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetTopicAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::ListEndpointsByPlatformApplicationError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListEndpointsByPlatformApplicationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListEndpointsByPlatformApplicationErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::ListEndpointsByPlatformApplicationErrorKind::InternalErrorException(inner) => Error::InternalErrorException(inner),
                crate::error::ListEndpointsByPlatformApplicationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListEndpointsByPlatformApplicationErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::ListEndpointsByPlatformApplicationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListOriginationNumbersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListOriginationNumbersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListOriginationNumbersErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::ListOriginationNumbersErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::ListOriginationNumbersErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListOriginationNumbersErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::ListOriginationNumbersErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListOriginationNumbersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPhoneNumbersOptedOutError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListPhoneNumbersOptedOutError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPhoneNumbersOptedOutErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::ListPhoneNumbersOptedOutErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::ListPhoneNumbersOptedOutErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::ListPhoneNumbersOptedOutErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::ListPhoneNumbersOptedOutErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPlatformApplicationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListPlatformApplicationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListPlatformApplicationsErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::ListPlatformApplicationsErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::ListPlatformApplicationsErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::ListPlatformApplicationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListSMSSandboxPhoneNumbersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListSMSSandboxPhoneNumbersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListSMSSandboxPhoneNumbersErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::ListSMSSandboxPhoneNumbersErrorKind::InternalErrorException(
                    inner,
                ) => Error::InternalErrorException(inner),
                crate::error::ListSMSSandboxPhoneNumbersErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::ListSMSSandboxPhoneNumbersErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::ListSMSSandboxPhoneNumbersErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::ListSMSSandboxPhoneNumbersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListSubscriptionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListSubscriptionsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::ListSubscriptionsErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::ListSubscriptionsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListSubscriptionsByTopicError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListSubscriptionsByTopicError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListSubscriptionsByTopicErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::ListSubscriptionsByTopicErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::ListSubscriptionsByTopicErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::ListSubscriptionsByTopicErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ListSubscriptionsByTopicErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ConcurrentAccessException(inner) => {
                    Error::ConcurrentAccessException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::TagPolicyException(inner) => {
                    Error::TagPolicyException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTopicsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTopicsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTopicsErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::ListTopicsErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::ListTopicsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTopicsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::OptInPhoneNumberError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::OptInPhoneNumberError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::OptInPhoneNumberErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::OptInPhoneNumberErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::OptInPhoneNumberErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::OptInPhoneNumberErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::OptInPhoneNumberErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PublishError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PublishError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PublishErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::PublishErrorKind::EndpointDisabledException(inner) => {
                    Error::EndpointDisabledException(inner)
                }
                crate::error::PublishErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::PublishErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PublishErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::PublishErrorKind::InvalidSecurityException(inner) => {
                    Error::InvalidSecurityException(inner)
                }
                crate::error::PublishErrorKind::KmsAccessDeniedException(inner) => {
                    Error::KmsAccessDeniedException(inner)
                }
                crate::error::PublishErrorKind::KmsDisabledException(inner) => {
                    Error::KmsDisabledException(inner)
                }
                crate::error::PublishErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::PublishErrorKind::KmsNotFoundException(inner) => {
                    Error::KmsNotFoundException(inner)
                }
                crate::error::PublishErrorKind::KmsOptInRequired(inner) => {
                    Error::KmsOptInRequired(inner)
                }
                crate::error::PublishErrorKind::KmsThrottlingException(inner) => {
                    Error::KmsThrottlingException(inner)
                }
                crate::error::PublishErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::PublishErrorKind::PlatformApplicationDisabledException(inner) => {
                    Error::PlatformApplicationDisabledException(inner)
                }
                crate::error::PublishErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PublishBatchError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PublishBatchError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PublishBatchErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::PublishBatchErrorKind::BatchEntryIdsNotDistinctException(inner) => {
                    Error::BatchEntryIdsNotDistinctException(inner)
                }
                crate::error::PublishBatchErrorKind::BatchRequestTooLongException(inner) => {
                    Error::BatchRequestTooLongException(inner)
                }
                crate::error::PublishBatchErrorKind::EmptyBatchRequestException(inner) => {
                    Error::EmptyBatchRequestException(inner)
                }
                crate::error::PublishBatchErrorKind::EndpointDisabledException(inner) => {
                    Error::EndpointDisabledException(inner)
                }
                crate::error::PublishBatchErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::PublishBatchErrorKind::InvalidBatchEntryIdException(inner) => {
                    Error::InvalidBatchEntryIdException(inner)
                }
                crate::error::PublishBatchErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PublishBatchErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::PublishBatchErrorKind::InvalidSecurityException(inner) => {
                    Error::InvalidSecurityException(inner)
                }
                crate::error::PublishBatchErrorKind::KmsAccessDeniedException(inner) => {
                    Error::KmsAccessDeniedException(inner)
                }
                crate::error::PublishBatchErrorKind::KmsDisabledException(inner) => {
                    Error::KmsDisabledException(inner)
                }
                crate::error::PublishBatchErrorKind::KmsInvalidStateException(inner) => {
                    Error::KmsInvalidStateException(inner)
                }
                crate::error::PublishBatchErrorKind::KmsNotFoundException(inner) => {
                    Error::KmsNotFoundException(inner)
                }
                crate::error::PublishBatchErrorKind::KmsOptInRequired(inner) => {
                    Error::KmsOptInRequired(inner)
                }
                crate::error::PublishBatchErrorKind::KmsThrottlingException(inner) => {
                    Error::KmsThrottlingException(inner)
                }
                crate::error::PublishBatchErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::PublishBatchErrorKind::PlatformApplicationDisabledException(
                    inner,
                ) => Error::PlatformApplicationDisabledException(inner),
                crate::error::PublishBatchErrorKind::TooManyEntriesInBatchRequestException(
                    inner,
                ) => Error::TooManyEntriesInBatchRequestException(inner),
                crate::error::PublishBatchErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemovePermissionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemovePermissionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemovePermissionErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::RemovePermissionErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::RemovePermissionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RemovePermissionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::RemovePermissionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetEndpointAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetEndpointAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetEndpointAttributesErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::SetEndpointAttributesErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::SetEndpointAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::SetEndpointAttributesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::SetEndpointAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::SetPlatformApplicationAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::SetPlatformApplicationAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::SetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::SetPlatformApplicationAttributesErrorKind::InternalErrorException(inner) => Error::InternalErrorException(inner),
                crate::error::SetPlatformApplicationAttributesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::SetPlatformApplicationAttributesErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::SetPlatformApplicationAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetSMSAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetSMSAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetSMSAttributesErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::SetSMSAttributesErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::SetSMSAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::SetSMSAttributesErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::SetSMSAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetSubscriptionAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetSubscriptionAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::SetSubscriptionAttributesErrorKind::AuthorizationErrorException(inner) => Error::AuthorizationErrorException(inner),
                crate::error::SetSubscriptionAttributesErrorKind::FilterPolicyLimitExceededException(inner) => Error::FilterPolicyLimitExceededException(inner),
                crate::error::SetSubscriptionAttributesErrorKind::InternalErrorException(inner) => Error::InternalErrorException(inner),
                crate::error::SetSubscriptionAttributesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::SetSubscriptionAttributesErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::SetSubscriptionAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetTopicAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetTopicAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetTopicAttributesErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::SetTopicAttributesErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::SetTopicAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::SetTopicAttributesErrorKind::InvalidSecurityException(inner) => {
                    Error::InvalidSecurityException(inner)
                }
                crate::error::SetTopicAttributesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::SetTopicAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SubscribeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SubscribeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SubscribeErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::SubscribeErrorKind::FilterPolicyLimitExceededException(inner) => {
                    Error::FilterPolicyLimitExceededException(inner)
                }
                crate::error::SubscribeErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::SubscribeErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::SubscribeErrorKind::InvalidSecurityException(inner) => {
                    Error::InvalidSecurityException(inner)
                }
                crate::error::SubscribeErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::SubscribeErrorKind::SubscriptionLimitExceededException(inner) => {
                    Error::SubscriptionLimitExceededException(inner)
                }
                crate::error::SubscribeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::TagResourceErrorKind::ConcurrentAccessException(inner) => {
                    Error::ConcurrentAccessException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::StaleTagException(inner) => {
                    Error::StaleTagException(inner)
                }
                crate::error::TagResourceErrorKind::TagLimitExceededException(inner) => {
                    Error::TagLimitExceededException(inner)
                }
                crate::error::TagResourceErrorKind::TagPolicyException(inner) => {
                    Error::TagPolicyException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UnsubscribeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UnsubscribeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UnsubscribeErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::UnsubscribeErrorKind::InternalErrorException(inner) => {
                    Error::InternalErrorException(inner)
                }
                crate::error::UnsubscribeErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UnsubscribeErrorKind::InvalidSecurityException(inner) => {
                    Error::InvalidSecurityException(inner)
                }
                crate::error::UnsubscribeErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UnsubscribeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AuthorizationErrorException(inner) => {
                    Error::AuthorizationErrorException(inner)
                }
                crate::error::UntagResourceErrorKind::ConcurrentAccessException(inner) => {
                    Error::ConcurrentAccessException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::StaleTagException(inner) => {
                    Error::StaleTagException(inner)
                }
                crate::error::UntagResourceErrorKind::TagLimitExceededException(inner) => {
                    Error::TagLimitExceededException(inner)
                }
                crate::error::UntagResourceErrorKind::TagPolicyException(inner) => {
                    Error::TagPolicyException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::VerifySMSSandboxPhoneNumberError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::VerifySMSSandboxPhoneNumberError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::VerifySMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(
                    inner,
                ) => Error::AuthorizationErrorException(inner),
                crate::error::VerifySMSSandboxPhoneNumberErrorKind::InternalErrorException(
                    inner,
                ) => Error::InternalErrorException(inner),
                crate::error::VerifySMSSandboxPhoneNumberErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::VerifySMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::VerifySMSSandboxPhoneNumberErrorKind::ThrottledException(inner) => {
                    Error::ThrottledException(inner)
                }
                crate::error::VerifySMSSandboxPhoneNumberErrorKind::VerificationException(
                    inner,
                ) => Error::VerificationException(inner),
                crate::error::VerifySMSSandboxPhoneNumberErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
