// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddPermissionInput`](crate::input::AddPermissionInput)
pub mod add_permission_input {
    /// A builder for [`AddPermissionInput`](crate::input::AddPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) action_name: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the topic whose access control policy you wish to modify.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic whose access control policy you wish to modify.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>A unique identifier for the new policy statement.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>A unique identifier for the new policy statement.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// Appends an item to `aws_account_id`.
        ///
        /// To override the contents of this collection use [`set_aws_account_id`](Self::set_aws_account_id).
        ///
        /// <p>The account IDs of the users (principals) who will be given access to the
        /// specified actions. The users must have account, but do not need to be signed up for
        /// this service.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aws_account_id.unwrap_or_default();
            v.push(input.into());
            self.aws_account_id = Some(v);
            self
        }
        /// <p>The account IDs of the users (principals) who will be given access to the
        /// specified actions. The users must have account, but do not need to be signed up for
        /// this service.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Appends an item to `action_name`.
        ///
        /// To override the contents of this collection use [`set_action_name`](Self::set_action_name).
        ///
        /// <p>The action you want to allow for the specified principal(s).</p>
        /// <p>Valid values: Any Amazon SNS action name, for example <code>Publish</code>.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.action_name.unwrap_or_default();
            v.push(input.into());
            self.action_name = Some(v);
            self
        }
        /// <p>The action you want to allow for the specified principal(s).</p>
        /// <p>Valid values: Any Amazon SNS action name, for example <code>Publish</code>.</p>
        pub fn set_action_name(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.action_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddPermissionInput`](crate::input::AddPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddPermissionInput {
                topic_arn: self.topic_arn,
                label: self.label,
                aws_account_id: self.aws_account_id,
                action_name: self.action_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddPermissionInputOperationOutputAlias = crate::operation::AddPermission;
#[doc(hidden)]
pub type AddPermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddPermissionInput {
    /// Consumes the builder and constructs an Operation<[`AddPermission`](crate::operation::AddPermission)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddPermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddPermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddPermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddPermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_permission(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddPermission",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddPermissionInput`](crate::input::AddPermissionInput)
    pub fn builder() -> crate::input::add_permission_input::Builder {
        crate::input::add_permission_input::Builder::default()
    }
}

/// See [`CheckIfPhoneNumberIsOptedOutInput`](crate::input::CheckIfPhoneNumberIsOptedOutInput)
pub mod check_if_phone_number_is_opted_out_input {
    /// A builder for [`CheckIfPhoneNumberIsOptedOutInput`](crate::input::CheckIfPhoneNumberIsOptedOutInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone number for which you want to check the opt out status.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number for which you want to check the opt out status.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckIfPhoneNumberIsOptedOutInput`](crate::input::CheckIfPhoneNumberIsOptedOutInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CheckIfPhoneNumberIsOptedOutInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CheckIfPhoneNumberIsOptedOutInput {
                phone_number: self.phone_number,
            })
        }
    }
}
#[doc(hidden)]
pub type CheckIfPhoneNumberIsOptedOutInputOperationOutputAlias =
    crate::operation::CheckIfPhoneNumberIsOptedOut;
#[doc(hidden)]
pub type CheckIfPhoneNumberIsOptedOutInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CheckIfPhoneNumberIsOptedOutInput {
    /// Consumes the builder and constructs an Operation<[`CheckIfPhoneNumberIsOptedOut`](crate::operation::CheckIfPhoneNumberIsOptedOut)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CheckIfPhoneNumberIsOptedOut,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CheckIfPhoneNumberIsOptedOutInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CheckIfPhoneNumberIsOptedOutInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CheckIfPhoneNumberIsOptedOutInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_check_if_phone_number_is_opted_out(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CheckIfPhoneNumberIsOptedOut::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CheckIfPhoneNumberIsOptedOut",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CheckIfPhoneNumberIsOptedOutInput`](crate::input::CheckIfPhoneNumberIsOptedOutInput)
    pub fn builder() -> crate::input::check_if_phone_number_is_opted_out_input::Builder {
        crate::input::check_if_phone_number_is_opted_out_input::Builder::default()
    }
}

/// See [`ConfirmSubscriptionInput`](crate::input::ConfirmSubscriptionInput)
pub mod confirm_subscription_input {
    /// A builder for [`ConfirmSubscriptionInput`](crate::input::ConfirmSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) authenticate_on_unsubscribe: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic for which you wish to confirm a subscription.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic for which you wish to confirm a subscription.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>Short-lived token sent to an endpoint during the <code>Subscribe</code> action.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>Short-lived token sent to an endpoint during the <code>Subscribe</code> action.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>Disallows unauthenticated unsubscribes of the subscription. If the value of this
        /// parameter is <code>true</code> and the request has an Amazon Web Services signature, then only the topic
        /// owner and the subscription owner can unsubscribe the endpoint. The unsubscribe action
        /// requires Amazon Web Services authentication. </p>
        pub fn authenticate_on_unsubscribe(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authenticate_on_unsubscribe = Some(input.into());
            self
        }
        /// <p>Disallows unauthenticated unsubscribes of the subscription. If the value of this
        /// parameter is <code>true</code> and the request has an Amazon Web Services signature, then only the topic
        /// owner and the subscription owner can unsubscribe the endpoint. The unsubscribe action
        /// requires Amazon Web Services authentication. </p>
        pub fn set_authenticate_on_unsubscribe(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authenticate_on_unsubscribe = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmSubscriptionInput`](crate::input::ConfirmSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmSubscriptionInput {
                topic_arn: self.topic_arn,
                token: self.token,
                authenticate_on_unsubscribe: self.authenticate_on_unsubscribe,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmSubscriptionInputOperationOutputAlias = crate::operation::ConfirmSubscription;
#[doc(hidden)]
pub type ConfirmSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ConfirmSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmSubscription`](crate::operation::ConfirmSubscription)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ConfirmSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ConfirmSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ConfirmSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_confirm_subscription(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmSubscription",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ConfirmSubscriptionInput`](crate::input::ConfirmSubscriptionInput)
    pub fn builder() -> crate::input::confirm_subscription_input::Builder {
        crate::input::confirm_subscription_input::Builder::default()
    }
}

/// See [`CreatePlatformApplicationInput`](crate::input::CreatePlatformApplicationInput)
pub mod create_platform_application_input {
    /// A builder for [`CreatePlatformApplicationInput`](crate::input::CreatePlatformApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Application names must be made up of only uppercase and lowercase ASCII letters,
        /// numbers, underscores, hyphens, and periods, and must be between 1 and 256 characters
        /// long.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Application names must be made up of only uppercase and lowercase ASCII letters,
        /// numbers, underscores, hyphens, and periods, and must be between 1 and 256 characters
        /// long.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push
        /// Notification Service), APNS_SANDBOX, and GCM (Firebase Cloud Messaging).</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push
        /// Notification Service), APNS_SANDBOX, and GCM (Firebase Cloud Messaging).</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html">SetPlatformApplicationAttributes</a>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html">SetPlatformApplicationAttributes</a>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlatformApplicationInput`](crate::input::CreatePlatformApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlatformApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlatformApplicationInput {
                name: self.name,
                platform: self.platform,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlatformApplicationInputOperationOutputAlias =
    crate::operation::CreatePlatformApplication;
#[doc(hidden)]
pub type CreatePlatformApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePlatformApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlatformApplication`](crate::operation::CreatePlatformApplication)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlatformApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePlatformApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePlatformApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePlatformApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_platform_application(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlatformApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlatformApplication",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePlatformApplicationInput`](crate::input::CreatePlatformApplicationInput)
    pub fn builder() -> crate::input::create_platform_application_input::Builder {
        crate::input::create_platform_application_input::Builder::default()
    }
}

/// See [`CreatePlatformEndpointInput`](crate::input::CreatePlatformEndpointInput)
pub mod create_platform_endpoint_input {
    /// A builder for [`CreatePlatformEndpointInput`](crate::input::CreatePlatformEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_application_arn: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) custom_user_data: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>PlatformApplicationArn returned from CreatePlatformApplication is used to create a an
        /// endpoint.</p>
        pub fn platform_application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_application_arn = Some(input.into());
            self
        }
        /// <p>PlatformApplicationArn returned from CreatePlatformApplication is used to create a an
        /// endpoint.</p>
        pub fn set_platform_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_application_arn = input;
            self
        }
        /// <p>Unique identifier created by the notification service for an app on a device. The
        /// specific name for Token will vary, depending on which notification service is being
        /// used. For example, when using APNS as the notification service, you need the device
        /// token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token
        /// equivalent is called the registration ID.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>Unique identifier created by the notification service for an app on a device. The
        /// specific name for Token will vary, depending on which notification service is being
        /// used. For example, when using APNS as the notification service, you need the device
        /// token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token
        /// equivalent is called the registration ID.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The
        /// data must be in UTF-8 format and less than 2KB.</p>
        pub fn custom_user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_user_data = Some(input.into());
            self
        }
        /// <p>Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The
        /// data must be in UTF-8 format and less than 2KB.</p>
        pub fn set_custom_user_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_user_data = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html">SetEndpointAttributes</a>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html">SetEndpointAttributes</a>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlatformEndpointInput`](crate::input::CreatePlatformEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlatformEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlatformEndpointInput {
                platform_application_arn: self.platform_application_arn,
                token: self.token,
                custom_user_data: self.custom_user_data,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlatformEndpointInputOperationOutputAlias = crate::operation::CreatePlatformEndpoint;
#[doc(hidden)]
pub type CreatePlatformEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePlatformEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlatformEndpoint`](crate::operation::CreatePlatformEndpoint)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlatformEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePlatformEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePlatformEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePlatformEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_platform_endpoint(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlatformEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlatformEndpoint",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePlatformEndpointInput`](crate::input::CreatePlatformEndpointInput)
    pub fn builder() -> crate::input::create_platform_endpoint_input::Builder {
        crate::input::create_platform_endpoint_input::Builder::default()
    }
}

/// See [`CreateSmsSandboxPhoneNumberInput`](crate::input::CreateSmsSandboxPhoneNumberInput)
pub mod create_sms_sandbox_phone_number_input {
    /// A builder for [`CreateSmsSandboxPhoneNumberInput`](crate::input::CreateSmsSandboxPhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCodeString>,
    }
    impl Builder {
        /// <p>The destination phone number to verify. On verification, Amazon SNS adds this phone number
        /// to the list of verified phone numbers that you can send SMS messages to.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The destination phone number to verify. On verification, Amazon SNS adds this phone number
        /// to the list of verified phone numbers that you can send SMS messages to.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The language to use for sending the OTP. The default value is
        /// <code>en-US</code>.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCodeString) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language to use for sending the OTP. The default value is
        /// <code>en-US</code>.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCodeString>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSmsSandboxPhoneNumberInput`](crate::input::CreateSmsSandboxPhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSmsSandboxPhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSmsSandboxPhoneNumberInput {
                phone_number: self.phone_number,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSmsSandboxPhoneNumberInputOperationOutputAlias =
    crate::operation::CreateSMSSandboxPhoneNumber;
#[doc(hidden)]
pub type CreateSmsSandboxPhoneNumberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSmsSandboxPhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`CreateSMSSandboxPhoneNumber`](crate::operation::CreateSMSSandboxPhoneNumber)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSMSSandboxPhoneNumber,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSmsSandboxPhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSmsSandboxPhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSmsSandboxPhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_sms_sandbox_phone_number(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSMSSandboxPhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSMSSandboxPhoneNumber",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSmsSandboxPhoneNumberInput`](crate::input::CreateSmsSandboxPhoneNumberInput)
    pub fn builder() -> crate::input::create_sms_sandbox_phone_number_input::Builder {
        crate::input::create_sms_sandbox_phone_number_input::Builder::default()
    }
}

/// See [`CreateTopicInput`](crate::input::CreateTopicInput)
pub mod create_topic_input {
    /// A builder for [`CreateTopicInput`](crate::input::CreateTopicInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the topic you want to create.</p>
        /// <p>Constraints: Topic names must be made up of only uppercase and lowercase ASCII
        /// letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters
        /// long.</p>
        /// <p>For a FIFO (first-in-first-out) topic, the name must end with the <code>.fifo</code>
        /// suffix. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the topic you want to create.</p>
        /// <p>Constraints: Topic names must be made up of only uppercase and lowercase ASCII
        /// letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters
        /// long.</p>
        /// <p>For a FIFO (first-in-first-out) topic, the name must end with the <code>.fifo</code>
        /// suffix. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that the <code>CreateTopic</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DisplayName</code> – The display name to use for a topic with SMS
        /// subscriptions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoTopic</code> – Set to true to create a FIFO topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The policy that defines who can access your
        /// topic. By default, only the topic owner can publish or subscribe to the
        /// topic.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side
        /// encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master
        /// key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
        /// Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API
        /// Reference</i>. </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FifoTopic</code> – When this is set to <code>true</code>, a FIFO
        /// topic is created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication for
        /// FIFO topics.</p>
        ///
        /// <ul>
        /// <li>
        /// <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>.
        /// If you create a FIFO topic and this attribute is <code>false</code>, you must
        /// specify a value for the <code>MessageDeduplicationId</code> parameter for the
        /// <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p>
        /// </li>
        /// <li>
        /// <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>,
        /// Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using
        /// the body of the message (but not the attributes of the message).</p>
        /// <p>(Optional) To override the generated value, you can specify a value
        /// for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code>
        /// action.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that the <code>CreateTopic</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DisplayName</code> – The display name to use for a topic with SMS
        /// subscriptions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FifoTopic</code> – Set to true to create a FIFO topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The policy that defines who can access your
        /// topic. By default, only the topic owner can publish or subscribe to the
        /// topic.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side
        /// encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master
        /// key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
        /// Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API
        /// Reference</i>. </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FifoTopic</code> – When this is set to <code>true</code>, a FIFO
        /// topic is created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication for
        /// FIFO topics.</p>
        ///
        /// <ul>
        /// <li>
        /// <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>.
        /// If you create a FIFO topic and this attribute is <code>false</code>, you must
        /// specify a value for the <code>MessageDeduplicationId</code> parameter for the
        /// <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p>
        /// </li>
        /// <li>
        /// <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>,
        /// Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using
        /// the body of the message (but not the attributes of the message).</p>
        /// <p>(Optional) To override the generated value, you can specify a value
        /// for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code>
        /// action.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to add to a new topic.</p>
        /// <note>
        /// <p>To be able to tag a topic on creation, you must have the
        /// <code>sns:CreateTopic</code> and <code>sns:TagResource</code>
        /// permissions.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags to add to a new topic.</p>
        /// <note>
        /// <p>To be able to tag a topic on creation, you must have the
        /// <code>sns:CreateTopic</code> and <code>sns:TagResource</code>
        /// permissions.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTopicInput`](crate::input::CreateTopicInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTopicInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTopicInput {
                name: self.name,
                attributes: self.attributes,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTopicInputOperationOutputAlias = crate::operation::CreateTopic;
#[doc(hidden)]
pub type CreateTopicInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTopicInput {
    /// Consumes the builder and constructs an Operation<[`CreateTopic`](crate::operation::CreateTopic)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTopic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTopicInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTopicInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTopicInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_topic(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTopic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTopic",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTopicInput`](crate::input::CreateTopicInput)
    pub fn builder() -> crate::input::create_topic_input::Builder {
        crate::input::create_topic_input::Builder::default()
    }
}

/// See [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
pub mod delete_endpoint_input {
    /// A builder for [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>EndpointArn of endpoint to delete.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>EndpointArn of endpoint to delete.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointInput {
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointInputOperationOutputAlias = crate::operation::DeleteEndpoint;
#[doc(hidden)]
pub type DeleteEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpoint`](crate::operation::DeleteEndpoint)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_endpoint(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpoint",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
}

/// See [`DeletePlatformApplicationInput`](crate::input::DeletePlatformApplicationInput)
pub mod delete_platform_application_input {
    /// A builder for [`DeletePlatformApplicationInput`](crate::input::DeletePlatformApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_application_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>PlatformApplicationArn of platform application object to delete.</p>
        pub fn platform_application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_application_arn = Some(input.into());
            self
        }
        /// <p>PlatformApplicationArn of platform application object to delete.</p>
        pub fn set_platform_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_application_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePlatformApplicationInput`](crate::input::DeletePlatformApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePlatformApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePlatformApplicationInput {
                platform_application_arn: self.platform_application_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePlatformApplicationInputOperationOutputAlias =
    crate::operation::DeletePlatformApplication;
#[doc(hidden)]
pub type DeletePlatformApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePlatformApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeletePlatformApplication`](crate::operation::DeletePlatformApplication)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePlatformApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePlatformApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePlatformApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePlatformApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_platform_application(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePlatformApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePlatformApplication",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePlatformApplicationInput`](crate::input::DeletePlatformApplicationInput)
    pub fn builder() -> crate::input::delete_platform_application_input::Builder {
        crate::input::delete_platform_application_input::Builder::default()
    }
}

/// See [`DeleteSmsSandboxPhoneNumberInput`](crate::input::DeleteSmsSandboxPhoneNumberInput)
pub mod delete_sms_sandbox_phone_number_input {
    /// A builder for [`DeleteSmsSandboxPhoneNumberInput`](crate::input::DeleteSmsSandboxPhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The destination phone number to delete.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The destination phone number to delete.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSmsSandboxPhoneNumberInput`](crate::input::DeleteSmsSandboxPhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSmsSandboxPhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSmsSandboxPhoneNumberInput {
                phone_number: self.phone_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSmsSandboxPhoneNumberInputOperationOutputAlias =
    crate::operation::DeleteSMSSandboxPhoneNumber;
#[doc(hidden)]
pub type DeleteSmsSandboxPhoneNumberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSmsSandboxPhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSMSSandboxPhoneNumber`](crate::operation::DeleteSMSSandboxPhoneNumber)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSMSSandboxPhoneNumber,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSmsSandboxPhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSmsSandboxPhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSmsSandboxPhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_sms_sandbox_phone_number(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSMSSandboxPhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSMSSandboxPhoneNumber",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSmsSandboxPhoneNumberInput`](crate::input::DeleteSmsSandboxPhoneNumberInput)
    pub fn builder() -> crate::input::delete_sms_sandbox_phone_number_input::Builder {
        crate::input::delete_sms_sandbox_phone_number_input::Builder::default()
    }
}

/// See [`DeleteTopicInput`](crate::input::DeleteTopicInput)
pub mod delete_topic_input {
    /// A builder for [`DeleteTopicInput`](crate::input::DeleteTopicInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic you want to delete.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic you want to delete.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTopicInput`](crate::input::DeleteTopicInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTopicInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTopicInput {
                topic_arn: self.topic_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTopicInputOperationOutputAlias = crate::operation::DeleteTopic;
#[doc(hidden)]
pub type DeleteTopicInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTopicInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTopic`](crate::operation::DeleteTopic)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTopic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTopicInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTopicInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTopicInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_topic(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTopic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTopic",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTopicInput`](crate::input::DeleteTopicInput)
    pub fn builder() -> crate::input::delete_topic_input::Builder {
        crate::input::delete_topic_input::Builder::default()
    }
}

/// See [`GetEndpointAttributesInput`](crate::input::GetEndpointAttributesInput)
pub mod get_endpoint_attributes_input {
    /// A builder for [`GetEndpointAttributesInput`](crate::input::GetEndpointAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>EndpointArn for GetEndpointAttributes input.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>EndpointArn for GetEndpointAttributes input.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEndpointAttributesInput`](crate::input::GetEndpointAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEndpointAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEndpointAttributesInput {
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEndpointAttributesInputOperationOutputAlias = crate::operation::GetEndpointAttributes;
#[doc(hidden)]
pub type GetEndpointAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEndpointAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetEndpointAttributes`](crate::operation::GetEndpointAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEndpointAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEndpointAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEndpointAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEndpointAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_endpoint_attributes(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEndpointAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEndpointAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEndpointAttributesInput`](crate::input::GetEndpointAttributesInput)
    pub fn builder() -> crate::input::get_endpoint_attributes_input::Builder {
        crate::input::get_endpoint_attributes_input::Builder::default()
    }
}

/// See [`GetPlatformApplicationAttributesInput`](crate::input::GetPlatformApplicationAttributesInput)
pub mod get_platform_application_attributes_input {
    /// A builder for [`GetPlatformApplicationAttributesInput`](crate::input::GetPlatformApplicationAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_application_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>PlatformApplicationArn for GetPlatformApplicationAttributesInput.</p>
        pub fn platform_application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_application_arn = Some(input.into());
            self
        }
        /// <p>PlatformApplicationArn for GetPlatformApplicationAttributesInput.</p>
        pub fn set_platform_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_application_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPlatformApplicationAttributesInput`](crate::input::GetPlatformApplicationAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPlatformApplicationAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPlatformApplicationAttributesInput {
                platform_application_arn: self.platform_application_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPlatformApplicationAttributesInputOperationOutputAlias =
    crate::operation::GetPlatformApplicationAttributes;
#[doc(hidden)]
pub type GetPlatformApplicationAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPlatformApplicationAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetPlatformApplicationAttributes`](crate::operation::GetPlatformApplicationAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPlatformApplicationAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPlatformApplicationAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPlatformApplicationAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPlatformApplicationAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_platform_application_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPlatformApplicationAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPlatformApplicationAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPlatformApplicationAttributesInput`](crate::input::GetPlatformApplicationAttributesInput)
    pub fn builder() -> crate::input::get_platform_application_attributes_input::Builder {
        crate::input::get_platform_application_attributes_input::Builder::default()
    }
}

/// See [`GetSmsAttributesInput`](crate::input::GetSmsAttributesInput)
pub mod get_sms_attributes_input {
    /// A builder for [`GetSmsAttributesInput`](crate::input::GetSmsAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for
        /// which you want values.</p>
        /// <p>For all attribute names, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.</p>
        /// <p>If you don't use this parameter, Amazon SNS returns all SMS attributes.</p>
        pub fn attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for
        /// which you want values.</p>
        /// <p>For all attribute names, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.</p>
        /// <p>If you don't use this parameter, Amazon SNS returns all SMS attributes.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSmsAttributesInput`](crate::input::GetSmsAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSmsAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSmsAttributesInput {
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSmsAttributesInputOperationOutputAlias = crate::operation::GetSMSAttributes;
#[doc(hidden)]
pub type GetSmsAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSmsAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetSMSAttributes`](crate::operation::GetSMSAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSMSAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSmsAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSmsAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSmsAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_sms_attributes(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSMSAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSMSAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSmsAttributesInput`](crate::input::GetSmsAttributesInput)
    pub fn builder() -> crate::input::get_sms_attributes_input::Builder {
        crate::input::get_sms_attributes_input::Builder::default()
    }
}

/// See [`GetSmsSandboxAccountStatusInput`](crate::input::GetSmsSandboxAccountStatusInput)
pub mod get_sms_sandbox_account_status_input {
    /// A builder for [`GetSmsSandboxAccountStatusInput`](crate::input::GetSmsSandboxAccountStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetSmsSandboxAccountStatusInput`](crate::input::GetSmsSandboxAccountStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSmsSandboxAccountStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSmsSandboxAccountStatusInput {})
        }
    }
}
#[doc(hidden)]
pub type GetSmsSandboxAccountStatusInputOperationOutputAlias =
    crate::operation::GetSMSSandboxAccountStatus;
#[doc(hidden)]
pub type GetSmsSandboxAccountStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSmsSandboxAccountStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetSMSSandboxAccountStatus`](crate::operation::GetSMSSandboxAccountStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSMSSandboxAccountStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSmsSandboxAccountStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSmsSandboxAccountStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSmsSandboxAccountStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_sms_sandbox_account_status(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSMSSandboxAccountStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSMSSandboxAccountStatus",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSmsSandboxAccountStatusInput`](crate::input::GetSmsSandboxAccountStatusInput)
    pub fn builder() -> crate::input::get_sms_sandbox_account_status_input::Builder {
        crate::input::get_sms_sandbox_account_status_input::Builder::default()
    }
}

/// See [`GetSubscriptionAttributesInput`](crate::input::GetSubscriptionAttributesInput)
pub mod get_subscription_attributes_input {
    /// A builder for [`GetSubscriptionAttributesInput`](crate::input::GetSubscriptionAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the subscription whose properties you want to get.</p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the subscription whose properties you want to get.</p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSubscriptionAttributesInput`](crate::input::GetSubscriptionAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSubscriptionAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSubscriptionAttributesInput {
                subscription_arn: self.subscription_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSubscriptionAttributesInputOperationOutputAlias =
    crate::operation::GetSubscriptionAttributes;
#[doc(hidden)]
pub type GetSubscriptionAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSubscriptionAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetSubscriptionAttributes`](crate::operation::GetSubscriptionAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSubscriptionAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSubscriptionAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSubscriptionAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSubscriptionAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_subscription_attributes(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSubscriptionAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSubscriptionAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSubscriptionAttributesInput`](crate::input::GetSubscriptionAttributesInput)
    pub fn builder() -> crate::input::get_subscription_attributes_input::Builder {
        crate::input::get_subscription_attributes_input::Builder::default()
    }
}

/// See [`GetTopicAttributesInput`](crate::input::GetTopicAttributesInput)
pub mod get_topic_attributes_input {
    /// A builder for [`GetTopicAttributesInput`](crate::input::GetTopicAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic whose properties you want to get.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic whose properties you want to get.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTopicAttributesInput`](crate::input::GetTopicAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTopicAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTopicAttributesInput {
                topic_arn: self.topic_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTopicAttributesInputOperationOutputAlias = crate::operation::GetTopicAttributes;
#[doc(hidden)]
pub type GetTopicAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTopicAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetTopicAttributes`](crate::operation::GetTopicAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTopicAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTopicAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTopicAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTopicAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_topic_attributes(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTopicAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTopicAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTopicAttributesInput`](crate::input::GetTopicAttributesInput)
    pub fn builder() -> crate::input::get_topic_attributes_input::Builder {
        crate::input::get_topic_attributes_input::Builder::default()
    }
}

/// See [`ListEndpointsByPlatformApplicationInput`](crate::input::ListEndpointsByPlatformApplicationInput)
pub mod list_endpoints_by_platform_application_input {
    /// A builder for [`ListEndpointsByPlatformApplicationInput`](crate::input::ListEndpointsByPlatformApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_application_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.</p>
        pub fn platform_application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_application_arn = Some(input.into());
            self
        }
        /// <p>PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.</p>
        pub fn set_platform_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_application_arn = input;
            self
        }
        /// <p>NextToken string is used when calling ListEndpointsByPlatformApplication action to
        /// retrieve additional records that are available after the first page results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken string is used when calling ListEndpointsByPlatformApplication action to
        /// retrieve additional records that are available after the first page results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEndpointsByPlatformApplicationInput`](crate::input::ListEndpointsByPlatformApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEndpointsByPlatformApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEndpointsByPlatformApplicationInput {
                platform_application_arn: self.platform_application_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEndpointsByPlatformApplicationInputOperationOutputAlias =
    crate::operation::ListEndpointsByPlatformApplication;
#[doc(hidden)]
pub type ListEndpointsByPlatformApplicationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEndpointsByPlatformApplicationInput {
    /// Consumes the builder and constructs an Operation<[`ListEndpointsByPlatformApplication`](crate::operation::ListEndpointsByPlatformApplication)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEndpointsByPlatformApplication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEndpointsByPlatformApplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEndpointsByPlatformApplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEndpointsByPlatformApplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_endpoints_by_platform_application(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEndpointsByPlatformApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEndpointsByPlatformApplication",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEndpointsByPlatformApplicationInput`](crate::input::ListEndpointsByPlatformApplicationInput)
    pub fn builder() -> crate::input::list_endpoints_by_platform_application_input::Builder {
        crate::input::list_endpoints_by_platform_application_input::Builder::default()
    }
}

/// See [`ListOriginationNumbersInput`](crate::input::ListOriginationNumbersInput)
pub mod list_origination_numbers_input {
    /// A builder for [`ListOriginationNumbersInput`](crate::input::ListOriginationNumbersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Token that the previous <code>ListOriginationNumbers</code> request returns.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token that the previous <code>ListOriginationNumbers</code> request returns.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of origination numbers to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of origination numbers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOriginationNumbersInput`](crate::input::ListOriginationNumbersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOriginationNumbersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOriginationNumbersInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOriginationNumbersInputOperationOutputAlias = crate::operation::ListOriginationNumbers;
#[doc(hidden)]
pub type ListOriginationNumbersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOriginationNumbersInput {
    /// Consumes the builder and constructs an Operation<[`ListOriginationNumbers`](crate::operation::ListOriginationNumbers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOriginationNumbers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOriginationNumbersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOriginationNumbersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOriginationNumbersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_origination_numbers(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOriginationNumbers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOriginationNumbers",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOriginationNumbersInput`](crate::input::ListOriginationNumbersInput)
    pub fn builder() -> crate::input::list_origination_numbers_input::Builder {
        crate::input::list_origination_numbers_input::Builder::default()
    }
}

/// See [`ListPhoneNumbersOptedOutInput`](crate::input::ListPhoneNumbersOptedOutInput)
pub mod list_phone_numbers_opted_out_input {
    /// A builder for [`ListPhoneNumbersOptedOutInput`](crate::input::ListPhoneNumbersOptedOutInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <code>NextToken</code> string is used when you call the
        /// <code>ListPhoneNumbersOptedOut</code> action to retrieve additional records that are
        /// available after the first page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A <code>NextToken</code> string is used when you call the
        /// <code>ListPhoneNumbersOptedOut</code> action to retrieve additional records that are
        /// available after the first page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPhoneNumbersOptedOutInput`](crate::input::ListPhoneNumbersOptedOutInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPhoneNumbersOptedOutInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPhoneNumbersOptedOutInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPhoneNumbersOptedOutInputOperationOutputAlias =
    crate::operation::ListPhoneNumbersOptedOut;
#[doc(hidden)]
pub type ListPhoneNumbersOptedOutInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPhoneNumbersOptedOutInput {
    /// Consumes the builder and constructs an Operation<[`ListPhoneNumbersOptedOut`](crate::operation::ListPhoneNumbersOptedOut)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPhoneNumbersOptedOut,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPhoneNumbersOptedOutInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPhoneNumbersOptedOutInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPhoneNumbersOptedOutInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_phone_numbers_opted_out(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPhoneNumbersOptedOut::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPhoneNumbersOptedOut",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPhoneNumbersOptedOutInput`](crate::input::ListPhoneNumbersOptedOutInput)
    pub fn builder() -> crate::input::list_phone_numbers_opted_out_input::Builder {
        crate::input::list_phone_numbers_opted_out_input::Builder::default()
    }
}

/// See [`ListPlatformApplicationsInput`](crate::input::ListPlatformApplicationsInput)
pub mod list_platform_applications_input {
    /// A builder for [`ListPlatformApplicationsInput`](crate::input::ListPlatformApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>NextToken string is used when calling ListPlatformApplications action to retrieve
        /// additional records that are available after the first page results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>NextToken string is used when calling ListPlatformApplications action to retrieve
        /// additional records that are available after the first page results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlatformApplicationsInput`](crate::input::ListPlatformApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPlatformApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPlatformApplicationsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPlatformApplicationsInputOperationOutputAlias =
    crate::operation::ListPlatformApplications;
#[doc(hidden)]
pub type ListPlatformApplicationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPlatformApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListPlatformApplications`](crate::operation::ListPlatformApplications)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPlatformApplications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPlatformApplicationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPlatformApplicationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPlatformApplicationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_platform_applications(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPlatformApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPlatformApplications",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPlatformApplicationsInput`](crate::input::ListPlatformApplicationsInput)
    pub fn builder() -> crate::input::list_platform_applications_input::Builder {
        crate::input::list_platform_applications_input::Builder::default()
    }
}

/// See [`ListSmsSandboxPhoneNumbersInput`](crate::input::ListSmsSandboxPhoneNumbersInput)
pub mod list_sms_sandbox_phone_numbers_input {
    /// A builder for [`ListSmsSandboxPhoneNumbersInput`](crate::input::ListSmsSandboxPhoneNumbersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Token that the previous <code>ListSMSSandboxPhoneNumbersInput</code> request
        /// returns.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token that the previous <code>ListSMSSandboxPhoneNumbersInput</code> request
        /// returns.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of phone numbers to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of phone numbers to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSmsSandboxPhoneNumbersInput`](crate::input::ListSmsSandboxPhoneNumbersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSmsSandboxPhoneNumbersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSmsSandboxPhoneNumbersInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSmsSandboxPhoneNumbersInputOperationOutputAlias =
    crate::operation::ListSMSSandboxPhoneNumbers;
#[doc(hidden)]
pub type ListSmsSandboxPhoneNumbersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSmsSandboxPhoneNumbersInput {
    /// Consumes the builder and constructs an Operation<[`ListSMSSandboxPhoneNumbers`](crate::operation::ListSMSSandboxPhoneNumbers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSMSSandboxPhoneNumbers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSmsSandboxPhoneNumbersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSmsSandboxPhoneNumbersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSmsSandboxPhoneNumbersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_sms_sandbox_phone_numbers(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSMSSandboxPhoneNumbers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSMSSandboxPhoneNumbers",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSmsSandboxPhoneNumbersInput`](crate::input::ListSmsSandboxPhoneNumbersInput)
    pub fn builder() -> crate::input::list_sms_sandbox_phone_numbers_input::Builder {
        crate::input::list_sms_sandbox_phone_numbers_input::Builder::default()
    }
}

/// See [`ListSubscriptionsInput`](crate::input::ListSubscriptionsInput)
pub mod list_subscriptions_input {
    /// A builder for [`ListSubscriptionsInput`](crate::input::ListSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Token returned by the previous <code>ListSubscriptions</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token returned by the previous <code>ListSubscriptions</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSubscriptionsInput`](crate::input::ListSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSubscriptionsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSubscriptionsInputOperationOutputAlias = crate::operation::ListSubscriptions;
#[doc(hidden)]
pub type ListSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSubscriptions`](crate::operation::ListSubscriptions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_subscriptions(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSubscriptions",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSubscriptionsInput`](crate::input::ListSubscriptionsInput)
    pub fn builder() -> crate::input::list_subscriptions_input::Builder {
        crate::input::list_subscriptions_input::Builder::default()
    }
}

/// See [`ListSubscriptionsByTopicInput`](crate::input::ListSubscriptionsByTopicInput)
pub mod list_subscriptions_by_topic_input {
    /// A builder for [`ListSubscriptionsByTopicInput`](crate::input::ListSubscriptionsByTopicInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic for which you wish to find subscriptions.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic for which you wish to find subscriptions.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>Token returned by the previous <code>ListSubscriptionsByTopic</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token returned by the previous <code>ListSubscriptionsByTopic</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSubscriptionsByTopicInput`](crate::input::ListSubscriptionsByTopicInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSubscriptionsByTopicInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSubscriptionsByTopicInput {
                topic_arn: self.topic_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSubscriptionsByTopicInputOperationOutputAlias =
    crate::operation::ListSubscriptionsByTopic;
#[doc(hidden)]
pub type ListSubscriptionsByTopicInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSubscriptionsByTopicInput {
    /// Consumes the builder and constructs an Operation<[`ListSubscriptionsByTopic`](crate::operation::ListSubscriptionsByTopic)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSubscriptionsByTopic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSubscriptionsByTopicInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSubscriptionsByTopicInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSubscriptionsByTopicInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_subscriptions_by_topic(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSubscriptionsByTopic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSubscriptionsByTopic",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSubscriptionsByTopicInput`](crate::input::ListSubscriptionsByTopicInput)
    pub fn builder() -> crate::input::list_subscriptions_by_topic_input::Builder {
        crate::input::list_subscriptions_by_topic_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic for which to list tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic for which to list tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTopicsInput`](crate::input::ListTopicsInput)
pub mod list_topics_input {
    /// A builder for [`ListTopicsInput`](crate::input::ListTopicsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Token returned by the previous <code>ListTopics</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token returned by the previous <code>ListTopics</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTopicsInput`](crate::input::ListTopicsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTopicsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTopicsInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTopicsInputOperationOutputAlias = crate::operation::ListTopics;
#[doc(hidden)]
pub type ListTopicsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTopicsInput {
    /// Consumes the builder and constructs an Operation<[`ListTopics`](crate::operation::ListTopics)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTopics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTopicsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTopicsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTopicsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_topics(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTopics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTopics",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTopicsInput`](crate::input::ListTopicsInput)
    pub fn builder() -> crate::input::list_topics_input::Builder {
        crate::input::list_topics_input::Builder::default()
    }
}

/// See [`OptInPhoneNumberInput`](crate::input::OptInPhoneNumberInput)
pub mod opt_in_phone_number_input {
    /// A builder for [`OptInPhoneNumberInput`](crate::input::OptInPhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The phone number to opt in. Use E.164 format.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number to opt in. Use E.164 format.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`OptInPhoneNumberInput`](crate::input::OptInPhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::OptInPhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::OptInPhoneNumberInput {
                phone_number: self.phone_number,
            })
        }
    }
}
#[doc(hidden)]
pub type OptInPhoneNumberInputOperationOutputAlias = crate::operation::OptInPhoneNumber;
#[doc(hidden)]
pub type OptInPhoneNumberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl OptInPhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`OptInPhoneNumber`](crate::operation::OptInPhoneNumber)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::OptInPhoneNumber,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::OptInPhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::OptInPhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::OptInPhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_opt_in_phone_number(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::OptInPhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "OptInPhoneNumber",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`OptInPhoneNumberInput`](crate::input::OptInPhoneNumberInput)
    pub fn builder() -> crate::input::opt_in_phone_number_input::Builder {
        crate::input::opt_in_phone_number_input::Builder::default()
    }
}

/// See [`PublishInput`](crate::input::PublishInput)
pub mod publish_input {
    /// A builder for [`PublishInput`](crate::input::PublishInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) message_structure: std::option::Option<std::string::String>,
        pub(crate) message_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
        >,
        pub(crate) message_deduplication_id: std::option::Option<std::string::String>,
        pub(crate) message_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The topic you want to publish to.</p>
        /// <p>If you don't specify a value for the <code>TopicArn</code> parameter, you must specify
        /// a value for the <code>PhoneNumber</code> or <code>TargetArn</code> parameters.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The topic you want to publish to.</p>
        /// <p>If you don't specify a value for the <code>TopicArn</code> parameter, you must specify
        /// a value for the <code>PhoneNumber</code> or <code>TargetArn</code> parameters.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>If you don't specify a value for the <code>TargetArn</code> parameter, you must
        /// specify a value for the <code>PhoneNumber</code> or <code>TopicArn</code>
        /// parameters.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>If you don't specify a value for the <code>TargetArn</code> parameter, you must
        /// specify a value for the <code>PhoneNumber</code> or <code>TopicArn</code>
        /// parameters.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The phone number to which you want to deliver an SMS message. Use E.164 format.</p>
        /// <p>If you don't specify a value for the <code>PhoneNumber</code> parameter, you must
        /// specify a value for the <code>TargetArn</code> or <code>TopicArn</code>
        /// parameters.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number to which you want to deliver an SMS message. Use E.164 format.</p>
        /// <p>If you don't specify a value for the <code>PhoneNumber</code> parameter, you must
        /// specify a value for the <code>TargetArn</code> or <code>TopicArn</code>
        /// parameters.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The message you want to send.</p>
        /// <p>If you are publishing to a topic and you want to send the same message to all
        /// transport protocols, include the text of the message as a String value. If you want to
        /// send different messages for each transport protocol, set the value of the
        /// <code>MessageStructure</code> parameter to <code>json</code> and use a JSON object
        /// for the <code>Message</code> parameter.
        /// </p>
        /// <p></p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>With the exception of SMS, messages must be UTF-8 encoded strings and at most
        /// 256 KB in size (262,144 bytes, not 262,144 characters).</p>
        /// </li>
        /// <li>
        /// <p>For SMS, each message can contain up to 140 characters. This character limit
        /// depends on the encoding schema. For example, an SMS message can contain 160 GSM
        /// characters, 140 ASCII characters, or 70 UCS-2 characters.</p>
        /// <p>If you publish a message that exceeds this size limit, Amazon SNS sends the message
        /// as multiple messages, each fitting within the size limit. Messages aren't
        /// truncated mid-word but are cut off at whole-word boundaries.</p>
        /// <p>The total size limit for a single SMS <code>Publish</code> action is 1,600
        /// characters.</p>
        /// </li>
        /// </ul>
        /// <p>JSON-specific constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Keys in the JSON object that correspond to supported transport protocols must
        /// have simple JSON string values.</p>
        /// </li>
        /// <li>
        /// <p>The values will be parsed (unescaped) before they are used in outgoing
        /// messages.</p>
        /// </li>
        /// <li>
        /// <p>Outbound notifications are JSON encoded (meaning that the characters will be
        /// reescaped for sending).</p>
        /// </li>
        /// <li>
        /// <p>Values have a minimum length of 0 (the empty string, "", is allowed).</p>
        /// </li>
        /// <li>
        /// <p>Values have a maximum length bounded by the overall message size (so,
        /// including multiple protocols may limit message sizes).</p>
        /// </li>
        /// <li>
        /// <p>Non-string values will cause the key to be ignored.</p>
        /// </li>
        /// <li>
        /// <p>Keys that do not correspond to supported transport protocols are
        /// ignored.</p>
        /// </li>
        /// <li>
        /// <p>Duplicate keys are not allowed.</p>
        /// </li>
        /// <li>
        /// <p>Failure to parse or validate any key or value in the message will cause the
        /// <code>Publish</code> call to return an error (no partial delivery).</p>
        /// </li>
        /// </ul>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message you want to send.</p>
        /// <p>If you are publishing to a topic and you want to send the same message to all
        /// transport protocols, include the text of the message as a String value. If you want to
        /// send different messages for each transport protocol, set the value of the
        /// <code>MessageStructure</code> parameter to <code>json</code> and use a JSON object
        /// for the <code>Message</code> parameter.
        /// </p>
        /// <p></p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>With the exception of SMS, messages must be UTF-8 encoded strings and at most
        /// 256 KB in size (262,144 bytes, not 262,144 characters).</p>
        /// </li>
        /// <li>
        /// <p>For SMS, each message can contain up to 140 characters. This character limit
        /// depends on the encoding schema. For example, an SMS message can contain 160 GSM
        /// characters, 140 ASCII characters, or 70 UCS-2 characters.</p>
        /// <p>If you publish a message that exceeds this size limit, Amazon SNS sends the message
        /// as multiple messages, each fitting within the size limit. Messages aren't
        /// truncated mid-word but are cut off at whole-word boundaries.</p>
        /// <p>The total size limit for a single SMS <code>Publish</code> action is 1,600
        /// characters.</p>
        /// </li>
        /// </ul>
        /// <p>JSON-specific constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Keys in the JSON object that correspond to supported transport protocols must
        /// have simple JSON string values.</p>
        /// </li>
        /// <li>
        /// <p>The values will be parsed (unescaped) before they are used in outgoing
        /// messages.</p>
        /// </li>
        /// <li>
        /// <p>Outbound notifications are JSON encoded (meaning that the characters will be
        /// reescaped for sending).</p>
        /// </li>
        /// <li>
        /// <p>Values have a minimum length of 0 (the empty string, "", is allowed).</p>
        /// </li>
        /// <li>
        /// <p>Values have a maximum length bounded by the overall message size (so,
        /// including multiple protocols may limit message sizes).</p>
        /// </li>
        /// <li>
        /// <p>Non-string values will cause the key to be ignored.</p>
        /// </li>
        /// <li>
        /// <p>Keys that do not correspond to supported transport protocols are
        /// ignored.</p>
        /// </li>
        /// <li>
        /// <p>Duplicate keys are not allowed.</p>
        /// </li>
        /// <li>
        /// <p>Failure to parse or validate any key or value in the message will cause the
        /// <code>Publish</code> call to return an error (no partial delivery).</p>
        /// </li>
        /// </ul>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Optional parameter to be used as the "Subject" line when the message is delivered to
        /// email endpoints. This field will also be included, if present, in the standard JSON
        /// messages delivered to other endpoints.</p>
        /// <p>Constraints: Subjects must be ASCII text that begins with a letter, number, or
        /// punctuation mark; must not include line breaks or control characters; and must be less
        /// than 100 characters long.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>Optional parameter to be used as the "Subject" line when the message is delivered to
        /// email endpoints. This field will also be included, if present, in the standard JSON
        /// messages delivered to other endpoints.</p>
        /// <p>Constraints: Subjects must be ASCII text that begins with a letter, number, or
        /// punctuation mark; must not include line breaks or control characters; and must be less
        /// than 100 characters long.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// <p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different
        /// message for each protocol. For example, using one publish action, you can send a short
        /// message to your SMS subscribers and a longer message to your email subscribers. If you
        /// set <code>MessageStructure</code> to <code>json</code>, the value of the
        /// <code>Message</code> parameter must: </p>
        /// <ul>
        /// <li>
        /// <p>be a syntactically valid JSON object; and</p>
        /// </li>
        /// <li>
        /// <p>contain at least a top-level JSON key of "default" with a value that is a
        /// string.</p>
        /// </li>
        /// </ul>
        /// <p>You can define other top-level keys that define the message you want to send to a
        /// specific transport protocol (e.g., "http").</p>
        /// <p>Valid value: <code>json</code>
        /// </p>
        pub fn message_structure(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_structure = Some(input.into());
            self
        }
        /// <p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different
        /// message for each protocol. For example, using one publish action, you can send a short
        /// message to your SMS subscribers and a longer message to your email subscribers. If you
        /// set <code>MessageStructure</code> to <code>json</code>, the value of the
        /// <code>Message</code> parameter must: </p>
        /// <ul>
        /// <li>
        /// <p>be a syntactically valid JSON object; and</p>
        /// </li>
        /// <li>
        /// <p>contain at least a top-level JSON key of "default" with a value that is a
        /// string.</p>
        /// </li>
        /// </ul>
        /// <p>You can define other top-level keys that define the message you want to send to a
        /// specific transport protocol (e.g., "http").</p>
        /// <p>Valid value: <code>json</code>
        /// </p>
        pub fn set_message_structure(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_structure = input;
            self
        }
        /// Adds a key-value pair to `message_attributes`.
        ///
        /// To override the contents of this collection use [`set_message_attributes`](Self::set_message_attributes).
        ///
        /// <p>Message attributes for Publish action.</p>
        pub fn message_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MessageAttributeValue>,
        ) -> Self {
            let mut hash_map = self.message_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.message_attributes = Some(hash_map);
            self
        }
        /// <p>Message attributes for Publish action.</p>
        pub fn set_message_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
            >,
        ) -> Self {
            self.message_attributes = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics. The
        /// <code>MessageDeduplicationId</code> can contain up to 128 alphanumeric characters
        /// (a-z, A-Z, 0-9) and punctuation
        /// <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>, which is a token
        /// used for deduplication of sent messages. If a message with a particular
        /// <code>MessageDeduplicationId</code> is sent successfully, any message sent with the
        /// same <code>MessageDeduplicationId</code> during the 5-minute deduplication interval is
        /// treated as a duplicate. </p>
        /// <p>If the topic has <code>ContentBasedDeduplication</code> set, the system generates a
        /// <code>MessageDeduplicationId</code> based on the contents of the message. Your
        /// <code>MessageDeduplicationId</code> overrides the generated one.</p>
        pub fn message_deduplication_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_deduplication_id = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics. The
        /// <code>MessageDeduplicationId</code> can contain up to 128 alphanumeric characters
        /// (a-z, A-Z, 0-9) and punctuation
        /// <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
        /// <p>Every message must have a unique <code>MessageDeduplicationId</code>, which is a token
        /// used for deduplication of sent messages. If a message with a particular
        /// <code>MessageDeduplicationId</code> is sent successfully, any message sent with the
        /// same <code>MessageDeduplicationId</code> during the 5-minute deduplication interval is
        /// treated as a duplicate. </p>
        /// <p>If the topic has <code>ContentBasedDeduplication</code> set, the system generates a
        /// <code>MessageDeduplicationId</code> based on the contents of the message. Your
        /// <code>MessageDeduplicationId</code> overrides the generated one.</p>
        pub fn set_message_deduplication_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_deduplication_id = input;
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics. The
        /// <code>MessageGroupId</code> can contain up to 128 alphanumeric characters (a-z, A-Z,
        /// 0-9) and punctuation <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
        /// <p>The <code>MessageGroupId</code> is a tag that specifies that a message belongs to a
        /// specific message group. Messages that belong to the same message group are processed in
        /// a FIFO manner (however, messages in different message groups might be processed out of
        /// order). Every message must include a <code>MessageGroupId</code>.</p>
        pub fn message_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_group_id = Some(input.into());
            self
        }
        /// <p>This parameter applies only to FIFO (first-in-first-out) topics. The
        /// <code>MessageGroupId</code> can contain up to 128 alphanumeric characters (a-z, A-Z,
        /// 0-9) and punctuation <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
        /// <p>The <code>MessageGroupId</code> is a tag that specifies that a message belongs to a
        /// specific message group. Messages that belong to the same message group are processed in
        /// a FIFO manner (however, messages in different message groups might be processed out of
        /// order). Every message must include a <code>MessageGroupId</code>.</p>
        pub fn set_message_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishInput`](crate::input::PublishInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PublishInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PublishInput {
                topic_arn: self.topic_arn,
                target_arn: self.target_arn,
                phone_number: self.phone_number,
                message: self.message,
                subject: self.subject,
                message_structure: self.message_structure,
                message_attributes: self.message_attributes,
                message_deduplication_id: self.message_deduplication_id,
                message_group_id: self.message_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishInputOperationOutputAlias = crate::operation::Publish;
#[doc(hidden)]
pub type PublishInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PublishInput {
    /// Consumes the builder and constructs an Operation<[`Publish`](crate::operation::Publish)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Publish,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PublishInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PublishInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PublishInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_publish(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Publish::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("Publish", "sns"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PublishInput`](crate::input::PublishInput)
    pub fn builder() -> crate::input::publish_input::Builder {
        crate::input::publish_input::Builder::default()
    }
}

/// See [`RemovePermissionInput`](crate::input::RemovePermissionInput)
pub mod remove_permission_input {
    /// A builder for [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic whose access control policy you wish to modify.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic whose access control policy you wish to modify.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The unique label of the statement you want to remove.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The unique label of the statement you want to remove.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// Consumes the builder and constructs a [`RemovePermissionInput`](crate::input::RemovePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemovePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemovePermissionInput {
                topic_arn: self.topic_arn,
                label: self.label,
            })
        }
    }
}
#[doc(hidden)]
pub type RemovePermissionInputOperationOutputAlias = crate::operation::RemovePermission;
#[doc(hidden)]
pub type RemovePermissionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemovePermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemovePermission`](crate::operation::RemovePermission)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemovePermission,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemovePermissionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemovePermissionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemovePermissionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_permission(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemovePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemovePermission",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
}

/// See [`SetEndpointAttributesInput`](crate::input::SetEndpointAttributesInput)
pub mod set_endpoint_attributes_input {
    /// A builder for [`SetEndpointAttributesInput`](crate::input::SetEndpointAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>EndpointArn used for SetEndpointAttributes action.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>EndpointArn used for SetEndpointAttributes action.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of the endpoint attributes. Attributes in this map include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CustomUserData</code> – arbitrary user data to associate with the
        /// endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and
        /// less than 2KB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Enabled</code> – flag that enables/disables delivery to the
        /// endpoint. Amazon SNS will set this to false when a notification service indicates to
        /// Amazon SNS that the endpoint is invalid. Users can set it back to true, typically
        /// after updating Token.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Token</code> – device token, also referred to as a registration id,
        /// for an app and mobile device. This is returned from the notification service
        /// when an app and mobile device are registered with the notification
        /// service.</p>
        /// </li>
        /// </ul>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of the endpoint attributes. Attributes in this map include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CustomUserData</code> – arbitrary user data to associate with the
        /// endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and
        /// less than 2KB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Enabled</code> – flag that enables/disables delivery to the
        /// endpoint. Amazon SNS will set this to false when a notification service indicates to
        /// Amazon SNS that the endpoint is invalid. Users can set it back to true, typically
        /// after updating Token.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Token</code> – device token, also referred to as a registration id,
        /// for an app and mobile device. This is returned from the notification service
        /// when an app and mobile device are registered with the notification
        /// service.</p>
        /// </li>
        /// </ul>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SetEndpointAttributesInput`](crate::input::SetEndpointAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetEndpointAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetEndpointAttributesInput {
                endpoint_arn: self.endpoint_arn,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type SetEndpointAttributesInputOperationOutputAlias = crate::operation::SetEndpointAttributes;
#[doc(hidden)]
pub type SetEndpointAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetEndpointAttributesInput {
    /// Consumes the builder and constructs an Operation<[`SetEndpointAttributes`](crate::operation::SetEndpointAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetEndpointAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetEndpointAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetEndpointAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetEndpointAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_endpoint_attributes(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetEndpointAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetEndpointAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetEndpointAttributesInput`](crate::input::SetEndpointAttributesInput)
    pub fn builder() -> crate::input::set_endpoint_attributes_input::Builder {
        crate::input::set_endpoint_attributes_input::Builder::default()
    }
}

/// See [`SetPlatformApplicationAttributesInput`](crate::input::SetPlatformApplicationAttributesInput)
pub mod set_platform_application_attributes_input {
    /// A builder for [`SetPlatformApplicationAttributesInput`](crate::input::SetPlatformApplicationAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform_application_arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>PlatformApplicationArn for SetPlatformApplicationAttributes action.</p>
        pub fn platform_application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_application_arn = Some(input.into());
            self
        }
        /// <p>PlatformApplicationArn for SetPlatformApplicationAttributes action.</p>
        pub fn set_platform_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_application_arn = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of the platform application attributes. Attributes in this map include the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlatformCredential</code> – The credential received from the
        /// notification service. For <code>APNS</code> and <code>APNS_SANDBOX</code>,
        /// <code>PlatformCredential</code> is <code>private key</code>. For
        /// <code>GCM</code> (Firebase Cloud Messaging), <code>PlatformCredential</code>
        /// is <code>API key</code>. For <code>ADM</code>, <code>PlatformCredential</code>
        /// is <code>client secret</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformPrincipal</code> – The principal received from the
        /// notification service. For <code>APNS</code> and <code>APNS_SANDBOX</code>,
        /// <code>PlatformPrincipal</code> is <code>SSL certificate</code>. For
        /// <code>GCM</code> (Firebase Cloud Messaging), there is no
        /// <code>PlatformPrincipal</code>. For <code>ADM</code>,
        /// <code>PlatformPrincipal</code> is <code>client id</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventEndpointCreated</code> – Topic ARN to which
        /// <code>EndpointCreated</code> event notifications are sent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventEndpointDeleted</code> – Topic ARN to which
        /// <code>EndpointDeleted</code> event notifications are sent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventEndpointUpdated</code> – Topic ARN to which
        /// <code>EndpointUpdate</code> event notifications are sent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventDeliveryFailure</code> – Topic ARN to which
        /// <code>DeliveryFailure</code> event notifications are sent upon Direct
        /// Publish delivery failure (permanent) to one of the application's
        /// endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS
        /// write access to use CloudWatch Logs on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS
        /// write access to use CloudWatch Logs on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100)
        /// of successfully delivered messages.</p>
        /// </li>
        /// </ul>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of the platform application attributes. Attributes in this map include the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlatformCredential</code> – The credential received from the
        /// notification service. For <code>APNS</code> and <code>APNS_SANDBOX</code>,
        /// <code>PlatformCredential</code> is <code>private key</code>. For
        /// <code>GCM</code> (Firebase Cloud Messaging), <code>PlatformCredential</code>
        /// is <code>API key</code>. For <code>ADM</code>, <code>PlatformCredential</code>
        /// is <code>client secret</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformPrincipal</code> – The principal received from the
        /// notification service. For <code>APNS</code> and <code>APNS_SANDBOX</code>,
        /// <code>PlatformPrincipal</code> is <code>SSL certificate</code>. For
        /// <code>GCM</code> (Firebase Cloud Messaging), there is no
        /// <code>PlatformPrincipal</code>. For <code>ADM</code>,
        /// <code>PlatformPrincipal</code> is <code>client id</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventEndpointCreated</code> – Topic ARN to which
        /// <code>EndpointCreated</code> event notifications are sent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventEndpointDeleted</code> – Topic ARN to which
        /// <code>EndpointDeleted</code> event notifications are sent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventEndpointUpdated</code> – Topic ARN to which
        /// <code>EndpointUpdate</code> event notifications are sent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EventDeliveryFailure</code> – Topic ARN to which
        /// <code>DeliveryFailure</code> event notifications are sent upon Direct
        /// Publish delivery failure (permanent) to one of the application's
        /// endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS
        /// write access to use CloudWatch Logs on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS
        /// write access to use CloudWatch Logs on your behalf.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100)
        /// of successfully delivered messages.</p>
        /// </li>
        /// </ul>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SetPlatformApplicationAttributesInput`](crate::input::SetPlatformApplicationAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetPlatformApplicationAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetPlatformApplicationAttributesInput {
                platform_application_arn: self.platform_application_arn,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type SetPlatformApplicationAttributesInputOperationOutputAlias =
    crate::operation::SetPlatformApplicationAttributes;
#[doc(hidden)]
pub type SetPlatformApplicationAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetPlatformApplicationAttributesInput {
    /// Consumes the builder and constructs an Operation<[`SetPlatformApplicationAttributes`](crate::operation::SetPlatformApplicationAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetPlatformApplicationAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetPlatformApplicationAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetPlatformApplicationAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetPlatformApplicationAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_platform_application_attributes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetPlatformApplicationAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetPlatformApplicationAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetPlatformApplicationAttributesInput`](crate::input::SetPlatformApplicationAttributesInput)
    pub fn builder() -> crate::input::set_platform_application_attributes_input::Builder {
        crate::input::set_platform_application_attributes_input::Builder::default()
    }
}

/// See [`SetSmsAttributesInput`](crate::input::SetSmsAttributesInput)
pub mod set_sms_attributes_input {
    /// A builder for [`SetSmsAttributesInput`](crate::input::SetSmsAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The default settings for sending SMS messages from your account. You can set values
        /// for the following attribute names:</p>
        /// <p>
        /// <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend
        /// each month to send SMS messages. When Amazon SNS determines that sending an SMS message would
        /// incur a cost that exceeds this limit, it stops sending SMS messages within
        /// minutes.</p>
        /// <important>
        /// <p>Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During
        /// that interval, if you continue to send SMS messages, you will incur costs that
        /// exceed your limit.</p>
        /// </important>
        /// <p>By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to
        /// raise the limit, submit an <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sns">SNS Limit Increase case</a>. For <b>New limit
        /// value</b>, enter your desired monthly spend limit. In the <b>Use Case Description</b> field, explain that you are requesting
        /// an SMS monthly spend limit increase.</p>
        /// <p>
        /// <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write
        /// logs about SMS deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS
        /// writes a log that includes the message price, the success or failure status, the reason
        /// for failure (if the message failed), the message dwell time, and other
        /// information.</p>
        /// <p>
        /// <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS
        /// deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value can be an
        /// integer from 0 - 100. For example, to write logs only for failed deliveries, set this
        /// value to <code>0</code>. To write logs for 10% of your successful deliveries, set it to
        /// <code>10</code>.</p>
        /// <p>
        /// <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed
        /// as the sender on the receiving device. Support for sender IDs varies by country. The
        /// sender ID can be 1 - 11 alphanumeric characters, and it must contain at least one
        /// letter.</p>
        /// <p>
        /// <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You
        /// can assign the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Promotional</code> – (Default) Noncritical messages, such as marketing
        /// messages. Amazon SNS optimizes the message delivery to incur the lowest cost.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Transactional</code> – Critical messages that support customer
        /// transactions, such as one-time passcodes for multi-factor authentication. Amazon
        /// SNS optimizes the message delivery to achieve the highest reliability.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS
        /// usage reports from Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to
        /// the bucket. The report includes the following information for each SMS message that was
        /// successfully delivered by your account:</p>
        /// <ul>
        /// <li>
        /// <p>Time that the message was published (in UTC)</p>
        /// </li>
        /// <li>
        /// <p>Message ID</p>
        /// </li>
        /// <li>
        /// <p>Destination phone number</p>
        /// </li>
        /// <li>
        /// <p>Message type</p>
        /// </li>
        /// <li>
        /// <p>Delivery status</p>
        /// </li>
        /// <li>
        /// <p>Message price (in USD)</p>
        /// </li>
        /// <li>
        /// <p>Part number (a message is split into multiple parts if it is too long for a
        /// single message)</p>
        /// </li>
        /// <li>
        /// <p>Total number of parts</p>
        /// </li>
        /// </ul>
        /// <p>To receive the report, the bucket must have a policy that allows the Amazon SNS service
        /// principal to perform the <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code>
        /// actions.</p>
        /// <p>For an example bucket policy and usage report, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the
        /// <i>Amazon SNS Developer Guide</i>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The default settings for sending SMS messages from your account. You can set values
        /// for the following attribute names:</p>
        /// <p>
        /// <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend
        /// each month to send SMS messages. When Amazon SNS determines that sending an SMS message would
        /// incur a cost that exceeds this limit, it stops sending SMS messages within
        /// minutes.</p>
        /// <important>
        /// <p>Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During
        /// that interval, if you continue to send SMS messages, you will incur costs that
        /// exceed your limit.</p>
        /// </important>
        /// <p>By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to
        /// raise the limit, submit an <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sns">SNS Limit Increase case</a>. For <b>New limit
        /// value</b>, enter your desired monthly spend limit. In the <b>Use Case Description</b> field, explain that you are requesting
        /// an SMS monthly spend limit increase.</p>
        /// <p>
        /// <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write
        /// logs about SMS deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS
        /// writes a log that includes the message price, the success or failure status, the reason
        /// for failure (if the message failed), the message dwell time, and other
        /// information.</p>
        /// <p>
        /// <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS
        /// deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value can be an
        /// integer from 0 - 100. For example, to write logs only for failed deliveries, set this
        /// value to <code>0</code>. To write logs for 10% of your successful deliveries, set it to
        /// <code>10</code>.</p>
        /// <p>
        /// <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed
        /// as the sender on the receiving device. Support for sender IDs varies by country. The
        /// sender ID can be 1 - 11 alphanumeric characters, and it must contain at least one
        /// letter.</p>
        /// <p>
        /// <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You
        /// can assign the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Promotional</code> – (Default) Noncritical messages, such as marketing
        /// messages. Amazon SNS optimizes the message delivery to incur the lowest cost.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Transactional</code> – Critical messages that support customer
        /// transactions, such as one-time passcodes for multi-factor authentication. Amazon
        /// SNS optimizes the message delivery to achieve the highest reliability.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS
        /// usage reports from Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to
        /// the bucket. The report includes the following information for each SMS message that was
        /// successfully delivered by your account:</p>
        /// <ul>
        /// <li>
        /// <p>Time that the message was published (in UTC)</p>
        /// </li>
        /// <li>
        /// <p>Message ID</p>
        /// </li>
        /// <li>
        /// <p>Destination phone number</p>
        /// </li>
        /// <li>
        /// <p>Message type</p>
        /// </li>
        /// <li>
        /// <p>Delivery status</p>
        /// </li>
        /// <li>
        /// <p>Message price (in USD)</p>
        /// </li>
        /// <li>
        /// <p>Part number (a message is split into multiple parts if it is too long for a
        /// single message)</p>
        /// </li>
        /// <li>
        /// <p>Total number of parts</p>
        /// </li>
        /// </ul>
        /// <p>To receive the report, the bucket must have a policy that allows the Amazon SNS service
        /// principal to perform the <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code>
        /// actions.</p>
        /// <p>For an example bucket policy and usage report, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the
        /// <i>Amazon SNS Developer Guide</i>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSmsAttributesInput`](crate::input::SetSmsAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetSmsAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetSmsAttributesInput {
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type SetSmsAttributesInputOperationOutputAlias = crate::operation::SetSMSAttributes;
#[doc(hidden)]
pub type SetSmsAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetSmsAttributesInput {
    /// Consumes the builder and constructs an Operation<[`SetSMSAttributes`](crate::operation::SetSMSAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetSMSAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetSmsAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetSmsAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetSmsAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_sms_attributes(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetSMSAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetSMSAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetSmsAttributesInput`](crate::input::SetSmsAttributesInput)
    pub fn builder() -> crate::input::set_sms_attributes_input::Builder {
        crate::input::set_sms_attributes_input::Builder::default()
    }
}

/// See [`SetSubscriptionAttributesInput`](crate::input::SetSubscriptionAttributesInput)
pub mod set_subscription_attributes_input {
    /// A builder for [`SetSubscriptionAttributesInput`](crate::input::SetSubscriptionAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the subscription to modify.</p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the subscription to modify.</p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that this action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FilterPolicy</code> – The simple JSON object that lets your
        /// subscriber receive only a subset of messages, rather than receiving every
        /// message published to the topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RawMessageDelivery</code> – When set to <code>true</code>,
        /// enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the
        /// need for the endpoints to process JSON formatting, which is otherwise created
        /// for Amazon SNS metadata.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
        /// Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable)
        /// or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held
        /// in the dead-letter queue for further analysis or reprocessing.</p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p>
        /// <ul>
        /// <li>
        /// <p>Permission to write to the Kinesis Data Firehose delivery stream</p>
        /// </li>
        /// <li>
        /// <p>Amazon SNS listed as a trusted entity</p>
        /// </li>
        /// </ul>
        /// <p>Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions.
        /// For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout
        /// to Kinesis Data Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that this action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FilterPolicy</code> – The simple JSON object that lets your
        /// subscriber receive only a subset of messages, rather than receiving every
        /// message published to the topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RawMessageDelivery</code> – When set to <code>true</code>,
        /// enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the
        /// need for the endpoints to process JSON formatting, which is otherwise created
        /// for Amazon SNS metadata.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
        /// Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable)
        /// or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held
        /// in the dead-letter queue for further analysis or reprocessing.</p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p>
        /// <ul>
        /// <li>
        /// <p>Permission to write to the Kinesis Data Firehose delivery stream</p>
        /// </li>
        /// <li>
        /// <p>Amazon SNS listed as a trusted entity</p>
        /// </li>
        /// </ul>
        /// <p>Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions.
        /// For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout
        /// to Kinesis Data Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The new value for the attribute in JSON format.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>The new value for the attribute in JSON format.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSubscriptionAttributesInput`](crate::input::SetSubscriptionAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetSubscriptionAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetSubscriptionAttributesInput {
                subscription_arn: self.subscription_arn,
                attribute_name: self.attribute_name,
                attribute_value: self.attribute_value,
            })
        }
    }
}
#[doc(hidden)]
pub type SetSubscriptionAttributesInputOperationOutputAlias =
    crate::operation::SetSubscriptionAttributes;
#[doc(hidden)]
pub type SetSubscriptionAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetSubscriptionAttributesInput {
    /// Consumes the builder and constructs an Operation<[`SetSubscriptionAttributes`](crate::operation::SetSubscriptionAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetSubscriptionAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetSubscriptionAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetSubscriptionAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetSubscriptionAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_subscription_attributes(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetSubscriptionAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetSubscriptionAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetSubscriptionAttributesInput`](crate::input::SetSubscriptionAttributesInput)
    pub fn builder() -> crate::input::set_subscription_attributes_input::Builder {
        crate::input::set_subscription_attributes_input::Builder::default()
    }
}

/// See [`SetTopicAttributesInput`](crate::input::SetTopicAttributesInput)
pub mod set_topic_attributes_input {
    /// A builder for [`SetTopicAttributesInput`](crate::input::SetTopicAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the topic to modify.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic to modify.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that the <code>SetTopicAttributes</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DisplayName</code> – The display name to use for a topic with SMS
        /// subscriptions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The policy that defines who can access your
        /// topic. By default, only the topic owner can publish or subscribe to the
        /// topic.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master
        /// key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
        /// Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API
        /// Reference</i>. </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication for
        /// FIFO topics.</p>
        ///
        /// <ul>
        /// <li>
        /// <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>.
        /// If you create a FIFO topic and this attribute is <code>false</code>, you must
        /// specify a value for the <code>MessageDeduplicationId</code> parameter for the
        /// <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p>
        /// </li>
        /// <li>
        /// <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>,
        /// Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using
        /// the body of the message (but not the attributes of the message).</p>
        /// <p>(Optional) To override the generated value, you can specify a value
        /// for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code>
        /// action.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that the <code>SetTopicAttributes</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DisplayName</code> – The display name to use for a topic with SMS
        /// subscriptions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Policy</code> – The policy that defines who can access your
        /// topic. By default, only the topic owner can publish or subscribe to the
        /// topic.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master
        /// key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
        /// Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API
        /// Reference</i>. </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication for
        /// FIFO topics.</p>
        ///
        /// <ul>
        /// <li>
        /// <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>.
        /// If you create a FIFO topic and this attribute is <code>false</code>, you must
        /// specify a value for the <code>MessageDeduplicationId</code> parameter for the
        /// <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p>
        /// </li>
        /// <li>
        /// <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>,
        /// Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using
        /// the body of the message (but not the attributes of the message).</p>
        /// <p>(Optional) To override the generated value, you can specify a value
        /// for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code>
        /// action.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The new value for the attribute.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>The new value for the attribute.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`SetTopicAttributesInput`](crate::input::SetTopicAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetTopicAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetTopicAttributesInput {
                topic_arn: self.topic_arn,
                attribute_name: self.attribute_name,
                attribute_value: self.attribute_value,
            })
        }
    }
}
#[doc(hidden)]
pub type SetTopicAttributesInputOperationOutputAlias = crate::operation::SetTopicAttributes;
#[doc(hidden)]
pub type SetTopicAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetTopicAttributesInput {
    /// Consumes the builder and constructs an Operation<[`SetTopicAttributes`](crate::operation::SetTopicAttributes)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetTopicAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetTopicAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetTopicAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetTopicAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_topic_attributes(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetTopicAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetTopicAttributes",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetTopicAttributesInput`](crate::input::SetTopicAttributesInput)
    pub fn builder() -> crate::input::set_topic_attributes_input::Builder {
        crate::input::set_topic_attributes_input::Builder::default()
    }
}

/// See [`SubscribeInput`](crate::input::SubscribeInput)
pub mod subscribe_input {
    /// A builder for [`SubscribeInput`](crate::input::SubscribeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) return_subscription_arn: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the topic you want to subscribe to.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic you want to subscribe to.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>The protocol that you want to use. Supported protocols include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>http</code> – delivery of JSON-encoded message via HTTP
        /// POST</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https</code> – delivery of JSON-encoded message via HTTPS
        /// POST</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>email</code> – delivery of message via SMTP</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>email-json</code> – delivery of JSON-encoded message via
        /// SMTP</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sms</code> – delivery of message via SMS</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqs</code> – delivery of JSON-encoded message to an Amazon SQS
        /// queue</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application</code> – delivery of JSON-encoded message to an
        /// EndpointArn for a mobile app and device</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>lambda</code> – delivery of JSON-encoded message to an Lambda
        /// function</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>firehose</code> – delivery of JSON-encoded message to an Amazon
        /// Kinesis Data Firehose delivery stream.</p>
        /// </li>
        /// </ul>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol that you want to use. Supported protocols include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>http</code> – delivery of JSON-encoded message via HTTP
        /// POST</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>https</code> – delivery of JSON-encoded message via HTTPS
        /// POST</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>email</code> – delivery of message via SMTP</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>email-json</code> – delivery of JSON-encoded message via
        /// SMTP</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sms</code> – delivery of message via SMS</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sqs</code> – delivery of JSON-encoded message to an Amazon SQS
        /// queue</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application</code> – delivery of JSON-encoded message to an
        /// EndpointArn for a mobile app and device</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>lambda</code> – delivery of JSON-encoded message to an Lambda
        /// function</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>firehose</code> – delivery of JSON-encoded message to an Amazon
        /// Kinesis Data Firehose delivery stream.</p>
        /// </li>
        /// </ul>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The endpoint that you want to receive notifications. Endpoints vary by
        /// protocol:</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>http</code> protocol, the (public) endpoint is a URL beginning
        /// with <code>http://</code>.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>https</code> protocol, the (public) endpoint is a URL beginning
        /// with <code>https://</code>.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>email</code> protocol, the endpoint is an email address.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>email-json</code> protocol, the endpoint is an email
        /// address.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>sms</code> protocol, the endpoint is a phone number of an
        /// SMS-enabled device.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>application</code> protocol, the endpoint is the EndpointArn of
        /// a mobile app and device.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>lambda</code> protocol, the endpoint is the ARN of an Lambda
        /// function.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>firehose</code> protocol, the endpoint is the ARN of an Amazon
        /// Kinesis Data Firehose delivery stream.</p>
        /// </li>
        /// </ul>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint that you want to receive notifications. Endpoints vary by
        /// protocol:</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>http</code> protocol, the (public) endpoint is a URL beginning
        /// with <code>http://</code>.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>https</code> protocol, the (public) endpoint is a URL beginning
        /// with <code>https://</code>.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>email</code> protocol, the endpoint is an email address.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>email-json</code> protocol, the endpoint is an email
        /// address.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>sms</code> protocol, the endpoint is a phone number of an
        /// SMS-enabled device.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS
        /// queue.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>application</code> protocol, the endpoint is the EndpointArn of
        /// a mobile app and device.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>lambda</code> protocol, the endpoint is the ARN of an Lambda
        /// function.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>firehose</code> protocol, the endpoint is the ARN of an Amazon
        /// Kinesis Data Firehose delivery stream.</p>
        /// </li>
        /// </ul>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that the <code>Subscribe</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FilterPolicy</code> – The simple JSON object that lets your
        /// subscriber receive only a subset of messages, rather than receiving every
        /// message published to the topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RawMessageDelivery</code> – When set to <code>true</code>,
        /// enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the
        /// need for the endpoints to process JSON formatting, which is otherwise created
        /// for Amazon SNS metadata.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
        /// Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable)
        /// or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held
        /// in the dead-letter queue for further analysis or reprocessing.</p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p>
        /// <ul>
        /// <li>
        /// <p>Permission to write to the Kinesis Data Firehose delivery stream</p>
        /// </li>
        /// <li>
        /// <p>Amazon SNS listed as a trusted entity</p>
        /// </li>
        /// </ul>
        /// <p>Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions.
        /// For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout
        /// to Kinesis Data Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of attributes with their corresponding values.</p>
        /// <p>The following lists the names, descriptions, and values of the special request
        /// parameters that the <code>Subscribe</code> action uses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
        /// failed deliveries to HTTP/S endpoints.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FilterPolicy</code> – The simple JSON object that lets your
        /// subscriber receive only a subset of messages, rather than receiving every
        /// message published to the topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RawMessageDelivery</code> – When set to <code>true</code>,
        /// enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the
        /// need for the endpoints to process JSON formatting, which is otherwise created
        /// for Amazon SNS metadata.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
        /// Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable)
        /// or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held
        /// in the dead-letter queue for further analysis or reprocessing.</p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p>
        /// <ul>
        /// <li>
        /// <p>Permission to write to the Kinesis Data Firehose delivery stream</p>
        /// </li>
        /// <li>
        /// <p>Amazon SNS listed as a trusted entity</p>
        /// </li>
        /// </ul>
        /// <p>Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions.
        /// For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout
        /// to Kinesis Data Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Sets whether the response from the <code>Subscribe</code> request includes the
        /// subscription ARN, even if the subscription is not yet confirmed.</p>
        /// <p>If you set this parameter to <code>true</code>, the response includes the ARN in all
        /// cases, even if the subscription is not yet confirmed. In addition to the ARN for
        /// confirmed subscriptions, the response also includes the <code>pending
        /// subscription</code> ARN value for subscriptions that aren't yet confirmed. A
        /// subscription becomes confirmed when the subscriber calls the
        /// <code>ConfirmSubscription</code> action with a confirmation token.</p>
        /// <p></p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn return_subscription_arn(mut self, input: bool) -> Self {
            self.return_subscription_arn = Some(input);
            self
        }
        /// <p>Sets whether the response from the <code>Subscribe</code> request includes the
        /// subscription ARN, even if the subscription is not yet confirmed.</p>
        /// <p>If you set this parameter to <code>true</code>, the response includes the ARN in all
        /// cases, even if the subscription is not yet confirmed. In addition to the ARN for
        /// confirmed subscriptions, the response also includes the <code>pending
        /// subscription</code> ARN value for subscriptions that aren't yet confirmed. A
        /// subscription becomes confirmed when the subscriber calls the
        /// <code>ConfirmSubscription</code> action with a confirmation token.</p>
        /// <p></p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_return_subscription_arn(mut self, input: std::option::Option<bool>) -> Self {
            self.return_subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscribeInput`](crate::input::SubscribeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::SubscribeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::SubscribeInput {
                topic_arn: self.topic_arn,
                protocol: self.protocol,
                endpoint: self.endpoint,
                attributes: self.attributes,
                return_subscription_arn: self.return_subscription_arn.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SubscribeInputOperationOutputAlias = crate::operation::Subscribe;
#[doc(hidden)]
pub type SubscribeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubscribeInput {
    /// Consumes the builder and constructs an Operation<[`Subscribe`](crate::operation::Subscribe)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Subscribe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubscribeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubscribeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubscribeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_subscribe(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Subscribe::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "Subscribe",
                    "sns",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubscribeInput`](crate::input::SubscribeInput)
    pub fn builder() -> crate::input::subscribe_input::Builder {
        crate::input::subscribe_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the topic to which to add tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic to which to add tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to the specified topic. A tag consists of a required key and an
        /// optional value.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be added to the specified topic. A tag consists of a required key and an
        /// optional value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UnsubscribeInput`](crate::input::UnsubscribeInput)
pub mod unsubscribe_input {
    /// A builder for [`UnsubscribeInput`](crate::input::UnsubscribeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the subscription to be deleted.</p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the subscription to be deleted.</p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsubscribeInput`](crate::input::UnsubscribeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnsubscribeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnsubscribeInput {
                subscription_arn: self.subscription_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UnsubscribeInputOperationOutputAlias = crate::operation::Unsubscribe;
#[doc(hidden)]
pub type UnsubscribeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UnsubscribeInput {
    /// Consumes the builder and constructs an Operation<[`Unsubscribe`](crate::operation::Unsubscribe)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Unsubscribe,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnsubscribeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnsubscribeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnsubscribeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_unsubscribe(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::Unsubscribe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "Unsubscribe",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnsubscribeInput`](crate::input::UnsubscribeInput)
    pub fn builder() -> crate::input::unsubscribe_input::Builder {
        crate::input::unsubscribe_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the topic from which to remove tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the topic from which to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the specified topic.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove from the specified topic.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`VerifySmsSandboxPhoneNumberInput`](crate::input::VerifySmsSandboxPhoneNumberInput)
pub mod verify_sms_sandbox_phone_number_input {
    /// A builder for [`VerifySmsSandboxPhoneNumberInput`](crate::input::VerifySmsSandboxPhoneNumberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) one_time_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The destination phone number to verify.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The destination phone number to verify.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The OTP sent to the destination number from the
        /// <code>CreateSMSSandBoxPhoneNumber</code> call.</p>
        pub fn one_time_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.one_time_password = Some(input.into());
            self
        }
        /// <p>The OTP sent to the destination number from the
        /// <code>CreateSMSSandBoxPhoneNumber</code> call.</p>
        pub fn set_one_time_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.one_time_password = input;
            self
        }
        /// Consumes the builder and constructs a [`VerifySmsSandboxPhoneNumberInput`](crate::input::VerifySmsSandboxPhoneNumberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VerifySmsSandboxPhoneNumberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VerifySmsSandboxPhoneNumberInput {
                phone_number: self.phone_number,
                one_time_password: self.one_time_password,
            })
        }
    }
}
#[doc(hidden)]
pub type VerifySmsSandboxPhoneNumberInputOperationOutputAlias =
    crate::operation::VerifySMSSandboxPhoneNumber;
#[doc(hidden)]
pub type VerifySmsSandboxPhoneNumberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl VerifySmsSandboxPhoneNumberInput {
    /// Consumes the builder and constructs an Operation<[`VerifySMSSandboxPhoneNumber`](crate::operation::VerifySMSSandboxPhoneNumber)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VerifySMSSandboxPhoneNumber,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::VerifySmsSandboxPhoneNumberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::VerifySmsSandboxPhoneNumberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::VerifySmsSandboxPhoneNumberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_verify_sms_sandbox_phone_number(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VerifySMSSandboxPhoneNumber::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VerifySMSSandboxPhoneNumber",
            "sns",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`VerifySmsSandboxPhoneNumberInput`](crate::input::VerifySmsSandboxPhoneNumberInput)
    pub fn builder() -> crate::input::verify_sms_sandbox_phone_number_input::Builder {
        crate::input::verify_sms_sandbox_phone_number_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerifySmsSandboxPhoneNumberInput {
    /// <p>The destination phone number to verify.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The OTP sent to the destination number from the
    /// <code>CreateSMSSandBoxPhoneNumber</code> call.</p>
    pub one_time_password: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VerifySmsSandboxPhoneNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerifySmsSandboxPhoneNumberInput");
        formatter.field("phone_number", &self.phone_number);
        formatter.field("one_time_password", &self.one_time_password);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the topic from which to remove tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove from the specified topic.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Input for Unsubscribe action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsubscribeInput {
    /// <p>The ARN of the subscription to be deleted.</p>
    pub subscription_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsubscribeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsubscribeInput");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the topic to which to add tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to be added to the specified topic. A tag consists of a required key and an
    /// optional value.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Input for Subscribe action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscribeInput {
    /// <p>The ARN of the topic you want to subscribe to.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The protocol that you want to use. Supported protocols include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>http</code> – delivery of JSON-encoded message via HTTP
    /// POST</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>https</code> – delivery of JSON-encoded message via HTTPS
    /// POST</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>email</code> – delivery of message via SMTP</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>email-json</code> – delivery of JSON-encoded message via
    /// SMTP</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sms</code> – delivery of message via SMS</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sqs</code> – delivery of JSON-encoded message to an Amazon SQS
    /// queue</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application</code> – delivery of JSON-encoded message to an
    /// EndpointArn for a mobile app and device</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>lambda</code> – delivery of JSON-encoded message to an Lambda
    /// function</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>firehose</code> – delivery of JSON-encoded message to an Amazon
    /// Kinesis Data Firehose delivery stream.</p>
    /// </li>
    /// </ul>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The endpoint that you want to receive notifications. Endpoints vary by
    /// protocol:</p>
    /// <ul>
    /// <li>
    /// <p>For the <code>http</code> protocol, the (public) endpoint is a URL beginning
    /// with <code>http://</code>.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>https</code> protocol, the (public) endpoint is a URL beginning
    /// with <code>https://</code>.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>email</code> protocol, the endpoint is an email address.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>email-json</code> protocol, the endpoint is an email
    /// address.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>sms</code> protocol, the endpoint is a phone number of an
    /// SMS-enabled device.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>sqs</code> protocol, the endpoint is the ARN of an Amazon SQS
    /// queue.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>application</code> protocol, the endpoint is the EndpointArn of
    /// a mobile app and device.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>lambda</code> protocol, the endpoint is the ARN of an Lambda
    /// function.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>firehose</code> protocol, the endpoint is the ARN of an Amazon
    /// Kinesis Data Firehose delivery stream.</p>
    /// </li>
    /// </ul>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>A map of attributes with their corresponding values.</p>
    /// <p>The following lists the names, descriptions, and values of the special request
    /// parameters that the <code>Subscribe</code> action uses:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
    /// failed deliveries to HTTP/S endpoints.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FilterPolicy</code> – The simple JSON object that lets your
    /// subscriber receive only a subset of messages, rather than receiving every
    /// message published to the topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RawMessageDelivery</code> – When set to <code>true</code>,
    /// enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the
    /// need for the endpoints to process JSON formatting, which is otherwise created
    /// for Amazon SNS metadata.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
    /// Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable)
    /// or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held
    /// in the dead-letter queue for further analysis or reprocessing.</p>
    /// </li>
    /// </ul>
    ///
    ///
    /// <p>The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p>
    /// <ul>
    /// <li>
    /// <p>Permission to write to the Kinesis Data Firehose delivery stream</p>
    /// </li>
    /// <li>
    /// <p>Amazon SNS listed as a trusted entity</p>
    /// </li>
    /// </ul>
    /// <p>Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions.
    /// For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout
    /// to Kinesis Data Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p>
    /// </li>
    /// </ul>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Sets whether the response from the <code>Subscribe</code> request includes the
    /// subscription ARN, even if the subscription is not yet confirmed.</p>
    /// <p>If you set this parameter to <code>true</code>, the response includes the ARN in all
    /// cases, even if the subscription is not yet confirmed. In addition to the ARN for
    /// confirmed subscriptions, the response also includes the <code>pending
    /// subscription</code> ARN value for subscriptions that aren't yet confirmed. A
    /// subscription becomes confirmed when the subscriber calls the
    /// <code>ConfirmSubscription</code> action with a confirmation token.</p>
    /// <p></p>
    /// <p>The default value is <code>false</code>.</p>
    pub return_subscription_arn: bool,
}
impl std::fmt::Debug for SubscribeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscribeInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("protocol", &self.protocol);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("attributes", &self.attributes);
        formatter.field("return_subscription_arn", &self.return_subscription_arn);
        formatter.finish()
    }
}

/// <p>Input for SetTopicAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetTopicAttributesInput {
    /// <p>The ARN of the topic to modify.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>A map of attributes with their corresponding values.</p>
    /// <p>The following lists the names, descriptions, and values of the special request
    /// parameters that the <code>SetTopicAttributes</code> action uses:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
    /// failed deliveries to HTTP/S endpoints.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DisplayName</code> – The display name to use for a topic with SMS
    /// subscriptions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Policy</code> – The policy that defines who can access your
    /// topic. By default, only the topic owner can publish or subscribe to the
    /// topic.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master
    /// key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
    /// Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API
    /// Reference</i>. </p>
    /// </li>
    /// </ul>
    ///
    ///
    /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication for
    /// FIFO topics.</p>
    ///
    /// <ul>
    /// <li>
    /// <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>.
    /// If you create a FIFO topic and this attribute is <code>false</code>, you must
    /// specify a value for the <code>MessageDeduplicationId</code> parameter for the
    /// <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p>
    /// </li>
    /// <li>
    /// <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>,
    /// Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using
    /// the body of the message (but not the attributes of the message).</p>
    /// <p>(Optional) To override the generated value, you can specify a value
    /// for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code>
    /// action.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The new value for the attribute.</p>
    pub attribute_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SetTopicAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetTopicAttributesInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_value", &self.attribute_value);
        formatter.finish()
    }
}

/// <p>Input for SetSubscriptionAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSubscriptionAttributesInput {
    /// <p>The ARN of the subscription to modify.</p>
    pub subscription_arn: std::option::Option<std::string::String>,
    /// <p>A map of attributes with their corresponding values.</p>
    /// <p>The following lists the names, descriptions, and values of the special request
    /// parameters that this action uses:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
    /// failed deliveries to HTTP/S endpoints.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FilterPolicy</code> – The simple JSON object that lets your
    /// subscriber receive only a subset of messages, rather than receiving every
    /// message published to the topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RawMessageDelivery</code> – When set to <code>true</code>,
    /// enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the
    /// need for the endpoints to process JSON formatting, which is otherwise created
    /// for Amazon SNS metadata.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RedrivePolicy</code> – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue.
    /// Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable)
    /// or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held
    /// in the dead-letter queue for further analysis or reprocessing.</p>
    /// </li>
    /// </ul>
    ///
    ///
    /// <p>The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SubscriptionRoleArn</code> – The ARN of the IAM role that has the following:</p>
    /// <ul>
    /// <li>
    /// <p>Permission to write to the Kinesis Data Firehose delivery stream</p>
    /// </li>
    /// <li>
    /// <p>Amazon SNS listed as a trusted entity</p>
    /// </li>
    /// </ul>
    /// <p>Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions.
    /// For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html">Fanout
    /// to Kinesis Data Firehose delivery streams</a> in the <i>Amazon SNS Developer Guide</i>.</p>
    /// </li>
    /// </ul>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The new value for the attribute in JSON format.</p>
    pub attribute_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SetSubscriptionAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSubscriptionAttributesInput");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_value", &self.attribute_value);
        formatter.finish()
    }
}

/// <p>The input for the SetSMSAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSmsAttributesInput {
    /// <p>The default settings for sending SMS messages from your account. You can set values
    /// for the following attribute names:</p>
    /// <p>
    /// <code>MonthlySpendLimit</code> – The maximum amount in USD that you are willing to spend
    /// each month to send SMS messages. When Amazon SNS determines that sending an SMS message would
    /// incur a cost that exceeds this limit, it stops sending SMS messages within
    /// minutes.</p>
    /// <important>
    /// <p>Amazon SNS stops sending SMS messages within minutes of the limit being crossed. During
    /// that interval, if you continue to send SMS messages, you will incur costs that
    /// exceed your limit.</p>
    /// </important>
    /// <p>By default, the spend limit is set to the maximum allowed by Amazon SNS. If you want to
    /// raise the limit, submit an <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sns">SNS Limit Increase case</a>. For <b>New limit
    /// value</b>, enter your desired monthly spend limit. In the <b>Use Case Description</b> field, explain that you are requesting
    /// an SMS monthly spend limit increase.</p>
    /// <p>
    /// <code>DeliveryStatusIAMRole</code> – The ARN of the IAM role that allows Amazon SNS to write
    /// logs about SMS deliveries in CloudWatch Logs. For each SMS message that you send, Amazon SNS
    /// writes a log that includes the message price, the success or failure status, the reason
    /// for failure (if the message failed), the message dwell time, and other
    /// information.</p>
    /// <p>
    /// <code>DeliveryStatusSuccessSamplingRate</code> – The percentage of successful SMS
    /// deliveries for which Amazon SNS will write logs in CloudWatch Logs. The value can be an
    /// integer from 0 - 100. For example, to write logs only for failed deliveries, set this
    /// value to <code>0</code>. To write logs for 10% of your successful deliveries, set it to
    /// <code>10</code>.</p>
    /// <p>
    /// <code>DefaultSenderID</code> – A string, such as your business brand, that is displayed
    /// as the sender on the receiving device. Support for sender IDs varies by country. The
    /// sender ID can be 1 - 11 alphanumeric characters, and it must contain at least one
    /// letter.</p>
    /// <p>
    /// <code>DefaultSMSType</code> – The type of SMS message that you will send by default. You
    /// can assign the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Promotional</code> – (Default) Noncritical messages, such as marketing
    /// messages. Amazon SNS optimizes the message delivery to incur the lowest cost.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Transactional</code> – Critical messages that support customer
    /// transactions, such as one-time passcodes for multi-factor authentication. Amazon
    /// SNS optimizes the message delivery to achieve the highest reliability.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>UsageReportS3Bucket</code> – The name of the Amazon S3 bucket to receive daily SMS
    /// usage reports from Amazon SNS. Each day, Amazon SNS will deliver a usage report as a CSV file to
    /// the bucket. The report includes the following information for each SMS message that was
    /// successfully delivered by your account:</p>
    /// <ul>
    /// <li>
    /// <p>Time that the message was published (in UTC)</p>
    /// </li>
    /// <li>
    /// <p>Message ID</p>
    /// </li>
    /// <li>
    /// <p>Destination phone number</p>
    /// </li>
    /// <li>
    /// <p>Message type</p>
    /// </li>
    /// <li>
    /// <p>Delivery status</p>
    /// </li>
    /// <li>
    /// <p>Message price (in USD)</p>
    /// </li>
    /// <li>
    /// <p>Part number (a message is split into multiple parts if it is too long for a
    /// single message)</p>
    /// </li>
    /// <li>
    /// <p>Total number of parts</p>
    /// </li>
    /// </ul>
    /// <p>To receive the report, the bucket must have a policy that allows the Amazon SNS service
    /// principal to perform the <code>s3:PutObject</code> and <code>s3:GetBucketLocation</code>
    /// actions.</p>
    /// <p>For an example bucket policy and usage report, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sms_stats.html">Monitoring SMS Activity</a> in the
    /// <i>Amazon SNS Developer Guide</i>.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SetSmsAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSmsAttributesInput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

/// <p>Input for SetPlatformApplicationAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetPlatformApplicationAttributesInput {
    /// <p>PlatformApplicationArn for SetPlatformApplicationAttributes action.</p>
    pub platform_application_arn: std::option::Option<std::string::String>,
    /// <p>A map of the platform application attributes. Attributes in this map include the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlatformCredential</code> – The credential received from the
    /// notification service. For <code>APNS</code> and <code>APNS_SANDBOX</code>,
    /// <code>PlatformCredential</code> is <code>private key</code>. For
    /// <code>GCM</code> (Firebase Cloud Messaging), <code>PlatformCredential</code>
    /// is <code>API key</code>. For <code>ADM</code>, <code>PlatformCredential</code>
    /// is <code>client secret</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PlatformPrincipal</code> – The principal received from the
    /// notification service. For <code>APNS</code> and <code>APNS_SANDBOX</code>,
    /// <code>PlatformPrincipal</code> is <code>SSL certificate</code>. For
    /// <code>GCM</code> (Firebase Cloud Messaging), there is no
    /// <code>PlatformPrincipal</code>. For <code>ADM</code>,
    /// <code>PlatformPrincipal</code> is <code>client id</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EventEndpointCreated</code> – Topic ARN to which
    /// <code>EndpointCreated</code> event notifications are sent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EventEndpointDeleted</code> – Topic ARN to which
    /// <code>EndpointDeleted</code> event notifications are sent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EventEndpointUpdated</code> – Topic ARN to which
    /// <code>EndpointUpdate</code> event notifications are sent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EventDeliveryFailure</code> – Topic ARN to which
    /// <code>DeliveryFailure</code> event notifications are sent upon Direct
    /// Publish delivery failure (permanent) to one of the application's
    /// endpoints.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SuccessFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS
    /// write access to use CloudWatch Logs on your behalf.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FailureFeedbackRoleArn</code> – IAM role ARN used to give Amazon SNS
    /// write access to use CloudWatch Logs on your behalf.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SuccessFeedbackSampleRate</code> – Sample rate percentage (0-100)
    /// of successfully delivered messages.</p>
    /// </li>
    /// </ul>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SetPlatformApplicationAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetPlatformApplicationAttributesInput");
        formatter.field("platform_application_arn", &self.platform_application_arn);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

/// <p>Input for SetEndpointAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetEndpointAttributesInput {
    /// <p>EndpointArn used for SetEndpointAttributes action.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>A map of the endpoint attributes. Attributes in this map include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CustomUserData</code> – arbitrary user data to associate with the
    /// endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and
    /// less than 2KB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Enabled</code> – flag that enables/disables delivery to the
    /// endpoint. Amazon SNS will set this to false when a notification service indicates to
    /// Amazon SNS that the endpoint is invalid. Users can set it back to true, typically
    /// after updating Token.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Token</code> – device token, also referred to as a registration id,
    /// for an app and mobile device. This is returned from the notification service
    /// when an app and mobile device are registered with the notification
    /// service.</p>
    /// </li>
    /// </ul>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SetEndpointAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetEndpointAttributesInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

/// <p>Input for RemovePermission action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionInput {
    /// <p>The ARN of the topic whose access control policy you wish to modify.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The unique label of the statement you want to remove.</p>
    pub label: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemovePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("label", &self.label);
        formatter.finish()
    }
}

/// <p>Input for Publish action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishInput {
    /// <p>The topic you want to publish to.</p>
    /// <p>If you don't specify a value for the <code>TopicArn</code> parameter, you must specify
    /// a value for the <code>PhoneNumber</code> or <code>TargetArn</code> parameters.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>If you don't specify a value for the <code>TargetArn</code> parameter, you must
    /// specify a value for the <code>PhoneNumber</code> or <code>TopicArn</code>
    /// parameters.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The phone number to which you want to deliver an SMS message. Use E.164 format.</p>
    /// <p>If you don't specify a value for the <code>PhoneNumber</code> parameter, you must
    /// specify a value for the <code>TargetArn</code> or <code>TopicArn</code>
    /// parameters.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The message you want to send.</p>
    /// <p>If you are publishing to a topic and you want to send the same message to all
    /// transport protocols, include the text of the message as a String value. If you want to
    /// send different messages for each transport protocol, set the value of the
    /// <code>MessageStructure</code> parameter to <code>json</code> and use a JSON object
    /// for the <code>Message</code> parameter.
    /// </p>
    /// <p></p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>With the exception of SMS, messages must be UTF-8 encoded strings and at most
    /// 256 KB in size (262,144 bytes, not 262,144 characters).</p>
    /// </li>
    /// <li>
    /// <p>For SMS, each message can contain up to 140 characters. This character limit
    /// depends on the encoding schema. For example, an SMS message can contain 160 GSM
    /// characters, 140 ASCII characters, or 70 UCS-2 characters.</p>
    /// <p>If you publish a message that exceeds this size limit, Amazon SNS sends the message
    /// as multiple messages, each fitting within the size limit. Messages aren't
    /// truncated mid-word but are cut off at whole-word boundaries.</p>
    /// <p>The total size limit for a single SMS <code>Publish</code> action is 1,600
    /// characters.</p>
    /// </li>
    /// </ul>
    /// <p>JSON-specific constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Keys in the JSON object that correspond to supported transport protocols must
    /// have simple JSON string values.</p>
    /// </li>
    /// <li>
    /// <p>The values will be parsed (unescaped) before they are used in outgoing
    /// messages.</p>
    /// </li>
    /// <li>
    /// <p>Outbound notifications are JSON encoded (meaning that the characters will be
    /// reescaped for sending).</p>
    /// </li>
    /// <li>
    /// <p>Values have a minimum length of 0 (the empty string, "", is allowed).</p>
    /// </li>
    /// <li>
    /// <p>Values have a maximum length bounded by the overall message size (so,
    /// including multiple protocols may limit message sizes).</p>
    /// </li>
    /// <li>
    /// <p>Non-string values will cause the key to be ignored.</p>
    /// </li>
    /// <li>
    /// <p>Keys that do not correspond to supported transport protocols are
    /// ignored.</p>
    /// </li>
    /// <li>
    /// <p>Duplicate keys are not allowed.</p>
    /// </li>
    /// <li>
    /// <p>Failure to parse or validate any key or value in the message will cause the
    /// <code>Publish</code> call to return an error (no partial delivery).</p>
    /// </li>
    /// </ul>
    pub message: std::option::Option<std::string::String>,
    /// <p>Optional parameter to be used as the "Subject" line when the message is delivered to
    /// email endpoints. This field will also be included, if present, in the standard JSON
    /// messages delivered to other endpoints.</p>
    /// <p>Constraints: Subjects must be ASCII text that begins with a letter, number, or
    /// punctuation mark; must not include line breaks or control characters; and must be less
    /// than 100 characters long.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>Set <code>MessageStructure</code> to <code>json</code> if you want to send a different
    /// message for each protocol. For example, using one publish action, you can send a short
    /// message to your SMS subscribers and a longer message to your email subscribers. If you
    /// set <code>MessageStructure</code> to <code>json</code>, the value of the
    /// <code>Message</code> parameter must: </p>
    /// <ul>
    /// <li>
    /// <p>be a syntactically valid JSON object; and</p>
    /// </li>
    /// <li>
    /// <p>contain at least a top-level JSON key of "default" with a value that is a
    /// string.</p>
    /// </li>
    /// </ul>
    /// <p>You can define other top-level keys that define the message you want to send to a
    /// specific transport protocol (e.g., "http").</p>
    /// <p>Valid value: <code>json</code>
    /// </p>
    pub message_structure: std::option::Option<std::string::String>,
    /// <p>Message attributes for Publish action.</p>
    pub message_attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MessageAttributeValue>,
    >,
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics. The
    /// <code>MessageDeduplicationId</code> can contain up to 128 alphanumeric characters
    /// (a-z, A-Z, 0-9) and punctuation
    /// <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
    /// <p>Every message must have a unique <code>MessageDeduplicationId</code>, which is a token
    /// used for deduplication of sent messages. If a message with a particular
    /// <code>MessageDeduplicationId</code> is sent successfully, any message sent with the
    /// same <code>MessageDeduplicationId</code> during the 5-minute deduplication interval is
    /// treated as a duplicate. </p>
    /// <p>If the topic has <code>ContentBasedDeduplication</code> set, the system generates a
    /// <code>MessageDeduplicationId</code> based on the contents of the message. Your
    /// <code>MessageDeduplicationId</code> overrides the generated one.</p>
    pub message_deduplication_id: std::option::Option<std::string::String>,
    /// <p>This parameter applies only to FIFO (first-in-first-out) topics. The
    /// <code>MessageGroupId</code> can contain up to 128 alphanumeric characters (a-z, A-Z,
    /// 0-9) and punctuation <code>(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)</code>.</p>
    /// <p>The <code>MessageGroupId</code> is a tag that specifies that a message belongs to a
    /// specific message group. Messages that belong to the same message group are processed in
    /// a FIFO manner (however, messages in different message groups might be processed out of
    /// order). Every message must include a <code>MessageGroupId</code>.</p>
    pub message_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PublishInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("message", &self.message);
        formatter.field("subject", &self.subject);
        formatter.field("message_structure", &self.message_structure);
        formatter.field("message_attributes", &self.message_attributes);
        formatter.field("message_deduplication_id", &self.message_deduplication_id);
        formatter.field("message_group_id", &self.message_group_id);
        formatter.finish()
    }
}

/// <p>Input for the OptInPhoneNumber action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptInPhoneNumberInput {
    /// <p>The phone number to opt in. Use E.164 format.</p>
    pub phone_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptInPhoneNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptInPhoneNumberInput");
        formatter.field("phone_number", &self.phone_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTopicsInput {
    /// <p>Token returned by the previous <code>ListTopics</code> request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTopicsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTopicsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the topic for which to list tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p>Input for ListSubscriptionsByTopic action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSubscriptionsByTopicInput {
    /// <p>The ARN of the topic for which you wish to find subscriptions.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>Token returned by the previous <code>ListSubscriptionsByTopic</code> request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSubscriptionsByTopicInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSubscriptionsByTopicInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Input for ListSubscriptions action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSubscriptionsInput {
    /// <p>Token returned by the previous <code>ListSubscriptions</code> request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSubscriptionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSmsSandboxPhoneNumbersInput {
    /// <p>Token that the previous <code>ListSMSSandboxPhoneNumbersInput</code> request
    /// returns.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of phone numbers to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListSmsSandboxPhoneNumbersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSmsSandboxPhoneNumbersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input for ListPlatformApplications action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlatformApplicationsInput {
    /// <p>NextToken string is used when calling ListPlatformApplications action to retrieve
    /// additional records that are available after the first page results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPlatformApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlatformApplicationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>The input for the <code>ListPhoneNumbersOptedOut</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPhoneNumbersOptedOutInput {
    /// <p>A <code>NextToken</code> string is used when you call the
    /// <code>ListPhoneNumbersOptedOut</code> action to retrieve additional records that are
    /// available after the first page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListPhoneNumbersOptedOutInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPhoneNumbersOptedOutInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOriginationNumbersInput {
    /// <p>Token that the previous <code>ListOriginationNumbers</code> request returns.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of origination numbers to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListOriginationNumbersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOriginationNumbersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input for ListEndpointsByPlatformApplication action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEndpointsByPlatformApplicationInput {
    /// <p>PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.</p>
    pub platform_application_arn: std::option::Option<std::string::String>,
    /// <p>NextToken string is used when calling ListEndpointsByPlatformApplication action to
    /// retrieve additional records that are available after the first page results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListEndpointsByPlatformApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEndpointsByPlatformApplicationInput");
        formatter.field("platform_application_arn", &self.platform_application_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Input for GetTopicAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTopicAttributesInput {
    /// <p>The ARN of the topic whose properties you want to get.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTopicAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTopicAttributesInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}

/// <p>Input for GetSubscriptionAttributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSubscriptionAttributesInput {
    /// <p>The ARN of the subscription whose properties you want to get.</p>
    pub subscription_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSubscriptionAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSubscriptionAttributesInput");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSmsSandboxAccountStatusInput {}
impl std::fmt::Debug for GetSmsSandboxAccountStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSmsSandboxAccountStatusInput");
        formatter.finish()
    }
}

/// <p>The input for the <code>GetSMSAttributes</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSmsAttributesInput {
    /// <p>A list of the individual attribute names, such as <code>MonthlySpendLimit</code>, for
    /// which you want values.</p>
    /// <p>For all attribute names, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html">SetSMSAttributes</a>.</p>
    /// <p>If you don't use this parameter, Amazon SNS returns all SMS attributes.</p>
    pub attributes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for GetSmsAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSmsAttributesInput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

/// <p>Input for GetPlatformApplicationAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPlatformApplicationAttributesInput {
    /// <p>PlatformApplicationArn for GetPlatformApplicationAttributesInput.</p>
    pub platform_application_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPlatformApplicationAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPlatformApplicationAttributesInput");
        formatter.field("platform_application_arn", &self.platform_application_arn);
        formatter.finish()
    }
}

/// <p>Input for GetEndpointAttributes action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEndpointAttributesInput {
    /// <p>EndpointArn for GetEndpointAttributes input.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEndpointAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEndpointAttributesInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTopicInput {
    /// <p>The ARN of the topic you want to delete.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteTopicInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTopicInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSmsSandboxPhoneNumberInput {
    /// <p>The destination phone number to delete.</p>
    pub phone_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSmsSandboxPhoneNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSmsSandboxPhoneNumberInput");
        formatter.field("phone_number", &self.phone_number);
        formatter.finish()
    }
}

/// <p>Input for DeletePlatformApplication action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePlatformApplicationInput {
    /// <p>PlatformApplicationArn of platform application object to delete.</p>
    pub platform_application_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeletePlatformApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePlatformApplicationInput");
        formatter.field("platform_application_arn", &self.platform_application_arn);
        formatter.finish()
    }
}

/// <p>Input for DeleteEndpoint action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEndpointInput {
    /// <p>EndpointArn of endpoint to delete.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEndpointInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

/// <p>Input for CreateTopic action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTopicInput {
    /// <p>The name of the topic you want to create.</p>
    /// <p>Constraints: Topic names must be made up of only uppercase and lowercase ASCII
    /// letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters
    /// long.</p>
    /// <p>For a FIFO (first-in-first-out) topic, the name must end with the <code>.fifo</code>
    /// suffix. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A map of attributes with their corresponding values.</p>
    /// <p>The following lists the names, descriptions, and values of the special request
    /// parameters that the <code>CreateTopic</code> action uses:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeliveryPolicy</code> – The policy that defines how Amazon SNS retries
    /// failed deliveries to HTTP/S endpoints.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DisplayName</code> – The display name to use for a topic with SMS
    /// subscriptions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FifoTopic</code> – Set to true to create a FIFO topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Policy</code> – The policy that defines who can access your
    /// topic. By default, only the topic owner can publish or subscribe to the
    /// topic.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>The following attribute applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side
    /// encryption</a>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KmsMasterKeyId</code> – The ID of an Amazon Web Services managed customer master
    /// key (CMK) for Amazon SNS or a custom CMK. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key
    /// Terms</a>. For more examples, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">KeyId</a> in the <i>Key Management Service API
    /// Reference</i>. </p>
    /// </li>
    /// </ul>
    ///
    ///
    /// <p>The following attributes apply only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html">FIFO topics</a>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FifoTopic</code> – When this is set to <code>true</code>, a FIFO
    /// topic is created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ContentBasedDeduplication</code> – Enables content-based deduplication for
    /// FIFO topics.</p>
    ///
    /// <ul>
    /// <li>
    /// <p>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code>.
    /// If you create a FIFO topic and this attribute is <code>false</code>, you must
    /// specify a value for the <code>MessageDeduplicationId</code> parameter for the
    /// <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action. </p>
    /// </li>
    /// <li>
    /// <p>When you set <code>ContentBasedDeduplication</code> to <code>true</code>,
    /// Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using
    /// the body of the message (but not the attributes of the message).</p>
    /// <p>(Optional) To override the generated value, you can specify a value
    /// for the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code>
    /// action.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The list of tags to add to a new topic.</p>
    /// <note>
    /// <p>To be able to tag a topic on creation, you must have the
    /// <code>sns:CreateTopic</code> and <code>sns:TagResource</code>
    /// permissions.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateTopicInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTopicInput");
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSmsSandboxPhoneNumberInput {
    /// <p>The destination phone number to verify. On verification, Amazon SNS adds this phone number
    /// to the list of verified phone numbers that you can send SMS messages to.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The language to use for sending the OTP. The default value is
    /// <code>en-US</code>.</p>
    pub language_code: std::option::Option<crate::model::LanguageCodeString>,
}
impl std::fmt::Debug for CreateSmsSandboxPhoneNumberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSmsSandboxPhoneNumberInput");
        formatter.field("phone_number", &self.phone_number);
        formatter.field("language_code", &self.language_code);
        formatter.finish()
    }
}

/// <p>Input for CreatePlatformEndpoint action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlatformEndpointInput {
    /// <p>PlatformApplicationArn returned from CreatePlatformApplication is used to create a an
    /// endpoint.</p>
    pub platform_application_arn: std::option::Option<std::string::String>,
    /// <p>Unique identifier created by the notification service for an app on a device. The
    /// specific name for Token will vary, depending on which notification service is being
    /// used. For example, when using APNS as the notification service, you need the device
    /// token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token
    /// equivalent is called the registration ID.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The
    /// data must be in UTF-8 format and less than 2KB.</p>
    pub custom_user_data: std::option::Option<std::string::String>,
    /// <p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html">SetEndpointAttributes</a>.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreatePlatformEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlatformEndpointInput");
        formatter.field("platform_application_arn", &self.platform_application_arn);
        formatter.field("token", &self.token);
        formatter.field("custom_user_data", &self.custom_user_data);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

/// <p>Input for CreatePlatformApplication action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlatformApplicationInput {
    /// <p>Application names must be made up of only uppercase and lowercase ASCII letters,
    /// numbers, underscores, hyphens, and periods, and must be between 1 and 256 characters
    /// long.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push
    /// Notification Service), APNS_SANDBOX, and GCM (Firebase Cloud Messaging).</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>For a list of attributes, see <a href="https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html">SetPlatformApplicationAttributes</a>.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreatePlatformApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlatformApplicationInput");
        formatter.field("name", &self.name);
        formatter.field("platform", &self.platform);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

/// <p>Input for ConfirmSubscription action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfirmSubscriptionInput {
    /// <p>The ARN of the topic for which you wish to confirm a subscription.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>Short-lived token sent to an endpoint during the <code>Subscribe</code> action.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>Disallows unauthenticated unsubscribes of the subscription. If the value of this
    /// parameter is <code>true</code> and the request has an Amazon Web Services signature, then only the topic
    /// owner and the subscription owner can unsubscribe the endpoint. The unsubscribe action
    /// requires Amazon Web Services authentication. </p>
    pub authenticate_on_unsubscribe: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfirmSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfirmSubscriptionInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("token", &self.token);
        formatter.field(
            "authenticate_on_unsubscribe",
            &self.authenticate_on_unsubscribe,
        );
        formatter.finish()
    }
}

/// <p>The input for the <code>CheckIfPhoneNumberIsOptedOut</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckIfPhoneNumberIsOptedOutInput {
    /// <p>The phone number for which you want to check the opt out status.</p>
    pub phone_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CheckIfPhoneNumberIsOptedOutInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckIfPhoneNumberIsOptedOutInput");
        formatter.field("phone_number", &self.phone_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddPermissionInput {
    /// <p>The ARN of the topic whose access control policy you wish to modify.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the new policy statement.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The account IDs of the users (principals) who will be given access to the
    /// specified actions. The users must have account, but do not need to be signed up for
    /// this service.</p>
    pub aws_account_id: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The action you want to allow for the specified principal(s).</p>
    /// <p>Valid values: Any Amazon SNS action name, for example <code>Publish</code>.</p>
    pub action_name: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for AddPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddPermissionInput");
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("label", &self.label);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("action_name", &self.action_name);
        formatter.finish()
    }
}
