// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddPermissionError {
    /// Kind of error that occurred.
    pub kind: AddPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddPermissionErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddPermissionErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddPermissionError {
    fn code(&self) -> Option<&str> {
        AddPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddPermissionError {
    /// Creates a new `AddPermissionError`.
    pub fn new(kind: AddPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddPermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddPermissionErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `AddPermissionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `AddPermissionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `AddPermissionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, AddPermissionErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for AddPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddPermissionErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            AddPermissionErrorKind::InternalErrorException(_inner) => Some(_inner),
            AddPermissionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AddPermissionErrorKind::NotFoundException(_inner) => Some(_inner),
            AddPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckIfPhoneNumberIsOptedOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckIfPhoneNumberIsOptedOutError {
    /// Kind of error that occurred.
    pub kind: CheckIfPhoneNumberIsOptedOutErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckIfPhoneNumberIsOptedOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckIfPhoneNumberIsOptedOutErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckIfPhoneNumberIsOptedOutError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckIfPhoneNumberIsOptedOutErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            CheckIfPhoneNumberIsOptedOutErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CheckIfPhoneNumberIsOptedOutErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            CheckIfPhoneNumberIsOptedOutErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            CheckIfPhoneNumberIsOptedOutErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckIfPhoneNumberIsOptedOutError {
    fn code(&self) -> Option<&str> {
        CheckIfPhoneNumberIsOptedOutError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckIfPhoneNumberIsOptedOutError {
    /// Creates a new `CheckIfPhoneNumberIsOptedOutError`.
    pub fn new(kind: CheckIfPhoneNumberIsOptedOutErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckIfPhoneNumberIsOptedOutError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckIfPhoneNumberIsOptedOutErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckIfPhoneNumberIsOptedOutError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckIfPhoneNumberIsOptedOutErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CheckIfPhoneNumberIsOptedOutErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckIfPhoneNumberIsOptedOutErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `CheckIfPhoneNumberIsOptedOutErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckIfPhoneNumberIsOptedOutErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `CheckIfPhoneNumberIsOptedOutErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckIfPhoneNumberIsOptedOutErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `CheckIfPhoneNumberIsOptedOutErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckIfPhoneNumberIsOptedOutErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for CheckIfPhoneNumberIsOptedOutError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckIfPhoneNumberIsOptedOutErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            CheckIfPhoneNumberIsOptedOutErrorKind::InternalErrorException(_inner) => Some(_inner),
            CheckIfPhoneNumberIsOptedOutErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            CheckIfPhoneNumberIsOptedOutErrorKind::ThrottledException(_inner) => Some(_inner),
            CheckIfPhoneNumberIsOptedOutErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ConfirmSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ConfirmSubscriptionError {
    /// Kind of error that occurred.
    pub kind: ConfirmSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ConfirmSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ConfirmSubscriptionErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates that the number of filter polices in your account exceeds the limit. To
    /// add more filter polices, submit an SNS Limit Increase case in the Amazon Web Services Support
    /// Center.</p>
    FilterPolicyLimitExceededException(crate::error::FilterPolicyLimitExceededException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Indicates that the customer already owns the maximum allowed number of
    /// subscriptions.</p>
    SubscriptionLimitExceededException(crate::error::SubscriptionLimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ConfirmSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ConfirmSubscriptionErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ConfirmSubscriptionErrorKind::FilterPolicyLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmSubscriptionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ConfirmSubscriptionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ConfirmSubscriptionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ConfirmSubscriptionErrorKind::SubscriptionLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ConfirmSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ConfirmSubscriptionError {
    fn code(&self) -> Option<&str> {
        ConfirmSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ConfirmSubscriptionError {
    /// Creates a new `ConfirmSubscriptionError`.
    pub fn new(kind: ConfirmSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ConfirmSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ConfirmSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ConfirmSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ConfirmSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ConfirmSubscriptionErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSubscriptionErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmSubscriptionErrorKind::FilterPolicyLimitExceededException`.
    pub fn is_filter_policy_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSubscriptionErrorKind::FilterPolicyLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmSubscriptionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSubscriptionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmSubscriptionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSubscriptionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmSubscriptionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSubscriptionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ConfirmSubscriptionErrorKind::SubscriptionLimitExceededException`.
    pub fn is_subscription_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ConfirmSubscriptionErrorKind::SubscriptionLimitExceededException(_)
        )
    }
}
impl std::error::Error for ConfirmSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ConfirmSubscriptionErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ConfirmSubscriptionErrorKind::FilterPolicyLimitExceededException(_inner) => {
                Some(_inner)
            }
            ConfirmSubscriptionErrorKind::InternalErrorException(_inner) => Some(_inner),
            ConfirmSubscriptionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ConfirmSubscriptionErrorKind::NotFoundException(_inner) => Some(_inner),
            ConfirmSubscriptionErrorKind::SubscriptionLimitExceededException(_inner) => {
                Some(_inner)
            }
            ConfirmSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePlatformApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePlatformApplicationError {
    /// Kind of error that occurred.
    pub kind: CreatePlatformApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePlatformApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePlatformApplicationErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePlatformApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePlatformApplicationErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreatePlatformApplicationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreatePlatformApplicationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreatePlatformApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePlatformApplicationError {
    fn code(&self) -> Option<&str> {
        CreatePlatformApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePlatformApplicationError {
    /// Creates a new `CreatePlatformApplicationError`.
    pub fn new(kind: CreatePlatformApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePlatformApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePlatformApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePlatformApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePlatformApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePlatformApplicationErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformApplicationErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreatePlatformApplicationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformApplicationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreatePlatformApplicationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformApplicationErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for CreatePlatformApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePlatformApplicationErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            CreatePlatformApplicationErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreatePlatformApplicationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreatePlatformApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePlatformEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePlatformEndpointError {
    /// Kind of error that occurred.
    pub kind: CreatePlatformEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePlatformEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePlatformEndpointErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePlatformEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePlatformEndpointErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            CreatePlatformEndpointErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreatePlatformEndpointErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreatePlatformEndpointErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreatePlatformEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePlatformEndpointError {
    fn code(&self) -> Option<&str> {
        CreatePlatformEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePlatformEndpointError {
    /// Creates a new `CreatePlatformEndpointError`.
    pub fn new(kind: CreatePlatformEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePlatformEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePlatformEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePlatformEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePlatformEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePlatformEndpointErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformEndpointErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreatePlatformEndpointErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformEndpointErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreatePlatformEndpointErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformEndpointErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `CreatePlatformEndpointErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePlatformEndpointErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for CreatePlatformEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePlatformEndpointErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            CreatePlatformEndpointErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreatePlatformEndpointErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreatePlatformEndpointErrorKind::NotFoundException(_inner) => Some(_inner),
            CreatePlatformEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSMSSandboxPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSMSSandboxPhoneNumberError {
    /// Kind of error that occurred.
    pub kind: CreateSMSSandboxPhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSMSSandboxPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSMSSandboxPhoneNumberErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the specified phone number opted out of receiving SMS messages from
    /// your account. You can't send SMS messages to phone numbers that opt out.</p>
    OptedOutException(crate::error::OptedOutException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    UserErrorException(crate::error::UserErrorException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSMSSandboxPhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateSMSSandboxPhoneNumberErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateSMSSandboxPhoneNumberErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            CreateSMSSandboxPhoneNumberErrorKind::OptedOutException(_inner) => _inner.fmt(f),
            CreateSMSSandboxPhoneNumberErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            CreateSMSSandboxPhoneNumberErrorKind::UserErrorException(_inner) => _inner.fmt(f),
            CreateSMSSandboxPhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSMSSandboxPhoneNumberError {
    fn code(&self) -> Option<&str> {
        CreateSMSSandboxPhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSMSSandboxPhoneNumberError {
    /// Creates a new `CreateSMSSandboxPhoneNumberError`.
    pub fn new(kind: CreateSMSSandboxPhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSMSSandboxPhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSMSSandboxPhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSMSSandboxPhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSMSSandboxPhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateSMSSandboxPhoneNumberErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMSSandboxPhoneNumberErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateSMSSandboxPhoneNumberErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMSSandboxPhoneNumberErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `CreateSMSSandboxPhoneNumberErrorKind::OptedOutException`.
    pub fn is_opted_out_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMSSandboxPhoneNumberErrorKind::OptedOutException(_)
        )
    }
    /// Returns true if the error kind is `CreateSMSSandboxPhoneNumberErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMSSandboxPhoneNumberErrorKind::ThrottledException(_)
        )
    }
    /// Returns true if the error kind is `CreateSMSSandboxPhoneNumberErrorKind::UserErrorException`.
    pub fn is_user_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSMSSandboxPhoneNumberErrorKind::UserErrorException(_)
        )
    }
}
impl std::error::Error for CreateSMSSandboxPhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            CreateSMSSandboxPhoneNumberErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateSMSSandboxPhoneNumberErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateSMSSandboxPhoneNumberErrorKind::OptedOutException(_inner) => Some(_inner),
            CreateSMSSandboxPhoneNumberErrorKind::ThrottledException(_inner) => Some(_inner),
            CreateSMSSandboxPhoneNumberErrorKind::UserErrorException(_inner) => Some(_inner),
            CreateSMSSandboxPhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTopicError {
    /// Kind of error that occurred.
    pub kind: CreateTopicErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTopicErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
    /// sequentially.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
    /// request using Signature Version 4.</p>
    InvalidSecurityException(crate::error::InvalidSecurityException),
    /// <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
    /// short while and then retry the operation.</p>
    StaleTagException(crate::error::StaleTagException),
    /// <p>Can't add more than 50 tags to a topic.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>The request doesn't comply with the IAM tag policy. Correct your request and then
    /// retry it.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>Indicates that the customer already owns the maximum allowed number of topics.</p>
    TopicLimitExceededException(crate::error::TopicLimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTopicError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTopicErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::ConcurrentAccessException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::InvalidSecurityException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::StaleTagException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::TagLimitExceededException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::TopicLimitExceededException(_inner) => _inner.fmt(f),
            CreateTopicErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTopicError {
    fn code(&self) -> Option<&str> {
        CreateTopicError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTopicError {
    /// Creates a new `CreateTopicError`.
    pub fn new(kind: CreateTopicErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTopicError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTopicErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTopicError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTopicErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::ConcurrentAccessException`.
    pub fn is_concurrent_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicErrorKind::ConcurrentAccessException(_)
        )
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, CreateTopicErrorKind::InternalErrorException(_))
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::InvalidSecurityException`.
    pub fn is_invalid_security_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicErrorKind::InvalidSecurityException(_)
        )
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::StaleTagException`.
    pub fn is_stale_tag_exception(&self) -> bool {
        matches!(&self.kind, CreateTopicErrorKind::StaleTagException(_))
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::TagLimitExceededException`.
    pub fn is_tag_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicErrorKind::TagLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, CreateTopicErrorKind::TagPolicyException(_))
    }
    /// Returns true if the error kind is `CreateTopicErrorKind::TopicLimitExceededException`.
    pub fn is_topic_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTopicErrorKind::TopicLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateTopicError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTopicErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            CreateTopicErrorKind::ConcurrentAccessException(_inner) => Some(_inner),
            CreateTopicErrorKind::InternalErrorException(_inner) => Some(_inner),
            CreateTopicErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateTopicErrorKind::InvalidSecurityException(_inner) => Some(_inner),
            CreateTopicErrorKind::StaleTagException(_inner) => Some(_inner),
            CreateTopicErrorKind::TagLimitExceededException(_inner) => Some(_inner),
            CreateTopicErrorKind::TagPolicyException(_inner) => Some(_inner),
            CreateTopicErrorKind::TopicLimitExceededException(_inner) => Some(_inner),
            CreateTopicErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEndpointErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEndpointErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEndpointError {
    /// Creates a new `DeleteEndpointError`.
    pub fn new(kind: DeleteEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteEndpointErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEndpointErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteEndpointErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for DeleteEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEndpointErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePlatformApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePlatformApplicationError {
    /// Kind of error that occurred.
    pub kind: DeletePlatformApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePlatformApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePlatformApplicationErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePlatformApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePlatformApplicationErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeletePlatformApplicationErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeletePlatformApplicationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeletePlatformApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePlatformApplicationError {
    fn code(&self) -> Option<&str> {
        DeletePlatformApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePlatformApplicationError {
    /// Creates a new `DeletePlatformApplicationError`.
    pub fn new(kind: DeletePlatformApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePlatformApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePlatformApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePlatformApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePlatformApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePlatformApplicationErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlatformApplicationErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeletePlatformApplicationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlatformApplicationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeletePlatformApplicationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePlatformApplicationErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for DeletePlatformApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePlatformApplicationErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            DeletePlatformApplicationErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeletePlatformApplicationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeletePlatformApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSMSSandboxPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSMSSandboxPhoneNumberError {
    /// Kind of error that occurred.
    pub kind: DeleteSMSSandboxPhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSMSSandboxPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSMSSandboxPhoneNumberErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Can’t perform the action on the specified resource. Make sure that the resource
    /// exists.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    UserErrorException(crate::error::UserErrorException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSMSSandboxPhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSMSSandboxPhoneNumberErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteSMSSandboxPhoneNumberErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSMSSandboxPhoneNumberErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            DeleteSMSSandboxPhoneNumberErrorKind::UserErrorException(_inner) => _inner.fmt(f),
            DeleteSMSSandboxPhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSMSSandboxPhoneNumberError {
    fn code(&self) -> Option<&str> {
        DeleteSMSSandboxPhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSMSSandboxPhoneNumberError {
    /// Creates a new `DeleteSMSSandboxPhoneNumberError`.
    pub fn new(kind: DeleteSMSSandboxPhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSMSSandboxPhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSMSSandboxPhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSMSSandboxPhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSMSSandboxPhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSMSSandboxPhoneNumberErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSMSSandboxPhoneNumberErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSMSSandboxPhoneNumberErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSMSSandboxPhoneNumberErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSMSSandboxPhoneNumberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSMSSandboxPhoneNumberErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSMSSandboxPhoneNumberErrorKind::ThrottledException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSMSSandboxPhoneNumberErrorKind::UserErrorException`.
    pub fn is_user_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSMSSandboxPhoneNumberErrorKind::UserErrorException(_)
        )
    }
}
impl std::error::Error for DeleteSMSSandboxPhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            DeleteSMSSandboxPhoneNumberErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteSMSSandboxPhoneNumberErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteSMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSMSSandboxPhoneNumberErrorKind::ThrottledException(_inner) => Some(_inner),
            DeleteSMSSandboxPhoneNumberErrorKind::UserErrorException(_inner) => Some(_inner),
            DeleteSMSSandboxPhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTopicError {
    /// Kind of error that occurred.
    pub kind: DeleteTopicErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTopicErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
    /// sequentially.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
    /// short while and then retry the operation.</p>
    StaleTagException(crate::error::StaleTagException),
    /// <p>The request doesn't comply with the IAM tag policy. Correct your request and then
    /// retry it.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTopicError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTopicErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            DeleteTopicErrorKind::ConcurrentAccessException(_inner) => _inner.fmt(f),
            DeleteTopicErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            DeleteTopicErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteTopicErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteTopicErrorKind::StaleTagException(_inner) => _inner.fmt(f),
            DeleteTopicErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            DeleteTopicErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTopicError {
    fn code(&self) -> Option<&str> {
        DeleteTopicError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTopicError {
    /// Creates a new `DeleteTopicError`.
    pub fn new(kind: DeleteTopicErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTopicError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTopicErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTopicError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTopicErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTopicErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTopicErrorKind::ConcurrentAccessException`.
    pub fn is_concurrent_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicErrorKind::ConcurrentAccessException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTopicErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, DeleteTopicErrorKind::InternalErrorException(_))
    }
    /// Returns true if the error kind is `DeleteTopicErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTopicErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTopicErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteTopicErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteTopicErrorKind::StaleTagException`.
    pub fn is_stale_tag_exception(&self) -> bool {
        matches!(&self.kind, DeleteTopicErrorKind::StaleTagException(_))
    }
    /// Returns true if the error kind is `DeleteTopicErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, DeleteTopicErrorKind::TagPolicyException(_))
    }
}
impl std::error::Error for DeleteTopicError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTopicErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            DeleteTopicErrorKind::ConcurrentAccessException(_inner) => Some(_inner),
            DeleteTopicErrorKind::InternalErrorException(_inner) => Some(_inner),
            DeleteTopicErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteTopicErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteTopicErrorKind::StaleTagException(_inner) => Some(_inner),
            DeleteTopicErrorKind::TagPolicyException(_inner) => Some(_inner),
            DeleteTopicErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEndpointAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEndpointAttributesError {
    /// Kind of error that occurred.
    pub kind: GetEndpointAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEndpointAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEndpointAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEndpointAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEndpointAttributesErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            GetEndpointAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetEndpointAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetEndpointAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetEndpointAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEndpointAttributesError {
    fn code(&self) -> Option<&str> {
        GetEndpointAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEndpointAttributesError {
    /// Creates a new `GetEndpointAttributesError`.
    pub fn new(kind: GetEndpointAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEndpointAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEndpointAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEndpointAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEndpointAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetEndpointAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetEndpointAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetEndpointAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetEndpointAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEndpointAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetEndpointAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEndpointAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            GetEndpointAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetEndpointAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetEndpointAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetEndpointAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPlatformApplicationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPlatformApplicationAttributesError {
    /// Kind of error that occurred.
    pub kind: GetPlatformApplicationAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPlatformApplicationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPlatformApplicationAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPlatformApplicationAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetPlatformApplicationAttributesErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetPlatformApplicationAttributesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetPlatformApplicationAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetPlatformApplicationAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPlatformApplicationAttributesError {
    fn code(&self) -> Option<&str> {
        GetPlatformApplicationAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPlatformApplicationAttributesError {
    /// Creates a new `GetPlatformApplicationAttributesError`.
    pub fn new(
        kind: GetPlatformApplicationAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPlatformApplicationAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPlatformApplicationAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPlatformApplicationAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPlatformApplicationAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetPlatformApplicationAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetPlatformApplicationAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlatformApplicationAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetPlatformApplicationAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlatformApplicationAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetPlatformApplicationAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPlatformApplicationAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetPlatformApplicationAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            GetPlatformApplicationAttributesErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            GetPlatformApplicationAttributesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetPlatformApplicationAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetPlatformApplicationAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSMSAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSMSAttributesError {
    /// Kind of error that occurred.
    pub kind: GetSMSAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSMSAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSMSAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSMSAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSMSAttributesErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            GetSMSAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetSMSAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetSMSAttributesErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetSMSAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSMSAttributesError {
    fn code(&self) -> Option<&str> {
        GetSMSAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSMSAttributesError {
    /// Creates a new `GetSMSAttributesError`.
    pub fn new(kind: GetSMSAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSMSAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSMSAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSMSAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSMSAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSMSAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSMSAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetSMSAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSMSAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetSMSAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSMSAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetSMSAttributesErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, GetSMSAttributesErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for GetSMSAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSMSAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            GetSMSAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetSMSAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetSMSAttributesErrorKind::ThrottledException(_inner) => Some(_inner),
            GetSMSAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSMSSandboxAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSMSSandboxAccountStatusError {
    /// Kind of error that occurred.
    pub kind: GetSMSSandboxAccountStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSMSSandboxAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSMSSandboxAccountStatusErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSMSSandboxAccountStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSMSSandboxAccountStatusErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetSMSSandboxAccountStatusErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetSMSSandboxAccountStatusErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            GetSMSSandboxAccountStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSMSSandboxAccountStatusError {
    fn code(&self) -> Option<&str> {
        GetSMSSandboxAccountStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSMSSandboxAccountStatusError {
    /// Creates a new `GetSMSSandboxAccountStatusError`.
    pub fn new(kind: GetSMSSandboxAccountStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSMSSandboxAccountStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSMSSandboxAccountStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSMSSandboxAccountStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSMSSandboxAccountStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSMSSandboxAccountStatusErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSMSSandboxAccountStatusErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetSMSSandboxAccountStatusErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSMSSandboxAccountStatusErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetSMSSandboxAccountStatusErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSMSSandboxAccountStatusErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for GetSMSSandboxAccountStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSMSSandboxAccountStatusErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            GetSMSSandboxAccountStatusErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetSMSSandboxAccountStatusErrorKind::ThrottledException(_inner) => Some(_inner),
            GetSMSSandboxAccountStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSubscriptionAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSubscriptionAttributesError {
    /// Kind of error that occurred.
    pub kind: GetSubscriptionAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSubscriptionAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSubscriptionAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSubscriptionAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSubscriptionAttributesErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetSubscriptionAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetSubscriptionAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetSubscriptionAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSubscriptionAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSubscriptionAttributesError {
    fn code(&self) -> Option<&str> {
        GetSubscriptionAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSubscriptionAttributesError {
    /// Creates a new `GetSubscriptionAttributesError`.
    pub fn new(kind: GetSubscriptionAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSubscriptionAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSubscriptionAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSubscriptionAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSubscriptionAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSubscriptionAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSubscriptionAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetSubscriptionAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSubscriptionAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetSubscriptionAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSubscriptionAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetSubscriptionAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSubscriptionAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetSubscriptionAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSubscriptionAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            GetSubscriptionAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetSubscriptionAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetSubscriptionAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSubscriptionAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTopicAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTopicAttributesError {
    /// Kind of error that occurred.
    pub kind: GetTopicAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTopicAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTopicAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
    /// request using Signature Version 4.</p>
    InvalidSecurityException(crate::error::InvalidSecurityException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTopicAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTopicAttributesErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            GetTopicAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            GetTopicAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetTopicAttributesErrorKind::InvalidSecurityException(_inner) => _inner.fmt(f),
            GetTopicAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTopicAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTopicAttributesError {
    fn code(&self) -> Option<&str> {
        GetTopicAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTopicAttributesError {
    /// Creates a new `GetTopicAttributesError`.
    pub fn new(kind: GetTopicAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTopicAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTopicAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTopicAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTopicAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTopicAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetTopicAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetTopicAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `GetTopicAttributesErrorKind::InvalidSecurityException`.
    pub fn is_invalid_security_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicAttributesErrorKind::InvalidSecurityException(_)
        )
    }
    /// Returns true if the error kind is `GetTopicAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTopicAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetTopicAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTopicAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            GetTopicAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            GetTopicAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetTopicAttributesErrorKind::InvalidSecurityException(_inner) => Some(_inner),
            GetTopicAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTopicAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEndpointsByPlatformApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEndpointsByPlatformApplicationError {
    /// Kind of error that occurred.
    pub kind: ListEndpointsByPlatformApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEndpointsByPlatformApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEndpointsByPlatformApplicationErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEndpointsByPlatformApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEndpointsByPlatformApplicationErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListEndpointsByPlatformApplicationErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListEndpointsByPlatformApplicationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListEndpointsByPlatformApplicationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListEndpointsByPlatformApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEndpointsByPlatformApplicationError {
    fn code(&self) -> Option<&str> {
        ListEndpointsByPlatformApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEndpointsByPlatformApplicationError {
    /// Creates a new `ListEndpointsByPlatformApplicationError`.
    pub fn new(
        kind: ListEndpointsByPlatformApplicationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEndpointsByPlatformApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEndpointsByPlatformApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEndpointsByPlatformApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEndpointsByPlatformApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListEndpointsByPlatformApplicationErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointsByPlatformApplicationErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListEndpointsByPlatformApplicationErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointsByPlatformApplicationErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListEndpointsByPlatformApplicationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointsByPlatformApplicationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ListEndpointsByPlatformApplicationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEndpointsByPlatformApplicationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListEndpointsByPlatformApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEndpointsByPlatformApplicationErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            ListEndpointsByPlatformApplicationErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            ListEndpointsByPlatformApplicationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListEndpointsByPlatformApplicationErrorKind::NotFoundException(_inner) => Some(_inner),
            ListEndpointsByPlatformApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOriginationNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOriginationNumbersError {
    /// Kind of error that occurred.
    pub kind: ListOriginationNumbersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOriginationNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOriginationNumbersErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// <p>Indicates that a parameter in the request is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOriginationNumbersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOriginationNumbersErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ListOriginationNumbersErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListOriginationNumbersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListOriginationNumbersErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            ListOriginationNumbersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListOriginationNumbersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOriginationNumbersError {
    fn code(&self) -> Option<&str> {
        ListOriginationNumbersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOriginationNumbersError {
    /// Creates a new `ListOriginationNumbersError`.
    pub fn new(kind: ListOriginationNumbersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOriginationNumbersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOriginationNumbersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOriginationNumbersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOriginationNumbersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListOriginationNumbersErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginationNumbersErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListOriginationNumbersErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginationNumbersErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListOriginationNumbersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginationNumbersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ListOriginationNumbersErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginationNumbersErrorKind::ThrottledException(_)
        )
    }
    /// Returns true if the error kind is `ListOriginationNumbersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOriginationNumbersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListOriginationNumbersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOriginationNumbersErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ListOriginationNumbersErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListOriginationNumbersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListOriginationNumbersErrorKind::ThrottledException(_inner) => Some(_inner),
            ListOriginationNumbersErrorKind::ValidationException(_inner) => Some(_inner),
            ListOriginationNumbersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPhoneNumbersOptedOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPhoneNumbersOptedOutError {
    /// Kind of error that occurred.
    pub kind: ListPhoneNumbersOptedOutErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPhoneNumbersOptedOut` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPhoneNumbersOptedOutErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPhoneNumbersOptedOutError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPhoneNumbersOptedOutErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ListPhoneNumbersOptedOutErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListPhoneNumbersOptedOutErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListPhoneNumbersOptedOutErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            ListPhoneNumbersOptedOutErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPhoneNumbersOptedOutError {
    fn code(&self) -> Option<&str> {
        ListPhoneNumbersOptedOutError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPhoneNumbersOptedOutError {
    /// Creates a new `ListPhoneNumbersOptedOutError`.
    pub fn new(kind: ListPhoneNumbersOptedOutErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPhoneNumbersOptedOutError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPhoneNumbersOptedOutErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPhoneNumbersOptedOutError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPhoneNumbersOptedOutErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPhoneNumbersOptedOutErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersOptedOutErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListPhoneNumbersOptedOutErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersOptedOutErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListPhoneNumbersOptedOutErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersOptedOutErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ListPhoneNumbersOptedOutErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersOptedOutErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for ListPhoneNumbersOptedOutError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPhoneNumbersOptedOutErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ListPhoneNumbersOptedOutErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListPhoneNumbersOptedOutErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListPhoneNumbersOptedOutErrorKind::ThrottledException(_inner) => Some(_inner),
            ListPhoneNumbersOptedOutErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPlatformApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPlatformApplicationsError {
    /// Kind of error that occurred.
    pub kind: ListPlatformApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPlatformApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPlatformApplicationsErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPlatformApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPlatformApplicationsErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ListPlatformApplicationsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListPlatformApplicationsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListPlatformApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPlatformApplicationsError {
    fn code(&self) -> Option<&str> {
        ListPlatformApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPlatformApplicationsError {
    /// Creates a new `ListPlatformApplicationsError`.
    pub fn new(kind: ListPlatformApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPlatformApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPlatformApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPlatformApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPlatformApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPlatformApplicationsErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPlatformApplicationsErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListPlatformApplicationsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPlatformApplicationsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListPlatformApplicationsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPlatformApplicationsErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListPlatformApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPlatformApplicationsErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ListPlatformApplicationsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListPlatformApplicationsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListPlatformApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSMSSandboxPhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSMSSandboxPhoneNumbersError {
    /// Kind of error that occurred.
    pub kind: ListSMSSandboxPhoneNumbersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSMSSandboxPhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSMSSandboxPhoneNumbersErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Can’t perform the action on the specified resource. Make sure that the resource
    /// exists.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSMSSandboxPhoneNumbersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSMSSandboxPhoneNumbersErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListSMSSandboxPhoneNumbersErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListSMSSandboxPhoneNumbersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListSMSSandboxPhoneNumbersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSMSSandboxPhoneNumbersErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            ListSMSSandboxPhoneNumbersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSMSSandboxPhoneNumbersError {
    fn code(&self) -> Option<&str> {
        ListSMSSandboxPhoneNumbersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSMSSandboxPhoneNumbersError {
    /// Creates a new `ListSMSSandboxPhoneNumbersError`.
    pub fn new(kind: ListSMSSandboxPhoneNumbersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSMSSandboxPhoneNumbersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSMSSandboxPhoneNumbersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSMSSandboxPhoneNumbersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSMSSandboxPhoneNumbersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSMSSandboxPhoneNumbersErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSMSSandboxPhoneNumbersErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSMSSandboxPhoneNumbersErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSMSSandboxPhoneNumbersErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSMSSandboxPhoneNumbersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSMSSandboxPhoneNumbersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ListSMSSandboxPhoneNumbersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSMSSandboxPhoneNumbersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListSMSSandboxPhoneNumbersErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSMSSandboxPhoneNumbersErrorKind::ThrottledException(_)
        )
    }
}
impl std::error::Error for ListSMSSandboxPhoneNumbersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSMSSandboxPhoneNumbersErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            ListSMSSandboxPhoneNumbersErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListSMSSandboxPhoneNumbersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListSMSSandboxPhoneNumbersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSMSSandboxPhoneNumbersErrorKind::ThrottledException(_inner) => Some(_inner),
            ListSMSSandboxPhoneNumbersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: ListSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSubscriptionsErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSubscriptionsErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ListSubscriptionsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListSubscriptionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSubscriptionsError {
    fn code(&self) -> Option<&str> {
        ListSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSubscriptionsError {
    /// Creates a new `ListSubscriptionsError`.
    pub fn new(kind: ListSubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSubscriptionsErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscriptionsErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSubscriptionsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscriptionsErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSubscriptionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscriptionsErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSubscriptionsErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ListSubscriptionsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListSubscriptionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSubscriptionsByTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSubscriptionsByTopicError {
    /// Kind of error that occurred.
    pub kind: ListSubscriptionsByTopicErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSubscriptionsByTopic` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSubscriptionsByTopicErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSubscriptionsByTopicError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSubscriptionsByTopicErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ListSubscriptionsByTopicErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListSubscriptionsByTopicErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListSubscriptionsByTopicErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListSubscriptionsByTopicErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSubscriptionsByTopicError {
    fn code(&self) -> Option<&str> {
        ListSubscriptionsByTopicError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSubscriptionsByTopicError {
    /// Creates a new `ListSubscriptionsByTopicError`.
    pub fn new(kind: ListSubscriptionsByTopicErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSubscriptionsByTopicError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSubscriptionsByTopicErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSubscriptionsByTopicError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSubscriptionsByTopicErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListSubscriptionsByTopicErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscriptionsByTopicErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSubscriptionsByTopicErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscriptionsByTopicErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListSubscriptionsByTopicErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscriptionsByTopicErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ListSubscriptionsByTopicErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscriptionsByTopicErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListSubscriptionsByTopicError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSubscriptionsByTopicErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ListSubscriptionsByTopicErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListSubscriptionsByTopicErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListSubscriptionsByTopicErrorKind::NotFoundException(_inner) => Some(_inner),
            ListSubscriptionsByTopicErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
    /// sequentially.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Can’t perform the action on the specified resource. Make sure that the resource
    /// exists.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request doesn't comply with the IAM tag policy. Correct your request and then
    /// retry it.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ConcurrentAccessException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ConcurrentAccessException`.
    pub fn is_concurrent_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ConcurrentAccessException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TagPolicyException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ConcurrentAccessException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TagPolicyException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTopics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTopicsError {
    /// Kind of error that occurred.
    pub kind: ListTopicsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTopics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTopicsErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTopicsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTopicsErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            ListTopicsErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            ListTopicsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTopicsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTopicsError {
    fn code(&self) -> Option<&str> {
        ListTopicsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTopicsError {
    /// Creates a new `ListTopicsError`.
    pub fn new(kind: ListTopicsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTopicsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTopicsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTopicsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTopicsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTopicsErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTopicsErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListTopicsErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ListTopicsErrorKind::InternalErrorException(_))
    }
    /// Returns true if the error kind is `ListTopicsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTopicsErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListTopicsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTopicsErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            ListTopicsErrorKind::InternalErrorException(_inner) => Some(_inner),
            ListTopicsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTopicsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `OptInPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct OptInPhoneNumberError {
    /// Kind of error that occurred.
    pub kind: OptInPhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `OptInPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum OptInPhoneNumberErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for OptInPhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            OptInPhoneNumberErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            OptInPhoneNumberErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            OptInPhoneNumberErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            OptInPhoneNumberErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            OptInPhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for OptInPhoneNumberError {
    fn code(&self) -> Option<&str> {
        OptInPhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl OptInPhoneNumberError {
    /// Creates a new `OptInPhoneNumberError`.
    pub fn new(kind: OptInPhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `OptInPhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: OptInPhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `OptInPhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: OptInPhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `OptInPhoneNumberErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            OptInPhoneNumberErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `OptInPhoneNumberErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            OptInPhoneNumberErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `OptInPhoneNumberErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            OptInPhoneNumberErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `OptInPhoneNumberErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, OptInPhoneNumberErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for OptInPhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            OptInPhoneNumberErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            OptInPhoneNumberErrorKind::InternalErrorException(_inner) => Some(_inner),
            OptInPhoneNumberErrorKind::InvalidParameterException(_inner) => Some(_inner),
            OptInPhoneNumberErrorKind::ThrottledException(_inner) => Some(_inner),
            OptInPhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Publish` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PublishError {
    /// Kind of error that occurred.
    pub kind: PublishErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Publish` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PublishErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Exception error indicating endpoint disabled.</p>
    EndpointDisabledException(crate::error::EndpointDisabledException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
    /// request using Signature Version 4.</p>
    InvalidSecurityException(crate::error::InvalidSecurityException),
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access
    /// to.</p>
    KmsAccessDeniedException(crate::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't
    /// enabled.</p>
    KmsDisabledException(crate::error::KmsDisabledException),
    /// <p>The request was rejected because the state of the specified resource isn't valid for
    /// this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
    /// Customer Master Key</a> in the <i>Key Management Service Developer
    /// Guide</i>.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>The request was rejected because the specified entity or resource can't be
    /// found.</p>
    KmsNotFoundException(crate::error::KmsNotFoundException),
    /// <p>The Amazon Web Services access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about
    /// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
    /// the <i>Key Management Service Developer Guide.</i>
    /// </p>
    KmsThrottlingException(crate::error::KmsThrottlingException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Exception error indicating platform application disabled.</p>
    PlatformApplicationDisabledException(crate::error::PlatformApplicationDisabledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PublishError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PublishErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            PublishErrorKind::EndpointDisabledException(_inner) => _inner.fmt(f),
            PublishErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            PublishErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PublishErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PublishErrorKind::InvalidSecurityException(_inner) => _inner.fmt(f),
            PublishErrorKind::KmsAccessDeniedException(_inner) => _inner.fmt(f),
            PublishErrorKind::KmsDisabledException(_inner) => _inner.fmt(f),
            PublishErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            PublishErrorKind::KmsNotFoundException(_inner) => _inner.fmt(f),
            PublishErrorKind::KmsOptInRequired(_inner) => _inner.fmt(f),
            PublishErrorKind::KmsThrottlingException(_inner) => _inner.fmt(f),
            PublishErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PublishErrorKind::PlatformApplicationDisabledException(_inner) => _inner.fmt(f),
            PublishErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PublishError {
    fn code(&self) -> Option<&str> {
        PublishError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PublishError {
    /// Creates a new `PublishError`.
    pub fn new(kind: PublishErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PublishError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PublishErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PublishError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PublishErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PublishErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::AuthorizationErrorException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::EndpointDisabledException`.
    pub fn is_endpoint_disabled_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::EndpointDisabledException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::InternalErrorException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns true if the error kind is `PublishErrorKind::InvalidSecurityException`.
    pub fn is_invalid_security_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::InvalidSecurityException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::KmsAccessDeniedException`.
    pub fn is_kms_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::KmsAccessDeniedException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::KmsDisabledException`.
    pub fn is_kms_disabled_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::KmsDisabledException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::KmsInvalidStateException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::KmsNotFoundException`.
    pub fn is_kms_not_found_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::KmsNotFoundException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::KmsOptInRequired`.
    pub fn is_kms_opt_in_required(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::KmsOptInRequired(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::KmsThrottlingException`.
    pub fn is_kms_throttling_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::KmsThrottlingException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PublishErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PublishErrorKind::PlatformApplicationDisabledException`.
    pub fn is_platform_application_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishErrorKind::PlatformApplicationDisabledException(_)
        )
    }
}
impl std::error::Error for PublishError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PublishErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            PublishErrorKind::EndpointDisabledException(_inner) => Some(_inner),
            PublishErrorKind::InternalErrorException(_inner) => Some(_inner),
            PublishErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PublishErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PublishErrorKind::InvalidSecurityException(_inner) => Some(_inner),
            PublishErrorKind::KmsAccessDeniedException(_inner) => Some(_inner),
            PublishErrorKind::KmsDisabledException(_inner) => Some(_inner),
            PublishErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            PublishErrorKind::KmsNotFoundException(_inner) => Some(_inner),
            PublishErrorKind::KmsOptInRequired(_inner) => Some(_inner),
            PublishErrorKind::KmsThrottlingException(_inner) => Some(_inner),
            PublishErrorKind::NotFoundException(_inner) => Some(_inner),
            PublishErrorKind::PlatformApplicationDisabledException(_inner) => Some(_inner),
            PublishErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemovePermissionError {
    /// Kind of error that occurred.
    pub kind: RemovePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemovePermissionErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemovePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemovePermissionErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemovePermissionError {
    fn code(&self) -> Option<&str> {
        RemovePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemovePermissionError {
    /// Creates a new `RemovePermissionError`.
    pub fn new(kind: RemovePermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `RemovePermissionErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `RemovePermissionErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `RemovePermissionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `RemovePermissionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RemovePermissionErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for RemovePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemovePermissionErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            RemovePermissionErrorKind::InternalErrorException(_inner) => Some(_inner),
            RemovePermissionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RemovePermissionErrorKind::NotFoundException(_inner) => Some(_inner),
            RemovePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetEndpointAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetEndpointAttributesError {
    /// Kind of error that occurred.
    pub kind: SetEndpointAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetEndpointAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetEndpointAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetEndpointAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetEndpointAttributesErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            SetEndpointAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetEndpointAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetEndpointAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SetEndpointAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetEndpointAttributesError {
    fn code(&self) -> Option<&str> {
        SetEndpointAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetEndpointAttributesError {
    /// Creates a new `SetEndpointAttributesError`.
    pub fn new(kind: SetEndpointAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetEndpointAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetEndpointAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetEndpointAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetEndpointAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetEndpointAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetEndpointAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetEndpointAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetEndpointAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetEndpointAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetEndpointAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `SetEndpointAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetEndpointAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for SetEndpointAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetEndpointAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            SetEndpointAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetEndpointAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetEndpointAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            SetEndpointAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetPlatformApplicationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetPlatformApplicationAttributesError {
    /// Kind of error that occurred.
    pub kind: SetPlatformApplicationAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetPlatformApplicationAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetPlatformApplicationAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetPlatformApplicationAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            SetPlatformApplicationAttributesErrorKind::InternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            SetPlatformApplicationAttributesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            SetPlatformApplicationAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SetPlatformApplicationAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetPlatformApplicationAttributesError {
    fn code(&self) -> Option<&str> {
        SetPlatformApplicationAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetPlatformApplicationAttributesError {
    /// Creates a new `SetPlatformApplicationAttributesError`.
    pub fn new(
        kind: SetPlatformApplicationAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetPlatformApplicationAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetPlatformApplicationAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetPlatformApplicationAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetPlatformApplicationAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetPlatformApplicationAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetPlatformApplicationAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetPlatformApplicationAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetPlatformApplicationAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetPlatformApplicationAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `SetPlatformApplicationAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetPlatformApplicationAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for SetPlatformApplicationAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetPlatformApplicationAttributesErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            SetPlatformApplicationAttributesErrorKind::InternalErrorException(_inner) => {
                Some(_inner)
            }
            SetPlatformApplicationAttributesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            SetPlatformApplicationAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            SetPlatformApplicationAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetSMSAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetSMSAttributesError {
    /// Kind of error that occurred.
    pub kind: SetSMSAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetSMSAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetSMSAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetSMSAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetSMSAttributesErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            SetSMSAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetSMSAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetSMSAttributesErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            SetSMSAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetSMSAttributesError {
    fn code(&self) -> Option<&str> {
        SetSMSAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetSMSAttributesError {
    /// Creates a new `SetSMSAttributesError`.
    pub fn new(kind: SetSMSAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetSMSAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetSMSAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetSMSAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetSMSAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetSMSAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSMSAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetSMSAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSMSAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetSMSAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSMSAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `SetSMSAttributesErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(&self.kind, SetSMSAttributesErrorKind::ThrottledException(_))
    }
}
impl std::error::Error for SetSMSAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetSMSAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            SetSMSAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetSMSAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetSMSAttributesErrorKind::ThrottledException(_inner) => Some(_inner),
            SetSMSAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetSubscriptionAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetSubscriptionAttributesError {
    /// Kind of error that occurred.
    pub kind: SetSubscriptionAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetSubscriptionAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetSubscriptionAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates that the number of filter polices in your account exceeds the limit. To
    /// add more filter polices, submit an SNS Limit Increase case in the Amazon Web Services Support
    /// Center.</p>
    FilterPolicyLimitExceededException(crate::error::FilterPolicyLimitExceededException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetSubscriptionAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetSubscriptionAttributesErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            SetSubscriptionAttributesErrorKind::FilterPolicyLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            SetSubscriptionAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetSubscriptionAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetSubscriptionAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SetSubscriptionAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetSubscriptionAttributesError {
    fn code(&self) -> Option<&str> {
        SetSubscriptionAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetSubscriptionAttributesError {
    /// Creates a new `SetSubscriptionAttributesError`.
    pub fn new(kind: SetSubscriptionAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetSubscriptionAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetSubscriptionAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetSubscriptionAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetSubscriptionAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetSubscriptionAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubscriptionAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetSubscriptionAttributesErrorKind::FilterPolicyLimitExceededException`.
    pub fn is_filter_policy_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubscriptionAttributesErrorKind::FilterPolicyLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `SetSubscriptionAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubscriptionAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetSubscriptionAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubscriptionAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `SetSubscriptionAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSubscriptionAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for SetSubscriptionAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetSubscriptionAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            SetSubscriptionAttributesErrorKind::FilterPolicyLimitExceededException(_inner) => {
                Some(_inner)
            }
            SetSubscriptionAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetSubscriptionAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetSubscriptionAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            SetSubscriptionAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetTopicAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetTopicAttributesError {
    /// Kind of error that occurred.
    pub kind: SetTopicAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetTopicAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetTopicAttributesErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
    /// request using Signature Version 4.</p>
    InvalidSecurityException(crate::error::InvalidSecurityException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetTopicAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetTopicAttributesErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            SetTopicAttributesErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SetTopicAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetTopicAttributesErrorKind::InvalidSecurityException(_inner) => _inner.fmt(f),
            SetTopicAttributesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SetTopicAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetTopicAttributesError {
    fn code(&self) -> Option<&str> {
        SetTopicAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetTopicAttributesError {
    /// Creates a new `SetTopicAttributesError`.
    pub fn new(kind: SetTopicAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetTopicAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetTopicAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetTopicAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetTopicAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SetTopicAttributesErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTopicAttributesErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetTopicAttributesErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTopicAttributesErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `SetTopicAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTopicAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `SetTopicAttributesErrorKind::InvalidSecurityException`.
    pub fn is_invalid_security_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTopicAttributesErrorKind::InvalidSecurityException(_)
        )
    }
    /// Returns true if the error kind is `SetTopicAttributesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetTopicAttributesErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for SetTopicAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetTopicAttributesErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            SetTopicAttributesErrorKind::InternalErrorException(_inner) => Some(_inner),
            SetTopicAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetTopicAttributesErrorKind::InvalidSecurityException(_inner) => Some(_inner),
            SetTopicAttributesErrorKind::NotFoundException(_inner) => Some(_inner),
            SetTopicAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Subscribe` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubscribeError {
    /// Kind of error that occurred.
    pub kind: SubscribeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Subscribe` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubscribeErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates that the number of filter polices in your account exceeds the limit. To
    /// add more filter polices, submit an SNS Limit Increase case in the Amazon Web Services Support
    /// Center.</p>
    FilterPolicyLimitExceededException(crate::error::FilterPolicyLimitExceededException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
    /// request using Signature Version 4.</p>
    InvalidSecurityException(crate::error::InvalidSecurityException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Indicates that the customer already owns the maximum allowed number of
    /// subscriptions.</p>
    SubscriptionLimitExceededException(crate::error::SubscriptionLimitExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubscribeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubscribeErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            SubscribeErrorKind::FilterPolicyLimitExceededException(_inner) => _inner.fmt(f),
            SubscribeErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            SubscribeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SubscribeErrorKind::InvalidSecurityException(_inner) => _inner.fmt(f),
            SubscribeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SubscribeErrorKind::SubscriptionLimitExceededException(_inner) => _inner.fmt(f),
            SubscribeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubscribeError {
    fn code(&self) -> Option<&str> {
        SubscribeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SubscribeError {
    /// Creates a new `SubscribeError`.
    pub fn new(kind: SubscribeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubscribeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubscribeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubscribeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubscribeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SubscribeErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `SubscribeErrorKind::FilterPolicyLimitExceededException`.
    pub fn is_filter_policy_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeErrorKind::FilterPolicyLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `SubscribeErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, SubscribeErrorKind::InternalErrorException(_))
    }
    /// Returns true if the error kind is `SubscribeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, SubscribeErrorKind::InvalidParameterException(_))
    }
    /// Returns true if the error kind is `SubscribeErrorKind::InvalidSecurityException`.
    pub fn is_invalid_security_exception(&self) -> bool {
        matches!(&self.kind, SubscribeErrorKind::InvalidSecurityException(_))
    }
    /// Returns true if the error kind is `SubscribeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, SubscribeErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `SubscribeErrorKind::SubscriptionLimitExceededException`.
    pub fn is_subscription_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubscribeErrorKind::SubscriptionLimitExceededException(_)
        )
    }
}
impl std::error::Error for SubscribeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubscribeErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            SubscribeErrorKind::FilterPolicyLimitExceededException(_inner) => Some(_inner),
            SubscribeErrorKind::InternalErrorException(_inner) => Some(_inner),
            SubscribeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SubscribeErrorKind::InvalidSecurityException(_inner) => Some(_inner),
            SubscribeErrorKind::NotFoundException(_inner) => Some(_inner),
            SubscribeErrorKind::SubscriptionLimitExceededException(_inner) => Some(_inner),
            SubscribeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
    /// sequentially.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Can’t perform the action on the specified resource. Make sure that the resource
    /// exists.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
    /// short while and then retry the operation.</p>
    StaleTagException(crate::error::StaleTagException),
    /// <p>Can't add more than 50 tags to a topic.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>The request doesn't comply with the IAM tag policy. Correct your request and then
    /// retry it.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConcurrentAccessException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::StaleTagException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagLimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ConcurrentAccessException`.
    pub fn is_concurrent_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentAccessException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::StaleTagException`.
    pub fn is_stale_tag_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::StaleTagException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TagLimitExceededException`.
    pub fn is_tag_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TagPolicyException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::ConcurrentAccessException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::StaleTagException(_inner) => Some(_inner),
            TagResourceErrorKind::TagLimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::TagPolicyException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Unsubscribe` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UnsubscribeError {
    /// Kind of error that occurred.
    pub kind: UnsubscribeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Unsubscribe` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UnsubscribeErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
    /// request using Signature Version 4.</p>
    InvalidSecurityException(crate::error::InvalidSecurityException),
    /// <p>Indicates that the requested resource does not exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UnsubscribeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UnsubscribeErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            UnsubscribeErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            UnsubscribeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UnsubscribeErrorKind::InvalidSecurityException(_inner) => _inner.fmt(f),
            UnsubscribeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UnsubscribeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UnsubscribeError {
    fn code(&self) -> Option<&str> {
        UnsubscribeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UnsubscribeError {
    /// Creates a new `UnsubscribeError`.
    pub fn new(kind: UnsubscribeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UnsubscribeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UnsubscribeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UnsubscribeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UnsubscribeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UnsubscribeErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `UnsubscribeErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(&self.kind, UnsubscribeErrorKind::InternalErrorException(_))
    }
    /// Returns true if the error kind is `UnsubscribeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `UnsubscribeErrorKind::InvalidSecurityException`.
    pub fn is_invalid_security_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnsubscribeErrorKind::InvalidSecurityException(_)
        )
    }
    /// Returns true if the error kind is `UnsubscribeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UnsubscribeErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UnsubscribeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UnsubscribeErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            UnsubscribeErrorKind::InternalErrorException(_inner) => Some(_inner),
            UnsubscribeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UnsubscribeErrorKind::InvalidSecurityException(_inner) => Some(_inner),
            UnsubscribeErrorKind::NotFoundException(_inner) => Some(_inner),
            UnsubscribeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
    /// sequentially.</p>
    ConcurrentAccessException(crate::error::ConcurrentAccessException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Can’t perform the action on the specified resource. Make sure that the resource
    /// exists.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
    /// short while and then retry the operation.</p>
    StaleTagException(crate::error::StaleTagException),
    /// <p>Can't add more than 50 tags to a topic.</p>
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// <p>The request doesn't comply with the IAM tag policy. Correct your request and then
    /// retry it.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AuthorizationErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConcurrentAccessException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::StaleTagException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagLimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ConcurrentAccessException`.
    pub fn is_concurrent_access_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentAccessException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::StaleTagException`.
    pub fn is_stale_tag_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::StaleTagException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::TagLimitExceededException`.
    pub fn is_tag_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TagLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TagPolicyException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AuthorizationErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConcurrentAccessException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::StaleTagException(_inner) => Some(_inner),
            UntagResourceErrorKind::TagLimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::TagPolicyException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VerifySMSSandboxPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VerifySMSSandboxPhoneNumberError {
    /// Kind of error that occurred.
    pub kind: VerifySMSSandboxPhoneNumberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VerifySMSSandboxPhoneNumber` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VerifySMSSandboxPhoneNumberErrorKind {
    /// <p>Indicates that the user has been denied access to the requested resource.</p>
    AuthorizationErrorException(crate::error::AuthorizationErrorException),
    /// <p>Indicates an internal service error.</p>
    InternalErrorException(crate::error::InternalErrorException),
    /// <p>Indicates that a request parameter does not comply with the associated
    /// constraints.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Can’t perform the action on the specified resource. Make sure that the resource
    /// exists.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Indicates that the rate at which requests have been submitted for this action exceeds
    /// the limit for your account.</p>
    ThrottledException(crate::error::ThrottledException),
    /// <p>Indicates that the one-time password (OTP) used for verification is invalid.</p>
    VerificationException(crate::error::VerificationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VerifySMSSandboxPhoneNumberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VerifySMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_inner) => {
                _inner.fmt(f)
            }
            VerifySMSSandboxPhoneNumberErrorKind::InternalErrorException(_inner) => _inner.fmt(f),
            VerifySMSSandboxPhoneNumberErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            VerifySMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            VerifySMSSandboxPhoneNumberErrorKind::ThrottledException(_inner) => _inner.fmt(f),
            VerifySMSSandboxPhoneNumberErrorKind::VerificationException(_inner) => _inner.fmt(f),
            VerifySMSSandboxPhoneNumberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VerifySMSSandboxPhoneNumberError {
    fn code(&self) -> Option<&str> {
        VerifySMSSandboxPhoneNumberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VerifySMSSandboxPhoneNumberError {
    /// Creates a new `VerifySMSSandboxPhoneNumberError`.
    pub fn new(kind: VerifySMSSandboxPhoneNumberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VerifySMSSandboxPhoneNumberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VerifySMSSandboxPhoneNumberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VerifySMSSandboxPhoneNumberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VerifySMSSandboxPhoneNumberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `VerifySMSSandboxPhoneNumberErrorKind::AuthorizationErrorException`.
    pub fn is_authorization_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_)
        )
    }
    /// Returns true if the error kind is `VerifySMSSandboxPhoneNumberErrorKind::InternalErrorException`.
    pub fn is_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySMSSandboxPhoneNumberErrorKind::InternalErrorException(_)
        )
    }
    /// Returns true if the error kind is `VerifySMSSandboxPhoneNumberErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySMSSandboxPhoneNumberErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns true if the error kind is `VerifySMSSandboxPhoneNumberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `VerifySMSSandboxPhoneNumberErrorKind::ThrottledException`.
    pub fn is_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySMSSandboxPhoneNumberErrorKind::ThrottledException(_)
        )
    }
    /// Returns true if the error kind is `VerifySMSSandboxPhoneNumberErrorKind::VerificationException`.
    pub fn is_verification_exception(&self) -> bool {
        matches!(
            &self.kind,
            VerifySMSSandboxPhoneNumberErrorKind::VerificationException(_)
        )
    }
}
impl std::error::Error for VerifySMSSandboxPhoneNumberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VerifySMSSandboxPhoneNumberErrorKind::AuthorizationErrorException(_inner) => {
                Some(_inner)
            }
            VerifySMSSandboxPhoneNumberErrorKind::InternalErrorException(_inner) => Some(_inner),
            VerifySMSSandboxPhoneNumberErrorKind::InvalidParameterException(_inner) => Some(_inner),
            VerifySMSSandboxPhoneNumberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            VerifySMSSandboxPhoneNumberErrorKind::ThrottledException(_inner) => Some(_inner),
            VerifySMSSandboxPhoneNumberErrorKind::VerificationException(_inner) => Some(_inner),
            VerifySMSSandboxPhoneNumberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Indicates that the one-time password (OTP) used for verification is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VerificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The status of the verification error.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VerificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VerificationException");
        formatter.field("message", &self.message);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
impl VerificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for VerificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "VerificationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for VerificationException {}
/// See [`VerificationException`](crate::error::VerificationException)
pub mod verification_exception {
    /// A builder for [`VerificationException`](crate::error::VerificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The status of the verification error.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the verification error.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VerificationException`](crate::error::VerificationException)
        pub fn build(self) -> crate::error::VerificationException {
            crate::error::VerificationException {
                message: self.message,
                status: self.status,
            }
        }
    }
}
impl VerificationException {
    /// Creates a new builder-style object to manufacture [`VerificationException`](crate::error::VerificationException)
    pub fn builder() -> crate::error::verification_exception::Builder {
        crate::error::verification_exception::Builder::default()
    }
}

/// <p>Indicates that the rate at which requests have been submitted for this action exceeds
/// the limit for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottledException {
    /// <p>Throttled request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottledException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottledException {}
/// See [`ThrottledException`](crate::error::ThrottledException)
pub mod throttled_exception {
    /// A builder for [`ThrottledException`](crate::error::ThrottledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Throttled request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Throttled request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottledException`](crate::error::ThrottledException)
        pub fn build(self) -> crate::error::ThrottledException {
            crate::error::ThrottledException {
                message: self.message,
            }
        }
    }
}
impl ThrottledException {
    /// Creates a new builder-style object to manufacture [`ThrottledException`](crate::error::ThrottledException)
    pub fn builder() -> crate::error::throttled_exception::Builder {
        crate::error::throttled_exception::Builder::default()
    }
}

/// <p>Can’t perform the action on the specified resource. Make sure that the resource
/// exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Indicates that a request parameter does not comply with the associated
/// constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>Indicates an internal service error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalErrorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalErrorException {}
/// See [`InternalErrorException`](crate::error::InternalErrorException)
pub mod internal_error_exception {
    /// A builder for [`InternalErrorException`](crate::error::InternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalErrorException`](crate::error::InternalErrorException)
        pub fn build(self) -> crate::error::InternalErrorException {
            crate::error::InternalErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalErrorException {
    /// Creates a new builder-style object to manufacture [`InternalErrorException`](crate::error::InternalErrorException)
    pub fn builder() -> crate::error::internal_error_exception::Builder {
        crate::error::internal_error_exception::Builder::default()
    }
}

/// <p>Indicates that the user has been denied access to the requested resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthorizationErrorException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthorizationErrorException {}
/// See [`AuthorizationErrorException`](crate::error::AuthorizationErrorException)
pub mod authorization_error_exception {
    /// A builder for [`AuthorizationErrorException`](crate::error::AuthorizationErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationErrorException`](crate::error::AuthorizationErrorException)
        pub fn build(self) -> crate::error::AuthorizationErrorException {
            crate::error::AuthorizationErrorException {
                message: self.message,
            }
        }
    }
}
impl AuthorizationErrorException {
    /// Creates a new builder-style object to manufacture [`AuthorizationErrorException`](crate::error::AuthorizationErrorException)
    pub fn builder() -> crate::error::authorization_error_exception::Builder {
        crate::error::authorization_error_exception::Builder::default()
    }
}

/// <p>The request doesn't comply with the IAM tag policy. Correct your request and then
/// retry it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagPolicyException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagPolicyException {}
/// See [`TagPolicyException`](crate::error::TagPolicyException)
pub mod tag_policy_exception {
    /// A builder for [`TagPolicyException`](crate::error::TagPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagPolicyException`](crate::error::TagPolicyException)
        pub fn build(self) -> crate::error::TagPolicyException {
            crate::error::TagPolicyException {
                message: self.message,
            }
        }
    }
}
impl TagPolicyException {
    /// Creates a new builder-style object to manufacture [`TagPolicyException`](crate::error::TagPolicyException)
    pub fn builder() -> crate::error::tag_policy_exception::Builder {
        crate::error::tag_policy_exception::Builder::default()
    }
}

/// <p>Can't add more than 50 tags to a topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagLimitExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagLimitExceededException {}
/// See [`TagLimitExceededException`](crate::error::TagLimitExceededException)
pub mod tag_limit_exceeded_exception {
    /// A builder for [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagLimitExceededException`](crate::error::TagLimitExceededException)
        pub fn build(self) -> crate::error::TagLimitExceededException {
            crate::error::TagLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TagLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    pub fn builder() -> crate::error::tag_limit_exceeded_exception::Builder {
        crate::error::tag_limit_exceeded_exception::Builder::default()
    }
}

/// <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
/// short while and then retry the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StaleTagException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StaleTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StaleTagException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StaleTagException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StaleTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StaleTagException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for StaleTagException {}
/// See [`StaleTagException`](crate::error::StaleTagException)
pub mod stale_tag_exception {
    /// A builder for [`StaleTagException`](crate::error::StaleTagException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StaleTagException`](crate::error::StaleTagException)
        pub fn build(self) -> crate::error::StaleTagException {
            crate::error::StaleTagException {
                message: self.message,
            }
        }
    }
}
impl StaleTagException {
    /// Creates a new builder-style object to manufacture [`StaleTagException`](crate::error::StaleTagException)
    pub fn builder() -> crate::error::stale_tag_exception::Builder {
        crate::error::stale_tag_exception::Builder::default()
    }
}

/// <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
/// sequentially.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentAccessException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentAccessException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentAccessException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentAccessException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentAccessException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentAccessException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentAccessException {}
/// See [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
pub mod concurrent_access_exception {
    /// A builder for [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
        pub fn build(self) -> crate::error::ConcurrentAccessException {
            crate::error::ConcurrentAccessException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentAccessException {
    /// Creates a new builder-style object to manufacture [`ConcurrentAccessException`](crate::error::ConcurrentAccessException)
    pub fn builder() -> crate::error::concurrent_access_exception::Builder {
        crate::error::concurrent_access_exception::Builder::default()
    }
}

/// <p>Indicates that the requested resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
/// request using Signature Version 4.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSecurityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSecurityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSecurityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSecurityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSecurityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSecurityException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSecurityException {}
/// See [`InvalidSecurityException`](crate::error::InvalidSecurityException)
pub mod invalid_security_exception {
    /// A builder for [`InvalidSecurityException`](crate::error::InvalidSecurityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSecurityException`](crate::error::InvalidSecurityException)
        pub fn build(self) -> crate::error::InvalidSecurityException {
            crate::error::InvalidSecurityException {
                message: self.message,
            }
        }
    }
}
impl InvalidSecurityException {
    /// Creates a new builder-style object to manufacture [`InvalidSecurityException`](crate::error::InvalidSecurityException)
    pub fn builder() -> crate::error::invalid_security_exception::Builder {
        crate::error::invalid_security_exception::Builder::default()
    }
}

/// <p>Indicates that the customer already owns the maximum allowed number of
/// subscriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionLimitExceededException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionLimitExceededException {}
/// See [`SubscriptionLimitExceededException`](crate::error::SubscriptionLimitExceededException)
pub mod subscription_limit_exceeded_exception {
    /// A builder for [`SubscriptionLimitExceededException`](crate::error::SubscriptionLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionLimitExceededException`](crate::error::SubscriptionLimitExceededException)
        pub fn build(self) -> crate::error::SubscriptionLimitExceededException {
            crate::error::SubscriptionLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl SubscriptionLimitExceededException {
    /// Creates a new builder-style object to manufacture [`SubscriptionLimitExceededException`](crate::error::SubscriptionLimitExceededException)
    pub fn builder() -> crate::error::subscription_limit_exceeded_exception::Builder {
        crate::error::subscription_limit_exceeded_exception::Builder::default()
    }
}

/// <p>Indicates that the number of filter polices in your account exceeds the limit. To
/// add more filter polices, submit an SNS Limit Increase case in the Amazon Web Services Support
/// Center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterPolicyLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FilterPolicyLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterPolicyLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FilterPolicyLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FilterPolicyLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FilterPolicyLimitExceededException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for FilterPolicyLimitExceededException {}
/// See [`FilterPolicyLimitExceededException`](crate::error::FilterPolicyLimitExceededException)
pub mod filter_policy_limit_exceeded_exception {
    /// A builder for [`FilterPolicyLimitExceededException`](crate::error::FilterPolicyLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterPolicyLimitExceededException`](crate::error::FilterPolicyLimitExceededException)
        pub fn build(self) -> crate::error::FilterPolicyLimitExceededException {
            crate::error::FilterPolicyLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl FilterPolicyLimitExceededException {
    /// Creates a new builder-style object to manufacture [`FilterPolicyLimitExceededException`](crate::error::FilterPolicyLimitExceededException)
    pub fn builder() -> crate::error::filter_policy_limit_exceeded_exception::Builder {
        crate::error::filter_policy_limit_exceeded_exception::Builder::default()
    }
}

/// <p>Exception error indicating platform application disabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformApplicationDisabledException {
    /// <p>Message for platform application disabled.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformApplicationDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformApplicationDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PlatformApplicationDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PlatformApplicationDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PlatformApplicationDisabledException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for PlatformApplicationDisabledException {}
/// See [`PlatformApplicationDisabledException`](crate::error::PlatformApplicationDisabledException)
pub mod platform_application_disabled_exception {
    /// A builder for [`PlatformApplicationDisabledException`](crate::error::PlatformApplicationDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Message for platform application disabled.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Message for platform application disabled.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformApplicationDisabledException`](crate::error::PlatformApplicationDisabledException)
        pub fn build(self) -> crate::error::PlatformApplicationDisabledException {
            crate::error::PlatformApplicationDisabledException {
                message: self.message,
            }
        }
    }
}
impl PlatformApplicationDisabledException {
    /// Creates a new builder-style object to manufacture [`PlatformApplicationDisabledException`](crate::error::PlatformApplicationDisabledException)
    pub fn builder() -> crate::error::platform_application_disabled_exception::Builder {
        crate::error::platform_application_disabled_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling. For more information about
/// throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
/// the <i>Key Management Service Developer Guide.</i>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsThrottlingException [KMSThrottlingException]")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsThrottlingException {}
/// See [`KmsThrottlingException`](crate::error::KmsThrottlingException)
pub mod kms_throttling_exception {
    /// A builder for [`KmsThrottlingException`](crate::error::KmsThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsThrottlingException`](crate::error::KmsThrottlingException)
        pub fn build(self) -> crate::error::KmsThrottlingException {
            crate::error::KmsThrottlingException {
                message: self.message,
            }
        }
    }
}
impl KmsThrottlingException {
    /// Creates a new builder-style object to manufacture [`KmsThrottlingException`](crate::error::KmsThrottlingException)
    pub fn builder() -> crate::error::kms_throttling_exception::Builder {
        crate::error::kms_throttling_exception::Builder::default()
    }
}

/// <p>The Amazon Web Services access key ID needs a subscription for the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsOptInRequired {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsOptInRequired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsOptInRequired");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsOptInRequired {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsOptInRequired {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsOptInRequired [KMSOptInRequired]")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsOptInRequired {}
/// See [`KmsOptInRequired`](crate::error::KmsOptInRequired)
pub mod kms_opt_in_required {
    /// A builder for [`KmsOptInRequired`](crate::error::KmsOptInRequired)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsOptInRequired`](crate::error::KmsOptInRequired)
        pub fn build(self) -> crate::error::KmsOptInRequired {
            crate::error::KmsOptInRequired {
                message: self.message,
            }
        }
    }
}
impl KmsOptInRequired {
    /// Creates a new builder-style object to manufacture [`KmsOptInRequired`](crate::error::KmsOptInRequired)
    pub fn builder() -> crate::error::kms_opt_in_required::Builder {
        crate::error::kms_opt_in_required::Builder::default()
    }
}

/// <p>The request was rejected because the specified entity or resource can't be
/// found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsNotFoundException [KMSNotFoundException]")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsNotFoundException {}
/// See [`KmsNotFoundException`](crate::error::KmsNotFoundException)
pub mod kms_not_found_exception {
    /// A builder for [`KmsNotFoundException`](crate::error::KmsNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsNotFoundException`](crate::error::KmsNotFoundException)
        pub fn build(self) -> crate::error::KmsNotFoundException {
            crate::error::KmsNotFoundException {
                message: self.message,
            }
        }
    }
}
impl KmsNotFoundException {
    /// Creates a new builder-style object to manufacture [`KmsNotFoundException`](crate::error::KmsNotFoundException)
    pub fn builder() -> crate::error::kms_not_found_exception::Builder {
        crate::error::kms_not_found_exception::Builder::default()
    }
}

/// <p>The request was rejected because the state of the specified resource isn't valid for
/// this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
/// Customer Master Key</a> in the <i>Key Management Service Developer
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsInvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsInvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsInvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsInvalidStateException [KMSInvalidStateException]")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsInvalidStateException {}
/// See [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
pub mod kms_invalid_state_exception {
    /// A builder for [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
        pub fn build(self) -> crate::error::KmsInvalidStateException {
            crate::error::KmsInvalidStateException {
                message: self.message,
            }
        }
    }
}
impl KmsInvalidStateException {
    /// Creates a new builder-style object to manufacture [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    pub fn builder() -> crate::error::kms_invalid_state_exception::Builder {
        crate::error::kms_invalid_state_exception::Builder::default()
    }
}

/// <p>The request was rejected because the specified customer master key (CMK) isn't
/// enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsDisabledException [KMSDisabledException]")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsDisabledException {}
/// See [`KmsDisabledException`](crate::error::KmsDisabledException)
pub mod kms_disabled_exception {
    /// A builder for [`KmsDisabledException`](crate::error::KmsDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsDisabledException`](crate::error::KmsDisabledException)
        pub fn build(self) -> crate::error::KmsDisabledException {
            crate::error::KmsDisabledException {
                message: self.message,
            }
        }
    }
}
impl KmsDisabledException {
    /// Creates a new builder-style object to manufacture [`KmsDisabledException`](crate::error::KmsDisabledException)
    pub fn builder() -> crate::error::kms_disabled_exception::Builder {
        crate::error::kms_disabled_exception::Builder::default()
    }
}

/// <p>The ciphertext references a key that doesn't exist or that you don't have access
/// to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsAccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsAccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsAccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsAccessDeniedException [KMSAccessDeniedException]")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsAccessDeniedException {}
/// See [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
pub mod kms_access_denied_exception {
    /// A builder for [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
        pub fn build(self) -> crate::error::KmsAccessDeniedException {
            crate::error::KmsAccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl KmsAccessDeniedException {
    /// Creates a new builder-style object to manufacture [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
    pub fn builder() -> crate::error::kms_access_denied_exception::Builder {
        crate::error::kms_access_denied_exception::Builder::default()
    }
}

/// <p>Indicates that a request parameter does not comply with the associated
/// constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    /// <p>The parameter value is invalid.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The parameter value is invalid.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The parameter value is invalid.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>Exception error indicating endpoint disabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointDisabledException {
    /// <p>Message for endpoint disabled.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointDisabledException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointDisabledException {}
/// See [`EndpointDisabledException`](crate::error::EndpointDisabledException)
pub mod endpoint_disabled_exception {
    /// A builder for [`EndpointDisabledException`](crate::error::EndpointDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Message for endpoint disabled.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Message for endpoint disabled.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointDisabledException`](crate::error::EndpointDisabledException)
        pub fn build(self) -> crate::error::EndpointDisabledException {
            crate::error::EndpointDisabledException {
                message: self.message,
            }
        }
    }
}
impl EndpointDisabledException {
    /// Creates a new builder-style object to manufacture [`EndpointDisabledException`](crate::error::EndpointDisabledException)
    pub fn builder() -> crate::error::endpoint_disabled_exception::Builder {
        crate::error::endpoint_disabled_exception::Builder::default()
    }
}

/// <p>Indicates that a parameter in the request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Indicates that a request parameter does not comply with the associated
/// constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserErrorException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserErrorException {}
/// See [`UserErrorException`](crate::error::UserErrorException)
pub mod user_error_exception {
    /// A builder for [`UserErrorException`](crate::error::UserErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserErrorException`](crate::error::UserErrorException)
        pub fn build(self) -> crate::error::UserErrorException {
            crate::error::UserErrorException {
                message: self.message,
            }
        }
    }
}
impl UserErrorException {
    /// Creates a new builder-style object to manufacture [`UserErrorException`](crate::error::UserErrorException)
    pub fn builder() -> crate::error::user_error_exception::Builder {
        crate::error::user_error_exception::Builder::default()
    }
}

/// <p>Indicates that the customer already owns the maximum allowed number of topics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TopicLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TopicLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TopicLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TopicLimitExceededException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for TopicLimitExceededException {}
/// See [`TopicLimitExceededException`](crate::error::TopicLimitExceededException)
pub mod topic_limit_exceeded_exception {
    /// A builder for [`TopicLimitExceededException`](crate::error::TopicLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicLimitExceededException`](crate::error::TopicLimitExceededException)
        pub fn build(self) -> crate::error::TopicLimitExceededException {
            crate::error::TopicLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TopicLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TopicLimitExceededException`](crate::error::TopicLimitExceededException)
    pub fn builder() -> crate::error::topic_limit_exceeded_exception::Builder {
        crate::error::topic_limit_exceeded_exception::Builder::default()
    }
}

/// <p>Indicates that the specified phone number opted out of receiving SMS messages from
/// your account. You can't send SMS messages to phone numbers that opt out.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptedOutException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptedOutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptedOutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OptedOutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OptedOutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OptedOutException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for OptedOutException {}
/// See [`OptedOutException`](crate::error::OptedOutException)
pub mod opted_out_exception {
    /// A builder for [`OptedOutException`](crate::error::OptedOutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OptedOutException`](crate::error::OptedOutException)
        pub fn build(self) -> crate::error::OptedOutException {
            crate::error::OptedOutException {
                message: self.message,
            }
        }
    }
}
impl OptedOutException {
    /// Creates a new builder-style object to manufacture [`OptedOutException`](crate::error::OptedOutException)
    pub fn builder() -> crate::error::opted_out_exception::Builder {
        crate::error::opted_out_exception::Builder::default()
    }
}
