// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_task`](crate::client::Client::cancel_task).
///
/// See [`crate::client::fluent_builders::CancelTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelTask {
    _private: (),
}
impl CancelTask {
    /// Creates a new builder-style object to manufacture [`CancelTaskInput`](crate::input::CancelTaskInput)
    pub fn builder() -> crate::input::cancel_task_input::Builder {
        crate::input::cancel_task_input::Builder::default()
    }
    /// Creates a new `CancelTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelTask {
    type Output =
        std::result::Result<crate::output::CancelTaskOutput, crate::error::CancelTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_task_response(response)
        }
    }
}

/// Operation shape for `CreateTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_task`](crate::client::Client::create_task).
///
/// See [`crate::client::fluent_builders::CreateTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTask {
    _private: (),
}
impl CreateTask {
    /// Creates a new builder-style object to manufacture [`CreateTaskInput`](crate::input::CreateTaskInput)
    pub fn builder() -> crate::input::create_task_input::Builder {
        crate::input::create_task_input::Builder::default()
    }
    /// Creates a new `CreateTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTask {
    type Output =
        std::result::Result<crate::output::CreateTaskOutput, crate::error::CreateTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_task_error(response)
        } else {
            crate::operation_deser::parse_create_task_response(response)
        }
    }
}

/// Operation shape for `DescribeDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device`](crate::client::Client::describe_device).
///
/// See [`crate::client::fluent_builders::DescribeDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDevice {
    _private: (),
}
impl DescribeDevice {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
    /// Creates a new `DescribeDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDevice {
    type Output =
        std::result::Result<crate::output::DescribeDeviceOutput, crate::error::DescribeDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_error(response)
        } else {
            crate::operation_deser::parse_describe_device_response(response)
        }
    }
}

/// Operation shape for `DescribeDeviceEc2Instances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device_ec2_instances`](crate::client::Client::describe_device_ec2_instances).
///
/// See [`crate::client::fluent_builders::DescribeDeviceEc2Instances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDeviceEc2Instances {
    _private: (),
}
impl DescribeDeviceEc2Instances {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceEc2InstancesInput`](crate::input::DescribeDeviceEc2InstancesInput)
    pub fn builder() -> crate::input::describe_device_ec2_instances_input::Builder {
        crate::input::describe_device_ec2_instances_input::Builder::default()
    }
    /// Creates a new `DescribeDeviceEc2Instances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDeviceEc2Instances {
    type Output = std::result::Result<
        crate::output::DescribeDeviceEc2InstancesOutput,
        crate::error::DescribeDeviceEc2InstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_ec2_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_device_ec2_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_execution`](crate::client::Client::describe_execution).
///
/// See [`crate::client::fluent_builders::DescribeExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExecution {
    _private: (),
}
impl DescribeExecution {
    /// Creates a new builder-style object to manufacture [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
    pub fn builder() -> crate::input::describe_execution_input::Builder {
        crate::input::describe_execution_input::Builder::default()
    }
    /// Creates a new `DescribeExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExecution {
    type Output = std::result::Result<
        crate::output::DescribeExecutionOutput,
        crate::error::DescribeExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_execution_response(response)
        }
    }
}

/// Operation shape for `DescribeTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_task`](crate::client::Client::describe_task).
///
/// See [`crate::client::fluent_builders::DescribeTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTask {
    _private: (),
}
impl DescribeTask {
    /// Creates a new builder-style object to manufacture [`DescribeTaskInput`](crate::input::DescribeTaskInput)
    pub fn builder() -> crate::input::describe_task_input::Builder {
        crate::input::describe_task_input::Builder::default()
    }
    /// Creates a new `DescribeTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTask {
    type Output =
        std::result::Result<crate::output::DescribeTaskOutput, crate::error::DescribeTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_task_error(response)
        } else {
            crate::operation_deser::parse_describe_task_response(response)
        }
    }
}

/// Operation shape for `ListDeviceResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_resources`](crate::client::Client::list_device_resources).
///
/// See [`crate::client::fluent_builders::ListDeviceResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceResources {
    _private: (),
}
impl ListDeviceResources {
    /// Creates a new builder-style object to manufacture [`ListDeviceResourcesInput`](crate::input::ListDeviceResourcesInput)
    pub fn builder() -> crate::input::list_device_resources_input::Builder {
        crate::input::list_device_resources_input::Builder::default()
    }
    /// Creates a new `ListDeviceResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceResources {
    type Output = std::result::Result<
        crate::output::ListDeviceResourcesOutput,
        crate::error::ListDeviceResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_resources_error(response)
        } else {
            crate::operation_deser::parse_list_device_resources_response(response)
        }
    }
}

/// Operation shape for `ListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices`](crate::client::Client::list_devices).
///
/// See [`crate::client::fluent_builders::ListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevices {
    _private: (),
}
impl ListDevices {
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
    /// Creates a new `ListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevices {
    type Output =
        std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_error(response)
        } else {
            crate::operation_deser::parse_list_devices_response(response)
        }
    }
}

/// Operation shape for `ListExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_executions`](crate::client::Client::list_executions).
///
/// See [`crate::client::fluent_builders::ListExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExecutions {
    _private: (),
}
impl ListExecutions {
    /// Creates a new builder-style object to manufacture [`ListExecutionsInput`](crate::input::ListExecutionsInput)
    pub fn builder() -> crate::input::list_executions_input::Builder {
        crate::input::list_executions_input::Builder::default()
    }
    /// Creates a new `ListExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExecutions {
    type Output =
        std::result::Result<crate::output::ListExecutionsOutput, crate::error::ListExecutionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_executions_error(response)
        } else {
            crate::operation_deser::parse_list_executions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tasks`](crate::client::Client::list_tasks).
///
/// See [`crate::client::fluent_builders::ListTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTasks {
    _private: (),
}
impl ListTasks {
    /// Creates a new builder-style object to manufacture [`ListTasksInput`](crate::input::ListTasksInput)
    pub fn builder() -> crate::input::list_tasks_input::Builder {
        crate::input::list_tasks_input::Builder::default()
    }
    /// Creates a new `ListTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTasks {
    type Output = std::result::Result<crate::output::ListTasksOutput, crate::error::ListTasksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_tasks_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
