// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Snow Device Management
///
/// Client for invoking operations on AWS Snow Device Management. Each operation on AWS Snow Device Management is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_snowdevicemanagement::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_snowdevicemanagement::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_snowdevicemanagement::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CancelTask`](crate::client::fluent_builders::CancelTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::CancelTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::CancelTask::set_task_id): <p>The ID of the task that you are attempting to cancel. You can retrieve a task ID by using the <code>ListTasks</code> operation.</p>
    /// - On success, responds with [`CancelTaskOutput`](crate::output::CancelTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::CancelTaskOutput::task_id): <p>The ID of the task that you are attempting to cancel.</p>
    /// - On failure, responds with [`SdkError<CancelTaskError>`](crate::error::CancelTaskError)
    pub fn cancel_task(&self) -> fluent_builders::CancelTask<C, M, R> {
        fluent_builders::CancelTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTask`](crate::client::fluent_builders::CreateTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`targets(Vec<String>)`](crate::client::fluent_builders::CreateTask::targets) / [`set_targets(Option<Vec<String>>)`](crate::client::fluent_builders::CreateTask::set_targets): <p>A list of managed device IDs.</p>
    ///   - [`command(Command)`](crate::client::fluent_builders::CreateTask::command) / [`set_command(Option<Command>)`](crate::client::fluent_builders::CreateTask::set_command): <p>The task to be performed. Only one task is executed on a device at a time.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateTask::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateTask::set_description): <p>A description of the task and its targets.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateTask::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateTask::set_tags): <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTask::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTask::set_client_token): <p>A token ensuring that the action is called only once with the specified details.</p>
    /// - On success, responds with [`CreateTaskOutput`](crate::output::CreateTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::CreateTaskOutput::task_id): <p>The ID of the task that you created.</p>
    ///   - [`task_arn(Option<String>)`](crate::output::CreateTaskOutput::task_arn): <p>The Amazon Resource Name (ARN) of the task that you created.</p>
    /// - On failure, responds with [`SdkError<CreateTaskError>`](crate::error::CreateTaskError)
    pub fn create_task(&self) -> fluent_builders::CreateTask<C, M, R> {
        fluent_builders::CreateTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDevice`](crate::client::fluent_builders::DescribeDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`managed_device_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDevice::managed_device_id) / [`set_managed_device_id(Option<String>)`](crate::client::fluent_builders::DescribeDevice::set_managed_device_id): <p>The ID of the device that you are checking the information of.</p>
    /// - On success, responds with [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput) with field(s):
    ///   - [`last_reached_out_at(Option<DateTime>)`](crate::output::DescribeDeviceOutput::last_reached_out_at): <p>When the device last contacted the Amazon Web Services Cloud. Indicates that the device is online.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::DescribeDeviceOutput::last_updated_at): <p>When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache was refreshed.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeDeviceOutput::tags): <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment. </p>
    ///   - [`managed_device_id(Option<String>)`](crate::output::DescribeDeviceOutput::managed_device_id): <p>The ID of the device that you checked the information for.</p>
    ///   - [`managed_device_arn(Option<String>)`](crate::output::DescribeDeviceOutput::managed_device_arn): <p>The Amazon Resource Name (ARN) of the device.</p>
    ///   - [`device_type(Option<String>)`](crate::output::DescribeDeviceOutput::device_type): <p>The type of Amazon Web Services Snow Family device.</p>
    ///   - [`associated_with_job(Option<String>)`](crate::output::DescribeDeviceOutput::associated_with_job): <p>The ID of the job used when ordering the device.</p>
    ///   - [`device_state(Option<UnlockState>)`](crate::output::DescribeDeviceOutput::device_state): <p>The current state of the device.</p>
    ///   - [`physical_network_interfaces(Option<Vec<PhysicalNetworkInterface>>)`](crate::output::DescribeDeviceOutput::physical_network_interfaces): <p>The network interfaces available on the device.</p>
    ///   - [`device_capacities(Option<Vec<Capacity>>)`](crate::output::DescribeDeviceOutput::device_capacities): <p>The hardware specifications of the device. </p>
    ///   - [`software(Option<SoftwareInformation>)`](crate::output::DescribeDeviceOutput::software): <p>The software installed on the device.</p>
    /// - On failure, responds with [`SdkError<DescribeDeviceError>`](crate::error::DescribeDeviceError)
    pub fn describe_device(&self) -> fluent_builders::DescribeDevice<C, M, R> {
        fluent_builders::DescribeDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDeviceEc2Instances`](crate::client::fluent_builders::DescribeDeviceEc2Instances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`managed_device_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDeviceEc2Instances::managed_device_id) / [`set_managed_device_id(Option<String>)`](crate::client::fluent_builders::DescribeDeviceEc2Instances::set_managed_device_id): <p>The ID of the managed device.</p>
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::DescribeDeviceEc2Instances::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDeviceEc2Instances::set_instance_ids): <p>A list of instance IDs associated with the managed device.</p>
    /// - On success, responds with [`DescribeDeviceEc2InstancesOutput`](crate::output::DescribeDeviceEc2InstancesOutput) with field(s):
    ///   - [`instances(Option<Vec<InstanceSummary>>)`](crate::output::DescribeDeviceEc2InstancesOutput::instances): <p>A list of structures containing information about each instance. </p>
    /// - On failure, responds with [`SdkError<DescribeDeviceEc2InstancesError>`](crate::error::DescribeDeviceEc2InstancesError)
    pub fn describe_device_ec2_instances(
        &self,
    ) -> fluent_builders::DescribeDeviceEc2Instances<C, M, R> {
        fluent_builders::DescribeDeviceEc2Instances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExecution`](crate::client::fluent_builders::DescribeExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeExecution::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeExecution::set_task_id): <p>The ID of the task that the action is describing.</p>
    ///   - [`managed_device_id(impl Into<String>)`](crate::client::fluent_builders::DescribeExecution::managed_device_id) / [`set_managed_device_id(Option<String>)`](crate::client::fluent_builders::DescribeExecution::set_managed_device_id): <p>The ID of the managed device.</p>
    /// - On success, responds with [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::DescribeExecutionOutput::task_id): <p>The ID of the task being executed on the device.</p>
    ///   - [`execution_id(Option<String>)`](crate::output::DescribeExecutionOutput::execution_id): <p>The ID of the execution.</p>
    ///   - [`managed_device_id(Option<String>)`](crate::output::DescribeExecutionOutput::managed_device_id): <p>The ID of the managed device that the task is being executed on.</p>
    ///   - [`state(Option<ExecutionState>)`](crate::output::DescribeExecutionOutput::state): <p>The current state of the execution.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::DescribeExecutionOutput::started_at): <p>When the execution began.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::DescribeExecutionOutput::last_updated_at): <p>When the status of the execution was last updated.</p>
    /// - On failure, responds with [`SdkError<DescribeExecutionError>`](crate::error::DescribeExecutionError)
    pub fn describe_execution(&self) -> fluent_builders::DescribeExecution<C, M, R> {
        fluent_builders::DescribeExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTask`](crate::client::fluent_builders::DescribeTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeTask::set_task_id): <p>The ID of the task to be described.</p>
    /// - On success, responds with [`DescribeTaskOutput`](crate::output::DescribeTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::DescribeTaskOutput::task_id): <p>The ID of the task.</p>
    ///   - [`task_arn(Option<String>)`](crate::output::DescribeTaskOutput::task_arn): <p>The Amazon Resource Name (ARN) of the task.</p>
    ///   - [`targets(Option<Vec<String>>)`](crate::output::DescribeTaskOutput::targets): <p>The managed devices that the task was sent to.</p>
    ///   - [`state(Option<TaskState>)`](crate::output::DescribeTaskOutput::state): <p>The current state of the task.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DescribeTaskOutput::created_at): <p>When the <code>CreateTask</code> operation was called.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::DescribeTaskOutput::last_updated_at): <p>When the state of the task was last updated.</p>
    ///   - [`completed_at(Option<DateTime>)`](crate::output::DescribeTaskOutput::completed_at): <p>When the task was completed.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeTaskOutput::description): <p>The description provided of the task and managed devices.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeTaskOutput::tags): <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment.</p>
    /// - On failure, responds with [`SdkError<DescribeTaskError>`](crate::error::DescribeTaskError)
    pub fn describe_task(&self) -> fluent_builders::DescribeTask<C, M, R> {
        fluent_builders::DescribeTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeviceResources`](crate::client::fluent_builders::ListDeviceResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeviceResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`managed_device_id(impl Into<String>)`](crate::client::fluent_builders::ListDeviceResources::managed_device_id) / [`set_managed_device_id(Option<String>)`](crate::client::fluent_builders::ListDeviceResources::set_managed_device_id): <p>The ID of the managed device that you are listing the resources of.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::ListDeviceResources::r#type) / [`set_type(Option<String>)`](crate::client::fluent_builders::ListDeviceResources::set_type): <p>A structure used to filter the results by type of resource.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDeviceResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDeviceResources::set_max_results): <p>The maximum number of resources per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeviceResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeviceResources::set_next_token): <p>A pagination token to continue to the next page of results.</p>
    /// - On success, responds with [`ListDeviceResourcesOutput`](crate::output::ListDeviceResourcesOutput) with field(s):
    ///   - [`resources(Option<Vec<ResourceSummary>>)`](crate::output::ListDeviceResourcesOutput::resources): <p>A structure defining the resource's type, Amazon Resource Name (ARN), and ID.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeviceResourcesOutput::next_token): <p>A pagination token to continue to the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListDeviceResourcesError>`](crate::error::ListDeviceResourcesError)
    pub fn list_device_resources(&self) -> fluent_builders::ListDeviceResources<C, M, R> {
        fluent_builders::ListDeviceResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDevices`](crate::client::fluent_builders::ListDevices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDevices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::ListDevices::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::ListDevices::set_job_id): <p>The ID of the job used to order the device.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDevices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDevices::set_max_results): <p>The maximum number of devices to list per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDevices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDevices::set_next_token): <p>A pagination token to continue to the next page of results.</p>
    /// - On success, responds with [`ListDevicesOutput`](crate::output::ListDevicesOutput) with field(s):
    ///   - [`devices(Option<Vec<DeviceSummary>>)`](crate::output::ListDevicesOutput::devices): <p>A list of device structures that contain information about the device.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDevicesOutput::next_token): <p>A pagination token to continue to the next page of devices.</p>
    /// - On failure, responds with [`SdkError<ListDevicesError>`](crate::error::ListDevicesError)
    pub fn list_devices(&self) -> fluent_builders::ListDevices<C, M, R> {
        fluent_builders::ListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExecutions`](crate::client::fluent_builders::ListExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::ListExecutions::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::ListExecutions::set_task_id): <p>The ID of the task.</p>
    ///   - [`state(ExecutionState)`](crate::client::fluent_builders::ListExecutions::state) / [`set_state(Option<ExecutionState>)`](crate::client::fluent_builders::ListExecutions::set_state): <p>A structure used to filter the tasks by their current state.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExecutions::set_max_results): <p>The maximum number of tasks to list per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExecutions::set_next_token): <p>A pagination token to continue to the next page of tasks.</p>
    /// - On success, responds with [`ListExecutionsOutput`](crate::output::ListExecutionsOutput) with field(s):
    ///   - [`executions(Option<Vec<ExecutionSummary>>)`](crate::output::ListExecutionsOutput::executions): <p>A list of executions. Each execution contains the task ID, the device that the task is executing on, the execution ID, and the status of the execution.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExecutionsOutput::next_token): <p>A pagination token to continue to the next page of executions.</p>
    /// - On failure, responds with [`SdkError<ListExecutionsError>`](crate::error::ListExecutionsError)
    pub fn list_executions(&self) -> fluent_builders::ListExecutions<C, M, R> {
        fluent_builders::ListExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the device or task.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tags for the device or task.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTasks`](crate::client::fluent_builders::ListTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`state(TaskState)`](crate::client::fluent_builders::ListTasks::state) / [`set_state(Option<TaskState>)`](crate::client::fluent_builders::ListTasks::set_state): <p>A structure used to filter the list of tasks.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTasks::set_max_results): <p>The maximum number of tasks per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTasks::set_next_token): <p>A pagination token to continue to the next page of tasks.</p>
    /// - On success, responds with [`ListTasksOutput`](crate::output::ListTasksOutput) with field(s):
    ///   - [`tasks(Option<Vec<TaskSummary>>)`](crate::output::ListTasksOutput::tasks): <p>A list of task structures containing details about each task.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTasksOutput::next_token): <p>A pagination token to continue to the next page of tasks.</p>
    /// - On failure, responds with [`SdkError<ListTasksError>`](crate::error::ListTasksError)
    pub fn list_tasks(&self) -> fluent_builders::ListTasks<C, M, R> {
        fluent_builders::ListTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the device or task.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the device or task.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelTask`.
    ///
    /// <p>Sends a cancel request for a specified task. You can cancel a task only if it's still in a <code>QUEUED</code> state. Tasks that are already running can't be cancelled.</p> <note>
    /// <p>A task might still run if it's processed from the queue before the <code>CancelTask</code> operation changes the task's state.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_task_input::Builder,
    }
    impl<C, M, R> CancelTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelTaskInputOperationOutputAlias,
                crate::output::CancelTaskOutput,
                crate::error::CancelTaskError,
                crate::input::CancelTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the task that you are attempting to cancel. You can retrieve a task ID by using the <code>ListTasks</code> operation.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the task that you are attempting to cancel. You can retrieve a task ID by using the <code>ListTasks</code> operation.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTask`.
    ///
    /// <p>Instructs one or more devices to start a task, such as unlocking or rebooting.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_task_input::Builder,
    }
    impl<C, M, R> CreateTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTaskInputOperationOutputAlias,
                crate::output::CreateTaskOutput,
                crate::error::CreateTaskError,
                crate::input::CreateTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>A list of managed device IDs.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.targets(input.into());
            self
        }
        /// <p>A list of managed device IDs.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>The task to be performed. Only one task is executed on a device at a time.</p>
        pub fn command(mut self, input: crate::model::Command) -> Self {
            self.inner = self.inner.command(input);
            self
        }
        /// <p>The task to be performed. Only one task is executed on a device at a time.</p>
        pub fn set_command(mut self, input: std::option::Option<crate::model::Command>) -> Self {
            self.inner = self.inner.set_command(input);
            self
        }
        /// <p>A description of the task and its targets.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the task and its targets.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A token ensuring that the action is called only once with the specified details.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDevice`.
    ///
    /// <p>Checks device-specific information, such as the device type, software version, IP addresses, and lock status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_input::Builder,
    }
    impl<C, M, R> DescribeDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeviceInputOperationOutputAlias,
                crate::output::DescribeDeviceOutput,
                crate::error::DescribeDeviceError,
                crate::input::DescribeDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the device that you are checking the information of.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_device_id(input.into());
            self
        }
        /// <p>The ID of the device that you are checking the information of.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDeviceEc2Instances`.
    ///
    /// <p>Checks the current state of the Amazon EC2 instances. The output is similar to <code>describeDevice</code>, but the results are sourced from the device cache in the Amazon Web Services Cloud and include a subset of the available fields. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDeviceEc2Instances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_ec2_instances_input::Builder,
    }
    impl<C, M, R> DescribeDeviceEc2Instances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDeviceEc2Instances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceEc2InstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceEc2InstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeviceEc2InstancesInputOperationOutputAlias,
                crate::output::DescribeDeviceEc2InstancesOutput,
                crate::error::DescribeDeviceEc2InstancesError,
                crate::input::DescribeDeviceEc2InstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the managed device.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_device_id(input.into());
            self
        }
        /// <p>The ID of the managed device.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_device_id(input);
            self
        }
        /// Appends an item to `instanceIds`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>A list of instance IDs associated with the managed device.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_ids(input.into());
            self
        }
        /// <p>A list of instance IDs associated with the managed device.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExecution`.
    ///
    /// <p>Checks the status of a remote task running on one or more target devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_execution_input::Builder,
    }
    impl<C, M, R> DescribeExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExecutionInputOperationOutputAlias,
                crate::output::DescribeExecutionOutput,
                crate::error::DescribeExecutionError,
                crate::input::DescribeExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the task that the action is describing.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the task that the action is describing.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>The ID of the managed device.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_device_id(input.into());
            self
        }
        /// <p>The ID of the managed device.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTask`.
    ///
    /// <p>Checks the metadata for a given task on a device. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_task_input::Builder,
    }
    impl<C, M, R> DescribeTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTaskInputOperationOutputAlias,
                crate::output::DescribeTaskOutput,
                crate::error::DescribeTaskError,
                crate::input::DescribeTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the task to be described.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the task to be described.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeviceResources`.
    ///
    /// <p>Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are the only supported resource type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeviceResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_resources_input::Builder,
    }
    impl<C, M, R> ListDeviceResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeviceResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeviceResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeviceResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeviceResourcesInputOperationOutputAlias,
                crate::output::ListDeviceResourcesOutput,
                crate::error::ListDeviceResourcesError,
                crate::input::ListDeviceResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeviceResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeviceResourcesPaginator<C, M, R> {
            crate::paginator::ListDeviceResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the managed device that you are listing the resources of.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_device_id(input.into());
            self
        }
        /// <p>The ID of the managed device that you are listing the resources of.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_managed_device_id(input);
            self
        }
        /// <p>A structure used to filter the results by type of resource.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.r#type(input.into());
            self
        }
        /// <p>A structure used to filter the results by type of resource.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The maximum number of resources per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of resources per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevices`.
    ///
    /// <p>Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device Management enabled in the Amazon Web Services Region where the command is run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_devices_input::Builder,
    }
    impl<C, M, R> ListDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicesInputOperationOutputAlias,
                crate::output::ListDevicesOutput,
                crate::error::ListDevicesError,
                crate::input::ListDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDevicesPaginator<C, M, R> {
            crate::paginator::ListDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the job used to order the device.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job used to order the device.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of devices to list per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of devices to list per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExecutions`.
    ///
    /// <p>Returns the status of tasks for one or more target devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_executions_input::Builder,
    }
    impl<C, M, R> ListExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListExecutionsInputOperationOutputAlias,
                crate::output::ListExecutionsOutput,
                crate::error::ListExecutionsError,
                crate::input::ListExecutionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExecutionsPaginator<C, M, R> {
            crate::paginator::ListExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>A structure used to filter the tasks by their current state.</p>
        pub fn state(mut self, input: crate::model::ExecutionState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>A structure used to filter the tasks by their current state.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ExecutionState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The maximum number of tasks to list per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tasks to list per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token to continue to the next page of tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags for a managed device or task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the device or task.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device or task.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTasks`.
    ///
    /// <p>Returns a list of tasks that can be filtered by state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tasks_input::Builder,
    }
    impl<C, M, R> ListTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTasksInputOperationOutputAlias,
                crate::output::ListTasksOutput,
                crate::error::ListTasksError,
                crate::input::ListTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTasksPaginator<C, M, R> {
            crate::paginator::ListTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>A structure used to filter the list of tasks.</p>
        pub fn state(mut self, input: crate::model::TaskState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>A structure used to filter the list of tasks.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::TaskState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The maximum number of tasks per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tasks per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token to continue to the next page of tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or replaces tags on a device or task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the device or task.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device or task.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from a device or task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the device or task.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device or task.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource in different ways, such as by purpose, owner, or environment.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
