// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about the task assigned to one or many devices.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskSummary {
    /// <p>The task ID.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The state of the task assigned to one or many devices.</p>
    pub state: std::option::Option<crate::model::TaskState>,
    /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
    /// in different ways, such as by purpose, owner, or environment.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TaskSummary {
    /// <p>The task ID.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
    /// <p>The state of the task assigned to one or many devices.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::TaskState> {
        self.state.as_ref()
    }
    /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
    /// in different ways, such as by purpose, owner, or environment.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TaskSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskSummary");
        formatter.field("task_id", &self.task_id);
        formatter.field("task_arn", &self.task_arn);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TaskSummary`](crate::model::TaskSummary)
pub mod task_summary {
    /// A builder for [`TaskSummary`](crate::model::TaskSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::TaskState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The task ID.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The task ID.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The state of the task assigned to one or many devices.</p>
        pub fn state(mut self, input: crate::model::TaskState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the task assigned to one or many devices.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::TaskState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskSummary`](crate::model::TaskSummary)
        pub fn build(self) -> crate::model::TaskSummary {
            crate::model::TaskSummary {
                task_id: self.task_id,
                task_arn: self.task_arn,
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl TaskSummary {
    /// Creates a new builder-style object to manufacture [`TaskSummary`](crate::model::TaskSummary)
    pub fn builder() -> crate::model::task_summary::Builder {
        crate::model::task_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskState {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => TaskState::Canceled,
            "COMPLETED" => TaskState::Completed,
            "IN_PROGRESS" => TaskState::InProgress,
            other => TaskState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskState::from(s))
    }
}
impl TaskState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskState::Canceled => "CANCELED",
            TaskState::Completed => "COMPLETED",
            TaskState::InProgress => "IN_PROGRESS",
            TaskState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELED", "COMPLETED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for TaskState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The command given to the device to execute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Command {
    /// <p>Reboots the device.</p>
    Reboot(crate::model::Reboot),
    /// <p>Unlocks the device.</p>
    Unlock(crate::model::Unlock),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Command {
    /// Tries to convert the enum instance into [`Reboot`](crate::model::Command::Reboot), extracting the inner [`Reboot`](crate::model::Reboot).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_reboot(&self) -> std::result::Result<&crate::model::Reboot, &Self> {
        if let Command::Reboot(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Reboot`](crate::model::Command::Reboot).
    pub fn is_reboot(&self) -> bool {
        self.as_reboot().is_ok()
    }
    /// Tries to convert the enum instance into [`Unlock`](crate::model::Command::Unlock), extracting the inner [`Unlock`](crate::model::Unlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_unlock(&self) -> std::result::Result<&crate::model::Unlock, &Self> {
        if let Command::Unlock(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`Unlock`](crate::model::Command::Unlock).
    pub fn is_unlock(&self) -> bool {
        self.as_unlock().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A structure used to reboot the device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Reboot {}
impl std::fmt::Debug for Reboot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Reboot");
        formatter.finish()
    }
}
/// See [`Reboot`](crate::model::Reboot)
pub mod reboot {
    /// A builder for [`Reboot`](crate::model::Reboot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Reboot`](crate::model::Reboot)
        pub fn build(self) -> crate::model::Reboot {
            crate::model::Reboot {}
        }
    }
}
impl Reboot {
    /// Creates a new builder-style object to manufacture [`Reboot`](crate::model::Reboot)
    pub fn builder() -> crate::model::reboot::Builder {
        crate::model::reboot::Builder::default()
    }
}

/// <p>A structure used to unlock a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Unlock {}
impl std::fmt::Debug for Unlock {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Unlock");
        formatter.finish()
    }
}
/// See [`Unlock`](crate::model::Unlock)
pub mod unlock {
    /// A builder for [`Unlock`](crate::model::Unlock)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Unlock`](crate::model::Unlock)
        pub fn build(self) -> crate::model::Unlock {
            crate::model::Unlock {}
        }
    }
}
impl Unlock {
    /// Creates a new builder-style object to manufacture [`Unlock`](crate::model::Unlock)
    pub fn builder() -> crate::model::unlock::Builder {
        crate::model::unlock::Builder::default()
    }
}

/// <p>The summary of a task execution on a specified device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionSummary {
    /// <p>The ID of the task.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The ID of the execution.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>The ID of the managed device that the task is being executed on.</p>
    pub managed_device_id: std::option::Option<std::string::String>,
    /// <p>The state of the execution.</p>
    pub state: std::option::Option<crate::model::ExecutionState>,
}
impl ExecutionSummary {
    /// <p>The ID of the task.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The ID of the execution.</p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p>The ID of the managed device that the task is being executed on.</p>
    pub fn managed_device_id(&self) -> std::option::Option<&str> {
        self.managed_device_id.as_deref()
    }
    /// <p>The state of the execution.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ExecutionState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ExecutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionSummary");
        formatter.field("task_id", &self.task_id);
        formatter.field("execution_id", &self.execution_id);
        formatter.field("managed_device_id", &self.managed_device_id);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ExecutionSummary`](crate::model::ExecutionSummary)
pub mod execution_summary {
    /// A builder for [`ExecutionSummary`](crate::model::ExecutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) managed_device_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ExecutionState>,
    }
    impl Builder {
        /// <p>The ID of the task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The ID of the execution.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the execution.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>The ID of the managed device that the task is being executed on.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the managed device that the task is being executed on.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_device_id = input;
            self
        }
        /// <p>The state of the execution.</p>
        pub fn state(mut self, input: crate::model::ExecutionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the execution.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ExecutionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionSummary`](crate::model::ExecutionSummary)
        pub fn build(self) -> crate::model::ExecutionSummary {
            crate::model::ExecutionSummary {
                task_id: self.task_id,
                execution_id: self.execution_id,
                managed_device_id: self.managed_device_id,
                state: self.state,
            }
        }
    }
}
impl ExecutionSummary {
    /// Creates a new builder-style object to manufacture [`ExecutionSummary`](crate::model::ExecutionSummary)
    pub fn builder() -> crate::model::execution_summary::Builder {
        crate::model::execution_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionState {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => ExecutionState::Canceled,
            "FAILED" => ExecutionState::Failed,
            "IN_PROGRESS" => ExecutionState::InProgress,
            "QUEUED" => ExecutionState::Queued,
            "REJECTED" => ExecutionState::Rejected,
            "SUCCEEDED" => ExecutionState::Succeeded,
            "TIMED_OUT" => ExecutionState::TimedOut,
            other => ExecutionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionState::from(s))
    }
}
impl ExecutionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionState::Canceled => "CANCELED",
            ExecutionState::Failed => "FAILED",
            ExecutionState::InProgress => "IN_PROGRESS",
            ExecutionState::Queued => "QUEUED",
            ExecutionState::Rejected => "REJECTED",
            ExecutionState::Succeeded => "SUCCEEDED",
            ExecutionState::TimedOut => "TIMED_OUT",
            ExecutionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "FAILED",
            "IN_PROGRESS",
            "QUEUED",
            "REJECTED",
            "SUCCEEDED",
            "TIMED_OUT",
        ]
    }
}
impl AsRef<str> for ExecutionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of a resource available on the device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSummary {
    /// <p>The resource type.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub id: std::option::Option<std::string::String>,
}
impl ResourceSummary {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ResourceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSummary");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`ResourceSummary`](crate::model::ResourceSummary)
pub mod resource_summary {
    /// A builder for [`ResourceSummary`](crate::model::ResourceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSummary`](crate::model::ResourceSummary)
        pub fn build(self) -> crate::model::ResourceSummary {
            crate::model::ResourceSummary {
                resource_type: self.resource_type,
                arn: self.arn,
                id: self.id,
            }
        }
    }
}
impl ResourceSummary {
    /// Creates a new builder-style object to manufacture [`ResourceSummary`](crate::model::ResourceSummary)
    pub fn builder() -> crate::model::resource_summary::Builder {
        crate::model::resource_summary::Builder::default()
    }
}

/// <p>The details about the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceSummary {
    /// <p>A structure containing details about the instance.</p>
    pub instance: std::option::Option<crate::model::Instance>,
    /// <p>When the instance summary was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl InstanceSummary {
    /// <p>A structure containing details about the instance.</p>
    pub fn instance(&self) -> std::option::Option<&crate::model::Instance> {
        self.instance.as_ref()
    }
    /// <p>When the instance summary was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for InstanceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceSummary");
        formatter.field("instance", &self.instance);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`InstanceSummary`](crate::model::InstanceSummary)
pub mod instance_summary {
    /// A builder for [`InstanceSummary`](crate::model::InstanceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance: std::option::Option<crate::model::Instance>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A structure containing details about the instance.</p>
        pub fn instance(mut self, input: crate::model::Instance) -> Self {
            self.instance = Some(input);
            self
        }
        /// <p>A structure containing details about the instance.</p>
        pub fn set_instance(mut self, input: std::option::Option<crate::model::Instance>) -> Self {
            self.instance = input;
            self
        }
        /// <p>When the instance summary was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>When the instance summary was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceSummary`](crate::model::InstanceSummary)
        pub fn build(self) -> crate::model::InstanceSummary {
            crate::model::InstanceSummary {
                instance: self.instance,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl InstanceSummary {
    /// Creates a new builder-style object to manufacture [`InstanceSummary`](crate::model::InstanceSummary)
    pub fn builder() -> crate::model::instance_summary::Builder {
        crate::model::instance_summary::Builder::default()
    }
}

/// <p>The description of an
/// instance.
/// Currently, Amazon EC2 instances are the only supported instance type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The ID of the AMI used to launch the instance.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Machine Image (AMI) launch index, which you can use to find this instance in
    /// the launch group. </p>
    pub ami_launch_index: std::option::Option<i32>,
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The description of the current state of an instance.</p>
    pub state: std::option::Option<crate::model::InstanceState>,
    /// <p>The instance type.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The private IPv4 address assigned to the instance.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The public IPv4 address assigned to the instance.</p>
    pub public_ip_address: std::option::Option<std::string::String>,
    /// <p>When the instance was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When the instance was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Any block device mapping entries for the instance.</p>
    pub block_device_mappings:
        std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
    /// <p>The security groups for the instance.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroupIdentifier>>,
    /// <p>The CPU options for the instance.</p>
    pub cpu_options: std::option::Option<crate::model::CpuOptions>,
    /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>). </p>
    pub root_device_name: std::option::Option<std::string::String>,
}
impl Instance {
    /// <p>The ID of the AMI used to launch the instance.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The Amazon Machine Image (AMI) launch index, which you can use to find this instance in
    /// the launch group. </p>
    pub fn ami_launch_index(&self) -> std::option::Option<i32> {
        self.ami_launch_index
    }
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The description of the current state of an instance.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::InstanceState> {
        self.state.as_ref()
    }
    /// <p>The instance type.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The private IPv4 address assigned to the instance.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>The public IPv4 address assigned to the instance.</p>
    pub fn public_ip_address(&self) -> std::option::Option<&str> {
        self.public_ip_address.as_deref()
    }
    /// <p>When the instance was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>When the instance was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_at.as_ref()
    }
    /// <p>Any block device mapping entries for the instance.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceBlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>The security groups for the instance.</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::SecurityGroupIdentifier]> {
        self.security_groups.as_deref()
    }
    /// <p>The CPU options for the instance.</p>
    pub fn cpu_options(&self) -> std::option::Option<&crate::model::CpuOptions> {
        self.cpu_options.as_ref()
    }
    /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>). </p>
    pub fn root_device_name(&self) -> std::option::Option<&str> {
        self.root_device_name.as_deref()
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("image_id", &self.image_id);
        formatter.field("ami_launch_index", &self.ami_launch_index);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("state", &self.state);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("public_ip_address", &self.public_ip_address);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("cpu_options", &self.cpu_options);
        formatter.field("root_device_name", &self.root_device_name);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) ami_launch_index: std::option::Option<i32>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::InstanceState>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) public_ip_address: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        pub(crate) security_groups:
            std::option::Option<std::vec::Vec<crate::model::SecurityGroupIdentifier>>,
        pub(crate) cpu_options: std::option::Option<crate::model::CpuOptions>,
        pub(crate) root_device_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the AMI used to launch the instance.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI used to launch the instance.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The Amazon Machine Image (AMI) launch index, which you can use to find this instance in
        /// the launch group. </p>
        pub fn ami_launch_index(mut self, input: i32) -> Self {
            self.ami_launch_index = Some(input);
            self
        }
        /// <p>The Amazon Machine Image (AMI) launch index, which you can use to find this instance in
        /// the launch group. </p>
        pub fn set_ami_launch_index(mut self, input: std::option::Option<i32>) -> Self {
            self.ami_launch_index = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The description of the current state of an instance.</p>
        pub fn state(mut self, input: crate::model::InstanceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The description of the current state of an instance.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The instance type.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The private IPv4 address assigned to the instance.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IPv4 address assigned to the instance.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// <p>The public IPv4 address assigned to the instance.</p>
        pub fn public_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip_address = Some(input.into());
            self
        }
        /// <p>The public IPv4 address assigned to the instance.</p>
        pub fn set_public_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_ip_address = input;
            self
        }
        /// <p>When the instance was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>When the instance was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>When the instance was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>When the instance was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>Any block device mapping entries for the instance.</p>
        pub fn block_device_mappings(
            mut self,
            input: impl Into<crate::model::InstanceBlockDeviceMapping>,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input.into());
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>Any block device mapping entries for the instance.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups for the instance.</p>
        pub fn security_groups(
            mut self,
            input: impl Into<crate::model::SecurityGroupIdentifier>,
        ) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups for the instance.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityGroupIdentifier>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The CPU options for the instance.</p>
        pub fn cpu_options(mut self, input: crate::model::CpuOptions) -> Self {
            self.cpu_options = Some(input);
            self
        }
        /// <p>The CPU options for the instance.</p>
        pub fn set_cpu_options(
            mut self,
            input: std::option::Option<crate::model::CpuOptions>,
        ) -> Self {
            self.cpu_options = input;
            self
        }
        /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>). </p>
        pub fn root_device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_device_name = Some(input.into());
            self
        }
        /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>). </p>
        pub fn set_root_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_device_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                image_id: self.image_id,
                ami_launch_index: self.ami_launch_index,
                instance_id: self.instance_id,
                state: self.state,
                instance_type: self.instance_type,
                private_ip_address: self.private_ip_address,
                public_ip_address: self.public_ip_address,
                created_at: self.created_at,
                updated_at: self.updated_at,
                block_device_mappings: self.block_device_mappings,
                security_groups: self.security_groups,
                cpu_options: self.cpu_options,
                root_device_name: self.root_device_name,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>The options for how a device's CPU is configured.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CpuOptions {
    /// <p>The number of cores that the CPU can use.</p>
    pub core_count: std::option::Option<i32>,
    /// <p>The number of threads per core in the CPU.</p>
    pub threads_per_core: std::option::Option<i32>,
}
impl CpuOptions {
    /// <p>The number of cores that the CPU can use.</p>
    pub fn core_count(&self) -> std::option::Option<i32> {
        self.core_count
    }
    /// <p>The number of threads per core in the CPU.</p>
    pub fn threads_per_core(&self) -> std::option::Option<i32> {
        self.threads_per_core
    }
}
impl std::fmt::Debug for CpuOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CpuOptions");
        formatter.field("core_count", &self.core_count);
        formatter.field("threads_per_core", &self.threads_per_core);
        formatter.finish()
    }
}
/// See [`CpuOptions`](crate::model::CpuOptions)
pub mod cpu_options {
    /// A builder for [`CpuOptions`](crate::model::CpuOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_count: std::option::Option<i32>,
        pub(crate) threads_per_core: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of cores that the CPU can use.</p>
        pub fn core_count(mut self, input: i32) -> Self {
            self.core_count = Some(input);
            self
        }
        /// <p>The number of cores that the CPU can use.</p>
        pub fn set_core_count(mut self, input: std::option::Option<i32>) -> Self {
            self.core_count = input;
            self
        }
        /// <p>The number of threads per core in the CPU.</p>
        pub fn threads_per_core(mut self, input: i32) -> Self {
            self.threads_per_core = Some(input);
            self
        }
        /// <p>The number of threads per core in the CPU.</p>
        pub fn set_threads_per_core(mut self, input: std::option::Option<i32>) -> Self {
            self.threads_per_core = input;
            self
        }
        /// Consumes the builder and constructs a [`CpuOptions`](crate::model::CpuOptions)
        pub fn build(self) -> crate::model::CpuOptions {
            crate::model::CpuOptions {
                core_count: self.core_count,
                threads_per_core: self.threads_per_core,
            }
        }
    }
}
impl CpuOptions {
    /// Creates a new builder-style object to manufacture [`CpuOptions`](crate::model::CpuOptions)
    pub fn builder() -> crate::model::cpu_options::Builder {
        crate::model::cpu_options::Builder::default()
    }
}

/// <p>Information about the device's security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupIdentifier {
    /// <p>The security group ID.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The security group name.</p>
    pub group_name: std::option::Option<std::string::String>,
}
impl SecurityGroupIdentifier {
    /// <p>The security group ID.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The security group name.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroupIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupIdentifier");
        formatter.field("group_id", &self.group_id);
        formatter.field("group_name", &self.group_name);
        formatter.finish()
    }
}
/// See [`SecurityGroupIdentifier`](crate::model::SecurityGroupIdentifier)
pub mod security_group_identifier {
    /// A builder for [`SecurityGroupIdentifier`](crate::model::SecurityGroupIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The security group ID.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The security group ID.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The security group name.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The security group name.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupIdentifier`](crate::model::SecurityGroupIdentifier)
        pub fn build(self) -> crate::model::SecurityGroupIdentifier {
            crate::model::SecurityGroupIdentifier {
                group_id: self.group_id,
                group_name: self.group_name,
            }
        }
    }
}
impl SecurityGroupIdentifier {
    /// Creates a new builder-style object to manufacture [`SecurityGroupIdentifier`](crate::model::SecurityGroupIdentifier)
    pub fn builder() -> crate::model::security_group_identifier::Builder {
        crate::model::security_group_identifier::Builder::default()
    }
}

/// <p>The description of a block device mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceBlockDeviceMapping {
    /// <p>The block device name.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS)
    /// volumes when the instance is launched. </p>
    pub ebs: std::option::Option<crate::model::EbsInstanceBlockDevice>,
}
impl InstanceBlockDeviceMapping {
    /// <p>The block device name.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS)
    /// volumes when the instance is launched. </p>
    pub fn ebs(&self) -> std::option::Option<&crate::model::EbsInstanceBlockDevice> {
        self.ebs.as_ref()
    }
}
impl std::fmt::Debug for InstanceBlockDeviceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceBlockDeviceMapping");
        formatter.field("device_name", &self.device_name);
        formatter.field("ebs", &self.ebs);
        formatter.finish()
    }
}
/// See [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
pub mod instance_block_device_mapping {
    /// A builder for [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<crate::model::EbsInstanceBlockDevice>,
    }
    impl Builder {
        /// <p>The block device name.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The block device name.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS)
        /// volumes when the instance is launched. </p>
        pub fn ebs(mut self, input: crate::model::EbsInstanceBlockDevice) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>The parameters used to automatically set up Amazon Elastic Block Store (Amazon EBS)
        /// volumes when the instance is launched. </p>
        pub fn set_ebs(
            mut self,
            input: std::option::Option<crate::model::EbsInstanceBlockDevice>,
        ) -> Self {
            self.ebs = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
        pub fn build(self) -> crate::model::InstanceBlockDeviceMapping {
            crate::model::InstanceBlockDeviceMapping {
                device_name: self.device_name,
                ebs: self.ebs,
            }
        }
    }
}
impl InstanceBlockDeviceMapping {
    /// Creates a new builder-style object to manufacture [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
    pub fn builder() -> crate::model::instance_block_device_mapping::Builder {
        crate::model::instance_block_device_mapping::Builder::default()
    }
}

/// <p>Describes a parameter used to set up an Amazon Elastic Block Store (Amazon EBS) volume
/// in a block device mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsInstanceBlockDevice {
    /// <p>When the attachment was initiated.</p>
    pub attach_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A value that indicates whether the volume is deleted on instance termination.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>The attachment state.</p>
    pub status: std::option::Option<crate::model::AttachmentStatus>,
    /// <p>The ID of the Amazon EBS volume.</p>
    pub volume_id: std::option::Option<std::string::String>,
}
impl EbsInstanceBlockDevice {
    /// <p>When the attachment was initiated.</p>
    pub fn attach_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.attach_time.as_ref()
    }
    /// <p>A value that indicates whether the volume is deleted on instance termination.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>The attachment state.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AttachmentStatus> {
        self.status.as_ref()
    }
    /// <p>The ID of the Amazon EBS volume.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
}
impl std::fmt::Debug for EbsInstanceBlockDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsInstanceBlockDevice");
        formatter.field("attach_time", &self.attach_time);
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("status", &self.status);
        formatter.field("volume_id", &self.volume_id);
        formatter.finish()
    }
}
/// See [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
pub mod ebs_instance_block_device {
    /// A builder for [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attach_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::AttachmentStatus>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When the attachment was initiated.</p>
        pub fn attach_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.attach_time = Some(input);
            self
        }
        /// <p>When the attachment was initiated.</p>
        pub fn set_attach_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.attach_time = input;
            self
        }
        /// <p>A value that indicates whether the volume is deleted on instance termination.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>A value that indicates whether the volume is deleted on instance termination.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>The attachment state.</p>
        pub fn status(mut self, input: crate::model::AttachmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The attachment state.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AttachmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the Amazon EBS volume.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EBS volume.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
        pub fn build(self) -> crate::model::EbsInstanceBlockDevice {
            crate::model::EbsInstanceBlockDevice {
                attach_time: self.attach_time,
                delete_on_termination: self.delete_on_termination,
                status: self.status,
                volume_id: self.volume_id,
            }
        }
    }
}
impl EbsInstanceBlockDevice {
    /// Creates a new builder-style object to manufacture [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
    pub fn builder() -> crate::model::ebs_instance_block_device::Builder {
        crate::model::ebs_instance_block_device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttachmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Attached,
    #[allow(missing_docs)] // documentation missing in model
    Attaching,
    #[allow(missing_docs)] // documentation missing in model
    Detached,
    #[allow(missing_docs)] // documentation missing in model
    Detaching,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttachmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "ATTACHED" => AttachmentStatus::Attached,
            "ATTACHING" => AttachmentStatus::Attaching,
            "DETACHED" => AttachmentStatus::Detached,
            "DETACHING" => AttachmentStatus::Detaching,
            other => AttachmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttachmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttachmentStatus::from(s))
    }
}
impl AttachmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttachmentStatus::Attached => "ATTACHED",
            AttachmentStatus::Attaching => "ATTACHING",
            AttachmentStatus::Detached => "DETACHED",
            AttachmentStatus::Detaching => "DETACHING",
            AttachmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ATTACHED", "ATTACHING", "DETACHED", "DETACHING"]
    }
}
impl AsRef<str> for AttachmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The description of the current state of an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceState {
    /// <p>The state of the instance as a 16-bit unsigned integer. </p>
    /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values
    /// between 256 and 65,535. These numerical values are used for internal purposes and should be
    /// ignored. </p>
    /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values
    /// between 0 and 255. </p>
    /// <p>The valid values for the instance state code are all in the range of the low byte. These
    /// values are: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>0</code> : <code>pending</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>16</code> : <code>running</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>32</code> : <code>shutting-down</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>48</code> : <code>terminated</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>64</code> : <code>stopping</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>80</code> : <code>stopped</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in
    /// decimal. </p>
    pub code: std::option::Option<i32>,
    /// <p>The current
    /// state
    /// of the instance.</p>
    pub name: std::option::Option<crate::model::InstanceStateName>,
}
impl InstanceState {
    /// <p>The state of the instance as a 16-bit unsigned integer. </p>
    /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values
    /// between 256 and 65,535. These numerical values are used for internal purposes and should be
    /// ignored. </p>
    /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values
    /// between 0 and 255. </p>
    /// <p>The valid values for the instance state code are all in the range of the low byte. These
    /// values are: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>0</code> : <code>pending</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>16</code> : <code>running</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>32</code> : <code>shutting-down</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>48</code> : <code>terminated</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>64</code> : <code>stopping</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>80</code> : <code>stopped</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in
    /// decimal. </p>
    pub fn code(&self) -> std::option::Option<i32> {
        self.code
    }
    /// <p>The current
    /// state
    /// of the instance.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::InstanceStateName> {
        self.name.as_ref()
    }
}
impl std::fmt::Debug for InstanceState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceState");
        formatter.field("code", &self.code);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`InstanceState`](crate::model::InstanceState)
pub mod instance_state {
    /// A builder for [`InstanceState`](crate::model::InstanceState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<i32>,
        pub(crate) name: std::option::Option<crate::model::InstanceStateName>,
    }
    impl Builder {
        /// <p>The state of the instance as a 16-bit unsigned integer. </p>
        /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values
        /// between 256 and 65,535. These numerical values are used for internal purposes and should be
        /// ignored. </p>
        /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values
        /// between 0 and 255. </p>
        /// <p>The valid values for the instance state code are all in the range of the low byte. These
        /// values are: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>0</code> : <code>pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>16</code> : <code>running</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>32</code> : <code>shutting-down</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>48</code> : <code>terminated</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>64</code> : <code>stopping</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>80</code> : <code>stopped</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in
        /// decimal. </p>
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The state of the instance as a 16-bit unsigned integer. </p>
        /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values
        /// between 256 and 65,535. These numerical values are used for internal purposes and should be
        /// ignored. </p>
        /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values
        /// between 0 and 255. </p>
        /// <p>The valid values for the instance state code are all in the range of the low byte. These
        /// values are: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>0</code> : <code>pending</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>16</code> : <code>running</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>32</code> : <code>shutting-down</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>48</code> : <code>terminated</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>64</code> : <code>stopping</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>80</code> : <code>stopped</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in
        /// decimal. </p>
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// <p>The current
        /// state
        /// of the instance.</p>
        pub fn name(mut self, input: crate::model::InstanceStateName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The current
        /// state
        /// of the instance.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::InstanceStateName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceState`](crate::model::InstanceState)
        pub fn build(self) -> crate::model::InstanceState {
            crate::model::InstanceState {
                code: self.code,
                name: self.name,
            }
        }
    }
}
impl InstanceState {
    /// Creates a new builder-style object to manufacture [`InstanceState`](crate::model::InstanceState)
    pub fn builder() -> crate::model::instance_state::Builder {
        crate::model::instance_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStateName {
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    ShuttingDown,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStateName {
    fn from(s: &str) -> Self {
        match s {
            "PENDING" => InstanceStateName::Pending,
            "RUNNING" => InstanceStateName::Running,
            "SHUTTING_DOWN" => InstanceStateName::ShuttingDown,
            "STOPPED" => InstanceStateName::Stopped,
            "STOPPING" => InstanceStateName::Stopping,
            "TERMINATED" => InstanceStateName::Terminated,
            other => InstanceStateName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStateName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStateName::from(s))
    }
}
impl InstanceStateName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStateName::Pending => "PENDING",
            InstanceStateName::Running => "RUNNING",
            InstanceStateName::ShuttingDown => "SHUTTING_DOWN",
            InstanceStateName::Stopped => "STOPPED",
            InstanceStateName::Stopping => "STOPPING",
            InstanceStateName::Terminated => "TERMINATED",
            InstanceStateName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "PENDING",
            "RUNNING",
            "SHUTTING_DOWN",
            "STOPPED",
            "STOPPING",
            "TERMINATED",
        ]
    }
}
impl AsRef<str> for InstanceStateName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifying information about the device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceSummary {
    /// <p>The ID of the device.</p>
    pub managed_device_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub managed_device_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the job used to order the device.</p>
    pub associated_with_job: std::option::Option<std::string::String>,
    /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
    /// in different ways, such as by purpose, owner, or environment.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DeviceSummary {
    /// <p>The ID of the device.</p>
    pub fn managed_device_id(&self) -> std::option::Option<&str> {
        self.managed_device_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub fn managed_device_arn(&self) -> std::option::Option<&str> {
        self.managed_device_arn.as_deref()
    }
    /// <p>The ID of the job used to order the device.</p>
    pub fn associated_with_job(&self) -> std::option::Option<&str> {
        self.associated_with_job.as_deref()
    }
    /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
    /// in different ways, such as by purpose, owner, or environment.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DeviceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceSummary");
        formatter.field("managed_device_id", &self.managed_device_id);
        formatter.field("managed_device_arn", &self.managed_device_arn);
        formatter.field("associated_with_job", &self.associated_with_job);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DeviceSummary`](crate::model::DeviceSummary)
pub mod device_summary {
    /// A builder for [`DeviceSummary`](crate::model::DeviceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) managed_device_id: std::option::Option<std::string::String>,
        pub(crate) managed_device_arn: std::option::Option<std::string::String>,
        pub(crate) associated_with_job: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the device.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_device_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn managed_device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_device_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn set_managed_device_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_device_arn = input;
            self
        }
        /// <p>The ID of the job used to order the device.</p>
        pub fn associated_with_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_with_job = Some(input.into());
            self
        }
        /// <p>The ID of the job used to order the device.</p>
        pub fn set_associated_with_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_with_job = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceSummary`](crate::model::DeviceSummary)
        pub fn build(self) -> crate::model::DeviceSummary {
            crate::model::DeviceSummary {
                managed_device_id: self.managed_device_id,
                managed_device_arn: self.managed_device_arn,
                associated_with_job: self.associated_with_job,
                tags: self.tags,
            }
        }
    }
}
impl DeviceSummary {
    /// Creates a new builder-style object to manufacture [`DeviceSummary`](crate::model::DeviceSummary)
    pub fn builder() -> crate::model::device_summary::Builder {
        crate::model::device_summary::Builder::default()
    }
}

/// <p>Information about the software on the device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SoftwareInformation {
    /// <p>The version of the software currently installed on the device.</p>
    pub installed_version: std::option::Option<std::string::String>,
    /// <p>The version of the software being installed on the device.</p>
    pub installing_version: std::option::Option<std::string::String>,
    /// <p>The state of the software that is installed or that is being installed on the
    /// device.</p>
    pub install_state: std::option::Option<std::string::String>,
}
impl SoftwareInformation {
    /// <p>The version of the software currently installed on the device.</p>
    pub fn installed_version(&self) -> std::option::Option<&str> {
        self.installed_version.as_deref()
    }
    /// <p>The version of the software being installed on the device.</p>
    pub fn installing_version(&self) -> std::option::Option<&str> {
        self.installing_version.as_deref()
    }
    /// <p>The state of the software that is installed or that is being installed on the
    /// device.</p>
    pub fn install_state(&self) -> std::option::Option<&str> {
        self.install_state.as_deref()
    }
}
impl std::fmt::Debug for SoftwareInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SoftwareInformation");
        formatter.field("installed_version", &self.installed_version);
        formatter.field("installing_version", &self.installing_version);
        formatter.field("install_state", &self.install_state);
        formatter.finish()
    }
}
/// See [`SoftwareInformation`](crate::model::SoftwareInformation)
pub mod software_information {
    /// A builder for [`SoftwareInformation`](crate::model::SoftwareInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) installed_version: std::option::Option<std::string::String>,
        pub(crate) installing_version: std::option::Option<std::string::String>,
        pub(crate) install_state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version of the software currently installed on the device.</p>
        pub fn installed_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.installed_version = Some(input.into());
            self
        }
        /// <p>The version of the software currently installed on the device.</p>
        pub fn set_installed_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.installed_version = input;
            self
        }
        /// <p>The version of the software being installed on the device.</p>
        pub fn installing_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.installing_version = Some(input.into());
            self
        }
        /// <p>The version of the software being installed on the device.</p>
        pub fn set_installing_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.installing_version = input;
            self
        }
        /// <p>The state of the software that is installed or that is being installed on the
        /// device.</p>
        pub fn install_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.install_state = Some(input.into());
            self
        }
        /// <p>The state of the software that is installed or that is being installed on the
        /// device.</p>
        pub fn set_install_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.install_state = input;
            self
        }
        /// Consumes the builder and constructs a [`SoftwareInformation`](crate::model::SoftwareInformation)
        pub fn build(self) -> crate::model::SoftwareInformation {
            crate::model::SoftwareInformation {
                installed_version: self.installed_version,
                installing_version: self.installing_version,
                install_state: self.install_state,
            }
        }
    }
}
impl SoftwareInformation {
    /// Creates a new builder-style object to manufacture [`SoftwareInformation`](crate::model::SoftwareInformation)
    pub fn builder() -> crate::model::software_information::Builder {
        crate::model::software_information::Builder::default()
    }
}

/// <p>The physical capacity of the Amazon Web Services Snow Family device. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Capacity {
    /// <p>The name of the type of capacity, such as memory.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unit of measure for the type of capacity.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>The total capacity on the device.</p>
    pub total: std::option::Option<i64>,
    /// <p>The amount of capacity used on the device.</p>
    pub used: std::option::Option<i64>,
    /// <p>The amount of capacity available for use on the device.</p>
    pub available: std::option::Option<i64>,
}
impl Capacity {
    /// <p>The name of the type of capacity, such as memory.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unit of measure for the type of capacity.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>The total capacity on the device.</p>
    pub fn total(&self) -> std::option::Option<i64> {
        self.total
    }
    /// <p>The amount of capacity used on the device.</p>
    pub fn used(&self) -> std::option::Option<i64> {
        self.used
    }
    /// <p>The amount of capacity available for use on the device.</p>
    pub fn available(&self) -> std::option::Option<i64> {
        self.available
    }
}
impl std::fmt::Debug for Capacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Capacity");
        formatter.field("name", &self.name);
        formatter.field("unit", &self.unit);
        formatter.field("total", &self.total);
        formatter.field("used", &self.used);
        formatter.field("available", &self.available);
        formatter.finish()
    }
}
/// See [`Capacity`](crate::model::Capacity)
pub mod capacity {
    /// A builder for [`Capacity`](crate::model::Capacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) total: std::option::Option<i64>,
        pub(crate) used: std::option::Option<i64>,
        pub(crate) available: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the type of capacity, such as memory.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the type of capacity, such as memory.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unit of measure for the type of capacity.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of measure for the type of capacity.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The total capacity on the device.</p>
        pub fn total(mut self, input: i64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total capacity on the device.</p>
        pub fn set_total(mut self, input: std::option::Option<i64>) -> Self {
            self.total = input;
            self
        }
        /// <p>The amount of capacity used on the device.</p>
        pub fn used(mut self, input: i64) -> Self {
            self.used = Some(input);
            self
        }
        /// <p>The amount of capacity used on the device.</p>
        pub fn set_used(mut self, input: std::option::Option<i64>) -> Self {
            self.used = input;
            self
        }
        /// <p>The amount of capacity available for use on the device.</p>
        pub fn available(mut self, input: i64) -> Self {
            self.available = Some(input);
            self
        }
        /// <p>The amount of capacity available for use on the device.</p>
        pub fn set_available(mut self, input: std::option::Option<i64>) -> Self {
            self.available = input;
            self
        }
        /// Consumes the builder and constructs a [`Capacity`](crate::model::Capacity)
        pub fn build(self) -> crate::model::Capacity {
            crate::model::Capacity {
                name: self.name,
                unit: self.unit,
                total: self.total,
                used: self.used,
                available: self.available,
            }
        }
    }
}
impl Capacity {
    /// Creates a new builder-style object to manufacture [`Capacity`](crate::model::Capacity)
    pub fn builder() -> crate::model::capacity::Builder {
        crate::model::capacity::Builder::default()
    }
}

/// <p>The details about the physical network interface for the device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhysicalNetworkInterface {
    /// <p>The physical network interface ID.</p>
    pub physical_network_interface_id: std::option::Option<std::string::String>,
    /// <p>The
    /// physical
    /// connector type.</p>
    pub physical_connector_type: std::option::Option<crate::model::PhysicalConnectorType>,
    /// <p>A value that describes whether the IP address is dynamic or persistent.</p>
    pub ip_address_assignment: std::option::Option<crate::model::IpAddressAssignment>,
    /// <p>The IP address of the device.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The netmask used to divide the IP address into subnets.</p>
    pub netmask: std::option::Option<std::string::String>,
    /// <p>The default gateway of the device.</p>
    pub default_gateway: std::option::Option<std::string::String>,
    /// <p>The MAC address of the device.</p>
    pub mac_address: std::option::Option<std::string::String>,
}
impl PhysicalNetworkInterface {
    /// <p>The physical network interface ID.</p>
    pub fn physical_network_interface_id(&self) -> std::option::Option<&str> {
        self.physical_network_interface_id.as_deref()
    }
    /// <p>The
    /// physical
    /// connector type.</p>
    pub fn physical_connector_type(
        &self,
    ) -> std::option::Option<&crate::model::PhysicalConnectorType> {
        self.physical_connector_type.as_ref()
    }
    /// <p>A value that describes whether the IP address is dynamic or persistent.</p>
    pub fn ip_address_assignment(&self) -> std::option::Option<&crate::model::IpAddressAssignment> {
        self.ip_address_assignment.as_ref()
    }
    /// <p>The IP address of the device.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The netmask used to divide the IP address into subnets.</p>
    pub fn netmask(&self) -> std::option::Option<&str> {
        self.netmask.as_deref()
    }
    /// <p>The default gateway of the device.</p>
    pub fn default_gateway(&self) -> std::option::Option<&str> {
        self.default_gateway.as_deref()
    }
    /// <p>The MAC address of the device.</p>
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
}
impl std::fmt::Debug for PhysicalNetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhysicalNetworkInterface");
        formatter.field(
            "physical_network_interface_id",
            &self.physical_network_interface_id,
        );
        formatter.field("physical_connector_type", &self.physical_connector_type);
        formatter.field("ip_address_assignment", &self.ip_address_assignment);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("netmask", &self.netmask);
        formatter.field("default_gateway", &self.default_gateway);
        formatter.field("mac_address", &self.mac_address);
        formatter.finish()
    }
}
/// See [`PhysicalNetworkInterface`](crate::model::PhysicalNetworkInterface)
pub mod physical_network_interface {
    /// A builder for [`PhysicalNetworkInterface`](crate::model::PhysicalNetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) physical_network_interface_id: std::option::Option<std::string::String>,
        pub(crate) physical_connector_type:
            std::option::Option<crate::model::PhysicalConnectorType>,
        pub(crate) ip_address_assignment: std::option::Option<crate::model::IpAddressAssignment>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) netmask: std::option::Option<std::string::String>,
        pub(crate) default_gateway: std::option::Option<std::string::String>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The physical network interface ID.</p>
        pub fn physical_network_interface_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.physical_network_interface_id = Some(input.into());
            self
        }
        /// <p>The physical network interface ID.</p>
        pub fn set_physical_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.physical_network_interface_id = input;
            self
        }
        /// <p>The
        /// physical
        /// connector type.</p>
        pub fn physical_connector_type(
            mut self,
            input: crate::model::PhysicalConnectorType,
        ) -> Self {
            self.physical_connector_type = Some(input);
            self
        }
        /// <p>The
        /// physical
        /// connector type.</p>
        pub fn set_physical_connector_type(
            mut self,
            input: std::option::Option<crate::model::PhysicalConnectorType>,
        ) -> Self {
            self.physical_connector_type = input;
            self
        }
        /// <p>A value that describes whether the IP address is dynamic or persistent.</p>
        pub fn ip_address_assignment(mut self, input: crate::model::IpAddressAssignment) -> Self {
            self.ip_address_assignment = Some(input);
            self
        }
        /// <p>A value that describes whether the IP address is dynamic or persistent.</p>
        pub fn set_ip_address_assignment(
            mut self,
            input: std::option::Option<crate::model::IpAddressAssignment>,
        ) -> Self {
            self.ip_address_assignment = input;
            self
        }
        /// <p>The IP address of the device.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address of the device.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The netmask used to divide the IP address into subnets.</p>
        pub fn netmask(mut self, input: impl Into<std::string::String>) -> Self {
            self.netmask = Some(input.into());
            self
        }
        /// <p>The netmask used to divide the IP address into subnets.</p>
        pub fn set_netmask(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.netmask = input;
            self
        }
        /// <p>The default gateway of the device.</p>
        pub fn default_gateway(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_gateway = Some(input.into());
            self
        }
        /// <p>The default gateway of the device.</p>
        pub fn set_default_gateway(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_gateway = input;
            self
        }
        /// <p>The MAC address of the device.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The MAC address of the device.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// Consumes the builder and constructs a [`PhysicalNetworkInterface`](crate::model::PhysicalNetworkInterface)
        pub fn build(self) -> crate::model::PhysicalNetworkInterface {
            crate::model::PhysicalNetworkInterface {
                physical_network_interface_id: self.physical_network_interface_id,
                physical_connector_type: self.physical_connector_type,
                ip_address_assignment: self.ip_address_assignment,
                ip_address: self.ip_address,
                netmask: self.netmask,
                default_gateway: self.default_gateway,
                mac_address: self.mac_address,
            }
        }
    }
}
impl PhysicalNetworkInterface {
    /// Creates a new builder-style object to manufacture [`PhysicalNetworkInterface`](crate::model::PhysicalNetworkInterface)
    pub fn builder() -> crate::model::physical_network_interface::Builder {
        crate::model::physical_network_interface::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpAddressAssignment {
    #[allow(missing_docs)] // documentation missing in model
    Dhcp,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpAddressAssignment {
    fn from(s: &str) -> Self {
        match s {
            "DHCP" => IpAddressAssignment::Dhcp,
            "STATIC" => IpAddressAssignment::Static,
            other => IpAddressAssignment::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpAddressAssignment {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpAddressAssignment::from(s))
    }
}
impl IpAddressAssignment {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpAddressAssignment::Dhcp => "DHCP",
            IpAddressAssignment::Static => "STATIC",
            IpAddressAssignment::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DHCP", "STATIC"]
    }
}
impl AsRef<str> for IpAddressAssignment {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhysicalConnectorType {
    #[allow(missing_docs)] // documentation missing in model
    Qsfp,
    #[allow(missing_docs)] // documentation missing in model
    Rj45,
    #[allow(missing_docs)] // documentation missing in model
    Rj452,
    #[allow(missing_docs)] // documentation missing in model
    SfpPlus,
    #[allow(missing_docs)] // documentation missing in model
    Wifi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhysicalConnectorType {
    fn from(s: &str) -> Self {
        match s {
            "QSFP" => PhysicalConnectorType::Qsfp,
            "RJ45" => PhysicalConnectorType::Rj45,
            "RJ45_2" => PhysicalConnectorType::Rj452,
            "SFP_PLUS" => PhysicalConnectorType::SfpPlus,
            "WIFI" => PhysicalConnectorType::Wifi,
            other => PhysicalConnectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhysicalConnectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhysicalConnectorType::from(s))
    }
}
impl PhysicalConnectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhysicalConnectorType::Qsfp => "QSFP",
            PhysicalConnectorType::Rj45 => "RJ45",
            PhysicalConnectorType::Rj452 => "RJ45_2",
            PhysicalConnectorType::SfpPlus => "SFP_PLUS",
            PhysicalConnectorType::Wifi => "WIFI",
            PhysicalConnectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["QSFP", "RJ45", "RJ45_2", "SFP_PLUS", "WIFI"]
    }
}
impl AsRef<str> for PhysicalConnectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UnlockState {
    #[allow(missing_docs)] // documentation missing in model
    Locked,
    #[allow(missing_docs)] // documentation missing in model
    Unlocked,
    #[allow(missing_docs)] // documentation missing in model
    Unlocking,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UnlockState {
    fn from(s: &str) -> Self {
        match s {
            "LOCKED" => UnlockState::Locked,
            "UNLOCKED" => UnlockState::Unlocked,
            "UNLOCKING" => UnlockState::Unlocking,
            other => UnlockState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UnlockState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UnlockState::from(s))
    }
}
impl UnlockState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UnlockState::Locked => "LOCKED",
            UnlockState::Unlocked => "UNLOCKED",
            UnlockState::Unlocking => "UNLOCKING",
            UnlockState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOCKED", "UNLOCKED", "UNLOCKING"]
    }
}
impl AsRef<str> for UnlockState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
