// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelTaskOutput {
    /// <p>The ID of the task that you are attempting to cancel.</p>
    pub task_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.finish()
    }
}
/// See [`CancelTaskOutput`](crate::output::CancelTaskOutput)
pub mod cancel_task_output {
    /// A builder for [`CancelTaskOutput`](crate::output::CancelTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the task that you are attempting to cancel.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task that you are attempting to cancel.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelTaskOutput`](crate::output::CancelTaskOutput)
        pub fn build(self) -> crate::output::CancelTaskOutput {
            crate::output::CancelTaskOutput {
                task_id: self.task_id,
            }
        }
    }
}
impl CancelTaskOutput {
    /// Creates a new builder-style object to manufacture [`CancelTaskOutput`](crate::output::CancelTaskOutput)
    pub fn builder() -> crate::output::cancel_task_output::Builder {
        crate::output::cancel_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTasksOutput {
    /// <p>A list of task structures containing details about each task.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::TaskSummary>>,
    /// <p>A pagination token to continue to the next page of tasks.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTasksOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTasksOutput`](crate::output::ListTasksOutput)
pub mod list_tasks_output {
    /// A builder for [`ListTasksOutput`](crate::output::ListTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::TaskSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A list of task structures containing details about each task.</p>
        pub fn tasks(mut self, input: impl Into<crate::model::TaskSummary>) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input.into());
            self.tasks = Some(v);
            self
        }
        /// <p>A list of task structures containing details about each task.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskSummary>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p>A pagination token to continue to the next page of tasks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of tasks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTasksOutput`](crate::output::ListTasksOutput)
        pub fn build(self) -> crate::output::ListTasksOutput {
            crate::output::ListTasksOutput {
                tasks: self.tasks,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTasksOutput {
    /// Creates a new builder-style object to manufacture [`ListTasksOutput`](crate::output::ListTasksOutput)
    pub fn builder() -> crate::output::list_tasks_output::Builder {
        crate::output::list_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTaskOutput {
    /// <p>The ID of the task that you created.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task that you created.</p>
    pub task_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.field("task_arn", &self.task_arn);
        formatter.finish()
    }
}
/// See [`CreateTaskOutput`](crate::output::CreateTaskOutput)
pub mod create_task_output {
    /// A builder for [`CreateTaskOutput`](crate::output::CreateTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the task that you created.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task that you created.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that you created.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that you created.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTaskOutput`](crate::output::CreateTaskOutput)
        pub fn build(self) -> crate::output::CreateTaskOutput {
            crate::output::CreateTaskOutput {
                task_id: self.task_id,
                task_arn: self.task_arn,
            }
        }
    }
}
impl CreateTaskOutput {
    /// Creates a new builder-style object to manufacture [`CreateTaskOutput`](crate::output::CreateTaskOutput)
    pub fn builder() -> crate::output::create_task_output::Builder {
        crate::output::create_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTaskOutput {
    /// <p>The ID of the task.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The managed devices that the task was sent to.</p>
    pub targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The current state of the task.</p>
    pub state: std::option::Option<crate::model::TaskState>,
    /// <p>When the <code>CreateTask</code> operation was called.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When the state of the task was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When the task was completed.</p>
    pub completed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description provided of the task and managed devices.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
    /// in different ways, such as by purpose, owner, or environment.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DescribeTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTaskOutput");
        formatter.field("task_id", &self.task_id);
        formatter.field("task_arn", &self.task_arn);
        formatter.field("targets", &self.targets);
        formatter.field("state", &self.state);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("completed_at", &self.completed_at);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
pub mod describe_task_output {
    /// A builder for [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state: std::option::Option<crate::model::TaskState>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The managed devices that the task was sent to.</p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The managed devices that the task was sent to.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The current state of the task.</p>
        pub fn state(mut self, input: crate::model::TaskState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the task.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::TaskState>) -> Self {
            self.state = input;
            self
        }
        /// <p>When the <code>CreateTask</code> operation was called.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>When the <code>CreateTask</code> operation was called.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>When the state of the task was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>When the state of the task was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>When the task was completed.</p>
        pub fn completed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_at = Some(input);
            self
        }
        /// <p>When the task was completed.</p>
        pub fn set_completed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_at = input;
            self
        }
        /// <p>The description provided of the task and managed devices.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description provided of the task and managed devices.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
        pub fn build(self) -> crate::output::DescribeTaskOutput {
            crate::output::DescribeTaskOutput {
                task_id: self.task_id,
                task_arn: self.task_arn,
                targets: self.targets,
                state: self.state,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                completed_at: self.completed_at,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl DescribeTaskOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTaskOutput`](crate::output::DescribeTaskOutput)
    pub fn builder() -> crate::output::describe_task_output::Builder {
        crate::output::describe_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExecutionsOutput {
    /// <p>A list of executions. Each execution contains the task ID, the device that the task is
    /// executing on, the execution ID, and the status of the execution.</p>
    pub executions: std::option::Option<std::vec::Vec<crate::model::ExecutionSummary>>,
    /// <p>A pagination token to continue to the next page of executions.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExecutionsOutput");
        formatter.field("executions", &self.executions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
pub mod list_executions_output {
    /// A builder for [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) executions: std::option::Option<std::vec::Vec<crate::model::ExecutionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `executions`.
        ///
        /// To override the contents of this collection use [`set_executions`](Self::set_executions).
        ///
        /// <p>A list of executions. Each execution contains the task ID, the device that the task is
        /// executing on, the execution ID, and the status of the execution.</p>
        pub fn executions(mut self, input: impl Into<crate::model::ExecutionSummary>) -> Self {
            let mut v = self.executions.unwrap_or_default();
            v.push(input.into());
            self.executions = Some(v);
            self
        }
        /// <p>A list of executions. Each execution contains the task ID, the device that the task is
        /// executing on, the execution ID, and the status of the execution.</p>
        pub fn set_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExecutionSummary>>,
        ) -> Self {
            self.executions = input;
            self
        }
        /// <p>A pagination token to continue to the next page of executions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of executions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
        pub fn build(self) -> crate::output::ListExecutionsOutput {
            crate::output::ListExecutionsOutput {
                executions: self.executions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
    pub fn builder() -> crate::output::list_executions_output::Builder {
        crate::output::list_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExecutionOutput {
    /// <p>The ID of the task being executed on the device.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The ID of the execution.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>The ID of the managed device that the task is being executed on.</p>
    pub managed_device_id: std::option::Option<std::string::String>,
    /// <p>The current state of the execution.</p>
    pub state: std::option::Option<crate::model::ExecutionState>,
    /// <p>When the execution began.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When the status of the execution was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DescribeExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExecutionOutput");
        formatter.field("task_id", &self.task_id);
        formatter.field("execution_id", &self.execution_id);
        formatter.field("managed_device_id", &self.managed_device_id);
        formatter.field("state", &self.state);
        formatter.field("started_at", &self.started_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
pub mod describe_execution_output {
    /// A builder for [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) managed_device_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ExecutionState>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the task being executed on the device.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the task being executed on the device.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The ID of the execution.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>The ID of the execution.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>The ID of the managed device that the task is being executed on.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the managed device that the task is being executed on.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_device_id = input;
            self
        }
        /// <p>The current state of the execution.</p>
        pub fn state(mut self, input: crate::model::ExecutionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the execution.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ExecutionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>When the execution began.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>When the execution began.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>When the status of the execution was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>When the status of the execution was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
        pub fn build(self) -> crate::output::DescribeExecutionOutput {
            crate::output::DescribeExecutionOutput {
                task_id: self.task_id,
                execution_id: self.execution_id,
                managed_device_id: self.managed_device_id,
                state: self.state,
                started_at: self.started_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl DescribeExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
    pub fn builder() -> crate::output::describe_execution_output::Builder {
        crate::output::describe_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceResourcesOutput {
    /// <p>A structure defining the resource's type, Amazon Resource Name (ARN), and ID.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::ResourceSummary>>,
    /// <p>A pagination token to continue to the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeviceResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceResourcesOutput");
        formatter.field("resources", &self.resources);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeviceResourcesOutput`](crate::output::ListDeviceResourcesOutput)
pub mod list_device_resources_output {
    /// A builder for [`ListDeviceResourcesOutput`](crate::output::ListDeviceResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::ResourceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A structure defining the resource's type, Amazon Resource Name (ARN), and ID.</p>
        pub fn resources(mut self, input: impl Into<crate::model::ResourceSummary>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>A structure defining the resource's type, Amazon Resource Name (ARN), and ID.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceSummary>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>A pagination token to continue to the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceResourcesOutput`](crate::output::ListDeviceResourcesOutput)
        pub fn build(self) -> crate::output::ListDeviceResourcesOutput {
            crate::output::ListDeviceResourcesOutput {
                resources: self.resources,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeviceResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListDeviceResourcesOutput`](crate::output::ListDeviceResourcesOutput)
    pub fn builder() -> crate::output::list_device_resources_output::Builder {
        crate::output::list_device_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeviceEc2InstancesOutput {
    /// <p>A list of structures containing information about each instance. </p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
}
impl std::fmt::Debug for DescribeDeviceEc2InstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeviceEc2InstancesOutput");
        formatter.field("instances", &self.instances);
        formatter.finish()
    }
}
/// See [`DescribeDeviceEc2InstancesOutput`](crate::output::DescribeDeviceEc2InstancesOutput)
pub mod describe_device_ec2_instances_output {
    /// A builder for [`DescribeDeviceEc2InstancesOutput`](crate::output::DescribeDeviceEc2InstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
    }
    impl Builder {
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>A list of structures containing information about each instance. </p>
        pub fn instances(mut self, input: impl Into<crate::model::InstanceSummary>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>A list of structures containing information about each instance. </p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceSummary>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceEc2InstancesOutput`](crate::output::DescribeDeviceEc2InstancesOutput)
        pub fn build(self) -> crate::output::DescribeDeviceEc2InstancesOutput {
            crate::output::DescribeDeviceEc2InstancesOutput {
                instances: self.instances,
            }
        }
    }
}
impl DescribeDeviceEc2InstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceEc2InstancesOutput`](crate::output::DescribeDeviceEc2InstancesOutput)
    pub fn builder() -> crate::output::describe_device_ec2_instances_output::Builder {
        crate::output::describe_device_ec2_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesOutput {
    /// <p>A list of device structures that contain information about the device.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
    /// <p>A pagination token to continue to the next page of devices.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesOutput");
        formatter.field("devices", &self.devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevicesOutput`](crate::output::ListDevicesOutput)
pub mod list_devices_output {
    /// A builder for [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>A list of device structures that contain information about the device.</p>
        pub fn devices(mut self, input: impl Into<crate::model::DeviceSummary>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>A list of device structures that contain information about the device.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>A pagination token to continue to the next page of devices.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token to continue to the next page of devices.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesOutput`](crate::output::ListDevicesOutput)
        pub fn build(self) -> crate::output::ListDevicesOutput {
            crate::output::ListDevicesOutput {
                devices: self.devices,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    pub fn builder() -> crate::output::list_devices_output::Builder {
        crate::output::list_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeviceOutput {
    /// <p>When the device last contacted the Amazon Web Services Cloud. Indicates that the device is
    /// online.</p>
    pub last_reached_out_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache
    /// was refreshed.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
    /// in different ways, such as by purpose, owner, or environment. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The ID of the device that you checked the information for.</p>
    pub managed_device_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub managed_device_arn: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services Snow Family device.</p>
    pub device_type: std::option::Option<std::string::String>,
    /// <p>The ID of the job used when ordering the device.</p>
    pub associated_with_job: std::option::Option<std::string::String>,
    /// <p>The current state of the device.</p>
    pub device_state: std::option::Option<crate::model::UnlockState>,
    /// <p>The network interfaces available on the device.</p>
    pub physical_network_interfaces:
        std::option::Option<std::vec::Vec<crate::model::PhysicalNetworkInterface>>,
    /// <p>The hardware specifications of the device. </p>
    pub device_capacities: std::option::Option<std::vec::Vec<crate::model::Capacity>>,
    /// <p>The software installed on the device.</p>
    pub software: std::option::Option<crate::model::SoftwareInformation>,
}
impl std::fmt::Debug for DescribeDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeviceOutput");
        formatter.field("last_reached_out_at", &self.last_reached_out_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.field("managed_device_id", &self.managed_device_id);
        formatter.field("managed_device_arn", &self.managed_device_arn);
        formatter.field("device_type", &self.device_type);
        formatter.field("associated_with_job", &self.associated_with_job);
        formatter.field("device_state", &self.device_state);
        formatter.field(
            "physical_network_interfaces",
            &self.physical_network_interfaces,
        );
        formatter.field("device_capacities", &self.device_capacities);
        formatter.field("software", &self.software);
        formatter.finish()
    }
}
/// See [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
pub mod describe_device_output {
    /// A builder for [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_reached_out_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) managed_device_id: std::option::Option<std::string::String>,
        pub(crate) managed_device_arn: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
        pub(crate) associated_with_job: std::option::Option<std::string::String>,
        pub(crate) device_state: std::option::Option<crate::model::UnlockState>,
        pub(crate) physical_network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::PhysicalNetworkInterface>>,
        pub(crate) device_capacities: std::option::Option<std::vec::Vec<crate::model::Capacity>>,
        pub(crate) software: std::option::Option<crate::model::SoftwareInformation>,
    }
    impl Builder {
        /// <p>When the device last contacted the Amazon Web Services Cloud. Indicates that the device is
        /// online.</p>
        pub fn last_reached_out_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_reached_out_at = Some(input);
            self
        }
        /// <p>When the device last contacted the Amazon Web Services Cloud. Indicates that the device is
        /// online.</p>
        pub fn set_last_reached_out_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_reached_out_at = input;
            self
        }
        /// <p>When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache
        /// was refreshed.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache
        /// was refreshed.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Optional metadata that you assign to a resource. You can use tags to categorize a resource
        /// in different ways, such as by purpose, owner, or environment. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the device that you checked the information for.</p>
        pub fn managed_device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device that you checked the information for.</p>
        pub fn set_managed_device_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_device_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn managed_device_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_device_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn set_managed_device_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_device_arn = input;
            self
        }
        /// <p>The type of Amazon Web Services Snow Family device.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services Snow Family device.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// <p>The ID of the job used when ordering the device.</p>
        pub fn associated_with_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.associated_with_job = Some(input.into());
            self
        }
        /// <p>The ID of the job used when ordering the device.</p>
        pub fn set_associated_with_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.associated_with_job = input;
            self
        }
        /// <p>The current state of the device.</p>
        pub fn device_state(mut self, input: crate::model::UnlockState) -> Self {
            self.device_state = Some(input);
            self
        }
        /// <p>The current state of the device.</p>
        pub fn set_device_state(
            mut self,
            input: std::option::Option<crate::model::UnlockState>,
        ) -> Self {
            self.device_state = input;
            self
        }
        /// Appends an item to `physical_network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_physical_network_interfaces`](Self::set_physical_network_interfaces).
        ///
        /// <p>The network interfaces available on the device.</p>
        pub fn physical_network_interfaces(
            mut self,
            input: impl Into<crate::model::PhysicalNetworkInterface>,
        ) -> Self {
            let mut v = self.physical_network_interfaces.unwrap_or_default();
            v.push(input.into());
            self.physical_network_interfaces = Some(v);
            self
        }
        /// <p>The network interfaces available on the device.</p>
        pub fn set_physical_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhysicalNetworkInterface>>,
        ) -> Self {
            self.physical_network_interfaces = input;
            self
        }
        /// Appends an item to `device_capacities`.
        ///
        /// To override the contents of this collection use [`set_device_capacities`](Self::set_device_capacities).
        ///
        /// <p>The hardware specifications of the device. </p>
        pub fn device_capacities(mut self, input: impl Into<crate::model::Capacity>) -> Self {
            let mut v = self.device_capacities.unwrap_or_default();
            v.push(input.into());
            self.device_capacities = Some(v);
            self
        }
        /// <p>The hardware specifications of the device. </p>
        pub fn set_device_capacities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Capacity>>,
        ) -> Self {
            self.device_capacities = input;
            self
        }
        /// <p>The software installed on the device.</p>
        pub fn software(mut self, input: crate::model::SoftwareInformation) -> Self {
            self.software = Some(input);
            self
        }
        /// <p>The software installed on the device.</p>
        pub fn set_software(
            mut self,
            input: std::option::Option<crate::model::SoftwareInformation>,
        ) -> Self {
            self.software = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
        pub fn build(self) -> crate::output::DescribeDeviceOutput {
            crate::output::DescribeDeviceOutput {
                last_reached_out_at: self.last_reached_out_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
                managed_device_id: self.managed_device_id,
                managed_device_arn: self.managed_device_arn,
                device_type: self.device_type,
                associated_with_job: self.associated_with_job,
                device_state: self.device_state,
                physical_network_interfaces: self.physical_network_interfaces,
                device_capacities: self.device_capacities,
                software: self.software,
            }
        }
    }
}
impl DescribeDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceOutput`](crate::output::DescribeDeviceOutput)
    pub fn builder() -> crate::output::describe_device_output::Builder {
        crate::output::describe_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tags for the device or task.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the device or task.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tags for the device or task.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
