// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelClusterInput`](crate::input::CancelClusterInput)
pub mod cancel_cluster_input {
    /// A builder for [`CancelClusterInput`](crate::input::CancelClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelClusterInput`](crate::input::CancelClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelClusterInput {
                cluster_id: self.cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelClusterInputOperationOutputAlias = crate::operation::CancelCluster;
#[doc(hidden)]
pub type CancelClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelClusterInput {
    /// Consumes the builder and constructs an Operation<[`CancelCluster`](crate::operation::CancelCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.CancelCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelCluster",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelClusterInput`](crate::input::CancelClusterInput)
    pub fn builder() -> crate::input::cancel_cluster_input::Builder {
        crate::input::cancel_cluster_input::Builder::default()
    }
}

/// See [`CancelJobInput`](crate::input::CancelJobInput)
pub mod cancel_job_input {
    /// A builder for [`CancelJobInput`](crate::input::CancelJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelJobInput`](crate::input::CancelJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CancelJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CancelJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelJobInputOperationOutputAlias = crate::operation::CancelJob;
#[doc(hidden)]
pub type CancelJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelJob`](crate::operation::CancelJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.CancelJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CancelJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CancelJob",
                    "snowball",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelJobInput`](crate::input::CancelJobInput)
    pub fn builder() -> crate::input::cancel_job_input::Builder {
        crate::input::cancel_job_input::Builder::default()
    }
}

/// See [`CreateAddressInput`](crate::input::CreateAddressInput)
pub mod create_address_input {
    /// A builder for [`CreateAddressInput`](crate::input::CreateAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<crate::model::Address>,
    }
    impl Builder {
        /// <p>The address that you want the Snow device shipped to.</p>
        pub fn address(mut self, input: crate::model::Address) -> Self {
            self.address = Some(input);
            self
        }
        /// <p>The address that you want the Snow device shipped to.</p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.address = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAddressInput`](crate::input::CreateAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAddressInput {
                address: self.address,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAddressInputOperationOutputAlias = crate::operation::CreateAddress;
#[doc(hidden)]
pub type CreateAddressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAddressInput {
    /// Consumes the builder and constructs an Operation<[`CreateAddress`](crate::operation::CreateAddress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAddress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAddressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAddressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAddressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.CreateAddress",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_address(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAddress",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAddressInput`](crate::input::CreateAddressInput)
    pub fn builder() -> crate::input::create_address_input::Builder {
        crate::input::create_address_input::Builder::default()
    }
}

/// See [`CreateClusterInput`](crate::input::CreateClusterInput)
pub mod create_cluster_input {
    /// A builder for [`CreateClusterInput`](crate::input::CreateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) resources: std::option::Option<crate::model::JobResource>,
        pub(crate) on_device_service_configuration:
            std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) address_id: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) snowball_type: std::option::Option<crate::model::SnowballType>,
        pub(crate) shipping_option: std::option::Option<crate::model::ShippingOption>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) forwarding_address_id: std::option::Option<std::string::String>,
        pub(crate) tax_documents: std::option::Option<crate::model::TaxDocuments>,
        pub(crate) remote_management: std::option::Option<crate::model::RemoteManagement>,
    }
    impl Builder {
        /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language. </p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.on_device_service_configuration = Some(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.on_device_service_configuration = input;
            self
        }
        /// <p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID for the address that you want the cluster shipped to.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The ID for the address that you want the cluster shipped to.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// <p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS). </p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS). </p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The type of Snow Family Devices to use for this cluster. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.snowball_type = Some(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for this cluster. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.snowball_type = input;
            self
        }
        /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.shipping_option = Some(input);
            self
        }
        /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.shipping_option = input;
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.forwarding_address_id = Some(input.into());
            self
        }
        /// <p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forwarding_address_id = input;
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn tax_documents(mut self, input: crate::model::TaxDocuments) -> Self {
            self.tax_documents = Some(input);
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn set_tax_documents(
            mut self,
            input: std::option::Option<crate::model::TaxDocuments>,
        ) -> Self {
            self.tax_documents = input;
            self
        }
        /// <p>Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn remote_management(mut self, input: crate::model::RemoteManagement) -> Self {
            self.remote_management = Some(input);
            self
        }
        /// <p>Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn set_remote_management(
            mut self,
            input: std::option::Option<crate::model::RemoteManagement>,
        ) -> Self {
            self.remote_management = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterInput`](crate::input::CreateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterInput {
                job_type: self.job_type,
                resources: self.resources,
                on_device_service_configuration: self.on_device_service_configuration,
                description: self.description,
                address_id: self.address_id,
                kms_key_arn: self.kms_key_arn,
                role_arn: self.role_arn,
                snowball_type: self.snowball_type,
                shipping_option: self.shipping_option,
                notification: self.notification,
                forwarding_address_id: self.forwarding_address_id,
                tax_documents: self.tax_documents,
                remote_management: self.remote_management,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterInputOperationOutputAlias = crate::operation::CreateCluster;
#[doc(hidden)]
pub type CreateClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateCluster`](crate::operation::CreateCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.CreateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCluster",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
}

/// See [`CreateJobInput`](crate::input::CreateJobInput)
pub mod create_job_input {
    /// A builder for [`CreateJobInput`](crate::input::CreateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) resources: std::option::Option<crate::model::JobResource>,
        pub(crate) on_device_service_configuration:
            std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) address_id: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) snowball_capacity_preference:
            std::option::Option<crate::model::SnowballCapacity>,
        pub(crate) shipping_option: std::option::Option<crate::model::ShippingOption>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) snowball_type: std::option::Option<crate::model::SnowballType>,
        pub(crate) forwarding_address_id: std::option::Option<std::string::String>,
        pub(crate) tax_documents: std::option::Option<crate::model::TaxDocuments>,
        pub(crate) device_configuration: std::option::Option<crate::model::DeviceConfiguration>,
        pub(crate) remote_management: std::option::Option<crate::model::RemoteManagement>,
        pub(crate) long_term_pricing_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Defines the type of job that you're creating. </p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>Defines the type of job that you're creating. </p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// <p>Defines the Amazon S3 buckets associated with this job.</p>
        /// <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p>
        /// <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>Defines the Amazon S3 buckets associated with this job.</p>
        /// <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p>
        /// <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.on_device_service_configuration = Some(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.on_device_service_configuration = input;
            self
        }
        /// <p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID for the address that you want the Snow device shipped to.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The ID for the address that you want the Snow device shipped to.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// <p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management Service (KMS) API action.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management Service (KMS) API action.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access Management (IAM) API action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access Management (IAM) API action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_capacity_preference(
            mut self,
            input: crate::model::SnowballCapacity,
        ) -> Self {
            self.snowball_capacity_preference = Some(input);
            self
        }
        /// <p>If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_capacity_preference(
            mut self,
            input: std::option::Option<crate::model::SnowballCapacity>,
        ) -> Self {
            self.snowball_capacity_preference = input;
            self
        }
        /// <p>The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.shipping_option = Some(input);
            self
        }
        /// <p>The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.shipping_option = input;
            self
        }
        /// <p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The type of Snow Family Devices to use for this job. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.snowball_type = Some(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for this job. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.snowball_type = input;
            self
        }
        /// <p>The forwarding address ID for a job. This field is not supported in most Regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.forwarding_address_id = Some(input.into());
            self
        }
        /// <p>The forwarding address ID for a job. This field is not supported in most Regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forwarding_address_id = input;
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn tax_documents(mut self, input: crate::model::TaxDocuments) -> Self {
            self.tax_documents = Some(input);
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn set_tax_documents(
            mut self,
            input: std::option::Option<crate::model::TaxDocuments>,
        ) -> Self {
            self.tax_documents = input;
            self
        }
        /// <p>Defines the device configuration for an Snowcone job.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn device_configuration(mut self, input: crate::model::DeviceConfiguration) -> Self {
            self.device_configuration = Some(input);
            self
        }
        /// <p>Defines the device configuration for an Snowcone job.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfiguration>,
        ) -> Self {
            self.device_configuration = input;
            self
        }
        /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn remote_management(mut self, input: crate::model::RemoteManagement) -> Self {
            self.remote_management = Some(input);
            self
        }
        /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn set_remote_management(
            mut self,
            input: std::option::Option<crate::model::RemoteManagement>,
        ) -> Self {
            self.remote_management = input;
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn long_term_pricing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.long_term_pricing_id = Some(input.into());
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn set_long_term_pricing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.long_term_pricing_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobInput`](crate::input::CreateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateJobInput {
                job_type: self.job_type,
                resources: self.resources,
                on_device_service_configuration: self.on_device_service_configuration,
                description: self.description,
                address_id: self.address_id,
                kms_key_arn: self.kms_key_arn,
                role_arn: self.role_arn,
                snowball_capacity_preference: self.snowball_capacity_preference,
                shipping_option: self.shipping_option,
                notification: self.notification,
                cluster_id: self.cluster_id,
                snowball_type: self.snowball_type,
                forwarding_address_id: self.forwarding_address_id,
                tax_documents: self.tax_documents,
                device_configuration: self.device_configuration,
                remote_management: self.remote_management,
                long_term_pricing_id: self.long_term_pricing_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateJobInputOperationOutputAlias = crate::operation::CreateJob;
#[doc(hidden)]
pub type CreateJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateJob`](crate::operation::CreateJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.CreateJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateJob",
                    "snowball",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
}

/// See [`CreateLongTermPricingInput`](crate::input::CreateLongTermPricingInput)
pub mod create_long_term_pricing_input {
    /// A builder for [`CreateLongTermPricingInput`](crate::input::CreateLongTermPricingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) long_term_pricing_type: std::option::Option<crate::model::LongTermPricingType>,
        pub(crate) is_long_term_pricing_auto_renew: std::option::Option<bool>,
        pub(crate) snowball_type: std::option::Option<crate::model::SnowballType>,
    }
    impl Builder {
        /// <p>The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.</p>
        pub fn long_term_pricing_type(mut self, input: crate::model::LongTermPricingType) -> Self {
            self.long_term_pricing_type = Some(input);
            self
        }
        /// <p>The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.</p>
        pub fn set_long_term_pricing_type(
            mut self,
            input: std::option::Option<crate::model::LongTermPricingType>,
        ) -> Self {
            self.long_term_pricing_type = input;
            self
        }
        /// <p>Specifies whether the current long-term pricing type for the device should be renewed.</p>
        pub fn is_long_term_pricing_auto_renew(mut self, input: bool) -> Self {
            self.is_long_term_pricing_auto_renew = Some(input);
            self
        }
        /// <p>Specifies whether the current long-term pricing type for the device should be renewed.</p>
        pub fn set_is_long_term_pricing_auto_renew(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_long_term_pricing_auto_renew = input;
            self
        }
        /// <p>The type of Snow Family Devices to use for the long-term pricing job.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.snowball_type = Some(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for the long-term pricing job.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.snowball_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLongTermPricingInput`](crate::input::CreateLongTermPricingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLongTermPricingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLongTermPricingInput {
                long_term_pricing_type: self.long_term_pricing_type,
                is_long_term_pricing_auto_renew: self.is_long_term_pricing_auto_renew,
                snowball_type: self.snowball_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLongTermPricingInputOperationOutputAlias = crate::operation::CreateLongTermPricing;
#[doc(hidden)]
pub type CreateLongTermPricingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLongTermPricingInput {
    /// Consumes the builder and constructs an Operation<[`CreateLongTermPricing`](crate::operation::CreateLongTermPricing)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLongTermPricing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLongTermPricingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLongTermPricingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLongTermPricingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.CreateLongTermPricing",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_long_term_pricing(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLongTermPricing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLongTermPricing",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLongTermPricingInput`](crate::input::CreateLongTermPricingInput)
    pub fn builder() -> crate::input::create_long_term_pricing_input::Builder {
        crate::input::create_long_term_pricing_input::Builder::default()
    }
}

/// See [`CreateReturnShippingLabelInput`](crate::input::CreateReturnShippingLabelInput)
pub mod create_return_shipping_label_input {
    /// A builder for [`CreateReturnShippingLabelInput`](crate::input::CreateReturnShippingLabelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) shipping_option: std::option::Option<crate::model::ShippingOption>,
    }
    impl Builder {
        /// <p>The ID for a job that you want to create the return shipping label for; for example, <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for a job that you want to create the return shipping label for; for example, <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.shipping_option = Some(input);
            self
        }
        /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.shipping_option = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReturnShippingLabelInput`](crate::input::CreateReturnShippingLabelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReturnShippingLabelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReturnShippingLabelInput {
                job_id: self.job_id,
                shipping_option: self.shipping_option,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReturnShippingLabelInputOperationOutputAlias =
    crate::operation::CreateReturnShippingLabel;
#[doc(hidden)]
pub type CreateReturnShippingLabelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateReturnShippingLabelInput {
    /// Consumes the builder and constructs an Operation<[`CreateReturnShippingLabel`](crate::operation::CreateReturnShippingLabel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReturnShippingLabel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReturnShippingLabelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReturnShippingLabelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReturnShippingLabelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.CreateReturnShippingLabel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_return_shipping_label(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReturnShippingLabel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReturnShippingLabel",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReturnShippingLabelInput`](crate::input::CreateReturnShippingLabelInput)
    pub fn builder() -> crate::input::create_return_shipping_label_input::Builder {
        crate::input::create_return_shipping_label_input::Builder::default()
    }
}

/// See [`DescribeAddressInput`](crate::input::DescribeAddressInput)
pub mod describe_address_input {
    /// A builder for [`DescribeAddressInput`](crate::input::DescribeAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The automatically generated ID for a specific address.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a specific address.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAddressInput`](crate::input::DescribeAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAddressInput {
                address_id: self.address_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAddressInputOperationOutputAlias = crate::operation::DescribeAddress;
#[doc(hidden)]
pub type DescribeAddressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAddressInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAddress`](crate::operation::DescribeAddress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAddress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAddressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAddressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAddressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.DescribeAddress",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_address(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAddress",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAddressInput`](crate::input::DescribeAddressInput)
    pub fn builder() -> crate::input::describe_address_input::Builder {
        crate::input::describe_address_input::Builder::default()
    }
}

/// See [`DescribeAddressesInput`](crate::input::DescribeAddressesInput)
pub mod describe_addresses_input {
    /// A builder for [`DescribeAddressesInput`](crate::input::DescribeAddressesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of <code>ADDRESS</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of <code>ADDRESS</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAddressesInput`](crate::input::DescribeAddressesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAddressesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAddressesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAddressesInputOperationOutputAlias = crate::operation::DescribeAddresses;
#[doc(hidden)]
pub type DescribeAddressesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAddressesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAddresses`](crate::operation::DescribeAddresses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAddresses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAddressesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAddressesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAddressesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.DescribeAddresses",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_addresses(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAddresses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAddresses",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAddressesInput`](crate::input::DescribeAddressesInput)
    pub fn builder() -> crate::input::describe_addresses_input::Builder {
        crate::input::describe_addresses_input::Builder::default()
    }
}

/// See [`DescribeClusterInput`](crate::input::DescribeClusterInput)
pub mod describe_cluster_input {
    /// A builder for [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The automatically generated ID for a cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterInput`](crate::input::DescribeClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterInput {
                cluster_id: self.cluster_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterInputOperationOutputAlias = crate::operation::DescribeCluster;
#[doc(hidden)]
pub type DescribeClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeClusterInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCluster`](crate::operation::DescribeCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.DescribeCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCluster",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    pub fn builder() -> crate::input::describe_cluster_input::Builder {
        crate::input::describe_cluster_input::Builder::default()
    }
}

/// See [`DescribeJobInput`](crate::input::DescribeJobInput)
pub mod describe_job_input {
    /// A builder for [`DescribeJobInput`](crate::input::DescribeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobInput`](crate::input::DescribeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobInputOperationOutputAlias = crate::operation::DescribeJob;
#[doc(hidden)]
pub type DescribeJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJob`](crate::operation::DescribeJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.DescribeJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJob",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
}

/// See [`DescribeReturnShippingLabelInput`](crate::input::DescribeReturnShippingLabelInput)
pub mod describe_return_shipping_label_input {
    /// A builder for [`DescribeReturnShippingLabelInput`](crate::input::DescribeReturnShippingLabelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReturnShippingLabelInput`](crate::input::DescribeReturnShippingLabelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReturnShippingLabelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReturnShippingLabelInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReturnShippingLabelInputOperationOutputAlias =
    crate::operation::DescribeReturnShippingLabel;
#[doc(hidden)]
pub type DescribeReturnShippingLabelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeReturnShippingLabelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReturnShippingLabel`](crate::operation::DescribeReturnShippingLabel)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReturnShippingLabel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReturnShippingLabelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReturnShippingLabelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReturnShippingLabelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.DescribeReturnShippingLabel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_return_shipping_label(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReturnShippingLabel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReturnShippingLabel",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReturnShippingLabelInput`](crate::input::DescribeReturnShippingLabelInput)
    pub fn builder() -> crate::input::describe_return_shipping_label_input::Builder {
        crate::input::describe_return_shipping_label_input::Builder::default()
    }
}

/// See [`GetJobManifestInput`](crate::input::GetJobManifestInput)
pub mod get_job_manifest_input {
    /// A builder for [`GetJobManifestInput`](crate::input::GetJobManifestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobManifestInput`](crate::input::GetJobManifestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJobManifestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJobManifestInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobManifestInputOperationOutputAlias = crate::operation::GetJobManifest;
#[doc(hidden)]
pub type GetJobManifestInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobManifestInput {
    /// Consumes the builder and constructs an Operation<[`GetJobManifest`](crate::operation::GetJobManifest)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJobManifest,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetJobManifestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetJobManifestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetJobManifestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.GetJobManifest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_job_manifest(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJobManifest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJobManifest",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetJobManifestInput`](crate::input::GetJobManifestInput)
    pub fn builder() -> crate::input::get_job_manifest_input::Builder {
        crate::input::get_job_manifest_input::Builder::default()
    }
}

/// See [`GetJobUnlockCodeInput`](crate::input::GetJobUnlockCodeInput)
pub mod get_job_unlock_code_input {
    /// A builder for [`GetJobUnlockCodeInput`](crate::input::GetJobUnlockCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobUnlockCodeInput`](crate::input::GetJobUnlockCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJobUnlockCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJobUnlockCodeInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobUnlockCodeInputOperationOutputAlias = crate::operation::GetJobUnlockCode;
#[doc(hidden)]
pub type GetJobUnlockCodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobUnlockCodeInput {
    /// Consumes the builder and constructs an Operation<[`GetJobUnlockCode`](crate::operation::GetJobUnlockCode)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJobUnlockCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetJobUnlockCodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetJobUnlockCodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetJobUnlockCodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.GetJobUnlockCode",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_job_unlock_code(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJobUnlockCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJobUnlockCode",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetJobUnlockCodeInput`](crate::input::GetJobUnlockCodeInput)
    pub fn builder() -> crate::input::get_job_unlock_code_input::Builder {
        crate::input::get_job_unlock_code_input::Builder::default()
    }
}

/// See [`GetSnowballUsageInput`](crate::input::GetSnowballUsageInput)
pub mod get_snowball_usage_input {
    /// A builder for [`GetSnowballUsageInput`](crate::input::GetSnowballUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetSnowballUsageInput`](crate::input::GetSnowballUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSnowballUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSnowballUsageInput {})
        }
    }
}
#[doc(hidden)]
pub type GetSnowballUsageInputOperationOutputAlias = crate::operation::GetSnowballUsage;
#[doc(hidden)]
pub type GetSnowballUsageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSnowballUsageInput {
    /// Consumes the builder and constructs an Operation<[`GetSnowballUsage`](crate::operation::GetSnowballUsage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSnowballUsage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSnowballUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSnowballUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSnowballUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.GetSnowballUsage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_snowball_usage(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSnowballUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSnowballUsage",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSnowballUsageInput`](crate::input::GetSnowballUsageInput)
    pub fn builder() -> crate::input::get_snowball_usage_input::Builder {
        crate::input::get_snowball_usage_input::Builder::default()
    }
}

/// See [`GetSoftwareUpdatesInput`](crate::input::GetSoftwareUpdatesInput)
pub mod get_software_updates_input {
    /// A builder for [`GetSoftwareUpdatesInput`](crate::input::GetSoftwareUpdatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSoftwareUpdatesInput`](crate::input::GetSoftwareUpdatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSoftwareUpdatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSoftwareUpdatesInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSoftwareUpdatesInputOperationOutputAlias = crate::operation::GetSoftwareUpdates;
#[doc(hidden)]
pub type GetSoftwareUpdatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSoftwareUpdatesInput {
    /// Consumes the builder and constructs an Operation<[`GetSoftwareUpdates`](crate::operation::GetSoftwareUpdates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSoftwareUpdates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSoftwareUpdatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSoftwareUpdatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSoftwareUpdatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.GetSoftwareUpdates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_software_updates(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSoftwareUpdates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSoftwareUpdates",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSoftwareUpdatesInput`](crate::input::GetSoftwareUpdatesInput)
    pub fn builder() -> crate::input::get_software_updates_input::Builder {
        crate::input::get_software_updates_input::Builder::default()
    }
}

/// See [`ListClusterJobsInput`](crate::input::ListClusterJobsInput)
pub mod list_cluster_jobs_input {
    /// A builder for [`ListClusterJobsInput`](crate::input::ListClusterJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClusterJobsInput`](crate::input::ListClusterJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClusterJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListClusterJobsInput {
                cluster_id: self.cluster_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListClusterJobsInputOperationOutputAlias = crate::operation::ListClusterJobs;
#[doc(hidden)]
pub type ListClusterJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListClusterJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListClusterJobs`](crate::operation::ListClusterJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClusterJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListClusterJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListClusterJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListClusterJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.ListClusterJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_cluster_jobs(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClusterJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClusterJobs",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListClusterJobsInput`](crate::input::ListClusterJobsInput)
    pub fn builder() -> crate::input::list_cluster_jobs_input::Builder {
        crate::input::list_cluster_jobs_input::Builder::default()
    }
}

/// See [`ListClustersInput`](crate::input::ListClustersInput)
pub mod list_clusters_input {
    /// A builder for [`ListClustersInput`](crate::input::ListClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of <code>ClusterListEntry</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of <code>ClusterListEntry</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClustersInput`](crate::input::ListClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListClustersInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListClustersInputOperationOutputAlias = crate::operation::ListClusters;
#[doc(hidden)]
pub type ListClustersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListClustersInput {
    /// Consumes the builder and constructs an Operation<[`ListClusters`](crate::operation::ListClusters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClusters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.ListClusters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_clusters(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClusters",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListClustersInput`](crate::input::ListClustersInput)
    pub fn builder() -> crate::input::list_clusters_input::Builder {
        crate::input::list_clusters_input::Builder::default()
    }
}

/// See [`ListCompatibleImagesInput`](crate::input::ListCompatibleImagesInput)
pub mod list_compatible_images_input {
    /// A builder for [`ListCompatibleImagesInput`](crate::input::ListCompatibleImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCompatibleImagesInput`](crate::input::ListCompatibleImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCompatibleImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCompatibleImagesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCompatibleImagesInputOperationOutputAlias = crate::operation::ListCompatibleImages;
#[doc(hidden)]
pub type ListCompatibleImagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListCompatibleImagesInput {
    /// Consumes the builder and constructs an Operation<[`ListCompatibleImages`](crate::operation::ListCompatibleImages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCompatibleImages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCompatibleImagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCompatibleImagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCompatibleImagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.ListCompatibleImages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_compatible_images(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCompatibleImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCompatibleImages",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCompatibleImagesInput`](crate::input::ListCompatibleImagesInput)
    pub fn builder() -> crate::input::list_compatible_images_input::Builder {
        crate::input::list_compatible_images_input::Builder::default()
    }
}

/// See [`ListJobsInput`](crate::input::ListJobsInput)
pub mod list_jobs_input {
    /// A builder for [`ListJobsInput`](crate::input::ListJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsInput`](crate::input::ListJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListJobsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListJobsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobsInputOperationOutputAlias = crate::operation::ListJobs;
#[doc(hidden)]
pub type ListJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobs`](crate::operation::ListJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.ListJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_jobs(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListJobs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListJobs", "snowball",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
}

/// See [`ListLongTermPricingInput`](crate::input::ListLongTermPricingInput)
pub mod list_long_term_pricing_input {
    /// A builder for [`ListLongTermPricingInput`](crate::input::ListLongTermPricingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of <code>ListLongTermPricing</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of <code>ListLongTermPricing</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Because HTTP requests are stateless, this is the starting point for your next list of <code>ListLongTermPricing</code> to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Because HTTP requests are stateless, this is the starting point for your next list of <code>ListLongTermPricing</code> to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLongTermPricingInput`](crate::input::ListLongTermPricingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLongTermPricingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLongTermPricingInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLongTermPricingInputOperationOutputAlias = crate::operation::ListLongTermPricing;
#[doc(hidden)]
pub type ListLongTermPricingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLongTermPricingInput {
    /// Consumes the builder and constructs an Operation<[`ListLongTermPricing`](crate::operation::ListLongTermPricing)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLongTermPricing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLongTermPricingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLongTermPricingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLongTermPricingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.ListLongTermPricing",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_long_term_pricing(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLongTermPricing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLongTermPricing",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLongTermPricingInput`](crate::input::ListLongTermPricingInput)
    pub fn builder() -> crate::input::list_long_term_pricing_input::Builder {
        crate::input::list_long_term_pricing_input::Builder::default()
    }
}

/// See [`UpdateClusterInput`](crate::input::UpdateClusterInput)
pub mod update_cluster_input {
    /// A builder for [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<crate::model::JobResource>,
        pub(crate) on_device_service_configuration:
            std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        pub(crate) address_id: std::option::Option<std::string::String>,
        pub(crate) shipping_option: std::option::Option<crate::model::ShippingOption>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) forwarding_address_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_id = Some(input.into());
            self
        }
        /// <p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_id = input;
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The updated description of this cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of this cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The updated arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.on_device_service_configuration = Some(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.on_device_service_configuration = input;
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// <p>The updated shipping option value of this cluster's <code>ShippingDetails</code> object.</p>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.shipping_option = Some(input);
            self
        }
        /// <p>The updated shipping option value of this cluster's <code>ShippingDetails</code> object.</p>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.shipping_option = input;
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.forwarding_address_id = Some(input.into());
            self
        }
        /// <p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forwarding_address_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterInput`](crate::input::UpdateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateClusterInput {
                cluster_id: self.cluster_id,
                role_arn: self.role_arn,
                description: self.description,
                resources: self.resources,
                on_device_service_configuration: self.on_device_service_configuration,
                address_id: self.address_id,
                shipping_option: self.shipping_option,
                notification: self.notification,
                forwarding_address_id: self.forwarding_address_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateClusterInputOperationOutputAlias = crate::operation::UpdateCluster;
#[doc(hidden)]
pub type UpdateClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateClusterInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCluster`](crate::operation::UpdateCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.UpdateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_cluster(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCluster",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    pub fn builder() -> crate::input::update_cluster_input::Builder {
        crate::input::update_cluster_input::Builder::default()
    }
}

/// See [`UpdateJobInput`](crate::input::UpdateJobInput)
pub mod update_job_input {
    /// A builder for [`UpdateJobInput`](crate::input::UpdateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) notification: std::option::Option<crate::model::Notification>,
        pub(crate) resources: std::option::Option<crate::model::JobResource>,
        pub(crate) on_device_service_configuration:
            std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        pub(crate) address_id: std::option::Option<std::string::String>,
        pub(crate) shipping_option: std::option::Option<crate::model::ShippingOption>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) snowball_capacity_preference:
            std::option::Option<crate::model::SnowballCapacity>,
        pub(crate) forwarding_address_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>Identity and Access Management (IAM) API action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>Identity and Access Management (IAM) API action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.notification = Some(input);
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.notification = input;
            self
        }
        /// <p>The updated <code>JobResource</code> object, or the updated <code>JobResource</code> object. </p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The updated <code>JobResource</code> object, or the updated <code>JobResource</code> object. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.on_device_service_configuration = Some(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.on_device_service_configuration = input;
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_id = Some(input.into());
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address_id = input;
            self
        }
        /// <p>The updated shipping option value of this job's <code>ShippingDetails</code> object.</p>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.shipping_option = Some(input);
            self
        }
        /// <p>The updated shipping option value of this job's <code>ShippingDetails</code> object.</p>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.shipping_option = input;
            self
        }
        /// <p>The updated description of this job's <code>JobMetadata</code> object.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of this job's <code>JobMetadata</code> object.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated <code>SnowballCapacityPreference</code> of this job's <code>JobMetadata</code> object. The 50 TB Snowballs are only available in the US regions.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_capacity_preference(
            mut self,
            input: crate::model::SnowballCapacity,
        ) -> Self {
            self.snowball_capacity_preference = Some(input);
            self
        }
        /// <p>The updated <code>SnowballCapacityPreference</code> of this job's <code>JobMetadata</code> object. The 50 TB Snowballs are only available in the US regions.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_capacity_preference(
            mut self,
            input: std::option::Option<crate::model::SnowballCapacity>,
        ) -> Self {
            self.snowball_capacity_preference = input;
            self
        }
        /// <p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.forwarding_address_id = Some(input.into());
            self
        }
        /// <p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.forwarding_address_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobInput`](crate::input::UpdateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateJobInput {
                job_id: self.job_id,
                role_arn: self.role_arn,
                notification: self.notification,
                resources: self.resources,
                on_device_service_configuration: self.on_device_service_configuration,
                address_id: self.address_id,
                shipping_option: self.shipping_option,
                description: self.description,
                snowball_capacity_preference: self.snowball_capacity_preference,
                forwarding_address_id: self.forwarding_address_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateJobInputOperationOutputAlias = crate::operation::UpdateJob;
#[doc(hidden)]
pub type UpdateJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateJobInput {
    /// Consumes the builder and constructs an Operation<[`UpdateJob`](crate::operation::UpdateJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.UpdateJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateJob",
                    "snowball",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateJobInput`](crate::input::UpdateJobInput)
    pub fn builder() -> crate::input::update_job_input::Builder {
        crate::input::update_job_input::Builder::default()
    }
}

/// See [`UpdateJobShipmentStateInput`](crate::input::UpdateJobShipmentStateInput)
pub mod update_job_shipment_state_input {
    /// A builder for [`UpdateJobShipmentStateInput`](crate::input::UpdateJobShipmentStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) shipment_state: std::option::Option<crate::model::ShipmentState>,
    }
    impl Builder {
        /// <p>The job ID of the job whose shipment date you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID of the job whose shipment date you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The state of a device when it is being shipped. </p>
        /// <p>Set to <code>RECEIVED</code> when the device arrives at your location.</p>
        /// <p>Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.</p>
        pub fn shipment_state(mut self, input: crate::model::ShipmentState) -> Self {
            self.shipment_state = Some(input);
            self
        }
        /// <p>The state of a device when it is being shipped. </p>
        /// <p>Set to <code>RECEIVED</code> when the device arrives at your location.</p>
        /// <p>Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.</p>
        pub fn set_shipment_state(
            mut self,
            input: std::option::Option<crate::model::ShipmentState>,
        ) -> Self {
            self.shipment_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobShipmentStateInput`](crate::input::UpdateJobShipmentStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateJobShipmentStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateJobShipmentStateInput {
                job_id: self.job_id,
                shipment_state: self.shipment_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateJobShipmentStateInputOperationOutputAlias = crate::operation::UpdateJobShipmentState;
#[doc(hidden)]
pub type UpdateJobShipmentStateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateJobShipmentStateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateJobShipmentState`](crate::operation::UpdateJobShipmentState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateJobShipmentState,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateJobShipmentStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateJobShipmentStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateJobShipmentStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.UpdateJobShipmentState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_job_shipment_state(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateJobShipmentState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateJobShipmentState",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateJobShipmentStateInput`](crate::input::UpdateJobShipmentStateInput)
    pub fn builder() -> crate::input::update_job_shipment_state_input::Builder {
        crate::input::update_job_shipment_state_input::Builder::default()
    }
}

/// See [`UpdateLongTermPricingInput`](crate::input::UpdateLongTermPricingInput)
pub mod update_long_term_pricing_input {
    /// A builder for [`UpdateLongTermPricingInput`](crate::input::UpdateLongTermPricingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) long_term_pricing_id: std::option::Option<std::string::String>,
        pub(crate) replacement_job: std::option::Option<std::string::String>,
        pub(crate) is_long_term_pricing_auto_renew: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn long_term_pricing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.long_term_pricing_id = Some(input.into());
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn set_long_term_pricing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.long_term_pricing_id = input;
            self
        }
        /// <p>Specifies that a device that is ordered with long-term pricing should be replaced with a new device.</p>
        pub fn replacement_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.replacement_job = Some(input.into());
            self
        }
        /// <p>Specifies that a device that is ordered with long-term pricing should be replaced with a new device.</p>
        pub fn set_replacement_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replacement_job = input;
            self
        }
        /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
        pub fn is_long_term_pricing_auto_renew(mut self, input: bool) -> Self {
            self.is_long_term_pricing_auto_renew = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
        pub fn set_is_long_term_pricing_auto_renew(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_long_term_pricing_auto_renew = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLongTermPricingInput`](crate::input::UpdateLongTermPricingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLongTermPricingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLongTermPricingInput {
                long_term_pricing_id: self.long_term_pricing_id,
                replacement_job: self.replacement_job,
                is_long_term_pricing_auto_renew: self.is_long_term_pricing_auto_renew,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLongTermPricingInputOperationOutputAlias = crate::operation::UpdateLongTermPricing;
#[doc(hidden)]
pub type UpdateLongTermPricingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLongTermPricingInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLongTermPricing`](crate::operation::UpdateLongTermPricing)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLongTermPricing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLongTermPricingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLongTermPricingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLongTermPricingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSIESnowballJobManagementService.UpdateLongTermPricing",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_long_term_pricing(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLongTermPricing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLongTermPricing",
            "snowball",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLongTermPricingInput`](crate::input::UpdateLongTermPricingInput)
    pub fn builder() -> crate::input::update_long_term_pricing_input::Builder {
        crate::input::update_long_term_pricing_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLongTermPricingInput {
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub long_term_pricing_id: std::option::Option<std::string::String>,
    /// <p>Specifies that a device that is ordered with long-term pricing should be replaced with a new device.</p>
    pub replacement_job: std::option::Option<std::string::String>,
    /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
    pub is_long_term_pricing_auto_renew: std::option::Option<bool>,
}
impl UpdateLongTermPricingInput {
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub fn long_term_pricing_id(&self) -> std::option::Option<&str> {
        self.long_term_pricing_id.as_deref()
    }
    /// <p>Specifies that a device that is ordered with long-term pricing should be replaced with a new device.</p>
    pub fn replacement_job(&self) -> std::option::Option<&str> {
        self.replacement_job.as_deref()
    }
    /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
    pub fn is_long_term_pricing_auto_renew(&self) -> std::option::Option<bool> {
        self.is_long_term_pricing_auto_renew
    }
}
impl std::fmt::Debug for UpdateLongTermPricingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLongTermPricingInput");
        formatter.field("long_term_pricing_id", &self.long_term_pricing_id);
        formatter.field("replacement_job", &self.replacement_job);
        formatter.field(
            "is_long_term_pricing_auto_renew",
            &self.is_long_term_pricing_auto_renew,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobShipmentStateInput {
    /// <p>The job ID of the job whose shipment date you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The state of a device when it is being shipped. </p>
    /// <p>Set to <code>RECEIVED</code> when the device arrives at your location.</p>
    /// <p>Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.</p>
    pub shipment_state: std::option::Option<crate::model::ShipmentState>,
}
impl UpdateJobShipmentStateInput {
    /// <p>The job ID of the job whose shipment date you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The state of a device when it is being shipped. </p>
    /// <p>Set to <code>RECEIVED</code> when the device arrives at your location.</p>
    /// <p>Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.</p>
    pub fn shipment_state(&self) -> std::option::Option<&crate::model::ShipmentState> {
        self.shipment_state.as_ref()
    }
}
impl std::fmt::Debug for UpdateJobShipmentStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobShipmentStateInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("shipment_state", &self.shipment_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobInput {
    /// <p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>Identity and Access Management (IAM) API action.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The new or updated <code>Notification</code> object.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The updated <code>JobResource</code> object, or the updated <code>JobResource</code> object. </p>
    pub resources: std::option::Option<crate::model::JobResource>,
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
    pub on_device_service_configuration:
        std::option::Option<crate::model::OnDeviceServiceConfiguration>,
    /// <p>The ID of the updated <code>Address</code> object.</p>
    pub address_id: std::option::Option<std::string::String>,
    /// <p>The updated shipping option value of this job's <code>ShippingDetails</code> object.</p>
    pub shipping_option: std::option::Option<crate::model::ShippingOption>,
    /// <p>The updated description of this job's <code>JobMetadata</code> object.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated <code>SnowballCapacityPreference</code> of this job's <code>JobMetadata</code> object. The 50 TB Snowballs are only available in the US regions.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub snowball_capacity_preference: std::option::Option<crate::model::SnowballCapacity>,
    /// <p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>
    pub forwarding_address_id: std::option::Option<std::string::String>,
}
impl UpdateJobInput {
    /// <p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>Identity and Access Management (IAM) API action.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The new or updated <code>Notification</code> object.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::Notification> {
        self.notification.as_ref()
    }
    /// <p>The updated <code>JobResource</code> object, or the updated <code>JobResource</code> object. </p>
    pub fn resources(&self) -> std::option::Option<&crate::model::JobResource> {
        self.resources.as_ref()
    }
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
    pub fn on_device_service_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OnDeviceServiceConfiguration> {
        self.on_device_service_configuration.as_ref()
    }
    /// <p>The ID of the updated <code>Address</code> object.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
    /// <p>The updated shipping option value of this job's <code>ShippingDetails</code> object.</p>
    pub fn shipping_option(&self) -> std::option::Option<&crate::model::ShippingOption> {
        self.shipping_option.as_ref()
    }
    /// <p>The updated description of this job's <code>JobMetadata</code> object.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated <code>SnowballCapacityPreference</code> of this job's <code>JobMetadata</code> object. The 50 TB Snowballs are only available in the US regions.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub fn snowball_capacity_preference(
        &self,
    ) -> std::option::Option<&crate::model::SnowballCapacity> {
        self.snowball_capacity_preference.as_ref()
    }
    /// <p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>
    pub fn forwarding_address_id(&self) -> std::option::Option<&str> {
        self.forwarding_address_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("notification", &self.notification);
        formatter.field("resources", &self.resources);
        formatter.field(
            "on_device_service_configuration",
            &self.on_device_service_configuration,
        );
        formatter.field("address_id", &self.address_id);
        formatter.field("shipping_option", &self.shipping_option);
        formatter.field("description", &self.description);
        formatter.field(
            "snowball_capacity_preference",
            &self.snowball_capacity_preference,
        );
        formatter.field("forwarding_address_id", &self.forwarding_address_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterInput {
    /// <p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The updated description of this cluster.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
    pub resources: std::option::Option<crate::model::JobResource>,
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
    pub on_device_service_configuration:
        std::option::Option<crate::model::OnDeviceServiceConfiguration>,
    /// <p>The ID of the updated <code>Address</code> object.</p>
    pub address_id: std::option::Option<std::string::String>,
    /// <p>The updated shipping option value of this cluster's <code>ShippingDetails</code> object.</p>
    pub shipping_option: std::option::Option<crate::model::ShippingOption>,
    /// <p>The new or updated <code>Notification</code> object.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>
    pub forwarding_address_id: std::option::Option<std::string::String>,
}
impl UpdateClusterInput {
    /// <p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The updated description of this cluster.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
    pub fn resources(&self) -> std::option::Option<&crate::model::JobResource> {
        self.resources.as_ref()
    }
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
    pub fn on_device_service_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OnDeviceServiceConfiguration> {
        self.on_device_service_configuration.as_ref()
    }
    /// <p>The ID of the updated <code>Address</code> object.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
    /// <p>The updated shipping option value of this cluster's <code>ShippingDetails</code> object.</p>
    pub fn shipping_option(&self) -> std::option::Option<&crate::model::ShippingOption> {
        self.shipping_option.as_ref()
    }
    /// <p>The new or updated <code>Notification</code> object.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::Notification> {
        self.notification.as_ref()
    }
    /// <p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>
    pub fn forwarding_address_id(&self) -> std::option::Option<&str> {
        self.forwarding_address_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("description", &self.description);
        formatter.field("resources", &self.resources);
        formatter.field(
            "on_device_service_configuration",
            &self.on_device_service_configuration,
        );
        formatter.field("address_id", &self.address_id);
        formatter.field("shipping_option", &self.shipping_option);
        formatter.field("notification", &self.notification);
        formatter.field("forwarding_address_id", &self.forwarding_address_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLongTermPricingInput {
    /// <p>The maximum number of <code>ListLongTermPricing</code> objects to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Because HTTP requests are stateless, this is the starting point for your next list of <code>ListLongTermPricing</code> to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLongTermPricingInput {
    /// <p>The maximum number of <code>ListLongTermPricing</code> objects to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Because HTTP requests are stateless, this is the starting point for your next list of <code>ListLongTermPricing</code> to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLongTermPricingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLongTermPricingInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsInput {
    /// <p>The number of <code>JobListEntry</code> objects to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsInput {
    /// <p>The number of <code>JobListEntry</code> objects to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCompatibleImagesInput {
    /// <p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCompatibleImagesInput {
    /// <p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCompatibleImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCompatibleImagesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClustersInput {
    /// <p>The number of <code>ClusterListEntry</code> objects to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListClustersInput {
    /// <p>The number of <code>ClusterListEntry</code> objects to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClustersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClusterJobsInput {
    /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The number of <code>JobListEntry</code> objects to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListClusterJobsInput {
    /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The number of <code>JobListEntry</code> objects to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListClusterJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClusterJobsInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSoftwareUpdatesInput {
    /// <p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetSoftwareUpdatesInput {
    /// <p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetSoftwareUpdatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSoftwareUpdatesInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSnowballUsageInput {}
impl std::fmt::Debug for GetSnowballUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSnowballUsageInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobUnlockCodeInput {
    /// <p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetJobUnlockCodeInput {
    /// <p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetJobUnlockCodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobUnlockCodeInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobManifestInput {
    /// <p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetJobManifestInput {
    /// <p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetJobManifestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobManifestInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReturnShippingLabelInput {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeReturnShippingLabelInput {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeReturnShippingLabelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReturnShippingLabelInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobInput {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeJobInput {
    /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterInput {
    /// <p>The automatically generated ID for a cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl DescribeClusterInput {
    /// <p>The automatically generated ID for a cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAddressesInput {
    /// <p>The number of <code>ADDRESS</code> objects to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAddressesInput {
    /// <p>The number of <code>ADDRESS</code> objects to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAddressesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAddressesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAddressInput {
    /// <p>The automatically generated ID for a specific address.</p>
    pub address_id: std::option::Option<std::string::String>,
}
impl DescribeAddressInput {
    /// <p>The automatically generated ID for a specific address.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAddressInput");
        formatter.field("address_id", &self.address_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReturnShippingLabelInput {
    /// <p>The ID for a job that you want to create the return shipping label for; for example, <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    pub shipping_option: std::option::Option<crate::model::ShippingOption>,
}
impl CreateReturnShippingLabelInput {
    /// <p>The ID for a job that you want to create the return shipping label for; for example, <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    pub fn shipping_option(&self) -> std::option::Option<&crate::model::ShippingOption> {
        self.shipping_option.as_ref()
    }
}
impl std::fmt::Debug for CreateReturnShippingLabelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReturnShippingLabelInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("shipping_option", &self.shipping_option);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLongTermPricingInput {
    /// <p>The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.</p>
    pub long_term_pricing_type: std::option::Option<crate::model::LongTermPricingType>,
    /// <p>Specifies whether the current long-term pricing type for the device should be renewed.</p>
    pub is_long_term_pricing_auto_renew: std::option::Option<bool>,
    /// <p>The type of Snow Family Devices to use for the long-term pricing job.</p>
    pub snowball_type: std::option::Option<crate::model::SnowballType>,
}
impl CreateLongTermPricingInput {
    /// <p>The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.</p>
    pub fn long_term_pricing_type(
        &self,
    ) -> std::option::Option<&crate::model::LongTermPricingType> {
        self.long_term_pricing_type.as_ref()
    }
    /// <p>Specifies whether the current long-term pricing type for the device should be renewed.</p>
    pub fn is_long_term_pricing_auto_renew(&self) -> std::option::Option<bool> {
        self.is_long_term_pricing_auto_renew
    }
    /// <p>The type of Snow Family Devices to use for the long-term pricing job.</p>
    pub fn snowball_type(&self) -> std::option::Option<&crate::model::SnowballType> {
        self.snowball_type.as_ref()
    }
}
impl std::fmt::Debug for CreateLongTermPricingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLongTermPricingInput");
        formatter.field("long_term_pricing_type", &self.long_term_pricing_type);
        formatter.field(
            "is_long_term_pricing_auto_renew",
            &self.is_long_term_pricing_auto_renew,
        );
        formatter.field("snowball_type", &self.snowball_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobInput {
    /// <p>Defines the type of job that you're creating. </p>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p>Defines the Amazon S3 buckets associated with this job.</p>
    /// <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p>
    /// <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>
    pub resources: std::option::Option<crate::model::JobResource>,
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
    pub on_device_service_configuration:
        std::option::Option<crate::model::OnDeviceServiceConfiguration>,
    /// <p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID for the address that you want the Snow device shipped to.</p>
    pub address_id: std::option::Option<std::string::String>,
    /// <p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management Service (KMS) API action.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access Management (IAM) API action.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub snowball_capacity_preference: std::option::Option<crate::model::SnowballCapacity>,
    /// <p>The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub shipping_option: std::option::Option<crate::model::ShippingOption>,
    /// <p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>
    pub cluster_id: std::option::Option<std::string::String>,
    /// <p>The type of Snow Family Devices to use for this job. </p> <note>
    /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
    /// </note>
    /// <p>The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub snowball_type: std::option::Option<crate::model::SnowballType>,
    /// <p>The forwarding address ID for a job. This field is not supported in most Regions.</p>
    pub forwarding_address_id: std::option::Option<std::string::String>,
    /// <p>The tax documents required in your Amazon Web Services Region.</p>
    pub tax_documents: std::option::Option<crate::model::TaxDocuments>,
    /// <p>Defines the device configuration for an Snowcone job.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub device_configuration: std::option::Option<crate::model::DeviceConfiguration>,
    /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    pub remote_management: std::option::Option<crate::model::RemoteManagement>,
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub long_term_pricing_id: std::option::Option<std::string::String>,
}
impl CreateJobInput {
    /// <p>Defines the type of job that you're creating. </p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p>Defines the Amazon S3 buckets associated with this job.</p>
    /// <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p>
    /// <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>
    pub fn resources(&self) -> std::option::Option<&crate::model::JobResource> {
        self.resources.as_ref()
    }
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
    pub fn on_device_service_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OnDeviceServiceConfiguration> {
        self.on_device_service_configuration.as_ref()
    }
    /// <p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID for the address that you want the Snow device shipped to.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
    /// <p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management Service (KMS) API action.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access Management (IAM) API action.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub fn snowball_capacity_preference(
        &self,
    ) -> std::option::Option<&crate::model::SnowballCapacity> {
        self.snowball_capacity_preference.as_ref()
    }
    /// <p>The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub fn shipping_option(&self) -> std::option::Option<&crate::model::ShippingOption> {
        self.shipping_option.as_ref()
    }
    /// <p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::Notification> {
        self.notification.as_ref()
    }
    /// <p>The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
    /// <p>The type of Snow Family Devices to use for this job. </p> <note>
    /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
    /// </note>
    /// <p>The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub fn snowball_type(&self) -> std::option::Option<&crate::model::SnowballType> {
        self.snowball_type.as_ref()
    }
    /// <p>The forwarding address ID for a job. This field is not supported in most Regions.</p>
    pub fn forwarding_address_id(&self) -> std::option::Option<&str> {
        self.forwarding_address_id.as_deref()
    }
    /// <p>The tax documents required in your Amazon Web Services Region.</p>
    pub fn tax_documents(&self) -> std::option::Option<&crate::model::TaxDocuments> {
        self.tax_documents.as_ref()
    }
    /// <p>Defines the device configuration for an Snowcone job.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub fn device_configuration(&self) -> std::option::Option<&crate::model::DeviceConfiguration> {
        self.device_configuration.as_ref()
    }
    /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    pub fn remote_management(&self) -> std::option::Option<&crate::model::RemoteManagement> {
        self.remote_management.as_ref()
    }
    /// <p>The ID of the long-term pricing type for the device.</p>
    pub fn long_term_pricing_id(&self) -> std::option::Option<&str> {
        self.long_term_pricing_id.as_deref()
    }
}
impl std::fmt::Debug for CreateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobInput");
        formatter.field("job_type", &self.job_type);
        formatter.field("resources", &self.resources);
        formatter.field(
            "on_device_service_configuration",
            &self.on_device_service_configuration,
        );
        formatter.field("description", &self.description);
        formatter.field("address_id", &self.address_id);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field(
            "snowball_capacity_preference",
            &self.snowball_capacity_preference,
        );
        formatter.field("shipping_option", &self.shipping_option);
        formatter.field("notification", &self.notification);
        formatter.field("cluster_id", &self.cluster_id);
        formatter.field("snowball_type", &self.snowball_type);
        formatter.field("forwarding_address_id", &self.forwarding_address_id);
        formatter.field("tax_documents", &self.tax_documents);
        formatter.field("device_configuration", &self.device_configuration);
        formatter.field("remote_management", &self.remote_management);
        formatter.field("long_term_pricing_id", &self.long_term_pricing_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterInput {
    /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language. </p>
    pub resources: std::option::Option<crate::model::JobResource>,
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
    pub on_device_service_configuration:
        std::option::Option<crate::model::OnDeviceServiceConfiguration>,
    /// <p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID for the address that you want the cluster shipped to.</p>
    pub address_id: std::option::Option<std::string::String>,
    /// <p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS). </p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The type of Snow Family Devices to use for this cluster. </p> <note>
    /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
    /// </note>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub snowball_type: std::option::Option<crate::model::SnowballType>,
    /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub shipping_option: std::option::Option<crate::model::ShippingOption>,
    /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
    pub notification: std::option::Option<crate::model::Notification>,
    /// <p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>
    pub forwarding_address_id: std::option::Option<std::string::String>,
    /// <p>The tax documents required in your Amazon Web Services Region.</p>
    pub tax_documents: std::option::Option<crate::model::TaxDocuments>,
    /// <p>Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    pub remote_management: std::option::Option<crate::model::RemoteManagement>,
}
impl CreateClusterInput {
    /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language. </p>
    pub fn resources(&self) -> std::option::Option<&crate::model::JobResource> {
        self.resources.as_ref()
    }
    /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
    pub fn on_device_service_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OnDeviceServiceConfiguration> {
        self.on_device_service_configuration.as_ref()
    }
    /// <p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID for the address that you want the cluster shipped to.</p>
    pub fn address_id(&self) -> std::option::Option<&str> {
        self.address_id.as_deref()
    }
    /// <p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS). </p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The type of Snow Family Devices to use for this cluster. </p> <note>
    /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
    /// </note>
    /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    pub fn snowball_type(&self) -> std::option::Option<&crate::model::SnowballType> {
        self.snowball_type.as_ref()
    }
    /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    /// <ul>
    /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
    /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
    /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
    /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
    /// </ul>
    pub fn shipping_option(&self) -> std::option::Option<&crate::model::ShippingOption> {
        self.shipping_option.as_ref()
    }
    /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
    pub fn notification(&self) -> std::option::Option<&crate::model::Notification> {
        self.notification.as_ref()
    }
    /// <p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>
    pub fn forwarding_address_id(&self) -> std::option::Option<&str> {
        self.forwarding_address_id.as_deref()
    }
    /// <p>The tax documents required in your Amazon Web Services Region.</p>
    pub fn tax_documents(&self) -> std::option::Option<&crate::model::TaxDocuments> {
        self.tax_documents.as_ref()
    }
    /// <p>Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    pub fn remote_management(&self) -> std::option::Option<&crate::model::RemoteManagement> {
        self.remote_management.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterInput");
        formatter.field("job_type", &self.job_type);
        formatter.field("resources", &self.resources);
        formatter.field(
            "on_device_service_configuration",
            &self.on_device_service_configuration,
        );
        formatter.field("description", &self.description);
        formatter.field("address_id", &self.address_id);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("snowball_type", &self.snowball_type);
        formatter.field("shipping_option", &self.shipping_option);
        formatter.field("notification", &self.notification);
        formatter.field("forwarding_address_id", &self.forwarding_address_id);
        formatter.field("tax_documents", &self.tax_documents);
        formatter.field("remote_management", &self.remote_management);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAddressInput {
    /// <p>The address that you want the Snow device shipped to.</p>
    pub address: std::option::Option<crate::model::Address>,
}
impl CreateAddressInput {
    /// <p>The address that you want the Snow device shipped to.</p>
    pub fn address(&self) -> std::option::Option<&crate::model::Address> {
        self.address.as_ref()
    }
}
impl std::fmt::Debug for CreateAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAddressInput");
        formatter.field("address", &self.address);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobInput {
    /// <p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl CancelJobInput {
    /// <p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for CancelJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelClusterInput {
    /// <p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub cluster_id: std::option::Option<std::string::String>,
}
impl CancelClusterInput {
    /// <p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    pub fn cluster_id(&self) -> std::option::Option<&str> {
        self.cluster_id.as_deref()
    }
}
impl std::fmt::Debug for CancelClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelClusterInput");
        formatter.field("cluster_id", &self.cluster_id);
        formatter.finish()
    }
}
