// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Import/Export Snowball
///
/// Client for invoking operations on Amazon Import/Export Snowball. Each operation on Amazon Import/Export Snowball is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_snowball::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_snowball::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_snowball::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CancelCluster`](crate::client::fluent_builders::CancelCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::CancelCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::CancelCluster::set_cluster_id): <p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On success, responds with [`CancelClusterOutput`](crate::output::CancelClusterOutput)

    /// - On failure, responds with [`SdkError<CancelClusterError>`](crate::error::CancelClusterError)
    pub fn cancel_cluster(&self) -> fluent_builders::CancelCluster<C, M, R> {
        fluent_builders::CancelCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelJob`](crate::client::fluent_builders::CancelJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CancelJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CancelJob::set_job_id): <p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On success, responds with [`CancelJobOutput`](crate::output::CancelJobOutput)

    /// - On failure, responds with [`SdkError<CancelJobError>`](crate::error::CancelJobError)
    pub fn cancel_job(&self) -> fluent_builders::CancelJob<C, M, R> {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAddress`](crate::client::fluent_builders::CreateAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`address(Address)`](crate::client::fluent_builders::CreateAddress::address) / [`set_address(Option<Address>)`](crate::client::fluent_builders::CreateAddress::set_address): <p>The address that you want the Snow device shipped to.</p>
    /// - On success, responds with [`CreateAddressOutput`](crate::output::CreateAddressOutput) with field(s):
    ///   - [`address_id(Option<String>)`](crate::output::CreateAddressOutput::address_id): <p>The automatically generated ID for a specific address. You'll use this ID when you create a job to specify which address you want the Snow device for that job shipped to.</p>
    /// - On failure, responds with [`SdkError<CreateAddressError>`](crate::error::CreateAddressError)
    pub fn create_address(&self) -> fluent_builders::CreateAddress<C, M, R> {
        fluent_builders::CreateAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCluster`](crate::client::fluent_builders::CreateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_type(JobType)`](crate::client::fluent_builders::CreateCluster::job_type) / [`set_job_type(Option<JobType>)`](crate::client::fluent_builders::CreateCluster::set_job_type): <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>  <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    ///   - [`resources(JobResource)`](crate::client::fluent_builders::CreateCluster::resources) / [`set_resources(Option<JobResource>)`](crate::client::fluent_builders::CreateCluster::set_resources): <p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language. </p>
    ///   - [`on_device_service_configuration(OnDeviceServiceConfiguration)`](crate::client::fluent_builders::CreateCluster::on_device_service_configuration) / [`set_on_device_service_configuration(Option<OnDeviceServiceConfiguration>)`](crate::client::fluent_builders::CreateCluster::set_on_device_service_configuration): <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_description): <p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>
    ///   - [`address_id(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::address_id) / [`set_address_id(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_address_id): <p>The ID for the address that you want the cluster shipped to.</p>
    ///   - [`kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::kms_key_arn) / [`set_kms_key_arn(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_kms_key_arn): <p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS). </p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_role_arn): <p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    ///   - [`snowball_type(SnowballType)`](crate::client::fluent_builders::CreateCluster::snowball_type) / [`set_snowball_type(Option<SnowballType>)`](crate::client::fluent_builders::CreateCluster::set_snowball_type): <p>The type of Snow Family Devices to use for this cluster. </p> <note>   <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>  </note>  <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    ///   - [`shipping_option(ShippingOption)`](crate::client::fluent_builders::CreateCluster::shipping_option) / [`set_shipping_option(Option<ShippingOption>)`](crate::client::fluent_builders::CreateCluster::set_shipping_option): <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p>  <ul>   <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>   <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>   <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>   <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>  </ul>  <ul>   <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>   <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>   <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>   <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>  </ul>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::CreateCluster::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::CreateCluster::set_notification): <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
    ///   - [`forwarding_address_id(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::forwarding_address_id) / [`set_forwarding_address_id(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_forwarding_address_id): <p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>
    ///   - [`tax_documents(TaxDocuments)`](crate::client::fluent_builders::CreateCluster::tax_documents) / [`set_tax_documents(Option<TaxDocuments>)`](crate::client::fluent_builders::CreateCluster::set_tax_documents): <p>The tax documents required in your Amazon Web Services Region.</p>
    ///   - [`remote_management(RemoteManagement)`](crate::client::fluent_builders::CreateCluster::remote_management) / [`set_remote_management(Option<RemoteManagement>)`](crate::client::fluent_builders::CreateCluster::set_remote_management): <p>Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    /// - On success, responds with [`CreateClusterOutput`](crate::output::CreateClusterOutput) with field(s):
    ///   - [`cluster_id(Option<String>)`](crate::output::CreateClusterOutput::cluster_id): <p>The automatically generated ID for a cluster.</p>
    /// - On failure, responds with [`SdkError<CreateClusterError>`](crate::error::CreateClusterError)
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster<C, M, R> {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJob`](crate::client::fluent_builders::CreateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_type(JobType)`](crate::client::fluent_builders::CreateJob::job_type) / [`set_job_type(Option<JobType>)`](crate::client::fluent_builders::CreateJob::set_job_type): <p>Defines the type of job that you're creating. </p>
    ///   - [`resources(JobResource)`](crate::client::fluent_builders::CreateJob::resources) / [`set_resources(Option<JobResource>)`](crate::client::fluent_builders::CreateJob::set_resources): <p>Defines the Amazon S3 buckets associated with this job.</p>  <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p>  <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>
    ///   - [`on_device_service_configuration(OnDeviceServiceConfiguration)`](crate::client::fluent_builders::CreateJob::on_device_service_configuration) / [`set_on_device_service_configuration(Option<OnDeviceServiceConfiguration>)`](crate::client::fluent_builders::CreateJob::set_on_device_service_configuration): <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateJob::set_description): <p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
    ///   - [`address_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::address_id) / [`set_address_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_address_id): <p>The ID for the address that you want the Snow device shipped to.</p>
    ///   - [`kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateJob::kms_key_arn) / [`set_kms_key_arn(Option<String>)`](crate::client::fluent_builders::CreateJob::set_kms_key_arn): <p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management Service (KMS) API action.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateJob::set_role_arn): <p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access Management (IAM) API action.</p>
    ///   - [`snowball_capacity_preference(SnowballCapacity)`](crate::client::fluent_builders::CreateJob::snowball_capacity_preference) / [`set_snowball_capacity_preference(Option<SnowballCapacity>)`](crate::client::fluent_builders::CreateJob::set_snowball_capacity_preference): <p>If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>  <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    ///   - [`shipping_option(ShippingOption)`](crate::client::fluent_builders::CreateJob::shipping_option) / [`set_shipping_option(Option<ShippingOption>)`](crate::client::fluent_builders::CreateJob::set_shipping_option): <p>The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:</p>  <ul>   <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>   <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>   <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>   <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>  </ul>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::CreateJob::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::CreateJob::set_notification): <p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_cluster_id): <p>The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>
    ///   - [`snowball_type(SnowballType)`](crate::client::fluent_builders::CreateJob::snowball_type) / [`set_snowball_type(Option<SnowballType>)`](crate::client::fluent_builders::CreateJob::set_snowball_type): <p>The type of Snow Family Devices to use for this job. </p> <note>   <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>  </note>  <p>The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>  <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    ///   - [`forwarding_address_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::forwarding_address_id) / [`set_forwarding_address_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_forwarding_address_id): <p>The forwarding address ID for a job. This field is not supported in most Regions.</p>
    ///   - [`tax_documents(TaxDocuments)`](crate::client::fluent_builders::CreateJob::tax_documents) / [`set_tax_documents(Option<TaxDocuments>)`](crate::client::fluent_builders::CreateJob::set_tax_documents): <p>The tax documents required in your Amazon Web Services Region.</p>
    ///   - [`device_configuration(DeviceConfiguration)`](crate::client::fluent_builders::CreateJob::device_configuration) / [`set_device_configuration(Option<DeviceConfiguration>)`](crate::client::fluent_builders::CreateJob::set_device_configuration): <p>Defines the device configuration for an Snowcone job.</p>  <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    ///   - [`remote_management(RemoteManagement)`](crate::client::fluent_builders::CreateJob::remote_management) / [`set_remote_management(Option<RemoteManagement>)`](crate::client::fluent_builders::CreateJob::set_remote_management): <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
    ///   - [`long_term_pricing_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::long_term_pricing_id) / [`set_long_term_pricing_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_long_term_pricing_id): <p>The ID of the long-term pricing type for the device.</p>
    /// - On success, responds with [`CreateJobOutput`](crate::output::CreateJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::CreateJobOutput::job_id): <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On failure, responds with [`SdkError<CreateJobError>`](crate::error::CreateJobError)
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLongTermPricing`](crate::client::fluent_builders::CreateLongTermPricing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`long_term_pricing_type(LongTermPricingType)`](crate::client::fluent_builders::CreateLongTermPricing::long_term_pricing_type) / [`set_long_term_pricing_type(Option<LongTermPricingType>)`](crate::client::fluent_builders::CreateLongTermPricing::set_long_term_pricing_type): <p>The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.</p>
    ///   - [`is_long_term_pricing_auto_renew(bool)`](crate::client::fluent_builders::CreateLongTermPricing::is_long_term_pricing_auto_renew) / [`set_is_long_term_pricing_auto_renew(Option<bool>)`](crate::client::fluent_builders::CreateLongTermPricing::set_is_long_term_pricing_auto_renew): <p>Specifies whether the current long-term pricing type for the device should be renewed.</p>
    ///   - [`snowball_type(SnowballType)`](crate::client::fluent_builders::CreateLongTermPricing::snowball_type) / [`set_snowball_type(Option<SnowballType>)`](crate::client::fluent_builders::CreateLongTermPricing::set_snowball_type): <p>The type of Snow Family Devices to use for the long-term pricing job.</p>
    /// - On success, responds with [`CreateLongTermPricingOutput`](crate::output::CreateLongTermPricingOutput) with field(s):
    ///   - [`long_term_pricing_id(Option<String>)`](crate::output::CreateLongTermPricingOutput::long_term_pricing_id): <p>The ID of the long-term pricing type for the device.</p>
    /// - On failure, responds with [`SdkError<CreateLongTermPricingError>`](crate::error::CreateLongTermPricingError)
    pub fn create_long_term_pricing(&self) -> fluent_builders::CreateLongTermPricing<C, M, R> {
        fluent_builders::CreateLongTermPricing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReturnShippingLabel`](crate::client::fluent_builders::CreateReturnShippingLabel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::CreateReturnShippingLabel::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::CreateReturnShippingLabel::set_job_id): <p>The ID for a job that you want to create the return shipping label for; for example, <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    ///   - [`shipping_option(ShippingOption)`](crate::client::fluent_builders::CreateReturnShippingLabel::shipping_option) / [`set_shipping_option(Option<ShippingOption>)`](crate::client::fluent_builders::CreateReturnShippingLabel::set_shipping_option): <p>The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
    /// - On success, responds with [`CreateReturnShippingLabelOutput`](crate::output::CreateReturnShippingLabelOutput) with field(s):
    ///   - [`status(Option<ShippingLabelStatus>)`](crate::output::CreateReturnShippingLabelOutput::status): <p>The status information of the task on a Snow device that is being returned to Amazon Web Services.</p>
    /// - On failure, responds with [`SdkError<CreateReturnShippingLabelError>`](crate::error::CreateReturnShippingLabelError)
    pub fn create_return_shipping_label(
        &self,
    ) -> fluent_builders::CreateReturnShippingLabel<C, M, R> {
        fluent_builders::CreateReturnShippingLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAddress`](crate::client::fluent_builders::DescribeAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`address_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAddress::address_id) / [`set_address_id(Option<String>)`](crate::client::fluent_builders::DescribeAddress::set_address_id): <p>The automatically generated ID for a specific address.</p>
    /// - On success, responds with [`DescribeAddressOutput`](crate::output::DescribeAddressOutput) with field(s):
    ///   - [`address(Option<Address>)`](crate::output::DescribeAddressOutput::address): <p>The address that you want the Snow device(s) associated with a specific job to be shipped to.</p>
    /// - On failure, responds with [`SdkError<DescribeAddressError>`](crate::error::DescribeAddressError)
    pub fn describe_address(&self) -> fluent_builders::DescribeAddress<C, M, R> {
        fluent_builders::DescribeAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAddresses`](crate::client::fluent_builders::DescribeAddresses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAddresses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAddresses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAddresses::set_max_results): <p>The number of <code>ADDRESS</code> objects to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAddresses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAddresses::set_next_token): <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>
    /// - On success, responds with [`DescribeAddressesOutput`](crate::output::DescribeAddressesOutput) with field(s):
    ///   - [`addresses(Option<Vec<Address>>)`](crate::output::DescribeAddressesOutput::addresses): <p>The Snow device shipping addresses that were created for this account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAddressesOutput::next_token): <p>HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in the array.</p>
    /// - On failure, responds with [`SdkError<DescribeAddressesError>`](crate::error::DescribeAddressesError)
    pub fn describe_addresses(&self) -> fluent_builders::DescribeAddresses<C, M, R> {
        fluent_builders::DescribeAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCluster`](crate::client::fluent_builders::DescribeCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::DescribeCluster::set_cluster_id): <p>The automatically generated ID for a cluster.</p>
    /// - On success, responds with [`DescribeClusterOutput`](crate::output::DescribeClusterOutput) with field(s):
    ///   - [`cluster_metadata(Option<ClusterMetadata>)`](crate::output::DescribeClusterOutput::cluster_metadata): <p>Information about a specific cluster, including shipping information, cluster status, and other important metadata.</p>
    /// - On failure, responds with [`SdkError<DescribeClusterError>`](crate::error::DescribeClusterError)
    pub fn describe_cluster(&self) -> fluent_builders::DescribeCluster<C, M, R> {
        fluent_builders::DescribeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJob`](crate::client::fluent_builders::DescribeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeJob::set_job_id): <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On success, responds with [`DescribeJobOutput`](crate::output::DescribeJobOutput) with field(s):
    ///   - [`job_metadata(Option<JobMetadata>)`](crate::output::DescribeJobOutput::job_metadata): <p>Information about a specific job, including shipping information, job status, and other important metadata.</p>
    ///   - [`sub_job_metadata(Option<Vec<JobMetadata>>)`](crate::output::DescribeJobOutput::sub_job_metadata): <p>Information about a specific job part (in the case of an export job), including shipping information, job status, and other important metadata.</p>
    /// - On failure, responds with [`SdkError<DescribeJobError>`](crate::error::DescribeJobError)
    pub fn describe_job(&self) -> fluent_builders::DescribeJob<C, M, R> {
        fluent_builders::DescribeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReturnShippingLabel`](crate::client::fluent_builders::DescribeReturnShippingLabel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReturnShippingLabel::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeReturnShippingLabel::set_job_id): <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On success, responds with [`DescribeReturnShippingLabelOutput`](crate::output::DescribeReturnShippingLabelOutput) with field(s):
    ///   - [`status(Option<ShippingLabelStatus>)`](crate::output::DescribeReturnShippingLabelOutput::status): <p>The status information of the task on a Snow device that is being returned to Amazon Web Services.</p>
    ///   - [`expiration_date(Option<DateTime>)`](crate::output::DescribeReturnShippingLabelOutput::expiration_date): <p>The expiration date of the current return shipping label.</p>
    ///   - [`return_shipping_label_uri(Option<String>)`](crate::output::DescribeReturnShippingLabelOutput::return_shipping_label_uri): <p>The pre-signed Amazon S3 URI used to download the return shipping label.</p>
    /// - On failure, responds with [`SdkError<DescribeReturnShippingLabelError>`](crate::error::DescribeReturnShippingLabelError)
    pub fn describe_return_shipping_label(
        &self,
    ) -> fluent_builders::DescribeReturnShippingLabel<C, M, R> {
        fluent_builders::DescribeReturnShippingLabel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJobManifest`](crate::client::fluent_builders::GetJobManifest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetJobManifest::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetJobManifest::set_job_id): <p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On success, responds with [`GetJobManifestOutput`](crate::output::GetJobManifestOutput) with field(s):
    ///   - [`manifest_uri(Option<String>)`](crate::output::GetJobManifestOutput::manifest_uri): <p>The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.</p>
    /// - On failure, responds with [`SdkError<GetJobManifestError>`](crate::error::GetJobManifestError)
    pub fn get_job_manifest(&self) -> fluent_builders::GetJobManifest<C, M, R> {
        fluent_builders::GetJobManifest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJobUnlockCode`](crate::client::fluent_builders::GetJobUnlockCode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetJobUnlockCode::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetJobUnlockCode::set_job_id): <p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On success, responds with [`GetJobUnlockCodeOutput`](crate::output::GetJobUnlockCodeOutput) with field(s):
    ///   - [`unlock_code(Option<String>)`](crate::output::GetJobUnlockCodeOutput::unlock_code): <p>The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be accessed for up to 360 days after the job has been created.</p>
    /// - On failure, responds with [`SdkError<GetJobUnlockCodeError>`](crate::error::GetJobUnlockCodeError)
    pub fn get_job_unlock_code(&self) -> fluent_builders::GetJobUnlockCode<C, M, R> {
        fluent_builders::GetJobUnlockCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSnowballUsage`](crate::client::fluent_builders::GetSnowballUsage) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetSnowballUsage::send) it.

    /// - On success, responds with [`GetSnowballUsageOutput`](crate::output::GetSnowballUsageOutput) with field(s):
    ///   - [`snowball_limit(Option<i32>)`](crate::output::GetSnowballUsageOutput::snowball_limit): <p>The service limit for number of Snow devices this account can have at once. The default service limit is 1 (one).</p>
    ///   - [`snowballs_in_use(Option<i32>)`](crate::output::GetSnowballUsageOutput::snowballs_in_use): <p>The number of Snow devices that this account is currently using.</p>
    /// - On failure, responds with [`SdkError<GetSnowballUsageError>`](crate::error::GetSnowballUsageError)
    pub fn get_snowball_usage(&self) -> fluent_builders::GetSnowballUsage<C, M, R> {
        fluent_builders::GetSnowballUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSoftwareUpdates`](crate::client::fluent_builders::GetSoftwareUpdates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetSoftwareUpdates::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetSoftwareUpdates::set_job_id): <p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    /// - On success, responds with [`GetSoftwareUpdatesOutput`](crate::output::GetSoftwareUpdatesOutput) with field(s):
    ///   - [`updates_uri(Option<String>)`](crate::output::GetSoftwareUpdatesOutput::updates_uri): <p>The Amazon S3 presigned URL for the update file associated with the specified <code>JobId</code> value. The software update will be available for 2 days after this request is made. To access an update after the 2 days have passed, you'll have to make another call to <code>GetSoftwareUpdates</code>.</p>
    /// - On failure, responds with [`SdkError<GetSoftwareUpdatesError>`](crate::error::GetSoftwareUpdatesError)
    pub fn get_software_updates(&self) -> fluent_builders::GetSoftwareUpdates<C, M, R> {
        fluent_builders::GetSoftwareUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClusterJobs`](crate::client::fluent_builders::ListClusterJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListClusterJobs::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::ListClusterJobs::set_cluster_id): <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListClusterJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListClusterJobs::set_max_results): <p>The number of <code>JobListEntry</code> objects to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListClusterJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListClusterJobs::set_next_token): <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    /// - On success, responds with [`ListClusterJobsOutput`](crate::output::ListClusterJobsOutput) with field(s):
    ///   - [`job_list_entries(Option<Vec<JobListEntry>>)`](crate::output::ListClusterJobsOutput::job_list_entries): <p>Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of export jobs. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListClusterJobsOutput::next_token): <p>HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.</p>
    /// - On failure, responds with [`SdkError<ListClusterJobsError>`](crate::error::ListClusterJobsError)
    pub fn list_cluster_jobs(&self) -> fluent_builders::ListClusterJobs<C, M, R> {
        fluent_builders::ListClusterJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClusters`](crate::client::fluent_builders::ListClusters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListClusters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListClusters::set_max_results): <p>The number of <code>ClusterListEntry</code> objects to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListClusters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListClusters::set_next_token): <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    /// - On success, responds with [`ListClustersOutput`](crate::output::ListClustersOutput) with field(s):
    ///   - [`cluster_list_entries(Option<Vec<ClusterListEntry>>)`](crate::output::ListClustersOutput::cluster_list_entries): <p>Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status information.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListClustersOutput::next_token): <p>HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the array.</p>
    /// - On failure, responds with [`SdkError<ListClustersError>`](crate::error::ListClustersError)
    pub fn list_clusters(&self) -> fluent_builders::ListClusters<C, M, R> {
        fluent_builders::ListClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCompatibleImages`](crate::client::fluent_builders::ListCompatibleImages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCompatibleImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCompatibleImages::set_max_results): <p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCompatibleImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCompatibleImages::set_next_token): <p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>
    /// - On success, responds with [`ListCompatibleImagesOutput`](crate::output::ListCompatibleImagesOutput) with field(s):
    ///   - [`compatible_images(Option<Vec<CompatibleImage>>)`](crate::output::ListCompatibleImagesOutput::compatible_images): <p>A JSON-formatted object that describes a compatible AMI, including the ID and name for a Snow device AMI.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCompatibleImagesOutput::next_token): <p>Because HTTP requests are stateless, this is the starting point for your next list of returned images.</p>
    /// - On failure, responds with [`SdkError<ListCompatibleImagesError>`](crate::error::ListCompatibleImagesError)
    pub fn list_compatible_images(&self) -> fluent_builders::ListCompatibleImages<C, M, R> {
        fluent_builders::ListCompatibleImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobs`](crate::client::fluent_builders::ListJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobs::set_max_results): <p>The number of <code>JobListEntry</code> objects to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobs::set_next_token): <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
    /// - On success, responds with [`ListJobsOutput`](crate::output::ListJobsOutput) with field(s):
    ///   - [`job_list_entries(Option<Vec<JobListEntry>>)`](crate::output::ListJobsOutput::job_list_entries): <p>Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of export jobs. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListJobsOutput::next_token): <p>HTTP requests are stateless. If you use this automatically generated <code>NextToken</code> value in your next <code>ListJobs</code> call, your returned <code>JobListEntry</code> objects will start from this point in the array.</p>
    /// - On failure, responds with [`SdkError<ListJobsError>`](crate::error::ListJobsError)
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLongTermPricing`](crate::client::fluent_builders::ListLongTermPricing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLongTermPricing::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLongTermPricing::set_max_results): <p>The maximum number of <code>ListLongTermPricing</code> objects to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLongTermPricing::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLongTermPricing::set_next_token): <p>Because HTTP requests are stateless, this is the starting point for your next list of <code>ListLongTermPricing</code> to return.</p>
    /// - On success, responds with [`ListLongTermPricingOutput`](crate::output::ListLongTermPricingOutput) with field(s):
    ///   - [`long_term_pricing_entries(Option<Vec<LongTermPricingListEntry>>)`](crate::output::ListLongTermPricingOutput::long_term_pricing_entries): <p>Each <code>LongTermPricingEntry</code> object contains a status, ID, and other information about the <code>LongTermPricing</code> type. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLongTermPricingOutput::next_token): <p>Because HTTP requests are stateless, this is the starting point for your next list of returned <code>ListLongTermPricing</code> list.</p>
    /// - On failure, responds with [`SdkError<ListLongTermPricingError>`](crate::error::ListLongTermPricingError)
    pub fn list_long_term_pricing(&self) -> fluent_builders::ListLongTermPricing<C, M, R> {
        fluent_builders::ListLongTermPricing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCluster`](crate::client::fluent_builders::UpdateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::cluster_id) / [`set_cluster_id(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_cluster_id): <p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_role_arn): <p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_description): <p>The updated description of this cluster.</p>
    ///   - [`resources(JobResource)`](crate::client::fluent_builders::UpdateCluster::resources) / [`set_resources(Option<JobResource>)`](crate::client::fluent_builders::UpdateCluster::set_resources): <p>The updated arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
    ///   - [`on_device_service_configuration(OnDeviceServiceConfiguration)`](crate::client::fluent_builders::UpdateCluster::on_device_service_configuration) / [`set_on_device_service_configuration(Option<OnDeviceServiceConfiguration>)`](crate::client::fluent_builders::UpdateCluster::set_on_device_service_configuration): <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
    ///   - [`address_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::address_id) / [`set_address_id(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_address_id): <p>The ID of the updated <code>Address</code> object.</p>
    ///   - [`shipping_option(ShippingOption)`](crate::client::fluent_builders::UpdateCluster::shipping_option) / [`set_shipping_option(Option<ShippingOption>)`](crate::client::fluent_builders::UpdateCluster::set_shipping_option): <p>The updated shipping option value of this cluster's <code>ShippingDetails</code> object.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::UpdateCluster::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::UpdateCluster::set_notification): <p>The new or updated <code>Notification</code> object.</p>
    ///   - [`forwarding_address_id(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::forwarding_address_id) / [`set_forwarding_address_id(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_forwarding_address_id): <p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>
    /// - On success, responds with [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)

    /// - On failure, responds with [`SdkError<UpdateClusterError>`](crate::error::UpdateClusterError)
    pub fn update_cluster(&self) -> fluent_builders::UpdateCluster<C, M, R> {
        fluent_builders::UpdateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateJob`](crate::client::fluent_builders::UpdateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_job_id): <p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_role_arn): <p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>Identity and Access Management (IAM) API action.</p>
    ///   - [`notification(Notification)`](crate::client::fluent_builders::UpdateJob::notification) / [`set_notification(Option<Notification>)`](crate::client::fluent_builders::UpdateJob::set_notification): <p>The new or updated <code>Notification</code> object.</p>
    ///   - [`resources(JobResource)`](crate::client::fluent_builders::UpdateJob::resources) / [`set_resources(Option<JobResource>)`](crate::client::fluent_builders::UpdateJob::set_resources): <p>The updated <code>JobResource</code> object, or the updated <code>JobResource</code> object. </p>
    ///   - [`on_device_service_configuration(OnDeviceServiceConfiguration)`](crate::client::fluent_builders::UpdateJob::on_device_service_configuration) / [`set_on_device_service_configuration(Option<OnDeviceServiceConfiguration>)`](crate::client::fluent_builders::UpdateJob::set_on_device_service_configuration): <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
    ///   - [`address_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::address_id) / [`set_address_id(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_address_id): <p>The ID of the updated <code>Address</code> object.</p>
    ///   - [`shipping_option(ShippingOption)`](crate::client::fluent_builders::UpdateJob::shipping_option) / [`set_shipping_option(Option<ShippingOption>)`](crate::client::fluent_builders::UpdateJob::set_shipping_option): <p>The updated shipping option value of this job's <code>ShippingDetails</code> object.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_description): <p>The updated description of this job's <code>JobMetadata</code> object.</p>
    ///   - [`snowball_capacity_preference(SnowballCapacity)`](crate::client::fluent_builders::UpdateJob::snowball_capacity_preference) / [`set_snowball_capacity_preference(Option<SnowballCapacity>)`](crate::client::fluent_builders::UpdateJob::set_snowball_capacity_preference): <p>The updated <code>SnowballCapacityPreference</code> of this job's <code>JobMetadata</code> object. The 50 TB Snowballs are only available in the US regions.</p>  <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
    ///   - [`forwarding_address_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJob::forwarding_address_id) / [`set_forwarding_address_id(Option<String>)`](crate::client::fluent_builders::UpdateJob::set_forwarding_address_id): <p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>
    /// - On success, responds with [`UpdateJobOutput`](crate::output::UpdateJobOutput)

    /// - On failure, responds with [`SdkError<UpdateJobError>`](crate::error::UpdateJobError)
    pub fn update_job(&self) -> fluent_builders::UpdateJob<C, M, R> {
        fluent_builders::UpdateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateJobShipmentState`](crate::client::fluent_builders::UpdateJobShipmentState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJobShipmentState::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::UpdateJobShipmentState::set_job_id): <p>The job ID of the job whose shipment date you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
    ///   - [`shipment_state(ShipmentState)`](crate::client::fluent_builders::UpdateJobShipmentState::shipment_state) / [`set_shipment_state(Option<ShipmentState>)`](crate::client::fluent_builders::UpdateJobShipmentState::set_shipment_state): <p>The state of a device when it is being shipped. </p>  <p>Set to <code>RECEIVED</code> when the device arrives at your location.</p>  <p>Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.</p>
    /// - On success, responds with [`UpdateJobShipmentStateOutput`](crate::output::UpdateJobShipmentStateOutput)

    /// - On failure, responds with [`SdkError<UpdateJobShipmentStateError>`](crate::error::UpdateJobShipmentStateError)
    pub fn update_job_shipment_state(&self) -> fluent_builders::UpdateJobShipmentState<C, M, R> {
        fluent_builders::UpdateJobShipmentState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLongTermPricing`](crate::client::fluent_builders::UpdateLongTermPricing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`long_term_pricing_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLongTermPricing::long_term_pricing_id) / [`set_long_term_pricing_id(Option<String>)`](crate::client::fluent_builders::UpdateLongTermPricing::set_long_term_pricing_id): <p>The ID of the long-term pricing type for the device.</p>
    ///   - [`replacement_job(impl Into<String>)`](crate::client::fluent_builders::UpdateLongTermPricing::replacement_job) / [`set_replacement_job(Option<String>)`](crate::client::fluent_builders::UpdateLongTermPricing::set_replacement_job): <p>Specifies that a device that is ordered with long-term pricing should be replaced with a new device.</p>
    ///   - [`is_long_term_pricing_auto_renew(bool)`](crate::client::fluent_builders::UpdateLongTermPricing::is_long_term_pricing_auto_renew) / [`set_is_long_term_pricing_auto_renew(Option<bool>)`](crate::client::fluent_builders::UpdateLongTermPricing::set_is_long_term_pricing_auto_renew): <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
    /// - On success, responds with [`UpdateLongTermPricingOutput`](crate::output::UpdateLongTermPricingOutput)

    /// - On failure, responds with [`SdkError<UpdateLongTermPricingError>`](crate::error::UpdateLongTermPricingError)
    pub fn update_long_term_pricing(&self) -> fluent_builders::UpdateLongTermPricing<C, M, R> {
        fluent_builders::UpdateLongTermPricing::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelCluster`.
    ///
    /// <p>Cancels a cluster job. You can only cancel a cluster job while it's in the <code>AwaitingQuorum</code> status. You'll have at least an hour after creating a cluster job to cancel it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_cluster_input::Builder,
    }
    impl<C, M, R> CancelCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelClusterInputOperationOutputAlias,
                crate::output::CancelClusterOutput,
                crate::error::CancelClusterError,
                crate::input::CancelClusterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// <p>Cancels the specified job. You can only cancel a job before its <code>JobState</code> value changes to <code>PreparingAppliance</code>. Requesting the <code>ListJobs</code> or <code>DescribeJob</code> action returns a job's <code>JobState</code> as part of the response element data returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl<C, M, R> CancelJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobInputOperationOutputAlias,
                crate::output::CancelJobOutput,
                crate::error::CancelJobError,
                crate::input::CancelJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAddress`.
    ///
    /// <p>Creates an address for a Snow device to be shipped to. In most regions, addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. If the address is invalid or unsupported, then an exception is thrown.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_address_input::Builder,
    }
    impl<C, M, R> CreateAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAddressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAddressInputOperationOutputAlias,
                crate::output::CreateAddressOutput,
                crate::error::CreateAddressError,
                crate::input::CreateAddressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address that you want the Snow device shipped to.</p>
        pub fn address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.address(input);
            self
        }
        /// <p>The address that you want the Snow device shipped to.</p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates an empty cluster. Each cluster supports five nodes. You use the <code>CreateJob</code> action separately to create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl<C, M, R> CreateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterInputOperationOutputAlias,
                crate::output::CreateClusterOutput,
                crate::error::CreateClusterError,
                crate::input::CreateClusterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.inner = self.inner.job_type(input);
            self
        }
        /// <p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// <p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language. </p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// <p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda functions written in the Python language. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.inner = self.inner.on_device_service_configuration(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_on_device_service_configuration(input);
            self
        }
        /// <p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID for the address that you want the cluster shipped to.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_id(input.into());
            self
        }
        /// <p>The ID for the address that you want the cluster shipped to.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address_id(input);
            self
        }
        /// <p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS). </p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(input.into());
            self
        }
        /// <p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key Management Service (KMS). </p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for this cluster. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.inner = self.inner.snowball_type(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for this cluster. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.inner = self.inner.set_snowball_type(input);
            self
        }
        /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.inner = self.inner.shipping_option(input);
            self
        }
        /// <p>The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.inner = self.inner.set_shipping_option(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forwarding_address_id(input.into());
            self
        }
        /// <p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forwarding_address_id(input);
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn tax_documents(mut self, input: crate::model::TaxDocuments) -> Self {
            self.inner = self.inner.tax_documents(input);
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn set_tax_documents(
            mut self,
            input: std::option::Option<crate::model::TaxDocuments>,
        ) -> Self {
            self.inner = self.inner.set_tax_documents(input);
            self
        }
        /// <p>Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn remote_management(mut self, input: crate::model::RemoteManagement) -> Self {
            self.inner = self.inner.remote_management(input);
            self
        }
        /// <p>Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn set_remote_management(
            mut self,
            input: std::option::Option<crate::model::RemoteManagement>,
        ) -> Self {
            self.inner = self.inner.set_remote_management(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>Creates a job to import or export data between Amazon S3 and your on-premises data center. Your Amazon Web Services account must have the right trust policies and permissions in place to create a job for a Snow device. If you're creating a job for a node in a cluster, you only need to provide the <code>clusterId</code> value; the other job attributes are inherited from the cluster. </p> <note>
    /// <p>Only the Snowball; Edge device type is supported when ordering clustered jobs.</p>
    /// <p>The device capacity is optional.</p>
    /// <p>Availability of device types differ by Amazon Web Services Region. For more information about Region availability, see <a href="https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&amp;loc=4">Amazon Web Services Regional Services</a>.</p>
    /// </note>
    /// <p></p>
    /// <p class="title"> <b>Snow Family Devices and their capacities.</b> </p>
    /// <ul>
    /// <li> <p>Snow Family device type: <b>SNC1_SSD</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T14</p> </li>
    /// <li> <p>Description: Snowcone </p> </li>
    /// </ul> <p></p> </li>
    /// <li> <p>Snow Family device type: <b>SNC1_HDD</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T8</p> </li>
    /// <li> <p>Description: Snowcone </p> </li>
    /// </ul> <p></p> </li>
    /// <li> <p>Device type: <b>EDGE_S</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T98</p> </li>
    /// <li> <p>Description: Snowball Edge Storage Optimized for data transfer only </p> </li>
    /// </ul> <p></p> </li>
    /// <li> <p>Device type: <b>EDGE_CG</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T42</p> </li>
    /// <li> <p>Description: Snowball Edge Compute Optimized with GPU</p> </li>
    /// </ul> <p></p> </li>
    /// <li> <p>Device type: <b>EDGE_C</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T42</p> </li>
    /// <li> <p>Description: Snowball Edge Compute Optimized without GPU</p> </li>
    /// </ul> <p></p> </li>
    /// <li> <p>Device type: <b>EDGE</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T100</p> </li>
    /// <li> <p>Description: Snowball Edge Storage Optimized with EC2 Compute</p> </li>
    /// </ul> <p></p> </li>
    /// <li> <p>Device type: <b>STANDARD</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T50</p> </li>
    /// <li> <p>Description: Original Snowball device</p> <note>
    /// <p>This device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region </p>
    /// </note> </li>
    /// </ul> <p></p> </li>
    /// <li> <p>Device type: <b>STANDARD</b> </p>
    /// <ul>
    /// <li> <p>Capacity: T80</p> </li>
    /// <li> <p>Description: Original Snowball device</p> <note>
    /// <p>This device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region. </p>
    /// </note> </li>
    /// </ul> <p></p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Defines the type of job that you're creating. </p>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.inner = self.inner.job_type(input);
            self
        }
        /// <p>Defines the type of job that you're creating. </p>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// <p>Defines the Amazon S3 buckets associated with this job.</p>
        /// <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p>
        /// <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// <p>Defines the Amazon S3 buckets associated with this job.</p>
        /// <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p>
        /// <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.inner = self.inner.on_device_service_configuration(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_on_device_service_configuration(input);
            self
        }
        /// <p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ID for the address that you want the Snow device shipped to.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_id(input.into());
            self
        }
        /// <p>The ID for the address that you want the Snow device shipped to.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address_id(input);
            self
        }
        /// <p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management Service (KMS) API action.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(input.into());
            self
        }
        /// <p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> Key Management Service (KMS) API action.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access Management (IAM) API action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> Identity and Access Management (IAM) API action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_capacity_preference(
            mut self,
            input: crate::model::SnowballCapacity,
        ) -> Self {
            self.inner = self.inner.snowball_capacity_preference(input);
            self
        }
        /// <p>If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_capacity_preference(
            mut self,
            input: std::option::Option<crate::model::SnowballCapacity>,
        ) -> Self {
            self.inner = self.inner.set_snowball_capacity_preference(input);
            self
        }
        /// <p>The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.inner = self.inner.shipping_option(input);
            self
        }
        /// <p>The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        /// <ul>
        /// <li> <p>In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.</p> </li>
        /// <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li>
        /// <li> <p>In India, Snow devices are delivered in one to seven days.</p> </li>
        /// <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li>
        /// </ul>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.inner = self.inner.set_shipping_option(input);
            self
        }
        /// <p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for this job. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.inner = self.inner.snowball_type(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for this job. </p> <note>
        /// <p>For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.</p>
        /// </note>
        /// <p>The type of Amazon Web Services Snow device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.inner = self.inner.set_snowball_type(input);
            self
        }
        /// <p>The forwarding address ID for a job. This field is not supported in most Regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forwarding_address_id(input.into());
            self
        }
        /// <p>The forwarding address ID for a job. This field is not supported in most Regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forwarding_address_id(input);
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn tax_documents(mut self, input: crate::model::TaxDocuments) -> Self {
            self.inner = self.inner.tax_documents(input);
            self
        }
        /// <p>The tax documents required in your Amazon Web Services Region.</p>
        pub fn set_tax_documents(
            mut self,
            input: std::option::Option<crate::model::TaxDocuments>,
        ) -> Self {
            self.inner = self.inner.set_tax_documents(input);
            self
        }
        /// <p>Defines the device configuration for an Snowcone job.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn device_configuration(mut self, input: crate::model::DeviceConfiguration) -> Self {
            self.inner = self.inner.device_configuration(input);
            self
        }
        /// <p>Defines the device configuration for an Snowcone job.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_device_configuration(
            mut self,
            input: std::option::Option<crate::model::DeviceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_device_configuration(input);
            self
        }
        /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn remote_management(mut self, input: crate::model::RemoteManagement) -> Self {
            self.inner = self.inner.remote_management(input);
            self
        }
        /// <p>Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.</p>
        pub fn set_remote_management(
            mut self,
            input: std::option::Option<crate::model::RemoteManagement>,
        ) -> Self {
            self.inner = self.inner.set_remote_management(input);
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn long_term_pricing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.long_term_pricing_id(input.into());
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn set_long_term_pricing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_long_term_pricing_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLongTermPricing`.
    ///
    /// <p>Creates a job with the long-term usage option for a device. The long-term usage is a 1-year or 3-year long-term pricing type for the device. You are billed upfront, and Amazon Web Services provides discounts for long-term pricing. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLongTermPricing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_long_term_pricing_input::Builder,
    }
    impl<C, M, R> CreateLongTermPricing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLongTermPricing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLongTermPricingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLongTermPricingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLongTermPricingInputOperationOutputAlias,
                crate::output::CreateLongTermPricingOutput,
                crate::error::CreateLongTermPricingError,
                crate::input::CreateLongTermPricingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.</p>
        pub fn long_term_pricing_type(mut self, input: crate::model::LongTermPricingType) -> Self {
            self.inner = self.inner.long_term_pricing_type(input);
            self
        }
        /// <p>The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.</p>
        pub fn set_long_term_pricing_type(
            mut self,
            input: std::option::Option<crate::model::LongTermPricingType>,
        ) -> Self {
            self.inner = self.inner.set_long_term_pricing_type(input);
            self
        }
        /// <p>Specifies whether the current long-term pricing type for the device should be renewed.</p>
        pub fn is_long_term_pricing_auto_renew(mut self, input: bool) -> Self {
            self.inner = self.inner.is_long_term_pricing_auto_renew(input);
            self
        }
        /// <p>Specifies whether the current long-term pricing type for the device should be renewed.</p>
        pub fn set_is_long_term_pricing_auto_renew(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_is_long_term_pricing_auto_renew(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for the long-term pricing job.</p>
        pub fn snowball_type(mut self, input: crate::model::SnowballType) -> Self {
            self.inner = self.inner.snowball_type(input);
            self
        }
        /// <p>The type of Snow Family Devices to use for the long-term pricing job.</p>
        pub fn set_snowball_type(
            mut self,
            input: std::option::Option<crate::model::SnowballType>,
        ) -> Self {
            self.inner = self.inner.set_snowball_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReturnShippingLabel`.
    ///
    /// <p>Creates a shipping label that will be used to return the Snow device to Amazon Web Services.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReturnShippingLabel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_return_shipping_label_input::Builder,
    }
    impl<C, M, R> CreateReturnShippingLabel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReturnShippingLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReturnShippingLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReturnShippingLabelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReturnShippingLabelInputOperationOutputAlias,
                crate::output::CreateReturnShippingLabelOutput,
                crate::error::CreateReturnShippingLabelError,
                crate::input::CreateReturnShippingLabelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for a job that you want to create the return shipping label for; for example, <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for a job that you want to create the return shipping label for; for example, <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.inner = self.inner.shipping_option(input);
            self
        }
        /// <p>The shipping speed for a particular job. This speed doesn't dictate how soon the device is returned to Amazon Web Services. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.inner = self.inner.set_shipping_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAddress`.
    ///
    /// <p>Takes an <code>AddressId</code> and returns specific details about that address in the form of an <code>Address</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_address_input::Builder,
    }
    impl<C, M, R> DescribeAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAddressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAddressInputOperationOutputAlias,
                crate::output::DescribeAddressOutput,
                crate::error::DescribeAddressError,
                crate::input::DescribeAddressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The automatically generated ID for a specific address.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_id(input.into());
            self
        }
        /// <p>The automatically generated ID for a specific address.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAddresses`.
    ///
    /// <p>Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return addresses from the list of all addresses associated with this account in all US regions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAddresses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_addresses_input::Builder,
    }
    impl<C, M, R> DescribeAddresses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAddresses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAddressesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAddressesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAddressesInputOperationOutputAlias,
                crate::output::DescribeAddressesOutput,
                crate::error::DescribeAddressesError,
                crate::input::DescribeAddressesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAddressesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAddressesPaginator<C, M, R> {
            crate::paginator::DescribeAddressesPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of <code>ADDRESS</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of <code>ADDRESS</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCluster`.
    ///
    /// <p>Returns information about a specific cluster including shipping information, cluster status, and other important metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_input::Builder,
    }
    impl<C, M, R> DescribeCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterInputOperationOutputAlias,
                crate::output::DescribeClusterOutput,
                crate::error::DescribeClusterError,
                crate::input::DescribeClusterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The automatically generated ID for a cluster.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The automatically generated ID for a cluster.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJob`.
    ///
    /// <p>Returns information about a specific job including shipping information, job status, and other important metadata. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_input::Builder,
    }
    impl<C, M, R> DescribeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobInputOperationOutputAlias,
                crate::output::DescribeJobOutput,
                crate::error::DescribeJobError,
                crate::input::DescribeJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReturnShippingLabel`.
    ///
    /// <p>Information on the shipping label of a Snow device that is being returned to Amazon Web Services.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReturnShippingLabel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_return_shipping_label_input::Builder,
    }
    impl<C, M, R> DescribeReturnShippingLabel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReturnShippingLabel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReturnShippingLabelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReturnShippingLabelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReturnShippingLabelInputOperationOutputAlias,
                crate::output::DescribeReturnShippingLabelOutput,
                crate::error::DescribeReturnShippingLabelError,
                crate::input::DescribeReturnShippingLabelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobManifest`.
    ///
    /// <p>Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value. You can access the manifest file for up to 60 minutes after this request has been made. To access the manifest file after 60 minutes have passed, you'll have to make another call to the <code>GetJobManifest</code> action.</p>
    /// <p>The manifest is an encrypted file that you can download after your job enters the <code>WithCustomer</code> status. The manifest is decrypted by using the <code>UnlockCode</code> code value, when you pass both values to the Snow device through the Snowball client when the client is started for the first time.</p>
    /// <p>As a best practice, we recommend that you don't save a copy of an <code>UnlockCode</code> value in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.</p>
    /// <p>The credentials of a given job, including its manifest file and unlock code, expire 360 days after the job is created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJobManifest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_manifest_input::Builder,
    }
    impl<C, M, R> GetJobManifest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobManifest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobManifestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobManifestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobManifestInputOperationOutputAlias,
                crate::output::GetJobManifestOutput,
                crate::error::GetJobManifestError,
                crate::input::GetJobManifestInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobUnlockCode`.
    ///
    /// <p>Returns the <code>UnlockCode</code> code value for the specified job. A particular <code>UnlockCode</code> value can be accessed for up to 360 days after the associated job has been created.</p>
    /// <p>The <code>UnlockCode</code> value is a 29-character code with 25 alphanumeric characters and 4 hyphens. This code is used to decrypt the manifest file when it is passed along with the manifest to the Snow device through the Snowball client when the client is started for the first time.</p>
    /// <p>As a best practice, we recommend that you don't save a copy of the <code>UnlockCode</code> in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJobUnlockCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_unlock_code_input::Builder,
    }
    impl<C, M, R> GetJobUnlockCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobUnlockCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobUnlockCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobUnlockCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobUnlockCodeInputOperationOutputAlias,
                crate::output::GetJobUnlockCodeOutput,
                crate::error::GetJobUnlockCodeError,
                crate::input::GetJobUnlockCodeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSnowballUsage`.
    ///
    /// <p>Returns information about the Snow Family service limit for your account, and also the number of Snow devices your account has in use.</p>
    /// <p>The default service limit for the number of Snow devices that you can have at one time is 1. If you want to increase your service limit, contact Amazon Web Services Support.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSnowballUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_snowball_usage_input::Builder,
    }
    impl<C, M, R> GetSnowballUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSnowballUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSnowballUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSnowballUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSnowballUsageInputOperationOutputAlias,
                crate::output::GetSnowballUsageOutput,
                crate::error::GetSnowballUsageError,
                crate::input::GetSnowballUsageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSoftwareUpdates`.
    ///
    /// <p>Returns an Amazon S3 presigned URL for an update file associated with a specified <code>JobId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSoftwareUpdates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_software_updates_input::Builder,
    }
    impl<C, M, R> GetSoftwareUpdates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSoftwareUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSoftwareUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSoftwareUpdatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSoftwareUpdatesInputOperationOutputAlias,
                crate::output::GetSoftwareUpdatesOutput,
                crate::error::GetSoftwareUpdatesError,
                crate::input::GetSoftwareUpdatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClusterJobs`.
    ///
    /// <p>Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code> object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClusterJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cluster_jobs_input::Builder,
    }
    impl<C, M, R> ListClusterJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListClusterJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClusterJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClusterJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListClusterJobsInputOperationOutputAlias,
                crate::output::ListClusterJobsOutput,
                crate::error::ListClusterJobsError,
                crate::input::ListClusterJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClusters`.
    ///
    /// <p>Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_clusters_input::Builder,
    }
    impl<C, M, R> ListClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListClustersInputOperationOutputAlias,
                crate::output::ListClustersOutput,
                crate::error::ListClustersError,
                crate::input::ListClustersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of <code>ClusterListEntry</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of <code>ClusterListEntry</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCompatibleImages`.
    ///
    /// <p>This action returns a list of the different Amazon EC2 Amazon Machine Images (AMIs) that are owned by your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are based on the CentOS 7 (x86_64) - with Updates HVM, Ubuntu Server 14.04 LTS (HVM), and Ubuntu 16.04 LTS - Xenial (HVM) images, available on the Amazon Web Services Marketplace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCompatibleImages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_compatible_images_input::Builder,
    }
    impl<C, M, R> ListCompatibleImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCompatibleImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCompatibleImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCompatibleImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCompatibleImagesInputOperationOutputAlias,
                crate::output::ListCompatibleImagesOutput,
                crate::error::ListCompatibleImagesError,
                crate::input::ListCompatibleImagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code> object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs associated with this account in all US regions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsPaginator<C, M, R> {
            crate::paginator::ListJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of <code>JobListEntry</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLongTermPricing`.
    ///
    /// <p>Lists all long-term pricing types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLongTermPricing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_long_term_pricing_input::Builder,
    }
    impl<C, M, R> ListLongTermPricing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLongTermPricing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLongTermPricingOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLongTermPricingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLongTermPricingInputOperationOutputAlias,
                crate::output::ListLongTermPricingOutput,
                crate::error::ListLongTermPricingError,
                crate::input::ListLongTermPricingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of <code>ListLongTermPricing</code> objects to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of <code>ListLongTermPricing</code> objects to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Because HTTP requests are stateless, this is the starting point for your next list of <code>ListLongTermPricing</code> to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Because HTTP requests are stateless, this is the starting point for your next list of <code>ListLongTermPricing</code> to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCluster`.
    ///
    /// <p>While a cluster's <code>ClusterState</code> value is in the <code>AwaitingQuorum</code> state, you can update some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60 minutes after the cluster being created, this action is no longer available.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cluster_input::Builder,
    }
    impl<C, M, R> UpdateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClusterInputOperationOutputAlias,
                crate::output::UpdateClusterOutput,
                crate::error::UpdateClusterError,
                crate::input::UpdateClusterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_id(input.into());
            self
        }
        /// <p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_cluster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_id(input);
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in Identity and Access Management (IAM).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The updated description of this cluster.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated description of this cluster.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// <p>The updated arrays of <code>JobResource</code> objects that can include updated <code>S3Resource</code> objects or <code>LambdaResource</code> objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.inner = self.inner.on_device_service_configuration(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_on_device_service_configuration(input);
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_id(input.into());
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address_id(input);
            self
        }
        /// <p>The updated shipping option value of this cluster's <code>ShippingDetails</code> object.</p>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.inner = self.inner.shipping_option(input);
            self
        }
        /// <p>The updated shipping option value of this cluster's <code>ShippingDetails</code> object.</p>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.inner = self.inner.set_shipping_option(input);
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forwarding_address_id(input.into());
            self
        }
        /// <p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forwarding_address_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJob`.
    ///
    /// <p>While a job's <code>JobState</code> value is <code>New</code>, you can update some of the information associated with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created, this action is no longer available.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_job_input::Builder,
    }
    impl<C, M, R> UpdateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJobInputOperationOutputAlias,
                crate::output::UpdateJobOutput,
                crate::error::UpdateJobError,
                crate::input::UpdateJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>Identity and Access Management (IAM) API action.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>Identity and Access Management (IAM) API action.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn notification(mut self, input: crate::model::Notification) -> Self {
            self.inner = self.inner.notification(input);
            self
        }
        /// <p>The new or updated <code>Notification</code> object.</p>
        pub fn set_notification(
            mut self,
            input: std::option::Option<crate::model::Notification>,
        ) -> Self {
            self.inner = self.inner.set_notification(input);
            self
        }
        /// <p>The updated <code>JobResource</code> object, or the updated <code>JobResource</code> object. </p>
        pub fn resources(mut self, input: crate::model::JobResource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// <p>The updated <code>JobResource</code> object, or the updated <code>JobResource</code> object. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::JobResource>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn on_device_service_configuration(
            mut self,
            input: crate::model::OnDeviceServiceConfiguration,
        ) -> Self {
            self.inner = self.inner.on_device_service_configuration(input);
            self
        }
        /// <p>Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.</p>
        pub fn set_on_device_service_configuration(
            mut self,
            input: std::option::Option<crate::model::OnDeviceServiceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_on_device_service_configuration(input);
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_id(input.into());
            self
        }
        /// <p>The ID of the updated <code>Address</code> object.</p>
        pub fn set_address_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address_id(input);
            self
        }
        /// <p>The updated shipping option value of this job's <code>ShippingDetails</code> object.</p>
        pub fn shipping_option(mut self, input: crate::model::ShippingOption) -> Self {
            self.inner = self.inner.shipping_option(input);
            self
        }
        /// <p>The updated shipping option value of this job's <code>ShippingDetails</code> object.</p>
        pub fn set_shipping_option(
            mut self,
            input: std::option::Option<crate::model::ShippingOption>,
        ) -> Self {
            self.inner = self.inner.set_shipping_option(input);
            self
        }
        /// <p>The updated description of this job's <code>JobMetadata</code> object.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated description of this job's <code>JobMetadata</code> object.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The updated <code>SnowballCapacityPreference</code> of this job's <code>JobMetadata</code> object. The 50 TB Snowballs are only available in the US regions.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn snowball_capacity_preference(
            mut self,
            input: crate::model::SnowballCapacity,
        ) -> Self {
            self.inner = self.inner.snowball_capacity_preference(input);
            self
        }
        /// <p>The updated <code>SnowballCapacityPreference</code> of this job's <code>JobMetadata</code> object. The 50 TB Snowballs are only available in the US regions.</p>
        /// <p>For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i>.</p>
        pub fn set_snowball_capacity_preference(
            mut self,
            input: std::option::Option<crate::model::SnowballCapacity>,
        ) -> Self {
            self.inner = self.inner.set_snowball_capacity_preference(input);
            self
        }
        /// <p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>
        pub fn forwarding_address_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.forwarding_address_id(input.into());
            self
        }
        /// <p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>
        pub fn set_forwarding_address_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_forwarding_address_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJobShipmentState`.
    ///
    /// <p>Updates the state when a shipment state changes to a different state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateJobShipmentState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_job_shipment_state_input::Builder,
    }
    impl<C, M, R> UpdateJobShipmentState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJobShipmentState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobShipmentStateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobShipmentStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJobShipmentStateInputOperationOutputAlias,
                crate::output::UpdateJobShipmentStateOutput,
                crate::error::UpdateJobShipmentStateError,
                crate::input::UpdateJobShipmentStateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job ID of the job whose shipment date you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job ID of the job whose shipment date you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The state of a device when it is being shipped. </p>
        /// <p>Set to <code>RECEIVED</code> when the device arrives at your location.</p>
        /// <p>Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.</p>
        pub fn shipment_state(mut self, input: crate::model::ShipmentState) -> Self {
            self.inner = self.inner.shipment_state(input);
            self
        }
        /// <p>The state of a device when it is being shipped. </p>
        /// <p>Set to <code>RECEIVED</code> when the device arrives at your location.</p>
        /// <p>Set to <code>RETURNED</code> when you have returned the device to Amazon Web Services.</p>
        pub fn set_shipment_state(
            mut self,
            input: std::option::Option<crate::model::ShipmentState>,
        ) -> Self {
            self.inner = self.inner.set_shipment_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLongTermPricing`.
    ///
    /// <p>Updates the long-term pricing type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLongTermPricing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_long_term_pricing_input::Builder,
    }
    impl<C, M, R> UpdateLongTermPricing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLongTermPricing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLongTermPricingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLongTermPricingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLongTermPricingInputOperationOutputAlias,
                crate::output::UpdateLongTermPricingOutput,
                crate::error::UpdateLongTermPricingError,
                crate::input::UpdateLongTermPricingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn long_term_pricing_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.long_term_pricing_id(input.into());
            self
        }
        /// <p>The ID of the long-term pricing type for the device.</p>
        pub fn set_long_term_pricing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_long_term_pricing_id(input);
            self
        }
        /// <p>Specifies that a device that is ordered with long-term pricing should be replaced with a new device.</p>
        pub fn replacement_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replacement_job(input.into());
            self
        }
        /// <p>Specifies that a device that is ordered with long-term pricing should be replaced with a new device.</p>
        pub fn set_replacement_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replacement_job(input);
            self
        }
        /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
        pub fn is_long_term_pricing_auto_renew(mut self, input: bool) -> Self {
            self.inner = self.inner.is_long_term_pricing_auto_renew(input);
            self
        }
        /// <p>If set to <code>true</code>, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.</p>
        pub fn set_is_long_term_pricing_auto_renew(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_is_long_term_pricing_auto_renew(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
