// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelClusterOutput, crate::error::CancelClusterError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::CancelClusterError {
            meta: generic,
            kind: crate::error::CancelClusterErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::CancelClusterError {
            meta: generic,
            kind: crate::error::CancelClusterErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSRequestFailedException" => crate::error::CancelClusterError {
            meta: generic,
            kind: crate::error::CancelClusterErrorKind::KmsRequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelClusterOutput, crate::error::CancelClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_cluster_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelJobOutput, crate::error::CancelJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::CancelJobError {
            meta: generic,
            kind: crate::error::CancelJobErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::CancelJobError {
            meta: generic,
            kind: crate::error::CancelJobErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSRequestFailedException" => crate::error::CancelJobError {
            meta: generic,
            kind: crate::error::CancelJobErrorKind::KmsRequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CancelJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelJobOutput, crate::error::CancelJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_address_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAddressOutput, crate::error::CreateAddressError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAddressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAddressError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidAddressException" => crate::error::CreateAddressError {
            meta: generic,
            kind: crate::error::CreateAddressErrorKind::InvalidAddressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_address_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_address_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAddressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAddressException" => crate::error::CreateAddressError {
            meta: generic,
            kind: crate::error::CreateAddressErrorKind::UnsupportedAddressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_address_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_address_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAddressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAddressError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_address_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAddressOutput, crate::error::CreateAddressError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_address_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_address(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAddressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "Ec2RequestFailedException" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::Ec2RequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputCombinationException" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidInputCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_input_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_combination_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSRequestFailedException" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::KmsRequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cluster_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterLimitExceededException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::ClusterLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Ec2RequestFailedException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::Ec2RequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputCombinationException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::InvalidInputCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_input_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_combination_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSRequestFailedException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::KmsRequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_long_term_pricing_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLongTermPricingOutput,
    crate::error::CreateLongTermPricingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLongTermPricingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLongTermPricingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceException" => crate::error::CreateLongTermPricingError {
            meta: generic,
            kind: crate::error::CreateLongTermPricingErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLongTermPricingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLongTermPricingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_long_term_pricing_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLongTermPricingOutput,
    crate::error::CreateLongTermPricingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_long_term_pricing_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_long_term_pricing(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLongTermPricingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_return_shipping_label_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReturnShippingLabelOutput,
    crate::error::CreateReturnShippingLabelError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateReturnShippingLabelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateReturnShippingLabelError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => crate::error::CreateReturnShippingLabelError { meta: generic, kind: crate::error::CreateReturnShippingLabelErrorKind::ConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReturnShippingLabelError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputCombinationException" => crate::error::CreateReturnShippingLabelError { meta: generic, kind: crate::error::CreateReturnShippingLabelErrorKind::InvalidInputCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_combination_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReturnShippingLabelError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidJobStateException" => crate::error::CreateReturnShippingLabelError { meta: generic, kind: crate::error::CreateReturnShippingLabelErrorKind::InvalidJobStateException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReturnShippingLabelError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidResourceException" => crate::error::CreateReturnShippingLabelError { meta: generic, kind: crate::error::CreateReturnShippingLabelErrorKind::InvalidResourceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReturnShippingLabelError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReturnShippingLabelAlreadyExistsException" => crate::error::CreateReturnShippingLabelError { meta: generic, kind: crate::error::CreateReturnShippingLabelErrorKind::ReturnShippingLabelAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::return_shipping_label_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_return_shipping_label_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateReturnShippingLabelError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateReturnShippingLabelError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_return_shipping_label_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateReturnShippingLabelOutput,
    crate::error::CreateReturnShippingLabelError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_return_shipping_label_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_return_shipping_label(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateReturnShippingLabelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_address_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAddressOutput, crate::error::DescribeAddressError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAddressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAddressError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceException" => crate::error::DescribeAddressError {
            meta: generic,
            kind: crate::error::DescribeAddressErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAddressError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAddressError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_address_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAddressOutput, crate::error::DescribeAddressError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_address_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_address(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAddressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_addresses_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAddressesOutput, crate::error::DescribeAddressesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAddressesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAddressesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::DescribeAddressesError {
            meta: generic,
            kind: crate::error::DescribeAddressesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAddressesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::DescribeAddressesError {
            meta: generic,
            kind: crate::error::DescribeAddressesErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAddressesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAddressesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_addresses_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAddressesOutput, crate::error::DescribeAddressesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_addresses_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_addresses(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAddressesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeClusterOutput, crate::error::DescribeClusterError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceException" => crate::error::DescribeClusterError {
            meta: generic,
            kind: crate::error::DescribeClusterErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeClusterOutput, crate::error::DescribeClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_job_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_return_shipping_label_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReturnShippingLabelOutput,
    crate::error::DescribeReturnShippingLabelError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReturnShippingLabelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReturnShippingLabelError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConflictException" => {
            crate::error::DescribeReturnShippingLabelError {
                meta: generic,
                kind: crate::error::DescribeReturnShippingLabelErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReturnShippingLabelError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidJobStateException" => crate::error::DescribeReturnShippingLabelError {
            meta: generic,
            kind: crate::error::DescribeReturnShippingLabelErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReturnShippingLabelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::DescribeReturnShippingLabelError {
            meta: generic,
            kind: crate::error::DescribeReturnShippingLabelErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeReturnShippingLabelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReturnShippingLabelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_return_shipping_label_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReturnShippingLabelOutput,
    crate::error::DescribeReturnShippingLabelError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_return_shipping_label_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_return_shipping_label(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReturnShippingLabelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_manifest_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobManifestOutput, crate::error::GetJobManifestError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetJobManifestError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetJobManifestError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::GetJobManifestError {
            meta: generic,
            kind: crate::error::GetJobManifestErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobManifestError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::GetJobManifestError {
            meta: generic,
            kind: crate::error::GetJobManifestErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobManifestError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetJobManifestError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_manifest_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobManifestOutput, crate::error::GetJobManifestError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_job_manifest_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_job_manifest(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetJobManifestError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_unlock_code_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobUnlockCodeOutput, crate::error::GetJobUnlockCodeError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetJobUnlockCodeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetJobUnlockCodeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::GetJobUnlockCodeError {
            meta: generic,
            kind: crate::error::GetJobUnlockCodeErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobUnlockCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::GetJobUnlockCodeError {
            meta: generic,
            kind: crate::error::GetJobUnlockCodeErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetJobUnlockCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetJobUnlockCodeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_unlock_code_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobUnlockCodeOutput, crate::error::GetJobUnlockCodeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_job_unlock_code_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_job_unlock_code(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetJobUnlockCodeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_snowball_usage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSnowballUsageOutput, crate::error::GetSnowballUsageError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSnowballUsageError::unhandled)?;
    Err(crate::error::GetSnowballUsageError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_snowball_usage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSnowballUsageOutput, crate::error::GetSnowballUsageError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_snowball_usage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_snowball_usage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSnowballUsageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_software_updates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSoftwareUpdatesOutput,
    crate::error::GetSoftwareUpdatesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSoftwareUpdatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSoftwareUpdatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::GetSoftwareUpdatesError {
            meta: generic,
            kind: crate::error::GetSoftwareUpdatesErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSoftwareUpdatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::GetSoftwareUpdatesError {
            meta: generic,
            kind: crate::error::GetSoftwareUpdatesErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSoftwareUpdatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSoftwareUpdatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_software_updates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSoftwareUpdatesOutput,
    crate::error::GetSoftwareUpdatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_software_updates_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_software_updates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSoftwareUpdatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cluster_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListClusterJobsOutput, crate::error::ListClusterJobsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListClusterJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListClusterJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListClusterJobsError {
            meta: generic,
            kind: crate::error::ListClusterJobsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListClusterJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::ListClusterJobsError {
            meta: generic,
            kind: crate::error::ListClusterJobsErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListClusterJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListClusterJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cluster_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListClusterJobsOutput, crate::error::ListClusterJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_cluster_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_cluster_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListClusterJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_clusters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListClustersOutput, crate::error::ListClustersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListClustersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListClustersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListClustersError {
            meta: generic,
            kind: crate::error::ListClustersErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListClustersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_clusters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListClustersOutput, crate::error::ListClustersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_clusters_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_clusters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListClustersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_compatible_images_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCompatibleImagesOutput,
    crate::error::ListCompatibleImagesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCompatibleImagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListCompatibleImagesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "Ec2RequestFailedException" => crate::error::ListCompatibleImagesError {
            meta: generic,
            kind: crate::error::ListCompatibleImagesErrorKind::Ec2RequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCompatibleImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListCompatibleImagesError {
            meta: generic,
            kind: crate::error::ListCompatibleImagesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCompatibleImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListCompatibleImagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_compatible_images_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCompatibleImagesOutput,
    crate::error::ListCompatibleImagesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_compatible_images_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_compatible_images(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCompatibleImagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_jobs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_long_term_pricing_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLongTermPricingOutput,
    crate::error::ListLongTermPricingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLongTermPricingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLongTermPricingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::ListLongTermPricingError {
            meta: generic,
            kind: crate::error::ListLongTermPricingErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLongTermPricingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::ListLongTermPricingError {
            meta: generic,
            kind: crate::error::ListLongTermPricingErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLongTermPricingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLongTermPricingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_long_term_pricing_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLongTermPricingOutput,
    crate::error::ListLongTermPricingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_long_term_pricing_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_long_term_pricing(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLongTermPricingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateClusterOutput, crate::error::UpdateClusterError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "Ec2RequestFailedException" => crate::error::UpdateClusterError {
            meta: generic,
            kind: crate::error::UpdateClusterErrorKind::Ec2RequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputCombinationException" => crate::error::UpdateClusterError {
            meta: generic,
            kind: crate::error::UpdateClusterErrorKind::InvalidInputCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_input_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_combination_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidJobStateException" => crate::error::UpdateClusterError {
            meta: generic,
            kind: crate::error::UpdateClusterErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::UpdateClusterError {
            meta: generic,
            kind: crate::error::UpdateClusterErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSRequestFailedException" => crate::error::UpdateClusterError {
            meta: generic,
            kind: crate::error::UpdateClusterErrorKind::KmsRequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateClusterOutput, crate::error::UpdateClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_cluster_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobOutput, crate::error::UpdateJobError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterLimitExceededException" => crate::error::UpdateJobError {
            meta: generic,
            kind: crate::error::UpdateJobErrorKind::ClusterLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "Ec2RequestFailedException" => crate::error::UpdateJobError {
            meta: generic,
            kind: crate::error::UpdateJobErrorKind::Ec2RequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputCombinationException" => crate::error::UpdateJobError {
            meta: generic,
            kind: crate::error::UpdateJobErrorKind::InvalidInputCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_input_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_combination_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidJobStateException" => crate::error::UpdateJobError {
            meta: generic,
            kind: crate::error::UpdateJobErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::UpdateJobError {
            meta: generic,
            kind: crate::error::UpdateJobErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSRequestFailedException" => crate::error::UpdateJobError {
            meta: generic,
            kind: crate::error::UpdateJobErrorKind::KmsRequestFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_request_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_request_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobOutput, crate::error::UpdateJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_job_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_shipment_state_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateJobShipmentStateOutput,
    crate::error::UpdateJobShipmentStateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateJobShipmentStateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateJobShipmentStateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidJobStateException" => crate::error::UpdateJobShipmentStateError {
            meta: generic,
            kind: crate::error::UpdateJobShipmentStateErrorKind::InvalidJobStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_job_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_job_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobShipmentStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidResourceException" => crate::error::UpdateJobShipmentStateError {
            meta: generic,
            kind: crate::error::UpdateJobShipmentStateErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobShipmentStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateJobShipmentStateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_shipment_state_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateJobShipmentStateOutput,
    crate::error::UpdateJobShipmentStateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_job_shipment_state_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_long_term_pricing_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLongTermPricingOutput,
    crate::error::UpdateLongTermPricingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateLongTermPricingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateLongTermPricingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidResourceException" => crate::error::UpdateLongTermPricingError {
            meta: generic,
            kind: crate::error::UpdateLongTermPricingErrorKind::InvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateLongTermPricingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateLongTermPricingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_long_term_pricing_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLongTermPricingOutput,
    crate::error::UpdateLongTermPricingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_long_term_pricing_output::Builder::default();
        let _ = response;
        output.build()
    })
}
